import{s as $t,n as Zt,o as Bt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as kt,g as p,s as a,r as i,A as Nt,h as m,f as e,c as n,j as Ut,u as o,x as d,k as It,y as Gt,a as l,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.52fa569e.js";import{H as R,E as xt}from"../chunks/EditOnGithub.b65eee75.js";function Ct(Mt){let J,X,Y,A,g,F,j,dt='<strong>MnasNet</strong> is a type of convolutional neural network optimized for mobile devices that is discovered through mobile neural architecture search, which explicitly incorporates model latency into the main objective so that the search can identify a model that achieves a good trade-off between accuracy and latency. The main building block is an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual block</a> (from <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>).',z,w,H,y,Jt="To load a pretrained model:",S,T,L,u,gt="To load and preprocess the image:",D,b,P,f,jt="To get the model predictions:",q,U,K,I,wt="To get the top-5 predictions class names:",O,$,tt,Z,yt="Replace the model name with the variant you want to use, e.g. <code>mnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",st,B,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,lt,k,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,N,nt,G,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,x,mt,C,ft='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,v,ot,E,rt,Q,ct,_,ht;return g=new R({props:{title:"MnasNet",local:"mnasnet",headingTag:"h1"}}),w=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21uYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW5hc25ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltbmFzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNbmFzTmV0JTNBJTIwUGxhdGZvcm0tQXdhcmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glMjBmb3IlMjBNb2JpbGUlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMEJvJTIwQ2hlbiUyMGFuZCUyMFJ1b21pbmclMjBQYW5nJTIwYW5kJTIwVmlqYXklMjBWYXN1ZGV2YW4lMjBhbmQlMjBNYXJrJTIwU2FuZGxlciUyMGFuZCUyMEFuZHJldyUyMEhvd2FyZCUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODA3LjExNjI2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{tan2019mnasnet,
      title={MnasNet: Platform-Aware Neural Architecture Search for Mobile}, 
      author={Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Bo </span>Chen <span class="hljs-keyword">and </span>Ruoming Pang <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span>Mark Sandler <span class="hljs-keyword">and </span><span class="hljs-keyword">Andrew </span>Howard <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1807</span>.<span class="hljs-number">11626</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mnasnet.mdx"}}),{c(){J=p("meta"),X=a(),Y=p("p"),A=a(),i(g.$$.fragment),F=a(),j=p("p"),j.innerHTML=dt,z=a(),i(w.$$.fragment),H=a(),y=p("p"),y.textContent=Jt,S=a(),i(T.$$.fragment),L=a(),u=p("p"),u.textContent=gt,D=a(),i(b.$$.fragment),P=a(),f=p("p"),f.textContent=jt,q=a(),i(U.$$.fragment),K=a(),I=p("p"),I.textContent=wt,O=a(),i($.$$.fragment),tt=a(),Z=p("p"),Z.innerHTML=yt,st=a(),B=p("p"),B.innerHTML=Tt,et=a(),i(W.$$.fragment),lt=a(),k=p("p"),k.textContent=ut,at=a(),i(N.$$.fragment),nt=a(),G=p("p"),G.innerHTML=bt,pt=a(),i(x.$$.fragment),mt=a(),C=p("p"),C.innerHTML=ft,it=a(),i(v.$$.fragment),ot=a(),i(E.$$.fragment),rt=a(),i(Q.$$.fragment),ct=a(),_=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),Y=m(t,"P",{}),Ut(Y).forEach(e),A=n(t),o(g.$$.fragment,t),F=n(t),j=m(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1b8hcw9"&&(j.innerHTML=dt),z=n(t),o(w.$$.fragment,t),H=n(t),y=m(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-18ywhxh"&&(y.textContent=Jt),S=n(t),o(T.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1c2ipa8"&&(u.textContent=gt),D=n(t),o(b.$$.fragment,t),P=n(t),f=m(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-1n9qsq1"&&(f.textContent=jt),q=n(t),o(U.$$.fragment,t),K=n(t),I=m(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19cnvx1"&&(I.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1jw4zc0"&&(Z.innerHTML=yt),st=n(t),B=m(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1wmi3ea"&&(B.innerHTML=Tt),et=n(t),o(W.$$.fragment,t),lt=n(t),k=m(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-9sr7nh"&&(k.textContent=ut),at=n(t),o(N.$$.fragment,t),nt=n(t),G=m(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1kguc51"&&(G.innerHTML=bt),pt=n(t),o(x.$$.fragment,t),mt=n(t),C=m(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-xtxxu6"&&(C.innerHTML=ft),it=n(t),o(v.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ct=n(t),_=m(t,"P",{}),Ut(_).forEach(e),this.h()},h(){It(J,"name","hf:doc:metadata"),It(J,"content",vt)},m(t,s){Gt(document.head,J),l(t,X,s),l(t,Y,s),l(t,A,s),r(g,t,s),l(t,F,s),l(t,j,s),l(t,z,s),r(w,t,s),l(t,H,s),l(t,y,s),l(t,S,s),r(T,t,s),l(t,L,s),l(t,u,s),l(t,D,s),r(b,t,s),l(t,P,s),l(t,f,s),l(t,q,s),r(U,t,s),l(t,K,s),l(t,I,s),l(t,O,s),r($,t,s),l(t,tt,s),l(t,Z,s),l(t,st,s),l(t,B,s),l(t,et,s),r(W,t,s),l(t,lt,s),l(t,k,s),l(t,at,s),r(N,t,s),l(t,nt,s),l(t,G,s),l(t,pt,s),r(x,t,s),l(t,mt,s),l(t,C,s),l(t,it,s),r(v,t,s),l(t,ot,s),r(E,t,s),l(t,rt,s),r(Q,t,s),l(t,ct,s),l(t,_,s),ht=!0},p:Zt,i(t){ht||(c(g.$$.fragment,t),c(w.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(N.$$.fragment,t),c(x.$$.fragment,t),c(v.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),ht=!0)},o(t){h(g.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ht=!1},d(t){t&&(e(X),e(Y),e(A),e(F),e(j),e(z),e(H),e(y),e(S),e(L),e(u),e(D),e(P),e(f),e(q),e(K),e(I),e(O),e(tt),e(Z),e(st),e(B),e(et),e(lt),e(k),e(at),e(nt),e(G),e(pt),e(mt),e(C),e(it),e(ot),e(rt),e(ct),e(_)),e(J),M(g,t),M(w,t),M(T,t),M(b,t),M(U,t),M($,t),M(W,t),M(N,t),M(x,t),M(v,t),M(E,t),M(Q,t)}}}const vt='{"title":"MnasNet","local":"mnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Wt{constructor(J){super(),kt(this,J,Et,Ct,$t,{})}}export{Rt as component};
