import{s as at,o as lt,n as je}from"../chunks/scheduler.d6170356.js";import{S as nt,i as st,g as i,s,r as d,A as ot,h as p,f as a,c as o,j as et,u as f,x as c,k as tt,y as it,a as l,v as m,d as g,t as w,w as $}from"../chunks/index.fcd4cc08.js";import{T as Ue}from"../chunks/Tip.b09c67cf.js";import{C as pt}from"../chunks/CodeBlock.7b16bdef.js";import{H as Y}from"../chunks/Heading.8660bd0e.js";function rt(T){let n,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){n=i("p"),n.innerHTML=u},l(r){n=p(r,"P",{"data-svelte-h":!0}),c(n)!=="svelte-1nqltc0"&&(n.innerHTML=u)},m(r,h){l(r,n,h)},p:je,d(r){r&&a(n)}}}function ct(T){let n,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){n=i("p"),n.innerHTML=u},l(r){n=p(r,"P",{"data-svelte-h":!0}),c(n)!=="svelte-138wjpm"&&(n.innerHTML=u)},m(r,h){l(r,n,h)},p:je,d(r){r&&a(n)}}}function ut(T){let n,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){n=i("p"),n.innerHTML=u},l(r){n=p(r,"P",{"data-svelte-h":!0}),c(n)!=="svelte-9c51kn"&&(n.innerHTML=u)},m(r,h){l(r,n,h)},p:je,d(r){r&&a(n)}}}function ht(T){let n,u,r,h,_,V,M,xe='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',K,H,Ie='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',ee,v,te,y,ae,L,le,S,ke="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",ne,C,Je="Here’s an example of metadata for a Gradio Space:",se,U,oe,j,Ae='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',ie,x,Ge='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',pe,I,Pe='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',re,k,Ee="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",ce,J,ue,A,Re="The allowed redirect URIs for your OAuth app are:",he,G,Oe="<li><code>https://{SPACE_HOST}/auth/callback</code></li> <li><code>https://{SPACE_HOST}/login/callback</code></li>",de,P,Ne='Note that <code>SPACE_HOST</code> is also <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',fe,E,qe="You can add a custom relative redirect path by setting <code>hf_oauth_redirect_path</code> in your Space’s metadata.",me,R,ge,O,Fe="The following scopes are always included for Spaces:",we,N,ze="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",$e,q,Be="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",Te,F,We='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write access to the user’s personal repos. Does not grant read access on its own, you need to include <code>read-repos</code> as well.</li> <li><code>manage-repos</code>: Get access to a repo’s settings. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li>',ve,z,ye,B,Xe='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol. Gradio also provides <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">check out the associated guide</a>.',be,W,Ze="Basically, you need to:",_e,X,De="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",Me,b,He,Z,Le,D,Ye='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li>',Se,Q,Ce;return _=new Y({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),v=new Ue({props:{$$slots:{default:[rt]},$$scope:{ctx:T}}}),y=new Ue({props:{$$slots:{default:[ct]},$$scope:{ctx:T}}}),L=new Y({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),U=new pt({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQWhmX29hdXRoX3JlZGlyZWN0X3BhdGglM0ElMjAlMkZjdXN0b21fY2FsbGJhY2tfcm91dGUlMjAlMjMlMjBvcHRpb25hbCUyQyUyMHNlZSUyMCUyMlJlZGlyZWN0JTIwVVJMcyUyMiUyMGJlbG93JTBBaGZfb2F1dGhfc2NvcGVzJTNBJTIwJTIycmVhZC1yZXBvcyUyMHdyaXRlLXJlcG9zJTIwbWFuYWdlLXJlcG9zJTIwaW5mZXJlbmNlLWFwaSUyMiUyMCUyMyUyMG9wdGlvbmFsJTJDJTIwc2VlJTIwJTIyU2NvcGVzJTIyJTIwYmVsb3cuJTIwJTIyb3BlbmlkJTIwcHJvZmlsZSUyMiUyMGlzJTIwYWx3YXlzJTIwaW5jbHVkZWQu",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">hf_oauth_redirect_path:</span> <span class="hljs-string">/custom_callback_route</span> <span class="hljs-comment"># optional, see &quot;Redirect URLs&quot; below</span>
<span class="hljs-attr">hf_oauth_scopes:</span> <span class="hljs-string">&quot;read-repos write-repos manage-repos inference-api&quot;</span> <span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>`,wrap:!1}}),J=new Y({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),R=new Y({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),z=new Y({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),b=new Ue({props:{warning:!0,$$slots:{default:[ut]},$$scope:{ctx:T}}}),Z=new Y({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),{c(){n=i("meta"),u=s(),r=i("p"),h=s(),d(_.$$.fragment),V=s(),M=i("p"),M.innerHTML=xe,K=s(),H=i("p"),H.innerHTML=Ie,ee=s(),d(v.$$.fragment),te=s(),d(y.$$.fragment),ae=s(),d(L.$$.fragment),le=s(),S=i("p"),S.innerHTML=ke,ne=s(),C=i("p"),C.textContent=Je,se=s(),d(U.$$.fragment),oe=s(),j=i("p"),j.innerHTML=Ae,ie=s(),x=i("p"),x.innerHTML=Ge,pe=s(),I=i("ul"),I.innerHTML=Pe,re=s(),k=i("p"),k.innerHTML=Ee,ce=s(),d(J.$$.fragment),ue=s(),A=i("p"),A.textContent=Re,he=s(),G=i("ul"),G.innerHTML=Oe,de=s(),P=i("p"),P.innerHTML=Ne,fe=s(),E=i("p"),E.innerHTML=qe,me=s(),d(R.$$.fragment),ge=s(),O=i("p"),O.textContent=Fe,we=s(),N=i("ul"),N.innerHTML=ze,$e=s(),q=i("p"),q.innerHTML=Be,Te=s(),F=i("ul"),F.innerHTML=We,ve=s(),d(z.$$.fragment),ye=s(),B=i("p"),B.innerHTML=Xe,be=s(),W=i("p"),W.textContent=Ze,_e=s(),X=i("ul"),X.innerHTML=De,Me=s(),d(b.$$.fragment),He=s(),d(Z.$$.fragment),Le=s(),D=i("ul"),D.innerHTML=Ye,Se=s(),Q=i("p"),this.h()},l(e){const t=ot("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=o(e),r=p(e,"P",{}),et(r).forEach(a),h=o(e),f(_.$$.fragment,e),V=o(e),M=p(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-1nfjaew"&&(M.innerHTML=xe),K=o(e),H=p(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1t83yje"&&(H.innerHTML=Ie),ee=o(e),f(v.$$.fragment,e),te=o(e),f(y.$$.fragment,e),ae=o(e),f(L.$$.fragment,e),le=o(e),S=p(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1u00faw"&&(S.innerHTML=ke),ne=o(e),C=p(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-vlpqut"&&(C.textContent=Je),se=o(e),f(U.$$.fragment,e),oe=o(e),j=p(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-ml9rcy"&&(j.innerHTML=Ae),ie=o(e),x=p(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-12m1u10"&&(x.innerHTML=Ge),pe=o(e),I=p(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-k73zcv"&&(I.innerHTML=Pe),re=o(e),k=p(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-qqxlx3"&&(k.innerHTML=Ee),ce=o(e),f(J.$$.fragment,e),ue=o(e),A=p(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-jvpuh2"&&(A.textContent=Re),he=o(e),G=p(e,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-eg7dcn"&&(G.innerHTML=Oe),de=o(e),P=p(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-lo8fiy"&&(P.innerHTML=Ne),fe=o(e),E=p(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-vk1fk7"&&(E.innerHTML=qe),me=o(e),f(R.$$.fragment,e),ge=o(e),O=p(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-sd96qs"&&(O.textContent=Fe),we=o(e),N=p(e,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-3wn6r0"&&(N.innerHTML=ze),$e=o(e),q=p(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-181zoj"&&(q.innerHTML=Be),Te=o(e),F=p(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-34w51"&&(F.innerHTML=We),ve=o(e),f(z.$$.fragment,e),ye=o(e),B=p(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-olbs7n"&&(B.innerHTML=Xe),be=o(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-g0kxak"&&(W.textContent=Ze),_e=o(e),X=p(e,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-159xo4d"&&(X.innerHTML=De),Me=o(e),f(b.$$.fragment,e),He=o(e),f(Z.$$.fragment,e),Le=o(e),D=p(e,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-154zvxo"&&(D.innerHTML=Ye),Se=o(e),Q=p(e,"P",{}),et(Q).forEach(a),this.h()},h(){tt(n,"name","hf:doc:metadata"),tt(n,"content",dt)},m(e,t){it(document.head,n),l(e,u,t),l(e,r,t),l(e,h,t),m(_,e,t),l(e,V,t),l(e,M,t),l(e,K,t),l(e,H,t),l(e,ee,t),m(v,e,t),l(e,te,t),m(y,e,t),l(e,ae,t),m(L,e,t),l(e,le,t),l(e,S,t),l(e,ne,t),l(e,C,t),l(e,se,t),m(U,e,t),l(e,oe,t),l(e,j,t),l(e,ie,t),l(e,x,t),l(e,pe,t),l(e,I,t),l(e,re,t),l(e,k,t),l(e,ce,t),m(J,e,t),l(e,ue,t),l(e,A,t),l(e,he,t),l(e,G,t),l(e,de,t),l(e,P,t),l(e,fe,t),l(e,E,t),l(e,me,t),m(R,e,t),l(e,ge,t),l(e,O,t),l(e,we,t),l(e,N,t),l(e,$e,t),l(e,q,t),l(e,Te,t),l(e,F,t),l(e,ve,t),m(z,e,t),l(e,ye,t),l(e,B,t),l(e,be,t),l(e,W,t),l(e,_e,t),l(e,X,t),l(e,Me,t),m(b,e,t),l(e,He,t),m(Z,e,t),l(e,Le,t),l(e,D,t),l(e,Se,t),l(e,Q,t),Ce=!0},p(e,[t]){const Qe={};t&2&&(Qe.$$scope={dirty:t,ctx:e}),v.$set(Qe);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),y.$set(Ve);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),b.$set(Ke)},i(e){Ce||(g(_.$$.fragment,e),g(v.$$.fragment,e),g(y.$$.fragment,e),g(L.$$.fragment,e),g(U.$$.fragment,e),g(J.$$.fragment,e),g(R.$$.fragment,e),g(z.$$.fragment,e),g(b.$$.fragment,e),g(Z.$$.fragment,e),Ce=!0)},o(e){w(_.$$.fragment,e),w(v.$$.fragment,e),w(y.$$.fragment,e),w(L.$$.fragment,e),w(U.$$.fragment,e),w(J.$$.fragment,e),w(R.$$.fragment,e),w(z.$$.fragment,e),w(b.$$.fragment,e),w(Z.$$.fragment,e),Ce=!1},d(e){e&&(a(u),a(r),a(h),a(V),a(M),a(K),a(H),a(ee),a(te),a(ae),a(le),a(S),a(ne),a(C),a(se),a(oe),a(j),a(ie),a(x),a(pe),a(I),a(re),a(k),a(ce),a(ue),a(A),a(he),a(G),a(de),a(P),a(fe),a(E),a(me),a(ge),a(O),a(we),a(N),a($e),a(q),a(Te),a(F),a(ve),a(ye),a(B),a(be),a(W),a(_e),a(X),a(Me),a(He),a(Le),a(D),a(Se),a(Q)),a(n),$(_,e),$(v,e),$(y,e),$(L,e),$(U,e),$(J,e),$(R,e),$(z,e),$(b,e),$(Z,e)}}}const dt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function ft(T){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends nt{constructor(n){super(),st(this,n,ft,ht,at,{})}}export{vt as component};
