import{s as vn,f as _n,o as wn,n as go}from"../chunks/scheduler.9bc65507.js";import{S as yn,i as Fn,g as a,s as r,r as m,A as Tn,h as i,f as o,c as s,j as T,u as p,x as _,k as w,y as n,a as l,v as f,d as h,t as g,w as u}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{D as O}from"../chunks/Docstring.17db21ae.js";import{C as qt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Nt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as B}from"../chunks/Heading.342b1fa6.js";function Mn(I){let c,M="Examples:",b,v,y;return v=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9uZUZvcm1lckNvbmZpZyUyQyUyME9uZUZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9uZUZvcm1lciUyMHNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9uZUZvcm1lckNvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPbmVGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerConfig, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OneFormer shi-labs/oneformer_ade20k_swin_tiny configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OneFormerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the shi-labs/oneformer_ade20k_swin_tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(v.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=M),b=s(d),p(v.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),f(v,d,x),y=!0},p:go,i(d){y||(h(v.$$.fragment,d),y=!0)},o(d){g(v.$$.fragment,d),y=!1},d(d){d&&(o(c),o(b)),u(v,d)}}}function xn(I){let c,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=M},l(b){c=i(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=M)},m(b,v){l(b,c,v)},p:go,d(b){b&&o(c)}}}function kn(I){let c,M="Example:",b,v,y;return v=new qt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBPbmVGb3JtZXJQcm9jZXNzb3IlMkMlMjBPbmVGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMGRvd25sb2FkJTIwdGV4dGluZyUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBwcm9jZXNzb3IlMjBmb3IlMjBwcmVwcm9jZXNzaW5nJTIwdGhlJTIwaW5wdXRzJTBBcHJvY2Vzc29yJTIwJTNEJTIwT25lRm9ybWVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwT25lRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwJTVCJTIyc2VtYW50aWMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza19wcmVkaWN0aW9ucyUyMCUzRCUyMG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9tYXNrX3ByZWRpY3Rpb25zJTBBY2xhc3NfcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLnRyYW5zZm9ybWVyX2RlY29kZXJfY2xhc3NfcHJlZGljdGlvbnMlMEElMEFmJTIyJUYwJTlGJTkxJTg5JTIwTWFzayUyMFByZWRpY3Rpb25zJTIwU2hhcGUlM0ElMjAlN0JsaXN0KG1hc2tfcHJlZGljdGlvbnMuc2hhcGUpJTdEJTJDJTIwQ2xhc3MlMjBQcmVkaWN0aW9ucyUyMFNoYXBlJTNBJTIwJTdCbGlzdChjbGFzc19wcmVkaWN0aW9ucy5zaGFwZSklN0QlMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download texting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load processor for preprocessing the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_predictions = outputs.transformer_decoder_mask_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>class_predictions = outputs.transformer_decoder_class_predictions

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Mask Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(mask_predictions.shape)}</span>, Class Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(class_predictions.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Mask Predictions Shape: [1, 150, 128, 171], Class Predictions Shape: [1, 150, 151]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(v.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=M),b=s(d),p(v.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),f(v,d,x),y=!0},p:go,i(d){y||(h(v.$$.fragment,d),y=!0)},o(d){g(v.$$.fragment,d),y=!1},d(d){d&&(o(c),o(b)),u(v,d)}}}function On(I){let c,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=M},l(b){c=i(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=M)},m(b,v){l(b,c,v)},p:go,d(b){b&&o(c)}}}function jn(I){let c,M="Universal segmentation example:",b,v,y;return v=new qt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load OneFormer fine-tuned on ADE20k for universal segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Semantic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for semantic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Semantic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_semantic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Semantic Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instance Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for instance postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_instance_map = processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Instance Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_instance_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Instance Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Panoptic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for panoptic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Panoptic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Panoptic Predictions Shape: [512, 683]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(v.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-9x0o9r"&&(c.textContent=M),b=s(d),p(v.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),f(v,d,x),y=!0},p:go,i(d){y||(h(v.$$.fragment,d),y=!0)},o(d){g(v.$$.fragment,d),y=!1},d(d){d&&(o(c),o(b)),u(v,d)}}}function $n(I){let c,M,b,v,y,d,x,uo,te,Pt='The OneFormer model was proposed in <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">OneFormer: One Transformer to Rule Universal Image Segmentation</a> by Jitesh Jain, Jiachen Li, MangTik Chiu, Ali Hassani, Nikita Orlov, Humphrey Shi. OneFormer is a universal image segmentation framework that can be trained on a single panoptic dataset to perform semantic, instance, and panoptic segmentation tasks. OneFormer uses a task token to condition the model on the task in focus, making the architecture task-guided for training, and task-dynamic for inference.',_o,ne,Wt,bo,re,Zt="The abstract from the paper is the following:",vo,se,Bt="<em>Universal Image Segmentation is not a new concept. Past attempts to unify image segmentation in the last decades include scene parsing, panoptic segmentation, and, more recently, new panoptic architectures. However, such panoptic architectures do not truly unify image segmentation because they need to be trained individually on the semantic, instance, or panoptic segmentation to achieve the best performance. Ideally, a truly universal framework should be trained only once and achieve SOTA performance across all three image segmentation tasks. To that end, we propose OneFormer, a universal image segmentation framework that unifies segmentation with a multi-task train-once design. We first propose a task-conditioned joint training strategy that enables training on ground truths of each domain (semantic, instance, and panoptic segmentation) within a single multi-task training process. Secondly, we introduce a task token to condition our model on the task at hand, making our model task-dynamic to support multi-task training and inference. Thirdly, we propose using a query-text contrastive loss during training to establish better inter-task and inter-class distinctions. Notably, our single OneFormer model outperforms specialized Mask2Former models across all three segmentation tasks on ADE20k, CityScapes, and COCO, despite the latter being trained on each of the three tasks individually with three times the resources. With new ConvNeXt and DiNAT backbones, we observe even more performance improvement. We believe OneFormer is a significant step towards making image segmentation more universal and accessible.</em>",wo,ae,St='The figure below illustrates the architecture of OneFormer. Taken from the <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">original paper</a>.',yo,ie,Ht,Fo,le,Gt='This model was contributed by <a href="https://huggingface.co/praeclarumjj3" rel="nofollow">Jitesh Jain</a>. The original code can be found <a href="https://github.com/SHI-Labs/OneFormer" rel="nofollow">here</a>.',To,ce,Mo,de,Vt=`<li>OneFormer requires two inputs during inference: <em>image</em> and <em>task token</em>.</li> <li>During training, OneFormer only uses panoptic annotations.</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>OneFormerLoss</code> class of <code>modeling_oneformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/SHI-Labs/OneFormer/blob/33ebb56ed34f970a30ae103e786c0cb64c653d9a/oneformer/modeling/criterion.py#L287" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> to prepare input images and task inputs for the model and optional targets for the model. <code>OneformerProcessor</code> wraps <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and <a href="/docs/transformers/v4.40.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both prepare the images and encode the task inputs.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,xo,me,ko,pe,Lt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OneFormer.",Oo,fe,Rt='<li>Demo notebooks regarding inference + fine-tuning on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OneFormer" rel="nofollow">here</a>.</li>',jo,he,Xt=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,$o,ge,Uo,S,ue,Qo,Be,Et='Class for outputs of <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. This class returns all the needed hidden states to compute the logits.',Io,C,_e,Ao,Se,Yt="Class for outputs of <code>OneFormerForUniversalSegmentationOutput</code>.",Ko,He,Dt=`This output can be directly passed to <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~OneFormerImageProcessor] for details regarding usage.`,Jo,be,zo,U,ve,et,Ge,Qt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. It is used to instantiate a
OneFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OneFormer
<a href="https://huggingface.co/shi-labs/oneformer_ade20k_swin_tiny" rel="nofollow">shi-labs/oneformer_ade20k_swin_tiny</a> architecture
trained on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,ot,Ve,At=`Configuration objects inherit from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,tt,G,Co,we,No,F,ye,nt,Le,Kt=`Constructs a OneFormer image processor. The image processor can be used to prepare image(s), task input(s) and
optional text inputs and targets for the model.`,rt,Re,en=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,st,Xe,Fe,at,W,Te,it,Ee,on="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",lt,Ye,tn=`OneFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,ct,V,Me,dt,De,nn=`Converts the output of <a href="/docs/transformers/v4.40.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,mt,L,xe,pt,Qe,rn=`Converts the output of <code>OneFormerForUniversalSegmentationOutput</code> into image instance segmentation
predictions. Only supports PyTorch.`,ft,R,ke,ht,Ae,sn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,qo,Oe,Po,j,je,gt,Ke,an=`Constructs an OneFormer processor which wraps <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and
<a href="/docs/transformers/v4.40.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/v4.40.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into a single processor that inherits both the image processor and
tokenizer functionalities.`,ut,X,$e,_t,eo,ln=`This method forwards all its arguments to <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.encode_inputs">OneFormerImageProcessor.encode_inputs()</a> and then tokenizes the
task_inputs. Please refer to the docstring of this method for more information.`,bt,E,Ue,vt,oo,cn=`This method forwards all its arguments to <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">OneFormerImageProcessor.post_process_instance_segmentation()</a>.
Please refer to the docstring of this method for more information.`,wt,Y,Ie,yt,to,dn=`This method forwards all its arguments to <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">OneFormerImageProcessor.post_process_panoptic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Ft,D,Je,Tt,no,mn=`This method forwards all its arguments to <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">OneFormerImageProcessor.post_process_semantic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Wo,ze,Zo,N,Ce,Mt,ro,pn=`The bare OneFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,xt,J,Ne,kt,so,fn='The <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ot,Q,jt,A,Bo,qe,So,q,Pe,$t,ao,hn=`OneFormer Model for instance, semantic and panoptic image segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,Ut,$,We,It,io,gn='The <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Jt,K,zt,lo,un="Example:",Ct,ee,Ho,fo,Go;return y=new B({props:{title:"OneFormer",local:"oneformer",headingTag:"h1"}}),x=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new B({props:{title:"OneFormer specific outputs",local:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",headingTag:"h2"}}),ue=new O({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",parameters:[{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": Optional = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": Optional = None"},{name:"text_queries",val:": Optional = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L812"}}),_e=new O({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_predictions",val:": List = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": Optional = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": Optional = None"},{name:"text_queries",val:": Optional = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.auxiliary_predictions",description:`<strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L862"}}),be=new B({props:{title:"OneFormerConfig",local:"transformers.OneFormerConfig",headingTag:"h2"}}),ve=new O({props:{name:"class transformers.OneFormerConfig",anchor:"transformers.OneFormerConfig",parameters:[{name:"backbone_config",val:": Optional = None"},{name:"backbone",val:": Optional = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": Optional = None"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 150"},{name:"no_object_weight",val:": int = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"contrastive_weight",val:": float = 0.5"},{name:"contrastive_temperature",val:": float = 0.07"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"is_training",val:": bool = False"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"output_auxiliary_logits",val:": bool = True"},{name:"strides",val:": Optional = [4, 8, 16, 32]"},{name:"task_seq_len",val:": int = 77"},{name:"text_encoder_width",val:": int = 256"},{name:"text_encoder_context_length",val:": int = 77"},{name:"text_encoder_num_layers",val:": int = 6"},{name:"text_encoder_vocab_size",val:": int = 49408"},{name:"text_encoder_proj_layers",val:": int = 2"},{name:"text_encoder_n_ctx",val:": int = 16"},{name:"conv_dim",val:": int = 256"},{name:"mask_dim",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"norm",val:": str = 'GN'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"use_task_norm",val:": bool = True"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.1"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_proj",val:": bool = False"},{name:"query_dec_layers",val:": int = 2"},{name:"common_stride",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>, defaults to <code>SwinConfig</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.OneFormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.OneFormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.OneFormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.OneFormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.OneFormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Values to be ignored in GT label while calculating loss.`,name:"ignore_value"},{anchor:"transformers.OneFormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 150) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.OneFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight for no-object class predictions.`,name:"no_object_weight"},{anchor:"transformers.OneFormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Weight for Classification CE loss.`,name:"class_weight"},{anchor:"transformers.OneFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for binary CE loss.`,name:"mask_weight"},{anchor:"transformers.OneFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for dice loss.`,name:"dice_weight"},{anchor:"transformers.OneFormerConfig.contrastive_weight",description:`<strong>contrastive_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Weight for contrastive loss.`,name:"contrastive_weight"},{anchor:"transformers.OneFormerConfig.contrastive_temperature",description:`<strong>contrastive_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.07) &#x2014;
Initial value for scaling the contrastive logits.`,name:"contrastive_temperature"},{anchor:"transformers.OneFormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points to sample while calculating losses on mask predictions.`,name:"train_num_points"},{anchor:"transformers.OneFormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Ratio to decide how many points to oversample.`,name:"oversample_ratio"},{anchor:"transformers.OneFormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.OneFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for normal intialization.`,name:"init_std"},{anchor:"transformers.OneFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Standard deviation for xavier uniform initialization.`,name:"init_xavier_std"},{anchor:"transformers.OneFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OneFormerConfig.is_training",description:`<strong>is_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to run in training or inference mode.`,name:"is_training"},{anchor:"transformers.OneFormerConfig.use_auxiliary_loss",description:`<strong>use_auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to calculate loss using intermediate predictions from transformer decoder.`,name:"use_auxiliary_loss"},{anchor:"transformers.OneFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return intermediate predictions from transformer decoder.`,name:"output_auxiliary_logits"},{anchor:"transformers.OneFormerConfig.strides",description:`<strong>strides</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
List containing the strides for feature maps in the encoder.`,name:"strides"},{anchor:"transformers.OneFormerConfig.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for tokenizing text list input.`,name:"task_seq_len"},{anchor:"transformers.OneFormerConfig.text_encoder_width",description:`<strong>text_encoder_width</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Hidden size for text encoder.`,name:"text_encoder_width"},{anchor:"transformers.OneFormerConfig.text_encoder_context_length",description:`<strong>text_encoder_context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Input sequence length for text encoder.`,name:"text_encoder_context_length"},{anchor:"transformers.OneFormerConfig.text_encoder_num_layers",description:`<strong>text_encoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers for transformer in text encoder.`,name:"text_encoder_num_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_vocab_size",description:`<strong>text_encoder_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size for tokenizer.`,name:"text_encoder_vocab_size"},{anchor:"transformers.OneFormerConfig.text_encoder_proj_layers",description:`<strong>text_encoder_proj_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in MLP for project text queries.`,name:"text_encoder_proj_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_n_ctx",description:`<strong>text_encoder_n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of learnable text context queries.`,name:"text_encoder_n_ctx"},{anchor:"transformers.OneFormerConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Feature map dimension to map outputs from the backbone.`,name:"conv_dim"},{anchor:"transformers.OneFormerConfig.mask_dim",description:`<strong>mask_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for feature maps in pixel decoder.`,name:"mask_dim"},{anchor:"transformers.OneFormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for hidden states in transformer decoder.`,name:"hidden_dim"},{anchor:"transformers.OneFormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension for FFN layer in pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.OneFormerConfig.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;GN&quot;</code>) &#x2014;
Type of normalization.`,name:"norm"},{anchor:"transformers.OneFormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.OneFormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.OneFormerConfig.use_task_norm",description:`<strong>use_task_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the task token.`,name:"use_task_norm"},{anchor:"transformers.OneFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads in transformer layers in the pixel and transformer decoders.`,name:"num_attention_heads"},{anchor:"transformers.OneFormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Dropout probability for pixel and transformer decoders.`,name:"dropout"},{anchor:"transformers.OneFormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension for FFN layer in transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.OneFormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize hidden states before attention layers in transformer decoder.`,name:"pre_norm"},{anchor:"transformers.OneFormerConfig.enforce_input_proj",description:`<strong>enforce_input_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to project hidden states in transformer decoder.`,name:"enforce_input_proj"},{anchor:"transformers.OneFormerConfig.query_dec_layers",description:`<strong>query_dec_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in query transformer.`,name:"query_dec_layers"},{anchor:"transformers.OneFormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Common stride used for features in pixel decoder.`,name:"common_stride"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/configuration_oneformer.py#L29"}}),G=new Nt({props:{anchor:"transformers.OneFormerConfig.example",$$slots:{default:[Mn]},$$scope:{ctx:I}}}),we=new B({props:{title:"OneFormerImageProcessor",local:"transformers.OneFormerImageProcessor",headingTag:"h2"}}),ye=new O({props:{name:"class transformers.OneFormerImageProcessor",anchor:"transformers.OneFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"repo_path",val:": Optional = 'shi-labs/oneformer_demo'"},{name:"class_info_file",val:": str = None"},{name:"num_text",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.OneFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.OneFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.OneFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.OneFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.OneFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.OneFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.OneFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.OneFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.OneFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.OneFormerImageProcessor.repo_path",description:`<strong>repo_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;shi-labs/oneformer_demo&quot;</code>) &#x2014;
Path to hub repo or local directory containing the JSON file with class information for the dataset.
If unset, will look for <code>class_info_file</code> in the current working directory.`,name:"repo_path"},{anchor:"transformers.OneFormerImageProcessor.class_info_file",description:`<strong>class_info_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
JSON file containing class information for the dataset. See <code>shi-labs/oneformer_demo/cityscapes_panoptic.json</code> for an example.`,name:"class_info_file"},{anchor:"transformers.OneFormerImageProcessor.num_text",description:`<strong>num_text</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of text entries in the text input list.`,name:"num_text"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L370"}}),Fe=new O({props:{name:"preprocess",anchor:"transformers.OneFormerImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"task_inputs",val:": Optional = None"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Optional = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L677"}}),Te=new O({props:{name:"encode_inputs",anchor:"transformers.OneFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": List"},{name:"task_inputs",val:": List"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.task_inputs",description:`<strong>task_inputs</strong> (<code>List[str]</code>) &#x2014;
List of task values.`,name:"task_inputs"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.40.0/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred from the input
image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L979",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.40.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
<li><strong>text_inputs</strong> — Optional list of text string entries to be fed to a model (when <code>annotations</code> are
provided). They identify the binary masks present in the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.40.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Me=new O({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),xe=new O({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"task_type",val:": str = 'instance'"},{name:"is_demo",val:": bool = True"},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<code>OneFormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <code>OneFormerForUniversalSegmentationOutput</code>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.task_type",description:`<strong>task_type</strong> (<code>str</code>, <em>optional)</em>, defaults to &#x201C;instance&#x201D;) &#x2014;
The post processing depends on the task token input. If the <code>task_type</code> is &#x201C;panoptic&#x201D;, we need to
ignore the stuff predictions.`,name:"task_type"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.is_demo",description:`<strong>is_demo</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>True</code>) &#x2014;
Whether the model is in demo mode. If true, use threshold to predict final masks.`,name:"is_demo"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>False</code>) &#x2014;
Whether to return predictions in COCO format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1164",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ke=new O({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.40.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1284",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Oe=new B({props:{title:"OneFormerProcessor",local:"transformers.OneFormerProcessor",headingTag:"h2"}}),je=new O({props:{name:"class transformers.OneFormerProcessor",anchor:"transformers.OneFormerProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"max_seq_length",val:": int = 77"},{name:"task_seq_length",val:": int = 77"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OneFormerProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.OneFormerProcessor.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77)) &#x2014;
Sequence length for input text list.`,name:"max_seq_len"},{anchor:"transformers.OneFormerProcessor.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for input task token.`,name:"task_seq_len"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/processing_oneformer.py#L29"}}),$e=new O({props:{name:"encode_inputs",anchor:"transformers.OneFormerProcessor.encode_inputs",parameters:[{name:"images",val:" = None"},{name:"task_inputs",val:" = None"},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/processing_oneformer.py#L145"}}),Ue=new O({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerProcessor.post_process_instance_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/processing_oneformer.py#L192"}}),Ie=new O({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_panoptic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/processing_oneformer.py#L199"}}),Je=new O({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_semantic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/processing_oneformer.py#L185"}}),ze=new B({props:{title:"OneFormerModel",local:"transformers.OneFormerModel",headingTag:"h2"}}),Ce=new O({props:{name:"class transformers.OneFormerModel",anchor:"transformers.OneFormerModel",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L2906"}}),Ne=new O({props:{name:"forward",anchor:"transformers.OneFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerModel.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L2927",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — Tuple of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new bn({props:{$$slots:{default:[xn]},$$scope:{ctx:I}}}),A=new Nt({props:{anchor:"transformers.OneFormerModel.forward.example",$$slots:{default:[kn]},$$scope:{ctx:I}}}),qe=new B({props:{title:"OneFormerForUniversalSegmentation",local:"transformers.OneFormerForUniversalSegmentation",headingTag:"h2"}}),Pe=new O({props:{name:"class transformers.OneFormerForUniversalSegmentation",anchor:"transformers.OneFormerForUniversalSegmentation",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L3035"}}),We=new O({props:{name:"forward",anchor:"transformers.OneFormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": Optional = None"},{name:"mask_labels",val:": Optional = None"},{name:"class_labels",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_auxiliary_logits",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.text_inputs",description:`<strong>text_inputs</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Tensor fof shape <code>(num_queries, sequence_length)</code> to be fed to a model`,name:"text_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/oneformer/modeling_oneformer.py#L3106",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.40.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new bn({props:{$$slots:{default:[On]},$$scope:{ctx:I}}}),ee=new Nt({props:{anchor:"transformers.OneFormerForUniversalSegmentation.forward.example",$$slots:{default:[jn]},$$scope:{ctx:I}}}),{c(){c=a("meta"),M=r(),b=a("p"),v=r(),m(y.$$.fragment),d=r(),m(x.$$.fragment),uo=r(),te=a("p"),te.innerHTML=Pt,_o=r(),ne=a("img"),bo=r(),re=a("p"),re.textContent=Zt,vo=r(),se=a("p"),se.innerHTML=Bt,wo=r(),ae=a("p"),ae.innerHTML=St,yo=r(),ie=a("img"),Fo=r(),le=a("p"),le.innerHTML=Gt,To=r(),m(ce.$$.fragment),Mo=r(),de=a("ul"),de.innerHTML=Vt,xo=r(),m(me.$$.fragment),ko=r(),pe=a("p"),pe.textContent=Lt,Oo=r(),fe=a("ul"),fe.innerHTML=Rt,jo=r(),he=a("p"),he.textContent=Xt,$o=r(),m(ge.$$.fragment),Uo=r(),S=a("div"),m(ue.$$.fragment),Qo=r(),Be=a("p"),Be.innerHTML=Et,Io=r(),C=a("div"),m(_e.$$.fragment),Ao=r(),Se=a("p"),Se.innerHTML=Yt,Ko=r(),He=a("p"),He.innerHTML=Dt,Jo=r(),m(be.$$.fragment),zo=r(),U=a("div"),m(ve.$$.fragment),et=r(),Ge=a("p"),Ge.innerHTML=Qt,ot=r(),Ve=a("p"),Ve.innerHTML=At,tt=r(),m(G.$$.fragment),Co=r(),m(we.$$.fragment),No=r(),F=a("div"),m(ye.$$.fragment),nt=r(),Le=a("p"),Le.textContent=Kt,rt=r(),Re=a("p"),Re.innerHTML=en,st=r(),Xe=a("div"),m(Fe.$$.fragment),at=r(),W=a("div"),m(Te.$$.fragment),it=r(),Ee=a("p"),Ee.innerHTML=on,lt=r(),Ye=a("p"),Ye.innerHTML=tn,ct=r(),V=a("div"),m(Me.$$.fragment),dt=r(),De=a("p"),De.innerHTML=nn,mt=r(),L=a("div"),m(xe.$$.fragment),pt=r(),Qe=a("p"),Qe.innerHTML=rn,ft=r(),R=a("div"),m(ke.$$.fragment),ht=r(),Ae=a("p"),Ae.innerHTML=sn,qo=r(),m(Oe.$$.fragment),Po=r(),j=a("div"),m(je.$$.fragment),gt=r(),Ke=a("p"),Ke.innerHTML=an,ut=r(),X=a("div"),m($e.$$.fragment),_t=r(),eo=a("p"),eo.innerHTML=ln,bt=r(),E=a("div"),m(Ue.$$.fragment),vt=r(),oo=a("p"),oo.innerHTML=cn,wt=r(),Y=a("div"),m(Ie.$$.fragment),yt=r(),to=a("p"),to.innerHTML=dn,Ft=r(),D=a("div"),m(Je.$$.fragment),Tt=r(),no=a("p"),no.innerHTML=mn,Wo=r(),m(ze.$$.fragment),Zo=r(),N=a("div"),m(Ce.$$.fragment),Mt=r(),ro=a("p"),ro.innerHTML=pn,xt=r(),J=a("div"),m(Ne.$$.fragment),kt=r(),so=a("p"),so.innerHTML=fn,Ot=r(),m(Q.$$.fragment),jt=r(),m(A.$$.fragment),Bo=r(),m(qe.$$.fragment),So=r(),q=a("div"),m(Pe.$$.fragment),$t=r(),ao=a("p"),ao.innerHTML=hn,Ut=r(),$=a("div"),m(We.$$.fragment),It=r(),io=a("p"),io.innerHTML=gn,Jt=r(),m(K.$$.fragment),zt=r(),lo=a("p"),lo.textContent=un,Ct=r(),m(ee.$$.fragment),Ho=r(),fo=a("p"),this.h()},l(e){const t=Tn("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(o),M=s(e),b=i(e,"P",{}),T(b).forEach(o),v=s(e),p(y.$$.fragment,e),d=s(e),p(x.$$.fragment,e),uo=s(e),te=i(e,"P",{"data-svelte-h":!0}),_(te)!=="svelte-4uriep"&&(te.innerHTML=Pt),_o=s(e),ne=i(e,"IMG",{width:!0,src:!0}),bo=s(e),re=i(e,"P",{"data-svelte-h":!0}),_(re)!=="svelte-vfdo9a"&&(re.textContent=Zt),vo=s(e),se=i(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-lnf9ge"&&(se.innerHTML=Bt),wo=s(e),ae=i(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-194z8jz"&&(ae.innerHTML=St),yo=s(e),ie=i(e,"IMG",{width:!0,src:!0}),Fo=s(e),le=i(e,"P",{"data-svelte-h":!0}),_(le)!=="svelte-tphfzt"&&(le.innerHTML=Gt),To=s(e),p(ce.$$.fragment,e),Mo=s(e),de=i(e,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-elol33"&&(de.innerHTML=Vt),xo=s(e),p(me.$$.fragment,e),ko=s(e),pe=i(e,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-e2wyhg"&&(pe.textContent=Lt),Oo=s(e),fe=i(e,"UL",{"data-svelte-h":!0}),_(fe)!=="svelte-1f4vugx"&&(fe.innerHTML=Rt),jo=s(e),he=i(e,"P",{"data-svelte-h":!0}),_(he)!=="svelte-1rggs50"&&(he.textContent=Xt),$o=s(e),p(ge.$$.fragment,e),Uo=s(e),S=i(e,"DIV",{class:!0});var Ze=T(S);p(ue.$$.fragment,Ze),Qo=s(Ze),Be=i(Ze,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-8iufp6"&&(Be.innerHTML=Et),Ze.forEach(o),Io=s(e),C=i(e,"DIV",{class:!0});var H=T(C);p(_e.$$.fragment,H),Ao=s(H),Se=i(H,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-tmsgtt"&&(Se.innerHTML=Yt),Ko=s(H),He=i(H,"P",{"data-svelte-h":!0}),_(He)!=="svelte-xwj5te"&&(He.innerHTML=Dt),H.forEach(o),Jo=s(e),p(be.$$.fragment,e),zo=s(e),U=i(e,"DIV",{class:!0});var P=T(U);p(ve.$$.fragment,P),et=s(P),Ge=i(P,"P",{"data-svelte-h":!0}),_(Ge)!=="svelte-j5jlgz"&&(Ge.innerHTML=Qt),ot=s(P),Ve=i(P,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-1pfahiz"&&(Ve.innerHTML=At),tt=s(P),p(G.$$.fragment,P),P.forEach(o),Co=s(e),p(we.$$.fragment,e),No=s(e),F=i(e,"DIV",{class:!0});var k=T(F);p(ye.$$.fragment,k),nt=s(k),Le=i(k,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-5uz02u"&&(Le.textContent=Kt),rt=s(k),Re=i(k,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-1wh3jgn"&&(Re.innerHTML=en),st=s(k),Xe=i(k,"DIV",{class:!0});var ho=T(Xe);p(Fe.$$.fragment,ho),ho.forEach(o),at=s(k),W=i(k,"DIV",{class:!0});var co=T(W);p(Te.$$.fragment,co),it=s(co),Ee=i(co,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-1tetyua"&&(Ee.innerHTML=on),lt=s(co),Ye=i(co,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-g5nqd2"&&(Ye.innerHTML=tn),co.forEach(o),ct=s(k),V=i(k,"DIV",{class:!0});var Vo=T(V);p(Me.$$.fragment,Vo),dt=s(Vo),De=i(Vo,"P",{"data-svelte-h":!0}),_(De)!=="svelte-1ovtas2"&&(De.innerHTML=nn),Vo.forEach(o),mt=s(k),L=i(k,"DIV",{class:!0});var Lo=T(L);p(xe.$$.fragment,Lo),pt=s(Lo),Qe=i(Lo,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-ivz9k7"&&(Qe.innerHTML=rn),Lo.forEach(o),ft=s(k),R=i(k,"DIV",{class:!0});var Ro=T(R);p(ke.$$.fragment,Ro),ht=s(Ro),Ae=i(Ro,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-pw2uru"&&(Ae.innerHTML=sn),Ro.forEach(o),k.forEach(o),qo=s(e),p(Oe.$$.fragment,e),Po=s(e),j=i(e,"DIV",{class:!0});var z=T(j);p(je.$$.fragment,z),gt=s(z),Ke=i(z,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-k2uub9"&&(Ke.innerHTML=an),ut=s(z),X=i(z,"DIV",{class:!0});var Xo=T(X);p($e.$$.fragment,Xo),_t=s(Xo),eo=i(Xo,"P",{"data-svelte-h":!0}),_(eo)!=="svelte-9yd98k"&&(eo.innerHTML=ln),Xo.forEach(o),bt=s(z),E=i(z,"DIV",{class:!0});var Eo=T(E);p(Ue.$$.fragment,Eo),vt=s(Eo),oo=i(Eo,"P",{"data-svelte-h":!0}),_(oo)!=="svelte-1trmag6"&&(oo.innerHTML=cn),Eo.forEach(o),wt=s(z),Y=i(z,"DIV",{class:!0});var Yo=T(Y);p(Ie.$$.fragment,Yo),yt=s(Yo),to=i(Yo,"P",{"data-svelte-h":!0}),_(to)!=="svelte-18kmquw"&&(to.innerHTML=dn),Yo.forEach(o),Ft=s(z),D=i(z,"DIV",{class:!0});var Do=T(D);p(Je.$$.fragment,Do),Tt=s(Do),no=i(Do,"P",{"data-svelte-h":!0}),_(no)!=="svelte-ryzw0o"&&(no.innerHTML=mn),Do.forEach(o),z.forEach(o),Wo=s(e),p(ze.$$.fragment,e),Zo=s(e),N=i(e,"DIV",{class:!0});var mo=T(N);p(Ce.$$.fragment,mo),Mt=s(mo),ro=i(mo,"P",{"data-svelte-h":!0}),_(ro)!=="svelte-1o75izy"&&(ro.innerHTML=pn),xt=s(mo),J=i(mo,"DIV",{class:!0});var oe=T(J);p(Ne.$$.fragment,oe),kt=s(oe),so=i(oe,"P",{"data-svelte-h":!0}),_(so)!=="svelte-whev3x"&&(so.innerHTML=fn),Ot=s(oe),p(Q.$$.fragment,oe),jt=s(oe),p(A.$$.fragment,oe),oe.forEach(o),mo.forEach(o),Bo=s(e),p(qe.$$.fragment,e),So=s(e),q=i(e,"DIV",{class:!0});var po=T(q);p(Pe.$$.fragment,po),$t=s(po),ao=i(po,"P",{"data-svelte-h":!0}),_(ao)!=="svelte-1c5p7r"&&(ao.innerHTML=hn),Ut=s(po),$=i(po,"DIV",{class:!0});var Z=T($);p(We.$$.fragment,Z),It=s(Z),io=i(Z,"P",{"data-svelte-h":!0}),_(io)!=="svelte-10fba49"&&(io.innerHTML=gn),Jt=s(Z),p(K.$$.fragment,Z),zt=s(Z),lo=i(Z,"P",{"data-svelte-h":!0}),_(lo)!=="svelte-11lpom8"&&(lo.textContent=un),Ct=s(Z),p(ee.$$.fragment,Z),Z.forEach(o),po.forEach(o),Ho=s(e),fo=i(e,"P",{}),T(fo).forEach(o),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",Un),w(ne,"width","600"),_n(ne.src,Wt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_teaser.png")||w(ne,"src",Wt),w(ie,"width","600"),_n(ie.src,Ht="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_architecture.png")||w(ie,"src",Ht),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,c),l(e,M,t),l(e,b,t),l(e,v,t),f(y,e,t),l(e,d,t),f(x,e,t),l(e,uo,t),l(e,te,t),l(e,_o,t),l(e,ne,t),l(e,bo,t),l(e,re,t),l(e,vo,t),l(e,se,t),l(e,wo,t),l(e,ae,t),l(e,yo,t),l(e,ie,t),l(e,Fo,t),l(e,le,t),l(e,To,t),f(ce,e,t),l(e,Mo,t),l(e,de,t),l(e,xo,t),f(me,e,t),l(e,ko,t),l(e,pe,t),l(e,Oo,t),l(e,fe,t),l(e,jo,t),l(e,he,t),l(e,$o,t),f(ge,e,t),l(e,Uo,t),l(e,S,t),f(ue,S,null),n(S,Qo),n(S,Be),l(e,Io,t),l(e,C,t),f(_e,C,null),n(C,Ao),n(C,Se),n(C,Ko),n(C,He),l(e,Jo,t),f(be,e,t),l(e,zo,t),l(e,U,t),f(ve,U,null),n(U,et),n(U,Ge),n(U,ot),n(U,Ve),n(U,tt),f(G,U,null),l(e,Co,t),f(we,e,t),l(e,No,t),l(e,F,t),f(ye,F,null),n(F,nt),n(F,Le),n(F,rt),n(F,Re),n(F,st),n(F,Xe),f(Fe,Xe,null),n(F,at),n(F,W),f(Te,W,null),n(W,it),n(W,Ee),n(W,lt),n(W,Ye),n(F,ct),n(F,V),f(Me,V,null),n(V,dt),n(V,De),n(F,mt),n(F,L),f(xe,L,null),n(L,pt),n(L,Qe),n(F,ft),n(F,R),f(ke,R,null),n(R,ht),n(R,Ae),l(e,qo,t),f(Oe,e,t),l(e,Po,t),l(e,j,t),f(je,j,null),n(j,gt),n(j,Ke),n(j,ut),n(j,X),f($e,X,null),n(X,_t),n(X,eo),n(j,bt),n(j,E),f(Ue,E,null),n(E,vt),n(E,oo),n(j,wt),n(j,Y),f(Ie,Y,null),n(Y,yt),n(Y,to),n(j,Ft),n(j,D),f(Je,D,null),n(D,Tt),n(D,no),l(e,Wo,t),f(ze,e,t),l(e,Zo,t),l(e,N,t),f(Ce,N,null),n(N,Mt),n(N,ro),n(N,xt),n(N,J),f(Ne,J,null),n(J,kt),n(J,so),n(J,Ot),f(Q,J,null),n(J,jt),f(A,J,null),l(e,Bo,t),f(qe,e,t),l(e,So,t),l(e,q,t),f(Pe,q,null),n(q,$t),n(q,ao),n(q,Ut),n(q,$),f(We,$,null),n($,It),n($,io),n($,Jt),f(K,$,null),n($,zt),n($,lo),n($,Ct),f(ee,$,null),l(e,Ho,t),l(e,fo,t),Go=!0},p(e,[t]){const Ze={};t&2&&(Ze.$$scope={dirty:t,ctx:e}),G.$set(Ze);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),Q.$set(H);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),A.$set(P);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),K.$set(k);const ho={};t&2&&(ho.$$scope={dirty:t,ctx:e}),ee.$set(ho)},i(e){Go||(h(y.$$.fragment,e),h(x.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(G.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(Fe.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(Oe.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Je.$$.fragment,e),h(ze.$$.fragment,e),h(Ce.$$.fragment,e),h(Ne.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(qe.$$.fragment,e),h(Pe.$$.fragment,e),h(We.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Go=!0)},o(e){g(y.$$.fragment,e),g(x.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(G.$$.fragment,e),g(we.$$.fragment,e),g(ye.$$.fragment,e),g(Fe.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(xe.$$.fragment,e),g(ke.$$.fragment,e),g(Oe.$$.fragment,e),g(je.$$.fragment,e),g($e.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Je.$$.fragment,e),g(ze.$$.fragment,e),g(Ce.$$.fragment,e),g(Ne.$$.fragment,e),g(Q.$$.fragment,e),g(A.$$.fragment,e),g(qe.$$.fragment,e),g(Pe.$$.fragment,e),g(We.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),Go=!1},d(e){e&&(o(M),o(b),o(v),o(d),o(uo),o(te),o(_o),o(ne),o(bo),o(re),o(vo),o(se),o(wo),o(ae),o(yo),o(ie),o(Fo),o(le),o(To),o(Mo),o(de),o(xo),o(ko),o(pe),o(Oo),o(fe),o(jo),o(he),o($o),o(Uo),o(S),o(Io),o(C),o(Jo),o(zo),o(U),o(Co),o(No),o(F),o(qo),o(Po),o(j),o(Wo),o(Zo),o(N),o(Bo),o(So),o(q),o(Ho),o(fo)),o(c),u(y,e),u(x,e),u(ce,e),u(me,e),u(ge,e),u(ue),u(_e),u(be,e),u(ve),u(G),u(we,e),u(ye),u(Fe),u(Te),u(Me),u(xe),u(ke),u(Oe,e),u(je),u($e),u(Ue),u(Ie),u(Je),u(ze,e),u(Ce),u(Ne),u(Q),u(A),u(qe,e),u(Pe),u(We),u(K),u(ee)}}}const Un='{"title":"OneFormer","local":"oneformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OneFormer specific outputs","local":"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput","sections":[],"depth":2},{"title":"OneFormerConfig","local":"transformers.OneFormerConfig","sections":[],"depth":2},{"title":"OneFormerImageProcessor","local":"transformers.OneFormerImageProcessor","sections":[],"depth":2},{"title":"OneFormerProcessor","local":"transformers.OneFormerProcessor","sections":[],"depth":2},{"title":"OneFormerModel","local":"transformers.OneFormerModel","sections":[],"depth":2},{"title":"OneFormerForUniversalSegmentation","local":"transformers.OneFormerForUniversalSegmentation","sections":[],"depth":2}],"depth":1}';function In(I){return wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends yn{constructor(c){super(),Fn(this,c,In,$n,vn,{})}}export{Zn as component};
