import{s as jo,o as Fo,n as yt}from"../chunks/scheduler.9bc65507.js";import{S as Uo,i as Io,g as l,s as n,r as f,A as Jo,h as i,f as t,c as s,j as z,u,x as c,k as q,y as a,a as r,v as h,d as _,t as g,w as k}from"../chunks/index.707bf1b6.js";import{T as zo}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.17db21ae.js";import{C as Ve}from"../chunks/CodeBlock.54a9f38d.js";import{E as qo}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as De}from"../chunks/Heading.342b1fa6.js";function Eo(I){let d,M="The <code>Llama2</code> family models, on which Code Llama is based, were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. Let’s look at the different precisions:",m,b,w="<li><code>float32</code>: PyTorch convention on model initialization is to load models in <code>float32</code>, no matter with which <code>dtype</code> the model weights were stored. <code>transformers</code> also follows this convention for consistency with PyTorch. This will be picked by default. If you want the <code>AutoModel</code> API to cast the load the checkpoints with the storage weights type, you must specify <code>torch_dtype=&quot;auto&quot;</code>, e.g. <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>.</li> <li><code>bfloat16</code>: Code Llama was trained with this precision, so we recommend using it for further training or fine-tuning.</li> <li><code>float16</code>: We recommend running inference using this precision, as it’s usually faster than <code>bfloat16</code>, and evaluation metrics show no discernible degradation with respect to <code>bfloat16</code>. You can also run inference using <code>bfloat16</code>, and we recommend you check inference results with both <code>float16</code> and <code>bfloat16</code> after fine-tuning.</li>",v,x,D="As mentioned above, the <code>dtype</code> of the storage weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using. The reason is that the model will first be downloaded (using the <code>dtype</code> of the checkpoints online) and then will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). If there is a specified <code>torch_dtype</code>, it will be used instead.";return{c(){d=l("p"),d.innerHTML=M,m=n(),b=l("ul"),b.innerHTML=w,v=n(),x=l("p"),x.innerHTML=D},l(T){d=i(T,"P",{"data-svelte-h":!0}),c(d)!=="svelte-8yf686"&&(d.innerHTML=M),m=s(T),b=i(T,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-17c64tm"&&(b.innerHTML=w),v=s(T),x=i(T,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1bzil5i"&&(x.innerHTML=D)},m(T,P){r(T,d,P),r(T,m,P),r(T,b,P),r(T,v,P),r(T,x,P)},p:yt,d(T){T&&(t(d),t(m),t(b),t(v),t(x))}}}function Po(I){let d,M=`Code Llama has the same architecture as the <code>Llama2</code> models, refer to <a href="llama2">Llama2’s documentation page</a> for the API reference.
Find Code Llama tokenizer reference below.`;return{c(){d=l("p"),d.innerHTML=M},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1buct0x"&&(d.innerHTML=M)},m(m,b){r(m,d,b)},p:yt,d(m){m&&t(d)}}}function Ho(I){let d,M="sequence pair mask has the following format:",m,b,w;return b=new Ve({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=l("p"),d.textContent=M,m=n(),f(b.$$.fragment)},l(v){d=i(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-16klr56"&&(d.textContent=M),m=s(v),u(b.$$.fragment,v)},m(v,x){r(v,d,x),r(v,m,x),h(b,v,x),w=!0},p:yt,i(v){w||(_(b.$$.fragment,v),w=!0)},o(v){g(b.$$.fragment,v),w=!1},d(v){v&&(t(d),t(m)),k(b,v)}}}function Zo(I){let d,M;return d=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVMbGFtYVRva2VuaXplckZhc3QlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGxhbWEtdG9rZW5pemVyJTIyKSUwQXRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGlzJTIwaXMlMjBhJTIwdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeLlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){f(d.$$.fragment)},l(m){u(d.$$.fragment,m)},m(m,b){h(d,m,b),M=!0},p:yt,i(m){M||(_(d.$$.fragment,m),M=!0)},o(m){g(d.$$.fragment,m),M=!1},d(m){k(d,m)}}}function No(I){let d,M,m,b,w,v,x,D,T,P='The Code Llama model was proposed in <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> by Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.',Se,V,Yt="The abstract from the paper is the following:",Xe,S,Ot="<em>We release Code Llama, a family of large language models for code based on Llama 2 providing state-of-the-art performance among open models, infilling capabilities, support for large input contexts, and zero-shot instruction following ability for programming tasks. We provide multiple flavors to cover a wide range of applications: foundation models (Code Llama), Python specializations (Code Llama - Python), and instruction-following models (Code Llama - Instruct) with 7B, 13B and 34B parameters each. All models are trained on sequences of 16k tokens and show improvements on inputs with up to 100k tokens. 7B and 13B Code Llama and Code Llama - Instruct variants support infilling based on surrounding content. Code Llama reaches state-of-the-art performance among open models on several code benchmarks, with scores of up to 53% and 55% on HumanEval and MBPP, respectively. Notably, Code Llama - Python 7B outperforms Llama 2 70B on HumanEval and MBPP, and all our models outperform every other publicly available model on MultiPL-E. We release Code Llama under a permissive license that allows for both research and commercial use.</em>",Qe,X,Kt='Check out all Code Llama model checkpoints <a href="https://huggingface.co/models?search=code_llama" rel="nofollow">here</a> and the officially released ones in the <a href="https://huggingface.co/codellama" rel="nofollow">codellama org</a>.',Ye,Q,eo='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZucker</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.',Oe,Y,Ke,H,et,O,to="Tips:",tt,K,oo="<li>The infilling task is supported out of the box. You should be using the <code>tokenizer.fill_token</code> where you want your input to be filled.</li> <li>The model conversion script is the same as for the <code>Llama2</code> family:</li>",ot,ee,no="Here is a sample usage:",nt,te,st,oe,so=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM).`,at,ne,ao="After conversion, the model and tokenizer can be loaded via:",rt,se,lt,ae,ro="If you only want the infilled part:",it,re,dt,le,lo='Under the hood, the tokenizer <a href="https://huggingface.co/docs/transformers/main/model_doc/code_llama#transformers.CodeLlamaTokenizer.fill_token" rel="nofollow">automatically splits by <code>&lt;FILL_ME&gt;</code></a> to create a formatted input string that follows <a href="https://github.com/facebookresearch/codellama/blob/cb51c14ec761370ba2e2bc351374a79265d0465e/llama/generation.py#L402" rel="nofollow">the original training pattern</a>. This is more robust than preparing the pattern yourself: it avoids pitfalls, such as token glueing, that are very hard to debug.  To see how much CPU and GPU memory you need for this model or others, try <a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">this calculator</a> which can help determine that value.',ct,ie,io='The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.',mt,Z,pt,de,ft,L,ce,Tt,xe,co=`Construct a CodeLlama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as
there is no padding token in the original model.`,xt,Le,mo=`The default configuration match that of
<a href="https://huggingface.co/codellama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Lt,Me,me,Mt,N,pe,$t,$e,po=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,wt,j,fe,Ct,we,fo="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",zt,A,qt,Ce,uo="if token_ids_1 is None, only returns the first portion of the mask (0s).",jt,R,ue,Ft,ze,ho="Save the vocabulary and special tokens file to a directory.",ut,he,ht,p,_e,Ut,qe,_o="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",It,je,go="This uses notably ByteFallback and no normalization.",Jt,B,Et,Fe,ko=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Pt,Ue,bo=`This tokenizer inherits from <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods. The default configuration match that of
<a href="https://huggingface.co/codellama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Ht,C,ge,Zt,Ie,vo=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,Nt,Je,yo="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",At,Ee,To="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",Rt,Pe,xo=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Bt,G,ke,Gt,He,Lo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Wt,J,be,Dt,Ze,Mo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Vt,Ne,$o="Should be overridden in a subclass if the model has a special way of building those.",St,W,ve,Xt,Ae,wo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Qt,Re,ye,_t,Ge,gt;return w=new De({props:{title:"CodeLlama",local:"codellama",headingTag:"h1"}}),x=new De({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new De({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),H=new zo({props:{warning:!0,$$slots:{default:[Eo]},$$scope:{ctx:I}}}),te=new Ve({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),se=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBDb2RlTGxhbWFUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMExsYW1hRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiklMEFQUk9NUFQlMjAlM0QlMjAnJydkZWYlMjByZW1vdmVfbm9uX2FzY2lpKHMlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyMCUzQ0ZJTExfTUUlM0UlMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQlMEEnJyclMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoUFJPTVBUJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBZmlsbGluZyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QiUzQSUyQyUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTIwJTNEJTIwVHJ1ZSklNUIwJTVEJTBBcHJpbnQoUFJPTVBULnJlcGxhY2UoJTIyJTNDRklMTF9NRSUzRSUyMiUyQyUyMGZpbGxpbmcpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, CodeLlamaTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>PROMPT = <span class="hljs-string">&#x27;&#x27;&#x27;def remove_non_ascii(s: str) -&gt; str:
<span class="hljs-meta">... </span>    &quot;&quot;&quot; &lt;FILL_ME&gt;
<span class="hljs-meta">... </span>    return result
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_ids, max_new_tokens=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filling = tokenizer.batch_decode(generated_ids[:, input_ids.shape[<span class="hljs-number">1</span>]:], skip_special_tokens = <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(PROMPT.replace(<span class="hljs-string">&quot;&lt;FILL_ME&gt;&quot;</span>, filling))
<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_non_ascii</span>(<span class="hljs-params">s: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot; Remove non-ASCII characters from a string.
&lt;BLANKLINE&gt;
    Args:
        s: The string to remove non-ASCII characters from.
&lt;BLANKLINE&gt;
    Returns:
        The string with non-ASCII characters removed.
    &quot;&quot;&quot;</span>
    result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> s:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">ord</span>(c) &lt; <span class="hljs-number">128</span>:
            result += c
    <span class="hljs-keyword">return</span> result
&lt;BLANKLINE&gt;`,wrap:!1}}),re=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkNtb2RlbCUzRCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiUyQ3RvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWdlbmVyYXRvcignZGVmJTIwcmVtb3ZlX25vbl9hc2NpaShzJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElNUNuJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTIwJTNDRklMTF9NRSUzRSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQnJTJDJTIwbWF4X25ld190b2tlbnMlMjAlM0QlMjAxMjgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>,model=<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>,torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return result&#x27;</span>, max_new_tokens = <span class="hljs-number">128</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return resultRemove non-ASCII characters from a string. &quot;&quot;&quot;\\n    result = &quot;&quot;\\n    for c in s:\\n        if ord(c) &lt; 128:\\n            result += c&#x27;</span>}]`,wrap:!1}}),Z=new zo({props:{$$slots:{default:[Po]},$$scope:{ctx:I}}}),de=new De({props:{title:"CodeLlamaTokenizer",local:"transformers.CodeLlamaTokenizer",headingTag:"h2"}}),ce=new U({props:{name:"class transformers.CodeLlamaTokenizer",anchor:"transformers.CodeLlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"suffix_first",val:" = False"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"additional_special_tokens",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizer.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizer.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizer.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizer.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.CodeLlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama.py#L48"}}),me=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama.py#L356"}}),pe=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama.py#L368",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),fe=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),A=new qo({props:{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Ho]},$$scope:{ctx:I}}}),ue=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama.py#L328",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),he=new De({props:{title:"CodeLlamaTokenizerFast",local:"transformers.CodeLlamaTokenizerFast",headingTag:"h2"}}),_e=new U({props:{name:"class transformers.CodeLlamaTokenizerFast",anchor:"transformers.CodeLlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"additional_special_tokens",val:" = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CodeLlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Wether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizerFast.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L52"}}),B=new qo({props:{anchor:"transformers.CodeLlamaTokenizerFast.example",$$slots:{default:[Zo]},$$scope:{ctx:I}}}),ge=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tokenization_utils_base.py#L3827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),be=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tokenization_utils_base.py#L3357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new U({props:{name:"update_post_processor",anchor:"transformers.CodeLlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L179"}}),ye=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L333"}}),{c(){d=l("meta"),M=n(),m=l("p"),b=n(),f(w.$$.fragment),v=n(),f(x.$$.fragment),D=n(),T=l("p"),T.innerHTML=P,Se=n(),V=l("p"),V.textContent=Yt,Xe=n(),S=l("p"),S.innerHTML=Ot,Qe=n(),X=l("p"),X.innerHTML=Kt,Ye=n(),Q=l("p"),Q.innerHTML=eo,Oe=n(),f(Y.$$.fragment),Ke=n(),f(H.$$.fragment),et=n(),O=l("p"),O.textContent=to,tt=n(),K=l("ul"),K.innerHTML=oo,ot=n(),ee=l("p"),ee.textContent=no,nt=n(),f(te.$$.fragment),st=n(),oe=l("p"),oe.textContent=so,at=n(),ne=l("p"),ne.textContent=ao,rt=n(),f(se.$$.fragment),lt=n(),ae=l("p"),ae.textContent=ro,it=n(),f(re.$$.fragment),dt=n(),le=l("p"),le.innerHTML=lo,ct=n(),ie=l("p"),ie.innerHTML=io,mt=n(),f(Z.$$.fragment),pt=n(),f(de.$$.fragment),ft=n(),L=l("div"),f(ce.$$.fragment),Tt=n(),xe=l("p"),xe.textContent=co,xt=n(),Le=l("p"),Le.innerHTML=mo,Lt=n(),Me=l("div"),f(me.$$.fragment),Mt=n(),N=l("div"),f(pe.$$.fragment),$t=n(),$e=l("p"),$e.innerHTML=po,wt=n(),j=l("div"),f(fe.$$.fragment),Ct=n(),we=l("p"),we.textContent=fo,zt=n(),f(A.$$.fragment),qt=n(),Ce=l("p"),Ce.textContent=uo,jt=n(),R=l("div"),f(ue.$$.fragment),Ft=n(),ze=l("p"),ze.textContent=ho,ut=n(),f(he.$$.fragment),ht=n(),p=l("div"),f(_e.$$.fragment),Ut=n(),qe=l("p"),qe.textContent=_o,It=n(),je=l("p"),je.textContent=go,Jt=n(),f(B.$$.fragment),Et=n(),Fe=l("p"),Fe.innerHTML=ko,Pt=n(),Ue=l("p"),Ue.innerHTML=bo,Ht=n(),C=l("div"),f(ge.$$.fragment),Zt=n(),Ie=l("p"),Ie.textContent=vo,Nt=n(),Je=l("p"),Je.innerHTML=yo,At=n(),Ee=l("ul"),Ee.innerHTML=To,Rt=n(),Pe=l("p"),Pe.textContent=xo,Bt=n(),G=l("div"),f(ke.$$.fragment),Gt=n(),He=l("p"),He.innerHTML=Lo,Wt=n(),J=l("div"),f(be.$$.fragment),Dt=n(),Ze=l("p"),Ze.innerHTML=Mo,Vt=n(),Ne=l("p"),Ne.textContent=$o,St=n(),W=l("div"),f(ve.$$.fragment),Xt=n(),Ae=l("p"),Ae.innerHTML=wo,Qt=n(),Re=l("div"),f(ye.$$.fragment),_t=n(),Ge=l("p"),this.h()},l(e){const o=Jo("svelte-u9bgzb",document.head);d=i(o,"META",{name:!0,content:!0}),o.forEach(t),M=s(e),m=i(e,"P",{}),z(m).forEach(t),b=s(e),u(w.$$.fragment,e),v=s(e),u(x.$$.fragment,e),D=s(e),T=i(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1s05gbs"&&(T.innerHTML=P),Se=s(e),V=i(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-vfdo9a"&&(V.textContent=Yt),Xe=s(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-mbr49z"&&(S.innerHTML=Ot),Qe=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-t80eao"&&(X.innerHTML=Kt),Ye=s(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-z5ta87"&&(Q.innerHTML=eo),Oe=s(e),u(Y.$$.fragment,e),Ke=s(e),u(H.$$.fragment,e),et=s(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-axv494"&&(O.textContent=to),tt=s(e),K=i(e,"UL",{"data-svelte-h":!0}),c(K)!=="svelte-qxctvz"&&(K.innerHTML=oo),ot=s(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1fo4g0o"&&(ee.textContent=no),nt=s(e),u(te.$$.fragment,e),st=s(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1ovdf29"&&(oe.textContent=so),at=s(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-b5pwv6"&&(ne.textContent=ao),rt=s(e),u(se.$$.fragment,e),lt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-cm0lfz"&&(ae.textContent=ro),it=s(e),u(re.$$.fragment,e),dt=s(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-xefpq6"&&(le.innerHTML=lo),ct=s(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-qunt86"&&(ie.innerHTML=io),mt=s(e),u(Z.$$.fragment,e),pt=s(e),u(de.$$.fragment,e),ft=s(e),L=i(e,"DIV",{class:!0});var $=z(L);u(ce.$$.fragment,$),Tt=s($),xe=i($,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1vmwvh5"&&(xe.textContent=co),xt=s($),Le=i($,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1thmlao"&&(Le.innerHTML=mo),Lt=s($),Me=i($,"DIV",{class:!0});var We=z(Me);u(me.$$.fragment,We),We.forEach(t),Mt=s($),N=i($,"DIV",{class:!0});var Te=z(N);u(pe.$$.fragment,Te),$t=s(Te),$e=i(Te,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1f4f5kp"&&($e.innerHTML=po),Te.forEach(t),wt=s($),j=i($,"DIV",{class:!0});var F=z(j);u(fe.$$.fragment,F),Ct=s(F),we=i(F,"P",{"data-svelte-h":!0}),c(we)!=="svelte-13bfd60"&&(we.textContent=fo),zt=s(F),u(A.$$.fragment,F),qt=s(F),Ce=i(F,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-wtrslu"&&(Ce.textContent=uo),F.forEach(t),jt=s($),R=i($,"DIV",{class:!0});var kt=z(R);u(ue.$$.fragment,kt),Ft=s(kt),ze=i(kt,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1slb66l"&&(ze.textContent=ho),kt.forEach(t),$.forEach(t),ut=s(e),u(he.$$.fragment,e),ht=s(e),p=i(e,"DIV",{class:!0});var y=z(p);u(_e.$$.fragment,y),Ut=s(y),qe=i(y,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-15tdcz8"&&(qe.textContent=_o),It=s(y),je=i(y,"P",{"data-svelte-h":!0}),c(je)!=="svelte-llhmpa"&&(je.textContent=go),Jt=s(y),u(B.$$.fragment,y),Et=s(y),Fe=i(y,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-cnb6q1"&&(Fe.innerHTML=ko),Pt=s(y),Ue=i(y,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-u0g1ez"&&(Ue.innerHTML=bo),Ht=s(y),C=i(y,"DIV",{class:!0});var E=z(C);u(ge.$$.fragment,E),Zt=s(E),Ie=i(E,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-1vll0v2"&&(Ie.textContent=vo),Nt=s(E),Je=i(E,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-90np8u"&&(Je.innerHTML=yo),At=s(E),Ee=i(E,"UL",{"data-svelte-h":!0}),c(Ee)!=="svelte-mlrsks"&&(Ee.innerHTML=To),Rt=s(E),Pe=i(E,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-46aam0"&&(Pe.textContent=xo),E.forEach(t),Bt=s(y),G=i(y,"DIV",{class:!0});var bt=z(G);u(ke.$$.fragment,bt),Gt=s(bt),He=i(bt,"P",{"data-svelte-h":!0}),c(He)!=="svelte-1wmjg8a"&&(He.innerHTML=Lo),bt.forEach(t),Wt=s(y),J=i(y,"DIV",{class:!0});var Be=z(J);u(be.$$.fragment,Be),Dt=s(Be),Ze=i(Be,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-zj1vf1"&&(Ze.innerHTML=Mo),Vt=s(Be),Ne=i(Be,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-9vptpw"&&(Ne.textContent=$o),Be.forEach(t),St=s(y),W=i(y,"DIV",{class:!0});var vt=z(W);u(ve.$$.fragment,vt),Xt=s(vt),Ae=i(vt,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-nfci2w"&&(Ae.innerHTML=wo),vt.forEach(t),Qt=s(y),Re=i(y,"DIV",{class:!0});var Co=z(Re);u(ye.$$.fragment,Co),Co.forEach(t),y.forEach(t),_t=s(e),Ge=i(e,"P",{}),z(Ge).forEach(t),this.h()},h(){q(d,"name","hf:doc:metadata"),q(d,"content",Ao),q(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,d),r(e,M,o),r(e,m,o),r(e,b,o),h(w,e,o),r(e,v,o),h(x,e,o),r(e,D,o),r(e,T,o),r(e,Se,o),r(e,V,o),r(e,Xe,o),r(e,S,o),r(e,Qe,o),r(e,X,o),r(e,Ye,o),r(e,Q,o),r(e,Oe,o),h(Y,e,o),r(e,Ke,o),h(H,e,o),r(e,et,o),r(e,O,o),r(e,tt,o),r(e,K,o),r(e,ot,o),r(e,ee,o),r(e,nt,o),h(te,e,o),r(e,st,o),r(e,oe,o),r(e,at,o),r(e,ne,o),r(e,rt,o),h(se,e,o),r(e,lt,o),r(e,ae,o),r(e,it,o),h(re,e,o),r(e,dt,o),r(e,le,o),r(e,ct,o),r(e,ie,o),r(e,mt,o),h(Z,e,o),r(e,pt,o),h(de,e,o),r(e,ft,o),r(e,L,o),h(ce,L,null),a(L,Tt),a(L,xe),a(L,xt),a(L,Le),a(L,Lt),a(L,Me),h(me,Me,null),a(L,Mt),a(L,N),h(pe,N,null),a(N,$t),a(N,$e),a(L,wt),a(L,j),h(fe,j,null),a(j,Ct),a(j,we),a(j,zt),h(A,j,null),a(j,qt),a(j,Ce),a(L,jt),a(L,R),h(ue,R,null),a(R,Ft),a(R,ze),r(e,ut,o),h(he,e,o),r(e,ht,o),r(e,p,o),h(_e,p,null),a(p,Ut),a(p,qe),a(p,It),a(p,je),a(p,Jt),h(B,p,null),a(p,Et),a(p,Fe),a(p,Pt),a(p,Ue),a(p,Ht),a(p,C),h(ge,C,null),a(C,Zt),a(C,Ie),a(C,Nt),a(C,Je),a(C,At),a(C,Ee),a(C,Rt),a(C,Pe),a(p,Bt),a(p,G),h(ke,G,null),a(G,Gt),a(G,He),a(p,Wt),a(p,J),h(be,J,null),a(J,Dt),a(J,Ze),a(J,Vt),a(J,Ne),a(p,St),a(p,W),h(ve,W,null),a(W,Xt),a(W,Ae),a(p,Qt),a(p,Re),h(ye,Re,null),r(e,_t,o),r(e,Ge,o),gt=!0},p(e,[o]){const $={};o&2&&($.$$scope={dirty:o,ctx:e}),H.$set($);const We={};o&2&&(We.$$scope={dirty:o,ctx:e}),Z.$set(We);const Te={};o&2&&(Te.$$scope={dirty:o,ctx:e}),A.$set(Te);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),B.$set(F)},i(e){gt||(_(w.$$.fragment,e),_(x.$$.fragment,e),_(Y.$$.fragment,e),_(H.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(Z.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(A.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(B.$$.fragment,e),_(ge.$$.fragment,e),_(ke.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),gt=!0)},o(e){g(w.$$.fragment,e),g(x.$$.fragment,e),g(Y.$$.fragment,e),g(H.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(Z.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(A.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(B.$$.fragment,e),g(ge.$$.fragment,e),g(ke.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),gt=!1},d(e){e&&(t(M),t(m),t(b),t(v),t(D),t(T),t(Se),t(V),t(Xe),t(S),t(Qe),t(X),t(Ye),t(Q),t(Oe),t(Ke),t(et),t(O),t(tt),t(K),t(ot),t(ee),t(nt),t(st),t(oe),t(at),t(ne),t(rt),t(lt),t(ae),t(it),t(dt),t(le),t(ct),t(ie),t(mt),t(pt),t(ft),t(L),t(ut),t(ht),t(p),t(_t),t(Ge)),t(d),k(w,e),k(x,e),k(Y,e),k(H,e),k(te,e),k(se,e),k(re,e),k(Z,e),k(de,e),k(ce),k(me),k(pe),k(fe),k(A),k(ue),k(he,e),k(_e),k(B),k(ge),k(ke),k(be),k(ve),k(ye)}}}const Ao='{"title":"CodeLlama","local":"codellama","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"CodeLlamaTokenizer","local":"transformers.CodeLlamaTokenizer","sections":[],"depth":2},{"title":"CodeLlamaTokenizerFast","local":"transformers.CodeLlamaTokenizerFast","sections":[],"depth":2}],"depth":1}';function Ro(I){return Fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qo extends Uo{constructor(d){super(),Io(this,d,Ro,No,jo,{})}}export{Qo as component};
