import{s as ll,f as al,n as el,o as nl}from"../chunks/scheduler.9bc65507.js";import{S as pl,i as il,g as p,s as e,r as m,A as cl,h as i,f as l,c as n,j as wt,u as o,x as c,k as y,y as ml,a,v as r,d as M,t as g,w as h}from"../chunks/index.707bf1b6.js";import{C as j}from"../chunks/CodeBlock.54a9f38d.js";import{D as ol}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as ds}from"../chunks/Heading.342b1fa6.js";function rl(xt){let b,Js,us,Us,C,ws,W,xs,v,Tt=`従来、<a href="object_detection">オブジェクト検出</a> に使用されるモデルには、トレーニング用のラベル付き画像データセットが必要でした。
トレーニング データからのクラスのセットの検出に限定されます。`,Ts,I,ft=`ゼロショットオブジェクト検出は、別のアプローチを使用する <a href="../model_doc/owlvit">OWL-ViT</a> モデルによってサポートされています。 OWL-ViT
オープン語彙オブジェクト検出器です。これは、フリーテキストクエリに基づいて画像内のオブジェクトを検出できることを意味します。
ラベル付きデータセットでモデルを微調整する必要性。`,fs,$,Ct=`OWL-ViTは、マルチモーダル表現を利用してオープン語彙の検出を実行します。 <a href="../model_doc/clip">CLIP</a> とを組み合わせます。
軽量のオブジェクト分類および位置特定ヘッド。オープン語彙の検出は、CLIP のテキスト エンコーダーを使用してフリーテキスト クエリを埋め込み、それらをオブジェクト分類およびローカリゼーション ヘッドへの入力として使用することによって実現されます。
画像とそれに対応するテキストの説明を関連付け、ViT は画像パッチを入力として処理します。作家たち
のOWL-ViTは、まずCLIPをゼロからトレーニングし、次に標準の物体検出データセットを使用してOWL-ViTをエンドツーエンドで微調整しました。
二部マッチング損失。`,Cs,k,Wt="このアプローチを使用すると、モデルはラベル付きデータセットで事前にトレーニングしなくても、テキストの説明に基づいてオブジェクトを検出できます。",Ws,R,vt="このガイドでは、OWL-ViT の使用方法を学習します。",vs,Z,It="<li>テキストプロンプトに基づいてオブジェクトを検出します</li> <li>バッチオブジェクト検出用</li> <li>画像誘導物体検出用</li>",Is,Q,$t="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",$s,V,ks,_,Rs,z,kt=`OWL-ViTによる推論を試す最も簡単な方法は、OWL-ViTを<a href="/docs/transformers/v4.40.0/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a>で使用することです。パイプラインをインスタンス化する
<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub のチェックポイント</a> からのゼロショット オブジェクト検出の場合:`,Zs,B,Qs,H,Rt=`次に、物体を検出したい画像を選択します。ここでは、宇宙飛行士アイリーン・コリンズの画像を使用します。
<a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images データセットの一部。`,Vs,N,_s,d,Zt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',zs,X,Qt=`検索する画像と候補オブジェクトのラベルをパイプラインに渡します。
ここでは画像を直接渡します。他の適切なオプションには、画像へのローカル パスまたは画像 URL が含まれます。また、画像をクエリするすべてのアイテムのテキスト説明も渡します。`,Bs,G,Hs,q,Vt="予測を視覚化してみましょう。",Ns,Y,Xs,J,_t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',Gs,E,qs,S,zt=`ゼロショット物体検出パイプラインの使用方法を確認したので、同じことを再現してみましょう。
手動で結果を取得します。`,Ys,F,Bt=`まず、<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub のチェックポイント</a> からモデルと関連プロセッサをロードします。
ここでは、前と同じチェックポイントを使用します。`,Es,L,Ss,A,Ht="気分を変えて、別の画像を撮ってみましょう。",Fs,D,Ls,U,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',As,P,Xt=`プロセッサを使用してモデルの入力を準備します。プロセッサーは、
サイズ変更と正規化によるモデルの画像と、テキスト入力を処理する <a href="/docs/transformers/v4.40.0/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> です。`,Ds,K,Ps,O,Gt=`入力をモデルに渡し、後処理し、結果を視覚化します。以前は画像プロセッサによって画像のサイズが変更されていたため、
それらをモデルにフィードするには、<code>post_process_object_detection()</code> メソッドを使用して、予測された境界を確認する必要があります。
ボックスは元の画像を基準とした正しい座標を持ちます。`,Ks,ss,Os,w,qt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',st,ts,tt,ls,Yt=`複数の画像セットとテキスト クエリを渡して、複数の画像内の異なる (または同じ) オブジェクトを検索できます。
宇宙飛行士の画像とビーチの画像を組み合わせてみましょう。
バッチ処理の場合、テキスト クエリをネストされたリストとしてプロセッサに渡し、画像を PIL イメージのリストとして渡す必要があります。
PyTorch テンソル、または NumPy 配列。`,lt,as,at,es,Et=`以前は後処理のために単一の画像のサイズをテンソルとして渡していましたが、タプルを渡すこともできます。
複数の画像のタプルのリスト。 2 つの例の予測を作成し、2 番目の例 (<code>image_idx = 1</code>) を視覚化しましょう。`,et,ns,nt,x,St='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',pt,ps,it,is,Ft=`テキストクエリによるゼロショットオブジェクト検出に加えて、OWL-ViTは画像ガイドによるオブジェクト検出を提供します。これはつまり
画像クエリを使用して、ターゲット画像内の類似したオブジェクトを検索できます。
テキスト クエリとは異なり、使用できるサンプル画像は 1 つだけです。`,ct,cs,Lt=`対象画像としてソファに2匹の猫がいる画像と、1匹の猫の画像を撮影しましょう
クエリとして:`,mt,ms,ot,os,At="画像を簡単に見てみましょう。",rt,rs,Mt,T,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',gt,Ms,Pt="前処理ステップでは、テキスト クエリの代わりに <code>query_images</code> を使用する必要があります。",ht,gs,jt,hs,Kt=`予測の場合、入力をモデルに渡す代わりに、<code>image_guided_detection()</code> に渡します。予測を描く
ラベルがないことを除いては以前と同様です。`,yt,js,ut,f,Ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',bt,ys,sl="OWL-ViTによる推論をインタラクティブに試したい場合は、このデモをチェックしてください。",dt,u,tl,Jt,bs,Ut;return C=new ds({props:{title:"Zero-shot object detection",local:"zero-shot-object-detection",headingTag:"h1"}}),W=new ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_object_detection.ipynb"}]}}),V=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),_=new ds({props:{title:"Zero-shot object detection pipeline",local:"zero-shot-object-detection-pipeline",headingTag:"h2"}}),B=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),N=new j({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),G=new j({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),Y=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new ds({props:{title:"Text-prompted zero-shot object detection by hand",local:"text-prompted-zero-shot-object-detection-by-hand",headingTag:"h2"}}),L=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),K=new j({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ss=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),ts=new ds({props:{title:"Batch processing",local:"batch-processing",headingTag:"h2"}}),as=new j({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ns=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),ps=new ds({props:{title:"Image-guided object detection",local:"image-guided-object-detection",headingTag:"h2"}}),ms=new j({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),rs=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),gs=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),js=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),{c(){b=p("meta"),Js=e(),us=p("p"),Us=e(),m(C.$$.fragment),ws=e(),m(W.$$.fragment),xs=e(),v=p("p"),v.innerHTML=Tt,Ts=e(),I=p("p"),I.innerHTML=ft,fs=e(),$=p("p"),$.innerHTML=Ct,Cs=e(),k=p("p"),k.textContent=Wt,Ws=e(),R=p("p"),R.textContent=vt,vs=e(),Z=p("ul"),Z.innerHTML=It,Is=e(),Q=p("p"),Q.textContent=$t,$s=e(),m(V.$$.fragment),ks=e(),m(_.$$.fragment),Rs=e(),z=p("p"),z.innerHTML=kt,Zs=e(),m(B.$$.fragment),Qs=e(),H=p("p"),H.innerHTML=Rt,Vs=e(),m(N.$$.fragment),_s=e(),d=p("div"),d.innerHTML=Zt,zs=e(),X=p("p"),X.textContent=Qt,Bs=e(),m(G.$$.fragment),Hs=e(),q=p("p"),q.textContent=Vt,Ns=e(),m(Y.$$.fragment),Xs=e(),J=p("div"),J.innerHTML=_t,Gs=e(),m(E.$$.fragment),qs=e(),S=p("p"),S.textContent=zt,Ys=e(),F=p("p"),F.innerHTML=Bt,Es=e(),m(L.$$.fragment),Ss=e(),A=p("p"),A.textContent=Ht,Fs=e(),m(D.$$.fragment),Ls=e(),U=p("div"),U.innerHTML=Nt,As=e(),P=p("p"),P.innerHTML=Xt,Ds=e(),m(K.$$.fragment),Ps=e(),O=p("p"),O.innerHTML=Gt,Ks=e(),m(ss.$$.fragment),Os=e(),w=p("div"),w.innerHTML=qt,st=e(),m(ts.$$.fragment),tt=e(),ls=p("p"),ls.textContent=Yt,lt=e(),m(as.$$.fragment),at=e(),es=p("p"),es.innerHTML=Et,et=e(),m(ns.$$.fragment),nt=e(),x=p("div"),x.innerHTML=St,pt=e(),m(ps.$$.fragment),it=e(),is=p("p"),is.textContent=Ft,ct=e(),cs=p("p"),cs.textContent=Lt,mt=e(),m(ms.$$.fragment),ot=e(),os=p("p"),os.textContent=At,rt=e(),m(rs.$$.fragment),Mt=e(),T=p("div"),T.innerHTML=Dt,gt=e(),Ms=p("p"),Ms.innerHTML=Pt,ht=e(),m(gs.$$.fragment),jt=e(),hs=p("p"),hs.innerHTML=Kt,yt=e(),m(js.$$.fragment),ut=e(),f=p("div"),f.innerHTML=Ot,bt=e(),ys=p("p"),ys.textContent=sl,dt=e(),u=p("iframe"),Jt=e(),bs=p("p"),this.h()},l(s){const t=cl("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),Js=n(s),us=i(s,"P",{}),wt(us).forEach(l),Us=n(s),o(C.$$.fragment,s),ws=n(s),o(W.$$.fragment,s),xs=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1jmn15x"&&(v.innerHTML=Tt),Ts=n(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-316ad1"&&(I.innerHTML=ft),fs=n(s),$=i(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-13iuwwr"&&($.innerHTML=Ct),Cs=n(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1o1n265"&&(k.textContent=Wt),Ws=n(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-nsc34w"&&(R.textContent=vt),vs=n(s),Z=i(s,"UL",{"data-svelte-h":!0}),c(Z)!=="svelte-v788np"&&(Z.innerHTML=It),Is=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1lya3k8"&&(Q.textContent=$t),$s=n(s),o(V.$$.fragment,s),ks=n(s),o(_.$$.fragment,s),Rs=n(s),z=i(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-j58kwl"&&(z.innerHTML=kt),Zs=n(s),o(B.$$.fragment,s),Qs=n(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-t24qb7"&&(H.innerHTML=Rt),Vs=n(s),o(N.$$.fragment,s),_s=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(d)!=="svelte-17qmfee"&&(d.innerHTML=Zt),zs=n(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1pcmuvb"&&(X.textContent=Qt),Bs=n(s),o(G.$$.fragment,s),Hs=n(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-3md4si"&&(q.textContent=Vt),Ns=n(s),o(Y.$$.fragment,s),Xs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(J)!=="svelte-1fwpqdn"&&(J.innerHTML=_t),Gs=n(s),o(E.$$.fragment,s),qs=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-fghste"&&(S.textContent=zt),Ys=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1faeuph"&&(F.innerHTML=Bt),Es=n(s),o(L.$$.fragment,s),Ss=n(s),A=i(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-vbbgku"&&(A.textContent=Ht),Fs=n(s),o(D.$$.fragment,s),Ls=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(U)!=="svelte-owux8y"&&(U.innerHTML=Nt),As=n(s),P=i(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1k4n0r2"&&(P.innerHTML=Xt),Ds=n(s),o(K.$$.fragment,s),Ps=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-v25fhy"&&(O.innerHTML=Gt),Ks=n(s),o(ss.$$.fragment,s),Os=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-1m863ar"&&(w.innerHTML=qt),st=n(s),o(ts.$$.fragment,s),tt=n(s),ls=i(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-1d0cvqy"&&(ls.textContent=Yt),lt=n(s),o(as.$$.fragment,s),at=n(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-7sl4ju"&&(es.innerHTML=Et),et=n(s),o(ns.$$.fragment,s),nt=n(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(x)!=="svelte-1m863ar"&&(x.innerHTML=St),pt=n(s),o(ps.$$.fragment,s),it=n(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-cpc5ya"&&(is.textContent=Ft),ct=n(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-16l357l"&&(cs.textContent=Lt),mt=n(s),o(ms.$$.fragment,s),ot=n(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-9k435k"&&(os.textContent=At),rt=n(s),o(rs.$$.fragment,s),Mt=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-y78yu"&&(T.innerHTML=Dt),gt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-1g2qd19"&&(Ms.innerHTML=Pt),ht=n(s),o(gs.$$.fragment,s),jt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-ccdvl"&&(hs.innerHTML=Kt),yt=n(s),o(js.$$.fragment,s),ut=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(f)!=="svelte-1f4dev0"&&(f.innerHTML=Ot),bt=n(s),ys=i(s,"P",{"data-svelte-h":!0}),c(ys)!=="svelte-1xcb9x7"&&(ys.textContent=sl),dt=n(s),u=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),wt(u).forEach(l),Jt=n(s),bs=i(s,"P",{}),wt(bs).forEach(l),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",Ml),y(d,"class","flex justify-center"),y(J,"class","flex justify-center"),y(U,"class","flex justify-center"),y(w,"class","flex justify-center"),y(x,"class","flex justify-center"),y(T,"class","flex justify-center"),y(f,"class","flex justify-center"),al(u.src,tl="https://adirik-owl-vit.hf.space")||y(u,"src",tl),y(u,"frameborder","0"),y(u,"width","850"),y(u,"height","450")},m(s,t){ml(document.head,b),a(s,Js,t),a(s,us,t),a(s,Us,t),r(C,s,t),a(s,ws,t),r(W,s,t),a(s,xs,t),a(s,v,t),a(s,Ts,t),a(s,I,t),a(s,fs,t),a(s,$,t),a(s,Cs,t),a(s,k,t),a(s,Ws,t),a(s,R,t),a(s,vs,t),a(s,Z,t),a(s,Is,t),a(s,Q,t),a(s,$s,t),r(V,s,t),a(s,ks,t),r(_,s,t),a(s,Rs,t),a(s,z,t),a(s,Zs,t),r(B,s,t),a(s,Qs,t),a(s,H,t),a(s,Vs,t),r(N,s,t),a(s,_s,t),a(s,d,t),a(s,zs,t),a(s,X,t),a(s,Bs,t),r(G,s,t),a(s,Hs,t),a(s,q,t),a(s,Ns,t),r(Y,s,t),a(s,Xs,t),a(s,J,t),a(s,Gs,t),r(E,s,t),a(s,qs,t),a(s,S,t),a(s,Ys,t),a(s,F,t),a(s,Es,t),r(L,s,t),a(s,Ss,t),a(s,A,t),a(s,Fs,t),r(D,s,t),a(s,Ls,t),a(s,U,t),a(s,As,t),a(s,P,t),a(s,Ds,t),r(K,s,t),a(s,Ps,t),a(s,O,t),a(s,Ks,t),r(ss,s,t),a(s,Os,t),a(s,w,t),a(s,st,t),r(ts,s,t),a(s,tt,t),a(s,ls,t),a(s,lt,t),r(as,s,t),a(s,at,t),a(s,es,t),a(s,et,t),r(ns,s,t),a(s,nt,t),a(s,x,t),a(s,pt,t),r(ps,s,t),a(s,it,t),a(s,is,t),a(s,ct,t),a(s,cs,t),a(s,mt,t),r(ms,s,t),a(s,ot,t),a(s,os,t),a(s,rt,t),r(rs,s,t),a(s,Mt,t),a(s,T,t),a(s,gt,t),a(s,Ms,t),a(s,ht,t),r(gs,s,t),a(s,jt,t),a(s,hs,t),a(s,yt,t),r(js,s,t),a(s,ut,t),a(s,f,t),a(s,bt,t),a(s,ys,t),a(s,dt,t),a(s,u,t),a(s,Jt,t),a(s,bs,t),Ut=!0},p:el,i(s){Ut||(M(C.$$.fragment,s),M(W.$$.fragment,s),M(V.$$.fragment,s),M(_.$$.fragment,s),M(B.$$.fragment,s),M(N.$$.fragment,s),M(G.$$.fragment,s),M(Y.$$.fragment,s),M(E.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(ms.$$.fragment,s),M(rs.$$.fragment,s),M(gs.$$.fragment,s),M(js.$$.fragment,s),Ut=!0)},o(s){g(C.$$.fragment,s),g(W.$$.fragment,s),g(V.$$.fragment,s),g(_.$$.fragment,s),g(B.$$.fragment,s),g(N.$$.fragment,s),g(G.$$.fragment,s),g(Y.$$.fragment,s),g(E.$$.fragment,s),g(L.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(ss.$$.fragment,s),g(ts.$$.fragment,s),g(as.$$.fragment,s),g(ns.$$.fragment,s),g(ps.$$.fragment,s),g(ms.$$.fragment,s),g(rs.$$.fragment,s),g(gs.$$.fragment,s),g(js.$$.fragment,s),Ut=!1},d(s){s&&(l(Js),l(us),l(Us),l(ws),l(xs),l(v),l(Ts),l(I),l(fs),l($),l(Cs),l(k),l(Ws),l(R),l(vs),l(Z),l(Is),l(Q),l($s),l(ks),l(Rs),l(z),l(Zs),l(Qs),l(H),l(Vs),l(_s),l(d),l(zs),l(X),l(Bs),l(Hs),l(q),l(Ns),l(Xs),l(J),l(Gs),l(qs),l(S),l(Ys),l(F),l(Es),l(Ss),l(A),l(Fs),l(Ls),l(U),l(As),l(P),l(Ds),l(Ps),l(O),l(Ks),l(Os),l(w),l(st),l(tt),l(ls),l(lt),l(at),l(es),l(et),l(nt),l(x),l(pt),l(it),l(is),l(ct),l(cs),l(mt),l(ot),l(os),l(rt),l(Mt),l(T),l(gt),l(Ms),l(ht),l(jt),l(hs),l(yt),l(ut),l(f),l(bt),l(ys),l(dt),l(u),l(Jt),l(bs)),l(b),h(C,s),h(W,s),h(V,s),h(_,s),h(B,s),h(N,s),h(G,s),h(Y,s),h(E,s),h(L,s),h(D,s),h(K,s),h(ss,s),h(ts,s),h(as,s),h(ns,s),h(ps,s),h(ms,s),h(rs,s),h(gs,s),h(js,s)}}}const Ml='{"title":"Zero-shot object detection","local":"zero-shot-object-detection","sections":[{"title":"Zero-shot object detection pipeline","local":"zero-shot-object-detection-pipeline","sections":[],"depth":2},{"title":"Text-prompted zero-shot object detection by hand","local":"text-prompted-zero-shot-object-detection-by-hand","sections":[],"depth":2},{"title":"Batch processing","local":"batch-processing","sections":[],"depth":2},{"title":"Image-guided object detection","local":"image-guided-object-detection","sections":[],"depth":2}],"depth":1}';function gl(xt){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends pl{constructor(b){super(),il(this,b,gl,rl,ll,{})}}export{dl as component};
