import{s as ta,n as na,o as aa}from"../chunks/scheduler.9039eef2.js";import{S as ra,i as oa,g as s,s as r,r as c,A as sa,h as l,f as n,c as o,j as w,u as m,x as d,k as y,l as la,y as i,a,v as h,d as g,t as u,w as T}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as v}from"../chunks/CodeBlock.8580f3e8.js";import{H as Z}from"../chunks/Heading.f027f30d.js";function ia(bn){let _,Xe,Ne,Qe,B,Se,q,_n='TRL supports the <a href="https://arxiv.org/abs/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',De,L,Mn='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',Ye,H,Ke,W,vn="Fine-tuning a language model via PPO consists of roughly three steps:",et,G,Jn="<li><strong>Rollout</strong>: The language model generates a response or continuation based on query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",tt,V,Pn="This process is illustrated in the sketch below:",nt,J,In='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png" width="800"/> <p style="text-align: center;"><b>Figure:</b> Sketch of the workflow.</p>',at,R,rt,A,$n="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",ot,N,xn="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",st,E,Un='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',lt,X,it,Q,jn="Resulting in the following subset of the dataset:",dt,S,pt,D,ct,Y,Cn='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',mt,K,ht,ee,kn="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",gt,te,ut,ne,zn="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",Tt,ae,ft,re,Fn="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",wt,oe,yt,se,On="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",bt,le,_t,ie,Zn="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",Mt,de,vt,pe,Jt,ce,Bn="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",Pt,me,qn='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',It,he,$t,ge,Ln="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",xt,ue,Ut,Te,jt,fe,Hn="While training and evaluating we log the following metrics:",Ct,we,Wn="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",kt,ye,zt,p,be,Qt,ze,Gn=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,St,P,_e,Dt,Fe,Vn="Calculate model outputs in multiple batches.",Yt,I,Me,Kt,Oe,Rn="Compute per token rewards from scores and KL-penalty.",en,$,ve,tn,Ze,An="Creates and saves a model card for a TRL model.",nn,x,Je,an,Be,Nn="Gather stats from all processes. Useful in the context of distributed training.",rn,U,Pe,on,qe,En=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,sn,j,Ie,ln,Le,Xn="A function that logs all the training stats. Call it at the end of each epoch.",dn,C,$e,pn,He,Qn="Calculate policy and value losses.",cn,k,xe,mn,We,Sn="Prepare the dataloader for training.",hn,z,Ue,gn,Ge,Dn="Record training step statistics.",un,F,je,Tn,Ve,Yn="Run a PPO optimisation step given a list of queries, model responses, and rewards.",fn,O,Ce,wn,Re,Kn="Train one PPO minibatch",Ft,M,ke,yn,Ae,ea="Configuration class for PPOTrainer",Ot,Ee,Zt;return B=new Z({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),H=new Z({props:{title:"How PPO works",local:"how-ppo-works",headingTag:"h2"}}),R=new Z({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),X=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),S=new v({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),D=new Z({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),K=new Z({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),te=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),ae=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),oe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),le=new v({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),de=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    dataset=dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),pe=new Z({props:{title:"Starting the training loop",local:"starting-the-training-loop",headingTag:"h3"}}),he=new v({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),ue=new v({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBJTBBZXBvY2hzJTIwJTNEJTIwMTAlMEFmb3IlMjBlcG9jaCUyMGluJTIwdHFkbShyYW5nZShlcG9jaHMpJTJDJTIwJTIyZXBvY2glM0ElMjAlMjIpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRxZG0ocHBvX3RyYWluZXIuZGF0YWxvYWRlciklM0ElMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV90ZW5zb3JzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjMlMjMlMjBHZXQlMjByZXNwb25zZSUyMGZyb20lMjBTRlRNb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbnNvcnMlMjAlM0QlMjBwcG9fdHJhaW5lci5nZW5lcmF0ZShxdWVyeV90ZW5zb3JzJTJDJTIwKipnZW5lcmF0aW9uX2t3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLmRlY29kZShyLnNxdWVlemUoKSklMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZV90ZW5zb3JzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwQ29tcHV0ZSUyMHJld2FyZCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwcmV3YXJkX21vZGVsKHRleHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMSU1RCU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMG91dHB1dCUyMGluJTIwcGlwZV9vdXRwdXRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwUnVuJTIwUFBPJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRzJTIwJTNEJTIwcHBvX3RyYWluZXIuc3RlcChxdWVyeV90ZW5zb3JzJTJDJTIwcmVzcG9uc2VfdGVuc29ycyUyQyUyMHJld2FyZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHBvX3RyYWluZXIubG9nX3N0YXRzKHN0YXRzJTJDJTIwYmF0Y2glMkMlMjByZXdhcmRzKSUwQSUwQSUyMyUyMyUyMyUyMyUyMFNhdmUlMjBtb2RlbCUwQXBwb190cmFpbmVyLnNhdmVfcHJldHJhaW5lZCglMjJteV9wcG9fbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm


epochs = <span class="hljs-number">10</span>
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(epochs), <span class="hljs-string">&quot;epoch: &quot;</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tqdm(ppo_trainer.dataloader): 
        query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
    
        <span class="hljs-comment">#### Get response from SFTModel</span>
        response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
        batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]
    
        <span class="hljs-comment">#### Compute reward score</span>
        texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
        pipe_outputs = reward_model(texts)
        rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]
    
        <span class="hljs-comment">#### Run PPO step</span>
        stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
        ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_pretrained(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),Te=new Z({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ye=new Z({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),be=new b({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L114"}}),_e=new b({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Me=new b({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1088",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ve=new b({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1396"}}),Je=new b({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L907",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Pe=new b({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Ie=new b({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1323"}}),$e=new b({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1170"}}),xe=new b({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Ue=new b({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1259",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),je=new b({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ce=new b({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1042",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),ke=new b({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),{c(){_=s("meta"),Xe=r(),Ne=s("p"),Qe=r(),c(B.$$.fragment),Se=r(),q=s("p"),q.innerHTML=_n,De=r(),L=s("p"),L.innerHTML=Mn,Ye=r(),c(H.$$.fragment),Ke=r(),W=s("p"),W.textContent=vn,et=r(),G=s("ol"),G.innerHTML=Jn,tt=r(),V=s("p"),V.textContent=Pn,nt=r(),J=s("div"),J.innerHTML=In,at=r(),c(R.$$.fragment),rt=r(),A=s("p"),A.innerHTML=$n,ot=r(),N=s("p"),N.innerHTML=xn,st=r(),E=s("p"),E.innerHTML=Un,lt=r(),c(X.$$.fragment),it=r(),Q=s("p"),Q.textContent=jn,dt=r(),c(S.$$.fragment),pt=r(),c(D.$$.fragment),ct=r(),Y=s("p"),Y.innerHTML=Cn,mt=r(),c(K.$$.fragment),ht=r(),ee=s("p"),ee.innerHTML=kn,gt=r(),c(te.$$.fragment),ut=r(),ne=s("p"),ne.textContent=zn,Tt=r(),c(ae.$$.fragment),ft=r(),re=s("p"),re.innerHTML=Fn,wt=r(),c(oe.$$.fragment),yt=r(),se=s("p"),se.innerHTML=On,bt=r(),c(le.$$.fragment),_t=r(),ie=s("p"),ie.innerHTML=Zn,Mt=r(),c(de.$$.fragment),vt=r(),c(pe.$$.fragment),Jt=r(),ce=s("p"),ce.innerHTML=Bn,Pt=r(),me=s("p"),me.innerHTML=qn,It=r(),c(he.$$.fragment),$t=r(),ge=s("p"),ge.innerHTML=Ln,xt=r(),c(ue.$$.fragment),Ut=r(),c(Te.$$.fragment),jt=r(),fe=s("p"),fe.textContent=Hn,Ct=r(),we=s("ul"),we.innerHTML=Wn,kt=r(),c(ye.$$.fragment),zt=r(),p=s("div"),c(be.$$.fragment),Qt=r(),ze=s("p"),ze.innerHTML=Gn,St=r(),P=s("div"),c(_e.$$.fragment),Dt=r(),Fe=s("p"),Fe.textContent=Vn,Yt=r(),I=s("div"),c(Me.$$.fragment),Kt=r(),Oe=s("p"),Oe.textContent=Rn,en=r(),$=s("div"),c(ve.$$.fragment),tn=r(),Ze=s("p"),Ze.textContent=An,nn=r(),x=s("div"),c(Je.$$.fragment),an=r(),Be=s("p"),Be.textContent=Nn,rn=r(),U=s("div"),c(Pe.$$.fragment),on=r(),qe=s("p"),qe.innerHTML=En,sn=r(),j=s("div"),c(Ie.$$.fragment),ln=r(),Le=s("p"),Le.textContent=Xn,dn=r(),C=s("div"),c($e.$$.fragment),pn=r(),He=s("p"),He.textContent=Qn,cn=r(),k=s("div"),c(xe.$$.fragment),mn=r(),We=s("p"),We.textContent=Sn,hn=r(),z=s("div"),c(Ue.$$.fragment),gn=r(),Ge=s("p"),Ge.textContent=Dn,un=r(),F=s("div"),c(je.$$.fragment),Tn=r(),Ve=s("p"),Ve.textContent=Yn,fn=r(),O=s("div"),c(Ce.$$.fragment),wn=r(),Re=s("p"),Re.textContent=Kn,Ft=r(),M=s("div"),c(ke.$$.fragment),yn=r(),Ae=s("p"),Ae.textContent=ea,Ot=r(),Ee=s("p"),this.h()},l(e){const t=sa("svelte-u9bgzb",document.head);_=l(t,"META",{name:!0,content:!0}),t.forEach(n),Xe=o(e),Ne=l(e,"P",{}),w(Ne).forEach(n),Qe=o(e),m(B.$$.fragment,e),Se=o(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1ulw62x"&&(q.innerHTML=_n),De=o(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1c2evbn"&&(L.innerHTML=Mn),Ye=o(e),m(H.$$.fragment,e),Ke=o(e),W=l(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-79li59"&&(W.textContent=vn),et=o(e),G=l(e,"OL",{"data-svelte-h":!0}),d(G)!=="svelte-19gvbbs"&&(G.innerHTML=Jn),tt=o(e),V=l(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-11407q1"&&(V.textContent=Pn),nt=o(e),J=l(e,"DIV",{style:!0,"data-svelte-h":!0}),d(J)!=="svelte-7jo56"&&(J.innerHTML=In),at=o(e),m(R.$$.fragment,e),rt=o(e),A=l(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-r47fon"&&(A.innerHTML=$n),ot=o(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-nw9p0e"&&(N.innerHTML=xn),st=o(e),E=l(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-ew3j45"&&(E.innerHTML=Un),lt=o(e),m(X.$$.fragment,e),it=o(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1lutirw"&&(Q.textContent=jn),dt=o(e),m(S.$$.fragment,e),pt=o(e),m(D.$$.fragment,e),ct=o(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-kuth75"&&(Y.innerHTML=Cn),mt=o(e),m(K.$$.fragment,e),ht=o(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-15i9f61"&&(ee.innerHTML=kn),gt=o(e),m(te.$$.fragment,e),ut=o(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-ft92fq"&&(ne.textContent=zn),Tt=o(e),m(ae.$$.fragment,e),ft=o(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-5saaij"&&(re.innerHTML=Fn),wt=o(e),m(oe.$$.fragment,e),yt=o(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1tdshp6"&&(se.innerHTML=On),bt=o(e),m(le.$$.fragment,e),_t=o(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1dqo05b"&&(ie.innerHTML=Zn),Mt=o(e),m(de.$$.fragment,e),vt=o(e),m(pe.$$.fragment,e),Jt=o(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1gfcgdl"&&(ce.innerHTML=Bn),Pt=o(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-xqje4x"&&(me.innerHTML=qn),It=o(e),m(he.$$.fragment,e),$t=o(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-jd50df"&&(ge.innerHTML=Ln),xt=o(e),m(ue.$$.fragment,e),Ut=o(e),m(Te.$$.fragment,e),jt=o(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1jybr47"&&(fe.textContent=Hn),Ct=o(e),we=l(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-1qs2o7q"&&(we.innerHTML=Wn),kt=o(e),m(ye.$$.fragment,e),zt=o(e),p=l(e,"DIV",{class:!0});var f=w(p);m(be.$$.fragment,f),Qt=o(f),ze=l(f,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-hys9rl"&&(ze.innerHTML=Gn),St=o(f),P=l(f,"DIV",{class:!0});var Bt=w(P);m(_e.$$.fragment,Bt),Dt=o(Bt),Fe=l(Bt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-185nst0"&&(Fe.textContent=Vn),Bt.forEach(n),Yt=o(f),I=l(f,"DIV",{class:!0});var qt=w(I);m(Me.$$.fragment,qt),Kt=o(qt),Oe=l(qt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-3nt516"&&(Oe.textContent=Rn),qt.forEach(n),en=o(f),$=l(f,"DIV",{class:!0});var Lt=w($);m(ve.$$.fragment,Lt),tn=o(Lt),Ze=l(Lt,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-3jfrz9"&&(Ze.textContent=An),Lt.forEach(n),nn=o(f),x=l(f,"DIV",{class:!0});var Ht=w(x);m(Je.$$.fragment,Ht),an=o(Ht),Be=l(Ht,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-lcc1u3"&&(Be.textContent=Nn),Ht.forEach(n),rn=o(f),U=l(f,"DIV",{class:!0});var Wt=w(U);m(Pe.$$.fragment,Wt),on=o(Wt),qe=l(Wt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1gqqzmu"&&(qe.innerHTML=En),Wt.forEach(n),sn=o(f),j=l(f,"DIV",{class:!0});var Gt=w(j);m(Ie.$$.fragment,Gt),ln=o(Gt),Le=l(Gt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-ffqz5"&&(Le.textContent=Xn),Gt.forEach(n),dn=o(f),C=l(f,"DIV",{class:!0});var Vt=w(C);m($e.$$.fragment,Vt),pn=o(Vt),He=l(Vt,"P",{"data-svelte-h":!0}),d(He)!=="svelte-febvhf"&&(He.textContent=Qn),Vt.forEach(n),cn=o(f),k=l(f,"DIV",{class:!0});var Rt=w(k);m(xe.$$.fragment,Rt),mn=o(Rt),We=l(Rt,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1hbodkw"&&(We.textContent=Sn),Rt.forEach(n),hn=o(f),z=l(f,"DIV",{class:!0});var At=w(z);m(Ue.$$.fragment,At),gn=o(At),Ge=l(At,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1hfgx92"&&(Ge.textContent=Dn),At.forEach(n),un=o(f),F=l(f,"DIV",{class:!0});var Nt=w(F);m(je.$$.fragment,Nt),Tn=o(Nt),Ve=l(Nt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-yrsdu6"&&(Ve.textContent=Yn),Nt.forEach(n),fn=o(f),O=l(f,"DIV",{class:!0});var Et=w(O);m(Ce.$$.fragment,Et),wn=o(Et),Re=l(Et,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-3k7k5e"&&(Re.textContent=Kn),Et.forEach(n),f.forEach(n),Ft=o(e),M=l(e,"DIV",{class:!0});var Xt=w(M);m(ke.$$.fragment,Xt),yn=o(Xt),Ae=l(Xt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-aondqr"&&(Ae.textContent=ea),Xt.forEach(n),Ot=o(e),Ee=l(e,"P",{}),w(Ee).forEach(n),this.h()},h(){y(_,"name","hf:doc:metadata"),y(_,"content",da),la(J,"text-align","center"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,_),a(e,Xe,t),a(e,Ne,t),a(e,Qe,t),h(B,e,t),a(e,Se,t),a(e,q,t),a(e,De,t),a(e,L,t),a(e,Ye,t),h(H,e,t),a(e,Ke,t),a(e,W,t),a(e,et,t),a(e,G,t),a(e,tt,t),a(e,V,t),a(e,nt,t),a(e,J,t),a(e,at,t),h(R,e,t),a(e,rt,t),a(e,A,t),a(e,ot,t),a(e,N,t),a(e,st,t),a(e,E,t),a(e,lt,t),h(X,e,t),a(e,it,t),a(e,Q,t),a(e,dt,t),h(S,e,t),a(e,pt,t),h(D,e,t),a(e,ct,t),a(e,Y,t),a(e,mt,t),h(K,e,t),a(e,ht,t),a(e,ee,t),a(e,gt,t),h(te,e,t),a(e,ut,t),a(e,ne,t),a(e,Tt,t),h(ae,e,t),a(e,ft,t),a(e,re,t),a(e,wt,t),h(oe,e,t),a(e,yt,t),a(e,se,t),a(e,bt,t),h(le,e,t),a(e,_t,t),a(e,ie,t),a(e,Mt,t),h(de,e,t),a(e,vt,t),h(pe,e,t),a(e,Jt,t),a(e,ce,t),a(e,Pt,t),a(e,me,t),a(e,It,t),h(he,e,t),a(e,$t,t),a(e,ge,t),a(e,xt,t),h(ue,e,t),a(e,Ut,t),h(Te,e,t),a(e,jt,t),a(e,fe,t),a(e,Ct,t),a(e,we,t),a(e,kt,t),h(ye,e,t),a(e,zt,t),a(e,p,t),h(be,p,null),i(p,Qt),i(p,ze),i(p,St),i(p,P),h(_e,P,null),i(P,Dt),i(P,Fe),i(p,Yt),i(p,I),h(Me,I,null),i(I,Kt),i(I,Oe),i(p,en),i(p,$),h(ve,$,null),i($,tn),i($,Ze),i(p,nn),i(p,x),h(Je,x,null),i(x,an),i(x,Be),i(p,rn),i(p,U),h(Pe,U,null),i(U,on),i(U,qe),i(p,sn),i(p,j),h(Ie,j,null),i(j,ln),i(j,Le),i(p,dn),i(p,C),h($e,C,null),i(C,pn),i(C,He),i(p,cn),i(p,k),h(xe,k,null),i(k,mn),i(k,We),i(p,hn),i(p,z),h(Ue,z,null),i(z,gn),i(z,Ge),i(p,un),i(p,F),h(je,F,null),i(F,Tn),i(F,Ve),i(p,fn),i(p,O),h(Ce,O,null),i(O,wn),i(O,Re),a(e,Ft,t),a(e,M,t),h(ke,M,null),i(M,yn),i(M,Ae),a(e,Ot,t),a(e,Ee,t),Zt=!0},p:na,i(e){Zt||(g(B.$$.fragment,e),g(H.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),Zt=!0)},o(e){u(B.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(Me.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(Pe.$$.fragment,e),u(Ie.$$.fragment,e),u($e.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),Zt=!1},d(e){e&&(n(Xe),n(Ne),n(Qe),n(Se),n(q),n(De),n(L),n(Ye),n(Ke),n(W),n(et),n(G),n(tt),n(V),n(nt),n(J),n(at),n(rt),n(A),n(ot),n(N),n(st),n(E),n(lt),n(it),n(Q),n(dt),n(pt),n(ct),n(Y),n(mt),n(ht),n(ee),n(gt),n(ut),n(ne),n(Tt),n(ft),n(re),n(wt),n(yt),n(se),n(bt),n(_t),n(ie),n(Mt),n(vt),n(Jt),n(ce),n(Pt),n(me),n(It),n($t),n(ge),n(xt),n(Ut),n(jt),n(fe),n(Ct),n(we),n(kt),n(zt),n(p),n(Ft),n(M),n(Ot),n(Ee)),n(_),T(B,e),T(H,e),T(R,e),T(X,e),T(S,e),T(D,e),T(K,e),T(te,e),T(ae,e),T(oe,e),T(le,e),T(de,e),T(pe,e),T(he,e),T(ue,e),T(Te,e),T(ye,e),T(be),T(_e),T(Me),T(ve),T(Je),T(Pe),T(Ie),T($e),T(xe),T(Ue),T(je),T(Ce),T(ke)}}}const da='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"How PPO works","local":"how-ppo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3},{"title":"Starting the training loop","local":"starting-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2}],"depth":1}';function pa(bn){return aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends ra{constructor(_){super(),oa(this,_,pa,ia,ta,{})}}export{Ta as component};
