import{s as Mo,f as yo,o as wo,n as vt}from"../chunks/scheduler.9bc65507.js";import{S as Co,i as ko,g as a,s as r,r as h,A as Ro,h as i,f as o,c as s,j as J,u as f,x as m,k,y as d,a as n,v as u,d as g,t as _,w as T}from"../chunks/index.707bf1b6.js";import{T as To}from"../chunks/Tip.c2ecdbf4.js";import{D as I}from"../chunks/Docstring.17db21ae.js";import{C as Ht}from"../chunks/CodeBlock.54a9f38d.js";import{E as bo}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as vo}from"../chunks/PipelineTag.44585822.js";import{H as X}from"../chunks/Heading.342b1fa6.js";function $o(x){let l,w="Example:",p,b,y;return b=new Ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyT0NSQ29uZmlnJTJDJTIwVHJPQ1JGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBUck9DUi1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFRyT0NSQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMFRyT0NSLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFRyT0NSRm9yQ2F1c2FsTE0oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrOCRConfig, TrOCRForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a TrOCR-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TrOCRConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the TrOCR-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TrOCRForCausalLM(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=w,p=r(),h(b.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=w),p=s(c),f(b.$$.fragment,c)},m(c,C){n(c,l,C),n(c,p,C),u(b,c,C),y=!0},p:vt,i(c){y||(g(b.$$.fragment,c),y=!0)},o(c){_(b.$$.fragment,c),y=!1},d(c){c&&(o(l),o(p)),T(b,c)}}}function jo(x){let l,w=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.37.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.37.1/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=a("p"),l.innerHTML=w},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1gid721"&&(l.innerHTML=w)},m(p,b){n(p,l,b)},p:vt,d(p){p&&o(l)}}}function Jo(x){let l,w=`This class method is simply calling <a href="/docs/transformers/v4.37.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=a("p"),l.innerHTML=w},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1tltf6i"&&(l.innerHTML=w)},m(p,b){n(p,l,b)},p:vt,d(p){p&&o(l)}}}function xo(x){let l,w="Example:",p,b,y;return b=new Ht({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    TrOCRConfig,
<span class="hljs-meta">... </span>    TrOCRProcessor,
<span class="hljs-meta">... </span>    TrOCRForCausalLM,
<span class="hljs-meta">... </span>    ViTConfig,
<span class="hljs-meta">... </span>    ViTModel,
<span class="hljs-meta">... </span>    VisionEncoderDecoderModel,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># TrOCR is a decoder model and should be used within a VisionEncoderDecoderModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init vision2text model with random weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = ViTModel(ViTConfig())
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = TrOCRForCausalLM(TrOCRConfig())
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel(encoder=encoder, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want to start from the pretrained model, load the checkpoint with \`VisionEncoderDecoderModel\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TrOCRProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image from the IAM dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://fki.tic.heia-fr.ch/static/img/a01-122-02.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;industry, &#x27; Mr. Brown commented icily. &#x27; Let us have a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = processor.tokenizer.cls_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = processor.tokenizer.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.vocab_size = model.config.decoder.vocab_size

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor.tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">5.30</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(pixel_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;industry, &quot; Mr. Brown commented icily. &quot; Let us have a&#x27;</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=w,p=r(),h(b.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=w),p=s(c),f(b.$$.fragment,c)},m(c,C){n(c,l,C),n(c,p,C),u(b,c,C),y=!0},p:vt,i(c){y||(g(b.$$.fragment,c),y=!0)},o(c){_(b.$$.fragment,c),y=!1},d(c){c&&(o(l),o(p)),T(b,c)}}}function Zo(x){let l,w,p,b,y,c,C,Pe,G,Nt=`The TrOCR model was proposed in <a href="https://arxiv.org/abs/2109.10282" rel="nofollow">TrOCR: Transformer-based Optical Character Recognition with Pre-trained
Models</a> by Minghao Li, Tengchao Lv, Lei Cui, Yijuan Lu, Dinei Florencio, Cha Zhang,
Zhoujun Li, Furu Wei. TrOCR consists of an image Transformer encoder and an autoregressive text Transformer decoder to
perform <a href="https://en.wikipedia.org/wiki/Optical_character_recognition" rel="nofollow">optical character recognition (OCR)</a>.`,Be,S,Et="The abstract from the paper is the following:",He,Y,Xt=`<em>Text recognition is a long-standing research problem for document digitalization. Existing approaches for text recognition
are usually built based on CNN for image understanding and RNN for char-level text generation. In addition, another language
model is usually needed to improve the overall accuracy as a post-processing step. In this paper, we propose an end-to-end
text recognition approach with pre-trained image Transformer and text Transformer models, namely TrOCR, which leverages the
Transformer architecture for both image understanding and wordpiece-level text generation. The TrOCR model is simple but
effective, and can be pre-trained with large-scale synthetic data and fine-tuned with human-labeled datasets. Experiments
show that the TrOCR model outperforms the current state-of-the-art models on both printed and handwritten text recognition
tasks.</em>`,Ne,W,Gt,Ee,q,St='TrOCR architecture. Taken from the <a href="https://arxiv.org/abs/2109.10282">original paper</a>.',Xe,Q,Yt="Please refer to the <code>VisionEncoderDecoder</code> class on how to use this model.",Ge,D,qt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/microsoft/unilm/tree/6f60612e7cc86a2a1ae85c47231507a587ab4e01/trocr" rel="nofollow">here</a>.`,Se,A,Ye,K,Qt=`<li>The quickest way to get started with TrOCR is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/TrOCR" rel="nofollow">tutorial
notebooks</a>, which show how to use the model
at inference time as well as fine-tuning on custom data.</li> <li>TrOCR is pre-trained in 2 stages before being fine-tuned on downstream datasets. It achieves state-of-the-art results
on both printed (e.g. the <a href="https://paperswithcode.com/dataset/sroie" rel="nofollow">SROIE dataset</a> and handwritten (e.g. the <a href="https://fki.tic.heia-fr.ch/databases/iam-handwriting-database%3E" rel="nofollow">IAM
Handwriting dataset</a> text recognition tasks. For more
information, see the <a href="https://huggingface.co/models?other=trocr%3E" rel="nofollow">official models</a>.</li> <li>TrOCR is always used within the <a href="vision-encoder-decoder">VisionEncoderDecoder</a> framework.</li>`,qe,ee,Qe,te,Dt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with TrOCR. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",De,oe,Ae,ne,At='<li>A blog post on <a href="https://huggingface.co/blog/document-ai" rel="nofollow">Accelerating Document AI</a> with TrOCR.</li> <li>A blog post on how to <a href="https://github.com/philschmid/document-ai-transformers" rel="nofollow">Document AI</a> with TrOCR.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Fine_tune_TrOCR_on_IAM_Handwriting_Database_using_Seq2SeqTrainer.ipynb" rel="nofollow">finetune TrOCR on IAM Handwriting Database using Seq2SeqTrainer</a>.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Inference_with_TrOCR_%2B_Gradio_demo.ipynb" rel="nofollow">inference with TrOCR</a> and Gradio demo.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Fine_tune_TrOCR_on_IAM_Handwriting_Database_using_native_PyTorch.ipynb" rel="nofollow">finetune TrOCR on the IAM Handwriting Database</a> using native PyTorch.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Evaluating_TrOCR_base_handwritten_on_the_IAM_test_set.ipynb" rel="nofollow">evaluating TrOCR on the IAM test set</a>.</li>',Ke,re,et,se,Kt='<li><a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Casual language modeling</a> task guide.</li>',tt,ae,eo="⚡️ Inference",ot,ie,to='<li>An interactive-demo on <a href="https://huggingface.co/spaces/nielsr/TrOCR-handwritten" rel="nofollow">TrOCR handwritten character recognition</a>.</li>',nt,le,rt,de,oo=`TrOCR’s <code>VisionEncoderDecoder</code> model accepts images as input and makes use of
<a href="/docs/transformers/v4.37.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to autoregressively generate text given the input image.`,st,ce,no=`The [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] class is responsible for preprocessing the input image and
[<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>] decodes the generated target tokens to the target string. The
<a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> wraps [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] and [<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]
into a single instance to both extract the input features and decode the predicted token ids.`,at,me,ro="<li>Step-by-step Optical Character Recognition (OCR)</li>",it,pe,lt,he,so='See the <a href="https://huggingface.co/models?filter=trocr" rel="nofollow">model hub</a> to look for TrOCR checkpoints.',dt,fe,ct,R,ue,Mt,$e,ao=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a>. It is used to instantiate an
TrOCR model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the TrOCR
<a href="https://huggingface.co/microsoft/trocr-base-handwritten" rel="nofollow">microsoft/trocr-base-handwritten</a> architecture.`,yt,je,io=`Configuration objects inherit from <a href="/docs/transformers/v4.37.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.37.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,wt,L,mt,ge,pt,v,_e,Ct,Je,lo="Constructs a TrOCR processor which wraps a vision image processor and a TrOCR tokenizer into a single processor.",kt,xe,co=`<a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> offers all the functionalities of [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] and
[<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]. See the <a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRProcessor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRProcessor.decode">decode()</a> for
more information.`,Rt,z,Te,$t,Ze,mo=`When used in normal mode, this method forwards all its arguments to AutoImageProcessor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to TrOCRTokenizer’s
<code>~TrOCRTokenizer.__call__</code>. Please refer to the doctsring of the above two methods for more information.`,jt,Z,be,Jt,Oe,po="Instantiate a processor associated with a pretrained model.",xt,F,Zt,O,ve,Ot,Ue,ho=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.37.1/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Ut,V,It,P,Me,Wt,Ie,fo=`This method forwards all its arguments to TrOCRTokenizer’s <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer
to the docstring of this method for more information.`,Lt,B,ye,zt,We,uo=`This method forwards all its arguments to TrOCRTokenizer’s <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,ht,we,ft,$,Ce,Ft,Le,go=`The TrOCR Decoder with a language modeling head. Can be used as the decoder part of <a href="/docs/transformers/v4.37.1/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> and <code>VisionEncoderDecoder</code>.
This model inherits from <a href="/docs/transformers/v4.37.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vt,ze,_o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,H,ke,Bt,N,ut,Ve,gt;return y=new X({props:{title:"TrOCR",local:"trocr",headingTag:"h1"}}),C=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new X({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ee=new X({props:{title:"Resources",local:"resources",headingTag:"h2"}}),oe=new vo({props:{pipeline:"text-classification"}}),re=new vo({props:{pipeline:"text-generation"}}),le=new X({props:{title:"Inference",local:"inference",headingTag:"h2"}}),pe=new Ht({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyT0NSUHJvY2Vzc29yJTJDJTIwVmlzaW9uRW5jb2RlckRlY29kZXJNb2RlbCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwVHJPQ1JQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnRyb2NyLWJhc2UtaGFuZHdyaXR0ZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBWaXNpb25FbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0cm9jci1iYXNlLWhhbmR3cml0dGVuJTIyKSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMGZyb20lMjB0aGUlMjBJQU0lMjBkYXRhc2V0JTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZma2kudGljLmhlaWEtZnIuY2glMkZzdGF0aWMlMkZpbWclMkZhMDEtMTIyLTAyLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUocGl4ZWxfdmFsdWVzKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrOCRProcessor, VisionEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TrOCRProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image from the IAM dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://fki.tic.heia-fr.ch/static/img/a01-122-02.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(pixel_values)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),fe=new X({props:{title:"TrOCRConfig",local:"transformers.TrOCRConfig",headingTag:"h2"}}),ue=new I({props:{name:"class transformers.TrOCRConfig",anchor:"transformers.TrOCRConfig",parameters:[{name:"vocab_size",val:" = 50265"},{name:"d_model",val:" = 1024"},{name:"decoder_layers",val:" = 12"},{name:"decoder_attention_heads",val:" = 16"},{name:"decoder_ffn_dim",val:" = 4096"},{name:"activation_function",val:" = 'gelu'"},{name:"max_position_embeddings",val:" = 512"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"decoder_start_token_id",val:" = 2"},{name:"init_std",val:" = 0.02"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"scale_embedding",val:" = False"},{name:"use_learned_position_embeddings",val:" = True"},{name:"layernorm_embedding",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50265) &#x2014;
Vocabulary size of the TrOCR model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a>.`,name:"vocab_size"},{anchor:"transformers.TrOCRConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.TrOCRConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.TrOCRConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.TrOCRConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.TrOCRConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the pooler. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.TrOCRConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TrOCRConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, and pooler.`,name:"dropout"},{anchor:"transformers.TrOCRConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.TrOCRConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.TrOCRConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.TrOCRConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.TrOCRConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.TrOCRConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the word embeddings by sqrt(d_model).`,name:"scale_embedding"},{anchor:"transformers.TrOCRConfig.use_learned_position_embeddings",description:`<strong>use_learned_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use learned position embeddings. If not, sinusoidal position embeddings will be used.`,name:"use_learned_position_embeddings"},{anchor:"transformers.TrOCRConfig.layernorm_embedding",description:`<strong>layernorm_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use a layernorm after the word + position embeddings.`,name:"layernorm_embedding"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/configuration_trocr.py#L31"}}),L=new bo({props:{anchor:"transformers.TrOCRConfig.example",$$slots:{default:[$o]},$$scope:{ctx:x}}}),ge=new X({props:{title:"TrOCRProcessor",local:"transformers.TrOCRProcessor",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.TrOCRProcessor",anchor:"transformers.TrOCRProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.image_processor",description:`<strong>image_processor</strong> ([<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>], <em>optional</em>) &#x2014;
An instance of [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>]. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.TrOCRProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>], <em>optional</em>) &#x2014;
An instance of [<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/processing_trocr.py#L24"}}),Te=new I({props:{name:"__call__",anchor:"transformers.TrOCRProcessor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/processing_trocr.py#L63"}}),be=new I({props:{name:"from_pretrained",anchor:"transformers.TrOCRProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.37.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.37.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/processing_utils.py#L406"}}),F=new To({props:{$$slots:{default:[jo]},$$scope:{ctx:x}}}),ve=new I({props:{name:"save_pretrained",anchor:"transformers.TrOCRProcessor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.TrOCRProcessor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.TrOCRProcessor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/processing_utils.py#L167"}}),V=new To({props:{$$slots:{default:[Jo]},$$scope:{ctx:x}}}),Me=new I({props:{name:"batch_decode",anchor:"transformers.TrOCRProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/processing_trocr.py#L96"}}),ye=new I({props:{name:"decode",anchor:"transformers.TrOCRProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/processing_trocr.py#L103"}}),we=new X({props:{title:"TrOCRForCausalLM",local:"transformers.TrOCRForCausalLM",headingTag:"h2"}}),Ce=new I({props:{name:"class transformers.TrOCRForCausalLM",anchor:"transformers.TrOCRForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TrOCRForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.37.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/modeling_trocr.py#L724"}}),ke=new I({props:{name:"forward",anchor:"transformers.TrOCRForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TrOCRForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TrOCRForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.TrOCRForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TrOCRForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.TrOCRForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.TrOCRForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TrOCRForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.TrOCRForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.37.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.37.1/src/transformers/models/trocr/modeling_trocr.py#L762",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.37.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.37.1/en/model_doc/trocr#transformers.TrOCRConfig"
>TrOCRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.37.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new bo({props:{anchor:"transformers.TrOCRForCausalLM.forward.example",$$slots:{default:[xo]},$$scope:{ctx:x}}}),{c(){l=a("meta"),w=r(),p=a("p"),b=r(),h(y.$$.fragment),c=r(),h(C.$$.fragment),Pe=r(),G=a("p"),G.innerHTML=Nt,Be=r(),S=a("p"),S.textContent=Et,He=r(),Y=a("p"),Y.innerHTML=Xt,Ne=r(),W=a("img"),Ee=r(),q=a("small"),q.innerHTML=St,Xe=r(),Q=a("p"),Q.innerHTML=Yt,Ge=r(),D=a("p"),D.innerHTML=qt,Se=r(),h(A.$$.fragment),Ye=r(),K=a("ul"),K.innerHTML=Qt,qe=r(),h(ee.$$.fragment),Qe=r(),te=a("p"),te.textContent=Dt,De=r(),h(oe.$$.fragment),Ae=r(),ne=a("ul"),ne.innerHTML=At,Ke=r(),h(re.$$.fragment),et=r(),se=a("ul"),se.innerHTML=Kt,tt=r(),ae=a("p"),ae.textContent=eo,ot=r(),ie=a("ul"),ie.innerHTML=to,nt=r(),h(le.$$.fragment),rt=r(),de=a("p"),de.innerHTML=oo,st=r(),ce=a("p"),ce.innerHTML=no,at=r(),me=a("ul"),me.innerHTML=ro,it=r(),h(pe.$$.fragment),lt=r(),he=a("p"),he.innerHTML=so,dt=r(),h(fe.$$.fragment),ct=r(),R=a("div"),h(ue.$$.fragment),Mt=r(),$e=a("p"),$e.innerHTML=ao,yt=r(),je=a("p"),je.innerHTML=io,wt=r(),h(L.$$.fragment),mt=r(),h(ge.$$.fragment),pt=r(),v=a("div"),h(_e.$$.fragment),Ct=r(),Je=a("p"),Je.textContent=lo,kt=r(),xe=a("p"),xe.innerHTML=co,Rt=r(),z=a("div"),h(Te.$$.fragment),$t=r(),Ze=a("p"),Ze.innerHTML=mo,jt=r(),Z=a("div"),h(be.$$.fragment),Jt=r(),Oe=a("p"),Oe.textContent=po,xt=r(),h(F.$$.fragment),Zt=r(),O=a("div"),h(ve.$$.fragment),Ot=r(),Ue=a("p"),Ue.innerHTML=ho,Ut=r(),h(V.$$.fragment),It=r(),P=a("div"),h(Me.$$.fragment),Wt=r(),Ie=a("p"),Ie.innerHTML=fo,Lt=r(),B=a("div"),h(ye.$$.fragment),zt=r(),We=a("p"),We.innerHTML=uo,ht=r(),h(we.$$.fragment),ft=r(),$=a("div"),h(Ce.$$.fragment),Ft=r(),Le=a("p"),Le.innerHTML=go,Vt=r(),ze=a("p"),ze.innerHTML=_o,Pt=r(),H=a("div"),h(ke.$$.fragment),Bt=r(),h(N.$$.fragment),ut=r(),Ve=a("p"),this.h()},l(e){const t=Ro("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),w=s(e),p=i(e,"P",{}),J(p).forEach(o),b=s(e),f(y.$$.fragment,e),c=s(e),f(C.$$.fragment,e),Pe=s(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1ueqt35"&&(G.innerHTML=Nt),Be=s(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-vfdo9a"&&(S.textContent=Et),He=s(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-u8sjcw"&&(Y.innerHTML=Xt),Ne=s(e),W=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ee=s(e),q=i(e,"SMALL",{"data-svelte-h":!0}),m(q)!=="svelte-745sv3"&&(q.innerHTML=St),Xe=s(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1qnnowp"&&(Q.innerHTML=Yt),Ge=s(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-38zca0"&&(D.innerHTML=qt),Se=s(e),f(A.$$.fragment,e),Ye=s(e),K=i(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-10xobs4"&&(K.innerHTML=Qt),qe=s(e),f(ee.$$.fragment,e),Qe=s(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-j67pez"&&(te.textContent=Dt),De=s(e),f(oe.$$.fragment,e),Ae=s(e),ne=i(e,"UL",{"data-svelte-h":!0}),m(ne)!=="svelte-14fopzs"&&(ne.innerHTML=At),Ke=s(e),f(re.$$.fragment,e),et=s(e),se=i(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-1k3rqn7"&&(se.innerHTML=Kt),tt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1wntqpp"&&(ae.textContent=eo),ot=s(e),ie=i(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-16d3ard"&&(ie.innerHTML=to),nt=s(e),f(le.$$.fragment,e),rt=s(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-4118sh"&&(de.innerHTML=oo),st=s(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-funz3v"&&(ce.innerHTML=no),at=s(e),me=i(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-1noonjl"&&(me.innerHTML=ro),it=s(e),f(pe.$$.fragment,e),lt=s(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1iv4swp"&&(he.innerHTML=so),dt=s(e),f(fe.$$.fragment,e),ct=s(e),R=i(e,"DIV",{class:!0});var j=J(R);f(ue.$$.fragment,j),Mt=s(j),$e=i(j,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1tnv86r"&&($e.innerHTML=ao),yt=s(j),je=i(j,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1chy751"&&(je.innerHTML=io),wt=s(j),f(L.$$.fragment,j),j.forEach(o),mt=s(e),f(ge.$$.fragment,e),pt=s(e),v=i(e,"DIV",{class:!0});var M=J(v);f(_e.$$.fragment,M),Ct=s(M),Je=i(M,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-ndaubh"&&(Je.textContent=lo),kt=s(M),xe=i(M,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-11awti1"&&(xe.innerHTML=co),Rt=s(M),z=i(M,"DIV",{class:!0});var Re=J(z);f(Te.$$.fragment,Re),$t=s(Re),Ze=i(Re,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-9cxgu"&&(Ze.innerHTML=mo),Re.forEach(o),jt=s(M),Z=i(M,"DIV",{class:!0});var U=J(Z);f(be.$$.fragment,U),Jt=s(U),Oe=i(U,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1cj8dcb"&&(Oe.textContent=po),xt=s(U),f(F.$$.fragment,U),U.forEach(o),Zt=s(M),O=i(M,"DIV",{class:!0});var Fe=J(O);f(ve.$$.fragment,Fe),Ot=s(Fe),Ue=i(Fe,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-g21n2l"&&(Ue.innerHTML=ho),Ut=s(Fe),f(V.$$.fragment,Fe),Fe.forEach(o),It=s(M),P=i(M,"DIV",{class:!0});var _t=J(P);f(Me.$$.fragment,_t),Wt=s(_t),Ie=i(_t,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-117iph9"&&(Ie.innerHTML=fo),_t.forEach(o),Lt=s(M),B=i(M,"DIV",{class:!0});var Tt=J(B);f(ye.$$.fragment,Tt),zt=s(Tt),We=i(Tt,"P",{"data-svelte-h":!0}),m(We)!=="svelte-sxrrof"&&(We.innerHTML=uo),Tt.forEach(o),M.forEach(o),ht=s(e),f(we.$$.fragment,e),ft=s(e),$=i(e,"DIV",{class:!0});var E=J($);f(Ce.$$.fragment,E),Ft=s(E),Le=i(E,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-nwlpcs"&&(Le.innerHTML=go),Vt=s(E),ze=i(E,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-hswkmf"&&(ze.innerHTML=_o),Pt=s(E),H=i(E,"DIV",{class:!0});var bt=J(H);f(ke.$$.fragment,bt),Bt=s(bt),f(N.$$.fragment,bt),bt.forEach(o),E.forEach(o),ut=s(e),Ve=i(e,"P",{}),J(Ve).forEach(o),this.h()},h(){k(l,"name","hf:doc:metadata"),k(l,"content",Oo),yo(W.src,Gt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/trocr_architecture.jpg")||k(W,"src",Gt),k(W,"alt","drawing"),k(W,"width","600"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),n(e,w,t),n(e,p,t),n(e,b,t),u(y,e,t),n(e,c,t),u(C,e,t),n(e,Pe,t),n(e,G,t),n(e,Be,t),n(e,S,t),n(e,He,t),n(e,Y,t),n(e,Ne,t),n(e,W,t),n(e,Ee,t),n(e,q,t),n(e,Xe,t),n(e,Q,t),n(e,Ge,t),n(e,D,t),n(e,Se,t),u(A,e,t),n(e,Ye,t),n(e,K,t),n(e,qe,t),u(ee,e,t),n(e,Qe,t),n(e,te,t),n(e,De,t),u(oe,e,t),n(e,Ae,t),n(e,ne,t),n(e,Ke,t),u(re,e,t),n(e,et,t),n(e,se,t),n(e,tt,t),n(e,ae,t),n(e,ot,t),n(e,ie,t),n(e,nt,t),u(le,e,t),n(e,rt,t),n(e,de,t),n(e,st,t),n(e,ce,t),n(e,at,t),n(e,me,t),n(e,it,t),u(pe,e,t),n(e,lt,t),n(e,he,t),n(e,dt,t),u(fe,e,t),n(e,ct,t),n(e,R,t),u(ue,R,null),d(R,Mt),d(R,$e),d(R,yt),d(R,je),d(R,wt),u(L,R,null),n(e,mt,t),u(ge,e,t),n(e,pt,t),n(e,v,t),u(_e,v,null),d(v,Ct),d(v,Je),d(v,kt),d(v,xe),d(v,Rt),d(v,z),u(Te,z,null),d(z,$t),d(z,Ze),d(v,jt),d(v,Z),u(be,Z,null),d(Z,Jt),d(Z,Oe),d(Z,xt),u(F,Z,null),d(v,Zt),d(v,O),u(ve,O,null),d(O,Ot),d(O,Ue),d(O,Ut),u(V,O,null),d(v,It),d(v,P),u(Me,P,null),d(P,Wt),d(P,Ie),d(v,Lt),d(v,B),u(ye,B,null),d(B,zt),d(B,We),n(e,ht,t),u(we,e,t),n(e,ft,t),n(e,$,t),u(Ce,$,null),d($,Ft),d($,Le),d($,Vt),d($,ze),d($,Pt),d($,H),u(ke,H,null),d(H,Bt),u(N,H,null),n(e,ut,t),n(e,Ve,t),gt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),L.$set(j);const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),F.$set(M);const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),V.$set(Re);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),N.$set(U)},i(e){gt||(g(y.$$.fragment,e),g(C.$$.fragment,e),g(A.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(L.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(F.$$.fragment,e),g(ve.$$.fragment,e),g(V.$$.fragment,e),g(Me.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(N.$$.fragment,e),gt=!0)},o(e){_(y.$$.fragment,e),_(C.$$.fragment,e),_(A.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(L.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(F.$$.fragment,e),_(ve.$$.fragment,e),_(V.$$.fragment,e),_(Me.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(Ce.$$.fragment,e),_(ke.$$.fragment,e),_(N.$$.fragment,e),gt=!1},d(e){e&&(o(w),o(p),o(b),o(c),o(Pe),o(G),o(Be),o(S),o(He),o(Y),o(Ne),o(W),o(Ee),o(q),o(Xe),o(Q),o(Ge),o(D),o(Se),o(Ye),o(K),o(qe),o(Qe),o(te),o(De),o(Ae),o(ne),o(Ke),o(et),o(se),o(tt),o(ae),o(ot),o(ie),o(nt),o(rt),o(de),o(st),o(ce),o(at),o(me),o(it),o(lt),o(he),o(dt),o(ct),o(R),o(mt),o(pt),o(v),o(ht),o(ft),o($),o(ut),o(Ve)),o(l),T(y,e),T(C,e),T(A,e),T(ee,e),T(oe,e),T(re,e),T(le,e),T(pe,e),T(fe,e),T(ue),T(L),T(ge,e),T(_e),T(Te),T(be),T(F),T(ve),T(V),T(Me),T(ye),T(we,e),T(Ce),T(ke),T(N)}}}const Oo='{"title":"TrOCR","local":"trocr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"TrOCRConfig","local":"transformers.TrOCRConfig","sections":[],"depth":2},{"title":"TrOCRProcessor","local":"transformers.TrOCRProcessor","sections":[],"depth":2},{"title":"TrOCRForCausalLM","local":"transformers.TrOCRForCausalLM","sections":[],"depth":2}],"depth":1}';function Uo(x){return wo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends Co{constructor(l){super(),ko(this,l,Uo,Zo,Mo,{})}}export{Ho as component};
