import{s as Ta,o as Ca,n as jt}from"../chunks/scheduler.9991993c.js";import{S as Pa,i as Ua,g as l,s,r as c,A as Ia,h as i,f as t,c as a,j as x,u as f,x as d,k as b,y as n,a as o,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as Is}from"../chunks/Tip.9de92fc6.js";import{D as w}from"../chunks/Docstring.8180f571.js";import{C as Et}from"../chunks/CodeBlock.e11cba92.js";import{E as Xs}from"../chunks/ExampleCodeBlock.a03fccd6.js";import{H as ie}from"../chunks/Heading.e3de321f.js";function Xa(Z){let m,y=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){m=l("p"),m.innerHTML=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-1numcrz"&&(m.innerHTML=y)},m(v,$){o(v,m,$)},p:jt,d(v){v&&t(m)}}}function Za(Z){let m,y="Examples:",v,$,M;return $=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBcHJvY2Vzc29yLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwcm9jZXNzb3IlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=s(),c($.$$.fragment)},l(p){m=i(p,"P",{"data-svelte-h":!0}),d(m)!=="svelte-kvfsh7"&&(m.textContent=y),v=a(p),f($.$$.fragment,p)},m(p,C){o(p,m,C),o(p,v,C),u($,p,C),M=!0},p:jt,i(p){M||(h($.$$.fragment,p),M=!0)},o(p){g($.$$.fragment,p),M=!1},d(p){p&&(t(m),t(v)),_($,p)}}}function ka(Z){let m,y="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){m=l("p"),m.textContent=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-15rpg4"&&(m.textContent=y)},m(v,$){o(v,m,$)},p:jt,d(v){v&&t(m)}}}function Ja(Z){let m,y=`This class method is simply calling <a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){m=l("p"),m.innerHTML=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-6mch0o"&&(m.innerHTML=y)},m(v,$){o(v,m,$)},p:jt,d(v){v&&t(m)}}}function La(Z){let m,y="Examples:",v,$,M;return $=new Et({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=s(),c($.$$.fragment)},l(p){m=i(p,"P",{"data-svelte-h":!0}),d(m)!=="svelte-kvfsh7"&&(m.textContent=y),v=a(p),f($.$$.fragment,p)},m(p,C){o(p,m,C),o(p,v,C),u($,p,C),M=!0},p:jt,i(p){M||(h($.$$.fragment,p),M=!0)},o(p){g($.$$.fragment,p),M=!1},d(p){p&&(t(m),t(v)),_($,p)}}}function za(Z){let m,y="Example:",v,$,M;return $=new Et({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=s(),c($.$$.fragment)},l(p){m=i(p,"P",{"data-svelte-h":!0}),d(m)!=="svelte-11lpom8"&&(m.textContent=y),v=a(p),f($.$$.fragment,p)},m(p,C){o(p,m,C),o(p,v,C),u($,p,C),M=!0},p:jt,i(p){M||(h($.$$.fragment,p),M=!0)},o(p){g($.$$.fragment,p),M=!1},d(p){p&&(t(m),t(v)),_($,p)}}}function Va(Z){let m,y,v,$,M,p,C,Zs="在 Transformers 库中，processors可以有两种不同的含义：",Bt,me,ks='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',Ht,de,Ft,pe,Js="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",Nt,ce,Ls="这些processors继承自以下实现保存和加载功能的基类：",Gt,U,fe,Br,pt,zs="This is a mixin used to provide saving/loading functionality for all processor classes.",Hr,z,ue,Fr,ct,Vs="Instantiate a processor associated with a pretrained model.",Nr,W,Gr,V,he,Sr,ft,js="Upload the processor files to the 🤗 Model Hub.",Wr,R,Rr,j,ge,Qr,ut,qs=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Dr,Q,Yr,q,_e,Ar,ht,Es=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Or,D,St,ve,Wt,$e,Bs='所有processor都遵循与 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',Rt,T,xe,Kr,gt,Hs="Base class for data converters for sequence classification data sets.",es,Y,be,ts,_t,Fs='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',rs,A,ye,ss,vt,Ns="Gets an example from a dict with tensorflow tensors.",as,O,Me,os,$t,Gs="Gets the list of labels for this data set.",ns,K,we,ls,xt,Ss='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',is,ee,Te,ms,bt,Ws='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',ds,te,Ce,ps,yt,Rs=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,Qt,k,Pe,cs,Mt,Qs="A single training/test example for simple sequence classification.",fs,re,Ue,us,wt,Ds="Serializes this instance to a JSON string.",Dt,J,Ie,hs,Tt,Ys="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",gs,se,Xe,_s,Ct,As="Serializes this instance to a JSON string.",Yt,Ze,At,ke,Os='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',Ot,Je,Ks="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",Kt,Le,ea="这些processor是：",er,ze,ta="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",tr,Ve,ra='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',rr,H,je,vs,Pt,sa="Loads a data file into a list of <code>InputFeatures</code>",sr,qe,ar,Ee,aa='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',or,Be,oa='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',nr,He,na="该库提供了加载XNLI数据的processor：",lr,Fe,la="<li><code>~data.processors.utils.XnliProcessor</code></li>",ir,Ne,ia="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",mr,Ge,ma='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',dr,Se,pr,We,da='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',cr,Re,pa="该库为两个版本各自提供了一个processor：",fr,Qe,ur,De,ca="这两个processor是：",hr,Ye,fa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",gr,Ae,ua="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",_r,I,Oe,$s,Ut,ha=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,xs,ae,Ke,bs,It,ga="Returns the evaluation example from the data directory.",ys,E,et,Ms,Xt,_a="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ws,oe,Ts,ne,tt,Cs,Zt,va="Returns the training examples from the data directory.",vr,rt,$a="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",$r,L,st,Ps,kt,xa=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,Us,le,xr,at,ba="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",br,ot,yr,nt,ya="以下是使用processor以及使用数据文件的转换方法的示例：",Mr,lt,wr,it,Ma="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Tr,mt,Cr,dt,wa='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Pr,qt,Ur;return M=new ie({props:{title:"Processors",local:"processors",headingTag:"h1"}}),de=new ie({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),fe=new w({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L42"}}),ue=new w({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L168"}}),W=new Is({props:{$$slots:{default:[Xa]},$$scope:{ctx:Z}}}),he=new w({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": typing.Optional[bool] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L759"}}),R=new Xs({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Za]},$$scope:{ctx:Z}}}),ge=new w({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L231"}}),Q=new Is({props:{warning:!0,$$slots:{default:[ka]},$$scope:{ctx:Z}}}),_e=new w({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L93"}}),D=new Is({props:{$$slots:{default:[Ja]},$$scope:{ctx:Z}}}),ve=new ie({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),xe=new w({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L80"}}),be=new w({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L97"}}),ye=new w({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L83"}}),Me=new w({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L105"}}),we=new w({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L101"}}),Te=new w({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L93"}}),Ce=new w({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L109"}}),Pe=new w({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": typing.Optional[str] = None"},{name:"label",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L30"}}),Ue=new w({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L49"}}),Ie=new w({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": typing.List[int]"},{name:"attention_mask",val:": typing.Optional[typing.List[int]] = None"},{name:"token_type_ids",val:": typing.Optional[typing.List[int]] = None"},{name:"label",val:": typing.Union[int, float, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L55"}}),Xe=new w({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L75"}}),Ze=new ie({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),je=new w({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": typing.Union[typing.List[transformers.data.processors.utils.InputExample], ForwardRef('tf.data.Dataset')]"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),qe=new ie({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),Se=new ie({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),Qe=new ie({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),Oe=new w({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L541"}}),Ke=new w({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L629"}}),et=new w({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),oe=new Xs({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[La]},$$scope:{ctx:Z}}}),tt=new w({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L607"}}),st=new w({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),le=new Xs({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[za]},$$scope:{ctx:Z}}}),ot=new ie({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),lt=new Et({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),mt=new Et({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){m=l("meta"),y=s(),v=l("p"),$=s(),c(M.$$.fragment),p=s(),C=l("p"),C.textContent=Zs,Bt=s(),me=l("ul"),me.innerHTML=ks,Ht=s(),c(de.$$.fragment),Ft=s(),pe=l("p"),pe.textContent=Js,Nt=s(),ce=l("p"),ce.textContent=Ls,Gt=s(),U=l("div"),c(fe.$$.fragment),Br=s(),pt=l("p"),pt.textContent=zs,Hr=s(),z=l("div"),c(ue.$$.fragment),Fr=s(),ct=l("p"),ct.textContent=Vs,Nr=s(),c(W.$$.fragment),Gr=s(),V=l("div"),c(he.$$.fragment),Sr=s(),ft=l("p"),ft.textContent=js,Wr=s(),c(R.$$.fragment),Rr=s(),j=l("div"),c(ge.$$.fragment),Qr=s(),ut=l("p"),ut.innerHTML=qs,Dr=s(),c(Q.$$.fragment),Yr=s(),q=l("div"),c(_e.$$.fragment),Ar=s(),ht=l("p"),ht.innerHTML=Es,Or=s(),c(D.$$.fragment),St=s(),c(ve.$$.fragment),Wt=s(),$e=l("p"),$e.innerHTML=Bs,Rt=s(),T=l("div"),c(xe.$$.fragment),Kr=s(),gt=l("p"),gt.textContent=Hs,es=s(),Y=l("div"),c(be.$$.fragment),ts=s(),_t=l("p"),_t.innerHTML=Fs,rs=s(),A=l("div"),c(ye.$$.fragment),ss=s(),vt=l("p"),vt.textContent=Ns,as=s(),O=l("div"),c(Me.$$.fragment),os=s(),$t=l("p"),$t.textContent=Gs,ns=s(),K=l("div"),c(we.$$.fragment),ls=s(),xt=l("p"),xt.innerHTML=Ss,is=s(),ee=l("div"),c(Te.$$.fragment),ms=s(),bt=l("p"),bt.innerHTML=Ws,ds=s(),te=l("div"),c(Ce.$$.fragment),ps=s(),yt=l("p"),yt.textContent=Rs,Qt=s(),k=l("div"),c(Pe.$$.fragment),cs=s(),Mt=l("p"),Mt.textContent=Qs,fs=s(),re=l("div"),c(Ue.$$.fragment),us=s(),wt=l("p"),wt.textContent=Ds,Dt=s(),J=l("div"),c(Ie.$$.fragment),hs=s(),Tt=l("p"),Tt.textContent=Ys,gs=s(),se=l("div"),c(Xe.$$.fragment),_s=s(),Ct=l("p"),Ct.textContent=As,Yt=s(),c(Ze.$$.fragment),At=s(),ke=l("p"),ke.innerHTML=Os,Ot=s(),Je=l("p"),Je.textContent=Ks,Kt=s(),Le=l("p"),Le.textContent=ea,er=s(),ze=l("ul"),ze.innerHTML=ta,tr=s(),Ve=l("p"),Ve.innerHTML=ra,rr=s(),H=l("div"),c(je.$$.fragment),vs=s(),Pt=l("p"),Pt.innerHTML=sa,sr=s(),c(qe.$$.fragment),ar=s(),Ee=l("p"),Ee.innerHTML=aa,or=s(),Be=l("p"),Be.innerHTML=oa,nr=s(),He=l("p"),He.textContent=na,lr=s(),Fe=l("ul"),Fe.innerHTML=la,ir=s(),Ne=l("p"),Ne.textContent=ia,mr=s(),Ge=l("p"),Ge.innerHTML=ma,dr=s(),c(Se.$$.fragment),pr=s(),We=l("p"),We.innerHTML=da,cr=s(),Re=l("p"),Re.textContent=pa,fr=s(),c(Qe.$$.fragment),ur=s(),De=l("p"),De.textContent=ca,hr=s(),Ye=l("ul"),Ye.innerHTML=fa,gr=s(),Ae=l("p"),Ae.innerHTML=ua,_r=s(),I=l("div"),c(Oe.$$.fragment),$s=s(),Ut=l("p"),Ut.textContent=ha,xs=s(),ae=l("div"),c(Ke.$$.fragment),bs=s(),It=l("p"),It.textContent=ga,ys=s(),E=l("div"),c(et.$$.fragment),Ms=s(),Xt=l("p"),Xt.innerHTML=_a,ws=s(),c(oe.$$.fragment),Ts=s(),ne=l("div"),c(tt.$$.fragment),Cs=s(),Zt=l("p"),Zt.textContent=va,vr=s(),rt=l("p"),rt.innerHTML=$a,$r=s(),L=l("div"),c(st.$$.fragment),Ps=s(),kt=l("p"),kt.textContent=xa,Us=s(),c(le.$$.fragment),xr=s(),at=l("p"),at.textContent=ba,br=s(),c(ot.$$.fragment),yr=s(),nt=l("p"),nt.textContent=ya,Mr=s(),c(lt.$$.fragment),wr=s(),it=l("p"),it.innerHTML=Ma,Tr=s(),c(mt.$$.fragment),Cr=s(),dt=l("p"),dt.innerHTML=wa,Pr=s(),qt=l("p"),this.h()},l(e){const r=Ia("svelte-u9bgzb",document.head);m=i(r,"META",{name:!0,content:!0}),r.forEach(t),y=a(e),v=i(e,"P",{}),x(v).forEach(t),$=a(e),f(M.$$.fragment,e),p=a(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1fd9lf0"&&(C.textContent=Zs),Bt=a(e),me=i(e,"UL",{"data-svelte-h":!0}),d(me)!=="svelte-rmvfpp"&&(me.innerHTML=ks),Ht=a(e),f(de.$$.fragment,e),Ft=a(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-ctzpmo"&&(pe.textContent=Js),Nt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-9fh2y4"&&(ce.textContent=Ls),Gt=a(e),U=i(e,"DIV",{class:!0});var X=x(U);f(fe.$$.fragment,X),Br=a(X),pt=i(X,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1s4wckx"&&(pt.textContent=zs),Hr=a(X),z=i(X,"DIV",{class:!0});var F=x(z);f(ue.$$.fragment,F),Fr=a(F),ct=i(F,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1cj8dcb"&&(ct.textContent=Vs),Nr=a(F),f(W.$$.fragment,F),F.forEach(t),Gr=a(X),V=i(X,"DIV",{class:!0});var N=x(V);f(he.$$.fragment,N),Sr=a(N),ft=i(N,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1cwsjho"&&(ft.textContent=js),Wr=a(N),f(R.$$.fragment,N),N.forEach(t),Rr=a(X),j=i(X,"DIV",{class:!0});var G=x(j);f(ge.$$.fragment,G),Qr=a(G),ut=i(G,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-hhsvto"&&(ut.innerHTML=qs),Dr=a(G),f(Q.$$.fragment,G),G.forEach(t),Yr=a(X),q=i(X,"DIV",{class:!0});var S=x(q);f(_e.$$.fragment,S),Ar=a(S),ht=i(S,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-wdcnpg"&&(ht.innerHTML=Es),Or=a(S),f(D.$$.fragment,S),S.forEach(t),X.forEach(t),St=a(e),f(ve.$$.fragment,e),Wt=a(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1gqc2ou"&&($e.innerHTML=Bs),Rt=a(e),T=i(e,"DIV",{class:!0});var P=x(T);f(xe.$$.fragment,P),Kr=a(P),gt=i(P,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1bsw04k"&&(gt.textContent=Hs),es=a(P),Y=i(P,"DIV",{class:!0});var Ir=x(Y);f(be.$$.fragment,Ir),ts=a(Ir),_t=i(Ir,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-i9v8dv"&&(_t.innerHTML=Fs),Ir.forEach(t),rs=a(P),A=i(P,"DIV",{class:!0});var Xr=x(A);f(ye.$$.fragment,Xr),ss=a(Xr),vt=i(Xr,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-pplryq"&&(vt.textContent=Ns),Xr.forEach(t),as=a(P),O=i(P,"DIV",{class:!0});var Zr=x(O);f(Me.$$.fragment,Zr),os=a(Zr),$t=i(Zr,"P",{"data-svelte-h":!0}),d($t)!=="svelte-3oqyjr"&&($t.textContent=Gs),Zr.forEach(t),ns=a(P),K=i(P,"DIV",{class:!0});var kr=x(K);f(we.$$.fragment,kr),ls=a(kr),xt=i(kr,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1f447o"&&(xt.innerHTML=Ss),kr.forEach(t),is=a(P),ee=i(P,"DIV",{class:!0});var Jr=x(ee);f(Te.$$.fragment,Jr),ms=a(Jr),bt=i(Jr,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-n3qvn6"&&(bt.innerHTML=Ws),Jr.forEach(t),ds=a(P),te=i(P,"DIV",{class:!0});var Lr=x(te);f(Ce.$$.fragment,Lr),ps=a(Lr),yt=i(Lr,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1jevh15"&&(yt.textContent=Rs),Lr.forEach(t),P.forEach(t),Qt=a(e),k=i(e,"DIV",{class:!0});var Jt=x(k);f(Pe.$$.fragment,Jt),cs=a(Jt),Mt=i(Jt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-vkt0pi"&&(Mt.textContent=Qs),fs=a(Jt),re=i(Jt,"DIV",{class:!0});var zr=x(re);f(Ue.$$.fragment,zr),us=a(zr),wt=i(zr,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-5ayq1f"&&(wt.textContent=Ds),zr.forEach(t),Jt.forEach(t),Dt=a(e),J=i(e,"DIV",{class:!0});var Lt=x(J);f(Ie.$$.fragment,Lt),hs=a(Lt),Tt=i(Lt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-168wf64"&&(Tt.textContent=Ys),gs=a(Lt),se=i(Lt,"DIV",{class:!0});var Vr=x(se);f(Xe.$$.fragment,Vr),_s=a(Vr),Ct=i(Vr,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-5ayq1f"&&(Ct.textContent=As),Vr.forEach(t),Lt.forEach(t),Yt=a(e),f(Ze.$$.fragment,e),At=a(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-pf4p60"&&(ke.innerHTML=Os),Ot=a(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-17867sm"&&(Je.textContent=Ks),Kt=a(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-190jb0p"&&(Le.textContent=ea),er=a(e),ze=i(e,"UL",{"data-svelte-h":!0}),d(ze)!=="svelte-my8qym"&&(ze.innerHTML=ta),tr=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-f7vo7d"&&(Ve.innerHTML=ra),rr=a(e),H=i(e,"DIV",{class:!0});var jr=x(H);f(je.$$.fragment,jr),vs=a(jr),Pt=i(jr,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-5lvrve"&&(Pt.innerHTML=sa),jr.forEach(t),sr=a(e),f(qe.$$.fragment,e),ar=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-143feg"&&(Ee.innerHTML=aa),or=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1y5f8bi"&&(Be.innerHTML=oa),nr=a(e),He=i(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1n6xg4v"&&(He.textContent=na),lr=a(e),Fe=i(e,"UL",{"data-svelte-h":!0}),d(Fe)!=="svelte-1e2xq99"&&(Fe.innerHTML=la),ir=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1514ut0"&&(Ne.textContent=ia),mr=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-18t4sjl"&&(Ge.innerHTML=ma),dr=a(e),f(Se.$$.fragment,e),pr=a(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1cqsmed"&&(We.innerHTML=da),cr=a(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1hd0jdd"&&(Re.textContent=pa),fr=a(e),f(Qe.$$.fragment,e),ur=a(e),De=i(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-utkcp6"&&(De.textContent=ca),hr=a(e),Ye=i(e,"UL",{"data-svelte-h":!0}),d(Ye)!=="svelte-1qiv3qf"&&(Ye.innerHTML=fa),gr=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-165sa1k"&&(Ae.innerHTML=ua),_r=a(e),I=i(e,"DIV",{class:!0});var B=x(I);f(Oe.$$.fragment,B),$s=a(B),Ut=i(B,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-173gxyd"&&(Ut.textContent=ha),xs=a(B),ae=i(B,"DIV",{class:!0});var qr=x(ae);f(Ke.$$.fragment,qr),bs=a(qr),It=i(qr,"P",{"data-svelte-h":!0}),d(It)!=="svelte-wmaktk"&&(It.textContent=ga),qr.forEach(t),ys=a(B),E=i(B,"DIV",{class:!0});var zt=x(E);f(et.$$.fragment,zt),Ms=a(zt),Xt=i(zt,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-11nqnea"&&(Xt.innerHTML=_a),ws=a(zt),f(oe.$$.fragment,zt),zt.forEach(t),Ts=a(B),ne=i(B,"DIV",{class:!0});var Er=x(ne);f(tt.$$.fragment,Er),Cs=a(Er),Zt=i(Er,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-d5zv1x"&&(Zt.textContent=va),Er.forEach(t),B.forEach(t),vr=a(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-7uap0d"&&(rt.innerHTML=$a),$r=a(e),L=i(e,"DIV",{class:!0});var Vt=x(L);f(st.$$.fragment,Vt),Ps=a(Vt),kt=i(Vt,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-169nh0g"&&(kt.textContent=xa),Us=a(Vt),f(le.$$.fragment,Vt),Vt.forEach(t),xr=a(e),at=i(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1dp3thd"&&(at.textContent=ba),br=a(e),f(ot.$$.fragment,e),yr=a(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1tuty7g"&&(nt.textContent=ya),Mr=a(e),f(lt.$$.fragment,e),wr=a(e),it=i(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1klp1tb"&&(it.innerHTML=Ma),Tr=a(e),f(mt.$$.fragment,e),Cr=a(e),dt=i(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1mzejoo"&&(dt.innerHTML=wa),Pr=a(e),qt=i(e,"P",{}),x(qt).forEach(t),this.h()},h(){b(m,"name","hf:doc:metadata"),b(m,"content",ja),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){n(document.head,m),o(e,y,r),o(e,v,r),o(e,$,r),u(M,e,r),o(e,p,r),o(e,C,r),o(e,Bt,r),o(e,me,r),o(e,Ht,r),u(de,e,r),o(e,Ft,r),o(e,pe,r),o(e,Nt,r),o(e,ce,r),o(e,Gt,r),o(e,U,r),u(fe,U,null),n(U,Br),n(U,pt),n(U,Hr),n(U,z),u(ue,z,null),n(z,Fr),n(z,ct),n(z,Nr),u(W,z,null),n(U,Gr),n(U,V),u(he,V,null),n(V,Sr),n(V,ft),n(V,Wr),u(R,V,null),n(U,Rr),n(U,j),u(ge,j,null),n(j,Qr),n(j,ut),n(j,Dr),u(Q,j,null),n(U,Yr),n(U,q),u(_e,q,null),n(q,Ar),n(q,ht),n(q,Or),u(D,q,null),o(e,St,r),u(ve,e,r),o(e,Wt,r),o(e,$e,r),o(e,Rt,r),o(e,T,r),u(xe,T,null),n(T,Kr),n(T,gt),n(T,es),n(T,Y),u(be,Y,null),n(Y,ts),n(Y,_t),n(T,rs),n(T,A),u(ye,A,null),n(A,ss),n(A,vt),n(T,as),n(T,O),u(Me,O,null),n(O,os),n(O,$t),n(T,ns),n(T,K),u(we,K,null),n(K,ls),n(K,xt),n(T,is),n(T,ee),u(Te,ee,null),n(ee,ms),n(ee,bt),n(T,ds),n(T,te),u(Ce,te,null),n(te,ps),n(te,yt),o(e,Qt,r),o(e,k,r),u(Pe,k,null),n(k,cs),n(k,Mt),n(k,fs),n(k,re),u(Ue,re,null),n(re,us),n(re,wt),o(e,Dt,r),o(e,J,r),u(Ie,J,null),n(J,hs),n(J,Tt),n(J,gs),n(J,se),u(Xe,se,null),n(se,_s),n(se,Ct),o(e,Yt,r),u(Ze,e,r),o(e,At,r),o(e,ke,r),o(e,Ot,r),o(e,Je,r),o(e,Kt,r),o(e,Le,r),o(e,er,r),o(e,ze,r),o(e,tr,r),o(e,Ve,r),o(e,rr,r),o(e,H,r),u(je,H,null),n(H,vs),n(H,Pt),o(e,sr,r),u(qe,e,r),o(e,ar,r),o(e,Ee,r),o(e,or,r),o(e,Be,r),o(e,nr,r),o(e,He,r),o(e,lr,r),o(e,Fe,r),o(e,ir,r),o(e,Ne,r),o(e,mr,r),o(e,Ge,r),o(e,dr,r),u(Se,e,r),o(e,pr,r),o(e,We,r),o(e,cr,r),o(e,Re,r),o(e,fr,r),u(Qe,e,r),o(e,ur,r),o(e,De,r),o(e,hr,r),o(e,Ye,r),o(e,gr,r),o(e,Ae,r),o(e,_r,r),o(e,I,r),u(Oe,I,null),n(I,$s),n(I,Ut),n(I,xs),n(I,ae),u(Ke,ae,null),n(ae,bs),n(ae,It),n(I,ys),n(I,E),u(et,E,null),n(E,Ms),n(E,Xt),n(E,ws),u(oe,E,null),n(I,Ts),n(I,ne),u(tt,ne,null),n(ne,Cs),n(ne,Zt),o(e,vr,r),o(e,rt,r),o(e,$r,r),o(e,L,r),u(st,L,null),n(L,Ps),n(L,kt),n(L,Us),u(le,L,null),o(e,xr,r),o(e,at,r),o(e,br,r),u(ot,e,r),o(e,yr,r),o(e,nt,r),o(e,Mr,r),u(lt,e,r),o(e,wr,r),o(e,it,r),o(e,Tr,r),u(mt,e,r),o(e,Cr,r),o(e,dt,r),o(e,Pr,r),o(e,qt,r),Ur=!0},p(e,[r]){const X={};r&2&&(X.$$scope={dirty:r,ctx:e}),W.$set(X);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),R.$set(F);const N={};r&2&&(N.$$scope={dirty:r,ctx:e}),Q.$set(N);const G={};r&2&&(G.$$scope={dirty:r,ctx:e}),D.$set(G);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),oe.$set(S);const P={};r&2&&(P.$$scope={dirty:r,ctx:e}),le.$set(P)},i(e){Ur||(h(M.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(W.$$.fragment,e),h(he.$$.fragment,e),h(R.$$.fragment,e),h(ge.$$.fragment,e),h(Q.$$.fragment,e),h(_e.$$.fragment,e),h(D.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(Ze.$$.fragment,e),h(je.$$.fragment,e),h(qe.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(oe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(le.$$.fragment,e),h(ot.$$.fragment,e),h(lt.$$.fragment,e),h(mt.$$.fragment,e),Ur=!0)},o(e){g(M.$$.fragment,e),g(de.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(W.$$.fragment,e),g(he.$$.fragment,e),g(R.$$.fragment,e),g(ge.$$.fragment,e),g(Q.$$.fragment,e),g(_e.$$.fragment,e),g(D.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Xe.$$.fragment,e),g(Ze.$$.fragment,e),g(je.$$.fragment,e),g(qe.$$.fragment,e),g(Se.$$.fragment,e),g(Qe.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(oe.$$.fragment,e),g(tt.$$.fragment,e),g(st.$$.fragment,e),g(le.$$.fragment,e),g(ot.$$.fragment,e),g(lt.$$.fragment,e),g(mt.$$.fragment,e),Ur=!1},d(e){e&&(t(y),t(v),t($),t(p),t(C),t(Bt),t(me),t(Ht),t(Ft),t(pe),t(Nt),t(ce),t(Gt),t(U),t(St),t(Wt),t($e),t(Rt),t(T),t(Qt),t(k),t(Dt),t(J),t(Yt),t(At),t(ke),t(Ot),t(Je),t(Kt),t(Le),t(er),t(ze),t(tr),t(Ve),t(rr),t(H),t(sr),t(ar),t(Ee),t(or),t(Be),t(nr),t(He),t(lr),t(Fe),t(ir),t(Ne),t(mr),t(Ge),t(dr),t(pr),t(We),t(cr),t(Re),t(fr),t(ur),t(De),t(hr),t(Ye),t(gr),t(Ae),t(_r),t(I),t(vr),t(rt),t($r),t(L),t(xr),t(at),t(br),t(yr),t(nt),t(Mr),t(wr),t(it),t(Tr),t(Cr),t(dt),t(Pr),t(qt)),t(m),_(M,e),_(de,e),_(fe),_(ue),_(W),_(he),_(R),_(ge),_(Q),_(_e),_(D),_(ve,e),_(xe),_(be),_(ye),_(Me),_(we),_(Te),_(Ce),_(Pe),_(Ue),_(Ie),_(Xe),_(Ze,e),_(je),_(qe,e),_(Se,e),_(Qe,e),_(Oe),_(Ke),_(et),_(oe),_(tt),_(st),_(le),_(ot,e),_(lt,e),_(mt,e)}}}const ja='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function qa(Z){return Ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends Pa{constructor(m){super(),Ua(this,m,qa,Va,Ta,{})}}export{Wa as component};
