import{s as UI,o as wI,n as gJ}from"../chunks/scheduler.9bc65507.js";import{S as dI,i as mI,g as p,s as a,r as M,A as fI,h as i,f as e,c as n,j as U,u,x as o,k as w,y as d,a as l,v as c,d as r,t as y,w as j}from"../chunks/index.707bf1b6.js";import{T as AJ}from"../chunks/Tip.c2ecdbf4.js";import{D as II}from"../chunks/Docstring.17db21ae.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as h}from"../chunks/Heading.342b1fa6.js";function CI($){let J,g="This section is a must-read";return{c(){J=p("p"),J.textContent=g},l(m){J=i(m,"P",{"data-svelte-h":!0}),o(J)!=="svelte-10scaxe"&&(J.textContent=g)},m(m,I){l(m,J,I)},p:gJ,d(m){m&&e(J)}}}function bI($){let J,g="As of <code>deepspeed==0.6.0</code> the bf16 support is new and experimental.",m,I,B='If you use <a href="#gradient-accumulation">gradient accumulation</a> with bf16-enabled, you need to be aware that it’ll accumulate gradients in bf16, which may not be what you want due to this format’s low precision, as it may lead to a lossy accumulation.',Z,b,Bo="A work is being done to fix that and provide an option to use a higher precision <code>dtype</code> (fp16 or fp32).";return{c(){J=p("p"),J.innerHTML=g,m=a(),I=p("p"),I.innerHTML=B,Z=a(),b=p("p"),b.innerHTML=Bo},l(f){J=i(f,"P",{"data-svelte-h":!0}),o(J)!=="svelte-zhd1i5"&&(J.innerHTML=g),m=n(f),I=i(f,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1330j3o"&&(I.innerHTML=B),Z=n(f),b=i(f,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1efu1t3"&&(b.innerHTML=Bo)},m(f,v){l(f,J,v),l(f,m,v),l(f,I,v),l(f,Z,v),l(f,b,v)},p:gJ,d(f){f&&(e(J),e(m),e(I),e(Z),e(b))}}}function AI($){let J,g=`Note, that once <code>load_state_dict_from_zero_checkpoint</code> was run, the <code>model</code> will no longer be usable in the
DeepSpeed context of the same application. i.e. you will need to re-initialize the deepspeed engine, since
<code>model.load_state_dict(state_dict)</code> will remove all the DeepSpeed magic from it. So do this only at the very end
of the training.`;return{c(){J=p("p"),J.innerHTML=g},l(m){J=i(m,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1jfwcm8"&&(J.innerHTML=g)},m(m,I){l(m,J,I)},p:gJ,d(m){m&&e(J)}}}function gI($){let J,g,m,I,B,Z,b,Bo='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Currently it provides full support for:',f,v,vJ="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and NVMe</li>",xo,R,_J=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,$o,k,BJ="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",So,N,ZJ=`DeepSpeed ZeRO-3 can be used for inference as well, since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,zo,X,qJ='🤗 Transformers integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',Go,Q,xJ=`<li>Integration of the core DeepSpeed features via <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>. This is an everything-done-for-you type
of integration - just supply your custom config file or use our template and you have nothing else to do. Most of
this document is focused on this feature.</li> <li>If you don’t use <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> and want to use your own Trainer where you integrated DeepSpeed
yourself, core functionality functions like <code>from_pretrained</code> and <code>from_config</code> include integration of essential
parts of DeepSpeed like <code>zero.Init</code> for ZeRO stage 3 and higher. To tap into this feature read the docs on
<a href="#nontrainer-deepspeed-integration">non-Trainer DeepSpeed Integration</a>.</li>`,Wo,E,$J="What is integrated:",Ro,H,SJ="Training:",ko,V,zJ="<li>DeepSpeed ZeRO training supports the full ZeRO stages 1, 2 and 3 with ZeRO-Infinity (CPU and NVME offload).</li>",No,Y,GJ="Inference:",Xo,F,WJ=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#zero-inference">zero-inference</a>.</li>`,Qo,L,RJ=`There is also DeepSpeed Inference - this is a totally different technology which uses Tensor Parallelism instead of
ZeRO (coming soon).`,Eo,Vi,Ho,D,Vo,Yi,Yo,P,Fo,O,kJ="Install the library via pypi:",Lo,K,Do,ss,NJ="or via <code>transformers</code>’ <code>extras</code>:",Po,ts,Oo,es,XJ=`or find more details on <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">the DeepSpeed’s GitHub page</a> and
<a href="https://www.deepspeed.ai/tutorials/advanced-install/" rel="nofollow">advanced install</a>.`,Ko,ls,QJ='If you’re still struggling with the build, first make sure to read <a href="trainer#cuda-extension-installation-notes">CUDA Extension Installation Notes</a>.',sM,as,EJ=`If you don’t prebuild the extensions and rely on them to be built at run time and you tried all of the above solutions
to no avail, the next thing to try is to pre-build the modules before installing them.`,tM,ns,HJ="To make a local build for DeepSpeed:",eM,ps,lM,is,VJ=`If you intend to use NVMe offload you will also need to include <code>DS_BUILD_AIO=1</code> in the instructions above (and also
install <em>libaio-dev</em> system-wide).`,aM,os,YJ=`Edit <code>TORCH_CUDA_ARCH_LIST</code> to insert the code for the architectures of the GPU cards you intend to use. Assuming all
your cards are the same you can get the arch via:`,nM,Ms,pM,us,FJ=`So if you get <code>8, 6</code>, then use <code>TORCH_CUDA_ARCH_LIST=&quot;8.6&quot;</code>. If you have multiple different cards, you can list all
of them like so <code>TORCH_CUDA_ARCH_LIST=&quot;6.1;8.6&quot;</code>`,iM,cs,LJ="If you need to use the same setup on multiple machines, make a binary wheel:",oM,rs,MM,ys,DJ=`it will generate something like <code>dist/deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> which now you can install
as <code>pip install deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> locally or on any other machine.`,uM,js,PJ="Again, remember to ensure to adjust <code>TORCH_CUDA_ARCH_LIST</code> to the target architectures.",cM,Ts,OJ=`You can find the complete list of NVIDIA GPUs and their corresponding <strong>Compute Capabilities</strong> (same as arch in this
context) <a href="https://developer.nvidia.com/cuda-gpus" rel="nofollow">here</a>.`,rM,hs,KJ="You can check the archs pytorch was built with using:",yM,Js,jM,Us,sU="Here is how to find out the arch for one of the installed GPUs. For example, for GPU 0:",TM,ws,hM,ds,tU="If the output is:",JM,ms,UM,fs,eU="then you know that this card’s arch is <code>8.6</code>.",wM,Is,lU=`You can also leave <code>TORCH_CUDA_ARCH_LIST</code> out completely and then the build program will automatically query the
architecture of the GPUs the build is made on. This may or may not match the GPUs on the target machines, that’s why
it’s best to specify the desired archs explicitly.`,dM,Cs,aU=`If after trying everything suggested you still encounter build issues, please, proceed with the GitHub Issue of
<a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">Deepspeed</a>,`,mM,Fi,fM,bs,IM,As,nU=`To deploy the DeepSpeed integration adjust the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments to include a new argument <code>--deepspeed ds_config.json</code>, where <code>ds_config.json</code> is the DeepSpeed configuration file as
documented <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">here</a>. The file naming is up to you.
It’s recommended to use DeepSpeed’s <code>add_config_arguments</code> utility to add the necessary command line arguments to your code.
For more information please see <a href="https://deepspeed.readthedocs.io/en/latest/initialize.html#argument-parsing" rel="nofollow">DeepSpeed’s Argument Parsing</a> doc.`,CM,gs,pU="You can use a launcher of your choice here. You can continue using the pytorch launcher:",bM,vs,AM,_s,iU="or use the launcher provided by <code>deepspeed</code>:",gM,Bs,vM,Zs,oU=`As you can see the arguments aren’t the same, but for most needs either of them works. The
full details on how to configure various nodes and GPUs can be found <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">here</a>.`,_M,qs,MU="When you use the <code>deepspeed</code> launcher and you want to use all available gpus you can just omit the <code>--num_gpus</code> flag.",BM,xs,uU="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",ZM,$s,qM,Ss,cU=`Note that in the DeepSpeed documentation you are likely to see <code>--deepspeed --deepspeed_config ds_config.json</code> - i.e.
two DeepSpeed-related arguments, but for the sake of simplicity, and since there are already so many arguments to deal
with, we combined the two into a single argument.`,xM,zs,rU='For some practical usage examples, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759248400" rel="nofollow">post</a>.',$M,Li,SM,Gs,zM,Ws,yU='To deploy DeepSpeed with one GPU adjust the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments as follows:',GM,Rs,WM,ks,jU=`This is almost the same as with multiple-GPUs, but here we tell DeepSpeed explicitly to use just one GPU via
<code>--num_gpus=1</code>. By default, DeepSpeed deploys all GPUs it can see on the given node. If you have only 1 GPU to start
with, then you don’t need this argument. The following <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">documentation</a> discusses the launcher options.`,RM,Ns,TU="Why would you want to use DeepSpeed with just one GPU?",kM,Xs,hU=`<li>It has a ZeRO-offload feature which can delegate some computations and memory to the host’s CPU and RAM, and thus
leave more GPU resources for model’s needs - e.g. larger batch size, or enabling a fitting of a very big model which
normally won’t fit.</li> <li>It provides a smart GPU memory management system, that minimizes memory fragmentation, which again allows you to fit
bigger models and data batches.</li>`,NM,Qs,JU=`While we are going to discuss the configuration in details next, the key to getting a huge improvement on a single GPU
with DeepSpeed is to have at least the following configuration in the configuration file:`,XM,Es,QM,Hs,UU=`which enables optimizer offload and some other important features. You may experiment with the buffer sizes, you will
find more details in the discussion below.`,EM,Vs,wU='For a practical usage example of this type of deployment, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759176685" rel="nofollow">post</a>.',HM,Ys,dU="You may also try the ZeRO-3 with CPU and NVMe offload as explained further in this document.",VM,Fs,mU="Notes:",YM,Di,q,Pi,fU=`if you need to run on a specific GPU, which is different from GPU 0, you can’t use <code>CUDA_VISIBLE_DEVICES</code> to limit
the visible scope of available GPUs. Instead, you have to use the following syntax:`,TJ,Ls,hJ,Oi,IU="In this example, we tell DeepSpeed to use GPU 1 (second gpu).",FM,Ki,LM,Ds,DM,Ps,CU="The information in this section isn’t not specific to the DeepSpeed integration and is applicable to any multi-node program. But DeepSpeed provides a <code>deepspeed</code> launcher that is easier to use than other launchers unless you are in a SLURM environment.",PM,Os,bU="For the duration of this section let’s assume that you have 2 nodes with 8 gpus each. And you can reach the first node with <code>ssh hostname1</code> and second node with <code>ssh hostname2</code>, and both must be able to reach each other via ssh locally without a password. Of course, you will need to rename these host (node) names to the actual host names you are working with.",OM,Ks,KM,st,AU="For example, to use <code>torch.distributed.run</code>, you could do:",su,tt,tu,et,gU="You have to ssh to each node and run this same command on each one of them! There is no rush, the launcher will wait until both nodes will synchronize.",eu,lt,vU='For more information please see <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>. Incidentally, this is also the launcher that replaced <code>torch.distributed.launch</code> a few pytorch versions back.',lu,at,au,nt,_U="To use the <code>deepspeed</code> launcher instead, you have to first create a <code>hostfile</code> file:",nu,pt,pu,it,BU="and then you can launch it as:",iu,ot,ou,Mt,ZU="Unlike the <code>torch.distributed.run</code> launcher, <code>deepspeed</code> will automatically launch this command on both nodes!",Mu,ut,qU='For more information please see <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">Resource Configuration (multi-node)</a>.',uu,ct,cu,rt,xU="In the SLURM environment the following approach can be used. The following is a slurm script <code>launch.slurm</code> which you will need to adapt it to your specific SLURM environment.",ru,yt,yu,jt,$U="All is left is to schedule it to run:",ju,Tt,Tu,ht,SU="<code>srun</code> will take care of launching the program simultaneously on all nodes.",hu,Jt,Ju,Ut,zU='By default DeepSpeed expects that a multi-node environment uses a shared storage. If this is not the case and each node can only see the local filesystem, you need to adjust the config file to include a  <a href="https://www.deepspeed.ai/docs/config-json/#checkpoint-options" rel="nofollow"><code>checkpoint</code>_section</a> with the following setting:',Uu,wt,wu,dt,GU='Alternatively, you can also use the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>’s <code>--save_on_each_node</code> argument, and the above config will be added automatically for you.',du,so,mu,mt,fu,ft,WU=`The problem with running notebook cells as a script is that there is no normal <code>deepspeed</code> launcher to rely on, so
under certain setups we have to emulate it.`,Iu,It,RU="If you’re using only 1 GPU, here is how you’d have to adjust your training code in the notebook to use DeepSpeed.",Cu,Ct,bu,bt,kU="Note: <code>...</code> stands for the normal arguments that you’d pass to the functions.",Au,At,NU=`If you want to use more than 1 GPU, you must use a multi-process environment for DeepSpeed to work. That is, you have
to use the launcher for that purpose and this cannot be accomplished by emulating the distributed environment presented
at the beginning of this section.`,gu,gt,XU=`If you want to create the config file on the fly in the notebook in the current directory, you could have a dedicated
cell with:`,vu,vt,_u,_t,QU=`If the training script is in a normal file and not in the notebook cells, you can launch <code>deepspeed</code> normally via
shell from a cell. For example, to use <code>run_translation.py</code> you would launch it with:`,Bu,Bt,Zu,Zt,EU="or with <code>%%bash</code> magic, where you can write a multi-line code for the shell program to run:",qu,qt,xu,xt,HU="In such case you don’t need any of the code presented at the beginning of this section.",$u,$t,VU=`Note: While <code>%%bash</code> magic is neat, but currently it buffers the output so you won’t see the logs until the process
completes.`,Su,to,zu,St,Gu,zt,YU=`For the complete guide to the DeepSpeed configuration options that can be used in its configuration file please refer
to the <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">following documentation</a>.`,Wu,Gt,FU=`You can find dozens of DeepSpeed configuration examples that address various practical needs in <a href="https://github.com/microsoft/DeepSpeedExamples" rel="nofollow">the DeepSpeedExamples
repo</a>:`,Ru,Wt,ku,Rt,LU=`Continuing the code from above, let’s say you’re looking to configure the Lamb optimizer. So you can search through the
example <code>.json</code> files with:`,Nu,kt,Xu,Nt,DU='Some more examples are to be found in the <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">main repo</a> as well.',Qu,Xt,PU=`When using DeepSpeed you always need to supply a DeepSpeed configuration file, yet some configuration parameters have
to be configured via the command line. You will find the nuances in the rest of this guide.`,Eu,Qt,OU=`To get an idea of what DeepSpeed configuration file looks like, here is one that activates ZeRO stage 2 features,
including optimizer states cpu offload, uses <code>AdamW</code> optimizer and <code>WarmupLR</code> scheduler and will enable mixed
precision training if <code>--fp16</code> is passed:`,Hu,Et,Vu,Ht,KU=`When you execute the program, DeepSpeed will log the configuration it received from the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>
to the console, so you can see exactly what was the final configuration passed to it.`,Yu,eo,Fu,Vt,Lu,Yt,sw=`As discussed in this document normally the DeepSpeed configuration is passed as a path to a json file, but if you’re
not using the command line interface to configure the training, and instead instantiate the
<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> via <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> then for the <code>deepspeed</code> argument you can
pass a nested <code>dict</code>. This allows you to create the configuration on the fly and doesn’t require you to write it to
the file system before passing it to <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.`,Du,Ft,tw="To summarize you can do:",Pu,Lt,Ou,Dt,ew="or:",Ku,Pt,sc,lo,tc,Ot,ec,S,lc,Kt,lw=`Some configuration values are required by both the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> and DeepSpeed to function correctly,
therefore, to prevent conflicting definitions, which could lead to hard to detect errors, we chose to configure those
via the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments.`,ac,se,aw=`Additionally, some configuration values are derived automatically based on the model’s configuration, so instead of
remembering to manually adjust multiple values, it’s the best to let the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> do the majority
of configuration for you.`,nc,te,nw=`Therefore, in the rest of this guide you will find a special configuration value: <code>auto</code>, which when set will be
automatically replaced with the correct or most efficient value. Please feel free to choose to ignore this
recommendation and set the values explicitly, in which case be very careful that your the
<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments and DeepSpeed configurations agree. For example, are you using the same
learning rate, or batch size, or gradient accumulation settings? if these mismatch the training may fail in very
difficult to detect ways. You have been warned.`,pc,ee,pw=`There are multiple other values that are specific to DeepSpeed-only and those you will have to set manually to suit
your needs.`,ic,le,iw=`In your own programs, you can also use the following approach if you’d like to modify the DeepSpeed config as a master
and configure <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> based on that. The steps are:`,oc,ae,ow='<li>Create or load the DeepSpeed configuration to be used as a master configuration</li> <li>Create the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object based on these values</li>',Mc,ne,Mw=`Do note that some values, such as <code>scheduler.params.total_num_steps</code> are calculated by
<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> during <code>train</code>, but you can of course do the math yourself.`,uc,ao,cc,pe,rc,ie,uw=`<a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">Zero Redundancy Optimizer (ZeRO)</a> is the workhorse of DeepSpeed. It
supports 3 different levels (stages) of optimization. The first one is not quite interesting for scalability purposes,
therefore this document focuses on stages 2 and 3. Stage 3 is further improved by the latest addition of ZeRO-Infinity.
You will find more indepth information in the DeepSpeed documentation.`,yc,oe,cw=`The <code>zero_optimization</code> section of the configuration file is the most important part (<a href="https://www.deepspeed.ai/docs/config-json/#zero-optimizations-for-fp16-training" rel="nofollow">docs</a>), since that is where you define
which ZeRO stages you want to enable and how to configure them. You will find the explanation for each parameter in the
DeepSpeed docs.`,jc,Me,rw=`This section has to be configured exclusively via DeepSpeed configuration - the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides
no equivalent command line arguments.`,Tc,ue,yw=`Note: currently DeepSpeed doesn’t validate parameter names, so if you misspell any, it’ll use the default setting for
the parameter that got misspelled. You can watch the DeepSpeed engine start up log messages to see what values it is
going to use.`,hc,no,Jc,ce,Uc,re,jw="The following is an example of configuration for ZeRO stage 2:",wc,ye,dc,je,Tw="<strong>Performance tuning:</strong>",mc,Te,hw=`<li>enabling <code>offload_optimizer</code> should reduce GPU RAM usage (it requires <code>&quot;stage&quot;: 2</code>)</li> <li><code>&quot;overlap_comm&quot;: true</code> trades off increased GPU RAM usage to lower all-reduce latency. <code>overlap_comm</code> uses 4.5x
the <code>allgather_bucket_size</code> and <code>reduce_bucket_size</code> values. So if they are set to 5e8, this requires a 9GB
footprint (<code>5e8 x 2Bytes x 2 x 4.5</code>). Therefore, if you have a GPU with 8GB or less RAM, to avoid getting
OOM-errors you will need to reduce those parameters to about <code>2e8</code>, which would require 3.6GB. You will want to do
the same on larger capacity GPU as well, if you’re starting to hit OOM.</li> <li>when reducing these buffers you’re trading communication speed to avail more GPU RAM. The smaller the buffer size is,
the slower the communication gets, and the more GPU RAM will be available to other tasks. So if a bigger batch size is
important, getting a slightly slower training time could be a good trade.</li>`,fc,he,Jw="Additionally, <code>deepspeed==0.4.4</code> added a new option <code>round_robin_gradients</code> which you can enable with:",Ic,Je,Cc,Ue,Uw="This is a stage 2 optimization for CPU offloading that parallelizes gradient copying to CPU memory among ranks by fine-grained gradient partitioning. Performance benefit grows with gradient accumulation steps (more copying between optimizer steps) or GPU count (increased parallelism).",bc,po,Ac,we,gc,de,ww="The following is an example of configuration for ZeRO stage 3:",vc,me,_c,fe,dw=`If you are getting OOMs, because your model or activations don’t fit into the GPU memory and you have unutilized CPU
memory offloading the optimizer states and parameters to CPU memory with <code>&quot;device&quot;: &quot;cpu&quot;</code> may solve this limitation.
If you don’t want to offload to CPU memory, use <code>none</code> instead of <code>cpu</code> for the <code>device</code> entry. Offloading to
NVMe is discussed further down.`,Bc,Ie,mw=`Pinned memory is enabled with <code>pin_memory</code> set to <code>true</code>. This feature can improve the throughput at the cost of
making less memory available to other processes. Pinned memory is set aside to the specific process that requested it
and its typically accessed much faster than normal CPU memory.`,Zc,Ce,fw="<strong>Performance tuning:</strong>",qc,be,Iw="<li><code>stage3_max_live_parameters</code>: <code>1e9</code></li> <li><code>stage3_max_reuse_distance</code>: <code>1e9</code></li>",xc,Ae,Cw=`If hitting OOM reduce <code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>. They should have minimal impact
on performance unless you are doing activation checkpointing. <code>1e9</code> would consume ~2GB. The memory is shared by
<code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>, so it’s not additive, it’s just 2GB total.`,$c,ge,bw=`<code>stage3_max_live_parameters</code> is the upper limit on how many full parameters you want to keep on the GPU at any given
time. “reuse distance” is a metric we are using to figure out when will a parameter be used again in the future, and we
use the <code>stage3_max_reuse_distance</code> to decide whether to throw away the parameter or to keep it. If a parameter is
going to be used again in near future (less than <code>stage3_max_reuse_distance</code>) then we keep it to reduce communication
overhead. This is super helpful when you have activation checkpointing enabled, where we do a forward recompute and
backward passes a single layer granularity and want to keep the parameter in the forward recompute till the backward`,Sc,ve,Aw="The following configuration values depend on the model’s hidden size:",zc,_e,gw="<li><code>reduce_bucket_size</code>: <code>hidden_size*hidden_size</code></li> <li><code>stage3_prefetch_bucket_size</code>: <code>0.9 * hidden_size * hidden_size</code></li> <li><code>stage3_param_persistence_threshold</code>: <code>10 * hidden_size</code></li>",Gc,Be,vw=`therefore set these values to <code>auto</code> and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically assign the recommended
values. But, of course, feel free to set these explicitly as well.`,Wc,Ze,_w=`<code>stage3_gather_16bit_weights_on_model_save</code> enables model fp16 weights consolidation when model gets saved. With large
models and multiple GPUs this is an expensive operation both in terms of memory and speed. It’s currently required if
you plan to resume the training. Watch out for future updates that will remove this limitation and make things more
flexible.`,Rc,qe,Bw=`If you’re migrating from ZeRO-2 configuration note that <code>allgather_partitions</code>, <code>allgather_bucket_size</code> and
<code>reduce_scatter</code> configuration parameters are not used in ZeRO-3. If you keep these in the config file they will just
be ignored.`,kc,xe,Zw="<li><code>sub_group_size</code>: <code>1e9</code></li>",Nc,$e,qw=`<code>sub_group_size</code> controls the granularity in which parameters are updated during optimizer steps. Parameters are
grouped into buckets of <code>sub_group_size</code> and each buckets is updated one at a time. When used with NVMe offload in
ZeRO-Infinity, <code>sub_group_size</code> therefore controls the granularity in which model states are moved in and out of CPU
memory from NVMe during the optimizer step. This prevents running out of CPU memory for extremely large models.`,Xc,Se,xw=`You can leave <code>sub_group_size</code> to its default value of <em>1e9</em> when not using NVMe offload. You may want to change its
default value in the following cases:`,Qc,ze,$w=`<li>Running into OOM during optimizer step: Reduce <code>sub_group_size</code> to reduce memory utilization of temporary buffers</li> <li>Optimizer Step is taking a long time: Increase <code>sub_group_size</code> to improve bandwidth utilization as a result of
the increased data buffers.</li>`,Ec,Ge,Hc,We,Sw="Note that we’re listing Stage 0 and 1 last since they are rarely used.",Vc,Re,zw="Stage 0 is disabling all types of sharding and just using DeepSpeed as DDP. You can turn it on with:",Yc,ke,Fc,Ne,Gw="This will essentially disable ZeRO without you needing to change anything else.",Lc,Xe,Dc,Qe,Ww="Stage 1 is Stage 2 minus gradient sharding. You can always try it to speed things a tiny bit to only shard the optimizer states with:",Pc,Ee,Oc,io,Kc,He,sr,Ve,Rw=`ZeRO-Infinity allows for training incredibly large models by extending GPU and CPU memory with NVMe memory. Thanks to
smart partitioning and tiling algorithms each GPU needs to send and receive very small amounts of data during
offloading so modern NVMe proved to be fit to allow for an even larger total memory pool available to your training
process. ZeRO-Infinity requires ZeRO-3 enabled.`,tr,Ye,kw="The following configuration example enables NVMe to offload both optimizer states and the params:",er,Fe,lr,Le,Nw=`You can choose to offload both optimizer states and params to NVMe, or just one of them or none. For example, if you
have copious amounts of CPU memory available, by all means offload to CPU memory only as it’d be faster (hint:
<em>“device”: “cpu”</em>).`,ar,De,Xw='Here is the full documentation for offloading <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-offloading" rel="nofollow">optimizer states</a> and <a href="https://www.deepspeed.ai/docs/config-json/#parameter-offloading" rel="nofollow">parameters</a>.',nr,Pe,Qw=`Make sure that your <code>nvme_path</code> is actually an NVMe, since it will work with the normal hard drive or SSD, but it’ll
be much much slower. The fast scalable training was designed with modern NVMe transfer speeds in mind (as of this
writing one can have ~3.5GB/s read, ~3GB/s write peak speeds).`,pr,Oe,Ew=`In order to figure out the optimal <code>aio</code> configuration block you must run a benchmark on your target setup, as
<a href="https://github.com/microsoft/DeepSpeed/issues/998" rel="nofollow">explained here</a>.`,ir,oo,or,Ke,Mr,sl,Hw=`ZeRO-3 is likely to be slower than ZeRO-2 if everything else is configured the same because the former has to gather
model weights in addition to what ZeRO-2 does. If ZeRO-2 meets your needs and you don’t need to scale beyond a few GPUs
then you may choose to stick to it. It’s important to understand that ZeRO-3 enables a much higher scalability capacity
at a cost of speed.`,ur,tl,Vw="It’s possible to adjust ZeRO-3 configuration to make it perform closer to ZeRO-2:",cr,el,Yw="<li>set <code>stage3_param_persistence_threshold</code> to a very large number - larger than the largest parameter, e.g., <code>6 * hidden_size * hidden_size</code>. This will keep the parameters on the GPUs.</li> <li>turn off <code>offload_params</code> since ZeRO-2 doesn’t have that option.</li>",rr,ll,Fw=`The performance will likely improve significantly with just <code>offload_params</code> turned off, even if you don’t change
<code>stage3_param_persistence_threshold</code>. Of course, these changes will impact the size of the model you can train. So
these help you to trade scalability for speed depending on your needs.`,yr,Mo,jr,al,Tr,nl,Lw="Here is a full ZeRO-2 auto-configuration file <code>ds_config_zero2.json</code>:",hr,pl,Jr,il,Dw=`Here is a full ZeRO-2 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,Ur,ol,wr,uo,dr,Ml,mr,ul,Pw="Here is a full ZeRO-3 auto-configuration file <code>ds_config_zero3.json</code>:",fr,cl,Ir,rl,Ow=`Here is a full ZeRO-3 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,Cr,yl,br,jl,Ar,Tl,Kw="So now you know there are all these different stages. How to decide which of them to use? This section will attempt to address this question.",gr,hl,sd="In general the following applies:",vr,Jl,td="<li>Speed-wise (left is faster than right)</li>",_r,Ul,ed="Stage 0 (DDP) > Stage 1 > Stage 2 > Stage 2 + offload > Stage 3 > Stage 3 + offloads",Br,wl,ld="<li>GPU Memory usage-wise (right is more GPU memory efficient than left)</li>",Zr,dl,ad="Stage 0 (DDP) < Stage 1 < Stage 2 < Stage 2 + offload < Stage 3 < Stage 3 + offloads",qr,ml,nd="So when you want to get the fastest execution while fitting into minimal number of GPUs, here is the process you could follow. We start with the fastest approach and if running into GPU OOM we then go to the next slower approach, but which will use less GPU memory. And so on and so forth.",xr,fl,pd="First of all set batch size to 1 (you can always use gradient accumulation for any desired effective batch size).",$r,Il,id="<li><p>Enable <code>--gradient_checkpointing 1</code> (HF Trainer) or directly <code>model.gradient_checkpointing_enable()</code> - if OOM then</p></li> <li><p>Try ZeRO stage 2 first. if OOM then</p></li> <li><p>Try ZeRO stage 2 + <code>offload_optimizer</code> - if OOM then</p></li> <li><p>Switch to ZeRO stage 3 - if OOM then</p></li> <li><p>Enable <code>offload_param</code> to <code>cpu</code> - if OOM then</p></li> <li><p>Enable <code>offload_optimizer</code> to <code>cpu</code> - if OOM then</p></li> <li><p>If you still can’t fit a batch size of 1 first check various default values and lower them if you can. For example, if you use <code>generate</code> and you don’t use a wide search beam make it narrower as it’d take a lot of memory.</p></li> <li><p>Definitely use mixed half-precision over fp32 - so bf16 on Ampere and higher GPUs and fp16 on older gpu architectures.</p></li> <li><p>If you still OOM you could add more hardware or enable ZeRO-Infinity - that is switch offloads <code>offload_param</code> and  <code>offload_optimizer</code> to <code>nvme</code>. You need to make sure it’s a very fast nvme. As an anecdote I was able to infer BLOOM-176B on a tiny GPU using ZeRO-Infinity except it was extremely slow. But it worked!</p></li>",Sr,Cl,od="You can, of course, work through these steps in reverse by starting with the most GPU memory efficient config and then going backwards. Or try bi-secting it.",zr,bl,Md="Once you have your batch size 1 not leading to OOM, measure your effective throughput.",Gr,Al,ud="Next try to increase the batch size to as large as you can, since the higher the batch size the more efficient the GPUs are as they perform the best when matrices they multiply are huge.",Wr,gl,cd="Now the performance optimization game starts. You can turn off some offload features or step down in ZeRO stages and increase/decrease batch size and again measure your effective throughput. Rinse and repeat until satisfied.",Rr,vl,rd="Don’t spend forever on it, but if you’re about to start a 3 months training - do spend a few days on it to find the most effective throughput-wise setup. So that your training cost will be the lowest and you will finish training faster. In the current crazy-paced ML world, if it takes you an extra month to train something you are likely to miss a golden opportunity. Of course, this is only me sharing an observation and in no way I’m trying to rush you. Before beginning to train BLOOM-176B I spent 2 days on this process and was able to increase throughput from 90 to 150 TFLOPs! This effort saved us more than one month of training time.",kr,_l,yd='These notes were written primarily for the training mode, but they should mostly apply for inference as well. For example, during inference Gradient Checkpointing is a no-op since it is only useful during training. Additionally, we found out that if you are doing a multi-GPU inference and not using <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">DeepSpeed-Inference</a>, <a href="https://huggingface.co/blog/bloom-inference-pytorch-scripts" rel="nofollow">Accelerate</a> should provide a superior performance.',Nr,Bl,jd="Other quick related performance notes:",Xr,Zl,Td='<li>if you are training something from scratch always try to have tensors with shapes that are divisible by 16 (e.g. hidden size). For batch size try divisible by 2 at least. There are <a href="https://developer.nvidia.com/blog/optimizing-gpu-performance-tensor-cores/" rel="nofollow">wave and tile quanitization</a> divisibility that is hardware-specific if you want to squeeze even higher performance from your GPUs.</li>',Qr,ql,Er,xl,hd="Activation checkpointing and gradient checkpointing are two distinct terms that refer to the same methodology. It’s very confusing but this is how it is.",Hr,$l,Jd="Gradient checkpointing allows one to trade speed for GPU memory, which either allows one to overcome a GPU OOM, or increase their batch size, which often leads to a better performance.",Vr,Sl,Ud="HF Transformers models don’t know anything about DeepSpeed’s activation checkpointing, so if you try to enable that feature in the DeepSpeed config file, nothing will happen.",Yr,zl,wd="Therefore you have two ways to take advantage of this very beneficial feature:",Fr,Gl,dd='<li>If you want to use a HF Transformers models you can do <code>model.gradient_checkpointing_enable()</code> or use <code>--gradient_checkpointing</code> in the HF Trainer, which will automatically enable this for you. <code>torch.utils.checkpoint</code> is used there.</li> <li>If you write your own model and you want to use DeepSpeed’s activation checkpointing you can use the <a href="https://deepspeed.readthedocs.io/en/latest/activation-checkpointing.html" rel="nofollow">API prescribed there</a>. You can also take the HF Transformers modeling code and replace <code>torch.utils.checkpoint</code> with the DeepSpeed’s API. The latter is more flexible since it allows you to offload the forward activations to the CPU memory instead of recalculating them.</li>',Lr,Wl,Dr,Rl,md=`As long as you don’t enable <code>offload_optimizer</code> you can mix and match DeepSpeed and HuggingFace schedulers and
optimizers, with the exception of using the combination of HuggingFace scheduler and DeepSpeed optimizer:`,Pr,kl,fd='<thead><tr><th align="left">Combos</th> <th align="left">HF Scheduler</th> <th align="left">DS Scheduler</th></tr></thead> <tbody><tr><td align="left">HF Optimizer</td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left">DS Optimizer</td> <td align="left">No</td> <td align="left">Yes</td></tr></tbody>',Or,Nl,Id=`It is possible to use a non-DeepSpeed optimizer when <code>offload_optimizer</code> is enabled, as long as it has both CPU and
GPU implementation (except LAMB).`,Kr,co,sy,Xl,ty,Ql,Cd=`DeepSpeed’s main optimizers are Adam, AdamW, OneBitAdam, and Lamb. These have been thoroughly tested with ZeRO and are
thus recommended to be used. It, however, can import other optimizers from <code>torch</code>. The full documentation is <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-parameters" rel="nofollow">here</a>.`,ey,El,bd=`If you don’t configure the <code>optimizer</code> entry in the configuration file, the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will
automatically set it to <code>AdamW</code> and will use the supplied values or the defaults for the following command line
arguments: <code>--learning_rate</code>, <code>--adam_beta1</code>, <code>--adam_beta2</code>, <code>--adam_epsilon</code> and <code>--weight_decay</code>.`,ly,Hl,Ad="Here is an example of the auto-configured <code>optimizer</code> entry for <code>AdamW</code>:",ay,Vl,ny,Yl,gd=`Note that the command line arguments will set the values in the configuration file. This is so that there is one
definitive source of the values and to avoid hard to find errors when for example, the learning rate is set to
different values in different places. Command line rules. The values that get overridden are:`,py,Fl,vd="<li><code>lr</code> with the value of <code>--learning_rate</code></li> <li><code>betas</code> with the value of <code>--adam_beta1 --adam_beta2</code></li> <li><code>eps</code> with the value of <code>--adam_epsilon</code></li> <li><code>weight_decay</code> with the value of <code>--weight_decay</code></li>",iy,Ll,_d="Therefore please remember to tune the shared hyperparameters on the command line.",oy,Dl,Bd="You can also set the values explicitly:",My,Pl,uy,Ol,Zd=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,cy,Kl,qd="If you want to use another optimizer which is not listed above, you will have to add to the top level configuration.",ry,sa,yy,ta,xd="Similarly to <code>AdamW</code>, you can configure other officially supported optimizers. Just remember that those may have different config values. e.g. for Adam you will want <code>weight_decay</code> around <code>0.01</code>.",jy,ea,$d="Additionally, offload works the best when it’s used with Deepspeed’s CPU Adam optimizer. If you want to use a different optimizer with offload, since <code>deepspeed==0.8.3</code> you need to also add:",Ty,la,hy,aa,Sd="to the top level configuration.",Jy,ro,Uy,na,wy,pa,zd=`DeepSpeed supports <code>LRRangeTest</code>, <code>OneCycle</code>, <code>WarmupLR</code> and <code>WarmupDecayLR</code> learning rate schedulers. The full
documentation is <a href="https://www.deepspeed.ai/docs/config-json/#scheduler-parameters" rel="nofollow">here</a>.`,dy,ia,Gd="Here is where the schedulers overlap between 🤗 Transformers and DeepSpeed:",my,oa,Wd=`<li><code>WarmupLR</code> via <code>--lr_scheduler_type constant_with_warmup</code></li> <li><code>WarmupDecayLR</code> via <code>--lr_scheduler_type linear</code>. This is also the default value for <code>--lr_scheduler_type</code>,
therefore, if you don’t configure the scheduler this is scheduler that will get configured by default.</li>`,fy,Ma,Rd=`If you don’t configure the <code>scheduler</code> entry in the configuration file, the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will use
the values of <code>--lr_scheduler_type</code>, <code>--learning_rate</code> and <code>--warmup_steps</code> or <code>--warmup_ratio</code> to configure a
🤗 Transformers version of it.`,Iy,ua,kd="Here is an example of the auto-configured <code>scheduler</code> entry for <code>WarmupLR</code>:",Cy,ca,by,ra,Nd=`Since <em>“auto”</em> is used the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments will set the correct values in the configuration
file. This is so that there is one definitive source of the values and to avoid hard to find errors when, for example,
the learning rate is set to different values in different places. Command line rules. The values that get set are:`,Ay,ya,Xd=`<li><code>warmup_min_lr</code> with the value of <code>0</code>.</li> <li><code>warmup_max_lr</code> with the value of <code>--learning_rate</code>.</li> <li><code>warmup_num_steps</code> with the value of <code>--warmup_steps</code> if provided. Otherwise will use <code>--warmup_ratio</code>
multiplied by the number of training steps and rounded up.</li> <li><code>total_num_steps</code> with either the value of <code>--max_steps</code> or if it is not provided, derived automatically at run
time based on the environment and the size of the dataset and other command line arguments (needed for
<code>WarmupDecayLR</code>).</li>`,gy,ja,Qd="You can, of course, take over any or all of the configuration values and set those yourself:",vy,Ta,_y,ha,Ed=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,By,Ja,Hd="For example, for <code>WarmupDecayLR</code>, you can use the following entry:",Zy,Ua,qy,wa,Vd="and <code>total_num_steps</code>, <code>warmup_max_lr</code>, <code>warmup_num_steps</code> and <code>total_num_steps</code> will be set at loading time.",xy,yo,$y,da,Sy,ma,Yd="Deepspeed supports the full fp32 and the fp16 mixed precision.",zy,fa,Fd=`Because of the much reduced memory needs and faster speed one gets with the fp16 mixed precision, the only time you
will want to not use it is when the model you’re using doesn’t behave well under this training mode. Typically this
happens when the model wasn’t pretrained in the fp16 mixed precision (e.g. often this happens with bf16-pretrained
models). Such models may overflow or underflow leading to <code>NaN</code> loss. If this is your case then you will want to use
the full fp32 mode, by explicitly disabling the otherwise default fp16 mixed precision mode with:`,Gy,Ia,Wy,Ca,Ld=`If you’re using the Ampere-architecture based GPU, pytorch version 1.7 and higher will automatically switch to using
the much more efficient tf32 format for some operations, but the results will still be in fp32. For details and
benchmarks, please, see <a href="https://pytorch.org/docs/stable/notes/cuda.html#tensorfloat-32-tf32-on-ampere-devices" rel="nofollow">TensorFloat-32(TF32) on Ampere devices</a>. The document includes
instructions on how to disable this automatic conversion if for some reason you prefer not to use it.`,Ry,ba,Dd="With the 🤗 Trainer you can use <code>--tf32</code> to enable it, or disable it with <code>--tf32 0</code> or <code>--no_tf32</code>. By default the PyTorch default is used.",ky,jo,Ny,Aa,Xy,ga,Pd="You can use automatic mixed precision with either a pytorch-like AMP way or the apex-like way:",Qy,va,Ey,_a,Od="To configure pytorch AMP-like mode with fp16 (float16) set:",Hy,Ba,Vy,Za,Kd=`and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically enable or disable it based on the value of
<code>args.fp16_backend</code>. The rest of config values are up to you.`,Yy,qa,sm="This mode gets enabled when <code>--fp16 --fp16_backend amp</code> or <code>--fp16_full_eval</code> command line args are passed.",Fy,xa,tm="You can also enable/disable this mode explicitly:",Ly,$a,Dy,Sa,em=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Py,za,lm='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#fp16-training-options" rel="nofollow">documentation</a>.',Oy,Ga,Ky,Wa,am="If bf16 (bfloat16) is desired instead of fp16 then the following configuration section is to be used:",sj,Ra,tj,ka,nm="bf16 has the same dynamic range as fp32 and thus doesn’t require loss scaling.",ej,Na,pm="This mode gets enabled when <code>--bf16</code> or <code>--bf16_full_eval</code> command line args are passed.",lj,Xa,im="You can also enable/disable this mode explicitly:",aj,Qa,nj,z,pj,Ea,ij,Ha,om="There is the <code>dtype</code> of the training regime and there is a separate <code>dtype</code> that is used for communication collectives like various reduction and gathering/scattering operations.",oj,Va,Mm="All gather/scatter ops are performed in the same <code>dtype</code> the data is in, so if you’re using bf16 training regime it gets gathered in bf16 - gathering is a non-lossy operation.",Mj,Ya,um="Various reduce operations can be quite lossy, for example when gradients are averaged across multiple-gpus, if the communications are done in fp16 or bf16 the outcome is likely be lossy - since when one ads multiple numbers in low precision the result isn’t exact. More so with bf16 as it has a lower precision than fp16. Often fp16 is good enough as the loss is minimal when averaging grads which are typically very small. Therefore, by default for half precision training fp16 is used as the default for reduction operations. But you have full control over this functionality and if you choose you can add a small overhead and ensure that reductions will be using fp32 as the accumulation dtype and only when the result is ready it’ll get downcast to the half precision <code>dtype</code> you’re training in.",uj,Fa,cm="In order to override the default you simply add a new configuration entry:",cj,La,rj,Da,rm="The valid values as of this writing are “fp16”, “bfp16”, “fp32”.",yj,Pa,ym="note: stage zero 3 had a bug with regards to bf16 comm dtype that was fixed in <code>deepspeed==0.8.1</code>",jj,Oa,Tj,Ka,jm="To configure apex AMP-like mode set:",hj,sn,Jj,tn,Tm=`and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically configure it based on the values of <code>args.fp16_backend</code> and
<code>args.fp16_opt_level</code>.`,Uj,en,hm="This mode gets enabled when <code>--fp16 --fp16_backend apex --fp16_opt_level 01</code> command line args are passed.",wj,ln,Jm="You can also configure this mode explicitly:",dj,an,mj,nn,Um=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,fj,pn,wm='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#automatic-mixed-precision-amp-training-options" rel="nofollow">documentation</a>.',Ij,To,Cj,on,bj,Mn,dm="To configure batch size, use:",Aj,un,gj,cn,mm=`and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set <code>train_micro_batch_size_per_gpu</code> to the value of
<code>args.per_device_train_batch_size</code> and <code>train_batch_size</code> to <code>args.world_size * args.per_device_train_batch_size * args.gradient_accumulation_steps</code>.`,vj,rn,fm="You can also set the values explicitly:",_j,yn,Bj,jn,Im=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Zj,ho,qj,Tn,xj,hn,Cm="To configure gradient accumulation set:",$j,Jn,Sj,Un,bm='and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.gradient_accumulation_steps</code>.',zj,wn,Am="You can also set the value explicitly:",Gj,dn,Wj,mn,gm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Rj,Jo,kj,fn,Nj,In,vm="To configure gradient gradient clipping set:",Xj,Cn,Qj,bn,_m='and the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.max_grad_norm</code>.',Ej,An,Bm="You can also set the value explicitly:",Hj,gn,Vj,vn,Zm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Yj,Uo,Fj,_n,Lj,Bn,qm=`As long as you continue training and resuming using DeepSpeed you don’t need to worry about anything. DeepSpeed stores
fp32 master weights in its custom checkpoint optimizer files, which are <code>global_step*/*optim_states.pt</code> (this is glob
pattern), and are saved under the normal checkpoint.`,Dj,Zn,xm="<strong>FP16 Weights:</strong>",Pj,qn,$m=`When a model is saved under ZeRO-2, you end up having the normal <code>pytorch_model.bin</code> file with the model weights, but
they are only the fp16 version of the weights.`,Oj,xn,Sm=`Under ZeRO-3, things are much more complicated, since the model weights are partitioned out over multiple GPUs,
therefore <code>&quot;stage3_gather_16bit_weights_on_model_save&quot;: true</code> is required to get the <code>Trainer</code> to save the fp16
version of the weights. If this setting is <code>False</code> <code>pytorch_model.bin</code> won’t be created. This is because by default DeepSpeed’s <code>state_dict</code> contains a placeholder and not the real weights. If we were to save this <code>state_dict</code> it won’t be possible to load it back.`,Kj,$n,sT,Sn,zm="<strong>FP32 Weights:</strong>",tT,zn,Gm=`While the fp16 weights are fine for resuming training, if you finished finetuning your model and want to upload it to
the <a href="https://huggingface.co/models" rel="nofollow">models hub</a> or pass it to someone else you most likely will want to get the fp32
weights. This ideally shouldn’t be done during training since this is a process that requires a lot of memory, and
therefore best to be performed offline after the training is complete. But if desired and you have plenty of free CPU
memory it can be done in the same training script. The following sections will discuss both approaches.`,eT,Gn,Wm="<strong>Live FP32 Weights Recovery:</strong>",lT,Wn,Rm="This approach may not work if you model is large and you have little free CPU memory left, at the end of the training.",aT,Rn,km="If you have saved at least one checkpoint, and you want to use the latest one, you can do the following:",nT,kn,pT,Nn,Nm=`If you’re using the <code>--load_best_model_at_end</code> class:<em>~transformers.TrainingArguments</em> argument (to track the best
checkpoint), then you can finish the training by first saving the final model explicitly and then do the same as above:`,iT,Xn,oT,G,MT,Qn,Xm=`Of course, you don’t have to use class:<em>~transformers.Trainer</em> and you can adjust the examples above to your own
trainer.`,uT,En,Qm=`If for some reason you want more refinement, you can also extract the fp32 <code>state_dict</code> of the weights and apply
these yourself as is shown in the following example:`,cT,Hn,rT,Vn,Em="<strong>Offline FP32 Weights Recovery:</strong>",yT,Yn,Hm=`DeepSpeed creates a special conversion script <code>zero_to_fp32.py</code> which it places in the top-level of the checkpoint
folder. Using this script you can extract the weights at any point. The script is standalone and you no longer need to
have the configuration file or a <code>Trainer</code> to do the extraction.`,jT,Fn,Vm="Let’s say your checkpoint folder looks like this:",TT,Ln,hT,Dn,Ym=`In this example there is just one DeepSpeed checkpoint sub-folder <em>global_step1</em>. Therefore to reconstruct the fp32
weights just run:`,JT,Pn,UT,On,Fm="This is it. <code>pytorch_model.bin</code> will now contain the full fp32 model weights consolidated from multiple GPUs.",wT,Kn,Lm="The script will automatically be able to handle either a ZeRO-2 or ZeRO-3 checkpoint.",dT,sp,Dm="<code>python zero_to_fp32.py -h</code> will give you usage details.",mT,tp,Pm=`The script will auto-discover the deepspeed sub-folder using the contents of the file <code>latest</code>, which in the current
example will contain <code>global_step1</code>.`,fT,ep,Om="Note: currently the script requires 2x general RAM of the final fp32 model weights.",IT,lp,CT,ap,Km="ZeRO-3 is quite different from ZeRO-2 because of its param sharding feature.",bT,np,sf="ZeRO-Infinity further extends ZeRO-3 to support NVMe memory and multiple other speed and scalability improvements.",AT,pp,tf=`While all the efforts were made for things to just work without needing any special changes to your models, in certain
circumstances you may find the following information to be needed.`,gT,ip,vT,op,ef=`DeepSpeed/ZeRO-3 can handle models with Trillions of parameters which may not fit onto the existing RAM. In such cases,
but also if you want the initialization to happen much faster, initialize the model using <em>deepspeed.zero.Init()</em>
context manager (which is also a function decorator), like so:`,_T,Mp,BT,up,lf="As you can see this gives you a randomly initialized model.",ZT,cp,af=`If you want to use a pretrained model, <code>model_class.from_pretrained</code> will activate this feature as long as
<code>is_deepspeed_zero3_enabled()</code> returns <code>True</code>, which currently is setup by the
<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object if the passed DeepSpeed configuration file contains ZeRO-3 config
section. Thus you must create the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object <strong>before</strong> calling
<code>from_pretrained</code>. Here is an example of a possible sequence:`,qT,rp,xT,yp,nf=`If you’re using the official example scripts and your command line arguments include <code>--deepspeed ds_config.json</code>
with ZeRO-3 config enabled, then everything is already done for you, since this is how example scripts are written.`,$T,jp,pf="Note: If the fp16 weights of the model can’t fit onto the memory of a single GPU this feature must be used.",ST,Tp,of='For full details on this method and other related features please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#constructing-massive-models" rel="nofollow">Constructing Massive Models</a>.',zT,hp,Mf=`Also when loading fp16-pretrained models, you will want to tell <code>from_pretrained</code> to use
<code>torch_dtype=torch.float16</code>. For details, please, see <a href="#from_pretrained-torch-dtype">from_pretrained-torch-dtype</a>.`,GT,Jp,WT,Up,uf=`Under ZeRO-3 on multiple GPUs no single GPU has all the parameters unless it’s the parameters for the currently
executing layer. So if you need to access all parameters from all layers at once there is a specific method to do it.
Most likely you won’t need it, but if you do please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#manual-parameter-coordination" rel="nofollow">Gathering Parameters</a>`,RT,wp,cf=`We do however use it internally in several places, one such example is when loading pretrained model weights in
<code>from_pretrained</code>. We load one layer at a time and immediately partition it to all participating GPUs, as for very
large models it won’t be possible to load it on one GPU and then spread it out to multiple GPUs, due to memory
limitations.`,kT,dp,rf="Also under ZeRO-3, if you write your own code and run into a model parameter weight that looks like:",NT,mp,XT,fp,yf=`stress on <code>tensor([1.])</code>, or if you get an error where it says the parameter is of size <code>1</code>, instead of some much
larger multi-dimensional shape, this means that the parameter is partitioned and what you see is a ZeRO-3 placeholder.`,QT,wo,ET,Ip,HT,Cp,jf=`ZeRO Inference uses the same config as ZeRO-3 Training. You just don’t need the optimizer and scheduler sections. In
fact you can leave these in the config file if you want to share the same one with the training. They will just be
ignored.`,VT,bp,Tf='Otherwise you just need to pass the usual <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments. For example:',YT,Ap,FT,gp,hf=`The only important thing is that you need to use a ZeRO-3 configuration, since ZeRO-2 provides no benefit whatsoever
for the inference as only ZeRO-3 performs sharding of parameters, whereas ZeRO-1 shards gradients and optimizer states.`,LT,vp,Jf="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",DT,_p,PT,Bp,Uf=`Since for inference there is no need for additional large memory used by the optimizer states and the gradients you
should be able to fit much larger batches and/or sequence length onto the same hardware.`,OT,Zp,wf=`Additionally DeepSpeed is currently developing a related product called Deepspeed-Inference which has no relationship
to the ZeRO technology, but instead uses tensor parallelism to scale models that can’t fit onto a single GPU. This is a
work in progress and we will provide the integration once that product is complete.`,KT,qp,sh,xp,df="Since Deepspeed ZeRO can offload memory to CPU (and NVMe) the framework provides utils that allow one to tell how much CPU and GPU memory will be needed depending on the number of GPUs being used.",th,$p,mf="Let’s estimate how much memory is needed to finetune “bigscience/T0_3B” on a single GPU:",eh,Sp,lh,zp,ff="So you can fit it on a single 80GB GPU and no CPU offload, or a tiny 8GB GPU but then need ~60GB of CPU memory. (Remember this is just the memory for params, optimizer states and gradients - you will need a bit more memory for cuda kernels, activations and temps.)",ah,Gp,If="Then it’s a tradeoff of cost vs speed. It’ll be cheaper to buy/rent a smaller GPU (or less GPUs since you can use multiple GPUs with Deepspeed ZeRO. But then it’ll be slower, so even if you don’t care about how fast something will be done, the slowdown has a direct impact on the duration of using the GPU and thus bigger cost. So experiment and compare which works the best.",nh,Wp,Cf="If you have enough GPU memory make sure to disable the CPU/NVMe offload as it’ll make everything faster.",ph,Rp,bf="For example, let’s repeat the same for 2 GPUs:",ih,kp,oh,Np,Af="So here you’d want 2x 32GB GPUs or higher without offloading to CPU.",Mh,Xp,gf='For full information please see <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">memory estimators</a>.',uh,Qp,ch,Ep,vf="Here is how to file an issue so that we could quickly get to the bottom of the issue and help you to unblock your work.",rh,Hp,_f="In your report please always include:",yh,C,mo,Bf="<p>the full Deepspeed config file in the report</p>",JJ,fo,Zf=`<p>either the command line arguments if you were using the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> or
<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments if you were scripting the Trainer setup yourself. Please do not
dump the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> as it has dozens of entries that are irrelevant.</p>`,UJ,Vp,Io,qf="Output of:",wJ,Yp,dJ,Co,xf=`<p>If possible include a link to a Google Colab notebook that we can reproduce the problem with. You can use this
<a href="https://github.com/stas00/porting/blob/master/transformers/deepspeed/DeepSpeed_on_colab_CLI.ipynb" rel="nofollow">notebook</a> as
a starting point.</p>`,mJ,bo,$f="<p>Unless it’s impossible please always use a standard dataset that we can use and not something custom.</p>",fJ,Ao,Sf='<p>If possible try to use one of the existing <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch" rel="nofollow">examples</a> to reproduce the problem with.</p>',jh,Fp,zf="Things to consider:",Th,Lp,Gf=`<li><p>Deepspeed is often not the cause of the problem.</p> <p>Some of the filed issues proved to be Deepspeed-unrelated. That is once Deepspeed was removed from the setup, the
problem was still there.</p> <p>Therefore, if it’s not absolutely obvious it’s a DeepSpeed-related problem, as in you can see that there is an
exception and you can see that DeepSpeed modules are involved, first re-test your setup without DeepSpeed in it.
And only if the problem persists then do mentioned Deepspeed and supply all the required details.</p></li> <li><p>If it’s clear to you that the issue is in the DeepSpeed core and not the integration part, please file the Issue
directly with <a href="https://github.com/microsoft/DeepSpeed/" rel="nofollow">Deepspeed</a>. If you aren’t sure, please do not worry,
either Issue tracker will do, we will figure it out once you posted it and redirect you to another Issue tracker if
need be.</p></li>`,hh,Dp,Jh,Pp,Uh,Op,Wf=`If the <code>deepspeed</code> process gets killed at launch time without a traceback, that usually means that the program tried
to allocate more CPU memory than your system has or your process is allowed to allocate and the OS kernel killed that
process. This is because your configuration file most likely has either <code>offload_optimizer</code> or <code>offload_param</code> or
both configured to offload to <code>cpu</code>. If you have NVMe, experiment with offloading to NVMe if you’re running under
ZeRO-3. Here is how you can <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">estimate how much memory is needed for a specific model</a>.`,wh,Kp,dh,si,Rf="This often happens when one takes a model pre-trained in bf16 mixed precision mode and tries to use it under fp16 (with or without mixed precision). Most models trained on TPU and often the ones released by Google are in this category (e.g. almost all t5-based models). Here the solution is to either use fp32 or bf16 if your hardware supports it (TPU, Ampere GPUs or newer).",mh,ti,kf="The other problem may have to do with using fp16. When you configure this section:",fh,ei,Ih,li,Nf="and you see in your log that Deepspeed reports <code>OVERFLOW!</code> as follows:",Ch,ai,bh,ni,Xf="that means that the Deepspeed loss scaler can’t figure out a scaling co-efficient that overcomes loss overflow.",Ah,pi,Qf="(the log was massaged to be more readable here.)",gh,ii,Ef="In this case you usually need to raise the value of <code>initial_scale_power</code>. Setting it to <code>&quot;initial_scale_power&quot;: 32</code> will typically resolve the problem.",vh,oi,_h,Mi,Hf=`<li>DeepSpeed works with the PyTorch <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> but not TF <code>TFTrainer</code>.</li> <li>While DeepSpeed has a pip installable PyPI package, it is highly recommended that it gets installed from <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">source</a> to best match your hardware and also if you need to enable
certain features, like 1-bit Adam, which aren’t available in the pypi distribution.</li> <li>You don’t have to use the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> to use DeepSpeed with 🤗 Transformers - you can use any model
with your own trainer, and you will have to adapt the latter according to <a href="https://www.deepspeed.ai/getting-started/#writing-deepspeed-models" rel="nofollow">the DeepSpeed integration instructions</a>.</li>`,Bh,ui,Zh,ci,Vf=`The <a href="/docs/transformers/v4.36.1/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> is used to integrate Deepspeed into the 🤗 Transformers core
functionality, when <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> is not used. The only thing that it does is handling Deepspeed ZeRO-3 param gathering and automatically splitting the model onto multiple gpus during <code>from_pretrained</code> call. Everything else you have to do by yourself.`,qh,ri,Yf='When using <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> everything is automatically taken care of.',xh,yi,Ff=`When not using <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>, to efficiently deploy DeepSpeed ZeRO-3, you must instantiate the
<a href="/docs/transformers/v4.36.1/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> object before instantiating the model and keep that object alive.`,$h,ji,Lf="If you’re using Deepspeed ZeRO-1 or ZeRO-2 you don’t need to use <code>HfDeepSpeedConfig</code> at all.",Sh,Ti,Df="For example for a pretrained model:",zh,hi,Gh,Ji,Pf="or for non-pretrained model:",Wh,Ui,Rh,wi,Of='Please note that if you’re not using the <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> integration, you’re completely on your own. Basically follow the documentation on the <a href="https://www.deepspeed.ai/" rel="nofollow">Deepspeed</a> website. Also you have to configure explicitly the config file - you can’t use <code>&quot;auto&quot;</code> values and you will have to put real values instead.',kh,di,Nh,_,mi,IJ,go,Kf="This object contains a DeepSpeed configuration dictionary and can be quickly queried for things like zero stage.",CJ,vo,sI=`A <code>weakref</code> of this object is stored in the module’s globals to be able to access the config from areas where
things like the Trainer object is not available (e.g. <code>from_pretrained</code> and <code>_get_resized_embeddings</code>). Therefore
it’s important that this object remains alive while the program is still running.`,bJ,_o,tI=`<a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> uses the <code>HfTrainerDeepSpeedConfig</code> subclass instead. That subclass has logic to sync the configuration
with values of <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> by replacing special placeholder values: <code>&quot;auto&quot;</code>. Without this special logic
the DeepSpeed configuration is not modified in any way.`,Xh,fi,Qh,Ii,eI='Here is an example of how one could do DeepSpeed ZeRO Inference without using <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> when one can’t fit a model onto a single GPU. The solution includes using additional GPUs or/and offloading GPU memory to CPU memory.',Eh,Ci,lI="The important nuance to understand here is that the way ZeRO is designed you can process different inputs on different GPUs in parallel.",Hh,bi,aI="The example has copious notes and is self-documenting.",Vh,Ai,nI="Make sure to:",Yh,gi,pI="<li>disable CPU offload if you have enough GPU memory (since it slows things down)</li> <li>enable bf16 if you own an Ampere or a newer GPU to make things faster. If you don’t have that hardware you may enable fp16 as long as you don’t use any model that was pre-trained in bf16 mixed precision (such as most t5 models). These usually overflow in fp16 and you will see garbage as output.</li>",Fh,vi,Lh,_i,iI="Let’s save it as <code>t0.py</code> and run it:",Dh,Bi,Ph,Zi,oI="This was a very basic example and you will want to adapt it to your needs.",Oh,qi,Kh,xi,MI="When using multiple GPUs with ZeRO Stage-3, one has to synchronize the GPUs by calling <code>generate(..., synced_gpus=True)</code>. If this is not done if one GPU finished generating before other GPUs the whole system will hang as the rest of the GPUs will not be able to received the shard of weights from the GPU that stopped generating.",sJ,$i,uI="Starting from <code>transformers&gt;=4.28</code>, if <code>synced_gpus</code> isn’t explicitly specified, it’ll be set to <code>True</code> automatically if these conditions are detected. But you can still override the value of <code>synced_gpus</code> if need to.",tJ,Si,eJ,zi,cI="If you submit a PR that involves DeepSpeed integration please note our CircleCI PR CI setup has no GPUs, so we only run tests requiring gpus on a different CI nightly. Therefore if you get a green CI report in your PR it doesn’t mean DeepSpeed tests pass.",lJ,Gi,rI="To run DeepSpeed tests, please run at least:",aJ,Wi,nJ,Ri,yI="If you changed any of the modeling or pytorch examples code, then run the model zoo tests as well. The following will run all DeepSpeed tests:",pJ,ki,iJ,Ni,oJ,Xi,jI='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',MJ,Qi,TI="Papers:",uJ,Ei,hI='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li>',cJ,Hi,JI=`Finally, please, remember that, HuggingFace <a href="/docs/transformers/v4.36.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,rJ,Zo,yJ;return B=new h({props:{title:"DeepSpeed Integration",local:"deepspeed-integration",headingTag:"h1"}}),D=new h({props:{title:"Trainer Deepspeed Integration",local:"trainer-deepspeed-integration",headingTag:"h2"}}),P=new h({props:{title:"Installation",local:"installation",headingTag:"h3"}}),K=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRlZXBzcGVlZA==",highlighted:"pip install deepspeed",wrap:!1}}),ts=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QmRlZXBzcGVlZCU1RA==",highlighted:"pip install transformers[deepspeed]",wrap:!1}}),ps=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMHBpcCUyMGluc3RhbGwlMjAuJTIwJTVDJTBBLS1nbG9iYWwtb3B0aW9uJTNEJTIyYnVpbGRfZXh0JTIyJTIwLS1nbG9iYWwtb3B0aW9uJTNEJTIyLWo4JTIyJTIwLS1uby1jYWNoZSUyMC12JTIwJTVDJTBBLS1kaXNhYmxlLXBpcC12ZXJzaW9uLWNoZWNrJTIwMiUzRSUyNjElMjAlN0MlMjB0ZWUlMjBidWlsZC5sb2c=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 pip install . \\
--global-option=<span class="hljs-string">&quot;build_ext&quot;</span> --global-option=<span class="hljs-string">&quot;-j8&quot;</span> --no-cache -v \\
--disable-pip-version-check 2&gt;&amp;1 | <span class="hljs-built_in">tee</span> build.log`,wrap:!1}}),Ms=new T({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9jYXBhYmlsaXR5KCkpJTIy",highlighted:'CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_capability())&quot;</span>',wrap:!1}}),rs=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMCU1QyUwQXB5dGhvbiUyMHNldHVwLnB5JTIwYnVpbGRfZXh0JTIwLWo4JTIwYmRpc3Rfd2hlZWw=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 \\
python setup.py build_ext -j8 bdist_wheel`,wrap:!1}}),Js=new T({props:{code:"cHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2FyY2hfbGlzdCgpKSUyMg==",highlighted:'python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_arch_list())&quot;</span>',wrap:!1}}),ws=new T({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMCU1QyUwQXByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKHRvcmNoLmRldmljZSgnY3VkYScpKSklMjI=",highlighted:`CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; \\
print(torch.cuda.get_device_properties(torch.device(&#x27;cuda&#x27;)))&quot;</span>`,wrap:!1}}),ms=new T({props:{code:"X0N1ZGFEZXZpY2VQcm9wZXJ0aWVzKG5hbWUlM0QnR2VGb3JjZSUyMFJUWCUyMDMwOTAnJTJDJTIwbWFqb3IlM0Q4JTJDJTIwbWlub3IlM0Q2JTJDJTIwdG90YWxfbWVtb3J5JTNEMjQyNjhNQiUyQyUyMG11bHRpX3Byb2Nlc3Nvcl9jb3VudCUzRDgyKQ==",highlighted:'_CudaDeviceProperties(name=<span class="hljs-string">&#x27;GeForce RTX 3090&#x27;</span>, major=8, minor=6, total_memory=24268MB, multi_processor_count=82)',wrap:!1}}),bs=new h({props:{title:"Deployment with multiple GPUs",local:"deployment-with-multiple-gpus",headingTag:"h3"}}),vs=new T({props:{code:"dG9yY2guZGlzdHJpYnV0ZWQucnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"torch.distributed.run --nproc_per_node=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json",wrap:!1}}),Bs=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json",wrap:!1}}),$s=new T({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLWZwMTYlMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUyMDUwMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEEtLWRhdGFzZXRfbmFtZSUyMHdtdDE2JTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJv",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`,wrap:!1}}),Gs=new h({props:{title:"Deployment with one GPU",local:"deployment-with-one-gpu",headingTag:"h3"}}),Rs=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDElMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMCU1QyUwQS0tZGVlcHNwZWVkJTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZkc19jb25maWdfemVybzIuanNvbiUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdDUtc21hbGwlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEEtLW91dHB1dF9kaXIlMjBvdXRwdXRfZGlyJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMC0tZnAxNiUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW1heF90cmFpbl9zYW1wbGVzJTIwNTAwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMSUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwd210MTYlMjAtLWRhdGFzZXRfY29uZmlnJTIwJTIycm8tZW4lMjIlMjAlNUMlMEEtLXNvdXJjZV9sYW5nJTIwZW4lMjAtLXRhcmdldF9sYW5nJTIwcm8=",highlighted:`deepspeed --num_gpus=1 examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero2.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`,wrap:!1}}),Es=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX3NjYXR0ZXIlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
     <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
     <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ls=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1pbmNsdWRlJTIwbG9jYWxob3N0JTNBMSUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:"deepspeed --include localhost:1 examples/pytorch/translation/run_translation.py ...",wrap:!1}}),Ds=new h({props:{title:"Deployment with multiple Nodes",local:"deployment-with-multiple-nodes",headingTag:"h3"}}),Ks=new h({props:{title:"The torch.distributed.run(torchrun) launcher",local:"the-torchdistributedruntorchrun-launcher",headingTag:"h4"}}),tt=new T({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEOCUyMC0tbm5vZGUlM0QyJTIwLS1ub2RlX3JhbmslM0QwJTIwLS1tYXN0ZXJfYWRkciUzRGhvc3RuYW1lMSUyMCU1QyUwQS0tbWFzdGVyX3BvcnQlM0Q5OTAxJTIweW91cl9wcm9ncmFtLnB5JTIwJTNDbm9ybWFsJTIwY2wlMjBhcmdzJTNFJTIwLS1kZWVwc3BlZWQlMjBkc19jb25maWcuanNvbg==",highlighted:`python -m torch.distributed.run --nproc_per_node=8 --nnode=2 --node_rank=0 --master_addr=hostname1 \\
--master_port=9901 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`,wrap:!1}}),at=new h({props:{title:"The deepspeed launcher",local:"the-deepspeed-launcher",headingTag:"h4"}}),pt=new T({props:{code:"aG9zdG5hbWUxJTIwc2xvdHMlM0Q4JTBBaG9zdG5hbWUyJTIwc2xvdHMlM0Q4",highlighted:`hostname1 <span class="hljs-attribute">slots</span>=8
hostname2 <span class="hljs-attribute">slots</span>=8`,wrap:!1}}),ot=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDglMjAtLW51bV9ub2RlcyUyMDIlMjAtLWhvc3RmaWxlJTIwaG9zdGZpbGUlMjAtLW1hc3Rlcl9hZGRyJTIwaG9zdG5hbWUxJTIwLS1tYXN0ZXJfcG9ydCUzRDk5MDElMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:`deepspeed --num_gpus 8 --num_nodes 2 --hostfile hostfile --master_addr hostname1 --master_port=9901 \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`,wrap:!1}}),ct=new h({props:{title:"Launching in a SLURM environment",local:"launching-in-a-slurm-environment",headingTag:"h4"}}),yt=new T({props:{code:"JTIzU0JBVENIJTIwLS1qb2ItbmFtZSUzRHRlc3Qtbm9kZXMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBuYW1lJTBBJTIzU0JBVENIJTIwLS1ub2RlcyUzRDIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub2RlcyUwQSUyM1NCQVRDSCUyMC0tbnRhc2tzLXBlci1ub2RlJTNEMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNydWNpYWwlMjAtJTIwb25seSUyMDElMjB0YXNrJTIwcGVyJTIwZGlzdCUyMHBlciUyMG5vZGUhJTBBJTIzU0JBVENIJTIwLS1jcHVzLXBlci10YXNrJTNEMTAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBudW1iZXIlMjBvZiUyMGNvcmVzJTIwcGVyJTIwdGFza3MlMEElMjNTQkFUQ0glMjAtLWdyZXMlM0RncHUlM0E4JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbnVtYmVyJTIwb2YlMjBncHVzJTBBJTIzU0JBVENIJTIwLS10aW1lJTIwMjAlM0EwMCUzQTAwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGV4ZWN1dGlvbiUyMHRpbWUlMjAoSEglM0FNTSUzQVNTKSUwQSUyM1NCQVRDSCUyMC0tb3V0cHV0JTNEJTI1eC0lMjVqLm91dCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG91dHB1dCUyMGZpbGUlMjBuYW1lJTBBJTBBZXhwb3J0JTIwR1BVU19QRVJfTk9ERSUzRDglMEFleHBvcnQlMjBNQVNURVJfQUREUiUzRCUyNChzY29udHJvbCUyMHNob3clMjBob3N0bmFtZXMlMjAlMjRTTFVSTV9KT0JfTk9ERUxJU1QlMjAlN0MlMjBoZWFkJTIwLW4lMjAxKSUwQWV4cG9ydCUyME1BU1RFUl9QT1JUJTNEOTkwMSUwQSUwQXNydW4lMjAtLWpvYmlkJTIwJTI0U0xVUk1fSk9CSUQlMjBiYXNoJTIwLWMlMjAncHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAlNUMlMEElMjAtLW5wcm9jX3Blcl9ub2RlJTIwJTI0R1BVU19QRVJfTk9ERSUyMC0tbm5vZGVzJTIwJTI0U0xVUk1fTk5PREVTJTIwLS1ub2RlX3JhbmslMjAlMjRTTFVSTV9QUk9DSUQlMjAlNUMlMEElMjAtLW1hc3Rlcl9hZGRyJTIwJTI0TUFTVEVSX0FERFIlMjAtLW1hc3Rlcl9wb3J0JTIwJTI0TUFTVEVSX1BPUlQlMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29uJw==",highlighted:`<span class="hljs-comment">#SBATCH --job-name=test-nodes        # name</span>
<span class="hljs-comment">#SBATCH --nodes=2                    # nodes</span>
<span class="hljs-comment">#SBATCH --ntasks-per-node=1          # crucial - only 1 task per dist per node!</span>
<span class="hljs-comment">#SBATCH --cpus-per-task=10           # number of cores per tasks</span>
<span class="hljs-comment">#SBATCH --gres=gpu:8                 # number of gpus</span>
<span class="hljs-comment">#SBATCH --time 20:00:00              # maximum execution time (HH:MM:SS)</span>
<span class="hljs-comment">#SBATCH --output=%x-%j.out           # output file name</span>

<span class="hljs-built_in">export</span> GPUS_PER_NODE=8
<span class="hljs-built_in">export</span> MASTER_ADDR=$(scontrol show hostnames <span class="hljs-variable">$SLURM_JOB_NODELIST</span> | <span class="hljs-built_in">head</span> -n 1)
<span class="hljs-built_in">export</span> MASTER_PORT=9901

srun --jobid <span class="hljs-variable">$SLURM_JOBID</span> bash -c <span class="hljs-string">&#x27;python -m torch.distributed.run \\
 --nproc_per_node $GPUS_PER_NODE --nnodes $SLURM_NNODES --node_rank $SLURM_PROCID \\
 --master_addr $MASTER_ADDR --master_port $MASTER_PORT \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json&#x27;</span>`,wrap:!1}}),Tt=new T({props:{code:"c2JhdGNoJTIwbGF1bmNoLnNsdXJt",highlighted:"sbatch launch.slurm",wrap:!1}}),Jt=new h({props:{title:"Use of Non-shared filesystem",local:"use-of-non-shared-filesystem",headingTag:"h4"}}),wt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyY2hlY2twb2ludCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVzZV9ub2RlX2xvY2FsX3N0b3JhZ2UlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;checkpoint&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;use_node_local_storage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),mt=new h({props:{title:"Deployment in Notebooks",local:"deployment-in-notebooks",headingTag:"h3"}}),Ct=new T({props:{code:"JTIzJTIwRGVlcFNwZWVkJTIwcmVxdWlyZXMlMjBhJTIwZGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUyMGV2ZW4lMjB3aGVuJTIwb25seSUyMG9uZSUyMHByb2Nlc3MlMjBpcyUyMHVzZWQuJTBBJTIzJTIwVGhpcyUyMGVtdWxhdGVzJTIwYSUyMGxhdW5jaGVyJTIwaW4lMjB0aGUlMjBub3RlYm9vayUwQWltcG9ydCUyMG9zJTBBJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9BRERSJTIyJTVEJTIwJTNEJTIwJTIybG9jYWxob3N0JTIyJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9QT1JUJTIyJTVEJTIwJTNEJTIwJTIyOTk5NCUyMiUyMCUyMCUyMyUyMG1vZGlmeSUyMGlmJTIwUnVudGltZUVycm9yJTNBJTIwQWRkcmVzcyUyMGFscmVhZHklMjBpbiUyMHVzZSUwQW9zLmVudmlyb24lNUIlMjJSQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJMT0NBTF9SQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJXT1JMRF9TSVpFJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyME5vdyUyMHByb2NlZWQlMjBhcyUyMG5vcm1hbCUyQyUyMHBsdXMlMjBwYXNzJTIwdGhlJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwZmlsZSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0QlMjJkc19jb25maWdfemVybzMuanNvbiUyMiklMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciguLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># DeepSpeed requires a distributed environment even when only one process is used.</span>
<span class="hljs-comment"># This emulates a launcher in the notebook</span>
<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;MASTER_ADDR&quot;</span>] = <span class="hljs-string">&quot;localhost&quot;</span>
os.environ[<span class="hljs-string">&quot;MASTER_PORT&quot;</span>] = <span class="hljs-string">&quot;9994&quot;</span>  <span class="hljs-comment"># modify if RuntimeError: Address already in use</span>
os.environ[<span class="hljs-string">&quot;RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-comment"># Now proceed as normal, plus pass the deepspeed config file</span>
training_args = TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;ds_config_zero3.json&quot;</span>)
trainer = Trainer(...)
trainer.train()`,wrap:!1}}),vt=new T({props:{code:"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",highlighted:`%%bash
cat &lt;&lt;<span class="hljs-string">&#x27;EOT&#x27;</span> &gt; ds_config_zero3.json
{
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;loss_scale&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;loss_scale_window&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;initial_scale_power&quot;</span>: <span class="hljs-number">16</span>,
        <span class="hljs-string">&quot;hysteresis&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;min_loss_scale&quot;</span>: <span class="hljs-number">1</span>
    },

    <span class="hljs-string">&quot;optimizer&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;AdamW&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;betas&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;eps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;scheduler&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;WarmupLR&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;warmup_min_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_max_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_num_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_optimizer&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: true,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: true,
        <span class="hljs-string">&quot;sub_group_size&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_max_live_parameters&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_max_reuse_distance&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span>: true
    },

    <span class="hljs-string">&quot;gradient_accumulation_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;gradient_clipping&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: false
}
EOT`,wrap:!1}}),Bt=new T({props:{code:"IWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEEhY2QlMjB0cmFuc2Zvcm1lcnMlM0IlMjBkZWVwc3BlZWQlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMC4uLg==",highlighted:`!git clone https://github.com/huggingface/transformers
!cd transformers; deepspeed examples/pytorch/translation/run_translation.py ...`,wrap:!1}}),qt=new T({props:{code:"JTI1JTI1YmFzaCUwQSUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEFjZCUyMHRyYW5zZm9ybWVycyUwQWRlZXBzcGVlZCUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:`%%bash

git clone https://github.com/huggingface/transformers
cd transformers
deepspeed examples/pytorch/translation/run_translation.py ...`,wrap:!1}}),St=new h({props:{title:"Configuration",local:"configuration",headingTag:"h3"}}),Wt=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWRFeGFtcGxlcyUwQWNkJTIwRGVlcFNwZWVkRXhhbXBsZXMlMEFmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJw==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeedExamples
<span class="hljs-built_in">cd</span> DeepSpeedExamples
find . -name <span class="hljs-string">&#x27;*json&#x27;</span>`,wrap:!1}}),kt=new T({props:{code:"Z3JlcCUyMC1pJTIwTGFtYiUyMCUyNChmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJyk=",highlighted:'grep -i Lamb $(find . -name <span class="hljs-string">&#x27;*json&#x27;</span>)',wrap:!1}}),Et=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Vt=new h({props:{title:"Passing Configuration",local:"passing-configuration",headingTag:"h3"}}),Lt=new T({props:{code:"VHJhaW5pbmdBcmd1bWVudHMoLi4uJTJDJTIwZGVlcHNwZWVkJTNEJTIyJTJGcGF0aCUyRnRvJTJGZHNfY29uZmlnLmpzb24lMjIp",highlighted:'TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;/path/to/ds_config.json&quot;</span>)',wrap:!1}}),Pt=new T({props:{code:"ZHNfY29uZmlnX2RpY3QlMjAlM0QlMjBkaWN0KHNjaGVkdWxlciUzRHNjaGVkdWxlcl9wYXJhbXMlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXJfcGFyYW1zKSUwQVRyYWluaW5nQXJndW1lbnRzKC4uLiUyQyUyMGRlZXBzcGVlZCUzRGRzX2NvbmZpZ19kaWN0KQ==",highlighted:`ds_config_dict = <span class="hljs-built_in">dict</span>(scheduler=scheduler_params, optimizer=optimizer_params)
TrainingArguments(..., deepspeed=ds_config_dict)`,wrap:!1}}),Ot=new h({props:{title:"Shared Configuration",local:"shared-configuration",headingTag:"h3"}}),S=new AJ({props:{warning:!0,$$slots:{default:[CI]},$$scope:{ctx:$}}}),pe=new h({props:{title:"ZeRO",local:"zero",headingTag:"h3"}}),ce=new h({props:{title:"ZeRO-2 Config",local:"zero-2-config",headingTag:"h4"}}),ye=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwNWU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9zY2F0dGVyJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9idWNrZXRfc2l6ZSUyMiUzQSUyMDVlOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Je=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb3VuZF9yb2Jpbl9ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;round_robin_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new h({props:{title:"ZeRO-3 Config",local:"zero-3-config",headingTag:"h4"}}),me=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Yl9ncm91cF9zaXplJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19wcmVmZXRjaF9idWNrZXRfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfcGFyYW1fcGVyc2lzdGVuY2VfdGhyZXNob2xkJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19tYXhfbGl2ZV9wYXJhbWV0ZXJzJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX21heF9yZXVzZV9kaXN0YW5jZSUyMiUzQSUyMDFlOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ge=new h({props:{title:"ZeRO-0 Config",local:"zero-0-config",headingTag:"h4"}}),ke=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDAlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Xe=new h({props:{title:"ZeRO-1 Config",local:"zero-1-config",headingTag:"h4"}}),Ee=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDElMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),He=new h({props:{title:"NVMe Support",local:"nvme-support",headingTag:"h3"}}),Fe=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;fast_init&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;max_in_cpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;aio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;block_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">262144</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;queue_depth&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">32</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;thread_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;single_submit&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;overlap_events&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ke=new h({props:{title:"ZeRO-2 vs ZeRO-3 Performance",local:"zero-2-vs-zero-3-performance",headingTag:"h4"}}),al=new h({props:{title:"ZeRO-2 Example",local:"zero-2-example",headingTag:"h4"}}),pl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ol=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ml=new h({props:{title:"ZeRO-3 Example",local:"zero-3-example",headingTag:"h4"}}),cl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),yl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.94e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e4</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jl=new h({props:{title:"How to Choose Which ZeRO Stage and Offloads To Use For Best Performance",local:"how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance",headingTag:"h4"}}),ql=new h({props:{title:"Activation Checkpointing or Gradient Checkpointing",local:"activation-checkpointing-or-gradient-checkpointing",headingTag:"h3"}}),Wl=new h({props:{title:"Optimizer and Scheduler",local:"optimizer-and-scheduler",headingTag:"h3"}}),Xl=new h({props:{title:"Optimizer",local:"optimizer",headingTag:"h4"}}),Vl=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmV0YXMlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlaWdodF9kZWNheSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Pl=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAwLjAwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJldGFzJTIyJTNBJTIwJTVCMC44JTJDJTIwMC45OTklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlcHMlMjIlM0ElMjAxZS04JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0X2RlY2F5JTIyJTNBJTIwM2UtNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),sa=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19hbGxvd191bnRlc3RlZF9vcHRpbWl6ZXIlMjIlM0ElMjB0cnVlJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_allow_untested_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),la=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19mb3JjZV9kc19jcHVfb3B0aW1pemVyJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_force_ds_cpu_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),na=new h({props:{title:"Scheduler",local:"scheduler",headingTag:"h4"}}),ca=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9udW1fc3RlcHMlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ta=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwMC4wMDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwMTAwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ua=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cERlY2F5TFIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYXN0X2JhdGNoX2l0ZXJhdGlvbiUyMiUzQSUyMC0xJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9taW5fbHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21heF9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;last_batch_iteration&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">-1</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),da=new h({props:{title:"fp32 Precision",local:"fp32-precision",headingTag:"h3"}}),Ia=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Aa=new h({props:{title:"Automatic Mixed Precision",local:"automatic-mixed-precision",headingTag:"h3"}}),va=new h({props:{title:"fp16",local:"fp16",headingTag:"h3"}}),Ba=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$a=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ga=new h({props:{title:"bf16",local:"bf16",headingTag:"h3"}}),Ra=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Qa=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new AJ({props:{$$slots:{default:[bI]},$$scope:{ctx:$}}}),Ea=new h({props:{title:"NCCL Collectives",local:"nccl-collectives",headingTag:"h3"}}),La=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyY29tbXVuaWNhdGlvbl9kYXRhX3R5cGUlMjIlM0ElMjAlMjJmcDMyJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;communication_data_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;fp32&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Oa=new h({props:{title:"apex",local:"apex",headingTag:"h3"}}),sn=new T({props:{code:"JTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),an=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJPMSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;O1&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),on=new h({props:{title:"Batch Size",local:"batch-size",headingTag:"h3"}}),un=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbl9taWNyb19iYXRjaF9zaXplX3Blcl9ncHUlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),yn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMDEyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwNCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">12</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Tn=new h({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h3"}}),Jn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),dn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwMyUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),fn=new h({props:{title:"Gradient Clipping",local:"gradient-clipping",headingTag:"h3"}}),Cn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),gn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAxLjAlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_n=new h({props:{title:"Getting The Model Weights Out",local:"getting-the-model-weights-out",headingTag:"h3"}}),$n=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),kn=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50cmFpbmVyX3V0aWxzJTIwaW1wb3J0JTIwZ2V0X2xhc3RfY2hlY2twb2ludCUwQWZyb20lMjBkZWVwc3BlZWQudXRpbHMuemVyb190b19mcDMyJTIwaW1wb3J0JTIwbG9hZF9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBY2hlY2twb2ludF9kaXIlMjAlM0QlMjBnZXRfbGFzdF9jaGVja3BvaW50KHRyYWluZXIuYXJncy5vdXRwdXRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.trainer_utils <span class="hljs-keyword">import</span> get_last_checkpoint
<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = get_last_checkpoint(trainer.args.output_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`,wrap:!1}}),Xn=new T({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEFjaGVja3BvaW50X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbih0cmFpbmVyLmFyZ3Mub3V0cHV0X2RpciUyQyUyMCUyMmNoZWNrcG9pbnQtZmluYWwlMjIpJTBBdHJhaW5lci5kZWVwc3BlZWQuc2F2ZV9jaGVja3BvaW50KGNoZWNrcG9pbnRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = os.path.join(trainer.args.output_dir, <span class="hljs-string">&quot;checkpoint-final&quot;</span>)
trainer.deepspeed.save_checkpoint(checkpoint_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`,wrap:!1}}),G=new AJ({props:{$$slots:{default:[AI]},$$scope:{ctx:$}}}),Hn=new T({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIpJTIwJTIwJTIzJTIwYWxyZWFkeSUyMG9uJTIwY3B1JTBBbW9kZWwlMjAlM0QlMjBtb2RlbC5jcHUoKSUwQW1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)  <span class="hljs-comment"># already on cpu</span>
model = model.cpu()
model.load_state_dict(state_dict)`,wrap:!1}}),Ln=new T({props:{code:"JTI0JTIwbHMlMjAtbCUyMG91dHB1dF9kaXIlMkZjaGVja3BvaW50LTElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwMS40SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMGNvbmZpZy5qc29uJTBBZHJ3eHJ3eHIteCUyMDIlMjBzdGFzJTIwc3RhcyUyMDQuMEslMjBNYXIlMjAyNSUyMDE5JTNBNTIlMjBnbG9iYWxfc3RlcDElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwJTIwMTIlMjBNYXIlMjAyNyUyMDEzJTNBMTYlMjBsYXRlc3QlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwODI3SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMG9wdGltaXplci5wdCUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjAyMzFNJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwNjIzJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc2NoZWR1bGVyLnB0JTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOEslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjBzcGVjaWFsX3Rva2Vuc19tYXAuanNvbiUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA3NzRLJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc3BpZWNlLm1vZGVsJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOUslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwMzM5JTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwdHJhaW5lcl9zdGF0ZS5qc29uJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDIuM0slMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0cmFpbmluZ19hcmdzLmJpbiUwQS1yd3hydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA1LjVLJTIwTWFyJTIwMjclMjAxMyUzQTE2JTIwemVyb190b19mcDMyLnB5Kg==",highlighted:`$ <span class="hljs-built_in">ls</span> -l output_dir/checkpoint-1/
-rw-rw-r-- 1 stas stas 1.4K Mar 27 20:42 config.json
drwxrwxr-x 2 stas stas 4.0K Mar 25 19:52 global_step1/
-rw-rw-r-- 1 stas stas   12 Mar 27 13:16 latest
-rw-rw-r-- 1 stas stas 827K Mar 27 20:42 optimizer.pt
-rw-rw-r-- 1 stas stas 231M Mar 27 20:42 pytorch_model.bin
-rw-rw-r-- 1 stas stas  623 Mar 27 20:42 scheduler.pt
-rw-rw-r-- 1 stas stas 1.8K Mar 27 20:42 special_tokens_map.json
-rw-rw-r-- 1 stas stas 774K Mar 27 20:42 spiece.model
-rw-rw-r-- 1 stas stas 1.9K Mar 27 20:42 tokenizer_config.json
-rw-rw-r-- 1 stas stas  339 Mar 27 20:42 trainer_state.json
-rw-rw-r-- 1 stas stas 2.3K Mar 27 20:42 training_args.bin
-rwxrw-r-- 1 stas stas 5.5K Mar 27 13:16 zero_to_fp32.py*`,wrap:!1}}),Pn=new T({props:{code:"cHl0aG9uJTIwemVyb190b19mcDMyLnB5JTIwLiUyMHB5dG9yY2hfbW9kZWwuYmlu",highlighted:"python zero_to_fp32.py . pytorch_model.bin",wrap:!1}}),lp=new h({props:{title:"ZeRO-3 and Infinity Nuances",local:"zero-3-and-infinity-nuances",headingTag:"h3"}}),ip=new h({props:{title:"Constructing Massive Models",local:"constructing-massive-models",headingTag:"h4"}}),Mp=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwVDVDb25maWclMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEF3aXRoJTIwZGVlcHNwZWVkLnplcm8uSW5pdCgpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwVDVDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5ForConditionalGeneration, T5Config
<span class="hljs-keyword">import</span> deepspeed

<span class="hljs-keyword">with</span> deepspeed.zero.Init():
    config = T5Config.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
    model = T5ForConditionalGeneration(config)`,wrap:!1}}),rp=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0Rkc19jb25maWcpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, Trainer, TrainingArguments

training_args = TrainingArguments(..., deepspeed=ds_config)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
trainer = Trainer(model=model, args=training_args, ...)`,wrap:!1}}),Jp=new h({props:{title:"Gathering Parameters",local:"gathering-parameters",headingTag:"h4"}}),mp=new T({props:{code:"dGVuc29yKCU1QjEuMCU1RCUyQyUyMGRldmljZSUzRCUyMmN1ZGElM0EwJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwcmVxdWlyZXNfZ3JhZCUzRFRydWUp",highlighted:'tensor([<span class="hljs-number">1.0</span>], device=<span class="hljs-string">&quot;cuda:0&quot;</span>, dtype=torch.float16, requires_grad=<span class="hljs-literal">True</span>)',wrap:!1}}),Ip=new h({props:{title:"ZeRO Inference",local:"zero-inference",headingTag:"h3"}}),Ap=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRvX2V2YWwlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --do_eval --deepspeed ds_config.json",wrap:!1}}),_p=new T({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMCU1QyUwQS0tZG9fZXZhbCUyMC0tbWF4X2V2YWxfc2FtcGxlcyUyMDUwJTIwLS13YXJtdXBfc3RlcHMlMjA1MCUyMCUyMCU1QyUwQS0tbWF4X3NvdXJjZV9sZW5ndGglMjAxMjglMjAtLXZhbF9tYXhfdGFyZ2V0X2xlbmd0aCUyMDEyOCUyMCU1QyUwQS0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQS0tcHJlZGljdF93aXRoX2dlbmVyYXRlJTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwLS1mcDE2JTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJvJTIwLS1kYXRhc2V0X25hbWUlMjB3bXQxNiUyMCU1QyUwQS0tc291cmNlX3ByZWZpeCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMFJvbWFuaWFuJTNBJTIwJTIy",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --output_dir output_dir \\
--do_eval --max_eval_samples 50 --warmup_steps 50  \\
--max_source_length 128 --val_max_target_length 128 \\
--overwrite_output_dir --per_device_eval_batch_size 4 \\
--predict_with_generate --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> --fp16 \\
--source_lang en --target_lang ro --dataset_name wmt16 \\
--source_prefix <span class="hljs-string">&quot;translate English to Romanian: &quot;</span>`,wrap:!1}}),qp=new h({props:{title:"Memory Requirements",local:"memory-requirements",headingTag:"h3"}}),Sp=new T({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDElMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMSUyMEdQVSUyMHBlciUyMG5vZGUuJTBBU1clM0ElMjBNb2RlbCUyMHdpdGglMjAyNzgzTSUyMHRvdGFsJTIwcGFyYW1zJTJDJTIwNjVNJTIwbGFyZ2VzdCUyMGxheWVyJTIwcGFyYW1zLiUwQSUyMCUyMHBlciUyMENQVSUyMCUyMCU3QyUyMCUyMHBlciUyMEdQVSUyMCU3QyUyMCUyMCUyME9wdGlvbnMlMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDcwLjAwR0IlMjAlN0MlMjAlMjAlMjAwLjI1R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEY3B1JTIwJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QxJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwJTIwMC4zN0dCJTIwJTdDJTIwJTIwNDYuOTFHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDE1LjU2R0IlMjAlN0MlMjAlMjA0Ni45MUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRG5vbmUlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRG5vbmUlMkMlMjB6ZXJvX2luaXQlM0Qw",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=1, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 1 GPU per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.37GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=1
   15.56GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=0`,wrap:!1}}),kp=new T({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDIlMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMiUyMEdQVXMlMjBwZXIlMjBub2RlLiUwQVNXJTNBJTIwTW9kZWwlMjB3aXRoJTIwMjc4M00lMjB0b3RhbCUyMHBhcmFtcyUyQyUyMDY1TSUyMGxhcmdlc3QlMjBsYXllciUyMHBhcmFtcy4lMEElMjAlMjBwZXIlMjBDUFUlMjAlMjAlN0MlMjAlMjBwZXIlMjBHUFUlMjAlN0MlMjAlMjAlMjBPcHRpb25zJTBBJTIwJTIwJTIwNzAuMDBHQiUyMCU3QyUyMCUyMCUyMDAuMjVHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0RjcHUlMjAlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRGNwdSUyMCUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMCUyMDAuNzRHQiUyMCU3QyUyMCUyMDIzLjU4R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEbm9uZSUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjAzMS4xMUdCJTIwJTdDJTIwJTIwMjMuNThHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMCUwQQ==",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=2, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 2 GPUs per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.74GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=1
   31.11GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=0
`,wrap:!1}}),Qp=new h({props:{title:"Filing Issues",local:"filing-issues",headingTag:"h3"}}),Yp=new T({props:{code:"cHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIydG9yY2glM0ElMjAlN0J0b3JjaC5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdHJhbnNmb3JtZXJzJTNCJTIwcHJpbnQoZiUyMnRyYW5zZm9ybWVycyUzQSUyMCU3QnRyYW5zZm9ybWVycy5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwZGVlcHNwZWVkJTNCJTIwcHJpbnQoZiUyMmRlZXBzcGVlZCUzQSUyMCU3QmRlZXBzcGVlZC5fX3ZlcnNpb25fXyU3RCUyMikn",highlighted:`python -c <span class="hljs-string">&#x27;import torch; print(f&quot;torch: {torch.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import transformers; print(f&quot;transformers: {transformers.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import deepspeed; print(f&quot;deepspeed: {deepspeed.__version__}&quot;)&#x27;</span>`,wrap:!1}}),Dp=new h({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h3"}}),Pp=new h({props:{title:"the deepspeed process gets killed at startup without a traceback",local:"the-deepspeed-process-gets-killed-at-startup-without-a-traceback",headingTag:"h4"}}),Kp=new h({props:{title:"training and/or eval/predict loss is NaN",local:"training-andor-evalpredict-loss-is-nan",headingTag:"h4"}}),ei=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ai=new T({props:{code:"MCUyNSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDAlMkYxODklMjAlNUIwMCUzQTAwJTNDJTNGJTJDJTIwJTNGaXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDI2MjE0NCUwQSUyMCUyMDElMjUlN0MlRTIlOTYlOEMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAxJTJGMTg5JTIwJTVCMDAlM0EwMCUzQzAxJTNBMjYlMkMlMjAlMjAyLjE3aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDEzMTA3Mi4wJTBBJTIwJTIwMSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4RiUwQSUyMCU1Qi4uLiU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSUyMDE0JTI1JTdDJUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JThDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMjclMkYxODklMjAlNUIwMCUzQTE0JTNDMDElM0ExMyUyQyUyMCUyMDIuMjFpdCUyRnMlNUQlMEElMjAlNUJkZWVwc2NhbGUlNUQlMjBPVkVSRkxPVyElMjBSYW5rJTIwMCUyMFNraXBwaW5nJTIwc3RlcC4lMjBBdHRlbXB0ZWQlMjBsb3NzJTIwc2NhbGUlM0ElMjAxJTJDJTIwcmVkdWNpbmclMjB0byUyMDElMEElMjAxNSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4RiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDI4JTJGMTg5JTIwJTVCMDAlM0ExNCUzQzAxJTNBMTMlMkMlMjAlMjAyLjE4aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMSUyQyUyMHJlZHVjaW5nJTIwdG8lMjAxJTBBJTIwMTUlMjUlN0MlRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlOEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyOSUyRjE4OSUyMCU1QjAwJTNBMTUlM0MwMSUzQTEzJTJDJTIwJTIwMi4xOGl0JTJGcyU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSU1Qi4uLiU1RA==",highlighted:`<span class="hljs-number">0</span><span class="hljs-comment">%|                                                                                                                             | 0/189 [00:00&lt;?, ?it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">262144</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|▌                                                                                                                    | 1/189 [00:00&lt;01:26,  2.17it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">131072.0</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|█▏</span>
 [...]
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">14</span><span class="hljs-comment">%|████████████████▌                                                                                                   | 27/189 [00:14&lt;01:13,  2.21it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▏                                                                                                  | 28/189 [00:14&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▊                                                                                                  | 29/189 [00:15&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
[...]`,wrap:!1}}),oi=new h({props:{title:"Notes",local:"notes",headingTag:"h3"}}),ui=new h({props:{title:"Non-Trainer Deepspeed Integration",local:"non-trainer-deepspeed-integration",headingTag:"h2"}}),hi=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEFkc19jb25maWclMjAlM0QlMjAlN0IuLi4lN0QlMjAlMjAlMjMlMjBkZWVwc3BlZWQlMjBjb25maWclMjBvYmplY3QlMjBvciUyMHBhdGglMjB0byUyMHRoZSUyMGZpbGUlMEElMjMlMjBtdXN0JTIwcnVuJTIwYmVmb3JlJTIwaW5zdGFudGlhdGluZyUyMHRoZSUyMG1vZGVsJTIwdG8lMjBkZXRlY3QlMjB6ZXJvJTIwMyUwQWRzY2hmJTIwJTNEJTIwSGZEZWVwU3BlZWRDb25maWcoZHNfY29uZmlnKSUyMCUyMCUyMyUyMGtlZXAlMjB0aGlzJTIwb2JqZWN0JTIwYWxpdmUlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFlbmdpbmUlMjAlM0QlMjBkZWVwc3BlZWQuaW5pdGlhbGl6ZShtb2RlbCUzRG1vZGVsJTJDJTIwY29uZmlnX3BhcmFtcyUzRGRzX2NvbmZpZyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`,wrap:!1}}),Ui=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMkMlMjBBdXRvQ29uZmlnJTBBaW1wb3J0JTIwZGVlcHNwZWVkJTBBJTBBZHNfY29uZmlnJTIwJTNEJTIwJTdCLi4uJTdEJTIwJTIwJTIzJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwb2JqZWN0JTIwb3IlMjBwYXRoJTIwdG8lMjB0aGUlMjBmaWxlJTBBJTIzJTIwbXVzdCUyMHJ1biUyMGJlZm9yZSUyMGluc3RhbnRpYXRpbmclMjB0aGUlMjBtb2RlbCUyMHRvJTIwZGV0ZWN0JTIwemVybyUyMDMlMEFkc2NoZiUyMCUzRCUyMEhmRGVlcFNwZWVkQ29uZmlnKGRzX2NvbmZpZyklMjAlMjAlMjMlMjBrZWVwJTIwdGhpcyUyMG9iamVjdCUyMGFsaXZlJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcpJTBBZW5naW5lJTIwJTNEJTIwZGVlcHNwZWVkLmluaXRpYWxpemUobW9kZWwlM0Rtb2RlbCUyQyUyMGNvbmZpZ19wYXJhbXMlM0Rkc19jb25maWclMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoConfig
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = AutoModel.from_config(config)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`,wrap:!1}}),di=new h({props:{title:"HfDeepSpeedConfig",local:"transformers.integrations.HfDeepSpeedConfig",headingTag:"h2"}}),mi=new II({props:{name:"class transformers.integrations.HfDeepSpeedConfig",anchor:"transformers.integrations.HfDeepSpeedConfig",parameters:[{name:"config_file_or_dict",val:""}],parametersDescription:[{anchor:"transformers.integrations.HfDeepSpeedConfig.config_file_or_dict",description:"<strong>config_file_or_dict</strong> (<code>Union[str, Dict]</code>) &#x2014; path to DeepSpeed config file or dict.",name:"config_file_or_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/integrations/deepspeed.py#L56"}}),fi=new h({props:{title:"Custom DeepSpeed ZeRO Inference",local:"custom-deepspeed-zero-inference",headingTag:"h3"}}),vi=new T({props:{code:"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",highlighted:`<span class="hljs-comment">#!/usr/bin/env python</span>

<span class="hljs-comment"># This script demonstrates how to use Deepspeed ZeRO in an inference mode when one can&#x27;t fit a model</span>
<span class="hljs-comment"># into a single GPU</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># 1. Use 1 GPU with CPU offload</span>
<span class="hljs-comment"># 2. Or use multiple GPUs instead</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># First you need to install deepspeed: pip install deepspeed</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># Here we use a 3B &quot;bigscience/T0_3B&quot; model which needs about 15GB GPU RAM - so 1 largish or 2</span>
<span class="hljs-comment"># small GPUs can handle it. or 1 small GPU and a lot of CPU memory.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To use a larger model like &quot;bigscience/T0&quot; which needs about 50GB, unless you have an 80GB GPU -</span>
<span class="hljs-comment"># you will need 2-4 gpus. And then you can adapt the script to handle more gpus if you want to</span>
<span class="hljs-comment"># process multiple inputs at once.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># The provided deepspeed config also activates CPU memory offloading, so chances are that if you</span>
<span class="hljs-comment"># have a lot of available CPU memory and you don&#x27;t mind a slowdown you should be able to load a</span>
<span class="hljs-comment"># model that doesn&#x27;t normally fit into a single GPU. If you have enough GPU memory the program will</span>
<span class="hljs-comment"># run faster if you don&#x27;t want offload to CPU - so disable that section then.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 1 gpu:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 1 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=1 t0.py</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 2 gpus:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 2 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=2 t0.py</span>


<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoConfig, AutoModelForSeq2SeqLM
<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">import</span> deepspeed
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To avoid warnings about parallelism in tokenizers</span>

<span class="hljs-comment"># distributed setup</span>
local_rank = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>))
world_size = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>, <span class="hljs-string">&quot;1&quot;</span>))
torch.cuda.set_device(local_rank)
deepspeed.init_distributed()

model_name = <span class="hljs-string">&quot;bigscience/T0_3B&quot;</span>

config = AutoConfig.from_pretrained(model_name)
model_hidden_size = config.d_model

<span class="hljs-comment"># batch size has to be divisible by world_size, but can be bigger than world_size</span>
train_batch_size = <span class="hljs-number">1</span> * world_size

<span class="hljs-comment"># ds_config notes</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - enable bf16 if you use Ampere or higher GPU - this will run in mixed precision and will be</span>
<span class="hljs-comment"># faster.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - for older GPUs you can enable fp16, but it&#x27;ll only work for non-bf16 pretrained models - e.g.</span>
<span class="hljs-comment"># all official t5 models are bf16-pretrained</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - set offload_param.device to &quot;none&quot; or completely remove the \`offload_param\` section if you don&#x27;t</span>
<span class="hljs-comment"># - want CPU offload</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - if using \`offload_param\` you can manually finetune stage3_param_persistence_threshold to control</span>
<span class="hljs-comment"># - which params should remain on gpus - the larger the value the smaller the offload size</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># For indepth info on Deepspeed config see</span>
<span class="hljs-comment"># https://huggingface.co/docs/transformers/main/main_classes/deepspeed</span>

<span class="hljs-comment"># keeping the same format as json for consistency, except it uses lower case for true/false</span>
<span class="hljs-comment"># fmt: off</span>
ds_config = {
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;bf16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: <span class="hljs-literal">True</span>
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-number">0.9</span> * model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-number">10</span> * model_hidden_size
    },
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: train_batch_size,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: <span class="hljs-literal">False</span>
}
<span class="hljs-comment"># fmt: on</span>

<span class="hljs-comment"># next line instructs transformers to partition the model directly over multiple gpus using</span>
<span class="hljs-comment"># deepspeed.zero.Init when model&#x27;s \`from_pretrained\` method is called.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># **it has to be run before loading the model AutoModelForSeq2SeqLM.from_pretrained(model_name)**</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># otherwise the model will first be loaded normally and only partitioned at forward time which is</span>
<span class="hljs-comment"># less efficient and when there is little CPU RAM may fail</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>

<span class="hljs-comment"># now a model can be loaded.</span>
model = AutoModelForSeq2SeqLM.from_pretrained(model_name)

<span class="hljs-comment"># initialise Deepspeed ZeRO and store only the engine object</span>
ds_engine = deepspeed.initialize(model=model, config_params=ds_config)[<span class="hljs-number">0</span>]
ds_engine.module.<span class="hljs-built_in">eval</span>()  <span class="hljs-comment"># inference</span>

<span class="hljs-comment"># Deepspeed ZeRO can process unrelated inputs on each GPU. So for 2 gpus you process 2 inputs at once.</span>
<span class="hljs-comment"># If you use more GPUs adjust for more.</span>
<span class="hljs-comment"># And of course if you have just one input to process you then need to pass the same string to both gpus</span>
<span class="hljs-comment"># If you use only one GPU, then you will have only rank 0.</span>
rank = torch.distributed.get_rank()
<span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the best cast iron skillet you will ever buy&quot;</span>
<span class="hljs-keyword">elif</span> rank == <span class="hljs-number">1</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the worst restaurant ever&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_name)
inputs = tokenizer.encode(text_in, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=local_rank)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = ds_engine.module.generate(inputs, synced_gpus=<span class="hljs-literal">True</span>)
text_out = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;rank<span class="hljs-subst">{rank}</span>:\\n   in=<span class="hljs-subst">{text_in}</span>\\n  out=<span class="hljs-subst">{text_out}</span>&quot;</span>)`,wrap:!1}}),Bi=new T({props:{code:"JTI0JTIwZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0MC5weSUwQXJhbmswJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjBiZXN0JTIwY2FzdCUyMGlyb24lMjBza2lsbGV0JTIweW91JTIwd2lsbCUyMGV2ZXIlMjBidXklMEElMjAlMjBvdXQlM0RQb3NpdGl2ZSUwQXJhbmsxJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjB3b3JzdCUyMHJlc3RhdXJhbnQlMjBldmVyJTBBJTIwJTIwb3V0JTNEbmVnYXRpdmU=",highlighted:`$ deepspeed --num_gpus <span class="hljs-number">2</span> t0.py
rank0:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the best cast iron skillet you will ever buy
  <span class="hljs-keyword">out</span>=Positive
rank1:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the worst restaurant ever
  <span class="hljs-keyword">out</span>=negative`,wrap:!1}}),qi=new h({props:{title:"generate nuances",local:"generate-nuances",headingTag:"h3"}}),Si=new h({props:{title:"Testing Deepspeed Integration",local:"testing-deepspeed-integration",headingTag:"h2"}}),Wi=new T({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZ0ZXN0X2RlZXBzcGVlZC5weQ==",highlighted:'RUN_SLOW=<span class="hljs-number">1</span> pytest tests<span class="hljs-regexp">/deepspeed/</span>test_deepspeed.py',wrap:!1}}),ki=new T({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQ=",highlighted:'<span class="hljs-attr">RUN_SLOW</span>=<span class="hljs-number">1</span> pytest tests/deepspeed',wrap:!1}}),Ni=new h({props:{title:"Main DeepSpeed Resources",local:"main-deepspeed-resources",headingTag:"h2"}}),{c(){J=p("meta"),g=a(),m=p("p"),I=a(),M(B.$$.fragment),Z=a(),b=p("p"),b.innerHTML=Bo,f=a(),v=p("ol"),v.innerHTML=vJ,xo=a(),R=p("p"),R.innerHTML=_J,$o=a(),k=p("p"),k.textContent=BJ,So=a(),N=p("p"),N.textContent=ZJ,zo=a(),X=p("p"),X.innerHTML=qJ,Go=a(),Q=p("ol"),Q.innerHTML=xJ,Wo=a(),E=p("p"),E.textContent=$J,Ro=a(),H=p("p"),H.textContent=SJ,ko=a(),V=p("ol"),V.innerHTML=zJ,No=a(),Y=p("p"),Y.textContent=GJ,Xo=a(),F=p("ol"),F.innerHTML=WJ,Qo=a(),L=p("p"),L.textContent=RJ,Eo=a(),Vi=p("a"),Ho=a(),M(D.$$.fragment),Vo=a(),Yi=p("a"),Yo=a(),M(P.$$.fragment),Fo=a(),O=p("p"),O.textContent=kJ,Lo=a(),M(K.$$.fragment),Do=a(),ss=p("p"),ss.innerHTML=NJ,Po=a(),M(ts.$$.fragment),Oo=a(),es=p("p"),es.innerHTML=XJ,Ko=a(),ls=p("p"),ls.innerHTML=QJ,sM=a(),as=p("p"),as.textContent=EJ,tM=a(),ns=p("p"),ns.textContent=HJ,eM=a(),M(ps.$$.fragment),lM=a(),is=p("p"),is.innerHTML=VJ,aM=a(),os=p("p"),os.innerHTML=YJ,nM=a(),M(Ms.$$.fragment),pM=a(),us=p("p"),us.innerHTML=FJ,iM=a(),cs=p("p"),cs.textContent=LJ,oM=a(),M(rs.$$.fragment),MM=a(),ys=p("p"),ys.innerHTML=DJ,uM=a(),js=p("p"),js.innerHTML=PJ,cM=a(),Ts=p("p"),Ts.innerHTML=OJ,rM=a(),hs=p("p"),hs.textContent=KJ,yM=a(),M(Js.$$.fragment),jM=a(),Us=p("p"),Us.textContent=sU,TM=a(),M(ws.$$.fragment),hM=a(),ds=p("p"),ds.textContent=tU,JM=a(),M(ms.$$.fragment),UM=a(),fs=p("p"),fs.innerHTML=eU,wM=a(),Is=p("p"),Is.innerHTML=lU,dM=a(),Cs=p("p"),Cs.innerHTML=aU,mM=a(),Fi=p("a"),fM=a(),M(bs.$$.fragment),IM=a(),As=p("p"),As.innerHTML=nU,CM=a(),gs=p("p"),gs.textContent=pU,bM=a(),M(vs.$$.fragment),AM=a(),_s=p("p"),_s.innerHTML=iU,gM=a(),M(Bs.$$.fragment),vM=a(),Zs=p("p"),Zs.innerHTML=oU,_M=a(),qs=p("p"),qs.innerHTML=MU,BM=a(),xs=p("p"),xs.innerHTML=uU,ZM=a(),M($s.$$.fragment),qM=a(),Ss=p("p"),Ss.innerHTML=cU,xM=a(),zs=p("p"),zs.innerHTML=rU,$M=a(),Li=p("a"),SM=a(),M(Gs.$$.fragment),zM=a(),Ws=p("p"),Ws.innerHTML=yU,GM=a(),M(Rs.$$.fragment),WM=a(),ks=p("p"),ks.innerHTML=jU,RM=a(),Ns=p("p"),Ns.textContent=TU,kM=a(),Xs=p("ol"),Xs.innerHTML=hU,NM=a(),Qs=p("p"),Qs.textContent=JU,XM=a(),M(Es.$$.fragment),QM=a(),Hs=p("p"),Hs.textContent=UU,EM=a(),Vs=p("p"),Vs.innerHTML=wU,HM=a(),Ys=p("p"),Ys.textContent=dU,VM=a(),Fs=p("p"),Fs.textContent=mU,YM=a(),Di=p("ul"),q=p("li"),Pi=p("p"),Pi.innerHTML=fU,TJ=a(),M(Ls.$$.fragment),hJ=a(),Oi=p("p"),Oi.textContent=IU,FM=a(),Ki=p("a"),LM=a(),M(Ds.$$.fragment),DM=a(),Ps=p("p"),Ps.innerHTML=CU,PM=a(),Os=p("p"),Os.innerHTML=bU,OM=a(),M(Ks.$$.fragment),KM=a(),st=p("p"),st.innerHTML=AU,su=a(),M(tt.$$.fragment),tu=a(),et=p("p"),et.textContent=gU,eu=a(),lt=p("p"),lt.innerHTML=vU,lu=a(),M(at.$$.fragment),au=a(),nt=p("p"),nt.innerHTML=_U,nu=a(),M(pt.$$.fragment),pu=a(),it=p("p"),it.textContent=BU,iu=a(),M(ot.$$.fragment),ou=a(),Mt=p("p"),Mt.innerHTML=ZU,Mu=a(),ut=p("p"),ut.innerHTML=qU,uu=a(),M(ct.$$.fragment),cu=a(),rt=p("p"),rt.innerHTML=xU,ru=a(),M(yt.$$.fragment),yu=a(),jt=p("p"),jt.textContent=$U,ju=a(),M(Tt.$$.fragment),Tu=a(),ht=p("p"),ht.innerHTML=SU,hu=a(),M(Jt.$$.fragment),Ju=a(),Ut=p("p"),Ut.innerHTML=zU,Uu=a(),M(wt.$$.fragment),wu=a(),dt=p("p"),dt.innerHTML=GU,du=a(),so=p("a"),mu=a(),M(mt.$$.fragment),fu=a(),ft=p("p"),ft.innerHTML=WU,Iu=a(),It=p("p"),It.textContent=RU,Cu=a(),M(Ct.$$.fragment),bu=a(),bt=p("p"),bt.innerHTML=kU,Au=a(),At=p("p"),At.textContent=NU,gu=a(),gt=p("p"),gt.textContent=XU,vu=a(),M(vt.$$.fragment),_u=a(),_t=p("p"),_t.innerHTML=QU,Bu=a(),M(Bt.$$.fragment),Zu=a(),Zt=p("p"),Zt.innerHTML=EU,qu=a(),M(qt.$$.fragment),xu=a(),xt=p("p"),xt.textContent=HU,$u=a(),$t=p("p"),$t.innerHTML=VU,Su=a(),to=p("a"),zu=a(),M(St.$$.fragment),Gu=a(),zt=p("p"),zt.innerHTML=YU,Wu=a(),Gt=p("p"),Gt.innerHTML=FU,Ru=a(),M(Wt.$$.fragment),ku=a(),Rt=p("p"),Rt.innerHTML=LU,Nu=a(),M(kt.$$.fragment),Xu=a(),Nt=p("p"),Nt.innerHTML=DU,Qu=a(),Xt=p("p"),Xt.textContent=PU,Eu=a(),Qt=p("p"),Qt.innerHTML=OU,Hu=a(),M(Et.$$.fragment),Vu=a(),Ht=p("p"),Ht.innerHTML=KU,Yu=a(),eo=p("a"),Fu=a(),M(Vt.$$.fragment),Lu=a(),Yt=p("p"),Yt.innerHTML=sw,Du=a(),Ft=p("p"),Ft.textContent=tw,Pu=a(),M(Lt.$$.fragment),Ou=a(),Dt=p("p"),Dt.textContent=ew,Ku=a(),M(Pt.$$.fragment),sc=a(),lo=p("a"),tc=a(),M(Ot.$$.fragment),ec=a(),M(S.$$.fragment),lc=a(),Kt=p("p"),Kt.innerHTML=lw,ac=a(),se=p("p"),se.innerHTML=aw,nc=a(),te=p("p"),te.innerHTML=nw,pc=a(),ee=p("p"),ee.textContent=pw,ic=a(),le=p("p"),le.innerHTML=iw,oc=a(),ae=p("ol"),ae.innerHTML=ow,Mc=a(),ne=p("p"),ne.innerHTML=Mw,uc=a(),ao=p("a"),cc=a(),M(pe.$$.fragment),rc=a(),ie=p("p"),ie.innerHTML=uw,yc=a(),oe=p("p"),oe.innerHTML=cw,jc=a(),Me=p("p"),Me.innerHTML=rw,Tc=a(),ue=p("p"),ue.textContent=yw,hc=a(),no=p("a"),Jc=a(),M(ce.$$.fragment),Uc=a(),re=p("p"),re.textContent=jw,wc=a(),M(ye.$$.fragment),dc=a(),je=p("p"),je.innerHTML=Tw,mc=a(),Te=p("ul"),Te.innerHTML=hw,fc=a(),he=p("p"),he.innerHTML=Jw,Ic=a(),M(Je.$$.fragment),Cc=a(),Ue=p("p"),Ue.textContent=Uw,bc=a(),po=p("a"),Ac=a(),M(we.$$.fragment),gc=a(),de=p("p"),de.textContent=ww,vc=a(),M(me.$$.fragment),_c=a(),fe=p("p"),fe.innerHTML=dw,Bc=a(),Ie=p("p"),Ie.innerHTML=mw,Zc=a(),Ce=p("p"),Ce.innerHTML=fw,qc=a(),be=p("ul"),be.innerHTML=Iw,xc=a(),Ae=p("p"),Ae.innerHTML=Cw,$c=a(),ge=p("p"),ge.innerHTML=bw,Sc=a(),ve=p("p"),ve.textContent=Aw,zc=a(),_e=p("ul"),_e.innerHTML=gw,Gc=a(),Be=p("p"),Be.innerHTML=vw,Wc=a(),Ze=p("p"),Ze.innerHTML=_w,Rc=a(),qe=p("p"),qe.innerHTML=Bw,kc=a(),xe=p("ul"),xe.innerHTML=Zw,Nc=a(),$e=p("p"),$e.innerHTML=qw,Xc=a(),Se=p("p"),Se.innerHTML=xw,Qc=a(),ze=p("ol"),ze.innerHTML=$w,Ec=a(),M(Ge.$$.fragment),Hc=a(),We=p("p"),We.textContent=Sw,Vc=a(),Re=p("p"),Re.textContent=zw,Yc=a(),M(ke.$$.fragment),Fc=a(),Ne=p("p"),Ne.textContent=Gw,Lc=a(),M(Xe.$$.fragment),Dc=a(),Qe=p("p"),Qe.textContent=Ww,Pc=a(),M(Ee.$$.fragment),Oc=a(),io=p("a"),Kc=a(),M(He.$$.fragment),sr=a(),Ve=p("p"),Ve.textContent=Rw,tr=a(),Ye=p("p"),Ye.textContent=kw,er=a(),M(Fe.$$.fragment),lr=a(),Le=p("p"),Le.innerHTML=Nw,ar=a(),De=p("p"),De.innerHTML=Xw,nr=a(),Pe=p("p"),Pe.innerHTML=Qw,pr=a(),Oe=p("p"),Oe.innerHTML=Ew,ir=a(),oo=p("a"),or=a(),M(Ke.$$.fragment),Mr=a(),sl=p("p"),sl.textContent=Hw,ur=a(),tl=p("p"),tl.textContent=Vw,cr=a(),el=p("ul"),el.innerHTML=Yw,rr=a(),ll=p("p"),ll.innerHTML=Fw,yr=a(),Mo=p("a"),jr=a(),M(al.$$.fragment),Tr=a(),nl=p("p"),nl.innerHTML=Lw,hr=a(),M(pl.$$.fragment),Jr=a(),il=p("p"),il.innerHTML=Dw,Ur=a(),M(ol.$$.fragment),wr=a(),uo=p("a"),dr=a(),M(Ml.$$.fragment),mr=a(),ul=p("p"),ul.innerHTML=Pw,fr=a(),M(cl.$$.fragment),Ir=a(),rl=p("p"),rl.innerHTML=Ow,Cr=a(),M(yl.$$.fragment),br=a(),M(jl.$$.fragment),Ar=a(),Tl=p("p"),Tl.textContent=Kw,gr=a(),hl=p("p"),hl.textContent=sd,vr=a(),Jl=p("ul"),Jl.innerHTML=td,_r=a(),Ul=p("p"),Ul.textContent=ed,Br=a(),wl=p("ul"),wl.innerHTML=ld,Zr=a(),dl=p("p"),dl.textContent=ad,qr=a(),ml=p("p"),ml.textContent=nd,xr=a(),fl=p("p"),fl.textContent=pd,$r=a(),Il=p("ol"),Il.innerHTML=id,Sr=a(),Cl=p("p"),Cl.textContent=od,zr=a(),bl=p("p"),bl.textContent=Md,Gr=a(),Al=p("p"),Al.textContent=ud,Wr=a(),gl=p("p"),gl.textContent=cd,Rr=a(),vl=p("p"),vl.textContent=rd,kr=a(),_l=p("p"),_l.innerHTML=yd,Nr=a(),Bl=p("p"),Bl.textContent=jd,Xr=a(),Zl=p("ul"),Zl.innerHTML=Td,Qr=a(),M(ql.$$.fragment),Er=a(),xl=p("p"),xl.textContent=hd,Hr=a(),$l=p("p"),$l.textContent=Jd,Vr=a(),Sl=p("p"),Sl.textContent=Ud,Yr=a(),zl=p("p"),zl.textContent=wd,Fr=a(),Gl=p("ol"),Gl.innerHTML=dd,Lr=a(),M(Wl.$$.fragment),Dr=a(),Rl=p("p"),Rl.innerHTML=md,Pr=a(),kl=p("table"),kl.innerHTML=fd,Or=a(),Nl=p("p"),Nl.innerHTML=Id,Kr=a(),co=p("a"),sy=a(),M(Xl.$$.fragment),ty=a(),Ql=p("p"),Ql.innerHTML=Cd,ey=a(),El=p("p"),El.innerHTML=bd,ly=a(),Hl=p("p"),Hl.innerHTML=Ad,ay=a(),M(Vl.$$.fragment),ny=a(),Yl=p("p"),Yl.textContent=gd,py=a(),Fl=p("ul"),Fl.innerHTML=vd,iy=a(),Ll=p("p"),Ll.textContent=_d,oy=a(),Dl=p("p"),Dl.textContent=Bd,My=a(),M(Pl.$$.fragment),uy=a(),Ol=p("p"),Ol.innerHTML=Zd,cy=a(),Kl=p("p"),Kl.textContent=qd,ry=a(),M(sa.$$.fragment),yy=a(),ta=p("p"),ta.innerHTML=xd,jy=a(),ea=p("p"),ea.innerHTML=$d,Ty=a(),M(la.$$.fragment),hy=a(),aa=p("p"),aa.textContent=Sd,Jy=a(),ro=p("a"),Uy=a(),M(na.$$.fragment),wy=a(),pa=p("p"),pa.innerHTML=zd,dy=a(),ia=p("p"),ia.textContent=Gd,my=a(),oa=p("ul"),oa.innerHTML=Wd,fy=a(),Ma=p("p"),Ma.innerHTML=Rd,Iy=a(),ua=p("p"),ua.innerHTML=kd,Cy=a(),M(ca.$$.fragment),by=a(),ra=p("p"),ra.innerHTML=Nd,Ay=a(),ya=p("ul"),ya.innerHTML=Xd,gy=a(),ja=p("p"),ja.textContent=Qd,vy=a(),M(Ta.$$.fragment),_y=a(),ha=p("p"),ha.innerHTML=Ed,By=a(),Ja=p("p"),Ja.innerHTML=Hd,Zy=a(),M(Ua.$$.fragment),qy=a(),wa=p("p"),wa.innerHTML=Vd,xy=a(),yo=p("a"),$y=a(),M(da.$$.fragment),Sy=a(),ma=p("p"),ma.textContent=Yd,zy=a(),fa=p("p"),fa.innerHTML=Fd,Gy=a(),M(Ia.$$.fragment),Wy=a(),Ca=p("p"),Ca.innerHTML=Ld,Ry=a(),ba=p("p"),ba.innerHTML=Dd,ky=a(),jo=p("a"),Ny=a(),M(Aa.$$.fragment),Xy=a(),ga=p("p"),ga.textContent=Pd,Qy=a(),M(va.$$.fragment),Ey=a(),_a=p("p"),_a.textContent=Od,Hy=a(),M(Ba.$$.fragment),Vy=a(),Za=p("p"),Za.innerHTML=Kd,Yy=a(),qa=p("p"),qa.innerHTML=sm,Fy=a(),xa=p("p"),xa.textContent=tm,Ly=a(),M($a.$$.fragment),Dy=a(),Sa=p("p"),Sa.innerHTML=em,Py=a(),za=p("p"),za.innerHTML=lm,Oy=a(),M(Ga.$$.fragment),Ky=a(),Wa=p("p"),Wa.textContent=am,sj=a(),M(Ra.$$.fragment),tj=a(),ka=p("p"),ka.textContent=nm,ej=a(),Na=p("p"),Na.innerHTML=pm,lj=a(),Xa=p("p"),Xa.textContent=im,aj=a(),M(Qa.$$.fragment),nj=a(),M(z.$$.fragment),pj=a(),M(Ea.$$.fragment),ij=a(),Ha=p("p"),Ha.innerHTML=om,oj=a(),Va=p("p"),Va.innerHTML=Mm,Mj=a(),Ya=p("p"),Ya.innerHTML=um,uj=a(),Fa=p("p"),Fa.textContent=cm,cj=a(),M(La.$$.fragment),rj=a(),Da=p("p"),Da.textContent=rm,yj=a(),Pa=p("p"),Pa.innerHTML=ym,jj=a(),M(Oa.$$.fragment),Tj=a(),Ka=p("p"),Ka.textContent=jm,hj=a(),M(sn.$$.fragment),Jj=a(),tn=p("p"),tn.innerHTML=Tm,Uj=a(),en=p("p"),en.innerHTML=hm,wj=a(),ln=p("p"),ln.textContent=Jm,dj=a(),M(an.$$.fragment),mj=a(),nn=p("p"),nn.innerHTML=Um,fj=a(),pn=p("p"),pn.innerHTML=wm,Ij=a(),To=p("a"),Cj=a(),M(on.$$.fragment),bj=a(),Mn=p("p"),Mn.textContent=dm,Aj=a(),M(un.$$.fragment),gj=a(),cn=p("p"),cn.innerHTML=mm,vj=a(),rn=p("p"),rn.textContent=fm,_j=a(),M(yn.$$.fragment),Bj=a(),jn=p("p"),jn.innerHTML=Im,Zj=a(),ho=p("a"),qj=a(),M(Tn.$$.fragment),xj=a(),hn=p("p"),hn.textContent=Cm,$j=a(),M(Jn.$$.fragment),Sj=a(),Un=p("p"),Un.innerHTML=bm,zj=a(),wn=p("p"),wn.textContent=Am,Gj=a(),M(dn.$$.fragment),Wj=a(),mn=p("p"),mn.innerHTML=gm,Rj=a(),Jo=p("a"),kj=a(),M(fn.$$.fragment),Nj=a(),In=p("p"),In.textContent=vm,Xj=a(),M(Cn.$$.fragment),Qj=a(),bn=p("p"),bn.innerHTML=_m,Ej=a(),An=p("p"),An.textContent=Bm,Hj=a(),M(gn.$$.fragment),Vj=a(),vn=p("p"),vn.innerHTML=Zm,Yj=a(),Uo=p("a"),Fj=a(),M(_n.$$.fragment),Lj=a(),Bn=p("p"),Bn.innerHTML=qm,Dj=a(),Zn=p("p"),Zn.innerHTML=xm,Pj=a(),qn=p("p"),qn.innerHTML=$m,Oj=a(),xn=p("p"),xn.innerHTML=Sm,Kj=a(),M($n.$$.fragment),sT=a(),Sn=p("p"),Sn.innerHTML=zm,tT=a(),zn=p("p"),zn.innerHTML=Gm,eT=a(),Gn=p("p"),Gn.innerHTML=Wm,lT=a(),Wn=p("p"),Wn.textContent=Rm,aT=a(),Rn=p("p"),Rn.textContent=km,nT=a(),M(kn.$$.fragment),pT=a(),Nn=p("p"),Nn.innerHTML=Nm,iT=a(),M(Xn.$$.fragment),oT=a(),M(G.$$.fragment),MT=a(),Qn=p("p"),Qn.innerHTML=Xm,uT=a(),En=p("p"),En.innerHTML=Qm,cT=a(),M(Hn.$$.fragment),rT=a(),Vn=p("p"),Vn.innerHTML=Em,yT=a(),Yn=p("p"),Yn.innerHTML=Hm,jT=a(),Fn=p("p"),Fn.textContent=Vm,TT=a(),M(Ln.$$.fragment),hT=a(),Dn=p("p"),Dn.innerHTML=Ym,JT=a(),M(Pn.$$.fragment),UT=a(),On=p("p"),On.innerHTML=Fm,wT=a(),Kn=p("p"),Kn.textContent=Lm,dT=a(),sp=p("p"),sp.innerHTML=Dm,mT=a(),tp=p("p"),tp.innerHTML=Pm,fT=a(),ep=p("p"),ep.textContent=Om,IT=a(),M(lp.$$.fragment),CT=a(),ap=p("p"),ap.textContent=Km,bT=a(),np=p("p"),np.textContent=sf,AT=a(),pp=p("p"),pp.textContent=tf,gT=a(),M(ip.$$.fragment),vT=a(),op=p("p"),op.innerHTML=ef,_T=a(),M(Mp.$$.fragment),BT=a(),up=p("p"),up.textContent=lf,ZT=a(),cp=p("p"),cp.innerHTML=af,qT=a(),M(rp.$$.fragment),xT=a(),yp=p("p"),yp.innerHTML=nf,$T=a(),jp=p("p"),jp.textContent=pf,ST=a(),Tp=p("p"),Tp.innerHTML=of,zT=a(),hp=p("p"),hp.innerHTML=Mf,GT=a(),M(Jp.$$.fragment),WT=a(),Up=p("p"),Up.innerHTML=uf,RT=a(),wp=p("p"),wp.innerHTML=cf,kT=a(),dp=p("p"),dp.textContent=rf,NT=a(),M(mp.$$.fragment),XT=a(),fp=p("p"),fp.innerHTML=yf,QT=a(),wo=p("a"),ET=a(),M(Ip.$$.fragment),HT=a(),Cp=p("p"),Cp.textContent=jf,VT=a(),bp=p("p"),bp.innerHTML=Tf,YT=a(),M(Ap.$$.fragment),FT=a(),gp=p("p"),gp.textContent=hf,LT=a(),vp=p("p"),vp.innerHTML=Jf,DT=a(),M(_p.$$.fragment),PT=a(),Bp=p("p"),Bp.textContent=Uf,OT=a(),Zp=p("p"),Zp.textContent=wf,KT=a(),M(qp.$$.fragment),sh=a(),xp=p("p"),xp.textContent=df,th=a(),$p=p("p"),$p.textContent=mf,eh=a(),M(Sp.$$.fragment),lh=a(),zp=p("p"),zp.textContent=ff,ah=a(),Gp=p("p"),Gp.textContent=If,nh=a(),Wp=p("p"),Wp.textContent=Cf,ph=a(),Rp=p("p"),Rp.textContent=bf,ih=a(),M(kp.$$.fragment),oh=a(),Np=p("p"),Np.textContent=Af,Mh=a(),Xp=p("p"),Xp.innerHTML=gf,uh=a(),M(Qp.$$.fragment),ch=a(),Ep=p("p"),Ep.textContent=vf,rh=a(),Hp=p("p"),Hp.textContent=_f,yh=a(),C=p("ol"),mo=p("li"),mo.innerHTML=Bf,JJ=a(),fo=p("li"),fo.innerHTML=Zf,UJ=a(),Vp=p("li"),Io=p("p"),Io.textContent=qf,wJ=a(),M(Yp.$$.fragment),dJ=a(),Co=p("li"),Co.innerHTML=xf,mJ=a(),bo=p("li"),bo.innerHTML=$f,fJ=a(),Ao=p("li"),Ao.innerHTML=Sf,jh=a(),Fp=p("p"),Fp.textContent=zf,Th=a(),Lp=p("ul"),Lp.innerHTML=Gf,hh=a(),M(Dp.$$.fragment),Jh=a(),M(Pp.$$.fragment),Uh=a(),Op=p("p"),Op.innerHTML=Wf,wh=a(),M(Kp.$$.fragment),dh=a(),si=p("p"),si.textContent=Rf,mh=a(),ti=p("p"),ti.textContent=kf,fh=a(),M(ei.$$.fragment),Ih=a(),li=p("p"),li.innerHTML=Nf,Ch=a(),M(ai.$$.fragment),bh=a(),ni=p("p"),ni.textContent=Xf,Ah=a(),pi=p("p"),pi.textContent=Qf,gh=a(),ii=p("p"),ii.innerHTML=Ef,vh=a(),M(oi.$$.fragment),_h=a(),Mi=p("ul"),Mi.innerHTML=Hf,Bh=a(),M(ui.$$.fragment),Zh=a(),ci=p("p"),ci.innerHTML=Vf,qh=a(),ri=p("p"),ri.innerHTML=Yf,xh=a(),yi=p("p"),yi.innerHTML=Ff,$h=a(),ji=p("p"),ji.innerHTML=Lf,Sh=a(),Ti=p("p"),Ti.textContent=Df,zh=a(),M(hi.$$.fragment),Gh=a(),Ji=p("p"),Ji.textContent=Pf,Wh=a(),M(Ui.$$.fragment),Rh=a(),wi=p("p"),wi.innerHTML=Of,kh=a(),M(di.$$.fragment),Nh=a(),_=p("div"),M(mi.$$.fragment),IJ=a(),go=p("p"),go.textContent=Kf,CJ=a(),vo=p("p"),vo.innerHTML=sI,bJ=a(),_o=p("p"),_o.innerHTML=tI,Xh=a(),M(fi.$$.fragment),Qh=a(),Ii=p("p"),Ii.innerHTML=eI,Eh=a(),Ci=p("p"),Ci.textContent=lI,Hh=a(),bi=p("p"),bi.textContent=aI,Vh=a(),Ai=p("p"),Ai.textContent=nI,Yh=a(),gi=p("ol"),gi.innerHTML=pI,Fh=a(),M(vi.$$.fragment),Lh=a(),_i=p("p"),_i.innerHTML=iI,Dh=a(),M(Bi.$$.fragment),Ph=a(),Zi=p("p"),Zi.textContent=oI,Oh=a(),M(qi.$$.fragment),Kh=a(),xi=p("p"),xi.innerHTML=MI,sJ=a(),$i=p("p"),$i.innerHTML=uI,tJ=a(),M(Si.$$.fragment),eJ=a(),zi=p("p"),zi.textContent=cI,lJ=a(),Gi=p("p"),Gi.textContent=rI,aJ=a(),M(Wi.$$.fragment),nJ=a(),Ri=p("p"),Ri.textContent=yI,pJ=a(),M(ki.$$.fragment),iJ=a(),M(Ni.$$.fragment),oJ=a(),Xi=p("ul"),Xi.innerHTML=jI,MJ=a(),Qi=p("p"),Qi.textContent=TI,uJ=a(),Ei=p("ul"),Ei.innerHTML=hI,cJ=a(),Hi=p("p"),Hi.innerHTML=JI,rJ=a(),Zo=p("p"),this.h()},l(s){const t=fI("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(e),g=n(s),m=i(s,"P",{}),U(m).forEach(e),I=n(s),u(B.$$.fragment,s),Z=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-4c3rde"&&(b.innerHTML=Bo),f=n(s),v=i(s,"OL",{"data-svelte-h":!0}),o(v)!=="svelte-12k6of1"&&(v.innerHTML=vJ),xo=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1ipy5tt"&&(R.innerHTML=_J),$o=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-iaccrf"&&(k.textContent=BJ),So=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1jckdpk"&&(N.textContent=ZJ),zo=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-k3r8dh"&&(X.innerHTML=qJ),Go=n(s),Q=i(s,"OL",{"data-svelte-h":!0}),o(Q)!=="svelte-1vvwu75"&&(Q.innerHTML=xJ),Wo=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1j61y1r"&&(E.textContent=$J),Ro=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1igpel8"&&(H.textContent=SJ),ko=n(s),V=i(s,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-lihws0"&&(V.innerHTML=zJ),No=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1i9b1jx"&&(Y.textContent=GJ),Xo=n(s),F=i(s,"OL",{"data-svelte-h":!0}),o(F)!=="svelte-ipbdbn"&&(F.innerHTML=WJ),Qo=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1nlnufl"&&(L.textContent=RJ),Eo=n(s),Vi=i(s,"A",{id:!0}),U(Vi).forEach(e),Ho=n(s),u(D.$$.fragment,s),Vo=n(s),Yi=i(s,"A",{id:!0}),U(Yi).forEach(e),Yo=n(s),u(P.$$.fragment,s),Fo=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1vqjc6p"&&(O.textContent=kJ),Lo=n(s),u(K.$$.fragment,s),Do=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1t82ll5"&&(ss.innerHTML=NJ),Po=n(s),u(ts.$$.fragment,s),Oo=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-1cphooc"&&(es.innerHTML=XJ),Ko=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-122yejb"&&(ls.innerHTML=QJ),sM=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1cymhp5"&&(as.textContent=EJ),tM=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-168m9gp"&&(ns.textContent=HJ),eM=n(s),u(ps.$$.fragment,s),lM=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-a7t4f9"&&(is.innerHTML=VJ),aM=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-gl7s3y"&&(os.innerHTML=YJ),nM=n(s),u(Ms.$$.fragment,s),pM=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-yu99fb"&&(us.innerHTML=FJ),iM=n(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1ldirwe"&&(cs.textContent=LJ),oM=n(s),u(rs.$$.fragment,s),MM=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-17wmgg8"&&(ys.innerHTML=DJ),uM=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1rxyat4"&&(js.innerHTML=PJ),cM=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-x5qy10"&&(Ts.innerHTML=OJ),rM=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1mgjr9n"&&(hs.textContent=KJ),yM=n(s),u(Js.$$.fragment,s),jM=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-5piew1"&&(Us.textContent=sU),TM=n(s),u(ws.$$.fragment,s),hM=n(s),ds=i(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1jhj7gz"&&(ds.textContent=tU),JM=n(s),u(ms.$$.fragment,s),UM=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-wulif7"&&(fs.innerHTML=eU),wM=n(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-1m52oc1"&&(Is.innerHTML=lU),dM=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1bgh2n5"&&(Cs.innerHTML=aU),mM=n(s),Fi=i(s,"A",{id:!0}),U(Fi).forEach(e),fM=n(s),u(bs.$$.fragment,s),IM=n(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1uo6cay"&&(As.innerHTML=nU),CM=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-18nicry"&&(gs.textContent=pU),bM=n(s),u(vs.$$.fragment,s),AM=n(s),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1xbc0kp"&&(_s.innerHTML=iU),gM=n(s),u(Bs.$$.fragment,s),vM=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-14y0009"&&(Zs.innerHTML=oU),_M=n(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-4y3pxo"&&(qs.innerHTML=MU),BM=n(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-1jem9f9"&&(xs.innerHTML=uU),ZM=n(s),u($s.$$.fragment,s),qM=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1hk3m2d"&&(Ss.innerHTML=cU),xM=n(s),zs=i(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1r95sq9"&&(zs.innerHTML=rU),$M=n(s),Li=i(s,"A",{id:!0}),U(Li).forEach(e),SM=n(s),u(Gs.$$.fragment,s),zM=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-1v8ycf1"&&(Ws.innerHTML=yU),GM=n(s),u(Rs.$$.fragment,s),WM=n(s),ks=i(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-1xjofrh"&&(ks.innerHTML=jU),RM=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-3lttbu"&&(Ns.textContent=TU),kM=n(s),Xs=i(s,"OL",{"data-svelte-h":!0}),o(Xs)!=="svelte-11yg5ud"&&(Xs.innerHTML=hU),NM=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1ynxwf6"&&(Qs.textContent=JU),XM=n(s),u(Es.$$.fragment,s),QM=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1w20i2l"&&(Hs.textContent=UU),EM=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1cjih2x"&&(Vs.innerHTML=wU),HM=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1vjeo35"&&(Ys.textContent=dU),VM=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-1biq3pv"&&(Fs.textContent=mU),YM=n(s),Di=i(s,"UL",{});var qo=U(Di);q=i(qo,"LI",{});var x=U(q);Pi=i(x,"P",{"data-svelte-h":!0}),o(Pi)!=="svelte-t6dru4"&&(Pi.innerHTML=fU),TJ=n(x),u(Ls.$$.fragment,x),hJ=n(x),Oi=i(x,"P",{"data-svelte-h":!0}),o(Oi)!=="svelte-1qlwfj"&&(Oi.textContent=IU),x.forEach(e),qo.forEach(e),FM=n(s),Ki=i(s,"A",{id:!0}),U(Ki).forEach(e),LM=n(s),u(Ds.$$.fragment,s),DM=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-1qsnpa1"&&(Ps.innerHTML=CU),PM=n(s),Os=i(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-84g6lv"&&(Os.innerHTML=bU),OM=n(s),u(Ks.$$.fragment,s),KM=n(s),st=i(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-dh13n7"&&(st.innerHTML=AU),su=n(s),u(tt.$$.fragment,s),tu=n(s),et=i(s,"P",{"data-svelte-h":!0}),o(et)!=="svelte-kk9ioq"&&(et.textContent=gU),eu=n(s),lt=i(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-bk7isu"&&(lt.innerHTML=vU),lu=n(s),u(at.$$.fragment,s),au=n(s),nt=i(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1u51h9h"&&(nt.innerHTML=_U),nu=n(s),u(pt.$$.fragment,s),pu=n(s),it=i(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1ipwpw9"&&(it.textContent=BU),iu=n(s),u(ot.$$.fragment,s),ou=n(s),Mt=i(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1c219ul"&&(Mt.innerHTML=ZU),Mu=n(s),ut=i(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1pc2cg3"&&(ut.innerHTML=qU),uu=n(s),u(ct.$$.fragment,s),cu=n(s),rt=i(s,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-7vonjg"&&(rt.innerHTML=xU),ru=n(s),u(yt.$$.fragment,s),yu=n(s),jt=i(s,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-yis0vn"&&(jt.textContent=$U),ju=n(s),u(Tt.$$.fragment,s),Tu=n(s),ht=i(s,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-5wrpqf"&&(ht.innerHTML=SU),hu=n(s),u(Jt.$$.fragment,s),Ju=n(s),Ut=i(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-10606ys"&&(Ut.innerHTML=zU),Uu=n(s),u(wt.$$.fragment,s),wu=n(s),dt=i(s,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-11kauro"&&(dt.innerHTML=GU),du=n(s),so=i(s,"A",{id:!0}),U(so).forEach(e),mu=n(s),u(mt.$$.fragment,s),fu=n(s),ft=i(s,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1gplil1"&&(ft.innerHTML=WU),Iu=n(s),It=i(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-rsdc5h"&&(It.textContent=RU),Cu=n(s),u(Ct.$$.fragment,s),bu=n(s),bt=i(s,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1ehkqs4"&&(bt.innerHTML=kU),Au=n(s),At=i(s,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1valkuq"&&(At.textContent=NU),gu=n(s),gt=i(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1714474"&&(gt.textContent=XU),vu=n(s),u(vt.$$.fragment,s),_u=n(s),_t=i(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-nh20cz"&&(_t.innerHTML=QU),Bu=n(s),u(Bt.$$.fragment,s),Zu=n(s),Zt=i(s,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-2zmg66"&&(Zt.innerHTML=EU),qu=n(s),u(qt.$$.fragment,s),xu=n(s),xt=i(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-tgm4xl"&&(xt.textContent=HU),$u=n(s),$t=i(s,"P",{"data-svelte-h":!0}),o($t)!=="svelte-5k5wyb"&&($t.innerHTML=VU),Su=n(s),to=i(s,"A",{id:!0}),U(to).forEach(e),zu=n(s),u(St.$$.fragment,s),Gu=n(s),zt=i(s,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1twydg2"&&(zt.innerHTML=YU),Wu=n(s),Gt=i(s,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1mc0tbi"&&(Gt.innerHTML=FU),Ru=n(s),u(Wt.$$.fragment,s),ku=n(s),Rt=i(s,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-jyv2rl"&&(Rt.innerHTML=LU),Nu=n(s),u(kt.$$.fragment,s),Xu=n(s),Nt=i(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1cqg1x2"&&(Nt.innerHTML=DU),Qu=n(s),Xt=i(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-1ledwpo"&&(Xt.textContent=PU),Eu=n(s),Qt=i(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1hl5ia"&&(Qt.innerHTML=OU),Hu=n(s),u(Et.$$.fragment,s),Vu=n(s),Ht=i(s,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-cigzpi"&&(Ht.innerHTML=KU),Yu=n(s),eo=i(s,"A",{id:!0}),U(eo).forEach(e),Fu=n(s),u(Vt.$$.fragment,s),Lu=n(s),Yt=i(s,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-8nua75"&&(Yt.innerHTML=sw),Du=n(s),Ft=i(s,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1ixfnm8"&&(Ft.textContent=tw),Pu=n(s),u(Lt.$$.fragment,s),Ou=n(s),Dt=i(s,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-ylttvt"&&(Dt.textContent=ew),Ku=n(s),u(Pt.$$.fragment,s),sc=n(s),lo=i(s,"A",{id:!0}),U(lo).forEach(e),tc=n(s),u(Ot.$$.fragment,s),ec=n(s),u(S.$$.fragment,s),lc=n(s),Kt=i(s,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-xf81m4"&&(Kt.innerHTML=lw),ac=n(s),se=i(s,"P",{"data-svelte-h":!0}),o(se)!=="svelte-dy6nxn"&&(se.innerHTML=aw),nc=n(s),te=i(s,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1f8kvoz"&&(te.innerHTML=nw),pc=n(s),ee=i(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-969ltr"&&(ee.textContent=pw),ic=n(s),le=i(s,"P",{"data-svelte-h":!0}),o(le)!=="svelte-7hfzd3"&&(le.innerHTML=iw),oc=n(s),ae=i(s,"OL",{"data-svelte-h":!0}),o(ae)!=="svelte-d4p2q3"&&(ae.innerHTML=ow),Mc=n(s),ne=i(s,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-c9gc1z"&&(ne.innerHTML=Mw),uc=n(s),ao=i(s,"A",{id:!0}),U(ao).forEach(e),cc=n(s),u(pe.$$.fragment,s),rc=n(s),ie=i(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-24gsuk"&&(ie.innerHTML=uw),yc=n(s),oe=i(s,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-878q4m"&&(oe.innerHTML=cw),jc=n(s),Me=i(s,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1gi8ru8"&&(Me.innerHTML=rw),Tc=n(s),ue=i(s,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-107618e"&&(ue.textContent=yw),hc=n(s),no=i(s,"A",{id:!0}),U(no).forEach(e),Jc=n(s),u(ce.$$.fragment,s),Uc=n(s),re=i(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-15jy11l"&&(re.textContent=jw),wc=n(s),u(ye.$$.fragment,s),dc=n(s),je=i(s,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1fr2k06"&&(je.innerHTML=Tw),mc=n(s),Te=i(s,"UL",{"data-svelte-h":!0}),o(Te)!=="svelte-1dbs24o"&&(Te.innerHTML=hw),fc=n(s),he=i(s,"P",{"data-svelte-h":!0}),o(he)!=="svelte-qsswlv"&&(he.innerHTML=Jw),Ic=n(s),u(Je.$$.fragment,s),Cc=n(s),Ue=i(s,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1w7z5ow"&&(Ue.textContent=Uw),bc=n(s),po=i(s,"A",{id:!0}),U(po).forEach(e),Ac=n(s),u(we.$$.fragment,s),gc=n(s),de=i(s,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1tebs8m"&&(de.textContent=ww),vc=n(s),u(me.$$.fragment,s),_c=n(s),fe=i(s,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1g2nab0"&&(fe.innerHTML=dw),Bc=n(s),Ie=i(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-ko8r4h"&&(Ie.innerHTML=mw),Zc=n(s),Ce=i(s,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1fr2k06"&&(Ce.innerHTML=fw),qc=n(s),be=i(s,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-l43e63"&&(be.innerHTML=Iw),xc=n(s),Ae=i(s,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-pylq8y"&&(Ae.innerHTML=Cw),$c=n(s),ge=i(s,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1x1c6u9"&&(ge.innerHTML=bw),Sc=n(s),ve=i(s,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-p0gfl6"&&(ve.textContent=Aw),zc=n(s),_e=i(s,"UL",{"data-svelte-h":!0}),o(_e)!=="svelte-1iwv2ux"&&(_e.innerHTML=gw),Gc=n(s),Be=i(s,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1i8v5ll"&&(Be.innerHTML=vw),Wc=n(s),Ze=i(s,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-2klf7u"&&(Ze.innerHTML=_w),Rc=n(s),qe=i(s,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-qdu2k0"&&(qe.innerHTML=Bw),kc=n(s),xe=i(s,"UL",{"data-svelte-h":!0}),o(xe)!=="svelte-1a9ucw0"&&(xe.innerHTML=Zw),Nc=n(s),$e=i(s,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1h39ux0"&&($e.innerHTML=qw),Xc=n(s),Se=i(s,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1ykp0a6"&&(Se.innerHTML=xw),Qc=n(s),ze=i(s,"OL",{"data-svelte-h":!0}),o(ze)!=="svelte-184i5cb"&&(ze.innerHTML=$w),Ec=n(s),u(Ge.$$.fragment,s),Hc=n(s),We=i(s,"P",{"data-svelte-h":!0}),o(We)!=="svelte-d6yedb"&&(We.textContent=Sw),Vc=n(s),Re=i(s,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1vpgrfa"&&(Re.textContent=zw),Yc=n(s),u(ke.$$.fragment,s),Fc=n(s),Ne=i(s,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1o9ymaq"&&(Ne.textContent=Gw),Lc=n(s),u(Xe.$$.fragment,s),Dc=n(s),Qe=i(s,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1mxfzxv"&&(Qe.textContent=Ww),Pc=n(s),u(Ee.$$.fragment,s),Oc=n(s),io=i(s,"A",{id:!0}),U(io).forEach(e),Kc=n(s),u(He.$$.fragment,s),sr=n(s),Ve=i(s,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-169yzfh"&&(Ve.textContent=Rw),tr=n(s),Ye=i(s,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-4qz2m"&&(Ye.textContent=kw),er=n(s),u(Fe.$$.fragment,s),lr=n(s),Le=i(s,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-6el816"&&(Le.innerHTML=Nw),ar=n(s),De=i(s,"P",{"data-svelte-h":!0}),o(De)!=="svelte-muwnvs"&&(De.innerHTML=Xw),nr=n(s),Pe=i(s,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1xgzrsc"&&(Pe.innerHTML=Qw),pr=n(s),Oe=i(s,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-f73cj8"&&(Oe.innerHTML=Ew),ir=n(s),oo=i(s,"A",{id:!0}),U(oo).forEach(e),or=n(s),u(Ke.$$.fragment,s),Mr=n(s),sl=i(s,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-q8gcrr"&&(sl.textContent=Hw),ur=n(s),tl=i(s,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-zjlf7h"&&(tl.textContent=Vw),cr=n(s),el=i(s,"UL",{"data-svelte-h":!0}),o(el)!=="svelte-11ygmoj"&&(el.innerHTML=Yw),rr=n(s),ll=i(s,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-jwn0zz"&&(ll.innerHTML=Fw),yr=n(s),Mo=i(s,"A",{id:!0}),U(Mo).forEach(e),jr=n(s),u(al.$$.fragment,s),Tr=n(s),nl=i(s,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-kggmat"&&(nl.innerHTML=Lw),hr=n(s),u(pl.$$.fragment,s),Jr=n(s),il=i(s,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1iwd1rz"&&(il.innerHTML=Dw),Ur=n(s),u(ol.$$.fragment,s),wr=n(s),uo=i(s,"A",{id:!0}),U(uo).forEach(e),dr=n(s),u(Ml.$$.fragment,s),mr=n(s),ul=i(s,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1rafa19"&&(ul.innerHTML=Pw),fr=n(s),u(cl.$$.fragment,s),Ir=n(s),rl=i(s,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-1enkn00"&&(rl.innerHTML=Ow),Cr=n(s),u(yl.$$.fragment,s),br=n(s),u(jl.$$.fragment,s),Ar=n(s),Tl=i(s,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-qfhyy9"&&(Tl.textContent=Kw),gr=n(s),hl=i(s,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-16uf65b"&&(hl.textContent=sd),vr=n(s),Jl=i(s,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-1j4sbsl"&&(Jl.innerHTML=td),_r=n(s),Ul=i(s,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1ab7r8x"&&(Ul.textContent=ed),Br=n(s),wl=i(s,"UL",{"data-svelte-h":!0}),o(wl)!=="svelte-covk0c"&&(wl.innerHTML=ld),Zr=n(s),dl=i(s,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-4dwozd"&&(dl.textContent=ad),qr=n(s),ml=i(s,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1dr92i0"&&(ml.textContent=nd),xr=n(s),fl=i(s,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-t7pxdh"&&(fl.textContent=pd),$r=n(s),Il=i(s,"OL",{"data-svelte-h":!0}),o(Il)!=="svelte-287qs6"&&(Il.innerHTML=id),Sr=n(s),Cl=i(s,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-16perix"&&(Cl.textContent=od),zr=n(s),bl=i(s,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1dtmptu"&&(bl.textContent=Md),Gr=n(s),Al=i(s,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-1sz5y3k"&&(Al.textContent=ud),Wr=n(s),gl=i(s,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1yer2s4"&&(gl.textContent=cd),Rr=n(s),vl=i(s,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-1my41ql"&&(vl.textContent=rd),kr=n(s),_l=i(s,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-10a65tx"&&(_l.innerHTML=yd),Nr=n(s),Bl=i(s,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-11pyqnf"&&(Bl.textContent=jd),Xr=n(s),Zl=i(s,"UL",{"data-svelte-h":!0}),o(Zl)!=="svelte-1d88xai"&&(Zl.innerHTML=Td),Qr=n(s),u(ql.$$.fragment,s),Er=n(s),xl=i(s,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-10cvgi7"&&(xl.textContent=hd),Hr=n(s),$l=i(s,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1w613qh"&&($l.textContent=Jd),Vr=n(s),Sl=i(s,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-s4wgap"&&(Sl.textContent=Ud),Yr=n(s),zl=i(s,"P",{"data-svelte-h":!0}),o(zl)!=="svelte-c067ql"&&(zl.textContent=wd),Fr=n(s),Gl=i(s,"OL",{"data-svelte-h":!0}),o(Gl)!=="svelte-cglkiv"&&(Gl.innerHTML=dd),Lr=n(s),u(Wl.$$.fragment,s),Dr=n(s),Rl=i(s,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-1l8r1qw"&&(Rl.innerHTML=md),Pr=n(s),kl=i(s,"TABLE",{"data-svelte-h":!0}),o(kl)!=="svelte-61eese"&&(kl.innerHTML=fd),Or=n(s),Nl=i(s,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-10k5ql"&&(Nl.innerHTML=Id),Kr=n(s),co=i(s,"A",{id:!0}),U(co).forEach(e),sy=n(s),u(Xl.$$.fragment,s),ty=n(s),Ql=i(s,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-zvvps7"&&(Ql.innerHTML=Cd),ey=n(s),El=i(s,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1wexatd"&&(El.innerHTML=bd),ly=n(s),Hl=i(s,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-qqxtuf"&&(Hl.innerHTML=Ad),ay=n(s),u(Vl.$$.fragment,s),ny=n(s),Yl=i(s,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-1fu4tok"&&(Yl.textContent=gd),py=n(s),Fl=i(s,"UL",{"data-svelte-h":!0}),o(Fl)!=="svelte-hhd3hb"&&(Fl.innerHTML=vd),iy=n(s),Ll=i(s,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-an845p"&&(Ll.textContent=_d),oy=n(s),Dl=i(s,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-ho8hoo"&&(Dl.textContent=Bd),My=n(s),u(Pl.$$.fragment,s),uy=n(s),Ol=i(s,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-ue9mzo"&&(Ol.innerHTML=Zd),cy=n(s),Kl=i(s,"P",{"data-svelte-h":!0}),o(Kl)!=="svelte-iuz4k6"&&(Kl.textContent=qd),ry=n(s),u(sa.$$.fragment,s),yy=n(s),ta=i(s,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-1f0ysyu"&&(ta.innerHTML=xd),jy=n(s),ea=i(s,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-1o7ogjk"&&(ea.innerHTML=$d),Ty=n(s),u(la.$$.fragment,s),hy=n(s),aa=i(s,"P",{"data-svelte-h":!0}),o(aa)!=="svelte-qrzd6x"&&(aa.textContent=Sd),Jy=n(s),ro=i(s,"A",{id:!0}),U(ro).forEach(e),Uy=n(s),u(na.$$.fragment,s),wy=n(s),pa=i(s,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-1bm7jil"&&(pa.innerHTML=zd),dy=n(s),ia=i(s,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-1cqsh10"&&(ia.textContent=Gd),my=n(s),oa=i(s,"UL",{"data-svelte-h":!0}),o(oa)!=="svelte-zirrsg"&&(oa.innerHTML=Wd),fy=n(s),Ma=i(s,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-p7o0mz"&&(Ma.innerHTML=Rd),Iy=n(s),ua=i(s,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-w55f7f"&&(ua.innerHTML=kd),Cy=n(s),u(ca.$$.fragment,s),by=n(s),ra=i(s,"P",{"data-svelte-h":!0}),o(ra)!=="svelte-6r9mld"&&(ra.innerHTML=Nd),Ay=n(s),ya=i(s,"UL",{"data-svelte-h":!0}),o(ya)!=="svelte-gr31mi"&&(ya.innerHTML=Xd),gy=n(s),ja=i(s,"P",{"data-svelte-h":!0}),o(ja)!=="svelte-17pyaox"&&(ja.textContent=Qd),vy=n(s),u(Ta.$$.fragment,s),_y=n(s),ha=i(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-ue9mzo"&&(ha.innerHTML=Ed),By=n(s),Ja=i(s,"P",{"data-svelte-h":!0}),o(Ja)!=="svelte-1lf5l3z"&&(Ja.innerHTML=Hd),Zy=n(s),u(Ua.$$.fragment,s),qy=n(s),wa=i(s,"P",{"data-svelte-h":!0}),o(wa)!=="svelte-qnxoz2"&&(wa.innerHTML=Vd),xy=n(s),yo=i(s,"A",{id:!0}),U(yo).forEach(e),$y=n(s),u(da.$$.fragment,s),Sy=n(s),ma=i(s,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-1dvil4m"&&(ma.textContent=Yd),zy=n(s),fa=i(s,"P",{"data-svelte-h":!0}),o(fa)!=="svelte-m827p9"&&(fa.innerHTML=Fd),Gy=n(s),u(Ia.$$.fragment,s),Wy=n(s),Ca=i(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-bdy26k"&&(Ca.innerHTML=Ld),Ry=n(s),ba=i(s,"P",{"data-svelte-h":!0}),o(ba)!=="svelte-kydp6d"&&(ba.innerHTML=Dd),ky=n(s),jo=i(s,"A",{id:!0}),U(jo).forEach(e),Ny=n(s),u(Aa.$$.fragment,s),Xy=n(s),ga=i(s,"P",{"data-svelte-h":!0}),o(ga)!=="svelte-kybyhn"&&(ga.textContent=Pd),Qy=n(s),u(va.$$.fragment,s),Ey=n(s),_a=i(s,"P",{"data-svelte-h":!0}),o(_a)!=="svelte-cwa3yk"&&(_a.textContent=Od),Hy=n(s),u(Ba.$$.fragment,s),Vy=n(s),Za=i(s,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-1dypvaz"&&(Za.innerHTML=Kd),Yy=n(s),qa=i(s,"P",{"data-svelte-h":!0}),o(qa)!=="svelte-pmyaoj"&&(qa.innerHTML=sm),Fy=n(s),xa=i(s,"P",{"data-svelte-h":!0}),o(xa)!=="svelte-1nyp904"&&(xa.textContent=tm),Ly=n(s),u($a.$$.fragment,s),Dy=n(s),Sa=i(s,"P",{"data-svelte-h":!0}),o(Sa)!=="svelte-ue9mzo"&&(Sa.innerHTML=em),Py=n(s),za=i(s,"P",{"data-svelte-h":!0}),o(za)!=="svelte-12xhtcc"&&(za.innerHTML=lm),Oy=n(s),u(Ga.$$.fragment,s),Ky=n(s),Wa=i(s,"P",{"data-svelte-h":!0}),o(Wa)!=="svelte-169tzv7"&&(Wa.textContent=am),sj=n(s),u(Ra.$$.fragment,s),tj=n(s),ka=i(s,"P",{"data-svelte-h":!0}),o(ka)!=="svelte-5n7z7p"&&(ka.textContent=nm),ej=n(s),Na=i(s,"P",{"data-svelte-h":!0}),o(Na)!=="svelte-1nldlad"&&(Na.innerHTML=pm),lj=n(s),Xa=i(s,"P",{"data-svelte-h":!0}),o(Xa)!=="svelte-1nyp904"&&(Xa.textContent=im),aj=n(s),u(Qa.$$.fragment,s),nj=n(s),u(z.$$.fragment,s),pj=n(s),u(Ea.$$.fragment,s),ij=n(s),Ha=i(s,"P",{"data-svelte-h":!0}),o(Ha)!=="svelte-1u92iuj"&&(Ha.innerHTML=om),oj=n(s),Va=i(s,"P",{"data-svelte-h":!0}),o(Va)!=="svelte-86oqji"&&(Va.innerHTML=Mm),Mj=n(s),Ya=i(s,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-qbyzy7"&&(Ya.innerHTML=um),uj=n(s),Fa=i(s,"P",{"data-svelte-h":!0}),o(Fa)!=="svelte-jwyw4f"&&(Fa.textContent=cm),cj=n(s),u(La.$$.fragment,s),rj=n(s),Da=i(s,"P",{"data-svelte-h":!0}),o(Da)!=="svelte-1o8aerk"&&(Da.textContent=rm),yj=n(s),Pa=i(s,"P",{"data-svelte-h":!0}),o(Pa)!=="svelte-1i0626v"&&(Pa.innerHTML=ym),jj=n(s),u(Oa.$$.fragment,s),Tj=n(s),Ka=i(s,"P",{"data-svelte-h":!0}),o(Ka)!=="svelte-1iq1d9w"&&(Ka.textContent=jm),hj=n(s),u(sn.$$.fragment,s),Jj=n(s),tn=i(s,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-lllfxw"&&(tn.innerHTML=Tm),Uj=n(s),en=i(s,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1dbs7ls"&&(en.innerHTML=hm),wj=n(s),ln=i(s,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-1h83nqw"&&(ln.textContent=Jm),dj=n(s),u(an.$$.fragment,s),mj=n(s),nn=i(s,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-ue9mzo"&&(nn.innerHTML=Um),fj=n(s),pn=i(s,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-5l4nm8"&&(pn.innerHTML=wm),Ij=n(s),To=i(s,"A",{id:!0}),U(To).forEach(e),Cj=n(s),u(on.$$.fragment,s),bj=n(s),Mn=i(s,"P",{"data-svelte-h":!0}),o(Mn)!=="svelte-xs1yap"&&(Mn.textContent=dm),Aj=n(s),u(un.$$.fragment,s),gj=n(s),cn=i(s,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-18baci6"&&(cn.innerHTML=mm),vj=n(s),rn=i(s,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-ho8hoo"&&(rn.textContent=fm),_j=n(s),u(yn.$$.fragment,s),Bj=n(s),jn=i(s,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-ue9mzo"&&(jn.innerHTML=Im),Zj=n(s),ho=i(s,"A",{id:!0}),U(ho).forEach(e),qj=n(s),u(Tn.$$.fragment,s),xj=n(s),hn=i(s,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-117mynk"&&(hn.textContent=Cm),$j=n(s),u(Jn.$$.fragment,s),Sj=n(s),Un=i(s,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-2o9bmr"&&(Un.innerHTML=bm),zj=n(s),wn=i(s,"P",{"data-svelte-h":!0}),o(wn)!=="svelte-1ml0uo7"&&(wn.textContent=Am),Gj=n(s),u(dn.$$.fragment,s),Wj=n(s),mn=i(s,"P",{"data-svelte-h":!0}),o(mn)!=="svelte-ue9mzo"&&(mn.innerHTML=gm),Rj=n(s),Jo=i(s,"A",{id:!0}),U(Jo).forEach(e),kj=n(s),u(fn.$$.fragment,s),Nj=n(s),In=i(s,"P",{"data-svelte-h":!0}),o(In)!=="svelte-5w86or"&&(In.textContent=vm),Xj=n(s),u(Cn.$$.fragment,s),Qj=n(s),bn=i(s,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-cyc5vj"&&(bn.innerHTML=_m),Ej=n(s),An=i(s,"P",{"data-svelte-h":!0}),o(An)!=="svelte-1ml0uo7"&&(An.textContent=Bm),Hj=n(s),u(gn.$$.fragment,s),Vj=n(s),vn=i(s,"P",{"data-svelte-h":!0}),o(vn)!=="svelte-ue9mzo"&&(vn.innerHTML=Zm),Yj=n(s),Uo=i(s,"A",{id:!0}),U(Uo).forEach(e),Fj=n(s),u(_n.$$.fragment,s),Lj=n(s),Bn=i(s,"P",{"data-svelte-h":!0}),o(Bn)!=="svelte-17ht9wx"&&(Bn.innerHTML=qm),Dj=n(s),Zn=i(s,"P",{"data-svelte-h":!0}),o(Zn)!=="svelte-1w3rd8v"&&(Zn.innerHTML=xm),Pj=n(s),qn=i(s,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-skbdco"&&(qn.innerHTML=$m),Oj=n(s),xn=i(s,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-1bhjkyj"&&(xn.innerHTML=Sm),Kj=n(s),u($n.$$.fragment,s),sT=n(s),Sn=i(s,"P",{"data-svelte-h":!0}),o(Sn)!=="svelte-smfkl9"&&(Sn.innerHTML=zm),tT=n(s),zn=i(s,"P",{"data-svelte-h":!0}),o(zn)!=="svelte-dunk9g"&&(zn.innerHTML=Gm),eT=n(s),Gn=i(s,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-1lyq672"&&(Gn.innerHTML=Wm),lT=n(s),Wn=i(s,"P",{"data-svelte-h":!0}),o(Wn)!=="svelte-1alw0cq"&&(Wn.textContent=Rm),aT=n(s),Rn=i(s,"P",{"data-svelte-h":!0}),o(Rn)!=="svelte-vnz9bj"&&(Rn.textContent=km),nT=n(s),u(kn.$$.fragment,s),pT=n(s),Nn=i(s,"P",{"data-svelte-h":!0}),o(Nn)!=="svelte-1kitce"&&(Nn.innerHTML=Nm),iT=n(s),u(Xn.$$.fragment,s),oT=n(s),u(G.$$.fragment,s),MT=n(s),Qn=i(s,"P",{"data-svelte-h":!0}),o(Qn)!=="svelte-46af4q"&&(Qn.innerHTML=Xm),uT=n(s),En=i(s,"P",{"data-svelte-h":!0}),o(En)!=="svelte-1k7xvv3"&&(En.innerHTML=Qm),cT=n(s),u(Hn.$$.fragment,s),rT=n(s),Vn=i(s,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-75olud"&&(Vn.innerHTML=Em),yT=n(s),Yn=i(s,"P",{"data-svelte-h":!0}),o(Yn)!=="svelte-1c769bq"&&(Yn.innerHTML=Hm),jT=n(s),Fn=i(s,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-x82t5s"&&(Fn.textContent=Vm),TT=n(s),u(Ln.$$.fragment,s),hT=n(s),Dn=i(s,"P",{"data-svelte-h":!0}),o(Dn)!=="svelte-nly9am"&&(Dn.innerHTML=Ym),JT=n(s),u(Pn.$$.fragment,s),UT=n(s),On=i(s,"P",{"data-svelte-h":!0}),o(On)!=="svelte-1y5jgb5"&&(On.innerHTML=Fm),wT=n(s),Kn=i(s,"P",{"data-svelte-h":!0}),o(Kn)!=="svelte-3pqf1n"&&(Kn.textContent=Lm),dT=n(s),sp=i(s,"P",{"data-svelte-h":!0}),o(sp)!=="svelte-9879ii"&&(sp.innerHTML=Dm),mT=n(s),tp=i(s,"P",{"data-svelte-h":!0}),o(tp)!=="svelte-13yg7dv"&&(tp.innerHTML=Pm),fT=n(s),ep=i(s,"P",{"data-svelte-h":!0}),o(ep)!=="svelte-1wfe5kh"&&(ep.textContent=Om),IT=n(s),u(lp.$$.fragment,s),CT=n(s),ap=i(s,"P",{"data-svelte-h":!0}),o(ap)!=="svelte-1m0vnge"&&(ap.textContent=Km),bT=n(s),np=i(s,"P",{"data-svelte-h":!0}),o(np)!=="svelte-1vst44s"&&(np.textContent=sf),AT=n(s),pp=i(s,"P",{"data-svelte-h":!0}),o(pp)!=="svelte-zk7rbv"&&(pp.textContent=tf),gT=n(s),u(ip.$$.fragment,s),vT=n(s),op=i(s,"P",{"data-svelte-h":!0}),o(op)!=="svelte-17kyo4r"&&(op.innerHTML=ef),_T=n(s),u(Mp.$$.fragment,s),BT=n(s),up=i(s,"P",{"data-svelte-h":!0}),o(up)!=="svelte-12v8sdv"&&(up.textContent=lf),ZT=n(s),cp=i(s,"P",{"data-svelte-h":!0}),o(cp)!=="svelte-1bfw61y"&&(cp.innerHTML=af),qT=n(s),u(rp.$$.fragment,s),xT=n(s),yp=i(s,"P",{"data-svelte-h":!0}),o(yp)!=="svelte-1citdyb"&&(yp.innerHTML=nf),$T=n(s),jp=i(s,"P",{"data-svelte-h":!0}),o(jp)!=="svelte-1iltlt8"&&(jp.textContent=pf),ST=n(s),Tp=i(s,"P",{"data-svelte-h":!0}),o(Tp)!=="svelte-lvtfhp"&&(Tp.innerHTML=of),zT=n(s),hp=i(s,"P",{"data-svelte-h":!0}),o(hp)!=="svelte-ifovwy"&&(hp.innerHTML=Mf),GT=n(s),u(Jp.$$.fragment,s),WT=n(s),Up=i(s,"P",{"data-svelte-h":!0}),o(Up)!=="svelte-1m7dsvx"&&(Up.innerHTML=uf),RT=n(s),wp=i(s,"P",{"data-svelte-h":!0}),o(wp)!=="svelte-zsc548"&&(wp.innerHTML=cf),kT=n(s),dp=i(s,"P",{"data-svelte-h":!0}),o(dp)!=="svelte-112tcb5"&&(dp.textContent=rf),NT=n(s),u(mp.$$.fragment,s),XT=n(s),fp=i(s,"P",{"data-svelte-h":!0}),o(fp)!=="svelte-1hh79bp"&&(fp.innerHTML=yf),QT=n(s),wo=i(s,"A",{id:!0}),U(wo).forEach(e),ET=n(s),u(Ip.$$.fragment,s),HT=n(s),Cp=i(s,"P",{"data-svelte-h":!0}),o(Cp)!=="svelte-1kc5zro"&&(Cp.textContent=jf),VT=n(s),bp=i(s,"P",{"data-svelte-h":!0}),o(bp)!=="svelte-1ua0yoe"&&(bp.innerHTML=Tf),YT=n(s),u(Ap.$$.fragment,s),FT=n(s),gp=i(s,"P",{"data-svelte-h":!0}),o(gp)!=="svelte-y0v7ku"&&(gp.textContent=hf),LT=n(s),vp=i(s,"P",{"data-svelte-h":!0}),o(vp)!=="svelte-1jem9f9"&&(vp.innerHTML=Jf),DT=n(s),u(_p.$$.fragment,s),PT=n(s),Bp=i(s,"P",{"data-svelte-h":!0}),o(Bp)!=="svelte-1dep852"&&(Bp.textContent=Uf),OT=n(s),Zp=i(s,"P",{"data-svelte-h":!0}),o(Zp)!=="svelte-j75mu1"&&(Zp.textContent=wf),KT=n(s),u(qp.$$.fragment,s),sh=n(s),xp=i(s,"P",{"data-svelte-h":!0}),o(xp)!=="svelte-ezkzj2"&&(xp.textContent=df),th=n(s),$p=i(s,"P",{"data-svelte-h":!0}),o($p)!=="svelte-1ugusnt"&&($p.textContent=mf),eh=n(s),u(Sp.$$.fragment,s),lh=n(s),zp=i(s,"P",{"data-svelte-h":!0}),o(zp)!=="svelte-ct9ez8"&&(zp.textContent=ff),ah=n(s),Gp=i(s,"P",{"data-svelte-h":!0}),o(Gp)!=="svelte-s1px3l"&&(Gp.textContent=If),nh=n(s),Wp=i(s,"P",{"data-svelte-h":!0}),o(Wp)!=="svelte-bmrnhs"&&(Wp.textContent=Cf),ph=n(s),Rp=i(s,"P",{"data-svelte-h":!0}),o(Rp)!=="svelte-g2c16a"&&(Rp.textContent=bf),ih=n(s),u(kp.$$.fragment,s),oh=n(s),Np=i(s,"P",{"data-svelte-h":!0}),o(Np)!=="svelte-9c1q51"&&(Np.textContent=Af),Mh=n(s),Xp=i(s,"P",{"data-svelte-h":!0}),o(Xp)!=="svelte-24xeo5"&&(Xp.innerHTML=gf),uh=n(s),u(Qp.$$.fragment,s),ch=n(s),Ep=i(s,"P",{"data-svelte-h":!0}),o(Ep)!=="svelte-1kab485"&&(Ep.textContent=vf),rh=n(s),Hp=i(s,"P",{"data-svelte-h":!0}),o(Hp)!=="svelte-1oebycv"&&(Hp.textContent=_f),yh=n(s),C=i(s,"OL",{});var A=U(C);mo=i(A,"LI",{"data-svelte-h":!0}),o(mo)!=="svelte-rrz71w"&&(mo.innerHTML=Bf),JJ=n(A),fo=i(A,"LI",{"data-svelte-h":!0}),o(fo)!=="svelte-1ym73sx"&&(fo.innerHTML=Zf),UJ=n(A),Vp=i(A,"LI",{});var jJ=U(Vp);Io=i(jJ,"P",{"data-svelte-h":!0}),o(Io)!=="svelte-1ncrygs"&&(Io.textContent=qf),wJ=n(jJ),u(Yp.$$.fragment,jJ),jJ.forEach(e),dJ=n(A),Co=i(A,"LI",{"data-svelte-h":!0}),o(Co)!=="svelte-tdhskc"&&(Co.innerHTML=xf),mJ=n(A),bo=i(A,"LI",{"data-svelte-h":!0}),o(bo)!=="svelte-1bwmgyk"&&(bo.innerHTML=$f),fJ=n(A),Ao=i(A,"LI",{"data-svelte-h":!0}),o(Ao)!=="svelte-ql9qyt"&&(Ao.innerHTML=Sf),A.forEach(e),jh=n(s),Fp=i(s,"P",{"data-svelte-h":!0}),o(Fp)!=="svelte-3g72th"&&(Fp.textContent=zf),Th=n(s),Lp=i(s,"UL",{"data-svelte-h":!0}),o(Lp)!=="svelte-2bwbor"&&(Lp.innerHTML=Gf),hh=n(s),u(Dp.$$.fragment,s),Jh=n(s),u(Pp.$$.fragment,s),Uh=n(s),Op=i(s,"P",{"data-svelte-h":!0}),o(Op)!=="svelte-1uwonxy"&&(Op.innerHTML=Wf),wh=n(s),u(Kp.$$.fragment,s),dh=n(s),si=i(s,"P",{"data-svelte-h":!0}),o(si)!=="svelte-6et3o9"&&(si.textContent=Rf),mh=n(s),ti=i(s,"P",{"data-svelte-h":!0}),o(ti)!=="svelte-zoxbhu"&&(ti.textContent=kf),fh=n(s),u(ei.$$.fragment,s),Ih=n(s),li=i(s,"P",{"data-svelte-h":!0}),o(li)!=="svelte-ivzk1k"&&(li.innerHTML=Nf),Ch=n(s),u(ai.$$.fragment,s),bh=n(s),ni=i(s,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-ee4ukj"&&(ni.textContent=Xf),Ah=n(s),pi=i(s,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-7t5s0l"&&(pi.textContent=Qf),gh=n(s),ii=i(s,"P",{"data-svelte-h":!0}),o(ii)!=="svelte-1dvgk5f"&&(ii.innerHTML=Ef),vh=n(s),u(oi.$$.fragment,s),_h=n(s),Mi=i(s,"UL",{"data-svelte-h":!0}),o(Mi)!=="svelte-1sxibtc"&&(Mi.innerHTML=Hf),Bh=n(s),u(ui.$$.fragment,s),Zh=n(s),ci=i(s,"P",{"data-svelte-h":!0}),o(ci)!=="svelte-1gl7myx"&&(ci.innerHTML=Vf),qh=n(s),ri=i(s,"P",{"data-svelte-h":!0}),o(ri)!=="svelte-b7glaw"&&(ri.innerHTML=Yf),xh=n(s),yi=i(s,"P",{"data-svelte-h":!0}),o(yi)!=="svelte-1ano7ck"&&(yi.innerHTML=Ff),$h=n(s),ji=i(s,"P",{"data-svelte-h":!0}),o(ji)!=="svelte-1g6cule"&&(ji.innerHTML=Lf),Sh=n(s),Ti=i(s,"P",{"data-svelte-h":!0}),o(Ti)!=="svelte-1l1ss1c"&&(Ti.textContent=Df),zh=n(s),u(hi.$$.fragment,s),Gh=n(s),Ji=i(s,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-1svk6rj"&&(Ji.textContent=Pf),Wh=n(s),u(Ui.$$.fragment,s),Rh=n(s),wi=i(s,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-efhh0l"&&(wi.innerHTML=Of),kh=n(s),u(di.$$.fragment,s),Nh=n(s),_=i(s,"DIV",{class:!0});var W=U(_);u(mi.$$.fragment,W),IJ=n(W),go=i(W,"P",{"data-svelte-h":!0}),o(go)!=="svelte-g6t8ro"&&(go.textContent=Kf),CJ=n(W),vo=i(W,"P",{"data-svelte-h":!0}),o(vo)!=="svelte-xzx2jk"&&(vo.innerHTML=sI),bJ=n(W),_o=i(W,"P",{"data-svelte-h":!0}),o(_o)!=="svelte-12b9sbk"&&(_o.innerHTML=tI),W.forEach(e),Xh=n(s),u(fi.$$.fragment,s),Qh=n(s),Ii=i(s,"P",{"data-svelte-h":!0}),o(Ii)!=="svelte-g0utjs"&&(Ii.innerHTML=eI),Eh=n(s),Ci=i(s,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-1kok2zl"&&(Ci.textContent=lI),Hh=n(s),bi=i(s,"P",{"data-svelte-h":!0}),o(bi)!=="svelte-2awh2l"&&(bi.textContent=aI),Vh=n(s),Ai=i(s,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-o4r1i6"&&(Ai.textContent=nI),Yh=n(s),gi=i(s,"OL",{"data-svelte-h":!0}),o(gi)!=="svelte-1kuo9hl"&&(gi.innerHTML=pI),Fh=n(s),u(vi.$$.fragment,s),Lh=n(s),_i=i(s,"P",{"data-svelte-h":!0}),o(_i)!=="svelte-1boyjju"&&(_i.innerHTML=iI),Dh=n(s),u(Bi.$$.fragment,s),Ph=n(s),Zi=i(s,"P",{"data-svelte-h":!0}),o(Zi)!=="svelte-1ezcpn"&&(Zi.textContent=oI),Oh=n(s),u(qi.$$.fragment,s),Kh=n(s),xi=i(s,"P",{"data-svelte-h":!0}),o(xi)!=="svelte-1blwf7x"&&(xi.innerHTML=MI),sJ=n(s),$i=i(s,"P",{"data-svelte-h":!0}),o($i)!=="svelte-h0s2m6"&&($i.innerHTML=uI),tJ=n(s),u(Si.$$.fragment,s),eJ=n(s),zi=i(s,"P",{"data-svelte-h":!0}),o(zi)!=="svelte-14hjhxw"&&(zi.textContent=cI),lJ=n(s),Gi=i(s,"P",{"data-svelte-h":!0}),o(Gi)!=="svelte-59lrmj"&&(Gi.textContent=rI),aJ=n(s),u(Wi.$$.fragment,s),nJ=n(s),Ri=i(s,"P",{"data-svelte-h":!0}),o(Ri)!=="svelte-xyk76s"&&(Ri.textContent=yI),pJ=n(s),u(ki.$$.fragment,s),iJ=n(s),u(Ni.$$.fragment,s),oJ=n(s),Xi=i(s,"UL",{"data-svelte-h":!0}),o(Xi)!=="svelte-qibs9v"&&(Xi.innerHTML=jI),MJ=n(s),Qi=i(s,"P",{"data-svelte-h":!0}),o(Qi)!=="svelte-1pnpyer"&&(Qi.textContent=TI),uJ=n(s),Ei=i(s,"UL",{"data-svelte-h":!0}),o(Ei)!=="svelte-teaul9"&&(Ei.innerHTML=hI),cJ=n(s),Hi=i(s,"P",{"data-svelte-h":!0}),o(Hi)!=="svelte-17192d4"&&(Hi.innerHTML=JI),rJ=n(s),Zo=i(s,"P",{}),U(Zo).forEach(e),this.h()},h(){w(J,"name","hf:doc:metadata"),w(J,"content",vI),w(Vi,"id","deepspeed-trainer-integration"),w(Yi,"id","deepspeed-installation"),w(Fi,"id","deepspeed-multi-gpu"),w(Li,"id","deepspeed-one-gpu"),w(Ki,"id","deepspeed-multi-node"),w(so,"id","deepspeed-notebook"),w(to,"id","deepspeed-config"),w(eo,"id","deepspeed-config-passing"),w(lo,"id","deepspeed-config-shared"),w(ao,"id","deepspeed-zero"),w(no,"id","deepspeed-zero2-config"),w(po,"id","deepspeed-zero3-config"),w(io,"id","deepspeed-nvme"),w(oo,"id","deepspeed-zero2-zero3-performance"),w(Mo,"id","deepspeed-zero2-example"),w(uo,"id","deepspeed-zero3-example"),w(co,"id","deepspeed-optimizer"),w(ro,"id","deepspeed-scheduler"),w(yo,"id","deepspeed-fp32"),w(jo,"id","deepspeed-amp"),w(To,"id","deepspeed-bs"),w(ho,"id","deepspeed-grad-acc"),w(Jo,"id","deepspeed-grad-clip"),w(Uo,"id","deepspeed-weight-extraction"),w(wo,"id","deepspeed-zero-inference"),w(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,t){d(document.head,J),l(s,g,t),l(s,m,t),l(s,I,t),c(B,s,t),l(s,Z,t),l(s,b,t),l(s,f,t),l(s,v,t),l(s,xo,t),l(s,R,t),l(s,$o,t),l(s,k,t),l(s,So,t),l(s,N,t),l(s,zo,t),l(s,X,t),l(s,Go,t),l(s,Q,t),l(s,Wo,t),l(s,E,t),l(s,Ro,t),l(s,H,t),l(s,ko,t),l(s,V,t),l(s,No,t),l(s,Y,t),l(s,Xo,t),l(s,F,t),l(s,Qo,t),l(s,L,t),l(s,Eo,t),l(s,Vi,t),l(s,Ho,t),c(D,s,t),l(s,Vo,t),l(s,Yi,t),l(s,Yo,t),c(P,s,t),l(s,Fo,t),l(s,O,t),l(s,Lo,t),c(K,s,t),l(s,Do,t),l(s,ss,t),l(s,Po,t),c(ts,s,t),l(s,Oo,t),l(s,es,t),l(s,Ko,t),l(s,ls,t),l(s,sM,t),l(s,as,t),l(s,tM,t),l(s,ns,t),l(s,eM,t),c(ps,s,t),l(s,lM,t),l(s,is,t),l(s,aM,t),l(s,os,t),l(s,nM,t),c(Ms,s,t),l(s,pM,t),l(s,us,t),l(s,iM,t),l(s,cs,t),l(s,oM,t),c(rs,s,t),l(s,MM,t),l(s,ys,t),l(s,uM,t),l(s,js,t),l(s,cM,t),l(s,Ts,t),l(s,rM,t),l(s,hs,t),l(s,yM,t),c(Js,s,t),l(s,jM,t),l(s,Us,t),l(s,TM,t),c(ws,s,t),l(s,hM,t),l(s,ds,t),l(s,JM,t),c(ms,s,t),l(s,UM,t),l(s,fs,t),l(s,wM,t),l(s,Is,t),l(s,dM,t),l(s,Cs,t),l(s,mM,t),l(s,Fi,t),l(s,fM,t),c(bs,s,t),l(s,IM,t),l(s,As,t),l(s,CM,t),l(s,gs,t),l(s,bM,t),c(vs,s,t),l(s,AM,t),l(s,_s,t),l(s,gM,t),c(Bs,s,t),l(s,vM,t),l(s,Zs,t),l(s,_M,t),l(s,qs,t),l(s,BM,t),l(s,xs,t),l(s,ZM,t),c($s,s,t),l(s,qM,t),l(s,Ss,t),l(s,xM,t),l(s,zs,t),l(s,$M,t),l(s,Li,t),l(s,SM,t),c(Gs,s,t),l(s,zM,t),l(s,Ws,t),l(s,GM,t),c(Rs,s,t),l(s,WM,t),l(s,ks,t),l(s,RM,t),l(s,Ns,t),l(s,kM,t),l(s,Xs,t),l(s,NM,t),l(s,Qs,t),l(s,XM,t),c(Es,s,t),l(s,QM,t),l(s,Hs,t),l(s,EM,t),l(s,Vs,t),l(s,HM,t),l(s,Ys,t),l(s,VM,t),l(s,Fs,t),l(s,YM,t),l(s,Di,t),d(Di,q),d(q,Pi),d(q,TJ),c(Ls,q,null),d(q,hJ),d(q,Oi),l(s,FM,t),l(s,Ki,t),l(s,LM,t),c(Ds,s,t),l(s,DM,t),l(s,Ps,t),l(s,PM,t),l(s,Os,t),l(s,OM,t),c(Ks,s,t),l(s,KM,t),l(s,st,t),l(s,su,t),c(tt,s,t),l(s,tu,t),l(s,et,t),l(s,eu,t),l(s,lt,t),l(s,lu,t),c(at,s,t),l(s,au,t),l(s,nt,t),l(s,nu,t),c(pt,s,t),l(s,pu,t),l(s,it,t),l(s,iu,t),c(ot,s,t),l(s,ou,t),l(s,Mt,t),l(s,Mu,t),l(s,ut,t),l(s,uu,t),c(ct,s,t),l(s,cu,t),l(s,rt,t),l(s,ru,t),c(yt,s,t),l(s,yu,t),l(s,jt,t),l(s,ju,t),c(Tt,s,t),l(s,Tu,t),l(s,ht,t),l(s,hu,t),c(Jt,s,t),l(s,Ju,t),l(s,Ut,t),l(s,Uu,t),c(wt,s,t),l(s,wu,t),l(s,dt,t),l(s,du,t),l(s,so,t),l(s,mu,t),c(mt,s,t),l(s,fu,t),l(s,ft,t),l(s,Iu,t),l(s,It,t),l(s,Cu,t),c(Ct,s,t),l(s,bu,t),l(s,bt,t),l(s,Au,t),l(s,At,t),l(s,gu,t),l(s,gt,t),l(s,vu,t),c(vt,s,t),l(s,_u,t),l(s,_t,t),l(s,Bu,t),c(Bt,s,t),l(s,Zu,t),l(s,Zt,t),l(s,qu,t),c(qt,s,t),l(s,xu,t),l(s,xt,t),l(s,$u,t),l(s,$t,t),l(s,Su,t),l(s,to,t),l(s,zu,t),c(St,s,t),l(s,Gu,t),l(s,zt,t),l(s,Wu,t),l(s,Gt,t),l(s,Ru,t),c(Wt,s,t),l(s,ku,t),l(s,Rt,t),l(s,Nu,t),c(kt,s,t),l(s,Xu,t),l(s,Nt,t),l(s,Qu,t),l(s,Xt,t),l(s,Eu,t),l(s,Qt,t),l(s,Hu,t),c(Et,s,t),l(s,Vu,t),l(s,Ht,t),l(s,Yu,t),l(s,eo,t),l(s,Fu,t),c(Vt,s,t),l(s,Lu,t),l(s,Yt,t),l(s,Du,t),l(s,Ft,t),l(s,Pu,t),c(Lt,s,t),l(s,Ou,t),l(s,Dt,t),l(s,Ku,t),c(Pt,s,t),l(s,sc,t),l(s,lo,t),l(s,tc,t),c(Ot,s,t),l(s,ec,t),c(S,s,t),l(s,lc,t),l(s,Kt,t),l(s,ac,t),l(s,se,t),l(s,nc,t),l(s,te,t),l(s,pc,t),l(s,ee,t),l(s,ic,t),l(s,le,t),l(s,oc,t),l(s,ae,t),l(s,Mc,t),l(s,ne,t),l(s,uc,t),l(s,ao,t),l(s,cc,t),c(pe,s,t),l(s,rc,t),l(s,ie,t),l(s,yc,t),l(s,oe,t),l(s,jc,t),l(s,Me,t),l(s,Tc,t),l(s,ue,t),l(s,hc,t),l(s,no,t),l(s,Jc,t),c(ce,s,t),l(s,Uc,t),l(s,re,t),l(s,wc,t),c(ye,s,t),l(s,dc,t),l(s,je,t),l(s,mc,t),l(s,Te,t),l(s,fc,t),l(s,he,t),l(s,Ic,t),c(Je,s,t),l(s,Cc,t),l(s,Ue,t),l(s,bc,t),l(s,po,t),l(s,Ac,t),c(we,s,t),l(s,gc,t),l(s,de,t),l(s,vc,t),c(me,s,t),l(s,_c,t),l(s,fe,t),l(s,Bc,t),l(s,Ie,t),l(s,Zc,t),l(s,Ce,t),l(s,qc,t),l(s,be,t),l(s,xc,t),l(s,Ae,t),l(s,$c,t),l(s,ge,t),l(s,Sc,t),l(s,ve,t),l(s,zc,t),l(s,_e,t),l(s,Gc,t),l(s,Be,t),l(s,Wc,t),l(s,Ze,t),l(s,Rc,t),l(s,qe,t),l(s,kc,t),l(s,xe,t),l(s,Nc,t),l(s,$e,t),l(s,Xc,t),l(s,Se,t),l(s,Qc,t),l(s,ze,t),l(s,Ec,t),c(Ge,s,t),l(s,Hc,t),l(s,We,t),l(s,Vc,t),l(s,Re,t),l(s,Yc,t),c(ke,s,t),l(s,Fc,t),l(s,Ne,t),l(s,Lc,t),c(Xe,s,t),l(s,Dc,t),l(s,Qe,t),l(s,Pc,t),c(Ee,s,t),l(s,Oc,t),l(s,io,t),l(s,Kc,t),c(He,s,t),l(s,sr,t),l(s,Ve,t),l(s,tr,t),l(s,Ye,t),l(s,er,t),c(Fe,s,t),l(s,lr,t),l(s,Le,t),l(s,ar,t),l(s,De,t),l(s,nr,t),l(s,Pe,t),l(s,pr,t),l(s,Oe,t),l(s,ir,t),l(s,oo,t),l(s,or,t),c(Ke,s,t),l(s,Mr,t),l(s,sl,t),l(s,ur,t),l(s,tl,t),l(s,cr,t),l(s,el,t),l(s,rr,t),l(s,ll,t),l(s,yr,t),l(s,Mo,t),l(s,jr,t),c(al,s,t),l(s,Tr,t),l(s,nl,t),l(s,hr,t),c(pl,s,t),l(s,Jr,t),l(s,il,t),l(s,Ur,t),c(ol,s,t),l(s,wr,t),l(s,uo,t),l(s,dr,t),c(Ml,s,t),l(s,mr,t),l(s,ul,t),l(s,fr,t),c(cl,s,t),l(s,Ir,t),l(s,rl,t),l(s,Cr,t),c(yl,s,t),l(s,br,t),c(jl,s,t),l(s,Ar,t),l(s,Tl,t),l(s,gr,t),l(s,hl,t),l(s,vr,t),l(s,Jl,t),l(s,_r,t),l(s,Ul,t),l(s,Br,t),l(s,wl,t),l(s,Zr,t),l(s,dl,t),l(s,qr,t),l(s,ml,t),l(s,xr,t),l(s,fl,t),l(s,$r,t),l(s,Il,t),l(s,Sr,t),l(s,Cl,t),l(s,zr,t),l(s,bl,t),l(s,Gr,t),l(s,Al,t),l(s,Wr,t),l(s,gl,t),l(s,Rr,t),l(s,vl,t),l(s,kr,t),l(s,_l,t),l(s,Nr,t),l(s,Bl,t),l(s,Xr,t),l(s,Zl,t),l(s,Qr,t),c(ql,s,t),l(s,Er,t),l(s,xl,t),l(s,Hr,t),l(s,$l,t),l(s,Vr,t),l(s,Sl,t),l(s,Yr,t),l(s,zl,t),l(s,Fr,t),l(s,Gl,t),l(s,Lr,t),c(Wl,s,t),l(s,Dr,t),l(s,Rl,t),l(s,Pr,t),l(s,kl,t),l(s,Or,t),l(s,Nl,t),l(s,Kr,t),l(s,co,t),l(s,sy,t),c(Xl,s,t),l(s,ty,t),l(s,Ql,t),l(s,ey,t),l(s,El,t),l(s,ly,t),l(s,Hl,t),l(s,ay,t),c(Vl,s,t),l(s,ny,t),l(s,Yl,t),l(s,py,t),l(s,Fl,t),l(s,iy,t),l(s,Ll,t),l(s,oy,t),l(s,Dl,t),l(s,My,t),c(Pl,s,t),l(s,uy,t),l(s,Ol,t),l(s,cy,t),l(s,Kl,t),l(s,ry,t),c(sa,s,t),l(s,yy,t),l(s,ta,t),l(s,jy,t),l(s,ea,t),l(s,Ty,t),c(la,s,t),l(s,hy,t),l(s,aa,t),l(s,Jy,t),l(s,ro,t),l(s,Uy,t),c(na,s,t),l(s,wy,t),l(s,pa,t),l(s,dy,t),l(s,ia,t),l(s,my,t),l(s,oa,t),l(s,fy,t),l(s,Ma,t),l(s,Iy,t),l(s,ua,t),l(s,Cy,t),c(ca,s,t),l(s,by,t),l(s,ra,t),l(s,Ay,t),l(s,ya,t),l(s,gy,t),l(s,ja,t),l(s,vy,t),c(Ta,s,t),l(s,_y,t),l(s,ha,t),l(s,By,t),l(s,Ja,t),l(s,Zy,t),c(Ua,s,t),l(s,qy,t),l(s,wa,t),l(s,xy,t),l(s,yo,t),l(s,$y,t),c(da,s,t),l(s,Sy,t),l(s,ma,t),l(s,zy,t),l(s,fa,t),l(s,Gy,t),c(Ia,s,t),l(s,Wy,t),l(s,Ca,t),l(s,Ry,t),l(s,ba,t),l(s,ky,t),l(s,jo,t),l(s,Ny,t),c(Aa,s,t),l(s,Xy,t),l(s,ga,t),l(s,Qy,t),c(va,s,t),l(s,Ey,t),l(s,_a,t),l(s,Hy,t),c(Ba,s,t),l(s,Vy,t),l(s,Za,t),l(s,Yy,t),l(s,qa,t),l(s,Fy,t),l(s,xa,t),l(s,Ly,t),c($a,s,t),l(s,Dy,t),l(s,Sa,t),l(s,Py,t),l(s,za,t),l(s,Oy,t),c(Ga,s,t),l(s,Ky,t),l(s,Wa,t),l(s,sj,t),c(Ra,s,t),l(s,tj,t),l(s,ka,t),l(s,ej,t),l(s,Na,t),l(s,lj,t),l(s,Xa,t),l(s,aj,t),c(Qa,s,t),l(s,nj,t),c(z,s,t),l(s,pj,t),c(Ea,s,t),l(s,ij,t),l(s,Ha,t),l(s,oj,t),l(s,Va,t),l(s,Mj,t),l(s,Ya,t),l(s,uj,t),l(s,Fa,t),l(s,cj,t),c(La,s,t),l(s,rj,t),l(s,Da,t),l(s,yj,t),l(s,Pa,t),l(s,jj,t),c(Oa,s,t),l(s,Tj,t),l(s,Ka,t),l(s,hj,t),c(sn,s,t),l(s,Jj,t),l(s,tn,t),l(s,Uj,t),l(s,en,t),l(s,wj,t),l(s,ln,t),l(s,dj,t),c(an,s,t),l(s,mj,t),l(s,nn,t),l(s,fj,t),l(s,pn,t),l(s,Ij,t),l(s,To,t),l(s,Cj,t),c(on,s,t),l(s,bj,t),l(s,Mn,t),l(s,Aj,t),c(un,s,t),l(s,gj,t),l(s,cn,t),l(s,vj,t),l(s,rn,t),l(s,_j,t),c(yn,s,t),l(s,Bj,t),l(s,jn,t),l(s,Zj,t),l(s,ho,t),l(s,qj,t),c(Tn,s,t),l(s,xj,t),l(s,hn,t),l(s,$j,t),c(Jn,s,t),l(s,Sj,t),l(s,Un,t),l(s,zj,t),l(s,wn,t),l(s,Gj,t),c(dn,s,t),l(s,Wj,t),l(s,mn,t),l(s,Rj,t),l(s,Jo,t),l(s,kj,t),c(fn,s,t),l(s,Nj,t),l(s,In,t),l(s,Xj,t),c(Cn,s,t),l(s,Qj,t),l(s,bn,t),l(s,Ej,t),l(s,An,t),l(s,Hj,t),c(gn,s,t),l(s,Vj,t),l(s,vn,t),l(s,Yj,t),l(s,Uo,t),l(s,Fj,t),c(_n,s,t),l(s,Lj,t),l(s,Bn,t),l(s,Dj,t),l(s,Zn,t),l(s,Pj,t),l(s,qn,t),l(s,Oj,t),l(s,xn,t),l(s,Kj,t),c($n,s,t),l(s,sT,t),l(s,Sn,t),l(s,tT,t),l(s,zn,t),l(s,eT,t),l(s,Gn,t),l(s,lT,t),l(s,Wn,t),l(s,aT,t),l(s,Rn,t),l(s,nT,t),c(kn,s,t),l(s,pT,t),l(s,Nn,t),l(s,iT,t),c(Xn,s,t),l(s,oT,t),c(G,s,t),l(s,MT,t),l(s,Qn,t),l(s,uT,t),l(s,En,t),l(s,cT,t),c(Hn,s,t),l(s,rT,t),l(s,Vn,t),l(s,yT,t),l(s,Yn,t),l(s,jT,t),l(s,Fn,t),l(s,TT,t),c(Ln,s,t),l(s,hT,t),l(s,Dn,t),l(s,JT,t),c(Pn,s,t),l(s,UT,t),l(s,On,t),l(s,wT,t),l(s,Kn,t),l(s,dT,t),l(s,sp,t),l(s,mT,t),l(s,tp,t),l(s,fT,t),l(s,ep,t),l(s,IT,t),c(lp,s,t),l(s,CT,t),l(s,ap,t),l(s,bT,t),l(s,np,t),l(s,AT,t),l(s,pp,t),l(s,gT,t),c(ip,s,t),l(s,vT,t),l(s,op,t),l(s,_T,t),c(Mp,s,t),l(s,BT,t),l(s,up,t),l(s,ZT,t),l(s,cp,t),l(s,qT,t),c(rp,s,t),l(s,xT,t),l(s,yp,t),l(s,$T,t),l(s,jp,t),l(s,ST,t),l(s,Tp,t),l(s,zT,t),l(s,hp,t),l(s,GT,t),c(Jp,s,t),l(s,WT,t),l(s,Up,t),l(s,RT,t),l(s,wp,t),l(s,kT,t),l(s,dp,t),l(s,NT,t),c(mp,s,t),l(s,XT,t),l(s,fp,t),l(s,QT,t),l(s,wo,t),l(s,ET,t),c(Ip,s,t),l(s,HT,t),l(s,Cp,t),l(s,VT,t),l(s,bp,t),l(s,YT,t),c(Ap,s,t),l(s,FT,t),l(s,gp,t),l(s,LT,t),l(s,vp,t),l(s,DT,t),c(_p,s,t),l(s,PT,t),l(s,Bp,t),l(s,OT,t),l(s,Zp,t),l(s,KT,t),c(qp,s,t),l(s,sh,t),l(s,xp,t),l(s,th,t),l(s,$p,t),l(s,eh,t),c(Sp,s,t),l(s,lh,t),l(s,zp,t),l(s,ah,t),l(s,Gp,t),l(s,nh,t),l(s,Wp,t),l(s,ph,t),l(s,Rp,t),l(s,ih,t),c(kp,s,t),l(s,oh,t),l(s,Np,t),l(s,Mh,t),l(s,Xp,t),l(s,uh,t),c(Qp,s,t),l(s,ch,t),l(s,Ep,t),l(s,rh,t),l(s,Hp,t),l(s,yh,t),l(s,C,t),d(C,mo),d(C,JJ),d(C,fo),d(C,UJ),d(C,Vp),d(Vp,Io),d(Vp,wJ),c(Yp,Vp,null),d(C,dJ),d(C,Co),d(C,mJ),d(C,bo),d(C,fJ),d(C,Ao),l(s,jh,t),l(s,Fp,t),l(s,Th,t),l(s,Lp,t),l(s,hh,t),c(Dp,s,t),l(s,Jh,t),c(Pp,s,t),l(s,Uh,t),l(s,Op,t),l(s,wh,t),c(Kp,s,t),l(s,dh,t),l(s,si,t),l(s,mh,t),l(s,ti,t),l(s,fh,t),c(ei,s,t),l(s,Ih,t),l(s,li,t),l(s,Ch,t),c(ai,s,t),l(s,bh,t),l(s,ni,t),l(s,Ah,t),l(s,pi,t),l(s,gh,t),l(s,ii,t),l(s,vh,t),c(oi,s,t),l(s,_h,t),l(s,Mi,t),l(s,Bh,t),c(ui,s,t),l(s,Zh,t),l(s,ci,t),l(s,qh,t),l(s,ri,t),l(s,xh,t),l(s,yi,t),l(s,$h,t),l(s,ji,t),l(s,Sh,t),l(s,Ti,t),l(s,zh,t),c(hi,s,t),l(s,Gh,t),l(s,Ji,t),l(s,Wh,t),c(Ui,s,t),l(s,Rh,t),l(s,wi,t),l(s,kh,t),c(di,s,t),l(s,Nh,t),l(s,_,t),c(mi,_,null),d(_,IJ),d(_,go),d(_,CJ),d(_,vo),d(_,bJ),d(_,_o),l(s,Xh,t),c(fi,s,t),l(s,Qh,t),l(s,Ii,t),l(s,Eh,t),l(s,Ci,t),l(s,Hh,t),l(s,bi,t),l(s,Vh,t),l(s,Ai,t),l(s,Yh,t),l(s,gi,t),l(s,Fh,t),c(vi,s,t),l(s,Lh,t),l(s,_i,t),l(s,Dh,t),c(Bi,s,t),l(s,Ph,t),l(s,Zi,t),l(s,Oh,t),c(qi,s,t),l(s,Kh,t),l(s,xi,t),l(s,sJ,t),l(s,$i,t),l(s,tJ,t),c(Si,s,t),l(s,eJ,t),l(s,zi,t),l(s,lJ,t),l(s,Gi,t),l(s,aJ,t),c(Wi,s,t),l(s,nJ,t),l(s,Ri,t),l(s,pJ,t),c(ki,s,t),l(s,iJ,t),c(Ni,s,t),l(s,oJ,t),l(s,Xi,t),l(s,MJ,t),l(s,Qi,t),l(s,uJ,t),l(s,Ei,t),l(s,cJ,t),l(s,Hi,t),l(s,rJ,t),l(s,Zo,t),yJ=!0},p(s,[t]){const qo={};t&2&&(qo.$$scope={dirty:t,ctx:s}),S.$set(qo);const x={};t&2&&(x.$$scope={dirty:t,ctx:s}),z.$set(x);const A={};t&2&&(A.$$scope={dirty:t,ctx:s}),G.$set(A)},i(s){yJ||(r(B.$$.fragment,s),r(D.$$.fragment,s),r(P.$$.fragment,s),r(K.$$.fragment,s),r(ts.$$.fragment,s),r(ps.$$.fragment,s),r(Ms.$$.fragment,s),r(rs.$$.fragment,s),r(Js.$$.fragment,s),r(ws.$$.fragment,s),r(ms.$$.fragment,s),r(bs.$$.fragment,s),r(vs.$$.fragment,s),r(Bs.$$.fragment,s),r($s.$$.fragment,s),r(Gs.$$.fragment,s),r(Rs.$$.fragment,s),r(Es.$$.fragment,s),r(Ls.$$.fragment,s),r(Ds.$$.fragment,s),r(Ks.$$.fragment,s),r(tt.$$.fragment,s),r(at.$$.fragment,s),r(pt.$$.fragment,s),r(ot.$$.fragment,s),r(ct.$$.fragment,s),r(yt.$$.fragment,s),r(Tt.$$.fragment,s),r(Jt.$$.fragment,s),r(wt.$$.fragment,s),r(mt.$$.fragment,s),r(Ct.$$.fragment,s),r(vt.$$.fragment,s),r(Bt.$$.fragment,s),r(qt.$$.fragment,s),r(St.$$.fragment,s),r(Wt.$$.fragment,s),r(kt.$$.fragment,s),r(Et.$$.fragment,s),r(Vt.$$.fragment,s),r(Lt.$$.fragment,s),r(Pt.$$.fragment,s),r(Ot.$$.fragment,s),r(S.$$.fragment,s),r(pe.$$.fragment,s),r(ce.$$.fragment,s),r(ye.$$.fragment,s),r(Je.$$.fragment,s),r(we.$$.fragment,s),r(me.$$.fragment,s),r(Ge.$$.fragment,s),r(ke.$$.fragment,s),r(Xe.$$.fragment,s),r(Ee.$$.fragment,s),r(He.$$.fragment,s),r(Fe.$$.fragment,s),r(Ke.$$.fragment,s),r(al.$$.fragment,s),r(pl.$$.fragment,s),r(ol.$$.fragment,s),r(Ml.$$.fragment,s),r(cl.$$.fragment,s),r(yl.$$.fragment,s),r(jl.$$.fragment,s),r(ql.$$.fragment,s),r(Wl.$$.fragment,s),r(Xl.$$.fragment,s),r(Vl.$$.fragment,s),r(Pl.$$.fragment,s),r(sa.$$.fragment,s),r(la.$$.fragment,s),r(na.$$.fragment,s),r(ca.$$.fragment,s),r(Ta.$$.fragment,s),r(Ua.$$.fragment,s),r(da.$$.fragment,s),r(Ia.$$.fragment,s),r(Aa.$$.fragment,s),r(va.$$.fragment,s),r(Ba.$$.fragment,s),r($a.$$.fragment,s),r(Ga.$$.fragment,s),r(Ra.$$.fragment,s),r(Qa.$$.fragment,s),r(z.$$.fragment,s),r(Ea.$$.fragment,s),r(La.$$.fragment,s),r(Oa.$$.fragment,s),r(sn.$$.fragment,s),r(an.$$.fragment,s),r(on.$$.fragment,s),r(un.$$.fragment,s),r(yn.$$.fragment,s),r(Tn.$$.fragment,s),r(Jn.$$.fragment,s),r(dn.$$.fragment,s),r(fn.$$.fragment,s),r(Cn.$$.fragment,s),r(gn.$$.fragment,s),r(_n.$$.fragment,s),r($n.$$.fragment,s),r(kn.$$.fragment,s),r(Xn.$$.fragment,s),r(G.$$.fragment,s),r(Hn.$$.fragment,s),r(Ln.$$.fragment,s),r(Pn.$$.fragment,s),r(lp.$$.fragment,s),r(ip.$$.fragment,s),r(Mp.$$.fragment,s),r(rp.$$.fragment,s),r(Jp.$$.fragment,s),r(mp.$$.fragment,s),r(Ip.$$.fragment,s),r(Ap.$$.fragment,s),r(_p.$$.fragment,s),r(qp.$$.fragment,s),r(Sp.$$.fragment,s),r(kp.$$.fragment,s),r(Qp.$$.fragment,s),r(Yp.$$.fragment,s),r(Dp.$$.fragment,s),r(Pp.$$.fragment,s),r(Kp.$$.fragment,s),r(ei.$$.fragment,s),r(ai.$$.fragment,s),r(oi.$$.fragment,s),r(ui.$$.fragment,s),r(hi.$$.fragment,s),r(Ui.$$.fragment,s),r(di.$$.fragment,s),r(mi.$$.fragment,s),r(fi.$$.fragment,s),r(vi.$$.fragment,s),r(Bi.$$.fragment,s),r(qi.$$.fragment,s),r(Si.$$.fragment,s),r(Wi.$$.fragment,s),r(ki.$$.fragment,s),r(Ni.$$.fragment,s),yJ=!0)},o(s){y(B.$$.fragment,s),y(D.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(Ms.$$.fragment,s),y(rs.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(ms.$$.fragment,s),y(bs.$$.fragment,s),y(vs.$$.fragment,s),y(Bs.$$.fragment,s),y($s.$$.fragment,s),y(Gs.$$.fragment,s),y(Rs.$$.fragment,s),y(Es.$$.fragment,s),y(Ls.$$.fragment,s),y(Ds.$$.fragment,s),y(Ks.$$.fragment,s),y(tt.$$.fragment,s),y(at.$$.fragment,s),y(pt.$$.fragment,s),y(ot.$$.fragment,s),y(ct.$$.fragment,s),y(yt.$$.fragment,s),y(Tt.$$.fragment,s),y(Jt.$$.fragment,s),y(wt.$$.fragment,s),y(mt.$$.fragment,s),y(Ct.$$.fragment,s),y(vt.$$.fragment,s),y(Bt.$$.fragment,s),y(qt.$$.fragment,s),y(St.$$.fragment,s),y(Wt.$$.fragment,s),y(kt.$$.fragment,s),y(Et.$$.fragment,s),y(Vt.$$.fragment,s),y(Lt.$$.fragment,s),y(Pt.$$.fragment,s),y(Ot.$$.fragment,s),y(S.$$.fragment,s),y(pe.$$.fragment,s),y(ce.$$.fragment,s),y(ye.$$.fragment,s),y(Je.$$.fragment,s),y(we.$$.fragment,s),y(me.$$.fragment,s),y(Ge.$$.fragment,s),y(ke.$$.fragment,s),y(Xe.$$.fragment,s),y(Ee.$$.fragment,s),y(He.$$.fragment,s),y(Fe.$$.fragment,s),y(Ke.$$.fragment,s),y(al.$$.fragment,s),y(pl.$$.fragment,s),y(ol.$$.fragment,s),y(Ml.$$.fragment,s),y(cl.$$.fragment,s),y(yl.$$.fragment,s),y(jl.$$.fragment,s),y(ql.$$.fragment,s),y(Wl.$$.fragment,s),y(Xl.$$.fragment,s),y(Vl.$$.fragment,s),y(Pl.$$.fragment,s),y(sa.$$.fragment,s),y(la.$$.fragment,s),y(na.$$.fragment,s),y(ca.$$.fragment,s),y(Ta.$$.fragment,s),y(Ua.$$.fragment,s),y(da.$$.fragment,s),y(Ia.$$.fragment,s),y(Aa.$$.fragment,s),y(va.$$.fragment,s),y(Ba.$$.fragment,s),y($a.$$.fragment,s),y(Ga.$$.fragment,s),y(Ra.$$.fragment,s),y(Qa.$$.fragment,s),y(z.$$.fragment,s),y(Ea.$$.fragment,s),y(La.$$.fragment,s),y(Oa.$$.fragment,s),y(sn.$$.fragment,s),y(an.$$.fragment,s),y(on.$$.fragment,s),y(un.$$.fragment,s),y(yn.$$.fragment,s),y(Tn.$$.fragment,s),y(Jn.$$.fragment,s),y(dn.$$.fragment,s),y(fn.$$.fragment,s),y(Cn.$$.fragment,s),y(gn.$$.fragment,s),y(_n.$$.fragment,s),y($n.$$.fragment,s),y(kn.$$.fragment,s),y(Xn.$$.fragment,s),y(G.$$.fragment,s),y(Hn.$$.fragment,s),y(Ln.$$.fragment,s),y(Pn.$$.fragment,s),y(lp.$$.fragment,s),y(ip.$$.fragment,s),y(Mp.$$.fragment,s),y(rp.$$.fragment,s),y(Jp.$$.fragment,s),y(mp.$$.fragment,s),y(Ip.$$.fragment,s),y(Ap.$$.fragment,s),y(_p.$$.fragment,s),y(qp.$$.fragment,s),y(Sp.$$.fragment,s),y(kp.$$.fragment,s),y(Qp.$$.fragment,s),y(Yp.$$.fragment,s),y(Dp.$$.fragment,s),y(Pp.$$.fragment,s),y(Kp.$$.fragment,s),y(ei.$$.fragment,s),y(ai.$$.fragment,s),y(oi.$$.fragment,s),y(ui.$$.fragment,s),y(hi.$$.fragment,s),y(Ui.$$.fragment,s),y(di.$$.fragment,s),y(mi.$$.fragment,s),y(fi.$$.fragment,s),y(vi.$$.fragment,s),y(Bi.$$.fragment,s),y(qi.$$.fragment,s),y(Si.$$.fragment,s),y(Wi.$$.fragment,s),y(ki.$$.fragment,s),y(Ni.$$.fragment,s),yJ=!1},d(s){s&&(e(g),e(m),e(I),e(Z),e(b),e(f),e(v),e(xo),e(R),e($o),e(k),e(So),e(N),e(zo),e(X),e(Go),e(Q),e(Wo),e(E),e(Ro),e(H),e(ko),e(V),e(No),e(Y),e(Xo),e(F),e(Qo),e(L),e(Eo),e(Vi),e(Ho),e(Vo),e(Yi),e(Yo),e(Fo),e(O),e(Lo),e(Do),e(ss),e(Po),e(Oo),e(es),e(Ko),e(ls),e(sM),e(as),e(tM),e(ns),e(eM),e(lM),e(is),e(aM),e(os),e(nM),e(pM),e(us),e(iM),e(cs),e(oM),e(MM),e(ys),e(uM),e(js),e(cM),e(Ts),e(rM),e(hs),e(yM),e(jM),e(Us),e(TM),e(hM),e(ds),e(JM),e(UM),e(fs),e(wM),e(Is),e(dM),e(Cs),e(mM),e(Fi),e(fM),e(IM),e(As),e(CM),e(gs),e(bM),e(AM),e(_s),e(gM),e(vM),e(Zs),e(_M),e(qs),e(BM),e(xs),e(ZM),e(qM),e(Ss),e(xM),e(zs),e($M),e(Li),e(SM),e(zM),e(Ws),e(GM),e(WM),e(ks),e(RM),e(Ns),e(kM),e(Xs),e(NM),e(Qs),e(XM),e(QM),e(Hs),e(EM),e(Vs),e(HM),e(Ys),e(VM),e(Fs),e(YM),e(Di),e(FM),e(Ki),e(LM),e(DM),e(Ps),e(PM),e(Os),e(OM),e(KM),e(st),e(su),e(tu),e(et),e(eu),e(lt),e(lu),e(au),e(nt),e(nu),e(pu),e(it),e(iu),e(ou),e(Mt),e(Mu),e(ut),e(uu),e(cu),e(rt),e(ru),e(yu),e(jt),e(ju),e(Tu),e(ht),e(hu),e(Ju),e(Ut),e(Uu),e(wu),e(dt),e(du),e(so),e(mu),e(fu),e(ft),e(Iu),e(It),e(Cu),e(bu),e(bt),e(Au),e(At),e(gu),e(gt),e(vu),e(_u),e(_t),e(Bu),e(Zu),e(Zt),e(qu),e(xu),e(xt),e($u),e($t),e(Su),e(to),e(zu),e(Gu),e(zt),e(Wu),e(Gt),e(Ru),e(ku),e(Rt),e(Nu),e(Xu),e(Nt),e(Qu),e(Xt),e(Eu),e(Qt),e(Hu),e(Vu),e(Ht),e(Yu),e(eo),e(Fu),e(Lu),e(Yt),e(Du),e(Ft),e(Pu),e(Ou),e(Dt),e(Ku),e(sc),e(lo),e(tc),e(ec),e(lc),e(Kt),e(ac),e(se),e(nc),e(te),e(pc),e(ee),e(ic),e(le),e(oc),e(ae),e(Mc),e(ne),e(uc),e(ao),e(cc),e(rc),e(ie),e(yc),e(oe),e(jc),e(Me),e(Tc),e(ue),e(hc),e(no),e(Jc),e(Uc),e(re),e(wc),e(dc),e(je),e(mc),e(Te),e(fc),e(he),e(Ic),e(Cc),e(Ue),e(bc),e(po),e(Ac),e(gc),e(de),e(vc),e(_c),e(fe),e(Bc),e(Ie),e(Zc),e(Ce),e(qc),e(be),e(xc),e(Ae),e($c),e(ge),e(Sc),e(ve),e(zc),e(_e),e(Gc),e(Be),e(Wc),e(Ze),e(Rc),e(qe),e(kc),e(xe),e(Nc),e($e),e(Xc),e(Se),e(Qc),e(ze),e(Ec),e(Hc),e(We),e(Vc),e(Re),e(Yc),e(Fc),e(Ne),e(Lc),e(Dc),e(Qe),e(Pc),e(Oc),e(io),e(Kc),e(sr),e(Ve),e(tr),e(Ye),e(er),e(lr),e(Le),e(ar),e(De),e(nr),e(Pe),e(pr),e(Oe),e(ir),e(oo),e(or),e(Mr),e(sl),e(ur),e(tl),e(cr),e(el),e(rr),e(ll),e(yr),e(Mo),e(jr),e(Tr),e(nl),e(hr),e(Jr),e(il),e(Ur),e(wr),e(uo),e(dr),e(mr),e(ul),e(fr),e(Ir),e(rl),e(Cr),e(br),e(Ar),e(Tl),e(gr),e(hl),e(vr),e(Jl),e(_r),e(Ul),e(Br),e(wl),e(Zr),e(dl),e(qr),e(ml),e(xr),e(fl),e($r),e(Il),e(Sr),e(Cl),e(zr),e(bl),e(Gr),e(Al),e(Wr),e(gl),e(Rr),e(vl),e(kr),e(_l),e(Nr),e(Bl),e(Xr),e(Zl),e(Qr),e(Er),e(xl),e(Hr),e($l),e(Vr),e(Sl),e(Yr),e(zl),e(Fr),e(Gl),e(Lr),e(Dr),e(Rl),e(Pr),e(kl),e(Or),e(Nl),e(Kr),e(co),e(sy),e(ty),e(Ql),e(ey),e(El),e(ly),e(Hl),e(ay),e(ny),e(Yl),e(py),e(Fl),e(iy),e(Ll),e(oy),e(Dl),e(My),e(uy),e(Ol),e(cy),e(Kl),e(ry),e(yy),e(ta),e(jy),e(ea),e(Ty),e(hy),e(aa),e(Jy),e(ro),e(Uy),e(wy),e(pa),e(dy),e(ia),e(my),e(oa),e(fy),e(Ma),e(Iy),e(ua),e(Cy),e(by),e(ra),e(Ay),e(ya),e(gy),e(ja),e(vy),e(_y),e(ha),e(By),e(Ja),e(Zy),e(qy),e(wa),e(xy),e(yo),e($y),e(Sy),e(ma),e(zy),e(fa),e(Gy),e(Wy),e(Ca),e(Ry),e(ba),e(ky),e(jo),e(Ny),e(Xy),e(ga),e(Qy),e(Ey),e(_a),e(Hy),e(Vy),e(Za),e(Yy),e(qa),e(Fy),e(xa),e(Ly),e(Dy),e(Sa),e(Py),e(za),e(Oy),e(Ky),e(Wa),e(sj),e(tj),e(ka),e(ej),e(Na),e(lj),e(Xa),e(aj),e(nj),e(pj),e(ij),e(Ha),e(oj),e(Va),e(Mj),e(Ya),e(uj),e(Fa),e(cj),e(rj),e(Da),e(yj),e(Pa),e(jj),e(Tj),e(Ka),e(hj),e(Jj),e(tn),e(Uj),e(en),e(wj),e(ln),e(dj),e(mj),e(nn),e(fj),e(pn),e(Ij),e(To),e(Cj),e(bj),e(Mn),e(Aj),e(gj),e(cn),e(vj),e(rn),e(_j),e(Bj),e(jn),e(Zj),e(ho),e(qj),e(xj),e(hn),e($j),e(Sj),e(Un),e(zj),e(wn),e(Gj),e(Wj),e(mn),e(Rj),e(Jo),e(kj),e(Nj),e(In),e(Xj),e(Qj),e(bn),e(Ej),e(An),e(Hj),e(Vj),e(vn),e(Yj),e(Uo),e(Fj),e(Lj),e(Bn),e(Dj),e(Zn),e(Pj),e(qn),e(Oj),e(xn),e(Kj),e(sT),e(Sn),e(tT),e(zn),e(eT),e(Gn),e(lT),e(Wn),e(aT),e(Rn),e(nT),e(pT),e(Nn),e(iT),e(oT),e(MT),e(Qn),e(uT),e(En),e(cT),e(rT),e(Vn),e(yT),e(Yn),e(jT),e(Fn),e(TT),e(hT),e(Dn),e(JT),e(UT),e(On),e(wT),e(Kn),e(dT),e(sp),e(mT),e(tp),e(fT),e(ep),e(IT),e(CT),e(ap),e(bT),e(np),e(AT),e(pp),e(gT),e(vT),e(op),e(_T),e(BT),e(up),e(ZT),e(cp),e(qT),e(xT),e(yp),e($T),e(jp),e(ST),e(Tp),e(zT),e(hp),e(GT),e(WT),e(Up),e(RT),e(wp),e(kT),e(dp),e(NT),e(XT),e(fp),e(QT),e(wo),e(ET),e(HT),e(Cp),e(VT),e(bp),e(YT),e(FT),e(gp),e(LT),e(vp),e(DT),e(PT),e(Bp),e(OT),e(Zp),e(KT),e(sh),e(xp),e(th),e($p),e(eh),e(lh),e(zp),e(ah),e(Gp),e(nh),e(Wp),e(ph),e(Rp),e(ih),e(oh),e(Np),e(Mh),e(Xp),e(uh),e(ch),e(Ep),e(rh),e(Hp),e(yh),e(C),e(jh),e(Fp),e(Th),e(Lp),e(hh),e(Jh),e(Uh),e(Op),e(wh),e(dh),e(si),e(mh),e(ti),e(fh),e(Ih),e(li),e(Ch),e(bh),e(ni),e(Ah),e(pi),e(gh),e(ii),e(vh),e(_h),e(Mi),e(Bh),e(Zh),e(ci),e(qh),e(ri),e(xh),e(yi),e($h),e(ji),e(Sh),e(Ti),e(zh),e(Gh),e(Ji),e(Wh),e(Rh),e(wi),e(kh),e(Nh),e(_),e(Xh),e(Qh),e(Ii),e(Eh),e(Ci),e(Hh),e(bi),e(Vh),e(Ai),e(Yh),e(gi),e(Fh),e(Lh),e(_i),e(Dh),e(Ph),e(Zi),e(Oh),e(Kh),e(xi),e(sJ),e($i),e(tJ),e(eJ),e(zi),e(lJ),e(Gi),e(aJ),e(nJ),e(Ri),e(pJ),e(iJ),e(oJ),e(Xi),e(MJ),e(Qi),e(uJ),e(Ei),e(cJ),e(Hi),e(rJ),e(Zo)),e(J),j(B,s),j(D,s),j(P,s),j(K,s),j(ts,s),j(ps,s),j(Ms,s),j(rs,s),j(Js,s),j(ws,s),j(ms,s),j(bs,s),j(vs,s),j(Bs,s),j($s,s),j(Gs,s),j(Rs,s),j(Es,s),j(Ls),j(Ds,s),j(Ks,s),j(tt,s),j(at,s),j(pt,s),j(ot,s),j(ct,s),j(yt,s),j(Tt,s),j(Jt,s),j(wt,s),j(mt,s),j(Ct,s),j(vt,s),j(Bt,s),j(qt,s),j(St,s),j(Wt,s),j(kt,s),j(Et,s),j(Vt,s),j(Lt,s),j(Pt,s),j(Ot,s),j(S,s),j(pe,s),j(ce,s),j(ye,s),j(Je,s),j(we,s),j(me,s),j(Ge,s),j(ke,s),j(Xe,s),j(Ee,s),j(He,s),j(Fe,s),j(Ke,s),j(al,s),j(pl,s),j(ol,s),j(Ml,s),j(cl,s),j(yl,s),j(jl,s),j(ql,s),j(Wl,s),j(Xl,s),j(Vl,s),j(Pl,s),j(sa,s),j(la,s),j(na,s),j(ca,s),j(Ta,s),j(Ua,s),j(da,s),j(Ia,s),j(Aa,s),j(va,s),j(Ba,s),j($a,s),j(Ga,s),j(Ra,s),j(Qa,s),j(z,s),j(Ea,s),j(La,s),j(Oa,s),j(sn,s),j(an,s),j(on,s),j(un,s),j(yn,s),j(Tn,s),j(Jn,s),j(dn,s),j(fn,s),j(Cn,s),j(gn,s),j(_n,s),j($n,s),j(kn,s),j(Xn,s),j(G,s),j(Hn,s),j(Ln,s),j(Pn,s),j(lp,s),j(ip,s),j(Mp,s),j(rp,s),j(Jp,s),j(mp,s),j(Ip,s),j(Ap,s),j(_p,s),j(qp,s),j(Sp,s),j(kp,s),j(Qp,s),j(Yp),j(Dp,s),j(Pp,s),j(Kp,s),j(ei,s),j(ai,s),j(oi,s),j(ui,s),j(hi,s),j(Ui,s),j(di,s),j(mi),j(fi,s),j(vi,s),j(Bi,s),j(qi,s),j(Si,s),j(Wi,s),j(ki,s),j(Ni,s)}}}const vI='{"title":"DeepSpeed Integration","local":"deepspeed-integration","sections":[{"title":"Trainer Deepspeed Integration","local":"trainer-deepspeed-integration","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Deployment with multiple GPUs","local":"deployment-with-multiple-gpus","sections":[],"depth":3},{"title":"Deployment with one GPU","local":"deployment-with-one-gpu","sections":[],"depth":3},{"title":"Deployment with multiple Nodes","local":"deployment-with-multiple-nodes","sections":[{"title":"The torch.distributed.run(torchrun) launcher","local":"the-torchdistributedruntorchrun-launcher","sections":[],"depth":4},{"title":"The deepspeed launcher","local":"the-deepspeed-launcher","sections":[],"depth":4},{"title":"Launching in a SLURM environment","local":"launching-in-a-slurm-environment","sections":[],"depth":4},{"title":"Use of Non-shared filesystem","local":"use-of-non-shared-filesystem","sections":[],"depth":4}],"depth":3},{"title":"Deployment in Notebooks","local":"deployment-in-notebooks","sections":[],"depth":3},{"title":"Configuration","local":"configuration","sections":[],"depth":3},{"title":"Passing Configuration","local":"passing-configuration","sections":[],"depth":3},{"title":"Shared Configuration","local":"shared-configuration","sections":[],"depth":3},{"title":"ZeRO","local":"zero","sections":[{"title":"ZeRO-2 Config","local":"zero-2-config","sections":[],"depth":4},{"title":"ZeRO-3 Config","local":"zero-3-config","sections":[],"depth":4},{"title":"ZeRO-0 Config","local":"zero-0-config","sections":[],"depth":4},{"title":"ZeRO-1 Config","local":"zero-1-config","sections":[],"depth":4}],"depth":3},{"title":"NVMe Support","local":"nvme-support","sections":[{"title":"ZeRO-2 vs ZeRO-3 Performance","local":"zero-2-vs-zero-3-performance","sections":[],"depth":4},{"title":"ZeRO-2 Example","local":"zero-2-example","sections":[],"depth":4},{"title":"ZeRO-3 Example","local":"zero-3-example","sections":[],"depth":4},{"title":"How to Choose Which ZeRO Stage and Offloads To Use For Best Performance","local":"how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance","sections":[],"depth":4}],"depth":3},{"title":"Activation Checkpointing or Gradient Checkpointing","local":"activation-checkpointing-or-gradient-checkpointing","sections":[],"depth":3},{"title":"Optimizer and Scheduler","local":"optimizer-and-scheduler","sections":[{"title":"Optimizer","local":"optimizer","sections":[],"depth":4},{"title":"Scheduler","local":"scheduler","sections":[],"depth":4}],"depth":3},{"title":"fp32 Precision","local":"fp32-precision","sections":[],"depth":3},{"title":"Automatic Mixed Precision","local":"automatic-mixed-precision","sections":[],"depth":3},{"title":"fp16","local":"fp16","sections":[],"depth":3},{"title":"bf16","local":"bf16","sections":[],"depth":3},{"title":"NCCL Collectives","local":"nccl-collectives","sections":[],"depth":3},{"title":"apex","local":"apex","sections":[],"depth":3},{"title":"Batch Size","local":"batch-size","sections":[],"depth":3},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient Clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Getting The Model Weights Out","local":"getting-the-model-weights-out","sections":[],"depth":3},{"title":"ZeRO-3 and Infinity Nuances","local":"zero-3-and-infinity-nuances","sections":[{"title":"Constructing Massive Models","local":"constructing-massive-models","sections":[],"depth":4},{"title":"Gathering Parameters","local":"gathering-parameters","sections":[],"depth":4}],"depth":3},{"title":"ZeRO Inference","local":"zero-inference","sections":[],"depth":3},{"title":"Memory Requirements","local":"memory-requirements","sections":[],"depth":3},{"title":"Filing Issues","local":"filing-issues","sections":[],"depth":3},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"the deepspeed process gets killed at startup without a traceback","local":"the-deepspeed-process-gets-killed-at-startup-without-a-traceback","sections":[],"depth":4},{"title":"training and/or eval/predict loss is NaN","local":"training-andor-evalpredict-loss-is-nan","sections":[],"depth":4}],"depth":3},{"title":"Notes","local":"notes","sections":[],"depth":3}],"depth":2},{"title":"Non-Trainer Deepspeed Integration","local":"non-trainer-deepspeed-integration","sections":[],"depth":2},{"title":"HfDeepSpeedConfig","local":"transformers.integrations.HfDeepSpeedConfig","sections":[{"title":"Custom DeepSpeed ZeRO Inference","local":"custom-deepspeed-zero-inference","sections":[],"depth":3},{"title":"generate nuances","local":"generate-nuances","sections":[],"depth":3}],"depth":2},{"title":"Testing Deepspeed Integration","local":"testing-deepspeed-integration","sections":[],"depth":2},{"title":"Main DeepSpeed Resources","local":"main-deepspeed-resources","sections":[],"depth":2}],"depth":1}';function _I($){return wI(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zI extends dI{constructor(J){super(),mI(this,J,_I,gI,UI,{})}}export{zI as component};
