import{s as Zt,o as Gt,n as Wt}from"../chunks/scheduler.c59d9fbb.js";import{S as Vt,i as Qt,g as c,s as a,r as p,A as vt,h as y,f as s,c as n,j as Rt,u as o,x as m,k as Xt,y as At,a as e,v as M,d as i,t as d,w as r}from"../chunks/index.a47918e3.js";import{T as Ft}from"../chunks/Tip.3fcf4aa4.js";import{C as J}from"../chunks/CodeBlock.936db8cd.js";import{D as $t}from"../chunks/DocNotebookDropdown.efd8a791.js";import{H as rl}from"../chunks/Heading.604bc707.js";function Nt(ml){let u,b='💡 Read <a href="https://arxiv.org/abs/2104.08691" rel="nofollow">The Power of Scale for Parameter-Efficient Prompt Tuning</a> to learn more about prompt tuning.';return{c(){u=c("p"),u.innerHTML=b},l(U){u=y(U,"P",{"data-svelte-h":!0}),m(u)!=="svelte-5rr20j"&&(u.innerHTML=b)},m(U,cl){e(U,u,cl)},p:Wt,d(U){U&&s(u)}}}function Yt(ml){let u,b,U,cl,h,ul,j,Jl,w,Mt="Prompting helps guide language model behavior by adding some input text specific to a task. Prompt tuning is an additive method for only training and updating the newly added prompt tokens to a pretrained model. This way, you can use one pretrained model whose weights are frozen, and train and update a smaller set of prompt parameters for each downstream task instead of fully finetuning a separate model. As models grow larger and larger, prompt tuning can be more efficient, and results are even better as model parameters scale.",Ul,T,Tl,f,it='This guide will show you how to apply prompt tuning to train a <a href="https://huggingface.co/bigscience/bloomz-560m" rel="nofollow"><code>bloomz-560m</code></a> model on the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset.',bl,C,dt="Before you begin, make sure you have all the necessary libraries installed:",hl,I,jl,_,wl,g,rt='Start by defining the model and tokenizer, the dataset and the dataset columns to train on, some training hyperparameters, and the <a href="/docs/peft/v0.6.2/en/package_reference/tuners#peft.PromptTuningConfig">PromptTuningConfig</a>. The <a href="/docs/peft/v0.6.2/en/package_reference/tuners#peft.PromptTuningConfig">PromptTuningConfig</a> contains information about the task type, the text to initialize the prompt embedding, the number of virtual tokens, and the tokenizer to use:',fl,B,Cl,k,Il,R,ct='For this guide, you’ll load the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset. This subset contains tweets that are labeled either <code>complaint</code> or <code>no complaint</code>:',_l,X,gl,Z,yt="To make the <code>Label</code> column more readable, replace the <code>Label</code> value with the corresponding label text and store them in a <code>text_label</code> column. You can use the <code>map</code> function to apply this change over the entire dataset in one step:",Bl,G,kl,W,Rl,V,mt="Next, you’ll setup a tokenizer; configure the appropriate padding token to use for padding sequences, and determine the maximum length of the tokenized labels:",Xl,Q,Zl,v,ut="Create a <code>preprocess_function</code> to:",Gl,A,Jt="<li>Tokenize the input text and labels.</li> <li>For each example in a batch, pad the labels with the tokenizers <code>pad_token_id</code>.</li> <li>Concatenate the input text and labels into the <code>model_inputs</code>.</li> <li>Create a separate attention mask for <code>labels</code> and <code>model_inputs</code>.</li> <li>Loop through each example in the batch again to pad the input ids, labels, and attention mask to the <code>max_length</code> and convert them to PyTorch tensors.</li>",Wl,F,Vl,$,Ut="Use the <code>map</code> function to apply the <code>preprocess_function</code> to the entire dataset. You can remove the unprocessed columns since the model won’t need them:",Ql,N,vl,Y,Tt='Create a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a> from the <code>train</code> and <code>eval</code> datasets. Set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Al,x,Fl,z,$l,H,bt="You’re almost ready to setup your model and start training!",Nl,E,ht='Initialize a base model from <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoModelForCausalLM" rel="nofollow">AutoModelForCausalLM</a>, and pass it and <code>peft_config</code> to the <code>get_peft_model()</code> function to create a <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. You can print the new <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>’s trainable parameters to see how much more efficient it is than training the full parameters of the original model!',Yl,S,xl,q,jt="Setup an optimizer and learning rate scheduler:",zl,L,Hl,P,wt="Move the model to the GPU, then write a training loop to start training!",El,K,Sl,D,ql,O,ft="You can store and share your model on the Hub if you’d like. Log in to your Hugging Face account and enter your token when prompted:",Ll,ll,Pl,tl,Ct='Use the <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> function to upload your model to a model repository on the Hub:',Kl,sl,Dl,el,It="Once the model is uploaded, you’ll see the model file size is only 33.5kB! 🤏",Ol,al,lt,nl,_t='Let’s try the model on a sample input for inference. If you look at the repository you uploaded the model to, you’ll see a <code>adapter_config.json</code> file. Load this file into <a href="/docs/peft/v0.6.2/en/package_reference/config#peft.PeftConfig">PeftConfig</a> to specify the <code>peft_type</code> and <code>task_type</code>. Then you can load the prompt tuned model weights, and the configuration into <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> to create the <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>:',tt,pl,st,ol,gt="Grab a tweet and tokenize it:",et,Ml,at,il,Bt="Put the model on a GPU and <em>generate</em> the predicted label:",nt,dl,pt,yl,ot;return h=new rl({props:{title:"Prompt tuning for causal language modeling",local:"prompt-tuning-for-causal-language-modeling",headingTag:"h1"}}),j=new $t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/clm-prompt-tuning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/clm-prompt-tuning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/clm-prompt-tuning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/clm-prompt-tuning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/clm-prompt-tuning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/clm-prompt-tuning.ipynb"}]}}),T=new Ft({props:{$$slots:{default:[Nt]},$$scope:{ctx:ml}}}),I=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cw==",highlighted:"!pip install -q peft transformers datasets",wrap:!1}}),_=new rl({props:{title:"Setup",local:"setup",headingTag:"h2"}}),B=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUyQyUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9wZWZ0X2NvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTJDJTIwUHJvbXB0VHVuaW5nSW5pdCUyQyUyMFByb21wdFR1bmluZ0NvbmZpZyUyQyUyMFRhc2tUeXBlJTJDJTIwUGVmdFR5cGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX25hbWVfb3JfcGF0aCUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiUwQXRva2VuaXplcl9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIlMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFByb21wdFR1bmluZ0NvbmZpZyglMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0RUYXNrVHlwZS5DQVVTQUxfTE0lMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdHVuaW5nX2luaXQlM0RQcm9tcHRUdW5pbmdJbml0LlRFWFQlMkMlMEElMjAlMjAlMjAlMjBudW1fdmlydHVhbF90b2tlbnMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3R1bmluZ19pbml0X3RleHQlM0QlMjJDbGFzc2lmeSUyMGlmJTIwdGhlJTIwdHdlZXQlMjBpcyUyMGElMjBjb21wbGFpbnQlMjBvciUyMG5vdCUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl9uYW1lX29yX3BhdGglM0Rtb2RlbF9uYW1lX29yX3BhdGglMkMlMEEpJTBBJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIydHdpdHRlcl9jb21wbGFpbnRzJTIyJTBBY2hlY2twb2ludF9uYW1lJTIwJTNEJTIwZiUyMiU3QmRhdGFzZXRfbmFtZSU3RF8lN0Jtb2RlbF9uYW1lX29yX3BhdGglN0RfJTdCcGVmdF9jb25maWcucGVmdF90eXBlJTdEXyU3QnBlZnRfY29uZmlnLnRhc2tfdHlwZSU3RF92MS5wdCUyMi5yZXBsYWNlKCUwQSUyMCUyMCUyMCUyMCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIlMEEpJTBBdGV4dF9jb2x1bW4lMjAlM0QlMjAlMjJUd2VldCUyMHRleHQlMjIlMEFsYWJlbF9jb2x1bW4lMjAlM0QlMjAlMjJ0ZXh0X2xhYmVsJTIyJTBBbWF4X2xlbmd0aCUyMCUzRCUyMDY0JTBBbHIlMjAlM0QlMjAzZS0yJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDUwJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDg=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, default_data_collator, get_linear_schedule_with_warmup
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_config, get_peft_model, PromptTuningInit, PromptTuningConfig, TaskType, PeftType
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_name_or_path = <span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>
tokenizer_name_or_path = <span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>
peft_config = PromptTuningConfig(
    task_type=TaskType.CAUSAL_LM,
    prompt_tuning_init=PromptTuningInit.TEXT,
    num_virtual_tokens=<span class="hljs-number">8</span>,
    prompt_tuning_init_text=<span class="hljs-string">&quot;Classify if the tweet is a complaint or not:&quot;</span>,
    tokenizer_name_or_path=model_name_or_path,
)

dataset_name = <span class="hljs-string">&quot;twitter_complaints&quot;</span>
checkpoint_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{dataset_name}</span>_<span class="hljs-subst">{model_name_or_path}</span>_<span class="hljs-subst">{peft_config.peft_type}</span>_<span class="hljs-subst">{peft_config.task_type}</span>_v1.pt&quot;</span>.replace(
    <span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>
)
text_column = <span class="hljs-string">&quot;Tweet text&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">64</span>
lr = <span class="hljs-number">3e-2</span>
num_epochs = <span class="hljs-number">50</span>
batch_size = <span class="hljs-number">8</span>`,wrap:!1}}),k=new rl({props:{title:"Load dataset",local:"load-dataset",headingTag:"h2"}}),X=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvdWdodCUyRnJhZnQlMjIlMkMlMjBkYXRhc2V0X25hbWUpJTBBZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUyMlR3ZWV0JTIwdGV4dCUyMiUzQSUyMCUyMiU0MEhNUkNjdXN0b21lcnMlMjBObyUyMHRoaXMlMjBpcyUyMG15JTIwZmlyc3QlMjBqb2IlMjIlMkMlMjAlMjJJRCUyMiUzQSUyMDAlMkMlMjAlMjJMYWJlbCUyMiUzQSUyMDIlN0Q=",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ought/raft&quot;</span>, dataset_name)
dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>}`,wrap:!1}}),G=new J({props:{code:"Y2xhc3NlcyUyMCUzRCUyMCU1QmsucmVwbGFjZSglMjJfJTIyJTJDJTIwJTIyJTIwJTIyKSUyMGZvciUyMGslMjBpbiUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMkxhYmVsJTIyJTVELm5hbWVzJTVEJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGxhbWJkYSUyMHglM0ElMjAlN0IlMjJ0ZXh0X2xhYmVsJTIyJTNBJTIwJTVCY2xhc3NlcyU1QmxhYmVsJTVEJTIwZm9yJTIwbGFiZWwlMjBpbiUyMHglNUIlMjJMYWJlbCUyMiU1RCU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Byb2MlM0QxJTJDJTBBKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlMEElN0IlMjJUd2VldCUyMHRleHQlMjIlM0ElMjAlMjIlNDBITVJDY3VzdG9tZXJzJTIwTm8lMjB0aGlzJTIwaXMlMjBteSUyMGZpcnN0JTIwam9iJTIyJTJDJTIwJTIySUQlMjIlM0ElMjAwJTJDJTIwJTIyTGFiZWwlMjIlM0ElMjAyJTJDJTIwJTIydGV4dF9sYWJlbCUyMiUzQSUyMCUyMm5vJTIwY29tcGxhaW50JTIyJTdE",highlighted:`classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;Label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)
dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;no complaint&quot;</span>}`,wrap:!1}}),W=new rl({props:{title:"Preprocess dataset",local:"preprocess-dataset",headingTag:"h2"}}),Q=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoKSUwQWlmJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTBBdGFyZ2V0X21heF9sZW5ndGglMjAlM0QlMjBtYXgoJTVCbGVuKHRva2VuaXplcihjbGFzc19sYWJlbCklNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTIwZm9yJTIwY2xhc3NfbGFiZWwlMjBpbiUyMGNsYXNzZXMlNUQpJTBBcHJpbnQodGFyZ2V0X21heF9sZW5ndGgpJTBBMw==",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name_or_path)
<span class="hljs-keyword">if</span> tokenizer.pad_token_id <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id
target_max_length = <span class="hljs-built_in">max</span>([<span class="hljs-built_in">len</span>(tokenizer(class_label)[<span class="hljs-string">&quot;input_ids&quot;</span>]) <span class="hljs-keyword">for</span> class_label <span class="hljs-keyword">in</span> classes])
<span class="hljs-built_in">print</span>(target_max_length)
<span class="hljs-number">3</span>`,wrap:!1}}),F=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    batch_size = <span class="hljs-built_in">len</span>(examples[text_column])
    inputs = [<span class="hljs-string">f&quot;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{x}</span> Label : &quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[text_column]]
    targets = [<span class="hljs-built_in">str</span>(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[label_column]]
    model_inputs = tokenizer(inputs)
    labels = tokenizer(targets)
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] + [tokenizer.pad_token_id]
        <span class="hljs-comment"># print(i, sample_input_ids, label_input_ids)</span>
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = sample_input_ids + label_input_ids
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * <span class="hljs-built_in">len</span>(sample_input_ids) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">1</span>] * <span class="hljs-built_in">len</span>(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i])
    <span class="hljs-comment"># print(model_inputs)</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [tokenizer.pad_token_id] * (
            max_length - <span class="hljs-built_in">len</span>(sample_input_ids)
        ) + sample_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">0</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + model_inputs[
            <span class="hljs-string">&quot;attention_mask&quot;</span>
        ][i]
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i][:max_length])
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),N=new J({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Byb2MlM0QxJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuY29sdW1uX25hbWVzJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9mcm9tX2NhY2hlX2ZpbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2MlM0QlMjJSdW5uaW5nJTIwdG9rZW5pemVyJTIwb24lMjBkYXRhc2V0JTIyJTJDJTBBKQ==",highlighted:`processed_datasets = dataset.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=dataset[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),x=new J({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHByb2Nlc3NlZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RCUwQSUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kYXRhc2V0JTJDJTIwY29sbGF0ZV9mbiUzRGRlZmF1bHRfZGF0YV9jb2xsYXRvciUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwcGluX21lbW9yeSUzRFRydWUp",highlighted:`train_dataset = processed_datasets[<span class="hljs-string">&quot;train&quot;</span>]
eval_dataset = processed_datasets[<span class="hljs-string">&quot;test&quot;</span>]


train_dataloader = DataLoader(
    train_dataset, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_dataset, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new rl({props:{title:"Train",local:"train",headingTag:"h2"}}),S=new J({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFwcmludChtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDgxOTIlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NTkyMjI3ODQlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjAwMTQ2NDg5MDI0MzA5ODUzNTglMjI=",highlighted:`model = AutoModelForCausalLM.from_pretrained(model_name_or_path)
model = get_peft_model(model, peft_config)
<span class="hljs-built_in">print</span>(model.print_trainable_parameters())
<span class="hljs-string">&quot;trainable params: 8192 || all params: 559222784 || trainable%: 0.0014648902430985358&quot;</span>`,wrap:!1}}),L=new J({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),K=new J({props:{code:"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",highlighted:`model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),D=new rl({props:{title:"Share model",local:"share-model",headingTag:"h2"}}),ll=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),sl=new J({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnlvdXItbmFtZSUyRmJsb29tei01NjBtX1BST01QVF9UVU5JTkdfQ0FVU0FMX0xNJTIyJTBBbW9kZWwucHVzaF90b19odWIoJTIyeW91ci1uYW1lJTJGYmxvb216LTU2MG1fUFJPTVBUX1RVTklOR19DQVVTQUxfTE0lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUp",highlighted:`peft_model_id = <span class="hljs-string">&quot;your-name/bloomz-560m_PROMPT_TUNING_CAUSAL_LM&quot;</span>
model.push_to_hub(<span class="hljs-string">&quot;your-name/bloomz-560m_PROMPT_TUNING_CAUSAL_LM&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),al=new rl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),pl=new J({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnN0ZXZobGl1JTJGYmxvb216LTU2MG1fUFJPTVBUX1RVTklOR19DQVVTQUxfTE0lMjIlMEElMEFjb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCklMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

peft_model_id = <span class="hljs-string">&quot;stevhliu/bloomz-560m_PROMPT_TUNING_CAUSAL_LM&quot;</span>

config = PeftConfig.from_pretrained(peft_model_id)
model = AutoModelForCausalLM.from_pretrained(config.base_model_name_or_path)
model = PeftModel.from_pretrained(model, peft_model_id)`,wrap:!1}}),Ml=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMGYnJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0IlMjIlNDBuYXRpb25hbGdyaWR1cyUyMEklMjBoYXZlJTIwbm8lMjB3YXRlciUyMGFuZCUyMHRoZSUyMGJpbGwlMjBpcyUyMGN1cnJlbnQlMjBhbmQlMjBwYWlkLiUyMENhbiUyMHlvdSUyMGRvJTIwc29tZXRoaW5nJTIwYWJvdXQlMjB0aGlzJTNGJTIyJTdEJTIwTGFiZWwlMjAlM0ElMjAnJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSk=",highlighted:`inputs = tokenizer(
    <span class="hljs-string">f&#x27;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{<span class="hljs-string">&quot;@nationalgridus I have no water and the bill is current and paid. Can you do something about this?&quot;</span>}</span> Label : &#x27;</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)`,wrap:!1}}),dl=new J({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGlucHV0cy5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGF0dGVudGlvbl9tYXNrJTNEaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZW9zX3Rva2VuX2lkJTNEMyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMEElMjAlMjAlMjAlMjAlMjJUd2VldCUyMHRleHQlMjAlM0ElMjAlNDBuYXRpb25hbGdyaWR1cyUyMEklMjBoYXZlJTIwbm8lMjB3YXRlciUyMGFuZCUyMHRoZSUyMGJpbGwlMjBpcyUyMGN1cnJlbnQlMjBhbmQlMjBwYWlkLiUyMENhbiUyMHlvdSUyMGRvJTIwc29tZXRoaW5nJTIwYWJvdXQlMjB0aGlzJTNGJTIwTGFiZWwlMjAlM0ElMjBjb21wbGFpbnQlMjIlMEElNUQ=",highlighted:`model.to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>, eos_token_id=<span class="hljs-number">3</span>
    )
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[
    <span class="hljs-string">&quot;Tweet text : @nationalgridus I have no water and the bill is current and paid. Can you do something about this? Label : complaint&quot;</span>
]`,wrap:!1}}),{c(){u=c("meta"),b=a(),U=c("p"),cl=a(),p(h.$$.fragment),ul=a(),p(j.$$.fragment),Jl=a(),w=c("p"),w.textContent=Mt,Ul=a(),p(T.$$.fragment),Tl=a(),f=c("p"),f.innerHTML=it,bl=a(),C=c("p"),C.textContent=dt,hl=a(),p(I.$$.fragment),jl=a(),p(_.$$.fragment),wl=a(),g=c("p"),g.innerHTML=rt,fl=a(),p(B.$$.fragment),Cl=a(),p(k.$$.fragment),Il=a(),R=c("p"),R.innerHTML=ct,_l=a(),p(X.$$.fragment),gl=a(),Z=c("p"),Z.innerHTML=yt,Bl=a(),p(G.$$.fragment),kl=a(),p(W.$$.fragment),Rl=a(),V=c("p"),V.textContent=mt,Xl=a(),p(Q.$$.fragment),Zl=a(),v=c("p"),v.innerHTML=ut,Gl=a(),A=c("ol"),A.innerHTML=Jt,Wl=a(),p(F.$$.fragment),Vl=a(),$=c("p"),$.innerHTML=Ut,Ql=a(),p(N.$$.fragment),vl=a(),Y=c("p"),Y.innerHTML=Tt,Al=a(),p(x.$$.fragment),Fl=a(),p(z.$$.fragment),$l=a(),H=c("p"),H.textContent=bt,Nl=a(),E=c("p"),E.innerHTML=ht,Yl=a(),p(S.$$.fragment),xl=a(),q=c("p"),q.textContent=jt,zl=a(),p(L.$$.fragment),Hl=a(),P=c("p"),P.textContent=wt,El=a(),p(K.$$.fragment),Sl=a(),p(D.$$.fragment),ql=a(),O=c("p"),O.textContent=ft,Ll=a(),p(ll.$$.fragment),Pl=a(),tl=c("p"),tl.innerHTML=Ct,Kl=a(),p(sl.$$.fragment),Dl=a(),el=c("p"),el.textContent=It,Ol=a(),p(al.$$.fragment),lt=a(),nl=c("p"),nl.innerHTML=_t,tt=a(),p(pl.$$.fragment),st=a(),ol=c("p"),ol.textContent=gt,et=a(),p(Ml.$$.fragment),at=a(),il=c("p"),il.innerHTML=Bt,nt=a(),p(dl.$$.fragment),pt=a(),yl=c("p"),this.h()},l(l){const t=vt("svelte-u9bgzb",document.head);u=y(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(l),U=y(l,"P",{}),Rt(U).forEach(s),cl=n(l),o(h.$$.fragment,l),ul=n(l),o(j.$$.fragment,l),Jl=n(l),w=y(l,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1rncs93"&&(w.textContent=Mt),Ul=n(l),o(T.$$.fragment,l),Tl=n(l),f=y(l,"P",{"data-svelte-h":!0}),m(f)!=="svelte-4kggda"&&(f.innerHTML=it),bl=n(l),C=y(l,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c9nexd"&&(C.textContent=dt),hl=n(l),o(I.$$.fragment,l),jl=n(l),o(_.$$.fragment,l),wl=n(l),g=y(l,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1upn4cu"&&(g.innerHTML=rt),fl=n(l),o(B.$$.fragment,l),Cl=n(l),o(k.$$.fragment,l),Il=n(l),R=y(l,"P",{"data-svelte-h":!0}),m(R)!=="svelte-185kx74"&&(R.innerHTML=ct),_l=n(l),o(X.$$.fragment,l),gl=n(l),Z=y(l,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-w7ixc9"&&(Z.innerHTML=yt),Bl=n(l),o(G.$$.fragment,l),kl=n(l),o(W.$$.fragment,l),Rl=n(l),V=y(l,"P",{"data-svelte-h":!0}),m(V)!=="svelte-rrdcxc"&&(V.textContent=mt),Xl=n(l),o(Q.$$.fragment,l),Zl=n(l),v=y(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-2a4a9i"&&(v.innerHTML=ut),Gl=n(l),A=y(l,"OL",{"data-svelte-h":!0}),m(A)!=="svelte-ung955"&&(A.innerHTML=Jt),Wl=n(l),o(F.$$.fragment,l),Vl=n(l),$=y(l,"P",{"data-svelte-h":!0}),m($)!=="svelte-148b38h"&&($.innerHTML=Ut),Ql=n(l),o(N.$$.fragment,l),vl=n(l),Y=y(l,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-j9si42"&&(Y.innerHTML=Tt),Al=n(l),o(x.$$.fragment,l),Fl=n(l),o(z.$$.fragment,l),$l=n(l),H=y(l,"P",{"data-svelte-h":!0}),m(H)!=="svelte-f4uv1m"&&(H.textContent=bt),Nl=n(l),E=y(l,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1npf6xd"&&(E.innerHTML=ht),Yl=n(l),o(S.$$.fragment,l),xl=n(l),q=y(l,"P",{"data-svelte-h":!0}),m(q)!=="svelte-7p7s8v"&&(q.textContent=jt),zl=n(l),o(L.$$.fragment,l),Hl=n(l),P=y(l,"P",{"data-svelte-h":!0}),m(P)!=="svelte-swkvfq"&&(P.textContent=wt),El=n(l),o(K.$$.fragment,l),Sl=n(l),o(D.$$.fragment,l),ql=n(l),O=y(l,"P",{"data-svelte-h":!0}),m(O)!=="svelte-vati0h"&&(O.textContent=ft),Ll=n(l),o(ll.$$.fragment,l),Pl=n(l),tl=y(l,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-xh50qj"&&(tl.innerHTML=Ct),Kl=n(l),o(sl.$$.fragment,l),Dl=n(l),el=y(l,"P",{"data-svelte-h":!0}),m(el)!=="svelte-8d1bi7"&&(el.textContent=It),Ol=n(l),o(al.$$.fragment,l),lt=n(l),nl=y(l,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-19sz0x6"&&(nl.innerHTML=_t),tt=n(l),o(pl.$$.fragment,l),st=n(l),ol=y(l,"P",{"data-svelte-h":!0}),m(ol)!=="svelte-f49xc3"&&(ol.textContent=gt),et=n(l),o(Ml.$$.fragment,l),at=n(l),il=y(l,"P",{"data-svelte-h":!0}),m(il)!=="svelte-tj65jb"&&(il.innerHTML=Bt),nt=n(l),o(dl.$$.fragment,l),pt=n(l),yl=y(l,"P",{}),Rt(yl).forEach(s),this.h()},h(){Xt(u,"name","hf:doc:metadata"),Xt(u,"content",xt)},m(l,t){At(document.head,u),e(l,b,t),e(l,U,t),e(l,cl,t),M(h,l,t),e(l,ul,t),M(j,l,t),e(l,Jl,t),e(l,w,t),e(l,Ul,t),M(T,l,t),e(l,Tl,t),e(l,f,t),e(l,bl,t),e(l,C,t),e(l,hl,t),M(I,l,t),e(l,jl,t),M(_,l,t),e(l,wl,t),e(l,g,t),e(l,fl,t),M(B,l,t),e(l,Cl,t),M(k,l,t),e(l,Il,t),e(l,R,t),e(l,_l,t),M(X,l,t),e(l,gl,t),e(l,Z,t),e(l,Bl,t),M(G,l,t),e(l,kl,t),M(W,l,t),e(l,Rl,t),e(l,V,t),e(l,Xl,t),M(Q,l,t),e(l,Zl,t),e(l,v,t),e(l,Gl,t),e(l,A,t),e(l,Wl,t),M(F,l,t),e(l,Vl,t),e(l,$,t),e(l,Ql,t),M(N,l,t),e(l,vl,t),e(l,Y,t),e(l,Al,t),M(x,l,t),e(l,Fl,t),M(z,l,t),e(l,$l,t),e(l,H,t),e(l,Nl,t),e(l,E,t),e(l,Yl,t),M(S,l,t),e(l,xl,t),e(l,q,t),e(l,zl,t),M(L,l,t),e(l,Hl,t),e(l,P,t),e(l,El,t),M(K,l,t),e(l,Sl,t),M(D,l,t),e(l,ql,t),e(l,O,t),e(l,Ll,t),M(ll,l,t),e(l,Pl,t),e(l,tl,t),e(l,Kl,t),M(sl,l,t),e(l,Dl,t),e(l,el,t),e(l,Ol,t),M(al,l,t),e(l,lt,t),e(l,nl,t),e(l,tt,t),M(pl,l,t),e(l,st,t),e(l,ol,t),e(l,et,t),M(Ml,l,t),e(l,at,t),e(l,il,t),e(l,nt,t),M(dl,l,t),e(l,pt,t),e(l,yl,t),ot=!0},p(l,[t]){const kt={};t&2&&(kt.$$scope={dirty:t,ctx:l}),T.$set(kt)},i(l){ot||(i(h.$$.fragment,l),i(j.$$.fragment,l),i(T.$$.fragment,l),i(I.$$.fragment,l),i(_.$$.fragment,l),i(B.$$.fragment,l),i(k.$$.fragment,l),i(X.$$.fragment,l),i(G.$$.fragment,l),i(W.$$.fragment,l),i(Q.$$.fragment,l),i(F.$$.fragment,l),i(N.$$.fragment,l),i(x.$$.fragment,l),i(z.$$.fragment,l),i(S.$$.fragment,l),i(L.$$.fragment,l),i(K.$$.fragment,l),i(D.$$.fragment,l),i(ll.$$.fragment,l),i(sl.$$.fragment,l),i(al.$$.fragment,l),i(pl.$$.fragment,l),i(Ml.$$.fragment,l),i(dl.$$.fragment,l),ot=!0)},o(l){d(h.$$.fragment,l),d(j.$$.fragment,l),d(T.$$.fragment,l),d(I.$$.fragment,l),d(_.$$.fragment,l),d(B.$$.fragment,l),d(k.$$.fragment,l),d(X.$$.fragment,l),d(G.$$.fragment,l),d(W.$$.fragment,l),d(Q.$$.fragment,l),d(F.$$.fragment,l),d(N.$$.fragment,l),d(x.$$.fragment,l),d(z.$$.fragment,l),d(S.$$.fragment,l),d(L.$$.fragment,l),d(K.$$.fragment,l),d(D.$$.fragment,l),d(ll.$$.fragment,l),d(sl.$$.fragment,l),d(al.$$.fragment,l),d(pl.$$.fragment,l),d(Ml.$$.fragment,l),d(dl.$$.fragment,l),ot=!1},d(l){l&&(s(b),s(U),s(cl),s(ul),s(Jl),s(w),s(Ul),s(Tl),s(f),s(bl),s(C),s(hl),s(jl),s(wl),s(g),s(fl),s(Cl),s(Il),s(R),s(_l),s(gl),s(Z),s(Bl),s(kl),s(Rl),s(V),s(Xl),s(Zl),s(v),s(Gl),s(A),s(Wl),s(Vl),s($),s(Ql),s(vl),s(Y),s(Al),s(Fl),s($l),s(H),s(Nl),s(E),s(Yl),s(xl),s(q),s(zl),s(Hl),s(P),s(El),s(Sl),s(ql),s(O),s(Ll),s(Pl),s(tl),s(Kl),s(Dl),s(el),s(Ol),s(lt),s(nl),s(tt),s(st),s(ol),s(et),s(at),s(il),s(nt),s(pt),s(yl)),s(u),r(h,l),r(j,l),r(T,l),r(I,l),r(_,l),r(B,l),r(k,l),r(X,l),r(G,l),r(W,l),r(Q,l),r(F,l),r(N,l),r(x,l),r(z,l),r(S,l),r(L,l),r(K,l),r(D,l),r(ll,l),r(sl,l),r(al,l),r(pl,l),r(Ml,l),r(dl,l)}}}const xt='{"title":"Prompt tuning for causal language modeling","local":"prompt-tuning-for-causal-language-modeling","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load dataset","local":"load-dataset","sections":[],"depth":2},{"title":"Preprocess dataset","local":"preprocess-dataset","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Share model","local":"share-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function zt(ml){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Vt{constructor(u){super(),Qt(this,u,zt,Yt,Zt,{})}}export{Kt as component};
