import{s as An,o as Xn,n as Gn}from"../chunks/scheduler.25b97de1.js";import{S as Qn,i as Nn,g as l,s as o,r as p,A as qn,h as s,f as a,c as r,j as U,u as m,x as d,k as w,y as i,a as n,v as f,d as c,t as u,w as h}from"../chunks/index.d9030fc9.js";import{T as In}from"../chunks/Tip.baa67368.js";import{D as V}from"../chunks/Docstring.ffac8efa.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{D as zn}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Z,E as Yn}from"../chunks/EditOnGithub.91d95064.js";function Sn(Xe){let y,$="You can load a PEFT adapter with either an <code>AutoModelFor</code> class or the base model class like <code>OPTForCausalLM</code> or <code>LlamaForCausalLM</code>.";return{c(){y=l("p"),y.innerHTML=$},l(M){y=s(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1cdoj9o"&&(y.innerHTML=$)},m(M,W){n(M,y,W)},p:Gn,d(M){M&&a(y)}}}function Dn(Xe){let y,$='If you aren’t familiar with fine-tuning a model with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the <a href="training">Fine-tune a pretrained model</a> tutorial.';return{c(){y=l("p"),y.innerHTML=$},l(M){y=s(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1aqapad"&&(y.innerHTML=$)},m(M,W){n(M,y,W)},p:Gn,d(M){M&&a(y)}}}function Kn(Xe){let y,$,M,W,I,yt,G,Mt,A,za='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it. The adapters are trained to learn task-specific information. This approach has been shown to be very memory-efficient with lower compute usage while producing results comparable to a fully fine-tuned model.',Tt,X,Ya="Adapters trained with PEFT are also usually an order of magnitude smaller than the full model, making it convenient to share, store, and load them.",wt,j,Sa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a OPTForCausalLM model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',_t,Q,Da='If you’re interested in learning more about the 🤗 PEFT library, check out the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',$t,N,vt,q,Ka="Get started by installing 🤗 PEFT:",Ct,z,xt,Y,Oa="If you want to try out the brand new features, you might be interested in installing the library from source:",kt,S,Jt,D,Ft,K,en="🤗 Transformers natively supports some PEFT methods, meaning you can load adapter weights stored locally or on the Hub and easily run or train them with a few lines of code. The following methods are supported:",Ut,O,tn='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',Zt,ee,an='If you want to use other PEFT methods, such as prompt learning or prompt tuning, or about the 🤗 PEFT library in general, please refer to the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',Pt,te,Wt,ae,nn="To load and use a PEFT adapter model from 🤗 Transformers, make sure the Hub repository or local directory contains an <code>adapter_config.json</code> file and the adapter weights, as shown in the example image above. Then you can load the PEFT adapter model using the <code>AutoModelFor</code> class. For example, to load a PEFT adapter model for causal language modeling:",jt,ne,on='<li>specify the PEFT model id</li> <li>pass it to the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> class</li>',Et,oe,Lt,E,Bt,re,rn="You can also load a PEFT adapter by calling the <code>load_adapter</code> method:",Ht,le,Rt,se,ln='Check out the <a href="#transformers.integrations.PeftAdapterMixin">API documentation</a> section below for more details.',Vt,ie,It,de,sn='The <code>bitsandbytes</code> integration supports 8bit and 4bit precision data types, which are useful for loading large models because it saves memory (see the <code>bitsandbytes</code> integration <a href="./quantization#bitsandbytes-integration">guide</a> to learn more). Add the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters to <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and set <code>device_map=&quot;auto&quot;</code> to effectively distribute the model to your hardware:',Gt,pe,At,me,Xt,fe,dn="You can use <code>~peft.PeftModel.add_adapter</code> to add a new adapter to a model with an existing adapter as long as the new adapter is the same type as the current one. For example, if you have an existing LoRA adapter attached to a model:",Qt,ce,Nt,ue,pn="To add a new adapter:",qt,he,zt,ge,mn="Now you can use <code>~peft.PeftModel.set_adapter</code> to set which adapter to use:",Yt,be,St,ye,Dt,Me,fn="Once you’ve added an adapter to a model, you can enable or disable the adapter module. To enable the adapter module:",Kt,Te,Ot,we,cn="To disable the adapter module:",ea,_e,ta,$e,aa,ve,un='PEFT adapters are supported by the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> class so that you can train an adapter for your specific use case. It only requires adding a few more lines of code. For example, to train a LoRA adapter:',na,L,oa,Ce,hn="<li>Define your adapter configuration with the task type and hyperparameters (see <code>~peft.LoraConfig</code> for more details about what the hyperparameters do).</li>",ra,xe,la,B,gn="<li>Add adapter to the model.</li>",sa,ke,ia,H,bn='<li>Now you can pass the model to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>!</li>',da,Je,pa,Fe,yn="To save your trained adapter and load it back:",ma,Ue,fa,Ze,ca,Pe,Mn="You can also fine-tune additional trainable adapters on top of a model that has adapters attached by passing <code>modules_to_save</code> in your PEFT config. For example, if you want to also fine-tune the lm_head on top of a model with a LoRA adapter:",ua,We,ha,je,ga,g,Ee,Ta,Qe,Tn=`A class containing all functions for loading and using adapters weights that are supported in PEFT library. For
more details about adapters and injecting them on a transformer-based model, check out the documentation of PEFT
library: <a href="https://huggingface.co/docs/peft/index" rel="nofollow">https://huggingface.co/docs/peft/index</a>`,wa,Ne,wn=`Currently supported PEFT methods are all non-prefix tuning methods. Below is the list of supported PEFT methods
that anyone can load, train and run with this mixin class:`,_a,qe,_n='<li>Low Rank Adapters (LoRA): <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/lora</a></li> <li>IA3: <a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/ia3</a></li> <li>AdaLora: <a href="https://arxiv.org/abs/2303.10512" rel="nofollow">https://arxiv.org/abs/2303.10512</a></li>',$a,ze,$n=`Other PEFT models such as prompt tuning, prompt learning are out of scope as these adapters are not “injectable”
into a torch module. For using these methods, please refer to the usage guide of PEFT library.`,va,Ye,vn="With this mixin, if the correct PEFT version is installed, it is possible to:",Ca,Se,Cn="<li>Load an adapter stored on a local path or in a remote Hub repository, and inject it in the model</li> <li>Attach new adapters in the model and train them with Trainer or by your own.</li> <li>Attach multiple adapters and iteratively activate / deactivate them</li> <li>Activate / deactivate all adapters from the model.</li> <li>Get the <code>state_dict</code> of the active adapter.</li>",xa,v,Le,ka,De,xn=`Load adapter weights from file or remote Hub folder. If you are not familiar with adapters and PEFT methods, we
invite you to read more about them on PEFT official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ja,Ke,kn="Requires peft as a backend to load the adapter weights.",Fa,C,Be,Ua,Oe,Jn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Za,et,Fn=`Adds a fresh new adapter to the current model for training purpose. If no adapter name is passed, a default
name is assigned to the adapter to follow the convention of PEFT library (in PEFT we use “default” as the
default adapter name).`,Pa,x,He,Wa,tt,Un=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,ja,at,Zn="Sets a specific adapter by forcing the model to use a that adapter and disable the other adapters.",Ea,k,Re,La,nt,Pn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ba,ot,Wn="Disable all adapters that are attached to the model. This leads to inferring with the base model only.",Ha,J,Ve,Ra,rt,jn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Va,lt,En="Enable adapters that are attached to the model. The model will use <code>self.active_adapter()</code>",Ia,_,Ie,Ga,st,Ln=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Aa,it,Bn=`Gets the current active adapters of the model. In case of multi-adapter inference (combining multiple adapters
for inference) returns the list of all active adapters so that users can deal with them accordingly.`,Xa,dt,Hn=`For previous PEFT versions (that does not support multi-adapter inference), <code>module.active_adapter</code> will return
a single string.`,Qa,F,Ge,Na,pt,Rn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,qa,mt,Vn=`Gets the adapter state dict that should only contain the weights tensors of the specified adapter_name adapter.
If no adapter_name is passed, the active adapter is used.`,ba,Ae,ya,bt,Ma;return I=new Z({props:{title:"Load adapters with 🤗 PEFT",local:"load-adapters-with--peft",headingTag:"h1"}}),G=new zn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"}]}}),N=new Z({props:{title:"Setup",local:"setup",headingTag:"h2"}}),z=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),S=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),D=new Z({props:{title:"Supported PEFT models",local:"supported-peft-models",headingTag:"h2"}}),te=new Z({props:{title:"Load a PEFT adapter",local:"load-a-peft-adapter",headingTag:"h2"}}),oe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),E=new In({props:{$$slots:{default:[Sn]},$$scope:{ctx:Xe}}}),le=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),ie=new Z({props:{title:"Load in 8bit or 4bit",local:"load-in-8bit-or-4bit",headingTag:"h2"}}),pe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new Z({props:{title:"Add a new adapter",local:"add-a-new-adapter",headingTag:"h2"}}),ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),he=new T({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),be=new T({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ye=new Z({props:{title:"Enable and disable adapters",local:"enable-and-disable-adapters",headingTag:"h2"}}),Te=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),_e=new T({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),$e=new Z({props:{title:"Train a PEFT adapter",local:"train-a-peft-adapter",headingTag:"h2"}}),L=new In({props:{$$slots:{default:[Dn]},$$scope:{ctx:Xe}}}),xe=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),ke=new T({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),Je=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),Ue=new T({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),Ze=new Z({props:{title:"Add additional trainable layers to a PEFT adapter",local:"add-additional-trainable-layers-to-a-peft-adapter",headingTag:"h2"}}),We=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model.add_adapter(lora_config)`,wrap:!1}}),je=new Z({props:{title:"API docs",local:"transformers.integrations.PeftAdapterMixin",headingTag:"h2"}}),Ee=new V({props:{name:"class transformers.integrations.PeftAdapterMixin",anchor:"transformers.integrations.PeftAdapterMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L42"}}),Le=new V({props:{name:"load_adapter",anchor:"transformers.integrations.PeftAdapterMixin.load_adapter",parameters:[{name:"peft_model_id",val:": Optional = None"},{name:"adapter_name",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"device_map",val:": Optional = 'auto'"},{name:"max_memory",val:": Optional = None"},{name:"offload_folder",val:": Optional = None"},{name:"offload_index",val:": Optional = None"},{name:"peft_config",val:": Dict = None"},{name:"adapter_state_dict",val:": Optional = None"},{name:"adapter_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_model_id",description:`<strong>peft_model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The identifier of the model to look for on the Hub, or a local path to the saved adapter config file
and adapter weights.`,name:"peft_model_id"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The adapter name to use. If not set, will use the default adapter.`,name:"adapter_name"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.token",description:`<strong>token</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Whether to use authentication token to load the remote folder. Userful to load private repositories
that are on HuggingFace Hub. You might need to call <code>huggingface-cli login</code> and paste your tokens to
cache it.`,name:"token"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code> or <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each
parameter/buffer name, once a given module name is inside, every submodule of it will be sent to the
same device. If we only pass the device (<em>e.g.</em>, <code>&quot;cpu&quot;</code>, <code>&quot;cuda:1&quot;</code>, <code>&quot;mps&quot;</code>, or a GPU ordinal rank
like <code>1</code>) on which the model will be allocated, the device map will map the entire model to this
device. Passing <code>device_map = 0</code> means put the whole model on GPU 0.</p>
<p>To have Accelerate compute the most optimized <code>device_map</code> automatically, set <code>device_map=&quot;auto&quot;</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available for each
GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <code>optional</code>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_index",description:`<strong>offload_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
<code>offload_index</code> argument to be passed to <code>accelerate.dispatch_model</code> method.`,name:"offload_index"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_config",description:`<strong>peft_config</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods. This argument is used in case users directly pass PEFT state dicts`,name:"peft_config"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_state_dict",description:`<strong>adapter_state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the adapter to load. This argument is used in case users directly pass PEFT state
dicts`,name:"adapter_state_dict"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_kwargs",description:`<strong>adapter_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <code>from_pretrained</code> method of the adapter config and
<code>find_adapter_config_file</code> method.`,name:"adapter_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L68"}}),Be=new V({props:{name:"add_adapter",anchor:"transformers.integrations.PeftAdapterMixin.add_adapter",parameters:[{name:"adapter_config",val:""},{name:"adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_config",description:`<strong>adapter_config</strong> (<code>~peft.PeftConfig</code>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods`,name:"adapter_config"},{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter to add. If no name is passed, a default name is assigned to the adapter.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L237"}}),He=new V({props:{name:"set_adapter",anchor:"transformers.integrations.PeftAdapterMixin.set_adapter",parameters:[{name:"adapter_name",val:": Union"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>Union[List[str], str]</code>) &#x2014;
The name of the adapter to set. Can be also a list of strings to set multiple adapters.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L276"}}),Re=new V({props:{name:"disable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.disable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L321"}}),Ve=new V({props:{name:"enable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.enable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L344"}}),Ie=new V({props:{name:"active_adapters",anchor:"transformers.integrations.PeftAdapterMixin.active_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L366"}}),Ge=new V({props:{name:"get_adapter_state_dict",anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict",parameters:[{name:"adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the adapter to get the state dict from. If no name is passed, the active adapter is used.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L405"}}),Ae=new Yn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/peft.md"}}),{c(){y=l("meta"),$=o(),M=l("p"),W=o(),p(I.$$.fragment),yt=o(),p(G.$$.fragment),Mt=o(),A=l("p"),A.innerHTML=za,Tt=o(),X=l("p"),X.textContent=Ya,wt=o(),j=l("div"),j.innerHTML=Sa,_t=o(),Q=l("p"),Q.innerHTML=Da,$t=o(),p(N.$$.fragment),vt=o(),q=l("p"),q.textContent=Ka,Ct=o(),p(z.$$.fragment),xt=o(),Y=l("p"),Y.textContent=Oa,kt=o(),p(S.$$.fragment),Jt=o(),p(D.$$.fragment),Ft=o(),K=l("p"),K.textContent=en,Ut=o(),O=l("ul"),O.innerHTML=tn,Zt=o(),ee=l("p"),ee.innerHTML=an,Pt=o(),p(te.$$.fragment),Wt=o(),ae=l("p"),ae.innerHTML=nn,jt=o(),ne=l("ol"),ne.innerHTML=on,Et=o(),p(oe.$$.fragment),Lt=o(),p(E.$$.fragment),Bt=o(),re=l("p"),re.innerHTML=rn,Ht=o(),p(le.$$.fragment),Rt=o(),se=l("p"),se.innerHTML=ln,Vt=o(),p(ie.$$.fragment),It=o(),de=l("p"),de.innerHTML=sn,Gt=o(),p(pe.$$.fragment),At=o(),p(me.$$.fragment),Xt=o(),fe=l("p"),fe.innerHTML=dn,Qt=o(),p(ce.$$.fragment),Nt=o(),ue=l("p"),ue.textContent=pn,qt=o(),p(he.$$.fragment),zt=o(),ge=l("p"),ge.innerHTML=mn,Yt=o(),p(be.$$.fragment),St=o(),p(ye.$$.fragment),Dt=o(),Me=l("p"),Me.textContent=fn,Kt=o(),p(Te.$$.fragment),Ot=o(),we=l("p"),we.textContent=cn,ea=o(),p(_e.$$.fragment),ta=o(),p($e.$$.fragment),aa=o(),ve=l("p"),ve.innerHTML=un,na=o(),p(L.$$.fragment),oa=o(),Ce=l("ol"),Ce.innerHTML=hn,ra=o(),p(xe.$$.fragment),la=o(),B=l("ol"),B.innerHTML=gn,sa=o(),p(ke.$$.fragment),ia=o(),H=l("ol"),H.innerHTML=bn,da=o(),p(Je.$$.fragment),pa=o(),Fe=l("p"),Fe.textContent=yn,ma=o(),p(Ue.$$.fragment),fa=o(),p(Ze.$$.fragment),ca=o(),Pe=l("p"),Pe.innerHTML=Mn,ua=o(),p(We.$$.fragment),ha=o(),p(je.$$.fragment),ga=o(),g=l("div"),p(Ee.$$.fragment),Ta=o(),Qe=l("p"),Qe.innerHTML=Tn,wa=o(),Ne=l("p"),Ne.textContent=wn,_a=o(),qe=l("ul"),qe.innerHTML=_n,$a=o(),ze=l("p"),ze.textContent=$n,va=o(),Ye=l("p"),Ye.textContent=vn,Ca=o(),Se=l("ul"),Se.innerHTML=Cn,xa=o(),v=l("div"),p(Le.$$.fragment),ka=o(),De=l("p"),De.innerHTML=xn,Ja=o(),Ke=l("p"),Ke.textContent=kn,Fa=o(),C=l("div"),p(Be.$$.fragment),Ua=o(),Oe=l("p"),Oe.innerHTML=Jn,Za=o(),et=l("p"),et.textContent=Fn,Pa=o(),x=l("div"),p(He.$$.fragment),Wa=o(),tt=l("p"),tt.innerHTML=Un,ja=o(),at=l("p"),at.textContent=Zn,Ea=o(),k=l("div"),p(Re.$$.fragment),La=o(),nt=l("p"),nt.innerHTML=Pn,Ba=o(),ot=l("p"),ot.textContent=Wn,Ha=o(),J=l("div"),p(Ve.$$.fragment),Ra=o(),rt=l("p"),rt.innerHTML=jn,Va=o(),lt=l("p"),lt.innerHTML=En,Ia=o(),_=l("div"),p(Ie.$$.fragment),Ga=o(),st=l("p"),st.innerHTML=Ln,Aa=o(),it=l("p"),it.textContent=Bn,Xa=o(),dt=l("p"),dt.innerHTML=Hn,Qa=o(),F=l("div"),p(Ge.$$.fragment),Na=o(),pt=l("p"),pt.innerHTML=Rn,qa=o(),mt=l("p"),mt.textContent=Vn,ba=o(),p(Ae.$$.fragment),ya=o(),bt=l("p"),this.h()},l(e){const t=qn("svelte-u9bgzb",document.head);y=s(t,"META",{name:!0,content:!0}),t.forEach(a),$=r(e),M=s(e,"P",{}),U(M).forEach(a),W=r(e),m(I.$$.fragment,e),yt=r(e),m(G.$$.fragment,e),Mt=r(e),A=s(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-378l9l"&&(A.innerHTML=za),Tt=r(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-nc5pgb"&&(X.textContent=Ya),wt=r(e),j=s(e,"DIV",{class:!0,"data-svelte-h":!0}),d(j)!=="svelte-1gn6iv2"&&(j.innerHTML=Sa),_t=r(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1ldq9i6"&&(Q.innerHTML=Da),$t=r(e),m(N.$$.fragment,e),vt=r(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1rn19ih"&&(q.textContent=Ka),Ct=r(e),m(z.$$.fragment,e),xt=r(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cgwmeo"&&(Y.textContent=Oa),kt=r(e),m(S.$$.fragment,e),Jt=r(e),m(D.$$.fragment,e),Ft=r(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-5xdqaf"&&(K.textContent=en),Ut=r(e),O=s(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-1ulyaf4"&&(O.innerHTML=tn),Zt=r(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-8y8234"&&(ee.innerHTML=an),Pt=r(e),m(te.$$.fragment,e),Wt=r(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-c3wuk0"&&(ae.innerHTML=nn),jt=r(e),ne=s(e,"OL",{"data-svelte-h":!0}),d(ne)!=="svelte-1yy7goh"&&(ne.innerHTML=on),Et=r(e),m(oe.$$.fragment,e),Lt=r(e),m(E.$$.fragment,e),Bt=r(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1l4y13r"&&(re.innerHTML=rn),Ht=r(e),m(le.$$.fragment,e),Rt=r(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-3yz3tt"&&(se.innerHTML=ln),Vt=r(e),m(ie.$$.fragment,e),It=r(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-15a7q7h"&&(de.innerHTML=sn),Gt=r(e),m(pe.$$.fragment,e),At=r(e),m(me.$$.fragment,e),Xt=r(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1xpot6r"&&(fe.innerHTML=dn),Qt=r(e),m(ce.$$.fragment,e),Nt=r(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1t2m746"&&(ue.textContent=pn),qt=r(e),m(he.$$.fragment,e),zt=r(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-adr915"&&(ge.innerHTML=mn),Yt=r(e),m(be.$$.fragment,e),St=r(e),m(ye.$$.fragment,e),Dt=r(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-gwuro2"&&(Me.textContent=fn),Kt=r(e),m(Te.$$.fragment,e),Ot=r(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-tzq689"&&(we.textContent=cn),ea=r(e),m(_e.$$.fragment,e),ta=r(e),m($e.$$.fragment,e),aa=r(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1jgkwn3"&&(ve.innerHTML=un),na=r(e),m(L.$$.fragment,e),oa=r(e),Ce=s(e,"OL",{"data-svelte-h":!0}),d(Ce)!=="svelte-28sdvg"&&(Ce.innerHTML=hn),ra=r(e),m(xe.$$.fragment,e),la=r(e),B=s(e,"OL",{start:!0,"data-svelte-h":!0}),d(B)!=="svelte-1qk52ef"&&(B.innerHTML=gn),sa=r(e),m(ke.$$.fragment,e),ia=r(e),H=s(e,"OL",{start:!0,"data-svelte-h":!0}),d(H)!=="svelte-e9niqx"&&(H.innerHTML=bn),da=r(e),m(Je.$$.fragment,e),pa=r(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1nalv2a"&&(Fe.textContent=yn),ma=r(e),m(Ue.$$.fragment,e),fa=r(e),m(Ze.$$.fragment,e),ca=r(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-6009n9"&&(Pe.innerHTML=Mn),ua=r(e),m(We.$$.fragment,e),ha=r(e),m(je.$$.fragment,e),ga=r(e),g=s(e,"DIV",{class:!0});var b=U(g);m(Ee.$$.fragment,b),Ta=r(b),Qe=s(b,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1lavptw"&&(Qe.innerHTML=Tn),wa=r(b),Ne=s(b,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-2z4u5p"&&(Ne.textContent=wn),_a=r(b),qe=s(b,"UL",{"data-svelte-h":!0}),d(qe)!=="svelte-1ug31ta"&&(qe.innerHTML=_n),$a=r(b),ze=s(b,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1nqkdi3"&&(ze.textContent=$n),va=r(b),Ye=s(b,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-wzrwkl"&&(Ye.textContent=vn),Ca=r(b),Se=s(b,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-4kner1"&&(Se.innerHTML=Cn),xa=r(b),v=s(b,"DIV",{class:!0});var P=U(v);m(Le.$$.fragment,P),ka=r(P),De=s(P,"P",{"data-svelte-h":!0}),d(De)!=="svelte-k3pc0b"&&(De.innerHTML=xn),Ja=r(P),Ke=s(P,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-qhx0qk"&&(Ke.textContent=kn),P.forEach(a),Fa=r(b),C=s(b,"DIV",{class:!0});var ft=U(C);m(Be.$$.fragment,ft),Ua=r(ft),Oe=s(ft,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-esrgfk"&&(Oe.innerHTML=Jn),Za=r(ft),et=s(ft,"P",{"data-svelte-h":!0}),d(et)!=="svelte-11mk5e0"&&(et.textContent=Fn),ft.forEach(a),Pa=r(b),x=s(b,"DIV",{class:!0});var ct=U(x);m(He.$$.fragment,ct),Wa=r(ct),tt=s(ct,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-esrgfk"&&(tt.innerHTML=Un),ja=r(ct),at=s(ct,"P",{"data-svelte-h":!0}),d(at)!=="svelte-dcd4bp"&&(at.textContent=Zn),ct.forEach(a),Ea=r(b),k=s(b,"DIV",{class:!0});var ut=U(k);m(Re.$$.fragment,ut),La=r(ut),nt=s(ut,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-esrgfk"&&(nt.innerHTML=Pn),Ba=r(ut),ot=s(ut,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1h3d7ho"&&(ot.textContent=Wn),ut.forEach(a),Ha=r(b),J=s(b,"DIV",{class:!0});var ht=U(J);m(Ve.$$.fragment,ht),Ra=r(ht),rt=s(ht,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-esrgfk"&&(rt.innerHTML=jn),Va=r(ht),lt=s(ht,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1wkmhaw"&&(lt.innerHTML=En),ht.forEach(a),Ia=r(b),_=s(b,"DIV",{class:!0});var R=U(_);m(Ie.$$.fragment,R),Ga=r(R),st=s(R,"P",{"data-svelte-h":!0}),d(st)!=="svelte-esrgfk"&&(st.innerHTML=Ln),Aa=r(R),it=s(R,"P",{"data-svelte-h":!0}),d(it)!=="svelte-kqotd"&&(it.textContent=Bn),Xa=r(R),dt=s(R,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-13oobru"&&(dt.innerHTML=Hn),R.forEach(a),Qa=r(b),F=s(b,"DIV",{class:!0});var gt=U(F);m(Ge.$$.fragment,gt),Na=r(gt),pt=s(gt,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-esrgfk"&&(pt.innerHTML=Rn),qa=r(gt),mt=s(gt,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-tj66gs"&&(mt.textContent=Vn),gt.forEach(a),b.forEach(a),ba=r(e),m(Ae.$$.fragment,e),ya=r(e),bt=s(e,"P",{}),U(bt).forEach(a),this.h()},h(){w(y,"name","hf:doc:metadata"),w(y,"content",On),w(j,"class","flex flex-col justify-center"),w(B,"start","2"),w(H,"start","3"),w(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,y),n(e,$,t),n(e,M,t),n(e,W,t),f(I,e,t),n(e,yt,t),f(G,e,t),n(e,Mt,t),n(e,A,t),n(e,Tt,t),n(e,X,t),n(e,wt,t),n(e,j,t),n(e,_t,t),n(e,Q,t),n(e,$t,t),f(N,e,t),n(e,vt,t),n(e,q,t),n(e,Ct,t),f(z,e,t),n(e,xt,t),n(e,Y,t),n(e,kt,t),f(S,e,t),n(e,Jt,t),f(D,e,t),n(e,Ft,t),n(e,K,t),n(e,Ut,t),n(e,O,t),n(e,Zt,t),n(e,ee,t),n(e,Pt,t),f(te,e,t),n(e,Wt,t),n(e,ae,t),n(e,jt,t),n(e,ne,t),n(e,Et,t),f(oe,e,t),n(e,Lt,t),f(E,e,t),n(e,Bt,t),n(e,re,t),n(e,Ht,t),f(le,e,t),n(e,Rt,t),n(e,se,t),n(e,Vt,t),f(ie,e,t),n(e,It,t),n(e,de,t),n(e,Gt,t),f(pe,e,t),n(e,At,t),f(me,e,t),n(e,Xt,t),n(e,fe,t),n(e,Qt,t),f(ce,e,t),n(e,Nt,t),n(e,ue,t),n(e,qt,t),f(he,e,t),n(e,zt,t),n(e,ge,t),n(e,Yt,t),f(be,e,t),n(e,St,t),f(ye,e,t),n(e,Dt,t),n(e,Me,t),n(e,Kt,t),f(Te,e,t),n(e,Ot,t),n(e,we,t),n(e,ea,t),f(_e,e,t),n(e,ta,t),f($e,e,t),n(e,aa,t),n(e,ve,t),n(e,na,t),f(L,e,t),n(e,oa,t),n(e,Ce,t),n(e,ra,t),f(xe,e,t),n(e,la,t),n(e,B,t),n(e,sa,t),f(ke,e,t),n(e,ia,t),n(e,H,t),n(e,da,t),f(Je,e,t),n(e,pa,t),n(e,Fe,t),n(e,ma,t),f(Ue,e,t),n(e,fa,t),f(Ze,e,t),n(e,ca,t),n(e,Pe,t),n(e,ua,t),f(We,e,t),n(e,ha,t),f(je,e,t),n(e,ga,t),n(e,g,t),f(Ee,g,null),i(g,Ta),i(g,Qe),i(g,wa),i(g,Ne),i(g,_a),i(g,qe),i(g,$a),i(g,ze),i(g,va),i(g,Ye),i(g,Ca),i(g,Se),i(g,xa),i(g,v),f(Le,v,null),i(v,ka),i(v,De),i(v,Ja),i(v,Ke),i(g,Fa),i(g,C),f(Be,C,null),i(C,Ua),i(C,Oe),i(C,Za),i(C,et),i(g,Pa),i(g,x),f(He,x,null),i(x,Wa),i(x,tt),i(x,ja),i(x,at),i(g,Ea),i(g,k),f(Re,k,null),i(k,La),i(k,nt),i(k,Ba),i(k,ot),i(g,Ha),i(g,J),f(Ve,J,null),i(J,Ra),i(J,rt),i(J,Va),i(J,lt),i(g,Ia),i(g,_),f(Ie,_,null),i(_,Ga),i(_,st),i(_,Aa),i(_,it),i(_,Xa),i(_,dt),i(g,Qa),i(g,F),f(Ge,F,null),i(F,Na),i(F,pt),i(F,qa),i(F,mt),n(e,ba,t),f(Ae,e,t),n(e,ya,t),n(e,bt,t),Ma=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),E.$set(b);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),L.$set(P)},i(e){Ma||(c(I.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(E.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),c(L.$$.fragment,e),c(xe.$$.fragment,e),c(ke.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(je.$$.fragment,e),c(Ee.$$.fragment,e),c(Le.$$.fragment,e),c(Be.$$.fragment,e),c(He.$$.fragment,e),c(Re.$$.fragment,e),c(Ve.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(Ae.$$.fragment,e),Ma=!0)},o(e){u(I.$$.fragment,e),u(G.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(E.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(_e.$$.fragment,e),u($e.$$.fragment,e),u(L.$$.fragment,e),u(xe.$$.fragment,e),u(ke.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Be.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),u(Ae.$$.fragment,e),Ma=!1},d(e){e&&(a($),a(M),a(W),a(yt),a(Mt),a(A),a(Tt),a(X),a(wt),a(j),a(_t),a(Q),a($t),a(vt),a(q),a(Ct),a(xt),a(Y),a(kt),a(Jt),a(Ft),a(K),a(Ut),a(O),a(Zt),a(ee),a(Pt),a(Wt),a(ae),a(jt),a(ne),a(Et),a(Lt),a(Bt),a(re),a(Ht),a(Rt),a(se),a(Vt),a(It),a(de),a(Gt),a(At),a(Xt),a(fe),a(Qt),a(Nt),a(ue),a(qt),a(zt),a(ge),a(Yt),a(St),a(Dt),a(Me),a(Kt),a(Ot),a(we),a(ea),a(ta),a(aa),a(ve),a(na),a(oa),a(Ce),a(ra),a(la),a(B),a(sa),a(ia),a(H),a(da),a(pa),a(Fe),a(ma),a(fa),a(ca),a(Pe),a(ua),a(ha),a(ga),a(g),a(ba),a(ya),a(bt)),a(y),h(I,e),h(G,e),h(N,e),h(z,e),h(S,e),h(D,e),h(te,e),h(oe,e),h(E,e),h(le,e),h(ie,e),h(pe,e),h(me,e),h(ce,e),h(he,e),h(be,e),h(ye,e),h(Te,e),h(_e,e),h($e,e),h(L,e),h(xe,e),h(ke,e),h(Je,e),h(Ue,e),h(Ze,e),h(We,e),h(je,e),h(Ee),h(Le),h(Be),h(He),h(Re),h(Ve),h(Ie),h(Ge),h(Ae,e)}}}const On='{"title":"Load adapters with 🤗 PEFT","local":"load-adapters-with--peft","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Supported PEFT models","local":"supported-peft-models","sections":[],"depth":2},{"title":"Load a PEFT adapter","local":"load-a-peft-adapter","sections":[],"depth":2},{"title":"Load in 8bit or 4bit","local":"load-in-8bit-or-4bit","sections":[],"depth":2},{"title":"Add a new adapter","local":"add-a-new-adapter","sections":[],"depth":2},{"title":"Enable and disable adapters","local":"enable-and-disable-adapters","sections":[],"depth":2},{"title":"Train a PEFT adapter","local":"train-a-peft-adapter","sections":[],"depth":2},{"title":"Add additional trainable layers to a PEFT adapter","local":"add-additional-trainable-layers-to-a-peft-adapter","sections":[],"depth":2},{"title":"API docs","local":"transformers.integrations.PeftAdapterMixin","sections":[],"depth":2}],"depth":1}';function eo(Xe){return Xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class io extends Qn{constructor(y){super(),Nn(this,y,eo,Kn,An,{})}}export{io as component};
