import{s as tl,o as nl,n as nn}from"../chunks/scheduler.25b97de1.js";import{S as ol,i as al,g as s,s as n,r as d,A as rl,h as l,f as a,c as o,j as _,u as m,x as f,k as v,y as t,a as i,v as c,d as p,t as g,w as h}from"../chunks/index.d9030fc9.js";import{T as Yr}from"../chunks/Tip.baa67368.js";import{D as y}from"../chunks/Docstring.ffac8efa.js";import{C as so}from"../chunks/CodeBlock.e6cd0d95.js";import{E as $a}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as j,E as sl}from"../chunks/EditOnGithub.91d95064.js";function ll(L){let u,x=`Transformers Agents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){u=s("p"),u.textContent=x},l($){u=l($,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1fgfei3"&&(u.textContent=x)},m($,w){i($,u,w)},p:nn,d($){$&&a(u)}}}function il(L){let u,x="Example:",$,w,T;return w=new so({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBQeXRob25JbnRlcnByZXRlclRvb2wlMEElMEFweXRob25faW50ZXJwcmV0ZXIlMjAlM0QlMjBQeXRob25JbnRlcnByZXRlclRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcHl0aG9uX2ludGVycHJldGVyJTVEKSUwQWFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjByZXN1bHQlMjBvZiUyMDIlMjBwb3dlciUyMDMuNzM4NCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> CodeAgent, PythonInterpreterTool

python_interpreter = PythonInterpreterTool()
agent = CodeAgent(tools=[python_interpreter])
agent.run(<span class="hljs-string">&quot;What is the result of 2 power 3.7384?&quot;</span>)`,wrap:!1}}),{c(){u=s("p"),u.textContent=x,$=n(),d(w.$$.fragment)},l(b){u=l(b,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11lpom8"&&(u.textContent=x),$=o(b),m(w.$$.fragment,b)},m(b,C){i(b,u,C),i(b,$,C),c(w,b,C),T=!0},p:nn,i(b){T||(p(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(u),a($)),h(w,b)}}}function dl(L){let u,x="Example:",$,w,T;return w=new so({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdEpzb25BZ2VudCUyQyUyMFB5dGhvbkludGVycHJldGVyVG9vbCUwQSUwQXB5dGhvbl9pbnRlcnByZXRlciUyMCUzRCUyMFB5dGhvbkludGVycHJldGVyVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnB5dGhvbl9pbnRlcnByZXRlciU1RCklMEFhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwcmVzdWx0JTIwb2YlMjAyJTIwcG93ZXIlMjAzLjczODQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactJsonAgent, PythonInterpreterTool

python_interpreter = PythonInterpreterTool()
agent = ReactJsonAgent(tools=[python_interpreter])
agent.run(<span class="hljs-string">&quot;What is the result of 2 power 3.7384?&quot;</span>)`,wrap:!1}}),{c(){u=s("p"),u.textContent=x,$=n(),d(w.$$.fragment)},l(b){u=l(b,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11lpom8"&&(u.textContent=x),$=o(b),m(w.$$.fragment,b)},m(b,C){i(b,u,C),i(b,$,C),c(w,b,C),T=!0},p:nn,i(b){T||(p(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(u),a($)),h(w,b)}}}function ml(L){let u,x=`Loading a tool means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){u=s("p"),u.textContent=x},l($){u=l($,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1kcherd"&&(u.textContent=x)},m($,w){i($,u,w)},p:nn,d($){$&&a(u)}}}function cl(L){let u,x=`Loading a tool from the Hub means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){u=s("p"),u.textContent=x},l($){u=l($,"P",{"data-svelte-h":!0}),f(u)!=="svelte-fpk7e5"&&(u.textContent=x)},m($,w){i($,u,w)},p:nn,d($){$&&a(u)}}}function pl(L){let u,x="For instance:",$,w,T;return w=new so({props:{code:"ZnJvbSUyMG15X3Rvb2xfbW9kdWxlJTIwaW1wb3J0JTIwTXlUb29sJTBBbXlfdG9vbCUyMCUzRCUyME15VG9vbCgpJTBBbXlfdG9vbC5wdXNoX3RvX2h1YiglMjJteS11c2VybmFtZSUyRm15LXNwYWNlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> my_tool_module <span class="hljs-keyword">import</span> MyTool
my_tool = MyTool()
my_tool.push_to_hub(<span class="hljs-string">&quot;my-username/my-space&quot;</span>)`,wrap:!1}}),{c(){u=s("p"),u.textContent=x,$=n(),d(w.$$.fragment)},l(b){u=l(b,"P",{"data-svelte-h":!0}),f(u)!=="svelte-4vay6o"&&(u.textContent=x),$=o(b),m(w.$$.fragment,b)},m(b,C){i(b,u,C),i(b,$,C),c(w,b,C),T=!0},p:nn,i(b){T||(p(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(u),a($)),h(w,b)}}}function gl(L){let u,x="Example:",$,w,T;return w=new so({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwUmVhY3RDb2RlQWdlbnQlMEElMEFpbWFnZV90b29sX2NvbGxlY3Rpb24lMjAlM0QlMjBUb29sQ29sbGVjdGlvbihjb2xsZWN0aW9uX3NsdWclM0QlMjJodWdnaW5nZmFjZS10b29scyUyRmRpZmZ1c2lvbi10b29scy02NjMwYmIxOWE5NDJjMjMwNmEyY2RiNmYlMjIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QippbWFnZV90b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUyMlBsZWFzZSUyMGRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcy4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ToolCollection, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>image_tool_collection = ToolCollection(collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[*image_tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){u=s("p"),u.textContent=x,$=n(),d(w.$$.fragment)},l(b){u=l(b,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11lpom8"&&(u.textContent=x),$=o(b),m(w.$$.fragment,b)},m(b,C){i(b,u,C),i(b,$,C),c(w,b,C),T=!0},p:nn,i(b){T||(p(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(u),a($)),h(w,b)}}}function hl(L){let u,x,$,w,T,b,C,lo,qe,Fr=`To learn more about agents and tools make sure to read the <a href="../transformers_agents">introductory guide</a>. This page
contains the API docs for the underlying classes.`,io,Pe,mo,Je,Qr='We provide two types of agents, based on the main <a href="/docs/transformers/main/en/main_classes/agent#transformers.Agent">Agent</a> class:',co,Ee,Xr='<li><a href="/docs/transformers/main/en/main_classes/agent#transformers.CodeAgent">CodeAgent</a> acts in one shot, generating code to solve the task, then executes it at once.</li> <li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactAgent">ReactAgent</a> acts step by step, each step consisting of one thought, then one tool call and execution. It has two classes:<ul><li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactJsonAgent">ReactJsonAgent</a> writes its tool calls in JSON.</li> <li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactCodeAgent">ReactCodeAgent</a> writes its tool calls in Python code.</li></ul></li>',po,Ne,go,q,He,ya,X,Ue,wa,on,Kr=`Execute tool with the provided input and returns the result.
This method replaces arguments with the actual values from the state if they refer to state variables.`,Ta,K,Be,xa,an,es="Parse action from the LLM output",ka,ee,De,Ca,rn,ts="To be implemented in the child class",Ma,te,Re,Ia,sn,ns=`Reads past llm_outputs, actions, and observations or errors from the logs into a series of messages
that can be used as input to the LLM.`,ho,We,uo,E,Se,Aa,ln,os="A class for an agent that solves the given task using a single block of code. It plans all its actions, then executes all in one shot.",ja,ne,Ve,La,dn,as=`Override this method if you want to change the way the code is
cleaned in the <code>run</code> method.`,qa,G,Oe,Pa,mn,rs="Runs the agent for the given task.",Ja,oe,fo,ze,bo,W,Ge,Ea,cn,ss=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The action will be parsed from the LLM output: it consists in calls to tools from the toolbox, with arguments chosen by the LLM engine.`,Na,Z,Ze,Ha,pn,ls="Runs the agent for the given task.",Ua,ae,_o,S,Ye,Ba,gn,is=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The tool calls will be formulated by the LLM in JSON format, then parsed and executed.`,Da,re,Fe,Ra,hn,ds=`Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
The errors are raised here, they are caught and logged in the run() method.`,vo,V,Qe,Wa,un,ms=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The tool calls will be formulated by the LLM in code format, then parsed and executed.`,Sa,se,Xe,Va,fn,cs=`Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
The errors are raised here, they are caught and logged in the run() method.`,$o,Ke,yo,et,wo,O,tt,Oa,bn,ps="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",za,le,To,nt,xo,k,ot,Ga,_n,gs=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,Za,vn,hs=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>Dict[str, Dict[str, Union[str, type]]]</code>) — The dict of modalities expected for the inputs.
It has one <code>type</code>key and a <code>description</code>key.
This is used by <code>launch_gradio_demo</code> or to make a nice space from your tool, and also can be used in the generated
description for your tool.</li> <li><strong>output_type</strong> (<code>type</code>) — The type of the tool output. This is used by <code>launch_gradio_demo</code>
or to make a nice space from your tool, and also can be used in the generated description for your tool.</li>`,Ya,$n,us=`You can also override the method <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,Fa,ie,at,Qa,yn,fs='Creates a <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',Xa,Y,rt,Ka,wn,bs="Loads a tool defined on the Hub.",er,de,tr,me,st,nr,Tn,_s='Creates a <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> from a langchain tool.',or,D,lt,ar,xn,vs="Upload the tool to the Hub.",rr,kn,$s="For this method to work properly, your tool must have been defined in a separate module (not <code>__main__</code>).",sr,ce,lr,R,it,ir,Cn,ys=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,dr,Mn,ws=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,mr,In,Ts="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",cr,pe,dt,pr,An,xs=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,ko,mt,Co,I,ct,gr,jn,ks=`The toolbox contains all tools that the agent can perform operations with, as well as a few methods to
manage them.`,hr,ge,pt,ur,Ln,Cs="Adds a tool to the toolbox",fr,he,gt,br,qn,Ms="Clears the toolbox",_r,ue,ht,vr,Pn,Is="Removes a tool from the toolbox",$r,fe,ut,yr,Jn,As="Returns the description of all tools in the toolbox",wr,be,ft,Tr,En,js="Updates a tool in the toolbox according to its name.",Mo,bt,Io,A,_t,xr,Nn,Ls=`A <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,kr,Hn,qs=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,Cr,_e,vt,Mr,Un,Ps="Uses the <code>post_processor</code> to decode the model output.",Ir,ve,$t,Ar,Bn,Js="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",jr,$e,yt,Lr,Dn,Es="Sends the inputs through the <code>model</code>.",qr,ye,wt,Pr,Rn,Ns="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",Ao,Tt,jo,F,xt,Jr,Wn,Hs=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>output_type</code>.`,Lo,kt,qo,N,Ct,Er,Sn,Us="Tool collections enable loading all Spaces from a collection in order to be added to the agent’s toolbox.",Nr,Vn,Bs=`<p>[!NOTE]
Only Spaces will be fetched, so you can feel free to add models and datasets to your collection if you’d
like for this collection to showcase them.</p>`,Hr,we,Po,Mt,Jo,It,Ds=`You’re free to create and use your own engines to be usable by the Agents framework.
These engines have the following specification:`,Eo,At,Rs='<li>Follow the <a href="../chat_templating.md">messages format</a> for its input (<code>List[Dict[str, str]]</code>) and return a string.</li> <li>Stop generating outputs <em>before</em> the sequences passed in the argument <code>stop_sequences</code></li>',No,jt,Ho,Lt,Ws="For convenience, we have added a <code>HfEngine</code> that implements the points above and uses an inference endpoint for the execution of the LLM.",Uo,qt,Bo,Pt,Jt,Do,Et,Ro,Nt,Ss=`Agents can handle any type of object in-between tools; tools, being completely multimodal, can accept and return
text, image, audio, video, among other types. In order to increase compatibility between tools, as well as to
correctly render these returns in ipython (jupyter, colab, ipython notebooks, …), we implement wrapper classes
around these types.`,Wo,Ht,Vs=`The wrapped objects should continue behaving as initially; a text object should still behave as a string, an image
object should still behave as a <code>PIL.Image</code>.`,So,Ut,Os="These types have three specific purposes:",Vo,Bt,zs=`<li>Calling <code>to_raw</code> on the type should return the underlying object</li> <li>Calling <code>to_string</code> on the type should return the object as a string: that can be the string in case of an <code>AgentText</code>
but will be the path of the serialized version of the object in other instances</li> <li>Displaying it in an ipython kernel should display the object correctly</li>`,Oo,Dt,zo,Q,Rt,Ur,On,Gs="Text type returned by the agent. Behaves as a string.",Go,Wt,Zo,H,St,Br,zn,Zs="Image type returned by the agent. Behaves as a PIL.Image.",Dr,Te,Vt,Rr,Gn,Ys="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",Wr,xe,Ot,Sr,Zn,Fs=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,Yo,zt,Fo,U,Gt,Vr,Yn,Qs="Audio type returned by the agent.",Or,ke,Zt,zr,Fn,Xs="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Gr,Ce,Yt,Zr,Qn,Ks=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,Qo,Ft,Xo,ro,Ko;return T=new j({props:{title:"Agents & Tools",local:"agents--tools",headingTag:"h1"}}),C=new Yr({props:{warning:!0,$$slots:{default:[ll]},$$scope:{ctx:L}}}),Pe=new j({props:{title:"Agents",local:"agents",headingTag:"h2"}}),Ne=new j({props:{title:"Agent",local:"transformers.Agent",headingTag:"h3"}}),He=new y({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"tools",val:": Union"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfEngine object at 0x7f1a06cb53f0>"},{name:"system_prompt",val:` = 'You will be given a task to solve as best you can. You have access to the following tools:\\n<<tool_descriptions>>\\n\\nThe way you use the tools is by specifying a json blob.\\nSpecifically, this json should have a \`action\` key (name of the tool to use) and a \`action_input\` key (input to the tool).\\n\\nThe $ACTION_JSON_BLOB should only contain a SINGLE action, do NOT return a list of multiple actions. It should be formatted in json. Do not try to escape special characters. Here is the template of a valid $ACTION_JSON_BLOB:\\nAction:\\n{\\n  "action": $TOOL_NAME,\\n  "action_input": $INPUT\\n}\\n\\nMake sure to have the $INPUT as a dictionnary in the right format for the tool you are using, and do not put variable names as input if you can find the right values.\\n\\nYou will be given:\\n\\nTask: the task you are given.\\n\\nYou should ALWAYS use the following format:\\n\\nThought: you should always think about one action to take. Then use the action as follows:\\nAction:\\n$ACTION_JSON_BLOB\\nObservation: the result of the action\\n... (this Thought/Action/Observation can repeat N times, you should take several steps when needed. The $ACTION_JSON_BLOB must only use a SINGLE action at a time.)\\n\\nYou can use the result of the previous action as input for the next action.\\nThe observation will always be a string: it can represent a file, like "image_1.jpg".\\nThen you can use it as input for the next action. You can do it for instance as follows:\\n\\nObservation: "image_1.jpg"\\n\\nThought: I need to transform the image that I received in the previous observation to make it green.\\nAction:\\n{\\n  "action": "image_transformer",\\n  "action_input": {"image": "image_1.jpg"}\\n}\\n\\nTo provide the final answer to the task, use an action blob with "action": "final_answer" tool. It is the only way to complete the task, else you will be stuck on a loop. So your final output should look like this:\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": {"answer": "insert your final answer here"}\\n}\\n\\n\\nHere are a few examples using notional tools:\\n---\\nTask: "Generate an image of the oldest person in this document."\\n\\nThought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.\\nAction:\\n{\\n  "action": "document_qa",\\n  "action_input": {"document": "document.pdf", "question": "Who is the oldest person mentioned?"}\\n}\\nObservation: "The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland."\\n\\n\\nThought: I will now generate an image showcasing the oldest person.\\nAction:\\n{\\n  "action": "image_generator",\\n  "action_input": {"text": ""A portrait of John Doe, a 55-year-old man living in Canada.""}\\n}\\nObservation: "image.png"\\n\\nThought: I will now return the generated image.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "image.png"\\n}\\n\\n---\\nTask: "What is the result of the following operation: 5 + 3 + 1294.678?"\\n\\nThought: I will use python code evaluator to compute the result of the operation and then return the final answer using the \`final_answer\` tool\\nAction:\\n{\\n    "action": "python_interpreter",\\n    "action_input": {"code": "5 + 3 + 1294.678"}\\n}\\nObservation: 1302.678\\n\\nThought: Now that I know the result, I will now return it.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "1302.678"\\n}\\n\\n---\\nTask: "Which city has the highest population , Guangzhou or Shanghai?"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Guangzhou"\\n}\\nObservation: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\n\\n\\nThought: Now let\\'s get the population of Shanghai using the tool \\'search\\'.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Shanghai"\\n}\\nObservation: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has a larger population. Let\\'s return the result.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "Shanghai"\\n}\\n\\n\\nAbove example were using notional tools that might not exist for you. You only have acces to those tools:\\n<<tool_names>>\\nALWAYS provide a \\'Thought:\\' and an \\'Action:\\' sequence. You MUST provide at least the \\'Action:\\' sequence to move forward.\\n\\nNow begin!\\n'`},{name:"tool_description_template",val:" = None"},{name:"additional_args",val:" = {}"},{name:"max_iterations",val:": int = 6"},{name:"tool_parser",val:" = <function parse_json_tool_call at 0x7f1a06eadf30>"},{name:"add_base_tools",val:": bool = False"},{name:"verbose",val:": int = 0"},{name:"memory_verbose",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L294"}}),Ue=new y({props:{name:"execute_tool_call",anchor:"transformers.Agent.execute_tool_call",parameters:[{name:"tool_name",val:": str"},{name:"arguments",val:": Dict"}],parametersDescription:[{anchor:"transformers.Agent.execute_tool_call.tool_name",description:"<strong>tool_name</strong> (<code>str</code>) &#x2014; Name of the Tool to execute (shoulde be one from self.toolbox).",name:"tool_name"},{anchor:"transformers.Agent.execute_tool_call.arguments",description:"<strong>arguments</strong> (Dict[str, str]) &#x2014; Arguments passed to the Tool.",name:"arguments"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L433"}}),Be=new y({props:{name:"extract_action",anchor:"transformers.Agent.extract_action",parameters:[{name:"llm_output",val:": str"},{name:"split_token",val:": str"}],parametersDescription:[{anchor:"transformers.Agent.extract_action.llm_output",description:"<strong>llm_output</strong> (<code>str</code>) &#x2014; Output of the LLM",name:"llm_output"},{anchor:"transformers.Agent.extract_action.split_token",description:"<strong>split_token</strong> (<code>str</code>) &#x2014; Separator for the action. Should match the example in the system prompt.",name:"split_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L412"}}),De=new y({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L473"}}),Re=new y({props:{name:"write_inner_memory_from_logs",anchor:"transformers.Agent.write_inner_memory_from_logs",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L363"}}),We=new j({props:{title:"CodeAgent",local:"transformers.CodeAgent",headingTag:"h3"}}),Se=new y({props:{name:"class transformers.CodeAgent",anchor:"transformers.CodeAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfEngine object at 0x7f1a06cb5630>"},{name:"system_prompt",val:': str = \'You will be given a task to solve, your job is to come up with a series of simple commands in Python that will perform the task.\\nTo help you, I will give you access to a set of tools that you can use. Each tool is a Python function and has a description explaining the task it performs, the inputs it expects and the outputs it returns.\\nYou should first explain which tool you will use to perform the task and for what reason, then write the code in Python.\\nEach instruction in Python should be a simple assignment. You can print intermediate results if it makes sense to do so.\\nBe sure to provide a \\\'Code:\\\' token, else the system will be stuck in a loop.\\n\\nTools:\\n<<tool_descriptions>>\\n\\nExamples:\\n---\\nTask: "Answer the question in the variable `question` about the image stored in the variable `image`. The question is in French."\\n\\nI will use the following tools: `translator` to translate the question into English and then `image_qa` to answer the question on the input image.\\nCode:\\n```py\\ntranslated_question = translator(question=question, src_lang="French", tgt_lang="English")\\nprint(f"The translated question is {translated_question}.")\\nanswer = image_qa(image=image, question=translated_question)\\nprint(f"The answer is {answer}")\\n```<end_code>\\n\\n---\\nTask: "Identify the oldest person in the `document` and create an image showcasing the result."\\n\\nI will use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document, question="What is the oldest person?")\\nprint(f"The answer is {answer}.")\\nimage = image_generator(answer)\\n```<end_code>\\n\\n---\\nTask: "Generate an image using the text given in the variable `caption`."\\n\\nI will use the following tool: `image_generator` to generate an image.\\nCode:\\n```py\\nimage = image_generator(prompt=caption)\\n```<end_code>\\n\\n---\\nTask: "Summarize the text given in the variable `text` and read it out loud."\\n\\nI will use the following tools: `summarizer` to create a summary of the input text, then `text_reader` to read it out loud.\\nCode:\\n```py\\nsummarized_text = summarizer(text)\\nprint(f"Summary: {summarized_text}")\\naudio_summary = text_reader(summarized_text)\\n```<end_code>\\n\\n---\\nTask: "Answer the question in the variable `question` about the text in the variable `text`. Use the answer to generate an image."\\n\\nI will use the following tools: `text_qa` to create the answer, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = text_qa(text=text, question=question)\\nprint(f"The answer is {answer}.")\\nimage = image_generator(answer)\\n```<end_code>\\n\\n---\\nTask: "Caption the following `image`."\\n\\nI will use the following tool: `image_captioner` to generate a caption for the image.\\nCode:\\n```py\\ncaption = image_captioner(image)\\n```<end_code>\\n\\n---\\nAbove example were using tools that might not exist for you. You only have acces to those Tools:\\n<<tool_names>>\\n\\nRemember to make sure that variables you use are all defined.\\nBe sure to provide a \\\'Code:\\n```\\\' sequence before the code and \\\'```<end_code>\\\' after, else you will get an error.\\nDO NOT pass the arguments as a dict as in \\\'answer = ask_search_agent({\\\'query\\\': "What is the place where James Bond lives?"})\\\', but use the arguments directly as in \\\'answer = ask_search_agent(query="What is the place where James Bond lives?")\\\'.\\n\\nNow Begin!\\n\''},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L478"}}),Ve=new y({props:{name:"parse_code_blob",anchor:"transformers.CodeAgent.parse_code_blob",parameters:[{name:"result",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L508"}}),Oe=new y({props:{name:"run",anchor:"transformers.CodeAgent.run",parameters:[{name:"task",val:": str"},{name:"return_generated_code",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeAgent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.CodeAgent.run.return_generated_code",description:"<strong>return_generated_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to return the generated code instead of running it",name:"return_generated_code"},{anchor:"transformers.CodeAgent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L515"}}),oe=new $a({props:{anchor:"transformers.CodeAgent.run.example",$$slots:{default:[il]},$$scope:{ctx:L}}}),ze=new j({props:{title:"React agents",local:"transformers.ReactAgent",headingTag:"h3"}}),Ge=new y({props:{name:"class transformers.ReactAgent",anchor:"transformers.ReactAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfEngine object at 0x7f1a06cb57e0>"},{name:"system_prompt",val:": str = 'You will be given a task to solve as best you can.\\nYou have access to the following tools:\\n<<tool_descriptions>>\\n\\nTo solve the task, you must plan forward to proceed in a series of steps, in a cycle of \\'Thought:\\', \\'Code:\\', and \\'Observation:\\' sequences.\\n\\nAt each step, in the \\'Thought:\\' sequence, you should first explain your reasoning towards solving the task, then the tools that you want to use.\\nThen in the \\'Code:\\' sequence, you shold write the code in simple Python. The code sequence must end with \\'/End code\\' sequence.\\nDuring each intermediate step, you can use \\'print()\\' to save whatever important information you will then need.\\nThese print outputs will then be available in the \\'Observation:\\' field, for using this information as input for the next step.\\n\\nIn the end you have to return a final answer using the `final_answer` tool.\\n\\nHere are a few examples using notional tools:\\n---\\nTask: \"Generate an image of the oldest person in this document.\"\\n\\nThought: I will proceed step by step and use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document=document, question=\"Who is the oldest person mentioned?\")\\nprint(answer)\\n```<end_code>\\nObservation: \"The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.\"\\n\\nThought: I will now generate an image showcasing the oldest person.\\n\\nCode:\\n```py\\nimage = image_generator(\"A portrait of John Doe, a 55-year-old man living in Canada.\")\\nfinal_answer(image)\\n```<end_code>\\n\\n---\\nTask: \"What is the result of the following operation: 5 + 3 + 1294.678?\"\\n\\nThought: I will use python code to compute the result of the operation and then return the final answer using the `final_answer` tool\\n\\nCode:\\n```py\\nresult = 5 + 3 + 1294.678\\nfinal_answer(result)\\n```<end_code>\\n\\n---\\nTask: \"Which city has the highest population , Guangzhou or Shanghai?\"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool `search` to get the population of both cities.\\nCode:\\n```py\\npopulation_guangzhou = search(\"Guangzhou population\")\\nprint(\"Population Guangzhou:\", population_guangzhou)\\npopulation_shanghai = search(\"Shanghai population\")\\nprint(\"Population Shanghai:\", population_shanghai)\\n```<end_code>\\nObservation:\\nPopulation Guangzhou: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\nPopulation Shanghai: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has the highest population.\\nCode:\\n```py\\nfinal_answer(\"Shanghai\")\\n```<end_code>\\n\\n---\\nTask: \"What is the current age of the pope, raised to the power 0.36?\"\\n\\nThought: I will use the tool `search` to get the age of the pope, then raise it to the power 0.36.\\nCode:\\n```py\\npope_age = search(query=\"current pope age\")\\nprint(\"Pope age:\", pope_age)\\n```<end_code>\\nObservation:\\nPope age: \"The pope Francis is currently 85 years old.\"\\n\\nThought: I know that the pope is 85 years old. Let\\'s compute the result using python code.\\nCode:\\n```py\\npope_current_age = 85 ** 0.36\\nfinal_answer(pope_current_age)\\n```<end_code>\\n\\n\\nAbove example were using notional tools that might not exist for you. You only have acces to those tools:\\n<<tool_names>>\\nYou also can perform computations in the python code you generate.\\n\\nAlways provide a \\'Thought:\\' and a \\'Code:\\n```py\\' sequence ending with \\'```<end_code>\\' sequence. You MUST provide at least the \\'Code:\\' sequence to move forward.\\n\\nRemember to not perform too many operations in a single code block! You should split the task into intermediate code blocks.\\nPrint results at the end of each step to save the intermediate results. Then use final_answer() to return the final result.\\n\\nRemember to make sure that variables you use are all defined.\\nDO NOT pass the arguments as a dict as in \\'answer = ask_search_agent({\\'query\\': \"What is the place where James Bond lives?\"})\\', but use the arguments directly as in \\'answer = ask_search_agent(query=\"What is the place where James Bond lives?\")\\'.\\n\\nNow Begin!\\n'"},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L575"}}),Ze=new y({props:{name:"run",anchor:"transformers.ReactAgent.run",parameters:[{name:"task",val:": str"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReactAgent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L600"}}),ae=new $a({props:{anchor:"transformers.ReactAgent.run.example",$$slots:{default:[dl]},$$scope:{ctx:L}}}),Ye=new y({props:{name:"class transformers.ReactJsonAgent",anchor:"transformers.ReactJsonAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfEngine object at 0x7f1a06cb5990>"},{name:"system_prompt",val:`: str = 'You will be given a task to solve as best you can. You have access to the following tools:\\n<<tool_descriptions>>\\n\\nThe way you use the tools is by specifying a json blob.\\nSpecifically, this json should have a \`action\` key (name of the tool to use) and a \`action_input\` key (input to the tool).\\n\\nThe $ACTION_JSON_BLOB should only contain a SINGLE action, do NOT return a list of multiple actions. It should be formatted in json. Do not try to escape special characters. Here is the template of a valid $ACTION_JSON_BLOB:\\nAction:\\n{\\n  "action": $TOOL_NAME,\\n  "action_input": $INPUT\\n}\\n\\nMake sure to have the $INPUT as a dictionnary in the right format for the tool you are using, and do not put variable names as input if you can find the right values.\\n\\nYou will be given:\\n\\nTask: the task you are given.\\n\\nYou should ALWAYS use the following format:\\n\\nThought: you should always think about one action to take. Then use the action as follows:\\nAction:\\n$ACTION_JSON_BLOB\\nObservation: the result of the action\\n... (this Thought/Action/Observation can repeat N times, you should take several steps when needed. The $ACTION_JSON_BLOB must only use a SINGLE action at a time.)\\n\\nYou can use the result of the previous action as input for the next action.\\nThe observation will always be a string: it can represent a file, like "image_1.jpg".\\nThen you can use it as input for the next action. You can do it for instance as follows:\\n\\nObservation: "image_1.jpg"\\n\\nThought: I need to transform the image that I received in the previous observation to make it green.\\nAction:\\n{\\n  "action": "image_transformer",\\n  "action_input": {"image": "image_1.jpg"}\\n}\\n\\nTo provide the final answer to the task, use an action blob with "action": "final_answer" tool. It is the only way to complete the task, else you will be stuck on a loop. So your final output should look like this:\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": {"answer": "insert your final answer here"}\\n}\\n\\n\\nHere are a few examples using notional tools:\\n---\\nTask: "Generate an image of the oldest person in this document."\\n\\nThought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.\\nAction:\\n{\\n  "action": "document_qa",\\n  "action_input": {"document": "document.pdf", "question": "Who is the oldest person mentioned?"}\\n}\\nObservation: "The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland."\\n\\n\\nThought: I will now generate an image showcasing the oldest person.\\nAction:\\n{\\n  "action": "image_generator",\\n  "action_input": {"text": ""A portrait of John Doe, a 55-year-old man living in Canada.""}\\n}\\nObservation: "image.png"\\n\\nThought: I will now return the generated image.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "image.png"\\n}\\n\\n---\\nTask: "What is the result of the following operation: 5 + 3 + 1294.678?"\\n\\nThought: I will use python code evaluator to compute the result of the operation and then return the final answer using the \`final_answer\` tool\\nAction:\\n{\\n    "action": "python_interpreter",\\n    "action_input": {"code": "5 + 3 + 1294.678"}\\n}\\nObservation: 1302.678\\n\\nThought: Now that I know the result, I will now return it.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "1302.678"\\n}\\n\\n---\\nTask: "Which city has the highest population , Guangzhou or Shanghai?"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Guangzhou"\\n}\\nObservation: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\n\\n\\nThought: Now let\\'s get the population of Shanghai using the tool \\'search\\'.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Shanghai"\\n}\\nObservation: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has a larger population. Let\\'s return the result.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "Shanghai"\\n}\\n\\n\\nAbove example were using notional tools that might not exist for you. You only have acces to those tools:\\n<<tool_names>>\\nALWAYS provide a \\'Thought:\\' and an \\'Action:\\' sequence. You MUST provide at least the \\'Action:\\' sequence to move forward.\\n\\nNow begin!\\n'`},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L656"}}),Fe=new y({props:{name:"step",anchor:"transformers.ReactJsonAgent.step",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L679"}}),Qe=new y({props:{name:"class transformers.ReactCodeAgent",anchor:"transformers.ReactCodeAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfEngine object at 0x7f1a06cb5b40>"},{name:"system_prompt",val:": str = 'You will be given a task to solve as best you can.\\nYou have access to the following tools:\\n<<tool_descriptions>>\\n\\nTo solve the task, you must plan forward to proceed in a series of steps, in a cycle of \\'Thought:\\', \\'Code:\\', and \\'Observation:\\' sequences.\\n\\nAt each step, in the \\'Thought:\\' sequence, you should first explain your reasoning towards solving the task, then the tools that you want to use.\\nThen in the \\'Code:\\' sequence, you shold write the code in simple Python. The code sequence must end with \\'/End code\\' sequence.\\nDuring each intermediate step, you can use \\'print()\\' to save whatever important information you will then need.\\nThese print outputs will then be available in the \\'Observation:\\' field, for using this information as input for the next step.\\n\\nIn the end you have to return a final answer using the `final_answer` tool.\\n\\nHere are a few examples using notional tools:\\n---\\nTask: \"Generate an image of the oldest person in this document.\"\\n\\nThought: I will proceed step by step and use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document=document, question=\"Who is the oldest person mentioned?\")\\nprint(answer)\\n```<end_code>\\nObservation: \"The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.\"\\n\\nThought: I will now generate an image showcasing the oldest person.\\n\\nCode:\\n```py\\nimage = image_generator(\"A portrait of John Doe, a 55-year-old man living in Canada.\")\\nfinal_answer(image)\\n```<end_code>\\n\\n---\\nTask: \"What is the result of the following operation: 5 + 3 + 1294.678?\"\\n\\nThought: I will use python code to compute the result of the operation and then return the final answer using the `final_answer` tool\\n\\nCode:\\n```py\\nresult = 5 + 3 + 1294.678\\nfinal_answer(result)\\n```<end_code>\\n\\n---\\nTask: \"Which city has the highest population , Guangzhou or Shanghai?\"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool `search` to get the population of both cities.\\nCode:\\n```py\\npopulation_guangzhou = search(\"Guangzhou population\")\\nprint(\"Population Guangzhou:\", population_guangzhou)\\npopulation_shanghai = search(\"Shanghai population\")\\nprint(\"Population Shanghai:\", population_shanghai)\\n```<end_code>\\nObservation:\\nPopulation Guangzhou: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\nPopulation Shanghai: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has the highest population.\\nCode:\\n```py\\nfinal_answer(\"Shanghai\")\\n```<end_code>\\n\\n---\\nTask: \"What is the current age of the pope, raised to the power 0.36?\"\\n\\nThought: I will use the tool `search` to get the age of the pope, then raise it to the power 0.36.\\nCode:\\n```py\\npope_age = search(query=\"current pope age\")\\nprint(\"Pope age:\", pope_age)\\n```<end_code>\\nObservation:\\nPope age: \"The pope Francis is currently 85 years old.\"\\n\\nThought: I know that the pope is 85 years old. Let\\'s compute the result using python code.\\nCode:\\n```py\\npope_current_age = 85 ** 0.36\\nfinal_answer(pope_current_age)\\n```<end_code>\\n\\n\\nAbove example were using notional tools that might not exist for you. You only have acces to those tools:\\n<<tool_names>>\\nYou also can perform computations in the python code you generate.\\n\\nAlways provide a \\'Thought:\\' and a \\'Code:\\n```py\\' sequence ending with \\'```<end_code>\\' sequence. You MUST provide at least the \\'Code:\\' sequence to move forward.\\n\\nRemember to not perform too many operations in a single code block! You should split the task into intermediate code blocks.\\nPrint results at the end of each step to save the intermediate results. Then use final_answer() to return the final result.\\n\\nRemember to make sure that variables you use are all defined.\\nDO NOT pass the arguments as a dict as in \\'answer = ask_search_agent({\\'query\\': \"What is the place where James Bond lives?\"})\\', but use the arguments directly as in \\'answer = ask_search_agent(query=\"What is the place where James Bond lives?\")\\'.\\n\\nNow Begin!\\n'"},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L747"}}),Xe=new y({props:{name:"step",anchor:"transformers.ReactCodeAgent.step",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L779"}}),Ke=new j({props:{title:"Tools",local:"tools",headingTag:"h2"}}),et=new j({props:{title:"load_tool",local:"transformers.load_tool",headingTag:"h3"}}),tt=new y({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document-question-answering&quot;</code></li>
<li><code>&quot;image-question-answering&quot;</code></li>
<li><code>&quot;speech-to-text&quot;</code></li>
<li><code>&quot;text-to-speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L661"}}),le=new Yr({props:{warning:!0,$$slots:{default:[ml]},$$scope:{ctx:L}}}),nt=new j({props:{title:"Tool",local:"transformers.Tool",headingTag:"h3"}}),ot=new y({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L91"}}),at=new y({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L377"}}),rt=new y({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L208"}}),de=new Yr({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:L}}}),st=new y({props:{name:"from_langchain",anchor:"transformers.Tool.from_langchain",parameters:[{name:"langchain_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L399"}}),lt=new y({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L320"}}),ce=new $a({props:{anchor:"transformers.Tool.push_to_hub.example",$$slots:{default:[pl]},$$scope:{ctx:L}}}),it=new y({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L148"}}),dt=new y({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L141"}}),mt=new j({props:{title:"Toolbox",local:"transformers.Toolbox",headingTag:"h3"}}),ct=new y({props:{name:"class transformers.Toolbox",anchor:"transformers.Toolbox",parameters:[{name:"tools",val:": List"},{name:"add_base_tools",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Toolbox.tools",description:`<strong>tools</strong> (<code>List[Tool]</code>) &#x2014;
The list of tools to instantiate the toolbox with`,name:"tools"},{anchor:"transformers.Toolbox.add_base_tools",description:`<strong>add_base_tools</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add the tools available within <code>transformers</code> to the toolbox.`,name:"add_base_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L150"}}),pt=new y({props:{name:"add_tool",anchor:"transformers.Toolbox.add_tool",parameters:[{name:"tool",val:": Tool"}],parametersDescription:[{anchor:"transformers.Toolbox.add_tool.tool",description:`<strong>tool</strong> (<code>Tool</code>) &#x2014;
The tool to add to the toolbox.`,name:"tool"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L196"}}),gt=new y({props:{name:"clear_toolbox",anchor:"transformers.Toolbox.clear_toolbox",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L236"}}),ht=new y({props:{name:"remove_tool",anchor:"transformers.Toolbox.remove_tool",parameters:[{name:"tool_name",val:": str"}],parametersDescription:[{anchor:"transformers.Toolbox.remove_tool.tool_name",description:`<strong>tool_name</strong> (<code>str</code>) &#x2014;
The tool to remove from the toolbox.`,name:"tool_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L208"}}),ut=new y({props:{name:"show_tool_descriptions",anchor:"transformers.Toolbox.show_tool_descriptions",parameters:[{name:"tool_description_template",val:": str = None"}],parametersDescription:[{anchor:"transformers.Toolbox.show_tool_descriptions.tool_description_template",description:`<strong>tool_description_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The template to use to describe the tools. If not provided, the default template will be used.`,name:"tool_description_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L184"}}),ft=new y({props:{name:"update_tool",anchor:"transformers.Toolbox.update_tool",parameters:[{name:"tool",val:": Tool"}],parametersDescription:[{anchor:"transformers.Toolbox.update_tool.tool",description:`<strong>tool</strong> (<code>Tool</code>) &#x2014;
The tool to update to the toolbox.`,name:"tool"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L222"}}),bt=new j({props:{title:"PipelineTool",local:"transformers.PipelineTool",headingTag:"h3"}}),_t=new y({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L459"}}),vt=new y({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L582"}}),$t=new y({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L569"}}),yt=new y({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L575"}}),wt=new y({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L543"}}),Tt=new j({props:{title:"launch_gradio_demo",local:"transformers.launch_gradio_demo",headingTag:"h3"}}),xt=new y({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L607"}}),kt=new j({props:{title:"ToolCollection",local:"transformers.ToolCollection",headingTag:"h3"}}),Ct=new y({props:{name:"class transformers.ToolCollection",anchor:"transformers.ToolCollection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ToolCollection.collection_slug",description:`<strong>collection_slug</strong> (str) &#x2014;
The collection slug referencing the collection.`,name:"collection_slug"},{anchor:"transformers.ToolCollection.token",description:`<strong>token</strong> (str, <em>optional</em>) &#x2014;
The authentication token if the collection is private.`,name:"token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L785"}}),we=new $a({props:{anchor:"transformers.ToolCollection.example",$$slots:{default:[gl]},$$scope:{ctx:L}}}),Mt=new j({props:{title:"Engines",local:"engines",headingTag:"h2"}}),jt=new j({props:{title:"HfEngine",local:"transformers.HfEngine",headingTag:"h3"}}),qt=new so({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmRW5naW5lJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTm8lMjBuZWVkJTIwdG8lMjBoZWxwJTJDJTIwdGFrZSUyMGl0JTIwZWFzeS4lMjIlN0QlMkMlMEElNUQlMEElMEFIZkVuZ2luZSgpKG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfEngine

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;No need to help, take it easy.&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>HfEngine()(messages, stop_sequences=[<span class="hljs-string">&quot;conversation&quot;</span>])

<span class="hljs-string">&quot;That&#x27;s very kind of you to say! It&#x27;s always nice to have a relaxed &quot;</span>`,wrap:!1}}),Jt=new y({props:{name:"class transformers.HfEngine",anchor:"transformers.HfEngine",parameters:[{name:"model",val:": str = 'meta-llama/Meta-Llama-3-8B-Instruct'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/llm_engine.py#L69"}}),Et=new j({props:{title:"Agent Types",local:"agent-types",headingTag:"h2"}}),Dt=new j({props:{title:"AgentText",local:"transformers.agents.agent_types.AgentText",headingTag:"h3"}}),Rt=new y({props:{name:"class transformers.agents.agent_types.AgentText",anchor:"transformers.agents.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L73"}}),Wt=new j({props:{title:"AgentImage",local:"transformers.agents.agent_types.AgentImage",headingTag:"h3"}}),St=new y({props:{name:"class transformers.agents.agent_types.AgentImage",anchor:"transformers.agents.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L85"}}),Vt=new y({props:{name:"to_raw",anchor:"transformers.agents.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L117"}}),Ot=new y({props:{name:"to_string",anchor:"transformers.agents.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L128"}}),zt=new j({props:{title:"AgentAudio",local:"transformers.agents.agent_types.AgentAudio",headingTag:"h3"}}),Gt=new y({props:{name:"class transformers.agents.agent_types.AgentAudio",anchor:"transformers.agents.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L157"}}),Zt=new y({props:{name:"to_raw",anchor:"transformers.agents.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L188"}}),Yt=new y({props:{name:"to_string",anchor:"transformers.agents.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L200"}}),Ft=new sl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/agent.md"}}),{c(){u=s("meta"),x=n(),$=s("p"),w=n(),d(T.$$.fragment),b=n(),d(C.$$.fragment),lo=n(),qe=s("p"),qe.innerHTML=Fr,io=n(),d(Pe.$$.fragment),mo=n(),Je=s("p"),Je.innerHTML=Qr,co=n(),Ee=s("ul"),Ee.innerHTML=Xr,po=n(),d(Ne.$$.fragment),go=n(),q=s("div"),d(He.$$.fragment),ya=n(),X=s("div"),d(Ue.$$.fragment),wa=n(),on=s("p"),on.textContent=Kr,Ta=n(),K=s("div"),d(Be.$$.fragment),xa=n(),an=s("p"),an.textContent=es,ka=n(),ee=s("div"),d(De.$$.fragment),Ca=n(),rn=s("p"),rn.textContent=ts,Ma=n(),te=s("div"),d(Re.$$.fragment),Ia=n(),sn=s("p"),sn.textContent=ns,ho=n(),d(We.$$.fragment),uo=n(),E=s("div"),d(Se.$$.fragment),Aa=n(),ln=s("p"),ln.textContent=os,ja=n(),ne=s("div"),d(Ve.$$.fragment),La=n(),dn=s("p"),dn.innerHTML=as,qa=n(),G=s("div"),d(Oe.$$.fragment),Pa=n(),mn=s("p"),mn.textContent=rs,Ja=n(),d(oe.$$.fragment),fo=n(),d(ze.$$.fragment),bo=n(),W=s("div"),d(Ge.$$.fragment),Ea=n(),cn=s("p"),cn.textContent=ss,Na=n(),Z=s("div"),d(Ze.$$.fragment),Ha=n(),pn=s("p"),pn.textContent=ls,Ua=n(),d(ae.$$.fragment),_o=n(),S=s("div"),d(Ye.$$.fragment),Ba=n(),gn=s("p"),gn.textContent=is,Da=n(),re=s("div"),d(Fe.$$.fragment),Ra=n(),hn=s("p"),hn.textContent=ds,vo=n(),V=s("div"),d(Qe.$$.fragment),Wa=n(),un=s("p"),un.textContent=ms,Sa=n(),se=s("div"),d(Xe.$$.fragment),Va=n(),fn=s("p"),fn.textContent=cs,$o=n(),d(Ke.$$.fragment),yo=n(),d(et.$$.fragment),wo=n(),O=s("div"),d(tt.$$.fragment),Oa=n(),bn=s("p"),bn.textContent=ps,za=n(),d(le.$$.fragment),To=n(),d(nt.$$.fragment),xo=n(),k=s("div"),d(ot.$$.fragment),Ga=n(),_n=s("p"),_n.innerHTML=gs,Za=n(),vn=s("ul"),vn.innerHTML=hs,Ya=n(),$n=s("p"),$n.innerHTML=us,Fa=n(),ie=s("div"),d(at.$$.fragment),Qa=n(),yn=s("p"),yn.innerHTML=fs,Xa=n(),Y=s("div"),d(rt.$$.fragment),Ka=n(),wn=s("p"),wn.textContent=bs,er=n(),d(de.$$.fragment),tr=n(),me=s("div"),d(st.$$.fragment),nr=n(),Tn=s("p"),Tn.innerHTML=_s,or=n(),D=s("div"),d(lt.$$.fragment),ar=n(),xn=s("p"),xn.textContent=vs,rr=n(),kn=s("p"),kn.innerHTML=$s,sr=n(),d(ce.$$.fragment),lr=n(),R=s("div"),d(it.$$.fragment),ir=n(),Cn=s("p"),Cn.innerHTML=ys,dr=n(),Mn=s("ul"),Mn.innerHTML=ws,mr=n(),In=s("p"),In.innerHTML=Ts,cr=n(),pe=s("div"),d(dt.$$.fragment),pr=n(),An=s("p"),An.textContent=xs,ko=n(),d(mt.$$.fragment),Co=n(),I=s("div"),d(ct.$$.fragment),gr=n(),jn=s("p"),jn.textContent=ks,hr=n(),ge=s("div"),d(pt.$$.fragment),ur=n(),Ln=s("p"),Ln.textContent=Cs,fr=n(),he=s("div"),d(gt.$$.fragment),br=n(),qn=s("p"),qn.textContent=Ms,_r=n(),ue=s("div"),d(ht.$$.fragment),vr=n(),Pn=s("p"),Pn.textContent=Is,$r=n(),fe=s("div"),d(ut.$$.fragment),yr=n(),Jn=s("p"),Jn.textContent=As,wr=n(),be=s("div"),d(ft.$$.fragment),Tr=n(),En=s("p"),En.textContent=js,Mo=n(),d(bt.$$.fragment),Io=n(),A=s("div"),d(_t.$$.fragment),xr=n(),Nn=s("p"),Nn.innerHTML=Ls,kr=n(),Hn=s("ul"),Hn.innerHTML=qs,Cr=n(),_e=s("div"),d(vt.$$.fragment),Mr=n(),Un=s("p"),Un.innerHTML=Ps,Ir=n(),ve=s("div"),d($t.$$.fragment),Ar=n(),Bn=s("p"),Bn.innerHTML=Js,jr=n(),$e=s("div"),d(yt.$$.fragment),Lr=n(),Dn=s("p"),Dn.innerHTML=Es,qr=n(),ye=s("div"),d(wt.$$.fragment),Pr=n(),Rn=s("p"),Rn.innerHTML=Ns,Ao=n(),d(Tt.$$.fragment),jo=n(),F=s("div"),d(xt.$$.fragment),Jr=n(),Wn=s("p"),Wn.innerHTML=Hs,Lo=n(),d(kt.$$.fragment),qo=n(),N=s("div"),d(Ct.$$.fragment),Er=n(),Sn=s("p"),Sn.textContent=Us,Nr=n(),Vn=s("blockquote"),Vn.innerHTML=Bs,Hr=n(),d(we.$$.fragment),Po=n(),d(Mt.$$.fragment),Jo=n(),It=s("p"),It.textContent=Ds,Eo=n(),At=s("ol"),At.innerHTML=Rs,No=n(),d(jt.$$.fragment),Ho=n(),Lt=s("p"),Lt.innerHTML=Ws,Uo=n(),d(qt.$$.fragment),Bo=n(),Pt=s("div"),d(Jt.$$.fragment),Do=n(),d(Et.$$.fragment),Ro=n(),Nt=s("p"),Nt.textContent=Ss,Wo=n(),Ht=s("p"),Ht.innerHTML=Vs,So=n(),Ut=s("p"),Ut.textContent=Os,Vo=n(),Bt=s("ul"),Bt.innerHTML=zs,Oo=n(),d(Dt.$$.fragment),zo=n(),Q=s("div"),d(Rt.$$.fragment),Ur=n(),On=s("p"),On.textContent=Gs,Go=n(),d(Wt.$$.fragment),Zo=n(),H=s("div"),d(St.$$.fragment),Br=n(),zn=s("p"),zn.textContent=Zs,Dr=n(),Te=s("div"),d(Vt.$$.fragment),Rr=n(),Gn=s("p"),Gn.textContent=Ys,Wr=n(),xe=s("div"),d(Ot.$$.fragment),Sr=n(),Zn=s("p"),Zn.textContent=Fs,Yo=n(),d(zt.$$.fragment),Fo=n(),U=s("div"),d(Gt.$$.fragment),Vr=n(),Yn=s("p"),Yn.textContent=Qs,Or=n(),ke=s("div"),d(Zt.$$.fragment),zr=n(),Fn=s("p"),Fn.innerHTML=Xs,Gr=n(),Ce=s("div"),d(Yt.$$.fragment),Zr=n(),Qn=s("p"),Qn.textContent=Ks,Qo=n(),d(Ft.$$.fragment),Xo=n(),ro=s("p"),this.h()},l(e){const r=rl("svelte-u9bgzb",document.head);u=l(r,"META",{name:!0,content:!0}),r.forEach(a),x=o(e),$=l(e,"P",{}),_($).forEach(a),w=o(e),m(T.$$.fragment,e),b=o(e),m(C.$$.fragment,e),lo=o(e),qe=l(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-7mj07q"&&(qe.innerHTML=Fr),io=o(e),m(Pe.$$.fragment,e),mo=o(e),Je=l(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-n8fmrj"&&(Je.innerHTML=Qr),co=o(e),Ee=l(e,"UL",{"data-svelte-h":!0}),f(Ee)!=="svelte-kxuq94"&&(Ee.innerHTML=Xr),po=o(e),m(Ne.$$.fragment,e),go=o(e),q=l(e,"DIV",{class:!0});var B=_(q);m(He.$$.fragment,B),ya=o(B),X=l(B,"DIV",{class:!0});var Qt=_(X);m(Ue.$$.fragment,Qt),wa=o(Qt),on=l(Qt,"P",{"data-svelte-h":!0}),f(on)!=="svelte-a91m64"&&(on.textContent=Kr),Qt.forEach(a),Ta=o(B),K=l(B,"DIV",{class:!0});var Xt=_(K);m(Be.$$.fragment,Xt),xa=o(Xt),an=l(Xt,"P",{"data-svelte-h":!0}),f(an)!=="svelte-104knry"&&(an.textContent=es),Xt.forEach(a),ka=o(B),ee=l(B,"DIV",{class:!0});var Kt=_(ee);m(De.$$.fragment,Kt),Ca=o(Kt),rn=l(Kt,"P",{"data-svelte-h":!0}),f(rn)!=="svelte-wvvftk"&&(rn.textContent=ts),Kt.forEach(a),Ma=o(B),te=l(B,"DIV",{class:!0});var en=_(te);m(Re.$$.fragment,en),Ia=o(en),sn=l(en,"P",{"data-svelte-h":!0}),f(sn)!=="svelte-1cw6633"&&(sn.textContent=ns),en.forEach(a),B.forEach(a),ho=o(e),m(We.$$.fragment,e),uo=o(e),E=l(e,"DIV",{class:!0});var z=_(E);m(Se.$$.fragment,z),Aa=o(z),ln=l(z,"P",{"data-svelte-h":!0}),f(ln)!=="svelte-rq8zg0"&&(ln.textContent=os),ja=o(z),ne=l(z,"DIV",{class:!0});var tn=_(ne);m(Ve.$$.fragment,tn),La=o(tn),dn=l(tn,"P",{"data-svelte-h":!0}),f(dn)!=="svelte-tvi94l"&&(dn.innerHTML=as),tn.forEach(a),qa=o(z),G=l(z,"DIV",{class:!0});var Xn=_(G);m(Oe.$$.fragment,Xn),Pa=o(Xn),mn=l(Xn,"P",{"data-svelte-h":!0}),f(mn)!=="svelte-tbr5ck"&&(mn.textContent=rs),Ja=o(Xn),m(oe.$$.fragment,Xn),Xn.forEach(a),z.forEach(a),fo=o(e),m(ze.$$.fragment,e),bo=o(e),W=l(e,"DIV",{class:!0});var Kn=_(W);m(Ge.$$.fragment,Kn),Ea=o(Kn),cn=l(Kn,"P",{"data-svelte-h":!0}),f(cn)!=="svelte-c95fji"&&(cn.textContent=ss),Na=o(Kn),Z=l(Kn,"DIV",{class:!0});var eo=_(Z);m(Ze.$$.fragment,eo),Ha=o(eo),pn=l(eo,"P",{"data-svelte-h":!0}),f(pn)!=="svelte-tbr5ck"&&(pn.textContent=ls),Ua=o(eo),m(ae.$$.fragment,eo),eo.forEach(a),Kn.forEach(a),_o=o(e),S=l(e,"DIV",{class:!0});var to=_(S);m(Ye.$$.fragment,to),Ba=o(to),gn=l(to,"P",{"data-svelte-h":!0}),f(gn)!=="svelte-1ip7q5f"&&(gn.textContent=is),Da=o(to),re=l(to,"DIV",{class:!0});var ea=_(re);m(Fe.$$.fragment,ea),Ra=o(ea),hn=l(ea,"P",{"data-svelte-h":!0}),f(hn)!=="svelte-1bbx2c8"&&(hn.textContent=ds),ea.forEach(a),to.forEach(a),vo=o(e),V=l(e,"DIV",{class:!0});var no=_(V);m(Qe.$$.fragment,no),Wa=o(no),un=l(no,"P",{"data-svelte-h":!0}),f(un)!=="svelte-1egm30q"&&(un.textContent=ms),Sa=o(no),se=l(no,"DIV",{class:!0});var ta=_(se);m(Xe.$$.fragment,ta),Va=o(ta),fn=l(ta,"P",{"data-svelte-h":!0}),f(fn)!=="svelte-1bbx2c8"&&(fn.textContent=cs),ta.forEach(a),no.forEach(a),$o=o(e),m(Ke.$$.fragment,e),yo=o(e),m(et.$$.fragment,e),wo=o(e),O=l(e,"DIV",{class:!0});var oo=_(O);m(tt.$$.fragment,oo),Oa=o(oo),bn=l(oo,"P",{"data-svelte-h":!0}),f(bn)!=="svelte-16uh3p8"&&(bn.textContent=ps),za=o(oo),m(le.$$.fragment,oo),oo.forEach(a),To=o(e),m(nt.$$.fragment,e),xo=o(e),k=l(e,"DIV",{class:!0});var M=_(k);m(ot.$$.fragment,M),Ga=o(M),_n=l(M,"P",{"data-svelte-h":!0}),f(_n)!=="svelte-cca4c5"&&(_n.innerHTML=gs),Za=o(M),vn=l(M,"UL",{"data-svelte-h":!0}),f(vn)!=="svelte-1cvtzkm"&&(vn.innerHTML=hs),Ya=o(M),$n=l(M,"P",{"data-svelte-h":!0}),f($n)!=="svelte-10s049q"&&($n.innerHTML=us),Fa=o(M),ie=l(M,"DIV",{class:!0});var na=_(ie);m(at.$$.fragment,na),Qa=o(na),yn=l(na,"P",{"data-svelte-h":!0}),f(yn)!=="svelte-548oc7"&&(yn.innerHTML=fs),na.forEach(a),Xa=o(M),Y=l(M,"DIV",{class:!0});var ao=_(Y);m(rt.$$.fragment,ao),Ka=o(ao),wn=l(ao,"P",{"data-svelte-h":!0}),f(wn)!=="svelte-yy7b2c"&&(wn.textContent=bs),er=o(ao),m(de.$$.fragment,ao),ao.forEach(a),tr=o(M),me=l(M,"DIV",{class:!0});var oa=_(me);m(st.$$.fragment,oa),nr=o(oa),Tn=l(oa,"P",{"data-svelte-h":!0}),f(Tn)!=="svelte-umcuss"&&(Tn.innerHTML=_s),oa.forEach(a),or=o(M),D=l(M,"DIV",{class:!0});var Me=_(D);m(lt.$$.fragment,Me),ar=o(Me),xn=l(Me,"P",{"data-svelte-h":!0}),f(xn)!=="svelte-1u3gku9"&&(xn.textContent=vs),rr=o(Me),kn=l(Me,"P",{"data-svelte-h":!0}),f(kn)!=="svelte-1yeagwn"&&(kn.innerHTML=$s),sr=o(Me),m(ce.$$.fragment,Me),Me.forEach(a),lr=o(M),R=l(M,"DIV",{class:!0});var Ie=_(R);m(it.$$.fragment,Ie),ir=o(Ie),Cn=l(Ie,"P",{"data-svelte-h":!0}),f(Cn)!=="svelte-19evuwa"&&(Cn.innerHTML=ys),dr=o(Ie),Mn=l(Ie,"UL",{"data-svelte-h":!0}),f(Mn)!=="svelte-15of9ze"&&(Mn.innerHTML=ws),mr=o(Ie),In=l(Ie,"P",{"data-svelte-h":!0}),f(In)!=="svelte-msa4ge"&&(In.innerHTML=Ts),Ie.forEach(a),cr=o(M),pe=l(M,"DIV",{class:!0});var aa=_(pe);m(dt.$$.fragment,aa),pr=o(aa),An=l(aa,"P",{"data-svelte-h":!0}),f(An)!=="svelte-63kthh"&&(An.textContent=xs),aa.forEach(a),M.forEach(a),ko=o(e),m(mt.$$.fragment,e),Co=o(e),I=l(e,"DIV",{class:!0});var P=_(I);m(ct.$$.fragment,P),gr=o(P),jn=l(P,"P",{"data-svelte-h":!0}),f(jn)!=="svelte-1jgzyq0"&&(jn.textContent=ks),hr=o(P),ge=l(P,"DIV",{class:!0});var ra=_(ge);m(pt.$$.fragment,ra),ur=o(ra),Ln=l(ra,"P",{"data-svelte-h":!0}),f(Ln)!=="svelte-g8q0nk"&&(Ln.textContent=Cs),ra.forEach(a),fr=o(P),he=l(P,"DIV",{class:!0});var sa=_(he);m(gt.$$.fragment,sa),br=o(sa),qn=l(sa,"P",{"data-svelte-h":!0}),f(qn)!=="svelte-1l2znf2"&&(qn.textContent=Ms),sa.forEach(a),_r=o(P),ue=l(P,"DIV",{class:!0});var la=_(ue);m(ht.$$.fragment,la),vr=o(la),Pn=l(la,"P",{"data-svelte-h":!0}),f(Pn)!=="svelte-165lhg0"&&(Pn.textContent=Is),la.forEach(a),$r=o(P),fe=l(P,"DIV",{class:!0});var ia=_(fe);m(ut.$$.fragment,ia),yr=o(ia),Jn=l(ia,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-15vkk0u"&&(Jn.textContent=As),ia.forEach(a),wr=o(P),be=l(P,"DIV",{class:!0});var da=_(be);m(ft.$$.fragment,da),Tr=o(da),En=l(da,"P",{"data-svelte-h":!0}),f(En)!=="svelte-1p64qrs"&&(En.textContent=js),da.forEach(a),P.forEach(a),Mo=o(e),m(bt.$$.fragment,e),Io=o(e),A=l(e,"DIV",{class:!0});var J=_(A);m(_t.$$.fragment,J),xr=o(J),Nn=l(J,"P",{"data-svelte-h":!0}),f(Nn)!=="svelte-1tqfigx"&&(Nn.innerHTML=Ls),kr=o(J),Hn=l(J,"UL",{"data-svelte-h":!0}),f(Hn)!=="svelte-n6zm2g"&&(Hn.innerHTML=qs),Cr=o(J),_e=l(J,"DIV",{class:!0});var ma=_(_e);m(vt.$$.fragment,ma),Mr=o(ma),Un=l(ma,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-zkjq4t"&&(Un.innerHTML=Ps),ma.forEach(a),Ir=o(J),ve=l(J,"DIV",{class:!0});var ca=_(ve);m($t.$$.fragment,ca),Ar=o(ca),Bn=l(ca,"P",{"data-svelte-h":!0}),f(Bn)!=="svelte-1vxzk80"&&(Bn.innerHTML=Js),ca.forEach(a),jr=o(J),$e=l(J,"DIV",{class:!0});var pa=_($e);m(yt.$$.fragment,pa),Lr=o(pa),Dn=l(pa,"P",{"data-svelte-h":!0}),f(Dn)!=="svelte-1qgsi13"&&(Dn.innerHTML=Es),pa.forEach(a),qr=o(J),ye=l(J,"DIV",{class:!0});var ga=_(ye);m(wt.$$.fragment,ga),Pr=o(ga),Rn=l(ga,"P",{"data-svelte-h":!0}),f(Rn)!=="svelte-1ojxz66"&&(Rn.innerHTML=Ns),ga.forEach(a),J.forEach(a),Ao=o(e),m(Tt.$$.fragment,e),jo=o(e),F=l(e,"DIV",{class:!0});var ha=_(F);m(xt.$$.fragment,ha),Jr=o(ha),Wn=l(ha,"P",{"data-svelte-h":!0}),f(Wn)!=="svelte-j4u4it"&&(Wn.innerHTML=Hs),ha.forEach(a),Lo=o(e),m(kt.$$.fragment,e),qo=o(e),N=l(e,"DIV",{class:!0});var Ae=_(N);m(Ct.$$.fragment,Ae),Er=o(Ae),Sn=l(Ae,"P",{"data-svelte-h":!0}),f(Sn)!=="svelte-n5kqzu"&&(Sn.textContent=Us),Nr=o(Ae),Vn=l(Ae,"BLOCKQUOTE",{"data-svelte-h":!0}),f(Vn)!=="svelte-1ezz2hf"&&(Vn.innerHTML=Bs),Hr=o(Ae),m(we.$$.fragment,Ae),Ae.forEach(a),Po=o(e),m(Mt.$$.fragment,e),Jo=o(e),It=l(e,"P",{"data-svelte-h":!0}),f(It)!=="svelte-oor881"&&(It.textContent=Ds),Eo=o(e),At=l(e,"OL",{"data-svelte-h":!0}),f(At)!=="svelte-1fvckr8"&&(At.innerHTML=Rs),No=o(e),m(jt.$$.fragment,e),Ho=o(e),Lt=l(e,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-1helv3l"&&(Lt.innerHTML=Ws),Uo=o(e),m(qt.$$.fragment,e),Bo=o(e),Pt=l(e,"DIV",{class:!0});var el=_(Pt);m(Jt.$$.fragment,el),el.forEach(a),Do=o(e),m(Et.$$.fragment,e),Ro=o(e),Nt=l(e,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-jsq4jz"&&(Nt.textContent=Ss),Wo=o(e),Ht=l(e,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-1ixcu88"&&(Ht.innerHTML=Vs),So=o(e),Ut=l(e,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-1nfvcwf"&&(Ut.textContent=Os),Vo=o(e),Bt=l(e,"UL",{"data-svelte-h":!0}),f(Bt)!=="svelte-ysem30"&&(Bt.innerHTML=zs),Oo=o(e),m(Dt.$$.fragment,e),zo=o(e),Q=l(e,"DIV",{class:!0});var ua=_(Q);m(Rt.$$.fragment,ua),Ur=o(ua),On=l(ua,"P",{"data-svelte-h":!0}),f(On)!=="svelte-57fhj7"&&(On.textContent=Gs),ua.forEach(a),Go=o(e),m(Wt.$$.fragment,e),Zo=o(e),H=l(e,"DIV",{class:!0});var je=_(H);m(St.$$.fragment,je),Br=o(je),zn=l(je,"P",{"data-svelte-h":!0}),f(zn)!=="svelte-1hsb0qs"&&(zn.textContent=Zs),Dr=o(je),Te=l(je,"DIV",{class:!0});var fa=_(Te);m(Vt.$$.fragment,fa),Rr=o(fa),Gn=l(fa,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-ybie7i"&&(Gn.textContent=Ys),fa.forEach(a),Wr=o(je),xe=l(je,"DIV",{class:!0});var ba=_(xe);m(Ot.$$.fragment,ba),Sr=o(ba),Zn=l(ba,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-chc6sp"&&(Zn.textContent=Fs),ba.forEach(a),je.forEach(a),Yo=o(e),m(zt.$$.fragment,e),Fo=o(e),U=l(e,"DIV",{class:!0});var Le=_(U);m(Gt.$$.fragment,Le),Vr=o(Le),Yn=l(Le,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-ckiqb6"&&(Yn.textContent=Qs),Or=o(Le),ke=l(Le,"DIV",{class:!0});var _a=_(ke);m(Zt.$$.fragment,_a),zr=o(_a),Fn=l(_a,"P",{"data-svelte-h":!0}),f(Fn)!=="svelte-10rnn1x"&&(Fn.innerHTML=Xs),_a.forEach(a),Gr=o(Le),Ce=l(Le,"DIV",{class:!0});var va=_(Ce);m(Yt.$$.fragment,va),Zr=o(va),Qn=l(va,"P",{"data-svelte-h":!0}),f(Qn)!=="svelte-1xu9o93"&&(Qn.textContent=Ks),va.forEach(a),Le.forEach(a),Qo=o(e),m(Ft.$$.fragment,e),Xo=o(e),ro=l(e,"P",{}),_(ro).forEach(a),this.h()},h(){v(u,"name","hf:doc:metadata"),v(u,"content",ul),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,u),i(e,x,r),i(e,$,r),i(e,w,r),c(T,e,r),i(e,b,r),c(C,e,r),i(e,lo,r),i(e,qe,r),i(e,io,r),c(Pe,e,r),i(e,mo,r),i(e,Je,r),i(e,co,r),i(e,Ee,r),i(e,po,r),c(Ne,e,r),i(e,go,r),i(e,q,r),c(He,q,null),t(q,ya),t(q,X),c(Ue,X,null),t(X,wa),t(X,on),t(q,Ta),t(q,K),c(Be,K,null),t(K,xa),t(K,an),t(q,ka),t(q,ee),c(De,ee,null),t(ee,Ca),t(ee,rn),t(q,Ma),t(q,te),c(Re,te,null),t(te,Ia),t(te,sn),i(e,ho,r),c(We,e,r),i(e,uo,r),i(e,E,r),c(Se,E,null),t(E,Aa),t(E,ln),t(E,ja),t(E,ne),c(Ve,ne,null),t(ne,La),t(ne,dn),t(E,qa),t(E,G),c(Oe,G,null),t(G,Pa),t(G,mn),t(G,Ja),c(oe,G,null),i(e,fo,r),c(ze,e,r),i(e,bo,r),i(e,W,r),c(Ge,W,null),t(W,Ea),t(W,cn),t(W,Na),t(W,Z),c(Ze,Z,null),t(Z,Ha),t(Z,pn),t(Z,Ua),c(ae,Z,null),i(e,_o,r),i(e,S,r),c(Ye,S,null),t(S,Ba),t(S,gn),t(S,Da),t(S,re),c(Fe,re,null),t(re,Ra),t(re,hn),i(e,vo,r),i(e,V,r),c(Qe,V,null),t(V,Wa),t(V,un),t(V,Sa),t(V,se),c(Xe,se,null),t(se,Va),t(se,fn),i(e,$o,r),c(Ke,e,r),i(e,yo,r),c(et,e,r),i(e,wo,r),i(e,O,r),c(tt,O,null),t(O,Oa),t(O,bn),t(O,za),c(le,O,null),i(e,To,r),c(nt,e,r),i(e,xo,r),i(e,k,r),c(ot,k,null),t(k,Ga),t(k,_n),t(k,Za),t(k,vn),t(k,Ya),t(k,$n),t(k,Fa),t(k,ie),c(at,ie,null),t(ie,Qa),t(ie,yn),t(k,Xa),t(k,Y),c(rt,Y,null),t(Y,Ka),t(Y,wn),t(Y,er),c(de,Y,null),t(k,tr),t(k,me),c(st,me,null),t(me,nr),t(me,Tn),t(k,or),t(k,D),c(lt,D,null),t(D,ar),t(D,xn),t(D,rr),t(D,kn),t(D,sr),c(ce,D,null),t(k,lr),t(k,R),c(it,R,null),t(R,ir),t(R,Cn),t(R,dr),t(R,Mn),t(R,mr),t(R,In),t(k,cr),t(k,pe),c(dt,pe,null),t(pe,pr),t(pe,An),i(e,ko,r),c(mt,e,r),i(e,Co,r),i(e,I,r),c(ct,I,null),t(I,gr),t(I,jn),t(I,hr),t(I,ge),c(pt,ge,null),t(ge,ur),t(ge,Ln),t(I,fr),t(I,he),c(gt,he,null),t(he,br),t(he,qn),t(I,_r),t(I,ue),c(ht,ue,null),t(ue,vr),t(ue,Pn),t(I,$r),t(I,fe),c(ut,fe,null),t(fe,yr),t(fe,Jn),t(I,wr),t(I,be),c(ft,be,null),t(be,Tr),t(be,En),i(e,Mo,r),c(bt,e,r),i(e,Io,r),i(e,A,r),c(_t,A,null),t(A,xr),t(A,Nn),t(A,kr),t(A,Hn),t(A,Cr),t(A,_e),c(vt,_e,null),t(_e,Mr),t(_e,Un),t(A,Ir),t(A,ve),c($t,ve,null),t(ve,Ar),t(ve,Bn),t(A,jr),t(A,$e),c(yt,$e,null),t($e,Lr),t($e,Dn),t(A,qr),t(A,ye),c(wt,ye,null),t(ye,Pr),t(ye,Rn),i(e,Ao,r),c(Tt,e,r),i(e,jo,r),i(e,F,r),c(xt,F,null),t(F,Jr),t(F,Wn),i(e,Lo,r),c(kt,e,r),i(e,qo,r),i(e,N,r),c(Ct,N,null),t(N,Er),t(N,Sn),t(N,Nr),t(N,Vn),t(N,Hr),c(we,N,null),i(e,Po,r),c(Mt,e,r),i(e,Jo,r),i(e,It,r),i(e,Eo,r),i(e,At,r),i(e,No,r),c(jt,e,r),i(e,Ho,r),i(e,Lt,r),i(e,Uo,r),c(qt,e,r),i(e,Bo,r),i(e,Pt,r),c(Jt,Pt,null),i(e,Do,r),c(Et,e,r),i(e,Ro,r),i(e,Nt,r),i(e,Wo,r),i(e,Ht,r),i(e,So,r),i(e,Ut,r),i(e,Vo,r),i(e,Bt,r),i(e,Oo,r),c(Dt,e,r),i(e,zo,r),i(e,Q,r),c(Rt,Q,null),t(Q,Ur),t(Q,On),i(e,Go,r),c(Wt,e,r),i(e,Zo,r),i(e,H,r),c(St,H,null),t(H,Br),t(H,zn),t(H,Dr),t(H,Te),c(Vt,Te,null),t(Te,Rr),t(Te,Gn),t(H,Wr),t(H,xe),c(Ot,xe,null),t(xe,Sr),t(xe,Zn),i(e,Yo,r),c(zt,e,r),i(e,Fo,r),i(e,U,r),c(Gt,U,null),t(U,Vr),t(U,Yn),t(U,Or),t(U,ke),c(Zt,ke,null),t(ke,zr),t(ke,Fn),t(U,Gr),t(U,Ce),c(Yt,Ce,null),t(Ce,Zr),t(Ce,Qn),i(e,Qo,r),c(Ft,e,r),i(e,Xo,r),i(e,ro,r),Ko=!0},p(e,[r]){const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),C.$set(B);const Qt={};r&2&&(Qt.$$scope={dirty:r,ctx:e}),oe.$set(Qt);const Xt={};r&2&&(Xt.$$scope={dirty:r,ctx:e}),ae.$set(Xt);const Kt={};r&2&&(Kt.$$scope={dirty:r,ctx:e}),le.$set(Kt);const en={};r&2&&(en.$$scope={dirty:r,ctx:e}),de.$set(en);const z={};r&2&&(z.$$scope={dirty:r,ctx:e}),ce.$set(z);const tn={};r&2&&(tn.$$scope={dirty:r,ctx:e}),we.$set(tn)},i(e){Ko||(p(T.$$.fragment,e),p(C.$$.fragment,e),p(Pe.$$.fragment,e),p(Ne.$$.fragment,e),p(He.$$.fragment,e),p(Ue.$$.fragment,e),p(Be.$$.fragment,e),p(De.$$.fragment,e),p(Re.$$.fragment,e),p(We.$$.fragment,e),p(Se.$$.fragment,e),p(Ve.$$.fragment,e),p(Oe.$$.fragment,e),p(oe.$$.fragment,e),p(ze.$$.fragment,e),p(Ge.$$.fragment,e),p(Ze.$$.fragment,e),p(ae.$$.fragment,e),p(Ye.$$.fragment,e),p(Fe.$$.fragment,e),p(Qe.$$.fragment,e),p(Xe.$$.fragment,e),p(Ke.$$.fragment,e),p(et.$$.fragment,e),p(tt.$$.fragment,e),p(le.$$.fragment,e),p(nt.$$.fragment,e),p(ot.$$.fragment,e),p(at.$$.fragment,e),p(rt.$$.fragment,e),p(de.$$.fragment,e),p(st.$$.fragment,e),p(lt.$$.fragment,e),p(ce.$$.fragment,e),p(it.$$.fragment,e),p(dt.$$.fragment,e),p(mt.$$.fragment,e),p(ct.$$.fragment,e),p(pt.$$.fragment,e),p(gt.$$.fragment,e),p(ht.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(bt.$$.fragment,e),p(_t.$$.fragment,e),p(vt.$$.fragment,e),p($t.$$.fragment,e),p(yt.$$.fragment,e),p(wt.$$.fragment,e),p(Tt.$$.fragment,e),p(xt.$$.fragment,e),p(kt.$$.fragment,e),p(Ct.$$.fragment,e),p(we.$$.fragment,e),p(Mt.$$.fragment,e),p(jt.$$.fragment,e),p(qt.$$.fragment,e),p(Jt.$$.fragment,e),p(Et.$$.fragment,e),p(Dt.$$.fragment,e),p(Rt.$$.fragment,e),p(Wt.$$.fragment,e),p(St.$$.fragment,e),p(Vt.$$.fragment,e),p(Ot.$$.fragment,e),p(zt.$$.fragment,e),p(Gt.$$.fragment,e),p(Zt.$$.fragment,e),p(Yt.$$.fragment,e),p(Ft.$$.fragment,e),Ko=!0)},o(e){g(T.$$.fragment,e),g(C.$$.fragment,e),g(Pe.$$.fragment,e),g(Ne.$$.fragment,e),g(He.$$.fragment,e),g(Ue.$$.fragment,e),g(Be.$$.fragment,e),g(De.$$.fragment,e),g(Re.$$.fragment,e),g(We.$$.fragment,e),g(Se.$$.fragment,e),g(Ve.$$.fragment,e),g(Oe.$$.fragment,e),g(oe.$$.fragment,e),g(ze.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(ae.$$.fragment,e),g(Ye.$$.fragment,e),g(Fe.$$.fragment,e),g(Qe.$$.fragment,e),g(Xe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(le.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(de.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(ce.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(mt.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(gt.$$.fragment,e),g(ht.$$.fragment,e),g(ut.$$.fragment,e),g(ft.$$.fragment,e),g(bt.$$.fragment,e),g(_t.$$.fragment,e),g(vt.$$.fragment,e),g($t.$$.fragment,e),g(yt.$$.fragment,e),g(wt.$$.fragment,e),g(Tt.$$.fragment,e),g(xt.$$.fragment,e),g(kt.$$.fragment,e),g(Ct.$$.fragment,e),g(we.$$.fragment,e),g(Mt.$$.fragment,e),g(jt.$$.fragment,e),g(qt.$$.fragment,e),g(Jt.$$.fragment,e),g(Et.$$.fragment,e),g(Dt.$$.fragment,e),g(Rt.$$.fragment,e),g(Wt.$$.fragment,e),g(St.$$.fragment,e),g(Vt.$$.fragment,e),g(Ot.$$.fragment,e),g(zt.$$.fragment,e),g(Gt.$$.fragment,e),g(Zt.$$.fragment,e),g(Yt.$$.fragment,e),g(Ft.$$.fragment,e),Ko=!1},d(e){e&&(a(x),a($),a(w),a(b),a(lo),a(qe),a(io),a(mo),a(Je),a(co),a(Ee),a(po),a(go),a(q),a(ho),a(uo),a(E),a(fo),a(bo),a(W),a(_o),a(S),a(vo),a(V),a($o),a(yo),a(wo),a(O),a(To),a(xo),a(k),a(ko),a(Co),a(I),a(Mo),a(Io),a(A),a(Ao),a(jo),a(F),a(Lo),a(qo),a(N),a(Po),a(Jo),a(It),a(Eo),a(At),a(No),a(Ho),a(Lt),a(Uo),a(Bo),a(Pt),a(Do),a(Ro),a(Nt),a(Wo),a(Ht),a(So),a(Ut),a(Vo),a(Bt),a(Oo),a(zo),a(Q),a(Go),a(Zo),a(H),a(Yo),a(Fo),a(U),a(Qo),a(Xo),a(ro)),a(u),h(T,e),h(C,e),h(Pe,e),h(Ne,e),h(He),h(Ue),h(Be),h(De),h(Re),h(We,e),h(Se),h(Ve),h(Oe),h(oe),h(ze,e),h(Ge),h(Ze),h(ae),h(Ye),h(Fe),h(Qe),h(Xe),h(Ke,e),h(et,e),h(tt),h(le),h(nt,e),h(ot),h(at),h(rt),h(de),h(st),h(lt),h(ce),h(it),h(dt),h(mt,e),h(ct),h(pt),h(gt),h(ht),h(ut),h(ft),h(bt,e),h(_t),h(vt),h($t),h(yt),h(wt),h(Tt,e),h(xt),h(kt,e),h(Ct),h(we),h(Mt,e),h(jt,e),h(qt,e),h(Jt),h(Et,e),h(Dt,e),h(Rt),h(Wt,e),h(St),h(Vt),h(Ot),h(zt,e),h(Gt),h(Zt),h(Yt),h(Ft,e)}}}const ul='{"title":"Agents & Tools","local":"agents--tools","sections":[{"title":"Agents","local":"agents","sections":[{"title":"Agent","local":"transformers.Agent","sections":[],"depth":3},{"title":"CodeAgent","local":"transformers.CodeAgent","sections":[],"depth":3},{"title":"React agents","local":"transformers.ReactAgent","sections":[],"depth":3}],"depth":2},{"title":"Tools","local":"tools","sections":[{"title":"load_tool","local":"transformers.load_tool","sections":[],"depth":3},{"title":"Tool","local":"transformers.Tool","sections":[],"depth":3},{"title":"Toolbox","local":"transformers.Toolbox","sections":[],"depth":3},{"title":"PipelineTool","local":"transformers.PipelineTool","sections":[],"depth":3},{"title":"launch_gradio_demo","local":"transformers.launch_gradio_demo","sections":[],"depth":3},{"title":"ToolCollection","local":"transformers.ToolCollection","sections":[],"depth":3}],"depth":2},{"title":"Engines","local":"engines","sections":[{"title":"HfEngine","local":"transformers.HfEngine","sections":[],"depth":3}],"depth":2},{"title":"Agent Types","local":"agent-types","sections":[{"title":"AgentText","local":"transformers.agents.agent_types.AgentText","sections":[],"depth":3},{"title":"AgentImage","local":"transformers.agents.agent_types.AgentImage","sections":[],"depth":3},{"title":"AgentAudio","local":"transformers.agents.agent_types.AgentAudio","sections":[],"depth":3}],"depth":2}],"depth":1}';function fl(L){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends ol{constructor(u){super(),al(this,u,fl,hl,tl,{})}}export{xl as component};
