import{s as Gs,f as Ys,o as Fs,n as st}from"../chunks/scheduler.9bc65507.js";import{S as qs,i as Es,g as i,s as o,r as p,A as Ss,h as d,f as s,c as n,j as x,u,x as b,k as w,y as r,a,v as g,d as h,t as f,w as _}from"../chunks/index.707bf1b6.js";import{T as ms}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.17db21ae.js";import{C as tt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ns}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as V}from"../chunks/Heading.342b1fa6.js";function Hs(I){let l,T="Example:",m,M,j;return M=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERvbnV0U3dpbkNvbmZpZyUyQyUyMERvbnV0U3dpbk1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERvbnV0JTIwbmF2ZXItY2xvdmEtaXglMkZkb251dC1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMERvbnV0U3dpbkNvbmZpZygpJTBBJTBBJTIzJTIwUmFuZG9tbHklMjBpbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbmF2ZXItY2xvdmEtaXglMkZkb251dC1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEb251dFN3aW5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DonutSwinConfig, DonutSwinModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Donut naver-clova-ix/donut-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DonutSwinConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model from the naver-clova-ix/donut-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DonutSwinModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=i("p"),l.textContent=T,m=o(),p(M.$$.fragment)},l(c){l=d(c,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=T),m=n(c),u(M.$$.fragment,c)},m(c,J){a(c,l,J),a(c,m,J),g(M,c,J),j=!0},p:st,i(c){j||(h(M.$$.fragment,c),j=!0)},o(c){f(M.$$.fragment,c),j=!1},d(c){c&&(s(l),s(m)),_(M,c)}}}function Ps(I){let l,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.39.3/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.39.3/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=i("p"),l.innerHTML=T},l(m){l=d(m,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1pxwq1t"&&(l.innerHTML=T)},m(m,M){a(m,l,M)},p:st,d(m){m&&s(l)}}}function Ls(I){let l,T=`This class method is simply calling <a href="/docs/transformers/v4.39.3/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=i("p"),l.innerHTML=T},l(m){l=d(m,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1g1uwi"&&(l.innerHTML=T)},m(m,M){a(m,l,M)},p:st,d(m){m&&s(l)}}}function Qs(I){let l,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=T},l(m){l=d(m,"P",{"data-svelte-h":!0}),b(l)!=="svelte-fincs2"&&(l.innerHTML=T)},m(m,M){a(m,l,M)},p:st,d(m){m&&s(l)}}}function As(I){let l,T="Example:",m,M,j;return M=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERvbnV0U3dpbk1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbmF2ZXItY2xvdmEtaXglMkZkb251dC1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwRG9udXRTd2luTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZuYXZlci1jbG92YS1peCUyRmRvbnV0LWJhc2UlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DonutSwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;https://huggingface.co/naver-clova-ix/donut-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DonutSwinModel.from_pretrained(<span class="hljs-string">&quot;https://huggingface.co/naver-clova-ix/donut-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=T,m=o(),p(M.$$.fragment)},l(c){l=d(c,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=T),m=n(c),u(M.$$.fragment,c)},m(c,J){a(c,l,J),a(c,m,J),g(M,c,J),j=!0},p:st,i(c){j||(h(M.$$.fragment,c),j=!0)},o(c){f(M.$$.fragment,c),j=!1},d(c){c&&(s(l),s(m)),_(M,c)}}}function Ks(I){let l,T,m,M,j,c,J,ot,A,ps=`The Donut model was proposed in <a href="https://arxiv.org/abs/2111.15664" rel="nofollow">OCR-free Document Understanding Transformer</a> by
Geewook Kim, Teakgyu Hong, Moonbin Yim, Jeongyeon Nam, Jinyoung Park, Jinyeong Yim, Wonseok Hwang, Sangdoo Yun, Dongyoon Han, Seunghyun Park.
Donut consists of an image Transformer encoder and an autoregressive text Transformer decoder to perform document understanding
tasks such as document image classification, form understanding and visual question answering.`,nt,K,us="The abstract from the paper is the following:",at,O,gs="<em>Understanding document images (e.g., invoices) is a core but challenging task since it requires complex functions such as reading text and a holistic understanding of the document. Current Visual Document Understanding (VDU) methods outsource the task of reading text to off-the-shelf Optical Character Recognition (OCR) engines and focus on the understanding task with the OCR outputs. Although such OCR-based approaches have shown promising performance, they suffer from 1) high computational costs for using OCR; 2) inflexibility of OCR models on languages or types of document; 3) OCR error propagation to the subsequent process. To address these issues, in this paper, we introduce a novel OCR-free VDU model named Donut, which stands for Document understanding transformer. As the first step in OCR-free VDU research, we propose a simple architecture (i.e., Transformer) with a pre-training objective (i.e., cross-entropy loss). Donut is conceptually simple yet effective. Through extensive experiments and analyses, we show a simple OCR-free VDU model, Donut, achieves state-of-the-art performances on various VDU tasks in terms of both speed and accuracy. In addition, we offer a synthetic data generator that helps the model pre-training to be flexible in various languages and domains.</em>",rt,X,hs,lt,ee,fs='Donut high-level overview. Taken from the <a href="https://arxiv.org/abs/2111.15664">original paper</a>.',it,te,_s=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/clovaai/donut" rel="nofollow">here</a>.`,dt,se,ct,oe,bs=`<li>The quickest way to get started with Donut is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Donut" rel="nofollow">tutorial
notebooks</a>, which show how to use the model
at inference time as well as fine-tuning on custom data.</li> <li>Donut is always used within the <a href="vision-encoder-decoder">VisionEncoderDecoder</a> framework.</li>`,mt,ne,pt,ae,Ms=`Donut’s <code>VisionEncoderDecoder</code> model accepts images as input and makes use of
<a href="/docs/transformers/v4.39.3/en/model_doc/phi#transformers.PhiForCausalLM.generate">generate()</a> to autoregressively generate text given the input image.`,ut,re,vs=`The <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> class is responsible for preprocessing the input image and
[<code>XLMRobertaTokenizer</code>/<code>XLMRobertaTokenizerFast</code>] decodes the generated target tokens to the target string. The
<a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutProcessor">DonutProcessor</a> wraps <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> and [<code>XLMRobertaTokenizer</code>/<code>XLMRobertaTokenizerFast</code>]
into a single instance to both extract the input features and decode the predicted token ids.`,gt,le,Ts="<li>Step-by-step Document Image Classification</li>",ht,ie,ft,de,ws="<li>Step-by-step Document Parsing</li>",_t,ce,bt,me,js="<li>Step-by-step Document Visual Question Answering (DocVQA)</li>",Mt,pe,vt,ue,ys='See the <a href="https://huggingface.co/models?filter=donut" rel="nofollow">model hub</a> to look for Donut checkpoints.',Tt,ge,wt,he,Js='We refer to the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Donut" rel="nofollow">tutorial notebooks</a>.',jt,fe,yt,k,_e,Bt,De,xs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a>. It is used to instantiate a
Donut model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Donut
<a href="https://huggingface.co/naver-clova-ix/donut-base" rel="nofollow">naver-clova-ix/donut-base</a> architecture.`,Xt,Be,ks=`Configuration objects inherit from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Nt,N,Jt,be,xt,z,Me,Gt,Xe,Us="Constructs a Donut image processor.",Yt,G,ve,Ft,Ne,Is="Preprocess an image or batch of images.",kt,Te,Ut,D,we,qt,Y,je,Et,Ge,Zs="Preprocess an image or a batch of images.",It,ye,Zt,v,Je,St,Ye,zs=`Constructs a Donut processor which wraps a Donut image processor and an XLMRoBERTa tokenizer into a single
processor.`,Ht,Fe,$s=`<a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutProcessor">DonutProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> and
[<code>XLMRobertaTokenizer</code>/<code>XLMRobertaTokenizerFast</code>]. See the <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutProcessor.__call__"><strong>call</strong>()</a> and
<a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutProcessor.decode">decode()</a> for more information.`,Pt,F,xe,Lt,qe,Rs=`When used in normal mode, this method forwards all its arguments to AutoImageProcessor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to DonutTokenizer’s
<code>~DonutTokenizer.__call__</code>. Please refer to the doctsring of the above two methods for more information.`,Qt,C,ke,At,Ee,Cs="Instantiate a processor associated with a pretrained model.",Kt,q,Ot,W,Ue,es,Se,Ws=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.39.3/en/model_doc/nougat#transformers.NougatProcessor.from_pretrained">from_pretrained()</a> method.`,ts,E,ss,S,Ie,os,He,Vs=`This method forwards all its arguments to DonutTokenizer’s <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer
to the docstring of this method for more information.`,ns,H,Ze,as,Pe,Ds=`This method forwards all its arguments to DonutTokenizer’s <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,zt,ze,$t,$,$e,rs,Le,Bs=`The bare Donut Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ls,Z,Re,is,Qe,Xs='The <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> forward method, overrides the <code>__call__</code> special method.',ds,P,cs,L,Rt,et,Ct;return j=new V({props:{title:"Donut",local:"donut",headingTag:"h1"}}),J=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new V({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ne=new V({props:{title:"Inference examples",local:"inference-examples",headingTag:"h2"}}),ie=new tt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> re

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DonutProcessor, VisionEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = DonutProcessor.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-rvlcdip&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-rvlcdip&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load document image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/example-documents&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;image&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare decoder inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task_prompt = <span class="hljs-string">&quot;&lt;s_rvlcdip&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = processor.tokenizer(task_prompt, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    pixel_values.to(device),
<span class="hljs-meta">... </span>    decoder_input_ids=decoder_input_ids.to(device),
<span class="hljs-meta">... </span>    max_length=model.decoder.config.max_position_embeddings,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>    eos_token_id=processor.tokenizer.eos_token_id,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bad_words_ids=[[processor.tokenizer.unk_token_id]],
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = processor.batch_decode(outputs.sequences)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = sequence.replace(processor.tokenizer.eos_token, <span class="hljs-string">&quot;&quot;</span>).replace(processor.tokenizer.pad_token, <span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = re.sub(<span class="hljs-string">r&quot;&lt;.*?&gt;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>, sequence, count=<span class="hljs-number">1</span>).strip()  <span class="hljs-comment"># remove first task start token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(processor.token2json(sequence))
{<span class="hljs-string">&#x27;class&#x27;</span>: <span class="hljs-string">&#x27;advertisement&#x27;</span>}`,wrap:!1}}),ce=new tt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> re

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DonutProcessor, VisionEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = DonutProcessor.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-cord-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-cord-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load document image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/example-documents&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare decoder inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task_prompt = <span class="hljs-string">&quot;&lt;s_cord-v2&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = processor.tokenizer(task_prompt, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    pixel_values.to(device),
<span class="hljs-meta">... </span>    decoder_input_ids=decoder_input_ids.to(device),
<span class="hljs-meta">... </span>    max_length=model.decoder.config.max_position_embeddings,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>    eos_token_id=processor.tokenizer.eos_token_id,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bad_words_ids=[[processor.tokenizer.unk_token_id]],
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = processor.batch_decode(outputs.sequences)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = sequence.replace(processor.tokenizer.eos_token, <span class="hljs-string">&quot;&quot;</span>).replace(processor.tokenizer.pad_token, <span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = re.sub(<span class="hljs-string">r&quot;&lt;.*?&gt;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>, sequence, count=<span class="hljs-number">1</span>).strip()  <span class="hljs-comment"># remove first task start token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(processor.token2json(sequence))
{<span class="hljs-string">&#x27;menu&#x27;</span>: {<span class="hljs-string">&#x27;nm&#x27;</span>: <span class="hljs-string">&#x27;CINNAMON SUGAR&#x27;</span>, <span class="hljs-string">&#x27;unitprice&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;cnt&#x27;</span>: <span class="hljs-string">&#x27;1 x&#x27;</span>, <span class="hljs-string">&#x27;price&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>}, <span class="hljs-string">&#x27;sub_total&#x27;</span>: {<span class="hljs-string">&#x27;subtotal_price&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>}, <span class="hljs-string">&#x27;total&#x27;</span>: {<span class="hljs-string">&#x27;total_price&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;cashprice&#x27;</span>: <span class="hljs-string">&#x27;20,000&#x27;</span>, <span class="hljs-string">&#x27;changeprice&#x27;</span>: <span class="hljs-string">&#x27;3,000&#x27;</span>}}`,wrap:!1}}),pe=new tt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> re

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DonutProcessor, VisionEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = DonutProcessor.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-docvqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-docvqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load document image from the DocVQA dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/example-documents&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare decoder inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task_prompt = <span class="hljs-string">&quot;&lt;s_docvqa&gt;&lt;s_question&gt;{user_input}&lt;/s_question&gt;&lt;s_answer&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;When is the coffee break?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = task_prompt.replace(<span class="hljs-string">&quot;{user_input}&quot;</span>, question)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = processor.tokenizer(prompt, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    pixel_values.to(device),
<span class="hljs-meta">... </span>    decoder_input_ids=decoder_input_ids.to(device),
<span class="hljs-meta">... </span>    max_length=model.decoder.config.max_position_embeddings,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>    eos_token_id=processor.tokenizer.eos_token_id,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bad_words_ids=[[processor.tokenizer.unk_token_id]],
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = processor.batch_decode(outputs.sequences)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = sequence.replace(processor.tokenizer.eos_token, <span class="hljs-string">&quot;&quot;</span>).replace(processor.tokenizer.pad_token, <span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = re.sub(<span class="hljs-string">r&quot;&lt;.*?&gt;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>, sequence, count=<span class="hljs-number">1</span>).strip()  <span class="hljs-comment"># remove first task start token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(processor.token2json(sequence))
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;When is the coffee break?&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;11-14 to 11:39 a.m.&#x27;</span>}`,wrap:!1}}),ge=new V({props:{title:"Training",local:"training",headingTag:"h2"}}),fe=new V({props:{title:"DonutSwinConfig",local:"transformers.DonutSwinConfig",headingTag:"h2"}}),_e=new U({props:{name:"class transformers.DonutSwinConfig",anchor:"transformers.DonutSwinConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 4"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 96"},{name:"depths",val:" = [2, 2, 6, 2]"},{name:"num_heads",val:" = [3, 6, 12, 24]"},{name:"window_size",val:" = 7"},{name:"mlp_ratio",val:" = 4.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutSwinConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.DonutSwinConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.DonutSwinConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DonutSwinConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.DonutSwinConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 2, 6, 2]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.DonutSwinConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[3, 6, 12, 24]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.DonutSwinConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.DonutSwinConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.DonutSwinConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.DonutSwinConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.DonutSwinConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.DonutSwinConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.DonutSwinConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.DonutSwinConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.DonutSwinConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DonutSwinConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/configuration_donut_swin.py#L29"}}),N=new Ns({props:{anchor:"transformers.DonutSwinConfig.example",$$slots:{default:[Hs]},$$scope:{ctx:I}}}),be=new V({props:{title:"DonutImageProcessor",local:"transformers.DonutImageProcessor",headingTag:"h2"}}),Me=new U({props:{name:"class transformers.DonutImageProcessor",anchor:"transformers.DonutImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_thumbnail",val:": bool = True"},{name:"do_align_long_axis",val:": bool = False"},{name:"do_pad",val:": bool = True"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DonutImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DonutImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DonutImageProcessor.do_thumbnail",description:`<strong>do_thumbnail</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image using thumbnail method.`,name:"do_thumbnail"},{anchor:"transformers.DonutImageProcessor.do_align_long_axis",description:`<strong>do_align_long_axis</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to align the long axis of the image with the long axis of <code>size</code> by rotating by 90 degrees.`,name:"do_align_long_axis"},{anchor:"transformers.DonutImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>random_padding</code> is set to <code>True</code> in <code>preprocess</code>, each image is padded with a
random amont of padding on each size, up to the largest image size in the batch. Otherwise, all images are
padded to the largest image size in the batch.`,name:"do_pad"},{anchor:"transformers.DonutImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DonutImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.DonutImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.DonutImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DonutImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Image standard deviation.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/image_processing_donut.py#L54"}}),ve=new U({props:{name:"preprocess",anchor:"transformers.DonutImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_thumbnail",val:": bool = None"},{name:"do_align_long_axis",val:": bool = None"},{name:"do_pad",val:": bool = None"},{name:"random_padding",val:": bool = False"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DonutImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DonutImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to min(size[&#x201C;height&#x201D;],
size[&#x201C;width&#x201D;]) with the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.DonutImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DonutImageProcessor.preprocess.do_thumbnail",description:`<strong>do_thumbnail</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_thumbnail</code>) &#x2014;
Whether to resize the image using thumbnail method.`,name:"do_thumbnail"},{anchor:"transformers.DonutImageProcessor.preprocess.do_align_long_axis",description:`<strong>do_align_long_axis</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_align_long_axis</code>) &#x2014;
Whether to align the long axis of the image with the long axis of <code>size</code> by rotating by 90 degrees.`,name:"do_align_long_axis"},{anchor:"transformers.DonutImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>random_padding</code> is set to <code>True</code>, each image is padded with a random
amont of padding on each size, up to the largest image size in the batch. Otherwise, all images are
padded to the largest image size in the batch.`,name:"do_pad"},{anchor:"transformers.DonutImageProcessor.preprocess.random_padding",description:`<strong>random_padding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.random_padding</code>) &#x2014;
Whether to use random padding when padding the image. If <code>True</code>, each image in the batch with be padded
with a random amount of padding on each side up to the size of the largest image in the batch.`,name:"random_padding"},{anchor:"transformers.DonutImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image pixel values.`,name:"do_rescale"},{anchor:"transformers.DonutImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DonutImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DonutImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization.`,name:"image_mean"},{anchor:"transformers.DonutImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization.`,name:"image_std"},{anchor:"transformers.DonutImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DonutImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: defaults to the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DonutImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/image_processing_donut.py#L317"}}),Te=new V({props:{title:"DonutFeatureExtractor",local:"transformers.DonutFeatureExtractor",headingTag:"h2"}}),we=new U({props:{name:"class transformers.DonutFeatureExtractor",anchor:"transformers.DonutFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/feature_extraction_donut.py#L26"}}),je=new U({props:{name:"__call__",anchor:"transformers.DonutFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/image_processing_utils.py#L549"}}),ye=new V({props:{title:"DonutProcessor",local:"transformers.DonutProcessor",headingTag:"h2"}}),Je=new U({props:{name:"class transformers.DonutProcessor",anchor:"transformers.DonutProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.DonutProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>XLMRobertaTokenizer</code>/<code>XLMRobertaTokenizerFast</code>], <em>optional</em>) &#x2014;
An instance of [<code>XLMRobertaTokenizer</code>/<code>XLMRobertaTokenizerFast</code>]. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/processing_donut.py#L25"}}),xe=new U({props:{name:"__call__",anchor:"transformers.DonutProcessor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/processing_donut.py#L65"}}),ke=new U({props:{name:"from_pretrained",anchor:"transformers.DonutProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.39.3/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.39.3/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/processing_utils.py#L406"}}),q=new ms({props:{$$slots:{default:[Ps]},$$scope:{ctx:I}}}),Ue=new U({props:{name:"save_pretrained",anchor:"transformers.DonutProcessor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DonutProcessor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.DonutProcessor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.DonutProcessor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/processing_utils.py#L167"}}),E=new ms({props:{$$slots:{default:[Ls]},$$scope:{ctx:I}}}),Ie=new U({props:{name:"batch_decode",anchor:"transformers.DonutProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/processing_donut.py#L98"}}),Ze=new U({props:{name:"decode",anchor:"transformers.DonutProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/processing_donut.py#L105"}}),ze=new V({props:{title:"DonutSwinModel",local:"transformers.DonutSwinModel",headingTag:"h2"}}),$e=new U({props:{name:"class transformers.DonutSwinModel",anchor:"transformers.DonutSwinModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"},{name:"use_mask_token",val:" = False"}],parametersDescription:[{anchor:"transformers.DonutSwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/modeling_donut_swin.py#L861"}}),Re=new U({props:{name:"forward",anchor:"transformers.DonutSwinModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"bool_masked_pos",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DonutSwinModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.39.3/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DonutImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DonutSwinModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DonutSwinModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DonutSwinModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DonutSwinModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DonutSwinModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/donut/modeling_donut_swin.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.donut.modeling_donut_swin.DonutSwinModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.3/en/model_doc/donut#transformers.DonutSwinConfig"
>DonutSwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.donut.modeling_donut_swin.DonutSwinModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new ms({props:{$$slots:{default:[Qs]},$$scope:{ctx:I}}}),L=new Ns({props:{anchor:"transformers.DonutSwinModel.forward.example",$$slots:{default:[As]},$$scope:{ctx:I}}}),{c(){l=i("meta"),T=o(),m=i("p"),M=o(),p(j.$$.fragment),c=o(),p(J.$$.fragment),ot=o(),A=i("p"),A.innerHTML=ps,nt=o(),K=i("p"),K.textContent=us,at=o(),O=i("p"),O.innerHTML=gs,rt=o(),X=i("img"),lt=o(),ee=i("small"),ee.innerHTML=fs,it=o(),te=i("p"),te.innerHTML=_s,dt=o(),p(se.$$.fragment),ct=o(),oe=i("ul"),oe.innerHTML=bs,mt=o(),p(ne.$$.fragment),pt=o(),ae=i("p"),ae.innerHTML=Ms,ut=o(),re=i("p"),re.innerHTML=vs,gt=o(),le=i("ul"),le.innerHTML=Ts,ht=o(),p(ie.$$.fragment),ft=o(),de=i("ul"),de.innerHTML=ws,_t=o(),p(ce.$$.fragment),bt=o(),me=i("ul"),me.innerHTML=js,Mt=o(),p(pe.$$.fragment),vt=o(),ue=i("p"),ue.innerHTML=ys,Tt=o(),p(ge.$$.fragment),wt=o(),he=i("p"),he.innerHTML=Js,jt=o(),p(fe.$$.fragment),yt=o(),k=i("div"),p(_e.$$.fragment),Bt=o(),De=i("p"),De.innerHTML=xs,Xt=o(),Be=i("p"),Be.innerHTML=ks,Nt=o(),p(N.$$.fragment),Jt=o(),p(be.$$.fragment),xt=o(),z=i("div"),p(Me.$$.fragment),Gt=o(),Xe=i("p"),Xe.textContent=Us,Yt=o(),G=i("div"),p(ve.$$.fragment),Ft=o(),Ne=i("p"),Ne.textContent=Is,kt=o(),p(Te.$$.fragment),Ut=o(),D=i("div"),p(we.$$.fragment),qt=o(),Y=i("div"),p(je.$$.fragment),Et=o(),Ge=i("p"),Ge.textContent=Zs,It=o(),p(ye.$$.fragment),Zt=o(),v=i("div"),p(Je.$$.fragment),St=o(),Ye=i("p"),Ye.textContent=zs,Ht=o(),Fe=i("p"),Fe.innerHTML=$s,Pt=o(),F=i("div"),p(xe.$$.fragment),Lt=o(),qe=i("p"),qe.innerHTML=Rs,Qt=o(),C=i("div"),p(ke.$$.fragment),At=o(),Ee=i("p"),Ee.textContent=Cs,Kt=o(),p(q.$$.fragment),Ot=o(),W=i("div"),p(Ue.$$.fragment),es=o(),Se=i("p"),Se.innerHTML=Ws,ts=o(),p(E.$$.fragment),ss=o(),S=i("div"),p(Ie.$$.fragment),os=o(),He=i("p"),He.innerHTML=Vs,ns=o(),H=i("div"),p(Ze.$$.fragment),as=o(),Pe=i("p"),Pe.innerHTML=Ds,zt=o(),p(ze.$$.fragment),$t=o(),$=i("div"),p($e.$$.fragment),rs=o(),Le=i("p"),Le.innerHTML=Bs,ls=o(),Z=i("div"),p(Re.$$.fragment),is=o(),Qe=i("p"),Qe.innerHTML=Xs,ds=o(),p(P.$$.fragment),cs=o(),p(L.$$.fragment),Rt=o(),et=i("p"),this.h()},l(e){const t=Ss("svelte-u9bgzb",document.head);l=d(t,"META",{name:!0,content:!0}),t.forEach(s),T=n(e),m=d(e,"P",{}),x(m).forEach(s),M=n(e),u(j.$$.fragment,e),c=n(e),u(J.$$.fragment,e),ot=n(e),A=d(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-pmkljw"&&(A.innerHTML=ps),nt=n(e),K=d(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-vfdo9a"&&(K.textContent=us),at=n(e),O=d(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-m8jgiq"&&(O.innerHTML=gs),rt=n(e),X=d(e,"IMG",{src:!0,alt:!0,width:!0}),lt=n(e),ee=d(e,"SMALL",{"data-svelte-h":!0}),b(ee)!=="svelte-16kwx1q"&&(ee.innerHTML=fs),it=n(e),te=d(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-1ka58uc"&&(te.innerHTML=_s),dt=n(e),u(se.$$.fragment,e),ct=n(e),oe=d(e,"UL",{"data-svelte-h":!0}),b(oe)!=="svelte-1dzhhy7"&&(oe.innerHTML=bs),mt=n(e),u(ne.$$.fragment,e),pt=n(e),ae=d(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-3hrt4n"&&(ae.innerHTML=Ms),ut=n(e),re=d(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-s3ym8d"&&(re.innerHTML=vs),gt=n(e),le=d(e,"UL",{"data-svelte-h":!0}),b(le)!=="svelte-1q30tw8"&&(le.innerHTML=Ts),ht=n(e),u(ie.$$.fragment,e),ft=n(e),de=d(e,"UL",{"data-svelte-h":!0}),b(de)!=="svelte-rxs8tv"&&(de.innerHTML=ws),_t=n(e),u(ce.$$.fragment,e),bt=n(e),me=d(e,"UL",{"data-svelte-h":!0}),b(me)!=="svelte-e6gv24"&&(me.innerHTML=js),Mt=n(e),u(pe.$$.fragment,e),vt=n(e),ue=d(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-dntm9d"&&(ue.innerHTML=ys),Tt=n(e),u(ge.$$.fragment,e),wt=n(e),he=d(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-yi1sug"&&(he.innerHTML=Js),jt=n(e),u(fe.$$.fragment,e),yt=n(e),k=d(e,"DIV",{class:!0});var R=x(k);u(_e.$$.fragment,R),Bt=n(R),De=d(R,"P",{"data-svelte-h":!0}),b(De)!=="svelte-q61ljn"&&(De.innerHTML=xs),Xt=n(R),Be=d(R,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-fgm5f9"&&(Be.innerHTML=ks),Nt=n(R),u(N.$$.fragment,R),R.forEach(s),Jt=n(e),u(be.$$.fragment,e),xt=n(e),z=d(e,"DIV",{class:!0});var B=x(z);u(Me.$$.fragment,B),Gt=n(B),Xe=d(B,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-1h1jbqe"&&(Xe.textContent=Us),Yt=n(B),G=d(B,"DIV",{class:!0});var Ce=x(G);u(ve.$$.fragment,Ce),Ft=n(Ce),Ne=d(Ce,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-1x3yxsa"&&(Ne.textContent=Is),Ce.forEach(s),B.forEach(s),kt=n(e),u(Te.$$.fragment,e),Ut=n(e),D=d(e,"DIV",{class:!0});var We=x(D);u(we.$$.fragment,We),qt=n(We),Y=d(We,"DIV",{class:!0});var Ve=x(Y);u(je.$$.fragment,Ve),Et=n(Ve),Ge=d(Ve,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-khengj"&&(Ge.textContent=Zs),Ve.forEach(s),We.forEach(s),It=n(e),u(ye.$$.fragment,e),Zt=n(e),v=d(e,"DIV",{class:!0});var y=x(v);u(Je.$$.fragment,y),St=n(y),Ye=d(y,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-13663wp"&&(Ye.textContent=zs),Ht=n(y),Fe=d(y,"P",{"data-svelte-h":!0}),b(Fe)!=="svelte-wxoenv"&&(Fe.innerHTML=$s),Pt=n(y),F=d(y,"DIV",{class:!0});var Wt=x(F);u(xe.$$.fragment,Wt),Lt=n(Wt),qe=d(Wt,"P",{"data-svelte-h":!0}),b(qe)!=="svelte-1ahfbom"&&(qe.innerHTML=Rs),Wt.forEach(s),Qt=n(y),C=d(y,"DIV",{class:!0});var Ae=x(C);u(ke.$$.fragment,Ae),At=n(Ae),Ee=d(Ae,"P",{"data-svelte-h":!0}),b(Ee)!=="svelte-1cj8dcb"&&(Ee.textContent=Cs),Kt=n(Ae),u(q.$$.fragment,Ae),Ae.forEach(s),Ot=n(y),W=d(y,"DIV",{class:!0});var Ke=x(W);u(Ue.$$.fragment,Ke),es=n(Ke),Se=d(Ke,"P",{"data-svelte-h":!0}),b(Se)!=="svelte-qsmudn"&&(Se.innerHTML=Ws),ts=n(Ke),u(E.$$.fragment,Ke),Ke.forEach(s),ss=n(y),S=d(y,"DIV",{class:!0});var Vt=x(S);u(Ie.$$.fragment,Vt),os=n(Vt),He=d(Vt,"P",{"data-svelte-h":!0}),b(He)!=="svelte-1bcwvdj"&&(He.innerHTML=Vs),Vt.forEach(s),ns=n(y),H=d(y,"DIV",{class:!0});var Dt=x(H);u(Ze.$$.fragment,Dt),as=n(Dt),Pe=d(Dt,"P",{"data-svelte-h":!0}),b(Pe)!=="svelte-73z65t"&&(Pe.innerHTML=Ds),Dt.forEach(s),y.forEach(s),zt=n(e),u(ze.$$.fragment,e),$t=n(e),$=d(e,"DIV",{class:!0});var Oe=x($);u($e.$$.fragment,Oe),rs=n(Oe),Le=d(Oe,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-gtr45t"&&(Le.innerHTML=Bs),ls=n(Oe),Z=d(Oe,"DIV",{class:!0});var Q=x(Z);u(Re.$$.fragment,Q),is=n(Q),Qe=d(Q,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-ieupvf"&&(Qe.innerHTML=Xs),ds=n(Q),u(P.$$.fragment,Q),cs=n(Q),u(L.$$.fragment,Q),Q.forEach(s),Oe.forEach(s),Rt=n(e),et=d(e,"P",{}),x(et).forEach(s),this.h()},h(){w(l,"name","hf:doc:metadata"),w(l,"content",Os),Ys(X.src,hs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/donut_architecture.jpg")||w(X,"src",hs),w(X,"alt","drawing"),w(X,"width","600"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,l),a(e,T,t),a(e,m,t),a(e,M,t),g(j,e,t),a(e,c,t),g(J,e,t),a(e,ot,t),a(e,A,t),a(e,nt,t),a(e,K,t),a(e,at,t),a(e,O,t),a(e,rt,t),a(e,X,t),a(e,lt,t),a(e,ee,t),a(e,it,t),a(e,te,t),a(e,dt,t),g(se,e,t),a(e,ct,t),a(e,oe,t),a(e,mt,t),g(ne,e,t),a(e,pt,t),a(e,ae,t),a(e,ut,t),a(e,re,t),a(e,gt,t),a(e,le,t),a(e,ht,t),g(ie,e,t),a(e,ft,t),a(e,de,t),a(e,_t,t),g(ce,e,t),a(e,bt,t),a(e,me,t),a(e,Mt,t),g(pe,e,t),a(e,vt,t),a(e,ue,t),a(e,Tt,t),g(ge,e,t),a(e,wt,t),a(e,he,t),a(e,jt,t),g(fe,e,t),a(e,yt,t),a(e,k,t),g(_e,k,null),r(k,Bt),r(k,De),r(k,Xt),r(k,Be),r(k,Nt),g(N,k,null),a(e,Jt,t),g(be,e,t),a(e,xt,t),a(e,z,t),g(Me,z,null),r(z,Gt),r(z,Xe),r(z,Yt),r(z,G),g(ve,G,null),r(G,Ft),r(G,Ne),a(e,kt,t),g(Te,e,t),a(e,Ut,t),a(e,D,t),g(we,D,null),r(D,qt),r(D,Y),g(je,Y,null),r(Y,Et),r(Y,Ge),a(e,It,t),g(ye,e,t),a(e,Zt,t),a(e,v,t),g(Je,v,null),r(v,St),r(v,Ye),r(v,Ht),r(v,Fe),r(v,Pt),r(v,F),g(xe,F,null),r(F,Lt),r(F,qe),r(v,Qt),r(v,C),g(ke,C,null),r(C,At),r(C,Ee),r(C,Kt),g(q,C,null),r(v,Ot),r(v,W),g(Ue,W,null),r(W,es),r(W,Se),r(W,ts),g(E,W,null),r(v,ss),r(v,S),g(Ie,S,null),r(S,os),r(S,He),r(v,ns),r(v,H),g(Ze,H,null),r(H,as),r(H,Pe),a(e,zt,t),g(ze,e,t),a(e,$t,t),a(e,$,t),g($e,$,null),r($,rs),r($,Le),r($,ls),r($,Z),g(Re,Z,null),r(Z,is),r(Z,Qe),r(Z,ds),g(P,Z,null),r(Z,cs),g(L,Z,null),a(e,Rt,t),a(e,et,t),Ct=!0},p(e,[t]){const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),N.$set(R);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),q.$set(B);const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),E.$set(Ce);const We={};t&2&&(We.$$scope={dirty:t,ctx:e}),P.$set(We);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),L.$set(Ve)},i(e){Ct||(h(j.$$.fragment,e),h(J.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(N.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(q.$$.fragment,e),h(Ue.$$.fragment,e),h(E.$$.fragment,e),h(Ie.$$.fragment,e),h(Ze.$$.fragment,e),h(ze.$$.fragment,e),h($e.$$.fragment,e),h(Re.$$.fragment,e),h(P.$$.fragment,e),h(L.$$.fragment,e),Ct=!0)},o(e){f(j.$$.fragment,e),f(J.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(N.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(je.$$.fragment,e),f(ye.$$.fragment,e),f(Je.$$.fragment,e),f(xe.$$.fragment,e),f(ke.$$.fragment,e),f(q.$$.fragment,e),f(Ue.$$.fragment,e),f(E.$$.fragment,e),f(Ie.$$.fragment,e),f(Ze.$$.fragment,e),f(ze.$$.fragment,e),f($e.$$.fragment,e),f(Re.$$.fragment,e),f(P.$$.fragment,e),f(L.$$.fragment,e),Ct=!1},d(e){e&&(s(T),s(m),s(M),s(c),s(ot),s(A),s(nt),s(K),s(at),s(O),s(rt),s(X),s(lt),s(ee),s(it),s(te),s(dt),s(ct),s(oe),s(mt),s(pt),s(ae),s(ut),s(re),s(gt),s(le),s(ht),s(ft),s(de),s(_t),s(bt),s(me),s(Mt),s(vt),s(ue),s(Tt),s(wt),s(he),s(jt),s(yt),s(k),s(Jt),s(xt),s(z),s(kt),s(Ut),s(D),s(It),s(Zt),s(v),s(zt),s($t),s($),s(Rt),s(et)),s(l),_(j,e),_(J,e),_(se,e),_(ne,e),_(ie,e),_(ce,e),_(pe,e),_(ge,e),_(fe,e),_(_e),_(N),_(be,e),_(Me),_(ve),_(Te,e),_(we),_(je),_(ye,e),_(Je),_(xe),_(ke),_(q),_(Ue),_(E),_(Ie),_(Ze),_(ze,e),_($e),_(Re),_(P),_(L)}}}const Os='{"title":"Donut","local":"donut","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Inference examples","local":"inference-examples","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"DonutSwinConfig","local":"transformers.DonutSwinConfig","sections":[],"depth":2},{"title":"DonutImageProcessor","local":"transformers.DonutImageProcessor","sections":[],"depth":2},{"title":"DonutFeatureExtractor","local":"transformers.DonutFeatureExtractor","sections":[],"depth":2},{"title":"DonutProcessor","local":"transformers.DonutProcessor","sections":[],"depth":2},{"title":"DonutSwinModel","local":"transformers.DonutSwinModel","sections":[],"depth":2}],"depth":1}';function eo(I){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class io extends qs{constructor(l){super(),Es(this,l,eo,Ks,Gs,{})}}export{io as component};
