import{s as $t,n as Ct,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as vt,i as Wt,g as p,s as l,r as m,A as kt,h as i,f as a,c as n,j as Ut,u as o,x as g,k as It,y as Bt,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as xt}from"../chunks/getInferenceSnippets.96f6e3ee.js";function Gt(Mt){let y,R,X,S,d,z,J,gt='<strong>Inception-v4</strong> is a convolutional neural network architecture that builds on previous iterations of the Inception family by simplifying the architecture and using more inception modules than <a href="https://paperswithcode.com/method/inception-v3" rel="nofollow">Inception-v3</a>.',H,u,F,j,yt="To load a pretrained model:",A,w,L,T,dt="To load and preprocess the image:",D,f,q,b,Jt="To get the model predictions:",P,U,K,I,ut="To get the top-5 predictions class names:",O,$,tt,C,jt="Replace the model name with the variant you want to use, e.g. <code>inception_v4</code>. You can find the IDs in the model summaries at the top of this page.",st,Z,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,v,et,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,k,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,x,it,G,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,N,ot,Q,ct,E,rt,_,ht;return d=new Y({props:{title:"Inception v4",local:"inception-v4",headingTag:"h1"}}),u=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92NCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Y0JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),E=new xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/inception-v4.mdx"}}),{c(){y=p("meta"),R=l(),X=p("p"),S=l(),m(d.$$.fragment),z=l(),J=p("p"),J.innerHTML=gt,H=l(),m(u.$$.fragment),F=l(),j=p("p"),j.textContent=yt,A=l(),m(w.$$.fragment),L=l(),T=p("p"),T.textContent=dt,D=l(),m(f.$$.fragment),q=l(),b=p("p"),b.textContent=Jt,P=l(),m(U.$$.fragment),K=l(),I=p("p"),I.textContent=ut,O=l(),m($.$$.fragment),tt=l(),C=p("p"),C.innerHTML=jt,st=l(),Z=p("p"),Z.innerHTML=wt,at=l(),m(v.$$.fragment),et=l(),W=p("p"),W.textContent=Tt,lt=l(),m(k.$$.fragment),nt=l(),B=p("p"),B.innerHTML=ft,pt=l(),m(x.$$.fragment),it=l(),G=p("p"),G.innerHTML=bt,mt=l(),m(N.$$.fragment),ot=l(),m(Q.$$.fragment),ct=l(),m(E.$$.fragment),rt=l(),_=p("p"),this.h()},l(t){const s=kt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(a),R=n(t),X=i(t,"P",{}),Ut(X).forEach(a),S=n(t),o(d.$$.fragment,t),z=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-884pc9"&&(J.innerHTML=gt),H=n(t),o(u.$$.fragment,t),F=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=yt),A=n(t),o(w.$$.fragment,t),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=dt),D=n(t),o(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),P=n(t),o(U.$$.fragment,t),K=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=ut),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-r4n0mi"&&(C.innerHTML=jt),st=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=wt),at=n(t),o(v.$$.fragment,t),et=n(t),W=i(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),lt=n(t),o(k.$$.fragment,t),nt=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(x.$$.fragment,t),it=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-xtxxu6"&&(G.innerHTML=bt),mt=n(t),o(N.$$.fragment,t),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(E.$$.fragment,t),rt=n(t),_=i(t,"P",{}),Ut(_).forEach(a),this.h()},h(){It(y,"name","hf:doc:metadata"),It(y,"content",Nt)},m(t,s){Bt(document.head,y),e(t,R,s),e(t,X,s),e(t,S,s),c(d,t,s),e(t,z,s),e(t,J,s),e(t,H,s),c(u,t,s),e(t,F,s),e(t,j,s),e(t,A,s),c(w,t,s),e(t,L,s),e(t,T,s),e(t,D,s),c(f,t,s),e(t,q,s),e(t,b,s),e(t,P,s),c(U,t,s),e(t,K,s),e(t,I,s),e(t,O,s),c($,t,s),e(t,tt,s),e(t,C,s),e(t,st,s),e(t,Z,s),e(t,at,s),c(v,t,s),e(t,et,s),e(t,W,s),e(t,lt,s),c(k,t,s),e(t,nt,s),e(t,B,s),e(t,pt,s),c(x,t,s),e(t,it,s),e(t,G,s),e(t,mt,s),c(N,t,s),e(t,ot,s),c(Q,t,s),e(t,ct,s),c(E,t,s),e(t,rt,s),e(t,_,s),ht=!0},p:Ct,i(t){ht||(r(d.$$.fragment,t),r(u.$$.fragment,t),r(w.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r($.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(x.$$.fragment,t),r(N.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(u.$$.fragment,t),h(w.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(v.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),ht=!1},d(t){t&&(a(R),a(X),a(S),a(z),a(J),a(H),a(F),a(j),a(A),a(L),a(T),a(D),a(q),a(b),a(P),a(K),a(I),a(O),a(tt),a(C),a(st),a(Z),a(at),a(et),a(W),a(lt),a(nt),a(B),a(pt),a(it),a(G),a(mt),a(ot),a(ct),a(rt),a(_)),a(y),M(d,t),M(u,t),M(w,t),M(f,t),M(U,t),M($,t),M(v,t),M(k,t),M(x,t),M(N,t),M(Q,t),M(E,t)}}}const Nt='{"title":"Inception v4","local":"inception-v4","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends vt{constructor(y){super(),Wt(this,y,Qt,Gt,$t,{})}}export{Yt as component};
