import{s as $t,n as Zt,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as kt,g as p,s as l,r as m,A as Nt,h as i,f as e,c as n,j as Ut,u as o,x as g,k as It,y as Bt,a,v as r,d as h,t as c,w as M}from"../chunks/index.c9837788.js";import{C as Y}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Gt}from"../chunks/getInferenceSnippets.96f6e3ee.js";function xt(Mt){let d,X,R,z,y,H,J,gt='<strong>ResNet-D</strong> is a modification on the <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> architecture that utilises an <a href="https://paperswithcode.com/method/average-pooling" rel="nofollow">average pooling</a> tweak for downsampling. The motivation is that in the unmodified ResNet, the <a href="https://paperswithcode.com/method/1x1-convolution" rel="nofollow">1×1 convolution</a> for the downsampling block ignores 3/4 of input feature maps, so this is modified so no information will be ignored',S,w,F,j,dt="To load a pretrained model:",A,u,L,T,yt="To load and preprocess the image:",D,f,q,b,Jt="To get the model predictions:",P,U,K,I,wt="To get the top-5 predictions class names:",O,$,tt,Z,jt="Replace the model name with the variant you want to use, e.g. <code>resnet101d</code>. You can find the IDs in the model summaries at the top of this page.",st,C,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,at,k,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,N,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,G,it,x,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,v,ot,E,rt,Q,ht,V,ct;return y=new _({props:{title:"ResNet-D",local:"resnet-d",headingTag:"h1"}}),w=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Y({props:{code:"JTQwbWlzYyU3QmhlMjAxOGJhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQmFnJTIwb2YlMjBUcmlja3MlMjBmb3IlMjBJbWFnZSUyMENsYXNzaWZpY2F0aW9uJTIwd2l0aCUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRvbmclMjBIZSUyMGFuZCUyMFpoaSUyMFpoYW5nJTIwYW5kJTIwSGFuZyUyMFpoYW5nJTIwYW5kJTIwWmhvbmd5dWUlMjBaaGFuZyUyMGFuZCUyMEp1bnl1YW4lMjBYaWUlMjBhbmQlMjBNdSUyMExpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODEyLjAxMTg3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{he<span class="hljs-symbol">2018b</span>ag,
      title={<span class="hljs-keyword">Bag </span>of Tricks for Image Classification with Convolutional Neural Networks}, 
      author={Tong He <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Hang Zhang <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span><span class="hljs-keyword">Junyuan </span>Xie <span class="hljs-keyword">and </span>Mu Li},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">01187</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new Gt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/resnet-d.mdx"}}),{c(){d=p("meta"),X=l(),R=p("p"),z=l(),m(y.$$.fragment),H=l(),J=p("p"),J.innerHTML=gt,S=l(),m(w.$$.fragment),F=l(),j=p("p"),j.textContent=dt,A=l(),m(u.$$.fragment),L=l(),T=p("p"),T.textContent=yt,D=l(),m(f.$$.fragment),q=l(),b=p("p"),b.textContent=Jt,P=l(),m(U.$$.fragment),K=l(),I=p("p"),I.textContent=wt,O=l(),m($.$$.fragment),tt=l(),Z=p("p"),Z.innerHTML=jt,st=l(),C=p("p"),C.innerHTML=ut,et=l(),m(W.$$.fragment),at=l(),k=p("p"),k.textContent=Tt,lt=l(),m(N.$$.fragment),nt=l(),B=p("p"),B.innerHTML=ft,pt=l(),m(G.$$.fragment),it=l(),x=p("p"),x.innerHTML=bt,mt=l(),m(v.$$.fragment),ot=l(),m(E.$$.fragment),rt=l(),m(Q.$$.fragment),ht=l(),V=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),R=i(t,"P",{}),Ut(R).forEach(e),z=n(t),o(y.$$.fragment,t),H=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-8lziuy"&&(J.innerHTML=gt),S=n(t),o(w.$$.fragment,t),F=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=dt),A=n(t),o(u.$$.fragment,t),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=yt),D=n(t),o(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),P=n(t),o(U.$$.fragment,t),K=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1iogwu7"&&(Z.innerHTML=jt),st=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1wmi3ea"&&(C.innerHTML=ut),et=n(t),o(W.$$.fragment,t),at=n(t),k=i(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-9sr7nh"&&(k.textContent=Tt),lt=n(t),o(N.$$.fragment,t),nt=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(G.$$.fragment,t),it=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-xtxxu6"&&(x.innerHTML=bt),mt=n(t),o(v.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ht=n(t),V=i(t,"P",{}),Ut(V).forEach(e),this.h()},h(){It(d,"name","hf:doc:metadata"),It(d,"content",vt)},m(t,s){Bt(document.head,d),a(t,X,s),a(t,R,s),a(t,z,s),r(y,t,s),a(t,H,s),a(t,J,s),a(t,S,s),r(w,t,s),a(t,F,s),a(t,j,s),a(t,A,s),r(u,t,s),a(t,L,s),a(t,T,s),a(t,D,s),r(f,t,s),a(t,q,s),a(t,b,s),a(t,P,s),r(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,Z,s),a(t,st,s),a(t,C,s),a(t,et,s),r(W,t,s),a(t,at,s),a(t,k,s),a(t,lt,s),r(N,t,s),a(t,nt,s),a(t,B,s),a(t,pt,s),r(G,t,s),a(t,it,s),a(t,x,s),a(t,mt,s),r(v,t,s),a(t,ot,s),r(E,t,s),a(t,rt,s),r(Q,t,s),a(t,ht,s),a(t,V,s),ct=!0},p:Zt,i(t){ct||(h(y.$$.fragment,t),h(w.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(G.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ct=!0)},o(t){c(y.$$.fragment,t),c(w.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(N.$$.fragment,t),c(G.$$.fragment,t),c(v.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),ct=!1},d(t){t&&(e(X),e(R),e(z),e(H),e(J),e(S),e(F),e(j),e(A),e(L),e(T),e(D),e(q),e(b),e(P),e(K),e(I),e(O),e(tt),e(Z),e(st),e(C),e(et),e(at),e(k),e(lt),e(nt),e(B),e(pt),e(it),e(x),e(mt),e(ot),e(rt),e(ht),e(V)),e(d),M(y,t),M(w,t),M(u,t),M(f,t),M(U,t),M($,t),M(W,t),M(N,t),M(G,t),M(v,t),M(E,t),M(Q,t)}}}const vt='{"title":"ResNet-D","local":"resnet-d","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Wt{constructor(d){super(),kt(this,d,Et,xt,$t,{})}}export{_t as component};
