import{s as xt,n as Ct,o as kt}from"../chunks/scheduler.85c25b89.js";import{S as Bt,i as Gt,g as p,s as a,r as m,A as vt,h as i,f as e,c as n,j as Wt,u as o,x as M,k as Zt,y as Nt,a as l,v as r,d as c,t as h,w as J}from"../chunks/index.c9837788.js";import{C as Y}from"../chunks/CodeBlock.e573519b.js";import{H as R,E as Et}from"../chunks/getInferenceSnippets.96f6e3ee.js";function _t(gt){let g,H,X,F,d,z,w,dt="<strong>AdvProp</strong> is an adversarial training scheme which treats adversarial examples as additional examples, to prevent overfitting. Key to the method is the usage of a separate auxiliary batch norm for adversarial examples, as they have different underlying distributions to normal examples.",A,T,wt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',S,y,L,j,Tt="To load a pretrained model:",P,f,q,u,yt="To load and preprocess the image:",D,b,K,U,jt="To get the model predictions:",O,I,tt,$,ft="To get the top-5 predictions class names:",st,W,et,Z,ut="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ap</code>. You can find the IDs in the model summaries at the top of this page.",lt,x,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,C,nt,k,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,B,it,G,It=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,v,ot,N,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,E,ct,_,ht,Q,Jt,V,Mt;return d=new R({props:{title:"AdvProp (EfficientNet)",local:"advprop-efficientnet",headingTag:"h1"}}),y=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9hcCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),W=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX2FwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new Y({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBhZHZlcnNhcmlhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQWR2ZXJzYXJpYWwlMjBFeGFtcGxlcyUyMEltcHJvdmUlMjBJbWFnZSUyMFJlY29nbml0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2loYW5nJTIwWGllJTIwYW5kJTIwTWluZ3hpbmclMjBUYW4lMjBhbmQlMjBCb3FpbmclMjBHb25nJTIwYW5kJTIwSmlhbmclMjBXYW5nJTIwYW5kJTIwQWxhbiUyMFl1aWxsZSUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTExLjA5NjY1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{xie2020adversarial,
      title={Adversarial Examples Improve Image Recognition}, 
      author={Cihang Xie <span class="hljs-keyword">and </span>Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Boqing </span>Gong <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiang </span>Wang <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">09665</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/advprop.mdx"}}),{c(){g=p("meta"),H=a(),X=p("p"),F=a(),m(d.$$.fragment),z=a(),w=p("p"),w.innerHTML=dt,A=a(),T=p("p"),T.innerHTML=wt,S=a(),m(y.$$.fragment),L=a(),j=p("p"),j.textContent=Tt,P=a(),m(f.$$.fragment),q=a(),u=p("p"),u.textContent=yt,D=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=jt,O=a(),m(I.$$.fragment),tt=a(),$=p("p"),$.textContent=ft,st=a(),m(W.$$.fragment),et=a(),Z=p("p"),Z.innerHTML=ut,lt=a(),x=p("p"),x.innerHTML=bt,at=a(),m(C.$$.fragment),nt=a(),k=p("p"),k.textContent=Ut,pt=a(),m(B.$$.fragment),it=a(),G=p("p"),G.innerHTML=It,mt=a(),m(v.$$.fragment),ot=a(),N=p("p"),N.innerHTML=$t,rt=a(),m(E.$$.fragment),ct=a(),m(_.$$.fragment),ht=a(),m(Q.$$.fragment),Jt=a(),V=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(e),H=n(t),X=i(t,"P",{}),Wt(X).forEach(e),F=n(t),o(d.$$.fragment,t),z=n(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1x6a5c1"&&(w.innerHTML=dt),A=n(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-k8hpf1"&&(T.innerHTML=wt),S=n(t),o(y.$$.fragment,t),L=n(t),j=i(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-18ywhxh"&&(j.textContent=Tt),P=n(t),o(f.$$.fragment,t),q=n(t),u=i(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=yt),D=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o(I.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-19cnvx1"&&($.textContent=ft),st=n(t),o(W.$$.fragment,t),et=n(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-m13wpe"&&(Z.innerHTML=ut),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1wmi3ea"&&(x.innerHTML=bt),at=n(t),o(C.$$.fragment,t),nt=n(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-9sr7nh"&&(k.textContent=Ut),pt=n(t),o(B.$$.fragment,t),it=n(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1kguc51"&&(G.innerHTML=It),mt=n(t),o(v.$$.fragment,t),ot=n(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-xtxxu6"&&(N.innerHTML=$t),rt=n(t),o(E.$$.fragment,t),ct=n(t),o(_.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),Jt=n(t),V=i(t,"P",{}),Wt(V).forEach(e),this.h()},h(){Zt(g,"name","hf:doc:metadata"),Zt(g,"content",Qt)},m(t,s){Nt(document.head,g),l(t,H,s),l(t,X,s),l(t,F,s),r(d,t,s),l(t,z,s),l(t,w,s),l(t,A,s),l(t,T,s),l(t,S,s),r(y,t,s),l(t,L,s),l(t,j,s),l(t,P,s),r(f,t,s),l(t,q,s),l(t,u,s),l(t,D,s),r(b,t,s),l(t,K,s),l(t,U,s),l(t,O,s),r(I,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(W,t,s),l(t,et,s),l(t,Z,s),l(t,lt,s),l(t,x,s),l(t,at,s),r(C,t,s),l(t,nt,s),l(t,k,s),l(t,pt,s),r(B,t,s),l(t,it,s),l(t,G,s),l(t,mt,s),r(v,t,s),l(t,ot,s),l(t,N,s),l(t,rt,s),r(E,t,s),l(t,ct,s),r(_,t,s),l(t,ht,s),r(Q,t,s),l(t,Jt,s),l(t,V,s),Mt=!0},p:Ct,i(t){Mt||(c(d.$$.fragment,t),c(y.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c(I.$$.fragment,t),c(W.$$.fragment,t),c(C.$$.fragment,t),c(B.$$.fragment,t),c(v.$$.fragment,t),c(E.$$.fragment,t),c(_.$$.fragment,t),c(Q.$$.fragment,t),Mt=!0)},o(t){h(d.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h(W.$$.fragment,t),h(C.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),h(Q.$$.fragment,t),Mt=!1},d(t){t&&(e(H),e(X),e(F),e(z),e(w),e(A),e(T),e(S),e(L),e(j),e(P),e(q),e(u),e(D),e(K),e(U),e(O),e(tt),e($),e(st),e(et),e(Z),e(lt),e(x),e(at),e(nt),e(k),e(pt),e(it),e(G),e(mt),e(ot),e(N),e(rt),e(ct),e(ht),e(Jt),e(V)),e(g),J(d,t),J(y,t),J(f,t),J(b,t),J(I,t),J(W,t),J(C,t),J(B,t),J(v,t),J(E,t),J(_,t),J(Q,t)}}}const Qt='{"title":"AdvProp (EfficientNet)","local":"advprop-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yt(gt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Bt{constructor(g){super(),Gt(this,g,Yt,_t,xt,{})}}export{Ft as component};
