import{s as Mt,o as bt,n as wt}from"../chunks/scheduler.c57aa7ef.js";import{S as Tt,i as yt,g as s,s as n,r as m,A as gt,h as o,f as l,c as i,j as ht,u as f,x as r,k as ct,y as Jt,a,v as u,d,t as h,w as c}from"../chunks/index.c50cb18e.js";import{T as _t}from"../chunks/Tip.9268b0ca.js";import{C as g}from"../chunks/CodeBlock.34f0a53d.js";import{H as ie}from"../chunks/Heading.c7d7e0e7.js";function $t(oe){let p,_='LoftQ initialization does not require quantizing the base model with the <code>load_in_4bits</code> parameter in the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method! Learn more about LoftQ initialization in the <a href="../developer_guides/lora#initialization">Initialization options</a> section.',T,b,y="Note: You can only perform LoftQ initialization on a GPU.";return{c(){p=s("p"),p.innerHTML=_,T=n(),b=s("p"),b.textContent=y},l(M){p=o(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p70fnx"&&(p.innerHTML=_),T=i(M),b=o(M,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1rnmx2i"&&(b.textContent=y)},m(M,w){a(M,p,w),a(M,T,w),a(M,b,w)},p:wt,d(M){M&&(l(p),l(T),l(b))}}}function qt(oe){let p,_,T,b,y,M,w,Ve="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",re,$,He='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',pe,q,Ye='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',me,j,Pe="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",fe,v,ue,C,Se='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',de,L,De="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",he,B,ce,U,Ke='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Me,Q,be,Z,Oe='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for traininng.',we,z,Te,I,et="Now that the quantized model is ready, let’s set up a configuration.",ye,k,ge,x,tt='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Je,R,_e,A,lt='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',$e,W,qe,E,at="You’re all set for training with whichever training method you prefer!",je,G,ve,X,nt='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, create a <code>LoftQConfig</code> and set <code>loftq_bits=4</code> for 4-bit quantization.',Ce,J,Le,F,Be,N,it='Now pass the <code>loftq_config</code> to the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> to enable LoftQ initialization, and create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> for training.',Ue,V,Qe,H,Ze,Y,st="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",ze,P,Ie,S,ke,D,ot='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',xe,K,rt='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Re,O,pt="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",Ae,ee,We,te,mt='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Ee,le,Ge,ae,ft="If you’re interested in learning more about quantization, the following may be helpful:",Xe,ne,ut='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Fe,se,Ne;return y=new ie({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),v=new ie({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),B=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),Q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),z=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),k=new ie({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),R=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),W=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),G=new ie({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),J=new _t({props:{warning:!0,$$slots:{default:[$t]},$$scope:{ctx:oe}}}),F=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWxvZnRxX2NvbmZpZyUyMCUzRCUyMExvZnRRQ29uZmlnKGxvZnRxX2JpdHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>)`,wrap:!1}}),V=new g({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIybG9mdHElMjIlMkMlMEElMjAlMjAlMjAlMjBsb2Z0cV9jb25maWclM0Rsb2Z0cV9jb25maWclMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyk=",highlighted:`lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>,
    loftq_config=loftq_config,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, lora_config)`,wrap:!1}}),H=new ie({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),P=new g({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),S=new ie({props:{title:"AQLM quantizaion",local:"aqlm-quantizaion",headingTag:"h2"}}),ee=new g({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),le=new ie({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){p=s("meta"),_=n(),T=s("p"),b=n(),m(y.$$.fragment),M=n(),w=s("p"),w.textContent=Ve,re=n(),$=s("ul"),$.innerHTML=He,pe=n(),q=s("p"),q.innerHTML=Ye,me=n(),j=s("p"),j.textContent=Pe,fe=n(),m(v.$$.fragment),ue=n(),C=s("p"),C.innerHTML=Se,de=n(),L=s("ul"),L.innerHTML=De,he=n(),m(B.$$.fragment),ce=n(),U=s("p"),U.innerHTML=Ke,Me=n(),m(Q.$$.fragment),be=n(),Z=s("p"),Z.innerHTML=Oe,we=n(),m(z.$$.fragment),Te=n(),I=s("p"),I.textContent=et,ye=n(),m(k.$$.fragment),ge=n(),x=s("p"),x.innerHTML=tt,Je=n(),m(R.$$.fragment),_e=n(),A=s("p"),A.innerHTML=lt,$e=n(),m(W.$$.fragment),qe=n(),E=s("p"),E.textContent=at,je=n(),m(G.$$.fragment),ve=n(),X=s("p"),X.innerHTML=nt,Ce=n(),m(J.$$.fragment),Le=n(),m(F.$$.fragment),Be=n(),N=s("p"),N.innerHTML=it,Ue=n(),m(V.$$.fragment),Qe=n(),m(H.$$.fragment),Ze=n(),Y=s("p"),Y.innerHTML=st,ze=n(),m(P.$$.fragment),Ie=n(),m(S.$$.fragment),ke=n(),D=s("p"),D.innerHTML=ot,xe=n(),K=s("p"),K.innerHTML=rt,Re=n(),O=s("p"),O.innerHTML=pt,Ae=n(),m(ee.$$.fragment),We=n(),te=s("p"),te.innerHTML=mt,Ee=n(),m(le.$$.fragment),Ge=n(),ae=s("p"),ae.textContent=ft,Xe=n(),ne=s("ul"),ne.innerHTML=ut,Fe=n(),se=s("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),_=i(e),T=o(e,"P",{}),ht(T).forEach(l),b=i(e),f(y.$$.fragment,e),M=i(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=Ve),re=i(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-27c91"&&($.innerHTML=He),pe=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-142xot4"&&(q.innerHTML=Ye),me=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1demhiu"&&(j.textContent=Pe),fe=i(e),f(v.$$.fragment,e),ue=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-p0gbf4"&&(C.innerHTML=Se),de=i(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-hfynw8"&&(L.innerHTML=De),he=i(e),f(B.$$.fragment,e),ce=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-pxonbi"&&(U.innerHTML=Ke),Me=i(e),f(Q.$$.fragment,e),be=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1v2z8y6"&&(Z.innerHTML=Oe),we=i(e),f(z.$$.fragment,e),Te=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-11mx7fc"&&(I.textContent=et),ye=i(e),f(k.$$.fragment,e),ge=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-16xpk8c"&&(x.innerHTML=tt),Je=i(e),f(R.$$.fragment,e),_e=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-rnh6oi"&&(A.innerHTML=lt),$e=i(e),f(W.$$.fragment,e),qe=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-xd402n"&&(E.textContent=at),je=i(e),f(G.$$.fragment,e),ve=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-g845ls"&&(X.innerHTML=nt),Ce=i(e),f(J.$$.fragment,e),Le=i(e),f(F.$$.fragment,e),Be=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-5zbxqc"&&(N.innerHTML=it),Ue=i(e),f(V.$$.fragment,e),Qe=i(e),f(H.$$.fragment,e),Ze=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1c7jiea"&&(Y.innerHTML=st),ze=i(e),f(P.$$.fragment,e),Ie=i(e),f(S.$$.fragment,e),ke=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-h7ytse"&&(D.innerHTML=ot),xe=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-120mr43"&&(K.innerHTML=rt),Re=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wlm3ol"&&(O.innerHTML=pt),Ae=i(e),f(ee.$$.fragment,e),We=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1f1bzer"&&(te.innerHTML=mt),Ee=i(e),f(le.$$.fragment,e),Ge=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-agdyn7"&&(ae.textContent=ft),Xe=i(e),ne=o(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-83nivc"&&(ne.innerHTML=ut),Fe=i(e),se=o(e,"P",{}),ht(se).forEach(l),this.h()},h(){ct(p,"name","hf:doc:metadata"),ct(p,"content",jt)},m(e,t){Jt(document.head,p),a(e,_,t),a(e,T,t),a(e,b,t),u(y,e,t),a(e,M,t),a(e,w,t),a(e,re,t),a(e,$,t),a(e,pe,t),a(e,q,t),a(e,me,t),a(e,j,t),a(e,fe,t),u(v,e,t),a(e,ue,t),a(e,C,t),a(e,de,t),a(e,L,t),a(e,he,t),u(B,e,t),a(e,ce,t),a(e,U,t),a(e,Me,t),u(Q,e,t),a(e,be,t),a(e,Z,t),a(e,we,t),u(z,e,t),a(e,Te,t),a(e,I,t),a(e,ye,t),u(k,e,t),a(e,ge,t),a(e,x,t),a(e,Je,t),u(R,e,t),a(e,_e,t),a(e,A,t),a(e,$e,t),u(W,e,t),a(e,qe,t),a(e,E,t),a(e,je,t),u(G,e,t),a(e,ve,t),a(e,X,t),a(e,Ce,t),u(J,e,t),a(e,Le,t),u(F,e,t),a(e,Be,t),a(e,N,t),a(e,Ue,t),u(V,e,t),a(e,Qe,t),u(H,e,t),a(e,Ze,t),a(e,Y,t),a(e,ze,t),u(P,e,t),a(e,Ie,t),u(S,e,t),a(e,ke,t),a(e,D,t),a(e,xe,t),a(e,K,t),a(e,Re,t),a(e,O,t),a(e,Ae,t),u(ee,e,t),a(e,We,t),a(e,te,t),a(e,Ee,t),u(le,e,t),a(e,Ge,t),a(e,ae,t),a(e,Xe,t),a(e,ne,t),a(e,Fe,t),a(e,se,t),Ne=!0},p(e,[t]){const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),J.$set(dt)},i(e){Ne||(d(y.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d(G.$$.fragment,e),d(J.$$.fragment,e),d(F.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(P.$$.fragment,e),d(S.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),Ne=!0)},o(e){h(y.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),h(k.$$.fragment,e),h(R.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(F.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(S.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),Ne=!1},d(e){e&&(l(_),l(T),l(b),l(M),l(w),l(re),l($),l(pe),l(q),l(me),l(j),l(fe),l(ue),l(C),l(de),l(L),l(he),l(ce),l(U),l(Me),l(be),l(Z),l(we),l(Te),l(I),l(ye),l(ge),l(x),l(Je),l(_e),l(A),l($e),l(qe),l(E),l(je),l(ve),l(X),l(Ce),l(Le),l(Be),l(N),l(Ue),l(Qe),l(Ze),l(Y),l(ze),l(Ie),l(ke),l(D),l(xe),l(K),l(Re),l(O),l(Ae),l(We),l(te),l(Ee),l(Ge),l(ae),l(Xe),l(ne),l(Fe),l(se)),l(p),c(y,e),c(v,e),c(B,e),c(Q,e),c(z,e),c(k,e),c(R,e),c(W,e),c(G,e),c(J,e),c(F,e),c(V,e),c(H,e),c(P,e),c(S,e),c(ee,e),c(le,e)}}}const jt='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantizaion","local":"aqlm-quantizaion","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function vt(oe){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends Tt{constructor(p){super(),yt(this,p,vt,qt,Mt,{})}}export{Zt as component};
