import{s as ue,n as Je,o as ge}from"../chunks/scheduler.85c25b89.js";import{S as ye,i as je,g as l,s as o,u as c,A as fe,h as n,f as e,c as i,j as h,v as d,y as m,k as p,o as r,a,w as M,d as w,t as u,x as J}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(St){let g,ht,st,mt,y,v,at,C,Qt,D,Ft="MnasNet",ct,$,Ht='<strong>MnasNet</strong> is a type of convolutional neural network optimized for mobile devices that is discovered through mobile neural architecture search, which explicitly incorporates model latency into the main objective so that the search can identify a model that achieves a good trade-off between accuracy and latency. The main building block is an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual block</a> (from <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>).',dt,j,U,lt,N,Vt,q,zt="How do I use this model on an image?",Mt,Z,Pt="To load a pretrained model:",wt,B,ut,W,Lt="To load and preprocess the image:",Jt,E,gt,_,Dt="To get the model predictions:",yt,G,jt,A,qt="To get the top-5 predictions class names:",ft,Q,Tt,V,Kt="Replace the model name with the variant you want to use, e.g. <code>mnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",bt,Y,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,I,nt,R,Yt,K,te="How do I finetune this model?",Ut,X,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",It,S,kt,F,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,T,k,ot,H,Rt,O,ae="How do I train this model?",Ct,z,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,x,it,P,Xt,tt,ne="Citation",Nt,L,Zt,pt,Bt;return C=new rt({}),N=new rt({}),B=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21uYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new rt({}),S=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW5hc25ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),H=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltbmFzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNbmFzTmV0JTNBJTIwUGxhdGZvcm0tQXdhcmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glMjBmb3IlMjBNb2JpbGUlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMEJvJTIwQ2hlbiUyMGFuZCUyMFJ1b21pbmclMjBQYW5nJTIwYW5kJTIwVmlqYXklMjBWYXN1ZGV2YW4lMjBhbmQlMjBNYXJrJTIwU2FuZGxlciUyMGFuZCUyMEFuZHJldyUyMEhvd2FyZCUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODA3LjExNjI2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{tan2019mnasnet,
      title={MnasNet: Platform-Aware Neural Architecture Search for Mobile}, 
      author={Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Bo </span>Chen <span class="hljs-keyword">and </span>Ruoming Pang <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span>Mark Sandler <span class="hljs-keyword">and </span><span class="hljs-keyword">Andrew </span>Howard <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1807</span>.<span class="hljs-number">11626</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=l("meta"),ht=o(),st=l("p"),mt=o(),y=l("h1"),v=l("a"),at=l("span"),c(C.$$.fragment),Qt=o(),D=l("span"),D.textContent=Ft,ct=o(),$=l("p"),$.innerHTML=Ht,dt=o(),j=l("h2"),U=l("a"),lt=l("span"),c(N.$$.fragment),Vt=o(),q=l("span"),q.textContent=zt,Mt=o(),Z=l("p"),Z.textContent=Pt,wt=o(),c(B.$$.fragment),ut=o(),W=l("p"),W.textContent=Lt,Jt=o(),c(E.$$.fragment),gt=o(),_=l("p"),_.textContent=Dt,yt=o(),c(G.$$.fragment),jt=o(),A=l("p"),A.textContent=qt,ft=o(),c(Q.$$.fragment),Tt=o(),V=l("p"),V.innerHTML=Kt,bt=o(),Y=l("p"),Y.innerHTML=Ot,vt=o(),f=l("h2"),I=l("a"),nt=l("span"),c(R.$$.fragment),Yt=o(),K=l("span"),K.textContent=te,Ut=o(),X=l("p"),X.textContent=ee,It=o(),c(S.$$.fragment),kt=o(),F=l("p"),F.innerHTML=se,xt=o(),T=l("h2"),k=l("a"),ot=l("span"),c(H.$$.fragment),Rt=o(),O=l("span"),O.textContent=ae,Ct=o(),z=l("p"),z.innerHTML=le,$t=o(),b=l("h2"),x=l("a"),it=l("span"),c(P.$$.fragment),Xt=o(),tt=l("span"),tt.textContent=ne,Nt=o(),c(L.$$.fragment),Zt=o(),pt=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),st=n(t,"P",{}),h(st).forEach(e),mt=i(t),y=n(t,"H1",{class:!0});var Wt=h(y);v=n(Wt,"A",{id:!0,class:!0,href:!0});var oe=h(v);at=n(oe,"SPAN",{});var ie=h(at);d(C.$$.fragment,ie),ie.forEach(e),oe.forEach(e),Qt=i(Wt),D=n(Wt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-rmmgf5"&&(D.textContent=Ft),Wt.forEach(e),ct=i(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1b8hcw9"&&($.innerHTML=Ht),dt=i(t),j=n(t,"H2",{class:!0});var Et=h(j);U=n(Et,"A",{id:!0,class:!0,href:!0});var pe=h(U);lt=n(pe,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),pe.forEach(e),Vt=i(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),Et.forEach(e),Mt=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Pt),wt=i(t),d(B.$$.fragment,t),ut=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),Jt=i(t),d(E.$$.fragment,t),gt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),yt=i(t),d(G.$$.fragment,t),jt=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-19cnvx1"&&(A.textContent=qt),ft=i(t),d(Q.$$.fragment,t),Tt=i(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1jw4zc0"&&(V.innerHTML=Kt),bt=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=Ot),vt=i(t),f=n(t,"H2",{class:!0});var _t=h(f);I=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(I);nt=n(he,"SPAN",{});var me=h(nt);d(R.$$.fragment,me),me.forEach(e),he.forEach(e),Yt=i(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-9sr7nh"&&(X.textContent=ee),It=i(t),d(S.$$.fragment,t),kt=i(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1kguc51"&&(F.innerHTML=se),xt=i(t),T=n(t,"H2",{class:!0});var Gt=h(T);k=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(k);ot=n(ce,"SPAN",{});var de=h(ot);d(H.$$.fragment,de),de.forEach(e),ce.forEach(e),Rt=i(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),Ct=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=le),$t=i(t),b=n(t,"H2",{class:!0});var At=h(b);x=n(At,"A",{id:!0,class:!0,href:!0});var Me=h(x);it=n(Me,"SPAN",{});var we=h(it);d(P.$$.fragment,we),we.forEach(e),Me.forEach(e),Xt=i(At),tt=n(At,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),At.forEach(e),Nt=i(t),d(L.$$.fragment,t),Zt=i(t),pt=n(t,"P",{}),h(pt).forEach(e),this.h()},h(){p(g,"name","hf:doc:metadata"),p(g,"content",JSON.stringify(be)),p(v,"id","mnasnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#mnasnet"),p(y,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(I,"id","how-do-i-finetune-this-model"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-finetune-this-model"),p(f,"class","relative group"),p(k,"id","how-do-i-train-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p(x,"id","citation"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,g),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,y,s),r(y,v),r(v,at),M(C,at,null),r(y,Qt),r(y,D),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,U),r(U,lt),M(N,lt,null),r(j,Vt),r(j,q),a(t,Mt,s),a(t,Z,s),a(t,wt,s),M(B,t,s),a(t,ut,s),a(t,W,s),a(t,Jt,s),M(E,t,s),a(t,gt,s),a(t,_,s),a(t,yt,s),M(G,t,s),a(t,jt,s),a(t,A,s),a(t,ft,s),M(Q,t,s),a(t,Tt,s),a(t,V,s),a(t,bt,s),a(t,Y,s),a(t,vt,s),a(t,f,s),r(f,I),r(I,nt),M(R,nt,null),r(f,Yt),r(f,K),a(t,Ut,s),a(t,X,s),a(t,It,s),M(S,t,s),a(t,kt,s),a(t,F,s),a(t,xt,s),a(t,T,s),r(T,k),r(k,ot),M(H,ot,null),r(T,Rt),r(T,O),a(t,Ct,s),a(t,z,s),a(t,$t,s),a(t,b,s),r(b,x),r(x,it),M(P,it,null),r(b,Xt),r(b,tt),a(t,Nt,s),M(L,t,s),a(t,Zt,s),a(t,pt,s),Bt=!0},p:Je,i(t){Bt||(w(C.$$.fragment,t),w(N.$$.fragment,t),w(B.$$.fragment,t),w(E.$$.fragment,t),w(G.$$.fragment,t),w(Q.$$.fragment,t),w(R.$$.fragment,t),w(S.$$.fragment,t),w(H.$$.fragment,t),w(P.$$.fragment,t),w(L.$$.fragment,t),Bt=!0)},o(t){u(C.$$.fragment,t),u(N.$$.fragment,t),u(B.$$.fragment,t),u(E.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(R.$$.fragment,t),u(S.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Bt=!1},d(t){t&&(e(ht),e(st),e(mt),e(y),e(ct),e($),e(dt),e(j),e(Mt),e(Z),e(wt),e(ut),e(W),e(Jt),e(gt),e(_),e(yt),e(jt),e(A),e(ft),e(Tt),e(V),e(bt),e(Y),e(vt),e(f),e(Ut),e(X),e(It),e(kt),e(F),e(xt),e(T),e(Ct),e(z),e($t),e(b),e(Nt),e(Zt),e(pt)),e(g),J(C),J(N),J(B,t),J(E,t),J(G,t),J(Q,t),J(R),J(S,t),J(H),J(P),J(L,t)}}}const be={local:"mnasnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"MnasNet"};function ve(St){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends ye{constructor(g){super(),je(this,g,ve,Te,ue,{})}}export{Ce as component};
