import{s as xa,n as Oa,o as ja}from"../chunks/scheduler.9039eef2.js";import{S as Ja,i as Ia,g as r,s as a,r as p,A as ka,h as i,f as o,c as n,j as v,u as g,x as m,k as b,y as t,a as s,v as _,d as h,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as T}from"../chunks/Docstring.a2ba2b54.js";import{C as Xt}from"../chunks/CodeBlock.8580f3e8.js";import{H as Ee}from"../chunks/Heading.f027f30d.js";function Aa(Vt){let U,ze,qe,Pe,F,He,L,Gt=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Be,E,Yt=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Se,q,We,D,ea="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Qe,z,ta="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Ze,P,aa="for example:",Re,H,Xe,B,na=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.`,Ve,S,Ge,W,oa="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Ye,Q,et,Z,la="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",tt,R,at,X,ra="After this one can then call:",nt,V,ot,G,lt,d,Y,vt,_e,ia="Initialize KTOTrainer.",bt,x,ee,Tt,he,sa=`Llama tokenizer does not satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Mt,O,te,yt,ue,da="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",wt,w,ae,Ct,fe,ma=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,$t,ve,ca="Works both with or without labels.",Ut,j,ne,xt,be,pa="Creates mismatched pairs of prompts and completions for the KL dataset.",Ot,J,oe,jt,Te,ga="Compute the log probabilities of the given labels under the given logits.",Jt,I,le,It,Me,_a="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",kt,k,re,At,ye,ha="Generate samples from the model and reference model for the given batch of inputs.",Nt,C,ie,Kt,we,ua="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ft,Ce,fa="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Lt,$,se,Et,$e,va="Returns the training <code>~torch.utils.data.DataLoader</code>.",qt,Ue,ba="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Dt,A,de,zt,xe,Ta="Compute the KTO loss for a batch of policy and reference model log probabilities.",Pt,N,me,Ht,Oe,Ma="Log <code>logs</code> on the various objects watching training, including stored metrics.",Bt,M,ce,St,je,ya="Tokenize a single row from a KTO specific dataset.",Wt,Je,wa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + completion responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the completion.`,Qt,Ie,Ca=`We also create the labels for the completion responses, which are of length equal to
the sum of the length of the prompt and the completion response, with
label_pad_token_id  for the prompt tokens.`,rt,pe,it,y,ge,Zt,ke,$a='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',Rt,Ae,Ua=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,st,De,dt;return F=new Ee({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),q=new Ee({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),H=new Xt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),S=new Ee({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Q=new Ee({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),R=new Xt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWt0b190cmFpbmVyJTIwJTNEJTIwS1RPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new Xt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),G=new Ee({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),Y=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L66"}}),ee=new T({props:{name:"build_tokenized_answer",anchor:"trl.KTOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L620"}}),te=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L546"}}),ae=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1128"}}),ne=new T({props:{name:"get_KL_dataset",anchor:"trl.KTOTrainer.get_KL_dataset",parameters:[{name:"batch",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L670"}}),oe=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L783",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),le=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L936"}}),re=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1042"}}),ie=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L493"}}),se=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L452"}}),de=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),me=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1184"}}),ce=new T({props:{name:"tokenize_row",anchor:"trl.KTOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"},{name:"prefix",val:" = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L675"}}),pe=new Ee({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),ge=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": int = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Optional = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),{c(){U=r("meta"),ze=a(),qe=r("p"),Pe=a(),p(F.$$.fragment),He=a(),L=r("p"),L.innerHTML=Gt,Be=a(),E=r("p"),E.textContent=Yt,Se=a(),p(q.$$.fragment),We=a(),D=r("p"),D.textContent=ea,Qe=a(),z=r("ul"),z.innerHTML=ta,Ze=a(),P=r("p"),P.textContent=aa,Re=a(),p(H.$$.fragment),Xe=a(),B=r("p"),B.innerHTML=na,Ve=a(),p(S.$$.fragment),Ge=a(),W=r("p"),W.innerHTML=oa,Ye=a(),p(Q.$$.fragment),et=a(),Z=r("p"),Z.innerHTML=la,tt=a(),p(R.$$.fragment),at=a(),X=r("p"),X.textContent=ra,nt=a(),p(V.$$.fragment),ot=a(),p(G.$$.fragment),lt=a(),d=r("div"),p(Y.$$.fragment),vt=a(),_e=r("p"),_e.textContent=ia,bt=a(),x=r("div"),p(ee.$$.fragment),Tt=a(),he=r("p"),he.innerHTML=sa,Mt=a(),O=r("div"),p(te.$$.fragment),yt=a(),ue=r("p"),ue.textContent=da,wt=a(),w=r("div"),p(ae.$$.fragment),Ct=a(),fe=r("p"),fe.innerHTML=ma,$t=a(),ve=r("p"),ve.textContent=ca,Ut=a(),j=r("div"),p(ne.$$.fragment),xt=a(),be=r("p"),be.textContent=pa,Ot=a(),J=r("div"),p(oe.$$.fragment),jt=a(),Te=r("p"),Te.textContent=ga,Jt=a(),I=r("div"),p(le.$$.fragment),It=a(),Me=r("p"),Me.textContent=_a,kt=a(),k=r("div"),p(re.$$.fragment),At=a(),ye=r("p"),ye.textContent=ha,Nt=a(),C=r("div"),p(ie.$$.fragment),Kt=a(),we=r("p"),we.innerHTML=ua,Ft=a(),Ce=r("p"),Ce.innerHTML=fa,Lt=a(),$=r("div"),p(se.$$.fragment),Et=a(),$e=r("p"),$e.innerHTML=va,qt=a(),Ue=r("p"),Ue.innerHTML=ba,Dt=a(),A=r("div"),p(de.$$.fragment),zt=a(),xe=r("p"),xe.textContent=Ta,Pt=a(),N=r("div"),p(me.$$.fragment),Ht=a(),Oe=r("p"),Oe.innerHTML=Ma,Bt=a(),M=r("div"),p(ce.$$.fragment),St=a(),je=r("p"),je.textContent=ya,Wt=a(),Je=r("p"),Je.textContent=wa,Qt=a(),Ie=r("p"),Ie.textContent=Ca,rt=a(),p(pe.$$.fragment),it=a(),y=r("div"),p(ge.$$.fragment),Zt=a(),ke=r("p"),ke.innerHTML=$a,Rt=a(),Ae=r("p"),Ae.innerHTML=Ua,st=a(),De=r("p"),this.h()},l(e){const l=ka("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(o),ze=n(e),qe=i(e,"P",{}),v(qe).forEach(o),Pe=n(e),g(F.$$.fragment,e),He=n(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-171dbf3"&&(L.innerHTML=Gt),Be=n(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-z1e9ri"&&(E.textContent=Yt),Se=n(e),g(q.$$.fragment,e),We=n(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1792bye"&&(D.textContent=ea),Qe=n(e),z=i(e,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-1bk1n3o"&&(z.innerHTML=ta),Ze=n(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1gl9mvz"&&(P.textContent=aa),Re=n(e),g(H.$$.fragment,e),Xe=n(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-109yt43"&&(B.innerHTML=na),Ve=n(e),g(S.$$.fragment,e),Ge=n(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-znx0uh"&&(W.innerHTML=oa),Ye=n(e),g(Q.$$.fragment,e),et=n(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1s8sgs3"&&(Z.innerHTML=la),tt=n(e),g(R.$$.fragment,e),at=n(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1lg6q1l"&&(X.textContent=ra),nt=n(e),g(V.$$.fragment,e),ot=n(e),g(G.$$.fragment,e),lt=n(e),d=i(e,"DIV",{class:!0});var c=v(d);g(Y.$$.fragment,c),vt=n(c),_e=i(c,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-hyhzxp"&&(_e.textContent=ia),bt=n(c),x=i(c,"DIV",{class:!0});var mt=v(x);g(ee.$$.fragment,mt),Tt=n(mt),he=i(mt,"P",{"data-svelte-h":!0}),m(he)!=="svelte-y1fzbp"&&(he.innerHTML=sa),mt.forEach(o),Mt=n(c),O=i(c,"DIV",{class:!0});var ct=v(O);g(te.$$.fragment,ct),yt=n(ct),ue=i(ct,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-pt6g01"&&(ue.textContent=da),ct.forEach(o),wt=n(c),w=i(c,"DIV",{class:!0});var Ne=v(w);g(ae.$$.fragment,Ne),Ct=n(Ne),fe=i(Ne,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-8qlty5"&&(fe.innerHTML=ma),$t=n(Ne),ve=i(Ne,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1tyo99t"&&(ve.textContent=ca),Ne.forEach(o),Ut=n(c),j=i(c,"DIV",{class:!0});var pt=v(j);g(ne.$$.fragment,pt),xt=n(pt),be=i(pt,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1y1n7oy"&&(be.textContent=pa),pt.forEach(o),Ot=n(c),J=i(c,"DIV",{class:!0});var gt=v(J);g(oe.$$.fragment,gt),jt=n(gt),Te=i(gt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-4nmimv"&&(Te.textContent=ga),gt.forEach(o),Jt=n(c),I=i(c,"DIV",{class:!0});var _t=v(I);g(le.$$.fragment,_t),It=n(_t),Me=i(_t,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-db7iek"&&(Me.textContent=_a),_t.forEach(o),kt=n(c),k=i(c,"DIV",{class:!0});var ht=v(k);g(re.$$.fragment,ht),At=n(ht),ye=i(ht,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-18uwvbi"&&(ye.textContent=ha),ht.forEach(o),Nt=n(c),C=i(c,"DIV",{class:!0});var Ke=v(C);g(ie.$$.fragment,Ke),Kt=n(Ke),we=i(Ke,"P",{"data-svelte-h":!0}),m(we)!=="svelte-xesobz"&&(we.innerHTML=ua),Ft=n(Ke),Ce=i(Ke,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-qg43tm"&&(Ce.innerHTML=fa),Ke.forEach(o),Lt=n(c),$=i(c,"DIV",{class:!0});var Fe=v($);g(se.$$.fragment,Fe),Et=n(Fe),$e=i(Fe,"P",{"data-svelte-h":!0}),m($e)!=="svelte-dkae9b"&&($e.innerHTML=va),qt=n(Fe),Ue=i(Fe,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-hmd5cw"&&(Ue.innerHTML=ba),Fe.forEach(o),Dt=n(c),A=i(c,"DIV",{class:!0});var ut=v(A);g(de.$$.fragment,ut),zt=n(ut),xe=i(ut,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-svckwe"&&(xe.textContent=Ta),ut.forEach(o),Pt=n(c),N=i(c,"DIV",{class:!0});var ft=v(N);g(me.$$.fragment,ft),Ht=n(ft),Oe=i(ft,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-nqksfz"&&(Oe.innerHTML=Ma),ft.forEach(o),Bt=n(c),M=i(c,"DIV",{class:!0});var K=v(M);g(ce.$$.fragment,K),St=n(K),je=i(K,"P",{"data-svelte-h":!0}),m(je)!=="svelte-118ojw5"&&(je.textContent=ya),Wt=n(K),Je=i(K,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1ku9h1p"&&(Je.textContent=wa),Qt=n(K),Ie=i(K,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-qa9jmj"&&(Ie.textContent=Ca),K.forEach(o),c.forEach(o),rt=n(e),g(pe.$$.fragment,e),it=n(e),y=i(e,"DIV",{class:!0});var Le=v(y);g(ge.$$.fragment,Le),Zt=n(Le),ke=i(Le,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1i1r5fd"&&(ke.innerHTML=$a),Rt=n(Le),Ae=i(Le,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1xl7jqc"&&(Ae.innerHTML=Ua),Le.forEach(o),st=n(e),De=i(e,"P",{}),v(De).forEach(o),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",Na),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,U),s(e,ze,l),s(e,qe,l),s(e,Pe,l),_(F,e,l),s(e,He,l),s(e,L,l),s(e,Be,l),s(e,E,l),s(e,Se,l),_(q,e,l),s(e,We,l),s(e,D,l),s(e,Qe,l),s(e,z,l),s(e,Ze,l),s(e,P,l),s(e,Re,l),_(H,e,l),s(e,Xe,l),s(e,B,l),s(e,Ve,l),_(S,e,l),s(e,Ge,l),s(e,W,l),s(e,Ye,l),_(Q,e,l),s(e,et,l),s(e,Z,l),s(e,tt,l),_(R,e,l),s(e,at,l),s(e,X,l),s(e,nt,l),_(V,e,l),s(e,ot,l),_(G,e,l),s(e,lt,l),s(e,d,l),_(Y,d,null),t(d,vt),t(d,_e),t(d,bt),t(d,x),_(ee,x,null),t(x,Tt),t(x,he),t(d,Mt),t(d,O),_(te,O,null),t(O,yt),t(O,ue),t(d,wt),t(d,w),_(ae,w,null),t(w,Ct),t(w,fe),t(w,$t),t(w,ve),t(d,Ut),t(d,j),_(ne,j,null),t(j,xt),t(j,be),t(d,Ot),t(d,J),_(oe,J,null),t(J,jt),t(J,Te),t(d,Jt),t(d,I),_(le,I,null),t(I,It),t(I,Me),t(d,kt),t(d,k),_(re,k,null),t(k,At),t(k,ye),t(d,Nt),t(d,C),_(ie,C,null),t(C,Kt),t(C,we),t(C,Ft),t(C,Ce),t(d,Lt),t(d,$),_(se,$,null),t($,Et),t($,$e),t($,qt),t($,Ue),t(d,Dt),t(d,A),_(de,A,null),t(A,zt),t(A,xe),t(d,Pt),t(d,N),_(me,N,null),t(N,Ht),t(N,Oe),t(d,Bt),t(d,M),_(ce,M,null),t(M,St),t(M,je),t(M,Wt),t(M,Je),t(M,Qt),t(M,Ie),s(e,rt,l),_(pe,e,l),s(e,it,l),s(e,y,l),_(ge,y,null),t(y,Zt),t(y,ke),t(y,Rt),t(y,Ae),s(e,st,l),s(e,De,l),dt=!0},p:Oa,i(e){dt||(h(F.$$.fragment,e),h(q.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),dt=!0)},o(e){u(F.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),dt=!1},d(e){e&&(o(ze),o(qe),o(Pe),o(He),o(L),o(Be),o(E),o(Se),o(We),o(D),o(Qe),o(z),o(Ze),o(P),o(Re),o(Xe),o(B),o(Ve),o(Ge),o(W),o(Ye),o(et),o(Z),o(tt),o(at),o(X),o(nt),o(ot),o(lt),o(d),o(rt),o(it),o(y),o(st),o(De)),o(U),f(F,e),f(q,e),f(H,e),f(S,e),f(Q,e),f(R,e),f(V,e),f(G,e),f(Y),f(ee),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(de),f(me),f(ce),f(pe,e),f(ge)}}}const Na='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function Ka(Vt){return ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends Ja{constructor(U){super(),Ia(this,U,Ka,Aa,xa,{})}}export{za as component};
