import{s as me,o as he,n as oe}from"../chunks/scheduler.25b97de1.js";import{S as re,i as ce,g as p,s as l,r,A as de,h as o,f as s,c as n,j as ie,u as c,x as m,k as at,y as ue,a,v as d,d as u,t as g,w as f}from"../chunks/index.d9030fc9.js";import{T as pe}from"../chunks/Tip.baa67368.js";import{C as j}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Vt,E as ge}from"../chunks/EditOnGithub.91d95064.js";function fe(et){let i,$='Check the <a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a> task page to view all compatible architectures and checkpoints.';return{c(){i=p("p"),i.innerHTML=$},l(h){i=o(h,"P",{"data-svelte-h":!0}),m(i)!=="svelte-vf0won"&&(i.innerHTML=$)},m(h,M){a(h,i,M)},p:oe,d(h){h&&s(i)}}}function Me(et){let i,$='In the <a href="https://github.com/isl-org/ZoeDepth/blob/edb6daf45458569e24f50250ef1ed08c015f17a7/zoedepth/models/depth_model.py#L131">original implementation</a> ZoeDepth model performs inference on both the original and flipped images and averages out the results. The <code>post_process_depth_estimation</code> function can handle this for us by passing the flipped outputs to the optional <code>outputs_flipped</code> argument:',h,M,v=`<code class="language-Python">&gt;&gt;&gt; with torch.no_grad():   
...     outputs = model(pixel_values)
...     outputs_flipped = model(pixel_values=torch.flip(inputs.pixel_values, dims=[3]))
&gt;&gt;&gt; post_processed_output = image_processor.post_process_depth_estimation(
...     outputs,
...     source_sizes=[(image.height, image.width)],
...     outputs_flipped=outputs_flipped,
... )
</code>`;return{c(){i=p("p"),i.innerHTML=$,h=l(),M=p("pre"),M.innerHTML=v},l(w){i=o(w,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1uajjwo"&&(i.innerHTML=$),h=n(w),M=o(w,"PRE",{"data-svelte-h":!0}),m(M)!=="svelte-1oycc4w"&&(M.innerHTML=v)},m(w,y){a(w,i,y),a(w,h,y),a(w,M,y)},p:oe,d(w){w&&(s(i),s(h),s(M))}}}function we(et){let i,$,h,M,v,w,y,It=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,lt,C,Lt=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,nt,W,Yt="There are two main depth estimation categories:",it,Z,Et="<li><p><strong>Absolute depth estimation</strong>: This task variant aims to provide exact depth measurements from the camera. The term is used interchangeably with metric depth estimation, where depth is provided in precise measurements in meters or feet. Absolute depth estimation models output depth maps with numerical values that represent real-world distances.</p></li> <li><p><strong>Relative depth estimation</strong>: Relative depth estimation aims to predict the depth order of objects or points in a scene without providing the precise measurements. These models output a depth map that indicates which parts of the scene are closer or farther relative to each other without the actual distances to A and B.</p></li>",pt,k,Nt='In this guide, we will see how to infer with <a href="https://huggingface.co/depth-anything/Depth-Anything-V2-Large" rel="nofollow">Depth Anything V2</a>, a state-of-the-art zero-shot relative depth estimation model, and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/zoedepth" rel="nofollow">ZoeDepth</a>, an absolute depth estimation model.',ot,b,mt,G,Xt="Before we begin, we need to install the latest version of Transformers:",ht,R,rt,x,ct,H,Ft=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,dt,B,ut,z,Pt="Next, choose an image to analyze:",gt,V,ft,_,Qt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Photo of a bee"/>',Mt,I,St="Pass the image to the pipeline.",wt,L,yt,Y,qt=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,$t,E,At="Let’s take a look at the visualized result:",vt,N,jt,T,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',bt,X,_t,F,Kt="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",Tt,P,Ot=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,Ut,Q,Jt,S,te=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,Ct,q,Wt,A,ee="Pass the prepared inputs through the model:",Zt,D,kt,K,se="Let’s post-process the results to remove any padding and resize the depth map to match the original image size. The <code>post_process_depth_estimation</code> outputs a list of dicts containing the <code>&quot;predicted_depth&quot;</code>.",Gt,O,Rt,U,xt,J,ae='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization-zoe.png" alt="Depth estimation visualization"/>',Ht,tt,Bt,st,zt;return v=new Vt({props:{title:"Monocular depth estimation",local:"monocular-depth-estimation",headingTag:"h1"}}),b=new pe({props:{$$slots:{default:[fe]},$$scope:{ctx:et}}}),R=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwLVUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q -U transformers",wrap:!1}}),x=new Vt({props:{title:"Depth estimation pipeline",local:"depth-estimation-pipeline",headingTag:"h2"}}),B=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLWJhc2UtaGYlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMGRldmljZSUzRGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-base-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint, device=device)`,wrap:!1}}),V=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZiZWUuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),L=new j({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlKGltYWdlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = pipe(image)',wrap:!1}}),N=new j({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),X=new Vt({props:{title:"Depth estimation inference by hand",local:"depth-estimation-inference-by-hand",headingTag:"h2"}}),Q=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJJbnRlbCUyRnpvZWRlcHRoLW55dS1raXR0aSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCkudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint).to(device)`,wrap:!1}}),q=new j({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzLnRvKGRldmljZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(device)',wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)`,wrap:!1}}),O=new j({props:{code:"JTIzJTIwWm9lRGVwdGglMjBkeW5hbWljYWxseSUyMHBhZHMlMjB0aGUlMjBpbnB1dCUyMGltYWdlLiUyMFRodXMlMjB3ZSUyMHBhc3MlMjB0aGUlMjBvcmlnaW5hbCUyMGltYWdlJTIwc2l6ZSUyMGFzJTIwYXJndW1lbnQlMEElMjMlMjB0byUyMCU2MHBvc3RfcHJvY2Vzc19kZXB0aF9lc3RpbWF0aW9uJTYwJTIwdG8lMjByZW1vdmUlMjB0aGUlMjBwYWRkaW5nJTIwYW5kJTIwcmVzaXplJTIwdG8lMjBvcmlnaW5hbCUyMGRpbWVuc2lvbnMuJTBBcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19kZXB0aF9lc3RpbWF0aW9uKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMkMlMEElMjAlMjAlMjAlMjBzb3VyY2Vfc2l6ZXMlM0QlNUIoaW1hZ2UuaGVpZ2h0JTJDJTIwaW1hZ2Uud2lkdGgpJTVEJTJDJTBBKSUwQSUwQXByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJwcmVkaWN0ZWRfZGVwdGglMjIlNUQlMEFkZXB0aCUyMCUzRCUyMChwcmVkaWN0ZWRfZGVwdGglMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUyMCUyRiUyMChwcmVkaWN0ZWRfZGVwdGgubWF4KCklMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyMColMjAyNTUlMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShkZXB0aC5hc3R5cGUoJTIydWludDglMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ZoeDepth dynamically pads the input image. Thus we pass the original image size as argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to \`post_process_depth_estimation\` to remove the padding and resize to original dimensions.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    source_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),U=new pe({props:{$$slots:{default:[Me]},$$scope:{ctx:et}}}),tt=new ge({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/monocular_depth_estimation.md"}}),{c(){i=p("meta"),$=l(),h=p("p"),M=l(),r(v.$$.fragment),w=l(),y=p("p"),y.textContent=It,lt=l(),C=p("p"),C.textContent=Lt,nt=l(),W=p("p"),W.textContent=Yt,it=l(),Z=p("ul"),Z.innerHTML=Et,pt=l(),k=p("p"),k.innerHTML=Nt,ot=l(),r(b.$$.fragment),mt=l(),G=p("p"),G.textContent=Xt,ht=l(),r(R.$$.fragment),rt=l(),r(x.$$.fragment),ct=l(),H=p("p"),H.innerHTML=Ft,dt=l(),r(B.$$.fragment),ut=l(),z=p("p"),z.textContent=Pt,gt=l(),r(V.$$.fragment),ft=l(),_=p("div"),_.innerHTML=Qt,Mt=l(),I=p("p"),I.textContent=St,wt=l(),r(L.$$.fragment),yt=l(),Y=p("p"),Y.innerHTML=qt,$t=l(),E=p("p"),E.textContent=At,vt=l(),r(N.$$.fragment),jt=l(),T=p("div"),T.innerHTML=Dt,bt=l(),r(X.$$.fragment),_t=l(),F=p("p"),F.textContent=Kt,Tt=l(),P=p("p"),P.innerHTML=Ot,Ut=l(),r(Q.$$.fragment),Jt=l(),S=p("p"),S.innerHTML=te,Ct=l(),r(q.$$.fragment),Wt=l(),A=p("p"),A.textContent=ee,Zt=l(),r(D.$$.fragment),kt=l(),K=p("p"),K.innerHTML=se,Gt=l(),r(O.$$.fragment),Rt=l(),r(U.$$.fragment),xt=l(),J=p("div"),J.innerHTML=ae,Ht=l(),r(tt.$$.fragment),Bt=l(),st=p("p"),this.h()},l(t){const e=de("svelte-u9bgzb",document.head);i=o(e,"META",{name:!0,content:!0}),e.forEach(s),$=n(t),h=o(t,"P",{}),ie(h).forEach(s),M=n(t),c(v.$$.fragment,t),w=n(t),y=o(t,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1elgt0a"&&(y.textContent=It),lt=n(t),C=o(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-szef6f"&&(C.textContent=Lt),nt=n(t),W=o(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1evxf27"&&(W.textContent=Yt),it=n(t),Z=o(t,"UL",{"data-svelte-h":!0}),m(Z)!=="svelte-1l3knez"&&(Z.innerHTML=Et),pt=n(t),k=o(t,"P",{"data-svelte-h":!0}),m(k)!=="svelte-9hlqcm"&&(k.innerHTML=Nt),ot=n(t),c(b.$$.fragment,t),mt=n(t),G=o(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-n2hqrn"&&(G.textContent=Xt),ht=n(t),c(R.$$.fragment,t),rt=n(t),c(x.$$.fragment,t),ct=n(t),H=o(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-dz0z6"&&(H.innerHTML=Ft),dt=n(t),c(B.$$.fragment,t),ut=n(t),z=o(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-wuz5lr"&&(z.textContent=Pt),gt=n(t),c(V.$$.fragment,t),ft=n(t),_=o(t,"DIV",{class:!0,"data-svelte-h":!0}),m(_)!=="svelte-6n7vnz"&&(_.innerHTML=Qt),Mt=n(t),I=o(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-mcr1tn"&&(I.textContent=St),wt=n(t),c(L.$$.fragment,t),yt=n(t),Y=o(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1jckqfu"&&(Y.innerHTML=qt),$t=n(t),E=o(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1dzpyfr"&&(E.textContent=At),vt=n(t),c(N.$$.fragment,t),jt=n(t),T=o(t,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-43wxxb"&&(T.innerHTML=Dt),bt=n(t),c(X.$$.fragment,t),_t=n(t),F=o(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1u79cc9"&&(F.textContent=Kt),Tt=n(t),P=o(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1r8mctn"&&(P.innerHTML=Ot),Ut=n(t),c(Q.$$.fragment,t),Jt=n(t),S=o(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-hhrw3"&&(S.innerHTML=te),Ct=n(t),c(q.$$.fragment,t),Wt=n(t),A=o(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1yk8q0z"&&(A.textContent=ee),Zt=n(t),c(D.$$.fragment,t),kt=n(t),K=o(t,"P",{"data-svelte-h":!0}),m(K)!=="svelte-znxo5i"&&(K.innerHTML=se),Gt=n(t),c(O.$$.fragment,t),Rt=n(t),c(U.$$.fragment,t),xt=n(t),J=o(t,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-18ny996"&&(J.innerHTML=ae),Ht=n(t),c(tt.$$.fragment,t),Bt=n(t),st=o(t,"P",{}),ie(st).forEach(s),this.h()},h(){at(i,"name","hf:doc:metadata"),at(i,"content",ye),at(_,"class","flex justify-center"),at(T,"class","flex justify-center"),at(J,"class","flex justify-center")},m(t,e){ue(document.head,i),a(t,$,e),a(t,h,e),a(t,M,e),d(v,t,e),a(t,w,e),a(t,y,e),a(t,lt,e),a(t,C,e),a(t,nt,e),a(t,W,e),a(t,it,e),a(t,Z,e),a(t,pt,e),a(t,k,e),a(t,ot,e),d(b,t,e),a(t,mt,e),a(t,G,e),a(t,ht,e),d(R,t,e),a(t,rt,e),d(x,t,e),a(t,ct,e),a(t,H,e),a(t,dt,e),d(B,t,e),a(t,ut,e),a(t,z,e),a(t,gt,e),d(V,t,e),a(t,ft,e),a(t,_,e),a(t,Mt,e),a(t,I,e),a(t,wt,e),d(L,t,e),a(t,yt,e),a(t,Y,e),a(t,$t,e),a(t,E,e),a(t,vt,e),d(N,t,e),a(t,jt,e),a(t,T,e),a(t,bt,e),d(X,t,e),a(t,_t,e),a(t,F,e),a(t,Tt,e),a(t,P,e),a(t,Ut,e),d(Q,t,e),a(t,Jt,e),a(t,S,e),a(t,Ct,e),d(q,t,e),a(t,Wt,e),a(t,A,e),a(t,Zt,e),d(D,t,e),a(t,kt,e),a(t,K,e),a(t,Gt,e),d(O,t,e),a(t,Rt,e),d(U,t,e),a(t,xt,e),a(t,J,e),a(t,Ht,e),d(tt,t,e),a(t,Bt,e),a(t,st,e),zt=!0},p(t,[e]){const le={};e&2&&(le.$$scope={dirty:e,ctx:t}),b.$set(le);const ne={};e&2&&(ne.$$scope={dirty:e,ctx:t}),U.$set(ne)},i(t){zt||(u(v.$$.fragment,t),u(b.$$.fragment,t),u(R.$$.fragment,t),u(x.$$.fragment,t),u(B.$$.fragment,t),u(V.$$.fragment,t),u(L.$$.fragment,t),u(N.$$.fragment,t),u(X.$$.fragment,t),u(Q.$$.fragment,t),u(q.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(U.$$.fragment,t),u(tt.$$.fragment,t),zt=!0)},o(t){g(v.$$.fragment,t),g(b.$$.fragment,t),g(R.$$.fragment,t),g(x.$$.fragment,t),g(B.$$.fragment,t),g(V.$$.fragment,t),g(L.$$.fragment,t),g(N.$$.fragment,t),g(X.$$.fragment,t),g(Q.$$.fragment,t),g(q.$$.fragment,t),g(D.$$.fragment,t),g(O.$$.fragment,t),g(U.$$.fragment,t),g(tt.$$.fragment,t),zt=!1},d(t){t&&(s($),s(h),s(M),s(w),s(y),s(lt),s(C),s(nt),s(W),s(it),s(Z),s(pt),s(k),s(ot),s(mt),s(G),s(ht),s(rt),s(ct),s(H),s(dt),s(ut),s(z),s(gt),s(ft),s(_),s(Mt),s(I),s(wt),s(yt),s(Y),s($t),s(E),s(vt),s(jt),s(T),s(bt),s(_t),s(F),s(Tt),s(P),s(Ut),s(Jt),s(S),s(Ct),s(Wt),s(A),s(Zt),s(kt),s(K),s(Gt),s(Rt),s(xt),s(J),s(Ht),s(Bt),s(st)),s(i),f(v,t),f(b,t),f(R,t),f(x,t),f(B,t),f(V,t),f(L,t),f(N,t),f(X,t),f(Q,t),f(q,t),f(D,t),f(O,t),f(U,t),f(tt,t)}}}const ye='{"title":"Monocular depth estimation","local":"monocular-depth-estimation","sections":[{"title":"Depth estimation pipeline","local":"depth-estimation-pipeline","sections":[],"depth":2},{"title":"Depth estimation inference by hand","local":"depth-estimation-inference-by-hand","sections":[],"depth":2}],"depth":1}';function $e(et){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends re{constructor(i){super(),ce(this,i,$e,we,me,{})}}export{Ue as component};
