import{s as dl,n as cl,o as hl}from"../chunks/scheduler.65852ee5.js";import{S as ul,i as fl,g as c,s as n,r as i,A as Ml,h,f as l,c as a,j as rl,u as o,x as u,k as ml,y as bl,a as s,v as p,d as r,t as m,w as d}from"../chunks/index.65a1b999.js";import{D as gl,C as f}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as M,E as wl}from"../chunks/getInferenceSnippets.56942ade.js";function yl(Rt){let b,ve,je,Ie,g,Ge,w,Ce,y,Bt='<em>Authored by: <a href="https://github.com/zc277584121" rel="nofollow">Chen Zhang</a></em>',ke,J,Vt='<a href="https://milvus.io/" rel="nofollow">Milvus</a> is a popular open-source vector database that powers AI applications with highly performant and scalable vector similarity search. In this tutorial, we will show you how to build a RAG (Retrieval-Augmented Generation) pipeline with Hugging Face and Milvus.',Ze,T,Nt="The RAG system combines a retrieval system with an LLM. The system first retrieves relevant documents from a corpus using Milvus vector database, then uses an LLM hosted in Hugging Face to generate answers based on the retrieved documents.",We,$,xe,j,_e,U,Re,v,At="<p>If you are using Google Colab, to enable the dependencies, you may need to <strong>restart the runtime</strong> (click on the “Runtime” menu at the top of the screen, and select “Restart session” from the dropdown menu).</p>",Be,I,Et='In addition, we recommend that you configure your <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">Hugging Face User Access Token</a>, and set it in your environment variables because we will use a LLM from the Hugging Face Hub. You may get a low limit of requests if you don’t set the token environment variable.',Ve,G,Ne,C,Ae,k,qt='We use the <a href="https://artificialintelligenceact.eu/wp-content/uploads/2021/08/The-AI-Act.pdf" rel="nofollow">AI Act PDF</a>, a regulatory framework for AI with different risk levels corresponding to more or less regulation, as the private knowledge in our RAG.',Ee,Z,qe,W,Ht='We use the <a href="https://python.langchain.com/v0.1/docs/modules/data_connection/document_loaders/pdf/" rel="nofollow"><code>PyPDFLoader</code></a> from LangChain to extract the text from the PDF, and then split the text into smaller chunks. By default, we set the chunk size as 1000 and the overlap as 200, which means each chunk will nearly have 1000 characters and the overlap between two chunks will be 200 characters.',He,x,Xe,_,Xt=`108
`,ze,R,Qe,B,Fe,V,Ye,N,zt='Define a function to generate text embeddings. We use <a href="https://huggingface.co/BAAI/bge-small-en-v1.5" rel="nofollow">BGE embedding model</a> as an example, but you can use any embedding models, such as those found on the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB leaderboard</a>.',Le,A,Se,E,Qt="Generate a test embedding and print its dimension and first few elements.",Pe,q,De,H,Ft=`384
[-0.07660683244466782, 0.025316666811704636, 0.012505513615906239, 0.004595153499394655, 0.025780051946640015, 0.03816710412502289, 0.08050819486379623, 0.003035430097952485, 0.02439221926033497, 0.0048803347162902355]
`,Ke,X,Oe,z,et,Q,tt,F,Yt='<p>As for the argument of <code>MilvusClient</code>:</p> <ul><li>Setting the <code>uri</code> as a local file, e.g.<code>./hf_milvus_demo.db</code>, is the most convenient method, as it automatically utilizes <a href="https://milvus.io/docs/milvus_lite.md" rel="nofollow">Milvus Lite</a> to store all data in this file.</li> <li>If you have a large amount of data, say more than a million vectors, you can set up a more performant Milvus server on <a href="https://milvus.io/docs/quickstart.md" rel="nofollow">Docker or Kubernetes</a>. In this setup, please use the server uri, e.g.<code>http://localhost:19530</code>, as your <code>uri</code>.</li> <li>If you want to use <a href="https://zilliz.com/cloud" rel="nofollow">Zilliz Cloud</a>, the fully managed cloud service for Milvus, adjust the <code>uri</code> and <code>token</code>, which correspond to the <a href="https://docs.zilliz.com/docs/on-zilliz-cloud-console#cluster-details" rel="nofollow">Public Endpoint and Api key</a> in Zilliz Cloud.</li></ul>',lt,Y,Lt="Check if the collection already exists and drop it if it does.",st,L,nt,S,St="Create a new collection with specified parameters.",at,P,Pt="If we don’t specify any field information, Milvus will automatically create a default <code>id</code> field for primary key, and a <code>vector</code> field to store the vector data. A reserved JSON field is used to store non-schema-defined fields and their values.",it,D,ot,K,pt,O,Dt="Iterate through the text lines, create embeddings, and then insert the data into Milvus.",rt,ee,Kt="Here is a new field <code>text</code>, which is a non-defined field in the collection schema. It will be automatically added to the reserved JSON dynamic field, which can be treated as a normal field at a high level.",mt,te,dt,le,ct,se,ht,ne,Ot="Let’s specify a question to ask about the corpus.",ut,ae,ft,ie,el="Search for the question in the collection and retrieve the top 3 semantic matches.",Mt,oe,bt,pe,tl="Let’s take a look at the search results of the query",gt,re,wt,me,ll=`[
    [
        "EN 6  EN 2. LEGAL  BASIS,  SUBSIDIARITY  AND  PROPORTIONALITY  \\n2.1. Legal  basis  \\nThe legal basis for the proposal is in the first place Article 114 of the Treaty on the \\nFunctioning of the European Union (TFEU), which provides for the adoption of measures to \\nensure the establishment and f unctioning of the internal market.  \\nThis proposal constitutes a core part of the EU digital single market strategy. The primary \\nobjective of this proposal is to ensure the proper functioning of the internal market by setting \\nharmonised rules in particular on the development, placing on the Union market and the use \\nof products and services making use of AI technologies or provided as stand -alone AI \\nsystems. Some Member States are already considering national rules to ensure that AI is safe \\nand is developed a nd used in compliance with fundamental rights obligations. This will likely \\nlead to two main problems: i) a fragmentation of the internal market on essential elements",
        0.7412998080253601
    ],
    [
        "applications and prevent market fragmentation.  \\nTo achieve those objectives, this proposal presents a balanced and proportionate horizontal \\nregulatory approach to AI that is limited to the minimum necessary requirements to address \\nthe risks and problems linked to AI, withou t unduly constraining or hindering technological \\ndevelopment or otherwise disproportionately increasing the cost of placing AI solutions on \\nthe market.  The proposal sets a robust and flexible legal framework. On the one hand, it is \\ncomprehensive and future -proof in its fundamental regulatory choices, including the \\nprinciple -based requirements that AI systems should comply with. On the other hand, it puts \\nin place a proportionate regulatory system centred on a well -defined risk -based regulatory \\napproach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such",
        0.696428656578064
    ],
    [
        "approach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such \\nconcern can reasonably be anticipated in the near future. At the same time, t he legal \\nframework includes flexible mechanisms that enable it to be dynamically adapted as the \\ntechnology evolves and new concerning situations emerge.  \\nThe proposal sets harmonised rules for the development, placement on the market and use of \\nAI systems i n the Union following a proportionate risk -based approach. It proposes a single \\nfuture -proof definition of AI. Certain particularly harmful AI practices are prohibited as \\ncontravening Union values, while specific restrictions and safeguards are proposed in  relation \\nto certain uses of remote biometric identification systems for the purpose of law enforcement. \\nThe proposal lays down a solid risk methodology to define \\u201chigh -risk\\u201d AI systems that pose",
        0.6891457438468933
    ]
]
`,yt,de,Jt,ce,sl="Before composing the prompt for LLM, let’s first flatten the retrieved document list into a plain string.",Tt,he,$t,ue,nl="Define prompts for the Language Model. This prompt is assembled with the retrieved documents from Milvus.",jt,fe,Ut,Me,al='We use the <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B-Instruct-v0.1</a> hosted on Hugging Face inference server to generate a response based on the prompt.',vt,be,It,ge,il="Finally, we can format the prompt and generate the answer.",Gt,we,Ct,ye,kt,Je,ol=`The legal basis for the proposal is Article 114 of the Treaty on the Functioning of the European Union (TFEU), which provides for the adoption of measures to ensure the establishment and functioning of the internal market. The proposal aims to establish harmonized rules for the development, placing on the market, and use of AI systems in the Union following a proportionate risk-based approach.
`,Zt,Te,pl="Congratulations! You have built an RAG pipeline with Hugging Face and Milvus.",Wt,$e,xt,Ue,_t;return g=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_hf_and_milvus.ipynb"}]}}),w=new M({props:{title:"Build RAG with Hugging Face and Milvus",local:"build-rag-with-hugging-face-and-milvus",headingTag:"h1"}}),$=new M({props:{title:"Preparation",local:"preparation",headingTag:"h2"}}),j=new M({props:{title:"Dependencies and Environment",local:"dependencies-and-environment",headingTag:"h3"}}),U=new f({props:{code:"ISUyMHBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBweW1pbHZ1cyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlLWh1YiUyMGxhbmdjaGFpbl9jb21tdW5pdHklMjBsYW5nY2hhaW4tdGV4dC1zcGxpdHRlcnMlMjBweXBkZiUyMHRxZG0=",highlighted:"! pip install --upgrade pymilvus sentence-transformers huggingface-hub langchain_community langchain-text-splitters pypdf tqdm",wrap:!1}}),G=new f({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjAlMjJoZl8uLi4lMjI=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),C=new M({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h3"}}),Z=new f({props:{code:"JTI1JTI1YmFzaCUwQSUwQWlmJTIwJTVCJTIwISUyMC1mJTIwJTIyVGhlLUFJLUFjdC5wZGYlMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwd2dldCUyMC1xJTIwaHR0cHMlM0ElMkYlMkZhcnRpZmljaWFsaW50ZWxsaWdlbmNlYWN0LmV1JTJGd3AtY29udGVudCUyRnVwbG9hZHMlMkYyMDIxJTJGMDglMkZUaGUtQUktQWN0LnBkZiUwQWZp",highlighted:`%%bash

<span class="hljs-keyword">if</span> [ ! -f <span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span> ]; then
    wget -q https://artificialintelligenceact.eu/wp-content/uploads/<span class="hljs-number">2021</span>/08/The-AI-Act.pdf
fi`,wrap:!1}}),x=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZG9jdW1lbnRfbG9hZGVycyUyMGltcG9ydCUyMFB5UERGTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwUHlQREZMb2FkZXIoJTIyVGhlLUFJLUFjdC5wZGYlMjIpJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCklMEFwcmludChsZW4oZG9jcykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> PyPDFLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>loader = PyPDFLoader(<span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs = loader.load()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(docs))`,wrap:!1}}),R=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl90ZXh0X3NwbGl0dGVycyUyMGltcG9ydCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDEwMDAlMkMlMjBjaHVua19vdmVybGFwJTNEMjAwKSUwQWNodW5rcyUyMCUzRCUyMHRleHRfc3BsaXR0ZXIuc3BsaXRfZG9jdW1lbnRzKGRvY3Mp",highlighted:`<span class="hljs-keyword">from</span> langchain_text_splitters <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">1000</span>, chunk_overlap=<span class="hljs-number">200</span>)
chunks = text_splitter.split_documents(docs)`,wrap:!1}}),B=new f({props:{code:"dGV4dF9saW5lcyUyMCUzRCUyMCU1QmNodW5rLnBhZ2VfY29udGVudCUyMGZvciUyMGNodW5rJTIwaW4lMjBjaHVua3MlNUQ=",highlighted:'text_lines = [chunk.page_content <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> chunks]',wrap:!1}}),V=new M({props:{title:"Prepare the Embedding Model",local:"prepare-the-embedding-model",headingTag:"h3"}}),A=new f({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEElMEElMEFkZWYlMjBlbWJfdGV4dCh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZ19tb2RlbC5lbmNvZGUoJTVCdGV4dCU1RCUyQyUyMG5vcm1hbGl6ZV9lbWJlZGRpbmdzJTNEVHJ1ZSkudG9saXN0KCklNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

embedding_model = SentenceTransformer(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">emb_text</span>(<span class="hljs-params">text</span>):
    <span class="hljs-keyword">return</span> embedding_model.encode([text], normalize_embeddings=<span class="hljs-literal">True</span>).tolist()[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new f({props:{code:"dGVzdF9lbWJlZGRpbmclMjAlM0QlMjBlbWJfdGV4dCglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiklMEFlbWJlZGRpbmdfZGltJTIwJTNEJTIwbGVuKHRlc3RfZW1iZWRkaW5nKSUwQXByaW50KGVtYmVkZGluZ19kaW0pJTBBcHJpbnQodGVzdF9lbWJlZGRpbmclNUIlM0ExMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>test_embedding = emb_text(<span class="hljs-string">&quot;This is a test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_dim = <span class="hljs-built_in">len</span>(test_embedding)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(embedding_dim)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(test_embedding[:<span class="hljs-number">10</span>])`,wrap:!1}}),X=new M({props:{title:"Load data into Milvus",local:"load-data-into-milvus",headingTag:"h2"}}),z=new M({props:{title:"Create the Collection",local:"create-the-collection",headingTag:"h3"}}),Q=new f({props:{code:"ZnJvbSUyMHB5bWlsdnVzJTIwaW1wb3J0JTIwTWlsdnVzQ2xpZW50JTBBJTBBbWlsdnVzX2NsaWVudCUyMCUzRCUyME1pbHZ1c0NsaWVudCh1cmklM0QlMjIuJTJGaGZfbWlsdnVzX2RlbW8uZGIlMjIpJTBBJTBBY29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIycmFnX2NvbGxlY3Rpb24lMjI=",highlighted:`<span class="hljs-keyword">from</span> pymilvus <span class="hljs-keyword">import</span> MilvusClient

milvus_client = MilvusClient(uri=<span class="hljs-string">&quot;./hf_milvus_demo.db&quot;</span>)

collection_name = <span class="hljs-string">&quot;rag_collection&quot;</span>`,wrap:!1}}),L=new f({props:{code:"aWYlMjBtaWx2dXNfY2xpZW50Lmhhc19jb2xsZWN0aW9uKGNvbGxlY3Rpb25fbmFtZSklM0ElMEElMjAlMjAlMjAlMjBtaWx2dXNfY2xpZW50LmRyb3BfY29sbGVjdGlvbihjb2xsZWN0aW9uX25hbWUp",highlighted:`<span class="hljs-keyword">if</span> milvus_client.has_collection(collection_name):
    milvus_client.drop_collection(collection_name)`,wrap:!1}}),D=new f({props:{code:"bWlsdnVzX2NsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0Rjb2xsZWN0aW9uX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkaW1lbnNpb24lM0RlbWJlZGRpbmdfZGltJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX3R5cGUlM0QlMjJJUCUyMiUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwY29uc2lzdGVuY3lfbGV2ZWwlM0QlMjJTdHJvbmclMjIlMkMlMjAlMjAlMjMlMjBTdHJvbmclMjBjb25zaXN0ZW5jeSUyMGxldmVsJTBBKQ==",highlighted:`milvus_client.create_collection(
    collection_name=collection_name,
    dimension=embedding_dim,
    metric_type=<span class="hljs-string">&quot;IP&quot;</span>,  <span class="hljs-comment"># Inner product distance</span>
    consistency_level=<span class="hljs-string">&quot;Strong&quot;</span>,  <span class="hljs-comment"># Strong consistency level</span>
)`,wrap:!1}}),K=new M({props:{title:"Insert data",local:"insert-data",headingTag:"h3"}}),te=new f({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZGF0YSUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGklMkMlMjBsaW5lJTIwaW4lMjBlbnVtZXJhdGUodHFkbSh0ZXh0X2xpbmVzJTJDJTIwZGVzYyUzRCUyMkNyZWF0aW5nJTIwZW1iZWRkaW5ncyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YS5hcHBlbmQoJTdCJTIyaWQlMjIlM0ElMjBpJTJDJTIwJTIydmVjdG9yJTIyJTNBJTIwZW1iX3RleHQobGluZSklMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwbGluZSU3RCklMEElMEFpbnNlcnRfcmVzJTIwJTNEJTIwbWlsdnVzX2NsaWVudC5pbnNlcnQoY29sbGVjdGlvbl9uYW1lJTNEY29sbGVjdGlvbl9uYW1lJTJDJTIwZGF0YSUzRGRhdGEpJTBBaW5zZXJ0X3JlcyU1QiUyMmluc2VydF9jb3VudCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

data = []

<span class="hljs-keyword">for</span> i, line <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(text_lines, desc=<span class="hljs-string">&quot;Creating embeddings&quot;</span>)):
    data.append({<span class="hljs-string">&quot;id&quot;</span>: i, <span class="hljs-string">&quot;vector&quot;</span>: emb_text(line), <span class="hljs-string">&quot;text&quot;</span>: line})

insert_res = milvus_client.insert(collection_name=collection_name, data=data)
insert_res[<span class="hljs-string">&quot;insert_count&quot;</span>]`,wrap:!1}}),le=new M({props:{title:"Build RAG",local:"build-rag",headingTag:"h2"}}),se=new M({props:{title:"Retrieve data for a query",local:"retrieve-data-for-a-query",headingTag:"h3"}}),ae=new f({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBsZWdhbCUyMGJhc2lzJTIwZm9yJTIwdGhlJTIwcHJvcG9zYWwlM0YlMjI=",highlighted:'question = <span class="hljs-string">&quot;What is the legal basis for the proposal?&quot;</span>',wrap:!1}}),oe=new f({props:{code:"c2VhcmNoX3JlcyUyMCUzRCUyMG1pbHZ1c19jbGllbnQuc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fbmFtZSUzRGNvbGxlY3Rpb25fbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0QlNUJlbWJfdGV4dChxdWVzdGlvbiklNUQlMkMlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjAlNjBlbWJfdGV4dCU2MCUyMGZ1bmN0aW9uJTIwdG8lMjBjb252ZXJ0JTIwdGhlJTIwcXVlc3Rpb24lMjB0byUyMGFuJTIwZW1iZWRkaW5nJTIwdmVjdG9yJTBBJTIwJTIwJTIwJTIwbGltaXQlM0QzJTJDJTIwJTIwJTIzJTIwUmV0dXJuJTIwdG9wJTIwMyUyMHJlc3VsdHMlMEElMjAlMjAlMjAlMjBzZWFyY2hfcGFyYW1zJTNEJTdCJTIybWV0cmljX3R5cGUlMjIlM0ElMjAlMjJJUCUyMiUyQyUyMCUyMnBhcmFtcyUyMiUzQSUyMCU3QiU3RCU3RCUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2ZpZWxkcyUzRCU1QiUyMnRleHQlMjIlNUQlMkMlMjAlMjAlMjMlMjBSZXR1cm4lMjB0aGUlMjB0ZXh0JTIwZmllbGQlMEEp",highlighted:`search_res = milvus_client.search(
    collection_name=collection_name,
    data=[emb_text(question)],  <span class="hljs-comment"># Use the \`emb_text\` function to convert the question to an embedding vector</span>
    limit=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Return top 3 results</span>
    search_params={<span class="hljs-string">&quot;metric_type&quot;</span>: <span class="hljs-string">&quot;IP&quot;</span>, <span class="hljs-string">&quot;params&quot;</span>: {}},  <span class="hljs-comment"># Inner product distance</span>
    output_fields=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># Return the text field</span>
)`,wrap:!1}}),re=new f({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJldHJpZXZlZF9saW5lc193aXRoX2Rpc3RhbmNlcyUyMCUzRCUyMCU1QihyZXMlNUIlMjJlbnRpdHklMjIlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcmVzJTVCJTIyZGlzdGFuY2UlMjIlNUQpJTIwZm9yJTIwcmVzJTIwaW4lMjBzZWFyY2hfcmVzJTVCMCU1RCU1RCUwQXByaW50KGpzb24uZHVtcHMocmV0cmlldmVkX2xpbmVzX3dpdGhfZGlzdGFuY2VzJTJDJTIwaW5kZW50JTNENCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json

<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_lines_with_distances = [(res[<span class="hljs-string">&quot;entity&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], res[<span class="hljs-string">&quot;distance&quot;</span>]) <span class="hljs-keyword">for</span> res <span class="hljs-keyword">in</span> search_res[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(json.dumps(retrieved_lines_with_distances, indent=<span class="hljs-number">4</span>))`,wrap:!1}}),de=new M({props:{title:"Use LLM to get an RAG response",local:"use-llm-to-get-an-rag-response",headingTag:"h3"}}),he=new f({props:{code:"Y29udGV4dCUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbiglNUJsaW5lX3dpdGhfZGlzdGFuY2UlNUIwJTVEJTIwZm9yJTIwbGluZV93aXRoX2Rpc3RhbmNlJTIwaW4lMjByZXRyaWV2ZWRfbGluZXNfd2l0aF9kaXN0YW5jZXMlNUQp",highlighted:'context = <span class="hljs-string">&quot;\\n&quot;</span>.join([line_with_distance[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> line_with_distance <span class="hljs-keyword">in</span> retrieved_lines_with_distances])',wrap:!1}}),fe=new f({props:{code:"UFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBVXNlJTIwdGhlJTIwZm9sbG93aW5nJTIwcGllY2VzJTIwb2YlMjBpbmZvcm1hdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0Njb250ZXh0JTNFJTIwdGFncyUyMHRvJTIwcHJvdmlkZSUyMGFuJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0NxdWVzdGlvbiUzRSUyMHRhZ3MuJTBBJTNDY29udGV4dCUzRSUwQSU3QmNvbnRleHQlN0QlMEElM0MlMkZjb250ZXh0JTNFJTBBJTNDcXVlc3Rpb24lM0UlMEElN0JxdWVzdGlvbiU3RCUwQSUzQyUyRnF1ZXN0aW9uJTNFJTBBJTIyJTIyJTIy",highlighted:`PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Use the following pieces of information enclosed in &lt;context&gt; tags to provide an answer to the question enclosed in &lt;question&gt; tags.
&lt;context&gt;
{context}
&lt;/context&gt;
&lt;question&gt;
{question}
&lt;/question&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),be=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQWxsbV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQobW9kZWwlM0RyZXBvX2lkJTJDJTIwdGltZW91dCUzRDEyMCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(model=repo_id, timeout=<span class="hljs-number">120</span>)`,wrap:!1}}),we=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwUFJPTVBULmZvcm1hdChjb250ZXh0JTNEY29udGV4dCUyQyUyMHF1ZXN0aW9uJTNEcXVlc3Rpb24p",highlighted:'prompt = PROMPT.<span class="hljs-built_in">format</span>(context=context, question=question)',wrap:!1}}),ye=new f({props:{code:"YW5zd2VyJTIwJTNEJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBKS5zdHJpcCgpJTBBcHJpbnQoYW5zd2VyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>answer = llm_client.text_generation(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>).strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),$e=new wl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hf_and_milvus.md"}}),{c(){b=c("meta"),ve=n(),je=c("p"),Ie=n(),i(g.$$.fragment),Ge=n(),i(w.$$.fragment),Ce=n(),y=c("p"),y.innerHTML=Bt,ke=n(),J=c("p"),J.innerHTML=Vt,Ze=n(),T=c("p"),T.textContent=Nt,We=n(),i($.$$.fragment),xe=n(),i(j.$$.fragment),_e=n(),i(U.$$.fragment),Re=n(),v=c("blockquote"),v.innerHTML=At,Be=n(),I=c("p"),I.innerHTML=Et,Ve=n(),i(G.$$.fragment),Ne=n(),i(C.$$.fragment),Ae=n(),k=c("p"),k.innerHTML=qt,Ee=n(),i(Z.$$.fragment),qe=n(),W=c("p"),W.innerHTML=Ht,He=n(),i(x.$$.fragment),Xe=n(),_=c("pre"),_.textContent=Xt,ze=n(),i(R.$$.fragment),Qe=n(),i(B.$$.fragment),Fe=n(),i(V.$$.fragment),Ye=n(),N=c("p"),N.innerHTML=zt,Le=n(),i(A.$$.fragment),Se=n(),E=c("p"),E.textContent=Qt,Pe=n(),i(q.$$.fragment),De=n(),H=c("pre"),H.textContent=Ft,Ke=n(),i(X.$$.fragment),Oe=n(),i(z.$$.fragment),et=n(),i(Q.$$.fragment),tt=n(),F=c("blockquote"),F.innerHTML=Yt,lt=n(),Y=c("p"),Y.textContent=Lt,st=n(),i(L.$$.fragment),nt=n(),S=c("p"),S.textContent=St,at=n(),P=c("p"),P.innerHTML=Pt,it=n(),i(D.$$.fragment),ot=n(),i(K.$$.fragment),pt=n(),O=c("p"),O.textContent=Dt,rt=n(),ee=c("p"),ee.innerHTML=Kt,mt=n(),i(te.$$.fragment),dt=n(),i(le.$$.fragment),ct=n(),i(se.$$.fragment),ht=n(),ne=c("p"),ne.textContent=Ot,ut=n(),i(ae.$$.fragment),ft=n(),ie=c("p"),ie.textContent=el,Mt=n(),i(oe.$$.fragment),bt=n(),pe=c("p"),pe.textContent=tl,gt=n(),i(re.$$.fragment),wt=n(),me=c("pre"),me.textContent=ll,yt=n(),i(de.$$.fragment),Jt=n(),ce=c("p"),ce.textContent=sl,Tt=n(),i(he.$$.fragment),$t=n(),ue=c("p"),ue.textContent=nl,jt=n(),i(fe.$$.fragment),Ut=n(),Me=c("p"),Me.innerHTML=al,vt=n(),i(be.$$.fragment),It=n(),ge=c("p"),ge.textContent=il,Gt=n(),i(we.$$.fragment),Ct=n(),i(ye.$$.fragment),kt=n(),Je=c("pre"),Je.textContent=ol,Zt=n(),Te=c("p"),Te.textContent=pl,Wt=n(),i($e.$$.fragment),xt=n(),Ue=c("p"),this.h()},l(e){const t=Ml("svelte-u9bgzb",document.head);b=h(t,"META",{name:!0,content:!0}),t.forEach(l),ve=a(e),je=h(e,"P",{}),rl(je).forEach(l),Ie=a(e),o(g.$$.fragment,e),Ge=a(e),o(w.$$.fragment,e),Ce=a(e),y=h(e,"P",{"data-svelte-h":!0}),u(y)!=="svelte-1a5wzqz"&&(y.innerHTML=Bt),ke=a(e),J=h(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-142uvcg"&&(J.innerHTML=Vt),Ze=a(e),T=h(e,"P",{"data-svelte-h":!0}),u(T)!=="svelte-jfjp6k"&&(T.textContent=Nt),We=a(e),o($.$$.fragment,e),xe=a(e),o(j.$$.fragment,e),_e=a(e),o(U.$$.fragment,e),Re=a(e),v=h(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(v)!=="svelte-114m81z"&&(v.innerHTML=At),Be=a(e),I=h(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1pes3tr"&&(I.innerHTML=Et),Ve=a(e),o(G.$$.fragment,e),Ne=a(e),o(C.$$.fragment,e),Ae=a(e),k=h(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-10vdpvs"&&(k.innerHTML=qt),Ee=a(e),o(Z.$$.fragment,e),qe=a(e),W=h(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-ok4onc"&&(W.innerHTML=Ht),He=a(e),o(x.$$.fragment,e),Xe=a(e),_=h(e,"PRE",{"data-svelte-h":!0}),u(_)!=="svelte-q6t6yp"&&(_.textContent=Xt),ze=a(e),o(R.$$.fragment,e),Qe=a(e),o(B.$$.fragment,e),Fe=a(e),o(V.$$.fragment,e),Ye=a(e),N=h(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-3itqrj"&&(N.innerHTML=zt),Le=a(e),o(A.$$.fragment,e),Se=a(e),E=h(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1k4nam5"&&(E.textContent=Qt),Pe=a(e),o(q.$$.fragment,e),De=a(e),H=h(e,"PRE",{"data-svelte-h":!0}),u(H)!=="svelte-citxyn"&&(H.textContent=Ft),Ke=a(e),o(X.$$.fragment,e),Oe=a(e),o(z.$$.fragment,e),et=a(e),o(Q.$$.fragment,e),tt=a(e),F=h(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(F)!=="svelte-1s1ch14"&&(F.innerHTML=Yt),lt=a(e),Y=h(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1gg40t6"&&(Y.textContent=Lt),st=a(e),o(L.$$.fragment,e),nt=a(e),S=h(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-hrnx97"&&(S.textContent=St),at=a(e),P=h(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1t69aou"&&(P.innerHTML=Pt),it=a(e),o(D.$$.fragment,e),ot=a(e),o(K.$$.fragment,e),pt=a(e),O=h(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-tgjhxg"&&(O.textContent=Dt),rt=a(e),ee=h(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-acj9x6"&&(ee.innerHTML=Kt),mt=a(e),o(te.$$.fragment,e),dt=a(e),o(le.$$.fragment,e),ct=a(e),o(se.$$.fragment,e),ht=a(e),ne=h(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-16ohks1"&&(ne.textContent=Ot),ut=a(e),o(ae.$$.fragment,e),ft=a(e),ie=h(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-we6yp5"&&(ie.textContent=el),Mt=a(e),o(oe.$$.fragment,e),bt=a(e),pe=h(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1az8z3k"&&(pe.textContent=tl),gt=a(e),o(re.$$.fragment,e),wt=a(e),me=h(e,"PRE",{"data-svelte-h":!0}),u(me)!=="svelte-sx7p7m"&&(me.textContent=ll),yt=a(e),o(de.$$.fragment,e),Jt=a(e),ce=h(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-qfyl3s"&&(ce.textContent=sl),Tt=a(e),o(he.$$.fragment,e),$t=a(e),ue=h(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-108tlj2"&&(ue.textContent=nl),jt=a(e),o(fe.$$.fragment,e),Ut=a(e),Me=h(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1eeh79j"&&(Me.innerHTML=al),vt=a(e),o(be.$$.fragment,e),It=a(e),ge=h(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-i2qxha"&&(ge.textContent=il),Gt=a(e),o(we.$$.fragment,e),Ct=a(e),o(ye.$$.fragment,e),kt=a(e),Je=h(e,"PRE",{"data-svelte-h":!0}),u(Je)!=="svelte-18i7g4t"&&(Je.textContent=ol),Zt=a(e),Te=h(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-6dbn83"&&(Te.textContent=pl),Wt=a(e),o($e.$$.fragment,e),xt=a(e),Ue=h(e,"P",{}),rl(Ue).forEach(l),this.h()},h(){ml(b,"name","hf:doc:metadata"),ml(b,"content",Jl)},m(e,t){bl(document.head,b),s(e,ve,t),s(e,je,t),s(e,Ie,t),p(g,e,t),s(e,Ge,t),p(w,e,t),s(e,Ce,t),s(e,y,t),s(e,ke,t),s(e,J,t),s(e,Ze,t),s(e,T,t),s(e,We,t),p($,e,t),s(e,xe,t),p(j,e,t),s(e,_e,t),p(U,e,t),s(e,Re,t),s(e,v,t),s(e,Be,t),s(e,I,t),s(e,Ve,t),p(G,e,t),s(e,Ne,t),p(C,e,t),s(e,Ae,t),s(e,k,t),s(e,Ee,t),p(Z,e,t),s(e,qe,t),s(e,W,t),s(e,He,t),p(x,e,t),s(e,Xe,t),s(e,_,t),s(e,ze,t),p(R,e,t),s(e,Qe,t),p(B,e,t),s(e,Fe,t),p(V,e,t),s(e,Ye,t),s(e,N,t),s(e,Le,t),p(A,e,t),s(e,Se,t),s(e,E,t),s(e,Pe,t),p(q,e,t),s(e,De,t),s(e,H,t),s(e,Ke,t),p(X,e,t),s(e,Oe,t),p(z,e,t),s(e,et,t),p(Q,e,t),s(e,tt,t),s(e,F,t),s(e,lt,t),s(e,Y,t),s(e,st,t),p(L,e,t),s(e,nt,t),s(e,S,t),s(e,at,t),s(e,P,t),s(e,it,t),p(D,e,t),s(e,ot,t),p(K,e,t),s(e,pt,t),s(e,O,t),s(e,rt,t),s(e,ee,t),s(e,mt,t),p(te,e,t),s(e,dt,t),p(le,e,t),s(e,ct,t),p(se,e,t),s(e,ht,t),s(e,ne,t),s(e,ut,t),p(ae,e,t),s(e,ft,t),s(e,ie,t),s(e,Mt,t),p(oe,e,t),s(e,bt,t),s(e,pe,t),s(e,gt,t),p(re,e,t),s(e,wt,t),s(e,me,t),s(e,yt,t),p(de,e,t),s(e,Jt,t),s(e,ce,t),s(e,Tt,t),p(he,e,t),s(e,$t,t),s(e,ue,t),s(e,jt,t),p(fe,e,t),s(e,Ut,t),s(e,Me,t),s(e,vt,t),p(be,e,t),s(e,It,t),s(e,ge,t),s(e,Gt,t),p(we,e,t),s(e,Ct,t),p(ye,e,t),s(e,kt,t),s(e,Je,t),s(e,Zt,t),s(e,Te,t),s(e,Wt,t),p($e,e,t),s(e,xt,t),s(e,Ue,t),_t=!0},p:cl,i(e){_t||(r(g.$$.fragment,e),r(w.$$.fragment,e),r($.$$.fragment,e),r(j.$$.fragment,e),r(U.$$.fragment,e),r(G.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r(x.$$.fragment,e),r(R.$$.fragment,e),r(B.$$.fragment,e),r(V.$$.fragment,e),r(A.$$.fragment,e),r(q.$$.fragment,e),r(X.$$.fragment,e),r(z.$$.fragment,e),r(Q.$$.fragment,e),r(L.$$.fragment,e),r(D.$$.fragment,e),r(K.$$.fragment,e),r(te.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(oe.$$.fragment,e),r(re.$$.fragment,e),r(de.$$.fragment,e),r(he.$$.fragment,e),r(fe.$$.fragment,e),r(be.$$.fragment,e),r(we.$$.fragment,e),r(ye.$$.fragment,e),r($e.$$.fragment,e),_t=!0)},o(e){m(g.$$.fragment,e),m(w.$$.fragment,e),m($.$$.fragment,e),m(j.$$.fragment,e),m(U.$$.fragment,e),m(G.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(ye.$$.fragment,e),m($e.$$.fragment,e),_t=!1},d(e){e&&(l(ve),l(je),l(Ie),l(Ge),l(Ce),l(y),l(ke),l(J),l(Ze),l(T),l(We),l(xe),l(_e),l(Re),l(v),l(Be),l(I),l(Ve),l(Ne),l(Ae),l(k),l(Ee),l(qe),l(W),l(He),l(Xe),l(_),l(ze),l(Qe),l(Fe),l(Ye),l(N),l(Le),l(Se),l(E),l(Pe),l(De),l(H),l(Ke),l(Oe),l(et),l(tt),l(F),l(lt),l(Y),l(st),l(nt),l(S),l(at),l(P),l(it),l(ot),l(pt),l(O),l(rt),l(ee),l(mt),l(dt),l(ct),l(ht),l(ne),l(ut),l(ft),l(ie),l(Mt),l(bt),l(pe),l(gt),l(wt),l(me),l(yt),l(Jt),l(ce),l(Tt),l($t),l(ue),l(jt),l(Ut),l(Me),l(vt),l(It),l(ge),l(Gt),l(Ct),l(kt),l(Je),l(Zt),l(Te),l(Wt),l(xt),l(Ue)),l(b),d(g,e),d(w,e),d($,e),d(j,e),d(U,e),d(G,e),d(C,e),d(Z,e),d(x,e),d(R,e),d(B,e),d(V,e),d(A,e),d(q,e),d(X,e),d(z,e),d(Q,e),d(L,e),d(D,e),d(K,e),d(te,e),d(le,e),d(se,e),d(ae,e),d(oe,e),d(re,e),d(de,e),d(he,e),d(fe,e),d(be,e),d(we,e),d(ye,e),d($e,e)}}}const Jl='{"title":"Build RAG with Hugging Face and Milvus","local":"build-rag-with-hugging-face-and-milvus","sections":[{"title":"Preparation","local":"preparation","sections":[{"title":"Dependencies and Environment","local":"dependencies-and-environment","sections":[],"depth":3},{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":3},{"title":"Prepare the Embedding Model","local":"prepare-the-embedding-model","sections":[],"depth":3}],"depth":2},{"title":"Load data into Milvus","local":"load-data-into-milvus","sections":[{"title":"Create the Collection","local":"create-the-collection","sections":[],"depth":3},{"title":"Insert data","local":"insert-data","sections":[],"depth":3}],"depth":2},{"title":"Build RAG","local":"build-rag","sections":[{"title":"Retrieve data for a query","local":"retrieve-data-for-a-query","sections":[],"depth":3},{"title":"Use LLM to get an RAG response","local":"use-llm-to-get-an-rag-response","sections":[],"depth":3}],"depth":2}],"depth":1}';function Tl(Rt){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends ul{constructor(b){super(),fl(this,b,Tl,yl,dl,{})}}export{Il as component};
