import{s as sl,n as nl,o as il}from"../chunks/scheduler.c59d9fbb.js";import{S as pl,i as ol,g as i,s,r,A as rl,h as p,f as l,c as n,j as al,u as d,x as o,k as ye,y as dl,a,v as M,d as c,t as m,w as h}from"../chunks/index.a47918e3.js";import{C as u}from"../chunks/CodeBlock.936db8cd.js";import{H as Je}from"../chunks/Heading.604bc707.js";function Ml(_t){let f,je,we,Te,j,be,T,gt=`This guide demonstrates how to use LoRA, a low-rank approximation technique, to fine-tune DreamBooth with the
<code>CompVis/stable-diffusion-v1-4</code> model.`,_e,b,Zt=`Although LoRA was initially designed as a technique for reducing the number of trainable parameters in
large-language models, the technique can also be applied to diffusion models. Performing a complete model fine-tuning
of diffusion models is a time-consuming task, which is why lightweight techniques like DreamBooth or Textual Inversion
gained popularity. With the introduction of LoRA, customizing and fine-tuning a model on a specific dataset has become
even faster.`,ge,_,It=`In this guide we’ll be using a DreamBooth fine-tuning script that is available in
<a href="https://github.com/huggingface/peft/tree/main/examples/lora_dreambooth" rel="nofollow">PEFT’s GitHub repo</a>. Feel free to explore it and
learn how things work.`,Ze,g,Ie,Z,Ct="Start by cloning the PEFT repository:",Ce,I,Ge,C,Gt="Navigate to the directory containing the training scripts for fine-tuning Dreambooth with LoRA:",Re,G,Xe,R,Rt=`Set up your environment: install PEFT, and all the required libraries. At the time of writing this guide we recommend
installing PEFT from source.`,ve,X,Be,v,We,B,Xt="Prepare the images that you will use for fine-tuning the model. Set up a few environment variables:",$e,W,ke,$,vt="Here:",xe,k,Bt="<li><code>INSTANCE_DIR</code>: The directory containing the images that you intend to use for training your model.</li> <li><code>CLASS_DIR</code>: The directory containing class-specific images. In this example, we use prior preservation to avoid overfitting and language-drift. For prior preservation, you need other images of the same class as part of the training process. However, these images can be generated and the training script will save them to a local path you specify here.</li> <li><code>OUTPUT_DIR</code>: The destination folder for storing the trained model’s weights.</li>",Ve,x,Wt='To learn more about DreamBooth fine-tuning with prior-preserving loss, check out the <a href="https://huggingface.co/docs/diffusers/training/dreambooth#finetuning-with-priorpreserving-loss" rel="nofollow">Diffusers documentation</a>.',He,V,$t="Launch the training script with <code>accelerate</code> and pass hyperparameters, as well as LoRa-specific arguments to it such as:",Ae,H,kt="<li><code>use_lora</code>: Enables LoRa in the training script.</li> <li><code>lora_r</code>:  The dimension used by the LoRA update matrices.</li> <li><code>lora_alpha</code>: Scaling factor.</li> <li><code>lora_text_encoder_r</code>: LoRA rank for text encoder.</li> <li><code>lora_text_encoder_alpha</code>: LoRA alpha (scaling factor) for text encoder.</li>",Ye,A,xt="Here’s what the full set of script arguments may look like:",Ne,Y,Qe,N,Se,Q,Vt="To run inference with the fine-tuned model, first specify the base model with which the fine-tuned LoRA weights will be combined:",Fe,S,Ee,F,Ht=`Next, add a function that will create a Stable Diffusion pipeline for image generation. It will combine the weights of
the base model with the fine-tuned LoRA weights using <code>LoraConfig</code>.`,Le,E,qe,L,At=`Now you can use the function above to create a Stable Diffusion pipeline using the LoRA weights that you have created during the fine-tuning step.<br/>
Note, if you’re running inference on the same machine, the path you specify here will be the same as <code>OUTPUT_DIR</code>.`,ze,q,De,z,Yt="Once you have the pipeline with your fine-tuned model, you can use it to generate images:",Pe,D,Ke,y,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_dog_park.png" alt="Generated image of a dog in a park"/>',Oe,P,et,K,Qt=`With PEFT you can combine multiple adapters for inference. In the previous example you have fine-tuned Stable Diffusion on
some dog images. The pipeline created based on these weights got a name - <code>adapter_name=&quot;dog</code>. Now, suppose you also fine-tuned
this base model on images of a crochet toy. Let’s see how we can use both adapters.`,tt,O,St="First, you’ll need to perform all the steps as in the single adapter inference example:",lt,ee,Ft="<li>Specify the base model.</li> <li>Add a function that creates a Stable Diffusion pipeline for image generation uses LoRA weights.</li> <li>Create a <code>pipe</code> with <code>adapter_name=&quot;dog&quot;</code> based on the model fine-tuned on dog images.</li>",at,te,Et=`Next, you’re going to need a few more helper functions.
To load another adapter, create a <code>load_adapter()</code> function that leverages <code>load_adapter()</code> method of <code>PeftModel</code> (e.g. <code>pipe.unet.load_adapter(peft_model_path, adapter_name)</code>):`,st,le,nt,ae,Lt="To switch between adapters, write a function that uses <code>set_adapter()</code> method of <code>PeftModel</code> (see <code>pipe.unet.set_adapter(adapter_name)</code>)",it,se,pt,ne,qt="Finally, add a function to create weighted LoRA adapter.",ot,ie,rt,pe,zt="Let’s load the second adapter from the model fine-tuned on images of a crochet toy, and give it a unique name:",dt,oe,Mt,re,Dt="Create a pipeline using weighted adapters:",ct,de,mt,Me,Pt="Now you can switch between adapters. If you’d like to generate more dog images, set the adapter to <code>&quot;dog&quot;</code>:",ht,ce,ut,w,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_dog_supermarket.png" alt="Generated image of a dog in a supermarket"/>',ft,me,Ot="In the same way, you can switch to the second adapter:",yt,he,wt,U,el='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_fish.png" alt="Generated image of a crochet fish"/>',Ut,ue,tl="Finally, you can use combined weighted adapters:",Jt,fe,jt,J,ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_crochet_dog.png" alt="Generated image of a crochet dog"/>',Tt,Ue,bt;return j=new Je({props:{title:"DreamBooth fine-tuning with LoRA",local:"dreambooth-fine-tuning-with-lora",headingTag:"h1"}}),g=new Je({props:{title:"Set up your environment",local:"set-up-your-environment",headingTag:"h2"}}),I=new u({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQ=",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/peft',wrap:!1}}),G=new u({props:{code:"Y2QlMjBwZWZ0JTJGZXhhbXBsZXMlMkZsb3JhX2RyZWFtYm9vdGg=",highlighted:'<span class="hljs-built_in">cd</span> peft/examples/lora_dreambooth',wrap:!1}}),X=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dCUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQ=",highlighted:`pip install -r requirements.txt
pip install git+https://github.com/huggingface/peft`,wrap:!1}}),v=new Je({props:{title:"Fine-tuning DreamBooth",local:"fine-tuning-dreambooth",headingTag:"h2"}}),W=new u({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMjAlMEFleHBvcnQlMjBJTlNUQU5DRV9ESVIlM0QlMjJwYXRoLXRvLWluc3RhbmNlLWltYWdlcyUyMiUwQWV4cG9ydCUyMENMQVNTX0RJUiUzRCUyMnBhdGgtdG8tY2xhc3MtaW1hZ2VzJTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGgtdG8tc2F2ZS1tb2RlbCUyMg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span> 
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;path-to-instance-images&quot;</span>
<span class="hljs-built_in">export</span> CLASS_DIR=<span class="hljs-string">&quot;path-to-class-images&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>`,wrap:!1}}),Y=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfZGF0YV9kaXIlM0QlMjRJTlNUQU5DRV9ESVIlMjAlNUMlMEElMjAlMjAtLWNsYXNzX2RhdGFfZGlyJTNEJTI0Q0xBU1NfRElSJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fdGV4dF9lbmNvZGVyJTIwJTVDJTBBJTIwJTIwLS13aXRoX3ByaW9yX3ByZXNlcnZhdGlvbiUyMC0tcHJpb3JfbG9zc193ZWlnaHQlM0QxLjAlMjAlNUMlMEElMjAlMjAtLWluc3RhbmNlX3Byb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwc2tzJTIwZG9nJTIyJTIwJTVDJTBBJTIwJTIwLS1jbGFzc19wcm9tcHQlM0QlMjJhJTIwcGhvdG8lMjBvZiUyMGRvZyUyMiUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWxyX3NjaGVkdWxlciUzRCUyMmNvbnN0YW50JTIyJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1udW1fY2xhc3NfaW1hZ2VzJTNEMjAwJTIwJTVDJTBBJTIwJTIwLS11c2VfbG9yYSUyMCU1QyUwQSUyMCUyMC0tbG9yYV9yJTIwMTYlMjAlNUMlMEElMjAlMjAtLWxvcmFfYWxwaGElMjAyNyUyMCU1QyUwQSUyMCUyMC0tbG9yYV90ZXh0X2VuY29kZXJfciUyMDE2JTIwJTVDJTBBJTIwJTIwLS1sb3JhX3RleHRfZW5jb2Rlcl9hbHBoYSUyMDE3JTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNCUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEODAw",highlighted:`accelerate launch train_dreambooth.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --class_data_dir=<span class="hljs-variable">$CLASS_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --train_text_encoder \\
  --with_prior_preservation --prior_loss_weight=1.0 \\
  --instance_prompt=<span class="hljs-string">&quot;a photo of sks dog&quot;</span> \\
  --class_prompt=<span class="hljs-string">&quot;a photo of dog&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --num_class_images=200 \\
  --use_lora \\
  --lora_r 16 \\
  --lora_alpha 27 \\
  --lora_text_encoder_r 16 \\
  --lora_text_encoder_alpha 17 \\
  --learning_rate=1e-4 \\
  --gradient_accumulation_steps=1 \\
  --gradient_checkpointing \\
  --max_train_steps=800`,wrap:!1}}),N=new Je({props:{title:"Inference with a single adapter",local:"inference-with-a-single-adapter",headingTag:"h2"}}),S=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, LoraConfig

MODEL_NAME = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>`,wrap:!1}}),E=new u({props:{code:"ZGVmJTIwZ2V0X2xvcmFfc2RfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwY2twdF9kaXIlMkMlMjBiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUzRE5vbmUlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyZGVmYXVsdCUyMiUwQSklM0ElMEElMjAlMjAlMjAlMjB1bmV0X3N1Yl9kaXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oY2twdF9kaXIlMkMlMjAlMjJ1bmV0JTIyKSUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9zdWJfZGlyJTIwJTNEJTIwb3MucGF0aC5qb2luKGNrcHRfZGlyJTJDJTIwJTIydGV4dF9lbmNvZGVyJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwb3MucGF0aC5leGlzdHModGV4dF9lbmNvZGVyX3N1Yl9kaXIpJTIwYW5kJTIwYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnLmZyb21fcHJldHJhaW5lZCh0ZXh0X2VuY29kZXJfc3ViX2RpciklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyMCUzRCUyMGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoJTIyUGxlYXNlJTIwc3BlY2lmeSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyMG5hbWUlMjBvciUyMHBhdGglMjIpJTBBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGUudW5ldCUyQyUyMHVuZXRfc3ViX2RpciUyQyUyMGFkYXB0ZXJfbmFtZSUzRGFkYXB0ZXJfbmFtZSklMEElMEElMjAlMjAlMjAlMjBpZiUyMG9zLnBhdGguZXhpc3RzKHRleHRfZW5jb2Rlcl9zdWJfZGlyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpcGUudGV4dF9lbmNvZGVyJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLnRleHRfZW5jb2RlciUyQyUyMHRleHRfZW5jb2Rlcl9zdWJfZGlyJTJDJTIwYWRhcHRlcl9uYW1lJTNEYWRhcHRlcl9uYW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwZHR5cGUlMjBpbiUyMCh0b3JjaC5mbG9hdDE2JTJDJTIwdG9yY2guYmZsb2F0MTYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZS51bmV0LmhhbGYoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpcGUudGV4dF9lbmNvZGVyLmhhbGYoKSUwQSUwQSUyMCUyMCUyMCUyMHBpcGUudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBpcGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_lora_sd_pipeline</span>(<span class="hljs-params">
    ckpt_dir, base_model_name_or_path=<span class="hljs-literal">None</span>, dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>, adapter_name=<span class="hljs-string">&quot;default&quot;</span>
</span>):
    unet_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;unet&quot;</span>)
    text_encoder_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;text_encoder&quot;</span>)
    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir) <span class="hljs-keyword">and</span> base_model_name_or_path <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        config = LoraConfig.from_pretrained(text_encoder_sub_dir)
        base_model_name_or_path = config.base_model_name_or_path

    <span class="hljs-keyword">if</span> base_model_name_or_path <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Please specify the base model name or path&quot;</span>)

    pipe = StableDiffusionPipeline.from_pretrained(base_model_name_or_path, torch_dtype=dtype).to(device)
    pipe.unet = PeftModel.from_pretrained(pipe.unet, unet_sub_dir, adapter_name=adapter_name)

    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir):
        pipe.text_encoder = PeftModel.from_pretrained(
            pipe.text_encoder, text_encoder_sub_dir, adapter_name=adapter_name
        )

    <span class="hljs-keyword">if</span> dtype <span class="hljs-keyword">in</span> (torch.float16, torch.bfloat16):
        pipe.unet.half()
        pipe.text_encoder.half()

    pipe.to(device)
    <span class="hljs-keyword">return</span> pipe`,wrap:!1}}),q=new u({props:{code:"cGlwZSUyMCUzRCUyMGdldF9sb3JhX3NkX3BpcGVsaW5lKFBhdGgoJTIycGF0aC10by1zYXZlZC1tb2RlbCUyMiklMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkb2clMjIp",highlighted:'pipe = get_lora_sd_pipeline(Path(<span class="hljs-string">&quot;path-to-saved-model&quot;</span>), adapter_name=<span class="hljs-string">&quot;dog&quot;</span>)',wrap:!1}}),D=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyc2tzJTIwZG9nJTIwcGxheWluZyUyMGZldGNoJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJsdXJyeSUyQyUyMHVuZmluaXNoZWQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJERVNUSU5BVElPTl9QQVRIX0ZPUl9USEVfSU1BR0UlMjIp",highlighted:`prompt = <span class="hljs-string">&quot;sks dog playing fetch in the park&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;DESTINATION_PATH_FOR_THE_IMAGE&quot;</span>)`,wrap:!1}}),P=new Je({props:{title:"Multi-adapter inference",local:"multi-adapter-inference",headingTag:"h2"}}),le=new u({props:{code:"ZGVmJTIwbG9hZF9hZGFwdGVyKHBpcGUlMkMlMjBja3B0X2RpciUyQyUyMGFkYXB0ZXJfbmFtZSklM0ElMEElMjAlMjAlMjAlMjB1bmV0X3N1Yl9kaXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oY2twdF9kaXIlMkMlMjAlMjJ1bmV0JTIyKSUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9zdWJfZGlyJTIwJTNEJTIwb3MucGF0aC5qb2luKGNrcHRfZGlyJTJDJTIwJTIydGV4dF9lbmNvZGVyJTIyKSUwQSUyMCUyMCUyMCUyMHBpcGUudW5ldC5sb2FkX2FkYXB0ZXIodW5ldF9zdWJfZGlyJTJDJTIwYWRhcHRlcl9uYW1lJTNEYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwb3MucGF0aC5leGlzdHModGV4dF9lbmNvZGVyX3N1Yl9kaXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZS50ZXh0X2VuY29kZXIubG9hZF9hZGFwdGVyKHRleHRfZW5jb2Rlcl9zdWJfZGlyJTJDJTIwYWRhcHRlcl9uYW1lJTNEYWRhcHRlcl9uYW1lKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_adapter</span>(<span class="hljs-params">pipe, ckpt_dir, adapter_name</span>):
    unet_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;unet&quot;</span>)
    text_encoder_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;text_encoder&quot;</span>)
    pipe.unet.load_adapter(unet_sub_dir, adapter_name=adapter_name)
    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir):
        pipe.text_encoder.load_adapter(text_encoder_sub_dir, adapter_name=adapter_name)`,wrap:!1}}),se=new u({props:{code:"ZGVmJTIwc2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSklM0ElMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuc2V0X2FkYXB0ZXIoYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwaXBlLnRleHRfZW5jb2RlciUyQyUyMFBlZnRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLnRleHRfZW5jb2Rlci5zZXRfYWRhcHRlcihhZGFwdGVyX25hbWUp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">set_adapter</span>(<span class="hljs-params">pipe, adapter_name</span>):
    pipe.unet.set_adapter(adapter_name)
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(pipe.text_encoder, PeftModel):
        pipe.text_encoder.set_adapter(adapter_name)`,wrap:!1}}),ie=new u({props:{code:"ZGVmJTIwY3JlYXRlX3dlaWdodGVkX2xvcmFfYWRhcHRlcihwaXBlJTJDJTIwYWRhcHRlcnMlMkMlMjB3ZWlnaHRzJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyZGVmYXVsdCUyMiklM0ElMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuYWRkX3dlaWdodGVkX2FkYXB0ZXIoYWRhcHRlcnMlMkMlMjB3ZWlnaHRzJTJDJTIwYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwaXBlLnRleHRfZW5jb2RlciUyQyUyMFBlZnRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLnRleHRfZW5jb2Rlci5hZGRfd2VpZ2h0ZWRfYWRhcHRlcihhZGFwdGVycyUyQyUyMHdlaWdodHMlMkMlMjBhZGFwdGVyX25hbWUpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcGlwZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_weighted_lora_adapter</span>(<span class="hljs-params">pipe, adapters, weights, adapter_name=<span class="hljs-string">&quot;default&quot;</span></span>):
    pipe.unet.add_weighted_adapter(adapters, weights, adapter_name)
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(pipe.text_encoder, PeftModel):
        pipe.text_encoder.add_weighted_adapter(adapters, weights, adapter_name)

    <span class="hljs-keyword">return</span> pipe`,wrap:!1}}),oe=new u({props:{code:"bG9hZF9hZGFwdGVyKHBpcGUlMkMlMjBQYXRoKCUyMnBhdGgtdG8tdGhlLXNlY29uZC1zYXZlZC1tb2RlbCUyMiklMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJjcm9jaGV0JTIyKQ==",highlighted:'load_adapter(pipe, Path(<span class="hljs-string">&quot;path-to-the-second-saved-model&quot;</span>), adapter_name=<span class="hljs-string">&quot;crochet&quot;</span>)',wrap:!1}}),de=new u({props:{code:"cGlwZSUyMCUzRCUyMGNyZWF0ZV93ZWlnaHRlZF9sb3JhX2FkYXB0ZXIocGlwZSUyQyUyMCU1QiUyMmNyb2NoZXQlMjIlMkMlMjAlMjJkb2clMjIlNUQlMkMlMjAlNUIxLjAlMkMlMjAxLjA1JTVEJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyY3JvY2hldF9kb2clMjIp",highlighted:'pipe = create_weighted_lora_adapter(pipe, [<span class="hljs-string">&quot;crochet&quot;</span>, <span class="hljs-string">&quot;dog&quot;</span>], [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.05</span>], adapter_name=<span class="hljs-string">&quot;crochet_dog&quot;</span>)',wrap:!1}}),ce=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRvZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJza3MlMjBkb2clMjBpbiUyMGElMjBzdXBlcm1hcmtldCUyMGlzbGUlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;dog&quot;</span>)
prompt = <span class="hljs-string">&quot;sks dog in a supermarket isle&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),he=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmNyb2NoZXQlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGZpc2glMjByZW5kZXJlZCUyMGluJTIwdGhlJTIwc3R5bGUlMjBvZiUyMCUzQzElM0UlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;crochet&quot;</span>)
prompt = <span class="hljs-string">&quot;a fish rendered in the style of &lt;1&gt;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),fe=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmNyb2NoZXRfZG9nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnNrcyUyMGRvZyUyMHJlbmRlcmVkJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwJTNDMSUzRSUyQyUyMGNsb3NlJTIwdXAlMjBwb3J0cmFpdCUyQyUyMDRLJTIwSEQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;crochet_dog&quot;</span>)
prompt = <span class="hljs-string">&quot;sks dog rendered in the style of &lt;1&gt;, close up portrait, 4K HD&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){f=i("meta"),je=s(),we=i("p"),Te=s(),r(j.$$.fragment),be=s(),T=i("p"),T.innerHTML=gt,_e=s(),b=i("p"),b.textContent=Zt,ge=s(),_=i("p"),_.innerHTML=It,Ze=s(),r(g.$$.fragment),Ie=s(),Z=i("p"),Z.textContent=Ct,Ce=s(),r(I.$$.fragment),Ge=s(),C=i("p"),C.textContent=Gt,Re=s(),r(G.$$.fragment),Xe=s(),R=i("p"),R.textContent=Rt,ve=s(),r(X.$$.fragment),Be=s(),r(v.$$.fragment),We=s(),B=i("p"),B.textContent=Xt,$e=s(),r(W.$$.fragment),ke=s(),$=i("p"),$.textContent=vt,xe=s(),k=i("ul"),k.innerHTML=Bt,Ve=s(),x=i("p"),x.innerHTML=Wt,He=s(),V=i("p"),V.innerHTML=$t,Ae=s(),H=i("ul"),H.innerHTML=kt,Ye=s(),A=i("p"),A.textContent=xt,Ne=s(),r(Y.$$.fragment),Qe=s(),r(N.$$.fragment),Se=s(),Q=i("p"),Q.textContent=Vt,Fe=s(),r(S.$$.fragment),Ee=s(),F=i("p"),F.innerHTML=Ht,Le=s(),r(E.$$.fragment),qe=s(),L=i("p"),L.innerHTML=At,ze=s(),r(q.$$.fragment),De=s(),z=i("p"),z.textContent=Yt,Pe=s(),r(D.$$.fragment),Ke=s(),y=i("div"),y.innerHTML=Nt,Oe=s(),r(P.$$.fragment),et=s(),K=i("p"),K.innerHTML=Qt,tt=s(),O=i("p"),O.textContent=St,lt=s(),ee=i("ol"),ee.innerHTML=Ft,at=s(),te=i("p"),te.innerHTML=Et,st=s(),r(le.$$.fragment),nt=s(),ae=i("p"),ae.innerHTML=Lt,it=s(),r(se.$$.fragment),pt=s(),ne=i("p"),ne.textContent=qt,ot=s(),r(ie.$$.fragment),rt=s(),pe=i("p"),pe.textContent=zt,dt=s(),r(oe.$$.fragment),Mt=s(),re=i("p"),re.textContent=Dt,ct=s(),r(de.$$.fragment),mt=s(),Me=i("p"),Me.innerHTML=Pt,ht=s(),r(ce.$$.fragment),ut=s(),w=i("div"),w.innerHTML=Kt,ft=s(),me=i("p"),me.textContent=Ot,yt=s(),r(he.$$.fragment),wt=s(),U=i("div"),U.innerHTML=el,Ut=s(),ue=i("p"),ue.textContent=tl,Jt=s(),r(fe.$$.fragment),jt=s(),J=i("div"),J.innerHTML=ll,Tt=s(),Ue=i("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),je=n(e),we=p(e,"P",{}),al(we).forEach(l),Te=n(e),d(j.$$.fragment,e),be=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-i4284a"&&(T.innerHTML=gt),_e=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1dejz68"&&(b.textContent=Zt),ge=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-18fgk7y"&&(_.innerHTML=It),Ze=n(e),d(g.$$.fragment,e),Ie=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-pxn7b7"&&(Z.textContent=Ct),Ce=n(e),d(I.$$.fragment,e),Ge=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-a2i2v3"&&(C.textContent=Gt),Re=n(e),d(G.$$.fragment,e),Xe=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-18c5jsl"&&(R.textContent=Rt),ve=n(e),d(X.$$.fragment,e),Be=n(e),d(v.$$.fragment,e),We=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1repjk"&&(B.textContent=Xt),$e=n(e),d(W.$$.fragment,e),ke=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1vuwyaw"&&($.textContent=vt),xe=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-x6kqao"&&(k.innerHTML=Bt),Ve=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-10y2hi5"&&(x.innerHTML=Wt),He=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-7ccaxr"&&(V.innerHTML=$t),Ae=n(e),H=p(e,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-1dm7o23"&&(H.innerHTML=kt),Ye=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-11r7hrr"&&(A.textContent=xt),Ne=n(e),d(Y.$$.fragment,e),Qe=n(e),d(N.$$.fragment,e),Se=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1apgfqi"&&(Q.textContent=Vt),Fe=n(e),d(S.$$.fragment,e),Ee=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1p89jr"&&(F.innerHTML=Ht),Le=n(e),d(E.$$.fragment,e),qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-bgs6sh"&&(L.innerHTML=At),ze=n(e),d(q.$$.fragment,e),De=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1cenv69"&&(z.textContent=Yt),Pe=n(e),d(D.$$.fragment,e),Ke=n(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1hia4bn"&&(y.innerHTML=Nt),Oe=n(e),d(P.$$.fragment,e),et=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-te66zn"&&(K.innerHTML=Qt),tt=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-mwwver"&&(O.textContent=St),lt=n(e),ee=p(e,"OL",{"data-svelte-h":!0}),o(ee)!=="svelte-1gkcmas"&&(ee.innerHTML=Ft),at=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-xiz6st"&&(te.innerHTML=Et),st=n(e),d(le.$$.fragment,e),nt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-f4lw3s"&&(ae.innerHTML=Lt),it=n(e),d(se.$$.fragment,e),pt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-q73wxm"&&(ne.textContent=qt),ot=n(e),d(ie.$$.fragment,e),rt=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fx7zod"&&(pe.textContent=zt),dt=n(e),d(oe.$$.fragment,e),Mt=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1uthdyu"&&(re.textContent=Dt),ct=n(e),d(de.$$.fragment,e),mt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-bep1v2"&&(Me.innerHTML=Pt),ht=n(e),d(ce.$$.fragment,e),ut=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1qy283v"&&(w.innerHTML=Kt),ft=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-v1nd15"&&(me.textContent=Ot),yt=n(e),d(he.$$.fragment,e),wt=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1awtarq"&&(U.innerHTML=el),Ut=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-ddp1rv"&&(ue.textContent=tl),Jt=n(e),d(fe.$$.fragment,e),jt=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1w1m79d"&&(J.innerHTML=ll),Tt=n(e),Ue=p(e,"P",{}),al(Ue).forEach(l),this.h()},h(){ye(f,"name","hf:doc:metadata"),ye(f,"content",cl),ye(y,"class","flex justify-center"),ye(w,"class","flex justify-center"),ye(U,"class","flex justify-center"),ye(J,"class","flex justify-center")},m(e,t){dl(document.head,f),a(e,je,t),a(e,we,t),a(e,Te,t),M(j,e,t),a(e,be,t),a(e,T,t),a(e,_e,t),a(e,b,t),a(e,ge,t),a(e,_,t),a(e,Ze,t),M(g,e,t),a(e,Ie,t),a(e,Z,t),a(e,Ce,t),M(I,e,t),a(e,Ge,t),a(e,C,t),a(e,Re,t),M(G,e,t),a(e,Xe,t),a(e,R,t),a(e,ve,t),M(X,e,t),a(e,Be,t),M(v,e,t),a(e,We,t),a(e,B,t),a(e,$e,t),M(W,e,t),a(e,ke,t),a(e,$,t),a(e,xe,t),a(e,k,t),a(e,Ve,t),a(e,x,t),a(e,He,t),a(e,V,t),a(e,Ae,t),a(e,H,t),a(e,Ye,t),a(e,A,t),a(e,Ne,t),M(Y,e,t),a(e,Qe,t),M(N,e,t),a(e,Se,t),a(e,Q,t),a(e,Fe,t),M(S,e,t),a(e,Ee,t),a(e,F,t),a(e,Le,t),M(E,e,t),a(e,qe,t),a(e,L,t),a(e,ze,t),M(q,e,t),a(e,De,t),a(e,z,t),a(e,Pe,t),M(D,e,t),a(e,Ke,t),a(e,y,t),a(e,Oe,t),M(P,e,t),a(e,et,t),a(e,K,t),a(e,tt,t),a(e,O,t),a(e,lt,t),a(e,ee,t),a(e,at,t),a(e,te,t),a(e,st,t),M(le,e,t),a(e,nt,t),a(e,ae,t),a(e,it,t),M(se,e,t),a(e,pt,t),a(e,ne,t),a(e,ot,t),M(ie,e,t),a(e,rt,t),a(e,pe,t),a(e,dt,t),M(oe,e,t),a(e,Mt,t),a(e,re,t),a(e,ct,t),M(de,e,t),a(e,mt,t),a(e,Me,t),a(e,ht,t),M(ce,e,t),a(e,ut,t),a(e,w,t),a(e,ft,t),a(e,me,t),a(e,yt,t),M(he,e,t),a(e,wt,t),a(e,U,t),a(e,Ut,t),a(e,ue,t),a(e,Jt,t),M(fe,e,t),a(e,jt,t),a(e,J,t),a(e,Tt,t),a(e,Ue,t),bt=!0},p:nl,i(e){bt||(c(j.$$.fragment,e),c(g.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(X.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(Y.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),bt=!0)},o(e){m(j.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),bt=!1},d(e){e&&(l(je),l(we),l(Te),l(be),l(T),l(_e),l(b),l(ge),l(_),l(Ze),l(Ie),l(Z),l(Ce),l(Ge),l(C),l(Re),l(Xe),l(R),l(ve),l(Be),l(We),l(B),l($e),l(ke),l($),l(xe),l(k),l(Ve),l(x),l(He),l(V),l(Ae),l(H),l(Ye),l(A),l(Ne),l(Qe),l(Se),l(Q),l(Fe),l(Ee),l(F),l(Le),l(qe),l(L),l(ze),l(De),l(z),l(Pe),l(Ke),l(y),l(Oe),l(et),l(K),l(tt),l(O),l(lt),l(ee),l(at),l(te),l(st),l(nt),l(ae),l(it),l(pt),l(ne),l(ot),l(rt),l(pe),l(dt),l(Mt),l(re),l(ct),l(mt),l(Me),l(ht),l(ut),l(w),l(ft),l(me),l(yt),l(wt),l(U),l(Ut),l(ue),l(Jt),l(jt),l(J),l(Tt),l(Ue)),l(f),h(j,e),h(g,e),h(I,e),h(G,e),h(X,e),h(v,e),h(W,e),h(Y,e),h(N,e),h(S,e),h(E,e),h(q,e),h(D,e),h(P,e),h(le,e),h(se,e),h(ie,e),h(oe,e),h(de,e),h(ce,e),h(he,e),h(fe,e)}}}const cl='{"title":"DreamBooth fine-tuning with LoRA","local":"dreambooth-fine-tuning-with-lora","sections":[{"title":"Set up your environment","local":"set-up-your-environment","sections":[],"depth":2},{"title":"Fine-tuning DreamBooth","local":"fine-tuning-dreambooth","sections":[],"depth":2},{"title":"Inference with a single adapter","local":"inference-with-a-single-adapter","sections":[],"depth":2},{"title":"Multi-adapter inference","local":"multi-adapter-inference","sections":[],"depth":2}],"depth":1}';function ml(_t){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends pl{constructor(f){super(),ol(this,f,ml,Ml,sl,{})}}export{wl as component};
