import{s as Me,o as be,n as we}from"../chunks/scheduler.c57aa7ef.js";import{S as Te,i as ye,g as s,s as n,r as m,A as ge,h as o,f as l,c as i,j as he,u as f,x as r,k as ce,y as Je,a,v as u,d,t as h,w as c}from"../chunks/index.c50cb18e.js";import{T as _e}from"../chunks/Tip.9268b0ca.js";import{C as g}from"../chunks/CodeBlock.34f0a53d.js";import{H as it}from"../chunks/Heading.c7d7e0e7.js";function $e(ot){let p,_='LoftQ initialization does not require quantizing the base model with the <code>load_in_4bits</code> parameter in the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method! Learn more about LoftQ initialization in the <a href="../developer_guides/lora#initialization">Initialization options</a> section.',T,b,y="Note: You can only perform LoftQ initialization on a GPU.";return{c(){p=s("p"),p.innerHTML=_,T=n(),b=s("p"),b.textContent=y},l(M){p=o(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p70fnx"&&(p.innerHTML=_),T=i(M),b=o(M,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1rnmx2i"&&(b.textContent=y)},m(M,w){a(M,p,w),a(M,T,w),a(M,b,w)},p:we,d(M){M&&(l(p),l(T),l(b))}}}function qe(ot){let p,_,T,b,y,M,w,Vt="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",rt,$,Ht='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',pt,q,Yt='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',mt,j,Pt="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",ft,v,ut,C,St='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',dt,L,Dt="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",ht,B,ct,U,Kt='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Mt,Q,bt,Z,Ot='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',wt,z,Tt,I,te="Now that the quantized model is ready, let’s set up a configuration.",yt,k,gt,x,ee='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Jt,R,_t,A,le='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',$t,W,qt,E,ae="You’re all set for training with whichever training method you prefer!",jt,G,vt,X,ne='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, create a <code>LoftQConfig</code> and set <code>loftq_bits=4</code> for 4-bit quantization.',Ct,J,Lt,F,Bt,N,ie='Now pass the <code>loftq_config</code> to the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> to enable LoftQ initialization, and create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> for training.',Ut,V,Qt,H,Zt,Y,se="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",zt,P,It,S,kt,D,oe='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',xt,K,re='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Rt,O,pe="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",At,tt,Wt,et,me='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Et,lt,Gt,at,fe="If you’re interested in learning more about quantization, the following may be helpful:",Xt,nt,ue='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Ft,st,Nt;return y=new it({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),v=new it({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),B=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),Q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),z=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),k=new it({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),R=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),W=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),G=new it({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),J=new _e({props:{warning:!0,$$slots:{default:[$e]},$$scope:{ctx:ot}}}),F=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWxvZnRxX2NvbmZpZyUyMCUzRCUyMExvZnRRQ29uZmlnKGxvZnRxX2JpdHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>)`,wrap:!1}}),V=new g({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIybG9mdHElMjIlMkMlMEElMjAlMjAlMjAlMjBsb2Z0cV9jb25maWclM0Rsb2Z0cV9jb25maWclMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyk=",highlighted:`lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>,
    loftq_config=loftq_config,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, lora_config)`,wrap:!1}}),H=new it({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),P=new g({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),S=new it({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),tt=new g({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),lt=new it({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){p=s("meta"),_=n(),T=s("p"),b=n(),m(y.$$.fragment),M=n(),w=s("p"),w.textContent=Vt,rt=n(),$=s("ul"),$.innerHTML=Ht,pt=n(),q=s("p"),q.innerHTML=Yt,mt=n(),j=s("p"),j.textContent=Pt,ft=n(),m(v.$$.fragment),ut=n(),C=s("p"),C.innerHTML=St,dt=n(),L=s("ul"),L.innerHTML=Dt,ht=n(),m(B.$$.fragment),ct=n(),U=s("p"),U.innerHTML=Kt,Mt=n(),m(Q.$$.fragment),bt=n(),Z=s("p"),Z.innerHTML=Ot,wt=n(),m(z.$$.fragment),Tt=n(),I=s("p"),I.textContent=te,yt=n(),m(k.$$.fragment),gt=n(),x=s("p"),x.innerHTML=ee,Jt=n(),m(R.$$.fragment),_t=n(),A=s("p"),A.innerHTML=le,$t=n(),m(W.$$.fragment),qt=n(),E=s("p"),E.textContent=ae,jt=n(),m(G.$$.fragment),vt=n(),X=s("p"),X.innerHTML=ne,Ct=n(),m(J.$$.fragment),Lt=n(),m(F.$$.fragment),Bt=n(),N=s("p"),N.innerHTML=ie,Ut=n(),m(V.$$.fragment),Qt=n(),m(H.$$.fragment),Zt=n(),Y=s("p"),Y.innerHTML=se,zt=n(),m(P.$$.fragment),It=n(),m(S.$$.fragment),kt=n(),D=s("p"),D.innerHTML=oe,xt=n(),K=s("p"),K.innerHTML=re,Rt=n(),O=s("p"),O.innerHTML=pe,At=n(),m(tt.$$.fragment),Wt=n(),et=s("p"),et.innerHTML=me,Et=n(),m(lt.$$.fragment),Gt=n(),at=s("p"),at.textContent=fe,Xt=n(),nt=s("ul"),nt.innerHTML=ue,Ft=n(),st=s("p"),this.h()},l(t){const e=ge("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(l),_=i(t),T=o(t,"P",{}),he(T).forEach(l),b=i(t),f(y.$$.fragment,t),M=i(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=Vt),rt=i(t),$=o(t,"UL",{"data-svelte-h":!0}),r($)!=="svelte-27c91"&&($.innerHTML=Ht),pt=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-142xot4"&&(q.innerHTML=Yt),mt=i(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1demhiu"&&(j.textContent=Pt),ft=i(t),f(v.$$.fragment,t),ut=i(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-p0gbf4"&&(C.innerHTML=St),dt=i(t),L=o(t,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-hfynw8"&&(L.innerHTML=Dt),ht=i(t),f(B.$$.fragment,t),ct=i(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-pxonbi"&&(U.innerHTML=Kt),Mt=i(t),f(Q.$$.fragment,t),bt=i(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1i20kxq"&&(Z.innerHTML=Ot),wt=i(t),f(z.$$.fragment,t),Tt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-11mx7fc"&&(I.textContent=te),yt=i(t),f(k.$$.fragment,t),gt=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-16xpk8c"&&(x.innerHTML=ee),Jt=i(t),f(R.$$.fragment,t),_t=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-rnh6oi"&&(A.innerHTML=le),$t=i(t),f(W.$$.fragment,t),qt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-xd402n"&&(E.textContent=ae),jt=i(t),f(G.$$.fragment,t),vt=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-g845ls"&&(X.innerHTML=ne),Ct=i(t),f(J.$$.fragment,t),Lt=i(t),f(F.$$.fragment,t),Bt=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-5zbxqc"&&(N.innerHTML=ie),Ut=i(t),f(V.$$.fragment,t),Qt=i(t),f(H.$$.fragment,t),Zt=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1c7jiea"&&(Y.innerHTML=se),zt=i(t),f(P.$$.fragment,t),It=i(t),f(S.$$.fragment,t),kt=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-h7ytse"&&(D.innerHTML=oe),xt=i(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-120mr43"&&(K.innerHTML=re),Rt=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wlm3ol"&&(O.innerHTML=pe),At=i(t),f(tt.$$.fragment,t),Wt=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1f1bzer"&&(et.innerHTML=me),Et=i(t),f(lt.$$.fragment,t),Gt=i(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-agdyn7"&&(at.textContent=fe),Xt=i(t),nt=o(t,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-83nivc"&&(nt.innerHTML=ue),Ft=i(t),st=o(t,"P",{}),he(st).forEach(l),this.h()},h(){ce(p,"name","hf:doc:metadata"),ce(p,"content",je)},m(t,e){Je(document.head,p),a(t,_,e),a(t,T,e),a(t,b,e),u(y,t,e),a(t,M,e),a(t,w,e),a(t,rt,e),a(t,$,e),a(t,pt,e),a(t,q,e),a(t,mt,e),a(t,j,e),a(t,ft,e),u(v,t,e),a(t,ut,e),a(t,C,e),a(t,dt,e),a(t,L,e),a(t,ht,e),u(B,t,e),a(t,ct,e),a(t,U,e),a(t,Mt,e),u(Q,t,e),a(t,bt,e),a(t,Z,e),a(t,wt,e),u(z,t,e),a(t,Tt,e),a(t,I,e),a(t,yt,e),u(k,t,e),a(t,gt,e),a(t,x,e),a(t,Jt,e),u(R,t,e),a(t,_t,e),a(t,A,e),a(t,$t,e),u(W,t,e),a(t,qt,e),a(t,E,e),a(t,jt,e),u(G,t,e),a(t,vt,e),a(t,X,e),a(t,Ct,e),u(J,t,e),a(t,Lt,e),u(F,t,e),a(t,Bt,e),a(t,N,e),a(t,Ut,e),u(V,t,e),a(t,Qt,e),u(H,t,e),a(t,Zt,e),a(t,Y,e),a(t,zt,e),u(P,t,e),a(t,It,e),u(S,t,e),a(t,kt,e),a(t,D,e),a(t,xt,e),a(t,K,e),a(t,Rt,e),a(t,O,e),a(t,At,e),u(tt,t,e),a(t,Wt,e),a(t,et,e),a(t,Et,e),u(lt,t,e),a(t,Gt,e),a(t,at,e),a(t,Xt,e),a(t,nt,e),a(t,Ft,e),a(t,st,e),Nt=!0},p(t,[e]){const de={};e&2&&(de.$$scope={dirty:e,ctx:t}),J.$set(de)},i(t){Nt||(d(y.$$.fragment,t),d(v.$$.fragment,t),d(B.$$.fragment,t),d(Q.$$.fragment,t),d(z.$$.fragment,t),d(k.$$.fragment,t),d(R.$$.fragment,t),d(W.$$.fragment,t),d(G.$$.fragment,t),d(J.$$.fragment,t),d(F.$$.fragment,t),d(V.$$.fragment,t),d(H.$$.fragment,t),d(P.$$.fragment,t),d(S.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),Nt=!0)},o(t){h(y.$$.fragment,t),h(v.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(z.$$.fragment,t),h(k.$$.fragment,t),h(R.$$.fragment,t),h(W.$$.fragment,t),h(G.$$.fragment,t),h(J.$$.fragment,t),h(F.$$.fragment,t),h(V.$$.fragment,t),h(H.$$.fragment,t),h(P.$$.fragment,t),h(S.$$.fragment,t),h(tt.$$.fragment,t),h(lt.$$.fragment,t),Nt=!1},d(t){t&&(l(_),l(T),l(b),l(M),l(w),l(rt),l($),l(pt),l(q),l(mt),l(j),l(ft),l(ut),l(C),l(dt),l(L),l(ht),l(ct),l(U),l(Mt),l(bt),l(Z),l(wt),l(Tt),l(I),l(yt),l(gt),l(x),l(Jt),l(_t),l(A),l($t),l(qt),l(E),l(jt),l(vt),l(X),l(Ct),l(Lt),l(Bt),l(N),l(Ut),l(Qt),l(Zt),l(Y),l(zt),l(It),l(kt),l(D),l(xt),l(K),l(Rt),l(O),l(At),l(Wt),l(et),l(Et),l(Gt),l(at),l(Xt),l(nt),l(Ft),l(st)),l(p),c(y,t),c(v,t),c(B,t),c(Q,t),c(z,t),c(k,t),c(R,t),c(W,t),c(G,t),c(J,t),c(F,t),c(V,t),c(H,t),c(P,t),c(S,t),c(tt,t),c(lt,t)}}}const je='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ve(ot){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends Te{constructor(p){super(),ye(this,p,ve,qe,Me,{})}}export{Ze as component};
