import{s as ca,o as ua,n as fa}from"../chunks/scheduler.c57aa7ef.js";import{S as Ma,i as wa,g as o,s,r,A as ya,h as i,f as a,c as n,j as da,u as p,x as c,k as ma,y as Ta,a as l,v as d,d as m,t as h,w as f}from"../chunks/index.c50cb18e.js";import{T as ha}from"../chunks/Tip.9268b0ca.js";import{C as w}from"../chunks/CodeBlock.34f0a53d.js";import{H as y}from"../chunks/Heading.c7d7e0e7.js";function Ja(_e){let u,T='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=o("p"),u.innerHTML=T},l(M){u=i(M,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1nbpolx"&&(u.innerHTML=T)},m(M,J){l(M,u,J)},p:fa,d(M){M&&a(u)}}}function ba(_e){let u,T='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=o("p"),u.innerHTML=T},l(M){u=i(M,"P",{"data-svelte-h":!0}),c(u)!=="svelte-19y7vpj"&&(u.innerHTML=T)},m(M,J){l(M,u,J)},p:fa,d(M){M&&a(u)}}}function ga(_e){let u,T,M,J,j,ke,Z,Ct='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ie,U,Lt="This guide explores in more detail other options and features for using LoRA.",ve,_,Re,$,Gt='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Be,k,Xt='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',We,I,Ce,v,Vt="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",Le,R,Ge,B,Xe,W,Qt='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. If you’re using LoftQ, <em>do not</em> quantize the base model. You should set up a <code>LoftQConfig</code> instead:',Ve,C,Qe,b,Ae,L,Fe,G,At='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',qe,X,He,V,ze,Q,Ft='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Ee,A,Ye,F,xe,q,qt='<li>DoRA only supports linear layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Ne,H,Se,z,Ht='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Pe,E,De,Y,Ke,x,zt='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Oe,N,et,S,Et='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',tt,P,Yt=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
(adapter_config.json)[https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json] shows a sample LoRA adapter config applying this method for fine-tuning.`,at,D,lt,K,xt='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',st,O,nt,ee,Nt='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',ot,te,it,ae,St='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',rt,le,Pt="First load the base model:",pt,se,dt,ne,Dt="Then we load the first adapter:",mt,oe,ht,ie,Kt="Then load a different adapter and merge it with the first one:",ft,re,ct,g,ut,pe,Ot="Now, perform inference:",Mt,de,wt,me,yt,he,ea='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Tt,fe,Jt,ce,ta='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',bt,ue,gt,Me,jt,we,aa="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Zt,ye,la="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Ut,Te,_t,Je,sa="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",$t,be,kt,ge,na="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",It,je,vt,Ze,oa="Using this features has some drawbacks, namely:",Rt,Ue,ia='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Bt,$e,Wt;return j=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),_=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),I=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),R=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),B=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),C=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),b=new ha({props:{$$slots:{default:[Ja]},$$scope:{ctx:_e}}}),L=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),X=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),V=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),A=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),F=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),H=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),E=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Y=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),N=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),D=new y({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),O=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),te=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),se=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),oe=new w({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),re=new w({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),g=new ha({props:{$$slots:{default:[ba]},$$scope:{ctx:_e}}}),de=new w({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),me=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),fe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ue=new w({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Me=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Te=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),be=new w({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),je=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),{c(){u=o("meta"),T=s(),M=o("p"),J=s(),r(j.$$.fragment),ke=s(),Z=o("p"),Z.innerHTML=Ct,Ie=s(),U=o("p"),U.textContent=Lt,ve=s(),r(_.$$.fragment),Re=s(),$=o("p"),$.innerHTML=Gt,Be=s(),k=o("p"),k.innerHTML=Xt,We=s(),r(I.$$.fragment),Ce=s(),v=o("p"),v.innerHTML=Vt,Le=s(),r(R.$$.fragment),Ge=s(),r(B.$$.fragment),Xe=s(),W=o("p"),W.innerHTML=Qt,Ve=s(),r(C.$$.fragment),Qe=s(),r(b.$$.fragment),Ae=s(),r(L.$$.fragment),Fe=s(),G=o("p"),G.innerHTML=At,qe=s(),r(X.$$.fragment),He=s(),r(V.$$.fragment),ze=s(),Q=o("p"),Q.innerHTML=Ft,Ee=s(),r(A.$$.fragment),Ye=s(),r(F.$$.fragment),xe=s(),q=o("ul"),q.innerHTML=qt,Ne=s(),r(H.$$.fragment),Se=s(),z=o("p"),z.innerHTML=Ht,Pe=s(),r(E.$$.fragment),De=s(),r(Y.$$.fragment),Ke=s(),x=o("p"),x.innerHTML=zt,Oe=s(),r(N.$$.fragment),et=s(),S=o("p"),S.innerHTML=Et,tt=s(),P=o("p"),P.innerHTML=Yt,at=s(),r(D.$$.fragment),lt=s(),K=o("p"),K.innerHTML=xt,st=s(),r(O.$$.fragment),nt=s(),ee=o("p"),ee.innerHTML=Nt,ot=s(),r(te.$$.fragment),it=s(),ae=o("p"),ae.innerHTML=St,rt=s(),le=o("p"),le.textContent=Pt,pt=s(),r(se.$$.fragment),dt=s(),ne=o("p"),ne.textContent=Dt,mt=s(),r(oe.$$.fragment),ht=s(),ie=o("p"),ie.textContent=Kt,ft=s(),r(re.$$.fragment),ct=s(),r(g.$$.fragment),ut=s(),pe=o("p"),pe.textContent=Ot,Mt=s(),r(de.$$.fragment),wt=s(),r(me.$$.fragment),yt=s(),he=o("p"),he.innerHTML=ea,Tt=s(),r(fe.$$.fragment),Jt=s(),ce=o("p"),ce.innerHTML=ta,bt=s(),r(ue.$$.fragment),gt=s(),r(Me.$$.fragment),jt=s(),we=o("p"),we.textContent=aa,Zt=s(),ye=o("p"),ye.innerHTML=la,Ut=s(),r(Te.$$.fragment),_t=s(),Je=o("p"),Je.innerHTML=sa,$t=s(),r(be.$$.fragment),kt=s(),ge=o("p"),ge.innerHTML=na,It=s(),r(je.$$.fragment),vt=s(),Ze=o("p"),Ze.textContent=oa,Rt=s(),Ue=o("ul"),Ue.innerHTML=ia,Bt=s(),$e=o("p"),this.h()},l(e){const t=ya("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),M=i(e,"P",{}),da(M).forEach(a),J=n(e),p(j.$$.fragment,e),ke=n(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-38uxl6"&&(Z.innerHTML=Ct),Ie=n(e),U=i(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-ovsn32"&&(U.textContent=Lt),ve=n(e),p(_.$$.fragment,e),Re=n(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-j883mf"&&($.innerHTML=Gt),Be=n(e),k=i(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1fujb7a"&&(k.innerHTML=Xt),We=n(e),p(I.$$.fragment,e),Ce=n(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-mwvui1"&&(v.innerHTML=Vt),Le=n(e),p(R.$$.fragment,e),Ge=n(e),p(B.$$.fragment,e),Xe=n(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1khsfzg"&&(W.innerHTML=Qt),Ve=n(e),p(C.$$.fragment,e),Qe=n(e),p(b.$$.fragment,e),Ae=n(e),p(L.$$.fragment,e),Fe=n(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-omuw13"&&(G.innerHTML=At),qe=n(e),p(X.$$.fragment,e),He=n(e),p(V.$$.fragment,e),ze=n(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1ukfkwt"&&(Q.innerHTML=Ft),Ee=n(e),p(A.$$.fragment,e),Ye=n(e),p(F.$$.fragment,e),xe=n(e),q=i(e,"UL",{"data-svelte-h":!0}),c(q)!=="svelte-cmsowz"&&(q.innerHTML=qt),Ne=n(e),p(H.$$.fragment,e),Se=n(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-15vxux2"&&(z.innerHTML=Ht),Pe=n(e),p(E.$$.fragment,e),De=n(e),p(Y.$$.fragment,e),Ke=n(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1mosto0"&&(x.innerHTML=zt),Oe=n(e),p(N.$$.fragment,e),et=n(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1safyei"&&(S.innerHTML=Et),tt=n(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-18i3sjb"&&(P.innerHTML=Yt),at=n(e),p(D.$$.fragment,e),lt=n(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1c3h9aa"&&(K.innerHTML=xt),st=n(e),p(O.$$.fragment,e),nt=n(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-m3cr6r"&&(ee.innerHTML=Nt),ot=n(e),p(te.$$.fragment,e),it=n(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-kbqhpl"&&(ae.innerHTML=St),rt=n(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1mwdwt1"&&(le.textContent=Pt),pt=n(e),p(se.$$.fragment,e),dt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-nuhu05"&&(ne.textContent=Dt),mt=n(e),p(oe.$$.fragment,e),ht=n(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1n53hd9"&&(ie.textContent=Kt),ft=n(e),p(re.$$.fragment,e),ct=n(e),p(g.$$.fragment,e),ut=n(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-qwbdkg"&&(pe.textContent=Ot),Mt=n(e),p(de.$$.fragment,e),wt=n(e),p(me.$$.fragment,e),yt=n(e),he=i(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-ke62q2"&&(he.innerHTML=ea),Tt=n(e),p(fe.$$.fragment,e),Jt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-cvmoj6"&&(ce.innerHTML=ta),bt=n(e),p(ue.$$.fragment,e),gt=n(e),p(Me.$$.fragment,e),jt=n(e),we=i(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1fq5tpu"&&(we.textContent=aa),Zt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-6zt8d6"&&(ye.innerHTML=la),Ut=n(e),p(Te.$$.fragment,e),_t=n(e),Je=i(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-6wkyom"&&(Je.innerHTML=sa),$t=n(e),p(be.$$.fragment,e),kt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1o40ch6"&&(ge.innerHTML=na),It=n(e),p(je.$$.fragment,e),vt=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-fpz5mj"&&(Ze.textContent=oa),Rt=n(e),Ue=i(e,"UL",{"data-svelte-h":!0}),c(Ue)!=="svelte-1jk1r7d"&&(Ue.innerHTML=ia),Bt=n(e),$e=i(e,"P",{}),da($e).forEach(a),this.h()},h(){ma(u,"name","hf:doc:metadata"),ma(u,"content",ja)},m(e,t){Ta(document.head,u),l(e,T,t),l(e,M,t),l(e,J,t),d(j,e,t),l(e,ke,t),l(e,Z,t),l(e,Ie,t),l(e,U,t),l(e,ve,t),d(_,e,t),l(e,Re,t),l(e,$,t),l(e,Be,t),l(e,k,t),l(e,We,t),d(I,e,t),l(e,Ce,t),l(e,v,t),l(e,Le,t),d(R,e,t),l(e,Ge,t),d(B,e,t),l(e,Xe,t),l(e,W,t),l(e,Ve,t),d(C,e,t),l(e,Qe,t),d(b,e,t),l(e,Ae,t),d(L,e,t),l(e,Fe,t),l(e,G,t),l(e,qe,t),d(X,e,t),l(e,He,t),d(V,e,t),l(e,ze,t),l(e,Q,t),l(e,Ee,t),d(A,e,t),l(e,Ye,t),d(F,e,t),l(e,xe,t),l(e,q,t),l(e,Ne,t),d(H,e,t),l(e,Se,t),l(e,z,t),l(e,Pe,t),d(E,e,t),l(e,De,t),d(Y,e,t),l(e,Ke,t),l(e,x,t),l(e,Oe,t),d(N,e,t),l(e,et,t),l(e,S,t),l(e,tt,t),l(e,P,t),l(e,at,t),d(D,e,t),l(e,lt,t),l(e,K,t),l(e,st,t),d(O,e,t),l(e,nt,t),l(e,ee,t),l(e,ot,t),d(te,e,t),l(e,it,t),l(e,ae,t),l(e,rt,t),l(e,le,t),l(e,pt,t),d(se,e,t),l(e,dt,t),l(e,ne,t),l(e,mt,t),d(oe,e,t),l(e,ht,t),l(e,ie,t),l(e,ft,t),d(re,e,t),l(e,ct,t),d(g,e,t),l(e,ut,t),l(e,pe,t),l(e,Mt,t),d(de,e,t),l(e,wt,t),d(me,e,t),l(e,yt,t),l(e,he,t),l(e,Tt,t),d(fe,e,t),l(e,Jt,t),l(e,ce,t),l(e,bt,t),d(ue,e,t),l(e,gt,t),d(Me,e,t),l(e,jt,t),l(e,we,t),l(e,Zt,t),l(e,ye,t),l(e,Ut,t),d(Te,e,t),l(e,_t,t),l(e,Je,t),l(e,$t,t),d(be,e,t),l(e,kt,t),l(e,ge,t),l(e,It,t),d(je,e,t),l(e,vt,t),l(e,Ze,t),l(e,Rt,t),l(e,Ue,t),l(e,Bt,t),l(e,$e,t),Wt=!0},p(e,[t]){const ra={};t&2&&(ra.$$scope={dirty:t,ctx:e}),b.$set(ra);const pa={};t&2&&(pa.$$scope={dirty:t,ctx:e}),g.$set(pa)},i(e){Wt||(m(j.$$.fragment,e),m(_.$$.fragment,e),m(I.$$.fragment,e),m(R.$$.fragment,e),m(B.$$.fragment,e),m(C.$$.fragment,e),m(b.$$.fragment,e),m(L.$$.fragment,e),m(X.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(E.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(g.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),Wt=!0)},o(e){h(j.$$.fragment,e),h(_.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(B.$$.fragment,e),h(C.$$.fragment,e),h(b.$$.fragment,e),h(L.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(g.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),Wt=!1},d(e){e&&(a(T),a(M),a(J),a(ke),a(Z),a(Ie),a(U),a(ve),a(Re),a($),a(Be),a(k),a(We),a(Ce),a(v),a(Le),a(Ge),a(Xe),a(W),a(Ve),a(Qe),a(Ae),a(Fe),a(G),a(qe),a(He),a(ze),a(Q),a(Ee),a(Ye),a(xe),a(q),a(Ne),a(Se),a(z),a(Pe),a(De),a(Ke),a(x),a(Oe),a(et),a(S),a(tt),a(P),a(at),a(lt),a(K),a(st),a(nt),a(ee),a(ot),a(it),a(ae),a(rt),a(le),a(pt),a(dt),a(ne),a(mt),a(ht),a(ie),a(ft),a(ct),a(ut),a(pe),a(Mt),a(wt),a(yt),a(he),a(Tt),a(Jt),a(ce),a(bt),a(gt),a(jt),a(we),a(Zt),a(ye),a(Ut),a(_t),a(Je),a($t),a(kt),a(ge),a(It),a(vt),a(Ze),a(Rt),a(Ue),a(Bt),a($e)),a(u),f(j,e),f(_,e),f(I,e),f(R,e),f(B,e),f(C,e),f(b,e),f(L,e),f(X,e),f(V,e),f(A,e),f(F,e),f(H,e),f(E,e),f(Y,e),f(N,e),f(D,e),f(O,e),f(te,e),f(se,e),f(oe,e),f(re,e),f(g,e),f(de,e),f(me,e),f(fe,e),f(ue,e),f(Me,e),f(Te,e),f(be,e),f(je,e)}}}const ja='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Za(_e){return ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends Ma{constructor(u){super(),wa(this,u,Za,ga,ca,{})}}export{va as component};
