import{s as Al,f as Ll,n as Dl,o as Pl}from"../chunks/scheduler.889ebb13.js";import{S as Kl,i as Ol,g as p,s as a,u as r,A as se,h as i,f as t,c as n,j as u,v as m,y as c,k as o,o as h,a as e,w as g,d as M,t as y,x as j}from"../chunks/index.8980e686.js";import{I as Xs}from"../chunks/IconCopyLink.357761cd.js";import{C as b}from"../chunks/CodeBlock.25fc3430.js";import{D as te}from"../chunks/DocNotebookDropdown.f8a50280.js";function le(sl){let J,Es,Rs,qs,U,C,Qs,N,Lt,ks,tl="제로샷(zero-shot) 객체 탐지",Gs,H,Ys,B,ll=`일반적으로 <a href="object_detection">객체 탐지</a>에 사용되는 모델을 학습하기 위해서는 레이블이 지정된 이미지 데이터 세트가 필요합니다.
그리고 학습 데이터에 존재하는 클래스(레이블)만 탐지할 수 있다는 한계점이 있습니다.`,Ss,X,el=`다른 방식을 사용하는 <a href="../model_doc/owlvit">OWL-ViT</a> 모델로 제로샷 객체 탐지가 가능합니다.
OWL-ViT는 개방형 어휘(open-vocabulary) 객체 탐지기입니다.
즉, 레이블이 지정된 데이터 세트에 미세 조정하지 않고 자유 텍스트 쿼리를 기반으로 이미지에서 객체를 탐지할 수 있습니다.`,Fs,E,al=`OWL-ViT 모델은 멀티 모달 표현을 활용해 개방형 어휘 탐지(open-vocabulary detection)를 수행합니다.
<a href="../model_doc/clip">CLIP</a> 모델에 경량화(lightweight)된 객체 분류와 지역화(localization) 헤드를 결합합니다.
개방형 어휘 탐지는 CLIP의 텍스트 인코더로 free-text 쿼리를 임베딩하고, 객체 분류와 지역화 헤드의 입력으로 사용합니다.
이미지와 해당 텍스트 설명을 연결하면 ViT가 이미지 패치(image patches)를 입력으로 처리합니다.
OWL-ViT 모델의 저자들은 CLIP 모델을 처음부터 학습(scratch learning)한 후에, bipartite matching loss를 사용하여 표준 객체 인식 데이터셋으로 OWL-ViT 모델을 미세 조정했습니다.`,As,q,nl="이 접근 방식을 사용하면 모델은 레이블이 지정된 데이터 세트에 대한 사전 학습 없이도 텍스트 설명을 기반으로 객체를 탐지할 수 있습니다.",Ls,G,pl="이번 가이드에서는 OWL-ViT 모델의 사용법을 다룰 것입니다:",Ds,Y,il="<li>텍스트 프롬프트 기반 객체 탐지</li> <li>일괄 객체 탐지</li> <li>이미지 가이드 객체 탐지</li>",Ps,S,cl="시작하기 전에 필요한 라이브러리가 모두 설치되어 있는지 확인하세요:",Ks,F,Os,x,v,Zs,A,Dt,Is,ol="제로샷(zero-shot) 객체 탐지 파이프라인",st,L,rl=`<code>pipeline()</code>을 활용하면 가장 간단하게 OWL-ViT 모델을 추론해볼 수 있습니다.
<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 제로샷(zero-shot) 객체 탐지용 파이프라인을 인스턴스화합니다:`,tt,D,lt,P,ml=`다음으로, 객체를 탐지하고 싶은 이미지를 선택하세요.
여기서는 <a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images 데이터 세트의 일부인 우주비행사 에일린 콜린스(Eileen Collins) 사진을 사용하겠습니다.`,et,K,at,W,hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',nt,O,gl=`이미지와 해당 이미지의 후보 레이블을 파이프라인으로 전달합니다.
여기서는 이미지를 직접 전달하지만, 컴퓨터에 저장된 이미지의 경로나 url로 전달할 수도 있습니다.
candidate_labels는 이 예시처럼 간단한 단어일 수도 있고 좀 더 설명적인 단어일 수도 있습니다.
또한, 이미지를 검색(query)하려는 모든 항목에 대한 텍스트 설명도 전달합니다.`,pt,ss,it,ts,Ml="이제 예측값을 시각화해봅시다:",ct,ls,ot,k,yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',rt,w,I,Vs,es,Pt,_s,jl="텍스트 프롬프트 기반 객체 탐지",mt,as,ul="제로샷 객체 탐지 파이프라인 사용법에 대해 살펴보았으니, 이제 동일한 결과를 복제해보겠습니다.",ht,ns,bl=`<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 관련 모델과 프로세서를 가져오는 것으로 시작합니다.
여기서는 이전과 동일한 체크포인트를 사용하겠습니다:`,gt,ps,Mt,is,dl="다른 이미지를 사용해 보겠습니다:",yt,cs,jt,_,Jl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',ut,os,Ul=`프로세서를 사용해 모델의 입력을 준비합니다.
프로세서는 모델의 입력으로 사용하기 위해 이미지 크기를 변환하고 정규화하는 이미지 프로세서와 텍스트 입력을 처리하는 <code>CLIPTokenizer</code>로 구성됩니다.`,bt,rs,dt,ms,xl=`모델에 입력을 전달하고 결과를 후처리 및 시각화합니다.
이미지 프로세서가 모델에 이미지를 입력하기 전에 이미지 크기를 조정했기 때문에, <code>post_process_object_detection()</code> 메소드를 사용해
예측값의 바운딩 박스(bounding box)가 원본 이미지의 좌표와 상대적으로 동일한지 확인해야 합니다.`,Jt,hs,Ut,$,wl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',xt,T,z,Ns,gs,Kt,$s,Tl="일괄 처리",wt,Ms,fl=`여러 이미지와 텍스트 쿼리를 전달하여 여러 이미지에서 서로 다른(또는 동일한) 객체를 검색할 수 있습니다.
일괄 처리를 위해서 텍스트 쿼리는 이중 리스트로, 이미지는 PIL 이미지, PyTorch 텐서, 또는 NumPy 배열로 이루어진 리스트로 프로세서에 전달해야 합니다.`,Tt,ys,ft,js,Cl=`이전에는 후처리를 위해 단일 이미지의 크기를 텐서로 전달했지만, 튜플을 전달할 수 있고, 여러 이미지를 처리하는 경우에는 튜플로 이루어진 리스트를 전달할 수도 있습니다.
아래 두 예제에 대한 예측을 생성하고, 두 번째 이미지(<code>image_idx = 1</code>)를 시각화해 보겠습니다.`,Ct,us,vt,R,vl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',Wt,f,Q,Hs,bs,Ot,zs,Wl="이미지 가이드 객체 탐지",kt,ds,kl=`텍스트 쿼리를 이용한 제로샷 객체 탐지 외에도 OWL-ViT 모델은 이미지 가이드 객체 탐지 기능을 제공합니다.
이미지를 쿼리로 사용해 대상 이미지에서 유사한 객체를 찾을 수 있다는 의미입니다.
텍스트 쿼리와 달리 하나의 예제 이미지에서만 가능합니다.`,It,Js,Il="소파에 고양이 두 마리가 있는 이미지를 대상 이미지(target image)로, 고양이 한 마리가 있는 이미지를 쿼리로 사용해보겠습니다:",_t,Us,$t,xs,_l="다음 이미지를 살펴보겠습니다:",zt,ws,Rt,Z,$l='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',Qt,Ts,zl="전처리 단계에서 텍스트 쿼리 대신에 <code>query_images</code>를 사용합니다:",Zt,fs,Vt,Cs,Rl=`예측의 경우, 모델에 입력을 전달하는 대신 <code>image_guided_detection()</code>에 전달합니다.
레이블이 없다는 점을 제외하면 이전과 동일합니다.
이전과 동일하게 이미지를 시각화합니다.`,Nt,vs,Ht,V,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',Bt,Ws,Zl="OWL-ViT 모델을 추론하고 싶다면 아래 데모를 확인하세요:",Xt,d,Vl,Et,Bs,qt;return N=new Xs({}),H=new te({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_object_detection.ipynb"}]}}),F=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers"}}),A=new Xs({}),D=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`}}),K=new b({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),ss=new b({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`}}),ls=new b({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),es=new Xs({}),ps=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`}}),cs=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`}}),rs=new b({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`}}),hs=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`}}),gs=new Xs({}),ys=new b({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`}}),us=new b({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`}}),bs=new Xs({}),Us=new b({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`}}),ws=new b({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`}}),fs=new b({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),vs=new b({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`}}),{c(){J=p("meta"),Es=a(),Rs=p("p"),qs=a(),U=p("h1"),C=p("a"),Qs=p("span"),r(N.$$.fragment),Lt=a(),ks=p("span"),ks.textContent=tl,Gs=a(),r(H.$$.fragment),Ys=a(),B=p("p"),B.innerHTML=ll,Ss=a(),X=p("p"),X.innerHTML=el,Fs=a(),E=p("p"),E.innerHTML=al,As=a(),q=p("p"),q.textContent=nl,Ls=a(),G=p("p"),G.textContent=pl,Ds=a(),Y=p("ul"),Y.innerHTML=il,Ps=a(),S=p("p"),S.textContent=cl,Ks=a(),r(F.$$.fragment),Os=a(),x=p("h2"),v=p("a"),Zs=p("span"),r(A.$$.fragment),Dt=a(),Is=p("span"),Is.textContent=ol,st=a(),L=p("p"),L.innerHTML=rl,tt=a(),r(D.$$.fragment),lt=a(),P=p("p"),P.innerHTML=ml,et=a(),r(K.$$.fragment),at=a(),W=p("div"),W.innerHTML=hl,nt=a(),O=p("p"),O.textContent=gl,pt=a(),r(ss.$$.fragment),it=a(),ts=p("p"),ts.textContent=Ml,ct=a(),r(ls.$$.fragment),ot=a(),k=p("div"),k.innerHTML=yl,rt=a(),w=p("h2"),I=p("a"),Vs=p("span"),r(es.$$.fragment),Pt=a(),_s=p("span"),_s.textContent=jl,mt=a(),as=p("p"),as.textContent=ul,ht=a(),ns=p("p"),ns.innerHTML=bl,gt=a(),r(ps.$$.fragment),Mt=a(),is=p("p"),is.textContent=dl,yt=a(),r(cs.$$.fragment),jt=a(),_=p("div"),_.innerHTML=Jl,ut=a(),os=p("p"),os.innerHTML=Ul,bt=a(),r(rs.$$.fragment),dt=a(),ms=p("p"),ms.innerHTML=xl,Jt=a(),r(hs.$$.fragment),Ut=a(),$=p("div"),$.innerHTML=wl,xt=a(),T=p("h2"),z=p("a"),Ns=p("span"),r(gs.$$.fragment),Kt=a(),$s=p("span"),$s.textContent=Tl,wt=a(),Ms=p("p"),Ms.textContent=fl,Tt=a(),r(ys.$$.fragment),ft=a(),js=p("p"),js.innerHTML=Cl,Ct=a(),r(us.$$.fragment),vt=a(),R=p("div"),R.innerHTML=vl,Wt=a(),f=p("h2"),Q=p("a"),Hs=p("span"),r(bs.$$.fragment),Ot=a(),zs=p("span"),zs.textContent=Wl,kt=a(),ds=p("p"),ds.textContent=kl,It=a(),Js=p("p"),Js.textContent=Il,_t=a(),r(Us.$$.fragment),$t=a(),xs=p("p"),xs.textContent=_l,zt=a(),r(ws.$$.fragment),Rt=a(),Z=p("div"),Z.innerHTML=$l,Qt=a(),Ts=p("p"),Ts.innerHTML=zl,Zt=a(),r(fs.$$.fragment),Vt=a(),Cs=p("p"),Cs.innerHTML=Rl,Nt=a(),r(vs.$$.fragment),Ht=a(),V=p("div"),V.innerHTML=Ql,Bt=a(),Ws=p("p"),Ws.textContent=Zl,Xt=a(),d=p("iframe"),Et=a(),Bs=p("p"),this.h()},l(s){const l=se("svelte-1phssyn",document.head);J=i(l,"META",{name:!0,content:!0}),l.forEach(t),Es=n(s),Rs=i(s,"P",{}),u(Rs).forEach(t),qs=n(s),U=i(s,"H1",{class:!0});var Gt=u(U);C=i(Gt,"A",{id:!0,class:!0,href:!0});var Nl=u(C);Qs=i(Nl,"SPAN",{});var Hl=u(Qs);m(N.$$.fragment,Hl),Hl.forEach(t),Nl.forEach(t),Lt=n(Gt),ks=i(Gt,"SPAN",{"data-svelte-h":!0}),c(ks)!=="svelte-a1vdrd"&&(ks.textContent=tl),Gt.forEach(t),Gs=n(s),m(H.$$.fragment,s),Ys=n(s),B=i(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-6eje4v"&&(B.innerHTML=ll),Ss=n(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-17o36b3"&&(X.innerHTML=el),Fs=n(s),E=i(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1148tws"&&(E.innerHTML=al),As=n(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1au2n2f"&&(q.textContent=nl),Ls=n(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-114e4n4"&&(G.textContent=pl),Ds=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-m6pgk5"&&(Y.innerHTML=il),Ps=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1k0z9pm"&&(S.textContent=cl),Ks=n(s),m(F.$$.fragment,s),Os=n(s),x=i(s,"H2",{class:!0});var Yt=u(x);v=i(Yt,"A",{id:!0,class:!0,href:!0});var Bl=u(v);Zs=i(Bl,"SPAN",{});var Xl=u(Zs);m(A.$$.fragment,Xl),Xl.forEach(t),Bl.forEach(t),Dt=n(Yt),Is=i(Yt,"SPAN",{"data-svelte-h":!0}),c(Is)!=="svelte-4x43o1"&&(Is.textContent=ol),Yt.forEach(t),st=n(s),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1nqv12v"&&(L.innerHTML=rl),tt=n(s),m(D.$$.fragment,s),lt=n(s),P=i(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1p9c2je"&&(P.innerHTML=ml),et=n(s),m(K.$$.fragment,s),at=n(s),W=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(W)!=="svelte-17qmfee"&&(W.innerHTML=hl),nt=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1argm47"&&(O.textContent=gl),pt=n(s),m(ss.$$.fragment,s),it=n(s),ts=i(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-1uqzhy9"&&(ts.textContent=Ml),ct=n(s),m(ls.$$.fragment,s),ot=n(s),k=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(k)!=="svelte-1fwpqdn"&&(k.innerHTML=yl),rt=n(s),w=i(s,"H2",{class:!0});var St=u(w);I=i(St,"A",{id:!0,class:!0,href:!0});var El=u(I);Vs=i(El,"SPAN",{});var ql=u(Vs);m(es.$$.fragment,ql),ql.forEach(t),El.forEach(t),Pt=n(St),_s=i(St,"SPAN",{"data-svelte-h":!0}),c(_s)!=="svelte-1c7f153"&&(_s.textContent=jl),St.forEach(t),mt=n(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1ipgrv9"&&(as.textContent=ul),ht=n(s),ns=i(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-qzn480"&&(ns.innerHTML=bl),gt=n(s),m(ps.$$.fragment,s),Mt=n(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-1ist5bc"&&(is.textContent=dl),yt=n(s),m(cs.$$.fragment,s),jt=n(s),_=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-owux8y"&&(_.innerHTML=Jl),ut=n(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-18gx5db"&&(os.innerHTML=Ul),bt=n(s),m(rs.$$.fragment,s),dt=n(s),ms=i(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-5kpzn3"&&(ms.innerHTML=xl),Jt=n(s),m(hs.$$.fragment,s),Ut=n(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c($)!=="svelte-1m863ar"&&($.innerHTML=wl),xt=n(s),T=i(s,"H2",{class:!0});var Ft=u(T);z=i(Ft,"A",{id:!0,class:!0,href:!0});var Gl=u(z);Ns=i(Gl,"SPAN",{});var Yl=u(Ns);m(gs.$$.fragment,Yl),Yl.forEach(t),Gl.forEach(t),Kt=n(Ft),$s=i(Ft,"SPAN",{"data-svelte-h":!0}),c($s)!=="svelte-g4pynz"&&($s.textContent=Tl),Ft.forEach(t),wt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-xr561s"&&(Ms.textContent=fl),Tt=n(s),m(ys.$$.fragment,s),ft=n(s),js=i(s,"P",{"data-svelte-h":!0}),c(js)!=="svelte-1e7zpei"&&(js.innerHTML=Cl),Ct=n(s),m(us.$$.fragment,s),vt=n(s),R=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(R)!=="svelte-1m863ar"&&(R.innerHTML=vl),Wt=n(s),f=i(s,"H2",{class:!0});var At=u(f);Q=i(At,"A",{id:!0,class:!0,href:!0});var Sl=u(Q);Hs=i(Sl,"SPAN",{});var Fl=u(Hs);m(bs.$$.fragment,Fl),Fl.forEach(t),Sl.forEach(t),Ot=n(At),zs=i(At,"SPAN",{"data-svelte-h":!0}),c(zs)!=="svelte-e0qh90"&&(zs.textContent=Wl),At.forEach(t),kt=n(s),ds=i(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1oyzclh"&&(ds.textContent=kl),It=n(s),Js=i(s,"P",{"data-svelte-h":!0}),c(Js)!=="svelte-3m9urc"&&(Js.textContent=Il),_t=n(s),m(Us.$$.fragment,s),$t=n(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-17azu4t"&&(xs.textContent=_l),zt=n(s),m(ws.$$.fragment,s),Rt=n(s),Z=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(Z)!=="svelte-y78yu"&&(Z.innerHTML=$l),Qt=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),c(Ts)!=="svelte-1lh7bnx"&&(Ts.innerHTML=zl),Zt=n(s),m(fs.$$.fragment,s),Vt=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-c93o6k"&&(Cs.innerHTML=Rl),Nt=n(s),m(vs.$$.fragment,s),Ht=n(s),V=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(V)!=="svelte-1f4dev0"&&(V.innerHTML=Ql),Bt=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),c(Ws)!=="svelte-16bo4q7"&&(Ws.textContent=Zl),Xt=n(s),d=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),u(d).forEach(t),Et=n(s),Bs=i(s,"P",{}),u(Bs).forEach(t),this.h()},h(){o(J,"name","hf:doc:metadata"),o(J,"content",JSON.stringify(ee)),o(C,"id","zeroshot-object-detection"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#zeroshot-object-detection"),o(U,"class","relative group"),o(v,"id","zeroshot-object-detection-pipeline"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#zeroshot-object-detection-pipeline"),o(x,"class","relative group"),o(W,"class","flex justify-center"),o(k,"class","flex justify-center"),o(I,"id","textprompted-zeroshot-object-detection-by-hand"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#textprompted-zeroshot-object-detection-by-hand"),o(w,"class","relative group"),o(_,"class","flex justify-center"),o($,"class","flex justify-center"),o(z,"id","batch-processing"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#batch-processing"),o(T,"class","relative group"),o(R,"class","flex justify-center"),o(Q,"id","imageguided-object-detection"),o(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Q,"href","#imageguided-object-detection"),o(f,"class","relative group"),o(Z,"class","flex justify-center"),o(V,"class","flex justify-center"),Ll(d.src,Vl="https://adirik-owl-vit.hf.space")||o(d,"src",Vl),o(d,"frameborder","0"),o(d,"width","850"),o(d,"height","450")},m(s,l){h(document.head,J),e(s,Es,l),e(s,Rs,l),e(s,qs,l),e(s,U,l),h(U,C),h(C,Qs),g(N,Qs,null),h(U,Lt),h(U,ks),e(s,Gs,l),g(H,s,l),e(s,Ys,l),e(s,B,l),e(s,Ss,l),e(s,X,l),e(s,Fs,l),e(s,E,l),e(s,As,l),e(s,q,l),e(s,Ls,l),e(s,G,l),e(s,Ds,l),e(s,Y,l),e(s,Ps,l),e(s,S,l),e(s,Ks,l),g(F,s,l),e(s,Os,l),e(s,x,l),h(x,v),h(v,Zs),g(A,Zs,null),h(x,Dt),h(x,Is),e(s,st,l),e(s,L,l),e(s,tt,l),g(D,s,l),e(s,lt,l),e(s,P,l),e(s,et,l),g(K,s,l),e(s,at,l),e(s,W,l),e(s,nt,l),e(s,O,l),e(s,pt,l),g(ss,s,l),e(s,it,l),e(s,ts,l),e(s,ct,l),g(ls,s,l),e(s,ot,l),e(s,k,l),e(s,rt,l),e(s,w,l),h(w,I),h(I,Vs),g(es,Vs,null),h(w,Pt),h(w,_s),e(s,mt,l),e(s,as,l),e(s,ht,l),e(s,ns,l),e(s,gt,l),g(ps,s,l),e(s,Mt,l),e(s,is,l),e(s,yt,l),g(cs,s,l),e(s,jt,l),e(s,_,l),e(s,ut,l),e(s,os,l),e(s,bt,l),g(rs,s,l),e(s,dt,l),e(s,ms,l),e(s,Jt,l),g(hs,s,l),e(s,Ut,l),e(s,$,l),e(s,xt,l),e(s,T,l),h(T,z),h(z,Ns),g(gs,Ns,null),h(T,Kt),h(T,$s),e(s,wt,l),e(s,Ms,l),e(s,Tt,l),g(ys,s,l),e(s,ft,l),e(s,js,l),e(s,Ct,l),g(us,s,l),e(s,vt,l),e(s,R,l),e(s,Wt,l),e(s,f,l),h(f,Q),h(Q,Hs),g(bs,Hs,null),h(f,Ot),h(f,zs),e(s,kt,l),e(s,ds,l),e(s,It,l),e(s,Js,l),e(s,_t,l),g(Us,s,l),e(s,$t,l),e(s,xs,l),e(s,zt,l),g(ws,s,l),e(s,Rt,l),e(s,Z,l),e(s,Qt,l),e(s,Ts,l),e(s,Zt,l),g(fs,s,l),e(s,Vt,l),e(s,Cs,l),e(s,Nt,l),g(vs,s,l),e(s,Ht,l),e(s,V,l),e(s,Bt,l),e(s,Ws,l),e(s,Xt,l),e(s,d,l),e(s,Et,l),e(s,Bs,l),qt=!0},p:Dl,i(s){qt||(M(N.$$.fragment,s),M(H.$$.fragment,s),M(F.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(es.$$.fragment,s),M(ps.$$.fragment,s),M(cs.$$.fragment,s),M(rs.$$.fragment,s),M(hs.$$.fragment,s),M(gs.$$.fragment,s),M(ys.$$.fragment,s),M(us.$$.fragment,s),M(bs.$$.fragment,s),M(Us.$$.fragment,s),M(ws.$$.fragment,s),M(fs.$$.fragment,s),M(vs.$$.fragment,s),qt=!0)},o(s){y(N.$$.fragment,s),y(H.$$.fragment,s),y(F.$$.fragment,s),y(A.$$.fragment,s),y(D.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),y(ls.$$.fragment,s),y(es.$$.fragment,s),y(ps.$$.fragment,s),y(cs.$$.fragment,s),y(rs.$$.fragment,s),y(hs.$$.fragment,s),y(gs.$$.fragment,s),y(ys.$$.fragment,s),y(us.$$.fragment,s),y(bs.$$.fragment,s),y(Us.$$.fragment,s),y(ws.$$.fragment,s),y(fs.$$.fragment,s),y(vs.$$.fragment,s),qt=!1},d(s){s&&(t(Es),t(Rs),t(qs),t(U),t(Gs),t(Ys),t(B),t(Ss),t(X),t(Fs),t(E),t(As),t(q),t(Ls),t(G),t(Ds),t(Y),t(Ps),t(S),t(Ks),t(Os),t(x),t(st),t(L),t(tt),t(lt),t(P),t(et),t(at),t(W),t(nt),t(O),t(pt),t(it),t(ts),t(ct),t(ot),t(k),t(rt),t(w),t(mt),t(as),t(ht),t(ns),t(gt),t(Mt),t(is),t(yt),t(jt),t(_),t(ut),t(os),t(bt),t(dt),t(ms),t(Jt),t(Ut),t($),t(xt),t(T),t(wt),t(Ms),t(Tt),t(ft),t(js),t(Ct),t(vt),t(R),t(Wt),t(f),t(kt),t(ds),t(It),t(Js),t(_t),t($t),t(xs),t(zt),t(Rt),t(Z),t(Qt),t(Ts),t(Zt),t(Vt),t(Cs),t(Nt),t(Ht),t(V),t(Bt),t(Ws),t(Xt),t(d),t(Et),t(Bs)),t(J),j(N),j(H,s),j(F,s),j(A),j(D,s),j(K,s),j(ss,s),j(ls,s),j(es),j(ps,s),j(cs,s),j(rs,s),j(hs,s),j(gs),j(ys,s),j(us,s),j(bs),j(Us,s),j(ws,s),j(fs,s),j(vs,s)}}}const ee={local:"zeroshot-object-detection",sections:[{local:"zeroshot-object-detection-pipeline",title:"제로샷(zero-shot) 객체 탐지 파이프라인"},{local:"textprompted-zeroshot-object-detection-by-hand",title:"텍스트 프롬프트 기반 객체 탐지"},{local:"batch-processing",title:"일괄 처리"},{local:"imageguided-object-detection",title:"이미지 가이드 객체 탐지"}],title:"제로샷(zero-shot) 객체 탐지"};function ae(sl){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class re extends Kl{constructor(J){super(),Ol(this,J,ae,le,Al,{})}}export{re as component};
