import{s as hs,o as ms,n as P}from"../chunks/scheduler.25b97de1.js";import{S as ps,i as us,g as l,s,r as u,A as fs,h as d,f as o,c as a,j as J,u as f,x as c,k as W,l as cs,y as p,a as n,v as g,d as _,t as b,w as M}from"../chunks/index.d9030fc9.js";import{T as jt}from"../chunks/Tip.baa67368.js";import{D as N}from"../chunks/Docstring.ffac8efa.js";import{C as $t}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Gt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as R,E as gs}from"../chunks/EditOnGithub.91d95064.js";function _s(T){let i,v='It is designed for intermediate use. We strongly recommend using the original <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">implementation</a> to infer the model in real-time streaming.';return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1l3jd0r"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:P,d(m){m&&o(i)}}}function bs(T){let i,v="The original model is synchronized text with audio by padding the text in between each token enunciation.",m,h,y="To follow the example of the following image, <code>&quot;Hello, I&#39;m Moshi&quot;</code> could be transformed to <code>&quot;Hello,&lt;pad&gt;&lt;unk&gt;I&#39;m Moshi&quot;</code>.";return{c(){i=l("p"),i.textContent=v,m=s(),h=l("p"),h.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1se1hi6"&&(i.textContent=v),m=a(r),h=d(r,"P",{"data-svelte-h":!0}),c(h)!=="svelte-nhkay6"&&(h.innerHTML=y)},m(r,w){n(r,i,w),n(r,m,w),n(r,h,w)},p:P,d(r){r&&(o(i),o(m),o(h))}}}function Ms(T){let i,v="Example:",m,h,y;return h=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaUNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb3NoaUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBrbWhmJTJGaGYtbW9zaGlrbyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBbW9zaGlfY29uZmlnJTIwJTNEJTIwTW9zaGlDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyJTJDJTIwY29uZmlnJTNEbW9zaGlfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiConfig,
<span class="hljs-meta">... </span>    MoshiForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiForConditionalGeneration (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_config = MoshiConfig.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>, config=moshi_config)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,w){n(r,i,w),n(r,m,w),g(h,r,w),y=!0},p:P,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function ys(T){let i,v="Example:",m,h,y;return h=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaURlcHRoQ29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwTW9zaGlEZXB0aERlY29kZXIlMkMlMEEpJTBBJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME1vc2hpRGVwdGhDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNb3NoaURlcHRoRGVjb2RlciUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwa21oZiUyRmhmLW1vc2hpa28lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1vc2hpRGVwdGhEZWNvZGVyKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiDepthConfig,
<span class="hljs-meta">... </span>    MoshiDepthDecoder,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiDepthConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiDepthDecoder (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiDepthDecoder(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,w){n(r,i,w),n(r,m,w),g(h,r,w),y=!0},p:P,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function vs(T){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:P,d(m){m&&o(i)}}}function ws(T){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:P,d(m){m&&o(i)}}}function Ts(T){let i,v="Example:",m,h,y;return h=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb3NoaUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwZmF2b3JpdGUlMjBjb25kaW1lbnQlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MoshiForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForCausalLM.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,w){n(r,i,w),n(r,m,w),g(h,r,w),y=!0},p:P,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function ks(T){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:P,d(m){m&&o(i)}}}function xs(T){let i,v="Examples:",m,h,y;return h=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEFpbnB1dHMlMjAlM0QlMjBtb3NoaS5nZXRfdW5jb25kaXRpb25hbF9pbnB1dHMoKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTJDJTIwc2VxX2xlbiUyQyUyMHRleHRfdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = moshi.get_unconditional_inputs()

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, ).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz, seq_len, text_vocab_size)</span>
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">32000</span>])`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-kvfsh7"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,w){n(r,i,w),n(r,m,w),g(h,r,w),y=!0},p:P,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Cs(T){let i,v="Example:",m,h,y;return h=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIya21oZiUyRmhmLW1vc2hpa28tcHl0b3JjaC1iZjE2JTIyKSUwQSUwQSUyMyUyMGdldCUyMHRoZSUyMHVuY29uZGl0aW9uYWwlMjAob3IlMjAnbnVsbCcpJTIwaW5wdXRzJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko-pytorch-bf16&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,w){n(r,i,w),n(r,m,w),g(h,r,w),y=!0},p:P,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function $s(T){let i,v,m,h,y,r,w,Ft,ie,hn='The Moshi model was proposed in <a href="https://kyutai.org/Moshi.pdf" rel="nofollow">Moshi: a speech-text foundation model for real-time dialogue</a> by Alexandre Défossez, Laurent Mazaré, Manu Orsini, Amélie Royer, Patrick Pérez, Hervé Jégou, Edouard Grave and Neil Zeghidour.',Jt,re,mn="Moshi is a speech-text foundation model that casts spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. Moshi also predicts time-aligned text tokens as a prefix to audio tokens. This “Inner Monologue” method significantly improves the linguistic quality of generated speech and provides streaming speech recognition and text-to-speech. As a result, Moshi is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice.",Wt,D,pn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_architecture.png"/>',Lt,le,un="The abstract from the paper is the following:",Zt,de,fn="<em>We introduce Moshi, a speech-text foundation model and full-duplex spoken dialogue framework. Current systems for spoken dialogue rely on pipelines of independent components, namely voice activity detection, speech recognition, textual dialogue and text-to-speech. Such frameworks cannot emulate the experience of real conversations. First, their complexity induces a latency of several seconds between interactions. Second, text being the intermediate modality for dialogue, non-linguistic information that modifies meaning— such as emotion or non-speech sounds— is lost in the interaction. Finally, they rely on a segmentation into speaker turns, which does not take into account overlapping speech, interruptions and interjections. Moshi solves these independent issues altogether by casting spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. We moreover extend the hierarchical semantic-to-acoustic token generation of previous work to first predict time-aligned text tokens as a prefix to audio tokens. Not only this “Inner Monologue” method significantly improves the linguistic quality of generated speech, but we also illustrate how it can provide streaming speech recognition and text-to-speech. Our resulting model is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice, and is available at github.com/kyutai-labs/moshi.</em>",Ut,ce,gn="Moshi deals with 3 streams of information:",It,he,_n="<li>The user’s audio</li> <li>Moshi’s audio</li> <li>Moshi’s textual output</li>",Ht,me,bn=`Similarly to <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>, audio is represented with audio codebooks, which can be interpreted like tokens. The main difference between text tokens and audio codebooks is that audio codebooks introduce an additional dimension of information.
Text tokens are typically of dim <code>(batch_size, sequence_length)</code> but audio tokens are of dim <code>(batch_size, num_codebooks, sequence_length)</code>.`,qt,pe,Mn="Moshi’s made of 3 components:",Nt,ue,yn="<strong>1. The main decoder (Helium in the paper)</strong>",Bt,fe,vn='It corresponds to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a>. It is strictly a classic text LLM, that uses an architecture similar to <code>~GemmaForCausalLM</code>. In other words, it takes text tokens, embeds them, pass them through the decoder and a language head, to get text logits.',Vt,ge,wn="<strong>2. The depth decoder</strong>",Rt,_e,Tn="On its own, it’s also a classic LLM, but this time, instead of generating over the time dimension, it generates over the codebook dimension.",Pt,be,kn="It also means that its context length is <code>num_codebooks</code>, thus it can’t generate more than <code>num_codebooks</code>.",Xt,Me,xn="Note that each timestamp - i.e each codebook - gets its own set of Linear Layers and Embeddings.",Dt,ye,Cn='<strong>3. <a href="/docs/transformers/main/en/model_doc/mimi#transformers.MimiModel">MimiModel</a></strong>',St,ve,$n='It’s the audio encoder from Kyutai, that has recently been integrated to transformers, which is used to “tokenize” audio. It has the same use that <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">~EncodecModel</a> has in <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>.',Et,we,Yt,Te,zn="The original checkpoints can be converted using the conversion script <code>src/transformers/models/moshi/convert_moshi_transformers.py</code>",At,ke,Qt,xe,jn="This implementation has two main aims:",Ot,Ce,Gn="<li>quickly test model generation by simplifying the original API</li> <li>simplify training. A training guide will come soon, but user contributions are welcomed!</li>",Kt,S,eo,$e,Fn="<strong>1. Model generation</strong>",to,ze,Jn="Moshi is a streaming auto-regressive model with two streams of audio. To put it differently, one audio stream corresponds to what the model said/will say and the other audio stream corresponds to what the user said/will say.",oo,je,Wn='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> thus needs 3 inputs:',no,Ge,Ln="<li><code>input_ids</code> - corresponding to the text token history</li> <li><code>moshi_input_values</code> or <code>moshi_audio_codes</code>- corresponding to the model audio history</li> <li><code>user_input_values</code> or <code>user_audio_codes</code> - corresponding to the user audio history</li>",so,Fe,Zn="These three inputs must be synchronized. Meaning that their lengths must correspond to the same number of tokens.",ao,Je,Un="You can dynamically use the 3 inputs depending on what you want to test:",io,We,In="<li>Simply check the model response to an user prompt - in that case, <code>input_ids</code> can be filled with pad tokens and <code>user_input_values</code> can be a zero tensor of the same shape than the user prompt.</li> <li>Test more complex behaviour - in that case, you must be careful about how the input tokens are synchronized with the audios.</li>",ro,E,lo,Y,Hn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_text_sync.png"/>',co,Le,qn='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> then auto-regressively feeds to itself its own audio stream, but since it doesn’t have access to the user input stream while using <code>transformers</code>, it will thus <strong>assume that the user is producing blank audio</strong>.',ho,Ze,mo,Ue,Nn="<strong>2. Model training</strong>",po,Ie,Bn="Most of the work has to be done during data creation/pre-processing, because of the need to align/synchronize streams.",uo,He,Vn='Once it’s done, you can simply forward <code>text_labels</code> and <code>audio_labels</code> to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.forward">MoshiForConditionalGeneration.forward()</a>, alongside the usual inputs, to get the model loss.',fo,qe,Rn="A training guide will come soon, but user contributions are welcomed!",go,Ne,_o,Be,Pn="<li><p>The input streams are embedded and combined into <code>inputs_embeds</code>.</p></li> <li><p><code>inputs_embeds</code> is passed through the main decoder, which processes it like a normal LLM would.</p></li> <li><p>The main decoder outputs <code>text logits</code> but also its <code>last hidden state</code> which is called <code>temporal context</code> in the paper.</p></li> <li><p>The depth decoder switches the dimension on which we forward / generate (codebooks instead of time). It uses the token generated from <code>text logits</code>  and the <code>temporal context</code> to auto-regressively generate audio codebooks.</p></li>",bo,Ve,Xn='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">Yoach Lacombe (ylacombe)</a>.',Mo,Re,Dn='The original code can be found <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">here</a>.',yo,Pe,vo,x,Xe,Wo,dt,Sn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a>. It is used to instantiate a
Moshi model according to the specified arguments, defining the audio encoder, Moshi depth decoder and Moshi decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Moshiko model,
e.g. <a href="https://huggingface.co/kmhf/hf-moshiko" rel="nofollow">kmhf/hf-moshiko</a>`,Lo,ct,En=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zo,A,Uo,Q,De,Io,ht,Yn='Instantiate a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a> (or a derived class) from an audio encoder configuration.',wo,Se,To,z,Ee,Ho,mt,An=`This is the configuration class to store the configuration of a <code>MoshiDepthDecoder</code>. It is used to instantiate a
Moshi depth decoder model according to the specified arguments, defining the Moshi depth decoder config.`,qo,pt,Qn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,No,O,ko,Ye,xo,C,Ae,Bo,ut,On=`The bare Moshi Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vo,ft,Kn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ro,gt,es="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>MoshiDecoderLayer</code>",Po,B,Qe,Xo,_t,ts='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a> forward method, overrides the <code>__call__</code> special method.',Do,K,Co,Oe,$o,j,Ke,So,bt,os=`The Moshi decoder model with a text language modelling head on top. Only usable for text.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Eo,Mt,ns=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Yo,L,et,Ao,yt,ss='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Qo,ee,Oo,te,zo,tt,jo,k,ot,Ko,vt,as=`The original Moshi model with an audio encoder, a Moshi depth decoder and a Moshi decoder, for speech-to-speech.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,en,wt,is=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tn,Z,nt,on,Tt,rs='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration">MoshiForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',nn,oe,sn,ne,an,se,st,rn,kt,ls="Generates sequences of text token ids and audio tokens ids.",ln,V,at,dn,xt,ds=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,cn,ae,Go,it,Fo,zt,Jo;return y=new R({props:{title:"Moshi",local:"moshi",headingTag:"h1"}}),w=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new R({props:{title:"Tips:",local:"tips",headingTag:"h2"}}),ke=new R({props:{title:"How to use the model:",local:"how-to-use-the-model",headingTag:"h3"}}),S=new jt({props:{$$slots:{default:[_s]},$$scope:{ctx:T}}}),E=new jt({props:{$$slots:{default:[bs]},$$scope:{ctx:T}}}),Ze=new $t({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch, math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration, AutoFeatureExtractor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare user input audio </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = librispeech_dummy.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=feature_extractor.sampling_rate))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_sample = librispeech_dummy[-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>user_input_values = feature_extractor(raw_audio=audio_sample, sampling_rate=feature_extractor.sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=device, dtype=dtype)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input values - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_input_values = torch.zeros_like(user_input_values.input_values)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input ids - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_tokens = math.ceil(moshi_input_values.shape[-<span class="hljs-number">1</span>] * waveform_to_token_ratio)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((<span class="hljs-number">1</span>, num_tokens), device=device, dtype=torch.int64) * tokenizer.encode(<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate 25 new tokens (around 2s of audio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(input_ids=input_ids, user_input_values=user_input_values.input_values, moshi_input_values=moshi_input_values, max_new_tokens=<span class="hljs-number">25</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text_tokens = output.sequences
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_waveforms = output.audio_sequences`,wrap:!1}}),Ne=new R({props:{title:"How does the model forward the inputs / generate:",local:"how-does-the-model-forward-the-inputs--generate",headingTag:"h3"}}),Pe=new R({props:{title:"MoshiConfig",local:"transformers.MoshiConfig",headingTag:"h2"}}),Xe=new N({props:{name:"class transformers.MoshiConfig",anchor:"transformers.MoshiConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = None"},{name:"max_position_embeddings",val:" = 3000"},{name:"rope_theta",val:" = 10000.0"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 3000"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 22528"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the layers and the pooler layer of the main decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the main decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoshiConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
Sliding window attention window size. If not specified, will default to <code>3000</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the main decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>depth__config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the depth decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L149"}}),A=new Gt({props:{anchor:"transformers.MoshiConfig.example",$$slots:{default:[Ms]},$$scope:{ctx:T}}}),De=new N({props:{name:"from_audio_encoder_config",anchor:"transformers.MoshiConfig.from_audio_encoder_config",parameters:[{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a></p>
`}}),Se=new R({props:{title:"MoshiDepthConfig",local:"transformers.MoshiDepthConfig",headingTag:"h2"}}),Ee=new N({props:{name:"class transformers.MoshiDepthConfig",anchor:"transformers.MoshiDepthConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 1024"},{name:"input_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 6"},{name:"num_attention_heads",val:" = 16"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 9"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 8"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 5632"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiDepthConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDepthDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDepthDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiDepthConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer of the depth decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiDepthConfig.input_size",description:`<strong>input_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the input hidden states. Used to connect the main decoder to the depth decoder.`,name:"input_size"},{anchor:"transformers.MoshiDepthConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of depth decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiDepthConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the depth decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiDepthConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiDepthConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiDepthConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 9) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiDepthConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the depth decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiDepthConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiDepthConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiDepthConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiDepthConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Sliding window attention window size. If not specified, will default to <code>8</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiDepthConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiDepthConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the depth decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiDepthConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiDepthConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiDepthConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiDepthConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L25"}}),O=new Gt({props:{anchor:"transformers.MoshiDepthConfig.example",$$slots:{default:[ys]},$$scope:{ctx:T}}}),Ye=new R({props:{title:"MoshiModel",local:"transformers.MoshiModel",headingTag:"h2"}}),Ae=new N({props:{name:"class transformers.MoshiModel",anchor:"transformers.MoshiModel",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MoshiModel.config",description:"<strong>config</strong> &#x2014; MoshiConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1440"}}),Qe=new N({props:{name:"forward",anchor:"transformers.MoshiModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoshiModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MoshiModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1476"}}),K=new jt({props:{$$slots:{default:[vs]},$$scope:{ctx:T}}}),Oe=new R({props:{title:"MoshiForCausalLM",local:"transformers.MoshiForCausalLM",headingTag:"h2"}}),Ke=new N({props:{name:"class transformers.MoshiForCausalLM",anchor:"transformers.MoshiForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1744"}}),et=new N({props:{name:"forward",anchor:"transformers.MoshiForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MoshiForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoshiForCausalLM.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1779",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new jt({props:{$$slots:{default:[ws]},$$scope:{ctx:T}}}),te=new Gt({props:{anchor:"transformers.MoshiForCausalLM.forward.example",$$slots:{default:[Ts]},$$scope:{ctx:T}}}),tt=new R({props:{title:"MoshiForConditionalGeneration",local:"transformers.MoshiForConditionalGeneration",headingTag:"h2"}}),ot=new N({props:{name:"class transformers.MoshiForConditionalGeneration",anchor:"transformers.MoshiForConditionalGeneration",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1886"}}),nt=new N({props:{name:"forward",anchor:"transformers.MoshiForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"text_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"audio_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence text tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_input_values",description:"<strong>user_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio user prompt for the generation.",name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_audio_codes",description:"<strong>user_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio user prompt for the generation. Has priority over </code>user_input_values<code>and represents the audio &quot;tokens&quot; of</code>user_input_values` once passed through the audio encoder.",name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_input_values",description:"<strong>moshi_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio Moshi prompt for the generation.",name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_audio_codes",description:"<strong>moshi_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio Moshi prompt for the generation. Has priority over </code>moshi_input_values<code>and represents the audio &quot;tokens&quot; of</code>moshi_input_values` once passed through the audio encoder.",name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>input_ids</code> and <code>inputs_embeds</code> are both unset, <code>inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.`,name:"past_key_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.text_labels",description:`<strong>text_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for text language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"text_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.audio_labels",description:`<strong>audio_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_codebooks, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.audio_vocab_size]</code>`,name:"audio_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1925",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new jt({props:{$$slots:{default:[ks]},$$scope:{ctx:T}}}),ne=new Gt({props:{anchor:"transformers.MoshiForConditionalGeneration.forward.example",$$slots:{default:[xs]},$$scope:{ctx:T}}}),st=new N({props:{name:"generate",anchor:"transformers.MoshiForConditionalGeneration.generate",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_audio_waveforms",val:": typing.Optional[bool] = True"},{name:"return_audio_codes",val:": typing.Optional[bool] = None"},{name:"concat_unconditional_inputs",val:": typing.Optional[bool] = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.generate.input_ids",description:"<strong>input_ids</strong> (<code>torch.Tensor </code>of shape `(batch_size, sequence_length), <em>optional</em>) &#x2014;\nThe sequence used as a text prompt for the generation.",name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_input_values",description:"<strong>user_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio user prompt for the generation.",name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_audio_codes",description:"<strong>user_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio user prompt for the generation. Has priority over </code>user_input_values<code>and represents the audio &quot;tokens&quot; of</code>user_input_values` once passed through the audio encoder.",name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_input_values",description:"<strong>moshi_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio Moshi prompt for the generation.",name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_audio_codes",description:"<strong>moshi_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio Moshi prompt for the generation. Has priority over </code>moshi_input_values<code>and represents the audio &quot;tokens&quot; of</code>moshi_input_values` once passed through the audio encoder.",name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> and the audio inputs you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert the inputs into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_waveforms",description:`<strong>return_audio_waveforms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t generate the audio waveforms.`,name:"return_audio_waveforms"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_codes",description:`<strong>return_audio_codes</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, will also returns the generated audio codes, i.e the intermediate audio &#x201C;tokens&#x201D; which transforms to <code>audio_sequences</code> once passed through the audio decoder.`,name:"return_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.concat_unconditional_inputs",description:`<strong>concat_unconditional_inputs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t concatenate initial audio and text tokens.`,name:"concat_unconditional_inputs"},{anchor:"transformers.MoshiForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Remaining dictionary of keyword arguments that are passed to the <code>generate</code> method. Refers to the
original <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow"><code>generate</code> docstrings</a>
for more information on how to use them.
Note that keywords with a <em>depth_</em> prefix will be input for the <code>generate</code> method of the
depth decoder. Otherwise, the latter will use its default generation config.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2183",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>MoshiConditionalGenerationGenerateOutput</code></p>
`}}),at=new N({props:{name:"get_unconditional_inputs",anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"},{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.max_new_tokens",description:`<strong>max_new_tokens</strong> (int, <em>optional</em>) &#x2014;
Number of tokens to generate for each sample. More tokens means longer audio samples, at the expense of
longer inference (since more audio tokens need to be generated per sample).`,name:"max_new_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2600"}}),ae=new Gt({props:{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.example",$$slots:{default:[Cs]},$$scope:{ctx:T}}}),it=new gs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moshi.md"}}),{c(){i=l("meta"),v=s(),m=l("p"),h=s(),u(y.$$.fragment),r=s(),u(w.$$.fragment),Ft=s(),ie=l("p"),ie.innerHTML=hn,Jt=s(),re=l("p"),re.textContent=mn,Wt=s(),D=l("div"),D.innerHTML=pn,Lt=s(),le=l("p"),le.textContent=un,Zt=s(),de=l("p"),de.innerHTML=fn,Ut=s(),ce=l("p"),ce.textContent=gn,It=s(),he=l("ol"),he.innerHTML=_n,Ht=s(),me=l("p"),me.innerHTML=bn,qt=s(),pe=l("p"),pe.textContent=Mn,Nt=s(),ue=l("p"),ue.innerHTML=yn,Bt=s(),fe=l("p"),fe.innerHTML=vn,Vt=s(),ge=l("p"),ge.innerHTML=wn,Rt=s(),_e=l("p"),_e.textContent=Tn,Pt=s(),be=l("p"),be.innerHTML=kn,Xt=s(),Me=l("p"),Me.textContent=xn,Dt=s(),ye=l("p"),ye.innerHTML=Cn,St=s(),ve=l("p"),ve.innerHTML=$n,Et=s(),u(we.$$.fragment),Yt=s(),Te=l("p"),Te.innerHTML=zn,At=s(),u(ke.$$.fragment),Qt=s(),xe=l("p"),xe.textContent=jn,Ot=s(),Ce=l("ol"),Ce.innerHTML=Gn,Kt=s(),u(S.$$.fragment),eo=s(),$e=l("p"),$e.innerHTML=Fn,to=s(),ze=l("p"),ze.textContent=Jn,oo=s(),je=l("p"),je.innerHTML=Wn,no=s(),Ge=l("ol"),Ge.innerHTML=Ln,so=s(),Fe=l("p"),Fe.textContent=Zn,ao=s(),Je=l("p"),Je.textContent=Un,io=s(),We=l("ol"),We.innerHTML=In,ro=s(),u(E.$$.fragment),lo=s(),Y=l("div"),Y.innerHTML=Hn,co=s(),Le=l("p"),Le.innerHTML=qn,ho=s(),u(Ze.$$.fragment),mo=s(),Ue=l("p"),Ue.innerHTML=Nn,po=s(),Ie=l("p"),Ie.textContent=Bn,uo=s(),He=l("p"),He.innerHTML=Vn,fo=s(),qe=l("p"),qe.textContent=Rn,go=s(),u(Ne.$$.fragment),_o=s(),Be=l("ol"),Be.innerHTML=Pn,bo=s(),Ve=l("p"),Ve.innerHTML=Xn,Mo=s(),Re=l("p"),Re.innerHTML=Dn,yo=s(),u(Pe.$$.fragment),vo=s(),x=l("div"),u(Xe.$$.fragment),Wo=s(),dt=l("p"),dt.innerHTML=Sn,Lo=s(),ct=l("p"),ct.innerHTML=En,Zo=s(),u(A.$$.fragment),Uo=s(),Q=l("div"),u(De.$$.fragment),Io=s(),ht=l("p"),ht.innerHTML=Yn,wo=s(),u(Se.$$.fragment),To=s(),z=l("div"),u(Ee.$$.fragment),Ho=s(),mt=l("p"),mt.innerHTML=An,qo=s(),pt=l("p"),pt.innerHTML=Qn,No=s(),u(O.$$.fragment),ko=s(),u(Ye.$$.fragment),xo=s(),C=l("div"),u(Ae.$$.fragment),Bo=s(),ut=l("p"),ut.innerHTML=On,Vo=s(),ft=l("p"),ft.innerHTML=Kn,Ro=s(),gt=l("p"),gt.innerHTML=es,Po=s(),B=l("div"),u(Qe.$$.fragment),Xo=s(),_t=l("p"),_t.innerHTML=ts,Do=s(),u(K.$$.fragment),Co=s(),u(Oe.$$.fragment),$o=s(),j=l("div"),u(Ke.$$.fragment),So=s(),bt=l("p"),bt.innerHTML=os,Eo=s(),Mt=l("p"),Mt.innerHTML=ns,Yo=s(),L=l("div"),u(et.$$.fragment),Ao=s(),yt=l("p"),yt.innerHTML=ss,Qo=s(),u(ee.$$.fragment),Oo=s(),u(te.$$.fragment),zo=s(),u(tt.$$.fragment),jo=s(),k=l("div"),u(ot.$$.fragment),Ko=s(),vt=l("p"),vt.innerHTML=as,en=s(),wt=l("p"),wt.innerHTML=is,tn=s(),Z=l("div"),u(nt.$$.fragment),on=s(),Tt=l("p"),Tt.innerHTML=rs,nn=s(),u(oe.$$.fragment),sn=s(),u(ne.$$.fragment),an=s(),se=l("div"),u(st.$$.fragment),rn=s(),kt=l("p"),kt.textContent=ls,ln=s(),V=l("div"),u(at.$$.fragment),dn=s(),xt=l("p"),xt.textContent=ds,cn=s(),u(ae.$$.fragment),Go=s(),u(it.$$.fragment),Fo=s(),zt=l("p"),this.h()},l(e){const t=fs("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(o),v=a(e),m=d(e,"P",{}),J(m).forEach(o),h=a(e),f(y.$$.fragment,e),r=a(e),f(w.$$.fragment,e),Ft=a(e),ie=d(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1ram3sl"&&(ie.innerHTML=hn),Jt=a(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-10cdxpm"&&(re.textContent=mn),Wt=a(e),D=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(D)!=="svelte-mbh6d3"&&(D.innerHTML=pn),Lt=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-vfdo9a"&&(le.textContent=un),Zt=a(e),de=d(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-ffvq6r"&&(de.innerHTML=fn),Ut=a(e),ce=d(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-4ue2cs"&&(ce.textContent=gn),It=a(e),he=d(e,"OL",{"data-svelte-h":!0}),c(he)!=="svelte-1jvfsgp"&&(he.innerHTML=_n),Ht=a(e),me=d(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-1ml9jf7"&&(me.innerHTML=bn),qt=a(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-14liuk7"&&(pe.textContent=Mn),Nt=a(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-p16krn"&&(ue.innerHTML=yn),Bt=a(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1q2q7g4"&&(fe.innerHTML=vn),Vt=a(e),ge=d(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-mrya4j"&&(ge.innerHTML=wn),Rt=a(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1rssv50"&&(_e.textContent=Tn),Pt=a(e),be=d(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-17ugm1v"&&(be.innerHTML=kn),Xt=a(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1omq70l"&&(Me.textContent=xn),Dt=a(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-17ls77v"&&(ye.innerHTML=Cn),St=a(e),ve=d(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-133xg3y"&&(ve.innerHTML=$n),Et=a(e),f(we.$$.fragment,e),Yt=a(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-w8i26r"&&(Te.innerHTML=zn),At=a(e),f(ke.$$.fragment,e),Qt=a(e),xe=d(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1bexf7"&&(xe.textContent=jn),Ot=a(e),Ce=d(e,"OL",{"data-svelte-h":!0}),c(Ce)!=="svelte-pl202q"&&(Ce.innerHTML=Gn),Kt=a(e),f(S.$$.fragment,e),eo=a(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-29ux01"&&($e.innerHTML=Fn),to=a(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1qxprua"&&(ze.textContent=Jn),oo=a(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-rsiv03"&&(je.innerHTML=Wn),no=a(e),Ge=d(e,"OL",{"data-svelte-h":!0}),c(Ge)!=="svelte-1h129yn"&&(Ge.innerHTML=Ln),so=a(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-mxzqdb"&&(Fe.textContent=Zn),ao=a(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-u8oyt7"&&(Je.textContent=Un),io=a(e),We=d(e,"OL",{"data-svelte-h":!0}),c(We)!=="svelte-1171zt7"&&(We.innerHTML=In),ro=a(e),f(E.$$.fragment,e),lo=a(e),Y=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(Y)!=="svelte-1tji7z9"&&(Y.innerHTML=Hn),co=a(e),Le=d(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-kta7w9"&&(Le.innerHTML=qn),ho=a(e),f(Ze.$$.fragment,e),mo=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1byzz9w"&&(Ue.innerHTML=Nn),po=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-2rjz94"&&(Ie.textContent=Bn),uo=a(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-78mjvt"&&(He.innerHTML=Vn),fo=a(e),qe=d(e,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-nu560a"&&(qe.textContent=Rn),go=a(e),f(Ne.$$.fragment,e),_o=a(e),Be=d(e,"OL",{"data-svelte-h":!0}),c(Be)!=="svelte-sd14aa"&&(Be.innerHTML=Pn),bo=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-xte361"&&(Ve.innerHTML=Xn),Mo=a(e),Re=d(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-ow5c16"&&(Re.innerHTML=Dn),yo=a(e),f(Pe.$$.fragment,e),vo=a(e),x=d(e,"DIV",{class:!0});var G=J(x);f(Xe.$$.fragment,G),Wo=a(G),dt=d(G,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-1bo9y8q"&&(dt.innerHTML=Sn),Lo=a(G),ct=d(G,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-o55m63"&&(ct.innerHTML=En),Zo=a(G),f(A.$$.fragment,G),Uo=a(G),Q=d(G,"DIV",{class:!0});var rt=J(Q);f(De.$$.fragment,rt),Io=a(rt),ht=d(rt,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-1i23l1v"&&(ht.innerHTML=Yn),rt.forEach(o),G.forEach(o),wo=a(e),f(Se.$$.fragment,e),To=a(e),z=d(e,"DIV",{class:!0});var U=J(z);f(Ee.$$.fragment,U),Ho=a(U),mt=d(U,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1o2zxrk"&&(mt.innerHTML=An),qo=a(U),pt=d(U,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-o55m63"&&(pt.innerHTML=Qn),No=a(U),f(O.$$.fragment,U),U.forEach(o),ko=a(e),f(Ye.$$.fragment,e),xo=a(e),C=d(e,"DIV",{class:!0});var F=J(C);f(Ae.$$.fragment,F),Bo=a(F),ut=d(F,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1hn43q6"&&(ut.innerHTML=On),Vo=a(F),ft=d(F,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-hswkmf"&&(ft.innerHTML=Kn),Ro=a(F),gt=d(F,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-8vjzhz"&&(gt.innerHTML=es),Po=a(F),B=d(F,"DIV",{class:!0});var X=J(B);f(Qe.$$.fragment,X),Xo=a(X),_t=d(X,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-te41l3"&&(_t.innerHTML=ts),Do=a(X),f(K.$$.fragment,X),X.forEach(o),F.forEach(o),Co=a(e),f(Oe.$$.fragment,e),$o=a(e),j=d(e,"DIV",{class:!0});var I=J(j);f(Ke.$$.fragment,I),So=a(I),bt=d(I,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-199lvu9"&&(bt.innerHTML=os),Eo=a(I),Mt=d(I,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-hswkmf"&&(Mt.innerHTML=ns),Yo=a(I),L=d(I,"DIV",{class:!0});var H=J(L);f(et.$$.fragment,H),Ao=a(H),yt=d(H,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-2k89wz"&&(yt.innerHTML=ss),Qo=a(H),f(ee.$$.fragment,H),Oo=a(H),f(te.$$.fragment,H),H.forEach(o),I.forEach(o),zo=a(e),f(tt.$$.fragment,e),jo=a(e),k=d(e,"DIV",{class:!0});var $=J(k);f(ot.$$.fragment,$),Ko=a($),vt=d($,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-6aoagg"&&(vt.innerHTML=as),en=a($),wt=d($,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-hswkmf"&&(wt.innerHTML=is),tn=a($),Z=d($,"DIV",{class:!0});var q=J(Z);f(nt.$$.fragment,q),on=a(q),Tt=d(q,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-10ij2kh"&&(Tt.innerHTML=rs),nn=a(q),f(oe.$$.fragment,q),sn=a(q),f(ne.$$.fragment,q),q.forEach(o),an=a($),se=d($,"DIV",{class:!0});var lt=J(se);f(st.$$.fragment,lt),rn=a(lt),kt=d(lt,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-8p80bg"&&(kt.textContent=ls),lt.forEach(o),ln=a($),V=d($,"DIV",{class:!0});var Ct=J(V);f(at.$$.fragment,Ct),dn=a(Ct),xt=d(Ct,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-99wdq5"&&(xt.textContent=ds),cn=a(Ct),f(ae.$$.fragment,Ct),Ct.forEach(o),$.forEach(o),Go=a(e),f(it.$$.fragment,e),Fo=a(e),zt=d(e,"P",{}),J(zt).forEach(o),this.h()},h(){W(i,"name","hf:doc:metadata"),W(i,"content",zs),cs(D,"text-align","center"),cs(Y,"text-align","center"),W(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,i),n(e,v,t),n(e,m,t),n(e,h,t),g(y,e,t),n(e,r,t),g(w,e,t),n(e,Ft,t),n(e,ie,t),n(e,Jt,t),n(e,re,t),n(e,Wt,t),n(e,D,t),n(e,Lt,t),n(e,le,t),n(e,Zt,t),n(e,de,t),n(e,Ut,t),n(e,ce,t),n(e,It,t),n(e,he,t),n(e,Ht,t),n(e,me,t),n(e,qt,t),n(e,pe,t),n(e,Nt,t),n(e,ue,t),n(e,Bt,t),n(e,fe,t),n(e,Vt,t),n(e,ge,t),n(e,Rt,t),n(e,_e,t),n(e,Pt,t),n(e,be,t),n(e,Xt,t),n(e,Me,t),n(e,Dt,t),n(e,ye,t),n(e,St,t),n(e,ve,t),n(e,Et,t),g(we,e,t),n(e,Yt,t),n(e,Te,t),n(e,At,t),g(ke,e,t),n(e,Qt,t),n(e,xe,t),n(e,Ot,t),n(e,Ce,t),n(e,Kt,t),g(S,e,t),n(e,eo,t),n(e,$e,t),n(e,to,t),n(e,ze,t),n(e,oo,t),n(e,je,t),n(e,no,t),n(e,Ge,t),n(e,so,t),n(e,Fe,t),n(e,ao,t),n(e,Je,t),n(e,io,t),n(e,We,t),n(e,ro,t),g(E,e,t),n(e,lo,t),n(e,Y,t),n(e,co,t),n(e,Le,t),n(e,ho,t),g(Ze,e,t),n(e,mo,t),n(e,Ue,t),n(e,po,t),n(e,Ie,t),n(e,uo,t),n(e,He,t),n(e,fo,t),n(e,qe,t),n(e,go,t),g(Ne,e,t),n(e,_o,t),n(e,Be,t),n(e,bo,t),n(e,Ve,t),n(e,Mo,t),n(e,Re,t),n(e,yo,t),g(Pe,e,t),n(e,vo,t),n(e,x,t),g(Xe,x,null),p(x,Wo),p(x,dt),p(x,Lo),p(x,ct),p(x,Zo),g(A,x,null),p(x,Uo),p(x,Q),g(De,Q,null),p(Q,Io),p(Q,ht),n(e,wo,t),g(Se,e,t),n(e,To,t),n(e,z,t),g(Ee,z,null),p(z,Ho),p(z,mt),p(z,qo),p(z,pt),p(z,No),g(O,z,null),n(e,ko,t),g(Ye,e,t),n(e,xo,t),n(e,C,t),g(Ae,C,null),p(C,Bo),p(C,ut),p(C,Vo),p(C,ft),p(C,Ro),p(C,gt),p(C,Po),p(C,B),g(Qe,B,null),p(B,Xo),p(B,_t),p(B,Do),g(K,B,null),n(e,Co,t),g(Oe,e,t),n(e,$o,t),n(e,j,t),g(Ke,j,null),p(j,So),p(j,bt),p(j,Eo),p(j,Mt),p(j,Yo),p(j,L),g(et,L,null),p(L,Ao),p(L,yt),p(L,Qo),g(ee,L,null),p(L,Oo),g(te,L,null),n(e,zo,t),g(tt,e,t),n(e,jo,t),n(e,k,t),g(ot,k,null),p(k,Ko),p(k,vt),p(k,en),p(k,wt),p(k,tn),p(k,Z),g(nt,Z,null),p(Z,on),p(Z,Tt),p(Z,nn),g(oe,Z,null),p(Z,sn),g(ne,Z,null),p(k,an),p(k,se),g(st,se,null),p(se,rn),p(se,kt),p(k,ln),p(k,V),g(at,V,null),p(V,dn),p(V,xt),p(V,cn),g(ae,V,null),n(e,Go,t),g(it,e,t),n(e,Fo,t),n(e,zt,t),Jo=!0},p(e,[t]){const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),S.$set(G);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),E.$set(rt);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),A.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),O.$set(F);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),K.$set(X);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),ee.$set(I);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),te.$set(H);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),oe.$set($);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),ne.$set(q);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),ae.$set(lt)},i(e){Jo||(_(y.$$.fragment,e),_(w.$$.fragment,e),_(we.$$.fragment,e),_(ke.$$.fragment,e),_(S.$$.fragment,e),_(E.$$.fragment,e),_(Ze.$$.fragment,e),_(Ne.$$.fragment,e),_(Pe.$$.fragment,e),_(Xe.$$.fragment,e),_(A.$$.fragment,e),_(De.$$.fragment,e),_(Se.$$.fragment,e),_(Ee.$$.fragment,e),_(O.$$.fragment,e),_(Ye.$$.fragment,e),_(Ae.$$.fragment,e),_(Qe.$$.fragment,e),_(K.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(ae.$$.fragment,e),_(it.$$.fragment,e),Jo=!0)},o(e){b(y.$$.fragment,e),b(w.$$.fragment,e),b(we.$$.fragment,e),b(ke.$$.fragment,e),b(S.$$.fragment,e),b(E.$$.fragment,e),b(Ze.$$.fragment,e),b(Ne.$$.fragment,e),b(Pe.$$.fragment,e),b(Xe.$$.fragment,e),b(A.$$.fragment,e),b(De.$$.fragment,e),b(Se.$$.fragment,e),b(Ee.$$.fragment,e),b(O.$$.fragment,e),b(Ye.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(K.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(ae.$$.fragment,e),b(it.$$.fragment,e),Jo=!1},d(e){e&&(o(v),o(m),o(h),o(r),o(Ft),o(ie),o(Jt),o(re),o(Wt),o(D),o(Lt),o(le),o(Zt),o(de),o(Ut),o(ce),o(It),o(he),o(Ht),o(me),o(qt),o(pe),o(Nt),o(ue),o(Bt),o(fe),o(Vt),o(ge),o(Rt),o(_e),o(Pt),o(be),o(Xt),o(Me),o(Dt),o(ye),o(St),o(ve),o(Et),o(Yt),o(Te),o(At),o(Qt),o(xe),o(Ot),o(Ce),o(Kt),o(eo),o($e),o(to),o(ze),o(oo),o(je),o(no),o(Ge),o(so),o(Fe),o(ao),o(Je),o(io),o(We),o(ro),o(lo),o(Y),o(co),o(Le),o(ho),o(mo),o(Ue),o(po),o(Ie),o(uo),o(He),o(fo),o(qe),o(go),o(_o),o(Be),o(bo),o(Ve),o(Mo),o(Re),o(yo),o(vo),o(x),o(wo),o(To),o(z),o(ko),o(xo),o(C),o(Co),o($o),o(j),o(zo),o(jo),o(k),o(Go),o(Fo),o(zt)),o(i),M(y,e),M(w,e),M(we,e),M(ke,e),M(S,e),M(E,e),M(Ze,e),M(Ne,e),M(Pe,e),M(Xe),M(A),M(De),M(Se,e),M(Ee),M(O),M(Ye,e),M(Ae),M(Qe),M(K),M(Oe,e),M(Ke),M(et),M(ee),M(te),M(tt,e),M(ot),M(nt),M(oe),M(ne),M(st),M(at),M(ae),M(it,e)}}}const zs='{"title":"Moshi","local":"moshi","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Tips:","local":"tips","sections":[{"title":"How to use the model:","local":"how-to-use-the-model","sections":[],"depth":3},{"title":"How does the model forward the inputs / generate:","local":"how-does-the-model-forward-the-inputs--generate","sections":[],"depth":3}],"depth":2},{"title":"MoshiConfig","local":"transformers.MoshiConfig","sections":[],"depth":2},{"title":"MoshiDepthConfig","local":"transformers.MoshiDepthConfig","sections":[],"depth":2},{"title":"MoshiModel","local":"transformers.MoshiModel","sections":[],"depth":2},{"title":"MoshiForCausalLM","local":"transformers.MoshiForCausalLM","sections":[],"depth":2},{"title":"MoshiForConditionalGeneration","local":"transformers.MoshiForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function js(T){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends ps{constructor(i){super(),us(this,i,js,$s,hs,{})}}export{Is as component};
