import{s as Ce,n as _e,o as ke}from"../chunks/scheduler.25b97de1.js";import{S as ge,i as Ze,g as p,s as a,r,A as Ae,h as i,f as l,c as n,j as Ie,u as c,x as o,k as Be,y as Ge,a as t,v as d,d as M,t as y,w as m}from"../chunks/index.d9030fc9.js";import{C as u}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Ps,E as He}from"../chunks/EditOnGithub.91d95064.js";function Xe(Ks){let w,ps,as,is,h,os,T,Ds=`In this guide, we will see how to create a custom pipeline and share it on the <a href="https://hf.co/models" rel="nofollow">Hub</a> or add it to the
🤗 Transformers library.`,rs,J,Os=`First and foremost, you need to decide the raw entries the pipeline will be able to take. It can be strings, raw bytes,
dictionaries or whatever seems to be the most likely desired input. Try to keep these inputs as pure Python as possible
as it makes compatibility easier (even through other languages via JSON). Those will be the <code>inputs</code> of the
pipeline (<code>preprocess</code>).`,cs,j,se=`Then define the <code>outputs</code>. Same policy as the <code>inputs</code>. The simpler, the better. Those will be the outputs of
<code>postprocess</code> method.`,ds,f,ee=`Start by inheriting the base class <code>Pipeline</code> with the 4 methods needed to implement <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code>, and <code>_sanitize_parameters</code>.`,Ms,U,ys,b,le=`The structure of this breakdown is to support relatively seamless support for CPU/GPU, while supporting doing
pre/postprocessing on the CPU on different threads`,ms,I,te=`<code>preprocess</code> will take the originally defined inputs, and turn them into something feedable to the model. It might
contain more information and is usually a <code>Dict</code>.`,us,B,ae=`<code>_forward</code> is the implementation detail and is not meant to be called directly. <code>forward</code> is the preferred
called method as it contains safeguards to make sure everything is working on the expected device. If anything is
linked to a real model it belongs in the <code>_forward</code> method, anything else is in the preprocess/postprocess.`,ws,C,ne=`<code>postprocess</code> methods will take the output of <code>_forward</code> and turn it into the final output that was decided
earlier.`,hs,_,pe=`<code>_sanitize_parameters</code> exists to allow users to pass any parameters whenever they wish, be it at initialization
time <code>pipeline(...., maybe_arg=4)</code> or at call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,Ts,k,ie=`The returns of <code>_sanitize_parameters</code> are the 3 dicts of kwargs that will be passed directly to <code>preprocess</code>,
<code>_forward</code>, and <code>postprocess</code>. Don’t fill anything if the caller didn’t call with any extra parameter. That
allows to keep the default arguments in the function definition which is always more “natural”.`,Js,g,oe="A classic example would be a <code>top_k</code> argument in the post processing in classification tasks.",js,Z,fs,A,re=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,Us,G,bs,H,ce=`Try to keep the inputs/outputs very simple and ideally JSON-serializable as it makes the pipeline usage very easy
without requiring users to understand new kinds of objects. It’s also relatively common to support many different types
of arguments for ease of use (audio files, which can be filenames, URLs or pure bytes)`,Is,X,Bs,V,de="To register your <code>new-task</code> to the list of supported tasks, you have to add it to the <code>PIPELINE_REGISTRY</code>:",Cs,W,_s,N,Me="You can specify a default model if you want, in which case it should come with a specific revision (which can be the name of a branch or a commit hash, here we took <code>&quot;abcdef&quot;</code>) as well as the type:",ks,R,gs,q,Zs,v,ye=`To share your custom pipeline on the Hub, you just have to save the custom code of your <code>Pipeline</code> subclass in a
python file. For instance, let’s say we want to use a custom pipeline for sentence pair classification like this:`,As,E,Gs,$,me=`The implementation is framework agnostic, and will work for PyTorch and TensorFlow models. If we have saved this in
a file named <code>pair_classification.py</code>, we can then import it and register it like this. The <a href="https://github.com/huggingface/transformers/blob/9feae5fb0164e89d4998e5776897c16f7330d3df/src/transformers/pipelines/base.py#L1387" rel="nofollow">register_pipeline</a> function registers the pipeline details (task type, pipeline class, supported backends) to a models <code>config.json</code> file.`,Hs,z,Xs,x,ue=`Once this is done, we can use it with a pretrained model. For instance <code>sgugger/finetuned-bert-mrpc</code> has been
fine-tuned on the MRPC dataset, which classifies pairs of sentences as paraphrases or not.`,Vs,Y,Ws,Q,we="Then we can share it on the Hub by using the <code>push_to_hub</code> method:",Ns,F,Rs,S,he=`This will copy the file where you defined <code>PairClassificationPipeline</code> inside the folder <code>&quot;test-dynamic-pipeline&quot;</code>,
along with saving the model and tokenizer of the pipeline, before pushing everything into the repository
<code>{your_username}/test-dynamic-pipeline</code>. After that, anyone can use it as long as they provide the option
<code>trust_remote_code=True</code>:`,qs,L,vs,P,Es,K,Te=`If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the <code>pipelines</code> submodule
with the code of your pipeline, then add it to the list of tasks defined in <code>pipelines/__init__.py</code>.`,$s,D,Je="Then you will need to add tests. Create a new file <code>tests/test_pipelines_MY_PIPELINE.py</code> with examples of the other tests.",zs,O,je=`The <code>run_pipeline_test</code> function will be very generic and run on small random models on every possible
architecture as defined by <code>model_mapping</code> and <code>tf_model_mapping</code>.`,xs,ss,fe=`This is very important to test future compatibility, meaning if someone adds a new model for
<code>XXXForQuestionAnswering</code> then the pipeline test will attempt to run on it. Because the models are random it’s
impossible to check for actual values, that’s why there is a helper <code>ANY</code> that will simply attempt to match the
output of the pipeline TYPE.`,Ys,es,Ue="You also <em>need</em> to implement 2 (ideally 4) tests.",Qs,ls,be=`<li><code>test_small_model_pt</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li>`,Fs,ts,Ss,ns,Ls;return h=new Ps({props:{title:"How to create a custom pipeline?",local:"how-to-create-a-custom-pipeline",headingTag:"h1"}}),U=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),Z=new u({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),G=new u({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),X=new Ps({props:{title:"Adding it to the list of supported tasks",local:"adding-it-to-the-list-of-supported-tasks",headingTag:"h2"}}),W=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),R=new u({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),q=new Ps({props:{title:"Share your pipeline on the Hub",local:"share-your-pipeline-on-the-hub",headingTag:"h2"}}),E=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),z=new u({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Y=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),F=new u({props:{code:"Y2xhc3NpZmllci5wdXNoX3RvX2h1YiglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIp",highlighted:'classifier.push_to_hub(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)',wrap:!1}}),L=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new Ps({props:{title:"Add the pipeline to 🤗 Transformers",local:"add-the-pipeline-to--transformers",headingTag:"h2"}}),ts=new He({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/add_new_pipeline.md"}}),{c(){w=p("meta"),ps=a(),as=p("p"),is=a(),r(h.$$.fragment),os=a(),T=p("p"),T.innerHTML=Ds,rs=a(),J=p("p"),J.innerHTML=Os,cs=a(),j=p("p"),j.innerHTML=se,ds=a(),f=p("p"),f.innerHTML=ee,Ms=a(),r(U.$$.fragment),ys=a(),b=p("p"),b.textContent=le,ms=a(),I=p("p"),I.innerHTML=te,us=a(),B=p("p"),B.innerHTML=ae,ws=a(),C=p("p"),C.innerHTML=ne,hs=a(),_=p("p"),_.innerHTML=pe,Ts=a(),k=p("p"),k.innerHTML=ie,Js=a(),g=p("p"),g.innerHTML=oe,js=a(),r(Z.$$.fragment),fs=a(),A=p("p"),A.innerHTML=re,Us=a(),r(G.$$.fragment),bs=a(),H=p("p"),H.textContent=ce,Is=a(),r(X.$$.fragment),Bs=a(),V=p("p"),V.innerHTML=de,Cs=a(),r(W.$$.fragment),_s=a(),N=p("p"),N.innerHTML=Me,ks=a(),r(R.$$.fragment),gs=a(),r(q.$$.fragment),Zs=a(),v=p("p"),v.innerHTML=ye,As=a(),r(E.$$.fragment),Gs=a(),$=p("p"),$.innerHTML=me,Hs=a(),r(z.$$.fragment),Xs=a(),x=p("p"),x.innerHTML=ue,Vs=a(),r(Y.$$.fragment),Ws=a(),Q=p("p"),Q.innerHTML=we,Ns=a(),r(F.$$.fragment),Rs=a(),S=p("p"),S.innerHTML=he,qs=a(),r(L.$$.fragment),vs=a(),r(P.$$.fragment),Es=a(),K=p("p"),K.innerHTML=Te,$s=a(),D=p("p"),D.innerHTML=Je,zs=a(),O=p("p"),O.innerHTML=je,xs=a(),ss=p("p"),ss.innerHTML=fe,Ys=a(),es=p("p"),es.innerHTML=Ue,Qs=a(),ls=p("ul"),ls.innerHTML=be,Fs=a(),r(ts.$$.fragment),Ss=a(),ns=p("p"),this.h()},l(s){const e=Ae("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),ps=n(s),as=i(s,"P",{}),Ie(as).forEach(l),is=n(s),c(h.$$.fragment,s),os=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-rbtu2p"&&(T.innerHTML=Ds),rs=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-oxa02l"&&(J.innerHTML=Os),cs=n(s),j=i(s,"P",{"data-svelte-h":!0}),o(j)!=="svelte-6dmyza"&&(j.innerHTML=se),ds=n(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-yoim0k"&&(f.innerHTML=ee),Ms=n(s),c(U.$$.fragment,s),ys=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-byrozk"&&(b.textContent=le),ms=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1f1lssz"&&(I.innerHTML=te),us=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-12jiwrp"&&(B.innerHTML=ae),ws=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ev1pra"&&(C.innerHTML=ne),hs=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wbhsl3"&&(_.innerHTML=pe),Ts=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1rxvpik"&&(k.innerHTML=ie),Js=n(s),g=i(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1jbvi33"&&(g.innerHTML=oe),js=n(s),c(Z.$$.fragment,s),fs=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-nsc0of"&&(A.innerHTML=re),Us=n(s),c(G.$$.fragment,s),bs=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1r0sy2p"&&(H.textContent=ce),Is=n(s),c(X.$$.fragment,s),Bs=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-3jotdg"&&(V.innerHTML=de),Cs=n(s),c(W.$$.fragment,s),_s=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-491gz1"&&(N.innerHTML=Me),ks=n(s),c(R.$$.fragment,s),gs=n(s),c(q.$$.fragment,s),Zs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-12i9yqr"&&(v.innerHTML=ye),As=n(s),c(E.$$.fragment,s),Gs=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-rgi6ma"&&($.innerHTML=me),Hs=n(s),c(z.$$.fragment,s),Xs=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1o1fy6m"&&(x.innerHTML=ue),Vs=n(s),c(Y.$$.fragment,s),Ws=n(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1rhc9p2"&&(Q.innerHTML=we),Ns=n(s),c(F.$$.fragment,s),Rs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-m8nvb"&&(S.innerHTML=he),qs=n(s),c(L.$$.fragment,s),vs=n(s),c(P.$$.fragment,s),Es=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-wriqax"&&(K.innerHTML=Te),$s=n(s),D=i(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1wx7ut0"&&(D.innerHTML=Je),zs=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1by38ya"&&(O.innerHTML=je),xs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1cftve5"&&(ss.innerHTML=fe),Ys=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-17fu767"&&(es.innerHTML=Ue),Qs=n(s),ls=i(s,"UL",{"data-svelte-h":!0}),o(ls)!=="svelte-9p61si"&&(ls.innerHTML=be),Fs=n(s),c(ts.$$.fragment,s),Ss=n(s),ns=i(s,"P",{}),Ie(ns).forEach(l),this.h()},h(){Be(w,"name","hf:doc:metadata"),Be(w,"content",Ve)},m(s,e){Ge(document.head,w),t(s,ps,e),t(s,as,e),t(s,is,e),d(h,s,e),t(s,os,e),t(s,T,e),t(s,rs,e),t(s,J,e),t(s,cs,e),t(s,j,e),t(s,ds,e),t(s,f,e),t(s,Ms,e),d(U,s,e),t(s,ys,e),t(s,b,e),t(s,ms,e),t(s,I,e),t(s,us,e),t(s,B,e),t(s,ws,e),t(s,C,e),t(s,hs,e),t(s,_,e),t(s,Ts,e),t(s,k,e),t(s,Js,e),t(s,g,e),t(s,js,e),d(Z,s,e),t(s,fs,e),t(s,A,e),t(s,Us,e),d(G,s,e),t(s,bs,e),t(s,H,e),t(s,Is,e),d(X,s,e),t(s,Bs,e),t(s,V,e),t(s,Cs,e),d(W,s,e),t(s,_s,e),t(s,N,e),t(s,ks,e),d(R,s,e),t(s,gs,e),d(q,s,e),t(s,Zs,e),t(s,v,e),t(s,As,e),d(E,s,e),t(s,Gs,e),t(s,$,e),t(s,Hs,e),d(z,s,e),t(s,Xs,e),t(s,x,e),t(s,Vs,e),d(Y,s,e),t(s,Ws,e),t(s,Q,e),t(s,Ns,e),d(F,s,e),t(s,Rs,e),t(s,S,e),t(s,qs,e),d(L,s,e),t(s,vs,e),d(P,s,e),t(s,Es,e),t(s,K,e),t(s,$s,e),t(s,D,e),t(s,zs,e),t(s,O,e),t(s,xs,e),t(s,ss,e),t(s,Ys,e),t(s,es,e),t(s,Qs,e),t(s,ls,e),t(s,Fs,e),d(ts,s,e),t(s,Ss,e),t(s,ns,e),Ls=!0},p:_e,i(s){Ls||(M(h.$$.fragment,s),M(U.$$.fragment,s),M(Z.$$.fragment,s),M(G.$$.fragment,s),M(X.$$.fragment,s),M(W.$$.fragment,s),M(R.$$.fragment,s),M(q.$$.fragment,s),M(E.$$.fragment,s),M(z.$$.fragment,s),M(Y.$$.fragment,s),M(F.$$.fragment,s),M(L.$$.fragment,s),M(P.$$.fragment,s),M(ts.$$.fragment,s),Ls=!0)},o(s){y(h.$$.fragment,s),y(U.$$.fragment,s),y(Z.$$.fragment,s),y(G.$$.fragment,s),y(X.$$.fragment,s),y(W.$$.fragment,s),y(R.$$.fragment,s),y(q.$$.fragment,s),y(E.$$.fragment,s),y(z.$$.fragment,s),y(Y.$$.fragment,s),y(F.$$.fragment,s),y(L.$$.fragment,s),y(P.$$.fragment,s),y(ts.$$.fragment,s),Ls=!1},d(s){s&&(l(ps),l(as),l(is),l(os),l(T),l(rs),l(J),l(cs),l(j),l(ds),l(f),l(Ms),l(ys),l(b),l(ms),l(I),l(us),l(B),l(ws),l(C),l(hs),l(_),l(Ts),l(k),l(Js),l(g),l(js),l(fs),l(A),l(Us),l(bs),l(H),l(Is),l(Bs),l(V),l(Cs),l(_s),l(N),l(ks),l(gs),l(Zs),l(v),l(As),l(Gs),l($),l(Hs),l(Xs),l(x),l(Vs),l(Ws),l(Q),l(Ns),l(Rs),l(S),l(qs),l(vs),l(Es),l(K),l($s),l(D),l(zs),l(O),l(xs),l(ss),l(Ys),l(es),l(Qs),l(ls),l(Fs),l(Ss),l(ns)),l(w),m(h,s),m(U,s),m(Z,s),m(G,s),m(X,s),m(W,s),m(R,s),m(q,s),m(E,s),m(z,s),m(Y,s),m(F,s),m(L,s),m(P,s),m(ts,s)}}}const Ve='{"title":"How to create a custom pipeline?","local":"how-to-create-a-custom-pipeline","sections":[{"title":"Adding it to the list of supported tasks","local":"adding-it-to-the-list-of-supported-tasks","sections":[],"depth":2},{"title":"Share your pipeline on the Hub","local":"share-your-pipeline-on-the-hub","sections":[],"depth":2},{"title":"Add the pipeline to 🤗 Transformers","local":"add-the-pipeline-to--transformers","sections":[],"depth":2}],"depth":1}';function We(Ks){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends ge{constructor(w){super(),Ze(this,w,We,Xe,Ce,{})}}export{Ee as component};
