import{s as _r,n as ur,o as fr}from"../chunks/scheduler.9039eef2.js";import{S as vr,i as br,g as r,s as n,r as l,A as Tr,h as o,f as s,c as a,j as u,u as d,x as h,k as f,y as t,a as _,v as c,d as p,t as m,w as g}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{H as N}from"../chunks/Heading.f027f30d.js";function yr(ka){let z,zt,Lt,Ft,ne,qt,ae,La=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,Mt,re,St,F,oe,$n,Ve,Na="Configuration class for PPOTrainer",It,se,At,v,ie,On,je,za=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Dn,I,le,wn,We,Fa="Calculate model outputs in multiple batches.",Cn,A,de,kn,Be,qa="Compute per token rewards from scores and KL-penalty.",Ln,E,ce,Nn,Ke,Ma="Creates and saves a model card for a TRL model.",zn,U,pe,Fn,Ge,Sa="Gather stats from all processes. Useful in the context of distributed training.",qn,H,me,Mn,Ye,Ia=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,Sn,R,ge,In,Ze,Aa="A function that logs all the training stats. Call it at the end of each epoch.",An,V,he,En,Je,Ea="Calculate policy and value losses.",Un,j,_e,Hn,Qe,Ua="Prepare the dataloader for training.",Rn,W,ue,Vn,Xe,Ha="Record training step statistics.",jn,B,fe,Wn,et,Ra="Run a PPO optimisation step given a list of queries, model responses, and rewards.",Bn,K,ve,Kn,tt,Va="Train one PPO minibatch",Et,be,Ut,D,Te,Gn,nt,ja='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a> class.',Yn,at,Wa=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ht,ye,Rt,P,xe,Zn,rt,Ba=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Jn,ot,Ka=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Qn,st,Ga="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Xn,it,Ya=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Vt,Pe,jt,q,$e,ea,lt,Za=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Wt,Oe,Bt,y,De,ta,dt,Ja="Initialize DPOTrainer.",na,w,we,aa,ct,Qa="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",ra,pt,Xa="We do this to avoid doing two forward passes, because it’s faster for FSDP.",oa,G,Ce,sa,mt,er="Concatenate the chosen and rejected inputs into a single tensor.",ia,Y,ke,la,gt,tr="Compute the DPO loss for a batch of policy and reference model log probabilities.",da,C,Le,ca,ht,nr=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,pa,_t,ar="Works both with or without labels.",ma,Z,Ne,ga,ut,rr="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",ha,J,ze,_a,ft,or="Generate samples from the model and reference model for the given batch of inputs.",ua,Q,Fe,fa,vt,sr="Log <code>logs</code> on the various objects watching training, including stored metrics.",Kt,qe,Gt,M,Me,va,bt,ir="Configuration class for DDPOTrainer",Yt,Se,Zt,$,Ie,ba,Tt,lr=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,Ta,X,Ae,ya,yt,dr="Calculate the loss for a batch of an unpacked sample",xa,O,Ee,Pa,xt,cr="Perform a single step of training.",$a,Pt,pr="Side Effects:",Oa,$t,mr="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",Da,ee,Ue,wa,Ot,gr="Train the model for a given number of epochs",Jt,He,Qt,S,Re,Ca,Dt,hr="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Xt,Nt,en;return ne=new N({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),re=new N({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),oe=new b({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"query_dataset",val:": typing.Optional[str] = None"},{name:"reward_model",val:": typing.Optional[str] = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": dict = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": typing.Optional[float] = 0.2"},{name:"kl_penalty",val:": typing.Literal['kl', 'abs', 'mse', 'full'] = 'kl'"},{name:"target",val:": typing.Optional[float] = 6"},{name:"horizon",val:": typing.Optional[float] = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": typing.Optional[int] = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": typing.Optional[float] = None"},{name:"optimize_cuda_cache",val:": bool = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": typing.Optional[float] = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"is_peft_model",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L30"}}),se=new N({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ie=new b({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": typing.Optional[trl.models.modeling_base.PreTrainedModelWrapper] = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset, NoneType] = None"},{name:"optimizer",val:": typing.Optional[torch.optim.optimizer.Optimizer] = None"},{name:"data_collator",val:": typing.Optional[typing.Callable] = None"},{name:"num_shared_layers",val:": typing.Optional[int] = None"},{name:"lr_scheduler",val:": typing.Optional[torch.optim.lr_scheduler._LRScheduler] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L107"}}),le=new b({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),de=new b({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1049"}}),ce=new b({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1358"}}),pe=new b({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L868",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),me=new b({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"length_sampler",val:": typing.Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L417",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),ge=new b({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": typing.List[torch.FloatTensor]"},{name:"columns_to_log",val:": typing.List[str] = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1277"}}),he=new b({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1125"}}),_e=new b({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset]"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L362",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),ue=new b({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),fe=new b({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": typing.List[torch.LongTensor]"},{name:"responses",val:": typing.List[torch.LongTensor]"},{name:"scores",val:": typing.List[torch.FloatTensor]"},{name:"response_masks",val:": typing.Optional[typing.List[torch.LongTensor]] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),ve=new b({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1003",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),be=new N({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Te=new b({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = False"},{name:"save_on_each_node",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Optional[str] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"deepspeed",val:": typing.Optional[str] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Optional[typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": typing.Optional[bool] = True"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/training_configs.py#L23"}}),ye=new N({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),xe=new b({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"args",val:": typing.Optional[trl.trainer.training_configs.RewardConfig] = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L35"}}),Pe=new N({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),$e=new b({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[peft.config.PeftConfig] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = False"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to <code>compute_accuracy</code>) &#x2014;
The metrics to use for evaluation. If no metrics are specified, the default metric (<code>compute_accuracy</code>) will be used.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L48"}}),Oe=new N({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),De=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss or <code>&quot;hinge&quot;</code> loss from SLiC paper.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value. This argument is required if you want to use the default data collator.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L46"}}),we=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L409"}}),Ce=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ke=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Le=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L600"}}),Ne=new b({props:{name:"get_batch_metrics",anchor:"trl.DPOTrainer.get_batch_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L447"}}),ze=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L520"}}),Fe=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L649"}}),qe=new N({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Me=new b({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": typing.Optional[str] = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": typing.Optional[str] = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": typing.Optional[str] = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L12"}}),Se=new N({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),Ie=new b({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": typing.Callable[[torch.Tensor, typing.Tuple[str], typing.Tuple[typing.Any]], torch.Tensor]"},{name:"prompt_function",val:": typing.Callable[[], typing.Tuple[str, typing.Any]]"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": typing.Union[typing.Callable[[typing.Any, typing.Any, typing.Any], typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L34"}}),Ae=new b({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L311",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),Ee=new b({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),Ue=new b({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L565"}}),He=new N({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),Re=new b({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L234"}}),{c(){z=r("meta"),zt=n(),Lt=r("p"),Ft=n(),l(ne.$$.fragment),qt=n(),ae=r("p"),ae.innerHTML=La,Mt=n(),l(re.$$.fragment),St=n(),F=r("div"),l(oe.$$.fragment),$n=n(),Ve=r("p"),Ve.textContent=Na,It=n(),l(se.$$.fragment),At=n(),v=r("div"),l(ie.$$.fragment),On=n(),je=r("p"),je.innerHTML=za,Dn=n(),I=r("div"),l(le.$$.fragment),wn=n(),We=r("p"),We.textContent=Fa,Cn=n(),A=r("div"),l(de.$$.fragment),kn=n(),Be=r("p"),Be.textContent=qa,Ln=n(),E=r("div"),l(ce.$$.fragment),Nn=n(),Ke=r("p"),Ke.textContent=Ma,zn=n(),U=r("div"),l(pe.$$.fragment),Fn=n(),Ge=r("p"),Ge.textContent=Sa,qn=n(),H=r("div"),l(me.$$.fragment),Mn=n(),Ye=r("p"),Ye.innerHTML=Ia,Sn=n(),R=r("div"),l(ge.$$.fragment),In=n(),Ze=r("p"),Ze.textContent=Aa,An=n(),V=r("div"),l(he.$$.fragment),En=n(),Je=r("p"),Je.textContent=Ea,Un=n(),j=r("div"),l(_e.$$.fragment),Hn=n(),Qe=r("p"),Qe.textContent=Ua,Rn=n(),W=r("div"),l(ue.$$.fragment),Vn=n(),Xe=r("p"),Xe.textContent=Ha,jn=n(),B=r("div"),l(fe.$$.fragment),Wn=n(),et=r("p"),et.textContent=Ra,Bn=n(),K=r("div"),l(ve.$$.fragment),Kn=n(),tt=r("p"),tt.textContent=Va,Et=n(),l(be.$$.fragment),Ut=n(),D=r("div"),l(Te.$$.fragment),Gn=n(),nt=r("p"),nt.innerHTML=ja,Yn=n(),at=r("p"),at.innerHTML=Wa,Ht=n(),l(ye.$$.fragment),Rt=n(),P=r("div"),l(xe.$$.fragment),Zn=n(),rt=r("p"),rt.innerHTML=Ba,Jn=n(),ot=r("p"),ot.innerHTML=Ka,Qn=n(),st=r("ul"),st.innerHTML=Ga,Xn=n(),it=r("p"),it.innerHTML=Ya,Vt=n(),l(Pe.$$.fragment),jt=n(),q=r("div"),l($e.$$.fragment),ea=n(),lt=r("p"),lt.innerHTML=Za,Wt=n(),l(Oe.$$.fragment),Bt=n(),y=r("div"),l(De.$$.fragment),ta=n(),dt=r("p"),dt.textContent=Ja,na=n(),w=r("div"),l(we.$$.fragment),aa=n(),ct=r("p"),ct.textContent=Qa,ra=n(),pt=r("p"),pt.textContent=Xa,oa=n(),G=r("div"),l(Ce.$$.fragment),sa=n(),mt=r("p"),mt.textContent=er,ia=n(),Y=r("div"),l(ke.$$.fragment),la=n(),gt=r("p"),gt.textContent=tr,da=n(),C=r("div"),l(Le.$$.fragment),ca=n(),ht=r("p"),ht.innerHTML=nr,pa=n(),_t=r("p"),_t.textContent=ar,ma=n(),Z=r("div"),l(Ne.$$.fragment),ga=n(),ut=r("p"),ut.textContent=rr,ha=n(),J=r("div"),l(ze.$$.fragment),_a=n(),ft=r("p"),ft.textContent=or,ua=n(),Q=r("div"),l(Fe.$$.fragment),fa=n(),vt=r("p"),vt.innerHTML=sr,Kt=n(),l(qe.$$.fragment),Gt=n(),M=r("div"),l(Me.$$.fragment),va=n(),bt=r("p"),bt.textContent=ir,Yt=n(),l(Se.$$.fragment),Zt=n(),$=r("div"),l(Ie.$$.fragment),ba=n(),Tt=r("p"),Tt.innerHTML=lr,Ta=n(),X=r("div"),l(Ae.$$.fragment),ya=n(),yt=r("p"),yt.textContent=dr,xa=n(),O=r("div"),l(Ee.$$.fragment),Pa=n(),xt=r("p"),xt.textContent=cr,$a=n(),Pt=r("p"),Pt.textContent=pr,Oa=n(),$t=r("ul"),$t.innerHTML=mr,Da=n(),ee=r("div"),l(Ue.$$.fragment),wa=n(),Ot=r("p"),Ot.textContent=gr,Jt=n(),l(He.$$.fragment),Qt=n(),S=r("div"),l(Re.$$.fragment),Ca=n(),Dt=r("p"),Dt.innerHTML=hr,Xt=n(),Nt=r("p"),this.h()},l(e){const i=Tr("svelte-u9bgzb",document.head);z=o(i,"META",{name:!0,content:!0}),i.forEach(s),zt=a(e),Lt=o(e,"P",{}),u(Lt).forEach(s),Ft=a(e),d(ne.$$.fragment,e),qt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-dxrcnp"&&(ae.innerHTML=La),Mt=a(e),d(re.$$.fragment,e),St=a(e),F=o(e,"DIV",{class:!0});var tn=u(F);d(oe.$$.fragment,tn),$n=a(tn),Ve=o(tn,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-aondqr"&&(Ve.textContent=Na),tn.forEach(s),It=a(e),d(se.$$.fragment,e),At=a(e),v=o(e,"DIV",{class:!0});var T=u(v);d(ie.$$.fragment,T),On=a(T),je=o(T,"P",{"data-svelte-h":!0}),h(je)!=="svelte-hys9rl"&&(je.innerHTML=za),Dn=a(T),I=o(T,"DIV",{class:!0});var nn=u(I);d(le.$$.fragment,nn),wn=a(nn),We=o(nn,"P",{"data-svelte-h":!0}),h(We)!=="svelte-185nst0"&&(We.textContent=Fa),nn.forEach(s),Cn=a(T),A=o(T,"DIV",{class:!0});var an=u(A);d(de.$$.fragment,an),kn=a(an),Be=o(an,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-3nt516"&&(Be.textContent=qa),an.forEach(s),Ln=a(T),E=o(T,"DIV",{class:!0});var rn=u(E);d(ce.$$.fragment,rn),Nn=a(rn),Ke=o(rn,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-3jfrz9"&&(Ke.textContent=Ma),rn.forEach(s),zn=a(T),U=o(T,"DIV",{class:!0});var on=u(U);d(pe.$$.fragment,on),Fn=a(on),Ge=o(on,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-lcc1u3"&&(Ge.textContent=Sa),on.forEach(s),qn=a(T),H=o(T,"DIV",{class:!0});var sn=u(H);d(me.$$.fragment,sn),Mn=a(sn),Ye=o(sn,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-1gqqzmu"&&(Ye.innerHTML=Ia),sn.forEach(s),Sn=a(T),R=o(T,"DIV",{class:!0});var ln=u(R);d(ge.$$.fragment,ln),In=a(ln),Ze=o(ln,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-ffqz5"&&(Ze.textContent=Aa),ln.forEach(s),An=a(T),V=o(T,"DIV",{class:!0});var dn=u(V);d(he.$$.fragment,dn),En=a(dn),Je=o(dn,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-febvhf"&&(Je.textContent=Ea),dn.forEach(s),Un=a(T),j=o(T,"DIV",{class:!0});var cn=u(j);d(_e.$$.fragment,cn),Hn=a(cn),Qe=o(cn,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1hbodkw"&&(Qe.textContent=Ua),cn.forEach(s),Rn=a(T),W=o(T,"DIV",{class:!0});var pn=u(W);d(ue.$$.fragment,pn),Vn=a(pn),Xe=o(pn,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1hfgx92"&&(Xe.textContent=Ha),pn.forEach(s),jn=a(T),B=o(T,"DIV",{class:!0});var mn=u(B);d(fe.$$.fragment,mn),Wn=a(mn),et=o(mn,"P",{"data-svelte-h":!0}),h(et)!=="svelte-yrsdu6"&&(et.textContent=Ra),mn.forEach(s),Bn=a(T),K=o(T,"DIV",{class:!0});var gn=u(K);d(ve.$$.fragment,gn),Kn=a(gn),tt=o(gn,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-3k7k5e"&&(tt.textContent=Va),gn.forEach(s),T.forEach(s),Et=a(e),d(be.$$.fragment,e),Ut=a(e),D=o(e,"DIV",{class:!0});var wt=u(D);d(Te.$$.fragment,wt),Gn=a(wt),nt=o(wt,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1alpag9"&&(nt.innerHTML=ja),Yn=a(wt),at=o(wt,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1xl7jqc"&&(at.innerHTML=Wa),wt.forEach(s),Ht=a(e),d(ye.$$.fragment,e),Rt=a(e),P=o(e,"DIV",{class:!0});var k=u(P);d(xe.$$.fragment,k),Zn=a(k),rt=o(k,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-qafafj"&&(rt.innerHTML=Ba),Jn=a(k),ot=o(k,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-bkmbwh"&&(ot.innerHTML=Ka),Qn=a(k),st=o(k,"UL",{"data-svelte-h":!0}),h(st)!=="svelte-1ytuxgw"&&(st.innerHTML=Ga),Xn=a(k),it=o(k,"P",{"data-svelte-h":!0}),h(it)!=="svelte-18tbp4c"&&(it.innerHTML=Ya),k.forEach(s),Vt=a(e),d(Pe.$$.fragment,e),jt=a(e),q=o(e,"DIV",{class:!0});var hn=u(q);d($e.$$.fragment,hn),ea=a(hn),lt=o(hn,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-14oyph8"&&(lt.innerHTML=Za),hn.forEach(s),Wt=a(e),d(Oe.$$.fragment,e),Bt=a(e),y=o(e,"DIV",{class:!0});var x=u(y);d(De.$$.fragment,x),ta=a(x),dt=o(x,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-n6cc8y"&&(dt.textContent=Ja),na=a(x),w=o(x,"DIV",{class:!0});var Ct=u(w);d(we.$$.fragment,Ct),aa=a(Ct),ct=o(Ct,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-16i1nac"&&(ct.textContent=Qa),ra=a(Ct),pt=o(Ct,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-tgti68"&&(pt.textContent=Xa),Ct.forEach(s),oa=a(x),G=o(x,"DIV",{class:!0});var _n=u(G);d(Ce.$$.fragment,_n),sa=a(_n),mt=o(_n,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1cvsgkk"&&(mt.textContent=er),_n.forEach(s),ia=a(x),Y=o(x,"DIV",{class:!0});var un=u(Y);d(ke.$$.fragment,un),la=a(un),gt=o(un,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-ymgxq7"&&(gt.textContent=tr),un.forEach(s),da=a(x),C=o(x,"DIV",{class:!0});var kt=u(C);d(Le.$$.fragment,kt),ca=a(kt),ht=o(kt,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-8qlty5"&&(ht.innerHTML=nr),pa=a(kt),_t=o(kt,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-1tyo99t"&&(_t.textContent=ar),kt.forEach(s),ma=a(x),Z=o(x,"DIV",{class:!0});var fn=u(Z);d(Ne.$$.fragment,fn),ga=a(fn),ut=o(fn,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-11q8u7l"&&(ut.textContent=rr),fn.forEach(s),ha=a(x),J=o(x,"DIV",{class:!0});var vn=u(J);d(ze.$$.fragment,vn),_a=a(vn),ft=o(vn,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-18uwvbi"&&(ft.textContent=or),vn.forEach(s),ua=a(x),Q=o(x,"DIV",{class:!0});var bn=u(Q);d(Fe.$$.fragment,bn),fa=a(bn),vt=o(bn,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-nqksfz"&&(vt.innerHTML=sr),bn.forEach(s),x.forEach(s),Kt=a(e),d(qe.$$.fragment,e),Gt=a(e),M=o(e,"DIV",{class:!0});var Tn=u(M);d(Me.$$.fragment,Tn),va=a(Tn),bt=o(Tn,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-2zpx1f"&&(bt.textContent=ir),Tn.forEach(s),Yt=a(e),d(Se.$$.fragment,e),Zt=a(e),$=o(e,"DIV",{class:!0});var L=u($);d(Ie.$$.fragment,L),ba=a(L),Tt=o(L,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-8q861t"&&(Tt.innerHTML=lr),Ta=a(L),X=o(L,"DIV",{class:!0});var yn=u(X);d(Ae.$$.fragment,yn),ya=a(yn),yt=o(yn,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-1ag17u3"&&(yt.textContent=dr),yn.forEach(s),xa=a(L),O=o(L,"DIV",{class:!0});var te=u(O);d(Ee.$$.fragment,te),Pa=a(te),xt=o(te,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-r6y15n"&&(xt.textContent=cr),$a=a(te),Pt=o(te,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-imqqfp"&&(Pt.textContent=pr),Oa=a(te),$t=o(te,"UL",{"data-svelte-h":!0}),h($t)!=="svelte-105j238"&&($t.innerHTML=mr),te.forEach(s),Da=a(L),ee=o(L,"DIV",{class:!0});var xn=u(ee);d(Ue.$$.fragment,xn),wa=a(xn),Ot=o(xn,"P",{"data-svelte-h":!0}),h(Ot)!=="svelte-1an944l"&&(Ot.textContent=gr),xn.forEach(s),L.forEach(s),Jt=a(e),d(He.$$.fragment,e),Qt=a(e),S=o(e,"DIV",{class:!0});var Pn=u(S);d(Re.$$.fragment,Pn),Ca=a(Pn),Dt=o(Pn,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-1aeuhep"&&(Dt.innerHTML=hr),Pn.forEach(s),Xt=a(e),Nt=o(e,"P",{}),u(Nt).forEach(s),this.h()},h(){f(z,"name","hf:doc:metadata"),f(z,"content",xr),f(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,z),_(e,zt,i),_(e,Lt,i),_(e,Ft,i),c(ne,e,i),_(e,qt,i),_(e,ae,i),_(e,Mt,i),c(re,e,i),_(e,St,i),_(e,F,i),c(oe,F,null),t(F,$n),t(F,Ve),_(e,It,i),c(se,e,i),_(e,At,i),_(e,v,i),c(ie,v,null),t(v,On),t(v,je),t(v,Dn),t(v,I),c(le,I,null),t(I,wn),t(I,We),t(v,Cn),t(v,A),c(de,A,null),t(A,kn),t(A,Be),t(v,Ln),t(v,E),c(ce,E,null),t(E,Nn),t(E,Ke),t(v,zn),t(v,U),c(pe,U,null),t(U,Fn),t(U,Ge),t(v,qn),t(v,H),c(me,H,null),t(H,Mn),t(H,Ye),t(v,Sn),t(v,R),c(ge,R,null),t(R,In),t(R,Ze),t(v,An),t(v,V),c(he,V,null),t(V,En),t(V,Je),t(v,Un),t(v,j),c(_e,j,null),t(j,Hn),t(j,Qe),t(v,Rn),t(v,W),c(ue,W,null),t(W,Vn),t(W,Xe),t(v,jn),t(v,B),c(fe,B,null),t(B,Wn),t(B,et),t(v,Bn),t(v,K),c(ve,K,null),t(K,Kn),t(K,tt),_(e,Et,i),c(be,e,i),_(e,Ut,i),_(e,D,i),c(Te,D,null),t(D,Gn),t(D,nt),t(D,Yn),t(D,at),_(e,Ht,i),c(ye,e,i),_(e,Rt,i),_(e,P,i),c(xe,P,null),t(P,Zn),t(P,rt),t(P,Jn),t(P,ot),t(P,Qn),t(P,st),t(P,Xn),t(P,it),_(e,Vt,i),c(Pe,e,i),_(e,jt,i),_(e,q,i),c($e,q,null),t(q,ea),t(q,lt),_(e,Wt,i),c(Oe,e,i),_(e,Bt,i),_(e,y,i),c(De,y,null),t(y,ta),t(y,dt),t(y,na),t(y,w),c(we,w,null),t(w,aa),t(w,ct),t(w,ra),t(w,pt),t(y,oa),t(y,G),c(Ce,G,null),t(G,sa),t(G,mt),t(y,ia),t(y,Y),c(ke,Y,null),t(Y,la),t(Y,gt),t(y,da),t(y,C),c(Le,C,null),t(C,ca),t(C,ht),t(C,pa),t(C,_t),t(y,ma),t(y,Z),c(Ne,Z,null),t(Z,ga),t(Z,ut),t(y,ha),t(y,J),c(ze,J,null),t(J,_a),t(J,ft),t(y,ua),t(y,Q),c(Fe,Q,null),t(Q,fa),t(Q,vt),_(e,Kt,i),c(qe,e,i),_(e,Gt,i),_(e,M,i),c(Me,M,null),t(M,va),t(M,bt),_(e,Yt,i),c(Se,e,i),_(e,Zt,i),_(e,$,i),c(Ie,$,null),t($,ba),t($,Tt),t($,Ta),t($,X),c(Ae,X,null),t(X,ya),t(X,yt),t($,xa),t($,O),c(Ee,O,null),t(O,Pa),t(O,xt),t(O,$a),t(O,Pt),t(O,Oa),t(O,$t),t($,Da),t($,ee),c(Ue,ee,null),t(ee,wa),t(ee,Ot),_(e,Jt,i),c(He,e,i),_(e,Qt,i),_(e,S,i),c(Re,S,null),t(S,Ca),t(S,Dt),_(e,Xt,i),_(e,Nt,i),en=!0},p:ur,i(e){en||(p(ne.$$.fragment,e),p(re.$$.fragment,e),p(oe.$$.fragment,e),p(se.$$.fragment,e),p(ie.$$.fragment,e),p(le.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(pe.$$.fragment,e),p(me.$$.fragment,e),p(ge.$$.fragment,e),p(he.$$.fragment,e),p(_e.$$.fragment,e),p(ue.$$.fragment,e),p(fe.$$.fragment,e),p(ve.$$.fragment,e),p(be.$$.fragment,e),p(Te.$$.fragment,e),p(ye.$$.fragment,e),p(xe.$$.fragment,e),p(Pe.$$.fragment,e),p($e.$$.fragment,e),p(Oe.$$.fragment,e),p(De.$$.fragment,e),p(we.$$.fragment,e),p(Ce.$$.fragment,e),p(ke.$$.fragment,e),p(Le.$$.fragment,e),p(Ne.$$.fragment,e),p(ze.$$.fragment,e),p(Fe.$$.fragment,e),p(qe.$$.fragment,e),p(Me.$$.fragment,e),p(Se.$$.fragment,e),p(Ie.$$.fragment,e),p(Ae.$$.fragment,e),p(Ee.$$.fragment,e),p(Ue.$$.fragment,e),p(He.$$.fragment,e),p(Re.$$.fragment,e),en=!0)},o(e){m(ne.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(le.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(_e.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(ve.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m(Pe.$$.fragment,e),m($e.$$.fragment,e),m(Oe.$$.fragment,e),m(De.$$.fragment,e),m(we.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),m(Le.$$.fragment,e),m(Ne.$$.fragment,e),m(ze.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(Me.$$.fragment,e),m(Se.$$.fragment,e),m(Ie.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Re.$$.fragment,e),en=!1},d(e){e&&(s(zt),s(Lt),s(Ft),s(qt),s(ae),s(Mt),s(St),s(F),s(It),s(At),s(v),s(Et),s(Ut),s(D),s(Ht),s(Rt),s(P),s(Vt),s(jt),s(q),s(Wt),s(Bt),s(y),s(Kt),s(Gt),s(M),s(Yt),s(Zt),s($),s(Jt),s(Qt),s(S),s(Xt),s(Nt)),s(z),g(ne,e),g(re,e),g(oe),g(se,e),g(ie),g(le),g(de),g(ce),g(pe),g(me),g(ge),g(he),g(_e),g(ue),g(fe),g(ve),g(be,e),g(Te),g(ye,e),g(xe),g(Pe,e),g($e),g(Oe,e),g(De),g(we),g(Ce),g(ke),g(Le),g(Ne),g(ze),g(Fe),g(qe,e),g(Me),g(Se,e),g(Ie),g(Ae),g(Ee),g(Ue),g(He,e),g(Re)}}}const xr='{"title":"Trainer","local":"trainer","sections":[{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function Pr(ka){return fr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cr extends vr{constructor(z){super(),br(this,z,Pr,yr,_r,{})}}export{Cr as component};
