import{s as pt,n as ft,o as dt}from"../chunks/scheduler.c57aa7ef.js";import{S as mt,i as ut,g as r,s,r as p,A as ct,h as o,f as a,c as n,j as it,u as f,x as i,k as Ie,y as ht,a as l,v as d,d as m,t as u,w as c}from"../chunks/index.c50cb18e.js";import{C as h}from"../chunks/CodeBlock.34f0a53d.js";import{H as Re}from"../chunks/Heading.c7d7e0e7.js";function Mt(Xe){let M,ee,K,te,w,ae,g,Ve='PEFT’s practical benefits extends to other Hugging Face libraries like <a href="https://hf.co/docs/diffusers" rel="nofollow">Diffusers</a> and <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>. One of the main benefits of PEFT is that an adapter file generated by a PEFT method is a lot smaller than the original model, which makes it super easy to manage and use multiple adapters. You can use one pretrained base model for multiple tasks by simply loading a new adapter finetuned for the task you’re solving. Or you can combine multiple adapters with a text-to-image diffusion model to create new effects.',le,T,Ye="This tutorial will show you how PEFT can help you manage adapters in Diffusers and Transformers.",se,J,ne,Z,qe="Diffusers is a generative AI library for creating images and videos from text or images with diffusion models. LoRA is an especially popular training method for diffusion models because you can very quickly train and share diffusion models to generate images in new styles. To make it easier to use and try multiple LoRA models, Diffusers uses the PEFT library to help manage different adapters for inference.",re,_,Ee='For example, load a base model and then load the <a href="https://huggingface.co/artificialguybr/3DRedmond-V1" rel="nofollow">artificialguybr/3DRedmond-V1</a> adapter for inference with the <a href="https://huggingface.co/docs/diffusers/v0.24.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights" rel="nofollow"><code>load_lora_weights</code></a> method. The <code>adapter_name</code> argument in the loading method is enabled by PEFT and allows you to set a name for the adapter so it is easier to reference.',oe,$,ie,y,Qe='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers.png"/>',pe,j,Ne='Now let’s try another cool LoRA model, <a href="https://huggingface.co/ostris/super-cereal-sdxl-lora" rel="nofollow">ostris/super-cereal-sdxl-lora</a>. All you need to do is load and name this new adapter with <code>adapter_name</code>, and use the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters" rel="nofollow"><code>set_adapters</code></a> method to set it as the currently active adapter.',fe,U,de,b,Se='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers-2.png"/>',me,v,Pe='Finally, you can call the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora" rel="nofollow"><code>disable_lora</code></a> method to restore the base model.',ue,W,ce,k,Ae='Learn more about how PEFT supports Diffusers in the <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference" rel="nofollow">Inference with PEFT</a> tutorial.',he,C,Me,B,ze='🤗 <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a> is a collection of pretrained models for all types of tasks in all modalities. You can load these models for training or inference. Many of the models are large language models (LLMs), so it makes sense to integrate PEFT with Transformers to manage and train adapters.',ye,G,De="Load a base pretrained model to train.",be,L,we,x,Ke='Next, add an adapter configuration to specify how to adapt the model parameters. Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the configuration to the base model.',ge,F,Te,H,Oe='Now you can train the model with Transformer’s <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class or whichever training framework you prefer.',Je,I,et='To use the newly trained model for inference, the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModel" rel="nofollow">AutoModel</a> class uses PEFT on the backend to load the adapter weights and configuration file into a base pretrained model.',Ze,R,_e,X,tt='Alternatively, you can use transformers <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipelines</a> to load the model for conveniently running inference:',$e,V,je,Y,at='If you’re interested in comparing or using more than one adapter, you can call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the adapter configuration to the base model. The only requirement is the adapter type must be the same (you can’t mix a LoRA and LoHa adapter).',Ue,q,ve,E,lt='Call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> again to attach a new adapter to the base model.',We,Q,ke,N,st='Then you can use <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.set_adapter">set_adapter()</a> to set the currently active adapter.',Ce,S,Be,P,nt='To disable the adapter, call the <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L313" rel="nofollow">disable_adapters</a> method.',Ge,A,Le,z,rt='The <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L336" rel="nofollow">enable_adapters</a> can be used to enable the adapters again.',xe,D,ot='If you’re curious, check out the <a href="https://huggingface.co/docs/transformers/main/peft" rel="nofollow">Load and train adapters with PEFT</a> tutorial to learn more.',Fe,O,He;return w=new Re({props:{title:"PEFT integrations",local:"peft-integrations",headingTag:"h1"}}),J=new Re({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),$=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGYXJ0aWZpY2lhbGd1eWJyX18zRFJlZG1vbmQtVjElMjIlMkMlMjAlMEElMjAlMjAlMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMjNEUmVkbW9uZC0zRFJlbmRlclN0eWxlLTNEUmVuZGVyQUYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjIzZCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnN1c2hpJTIwcm9sbHMlMjBzaGFwZWQlMjBsaWtlJTIwa2F3YWlpJTIwY2F0JTIwZmFjZXMlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;peft-internal-testing/artificialguybr__3DRedmond-V1&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;3DRedmond-3DRenderStyle-3DRenderAF.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;3d&quot;</span>
)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),U=new h({props:{code:"cGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyb3N0cmlzJTJGc3VwZXItY2VyZWFsLXNkeGwtbG9yYSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyY2VyZWFsX2JveF9zZHhsX3YxLnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyY2VyZWFsJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjZXJlYWwlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJzdXNoaSUyMHJvbGxzJTIwc2hhcGVkJTIwbGlrZSUyMGthd2FpaSUyMGNhdCUyMGZhY2VzJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline.load_lora_weights(
    <span class="hljs-string">&quot;ostris/super-cereal-sdxl-lora&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;cereal_box_sdxl_v1.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;cereal&quot;</span>
)
pipeline.set_adapters(<span class="hljs-string">&quot;cereal&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),W=new h({props:{code:"cGlwZWxpbmUuZGlzYWJsZV9sb3JhKCk=",highlighted:"pipeline.disable_lora()",wrap:!1}}),C=new Re({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)
model.add_adapter(peft_config)`,wrap:!1}}),R=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGb3B0LTM1MG0tbG9yYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWwlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjAlMjJwZWZ0LWludGVybmFsLXRlc3RpbmclMkZvcHQtMzUwbS1sb3JhJTIyKSUwQXByaW50KG1vZGVsKCUyMkhlbGxvJTIwV29ybGQlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)
<span class="hljs-built_in">print</span>(model(<span class="hljs-string">&quot;Hello World&quot;</span>))`,wrap:!1}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZ18xJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl8xJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model.add_adapter(lora_config_1, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),Q=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWdfMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMiUyMik=",highlighted:'model.add_adapter(lora_config_2, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)',wrap:!1}}),S=new h({props:{code:"bW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),A=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygp",highlighted:"model.disable_adapters()",wrap:!1}}),{c(){M=r("meta"),ee=s(),K=r("p"),te=s(),p(w.$$.fragment),ae=s(),g=r("p"),g.innerHTML=Ve,le=s(),T=r("p"),T.textContent=Ye,se=s(),p(J.$$.fragment),ne=s(),Z=r("p"),Z.textContent=qe,re=s(),_=r("p"),_.innerHTML=Ee,oe=s(),p($.$$.fragment),ie=s(),y=r("div"),y.innerHTML=Qe,pe=s(),j=r("p"),j.innerHTML=Ne,fe=s(),p(U.$$.fragment),de=s(),b=r("div"),b.innerHTML=Se,me=s(),v=r("p"),v.innerHTML=Pe,ue=s(),p(W.$$.fragment),ce=s(),k=r("p"),k.innerHTML=Ae,he=s(),p(C.$$.fragment),Me=s(),B=r("p"),B.innerHTML=ze,ye=s(),G=r("p"),G.textContent=De,be=s(),p(L.$$.fragment),we=s(),x=r("p"),x.innerHTML=Ke,ge=s(),p(F.$$.fragment),Te=s(),H=r("p"),H.innerHTML=Oe,Je=s(),I=r("p"),I.innerHTML=et,Ze=s(),p(R.$$.fragment),_e=s(),X=r("p"),X.innerHTML=tt,$e=s(),p(V.$$.fragment),je=s(),Y=r("p"),Y.innerHTML=at,Ue=s(),p(q.$$.fragment),ve=s(),E=r("p"),E.innerHTML=lt,We=s(),p(Q.$$.fragment),ke=s(),N=r("p"),N.innerHTML=st,Ce=s(),p(S.$$.fragment),Be=s(),P=r("p"),P.innerHTML=nt,Ge=s(),p(A.$$.fragment),Le=s(),z=r("p"),z.innerHTML=rt,xe=s(),D=r("p"),D.innerHTML=ot,Fe=s(),O=r("p"),this.h()},l(e){const t=ct("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(a),ee=n(e),K=o(e,"P",{}),it(K).forEach(a),te=n(e),f(w.$$.fragment,e),ae=n(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-a6a8i"&&(g.innerHTML=Ve),le=n(e),T=o(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-4mutq9"&&(T.textContent=Ye),se=n(e),f(J.$$.fragment,e),ne=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-d4l0h1"&&(Z.textContent=qe),re=n(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-rcmzt6"&&(_.innerHTML=Ee),oe=n(e),f($.$$.fragment,e),ie=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-1cw2tql"&&(y.innerHTML=Qe),pe=n(e),j=o(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-4vggr3"&&(j.innerHTML=Ne),fe=n(e),f(U.$$.fragment,e),de=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-pvy16"&&(b.innerHTML=Se),me=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-dtlzi"&&(v.innerHTML=Pe),ue=n(e),f(W.$$.fragment,e),ce=n(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nfye23"&&(k.innerHTML=Ae),he=n(e),f(C.$$.fragment,e),Me=n(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1b1b0a9"&&(B.innerHTML=ze),ye=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-luca6i"&&(G.textContent=De),be=n(e),f(L.$$.fragment,e),we=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-ycm3gd"&&(x.innerHTML=Ke),ge=n(e),f(F.$$.fragment,e),Te=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-rsm0q6"&&(H.innerHTML=Oe),Je=n(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-11qdvon"&&(I.innerHTML=et),Ze=n(e),f(R.$$.fragment,e),_e=n(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1xfm1"&&(X.innerHTML=tt),$e=n(e),f(V.$$.fragment,e),je=n(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1vwya0n"&&(Y.innerHTML=at),Ue=n(e),f(q.$$.fragment,e),ve=n(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1pcj5p1"&&(E.innerHTML=lt),We=n(e),f(Q.$$.fragment,e),ke=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ug4ykr"&&(N.innerHTML=st),Ce=n(e),f(S.$$.fragment,e),Be=n(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-lfmda3"&&(P.innerHTML=nt),Ge=n(e),f(A.$$.fragment,e),Le=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1orofvq"&&(z.innerHTML=rt),xe=n(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1o6emrm"&&(D.innerHTML=ot),Fe=n(e),O=o(e,"P",{}),it(O).forEach(a),this.h()},h(){Ie(M,"name","hf:doc:metadata"),Ie(M,"content",yt),Ie(y,"class","flex justify-center"),Ie(b,"class","flex justify-center")},m(e,t){ht(document.head,M),l(e,ee,t),l(e,K,t),l(e,te,t),d(w,e,t),l(e,ae,t),l(e,g,t),l(e,le,t),l(e,T,t),l(e,se,t),d(J,e,t),l(e,ne,t),l(e,Z,t),l(e,re,t),l(e,_,t),l(e,oe,t),d($,e,t),l(e,ie,t),l(e,y,t),l(e,pe,t),l(e,j,t),l(e,fe,t),d(U,e,t),l(e,de,t),l(e,b,t),l(e,me,t),l(e,v,t),l(e,ue,t),d(W,e,t),l(e,ce,t),l(e,k,t),l(e,he,t),d(C,e,t),l(e,Me,t),l(e,B,t),l(e,ye,t),l(e,G,t),l(e,be,t),d(L,e,t),l(e,we,t),l(e,x,t),l(e,ge,t),d(F,e,t),l(e,Te,t),l(e,H,t),l(e,Je,t),l(e,I,t),l(e,Ze,t),d(R,e,t),l(e,_e,t),l(e,X,t),l(e,$e,t),d(V,e,t),l(e,je,t),l(e,Y,t),l(e,Ue,t),d(q,e,t),l(e,ve,t),l(e,E,t),l(e,We,t),d(Q,e,t),l(e,ke,t),l(e,N,t),l(e,Ce,t),d(S,e,t),l(e,Be,t),l(e,P,t),l(e,Ge,t),d(A,e,t),l(e,Le,t),l(e,z,t),l(e,xe,t),l(e,D,t),l(e,Fe,t),l(e,O,t),He=!0},p:ft,i(e){He||(m(w.$$.fragment,e),m(J.$$.fragment,e),m($.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(C.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(q.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),He=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u($.$$.fragment,e),u(U.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),He=!1},d(e){e&&(a(ee),a(K),a(te),a(ae),a(g),a(le),a(T),a(se),a(ne),a(Z),a(re),a(_),a(oe),a(ie),a(y),a(pe),a(j),a(fe),a(de),a(b),a(me),a(v),a(ue),a(ce),a(k),a(he),a(Me),a(B),a(ye),a(G),a(be),a(we),a(x),a(ge),a(Te),a(H),a(Je),a(I),a(Ze),a(_e),a(X),a($e),a(je),a(Y),a(Ue),a(ve),a(E),a(We),a(ke),a(N),a(Ce),a(Be),a(P),a(Ge),a(Le),a(z),a(xe),a(D),a(Fe),a(O)),a(M),c(w,e),c(J,e),c($,e),c(U,e),c(W,e),c(C,e),c(L,e),c(F,e),c(R,e),c(V,e),c(q,e),c(Q,e),c(S,e),c(A,e)}}}const yt='{"title":"PEFT integrations","local":"peft-integrations","sections":[{"title":"Diffusers","local":"diffusers","sections":[],"depth":2},{"title":"Transformers","local":"transformers","sections":[],"depth":2}],"depth":1}';function bt(Xe){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends mt{constructor(M){super(),ut(this,M,bt,Mt,pt,{})}}export{Zt as component};
