import{s as Rt,o as Zt,n as Jt}from"../chunks/scheduler.6062bdaf.js";import{S as zt,i as Vt,g as s,s as r,r as u,A as Xt,h as d,f as o,c as a,j as $,u as f,x as g,k as M,y as t,a as m,v as h,d as _,t as x,w as b}from"../chunks/index.4bca734e.js";import{T as Bt}from"../chunks/Tip.b9ac1f03.js";import{D as C}from"../chunks/Docstring.ed07512f.js";import{C as St}from"../chunks/CodeBlock.fa01571c.js";import{E as Wt}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as we}from"../chunks/Heading.723dceba.js";function Gt(ce){let p,F="It is possible to know which tasks are supported for a model for a given backend, by doing:",v,k,y;return k=new St({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBJTBBbW9kZWxfdHlwZSUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMjIlMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGZvciUyMHRoZSUyME9OTlglMjBleHBvcnQuJTBBYmFja2VuZCUyMCUzRCUyMCUyMm9ubnglMjIlMEFkaXN0aWxiZXJ0X3Rhc2tzJTIwJTNEJTIwbGlzdChUYXNrc01hbmFnZXIuZ2V0X3N1cHBvcnRlZF90YXNrc19mb3JfbW9kZWxfdHlwZShtb2RlbF90eXBlJTJDJTIwYmFja2VuZCkua2V5cygpKSUwQSUwQXByaW50KGRpc3RpbGJlcnRfdGFza3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model_type = <span class="hljs-string">&quot;distilbert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, for the ONNX export.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>backend = <span class="hljs-string">&quot;onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>distilbert_tasks = <span class="hljs-built_in">list</span>(TasksManager.get_supported_tasks_for_model_type(model_type, backend).keys())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(distilbert_tasks)
[<span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;multiple-choice&#x27;</span>, <span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;question-answering&#x27;</span>]`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,v=r(),u(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-af61zr"&&(p.textContent=F),v=a(i),f(k.$$.fragment,i)},m(i,T){m(i,p,T),m(i,v,T),h(k,i,T),y=!0},p:Jt,i(i){y||(_(k.$$.fragment,i),y=!0)},o(i){x(k.$$.fragment,i),y=!1},d(i){i&&(o(p),o(v)),b(k,i)}}}function Yt(ce){let p,F="Example:",v,k,y;return k=new St({props:{code:"cmVnaXN0ZXJfZm9yX25ld19iYWNrZW5kJTIwJTNEJTIwY3JlYXRlX3JlZ2lzdGVyKCUyMm5ldy1iYWNrZW5kJTIyKSUwQSUwQSU0MHJlZ2lzdGVyX2Zvcl9uZXdfYmFja2VuZCglMjJiZXJ0JTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWNsYXNzJTIwQmVydE5ld0JhY2tlbmRDb25maWcoTmV3QmFja2VuZENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>register_for_new_backend = create_register(<span class="hljs-string">&quot;new-backend&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@register_for_new_backend(<span class="hljs-string">&quot;bert&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">BertNewBackendConfig</span>(<span class="hljs-title class_ inherited__">NewBackendConfig</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,v=r(),u(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-11lpom8"&&(p.textContent=F),v=a(i),f(k.$$.fragment,i)},m(i,T){m(i,p,T),m(i,v,T),h(k,i,T),y=!0},p:Jt,i(i){y||(_(k.$$.fragment,i),y=!0)},o(i){x(k.$$.fragment,i),y=!1},d(i){i&&(o(p),o(v)),b(k,i)}}}function Qt(ce){let p,F,v,k,y,i,T,yt="Exporting a model from one framework to some format (also called backend here) involves specifying inputs and outputs information that the export function needs. The way <code>optimum.exporters</code> is structured for each backend is as follows:",Ce,R,vt="<li>Configuration classes containing the information for each model to perform the export.</li> <li>Exporting functions using the proper configuration for the model to export.</li>",Fe,Z,Tt='The role of the <a href="/docs/optimum/main/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a> is to be the main entry-point to load a model given a name and a task, and to get the proper configuration for a given (architecture, backend) couple. That way, there is a centralized place to register the <code>task -&gt; model class</code> and <code>(architecture, backend) -&gt; configuration</code> mappings. This allows the export functions to use this, and to rely on the various checks it provides.',Ne,z,je,V,$t="The tasks supported might depend on the backend, but here are the mappings between a task name and the auto class for both PyTorch and TensorFlow.",Pe,P,qe,X,He,B,Mt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>AutoModelForCausalLM</code></td></tr> <tr><td><code>feature-extraction</code>, <code>feature-extraction-with-past</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>AutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>AutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>AutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>AutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>AutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>AutoModelForMultipleChoice</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>AutoModelForImageClassification</code></td></tr> <tr><td><code>object-detection</code></td> <td><code>AutoModelForObjectDetection</code></td></tr> <tr><td><code>image-segmentation</code></td> <td><code>AutoModelForImageSegmentation</code></td></tr> <tr><td><code>masked-im</code></td> <td><code>AutoModelForMaskedImageModeling</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>AutoModelForSemanticSegmentation</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>AutoModelForSpeechSeq2Seq</code></td></tr></tbody>",De,W,Ie,G,wt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>TFAutoModelForCausalLM</code></td></tr> <tr><td><code>default</code>, <code>default-with-past</code></td> <td><code>TFAutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>TFAutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>TFAutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>TFAutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>TFAutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>TFAutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>TFAutoModelForMultipleChoice</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>TFAutoModelForSemanticSegmentation</code></td></tr></tbody>",Ae,Y,Le,l,Q,We,me,Ct="Handles the <code>task name -&gt; model class</code> and <code>architecture -&gt; configuration</code> mappings.",Ge,N,K,Ye,pe,Ft="Creates a register function for the specified backend.",Qe,q,Ke,w,ee,et,ge,Nt="Determines the framework to use for the export.",tt,ue,jt="The priority is in the following order:",ot,fe,Pt="<li>User input via <code>framework</code>.</li> <li>If local checkpoint is provided, use the same framework as the checkpoint.</li> <li>If model repo, try to infer the framework from the cache if available, else from the Hub.</li> <li>If could not infer, use available framework in environment, with priority given to PyTorch.</li>",rt,H,te,at,he,qt="Retrieves all the possible tasks.",nt,D,oe,st,_e,Ht="Gets the <code>ExportConfigConstructor</code> for a model (or alternatively for a model type) and task combination.",dt,I,re,it,xe,Dt="Attempts to retrieve an AutoModel class from a task name.",lt,A,ae,ct,be,It="Retrieves a model from its name and the task to be enabled.",mt,L,ne,pt,ke,At="Returns the list of supported architectures by the exporter for a given task.",gt,U,se,ut,ye,Lt="Retrieves the <code>task -&gt; exporter backend config constructors</code> map from the model type.",ft,O,de,ht,ve,Ut="Infers the library from the model repo.",_t,E,ie,xt,Te,Ot="Infers the task from the model repo.",bt,J,le,kt,$e,Et=`Updates the model for export. This function is suitable to make required changes to the models from different
libraries to follow transformers style.`,Ue,Me,Oe;return y=new we({props:{title:"The Tasks Manager",local:"the-tasks-manager",headingTag:"h1"}}),z=new we({props:{title:"Task names",local:"task-names",headingTag:"h2"}}),P=new Bt({props:{$$slots:{default:[Gt]},$$scope:{ctx:ce}}}),X=new we({props:{title:"PyTorch",local:"pytorch",headingTag:"h3"}}),W=new we({props:{title:"TensorFlow",local:"tensorflow",headingTag:"h3"}}),Y=new we({props:{title:"Reference",local:"optimum.exporters.TasksManager",headingTag:"h2"}}),Q=new C({props:{name:"class optimum.exporters.TasksManager",anchor:"optimum.exporters.TasksManager",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L138"}}),K=new C({props:{name:"create_register",anchor:"optimum.exporters.TasksManager.create_register",parameters:[{name:"backend",val:": str"},{name:"overwrite_existing",val:": bool = False"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.create_register.backend",description:`<strong>backend</strong> (<code>str</code>) &#x2014;
The name of the backend that the register function will handle.`,name:"backend"},{anchor:"optimum.exporters.TasksManager.create_register.overwrite_existing",description:`<strong>overwrite_existing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not the register function is allowed to overwrite an already existing config.`,name:"overwrite_existing"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1025",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator taking the model type and a the
supported tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable[[str, Tuple[str, ...]], Callable[[Type], Type]]</code></p>
`}}),q=new Wt({props:{anchor:"optimum.exporters.TasksManager.create_register.example",$$slots:{default:[Yt]},$$scope:{ctx:ce}}}),ee=new C({props:{name:"determine_framework",anchor:"optimum.exporters.TasksManager.determine_framework",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"framework",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.determine_framework.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.determine_framework.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.determine_framework.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See above for priority if none provided.`,name:"framework"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The framework to use for the export.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),te=new C({props:{name:"get_all_tasks",anchor:"optimum.exporters.TasksManager.get_all_tasks",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>all the possible tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`}}),oe=new C({props:{name:"get_exporter_config_constructor",anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor",parameters:[{name:"exporter",val:": str"},{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), NoneType] = None"},{name:"task",val:": str = 'feature-extraction'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"exporter_config_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The exporter to use.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model",description:`<strong>model</strong> (<code>Optional[Union[PreTrainedModel, TFPreTrainedModel]]</code>, defaults to <code>None</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;feature-extraction&quot;</code>) &#x2014;
The task to retrieve the config for.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the config for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter_config_kwargs(`Optional[Dict[str,",description:"<strong>exporter_config_kwargs(`Optional[Dict[str,</strong> Any]]<code>, defaults to </code>None`) &#x2014;\nArguments that will be passed to the exporter config class when building the config constructor.",name:"exporter_config_kwargs(`Optional[Dict[str,"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>ExportConfig</code> constructor for the requested backend.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ExportConfigConstructor</code></p>
`}}),re=new C({props:{name:"get_model_class_for_task",anchor:"optimum.exporters.TasksManager.get_model_class_for_task",parameters:[{name:"task",val:": str"},{name:"framework",val:": str = 'pt'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_class_name",val:": typing.Optional[str] = None"},{name:"library",val:": str = 'transformers'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.framework",description:`<strong>framework</strong> (<code>str</code>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The framework to use for the export.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the model class for. Some architectures need a custom class to be loaded,
and can not be loaded from auto class.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_class_name",description:`<strong>model_class_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
A model class name, allowing to override the default class that would be detected for the task. This
parameter is useful for example for &#x201C;automatic-speech-recognition&#x201D;, that may map to
AutoModelForSpeechSeq2Seq or to AutoModelForCTC.`,name:"model_class_name"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.library",description:`<strong>library</strong> (<code>str</code>, defaults to <code>transformers</code>) &#x2014;
The library name of the model.`,name:"library"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1150",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The AutoModel class corresponding to the task.</p>
`}}),ae=new C({props:{name:"get_model_from_task",anchor:"optimum.exporters.TasksManager.get_model_from_task",parameters:[{name:"task",val:": str"},{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"torch_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"device",val:": typing.Union[ForwardRef('torch.device'), str, NoneType] = None"},{name:"library_name",val:": str = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_from_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See <code>TasksManager.determine_framework</code> for the priority should
none be provided.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[torch.dtype]</code>, defaults to <code>None</code>) &#x2014;
Data type to load the model on. PyTorch-only argument.`,name:"torch_dtype"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
Device to initialize the model on. PyTorch-only argument. For PyTorch, defaults to &#x201C;cpu&#x201D;.`,name:"device"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments to pass to the model <code>.from_pretrained()</code> method.`,name:"model_kwargs"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The library name of the model. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1654",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The instance of the model.</p>
`}}),ne=new C({props:{name:"get_supported_model_type_for_task",anchor:"optimum.exporters.TasksManager.get_supported_model_type_for_task",parameters:[{name:"task",val:": str"},{name:"exporter",val:": str"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1109"}}),se=new C({props:{name:"get_supported_tasks_for_model_type",anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type",parameters:[{name:"model_type",val:": str"},{name:"exporter",val:": str"},{name:"model_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_type",description:`<strong>model_type</strong> (<code>str</code>) &#x2014;
The model type to retrieve the supported tasks for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The name of the exporter.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1073",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping each task to a corresponding <code>ExportConfig</code>
constructor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TaskNameToExportConfigDict</code></p>
`}}),de=new C({props:{name:"infer_library_from_model",anchor:"optimum.exporters.TasksManager.infer_library_from_model",parameters:[{name:"model_name_or_path",val:": str"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"library_name",val:": str = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_library_from_model.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The library name of the model.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The library name automatically detected from the model repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ie=new C({props:{name:"infer_task_from_model",anchor:"optimum.exporters.TasksManager.infer_task_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_task_from_model.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1469",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The task name automatically detected from the model repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),le=new C({props:{name:"standardize_model_attributes",anchor:"optimum.exporters.TasksManager.standardize_model_attributes",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"library_name",val:": str = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, TFPreTrainedModel]</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;:
The library name of the model.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1575"}}),{c(){p=s("meta"),F=r(),v=s("p"),k=r(),u(y.$$.fragment),i=r(),T=s("p"),T.innerHTML=yt,Ce=r(),R=s("ul"),R.innerHTML=vt,Fe=r(),Z=s("p"),Z.innerHTML=Tt,Ne=r(),u(z.$$.fragment),je=r(),V=s("p"),V.textContent=$t,Pe=r(),u(P.$$.fragment),qe=r(),u(X.$$.fragment),He=r(),B=s("table"),B.innerHTML=Mt,De=r(),u(W.$$.fragment),Ie=r(),G=s("table"),G.innerHTML=wt,Ae=r(),u(Y.$$.fragment),Le=r(),l=s("div"),u(Q.$$.fragment),We=r(),me=s("p"),me.innerHTML=Ct,Ge=r(),N=s("div"),u(K.$$.fragment),Ye=r(),pe=s("p"),pe.textContent=Ft,Qe=r(),u(q.$$.fragment),Ke=r(),w=s("div"),u(ee.$$.fragment),et=r(),ge=s("p"),ge.textContent=Nt,tt=r(),ue=s("p"),ue.textContent=jt,ot=r(),fe=s("ol"),fe.innerHTML=Pt,rt=r(),H=s("div"),u(te.$$.fragment),at=r(),he=s("p"),he.textContent=qt,nt=r(),D=s("div"),u(oe.$$.fragment),st=r(),_e=s("p"),_e.innerHTML=Ht,dt=r(),I=s("div"),u(re.$$.fragment),it=r(),xe=s("p"),xe.textContent=Dt,lt=r(),A=s("div"),u(ae.$$.fragment),ct=r(),be=s("p"),be.textContent=It,mt=r(),L=s("div"),u(ne.$$.fragment),pt=r(),ke=s("p"),ke.textContent=At,gt=r(),U=s("div"),u(se.$$.fragment),ut=r(),ye=s("p"),ye.innerHTML=Lt,ft=r(),O=s("div"),u(de.$$.fragment),ht=r(),ve=s("p"),ve.textContent=Ut,_t=r(),E=s("div"),u(ie.$$.fragment),xt=r(),Te=s("p"),Te.textContent=Ot,bt=r(),J=s("div"),u(le.$$.fragment),kt=r(),$e=s("p"),$e.textContent=Et,Ue=r(),Me=s("p"),this.h()},l(e){const n=Xt("svelte-u9bgzb",document.head);p=d(n,"META",{name:!0,content:!0}),n.forEach(o),F=a(e),v=d(e,"P",{}),$(v).forEach(o),k=a(e),f(y.$$.fragment,e),i=a(e),T=d(e,"P",{"data-svelte-h":!0}),g(T)!=="svelte-ab4qq0"&&(T.innerHTML=yt),Ce=a(e),R=d(e,"UL",{"data-svelte-h":!0}),g(R)!=="svelte-g9sbqh"&&(R.innerHTML=vt),Fe=a(e),Z=d(e,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-slwz7e"&&(Z.innerHTML=Tt),Ne=a(e),f(z.$$.fragment,e),je=a(e),V=d(e,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1bgg04"&&(V.textContent=$t),Pe=a(e),f(P.$$.fragment,e),qe=a(e),f(X.$$.fragment,e),He=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),g(B)!=="svelte-52hvyl"&&(B.innerHTML=Mt),De=a(e),f(W.$$.fragment,e),Ie=a(e),G=d(e,"TABLE",{"data-svelte-h":!0}),g(G)!=="svelte-1b4ycm7"&&(G.innerHTML=wt),Ae=a(e),f(Y.$$.fragment,e),Le=a(e),l=d(e,"DIV",{class:!0});var c=$(l);f(Q.$$.fragment,c),We=a(c),me=d(c,"P",{"data-svelte-h":!0}),g(me)!=="svelte-11ax9pk"&&(me.innerHTML=Ct),Ge=a(c),N=d(c,"DIV",{class:!0});var j=$(N);f(K.$$.fragment,j),Ye=a(j),pe=d(j,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1hg58vd"&&(pe.textContent=Ft),Qe=a(j),f(q.$$.fragment,j),j.forEach(o),Ke=a(c),w=d(c,"DIV",{class:!0});var S=$(w);f(ee.$$.fragment,S),et=a(S),ge=d(S,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-rshgf5"&&(ge.textContent=Nt),tt=a(S),ue=d(S,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-1wbth9c"&&(ue.textContent=jt),ot=a(S),fe=d(S,"OL",{"data-svelte-h":!0}),g(fe)!=="svelte-17imzut"&&(fe.innerHTML=Pt),S.forEach(o),rt=a(c),H=d(c,"DIV",{class:!0});var Ee=$(H);f(te.$$.fragment,Ee),at=a(Ee),he=d(Ee,"P",{"data-svelte-h":!0}),g(he)!=="svelte-1u59gs0"&&(he.textContent=qt),Ee.forEach(o),nt=a(c),D=d(c,"DIV",{class:!0});var Je=$(D);f(oe.$$.fragment,Je),st=a(Je),_e=d(Je,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-77ppuy"&&(_e.innerHTML=Ht),Je.forEach(o),dt=a(c),I=d(c,"DIV",{class:!0});var Se=$(I);f(re.$$.fragment,Se),it=a(Se),xe=d(Se,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-dfgadj"&&(xe.textContent=Dt),Se.forEach(o),lt=a(c),A=d(c,"DIV",{class:!0});var Re=$(A);f(ae.$$.fragment,Re),ct=a(Re),be=d(Re,"P",{"data-svelte-h":!0}),g(be)!=="svelte-xnksbg"&&(be.textContent=It),Re.forEach(o),mt=a(c),L=d(c,"DIV",{class:!0});var Ze=$(L);f(ne.$$.fragment,Ze),pt=a(Ze),ke=d(Ze,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-tg7o1w"&&(ke.textContent=At),Ze.forEach(o),gt=a(c),U=d(c,"DIV",{class:!0});var ze=$(U);f(se.$$.fragment,ze),ut=a(ze),ye=d(ze,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-h2w0ej"&&(ye.innerHTML=Lt),ze.forEach(o),ft=a(c),O=d(c,"DIV",{class:!0});var Ve=$(O);f(de.$$.fragment,Ve),ht=a(Ve),ve=d(Ve,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-gsde3z"&&(ve.textContent=Ut),Ve.forEach(o),_t=a(c),E=d(c,"DIV",{class:!0});var Xe=$(E);f(ie.$$.fragment,Xe),xt=a(Xe),Te=d(Xe,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-upyqbj"&&(Te.textContent=Ot),Xe.forEach(o),bt=a(c),J=d(c,"DIV",{class:!0});var Be=$(J);f(le.$$.fragment,Be),kt=a(Be),$e=d(Be,"P",{"data-svelte-h":!0}),g($e)!=="svelte-3l6tv0"&&($e.textContent=Et),Be.forEach(o),c.forEach(o),Ue=a(e),Me=d(e,"P",{}),$(Me).forEach(o),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",Kt),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,p),m(e,F,n),m(e,v,n),m(e,k,n),h(y,e,n),m(e,i,n),m(e,T,n),m(e,Ce,n),m(e,R,n),m(e,Fe,n),m(e,Z,n),m(e,Ne,n),h(z,e,n),m(e,je,n),m(e,V,n),m(e,Pe,n),h(P,e,n),m(e,qe,n),h(X,e,n),m(e,He,n),m(e,B,n),m(e,De,n),h(W,e,n),m(e,Ie,n),m(e,G,n),m(e,Ae,n),h(Y,e,n),m(e,Le,n),m(e,l,n),h(Q,l,null),t(l,We),t(l,me),t(l,Ge),t(l,N),h(K,N,null),t(N,Ye),t(N,pe),t(N,Qe),h(q,N,null),t(l,Ke),t(l,w),h(ee,w,null),t(w,et),t(w,ge),t(w,tt),t(w,ue),t(w,ot),t(w,fe),t(l,rt),t(l,H),h(te,H,null),t(H,at),t(H,he),t(l,nt),t(l,D),h(oe,D,null),t(D,st),t(D,_e),t(l,dt),t(l,I),h(re,I,null),t(I,it),t(I,xe),t(l,lt),t(l,A),h(ae,A,null),t(A,ct),t(A,be),t(l,mt),t(l,L),h(ne,L,null),t(L,pt),t(L,ke),t(l,gt),t(l,U),h(se,U,null),t(U,ut),t(U,ye),t(l,ft),t(l,O),h(de,O,null),t(O,ht),t(O,ve),t(l,_t),t(l,E),h(ie,E,null),t(E,xt),t(E,Te),t(l,bt),t(l,J),h(le,J,null),t(J,kt),t(J,$e),m(e,Ue,n),m(e,Me,n),Oe=!0},p(e,[n]){const c={};n&2&&(c.$$scope={dirty:n,ctx:e}),P.$set(c);const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),q.$set(j)},i(e){Oe||(_(y.$$.fragment,e),_(z.$$.fragment,e),_(P.$$.fragment,e),_(X.$$.fragment,e),_(W.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(q.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),Oe=!0)},o(e){x(y.$$.fragment,e),x(z.$$.fragment,e),x(P.$$.fragment,e),x(X.$$.fragment,e),x(W.$$.fragment,e),x(Y.$$.fragment,e),x(Q.$$.fragment,e),x(K.$$.fragment,e),x(q.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(oe.$$.fragment,e),x(re.$$.fragment,e),x(ae.$$.fragment,e),x(ne.$$.fragment,e),x(se.$$.fragment,e),x(de.$$.fragment,e),x(ie.$$.fragment,e),x(le.$$.fragment,e),Oe=!1},d(e){e&&(o(F),o(v),o(k),o(i),o(T),o(Ce),o(R),o(Fe),o(Z),o(Ne),o(je),o(V),o(Pe),o(qe),o(He),o(B),o(De),o(Ie),o(G),o(Ae),o(Le),o(l),o(Ue),o(Me)),o(p),b(y,e),b(z,e),b(P,e),b(X,e),b(W,e),b(Y,e),b(Q),b(K),b(q),b(ee),b(te),b(oe),b(re),b(ae),b(ne),b(se),b(de),b(ie),b(le)}}}const Kt='{"title":"The Tasks Manager","local":"the-tasks-manager","sections":[{"title":"Task names","local":"task-names","sections":[{"title":"PyTorch","local":"pytorch","sections":[],"depth":3},{"title":"TensorFlow","local":"tensorflow","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"optimum.exporters.TasksManager","sections":[],"depth":2}],"depth":1}';function eo(ce){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lo extends zt{constructor(p){super(),Vt(this,p,eo,Qt,Rt,{})}}export{lo as component};
