import{s as ie,o as re,n as Me}from"../chunks/scheduler.c59d9fbb.js";import{S as ce,i as ye,g as o,s as n,r,A as ue,h as m,f as s,c as a,j as me,u as M,x as p,k as pe,y as de,a as t,v as c,d as y,t as u,w as d}from"../chunks/index.a47918e3.js";import{T as be}from"../chunks/Tip.3fcf4aa4.js";import{C as h}from"../chunks/CodeBlock.936db8cd.js";import{H as Al}from"../chunks/Heading.604bc707.js";function he(sl){let i,w=`For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.`;return{c(){i=o("p"),i.textContent=w},l(b){i=m(b,"P",{"data-svelte-h":!0}),p(i)!=="svelte-7te1s3"&&(i.textContent=w)},m(b,ll){t(b,i,ll)},p:Me,d(b){b&&s(i)}}}function Je(sl){let i,w,b,ll,j,tl,T,Nl=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,nl,f,Yl='In this guide, we will see how LoRA can be applied to a multilayer perceptron and a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library.',al,k,ol,x,Xl="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",ml,g,pl,C,El="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",il,J,rl,U,Sl=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,Ml,W,cl,Z,Fl="This should print:",yl,L,ul,G,Ql=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,dl,v,bl,$,Hl="With that, we can create our PEFT model and check the fraction of parameters trained:",hl,I,Jl,_,zl="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",wl,B,Dl='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',jl,R,Tl,V,Kl=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,fl,A,ql="To start, ensure that timm is installed in the Python environment:",kl,N,xl,Y,Pl="Next we load a timm model for an image classification task:",gl,X,Cl,E,Ol=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,Ul,S,Wl,F,le="This will print a very long list, we’ll only show the first few:",Zl,Q,Ll,H,ee=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,Gl,z,se=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,vl,D,$l,K,te="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",Il,q,_l,P,ne="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",Bl,O,ae='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',Rl,el,Vl;return j=new Al({props:{title:"Working with custom models",local:"working-with-custom-models",headingTag:"h1"}}),k=new Al({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),g=new h({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),J=new be({props:{$$slots:{default:[he]},$$scope:{ctx:sl}}}),W=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),L=new h({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),I=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),R=new Al({props:{title:"timm model",local:"timm-model",headingTag:"h2"}}),N=new h({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),X=new h({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),S=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),Q=new h({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),D=new h({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),q=new h({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),{c(){i=o("meta"),w=n(),b=o("p"),ll=n(),r(j.$$.fragment),tl=n(),T=o("p"),T.innerHTML=Nl,nl=n(),f=o("p"),f.innerHTML=Yl,al=n(),r(k.$$.fragment),ol=n(),x=o("p"),x.textContent=Xl,ml=n(),r(g.$$.fragment),pl=n(),C=o("p"),C.textContent=El,il=n(),r(J.$$.fragment),rl=n(),U=o("p"),U.textContent=Sl,Ml=n(),r(W.$$.fragment),cl=n(),Z=o("p"),Z.textContent=Fl,yl=n(),r(L.$$.fragment),ul=n(),G=o("p"),G.innerHTML=Ql,dl=n(),r(v.$$.fragment),bl=n(),$=o("p"),$.textContent=Hl,hl=n(),r(I.$$.fragment),Jl=n(),_=o("p"),_.innerHTML=zl,wl=n(),B=o("p"),B.innerHTML=Dl,jl=n(),r(R.$$.fragment),Tl=n(),V=o("p"),V.innerHTML=Kl,fl=n(),A=o("p"),A.textContent=ql,kl=n(),r(N.$$.fragment),xl=n(),Y=o("p"),Y.textContent=Pl,gl=n(),r(X.$$.fragment),Cl=n(),E=o("p"),E.textContent=Ol,Ul=n(),r(S.$$.fragment),Wl=n(),F=o("p"),F.textContent=le,Zl=n(),r(Q.$$.fragment),Ll=n(),H=o("p"),H.innerHTML=ee,Gl=n(),z=o("p"),z.innerHTML=se,vl=n(),r(D.$$.fragment),$l=n(),K=o("p"),K.innerHTML=te,Il=n(),r(q.$$.fragment),_l=n(),P=o("p"),P.textContent=ne,Bl=n(),O=o("p"),O.innerHTML=ae,Rl=n(),el=o("p"),this.h()},l(l){const e=ue("svelte-u9bgzb",document.head);i=m(e,"META",{name:!0,content:!0}),e.forEach(s),w=a(l),b=m(l,"P",{}),me(b).forEach(s),ll=a(l),M(j.$$.fragment,l),tl=a(l),T=m(l,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1twj2ga"&&(T.innerHTML=Nl),nl=a(l),f=m(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1xbl0bq"&&(f.innerHTML=Yl),al=a(l),M(k.$$.fragment,l),ol=a(l),x=m(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1vzm18b"&&(x.textContent=Xl),ml=a(l),M(g.$$.fragment,l),pl=a(l),C=m(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-o052zc"&&(C.textContent=El),il=a(l),M(J.$$.fragment,l),rl=a(l),U=m(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-19hnh19"&&(U.textContent=Sl),Ml=a(l),M(W.$$.fragment,l),cl=a(l),Z=m(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-47m0b6"&&(Z.textContent=Fl),yl=a(l),M(L.$$.fragment,l),ul=a(l),G=m(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-hvbljg"&&(G.innerHTML=Ql),dl=a(l),M(v.$$.fragment,l),bl=a(l),$=m(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-12m4713"&&($.textContent=Hl),hl=a(l),M(I.$$.fragment,l),Jl=a(l),_=m(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-3iyeuu"&&(_.innerHTML=zl),wl=a(l),B=m(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-12a8po"&&(B.innerHTML=Dl),jl=a(l),M(R.$$.fragment,l),Tl=a(l),V=m(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1el2qhw"&&(V.innerHTML=Kl),fl=a(l),A=m(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-132k8n8"&&(A.textContent=ql),kl=a(l),M(N.$$.fragment,l),xl=a(l),Y=m(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1i7knza"&&(Y.textContent=Pl),gl=a(l),M(X.$$.fragment,l),Cl=a(l),E=m(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-66d7qt"&&(E.textContent=Ol),Ul=a(l),M(S.$$.fragment,l),Wl=a(l),F=m(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-132x2pj"&&(F.textContent=le),Zl=a(l),M(Q.$$.fragment,l),Ll=a(l),H=m(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-odd6w6"&&(H.innerHTML=ee),Gl=a(l),z=m(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-vtvaop"&&(z.innerHTML=se),vl=a(l),M(D.$$.fragment,l),$l=a(l),K=m(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ym7j5n"&&(K.innerHTML=te),Il=a(l),M(q.$$.fragment,l),_l=a(l),P=m(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1a6hk12"&&(P.textContent=ne),Bl=a(l),O=m(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-13ceymq"&&(O.innerHTML=ae),Rl=a(l),el=m(l,"P",{}),me(el).forEach(s),this.h()},h(){pe(i,"name","hf:doc:metadata"),pe(i,"content",we)},m(l,e){de(document.head,i),t(l,w,e),t(l,b,e),t(l,ll,e),c(j,l,e),t(l,tl,e),t(l,T,e),t(l,nl,e),t(l,f,e),t(l,al,e),c(k,l,e),t(l,ol,e),t(l,x,e),t(l,ml,e),c(g,l,e),t(l,pl,e),t(l,C,e),t(l,il,e),c(J,l,e),t(l,rl,e),t(l,U,e),t(l,Ml,e),c(W,l,e),t(l,cl,e),t(l,Z,e),t(l,yl,e),c(L,l,e),t(l,ul,e),t(l,G,e),t(l,dl,e),c(v,l,e),t(l,bl,e),t(l,$,e),t(l,hl,e),c(I,l,e),t(l,Jl,e),t(l,_,e),t(l,wl,e),t(l,B,e),t(l,jl,e),c(R,l,e),t(l,Tl,e),t(l,V,e),t(l,fl,e),t(l,A,e),t(l,kl,e),c(N,l,e),t(l,xl,e),t(l,Y,e),t(l,gl,e),c(X,l,e),t(l,Cl,e),t(l,E,e),t(l,Ul,e),c(S,l,e),t(l,Wl,e),t(l,F,e),t(l,Zl,e),c(Q,l,e),t(l,Ll,e),t(l,H,e),t(l,Gl,e),t(l,z,e),t(l,vl,e),c(D,l,e),t(l,$l,e),t(l,K,e),t(l,Il,e),c(q,l,e),t(l,_l,e),t(l,P,e),t(l,Bl,e),t(l,O,e),t(l,Rl,e),t(l,el,e),Vl=!0},p(l,[e]){const oe={};e&2&&(oe.$$scope={dirty:e,ctx:l}),J.$set(oe)},i(l){Vl||(y(j.$$.fragment,l),y(k.$$.fragment,l),y(g.$$.fragment,l),y(J.$$.fragment,l),y(W.$$.fragment,l),y(L.$$.fragment,l),y(v.$$.fragment,l),y(I.$$.fragment,l),y(R.$$.fragment,l),y(N.$$.fragment,l),y(X.$$.fragment,l),y(S.$$.fragment,l),y(Q.$$.fragment,l),y(D.$$.fragment,l),y(q.$$.fragment,l),Vl=!0)},o(l){u(j.$$.fragment,l),u(k.$$.fragment,l),u(g.$$.fragment,l),u(J.$$.fragment,l),u(W.$$.fragment,l),u(L.$$.fragment,l),u(v.$$.fragment,l),u(I.$$.fragment,l),u(R.$$.fragment,l),u(N.$$.fragment,l),u(X.$$.fragment,l),u(S.$$.fragment,l),u(Q.$$.fragment,l),u(D.$$.fragment,l),u(q.$$.fragment,l),Vl=!1},d(l){l&&(s(w),s(b),s(ll),s(tl),s(T),s(nl),s(f),s(al),s(ol),s(x),s(ml),s(pl),s(C),s(il),s(rl),s(U),s(Ml),s(cl),s(Z),s(yl),s(ul),s(G),s(dl),s(bl),s($),s(hl),s(Jl),s(_),s(wl),s(B),s(jl),s(Tl),s(V),s(fl),s(A),s(kl),s(xl),s(Y),s(gl),s(Cl),s(E),s(Ul),s(Wl),s(F),s(Zl),s(Ll),s(H),s(Gl),s(z),s(vl),s($l),s(K),s(Il),s(_l),s(P),s(Bl),s(O),s(Rl),s(el)),s(i),d(j,l),d(k,l),d(g,l),d(J,l),d(W,l),d(L,l),d(v,l),d(I,l),d(R,l),d(N,l),d(X,l),d(S,l),d(Q,l),d(D,l),d(q,l)}}}const we='{"title":"Working with custom models","local":"working-with-custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm model","local":"timm-model","sections":[],"depth":2}],"depth":1}';function je(sl){return re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends ce{constructor(i){super(),ye(this,i,je,Je,ie,{})}}export{Ce as component};
