import{s as xs,o as Zs,n as tt}from"../chunks/scheduler.69131cc3.js";import{S as Is,i as Ws,g as i,s as a,r as m,A as Bs,h as p,f as l,c as n,j as Cs,u as c,x as r,k as Gs,y as qs,a as s,v as h,d as f,t as u,w as y}from"../chunks/index.e1f30d73.js";import{T as et}from"../chunks/Tip.22e79575.js";import{Y as Ps}from"../chunks/Youtube.b682de5d.js";import{C as $}from"../chunks/CodeBlock.30cef355.js";import{H as v}from"../chunks/Heading.0aab6758.js";function Rs(b){let o,M="This API is quite new and still in its experimental stage. While we strive to provide a stable API, it’s possible some small parts of the public API will change in the future.";return{c(){o=i("p"),o.textContent=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1yc3yd7"&&(o.textContent=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function zs(b){let o,M="You can’t move a model initialized like this on CPU or another device directly, since it doesn’t have any data. It’s also very likely that a forward pass with that empty model will fail, as not all operations are supported on the meta device.";return{c(){o=i("p"),o.textContent=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-vdgsa6"&&(o.textContent=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function Qs(b){let o,M="This only supports the inference of your model, not training. Most of the computation happens behind <code>torch.no_grad()</code> context managers to avoid spending some GPU memory with intermediate activations.";return{c(){o=i("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1a0gshx"&&(o.innerHTML=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function As(b){let o,M="You can derive all sizes of the model (and thus compute a <code>device_map</code>) on a model that is on the meta device.";return{c(){o=i("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1r7jnyr"&&(o.innerHTML=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function Xs(b){let o,M="The options <code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> produce the same results for now, but the behavior of <code>&quot;auto&quot;</code> might change in the future if we find a strategy that makes more sense, while <code>&quot;balanced&quot;</code> will stay stable.";return{c(){o=i("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-vyehzb"&&(o.innerHTML=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function Es(b){let o,M="When a first allocation happens in PyTorch, it loads CUDA kernels which take about 1-2GB of memory depending on the GPU. Therefore you always have less usable memory than the actual size of the GPU. To see how much memory is actually used do <code>torch.ones(1).cuda()</code> and look at the memory usage.",d,w,U="Therefore when you create memory maps with <code>max_memory</code> make sure to adjust the available memory accordingly to avoid out-of-memory errors.";return{c(){o=i("p"),o.innerHTML=M,d=a(),w=i("p"),w.innerHTML=U},l(g){o=p(g,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1l1ovnr"&&(o.innerHTML=M),d=n(g),w=p(g,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1sybea"&&(w.innerHTML=U)},m(g,_){s(g,o,_),s(g,d,_),s(g,w,_)},p:tt,d(g){g&&(l(o),l(d),l(w))}}}function Hs(b){let o,M="To be the most efficient, make sure your device map puts the parameters on the GPUs in a sequential manner (e.g. don’t put one of the first weights on GPU 0, then weights on GPU 1 and the last weight back to GPU 0) to avoid making many transfers of data between the GPUs.";return{c(){o=i("p"),o.textContent=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1j5mha8"&&(o.textContent=M)},m(d,w){s(d,o,w)},p:tt,d(d){d&&l(o)}}}function Ls(b){let o,M,d,w,U,g,_,Wl="When loading a pre-trained model in PyTorch, the usual workflow looks like this:",st,Z,at,I,Bl="In plain English, those steps are:",nt,W,ql="<li>Create the model with randomly initialized weights</li> <li>Load the model weights (in a dictionary usually called a state dict) from the disk</li> <li>Load those weights inside the model</li>",ot,B,Pl="While this works very well for regularly sized models, this workflow has some clear limitations when we deal with a huge model: in step 1, we load a full version of the model in RAM, and spend some time randomly initializing the weights (which will be discarded in step 3). In step 2, we load another full version of the model in RAM, with the pre-trained weights. If you’re loading a model with 6 billion parameters, this means you will need 24GB of RAM for each copy of the model, so 48GB in total (half of it to load the model in FP16).",it,j,pt,q,rt,P,dt,R,mt,z,ct,Q,Rl='The first tool 🤗 Accelerate introduces to help with big models is a context manager <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> that helps you initialize a model without using any RAM so that step 1 can be done on models of any size. Here is how it works:',ht,A,ft,X,zl="For instance:",ut,E,yt,H,Ql="initializes an empty model with a bit more than 100B parameters. Behind the scenes, this relies on the meta device introduced in PyTorch 1.9. During the initialization under the context manager, each time a parameter is created, it is instantly moved to that device.",Mt,k,wt,L,$t,N,Al="It’s possible your model is so big that even a single copy won’t fit in RAM. That doesn’t mean it can’t be loaded: if you have one or several GPUs, this is more memory available to store your model. In this case, it’s better if your checkpoint is split into several smaller files that we call checkpoint shards.",bt,Y,Xl='🤗 Accelerate will handle sharded checkpoints as long as you follow the following format: your checkpoint should be in a folder, with several files containing the partial state dicts, and there should be an index in the JSON format that contains a dictionary mapping parameter names to the file containing their weights. You can easily shard your model with <a href="/docs/accelerate/v0.26.0/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>. For instance, we could have a folder containing:',gt,S,vt,V,El="with index.json being the following file:",_t,F,Ut,D,Hl="and <code>first_state_dict.bin</code> containing the weights for <code>&quot;linear1.weight&quot;</code> and <code>&quot;linear1.bias&quot;</code>, <code>second_state_dict.bin</code> the ones for <code>&quot;linear2.weight&quot;</code> and <code>&quot;linear2.bias&quot;</code>",jt,K,kt,O,Ll='The second tool 🤗 Accelerate introduces is a function <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, that will allow you to load a checkpoint inside your empty model. This supports full checkpoints (a single file containing the whole state dict) as well as sharded checkpoints. It will also automatically dispatch those weights across the devices you have available (GPUs, CPU RAM), so if you are loading a sharded checkpoint, the maximum RAM usage will be the size of the biggest shard.',Tt,ee,Nl='If you want to use big model inference with 🤗 Transformers models, check out this <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#large-model-loading" rel="nofollow">documentation</a>.',Jt,te,Yl='Here is how we can use this to load the <a href="https://huggingface.co/marcsun13/gpt2-xl-linear-sharded" rel="nofollow">GPT2-1.5B</a> model.',Ct,le,Sl="Let’s download the sharded version of this model.",Gt,se,xt,ae,Zt,ne,Vl="In order to initialize the model, we will use the library minGPT.",It,oe,Wt,ie,Bt,pe,Fl="Then, load the checkpoint we just downloaded with:",qt,re,Pt,de,Dl="By passing <code>device_map=&quot;auto&quot;</code>, we tell 🤗 Accelerate to determine automatically where to put each layer of the model depending on the available resources:",Rt,me,Kl="<li>first, we use the maximum space available on the GPU(s)</li> <li>if we still need space, we store the remaining weights on the CPU</li> <li>if there is not enough RAM, we store the remaining weights on the hard drive as memory-mapped tensors</li>",zt,ce,Qt,he,Ol=`This parameter will indicate that some of the modules with the name <code>&quot;Block&quot;</code> should not be split across different devices. You should set here all blocks that
include a residual connection of some kind.`,At,fe,Xt,ue,es="You can see the <code>device_map</code> that 🤗 Accelerate picked by accessing the <code>hf_device_map</code> attribute of your model:",Et,ye,Ht,Me,Lt,we,ts="It’s fully possible to create your own device map for the layers to use as well, specifying the GPU device to use (a number), <code>&quot;cpu&quot;</code>, or <code>&quot;disk&quot;</code> and pass this in:",Nt,$e,Yt,be,St,ge,ls="Now that we have done this, our model lies across several devices, and maybe the hard drive. But it can still be used as a regular PyTorch model:",Vt,ve,Ft,_e,ss="Behind the scenes, 🤗 Accelerate added hooks to the model, so that:",Dt,Ue,as="<li>at each layer, the inputs are put on the right device (so even if your model is spread across several GPUs, it works)</li> <li>for the weights offloaded on the CPU, they are put on a GPU just before the forward pass and cleaned up just after</li> <li>for the weights offloaded on the hard drive, they are loaded in RAM then put on a GPU just before the forward pass and cleaned up just after</li>",Kt,je,ns="This way, your model can run for inference even if it doesn’t fit on one of the GPUs or the CPU RAM!",Ot,T,el,ke,tl,Te,os="You can let 🤗 Accelerate handle the device map computation by setting <code>device_map</code> to one of the supported options (<code>&quot;auto&quot;</code>, <code>&quot;balanced&quot;</code>, <code>&quot;balanced_low_0&quot;</code>, <code>&quot;sequential&quot;</code>) or create one yourself if you want more control over where each layer should go.",ll,J,sl,Je,is="All the options will produce the same result when you don’t have enough GPU memory to accommodate the whole model (which is to fit everything that can on the GPU, then offload weights on the CPU or even on the disk if there is not enough RAM).",al,Ce,ps="When you have more GPU memory available than the model size, here is the difference between each option:",nl,Ge,rs="<li><code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> evenly split the model on all available GPUs, making it possible for you to use a batch size greater than 1.</li> <li><code>&quot;balanced_low_0&quot;</code> evenly splits the model on all GPUs except the first one, and only puts on GPU 0 what does not fit on the others. This option is great when you need to use GPU 0 for some processing of the outputs, like when using the <code>generate</code> function for Transformers models</li> <li><code>&quot;sequential&quot;</code> will fit what it can on GPU 0, then move on GPU 1 and so forth (so won’t use the last GPUs if it doesn’t need to).</li>",ol,C,il,xe,ds='First note that you can limit the memory used on each GPU by using the <code>max_memory</code> argument (available in <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> and in all functions using it). When setting <code>max_memory</code>, you should pass along a dictionary containing the GPU identifiers (for instance <code>0</code>, <code>1</code> etc.) and the <code>&quot;cpu&quot;</code> key for the maximum RAM you want to use for CPU offload. The values can either be an integer (in bytes) or a string representing a number with its unit, such as <code>&quot;10GiB&quot;</code> or <code>&quot;10GB&quot;</code>.',pl,Ze,ms="Here is an example where we don’t want to use more than 10GiB on each of the two GPUs and no more than 30GiB of CPU RAM for the model weights:",rl,Ie,dl,G,ml,We,cs="Additionally, if you do some additional operations with your outputs without placing them back on the CPU (for instance inside the <code>generate</code> method of Transformers) and if you placed your inputs on a GPU, that GPU will consume more memory than the others (Accelerate always place the output back to the device of the input). Therefore if you would like to optimize the maximum batch size and you have many GPUs, give the first GPU less memory. For example, with BLOOM-176B on 8x80 A100 setup, the close-to-ideal map is:",cl,Be,hl,qe,hs="as you can see we gave the remaining 7 GPUs ~50% more memory than GPU 0.",fl,Pe,fs="If you opt to fully design the <code>device_map</code> yourself, it should be a dictionary with keys being module names of your model and values being a valid device identifier (for instance an integer for the GPUs) or <code>&quot;cpu&quot;</code> for CPU offload, <code>&quot;disk&quot;</code> for disk offload. The keys need to cover the whole model, you can then define your device map as you wish: for instance, if your model has two blocks (let’s say <code>block1</code> and <code>block2</code>) which each contain three linear layers (let’s say <code>linear1</code>, <code>linear2</code> and <code>linear3</code>), a valid device map can be:",ul,Re,yl,ze,us="another one that is valid could be:",Ml,Qe,wl,Ae,ys="On the other hand, this one is not valid as it does not cover every parameter of the model:",$l,Xe,bl,x,gl,Ee,vl,He,Ms='If you want to offload your model on CPU, you can use <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a>. As a result, all parameters of the model will be offloaded and only one copy of the state dict of the model will be kept. During the forward pass, parameters will be extracted from that state dict and put on the execution device and passed as they are needed, then offloaded again.',_l,Le,Ul,Ne,ws='You can also use <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.cpu_offload_with_hook">cpu_offload_with_hook()</a>. This function will offloads a model on the CPU and puts it back to an execution device when executed. The difference with <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a> is that the model stays on the execution device after the forward and is only offloaded again when the <code>offload</code> method of the returned <code>hook</code> is called. Furthermore, <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.cpu_offload_with_hook">cpu_offload_with_hook()</a> is more performant but less memory saving. It is useful for pipelines running a model in a loop:',jl,Ye,kl,Se,Tl,Ve,$s='To perform disk offload, you can use <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.disk_offload">disk_offload()</a>. As a result, all parameters of the model will be offloaded as memory-mapped array in a given folder. During the forward pass, parameters will be accessed from that folder and put on the execution device passed as they are needed, then offloaded again.',Jl,Fe,Cl,De,Gl,Ke,bs="We are aware of the current limitations in the API:",xl,Oe,gs='<li><a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) tries to maximize GPU and CPU RAM it sees available when you execute it. While PyTorch is very good at managing GPU RAM efficiently (and giving it back when not needed), it’s not entirely true with Python and CPU RAM. Therefore, an automatically computed device map might be too intense on the CPU. Move a few modules to the disk device if you get crashes due to a lack of RAM.</li> <li><a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) attributes devices sequentially (to avoid moving things back and forth) so if your first layer is bigger than the size of the GPU you have, it will end up with everything on the CPU/Disk.</li> <li><a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> and <a href="/docs/accelerate/v0.26.0/en/package_reference/big_modeling#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> do not perform any check on the correctness of your state dict compared to your model at the moment (this will be fixed in a future version), so you may get some weird errors if trying to load a checkpoint with mismatched or missing keys.</li> <li>The model parallelism used when your model is split on several GPUs is naive and not optimized, meaning that only one GPU works at a given time and the other sits idle.</li> <li>When weights are offloaded on the CPU/hard drive, there is no pre-fetching (yet, we will work on this for future versions) which means the weights are put on the GPU when they are needed and not before.</li> <li>Hard-drive offloading might be very slow if the hardware you run on does not have fast communication between disk and CPU (like NVMes).</li>',Zl,lt,Il;return U=new v({props:{title:"Handling big models for inference",local:"handling-big-models-for-inference",headingTag:"h1"}}),Z=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKSUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKGNoZWNrcG9pbnRfZmlsZSklMEFteV9tb2RlbC5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

my_model = ModelClass(...)
state_dict = torch.load(checkpoint_file)
my_model.load_state_dict(state_dict)`,wrap:!1}}),j=new et({props:{warning:!0,$$slots:{default:[Rs]},$$scope:{ctx:b}}}),q=new v({props:{title:"How the Process Works: A Quick Overview",local:"how-the-process-works-a-quick-overview",headingTag:"h2"}}),P=new Ps({props:{id:"MWCSGj9jEAo"}}),R=new v({props:{title:"How the Process Works: Working with Code",local:"how-the-process-works-working-with-code",headingTag:"h2"}}),z=new v({props:{title:"Instantiating an empty model",local:"instantiating-an-empty-model",headingTag:"h3"}}),A=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEElMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights

<span class="hljs-keyword">with</span> init_empty_weights():
    my_model = ModelClass(...)`,wrap:!1}}),E=new $({props:{code:"d2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKColNUJubi5MaW5lYXIoMTAwMDAlMkMlMjAxMDAwMCklMjBmb3IlMjBfJTIwaW4lMjByYW5nZSgxMDAwKSU1RCk=",highlighted:`<span class="hljs-keyword">with</span> init_empty_weights():
    model = nn.Sequential(*[nn.Linear(<span class="hljs-number">10000</span>, <span class="hljs-number">10000</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)])`,wrap:!1}}),k=new et({props:{warning:!0,$$slots:{default:[zs]},$$scope:{ctx:b}}}),L=new v({props:{title:"Sharded checkpoints",local:"sharded-checkpoints",headingTag:"h3"}}),S=new $({props:{code:"Zmlyc3Rfc3RhdGVfZGljdC5iaW4lMEFpbmRleC5qc29uJTBBc2Vjb25kX3N0YXRlX2RpY3QuYmlu",highlighted:`first_state_dict.bin
index.json
second_state_dict.bin`,wrap:!1}}),F=new $({props:{code:"JTdCJTBBJTIwJTIwJTIybGluZWFyMS53ZWlnaHQlMjIlM0ElMjAlMjJmaXJzdF9zdGF0ZV9kaWN0LmJpbiUyMiUyQyUwQSUyMCUyMCUyMmxpbmVhcjEuYmlhcyUyMiUzQSUyMCUyMmZpcnN0X3N0YXRlX2RpY3QuYmluJTIyJTJDJTBBJTIwJTIwJTIybGluZWFyMi53ZWlnaHQlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMkMlMEElMjAlMjAlMjJsaW5lYXIyLmJpYXMlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;linear1.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear1.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new v({props:{title:"Loading weights",local:"loading-weights",headingTag:"h3"}}),se=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),ae=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1hcmNzdW4xMyUyRmdwdDIteGwtbGluZWFyLXNoYXJkZWQlMjIlMEF3ZWlnaHRzX2xvY2F0aW9uJTIwJTNEJTIwc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRGNoZWNrcG9pbnQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
checkpoint = <span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>
weights_location = snapshot_download(repo_id=checkpoint)`,wrap:!1}}),oe=new $({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJG",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/`,wrap:!1}}),ie=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    model = GPT(model_config)`,wrap:!1}}),re=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG5vX3NwbGl0X21vZHVsZV9jbGFzc2VzJTNEJTVCJ0Jsb2NrJyU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),ce=new v({props:{title:"no_split_module_classes",local:"nosplitmoduleclasses",headingTag:"h4"}}),fe=new v({props:{title:"The device_map",local:"the-devicemap",headingTag:"h4"}}),ye=new $({props:{code:"bW9kZWwuaGZfZGV2aWNlX21hcA==",highlighted:"model.hf_device_map",wrap:!1}}),Me=new $({props:{code:"JTdCJ3RyYW5zZm9ybWVyLnd0ZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLndwZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLmRyb3AnJTNBJTIwMCUyQyUwQSUyMCd0cmFuc2Zvcm1lci5oLjAnJTNBJTIwMCUyQyUwQSUyMC4uLiUwQSUyMCd0cmFuc2Zvcm1lci5oLjIxJyUzQSUyMDAlMkMlMjAlMEElMjAndHJhbnNmb3JtZXIuaC4yMiclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmguMjMnJTNBJTIwMSUyQyUyMCUwQSUyMCd0cmFuc2Zvcm1lci5oLjI0JyUzQSUyMDElMkMlMEElMjAuLi4lMEElMjAndHJhbnNmb3JtZXIuaC40NyclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmxuX2YnJTNBJTIwMSUyQyUyMCUwQSUyMCdsbV9oZWFkJyUzQSUyMDElN0Q=",highlighted:`{<span class="hljs-string">&#x27;transformer.wte&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.wpe&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.drop&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.h.0&#x27;</span>: <span class="hljs-number">0</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.21&#x27;</span>: <span class="hljs-number">0</span>, 
 <span class="hljs-string">&#x27;transformer.h.22&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.23&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.24&#x27;</span>: <span class="hljs-number">1</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.47&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.ln_f&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;lm_head&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),$e=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndwZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5kcm9wJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuaC4wJTIyJTNBJTIwJTIyZGlzayUyMiUwQSU3RCUwQSUwQW1vZGVsJTIwJTNEJTIwbG9hZF9jaGVja3BvaW50X2FuZF9kaXNwYXRjaCglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMGNoZWNrcG9pbnQlM0R3ZWlnaHRzX2xvY2F0aW9uJTJDJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMEEpJTBB",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h.0&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>
}

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=device_map
)
`,wrap:!1}}),be=new v({props:{title:"Run the model",local:"run-the-model",headingTag:"h3"}}),ve=new $({props:{code:"ZnJvbSUyMG1pbmdwdC5icGUlMjBpbXBvcnQlMjBCUEVUb2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBCUEVUb2tlbml6ZXIoKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyKS50bygwKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSh4MSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklNUIwJTVEJTBBdG9rZW5pemVyLmRlY29kZShvdXRwdXRzLmNwdSgpLnNxdWVlemUoKSk=",highlighted:`<span class="hljs-keyword">from</span> mingpt.bpe <span class="hljs-keyword">import</span> BPETokenizer
tokenizer = BPETokenizer()
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>).to(<span class="hljs-number">0</span>)

outputs = model.generate(x1, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
tokenizer.decode(outputs.cpu().squeeze())`,wrap:!1}}),T=new et({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:b}}}),ke=new v({props:{title:"Designing a device map",local:"designing-a-device-map",headingTag:"h3"}}),J=new et({props:{$$slots:{default:[As]},$$scope:{ctx:b}}}),C=new et({props:{$$slots:{default:[Xs]},$$scope:{ctx:b}}}),Ie=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbmZlcl9hdXRvX2RldmljZV9tYXAlMEElMEFkZXZpY2VfbWFwJTIwJTNEJTIwaW5mZXJfYXV0b19kZXZpY2VfbWFwKG15X21vZGVsJTJDJTIwbWF4X21lbW9yeSUzRCU3QjAlM0ElMjAlMjIxMEdpQiUyMiUyQyUyMDElM0ElMjAlMjIxMEdpQiUyMiUyQyUyMCUyMmNwdSUyMiUzQSUyMCUyMjMwR2lCJTIyJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> infer_auto_device_map

device_map = infer_auto_device_map(my_model, max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-string">&quot;cpu&quot;</span>: <span class="hljs-string">&quot;30GiB&quot;</span>})`,wrap:!1}}),G=new et({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:b}}}),Be=new $({props:{code:"bWF4X21lbW9yeSUyMCUzRCUyMCU3QjAlM0ElMjAlMjIzMEdJQiUyMiUyQyUyMDElM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDIlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDMlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDQlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDUlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDYlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDclM0ElMjAlMjI0NkdJQiUyMiU3RA==",highlighted:'max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;30GIB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">4</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">5</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">6</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">7</span>: <span class="hljs-string">&quot;46GIB&quot;</span>}',wrap:!1}}),Re=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIlMjIlM0ElMjAxJTdE",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Qe=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMyUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear3&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Xe=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),x=new et({props:{$$slots:{default:[Hs]},$$scope:{ctx:b}}}),Ee=new v({props:{title:"CPU offload only",local:"cpu-offload-only",headingTag:"h2"}}),Le=new $({props:{code:"Y3B1X29mZmxvYWQobW9kZWwlMkMlMjBleGVjdXRpb25fZGV2aWNlKQ==",highlighted:"cpu_offload(model, execution_device)",wrap:!1}}),Ye=new $({props:{code:"bW9kZWxfMSUyQyUyMGhvb2tfMSUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8xJTJDJTIwZXhlY3V0aW9uX2RldmljZSklMEFtb2RlbF8yJTJDJTIwaG9va18yJTIwJTNEJTIwY3B1X29mZmxvYWRfd2l0aF9ob29rKG1vZGVsXzIlMkMlMjBleGVjdXRpb25fZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMSklMEFtb2RlbF8zJTJDJTIwaG9va18zJTIwJTNEJTIwY3B1X29mZmxvYWRfd2l0aF9ob29rKG1vZGVsXzMlMkMlMjBleGVjdXRpb25fZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMiklMEElMEFoaWRfMSUyMCUzRCUyMG1vZGVsXzEoaW5wdXQpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNTApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWwxJTIwaXMlMjBvZmZsb2FkZWQlMjBvbiUyMHRoZSUyMENQVSUyMGF0JTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBtb2RlbCUyMDIlMjBzdGF5cyUyMG9uJTIwdGhlJTIwR1BVJTIwZm9yJTIwdGhpcyUyMHdob2xlJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBoaWRfMiUyMCUzRCUyMG1vZGVsXzIoaGlkXzEpJTBBJTIzJTIwbW9kZWwyJTIwaXMlMjBvZmZsb2FkZWQlMjB0byUyMHRoZSUyMENQVSUyMGp1c3QlMjBiZWZvcmUlMjB0aGlzJTIwZm9yd2FyZC4lMEFoaWRfMyUyMCUzRCUyMG1vZGVsXzMoaGlkXzMpJTBBJTBBJTIzJTIwRm9yJTIwbW9kZWwzJTJDJTIweW91JTIwbmVlZCUyMHRvJTIwbWFudWFsbHklMjBjYWxsJTIwdGhlJTIwaG9vayUyMG9mZmxvYWQlMjBtZXRob2QuJTBBaG9va18zLm9mZmxvYWQoKQ==",highlighted:`model_1, hook_1 = cpu_offload_with_hook(model_1, execution_device)
model_2, hook_2 = cpu_offload_with_hook(model_2, execution_device, prev_module_hook=hook_1)
model_3, hook_3 = cpu_offload_with_hook(model_3, execution_device, prev_module_hook=hook_2)

hid_1 = model_1(<span class="hljs-built_in">input</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>):
    <span class="hljs-comment"># model1 is offloaded on the CPU at the first iteration, model 2 stays on the GPU for this whole loop.</span>
    hid_2 = model_2(hid_1)
<span class="hljs-comment"># model2 is offloaded to the CPU just before this forward.</span>
hid_3 = model_3(hid_3)

<span class="hljs-comment"># For model3, you need to manually call the hook offload method.</span>
hook_3.offload()`,wrap:!1}}),Se=new v({props:{title:"Disk offload only",local:"disk-offload-only",headingTag:"h2"}}),Fe=new $({props:{code:"ZGlza19vZmZsb2FkKG1vZGVsJTJDJTIwb2ZmbG9hZF9kaXIlMkMlMjBleGVjdXRpb25fZGV2aWNlKQ==",highlighted:"disk_offload(model, offload_dir, execution_device)",wrap:!1}}),De=new v({props:{title:"Limits and further development",local:"limits-and-further-development",headingTag:"h2"}}),{c(){o=i("meta"),M=a(),d=i("p"),w=a(),m(U.$$.fragment),g=a(),_=i("p"),_.textContent=Wl,st=a(),m(Z.$$.fragment),at=a(),I=i("p"),I.textContent=Bl,nt=a(),W=i("ol"),W.innerHTML=ql,ot=a(),B=i("p"),B.textContent=Pl,it=a(),m(j.$$.fragment),pt=a(),m(q.$$.fragment),rt=a(),m(P.$$.fragment),dt=a(),m(R.$$.fragment),mt=a(),m(z.$$.fragment),ct=a(),Q=i("p"),Q.innerHTML=Rl,ht=a(),m(A.$$.fragment),ft=a(),X=i("p"),X.textContent=zl,ut=a(),m(E.$$.fragment),yt=a(),H=i("p"),H.textContent=Ql,Mt=a(),m(k.$$.fragment),wt=a(),m(L.$$.fragment),$t=a(),N=i("p"),N.textContent=Al,bt=a(),Y=i("p"),Y.innerHTML=Xl,gt=a(),m(S.$$.fragment),vt=a(),V=i("p"),V.textContent=El,_t=a(),m(F.$$.fragment),Ut=a(),D=i("p"),D.innerHTML=Hl,jt=a(),m(K.$$.fragment),kt=a(),O=i("p"),O.innerHTML=Ll,Tt=a(),ee=i("p"),ee.innerHTML=Nl,Jt=a(),te=i("p"),te.innerHTML=Yl,Ct=a(),le=i("p"),le.textContent=Sl,Gt=a(),m(se.$$.fragment),xt=a(),m(ae.$$.fragment),Zt=a(),ne=i("p"),ne.textContent=Vl,It=a(),m(oe.$$.fragment),Wt=a(),m(ie.$$.fragment),Bt=a(),pe=i("p"),pe.textContent=Fl,qt=a(),m(re.$$.fragment),Pt=a(),de=i("p"),de.innerHTML=Dl,Rt=a(),me=i("ul"),me.innerHTML=Kl,zt=a(),m(ce.$$.fragment),Qt=a(),he=i("p"),he.innerHTML=Ol,At=a(),m(fe.$$.fragment),Xt=a(),ue=i("p"),ue.innerHTML=es,Et=a(),m(ye.$$.fragment),Ht=a(),m(Me.$$.fragment),Lt=a(),we=i("p"),we.innerHTML=ts,Nt=a(),m($e.$$.fragment),Yt=a(),m(be.$$.fragment),St=a(),ge=i("p"),ge.textContent=ls,Vt=a(),m(ve.$$.fragment),Ft=a(),_e=i("p"),_e.textContent=ss,Dt=a(),Ue=i("ul"),Ue.innerHTML=as,Kt=a(),je=i("p"),je.textContent=ns,Ot=a(),m(T.$$.fragment),el=a(),m(ke.$$.fragment),tl=a(),Te=i("p"),Te.innerHTML=os,ll=a(),m(J.$$.fragment),sl=a(),Je=i("p"),Je.textContent=is,al=a(),Ce=i("p"),Ce.textContent=ps,nl=a(),Ge=i("ul"),Ge.innerHTML=rs,ol=a(),m(C.$$.fragment),il=a(),xe=i("p"),xe.innerHTML=ds,pl=a(),Ze=i("p"),Ze.textContent=ms,rl=a(),m(Ie.$$.fragment),dl=a(),m(G.$$.fragment),ml=a(),We=i("p"),We.innerHTML=cs,cl=a(),m(Be.$$.fragment),hl=a(),qe=i("p"),qe.textContent=hs,fl=a(),Pe=i("p"),Pe.innerHTML=fs,ul=a(),m(Re.$$.fragment),yl=a(),ze=i("p"),ze.textContent=us,Ml=a(),m(Qe.$$.fragment),wl=a(),Ae=i("p"),Ae.textContent=ys,$l=a(),m(Xe.$$.fragment),bl=a(),m(x.$$.fragment),gl=a(),m(Ee.$$.fragment),vl=a(),He=i("p"),He.innerHTML=Ms,_l=a(),m(Le.$$.fragment),Ul=a(),Ne=i("p"),Ne.innerHTML=ws,jl=a(),m(Ye.$$.fragment),kl=a(),m(Se.$$.fragment),Tl=a(),Ve=i("p"),Ve.innerHTML=$s,Jl=a(),m(Fe.$$.fragment),Cl=a(),m(De.$$.fragment),Gl=a(),Ke=i("p"),Ke.textContent=bs,xl=a(),Oe=i("ul"),Oe.innerHTML=gs,Zl=a(),lt=i("p"),this.h()},l(e){const t=Bs("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),d=p(e,"P",{}),Cs(d).forEach(l),w=n(e),c(U.$$.fragment,e),g=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1yyj096"&&(_.textContent=Wl),st=n(e),c(Z.$$.fragment,e),at=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jnckpv"&&(I.textContent=Bl),nt=n(e),W=p(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-11v868"&&(W.innerHTML=ql),ot=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1mmkmja"&&(B.textContent=Pl),it=n(e),c(j.$$.fragment,e),pt=n(e),c(q.$$.fragment,e),rt=n(e),c(P.$$.fragment,e),dt=n(e),c(R.$$.fragment,e),mt=n(e),c(z.$$.fragment,e),ct=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1knfk2e"&&(Q.innerHTML=Rl),ht=n(e),c(A.$$.fragment,e),ft=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-4vay6o"&&(X.textContent=zl),ut=n(e),c(E.$$.fragment,e),yt=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mwzmvc"&&(H.textContent=Ql),Mt=n(e),c(k.$$.fragment,e),wt=n(e),c(L.$$.fragment,e),$t=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13afm5q"&&(N.textContent=Al),bt=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-p720qc"&&(Y.innerHTML=Xl),gt=n(e),c(S.$$.fragment,e),vt=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1resniz"&&(V.textContent=El),_t=n(e),c(F.$$.fragment,e),Ut=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1wl1rhb"&&(D.innerHTML=Hl),jt=n(e),c(K.$$.fragment,e),kt=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hbn164"&&(O.innerHTML=Ll),Tt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-gg1omy"&&(ee.innerHTML=Nl),Jt=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-de38z1"&&(te.innerHTML=Yl),Ct=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-q7q9oj"&&(le.textContent=Sl),Gt=n(e),c(se.$$.fragment,e),xt=n(e),c(ae.$$.fragment,e),Zt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9hv0ru"&&(ne.textContent=Vl),It=n(e),c(oe.$$.fragment,e),Wt=n(e),c(ie.$$.fragment,e),Bt=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-l7qwnt"&&(pe.textContent=Fl),qt=n(e),c(re.$$.fragment,e),Pt=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-o7kc16"&&(de.innerHTML=Dl),Rt=n(e),me=p(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-11opk3r"&&(me.innerHTML=Kl),zt=n(e),c(ce.$$.fragment,e),Qt=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1xo69nf"&&(he.innerHTML=Ol),At=n(e),c(fe.$$.fragment,e),Xt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-uy2xoa"&&(ue.innerHTML=es),Et=n(e),c(ye.$$.fragment,e),Ht=n(e),c(Me.$$.fragment,e),Lt=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11gz870"&&(we.innerHTML=ts),Nt=n(e),c($e.$$.fragment,e),Yt=n(e),c(be.$$.fragment,e),St=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1d1z3sn"&&(ge.textContent=ls),Vt=n(e),c(ve.$$.fragment,e),Ft=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-lh30ey"&&(_e.textContent=ss),Dt=n(e),Ue=p(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1macllt"&&(Ue.innerHTML=as),Kt=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-2f3qjg"&&(je.textContent=ns),Ot=n(e),c(T.$$.fragment,e),el=n(e),c(ke.$$.fragment,e),tl=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-q28p5z"&&(Te.innerHTML=os),ll=n(e),c(J.$$.fragment,e),sl=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-185xrjm"&&(Je.textContent=is),al=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-isobvw"&&(Ce.textContent=ps),nl=n(e),Ge=p(e,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-gk7g7m"&&(Ge.innerHTML=rs),ol=n(e),c(C.$$.fragment,e),il=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1y5m5ja"&&(xe.innerHTML=ds),pl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1btz7o0"&&(Ze.textContent=ms),rl=n(e),c(Ie.$$.fragment,e),dl=n(e),c(G.$$.fragment,e),ml=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wm631f"&&(We.innerHTML=cs),cl=n(e),c(Be.$$.fragment,e),hl=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1epndkt"&&(qe.textContent=hs),fl=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-6j84en"&&(Pe.innerHTML=fs),ul=n(e),c(Re.$$.fragment,e),yl=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1niaejq"&&(ze.textContent=us),Ml=n(e),c(Qe.$$.fragment,e),wl=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-u50du7"&&(Ae.textContent=ys),$l=n(e),c(Xe.$$.fragment,e),bl=n(e),c(x.$$.fragment,e),gl=n(e),c(Ee.$$.fragment,e),vl=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-qt42wm"&&(He.innerHTML=Ms),_l=n(e),c(Le.$$.fragment,e),Ul=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-lv3b79"&&(Ne.innerHTML=ws),jl=n(e),c(Ye.$$.fragment,e),kl=n(e),c(Se.$$.fragment,e),Tl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-bna1f6"&&(Ve.innerHTML=$s),Jl=n(e),c(Fe.$$.fragment,e),Cl=n(e),c(De.$$.fragment,e),Gl=n(e),Ke=p(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1rkjfcc"&&(Ke.textContent=bs),xl=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-14rqwnq"&&(Oe.innerHTML=gs),Zl=n(e),lt=p(e,"P",{}),Cs(lt).forEach(l),this.h()},h(){Gs(o,"name","hf:doc:metadata"),Gs(o,"content",Ns)},m(e,t){qs(document.head,o),s(e,M,t),s(e,d,t),s(e,w,t),h(U,e,t),s(e,g,t),s(e,_,t),s(e,st,t),h(Z,e,t),s(e,at,t),s(e,I,t),s(e,nt,t),s(e,W,t),s(e,ot,t),s(e,B,t),s(e,it,t),h(j,e,t),s(e,pt,t),h(q,e,t),s(e,rt,t),h(P,e,t),s(e,dt,t),h(R,e,t),s(e,mt,t),h(z,e,t),s(e,ct,t),s(e,Q,t),s(e,ht,t),h(A,e,t),s(e,ft,t),s(e,X,t),s(e,ut,t),h(E,e,t),s(e,yt,t),s(e,H,t),s(e,Mt,t),h(k,e,t),s(e,wt,t),h(L,e,t),s(e,$t,t),s(e,N,t),s(e,bt,t),s(e,Y,t),s(e,gt,t),h(S,e,t),s(e,vt,t),s(e,V,t),s(e,_t,t),h(F,e,t),s(e,Ut,t),s(e,D,t),s(e,jt,t),h(K,e,t),s(e,kt,t),s(e,O,t),s(e,Tt,t),s(e,ee,t),s(e,Jt,t),s(e,te,t),s(e,Ct,t),s(e,le,t),s(e,Gt,t),h(se,e,t),s(e,xt,t),h(ae,e,t),s(e,Zt,t),s(e,ne,t),s(e,It,t),h(oe,e,t),s(e,Wt,t),h(ie,e,t),s(e,Bt,t),s(e,pe,t),s(e,qt,t),h(re,e,t),s(e,Pt,t),s(e,de,t),s(e,Rt,t),s(e,me,t),s(e,zt,t),h(ce,e,t),s(e,Qt,t),s(e,he,t),s(e,At,t),h(fe,e,t),s(e,Xt,t),s(e,ue,t),s(e,Et,t),h(ye,e,t),s(e,Ht,t),h(Me,e,t),s(e,Lt,t),s(e,we,t),s(e,Nt,t),h($e,e,t),s(e,Yt,t),h(be,e,t),s(e,St,t),s(e,ge,t),s(e,Vt,t),h(ve,e,t),s(e,Ft,t),s(e,_e,t),s(e,Dt,t),s(e,Ue,t),s(e,Kt,t),s(e,je,t),s(e,Ot,t),h(T,e,t),s(e,el,t),h(ke,e,t),s(e,tl,t),s(e,Te,t),s(e,ll,t),h(J,e,t),s(e,sl,t),s(e,Je,t),s(e,al,t),s(e,Ce,t),s(e,nl,t),s(e,Ge,t),s(e,ol,t),h(C,e,t),s(e,il,t),s(e,xe,t),s(e,pl,t),s(e,Ze,t),s(e,rl,t),h(Ie,e,t),s(e,dl,t),h(G,e,t),s(e,ml,t),s(e,We,t),s(e,cl,t),h(Be,e,t),s(e,hl,t),s(e,qe,t),s(e,fl,t),s(e,Pe,t),s(e,ul,t),h(Re,e,t),s(e,yl,t),s(e,ze,t),s(e,Ml,t),h(Qe,e,t),s(e,wl,t),s(e,Ae,t),s(e,$l,t),h(Xe,e,t),s(e,bl,t),h(x,e,t),s(e,gl,t),h(Ee,e,t),s(e,vl,t),s(e,He,t),s(e,_l,t),h(Le,e,t),s(e,Ul,t),s(e,Ne,t),s(e,jl,t),h(Ye,e,t),s(e,kl,t),h(Se,e,t),s(e,Tl,t),s(e,Ve,t),s(e,Jl,t),h(Fe,e,t),s(e,Cl,t),h(De,e,t),s(e,Gl,t),s(e,Ke,t),s(e,xl,t),s(e,Oe,t),s(e,Zl,t),s(e,lt,t),Il=!0},p(e,[t]){const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),j.$set(vs);const _s={};t&2&&(_s.$$scope={dirty:t,ctx:e}),k.$set(_s);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),T.$set(Us);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),J.$set(js);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),C.$set(ks);const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),G.$set(Ts);const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),x.$set(Js)},i(e){Il||(f(U.$$.fragment,e),f(Z.$$.fragment,e),f(j.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(k.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(T.$$.fragment,e),f(ke.$$.fragment,e),f(J.$$.fragment,e),f(C.$$.fragment,e),f(Ie.$$.fragment,e),f(G.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Qe.$$.fragment,e),f(Xe.$$.fragment,e),f(x.$$.fragment,e),f(Ee.$$.fragment,e),f(Le.$$.fragment,e),f(Ye.$$.fragment,e),f(Se.$$.fragment,e),f(Fe.$$.fragment,e),f(De.$$.fragment,e),Il=!0)},o(e){u(U.$$.fragment,e),u(Z.$$.fragment,e),u(j.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(R.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u($e.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(T.$$.fragment,e),u(ke.$$.fragment,e),u(J.$$.fragment,e),u(C.$$.fragment,e),u(Ie.$$.fragment,e),u(G.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Qe.$$.fragment,e),u(Xe.$$.fragment,e),u(x.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Ye.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(De.$$.fragment,e),Il=!1},d(e){e&&(l(M),l(d),l(w),l(g),l(_),l(st),l(at),l(I),l(nt),l(W),l(ot),l(B),l(it),l(pt),l(rt),l(dt),l(mt),l(ct),l(Q),l(ht),l(ft),l(X),l(ut),l(yt),l(H),l(Mt),l(wt),l($t),l(N),l(bt),l(Y),l(gt),l(vt),l(V),l(_t),l(Ut),l(D),l(jt),l(kt),l(O),l(Tt),l(ee),l(Jt),l(te),l(Ct),l(le),l(Gt),l(xt),l(Zt),l(ne),l(It),l(Wt),l(Bt),l(pe),l(qt),l(Pt),l(de),l(Rt),l(me),l(zt),l(Qt),l(he),l(At),l(Xt),l(ue),l(Et),l(Ht),l(Lt),l(we),l(Nt),l(Yt),l(St),l(ge),l(Vt),l(Ft),l(_e),l(Dt),l(Ue),l(Kt),l(je),l(Ot),l(el),l(tl),l(Te),l(ll),l(sl),l(Je),l(al),l(Ce),l(nl),l(Ge),l(ol),l(il),l(xe),l(pl),l(Ze),l(rl),l(dl),l(ml),l(We),l(cl),l(hl),l(qe),l(fl),l(Pe),l(ul),l(yl),l(ze),l(Ml),l(wl),l(Ae),l($l),l(bl),l(gl),l(vl),l(He),l(_l),l(Ul),l(Ne),l(jl),l(kl),l(Tl),l(Ve),l(Jl),l(Cl),l(Gl),l(Ke),l(xl),l(Oe),l(Zl),l(lt)),l(o),y(U,e),y(Z,e),y(j,e),y(q,e),y(P,e),y(R,e),y(z,e),y(A,e),y(E,e),y(k,e),y(L,e),y(S,e),y(F,e),y(K,e),y(se,e),y(ae,e),y(oe,e),y(ie,e),y(re,e),y(ce,e),y(fe,e),y(ye,e),y(Me,e),y($e,e),y(be,e),y(ve,e),y(T,e),y(ke,e),y(J,e),y(C,e),y(Ie,e),y(G,e),y(Be,e),y(Re,e),y(Qe,e),y(Xe,e),y(x,e),y(Ee,e),y(Le,e),y(Ye,e),y(Se,e),y(Fe,e),y(De,e)}}}const Ns='{"title":"Handling big models for inference","local":"handling-big-models-for-inference","sections":[{"title":"How the Process Works: A Quick Overview","local":"how-the-process-works-a-quick-overview","sections":[],"depth":2},{"title":"How the Process Works: Working with Code","local":"how-the-process-works-working-with-code","sections":[{"title":"Instantiating an empty model","local":"instantiating-an-empty-model","sections":[],"depth":3},{"title":"Sharded checkpoints","local":"sharded-checkpoints","sections":[],"depth":3},{"title":"Loading weights","local":"loading-weights","sections":[{"title":"no_split_module_classes","local":"nosplitmoduleclasses","sections":[],"depth":4},{"title":"The device_map","local":"the-devicemap","sections":[],"depth":4}],"depth":3},{"title":"Run the model","local":"run-the-model","sections":[],"depth":3},{"title":"Designing a device map","local":"designing-a-device-map","sections":[],"depth":3}],"depth":2},{"title":"CPU offload only","local":"cpu-offload-only","sections":[],"depth":2},{"title":"Disk offload only","local":"disk-offload-only","sections":[],"depth":2},{"title":"Limits and further development","local":"limits-and-further-development","sections":[],"depth":2}],"depth":1}';function Ys(b){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ea extends Is{constructor(o){super(),Ws(this,o,Ys,Ls,xs,{})}}export{ea as component};
