import{s as Lp,o as Wp,n as Ua}from"../chunks/scheduler.9bc65507.js";import{S as Gp,i as Ip,g as i,s as r,u as f,A as Yp,h as l,f as t,c as o,j as c,v as u,y as s,k as p,o as h,a,w as m,d as g,t as v,x as y}from"../chunks/index.78c82d43.js";import{T as Aa}from"../chunks/Tip.87d55b76.js";import{I as _}from"../chunks/IconCopyLink.bedaa44d.js";import{C as x}from"../chunks/CodeBlock.48618ec2.js";function Rp(C){let d,M='If you have access to a machine with multiple GPUs, these approaches are still valid, plus you can leverage additional methods outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.';return{c(){d=i("p"),d.innerHTML=M},l(w){d=l(w,"P",{"data-svelte-h":!0}),s(d)!=="svelte-198lgun"&&(d.innerHTML=M)},m(w,b){a(w,d,b)},p:Ua,d(w){w&&t(d)}}}function Zp(C){let d,M=`Note: when using mixed precision with a small model and a large batch size, there will be some memory savings but with a
large model and a small batch size, the memory use will be larger.`;return{c(){d=i("p"),d.textContent=M},l(w){d=l(w,"P",{"data-svelte-h":!0}),s(d)!=="svelte-e8wqm0"&&(d.textContent=M)},m(w,b){a(w,d,b)},p:Ua,d(w){w&&t(d)}}}function Ep(C){let d,M="While gradient checkpointing may improve memory efficiency, it slows training by approximately 20%.";return{c(){d=i("p"),d.textContent=M},l(w){d=l(w,"P",{"data-svelte-h":!0}),s(d)!=="svelte-1rw5pua"&&(d.textContent=M)},m(w,b){a(w,d,b)},p:Ua,d(w){w&&t(d)}}}function Fp(C){let d,M="tf32 can’t be accessed directly via <code>tensor.to(dtype=torch.tf32)</code> because it is an internal CUDA data type. You need <code>torch&gt;=1.7</code> to use tf32 data types.";return{c(){d=i("p"),d.innerHTML=M},l(w){d=l(w,"P",{"data-svelte-h":!0}),s(d)!=="svelte-lagf4l"&&(d.innerHTML=M)},m(w,b){a(w,d,b)},p:Ua,d(w){w&&t(d)}}}function Bp(C){let d,M="The PyTorch-native <code>scaled_dot_product_attention</code> operator can only dispatch to Flash Attention if no <code>attention_mask</code> is provided.",w,b,$="By default, in training mode, the BetterTransformer integration <strong>drops the mask support and can only be used for training that does not require a padding mask for batched training</strong>. This is the case, for example, during masked language modeling or causal language modeling. BetterTransformer is not suited for fine-tuning models on tasks that require a padding mask.";return{c(){d=i("p"),d.innerHTML=M,w=r(),b=i("p"),b.innerHTML=$},l(T){d=l(T,"P",{"data-svelte-h":!0}),s(d)!=="svelte-3mpetc"&&(d.innerHTML=M),w=o(T),b=l(T,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1sd6oaz"&&(b.innerHTML=$)},m(T,k){a(T,d,k),a(T,w,k),a(T,b,k)},p:Ua,d(T){T&&(t(d),t(w),t(b))}}}function Xp(C){let d,M,w,b,$,T,k,me,xr,En,Fr="Methods and tools for efficient training on a single GPU",Ha,ge,Br=`This guide demonstrates practical techniques that you can use to increase the efficiency of your model’s training by
optimizing memory utilization, speeding up the training, or both. If you’d like to understand how GPU is utilized during
training, please refer to the <a href="model_memory_anatomy">Model training anatomy</a> conceptual guide first. This guide
focuses on practical techniques.`,ja,N,za,ve,Xr="When training large models, there are two aspects that should be considered at the same time:",Pa,ye,Nr="<li>Data throughput/training time</li> <li>Model performance</li>",La,we,Sr=`Maximizing the throughput (samples/second) leads to lower training cost. This is generally achieved by utilizing the GPU
as much as possible and thus filling GPU memory to its limit. If the desired batch size exceeds the limits of the GPU memory,
the memory optimization techniques, such as gradient accumulation, can help.`,Wa,be,qr=`However, if the preferred batch size fits into memory, there’s no reason to apply memory-optimizing techniques because they can
slow down the training. Just because one can use a large batch size, does not necessarily mean they should. As part of
hyperparameter tuning, you should determine which batch size yields the best results and then optimize resources accordingly.`,Ga,Me,Vr="The methods and tools covered in this guide can be classified based on the effect they have on the training process:",Ia,_e,Dr='<thead><tr><th align="left">Method/tool</th> <th align="left">Improves training speed</th> <th align="left">Optimizes memory utilization</th></tr></thead> <tbody><tr><td align="left"><a href="#batch-size-choice">Batch size choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-accumulation">Gradient accumulation</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-checkpointing">Gradient checkpointing</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#mixed-precision-training">Mixed precision training</a></td> <td align="left">Yes</td> <td align="left">(No)</td></tr> <tr><td align="left"><a href="#optimizer-choice">Optimizer choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#data-preloading">Data preloading</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#deepspeed-zero">DeepSpeed Zero</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#using-torchcompile">torch.compile</a></td> <td align="left">Yes</td> <td align="left">No</td></tr></tbody>',Ya,S,Ra,Te,Qr=`You can combine the above methods to get a cumulative effect. These techniques are available to you whether you are
training your model with <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> or writing a pure PyTorch loop, in which case you can <a href="#using-accelerate">configure these optimizations
with 🤗 Accelerate</a>.`,Za,xe,Kr="If these methods do not result in sufficient gains, you can explore the following options:",Ea,Ce,Or='<li><a href="#efficient-software-prebuilds">Look into building your own custom Docker container with efficient softare prebuilds</a></li> <li><a href="#mixture-of-experts">Consider a model that uses Mixture of Experts (MoE)</a></li> <li><a href="#using-pytorch-native-attention">Convert your model to BetterTransformer to leverage PyTorch native attention</a></li>',Fa,$e,eo=`Finally, if all of the above is still not enough, even after switching to a server-grade GPU like A100, consider moving
to a multi-GPU setup. All these approaches are still valid in a multi-GPU setup, plus you can leverage additional parallelism
techniques outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.`,Ba,J,q,oa,ke,Cr,Fn,to="Batch size choice",Xa,Je,no=`To achieve optimal performance, start by identifying the appropriate batch size. It is recommended to use batch sizes and
input/output neuron counts that are of size 2^N. Often it’s a multiple of 8, but it can be
higher depending on the hardware being used and the model’s dtype.`,Na,Ae,ao=`For reference, check out NVIDIA’s recommendation for <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#input-features" rel="nofollow">input/output neuron counts</a> and
<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#batch-size" rel="nofollow">batch size</a> for
fully connected layers (which are involved in GEMMs (General Matrix Multiplications)).`,Sa,Ue,io=`<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#requirements-tc" rel="nofollow">Tensor Core Requirements</a>
define the multiplier based on the dtype and the hardware. For instance, for fp16 data type a multiple of 8 is recommended, unless
it’s an A100 GPU, in which case use multiples of 64.`,qa,He,lo=`For parameters that are small, consider also <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#dim-quantization" rel="nofollow">Dimension Quantization Effects</a>.
This is where tiling happens and the right multiplier can have a significant speedup.`,Va,A,V,sa,je,$r,Bn,ro="Gradient Accumulation",Da,ze,oo=`The <strong>gradient accumulation</strong> method aims to calculate gradients in smaller increments instead of computing them for the
entire batch at once. This approach involves iteratively calculating gradients in smaller batches by performing forward
and backward passes through the model and accumulating the gradients during the process. Once a sufficient number of
gradients have been accumulated, the model’s optimization step is executed. By employing gradient accumulation, it
becomes possible to increase the <strong>effective batch size</strong> beyond the limitations imposed by the GPU’s memory capacity.
However, it is important to note that the additional forward and backward passes introduced by gradient accumulation can
slow down the training process.`,Qa,Pe,so='You can enable gradient accumulation by adding the <code>gradient_accumulation_steps</code> argument to  <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Ka,Le,Oa,We,po="In the above example, your effective batch size becomes 4.",ei,Ge,ho=`Alternatively, use 🤗 Accelerate to gain full control over the training loop. Find the 🤗 Accelerate example
<a href="#using-accelerate">further down in this guide</a>.`,ti,Ie,co=`While it is advised to max out GPU usage as much as possible, a high number of gradient accumulation steps can
result in a more pronounced training slowdown. Consider the following example. Let’s say, the <code>per_device_train_batch_size=4</code>
without gradient accumulation hits the GPU’s limit. If you would like to train with batches of size 64, do not set the
<code>per_device_train_batch_size</code> to 1 and <code>gradient_accumulation_steps</code> to 64. Instead, keep <code>per_device_train_batch_size=4</code>
and set <code>gradient_accumulation_steps=16</code>. This results in the same effective batch size while making better use of
the available GPU resources.`,ni,Ye,fo=`For additional information, please refer to batch size and gradient accumulation benchmarks for <a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004392537" rel="nofollow">RTX-3090</a>
and <a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1005033957" rel="nofollow">A100</a>.`,ai,U,D,pa,Re,kr,Xn,uo="Gradient Checkpointing",ii,Ze,mo=`Some large models may still face memory issues even when the batch size is set to 1 and gradient accumulation is used.
This is because there are other components that also require memory storage.`,li,Ee,go=`Saving all activations from the forward pass in order to compute the gradients during the backward pass can result in
significant memory overhead. The alternative approach of discarding the activations and recalculating them when needed
during the backward pass, would introduce a considerable computational overhead and slow down the training process.`,ri,Fe,vo=`<strong>Gradient checkpointing</strong> offers a compromise between these two approaches and saves strategically selected activations
throughout the computational graph so only a fraction of the activations need to be re-computed for the gradients. For
an in-depth explanation of gradient checkpointing, refer to <a href="https://medium.com/tensorflow/fitting-larger-networks-into-memory-583e3c758ff9" rel="nofollow">this great article</a>.`,oi,Be,yo='To enable gradient checkpointing in the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, pass the corresponding a flag to <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',si,Xe,pi,Ne,wo='Alternatively, use 🤗 Accelerate - find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',hi,Q,ci,H,K,ha,Se,Jr,Nn,bo="Mixed precision training",di,qe,Mo=`<strong>Mixed precision training</strong> is a technique that aims to optimize the computational efficiency of training models by
utilizing lower-precision numerical formats for certain variables. Traditionally, most models use 32-bit floating point
precision (fp32 or float32) to represent and process variables. However, not all variables require this high precision
level to achieve accurate results. By reducing the precision of certain variables to lower numerical formats like 16-bit
floating point (fp16 or float16), we can speed up the computations. Because in this approach some computations are performed
in half-precision, while some are still in full precision, the approach is called mixed precision training.`,fi,Ve,_o=`Most commonly mixed precision training is achieved by using fp16 (float16) data types, however, some GPU architectures
(such as the Ampere architecture) offer bf16 and tf32 (CUDA internal data type) data types. Check
out the <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA Blog</a> to learn more about
the differences between these data types.`,ui,j,O,ca,De,Ar,Sn,To="fp16",mi,Qe,xo=`The main advantage of mixed precision training comes from saving the activations in half precision (fp16).
Although the gradients are also computed in half precision they are converted back to full precision for the optimization
step so no memory is saved here.
While mixed precision training results in faster computations, it can also lead to more GPU memory being utilized, especially for small batch sizes.
This is because the model is now present on the GPU in both 16-bit and 32-bit precision (1.5x the original model on the GPU).`,gi,Ke,Co="To enable mixed precision training, set the <code>fp16</code> flag to <code>True</code>:",vi,Oe,yi,et,$o='If you prefer to use 🤗 Accelerate, find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',wi,z,ee,da,tt,Ur,qn,ko="BF16",bi,nt,Jo=`If you have access to an Ampere or newer hardware you can use bf16 for mixed precision training and evaluation. While
bf16 has a worse precision than fp16, it has a much bigger dynamic range. In fp16 the biggest number you can have
is <code>65535</code> and any number above that will result in an overflow. A bf16 number can be as large as <code>3.39e+38</code> (!) which
is about the same as fp32 - because both have 8-bits used for the numerical range.`,Mi,at,Ao="You can enable BF16 in the 🤗 Trainer with:",_i,it,Ti,P,te,fa,lt,Hr,Vn,Uo="TF32",xi,rt,Ho=`The Ampere hardware uses a magical data type called tf32. It has the same numerical range as fp32 (8-bits), but instead
of 23 bits precision it has only 10 bits (same as fp16) and uses only 19 bits in total. It’s “magical” in the sense that
you can use the normal fp32 training and/or inference code and by enabling tf32 support you can get up to 3x throughput
improvement. All you need to do is to add the following to your code:`,Ci,ot,$i,st,jo="CUDA will automatically switch to using tf32 instead of fp32 where possible, assuming that the used GPU is from the Ampere series.",ki,pt,zo=`According to <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA research</a>, the
majority of machine learning training workloads show the same perplexity and convergence with tf32 training as with fp32.
If you’re already using fp16 or bf16 mixed precision it may help with the throughput as well.`,Ji,ht,Po="You can enable this mode in the 🤗 Trainer:",Ai,ct,Ui,ne,Hi,dt,Lo=`For additional information on tf32 vs other precisions, please refer to the following benchmarks:
<a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004390803" rel="nofollow">RTX-3090</a> and
<a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1004543189" rel="nofollow">A100</a>.`,ji,L,ae,ua,ft,jr,Dn,Wo="Optimizer choice",zi,ut,Go=`The most common optimizer used to train transformer models is Adam or AdamW (Adam with weight decay). Adam achieves
good convergence by storing the rolling average of the previous gradients; however, it adds an additional memory
footprint of the order of the number of model parameters. To remedy this, you can use an alternative optimizer.
For example if you have <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA/apex</a> installed, <code>adamw_apex_fused</code> will give you the
fastest training experience among all supported AdamW optimizers.`,Pi,mt,Io=`<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> integrates a variety of optimizers that can be used out of box: <code>adamw_hf</code>, <code>adamw_torch</code>, <code>adamw_torch_fused</code>,
<code>adamw_apex_fused</code>, <code>adamw_anyprecision</code>, <code>adafactor</code>, or <code>adamw_bnb_8bit</code>. More optimizers can be plugged in via a third-party implementation.`,Li,gt,Yo="Let’s take a closer look at two alternatives to AdamW optimizer:",Wi,vt,Ro='<li><code>adafactor</code> which is available in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a></li> <li><code>adamw_bnb_8bit</code> is also available in Trainer, but a third-party integration is provided below for demonstration.</li>',Gi,yt,Zo="For comparison, for a 3B-parameter model, like “t5-3b”:",Ii,wt,Eo="<li>A standard AdamW optimizer will need 24GB of GPU memory because it uses 8 bytes for each parameter (8*3 =&gt; 24GB)</li> <li>Adafactor optimizer will need more than 12GB. It uses slightly more than 4 bytes for each parameter, so 4*3 and then some extra.</li> <li>8bit BNB quantized optimizer will use only (2*3) 6GB if all optimizer states are quantized.</li>",Yi,W,ie,ma,bt,zr,Qn,Fo="Adafactor",Ri,Mt,Bo=`Adafactor doesn’t store rolling averages for each element in weight matrices. Instead, it keeps aggregated information
(sums of rolling averages row- and column-wise), significantly reducing its footprint. However, compared to Adam,
Adafactor may have slower convergence in certain cases.`,Zi,_t,Xo='You can switch to Adafactor by setting <code>optim=&quot;adafactor&quot;</code> in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Ei,Tt,Fi,xt,No=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training)
you can notice up to 3x improvement while maintaining the throughput! However, as mentioned before, the convergence of
Adafactor can be worse than Adam.`,Bi,G,le,ga,Ct,Pr,Kn,So="8-bit Adam",Xi,$t,qo=`Instead of aggregating optimizer states like Adafactor, 8-bit Adam keeps the full state and quantizes it. Quantization
means that it stores the state with lower precision and dequantizes it only for the optimization. This is similar to the
idea behind mixed precision training.`,Ni,kt,Vo='To use <code>adamw_bnb_8bit</code>, you simply need to set <code>optim=&quot;adamw_bnb_8bit&quot;</code> in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Si,Jt,qi,At,Do="However, we can also use a third-party implementation of the 8-bit optimizer for demonstration purposes to see how that can be integrated.",Vi,Ut,Qo=`First, follow the installation guide in the GitHub <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">repo</a> to install the <code>bitsandbytes</code> library
that implements the 8-bit Adam optimizer.`,Di,Ht,Ko="Next you need to initialize the optimizer. This involves two steps:",Qi,jt,Oo="<li>First, group the model’s parameters into two groups - one where weight decay should be applied, and the other one where it should not. Usually, biases and layer norm parameters are not weight decayed.</li> <li>Then do some argument housekeeping to use the same parameters as the previously used AdamW optimizer.</li>",Ki,zt,Oi,Pt,es="Finally, pass the custom optimizer as an argument to the <code>Trainer</code>:",el,Lt,tl,Wt,ts=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training),
you can expect to get about a 3x memory improvement and even slightly higher throughput as using Adafactor.`,nl,I,re,va,Gt,Lr,On,ns="multi_tensor",al,It,as=`pytorch-nightly introduced <code>torch.optim._multi_tensor</code> which should significantly speed up the optimizers for situations
with lots of small feature tensors. It should eventually become the default, but if you want to experiment with it sooner, take a look at this GitHub <a href="https://github.com/huggingface/transformers/issues/9965" rel="nofollow">issue</a>.`,il,Y,oe,ya,Yt,Wr,ea,is="Data preloading",ll,Rt,ls=`One of the important requirements to reach great training speed is the ability to feed the GPU at the maximum speed it
can handle. By default, everything happens in the main process, and it might not be able to read the data from disk fast
enough, and thus create a bottleneck, leading to GPU under-utilization. Configure the following arguments to reduce the bottleneck:`,rl,Zt,rs="<li><code>DataLoader(pin_memory=True, ...)</code> - ensures the data gets preloaded into the pinned memory on CPU and typically leads to much faster transfers from CPU to GPU memory.</li> <li><code>DataLoader(num_workers=4, ...)</code> - spawn several workers to preload data faster. During training, watch the GPU utilization stats; if it’s far from 100%, experiment with increasing the number of workers. Of course, the problem could be elsewhere, so many workers won’t necessarily lead to better performance.</li>",ol,Et,os='When using <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, the corresponding <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> are: <code>dataloader_pin_memory</code> (<code>True</code> by default), and <code>dataloader_num_workers</code> (defaults to <code>0</code>).',sl,R,se,wa,Ft,Gr,ta,ss="DeepSpeed ZeRO",pl,Bt,ps=`DeepSpeed is an open-source deep learning optimization library that is integrated with 🤗 Transformers and 🤗 Accelerate.
It provides a wide range of features and optimizations designed to improve the efficiency and scalability of large-scale
deep learning training.`,hl,Xt,hs=`If your model fits onto a single GPU and you have enough space to fit a small batch size, you don’t need to use DeepSpeed
as it’ll only slow things down. However, if the model doesn’t fit onto a single GPU or you can’t fit a small batch, you can
leverage DeepSpeed ZeRO + CPU Offload, or NVMe Offload for much larger models. In this case, you need to separately
<a href="main_classes/deepspeed#installation">install the library</a>, then follow one of the guides to create a configuration file
and launch DeepSpeed:`,cl,Nt,cs=`<li>For an in-depth guide on DeepSpeed integration with <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, review <a href="main_classes/deepspeed">the corresponding documentation</a>, specifically the
<a href="main_classes/deepspeed#deployment-with-one-gpu">section for a single GPU</a>. Some adjustments are required to use DeepSpeed in a notebook; please take a look at the <a href="main_classes/deepspeed#deployment-in-notebooks">corresponding guide</a>.</li> <li>If you prefer to use 🤗 Accelerate, refer to <a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate DeepSpeed guide</a>.</li>`,dl,Z,pe,ba,St,Ir,na,ds="Using torch.compile",fl,qt,fs=`PyTorch 2.0 introduced a new compile function that doesn’t require any modification to existing PyTorch code but can
optimize your code by adding a single line of code: <code>model = torch.compile(model)</code>.`,ul,Vt,us='If using <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you only need <code>to</code> pass the <code>torch_compile</code> option in the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',ml,Dt,gl,Qt,ms=`<code>torch.compile</code> uses Python’s frame evaluation API to automatically create a graph from existing PyTorch programs. After
capturing the graph, different backends can be deployed to lower the graph to an optimized engine.
You can find more details and benchmarks in <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch documentation</a>.`,vl,Kt,gs="<code>torch.compile</code> has a growing list of backends, which can be found in by calling <code>torchdynamo.list_backends()</code>, each of which with its optional dependencies.",yl,Ot,vs='Choose which backend to use by specifying it via <code>torch_compile_backend</code> in the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.  Some of the most commonly used backends are:',wl,en,ys="<strong>Debugging backends</strong>:",bl,tn,ws="<li><code>dynamo.optimize(&quot;eager&quot;)</code> - Uses PyTorch to run the extracted GraphModule. This is quite useful in debugging TorchDynamo issues.</li> <li><code>dynamo.optimize(&quot;aot_eager&quot;)</code> - Uses AotAutograd with no compiler, i.e, just using PyTorch eager for the AotAutograd’s extracted forward and backward graphs. This is useful for debugging, and unlikely to give speedups.</li>",Ml,nn,bs="<strong>Training &amp; inference backends</strong>:",_l,an,Ms='<li><code>dynamo.optimize(&quot;inductor&quot;)</code> - Uses TorchInductor backend with AotAutograd and cudagraphs by leveraging codegened Triton kernels  <a href="https://dev-discuss.pytorch.org/t/torchinductor-a-pytorch-native-compiler-with-define-by-run-ir-and-symbolic-shapes/747" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;nvfuser&quot;)</code> -  nvFuser with TorchScript. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_nvfuser&quot;)</code> -  nvFuser with AotAutograd. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_cudagraphs&quot;)</code> - cudagraphs with AotAutograd. <a href="https://github.com/pytorch/torchdynamo/pull/757" rel="nofollow">Read more</a></li>',Tl,ln,_s="<strong>Inference-only backend</strong>s:",xl,rn,Ts='<li><code>dynamo.optimize(&quot;ofi&quot;)</code> -  Uses Torchscript optimize_for_inference.  <a href="https://pytorch.org/docs/stable/generated/torch.jit.optimize_for_inference.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;fx2trt&quot;)</code> -  Uses Nvidia TensorRT for inference optimizations.  <a href="https://github.com/pytorch/TensorRT/blob/master/docsrc/tutorials/getting_started_with_fx_path.rst" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;onnxrt&quot;)</code> -  Uses ONNXRT for inference on CPU/GPU.  <a href="https://onnxruntime.ai/" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;ipex&quot;)</code> -  Uses IPEX for inference on CPU.  <a href="https://github.com/intel/intel-extension-for-pytorch" rel="nofollow">Read more</a></li>',Cl,on,xs='For an example of using <code>torch.compile</code> with 🤗 Transformers, check out this <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers" rel="nofollow">blog post on fine-tuning a BERT model for Text Classification using the newest PyTorch 2.0 features</a>',$l,E,he,Ma,sn,Yr,aa,Cs="Using 🤗 Accelerate",kl,pn,$s=`With <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> you can use the above methods while gaining full
control over the training loop and can essentially write the loop in pure PyTorch with some minor modifications.`,Jl,hn,ks='Suppose you have combined the methods in the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> like so:',Al,cn,Ul,dn,Js="The full example training loop with 🤗 Accelerate is only a handful of lines of code long:",Hl,fn,jl,un,As=`First we wrap the dataset in a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>.
Then we can enable gradient checkpointing by calling the model’s <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.gradient_checkpointing_enable">gradient_checkpointing_enable()</a> method.
When we initialize the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>
we can specify if we want to use mixed precision training and it will take care of it for us in the <code>prepare</code> call.
During the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>
call the dataloader will also be distributed across workers should we use multiple GPUs. We use the same <a href="#8-bit-adam">8-bit optimizer</a> from the earlier example.`,zl,mn,Us=`Finally, we can add the main training loop. Note that the <code>backward</code> call is handled by 🤗 Accelerate. We can also see
how gradient accumulation works: we normalize the loss, so we get the average at the end of accumulation and once we have
enough steps we run the optimization.`,Pl,gn,Hs=`Implementing these optimization techniques with 🤗 Accelerate only takes a handful of lines of code and comes with the
benefit of more flexibility in the training loop. For a full documentation of all features have a look at the
<a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate documentation</a>.`,Ll,F,ce,_a,vn,Rr,ia,js="Efficient Software Prebuilds",Wl,yn,zs=`PyTorch’s <a href="https://pytorch.org/get-started/locally/#start-locally" rel="nofollow">pip and conda builds</a> come prebuilt with the cuda toolkit
which is enough to run PyTorch, but it is insufficient if you need to build cuda extensions.`,Gl,wn,Ps=`At times, additional efforts may be required to pre-build some components. For instance, if you’re using libraries like <code>apex</code> that
don’t come pre-compiled. In other situations figuring out how to install the right cuda toolkit system-wide can be complicated.
To address these scenarios PyTorch and NVIDIA released a new version of NGC docker container which already comes with
everything prebuilt. You just need to install your programs on it, and it will run out of the box.`,Il,bn,Ls=`This approach is also useful if you want to tweak the pytorch source and/or make a new customized build.
To find the docker image version you want start <a href="https://docs.nvidia.com/deeplearning/frameworks/pytorch-release-notes/" rel="nofollow">with PyTorch release notes</a>,
choose one of the latest monthly releases. Go into the release’s notes for the desired release, check that the environment’s
components are matching your needs (including NVIDIA Driver requirements!) and then at the very top of that document go
to the corresponding NGC page. If for some reason you get lost, here is <a href="https://ngc.nvidia.com/catalog/containers/nvidia:pytorch" rel="nofollow">the index of all PyTorch NGC images</a>.`,Yl,Mn,Ws="Next follow the instructions to download and deploy the docker image.",Rl,B,de,Ta,_n,Zr,la,Gs="Mixture of Experts",Zl,Tn,Is=`Some recent papers reported a 4-5x training speedup and a faster inference by integrating
Mixture of Experts (MoE) into the Transformer models.`,El,xn,Ys=`Since it has been discovered that more parameters lead to better performance, this technique allows to increase the
number of parameters by an order of magnitude without increasing training costs.`,Fl,Cn,Rs=`In this approach every other FFN layer is replaced with a MoE Layer which consists of many experts, with a gated function
that trains each expert in a balanced way depending on the input token’s position in a sequence.`,Bl,$n,Zs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perf-moe-transformer.png" alt="MoE Transformer 2x block"/>',Xl,kn,Es='(source: <a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLAM</a>)',Nl,Jn,Fs="You can find exhaustive details and comparison tables in the papers listed at the end of this section.",Sl,An,Bs=`The main drawback of this approach is that it requires staggering amounts of GPU memory - almost an order of magnitude
larger than its dense equivalent. Various distillation and approaches are proposed to how to overcome the much higher memory requirements.`,ql,Un,Xs=`There is direct trade-off though, you can use just a few experts with a 2-3x smaller base model instead of dozens or
hundreds experts leading to a 5x smaller model and thus increase the training speed moderately while increasing the
memory requirements moderately as well.`,Vl,Hn,Ns="Most related papers and implementations are built around Tensorflow/TPUs:",Dl,jn,Ss='<li><a href="https://arxiv.org/abs/2006.16668" rel="nofollow">GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding</a></li> <li><a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a></li> <li><a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLaM: Generalist Language Model (GLaM)</a></li>',Ql,zn,qs='And for Pytorch DeepSpeed has built one as well: <a href="https://arxiv.org/abs/2201.05596" rel="nofollow">DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</a>, <a href="https://www.deepspeed.ai/tutorials/mixture-of-experts/" rel="nofollow">Mixture of Experts</a> - blog posts:  <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-powers-8x-larger-moe-model-training-with-high-performance/" rel="nofollow">1</a>, <a href="https://www.microsoft.com/en-us/research/publication/scalable-and-efficient-moe-training-for-multitask-multilingual-models/" rel="nofollow">2</a> and specific deployment with large transformer-based natural language generation models: <a href="https://www.deepspeed.ai/news/2021/12/09/deepspeed-moe-nlg.html" rel="nofollow">blog post</a>, <a href="Thttps://github.com/microsoft/Megatron-DeepSpeed/tree/moe-training">Megatron-Deepspeed branch</a>.',Kl,X,fe,xa,Pn,Er,ra,Vs="Using PyTorch native attention and Flash Attention",Ol,Ln,Ds=`PyTorch 2.0 released a native <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA),
that allows using fused GPU kernels such as <a href="https://arxiv.org/abs/2112.05682" rel="nofollow">memory-efficient attention</a> and <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">flash attention</a>.`,er,Wn,Qs=`After installing the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a> package, the relevant internal modules can be
replaced to use PyTorch’s native attention with:`,tr,Gn,nr,In,Ks="Once converted, train the model as usual.",ar,ue,ir,Yn,Os='Check out this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blogpost</a> to learn more about acceleration and memory-savings with SDPA.',lr,Ca,rr;return me=new _({}),N=new Aa({props:{$$slots:{default:[Rp]},$$scope:{ctx:C}}}),S=new Aa({props:{$$slots:{default:[Zp]},$$scope:{ctx:C}}}),ke=new _({}),je=new _({}),Le=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, **default_args)'}}),Re=new _({}),Xe=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyUwQSk=",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, gradient_checkpointing=<span class="hljs-literal">True</span>, **default_args
)`}}),Q=new Aa({props:{$$slots:{default:[Ep]},$$scope:{ctx:C}}}),Se=new _({}),De=new _({}),Oe=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBmcDE2JTNEVHJ1ZSUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, fp16=<span class="hljs-literal">True</span>, **default_args)'}}),tt=new _({}),it=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKGJmMTYlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(bf16=<span class="hljs-literal">True</span>, **default_args)'}}),lt=new _({}),ot=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`import torch
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cuda</span><span class="hljs-selector-class">.matmul</span><span class="hljs-selector-class">.allow_tf32</span> = True
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cudnn</span><span class="hljs-selector-class">.allow_tf32</span> = True`}}),ct=new x({props:{code:"VHJhaW5pbmdBcmd1bWVudHModGYzMiUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyk=",highlighted:'TrainingArguments(tf32=<span class="hljs-literal">True</span>, **default_args)'}}),ne=new Aa({props:{$$slots:{default:[Fp]},$$scope:{ctx:C}}}),ft=new _({}),bt=new _({}),Tt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYWZhY3RvciUyMiUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adafactor&quot;</span>, **default_args)'}}),Ct=new _({}),Jt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYW13X2JuYl84Yml0JTIyJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adamw_bnb_8bit&quot;</span>, **default_args)'}}),zt=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers.trainer_pt_utils <span class="hljs-keyword">import</span> get_parameter_names

training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)

decay_parameters = get_parameter_names(model, [nn.LayerNorm])
decay_parameters = [name <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> decay_parameters <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bias&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> name]
optimizer_grouped_parameters = [
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: training_args.weight_decay,
    },
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-number">0.0</span>,
    },
]

optimizer_kwargs = {
    <span class="hljs-string">&quot;betas&quot;</span>: (training_args.adam_beta1, training_args.adam_beta2),
    <span class="hljs-string">&quot;eps&quot;</span>: training_args.adam_epsilon,
}
optimizer_kwargs[<span class="hljs-string">&quot;lr&quot;</span>] = training_args.learning_rate
adam_bnb_optim = bnb.optim.Adam8bit(
    optimizer_grouped_parameters,
    betas=(training_args.adam_beta1, training_args.adam_beta2),
    eps=training_args.adam_epsilon,
    lr=training_args.learning_rate,
)`}}),Lt=new x({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzJTJDJTIwb3B0aW1pemVycyUzRChhZGFtX2JuYl9vcHRpbSUyQyUyME5vbmUpKQ==",highlighted:'trainer = Trainer(model=model, args=training_args, train_dataset=ds, optimizers=(adam_bnb_optim, <span class="hljs-literal">None</span>))'}}),Gt=new _({}),Yt=new _({}),Ft=new _({}),St=new _({}),Dt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHRvcmNoX2NvbXBpbGUlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(torch_compile=<span class="hljs-literal">True</span>, **default_args)'}}),sn=new _({}),cn=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqZGVmYXVsdF9hcmdzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    **default_args,
)`}}),fn=new x({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhLmRhdGFsb2FkZXIlMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZHMlMkMlMjBiYXRjaF9zaXplJTNEdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0ElMEElMjAlMjAlMjAlMjBtb2RlbC5ncmFkaWVudF9jaGVja3BvaW50aW5nX2VuYWJsZSgpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmcDE2JTNEdHJhaW5pbmdfYXJncy5mcDE2KSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBhZGFtX2JuYl9vcHRpbSUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKGRhdGFsb2FkZXIlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpLmxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjBpZiUyMHN0ZXAlMjAlMjUlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(ds, batch_size=training_args.per_device_train_batch_size)

<span class="hljs-keyword">if</span> training_args.gradient_checkpointing:
    model.gradient_checkpointing_enable()

accelerator = Accelerator(fp16=training_args.fp16)
model, optimizer, dataloader = accelerator.prepare(model, adam_bnb_optim, dataloader)

model.train()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader, start=<span class="hljs-number">1</span>):
    loss = model(**batch).loss
    loss = loss / training_args.gradient_accumulation_steps
    accelerator.backward(loss)
    <span class="hljs-keyword">if</span> step % training_args.gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        optimizer.zero_grad()`}}),vn=new _({}),_n=new _({}),Pn=new _({}),Gn=new x({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigp",highlighted:"model = model.to_bettertransformer()"}}),ue=new Aa({props:{warning:!0,$$slots:{default:[Bp]},$$scope:{ctx:C}}}),{c(){d=i("meta"),M=r(),w=i("p"),b=r(),$=i("h1"),T=i("a"),k=i("span"),f(me.$$.fragment),xr=r(),En=i("span"),En.textContent=Fr,Ha=r(),ge=i("p"),ge.innerHTML=Br,ja=r(),f(N.$$.fragment),za=r(),ve=i("p"),ve.textContent=Xr,Pa=r(),ye=i("ul"),ye.innerHTML=Nr,La=r(),we=i("p"),we.textContent=Sr,Wa=r(),be=i("p"),be.textContent=qr,Ga=r(),Me=i("p"),Me.textContent=Vr,Ia=r(),_e=i("table"),_e.innerHTML=Dr,Ya=r(),f(S.$$.fragment),Ra=r(),Te=i("p"),Te.innerHTML=Qr,Za=r(),xe=i("p"),xe.textContent=Kr,Ea=r(),Ce=i("ul"),Ce.innerHTML=Or,Fa=r(),$e=i("p"),$e.innerHTML=eo,Ba=r(),J=i("h2"),q=i("a"),oa=i("span"),f(ke.$$.fragment),Cr=r(),Fn=i("span"),Fn.textContent=to,Xa=r(),Je=i("p"),Je.textContent=no,Na=r(),Ae=i("p"),Ae.innerHTML=ao,Sa=r(),Ue=i("p"),Ue.innerHTML=io,qa=r(),He=i("p"),He.innerHTML=lo,Va=r(),A=i("h2"),V=i("a"),sa=i("span"),f(je.$$.fragment),$r=r(),Bn=i("span"),Bn.textContent=ro,Da=r(),ze=i("p"),ze.innerHTML=oo,Qa=r(),Pe=i("p"),Pe.innerHTML=so,Ka=r(),f(Le.$$.fragment),Oa=r(),We=i("p"),We.textContent=po,ei=r(),Ge=i("p"),Ge.innerHTML=ho,ti=r(),Ie=i("p"),Ie.innerHTML=co,ni=r(),Ye=i("p"),Ye.innerHTML=fo,ai=r(),U=i("h2"),D=i("a"),pa=i("span"),f(Re.$$.fragment),kr=r(),Xn=i("span"),Xn.textContent=uo,ii=r(),Ze=i("p"),Ze.textContent=mo,li=r(),Ee=i("p"),Ee.textContent=go,ri=r(),Fe=i("p"),Fe.innerHTML=vo,oi=r(),Be=i("p"),Be.innerHTML=yo,si=r(),f(Xe.$$.fragment),pi=r(),Ne=i("p"),Ne.innerHTML=wo,hi=r(),f(Q.$$.fragment),ci=r(),H=i("h2"),K=i("a"),ha=i("span"),f(Se.$$.fragment),Jr=r(),Nn=i("span"),Nn.textContent=bo,di=r(),qe=i("p"),qe.innerHTML=Mo,fi=r(),Ve=i("p"),Ve.innerHTML=_o,ui=r(),j=i("h3"),O=i("a"),ca=i("span"),f(De.$$.fragment),Ar=r(),Sn=i("span"),Sn.textContent=To,mi=r(),Qe=i("p"),Qe.textContent=xo,gi=r(),Ke=i("p"),Ke.innerHTML=Co,vi=r(),f(Oe.$$.fragment),yi=r(),et=i("p"),et.innerHTML=$o,wi=r(),z=i("h3"),ee=i("a"),da=i("span"),f(tt.$$.fragment),Ur=r(),qn=i("span"),qn.textContent=ko,bi=r(),nt=i("p"),nt.innerHTML=Jo,Mi=r(),at=i("p"),at.textContent=Ao,_i=r(),f(it.$$.fragment),Ti=r(),P=i("h3"),te=i("a"),fa=i("span"),f(lt.$$.fragment),Hr=r(),Vn=i("span"),Vn.textContent=Uo,xi=r(),rt=i("p"),rt.textContent=Ho,Ci=r(),f(ot.$$.fragment),$i=r(),st=i("p"),st.textContent=jo,ki=r(),pt=i("p"),pt.innerHTML=zo,Ji=r(),ht=i("p"),ht.textContent=Po,Ai=r(),f(ct.$$.fragment),Ui=r(),f(ne.$$.fragment),Hi=r(),dt=i("p"),dt.innerHTML=Lo,ji=r(),L=i("h2"),ae=i("a"),ua=i("span"),f(ft.$$.fragment),jr=r(),Dn=i("span"),Dn.textContent=Wo,zi=r(),ut=i("p"),ut.innerHTML=Go,Pi=r(),mt=i("p"),mt.innerHTML=Io,Li=r(),gt=i("p"),gt.textContent=Yo,Wi=r(),vt=i("ol"),vt.innerHTML=Ro,Gi=r(),yt=i("p"),yt.textContent=Zo,Ii=r(),wt=i("ul"),wt.innerHTML=Eo,Yi=r(),W=i("h3"),ie=i("a"),ma=i("span"),f(bt.$$.fragment),zr=r(),Qn=i("span"),Qn.textContent=Fo,Ri=r(),Mt=i("p"),Mt.textContent=Bo,Zi=r(),_t=i("p"),_t.innerHTML=Xo,Ei=r(),f(Tt.$$.fragment),Fi=r(),xt=i("p"),xt.textContent=No,Bi=r(),G=i("h3"),le=i("a"),ga=i("span"),f(Ct.$$.fragment),Pr=r(),Kn=i("span"),Kn.textContent=So,Xi=r(),$t=i("p"),$t.textContent=qo,Ni=r(),kt=i("p"),kt.innerHTML=Vo,Si=r(),f(Jt.$$.fragment),qi=r(),At=i("p"),At.textContent=Do,Vi=r(),Ut=i("p"),Ut.innerHTML=Qo,Di=r(),Ht=i("p"),Ht.textContent=Ko,Qi=r(),jt=i("ul"),jt.innerHTML=Oo,Ki=r(),f(zt.$$.fragment),Oi=r(),Pt=i("p"),Pt.innerHTML=es,el=r(),f(Lt.$$.fragment),tl=r(),Wt=i("p"),Wt.textContent=ts,nl=r(),I=i("h3"),re=i("a"),va=i("span"),f(Gt.$$.fragment),Lr=r(),On=i("span"),On.textContent=ns,al=r(),It=i("p"),It.innerHTML=as,il=r(),Y=i("h2"),oe=i("a"),ya=i("span"),f(Yt.$$.fragment),Wr=r(),ea=i("span"),ea.textContent=is,ll=r(),Rt=i("p"),Rt.textContent=ls,rl=r(),Zt=i("ul"),Zt.innerHTML=rs,ol=r(),Et=i("p"),Et.innerHTML=os,sl=r(),R=i("h2"),se=i("a"),wa=i("span"),f(Ft.$$.fragment),Gr=r(),ta=i("span"),ta.textContent=ss,pl=r(),Bt=i("p"),Bt.textContent=ps,hl=r(),Xt=i("p"),Xt.innerHTML=hs,cl=r(),Nt=i("ul"),Nt.innerHTML=cs,dl=r(),Z=i("h2"),pe=i("a"),ba=i("span"),f(St.$$.fragment),Ir=r(),na=i("span"),na.textContent=ds,fl=r(),qt=i("p"),qt.innerHTML=fs,ul=r(),Vt=i("p"),Vt.innerHTML=us,ml=r(),f(Dt.$$.fragment),gl=r(),Qt=i("p"),Qt.innerHTML=ms,vl=r(),Kt=i("p"),Kt.innerHTML=gs,yl=r(),Ot=i("p"),Ot.innerHTML=vs,wl=r(),en=i("p"),en.innerHTML=ys,bl=r(),tn=i("ul"),tn.innerHTML=ws,Ml=r(),nn=i("p"),nn.innerHTML=bs,_l=r(),an=i("ul"),an.innerHTML=Ms,Tl=r(),ln=i("p"),ln.innerHTML=_s,xl=r(),rn=i("ul"),rn.innerHTML=Ts,Cl=r(),on=i("p"),on.innerHTML=xs,$l=r(),E=i("h2"),he=i("a"),Ma=i("span"),f(sn.$$.fragment),Yr=r(),aa=i("span"),aa.textContent=Cs,kl=r(),pn=i("p"),pn.innerHTML=$s,Jl=r(),hn=i("p"),hn.innerHTML=ks,Al=r(),f(cn.$$.fragment),Ul=r(),dn=i("p"),dn.textContent=Js,Hl=r(),f(fn.$$.fragment),jl=r(),un=i("p"),un.innerHTML=As,zl=r(),mn=i("p"),mn.innerHTML=Us,Pl=r(),gn=i("p"),gn.innerHTML=Hs,Ll=r(),F=i("h2"),ce=i("a"),_a=i("span"),f(vn.$$.fragment),Rr=r(),ia=i("span"),ia.textContent=js,Wl=r(),yn=i("p"),yn.innerHTML=zs,Gl=r(),wn=i("p"),wn.innerHTML=Ps,Il=r(),bn=i("p"),bn.innerHTML=Ls,Yl=r(),Mn=i("p"),Mn.textContent=Ws,Rl=r(),B=i("h2"),de=i("a"),Ta=i("span"),f(_n.$$.fragment),Zr=r(),la=i("span"),la.textContent=Gs,Zl=r(),Tn=i("p"),Tn.textContent=Is,El=r(),xn=i("p"),xn.textContent=Ys,Fl=r(),Cn=i("p"),Cn.textContent=Rs,Bl=r(),$n=i("p"),$n.innerHTML=Zs,Xl=r(),kn=i("p"),kn.innerHTML=Es,Nl=r(),Jn=i("p"),Jn.textContent=Fs,Sl=r(),An=i("p"),An.textContent=Bs,ql=r(),Un=i("p"),Un.textContent=Xs,Vl=r(),Hn=i("p"),Hn.textContent=Ns,Dl=r(),jn=i("ul"),jn.innerHTML=Ss,Ql=r(),zn=i("p"),zn.innerHTML=qs,Kl=r(),X=i("h2"),fe=i("a"),xa=i("span"),f(Pn.$$.fragment),Er=r(),ra=i("span"),ra.textContent=Vs,Ol=r(),Ln=i("p"),Ln.innerHTML=Ds,er=r(),Wn=i("p"),Wn.innerHTML=Qs,tr=r(),f(Gn.$$.fragment),nr=r(),In=i("p"),In.textContent=Ks,ar=r(),f(ue.$$.fragment),ir=r(),Yn=i("p"),Yn.innerHTML=Os,lr=r(),Ca=i("p"),this.h()},l(e){const n=Yp("svelte-1phssyn",document.head);d=l(n,"META",{name:!0,content:!0}),n.forEach(t),M=o(e),w=l(e,"P",{}),c(w).forEach(t),b=o(e),$=l(e,"H1",{class:!0});var Rn=c($);T=l(Rn,"A",{id:!0,class:!0,href:!0});var $a=c(T);k=l($a,"SPAN",{});var ka=c(k);u(me.$$.fragment,ka),ka.forEach(t),$a.forEach(t),xr=o(Rn),En=l(Rn,"SPAN",{"data-svelte-h":!0}),s(En)!=="svelte-izxbuz"&&(En.textContent=Fr),Rn.forEach(t),Ha=o(e),ge=l(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-tqdu0u"&&(ge.innerHTML=Br),ja=o(e),u(N.$$.fragment,e),za=o(e),ve=l(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-4s75i8"&&(ve.textContent=Xr),Pa=o(e),ye=l(e,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-djgcn1"&&(ye.innerHTML=Nr),La=o(e),we=l(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-uf18r4"&&(we.textContent=Sr),Wa=o(e),be=l(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-b3xmwb"&&(be.textContent=qr),Ga=o(e),Me=l(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-1qbc4zp"&&(Me.textContent=Vr),Ia=o(e),_e=l(e,"TABLE",{"data-svelte-h":!0}),s(_e)!=="svelte-15stut3"&&(_e.innerHTML=Dr),Ya=o(e),u(S.$$.fragment,e),Ra=o(e),Te=l(e,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-bnmzn2"&&(Te.innerHTML=Qr),Za=o(e),xe=l(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1thjxg4"&&(xe.textContent=Kr),Ea=o(e),Ce=l(e,"UL",{"data-svelte-h":!0}),s(Ce)!=="svelte-18kwup6"&&(Ce.innerHTML=Or),Fa=o(e),$e=l(e,"P",{"data-svelte-h":!0}),s($e)!=="svelte-1uvbmrd"&&($e.innerHTML=eo),Ba=o(e),J=l(e,"H2",{class:!0});var Zn=c(J);q=l(Zn,"A",{id:!0,class:!0,href:!0});var Ja=c(q);oa=l(Ja,"SPAN",{});var ep=c(oa);u(ke.$$.fragment,ep),ep.forEach(t),Ja.forEach(t),Cr=o(Zn),Fn=l(Zn,"SPAN",{"data-svelte-h":!0}),s(Fn)!=="svelte-124zq07"&&(Fn.textContent=to),Zn.forEach(t),Xa=o(e),Je=l(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1f9wkzb"&&(Je.textContent=no),Na=o(e),Ae=l(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-h1ek0g"&&(Ae.innerHTML=ao),Sa=o(e),Ue=l(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-sfn5k1"&&(Ue.innerHTML=io),qa=o(e),He=l(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-wvp8kx"&&(He.innerHTML=lo),Va=o(e),A=l(e,"H2",{class:!0});var or=c(A);V=l(or,"A",{id:!0,class:!0,href:!0});var tp=c(V);sa=l(tp,"SPAN",{});var np=c(sa);u(je.$$.fragment,np),np.forEach(t),tp.forEach(t),$r=o(or),Bn=l(or,"SPAN",{"data-svelte-h":!0}),s(Bn)!=="svelte-1hbfta0"&&(Bn.textContent=ro),or.forEach(t),Da=o(e),ze=l(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-1l7rfkq"&&(ze.innerHTML=oo),Qa=o(e),Pe=l(e,"P",{"data-svelte-h":!0}),s(Pe)!=="svelte-189ss27"&&(Pe.innerHTML=so),Ka=o(e),u(Le.$$.fragment,e),Oa=o(e),We=l(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-18ky75y"&&(We.textContent=po),ei=o(e),Ge=l(e,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-khctnv"&&(Ge.innerHTML=ho),ti=o(e),Ie=l(e,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-1bitspm"&&(Ie.innerHTML=co),ni=o(e),Ye=l(e,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-nbfonf"&&(Ye.innerHTML=fo),ai=o(e),U=l(e,"H2",{class:!0});var sr=c(U);D=l(sr,"A",{id:!0,class:!0,href:!0});var ap=c(D);pa=l(ap,"SPAN",{});var ip=c(pa);u(Re.$$.fragment,ip),ip.forEach(t),ap.forEach(t),kr=o(sr),Xn=l(sr,"SPAN",{"data-svelte-h":!0}),s(Xn)!=="svelte-1p42uqz"&&(Xn.textContent=uo),sr.forEach(t),ii=o(e),Ze=l(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-n1qbw"&&(Ze.textContent=mo),li=o(e),Ee=l(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1419dmv"&&(Ee.textContent=go),ri=o(e),Fe=l(e,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-nfo3gu"&&(Fe.innerHTML=vo),oi=o(e),Be=l(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-dweu6n"&&(Be.innerHTML=yo),si=o(e),u(Xe.$$.fragment,e),pi=o(e),Ne=l(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-1wwrmcl"&&(Ne.innerHTML=wo),hi=o(e),u(Q.$$.fragment,e),ci=o(e),H=l(e,"H2",{class:!0});var pr=c(H);K=l(pr,"A",{id:!0,class:!0,href:!0});var lp=c(K);ha=l(lp,"SPAN",{});var rp=c(ha);u(Se.$$.fragment,rp),rp.forEach(t),lp.forEach(t),Jr=o(pr),Nn=l(pr,"SPAN",{"data-svelte-h":!0}),s(Nn)!=="svelte-h7a0sg"&&(Nn.textContent=bo),pr.forEach(t),di=o(e),qe=l(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-7pqnv0"&&(qe.innerHTML=Mo),fi=o(e),Ve=l(e,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-1ttanpy"&&(Ve.innerHTML=_o),ui=o(e),j=l(e,"H3",{class:!0});var hr=c(j);O=l(hr,"A",{id:!0,class:!0,href:!0});var op=c(O);ca=l(op,"SPAN",{});var sp=c(ca);u(De.$$.fragment,sp),sp.forEach(t),op.forEach(t),Ar=o(hr),Sn=l(hr,"SPAN",{"data-svelte-h":!0}),s(Sn)!=="svelte-1pscsni"&&(Sn.textContent=To),hr.forEach(t),mi=o(e),Qe=l(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-h2t8go"&&(Qe.textContent=xo),gi=o(e),Ke=l(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-wwg09w"&&(Ke.innerHTML=Co),vi=o(e),u(Oe.$$.fragment,e),yi=o(e),et=l(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-11fsu6r"&&(et.innerHTML=$o),wi=o(e),z=l(e,"H3",{class:!0});var cr=c(z);ee=l(cr,"A",{id:!0,class:!0,href:!0});var pp=c(ee);da=l(pp,"SPAN",{});var hp=c(da);u(tt.$$.fragment,hp),hp.forEach(t),pp.forEach(t),Ur=o(cr),qn=l(cr,"SPAN",{"data-svelte-h":!0}),s(qn)!=="svelte-13por1k"&&(qn.textContent=ko),cr.forEach(t),bi=o(e),nt=l(e,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-1p48z2n"&&(nt.innerHTML=Jo),Mi=o(e),at=l(e,"P",{"data-svelte-h":!0}),s(at)!=="svelte-vq639r"&&(at.textContent=Ao),_i=o(e),u(it.$$.fragment,e),Ti=o(e),P=l(e,"H3",{class:!0});var dr=c(P);te=l(dr,"A",{id:!0,class:!0,href:!0});var cp=c(te);fa=l(cp,"SPAN",{});var dp=c(fa);u(lt.$$.fragment,dp),dp.forEach(t),cp.forEach(t),Hr=o(dr),Vn=l(dr,"SPAN",{"data-svelte-h":!0}),s(Vn)!=="svelte-whoyjk"&&(Vn.textContent=Uo),dr.forEach(t),xi=o(e),rt=l(e,"P",{"data-svelte-h":!0}),s(rt)!=="svelte-7szee7"&&(rt.textContent=Ho),Ci=o(e),u(ot.$$.fragment,e),$i=o(e),st=l(e,"P",{"data-svelte-h":!0}),s(st)!=="svelte-1kvnj8w"&&(st.textContent=jo),ki=o(e),pt=l(e,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-alc3bu"&&(pt.innerHTML=zo),Ji=o(e),ht=l(e,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-d0keh1"&&(ht.textContent=Po),Ai=o(e),u(ct.$$.fragment,e),Ui=o(e),u(ne.$$.fragment,e),Hi=o(e),dt=l(e,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-dzrbtx"&&(dt.innerHTML=Lo),ji=o(e),L=l(e,"H2",{class:!0});var fr=c(L);ae=l(fr,"A",{id:!0,class:!0,href:!0});var fp=c(ae);ua=l(fp,"SPAN",{});var up=c(ua);u(ft.$$.fragment,up),up.forEach(t),fp.forEach(t),jr=o(fr),Dn=l(fr,"SPAN",{"data-svelte-h":!0}),s(Dn)!=="svelte-166mczz"&&(Dn.textContent=Wo),fr.forEach(t),zi=o(e),ut=l(e,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-xkv29v"&&(ut.innerHTML=Go),Pi=o(e),mt=l(e,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-j6xg2k"&&(mt.innerHTML=Io),Li=o(e),gt=l(e,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-1qfw41"&&(gt.textContent=Yo),Wi=o(e),vt=l(e,"OL",{"data-svelte-h":!0}),s(vt)!=="svelte-12rvckj"&&(vt.innerHTML=Ro),Gi=o(e),yt=l(e,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-2mb823"&&(yt.textContent=Zo),Ii=o(e),wt=l(e,"UL",{"data-svelte-h":!0}),s(wt)!=="svelte-ajuctj"&&(wt.innerHTML=Eo),Yi=o(e),W=l(e,"H3",{class:!0});var ur=c(W);ie=l(ur,"A",{id:!0,class:!0,href:!0});var mp=c(ie);ma=l(mp,"SPAN",{});var gp=c(ma);u(bt.$$.fragment,gp),gp.forEach(t),mp.forEach(t),zr=o(ur),Qn=l(ur,"SPAN",{"data-svelte-h":!0}),s(Qn)!=="svelte-cj5f8s"&&(Qn.textContent=Fo),ur.forEach(t),Ri=o(e),Mt=l(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-19jpav8"&&(Mt.textContent=Bo),Zi=o(e),_t=l(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-1qyoqn3"&&(_t.innerHTML=Xo),Ei=o(e),u(Tt.$$.fragment,e),Fi=o(e),xt=l(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-1850zf2"&&(xt.textContent=No),Bi=o(e),G=l(e,"H3",{class:!0});var mr=c(G);le=l(mr,"A",{id:!0,class:!0,href:!0});var vp=c(le);ga=l(vp,"SPAN",{});var yp=c(ga);u(Ct.$$.fragment,yp),yp.forEach(t),vp.forEach(t),Pr=o(mr),Kn=l(mr,"SPAN",{"data-svelte-h":!0}),s(Kn)!=="svelte-6mb76"&&(Kn.textContent=So),mr.forEach(t),Xi=o(e),$t=l(e,"P",{"data-svelte-h":!0}),s($t)!=="svelte-1ld1y8t"&&($t.textContent=qo),Ni=o(e),kt=l(e,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-3fp3rb"&&(kt.innerHTML=Vo),Si=o(e),u(Jt.$$.fragment,e),qi=o(e),At=l(e,"P",{"data-svelte-h":!0}),s(At)!=="svelte-czmcu6"&&(At.textContent=Do),Vi=o(e),Ut=l(e,"P",{"data-svelte-h":!0}),s(Ut)!=="svelte-1av8920"&&(Ut.innerHTML=Qo),Di=o(e),Ht=l(e,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-19nyc4u"&&(Ht.textContent=Ko),Qi=o(e),jt=l(e,"UL",{"data-svelte-h":!0}),s(jt)!=="svelte-8z8ok2"&&(jt.innerHTML=Oo),Ki=o(e),u(zt.$$.fragment,e),Oi=o(e),Pt=l(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-n8bkwf"&&(Pt.innerHTML=es),el=o(e),u(Lt.$$.fragment,e),tl=o(e),Wt=l(e,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1egi1g7"&&(Wt.textContent=ts),nl=o(e),I=l(e,"H3",{class:!0});var gr=c(I);re=l(gr,"A",{id:!0,class:!0,href:!0});var wp=c(re);va=l(wp,"SPAN",{});var bp=c(va);u(Gt.$$.fragment,bp),bp.forEach(t),wp.forEach(t),Lr=o(gr),On=l(gr,"SPAN",{"data-svelte-h":!0}),s(On)!=="svelte-frs5m8"&&(On.textContent=ns),gr.forEach(t),al=o(e),It=l(e,"P",{"data-svelte-h":!0}),s(It)!=="svelte-1cvgqaq"&&(It.innerHTML=as),il=o(e),Y=l(e,"H2",{class:!0});var vr=c(Y);oe=l(vr,"A",{id:!0,class:!0,href:!0});var Mp=c(oe);ya=l(Mp,"SPAN",{});var _p=c(ya);u(Yt.$$.fragment,_p),_p.forEach(t),Mp.forEach(t),Wr=o(vr),ea=l(vr,"SPAN",{"data-svelte-h":!0}),s(ea)!=="svelte-mumppk"&&(ea.textContent=is),vr.forEach(t),ll=o(e),Rt=l(e,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-16tninz"&&(Rt.textContent=ls),rl=o(e),Zt=l(e,"UL",{"data-svelte-h":!0}),s(Zt)!=="svelte-1i85v8g"&&(Zt.innerHTML=rs),ol=o(e),Et=l(e,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-1iaud1"&&(Et.innerHTML=os),sl=o(e),R=l(e,"H2",{class:!0});var yr=c(R);se=l(yr,"A",{id:!0,class:!0,href:!0});var Tp=c(se);wa=l(Tp,"SPAN",{});var xp=c(wa);u(Ft.$$.fragment,xp),xp.forEach(t),Tp.forEach(t),Gr=o(yr),ta=l(yr,"SPAN",{"data-svelte-h":!0}),s(ta)!=="svelte-19d84u2"&&(ta.textContent=ss),yr.forEach(t),pl=o(e),Bt=l(e,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-1onp6io"&&(Bt.textContent=ps),hl=o(e),Xt=l(e,"P",{"data-svelte-h":!0}),s(Xt)!=="svelte-18hg7g"&&(Xt.innerHTML=hs),cl=o(e),Nt=l(e,"UL",{"data-svelte-h":!0}),s(Nt)!=="svelte-18f97ck"&&(Nt.innerHTML=cs),dl=o(e),Z=l(e,"H2",{class:!0});var wr=c(Z);pe=l(wr,"A",{id:!0,class:!0,href:!0});var Cp=c(pe);ba=l(Cp,"SPAN",{});var $p=c(ba);u(St.$$.fragment,$p),$p.forEach(t),Cp.forEach(t),Ir=o(wr),na=l(wr,"SPAN",{"data-svelte-h":!0}),s(na)!=="svelte-1mhqvvq"&&(na.textContent=ds),wr.forEach(t),fl=o(e),qt=l(e,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-5qw0v5"&&(qt.innerHTML=fs),ul=o(e),Vt=l(e,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-108njcc"&&(Vt.innerHTML=us),ml=o(e),u(Dt.$$.fragment,e),gl=o(e),Qt=l(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1y4s25e"&&(Qt.innerHTML=ms),vl=o(e),Kt=l(e,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-jluuok"&&(Kt.innerHTML=gs),yl=o(e),Ot=l(e,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-1hc0pwa"&&(Ot.innerHTML=vs),wl=o(e),en=l(e,"P",{"data-svelte-h":!0}),s(en)!=="svelte-v82kng"&&(en.innerHTML=ys),bl=o(e),tn=l(e,"UL",{"data-svelte-h":!0}),s(tn)!=="svelte-1dbgjs7"&&(tn.innerHTML=ws),Ml=o(e),nn=l(e,"P",{"data-svelte-h":!0}),s(nn)!=="svelte-m2qf5f"&&(nn.innerHTML=bs),_l=o(e),an=l(e,"UL",{"data-svelte-h":!0}),s(an)!=="svelte-x9b2wm"&&(an.innerHTML=Ms),Tl=o(e),ln=l(e,"P",{"data-svelte-h":!0}),s(ln)!=="svelte-78l3h4"&&(ln.innerHTML=_s),xl=o(e),rn=l(e,"UL",{"data-svelte-h":!0}),s(rn)!=="svelte-1y0itbi"&&(rn.innerHTML=Ts),Cl=o(e),on=l(e,"P",{"data-svelte-h":!0}),s(on)!=="svelte-1prqm7s"&&(on.innerHTML=xs),$l=o(e),E=l(e,"H2",{class:!0});var br=c(E);he=l(br,"A",{id:!0,class:!0,href:!0});var kp=c(he);Ma=l(kp,"SPAN",{});var Jp=c(Ma);u(sn.$$.fragment,Jp),Jp.forEach(t),kp.forEach(t),Yr=o(br),aa=l(br,"SPAN",{"data-svelte-h":!0}),s(aa)!=="svelte-97dpbf"&&(aa.textContent=Cs),br.forEach(t),kl=o(e),pn=l(e,"P",{"data-svelte-h":!0}),s(pn)!=="svelte-d91a9c"&&(pn.innerHTML=$s),Jl=o(e),hn=l(e,"P",{"data-svelte-h":!0}),s(hn)!=="svelte-10f4kuh"&&(hn.innerHTML=ks),Al=o(e),u(cn.$$.fragment,e),Ul=o(e),dn=l(e,"P",{"data-svelte-h":!0}),s(dn)!=="svelte-eja69v"&&(dn.textContent=Js),Hl=o(e),u(fn.$$.fragment,e),jl=o(e),un=l(e,"P",{"data-svelte-h":!0}),s(un)!=="svelte-8fwwt"&&(un.innerHTML=As),zl=o(e),mn=l(e,"P",{"data-svelte-h":!0}),s(mn)!=="svelte-i5733s"&&(mn.innerHTML=Us),Pl=o(e),gn=l(e,"P",{"data-svelte-h":!0}),s(gn)!=="svelte-1caz98g"&&(gn.innerHTML=Hs),Ll=o(e),F=l(e,"H2",{class:!0});var Mr=c(F);ce=l(Mr,"A",{id:!0,class:!0,href:!0});var Ap=c(ce);_a=l(Ap,"SPAN",{});var Up=c(_a);u(vn.$$.fragment,Up),Up.forEach(t),Ap.forEach(t),Rr=o(Mr),ia=l(Mr,"SPAN",{"data-svelte-h":!0}),s(ia)!=="svelte-1noxph5"&&(ia.textContent=js),Mr.forEach(t),Wl=o(e),yn=l(e,"P",{"data-svelte-h":!0}),s(yn)!=="svelte-nmhpgl"&&(yn.innerHTML=zs),Gl=o(e),wn=l(e,"P",{"data-svelte-h":!0}),s(wn)!=="svelte-kxuhyz"&&(wn.innerHTML=Ps),Il=o(e),bn=l(e,"P",{"data-svelte-h":!0}),s(bn)!=="svelte-qkuwkx"&&(bn.innerHTML=Ls),Yl=o(e),Mn=l(e,"P",{"data-svelte-h":!0}),s(Mn)!=="svelte-16g8p4x"&&(Mn.textContent=Ws),Rl=o(e),B=l(e,"H2",{class:!0});var _r=c(B);de=l(_r,"A",{id:!0,class:!0,href:!0});var Hp=c(de);Ta=l(Hp,"SPAN",{});var jp=c(Ta);u(_n.$$.fragment,jp),jp.forEach(t),Hp.forEach(t),Zr=o(_r),la=l(_r,"SPAN",{"data-svelte-h":!0}),s(la)!=="svelte-ei820d"&&(la.textContent=Gs),_r.forEach(t),Zl=o(e),Tn=l(e,"P",{"data-svelte-h":!0}),s(Tn)!=="svelte-1aawf57"&&(Tn.textContent=Is),El=o(e),xn=l(e,"P",{"data-svelte-h":!0}),s(xn)!=="svelte-ln9ugc"&&(xn.textContent=Ys),Fl=o(e),Cn=l(e,"P",{"data-svelte-h":!0}),s(Cn)!=="svelte-1ett6yb"&&(Cn.textContent=Rs),Bl=o(e),$n=l(e,"P",{"data-svelte-h":!0}),s($n)!=="svelte-tdgts9"&&($n.innerHTML=Zs),Xl=o(e),kn=l(e,"P",{"data-svelte-h":!0}),s(kn)!=="svelte-z2dori"&&(kn.innerHTML=Es),Nl=o(e),Jn=l(e,"P",{"data-svelte-h":!0}),s(Jn)!=="svelte-1gc8znk"&&(Jn.textContent=Fs),Sl=o(e),An=l(e,"P",{"data-svelte-h":!0}),s(An)!=="svelte-13sa7m0"&&(An.textContent=Bs),ql=o(e),Un=l(e,"P",{"data-svelte-h":!0}),s(Un)!=="svelte-dxh8d5"&&(Un.textContent=Xs),Vl=o(e),Hn=l(e,"P",{"data-svelte-h":!0}),s(Hn)!=="svelte-1jfhyzg"&&(Hn.textContent=Ns),Dl=o(e),jn=l(e,"UL",{"data-svelte-h":!0}),s(jn)!=="svelte-1fjc55v"&&(jn.innerHTML=Ss),Ql=o(e),zn=l(e,"P",{"data-svelte-h":!0}),s(zn)!=="svelte-o7v7js"&&(zn.innerHTML=qs),Kl=o(e),X=l(e,"H2",{class:!0});var Tr=c(X);fe=l(Tr,"A",{id:!0,class:!0,href:!0});var zp=c(fe);xa=l(zp,"SPAN",{});var Pp=c(xa);u(Pn.$$.fragment,Pp),Pp.forEach(t),zp.forEach(t),Er=o(Tr),ra=l(Tr,"SPAN",{"data-svelte-h":!0}),s(ra)!=="svelte-14vlou"&&(ra.textContent=Vs),Tr.forEach(t),Ol=o(e),Ln=l(e,"P",{"data-svelte-h":!0}),s(Ln)!=="svelte-10jsqxr"&&(Ln.innerHTML=Ds),er=o(e),Wn=l(e,"P",{"data-svelte-h":!0}),s(Wn)!=="svelte-mg6n76"&&(Wn.innerHTML=Qs),tr=o(e),u(Gn.$$.fragment,e),nr=o(e),In=l(e,"P",{"data-svelte-h":!0}),s(In)!=="svelte-wfi44p"&&(In.textContent=Ks),ar=o(e),u(ue.$$.fragment,e),ir=o(e),Yn=l(e,"P",{"data-svelte-h":!0}),s(Yn)!=="svelte-1r3sioy"&&(Yn.innerHTML=Os),lr=o(e),Ca=l(e,"P",{}),c(Ca).forEach(t),this.h()},h(){p(d,"name","hf:doc:metadata"),p(d,"content",JSON.stringify(Np)),p(T,"id","methods-and-tools-for-efficient-training-on-a-single-gpu"),p(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(T,"href","#methods-and-tools-for-efficient-training-on-a-single-gpu"),p($,"class","relative group"),p(q,"id","batch-size-choice"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#batch-size-choice"),p(J,"class","relative group"),p(V,"id","gradient-accumulation"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#gradient-accumulation"),p(A,"class","relative group"),p(D,"id","gradient-checkpointing"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#gradient-checkpointing"),p(U,"class","relative group"),p(K,"id","mixed-precision-training"),p(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(K,"href","#mixed-precision-training"),p(H,"class","relative group"),p(O,"id","fp16"),p(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(O,"href","#fp16"),p(j,"class","relative group"),p(ee,"id","bf16"),p(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ee,"href","#bf16"),p(z,"class","relative group"),p(te,"id","tf32"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#tf32"),p(P,"class","relative group"),p(ae,"id","optimizer-choice"),p(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ae,"href","#optimizer-choice"),p(L,"class","relative group"),p(ie,"id","adafactor"),p(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ie,"href","#adafactor"),p(W,"class","relative group"),p(le,"id","8bit-adam"),p(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(le,"href","#8bit-adam"),p(G,"class","relative group"),p(re,"id","multitensor"),p(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(re,"href","#multitensor"),p(I,"class","relative group"),p(oe,"id","data-preloading"),p(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(oe,"href","#data-preloading"),p(Y,"class","relative group"),p(se,"id","deepspeed-zero"),p(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(se,"href","#deepspeed-zero"),p(R,"class","relative group"),p(pe,"id","using-torchcompile"),p(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(pe,"href","#using-torchcompile"),p(Z,"class","relative group"),p(he,"id","using-accelerate"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#using-accelerate"),p(E,"class","relative group"),p(ce,"id","efficient-software-prebuilds"),p(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ce,"href","#efficient-software-prebuilds"),p(F,"class","relative group"),p(de,"id","mixture-of-experts"),p(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(de,"href","#mixture-of-experts"),p(B,"class","relative group"),p(fe,"id","using-pytorch-native-attention-and-flash-attention"),p(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(fe,"href","#using-pytorch-native-attention-and-flash-attention"),p(X,"class","relative group")},m(e,n){h(document.head,d),a(e,M,n),a(e,w,n),a(e,b,n),a(e,$,n),h($,T),h(T,k),m(me,k,null),h($,xr),h($,En),a(e,Ha,n),a(e,ge,n),a(e,ja,n),m(N,e,n),a(e,za,n),a(e,ve,n),a(e,Pa,n),a(e,ye,n),a(e,La,n),a(e,we,n),a(e,Wa,n),a(e,be,n),a(e,Ga,n),a(e,Me,n),a(e,Ia,n),a(e,_e,n),a(e,Ya,n),m(S,e,n),a(e,Ra,n),a(e,Te,n),a(e,Za,n),a(e,xe,n),a(e,Ea,n),a(e,Ce,n),a(e,Fa,n),a(e,$e,n),a(e,Ba,n),a(e,J,n),h(J,q),h(q,oa),m(ke,oa,null),h(J,Cr),h(J,Fn),a(e,Xa,n),a(e,Je,n),a(e,Na,n),a(e,Ae,n),a(e,Sa,n),a(e,Ue,n),a(e,qa,n),a(e,He,n),a(e,Va,n),a(e,A,n),h(A,V),h(V,sa),m(je,sa,null),h(A,$r),h(A,Bn),a(e,Da,n),a(e,ze,n),a(e,Qa,n),a(e,Pe,n),a(e,Ka,n),m(Le,e,n),a(e,Oa,n),a(e,We,n),a(e,ei,n),a(e,Ge,n),a(e,ti,n),a(e,Ie,n),a(e,ni,n),a(e,Ye,n),a(e,ai,n),a(e,U,n),h(U,D),h(D,pa),m(Re,pa,null),h(U,kr),h(U,Xn),a(e,ii,n),a(e,Ze,n),a(e,li,n),a(e,Ee,n),a(e,ri,n),a(e,Fe,n),a(e,oi,n),a(e,Be,n),a(e,si,n),m(Xe,e,n),a(e,pi,n),a(e,Ne,n),a(e,hi,n),m(Q,e,n),a(e,ci,n),a(e,H,n),h(H,K),h(K,ha),m(Se,ha,null),h(H,Jr),h(H,Nn),a(e,di,n),a(e,qe,n),a(e,fi,n),a(e,Ve,n),a(e,ui,n),a(e,j,n),h(j,O),h(O,ca),m(De,ca,null),h(j,Ar),h(j,Sn),a(e,mi,n),a(e,Qe,n),a(e,gi,n),a(e,Ke,n),a(e,vi,n),m(Oe,e,n),a(e,yi,n),a(e,et,n),a(e,wi,n),a(e,z,n),h(z,ee),h(ee,da),m(tt,da,null),h(z,Ur),h(z,qn),a(e,bi,n),a(e,nt,n),a(e,Mi,n),a(e,at,n),a(e,_i,n),m(it,e,n),a(e,Ti,n),a(e,P,n),h(P,te),h(te,fa),m(lt,fa,null),h(P,Hr),h(P,Vn),a(e,xi,n),a(e,rt,n),a(e,Ci,n),m(ot,e,n),a(e,$i,n),a(e,st,n),a(e,ki,n),a(e,pt,n),a(e,Ji,n),a(e,ht,n),a(e,Ai,n),m(ct,e,n),a(e,Ui,n),m(ne,e,n),a(e,Hi,n),a(e,dt,n),a(e,ji,n),a(e,L,n),h(L,ae),h(ae,ua),m(ft,ua,null),h(L,jr),h(L,Dn),a(e,zi,n),a(e,ut,n),a(e,Pi,n),a(e,mt,n),a(e,Li,n),a(e,gt,n),a(e,Wi,n),a(e,vt,n),a(e,Gi,n),a(e,yt,n),a(e,Ii,n),a(e,wt,n),a(e,Yi,n),a(e,W,n),h(W,ie),h(ie,ma),m(bt,ma,null),h(W,zr),h(W,Qn),a(e,Ri,n),a(e,Mt,n),a(e,Zi,n),a(e,_t,n),a(e,Ei,n),m(Tt,e,n),a(e,Fi,n),a(e,xt,n),a(e,Bi,n),a(e,G,n),h(G,le),h(le,ga),m(Ct,ga,null),h(G,Pr),h(G,Kn),a(e,Xi,n),a(e,$t,n),a(e,Ni,n),a(e,kt,n),a(e,Si,n),m(Jt,e,n),a(e,qi,n),a(e,At,n),a(e,Vi,n),a(e,Ut,n),a(e,Di,n),a(e,Ht,n),a(e,Qi,n),a(e,jt,n),a(e,Ki,n),m(zt,e,n),a(e,Oi,n),a(e,Pt,n),a(e,el,n),m(Lt,e,n),a(e,tl,n),a(e,Wt,n),a(e,nl,n),a(e,I,n),h(I,re),h(re,va),m(Gt,va,null),h(I,Lr),h(I,On),a(e,al,n),a(e,It,n),a(e,il,n),a(e,Y,n),h(Y,oe),h(oe,ya),m(Yt,ya,null),h(Y,Wr),h(Y,ea),a(e,ll,n),a(e,Rt,n),a(e,rl,n),a(e,Zt,n),a(e,ol,n),a(e,Et,n),a(e,sl,n),a(e,R,n),h(R,se),h(se,wa),m(Ft,wa,null),h(R,Gr),h(R,ta),a(e,pl,n),a(e,Bt,n),a(e,hl,n),a(e,Xt,n),a(e,cl,n),a(e,Nt,n),a(e,dl,n),a(e,Z,n),h(Z,pe),h(pe,ba),m(St,ba,null),h(Z,Ir),h(Z,na),a(e,fl,n),a(e,qt,n),a(e,ul,n),a(e,Vt,n),a(e,ml,n),m(Dt,e,n),a(e,gl,n),a(e,Qt,n),a(e,vl,n),a(e,Kt,n),a(e,yl,n),a(e,Ot,n),a(e,wl,n),a(e,en,n),a(e,bl,n),a(e,tn,n),a(e,Ml,n),a(e,nn,n),a(e,_l,n),a(e,an,n),a(e,Tl,n),a(e,ln,n),a(e,xl,n),a(e,rn,n),a(e,Cl,n),a(e,on,n),a(e,$l,n),a(e,E,n),h(E,he),h(he,Ma),m(sn,Ma,null),h(E,Yr),h(E,aa),a(e,kl,n),a(e,pn,n),a(e,Jl,n),a(e,hn,n),a(e,Al,n),m(cn,e,n),a(e,Ul,n),a(e,dn,n),a(e,Hl,n),m(fn,e,n),a(e,jl,n),a(e,un,n),a(e,zl,n),a(e,mn,n),a(e,Pl,n),a(e,gn,n),a(e,Ll,n),a(e,F,n),h(F,ce),h(ce,_a),m(vn,_a,null),h(F,Rr),h(F,ia),a(e,Wl,n),a(e,yn,n),a(e,Gl,n),a(e,wn,n),a(e,Il,n),a(e,bn,n),a(e,Yl,n),a(e,Mn,n),a(e,Rl,n),a(e,B,n),h(B,de),h(de,Ta),m(_n,Ta,null),h(B,Zr),h(B,la),a(e,Zl,n),a(e,Tn,n),a(e,El,n),a(e,xn,n),a(e,Fl,n),a(e,Cn,n),a(e,Bl,n),a(e,$n,n),a(e,Xl,n),a(e,kn,n),a(e,Nl,n),a(e,Jn,n),a(e,Sl,n),a(e,An,n),a(e,ql,n),a(e,Un,n),a(e,Vl,n),a(e,Hn,n),a(e,Dl,n),a(e,jn,n),a(e,Ql,n),a(e,zn,n),a(e,Kl,n),a(e,X,n),h(X,fe),h(fe,xa),m(Pn,xa,null),h(X,Er),h(X,ra),a(e,Ol,n),a(e,Ln,n),a(e,er,n),a(e,Wn,n),a(e,tr,n),m(Gn,e,n),a(e,nr,n),a(e,In,n),a(e,ar,n),m(ue,e,n),a(e,ir,n),a(e,Yn,n),a(e,lr,n),a(e,Ca,n),rr=!0},p(e,[n]){const Rn={};n&2&&(Rn.$$scope={dirty:n,ctx:e}),N.$set(Rn);const $a={};n&2&&($a.$$scope={dirty:n,ctx:e}),S.$set($a);const ka={};n&2&&(ka.$$scope={dirty:n,ctx:e}),Q.$set(ka);const Zn={};n&2&&(Zn.$$scope={dirty:n,ctx:e}),ne.$set(Zn);const Ja={};n&2&&(Ja.$$scope={dirty:n,ctx:e}),ue.$set(Ja)},i(e){rr||(g(me.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(ke.$$.fragment,e),g(je.$$.fragment,e),g(Le.$$.fragment,e),g(Re.$$.fragment,e),g(Xe.$$.fragment,e),g(Q.$$.fragment,e),g(Se.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(tt.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(ot.$$.fragment,e),g(ct.$$.fragment,e),g(ne.$$.fragment,e),g(ft.$$.fragment,e),g(bt.$$.fragment,e),g(Tt.$$.fragment,e),g(Ct.$$.fragment,e),g(Jt.$$.fragment,e),g(zt.$$.fragment,e),g(Lt.$$.fragment,e),g(Gt.$$.fragment,e),g(Yt.$$.fragment,e),g(Ft.$$.fragment,e),g(St.$$.fragment,e),g(Dt.$$.fragment,e),g(sn.$$.fragment,e),g(cn.$$.fragment,e),g(fn.$$.fragment,e),g(vn.$$.fragment,e),g(_n.$$.fragment,e),g(Pn.$$.fragment,e),g(Gn.$$.fragment,e),g(ue.$$.fragment,e),rr=!0)},o(e){v(me.$$.fragment,e),v(N.$$.fragment,e),v(S.$$.fragment,e),v(ke.$$.fragment,e),v(je.$$.fragment,e),v(Le.$$.fragment,e),v(Re.$$.fragment,e),v(Xe.$$.fragment,e),v(Q.$$.fragment,e),v(Se.$$.fragment,e),v(De.$$.fragment,e),v(Oe.$$.fragment,e),v(tt.$$.fragment,e),v(it.$$.fragment,e),v(lt.$$.fragment,e),v(ot.$$.fragment,e),v(ct.$$.fragment,e),v(ne.$$.fragment,e),v(ft.$$.fragment,e),v(bt.$$.fragment,e),v(Tt.$$.fragment,e),v(Ct.$$.fragment,e),v(Jt.$$.fragment,e),v(zt.$$.fragment,e),v(Lt.$$.fragment,e),v(Gt.$$.fragment,e),v(Yt.$$.fragment,e),v(Ft.$$.fragment,e),v(St.$$.fragment,e),v(Dt.$$.fragment,e),v(sn.$$.fragment,e),v(cn.$$.fragment,e),v(fn.$$.fragment,e),v(vn.$$.fragment,e),v(_n.$$.fragment,e),v(Pn.$$.fragment,e),v(Gn.$$.fragment,e),v(ue.$$.fragment,e),rr=!1},d(e){e&&(t(M),t(w),t(b),t($),t(Ha),t(ge),t(ja),t(za),t(ve),t(Pa),t(ye),t(La),t(we),t(Wa),t(be),t(Ga),t(Me),t(Ia),t(_e),t(Ya),t(Ra),t(Te),t(Za),t(xe),t(Ea),t(Ce),t(Fa),t($e),t(Ba),t(J),t(Xa),t(Je),t(Na),t(Ae),t(Sa),t(Ue),t(qa),t(He),t(Va),t(A),t(Da),t(ze),t(Qa),t(Pe),t(Ka),t(Oa),t(We),t(ei),t(Ge),t(ti),t(Ie),t(ni),t(Ye),t(ai),t(U),t(ii),t(Ze),t(li),t(Ee),t(ri),t(Fe),t(oi),t(Be),t(si),t(pi),t(Ne),t(hi),t(ci),t(H),t(di),t(qe),t(fi),t(Ve),t(ui),t(j),t(mi),t(Qe),t(gi),t(Ke),t(vi),t(yi),t(et),t(wi),t(z),t(bi),t(nt),t(Mi),t(at),t(_i),t(Ti),t(P),t(xi),t(rt),t(Ci),t($i),t(st),t(ki),t(pt),t(Ji),t(ht),t(Ai),t(Ui),t(Hi),t(dt),t(ji),t(L),t(zi),t(ut),t(Pi),t(mt),t(Li),t(gt),t(Wi),t(vt),t(Gi),t(yt),t(Ii),t(wt),t(Yi),t(W),t(Ri),t(Mt),t(Zi),t(_t),t(Ei),t(Fi),t(xt),t(Bi),t(G),t(Xi),t($t),t(Ni),t(kt),t(Si),t(qi),t(At),t(Vi),t(Ut),t(Di),t(Ht),t(Qi),t(jt),t(Ki),t(Oi),t(Pt),t(el),t(tl),t(Wt),t(nl),t(I),t(al),t(It),t(il),t(Y),t(ll),t(Rt),t(rl),t(Zt),t(ol),t(Et),t(sl),t(R),t(pl),t(Bt),t(hl),t(Xt),t(cl),t(Nt),t(dl),t(Z),t(fl),t(qt),t(ul),t(Vt),t(ml),t(gl),t(Qt),t(vl),t(Kt),t(yl),t(Ot),t(wl),t(en),t(bl),t(tn),t(Ml),t(nn),t(_l),t(an),t(Tl),t(ln),t(xl),t(rn),t(Cl),t(on),t($l),t(E),t(kl),t(pn),t(Jl),t(hn),t(Al),t(Ul),t(dn),t(Hl),t(jl),t(un),t(zl),t(mn),t(Pl),t(gn),t(Ll),t(F),t(Wl),t(yn),t(Gl),t(wn),t(Il),t(bn),t(Yl),t(Mn),t(Rl),t(B),t(Zl),t(Tn),t(El),t(xn),t(Fl),t(Cn),t(Bl),t($n),t(Xl),t(kn),t(Nl),t(Jn),t(Sl),t(An),t(ql),t(Un),t(Vl),t(Hn),t(Dl),t(jn),t(Ql),t(zn),t(Kl),t(X),t(Ol),t(Ln),t(er),t(Wn),t(tr),t(nr),t(In),t(ar),t(ir),t(Yn),t(lr),t(Ca)),t(d),y(me),y(N,e),y(S,e),y(ke),y(je),y(Le,e),y(Re),y(Xe,e),y(Q,e),y(Se),y(De),y(Oe,e),y(tt),y(it,e),y(lt),y(ot,e),y(ct,e),y(ne,e),y(ft),y(bt),y(Tt,e),y(Ct),y(Jt,e),y(zt,e),y(Lt,e),y(Gt),y(Yt),y(Ft),y(St),y(Dt,e),y(sn),y(cn,e),y(fn,e),y(vn),y(_n),y(Pn),y(Gn,e),y(ue,e)}}}const Np={local:"methods-and-tools-for-efficient-training-on-a-single-gpu",sections:[{local:"batch-size-choice",title:"Batch size choice"},{local:"gradient-accumulation",title:"Gradient Accumulation"},{local:"gradient-checkpointing",title:"Gradient Checkpointing"},{local:"mixed-precision-training",sections:[{local:"fp16",title:"fp16"},{local:"bf16",title:"BF16"},{local:"tf32",title:"TF32"}],title:"Mixed precision training"},{local:"optimizer-choice",sections:[{local:"adafactor",title:"Adafactor"},{local:"8bit-adam",title:"8-bit Adam"},{local:"multitensor",title:"multi_tensor"}],title:"Optimizer choice"},{local:"data-preloading",title:"Data preloading"},{local:"deepspeed-zero",title:"DeepSpeed ZeRO"},{local:"using-torchcompile",title:"Using torch.compile"},{local:"using-accelerate",title:"Using 🤗 Accelerate"},{local:"efficient-software-prebuilds",title:"Efficient Software Prebuilds"},{local:"mixture-of-experts",title:"Mixture of Experts"},{local:"using-pytorch-native-attention-and-flash-attention",title:"Using PyTorch native attention and Flash Attention"}],title:"Methods and tools for efficient training on a single GPU"};function Sp(C){return Wp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Op extends Gp{constructor(d){super(),Ip(this,d,Sp,Xp,Lp,{})}}export{Op as component};
