import{s as nr,f as or,o as sr,n as K}from"../chunks/scheduler.25b97de1.js";import{S as ar,i as rr,g as i,s as o,r as m,A as ir,h as l,f as n,c as s,j as v,u,x as p,k as w,y as a,a as r,v as h,d as f,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as Io}from"../chunks/Tip.baa67368.js";import{D as x}from"../chunks/Docstring.ffac8efa.js";import{C as V}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Un}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as F,E as lr}from"../chunks/EditOnGithub.91d95064.js";function dr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNTW9kZWwlMkMlMjBNYXJrdXBMTUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXJrdXBMTSUyMG1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFya3VwTE1Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMModel, MarkupLMConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MarkupLM microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MarkupLMConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function cr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUwQSUwQXBhZ2VfbmFtZV8xJTIwJTNEJTIwJTIycGFnZTEuaHRtbCUyMiUwQXBhZ2VfbmFtZV8yJTIwJTNEJTIwJTIycGFnZTIuaHRtbCUyMiUwQXBhZ2VfbmFtZV8zJTIwJTNEJTIwJTIycGFnZTMuaHRtbCUyMiUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8xKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHNpbmdsZV9odG1sX3N0cmluZyUyMCUzRCUyMGYucmVhZCgpJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQSUwQSUyMyUyMHNpbmdsZSUyMGV4YW1wbGUlMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKHNpbmdsZV9odG1sX3N0cmluZyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCklMEElMEElMjMlMjBiYXRjaGVkJTIwZXhhbXBsZSUwQSUwQW11bHRpX2h0bWxfc3RyaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8yKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMG11bHRpX2h0bWxfc3RyaW5ncy5hcHBlbmQoZi5yZWFkKCkpJTBBd2l0aCUyMG9wZW4ocGFnZV9uYW1lXzMpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwbXVsdGlfaHRtbF9zdHJpbmdzLmFwcGVuZChmLnJlYWQoKSklMEElMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKG11bHRpX2h0bWxfc3RyaW5ncyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_1 = <span class="hljs-string">&quot;page1.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_2 = <span class="hljs-string">&quot;page2.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_3 = <span class="hljs-string">&quot;page3.html&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_1) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    single_html_string = f.read()

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = MarkupLMFeatureExtractor()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># single example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(single_html_string)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batched example</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>multi_html_strings = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_2) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_3) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(multi_html_strings)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function pr($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&n(c)}}}function mr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTU1vZGVsJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hcmt1cExNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFUGFnZSUyMFRpdGxlJTNDJTJGdGl0bGUlM0UlMjAlM0MlMkZoZWFkJTNFJTIwJTNDJTJGaHRtbCUzRSUyMiUwQSUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function ur($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&n(c)}}}function hr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0Q3KSUwQSUwQWh0bWxfc3RyaW5nJTIwJTNEJTIwJTIyJTNDaHRtbCUzRSUyMCUzQ2hlYWQlM0UlMjAlM0N0aXRsZSUzRVBhZ2UlMjBUaXRsZSUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function fr($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&n(c)}}}function gr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQXByb2Nlc3Nvci5wYXJzZV9odG1sJTIwJTNEJTIwRmFsc2UlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIlMkMlMjBudW1fbGFiZWxzJTNENyklMEElMEFub2RlcyUyMCUzRCUyMCU1QiUyMmhlbGxvJTIyJTJDJTIwJTIyd29ybGQlMjIlNUQlMEF4cGF0aHMlMjAlM0QlMjAlNUIlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlMkMlMjAlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTVEJTBBZW5jb2RpbmclMjAlM0QlMjBwcm9jZXNzb3Iobm9kZXMlM0Rub2RlcyUyQyUyMHhwYXRocyUzRHhwYXRocyUyQyUyMG5vZGVfbGFiZWxzJTNEbm9kZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function _r($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&n(c)}}}function Mr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFTXklMjBuYW1lJTIwaXMlMjBOaWVscyUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEElMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHF1ZXN0aW9ucyUzRHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwZW5jb2RpbmcuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMpLnN0cmlwKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;My name is Niels&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = encoding.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(predict_answer_tokens).strip()
<span class="hljs-string">&#x27;Niels&#x27;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=o(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(n(c),n(k)),_(M,d)}}}function kr($){let c,y,k,M,b,d,T,jn,ve,Xs=`The MarkupLM model was proposed in <a href="https://arxiv.org/abs/2110.08518" rel="nofollow">MarkupLM: Pre-training of Text and Markup Language for Visually-rich Document
Understanding</a> by Junlong Li, Yiheng Xu, Lei Cui, Furu Wei. MarkupLM is BERT, but
applied to HTML pages instead of raw text documents. The model incorporates additional embedding layers to improve
performance, similar to <a href="layoutlm">LayoutLM</a>.`,Cn,xe,Ps=`The model can be used for tasks like question answering on web pages or information extraction from web pages. It obtains
state-of-the-art results on 2 important benchmarks:`,Fn,Le,As=`<li><a href="https://x-lance.github.io/WebSRC/" rel="nofollow">WebSRC</a>, a dataset for Web-Based Structural Reading Comprehension (a bit like SQuAD but for web pages)</li> <li><a href="https://www.researchgate.net/publication/221299838_From_one_tree_to_a_forest_a_unified_solution_for_structured_web_data_extraction" rel="nofollow">SWDE</a>, a dataset
for information extraction from web pages (basically named-entity recognition on web pages)</li>`,Nn,$e,Ds="The abstract from the paper is the following:",In,Ue,Ys=`<em>Multimodal pre-training with text, layout, and image has made significant progress for Visually-rich Document
Understanding (VrDU), especially the fixed-layout documents such as scanned document images. While, there are still a
large number of digital documents where the layout information is not fixed and needs to be interactively and
dynamically rendered for visualization, making existing layout-based pre-training approaches not easy to apply. In this
paper, we propose MarkupLM for document understanding tasks with markup languages as the backbone such as
HTML/XML-based documents, where text and markup information is jointly pre-trained. Experiment results show that the
pre-trained MarkupLM significantly outperforms the existing strong baseline models on several document understanding
tasks. The pre-trained model and code will be publicly available.</em>`,Zn,Je,Os='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/markuplm" rel="nofollow">here</a>.',Rn,qe,Bn,ze,Ks=`<li>In addition to <code>input_ids</code>, <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel.forward">forward()</a> expects 2 additional inputs, namely <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.
These are the XPATH tags and subscripts respectively for each token in the input sequence.</li> <li>One can use <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> to prepare all data for the model. Refer to the <a href="#usage-markuplmprocessor">usage guide</a> for more info.</li>`,Gn,ne,ea,Hn,je,ta='MarkupLM architecture. Taken from the <a href="https://arxiv.org/abs/2110.08518">original paper.</a>',En,Ce,Wn,Fe,na=`The easiest way to prepare data for the model is to use <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>, which internally combines a feature extractor
(<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>) and a tokenizer (<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>). The feature extractor is
used to extract all nodes and xpaths from the HTML strings, which are then provided to the tokenizer, which turns them into the
token-level inputs of the model (<code>input_ids</code> etc.). Note that you can still use the feature extractor and tokenizer separately,
if you only want to handle one of the two tasks.`,Vn,Ne,Sn,Ie,oa=`In short, one can provide HTML strings (and possibly additional data) to <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>,
and it will create the inputs expected by the model. Internally, the processor first uses
<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to get a list of nodes and corresponding xpaths. The nodes and
xpaths are then provided to <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which converts them
to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_subs_seq</code>, <code>xpath_tags_seq</code>.
Optionally, one can provide node labels to the processor, which are turned into token-level <code>labels</code>.`,Qn,Ze,sa=`<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> uses <a href="https://www.crummy.com/software/BeautifulSoup/bs4/doc/" rel="nofollow">Beautiful Soup</a>, a Python library for
pulling data out of HTML and XML files, under the hood. Note that you can still use your own parsing solution of
choice, and provide the nodes and xpaths yourself to <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>.`,Xn,Re,aa=`In total, there are 5 use cases that are supported by the processor. Below, we list them all. Note that each of these
use cases work for both batched and non-batched inputs (we illustrate them for non-batched inputs).`,Pn,Be,ra="<strong>Use case 1: web page classification (training, inference) + token classification (inference), parse_html = True</strong>",An,Ge,ia="This is the simplest case, in which the processor will use the feature extractor to get all nodes and xpaths from the HTML.",Dn,He,Yn,Ee,la="<strong>Use case 2: web page classification (training, inference) + token classification (inference), parse_html=False</strong>",On,We,da=`In case one already has obtained all nodes and xpaths, one doesn’t need the feature extractor. In that case, one should
provide the nodes and corresponding xpaths themselves to the processor, and make sure to set <code>parse_html</code> to <code>False</code>.`,Kn,Ve,eo,Se,ca="<strong>Use case 3: token classification (training), parse_html=False</strong>",to,Qe,pa=`For token classification tasks (such as <a href="https://paperswithcode.com/dataset/swde" rel="nofollow">SWDE</a>), one can also provide the
corresponding node labels in order to train a model. The processor will then convert these into token-level <code>labels</code>.
By default, it will only label the first wordpiece of a word, and label the remaining wordpieces with -100, which is the
<code>ignore_index</code> of PyTorch’s CrossEntropyLoss. In case you want all wordpieces of a word to be labeled, you can
initialize the tokenizer with <code>only_label_first_subword</code> set to <code>False</code>.`,no,Xe,oo,Pe,ma="<strong>Use case 4: web page question answering (inference), parse_html=True</strong>",so,Ae,ua=`For question answering tasks on web pages, you can provide a question to the processor. By default, the
processor will use the feature extractor to get all nodes and xpaths, and create [CLS] question tokens [SEP] word tokens [SEP].`,ao,De,ro,Ye,ha="<strong>Use case 5: web page question answering (inference), parse_html=False</strong>",io,Oe,fa=`For question answering tasks (such as WebSRC), you can provide a question to the processor. If you have extracted
all nodes and xpaths yourself, you can provide them directly to the processor. Make sure to set <code>parse_html</code> to <code>False</code>.`,lo,Ke,co,et,po,tt,ga='<li><a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MarkupLM" rel="nofollow">Demo notebooks</a></li> <li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li>',mo,nt,uo,N,ot,Zo,Zt,_a=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>. It is used to instantiate a
MarkupLM model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the MarkupLM
<a href="https://huggingface.co/microsoft/markuplm-base" rel="nofollow">microsoft/markuplm-base</a> architecture.`,Ro,Rt,Ma=`Configuration objects inherit from <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> for more information.`,Bo,oe,ho,st,fo,I,at,Go,Bt,ka=`Constructs a MarkupLM feature extractor. This can be used to get a list of nodes and corresponding xpaths from HTML
strings.`,Ho,Gt,ba=`This feature extractor inherits from <code>PreTrainedFeatureExtractor()</code> which contains most
of the main methods. Users should refer to this superclass for more information regarding those methods.`,Eo,A,rt,Wo,Ht,ya="Main method to prepare for the model one or several HTML strings.",Vo,se,go,it,_o,q,lt,So,Et,Ta=`Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE). <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> can be used to
turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and
<code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods.
Users should refer to this superclass for more information regarding those methods.`,Qo,D,dt,Xo,Wt,wa=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,Po,Vt,va="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",Ao,St,ct,Do,ae,pt,Yo,Qt,xa=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,Oo,Xt,mt,Mo,ut,ko,L,ht,Ko,Pt,La="Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE).",es,At,$a=`<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a> can be used to turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>,
<code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which
contains most of the main methods.`,ts,Dt,Ua="Users should refer to this superclass for more information regarding those methods.",ns,J,ft,os,Yt,Ja=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,ss,Ot,qa=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters.</p></li>`,as,Kt,za=`If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
is_split_into_words (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).
padding_side (<code>str</code>, <em>optional</em>):
The side on which the model should have padding applied. Should be selected between [‘right’, ‘left’].
Default value is picked from the class attribute of the same name.
return_tensors (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:`,rs,en,ja="<li><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</li> <li><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li> <li><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</li>",is,tn,Ca=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to encode the sequences with the special tokens relative to their model.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,ls,nn,Fa=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).
return_tensors (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:</p></li> <li><p><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</p></li> <li><p><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</p></li> <li><p><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</p></li>`,ds,Y,gt,cs,on,Na=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,ps,sn,Ia="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",ms,re,_t,us,an,Za=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,hs,ie,Mt,fs,rn,Ra=`Tokenize and prepare for the model a sequence or a pair of sequences. .. warning:: This method is deprecated,
<code>__call__</code> should be used instead.`,gs,le,kt,_s,ln,Ba=`Given the xpath expression of one particular node (like “/html/body/div/li[1]/div/span[2]”), return a list of
tag IDs and corresponding subscripts, taking into account max depth.`,bo,bt,yo,j,yt,Ms,dn,Ga=`Constructs a MarkupLM processor which combines a MarkupLM feature extractor and a MarkupLM tokenizer into a single
processor.`,ks,cn,Ha='<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> offers all the functionalities you need to prepare data for the model.',bs,pn,Ea=`It first uses <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to extract nodes and corresponding xpaths from one or more HTML strings.
Next, these are provided to <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which turns them into token-level
<code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.`,ys,B,Tt,Ts,mn,Wa=`This method first forwards the <code>html_strings</code> argument to <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor.__call__"><strong>call</strong>()</a>. Next, it
passes the <code>nodes</code> and <code>xpaths</code> along with the additional arguments to <code>__call__()</code> and
returns the output.`,ws,un,Va="Optionally, one can also provide a <code>text</code> argument which is passed along as first sequence.",vs,hn,Sa="Please refer to the docstring of the above two methods for more information.",To,wt,wo,S,vt,xs,fn,Qa=`The bare MarkupLM Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ls,G,xt,$s,gn,Xa='The <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> forward method, overrides the <code>__call__</code> special method.',Us,de,Js,ce,vo,Lt,xo,Z,$t,qs,_n,Pa=`MarkupLM Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,zs,Mn,Aa=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,js,H,Ut,Cs,kn,Da='The <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Fs,pe,Ns,me,Lo,Jt,$o,Q,qt,Is,bn,Ya=`MarkupLM Model with a <code>token_classification</code> head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Zs,E,zt,Rs,yn,Oa='The <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Bs,ue,Gs,he,Uo,jt,Jo,R,Ct,Hs,Tn,Ka=`MarkupLM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Es,wn,er=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ws,W,Ft,Vs,vn,tr='The <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Ss,fe,Qs,ge,qo,Nt,zo,Jn,jo;return b=new F({props:{title:"MarkupLM",local:"markuplm",headingTag:"h1"}}),T=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),qe=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Ce=new F({props:{title:"Usage: MarkupLMProcessor",local:"usage-markuplmprocessor",headingTag:"h2"}}),Ne=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUyQyUyME1hcmt1cExNVG9rZW5pemVyRmFzdCUyQyUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQXRva2VuaXplciUyMCUzRCUyME1hcmt1cExNVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBNYXJrdXBMTVByb2Nlc3NvcihmZWF0dXJlX2V4dHJhY3RvciUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor, MarkupLMTokenizerFast, MarkupLMProcessor

feature_extractor = MarkupLMFeatureExtractor()
tokenizer = MarkupLMTokenizerFast.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
processor = MarkupLMProcessor(feature_extractor, tokenizer)`,wrap:!1}}),He=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VIZXJlJTIwaXMlMjBteSUyMHdlYnNpdGUuJTNDJTJGcCUzRSUwQSUyMCUzQyUyRmJvZHklM0UlMEElMjAlM0MlMkZodG1sJTNFJTIyJTIyJTIyJTBBJTBBJTIzJTIwbm90ZSUyMHRoYXQlMjB5b3UlMjBjYW4lMjBhbHNvJTIwYWRkJTIwcHJvdmlkZSUyMGFsbCUyMHRva2VuaXplciUyMHBhcmFtZXRlcnMlMjBoZXJlJTIwc3VjaCUyMGFzJTIwcGFkZGluZyUyQyUyMHRydW5jYXRpb24lMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;Here is my website.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note that you can also add provide all tokenizer parameters here such as padding, truncation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Ve=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChlbmNvZGluZy5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Xe=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTJDJTIwMiUyQyUyMDElNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwbm9kZV9sYWJlbHMlM0Rub2RlX2xhYmVscyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>])`,wrap:!1}}),De=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VNeSUyMG5hbWUlMjBpcyUyME5pZWxzLiUzQyUyRnAlM0UlMEElMjAlM0MlMkZib2R5JTNFJTBBJTIwJTNDJTJGaHRtbCUzRSUyMiUyMiUyMiUwQSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwaGlzJTIwbmFtZSUzRiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;My name is Niels.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Ke=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),et=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),nt=new F({props:{title:"MarkupLMConfig",local:"transformers.MarkupLMConfig",headingTag:"h2"}}),ot=new x({props:{name:"class transformers.MarkupLMConfig",anchor:"transformers.MarkupLMConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_xpath_tag_unit_embeddings",val:" = 256"},{name:"max_xpath_subs_unit_embeddings",val:" = 1024"},{name:"tag_pad_id",val:" = 216"},{name:"subs_pad_id",val:" = 1001"},{name:"xpath_unit_hidden_size",val:" = 32"},{name:"max_depth",val:" = 50"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the MarkupLM model. Defines the different tokens that can be represented by the
<em>inputs_ids</em> passed to the forward method of <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"vocab_size"},{anchor:"transformers.MarkupLMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MarkupLMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MarkupLMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.MarkupLMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.MarkupLMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.MarkupLMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.MarkupLMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.MarkupLMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MarkupLMConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed into <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.MarkupLMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MarkupLMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MarkupLMConfig.max_tree_id_unit_embeddings",description:`<strong>max_tree_id_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the tree id unit embedding might ever use. Typically set this to something large
just in case (e.g., 1024).`,name:"max_tree_id_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_tag_unit_embeddings",description:`<strong>max_xpath_tag_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum value that the xpath tag unit embedding might ever use. Typically set this to something large
just in case (e.g., 256).`,name:"max_xpath_tag_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_subs_unit_embeddings",description:`<strong>max_xpath_subs_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the xpath subscript unit embedding might ever use. Typically set this to something
large just in case (e.g., 1024).`,name:"max_xpath_subs_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.tag_pad_id",description:`<strong>tag_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 216) &#x2014;
The id of the padding token in the xpath tags.`,name:"tag_pad_id"},{anchor:"transformers.MarkupLMConfig.subs_pad_id",description:`<strong>subs_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1001) &#x2014;
The id of the padding token in the xpath subscripts.`,name:"subs_pad_id"},{anchor:"transformers.MarkupLMConfig.xpath_tag_unit_hidden_size",description:`<strong>xpath_tag_unit_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The hidden size of each tree id unit. One complete tree index will have
(50*xpath_tag_unit_hidden_size)-dim.`,name:"xpath_tag_unit_hidden_size"},{anchor:"transformers.MarkupLMConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The maximum depth in xpath.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/configuration_markuplm.py#L24"}}),oe=new Un({props:{anchor:"transformers.MarkupLMConfig.example",$$slots:{default:[dr]},$$scope:{ctx:$}}}),st=new F({props:{title:"MarkupLMFeatureExtractor",local:"transformers.MarkupLMFeatureExtractor",headingTag:"h2"}}),at=new x({props:{name:"class transformers.MarkupLMFeatureExtractor",anchor:"transformers.MarkupLMFeatureExtractor",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/feature_extraction_markuplm.py#L33"}}),rt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMFeatureExtractor.__call__",parameters:[{name:"html_strings",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMFeatureExtractor.__call__.html_strings",description:`<strong>html_strings</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The HTML string or batch of HTML strings from which to extract nodes and corresponding xpaths.`,name:"html_strings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/feature_extraction_markuplm.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>nodes</strong> — Nodes.</li>
<li><strong>xpaths</strong> — Corresponding xpaths.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),se=new Un({props:{anchor:"transformers.MarkupLMFeatureExtractor.__call__.example",$$slots:{default:[cr]},$$scope:{ctx:$}}}),it=new F({props:{title:"MarkupLMTokenizer",local:"transformers.MarkupLMTokenizer",headingTag:"h2"}}),lt=new x({props:{name:"class transformers.MarkupLMTokenizer",anchor:"transformers.MarkupLMTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizer.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizer.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm.py#L128"}}),dt=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ct=new x({props:{name:"get_special_tokens_mask",anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.Retrieve",description:"<strong>Retrieve</strong> sequence ids from a token list that has no special tokens added. This method is called when adding &#x2014;",name:"Retrieve"},{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.special",description:`<strong>special</strong> tokens using the tokenizer <code>prepare_for_model</code> method. &#x2014;
token_ids_0 (<code>List[int]</code>):
List of IDs.
token_ids_1 (<code>List[int]</code>, <em>optional</em>):
Optional second list of IDs for sequence pairs.
already_has_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the token list is already formatted with special tokens for the model.`,name:"special"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),pt=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),mt=new x({props:{name:"save_vocabulary",anchor:"transformers.MarkupLMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm.py#L370"}}),ut=new F({props:{title:"MarkupLMTokenizerFast",local:"transformers.MarkupLMTokenizerFast",headingTag:"h2"}}),ht=new x({props:{name:"class transformers.MarkupLMTokenizerFast",anchor:"transformers.MarkupLMTokenizerFast",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"tokenizer_file",val:" = None"},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"trim_offsets",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizerFast.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L83"}}),ft=new x({props:{name:"batch_encode_plus",anchor:"transformers.MarkupLMTokenizerFast.batch_encode_plus",parameters:[{name:"batch_text_or_text_pairs",val:": Union"},{name:"is_pair",val:": bool = None"},{name:"xpaths",val:": Optional = None"},{name:"node_labels",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"padding_side",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L424"}}),gt=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L887",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_t=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L910",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Mt=new x({props:{name:"encode_plus",anchor:"transformers.MarkupLMTokenizerFast.encode_plus",parameters:[{name:"text",val:": Union"},{name:"text_pair",val:": Optional = None"},{name:"xpaths",val:": Optional = None"},{name:"node_labels",val:": Optional = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"padding_side",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The first sequence to be encoded. This can be a string, a list of strings or a list of list of strings.`,name:"text"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text_pair",description:`<strong>text_pair</strong> (<code>List[str]</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second sequence to be encoded. This can be a list of strings (words of a single example) or a
list of list of strings (words of a batch of examples).`,name:"text_pair"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding_side",description:`<strong>padding_side</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The side on which the model should have padding applied. Should be selected between [&#x2018;right&#x2019;, &#x2018;left&#x2019;].
Default value is picked from the class attribute of the same name.`,name:"padding_side"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L493"}}),kt=new x({props:{name:"get_xpath_seq",anchor:"transformers.MarkupLMTokenizerFast.get_xpath_seq",parameters:[{name:"xpath",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L251"}}),bt=new F({props:{title:"MarkupLMProcessor",local:"transformers.MarkupLMProcessor",headingTag:"h2"}}),yt=new x({props:{name:"class transformers.MarkupLMProcessor",anchor:"transformers.MarkupLMProcessor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MarkupLMFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MarkupLMProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>MarkupLMTokenizer</code> or <code>MarkupLMTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.MarkupLMProcessor.parse_html",description:`<strong>parse_html</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use <code>MarkupLMFeatureExtractor</code> to parse HTML strings into nodes and corresponding xpaths.`,name:"parse_html"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/processing_markuplm.py#L26"}}),Tt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMProcessor.__call__",parameters:[{name:"html_strings",val:" = None"},{name:"nodes",val:" = None"},{name:"xpaths",val:" = None"},{name:"node_labels",val:" = None"},{name:"questions",val:" = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"return_tensors",val:": Union = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/processing_markuplm.py#L50"}}),wt=new F({props:{title:"MarkupLMModel",local:"transformers.MarkupLMModel",headingTag:"h2"}}),vt=new x({props:{name:"class transformers.MarkupLMModel",anchor:"transformers.MarkupLMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L802"}}),xt=new x({props:{name:"forward",anchor:"transformers.MarkupLMModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMModel.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMModel.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L834",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Io({props:{$$slots:{default:[pr]},$$scope:{ctx:$}}}),ce=new Un({props:{anchor:"transformers.MarkupLMModel.forward.example",$$slots:{default:[mr]},$$scope:{ctx:$}}}),Lt=new F({props:{title:"MarkupLMForSequenceClassification",local:"transformers.MarkupLMForSequenceClassification",headingTag:"h2"}}),$t=new x({props:{name:"class transformers.MarkupLMForSequenceClassification",anchor:"transformers.MarkupLMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L1204"}}),Ut=new x({props:{name:"forward",anchor:"transformers.MarkupLMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new Io({props:{$$slots:{default:[ur]},$$scope:{ctx:$}}}),me=new Un({props:{anchor:"transformers.MarkupLMForSequenceClassification.forward.example",$$slots:{default:[hr]},$$scope:{ctx:$}}}),Jt=new F({props:{title:"MarkupLMForTokenClassification",local:"transformers.MarkupLMForTokenClassification",headingTag:"h2"}}),qt=new x({props:{name:"class transformers.MarkupLMForTokenClassification",anchor:"transformers.MarkupLMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L1104"}}),zt=new x({props:{name:"forward",anchor:"transformers.MarkupLMForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L1121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new Io({props:{$$slots:{default:[fr]},$$scope:{ctx:$}}}),he=new Un({props:{anchor:"transformers.MarkupLMForTokenClassification.forward.example",$$slots:{default:[gr]},$$scope:{ctx:$}}}),jt=new F({props:{title:"MarkupLMForQuestionAnswering",local:"transformers.MarkupLMForQuestionAnswering",headingTag:"h2"}}),Ct=new x({props:{name:"class transformers.MarkupLMForQuestionAnswering",anchor:"transformers.MarkupLMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L978"}}),Ft=new x({props:{name:"forward",anchor:"transformers.MarkupLMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/markuplm/modeling_markuplm.py#L997",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new Io({props:{$$slots:{default:[_r]},$$scope:{ctx:$}}}),ge=new Un({props:{anchor:"transformers.MarkupLMForQuestionAnswering.forward.example",$$slots:{default:[Mr]},$$scope:{ctx:$}}}),Nt=new lr({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/markuplm.md"}}),{c(){c=i("meta"),y=o(),k=i("p"),M=o(),m(b.$$.fragment),d=o(),m(T.$$.fragment),jn=o(),ve=i("p"),ve.innerHTML=Xs,Cn=o(),xe=i("p"),xe.textContent=Ps,Fn=o(),Le=i("ul"),Le.innerHTML=As,Nn=o(),$e=i("p"),$e.textContent=Ds,In=o(),Ue=i("p"),Ue.innerHTML=Ys,Zn=o(),Je=i("p"),Je.innerHTML=Os,Rn=o(),m(qe.$$.fragment),Bn=o(),ze=i("ul"),ze.innerHTML=Ks,Gn=o(),ne=i("img"),Hn=o(),je=i("small"),je.innerHTML=ta,En=o(),m(Ce.$$.fragment),Wn=o(),Fe=i("p"),Fe.innerHTML=na,Vn=o(),m(Ne.$$.fragment),Sn=o(),Ie=i("p"),Ie.innerHTML=oa,Qn=o(),Ze=i("p"),Ze.innerHTML=sa,Xn=o(),Re=i("p"),Re.textContent=aa,Pn=o(),Be=i("p"),Be.innerHTML=ra,An=o(),Ge=i("p"),Ge.textContent=ia,Dn=o(),m(He.$$.fragment),Yn=o(),Ee=i("p"),Ee.innerHTML=la,On=o(),We=i("p"),We.innerHTML=da,Kn=o(),m(Ve.$$.fragment),eo=o(),Se=i("p"),Se.innerHTML=ca,to=o(),Qe=i("p"),Qe.innerHTML=pa,no=o(),m(Xe.$$.fragment),oo=o(),Pe=i("p"),Pe.innerHTML=ma,so=o(),Ae=i("p"),Ae.textContent=ua,ao=o(),m(De.$$.fragment),ro=o(),Ye=i("p"),Ye.innerHTML=ha,io=o(),Oe=i("p"),Oe.innerHTML=fa,lo=o(),m(Ke.$$.fragment),co=o(),m(et.$$.fragment),po=o(),tt=i("ul"),tt.innerHTML=ga,mo=o(),m(nt.$$.fragment),uo=o(),N=i("div"),m(ot.$$.fragment),Zo=o(),Zt=i("p"),Zt.innerHTML=_a,Ro=o(),Rt=i("p"),Rt.innerHTML=Ma,Bo=o(),m(oe.$$.fragment),ho=o(),m(st.$$.fragment),fo=o(),I=i("div"),m(at.$$.fragment),Go=o(),Bt=i("p"),Bt.textContent=ka,Ho=o(),Gt=i("p"),Gt.innerHTML=ba,Eo=o(),A=i("div"),m(rt.$$.fragment),Wo=o(),Ht=i("p"),Ht.textContent=ya,Vo=o(),m(se.$$.fragment),go=o(),m(it.$$.fragment),_o=o(),q=i("div"),m(lt.$$.fragment),So=o(),Et=i("p"),Et.innerHTML=Ta,Qo=o(),D=i("div"),m(dt.$$.fragment),Xo=o(),Wt=i("p"),Wt.textContent=wa,Po=o(),Vt=i("ul"),Vt.innerHTML=va,Ao=o(),St=i("div"),m(ct.$$.fragment),Do=o(),ae=i("div"),m(pt.$$.fragment),Yo=o(),Qt=i("p"),Qt.textContent=xa,Oo=o(),Xt=i("div"),m(mt.$$.fragment),Mo=o(),m(ut.$$.fragment),ko=o(),L=i("div"),m(ht.$$.fragment),Ko=o(),Pt=i("p"),Pt.textContent=La,es=o(),At=i("p"),At.innerHTML=$a,ts=o(),Dt=i("p"),Dt.textContent=Ua,ns=o(),J=i("div"),m(ft.$$.fragment),os=o(),Yt=i("p"),Yt.innerHTML=Ja,ss=o(),Ot=i("ul"),Ot.innerHTML=qa,as=o(),Kt=i("p"),Kt.innerHTML=za,rs=o(),en=i("ul"),en.innerHTML=ja,is=o(),tn=i("p"),tn.innerHTML=Ca,ls=o(),nn=i("ul"),nn.innerHTML=Fa,ds=o(),Y=i("div"),m(gt.$$.fragment),cs=o(),on=i("p"),on.textContent=Na,ps=o(),sn=i("ul"),sn.innerHTML=Ia,ms=o(),re=i("div"),m(_t.$$.fragment),us=o(),an=i("p"),an.textContent=Za,hs=o(),ie=i("div"),m(Mt.$$.fragment),fs=o(),rn=i("p"),rn.innerHTML=Ra,gs=o(),le=i("div"),m(kt.$$.fragment),_s=o(),ln=i("p"),ln.textContent=Ba,bo=o(),m(bt.$$.fragment),yo=o(),j=i("div"),m(yt.$$.fragment),Ms=o(),dn=i("p"),dn.textContent=Ga,ks=o(),cn=i("p"),cn.innerHTML=Ha,bs=o(),pn=i("p"),pn.innerHTML=Ea,ys=o(),B=i("div"),m(Tt.$$.fragment),Ts=o(),mn=i("p"),mn.innerHTML=Wa,ws=o(),un=i("p"),un.innerHTML=Va,vs=o(),hn=i("p"),hn.textContent=Sa,To=o(),m(wt.$$.fragment),wo=o(),S=i("div"),m(vt.$$.fragment),xs=o(),fn=i("p"),fn.innerHTML=Qa,Ls=o(),G=i("div"),m(xt.$$.fragment),$s=o(),gn=i("p"),gn.innerHTML=Xa,Us=o(),m(de.$$.fragment),Js=o(),m(ce.$$.fragment),vo=o(),m(Lt.$$.fragment),xo=o(),Z=i("div"),m($t.$$.fragment),qs=o(),_n=i("p"),_n.textContent=Pa,zs=o(),Mn=i("p"),Mn.innerHTML=Aa,js=o(),H=i("div"),m(Ut.$$.fragment),Cs=o(),kn=i("p"),kn.innerHTML=Da,Fs=o(),m(pe.$$.fragment),Ns=o(),m(me.$$.fragment),Lo=o(),m(Jt.$$.fragment),$o=o(),Q=i("div"),m(qt.$$.fragment),Is=o(),bn=i("p"),bn.innerHTML=Ya,Zs=o(),E=i("div"),m(zt.$$.fragment),Rs=o(),yn=i("p"),yn.innerHTML=Oa,Bs=o(),m(ue.$$.fragment),Gs=o(),m(he.$$.fragment),Uo=o(),m(jt.$$.fragment),Jo=o(),R=i("div"),m(Ct.$$.fragment),Hs=o(),Tn=i("p"),Tn.innerHTML=Ka,Es=o(),wn=i("p"),wn.innerHTML=er,Ws=o(),W=i("div"),m(Ft.$$.fragment),Vs=o(),vn=i("p"),vn.innerHTML=tr,Ss=o(),m(fe.$$.fragment),Qs=o(),m(ge.$$.fragment),qo=o(),m(Nt.$$.fragment),zo=o(),Jn=i("p"),this.h()},l(e){const t=ir("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(n),y=s(e),k=l(e,"P",{}),v(k).forEach(n),M=s(e),u(b.$$.fragment,e),d=s(e),u(T.$$.fragment,e),jn=s(e),ve=l(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1t0sxmg"&&(ve.innerHTML=Xs),Cn=s(e),xe=l(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1ytlk74"&&(xe.textContent=Ps),Fn=s(e),Le=l(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-6h13ie"&&(Le.innerHTML=As),Nn=s(e),$e=l(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-vfdo9a"&&($e.textContent=Ds),In=s(e),Ue=l(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-hdnp88"&&(Ue.innerHTML=Ys),Zn=s(e),Je=l(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-rdxa92"&&(Je.innerHTML=Os),Rn=s(e),u(qe.$$.fragment,e),Bn=s(e),ze=l(e,"UL",{"data-svelte-h":!0}),p(ze)!=="svelte-1kus2hf"&&(ze.innerHTML=Ks),Gn=s(e),ne=l(e,"IMG",{src:!0,alt:!0,width:!0}),Hn=s(e),je=l(e,"SMALL",{"data-svelte-h":!0}),p(je)!=="svelte-1ylkkn"&&(je.innerHTML=ta),En=s(e),u(Ce.$$.fragment,e),Wn=s(e),Fe=l(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1k57sc8"&&(Fe.innerHTML=na),Vn=s(e),u(Ne.$$.fragment,e),Sn=s(e),Ie=l(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1rk2hsl"&&(Ie.innerHTML=oa),Qn=s(e),Ze=l(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1s4vnkd"&&(Ze.innerHTML=sa),Xn=s(e),Re=l(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-jv0had"&&(Re.textContent=aa),Pn=s(e),Be=l(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-dkcsne"&&(Be.innerHTML=ra),An=s(e),Ge=l(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-6kpuj"&&(Ge.textContent=ia),Dn=s(e),u(He.$$.fragment,e),Yn=s(e),Ee=l(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1i783jq"&&(Ee.innerHTML=la),On=s(e),We=l(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-glfvnv"&&(We.innerHTML=da),Kn=s(e),u(Ve.$$.fragment,e),eo=s(e),Se=l(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-owkrw8"&&(Se.innerHTML=ca),to=s(e),Qe=l(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1x7hckg"&&(Qe.innerHTML=pa),no=s(e),u(Xe.$$.fragment,e),oo=s(e),Pe=l(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-34jdzj"&&(Pe.innerHTML=ma),so=s(e),Ae=l(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-11r3tgp"&&(Ae.textContent=ua),ao=s(e),u(De.$$.fragment,e),ro=s(e),Ye=l(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-147vwql"&&(Ye.innerHTML=ha),io=s(e),Oe=l(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1wesasz"&&(Oe.innerHTML=fa),lo=s(e),u(Ke.$$.fragment,e),co=s(e),u(et.$$.fragment,e),po=s(e),tt=l(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-1o7x1ln"&&(tt.innerHTML=ga),mo=s(e),u(nt.$$.fragment,e),uo=s(e),N=l(e,"DIV",{class:!0});var X=v(N);u(ot.$$.fragment,X),Zo=s(X),Zt=l(X,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-vpt3q0"&&(Zt.innerHTML=_a),Ro=s(X),Rt=l(X,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1gq55o3"&&(Rt.innerHTML=Ma),Bo=s(X),u(oe.$$.fragment,X),X.forEach(n),ho=s(e),u(st.$$.fragment,e),fo=s(e),I=l(e,"DIV",{class:!0});var P=v(I);u(at.$$.fragment,P),Go=s(P),Bt=l(P,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-t29t5v"&&(Bt.textContent=ka),Ho=s(P),Gt=l(P,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1xyp3q9"&&(Gt.innerHTML=ba),Eo=s(P),A=l(P,"DIV",{class:!0});var ee=v(A);u(rt.$$.fragment,ee),Wo=s(ee),Ht=l(ee,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-ep3db5"&&(Ht.textContent=ya),Vo=s(ee),u(se.$$.fragment,ee),ee.forEach(n),P.forEach(n),go=s(e),u(it.$$.fragment,e),_o=s(e),q=l(e,"DIV",{class:!0});var C=v(q);u(lt.$$.fragment,C),So=s(C),Et=l(C,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-sqk04d"&&(Et.innerHTML=Ta),Qo=s(C),D=l(C,"DIV",{class:!0});var te=v(D);u(dt.$$.fragment,te),Xo=s(te),Wt=l(te,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-og4clw"&&(Wt.textContent=wa),Po=s(te),Vt=l(te,"UL",{"data-svelte-h":!0}),p(Vt)!=="svelte-rq8uot"&&(Vt.innerHTML=va),te.forEach(n),Ao=s(C),St=l(C,"DIV",{class:!0});var qn=v(St);u(ct.$$.fragment,qn),qn.forEach(n),Do=s(C),ae=l(C,"DIV",{class:!0});var It=v(ae);u(pt.$$.fragment,It),Yo=s(It),Qt=l(It,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-wwxeoo"&&(Qt.textContent=xa),It.forEach(n),Oo=s(C),Xt=l(C,"DIV",{class:!0});var zn=v(Xt);u(mt.$$.fragment,zn),zn.forEach(n),C.forEach(n),Mo=s(e),u(ut.$$.fragment,e),ko=s(e),L=l(e,"DIV",{class:!0});var U=v(L);u(ht.$$.fragment,U),Ko=s(U),Pt=l(U,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-w71jv6"&&(Pt.textContent=La),es=s(U),At=l(U,"P",{"data-svelte-h":!0}),p(At)!=="svelte-f9h7i0"&&(At.innerHTML=$a),ts=s(U),Dt=l(U,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1x24yjd"&&(Dt.textContent=Ua),ns=s(U),J=l(U,"DIV",{class:!0});var z=v(J);u(ft.$$.fragment,z),os=s(z),Yt=l(z,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-q6uxah"&&(Yt.innerHTML=Ja),ss=s(z),Ot=l(z,"UL",{"data-svelte-h":!0}),p(Ot)!=="svelte-fh1ysh"&&(Ot.innerHTML=qa),as=s(z),Kt=l(z,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-za59kj"&&(Kt.innerHTML=za),rs=s(z),en=l(z,"UL",{"data-svelte-h":!0}),p(en)!=="svelte-sxb3sg"&&(en.innerHTML=ja),is=s(z),tn=l(z,"P",{"data-svelte-h":!0}),p(tn)!=="svelte-zbz80u"&&(tn.innerHTML=Ca),ls=s(z),nn=l(z,"UL",{"data-svelte-h":!0}),p(nn)!=="svelte-1drozer"&&(nn.innerHTML=Fa),z.forEach(n),ds=s(U),Y=l(U,"DIV",{class:!0});var xn=v(Y);u(gt.$$.fragment,xn),cs=s(xn),on=l(xn,"P",{"data-svelte-h":!0}),p(on)!=="svelte-og4clw"&&(on.textContent=Na),ps=s(xn),sn=l(xn,"UL",{"data-svelte-h":!0}),p(sn)!=="svelte-rq8uot"&&(sn.innerHTML=Ia),xn.forEach(n),ms=s(U),re=l(U,"DIV",{class:!0});var Co=v(re);u(_t.$$.fragment,Co),us=s(Co),an=l(Co,"P",{"data-svelte-h":!0}),p(an)!=="svelte-wwxeoo"&&(an.textContent=Za),Co.forEach(n),hs=s(U),ie=l(U,"DIV",{class:!0});var Fo=v(ie);u(Mt.$$.fragment,Fo),fs=s(Fo),rn=l(Fo,"P",{"data-svelte-h":!0}),p(rn)!=="svelte-1eppb6b"&&(rn.innerHTML=Ra),Fo.forEach(n),gs=s(U),le=l(U,"DIV",{class:!0});var No=v(le);u(kt.$$.fragment,No),_s=s(No),ln=l(No,"P",{"data-svelte-h":!0}),p(ln)!=="svelte-19qak01"&&(ln.textContent=Ba),No.forEach(n),U.forEach(n),bo=s(e),u(bt.$$.fragment,e),yo=s(e),j=l(e,"DIV",{class:!0});var O=v(j);u(yt.$$.fragment,O),Ms=s(O),dn=l(O,"P",{"data-svelte-h":!0}),p(dn)!=="svelte-jukxuq"&&(dn.textContent=Ga),ks=s(O),cn=l(O,"P",{"data-svelte-h":!0}),p(cn)!=="svelte-1mzioae"&&(cn.innerHTML=Ha),bs=s(O),pn=l(O,"P",{"data-svelte-h":!0}),p(pn)!=="svelte-4v1yq"&&(pn.innerHTML=Ea),ys=s(O),B=l(O,"DIV",{class:!0});var _e=v(B);u(Tt.$$.fragment,_e),Ts=s(_e),mn=l(_e,"P",{"data-svelte-h":!0}),p(mn)!=="svelte-pnlbsq"&&(mn.innerHTML=Wa),ws=s(_e),un=l(_e,"P",{"data-svelte-h":!0}),p(un)!=="svelte-yz8mju"&&(un.innerHTML=Va),vs=s(_e),hn=l(_e,"P",{"data-svelte-h":!0}),p(hn)!=="svelte-ws0hzs"&&(hn.textContent=Sa),_e.forEach(n),O.forEach(n),To=s(e),u(wt.$$.fragment,e),wo=s(e),S=l(e,"DIV",{class:!0});var Ln=v(S);u(vt.$$.fragment,Ln),xs=s(Ln),fn=l(Ln,"P",{"data-svelte-h":!0}),p(fn)!=="svelte-du7a53"&&(fn.innerHTML=Qa),Ls=s(Ln),G=l(Ln,"DIV",{class:!0});var Me=v(G);u(xt.$$.fragment,Me),$s=s(Me),gn=l(Me,"P",{"data-svelte-h":!0}),p(gn)!=="svelte-1rperva"&&(gn.innerHTML=Xa),Us=s(Me),u(de.$$.fragment,Me),Js=s(Me),u(ce.$$.fragment,Me),Me.forEach(n),Ln.forEach(n),vo=s(e),u(Lt.$$.fragment,e),xo=s(e),Z=l(e,"DIV",{class:!0});var ke=v(Z);u($t.$$.fragment,ke),qs=s(ke),_n=l(ke,"P",{"data-svelte-h":!0}),p(_n)!=="svelte-hwwz9z"&&(_n.textContent=Pa),zs=s(ke),Mn=l(ke,"P",{"data-svelte-h":!0}),p(Mn)!=="svelte-68lg8f"&&(Mn.innerHTML=Aa),js=s(ke),H=l(ke,"DIV",{class:!0});var be=v(H);u(Ut.$$.fragment,be),Cs=s(be),kn=l(be,"P",{"data-svelte-h":!0}),p(kn)!=="svelte-4fv17y"&&(kn.innerHTML=Da),Fs=s(be),u(pe.$$.fragment,be),Ns=s(be),u(me.$$.fragment,be),be.forEach(n),ke.forEach(n),Lo=s(e),u(Jt.$$.fragment,e),$o=s(e),Q=l(e,"DIV",{class:!0});var $n=v(Q);u(qt.$$.fragment,$n),Is=s($n),bn=l($n,"P",{"data-svelte-h":!0}),p(bn)!=="svelte-z4eix7"&&(bn.innerHTML=Ya),Zs=s($n),E=l($n,"DIV",{class:!0});var ye=v(E);u(zt.$$.fragment,ye),Rs=s(ye),yn=l(ye,"P",{"data-svelte-h":!0}),p(yn)!=="svelte-1g7srfo"&&(yn.innerHTML=Oa),Bs=s(ye),u(ue.$$.fragment,ye),Gs=s(ye),u(he.$$.fragment,ye),ye.forEach(n),$n.forEach(n),Uo=s(e),u(jt.$$.fragment,e),Jo=s(e),R=l(e,"DIV",{class:!0});var Te=v(R);u(Ct.$$.fragment,Te),Hs=s(Te),Tn=l(Te,"P",{"data-svelte-h":!0}),p(Tn)!=="svelte-15cf5fq"&&(Tn.innerHTML=Ka),Es=s(Te),wn=l(Te,"P",{"data-svelte-h":!0}),p(wn)!=="svelte-68lg8f"&&(wn.innerHTML=er),Ws=s(Te),W=l(Te,"DIV",{class:!0});var we=v(W);u(Ft.$$.fragment,we),Vs=s(we),vn=l(we,"P",{"data-svelte-h":!0}),p(vn)!=="svelte-134d0yq"&&(vn.innerHTML=tr),Ss=s(we),u(fe.$$.fragment,we),Qs=s(we),u(ge.$$.fragment,we),we.forEach(n),Te.forEach(n),qo=s(e),u(Nt.$$.fragment,e),zo=s(e),Jn=l(e,"P",{}),v(Jn).forEach(n),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",br),or(ne.src,ea="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/markuplm_architecture.jpg")||w(ne,"src",ea),w(ne,"alt","drawing"),w(ne,"width","600"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,c),r(e,y,t),r(e,k,t),r(e,M,t),h(b,e,t),r(e,d,t),h(T,e,t),r(e,jn,t),r(e,ve,t),r(e,Cn,t),r(e,xe,t),r(e,Fn,t),r(e,Le,t),r(e,Nn,t),r(e,$e,t),r(e,In,t),r(e,Ue,t),r(e,Zn,t),r(e,Je,t),r(e,Rn,t),h(qe,e,t),r(e,Bn,t),r(e,ze,t),r(e,Gn,t),r(e,ne,t),r(e,Hn,t),r(e,je,t),r(e,En,t),h(Ce,e,t),r(e,Wn,t),r(e,Fe,t),r(e,Vn,t),h(Ne,e,t),r(e,Sn,t),r(e,Ie,t),r(e,Qn,t),r(e,Ze,t),r(e,Xn,t),r(e,Re,t),r(e,Pn,t),r(e,Be,t),r(e,An,t),r(e,Ge,t),r(e,Dn,t),h(He,e,t),r(e,Yn,t),r(e,Ee,t),r(e,On,t),r(e,We,t),r(e,Kn,t),h(Ve,e,t),r(e,eo,t),r(e,Se,t),r(e,to,t),r(e,Qe,t),r(e,no,t),h(Xe,e,t),r(e,oo,t),r(e,Pe,t),r(e,so,t),r(e,Ae,t),r(e,ao,t),h(De,e,t),r(e,ro,t),r(e,Ye,t),r(e,io,t),r(e,Oe,t),r(e,lo,t),h(Ke,e,t),r(e,co,t),h(et,e,t),r(e,po,t),r(e,tt,t),r(e,mo,t),h(nt,e,t),r(e,uo,t),r(e,N,t),h(ot,N,null),a(N,Zo),a(N,Zt),a(N,Ro),a(N,Rt),a(N,Bo),h(oe,N,null),r(e,ho,t),h(st,e,t),r(e,fo,t),r(e,I,t),h(at,I,null),a(I,Go),a(I,Bt),a(I,Ho),a(I,Gt),a(I,Eo),a(I,A),h(rt,A,null),a(A,Wo),a(A,Ht),a(A,Vo),h(se,A,null),r(e,go,t),h(it,e,t),r(e,_o,t),r(e,q,t),h(lt,q,null),a(q,So),a(q,Et),a(q,Qo),a(q,D),h(dt,D,null),a(D,Xo),a(D,Wt),a(D,Po),a(D,Vt),a(q,Ao),a(q,St),h(ct,St,null),a(q,Do),a(q,ae),h(pt,ae,null),a(ae,Yo),a(ae,Qt),a(q,Oo),a(q,Xt),h(mt,Xt,null),r(e,Mo,t),h(ut,e,t),r(e,ko,t),r(e,L,t),h(ht,L,null),a(L,Ko),a(L,Pt),a(L,es),a(L,At),a(L,ts),a(L,Dt),a(L,ns),a(L,J),h(ft,J,null),a(J,os),a(J,Yt),a(J,ss),a(J,Ot),a(J,as),a(J,Kt),a(J,rs),a(J,en),a(J,is),a(J,tn),a(J,ls),a(J,nn),a(L,ds),a(L,Y),h(gt,Y,null),a(Y,cs),a(Y,on),a(Y,ps),a(Y,sn),a(L,ms),a(L,re),h(_t,re,null),a(re,us),a(re,an),a(L,hs),a(L,ie),h(Mt,ie,null),a(ie,fs),a(ie,rn),a(L,gs),a(L,le),h(kt,le,null),a(le,_s),a(le,ln),r(e,bo,t),h(bt,e,t),r(e,yo,t),r(e,j,t),h(yt,j,null),a(j,Ms),a(j,dn),a(j,ks),a(j,cn),a(j,bs),a(j,pn),a(j,ys),a(j,B),h(Tt,B,null),a(B,Ts),a(B,mn),a(B,ws),a(B,un),a(B,vs),a(B,hn),r(e,To,t),h(wt,e,t),r(e,wo,t),r(e,S,t),h(vt,S,null),a(S,xs),a(S,fn),a(S,Ls),a(S,G),h(xt,G,null),a(G,$s),a(G,gn),a(G,Us),h(de,G,null),a(G,Js),h(ce,G,null),r(e,vo,t),h(Lt,e,t),r(e,xo,t),r(e,Z,t),h($t,Z,null),a(Z,qs),a(Z,_n),a(Z,zs),a(Z,Mn),a(Z,js),a(Z,H),h(Ut,H,null),a(H,Cs),a(H,kn),a(H,Fs),h(pe,H,null),a(H,Ns),h(me,H,null),r(e,Lo,t),h(Jt,e,t),r(e,$o,t),r(e,Q,t),h(qt,Q,null),a(Q,Is),a(Q,bn),a(Q,Zs),a(Q,E),h(zt,E,null),a(E,Rs),a(E,yn),a(E,Bs),h(ue,E,null),a(E,Gs),h(he,E,null),r(e,Uo,t),h(jt,e,t),r(e,Jo,t),r(e,R,t),h(Ct,R,null),a(R,Hs),a(R,Tn),a(R,Es),a(R,wn),a(R,Ws),a(R,W),h(Ft,W,null),a(W,Vs),a(W,vn),a(W,Ss),h(fe,W,null),a(W,Qs),h(ge,W,null),r(e,qo,t),h(Nt,e,t),r(e,zo,t),r(e,Jn,t),jo=!0},p(e,[t]){const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),oe.$set(X);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),se.$set(P);const ee={};t&2&&(ee.$$scope={dirty:t,ctx:e}),de.$set(ee);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),ce.$set(C);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),pe.$set(te);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),me.$set(qn);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),ue.$set(It);const zn={};t&2&&(zn.$$scope={dirty:t,ctx:e}),he.$set(zn);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),fe.$set(U);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),ge.$set(z)},i(e){jo||(f(b.$$.fragment,e),f(T.$$.fragment,e),f(qe.$$.fragment,e),f(Ce.$$.fragment,e),f(Ne.$$.fragment,e),f(He.$$.fragment,e),f(Ve.$$.fragment,e),f(Xe.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(oe.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(se.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(gt.$$.fragment,e),f(_t.$$.fragment,e),f(Mt.$$.fragment,e),f(kt.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(Tt.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(xt.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(Lt.$$.fragment,e),f($t.$$.fragment,e),f(Ut.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(Jt.$$.fragment,e),f(qt.$$.fragment,e),f(zt.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(jt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ft.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(Nt.$$.fragment,e),jo=!0)},o(e){g(b.$$.fragment,e),g(T.$$.fragment,e),g(qe.$$.fragment,e),g(Ce.$$.fragment,e),g(Ne.$$.fragment,e),g(He.$$.fragment,e),g(Ve.$$.fragment,e),g(Xe.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(oe.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(se.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(mt.$$.fragment,e),g(ut.$$.fragment,e),g(ht.$$.fragment,e),g(ft.$$.fragment,e),g(gt.$$.fragment,e),g(_t.$$.fragment,e),g(Mt.$$.fragment,e),g(kt.$$.fragment,e),g(bt.$$.fragment,e),g(yt.$$.fragment,e),g(Tt.$$.fragment,e),g(wt.$$.fragment,e),g(vt.$$.fragment,e),g(xt.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(Lt.$$.fragment,e),g($t.$$.fragment,e),g(Ut.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(Jt.$$.fragment,e),g(qt.$$.fragment,e),g(zt.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(jt.$$.fragment,e),g(Ct.$$.fragment,e),g(Ft.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(Nt.$$.fragment,e),jo=!1},d(e){e&&(n(y),n(k),n(M),n(d),n(jn),n(ve),n(Cn),n(xe),n(Fn),n(Le),n(Nn),n($e),n(In),n(Ue),n(Zn),n(Je),n(Rn),n(Bn),n(ze),n(Gn),n(ne),n(Hn),n(je),n(En),n(Wn),n(Fe),n(Vn),n(Sn),n(Ie),n(Qn),n(Ze),n(Xn),n(Re),n(Pn),n(Be),n(An),n(Ge),n(Dn),n(Yn),n(Ee),n(On),n(We),n(Kn),n(eo),n(Se),n(to),n(Qe),n(no),n(oo),n(Pe),n(so),n(Ae),n(ao),n(ro),n(Ye),n(io),n(Oe),n(lo),n(co),n(po),n(tt),n(mo),n(uo),n(N),n(ho),n(fo),n(I),n(go),n(_o),n(q),n(Mo),n(ko),n(L),n(bo),n(yo),n(j),n(To),n(wo),n(S),n(vo),n(xo),n(Z),n(Lo),n($o),n(Q),n(Uo),n(Jo),n(R),n(qo),n(zo),n(Jn)),n(c),_(b,e),_(T,e),_(qe,e),_(Ce,e),_(Ne,e),_(He,e),_(Ve,e),_(Xe,e),_(De,e),_(Ke,e),_(et,e),_(nt,e),_(ot),_(oe),_(st,e),_(at),_(rt),_(se),_(it,e),_(lt),_(dt),_(ct),_(pt),_(mt),_(ut,e),_(ht),_(ft),_(gt),_(_t),_(Mt),_(kt),_(bt,e),_(yt),_(Tt),_(wt,e),_(vt),_(xt),_(de),_(ce),_(Lt,e),_($t),_(Ut),_(pe),_(me),_(Jt,e),_(qt),_(zt),_(ue),_(he),_(jt,e),_(Ct),_(Ft),_(fe),_(ge),_(Nt,e)}}}const br='{"title":"MarkupLM","local":"markuplm","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage: MarkupLMProcessor","local":"usage-markuplmprocessor","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MarkupLMConfig","local":"transformers.MarkupLMConfig","sections":[],"depth":2},{"title":"MarkupLMFeatureExtractor","local":"transformers.MarkupLMFeatureExtractor","sections":[],"depth":2},{"title":"MarkupLMTokenizer","local":"transformers.MarkupLMTokenizer","sections":[],"depth":2},{"title":"MarkupLMTokenizerFast","local":"transformers.MarkupLMTokenizerFast","sections":[],"depth":2},{"title":"MarkupLMProcessor","local":"transformers.MarkupLMProcessor","sections":[],"depth":2},{"title":"MarkupLMModel","local":"transformers.MarkupLMModel","sections":[],"depth":2},{"title":"MarkupLMForSequenceClassification","local":"transformers.MarkupLMForSequenceClassification","sections":[],"depth":2},{"title":"MarkupLMForTokenClassification","local":"transformers.MarkupLMForTokenClassification","sections":[],"depth":2},{"title":"MarkupLMForQuestionAnswering","local":"transformers.MarkupLMForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function yr($){return sr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jr extends ar{constructor(c){super(),rr(this,c,yr,kr,nr,{})}}export{Jr as component};
