import{s as te,o as ne,n as ie}from"../chunks/scheduler.36a0863c.js";import{S as pe,i as oe,g as i,s as t,r as c,A as re,h as p,f as l,c as n,j as ae,u as m,x as o,k as qs,y as ce,a,v as M,d,t as u,w as h}from"../chunks/index.9c13489a.js";import{T as me}from"../chunks/Tip.3b06990e.js";import{C as j}from"../chunks/CodeBlock.05d8ec32.js";import{H as es}from"../chunks/Heading.7a254a62.js";function Me(ls){let r,U="Dai un’occhiata alla documentazione di <code>pipeline()</code> per una lista completa dei compiti supportati.";return{c(){r=i("p"),r.innerHTML=U},l(g){r=p(g,"P",{"data-svelte-h":!0}),o(r)!=="svelte-19razip"&&(r.innerHTML=U)},m(g,O){a(g,r,O)},p:ie,d(g){g&&l(r)}}}function de(ls){let r,U,g,O,J,as,T,Rs='La <code>pipeline()</code> rende semplice usare qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> per fare inferenza su diversi compiti come generazione del testo, segmentazione di immagini e classificazione di audio. Anche se non hai esperienza con una modalità specifica o non comprendi bene il codice che alimenta i modelli, è comunque possibile utilizzarli con l’opzione <code>pipeline()</code>! Questa esercitazione ti insegnerà a:',ts,b,_s="<li>Usare una <code>pipeline()</code> per fare inferenza.</li> <li>Usare uno specifico tokenizer o modello.</li> <li>Usare una <code>pipeline()</code> per compiti che riguardano audio e video.</li>",ns,y,is,w,ps,$,Xs="Nonostante ogni compito abbia una <code>pipeline()</code> associata, è più semplice utilizzare l’astrazione generica della <code>pipeline()</code> che contiene tutte quelle specifiche per ogni mansione. La <code>pipeline()</code> carica automaticamente un modello predefinito e un tokenizer in grado di fare inferenza per il tuo compito.",os,x,Ss="<li>Inizia creando una <code>pipeline()</code> e specificando il compito su cui fare inferenza:</li>",rs,Z,cs,f,Ls="<li>Inserisci il testo in input nella <code>pipeline()</code>:</li>",ms,I,Ms,C,Qs="Se hai più di un input, inseriscilo in una lista:",ds,k,us,G,Es="Qualsiasi parametro addizionale per il tuo compito può essere incluso nella <code>pipeline()</code>. La mansione <code>text-generation</code> ha un metodo <code>generate()</code> con diversi parametri per controllare l’output. Ad esempio, se desideri generare più di un output, utilizza il parametro <code>num_return_sequences</code>:",hs,v,gs,z,js,B,Ns='La <code>pipeline()</code> accetta qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Ci sono tag nel Model Hub che consentono di filtrare i modelli per attività. Una volta che avrai scelto il modello appropriato, caricalo usando la corrispondente classe <code>AutoModelFor</code> e <code>AutoTokenizer</code>. Ad esempio, carica la classe <code>AutoModelForCausalLM</code> per un compito di causal language modeling:',ys,W,fs,H,Ys="Crea una <code>pipeline()</code> per il tuo compito, specificando il modello e il tokenizer che hai caricato:",Us,V,Js,q,As="Inserisci il testo di input nella <code>pipeline()</code> per generare del testo:",Ts,R,bs,_,ws,X,Fs="La flessibilità della <code>pipeline()</code> fa si che possa essere estesa ad attività sugli audio.",$s,S,Ps="Per esempio, classifichiamo le emozioni in questo clip audio:",xs,L,Zs,Q,Ds='Trova un modello per la <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">classificazione audio</a> sul Model Hub per eseguire un compito di riconoscimento automatico delle emozioni e caricalo nella <code>pipeline()</code>:',Is,E,Cs,N,Ks="Inserisci il file audio nella <code>pipeline()</code>:",ks,Y,Gs,A,vs,F,Os="Infine, usare la <code>pipeline()</code> per le attività sulle immagini è praticamente la stessa cosa.",zs,P,se="Specifica la tua attività e inserisci l’immagine nel classificatore. L’immagine può essere sia un link che un percorso sul tuo pc in locale. Per esempio, quale specie di gatto è raffigurata qui sotto?",Bs,D,ee='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ws,K,Hs,ss,Vs;return J=new es({props:{title:"Pipeline per l’inferenza",local:"pipeline-per-linferenza",headingTag:"h1"}}),y=new me({props:{$$slots:{default:[Me]},$$scope:{ctx:ls}}}),w=new es({props:{title:"Utilizzo della Pipeline",local:"utilizzo-della-pipeline",headingTag:"h2"}}),Z=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),I=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),k=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),v=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),z=new es({props:{title:"Scegliere modello e tokenizer",local:"scegliere-modello-e-tokenizer",headingTag:"h3"}}),W=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`,wrap:!1}}),V=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),R=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),_=new es({props:{title:"Audio pipeline",local:"audio-pipeline",headingTag:"h2"}}),L=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFhdWRpb19maWxlJTIwJTNEJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJwYXRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new j({props:{code:"cHJlZHMlMjAlM0QlMjBhdWRpb19jbGFzc2lmaWVyKGF1ZGlvX2ZpbGUpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = audio_classifier(audio_file)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1315</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1307</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1274</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1261</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1242</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>}]`,wrap:!1}}),A=new es({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),K=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjB2aXNpb25fY2xhc3NpZmllciglMEElMjAlMjAlMjAlMjBpbWFnZXMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),{c(){r=i("meta"),U=t(),g=i("p"),O=t(),c(J.$$.fragment),as=t(),T=i("p"),T.innerHTML=Rs,ts=t(),b=i("ul"),b.innerHTML=_s,ns=t(),c(y.$$.fragment),is=t(),c(w.$$.fragment),ps=t(),$=i("p"),$.innerHTML=Xs,os=t(),x=i("ol"),x.innerHTML=Ss,rs=t(),c(Z.$$.fragment),cs=t(),f=i("ol"),f.innerHTML=Ls,ms=t(),c(I.$$.fragment),Ms=t(),C=i("p"),C.textContent=Qs,ds=t(),c(k.$$.fragment),us=t(),G=i("p"),G.innerHTML=Es,hs=t(),c(v.$$.fragment),gs=t(),c(z.$$.fragment),js=t(),B=i("p"),B.innerHTML=Ns,ys=t(),c(W.$$.fragment),fs=t(),H=i("p"),H.innerHTML=Ys,Us=t(),c(V.$$.fragment),Js=t(),q=i("p"),q.innerHTML=As,Ts=t(),c(R.$$.fragment),bs=t(),c(_.$$.fragment),ws=t(),X=i("p"),X.innerHTML=Fs,$s=t(),S=i("p"),S.textContent=Ps,xs=t(),c(L.$$.fragment),Zs=t(),Q=i("p"),Q.innerHTML=Ds,Is=t(),c(E.$$.fragment),Cs=t(),N=i("p"),N.innerHTML=Ks,ks=t(),c(Y.$$.fragment),Gs=t(),c(A.$$.fragment),vs=t(),F=i("p"),F.innerHTML=Os,zs=t(),P=i("p"),P.textContent=se,Bs=t(),D=i("p"),D.innerHTML=ee,Ws=t(),c(K.$$.fragment),Hs=t(),ss=i("p"),this.h()},l(s){const e=re("svelte-u9bgzb",document.head);r=p(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(s),g=p(s,"P",{}),ae(g).forEach(l),O=n(s),m(J.$$.fragment,s),as=n(s),T=p(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1rvqis7"&&(T.innerHTML=Rs),ts=n(s),b=p(s,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-fik7a1"&&(b.innerHTML=_s),ns=n(s),m(y.$$.fragment,s),is=n(s),m(w.$$.fragment,s),ps=n(s),$=p(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1nqd0ay"&&($.innerHTML=Xs),os=n(s),x=p(s,"OL",{"data-svelte-h":!0}),o(x)!=="svelte-a5h60b"&&(x.innerHTML=Ss),rs=n(s),m(Z.$$.fragment,s),cs=n(s),f=p(s,"OL",{start:!0,"data-svelte-h":!0}),o(f)!=="svelte-13e2sq6"&&(f.innerHTML=Ls),ms=n(s),m(I.$$.fragment,s),Ms=n(s),C=p(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-tdglgg"&&(C.textContent=Qs),ds=n(s),m(k.$$.fragment,s),us=n(s),G=p(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-qa2wbk"&&(G.innerHTML=Es),hs=n(s),m(v.$$.fragment,s),gs=n(s),m(z.$$.fragment,s),js=n(s),B=p(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1c68157"&&(B.innerHTML=Ns),ys=n(s),m(W.$$.fragment,s),fs=n(s),H=p(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-p862so"&&(H.innerHTML=Ys),Us=n(s),m(V.$$.fragment,s),Js=n(s),q=p(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-g4zh60"&&(q.innerHTML=As),Ts=n(s),m(R.$$.fragment,s),bs=n(s),m(_.$$.fragment,s),ws=n(s),X=p(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-cjx6rg"&&(X.innerHTML=Fs),$s=n(s),S=p(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-riddeh"&&(S.textContent=Ps),xs=n(s),m(L.$$.fragment,s),Zs=n(s),Q=p(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-15pg5pf"&&(Q.innerHTML=Ds),Is=n(s),m(E.$$.fragment,s),Cs=n(s),N=p(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-15lqrn8"&&(N.innerHTML=Ks),ks=n(s),m(Y.$$.fragment,s),Gs=n(s),m(A.$$.fragment,s),vs=n(s),F=p(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-gkha5e"&&(F.innerHTML=Os),zs=n(s),P=p(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-5pw8zv"&&(P.textContent=se),Bs=n(s),D=p(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1bks2jw"&&(D.innerHTML=ee),Ws=n(s),m(K.$$.fragment,s),Hs=n(s),ss=p(s,"P",{}),ae(ss).forEach(l),this.h()},h(){qs(r,"name","hf:doc:metadata"),qs(r,"content",ue),qs(f,"start","2")},m(s,e){ce(document.head,r),a(s,U,e),a(s,g,e),a(s,O,e),M(J,s,e),a(s,as,e),a(s,T,e),a(s,ts,e),a(s,b,e),a(s,ns,e),M(y,s,e),a(s,is,e),M(w,s,e),a(s,ps,e),a(s,$,e),a(s,os,e),a(s,x,e),a(s,rs,e),M(Z,s,e),a(s,cs,e),a(s,f,e),a(s,ms,e),M(I,s,e),a(s,Ms,e),a(s,C,e),a(s,ds,e),M(k,s,e),a(s,us,e),a(s,G,e),a(s,hs,e),M(v,s,e),a(s,gs,e),M(z,s,e),a(s,js,e),a(s,B,e),a(s,ys,e),M(W,s,e),a(s,fs,e),a(s,H,e),a(s,Us,e),M(V,s,e),a(s,Js,e),a(s,q,e),a(s,Ts,e),M(R,s,e),a(s,bs,e),M(_,s,e),a(s,ws,e),a(s,X,e),a(s,$s,e),a(s,S,e),a(s,xs,e),M(L,s,e),a(s,Zs,e),a(s,Q,e),a(s,Is,e),M(E,s,e),a(s,Cs,e),a(s,N,e),a(s,ks,e),M(Y,s,e),a(s,Gs,e),M(A,s,e),a(s,vs,e),a(s,F,e),a(s,zs,e),a(s,P,e),a(s,Bs,e),a(s,D,e),a(s,Ws,e),M(K,s,e),a(s,Hs,e),a(s,ss,e),Vs=!0},p(s,[e]){const le={};e&2&&(le.$$scope={dirty:e,ctx:s}),y.$set(le)},i(s){Vs||(d(J.$$.fragment,s),d(y.$$.fragment,s),d(w.$$.fragment,s),d(Z.$$.fragment,s),d(I.$$.fragment,s),d(k.$$.fragment,s),d(v.$$.fragment,s),d(z.$$.fragment,s),d(W.$$.fragment,s),d(V.$$.fragment,s),d(R.$$.fragment,s),d(_.$$.fragment,s),d(L.$$.fragment,s),d(E.$$.fragment,s),d(Y.$$.fragment,s),d(A.$$.fragment,s),d(K.$$.fragment,s),Vs=!0)},o(s){u(J.$$.fragment,s),u(y.$$.fragment,s),u(w.$$.fragment,s),u(Z.$$.fragment,s),u(I.$$.fragment,s),u(k.$$.fragment,s),u(v.$$.fragment,s),u(z.$$.fragment,s),u(W.$$.fragment,s),u(V.$$.fragment,s),u(R.$$.fragment,s),u(_.$$.fragment,s),u(L.$$.fragment,s),u(E.$$.fragment,s),u(Y.$$.fragment,s),u(A.$$.fragment,s),u(K.$$.fragment,s),Vs=!1},d(s){s&&(l(U),l(g),l(O),l(as),l(T),l(ts),l(b),l(ns),l(is),l(ps),l($),l(os),l(x),l(rs),l(cs),l(f),l(ms),l(Ms),l(C),l(ds),l(us),l(G),l(hs),l(gs),l(js),l(B),l(ys),l(fs),l(H),l(Us),l(Js),l(q),l(Ts),l(bs),l(ws),l(X),l($s),l(S),l(xs),l(Zs),l(Q),l(Is),l(Cs),l(N),l(ks),l(Gs),l(vs),l(F),l(zs),l(P),l(Bs),l(D),l(Ws),l(Hs),l(ss)),l(r),h(J,s),h(y,s),h(w,s),h(Z,s),h(I,s),h(k,s),h(v,s),h(z,s),h(W,s),h(V,s),h(R,s),h(_,s),h(L,s),h(E,s),h(Y,s),h(A,s),h(K,s)}}}const ue='{"title":"Pipeline per l’inferenza","local":"pipeline-per-linferenza","sections":[{"title":"Utilizzo della Pipeline","local":"utilizzo-della-pipeline","sections":[{"title":"Scegliere modello e tokenizer","local":"scegliere-modello-e-tokenizer","sections":[],"depth":3}],"depth":2},{"title":"Audio pipeline","local":"audio-pipeline","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2}],"depth":1}';function he(ls){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends pe{constructor(r){super(),oe(this,r,he,de,te,{})}}export{Je as component};
