import{s as Ys,o as Rs,n as Q}from"../chunks/scheduler.22bf70d2.js";import{S as Vs,i as qs,g as p,s as l,r as g,A as As,h as i,f as d,c as r,j as T,u as f,x as u,k as x,y as a,a as j,v as M,d as y,t as b,w}from"../chunks/index.59178e06.js";import{D as B}from"../chunks/Docstring.cefe8221.js";import{C as W}from"../chunks/CodeBlock.f7047b13.js";import{E as P}from"../chunks/ExampleCodeBlock.36f5c5dc.js";import{H as Ds}from"../chunks/Heading.f8746c79.js";function Ls(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBJbml0UHJvY2Vzc0dyb3VwS3dhcmdzJTBBJTBBJTIzJTIwVG8lMjBpbmNsdWRlJTIwJTYwSW5pdFByb2Nlc3NHcm91cEt3YXJncyU2MCUyQyUyMGluaXQlMjB0aGVuJTIwY2FsbCUyMCU2MC50b19rd2FyZ3MoKSU2MCUwQWt3YXJncyUyMCUzRCUyMEluaXRQcm9jZXNzR3JvdXBLd2FyZ3MoLi4uKS50b19rd2FyZ3MoKSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCoqa3dhcmdzKQ==",highlighted:'<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> InitProcessGroupKwargs\n\n<span class="hljs-comment"># To include `InitProcessGroupKwargs`, init then call `.to_kwargs()`</span>\nkwargs = InitProcessGroupKwargs(...).to_kwargs()\nstate = PartialState(**kwargs)',wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function Ks(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBd2l0aCUyMHN0YXRlLmxvY2FsX21haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBmaXJzdCUyMGJ5JTIwbG9jYWwlMjBwcm9jZXNzJTIwMCUyMHRoZW4lMjBpbiUyMGElMjBzZWVtaW5nbHklMEElMjAlMjAlMjAlMjAlMjMlMjByYW5kb20lMjBvcmRlciUyMGJ5JTIwdGhlJTIwb3RoZXIlMjBwcm9jZXNzZXMuJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwJTdCc3RhdGUubG9jYWxfcHJvY2Vzc19pbmRleCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> state.local_main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by local process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{state.local_process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function Os(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQXdpdGglMjBhY2NlbGVyYXRvci5tYWluX3Byb2Nlc3NfZmlyc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwZmlyc3QlMjBieSUyMHByb2Nlc3MlMjAwJTIwdGhlbiUyMGluJTIwYSUyMHNlZW1pbmdseSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJhbmRvbSUyMG9yZGVyJTIwYnklMjB0aGUlMjBvdGhlciUyMHByb2Nlc3Nlcy4lMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAlN0JhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4JTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ea(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9sYXN0X3Byb2Nlc3MlMEFkZWYlMjBwcmludF9zb21ldGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwJTdCc3RhdGUucHJvY2Vzc19pbmRleCU3RCUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAzJTIy",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_last_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 3&quot;</span>`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ta(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbG9jYWxfbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIwb24lMjBlYWNoJTIwc2VydmVyLiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMyUyME9uJTIwc2VydmVyJTIwMSUzQSUwQSUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwMCUyMG9ubHklMjIlMEElMjMlMjBPbiUyMHNlcnZlciUyMDIlM0ElMEElMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_local_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only on each server.&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function sa(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX2xvY2FsX3Byb2Nlc3MobG9jYWxfcHJvY2Vzc19pbmRleCUzRDIpJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjMlMjBPbiUyMHNlcnZlciUyMDElM0ElMEElMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwMiUyMiUwQSUyMyUyME9uJTIwc2VydmVyJTIwMiUzQSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAyJTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_local_process(<span class="hljs-params">local_process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.local_process_index}</span>&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function aa(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5LiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()


<span class="hljs-meta">&gt;&gt;&gt; </span>@state.on_main_process
<span class="hljs-meta">... </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>print_something()
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function na(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9wcm9jZXNzKHByb2Nlc3NfaW5kZXglM0QyKSUwQWRlZiUyMHByaW50X3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAlN0JzdGF0ZS5wcm9jZXNzX2luZGV4JTdEJTIyKSUwQSUwQSUwQXByaW50X3NvbWV0aGluZygpJTBBJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMDIlMjI=",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_process(<span class="hljs-params">process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function la(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEKSUyMGFzJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoaW5wdXRzKSUwQSUyMyUyMFByb2Nlc3MlMjAwJTBBJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlNUQlMEElMjMlMjBQcm9jZXNzJTIwMSUwQSU1QiUyMkMlMjIlNUQlMEElMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEJTJDJTIwYXBwbHlfcGFkZGluZyUzRFRydWUpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjIlNUQ=",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState

state = PartialState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ra(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBHUFUlMjBwcm9jZXNzZXMlMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBaWYlMjBzdGF0ZS5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjB0aW1lLnNsZWVwKDIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkknbSUyMHdhaXRpbmclMjBmb3IlMjB0aGUlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwZmluaXNoJTIwaXRzJTIwc2xlZXAuLi4lMjIpJTBBc3RhdGUud2FpdF9mb3JfZXZlcnlvbmUoKSUwQSUyMyUyMFNob3VsZCUyMHByaW50JTIwb24lMjBldmVyeSUyMHByb2Nlc3MlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBcHJpbnQoJTIyRXZlcnlvbmUlMjBpcyUyMGhlcmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two GPU processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> state.is_main_process:
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I&#x27;m waiting for the main process to finish its sleep...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>state.wait_for_everyone()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Should print on every process at the same time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Everyone is here&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function oa(v){let s,$="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMEFjY2VsZXJhdG9yU3RhdGUoKSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiU1RCUwQSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQlMkMlMjBhcHBseV9wYWRkaW5nJTNEVHJ1ZSklMjBhcyUyMGlucHV0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGlucHV0cyklMEElMjMlMjBQcm9jZXNzJTIwMCUwQSU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTIzJTIwUHJvY2VzcyUyMDElMEElNUIlMjJDJTIyJTJDJTIwJTIyQyUyMiU1RA==",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState

state = AcceleratorState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=$,c=l(),g(n.$$.fragment)},l(e){s=i(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),c=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ca(v){let s,$,c,n,o,e,m,gs=`Below are variations of a <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton class</a> in the sense that all
instances share the same state, which is initialized on the first instantiation.`,dt,fe,fs=`These classes are immutable and store information about certain configurations or
states.`,mt,_,Me,Mt,ke,Ms=`Singleton class that has information about the current training environment and functions to help with process
control. Designed to be used when only process control and device execution states are needed. Does <em>not</em> need to
be initialized from <code>Accelerator</code>.`,yt,Ee,ys="<strong>Available attributes:</strong>",bt,Ze,bs=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,wt,se,$t,S,ye,jt,Ne,ws="Lets the local main process go inside a with block.",_t,Xe,$s="The other processes will enter the with block after the main process exits.",Ut,ae,vt,G,be,Jt,Pe,js="Lets the main process go first inside a with block.",Tt,Qe,_s="The other processes will enter the with block after the main process exits.",xt,ne,Bt,z,we,Ct,We,Us="Decorator that only runs the decorated function on the last process.",It,le,St,F,$e,Gt,ze,vs="Decorator that only runs the decorated function on the local main process.",kt,re,Et,H,je,Zt,Fe,Js="Decorator that only runs the decorated function on the process with the given index on the current node.",Nt,oe,Xt,Y,_e,Pt,He,Ts="Decorator that only runs the decorated function on the main process.",Qt,ce,Wt,R,Ue,zt,Ye,xs="Decorator that only runs the decorated function on the process with the given index.",Ft,pe,Ht,ie,ve,Yt,Re,Bs="Sets the device in <code>self.device</code> to the current distributed environment.",Rt,k,Je,Vt,Ve,Cs=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,qt,qe,Is="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",At,de,Dt,V,Te,Lt,Ae,Ss=`Will stop the execution of the current process until every other process has reached that point (so this does
nothing when the script is only run in one process). Useful to do before saving a model.`,Kt,me,ht,J,xe,Ot,De,Gs="Singleton class that has information about the current training environment.",es,Le,ks="<strong>Available attributes:</strong>",ts,Ke,Es=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>initialized</strong> (<code>bool</code>) — Whether or not the <code>AcceleratorState</code> has been initialized from <code>Accelerator</code>.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,ss,q,Be,as,Oe,Zs="Lets the local main process go inside a with block.",ns,et,Ns="The other processes will enter the with block after the main process exits.",ls,A,Ce,rs,tt,Xs="Lets the main process go first inside a with block.",os,st,Ps="The other processes will enter the with block after the main process exits.",cs,E,Ie,ps,at,Qs=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,is,nt,Ws="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",ds,he,ut,I,Se,ms,lt,zs="Singleton class that has information related to gradient synchronization for gradient accumulation",hs,rt,Fs="<strong>Available attributes:</strong>",us,ot,Hs=`<li><strong>end_of_dataloader</strong> (<code>bool</code>) — Whether we have reached the end the current dataloader</li> <li><strong>remainder</strong> (<code>int</code>) — The number of extra samples that were added from padding the dataloader</li> <li><strong>sync_gradients</strong> (<code>bool</code>) — Whether the gradients should be synced across all devices</li> <li><strong>active_dataloader</strong> (<code>Optional[DataLoader]</code>) — The dataloader that is currently being iterated over</li> <li><strong>dataloader_references</strong> (<code>List[Optional[DataLoader]]</code>) — A list of references to the dataloaders that are
being iterated over</li> <li><strong>num_steps</strong> (<code>int</code>) — The number of steps to accumulate over</li> <li><strong>adjust_scheduler</strong> (<code>bool</code>) — Whether the scheduler should be adjusted to account for the gradient
accumulation</li> <li><strong>sync_with_dataloader</strong> (<code>bool</code>) — Whether the gradients should be synced at the end of the dataloader
iteration and the number of total steps reset</li> <li><strong>is_xla_gradients_synced</strong> (<code>bool</code>) — Whether the XLA gradients have been synchronized. It is initialized
as false. Once gradients have been reduced before the optimizer step, this flag is set to true. Subsequently,
after each step, the flag is reset to false. FSDP will always synchronize the gradients, hence
is_xla_gradients_synced is always true.</li>`,gt,it,ft;return o=new Ds({props:{title:"Stateful Classes",local:"accelerate.PartialState",headingTag:"h1"}}),Me=new B({props:{name:"class accelerate.PartialState",anchor:"accelerate.PartialState",parameters:[{name:"cpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"accelerate.PartialState.cpu",description:`<strong>cpu</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to force the script to execute on CPU. Will ignore any accelerators available if set to
<code>True</code> and force the execution on the CPU.`,name:"cpu"},{anchor:"accelerate.PartialState.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the relevent <code>init_process_group</code> function. Valid <code>kwargs</code> can be
found in <a href="/docs/accelerate/v0.29.0/en/package_reference/kwargs#accelerate.InitProcessGroupKwargs">utils.InitProcessGroupKwargs</a>. See the example section for detailed usage.`,name:"kwargs"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L111"}}),se=new P({props:{anchor:"accelerate.PartialState.example",$$slots:{default:[Ls]},$$scope:{ctx:v}}}),ye=new B({props:{name:"local_main_process_first",anchor:"accelerate.PartialState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L501"}}),ae=new P({props:{anchor:"accelerate.PartialState.local_main_process_first.example",$$slots:{default:[Ks]},$$scope:{ctx:v}}}),be=new B({props:{name:"main_process_first",anchor:"accelerate.PartialState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L480"}}),ne=new P({props:{anchor:"accelerate.PartialState.main_process_first.example",$$slots:{default:[Os]},$$scope:{ctx:v}}}),we=new B({props:{name:"on_last_process",anchor:"accelerate.PartialState.on_last_process",parameters:[{name:"function",val:": Callable[..., Any]"}],parametersDescription:[{anchor:"accelerate.PartialState.on_last_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L583"}}),le=new P({props:{anchor:"accelerate.PartialState.on_last_process.example",$$slots:{default:[ea]},$$scope:{ctx:v}}}),$e=new B({props:{name:"on_local_main_process",anchor:"accelerate.PartialState.on_local_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L552"}}),re=new P({props:{anchor:"accelerate.PartialState.on_local_main_process.example",$$slots:{default:[ta]},$$scope:{ctx:v}}}),je=new B({props:{name:"on_local_process",anchor:"accelerate.PartialState.on_local_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"local_process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_process.function",description:`<strong>function</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_local_process.local_process_index",description:`<strong>local_process_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the local process on which to run the function.`,name:"local_process_index"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L644"}}),oe=new P({props:{anchor:"accelerate.PartialState.on_local_process.example",$$slots:{default:[sa]},$$scope:{ctx:v}}}),_e=new B({props:{name:"on_main_process",anchor:"accelerate.PartialState.on_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L522"}}),ce=new P({props:{anchor:"accelerate.PartialState.on_main_process.example",$$slots:{default:[aa]},$$scope:{ctx:v}}}),Ue=new B({props:{name:"on_process",anchor:"accelerate.PartialState.on_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_process.function",description:`<strong>function</strong> (<code>Callable</code>, <code>optional</code>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_process.process_index",description:`<strong>process_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The index of the process on which to run the function.`,name:"process_index"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L611"}}),pe=new P({props:{anchor:"accelerate.PartialState.on_process.example",$$slots:{default:[na]},$$scope:{ctx:v}}}),ve=new B({props:{name:"set_device",anchor:"accelerate.PartialState.set_device",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L755"}}),Je=new B({props:{name:"split_between_processes",anchor:"accelerate.PartialState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.PartialState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>, or <code>datasets.Dataset</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.PartialState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L389"}}),de=new P({props:{anchor:"accelerate.PartialState.split_between_processes.example",$$slots:{default:[la]},$$scope:{ctx:v}}}),Te=new B({props:{name:"wait_for_everyone",anchor:"accelerate.PartialState.wait_for_everyone",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L345"}}),me=new P({props:{anchor:"accelerate.PartialState.wait_for_everyone.example",$$slots:{default:[ra]},$$scope:{ctx:v}}}),xe=new B({props:{name:"class accelerate.state.AcceleratorState",anchor:"accelerate.state.AcceleratorState",parameters:[{name:"mixed_precision",val:": str = None"},{name:"cpu",val:": bool = False"},{name:"dynamo_plugin",val:" = None"},{name:"deepspeed_plugin",val:" = None"},{name:"fsdp_plugin",val:" = None"},{name:"megatron_lm_plugin",val:" = None"},{name:"_from_accelerator",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L795"}}),Be=new B({props:{name:"local_main_process_first",anchor:"accelerate.state.AcceleratorState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L1047"}}),Ce=new B({props:{name:"main_process_first",anchor:"accelerate.state.AcceleratorState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L1037"}}),Ie=new B({props:{name:"split_between_processes",anchor:"accelerate.state.AcceleratorState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.state.AcceleratorState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, or <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.state.AcceleratorState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L995"}}),he=new P({props:{anchor:"accelerate.state.AcceleratorState.split_between_processes.example",$$slots:{default:[oa]},$$scope:{ctx:v}}}),Se=new B({props:{name:"class accelerate.state.GradientState",anchor:"accelerate.state.GradientState",parameters:[{name:"gradient_accumulation_plugin",val:": Optional[GradientAccumulationPlugin] = None"}],source:"https://github.com/huggingface/accelerate/blob/v0.29.0/src/accelerate/state.py#L1073"}}),{c(){s=p("meta"),$=l(),c=p("p"),n=l(),g(o.$$.fragment),e=l(),m=p("p"),m.innerHTML=gs,dt=l(),fe=p("p"),fe.textContent=fs,mt=l(),_=p("div"),g(Me.$$.fragment),Mt=l(),ke=p("p"),ke.innerHTML=Ms,yt=l(),Ee=p("p"),Ee.innerHTML=ys,bt=l(),Ze=p("ul"),Ze.innerHTML=bs,wt=l(),g(se.$$.fragment),$t=l(),S=p("div"),g(ye.$$.fragment),jt=l(),Ne=p("p"),Ne.textContent=ws,_t=l(),Xe=p("p"),Xe.textContent=$s,Ut=l(),g(ae.$$.fragment),vt=l(),G=p("div"),g(be.$$.fragment),Jt=l(),Pe=p("p"),Pe.textContent=js,Tt=l(),Qe=p("p"),Qe.textContent=_s,xt=l(),g(ne.$$.fragment),Bt=l(),z=p("div"),g(we.$$.fragment),Ct=l(),We=p("p"),We.textContent=Us,It=l(),g(le.$$.fragment),St=l(),F=p("div"),g($e.$$.fragment),Gt=l(),ze=p("p"),ze.textContent=vs,kt=l(),g(re.$$.fragment),Et=l(),H=p("div"),g(je.$$.fragment),Zt=l(),Fe=p("p"),Fe.textContent=Js,Nt=l(),g(oe.$$.fragment),Xt=l(),Y=p("div"),g(_e.$$.fragment),Pt=l(),He=p("p"),He.textContent=Ts,Qt=l(),g(ce.$$.fragment),Wt=l(),R=p("div"),g(Ue.$$.fragment),zt=l(),Ye=p("p"),Ye.textContent=xs,Ft=l(),g(pe.$$.fragment),Ht=l(),ie=p("div"),g(ve.$$.fragment),Yt=l(),Re=p("p"),Re.innerHTML=Bs,Rt=l(),k=p("div"),g(Je.$$.fragment),Vt=l(),Ve=p("p"),Ve.innerHTML=Cs,qt=l(),qe=p("p"),qe.innerHTML=Is,At=l(),g(de.$$.fragment),Dt=l(),V=p("div"),g(Te.$$.fragment),Lt=l(),Ae=p("p"),Ae.textContent=Ss,Kt=l(),g(me.$$.fragment),ht=l(),J=p("div"),g(xe.$$.fragment),Ot=l(),De=p("p"),De.textContent=Gs,es=l(),Le=p("p"),Le.innerHTML=ks,ts=l(),Ke=p("ul"),Ke.innerHTML=Es,ss=l(),q=p("div"),g(Be.$$.fragment),as=l(),Oe=p("p"),Oe.textContent=Zs,ns=l(),et=p("p"),et.textContent=Ns,ls=l(),A=p("div"),g(Ce.$$.fragment),rs=l(),tt=p("p"),tt.textContent=Xs,os=l(),st=p("p"),st.textContent=Ps,cs=l(),E=p("div"),g(Ie.$$.fragment),ps=l(),at=p("p"),at.innerHTML=Qs,is=l(),nt=p("p"),nt.innerHTML=Ws,ds=l(),g(he.$$.fragment),ut=l(),I=p("div"),g(Se.$$.fragment),ms=l(),lt=p("p"),lt.textContent=zs,hs=l(),rt=p("p"),rt.innerHTML=Fs,us=l(),ot=p("ul"),ot.innerHTML=Hs,gt=l(),it=p("p"),this.h()},l(t){const h=As("svelte-u9bgzb",document.head);s=i(h,"META",{name:!0,content:!0}),h.forEach(d),$=r(t),c=i(t,"P",{}),T(c).forEach(d),n=r(t),f(o.$$.fragment,t),e=r(t),m=i(t,"P",{"data-svelte-h":!0}),u(m)!=="svelte-6w5h2d"&&(m.innerHTML=gs),dt=r(t),fe=i(t,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-n5bwiq"&&(fe.textContent=fs),mt=r(t),_=i(t,"DIV",{class:!0});var U=T(_);f(Me.$$.fragment,U),Mt=r(U),ke=i(U,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-b0lfuj"&&(ke.innerHTML=Ms),yt=r(U),Ee=i(U,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-17v1xbv"&&(Ee.innerHTML=ys),bt=r(U),Ze=i(U,"UL",{"data-svelte-h":!0}),u(Ze)!=="svelte-13df3v1"&&(Ze.innerHTML=bs),wt=r(U),f(se.$$.fragment,U),$t=r(U),S=i(U,"DIV",{class:!0});var Z=T(S);f(ye.$$.fragment,Z),jt=r(Z),Ne=i(Z,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1xrqyx2"&&(Ne.textContent=ws),_t=r(Z),Xe=i(Z,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-144ycie"&&(Xe.textContent=$s),Ut=r(Z),f(ae.$$.fragment,Z),Z.forEach(d),vt=r(U),G=i(U,"DIV",{class:!0});var N=T(G);f(be.$$.fragment,N),Jt=r(N),Pe=i(N,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-f40x3x"&&(Pe.textContent=js),Tt=r(N),Qe=i(N,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-144ycie"&&(Qe.textContent=_s),xt=r(N),f(ne.$$.fragment,N),N.forEach(d),Bt=r(U),z=i(U,"DIV",{class:!0});var D=T(z);f(we.$$.fragment,D),Ct=r(D),We=i(D,"P",{"data-svelte-h":!0}),u(We)!=="svelte-15mu2x9"&&(We.textContent=Us),It=r(D),f(le.$$.fragment,D),D.forEach(d),St=r(U),F=i(U,"DIV",{class:!0});var L=T(F);f($e.$$.fragment,L),Gt=r(L),ze=i(L,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-10pbn0p"&&(ze.textContent=vs),kt=r(L),f(re.$$.fragment,L),L.forEach(d),Et=r(U),H=i(U,"DIV",{class:!0});var K=T(H);f(je.$$.fragment,K),Zt=r(K),Fe=i(K,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-3g0as"&&(Fe.textContent=Js),Nt=r(K),f(oe.$$.fragment,K),K.forEach(d),Xt=r(U),Y=i(U,"DIV",{class:!0});var O=T(Y);f(_e.$$.fragment,O),Pt=r(O),He=i(O,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1dr4vmg"&&(He.textContent=Ts),Qt=r(O),f(ce.$$.fragment,O),O.forEach(d),Wt=r(U),R=i(U,"DIV",{class:!0});var ee=T(R);f(Ue.$$.fragment,ee),zt=r(ee),Ye=i(ee,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-1uajfn5"&&(Ye.textContent=xs),Ft=r(ee),f(pe.$$.fragment,ee),ee.forEach(d),Ht=r(U),ie=i(U,"DIV",{class:!0});var Ge=T(ie);f(ve.$$.fragment,Ge),Yt=r(Ge),Re=i(Ge,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1ylvgoj"&&(Re.innerHTML=Bs),Ge.forEach(d),Rt=r(U),k=i(U,"DIV",{class:!0});var X=T(k);f(Je.$$.fragment,X),Vt=r(X),Ve=i(X,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-xr05jy"&&(Ve.innerHTML=Cs),qt=r(X),qe=i(X,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-hvuw2l"&&(qe.innerHTML=Is),At=r(X),f(de.$$.fragment,X),X.forEach(d),Dt=r(U),V=i(U,"DIV",{class:!0});var te=T(V);f(Te.$$.fragment,te),Lt=r(te),Ae=i(te,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-tmafbn"&&(Ae.textContent=Ss),Kt=r(te),f(me.$$.fragment,te),te.forEach(d),U.forEach(d),ht=r(t),J=i(t,"DIV",{class:!0});var C=T(J);f(xe.$$.fragment,C),Ot=r(C),De=i(C,"P",{"data-svelte-h":!0}),u(De)!=="svelte-x2ar5c"&&(De.textContent=Gs),es=r(C),Le=i(C,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-17v1xbv"&&(Le.innerHTML=ks),ts=r(C),Ke=i(C,"UL",{"data-svelte-h":!0}),u(Ke)!=="svelte-3ttfpw"&&(Ke.innerHTML=Es),ss=r(C),q=i(C,"DIV",{class:!0});var ct=T(q);f(Be.$$.fragment,ct),as=r(ct),Oe=i(ct,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-1xrqyx2"&&(Oe.textContent=Zs),ns=r(ct),et=i(ct,"P",{"data-svelte-h":!0}),u(et)!=="svelte-144ycie"&&(et.textContent=Ns),ct.forEach(d),ls=r(C),A=i(C,"DIV",{class:!0});var pt=T(A);f(Ce.$$.fragment,pt),rs=r(pt),tt=i(pt,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-f40x3x"&&(tt.textContent=Xs),os=r(pt),st=i(pt,"P",{"data-svelte-h":!0}),u(st)!=="svelte-144ycie"&&(st.textContent=Ps),pt.forEach(d),cs=r(C),E=i(C,"DIV",{class:!0});var ue=T(E);f(Ie.$$.fragment,ue),ps=r(ue),at=i(ue,"P",{"data-svelte-h":!0}),u(at)!=="svelte-xr05jy"&&(at.innerHTML=Qs),is=r(ue),nt=i(ue,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-hvuw2l"&&(nt.innerHTML=Ws),ds=r(ue),f(he.$$.fragment,ue),ue.forEach(d),C.forEach(d),ut=r(t),I=i(t,"DIV",{class:!0});var ge=T(I);f(Se.$$.fragment,ge),ms=r(ge),lt=i(ge,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-1pw2ldw"&&(lt.textContent=zs),hs=r(ge),rt=i(ge,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-17v1xbv"&&(rt.innerHTML=Fs),us=r(ge),ot=i(ge,"UL",{"data-svelte-h":!0}),u(ot)!=="svelte-kdkw1r"&&(ot.innerHTML=Hs),ge.forEach(d),gt=r(t),it=i(t,"P",{}),T(it).forEach(d),this.h()},h(){x(s,"name","hf:doc:metadata"),x(s,"content",pa),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,h){a(document.head,s),j(t,$,h),j(t,c,h),j(t,n,h),M(o,t,h),j(t,e,h),j(t,m,h),j(t,dt,h),j(t,fe,h),j(t,mt,h),j(t,_,h),M(Me,_,null),a(_,Mt),a(_,ke),a(_,yt),a(_,Ee),a(_,bt),a(_,Ze),a(_,wt),M(se,_,null),a(_,$t),a(_,S),M(ye,S,null),a(S,jt),a(S,Ne),a(S,_t),a(S,Xe),a(S,Ut),M(ae,S,null),a(_,vt),a(_,G),M(be,G,null),a(G,Jt),a(G,Pe),a(G,Tt),a(G,Qe),a(G,xt),M(ne,G,null),a(_,Bt),a(_,z),M(we,z,null),a(z,Ct),a(z,We),a(z,It),M(le,z,null),a(_,St),a(_,F),M($e,F,null),a(F,Gt),a(F,ze),a(F,kt),M(re,F,null),a(_,Et),a(_,H),M(je,H,null),a(H,Zt),a(H,Fe),a(H,Nt),M(oe,H,null),a(_,Xt),a(_,Y),M(_e,Y,null),a(Y,Pt),a(Y,He),a(Y,Qt),M(ce,Y,null),a(_,Wt),a(_,R),M(Ue,R,null),a(R,zt),a(R,Ye),a(R,Ft),M(pe,R,null),a(_,Ht),a(_,ie),M(ve,ie,null),a(ie,Yt),a(ie,Re),a(_,Rt),a(_,k),M(Je,k,null),a(k,Vt),a(k,Ve),a(k,qt),a(k,qe),a(k,At),M(de,k,null),a(_,Dt),a(_,V),M(Te,V,null),a(V,Lt),a(V,Ae),a(V,Kt),M(me,V,null),j(t,ht,h),j(t,J,h),M(xe,J,null),a(J,Ot),a(J,De),a(J,es),a(J,Le),a(J,ts),a(J,Ke),a(J,ss),a(J,q),M(Be,q,null),a(q,as),a(q,Oe),a(q,ns),a(q,et),a(J,ls),a(J,A),M(Ce,A,null),a(A,rs),a(A,tt),a(A,os),a(A,st),a(J,cs),a(J,E),M(Ie,E,null),a(E,ps),a(E,at),a(E,is),a(E,nt),a(E,ds),M(he,E,null),j(t,ut,h),j(t,I,h),M(Se,I,null),a(I,ms),a(I,lt),a(I,hs),a(I,rt),a(I,us),a(I,ot),j(t,gt,h),j(t,it,h),ft=!0},p(t,[h]){const U={};h&2&&(U.$$scope={dirty:h,ctx:t}),se.$set(U);const Z={};h&2&&(Z.$$scope={dirty:h,ctx:t}),ae.$set(Z);const N={};h&2&&(N.$$scope={dirty:h,ctx:t}),ne.$set(N);const D={};h&2&&(D.$$scope={dirty:h,ctx:t}),le.$set(D);const L={};h&2&&(L.$$scope={dirty:h,ctx:t}),re.$set(L);const K={};h&2&&(K.$$scope={dirty:h,ctx:t}),oe.$set(K);const O={};h&2&&(O.$$scope={dirty:h,ctx:t}),ce.$set(O);const ee={};h&2&&(ee.$$scope={dirty:h,ctx:t}),pe.$set(ee);const Ge={};h&2&&(Ge.$$scope={dirty:h,ctx:t}),de.$set(Ge);const X={};h&2&&(X.$$scope={dirty:h,ctx:t}),me.$set(X);const te={};h&2&&(te.$$scope={dirty:h,ctx:t}),he.$set(te)},i(t){ft||(y(o.$$.fragment,t),y(Me.$$.fragment,t),y(se.$$.fragment,t),y(ye.$$.fragment,t),y(ae.$$.fragment,t),y(be.$$.fragment,t),y(ne.$$.fragment,t),y(we.$$.fragment,t),y(le.$$.fragment,t),y($e.$$.fragment,t),y(re.$$.fragment,t),y(je.$$.fragment,t),y(oe.$$.fragment,t),y(_e.$$.fragment,t),y(ce.$$.fragment,t),y(Ue.$$.fragment,t),y(pe.$$.fragment,t),y(ve.$$.fragment,t),y(Je.$$.fragment,t),y(de.$$.fragment,t),y(Te.$$.fragment,t),y(me.$$.fragment,t),y(xe.$$.fragment,t),y(Be.$$.fragment,t),y(Ce.$$.fragment,t),y(Ie.$$.fragment,t),y(he.$$.fragment,t),y(Se.$$.fragment,t),ft=!0)},o(t){b(o.$$.fragment,t),b(Me.$$.fragment,t),b(se.$$.fragment,t),b(ye.$$.fragment,t),b(ae.$$.fragment,t),b(be.$$.fragment,t),b(ne.$$.fragment,t),b(we.$$.fragment,t),b(le.$$.fragment,t),b($e.$$.fragment,t),b(re.$$.fragment,t),b(je.$$.fragment,t),b(oe.$$.fragment,t),b(_e.$$.fragment,t),b(ce.$$.fragment,t),b(Ue.$$.fragment,t),b(pe.$$.fragment,t),b(ve.$$.fragment,t),b(Je.$$.fragment,t),b(de.$$.fragment,t),b(Te.$$.fragment,t),b(me.$$.fragment,t),b(xe.$$.fragment,t),b(Be.$$.fragment,t),b(Ce.$$.fragment,t),b(Ie.$$.fragment,t),b(he.$$.fragment,t),b(Se.$$.fragment,t),ft=!1},d(t){t&&(d($),d(c),d(n),d(e),d(m),d(dt),d(fe),d(mt),d(_),d(ht),d(J),d(ut),d(I),d(gt),d(it)),d(s),w(o,t),w(Me),w(se),w(ye),w(ae),w(be),w(ne),w(we),w(le),w($e),w(re),w(je),w(oe),w(_e),w(ce),w(Ue),w(pe),w(ve),w(Je),w(de),w(Te),w(me),w(xe),w(Be),w(Ce),w(Ie),w(he),w(Se)}}}const pa='{"title":"Stateful Classes","local":"accelerate.PartialState","sections":[],"depth":1}';function ia(v){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends Vs{constructor(s){super(),qs(this,s,ia,ca,Ys,{})}}export{Ma as component};
