import{s as Ke,n as Oe,o as el}from"../chunks/scheduler.d6170356.js";import{S as ll,i as sl,g as i,s as a,r,A as tl,h as m,f as s,c as n,j as Pe,u as c,x as o,k as P,y as al,a as t,v as p,d,t as y,w as M}from"../chunks/index.fcd4cc08.js";import{C as X}from"../chunks/CodeBlock.7b16bdef.js";import{H as F}from"../chunks/Heading.8660bd0e.js";function nl(Ge){let h,K,D,O,w,ee,f,$e='<code>timm</code>, also known as <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">pytorch-image-models</a>, is an open-source collection of state-of-the-art PyTorch image models, pretrained weights, and utility scripts for training, inference, and validation.',le,g,He='This documentation focuses on <code>timm</code> functionality in the Hugging Face Hub instead of the <code>timm</code> library itself. For detailed information about the <code>timm</code> library, visit <a href="https://huggingface.co/docs/timm" rel="nofollow">its documentation</a>.',se,b,ke='You can find a number of <code>timm</code> models on the Hub using the filters on the left of the <a href="https://huggingface.co/models?library=timm&amp;sort=downloads" rel="nofollow">models page</a>.',te,U,Ye="All models on the Hub come with several useful features:",ae,I,ze='<li>An automatically generated model card, which model authors can complete with <a href="./model-cards">information about their model</a>.</li> <li>Metadata tags help users discover the relevant <code>timm</code> models.</li> <li>An <a href="./models-widgets">interactive widget</a> you can use to play with the model directly in the browser.</li> <li>An <a href="./models-inference">Inference API</a> that allows users to make inference requests.</li>',ne,j,ie,W,Ve="Any <code>timm</code> model from the Hugging Face Hub can be loaded with a single line of code as long as you have <code>timm</code> installed! Once you’ve selected a model from the Hub, pass the model’s ID prefixed with <code>hf-hub:</code> to <code>timm</code>’s <code>create_model</code> method to download and instantiate the model.",me,Z,oe,B,_e="If you want to see how to load a specific model, you can click <strong>Use in timm</strong> and you will be given a working snippet to load it!",re,J,Ne='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1-dark.png"/>',ce,T,Qe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2-dark.png"/>',pe,x,de,v,Ee="The snippet below shows how you can perform inference on a <code>timm</code> model loaded from the Hub:",ye,C,Me,G,Ae="This should leave you with a list of predictions, like this:",he,$,Je,H,Te,k,Se="You can share your <code>timm</code> models directly to the Hugging Face Hub. This will publish a new version of your model to the Hugging Face Hub, creating a model repo for you if it doesn’t already exist.",ue,Y,Le="Before pushing a model, make sure that you’ve logged in to Hugging Face:",we,z,fe,V,Re="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, once you’ve installed <code>huggingface_hub</code> you can log in with:",ge,_,be,N,Xe="Then, push your model using the <code>push_to_hf_hub</code> method:",Ue,Q,Ie,E,je,A,Fe='All <code>timm</code> models on the Hub are automatically equipped with an <a href="./models-widgets">inference widget</a>, pictured below for <a href="https://huggingface.co/nateraw/timm-resnet50-beans" rel="nofollow">nateraw/timm-resnet50-beans</a>. Additionally, <code>timm</code> models are available through the <a href="./models-inference">Inference API</a>, which you can access through HTTP with cURL, Python’s <code>requests</code> library, or your preferred method for making network requests.',We,u,De='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget-dark.png"/>',Ze,S,Be,L,xe,R,qe='<li>timm (pytorch-image-models) <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">GitHub Repo</a>.</li> <li>timm <a href="https://huggingface.co/docs/timm" rel="nofollow">documentation</a>.</li> <li>Additional documentation at <a href="https://timm.fast.ai" rel="nofollow">timmdocs</a> by <a href="https://github.com/amaarora" rel="nofollow">Aman Arora</a>.</li> <li><a href="https://towardsdatascience.com/getting-started-with-pytorch-image-models-timm-a-practitioners-guide-4e77b4bf9055" rel="nofollow">Getting Started with PyTorch Image Models (timm): A Practitioner’s Guide</a> by <a href="https://github.com/Chris-hughes10" rel="nofollow">Chris Hughes</a>.</li>',ve,q,Ce;return w=new F({props:{title:"Using timm at Hugging Face",local:"using-timm-at-hugging-face",headingTag:"h1"}}),j=new F({props:{title:"Using existing models from the Hub",local:"using-existing-models-from-the-hub",headingTag:"h2"}}),Z=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMExvYWRpbmclMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGltbSUyRmVjYV9uZm5ldF9sMCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJTIyaGYtaHViJTNBdGltbSUyRmVjYV9uZm5ldF9sMCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Loading https://huggingface.co/timm/eca_nfnet_l0</span>
model = timm.create_model(<span class="hljs-string">&quot;hf-hub:timm/eca_nfnet_l0&quot;</span>, pretrained=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new F({props:{title:"Inference",local:"inference",headingTag:"h3"}}),C=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> timm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-comment"># Load from Hub 🔥</span>
model = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:nateraw/resnet50-oxford-iiit-pet&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Set model to eval mode for inference</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># Create Transform</span>
transform = create_transform(**resolve_data_config(model.pretrained_cfg, model=model))

<span class="hljs-comment"># Get the labels from the model config</span>
labels = model.pretrained_cfg[<span class="hljs-string">&#x27;label_names&#x27;</span>]
top_k = <span class="hljs-built_in">min</span>(<span class="hljs-built_in">len</span>(labels), <span class="hljs-number">5</span>)

<span class="hljs-comment"># Use your own image file here...</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;boxer.jpg&#x27;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

<span class="hljs-comment"># Process PIL image with transforms and add a batch dimension</span>
x = transform(image).unsqueeze(<span class="hljs-number">0</span>)

<span class="hljs-comment"># Pass inputs to model forward function to get outputs</span>
out = model(x)

<span class="hljs-comment"># Apply softmax to get predicted probabilities for each class</span>
probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Grab the values and indices of top 5 predicted classes</span>
values, indices = torch.topk(probabilities, top_k)

<span class="hljs-comment"># Prepare a nice dict of top k predictions</span>
predictions = [
    {<span class="hljs-string">&quot;label&quot;</span>: labels[i], <span class="hljs-string">&quot;score&quot;</span>: v.item()}
    <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(indices, values)
]
<span class="hljs-built_in">print</span>(predictions)`,wrap:!1}}),$=new X({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdhbWVyaWNhbl9waXRfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTk5OTg4MDc5MDcxMDQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ3N0YWZmb3Jkc2hpcmVfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdtaW5pYXR1cmVfcGluc2NoZXInJTJDJTIwJ3Njb3JlJyUzQSUyMDEuMDAwMDAwMDE0OTAxMTYxMmUtMDclN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ2NoaWh1YWh1YSclMkMlMjAnc2NvcmUnJTNBJTIwMS4wMDAwMDAwMTQ5MDExNjEyZS0wNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QidsYWJlbCclM0ElMjAnYmVhZ2xlJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTBBJTVE",highlighted:`[
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;american_pit_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9999998807907104</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;staffordshire_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;miniature_pinscher&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chihuahua&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>}
]`,wrap:!1}}),H=new F({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),z=new X({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:`python -m pip install huggingface_hub
huggingface-cli login`,wrap:!1}}),_=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()`,wrap:!1}}),Q=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMEJ1aWxkJTIwb3IlMjBsb2FkJTIwYSUyMG1vZGVsJTJDJTIwZS5nLiUyMHRpbW0ncyUyMHByZXRyYWluZWQlMjByZXNuZXQxOCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUwQSUyMyUyMCU1QkZpbmUlMjB0dW5lJTIweW91ciUyMG1vZGVsLi4uJTVEJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwUHVzaCUyMGl0JTIwdG8lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBIdWIlMEF0aW1tLm1vZGVscy5odWIucHVzaF90b19oZl9odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAncmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJ2xhYmVscyclM0ElMjAlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQlN0QlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEFtb2RlbF9yZWxvYWRlZCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCdoZi1odWIlM0ElM0N5b3VyLXVzZXJuYW1lJTNFJTJGcmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwcHJldHJhaW5lZCUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Build or load a model, e.g. timm&#x27;s pretrained resnet18</span>
model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)

<span class="hljs-comment">###########################</span>
<span class="hljs-comment"># [Fine tune your model...]</span>
<span class="hljs-comment">###########################</span>

<span class="hljs-comment"># Push it to the 🤗 Hub</span>
timm.models.hub.push_to_hf_hub(
    model,
    <span class="hljs-string">&#x27;resnet18-random-classifier&#x27;</span>,
    model_config={<span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]}
)

<span class="hljs-comment"># Load your model from the Hub</span>
model_reloaded = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:&lt;your-username&gt;/resnet18-random-classifier&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)`,wrap:!1}}),E=new F({props:{title:"Inference Widget and API",local:"inference-widget-and-api",headingTag:"h2"}}),S=new X({props:{code:"Y3VybCUyMGh0dHBzJTNBJTJGJTJGYXBpLWluZmVyZW5jZS5odWdnaW5nZmFjZS5jbyUyRm1vZGVscyUyRm5hdGVyYXclMkZ0aW1tLXJlc25ldDUwLWJlYW5zJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBiZWFucy5qcGVnJyUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCU3QiUyNEhGX0FQSV9UT0tFTiU3RCUyMiUwQSUyMyUyMCU1QiU3QiUyMmxhYmVsJTIyJTNBJTIyYW5ndWxhcl9sZWFmX3Nwb3QlMjIlMkMlMjJzY29yZSUyMiUzQTAuOTg0NTk0NzAyNzIwNjQyMSU3RCUyQyU3QiUyMmxhYmVsJTIyJTNBJTIyYmVhbl9ydXN0JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAxMzY4MzE1MDUyMjQxMDg3JTdEJTJDJTdCJTIybGFiZWwlMjIlM0ElMjJoZWFsdGh5JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAwMTcyMjA4NTg3MTczMzcyNSU3RCU1RA==",highlighted:`curl https://api-inference.huggingface.co/models/nateraw/timm-resnet50-beans \\
        -X POST \\
        --data-binary <span class="hljs-string">&#x27;@beans.jpeg&#x27;</span> \\
        -H <span class="hljs-string">&quot;Authorization: Bearer {<span class="hljs-variable">$HF_API_TOKEN</span>}&quot;</span>
<span class="hljs-comment"># [{&quot;label&quot;:&quot;angular_leaf_spot&quot;,&quot;score&quot;:0.9845947027206421},{&quot;label&quot;:&quot;bean_rust&quot;,&quot;score&quot;:0.01368315052241087},{&quot;label&quot;:&quot;healthy&quot;,&quot;score&quot;:0.001722085871733725}]</span>`,wrap:!1}}),L=new F({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){h=i("meta"),K=a(),D=i("p"),O=a(),r(w.$$.fragment),ee=a(),f=i("p"),f.innerHTML=$e,le=a(),g=i("p"),g.innerHTML=He,se=a(),b=i("p"),b.innerHTML=ke,te=a(),U=i("p"),U.textContent=Ye,ae=a(),I=i("ol"),I.innerHTML=ze,ne=a(),r(j.$$.fragment),ie=a(),W=i("p"),W.innerHTML=Ve,me=a(),r(Z.$$.fragment),oe=a(),B=i("p"),B.innerHTML=_e,re=a(),J=i("div"),J.innerHTML=Ne,ce=a(),T=i("div"),T.innerHTML=Qe,pe=a(),r(x.$$.fragment),de=a(),v=i("p"),v.innerHTML=Ee,ye=a(),r(C.$$.fragment),Me=a(),G=i("p"),G.textContent=Ae,he=a(),r($.$$.fragment),Je=a(),r(H.$$.fragment),Te=a(),k=i("p"),k.innerHTML=Se,ue=a(),Y=i("p"),Y.textContent=Le,we=a(),r(z.$$.fragment),fe=a(),V=i("p"),V.innerHTML=Re,ge=a(),r(_.$$.fragment),be=a(),N=i("p"),N.innerHTML=Xe,Ue=a(),r(Q.$$.fragment),Ie=a(),r(E.$$.fragment),je=a(),A=i("p"),A.innerHTML=Fe,We=a(),u=i("div"),u.innerHTML=De,Ze=a(),r(S.$$.fragment),Be=a(),r(L.$$.fragment),xe=a(),R=i("ul"),R.innerHTML=qe,ve=a(),q=i("p"),this.h()},l(e){const l=tl("svelte-u9bgzb",document.head);h=m(l,"META",{name:!0,content:!0}),l.forEach(s),K=n(e),D=m(e,"P",{}),Pe(D).forEach(s),O=n(e),c(w.$$.fragment,e),ee=n(e),f=m(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1bz9zfk"&&(f.innerHTML=$e),le=n(e),g=m(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1b9kavw"&&(g.innerHTML=He),se=n(e),b=m(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-19ixdpv"&&(b.innerHTML=ke),te=n(e),U=m(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1uvi03j"&&(U.textContent=Ye),ae=n(e),I=m(e,"OL",{"data-svelte-h":!0}),o(I)!=="svelte-1dns05d"&&(I.innerHTML=ze),ne=n(e),c(j.$$.fragment,e),ie=n(e),W=m(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-19q2wuk"&&(W.innerHTML=Ve),me=n(e),c(Z.$$.fragment,e),oe=n(e),B=m(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1dv22ye"&&(B.innerHTML=_e),re=n(e),J=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-y8p227"&&(J.innerHTML=Ne),ce=n(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1xvepxr"&&(T.innerHTML=Qe),pe=n(e),c(x.$$.fragment,e),de=n(e),v=m(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-4jjk9c"&&(v.innerHTML=Ee),ye=n(e),c(C.$$.fragment,e),Me=n(e),G=m(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1hfr7cw"&&(G.textContent=Ae),he=n(e),c($.$$.fragment,e),Je=n(e),c(H.$$.fragment,e),Te=n(e),k=m(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1m2yz24"&&(k.innerHTML=Se),ue=n(e),Y=m(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ixi9lc"&&(Y.textContent=Le),we=n(e),c(z.$$.fragment,e),fe=n(e),V=m(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-19plf33"&&(V.innerHTML=Re),ge=n(e),c(_.$$.fragment,e),be=n(e),N=m(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-13bqgmd"&&(N.innerHTML=Xe),Ue=n(e),c(Q.$$.fragment,e),Ie=n(e),c(E.$$.fragment,e),je=n(e),A=m(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1suwl6q"&&(A.innerHTML=Fe),We=n(e),u=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-11rs1r3"&&(u.innerHTML=De),Ze=n(e),c(S.$$.fragment,e),Be=n(e),c(L.$$.fragment,e),xe=n(e),R=m(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1o8g6cw"&&(R.innerHTML=qe),ve=n(e),q=m(e,"P",{}),Pe(q).forEach(s),this.h()},h(){P(h,"name","hf:doc:metadata"),P(h,"content",il),P(J,"class","flex justify-center"),P(T,"class","flex justify-center"),P(u,"class","flex justify-center")},m(e,l){al(document.head,h),t(e,K,l),t(e,D,l),t(e,O,l),p(w,e,l),t(e,ee,l),t(e,f,l),t(e,le,l),t(e,g,l),t(e,se,l),t(e,b,l),t(e,te,l),t(e,U,l),t(e,ae,l),t(e,I,l),t(e,ne,l),p(j,e,l),t(e,ie,l),t(e,W,l),t(e,me,l),p(Z,e,l),t(e,oe,l),t(e,B,l),t(e,re,l),t(e,J,l),t(e,ce,l),t(e,T,l),t(e,pe,l),p(x,e,l),t(e,de,l),t(e,v,l),t(e,ye,l),p(C,e,l),t(e,Me,l),t(e,G,l),t(e,he,l),p($,e,l),t(e,Je,l),p(H,e,l),t(e,Te,l),t(e,k,l),t(e,ue,l),t(e,Y,l),t(e,we,l),p(z,e,l),t(e,fe,l),t(e,V,l),t(e,ge,l),p(_,e,l),t(e,be,l),t(e,N,l),t(e,Ue,l),p(Q,e,l),t(e,Ie,l),p(E,e,l),t(e,je,l),t(e,A,l),t(e,We,l),t(e,u,l),t(e,Ze,l),p(S,e,l),t(e,Be,l),p(L,e,l),t(e,xe,l),t(e,R,l),t(e,ve,l),t(e,q,l),Ce=!0},p:Oe,i(e){Ce||(d(w.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),Ce=!0)},o(e){y(w.$$.fragment,e),y(j.$$.fragment,e),y(Z.$$.fragment,e),y(x.$$.fragment,e),y(C.$$.fragment,e),y($.$$.fragment,e),y(H.$$.fragment,e),y(z.$$.fragment,e),y(_.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),Ce=!1},d(e){e&&(s(K),s(D),s(O),s(ee),s(f),s(le),s(g),s(se),s(b),s(te),s(U),s(ae),s(I),s(ne),s(ie),s(W),s(me),s(oe),s(B),s(re),s(J),s(ce),s(T),s(pe),s(de),s(v),s(ye),s(Me),s(G),s(he),s(Je),s(Te),s(k),s(ue),s(Y),s(we),s(fe),s(V),s(ge),s(be),s(N),s(Ue),s(Ie),s(je),s(A),s(We),s(u),s(Ze),s(Be),s(xe),s(R),s(ve),s(q)),s(h),M(w,e),M(j,e),M(Z,e),M(x,e),M(C,e),M($,e),M(H,e),M(z,e),M(_,e),M(Q,e),M(E,e),M(S,e),M(L,e)}}}const il='{"title":"Using timm at Hugging Face","local":"using-timm-at-hugging-face","sections":[{"title":"Using existing models from the Hub","local":"using-existing-models-from-the-hub","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Inference Widget and API","local":"inference-widget-and-api","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function ml(Ge){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends ll{constructor(h){super(),sl(this,h,ml,nl,Ke,{})}}export{dl as component};
