import{S as gI,i as uI,s as fI,e as s,k as c,w as h,t as a,M as _I,c as r,d as o,m as l,a as n,x as g,h as i,b as d,G as t,g as m,y as u,q as f,o as _,B as b,v as bI,L as Fe}from"../../chunks/vendor-hf-doc-builder.js";import{T as Rm}from"../../chunks/Tip-hf-doc-builder.js";import{D as y}from"../../chunks/Docstring-hf-doc-builder.js";import{C as le}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as ce}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Ee}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function vI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Import required libraries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set the model name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;gpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set the pad token to eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The below sequence intentionally contains two subjects to show the difference between the two approaches</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = <span class="hljs-string">&quot;a quadcopter flight controller (RTFQ Flip MWC) that supports I2C sensors for adding things like a barometer, magnetometer, and GPS system. The officially supported sensor block (BMP180, HMC5883L on one board) is discontinued, as far as I know, everyone involved lived to sing another day. . . disorder and an extreme state of dysmetabolism characterized by extensive erythema and a significant reduction in uncovered&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tokenize the sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(sequence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the model is generating repeating text and also is not able to continue the sequence properly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">128</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
a quadcopter flight controller (RTFQ Flip MWC) that supports I2C sensors <span class="hljs-keyword">for</span> adding things like a barometer, magnetometer, <span class="hljs-keyword">and</span> GPS system. The officially supported sensor block (BMP180, HMC5883L on one board) <span class="hljs-keyword">is</span> discontinued, <span class="hljs-keyword">as</span> far <span class="hljs-keyword">as</span> I know, everyone involved lived to sing another day... disorder <span class="hljs-keyword">and</span> an extreme state of dysmetabolism characterized by extensive erythema <span class="hljs-keyword">and</span> a significant reduction <span class="hljs-keyword">in</span> uncovered muscle mass. The patient was diagnosed <span class="hljs-keyword">with</span> a severe erythema <span class="hljs-keyword">and</span> a severe erythema-like condition. The patient was treated <span class="hljs-keyword">with</span> a combination

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The result is much better and coherent when we use the \`eta_cutoff\` parameter</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">128</span>, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">2e-2</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># need to set do_sample=True for eta_cutoff to work</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
a quadcopter flight controller (RTFQ Flip MWC) that supports I2C sensors <span class="hljs-keyword">for</span> adding things like a barometer, magnetometer, <span class="hljs-keyword">and</span> GPS system. The officially supported sensor block (BMP180, HMC5883L on one board) <span class="hljs-keyword">is</span> discontinued, <span class="hljs-keyword">as</span> far <span class="hljs-keyword">as</span> I know, everyone involved lived to sing another day... disorder <span class="hljs-keyword">and</span> an extreme state of dysmetabolism characterized by extensive erythema <span class="hljs-keyword">and</span> a significant reduction <span class="hljs-keyword">in</span> uncovered fatty acids. A significant loss of brain development. The individual also experienced high levels of a common psychiatric condition called schizophrenia, <span class="hljs-keyword">with</span> an important <span class="hljs-keyword">and</span> life threatening consequence.`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function yI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_context = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Without \`eos_token_id\`, it will generate the default length, 20, ignoring \`min_new_tokens\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, min_new_tokens=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been working on a new product <span class="hljs-keyword">for</span> the past year.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If \`eos_token_id\` is set to \` company\` it will take into account how many \`min_new_tokens\` have been generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># before stopping. Note that \` Company\` (5834) and \` company\` (1664) are not actually the same token, and even</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># if they were \` Company\` would be ignored by \`min_new_tokens\` as it excludes the prompt.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, min_new_tokens=<span class="hljs-number">1</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Increasing \`min_new_tokens\` will bury the first occurrence of \` company\` generating a different sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, min_new_tokens=<span class="hljs-number">2</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If no more occurrences of the \`eos_token\` happen after \`min_new_tokens\` it returns to the 20 default tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, min_new_tokens=<span class="hljs-number">10</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new <span class="hljs-keyword">and</span> innovative brand of facial recognition technology that <span class="hljs-keyword">is</span> designed to <span class="hljs-built_in">help</span> you`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function TI(E){let T,M,k,w,x,v,$,S,J,I,j,q,K,je,W,ee,Le;return{c(){T=s("p"),M=a(`In order to get the token ids of the words that should not appear in the generated text, make sure to set
`),k=s("code"),w=a("add_prefix_space=True"),x=a(" when initializing the tokenizer, and use "),v=s("code"),$=a("tokenizer(bad_words, add_special_tokens=False).input_ids"),S=a(". The "),J=s("code"),I=a("add_prefix_space"),j=a(` argument is only supported for some slow tokenizers,
as fast tokenizers\u2019 prefixing behaviours come from `),q=s("code"),K=a("pre tokenizers"),je=a(`. Read more
`),W=s("a"),ee=a("here"),Le=a("."),this.h()},l(N){T=r(N,"P",{});var F=n(T);M=i(F,`In order to get the token ids of the words that should not appear in the generated text, make sure to set
`),k=r(F,"CODE",{});var Yt=n(k);w=i(Yt,"add_prefix_space=True"),Yt.forEach(o),x=i(F," when initializing the tokenizer, and use "),v=r(F,"CODE",{});var Kt=n(v);$=i(Kt,"tokenizer(bad_words, add_special_tokens=False).input_ids"),Kt.forEach(o),S=i(F,". The "),J=r(F,"CODE",{});var be=n(J);I=i(be,"add_prefix_space"),be.forEach(o),j=i(F,` argument is only supported for some slow tokenizers,
as fast tokenizers\u2019 prefixing behaviours come from `),q=r(F,"CODE",{});var eo=n(q);K=i(eo,"pre tokenizers"),eo.forEach(o),je=i(F,`. Read more
`),W=r(F,"A",{href:!0,rel:!0});var to=n(W);ee=i(to,"here"),to.forEach(o),Le=i(F,"."),F.forEach(o),this.h()},h(){d(W,"href","https://huggingface.co/docs/tokenizers/api/pre-tokenizers"),d(W,"rel","nofollow")},m(N,F){m(N,T,F),t(T,M),t(T,k),t(k,w),t(T,x),t(T,v),t(v,$),t(T,S),t(T,J),t(J,I),t(T,j),t(T,q),t(q,K),t(T,je),t(T,W),t(W,ee),t(T,Le)},d(N){N&&o(T)}}}function wI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation taking the bad words out. Please note that the tokenizer is initialized differently</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list.split(<span class="hljs-string">&quot; &quot;</span>):
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>word_list = <span class="hljs-string">&quot;mess&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=word_list)

<span class="hljs-meta">&gt;&gt;&gt; </span>badwords_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    bad_words_ids=bad_words_ids,
<span class="hljs-meta">... </span>    eos_token_id=tokenizer_with_prefix_space.eos_token_id,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(badwords_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.

<span class="hljs-meta">&gt;&gt;&gt; </span>badwords_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a great way to start`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function kI(E){let T,M,k,w;return{c(){T=s("p"),M=a(`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city\u2019s name appears only once in the entire text.
`),k=s("a"),w=a("Reference"),this.h()},l(x){T=r(x,"P",{});var v=n(T);M=i(v,`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city\u2019s name appears only once in the entire text.
`),k=r(v,"A",{href:!0,rel:!0});var $=n(k);w=i($,"Reference"),$.forEach(o),v.forEach(o),this.h()},h(){d(k,"href","https://huggingface.co/blog/how-to-generate"),d(k,"rel","nofollow")},m(x,v){m(x,T,v),t(T,M),t(T,k),t(k,w)},d(x){x&&o(T)}}}function $I(E){let T,M,k,w,x;return w=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSUyMGVuam95JTIwd2F0Y2hpbmclMjBmb290YmFsbCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNENTApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyME5vdyUyMGxldCdzJTIwYWRkJTIwbmdyYW0lMjBzaXplJTIwdXNpbmclMjAlM0Nub19yZXBlYXRfbmdyYW1fc2l6ZSUzRSUyMGluJTIwbW9kZWwuZ2VuZXJhdGUuJTIwVGhpcyUyMHNob3VsZCUyMHN0b3AlMjB0aGUlMjByZXBldGl0aW9ucyUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDUwJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I enjoy watching football&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&quot;I enjoy playing football on the weekends, but I&#x27;m not a big fan of the idea of playing in the middle of the night. I&#x27;m not a big fan of the idea of playing in the middle of the night. I&#x27;m not a big&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using &lt;no_repeat_ngram_size&gt; in model.generate. This should stop the repetitions in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_length=<span class="hljs-number">50</span>, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
I enjoy playing football on the weekends, but I<span class="hljs-string">&#x27;m not a big fan of the idea of playing in the middle of a game. I think it&#x27;</span>s a bit of an overreaction to the fact that we<span class="hljs-string">&#x27;re playing a team that&#x27;</span>s playing<span class="hljs-string">&quot;</span>`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function xI(E){let T,M,k,w,x;return w=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHN1bW1hcnlfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBUaGlzJTIwZ2VuZXJhdGVzJTIwYSUyMHBlbmFsdHklMjBmb3IlMjByZXBlYXRlZCUyMHRva2VucyUwQXBlbmFsaXplZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbGVuZ3RoJTNEMjAlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShiaWFzZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to lie, I&#x27;</span>m <span class="hljs-keyword">not</span> going to lie. I<span class="hljs-string">&#x27;m not going to lie

&gt;&gt;&gt; # This generates a penalty for repeated tokens
&gt;&gt;&gt; penalized_ids = model.generate(inputs[&quot;input_ids&quot;], max_length=20, repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(biased_ids, skip_special_tokens=True)[0])
I&#x27;</span>m <span class="hljs-keyword">not</span> going to lie, I was really excited about this. It<span class="hljs-string">&#x27;s a great game</span>`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function MI(E){let T,M,k,w,x,v,$,S,J,I,j,q,K,je,W,ee,Le;return{c(){T=s("p"),M=a("In order to get the token ids of the sequences that you want to bias, make sure to set "),k=s("code"),w=a("add_prefix_space=True"),x=a(` when
initializing the tokenizer, and use `),v=s("code"),$=a("tokenizer(bad_words, add_special_tokens=False).input_ids"),S=a(`. The
`),J=s("code"),I=a("add_prefix_space"),j=a(` argument is only supported for some slow tokenizers, as fast tokenizers\u2019 prefixing behaviours
come from `),q=s("code"),K=a("pre tokenizers"),je=a(". Read more "),W=s("a"),ee=a("here"),Le=a("."),this.h()},l(N){T=r(N,"P",{});var F=n(T);M=i(F,"In order to get the token ids of the sequences that you want to bias, make sure to set "),k=r(F,"CODE",{});var Yt=n(k);w=i(Yt,"add_prefix_space=True"),Yt.forEach(o),x=i(F,` when
initializing the tokenizer, and use `),v=r(F,"CODE",{});var Kt=n(v);$=i(Kt,"tokenizer(bad_words, add_special_tokens=False).input_ids"),Kt.forEach(o),S=i(F,`. The
`),J=r(F,"CODE",{});var be=n(J);I=i(be,"add_prefix_space"),be.forEach(o),j=i(F,` argument is only supported for some slow tokenizers, as fast tokenizers\u2019 prefixing behaviours
come from `),q=r(F,"CODE",{});var eo=n(q);K=i(eo,"pre tokenizers"),eo.forEach(o),je=i(F,". Read more "),W=r(F,"A",{href:!0,rel:!0});var to=n(W);ee=i(to,"here"),to.forEach(o),Le=i(F,"."),F.forEach(o),this.h()},h(){d(W,"href","https://huggingface.co/docs/tokenizers/api/pre-tokenizers"),d(W,"rel","nofollow")},m(N,F){m(N,T,F),t(T,M),t(T,k),t(k,w),t(T,x),t(T,v),t(v,$),t(T,S),t(T,J),t(J,I),t(T,j),t(T,q),t(q,K),t(T,je),t(T,W),t(W,ee),t(T,Le)},d(N){N&&o(T)}}}function EI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function FI(E){let T,M,k,w,x,v,$,S;return{c(){T=s("p"),M=a("Make sure that "),k=s("code"),w=a("do_sample=True"),x=a(" is included in the "),v=s("code"),$=a("generate"),S=a(` arguments otherwise the temperature value won\u2019t have
any effect.`)},l(J){T=r(J,"P",{});var I=n(T);M=i(I,"Make sure that "),k=r(I,"CODE",{});var j=n(k);w=i(j,"do_sample=True"),j.forEach(o),x=i(I," is included in the "),v=r(I,"CODE",{});var q=n(v);$=i(q,"generate"),q.forEach(o),S=i(I,` arguments otherwise the temperature value won\u2019t have
any effect.`),I.forEach(o)},m(J,I){m(J,T,I),t(T,M),t(T,k),t(k,w),t(T,x),t(T,v),t(v,$),t(T,S)},d(J){J&&o(T)}}}function jI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_context = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer.encode(input_context, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, max_new_tokens=<span class="hljs-number">10</span>, temperature=<span class="hljs-number">1</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> one of these companies that <span class="hljs-keyword">is</span> going to take a

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, max_new_tokens=<span class="hljs-number">10</span>, temperature=<span class="hljs-number">1</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> one of these companies, you can make a very

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0 , the output remains invariant.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, max_new_tokens=<span class="hljs-number">10</span>, temperature=<span class="hljs-number">0.0001</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been around <span class="hljs-keyword">for</span> over <span class="hljs-number">20</span> years

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># even if we set a different seed.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids=input_ids, max_new_tokens=<span class="hljs-number">10</span>, temperature=<span class="hljs-number">0.0001</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been around <span class="hljs-keyword">for</span> over <span class="hljs-number">20</span> years`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function LI(E){let T,M,k,w,x;return w=new le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;It is probably one of the most important things for parents to teach children about patience and acceptance. In this way, we as a society can ensure&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences without top_p sampling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We see that the answer tends to have a lot of repeated tokens and phrases</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_length=<span class="hljs-number">55</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;It is probably one of the most important things for parents to teach children about patience and acceptance. In this way, we as a society can ensure that our children are not taught to be impatient or to be afraid of the future.

first step is to teach them&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences with top_p sampling: set \`do_sample=True\` to use top_p sampling with \`top_p\` arugment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We already see that the answer has less repetitive tokens and is more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_length=<span class="hljs-number">55</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.25</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;It is probably one of the most important things for parents to teach children about patience and acceptance. In this way, we as a society can ensure that children learn to be more accepting of others and to be more tolerant of others.

an also teach children to be&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences with top_p sampling with a larger top_p value</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We see that as we increase the top_p value, less probable tokens also get selected during text generation, making the answer more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro Tip: In practice, we tend to use top_p values between 0.9 and 1.0!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_length=<span class="hljs-number">55</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;It is probably one of the most important things for parents to teach children about patience and acceptance. In this way, we as a society can ensure we have the best learning environment, so that we can teach to learn and not just take advantage of the environment.

</span>`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function zI(E){let T,M,k,w,x;return w=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
The dragon flew over Paris, France, landing <span class="hljs-keyword">in</span> Lyon, a city of a few million. Dragon-flying was a new form of
transport, <span class="hljs-keyword">and</span> the dragon was the first <span class="hljs-keyword">in</span> Europe.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
The dragon flew over Paris, France, crashing into Notre Dame Cathedral <span class="hljs-keyword">in</span> the French capital killing at least <span class="hljs-number">127</span>
people <span class="hljs-keyword">and</span> injuring more than <span class="hljs-number">350.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
Today, a dragon flew over Paris, France, <span class="hljs-keyword">and</span> I<span class="hljs-string">&#x27;m very happy to be here.</span>`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function JI(E){let T,M;return T=new le({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`}}),{c(){h(T.$$.fragment)},l(k){g(T.$$.fragment,k)},m(k,w){u(T,k,w),M=!0},p:Fe,i(k){M||(f(T.$$.fragment,k),M=!0)},o(k){_(T.$$.fragment,k),M=!1},d(k){b(T,k)}}}function II(E){let T,M;return{c(){T=s("p"),M=a("The API for the streamer classes is still under development and may change in the future.")},l(k){T=r(k,"P",{});var w=n(T);M=i(w,"The API for the streamer classes is still under development and may change in the future."),w.forEach(o)},m(k,w){m(k,T,w),t(T,M)},d(k){k&&o(T)}}}function UI(E){let T,M,k,w,x;return w=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function BI(E){let T,M;return{c(){T=s("p"),M=a("The API for the streamer classes is still under development and may change in the future.")},l(k){T=r(k,"P",{});var w=n(T);M=i(w,"The API for the streamer classes is still under development and may change in the future."),w.forEach(o)},m(k,w){m(k,T,w),t(T,M)},d(k){k&&o(T)}}}function WI(E){let T,M,k,w,x;return w=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`}}),{c(){T=s("p"),M=a("Examples:"),k=c(),h(w.$$.fragment)},l(v){T=r(v,"P",{});var $=n(T);M=i($,"Examples:"),$.forEach(o),k=l(v),g(w.$$.fragment,v)},m(v,$){m(v,T,$),t(T,M),m(v,k,$),u(w,v,$),x=!0},p:Fe,i(v){x||(f(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&o(T),v&&o(k),b(w,v)}}}function DI(E){let T,M,k,w,x,v,$,S,J,I,j,q,K,je,W,ee,Le,N,F,Yt,Kt,be,eo,to,jc,iy,cy,Lc,ly,dy,zc,py,my,Jc,hy,gy,Mf,Ic,uy,Ef,oo,Ro,Om,ur,fy,Am,_y,Ff,ve,by,Uc,vy,yy,Bc,Ty,wy,Wc,ky,$y,jf,Dc,xy,Lf,fr,zf,Dt,My,Hm,Ey,Fy,qc,jy,Ly,Jf,ye,Pc,Qm,zy,Jy,Iy,Sc,Ym,Uy,By,Wy,Vc,Km,Dy,qy,Py,Zc,eh,Sy,Vy,If,P,Zy,th,Gy,Cy,oh,Xy,Ny,sh,Ry,Oy,rh,Ay,Hy,nh,Qy,Yy,ah,Ky,eT,Uf,te,tT,ih,oT,sT,ch,rT,nT,lh,aT,iT,dh,cT,lT,Bf,oe,dT,ph,pT,mT,mh,hT,gT,hh,uT,fT,gh,_T,bT,Wf,_r,Df,Oo,vT,uh,yT,TT,qf,se,wT,fh,kT,$T,_h,xT,MT,bh,ET,FT,vh,jT,LT,Pf,Gc,zT,Sf,so,Ao,yh,br,JT,Th,IT,Vf,ro,vr,UT,wh,BT,Zf,no,yr,WT,kh,DT,Gf,ao,Tr,qT,$h,PT,Cf,io,wr,ST,xh,VT,Xf,co,kr,ZT,Mh,GT,Nf,lo,$r,CT,Eh,XT,Rf,po,xr,NT,Fh,RT,Of,mo,Mr,OT,jh,AT,Af,ho,Er,HT,Lh,QT,Hf,go,Fr,YT,zh,KT,Qf,uo,Ho,Jh,jr,e1,Ih,t1,Yf,fo,Lr,o1,Uh,s1,Kf,_o,zr,r1,Bh,n1,e_,bo,Jr,a1,Wh,i1,t_,vo,Ir,c1,Dh,l1,o_,yo,Ur,d1,qh,p1,s_,To,Br,m1,Ph,h1,r_,wo,Wr,g1,Sh,u1,n_,ko,Dr,f1,Vh,_1,a_,$o,qr,b1,Zh,v1,i_,xo,Pr,y1,Gh,T1,c_,Mo,Qo,Ch,Sr,w1,Xh,k1,l_,ze,Vr,$1,Nh,x1,M1,Yo,Zr,E1,Rh,F1,d_,Je,Gr,j1,Oh,L1,z1,Ko,Cr,J1,Ah,I1,p_,Ie,Xr,U1,Hh,B1,W1,es,Nr,D1,Qh,q1,m_,Eo,ts,Yh,Rr,P1,Kh,S1,h_,os,V1,Cc,Z1,G1,g_,Fo,ss,eg,Or,C1,tg,X1,u_,Ue,Ar,N1,rs,Xc,R1,O1,og,A1,H1,Q1,Nc,Hr,f_,Be,Qr,Y1,Yr,K1,sg,e2,t2,o2,Rc,Kr,__,We,en,s2,ns,Oc,r2,n2,tn,a2,i2,c2,Ac,on,b_,De,sn,l2,Hc,Qc,d2,p2,m2,Yc,rn,v_,qe,nn,h2,qt,Kc,g2,u2,rg,f2,_2,an,b2,v2,y2,el,cn,y_,de,ln,T2,B,tl,w2,k2,ng,$2,x2,ag,M2,E2,ig,F2,j2,dn,L2,z2,cg,J2,I2,lg,U2,B2,dg,W2,D2,q2,as,P2,ol,pn,T_,Pe,mn,S2,sl,rl,V2,Z2,G2,nl,hn,w_,Se,gn,C2,al,il,X2,N2,R2,cl,un,k_,Ve,fn,O2,is,ll,A2,H2,pg,Q2,Y2,K2,dl,_n,$_,Ze,bn,ew,vn,tw,mg,ow,sw,rw,pl,yn,x_,Ge,Tn,nw,Pt,ml,aw,iw,hl,cw,lw,wn,dw,pw,mw,gl,kn,M_,Ce,$n,hw,St,ul,gw,uw,hg,fw,_w,gg,bw,vw,yw,fl,xn,E_,Xe,Mn,Tw,cs,_l,ww,kw,bl,$w,xw,Mw,vl,En,F_,Ne,Fn,Ew,ug,Fw,jw,yl,jn,j_,Re,Ln,Lw,V,zw,Tl,Jw,Iw,wl,Uw,Bw,fg,Ww,Dw,_g,bg,qw,Pw,kl,Sw,Vw,$l,Zw,Gw,Cw,xl,zn,L_,Oe,Jn,Xw,vg,Nw,Rw,Ml,In,z_,Ae,Un,Ow,El,Fl,Aw,Hw,Qw,jl,Bn,J_,pe,Wn,Yw,Te,Ll,Kw,ek,yg,tk,ok,Tg,sk,rk,wg,nk,ak,ik,ls,ck,zl,Dn,I_,R,qn,lk,Jl,Il,dk,pk,mk,ds,hk,ps,gk,Ul,Pn,U_,O,Sn,uk,jo,fk,Bl,_k,bk,Vn,vk,yk,Tk,ms,wk,hs,kk,Wl,Zn,B_,He,Gn,$k,gs,Dl,xk,Mk,Cn,Ek,Fk,jk,ql,Xn,W_,me,Nn,Lk,us,Pl,zk,Jk,Rn,Ik,Uk,Bk,fs,Wk,Sl,On,D_,A,An,Dk,Vl,Zl,qk,Pk,Sk,_s,Vk,bs,Zk,Gl,Hn,q_,Qe,Qn,Gk,we,Cl,Ck,Xk,kg,Nk,Rk,$g,Ok,Ak,xg,Hk,Qk,Yk,Xl,Yn,P_,Ye,Kn,Kk,ea,e$,Mg,t$,o$,s$,Nl,ta,S_,H,oa,r$,Rl,Ol,n$,a$,i$,vs,c$,ys,l$,Al,sa,V_,Ke,ra,d$,Hl,Ql,p$,m$,h$,Yl,na,Z_,he,aa,g$,Kl,ed,u$,f$,_$,Ts,b$,td,ia,G_,et,ca,v$,ws,od,y$,T$,la,w$,k$,$$,sd,da,C_,Q,pa,x$,tt,M$,Eg,E$,F$,Fg,j$,L$,jg,z$,J$,I$,ma,U$,ha,B$,W$,D$,ks,q$,rd,ga,X_,ot,ua,P$,fa,S$,Lg,V$,Z$,G$,nd,_a,N_,Lo,$s,zg,ba,C$,Jg,X$,R_,st,va,N$,ad,id,R$,O$,A$,cd,ya,O_,rt,Ta,H$,xs,ld,Q$,Y$,Ig,K$,e0,t0,dd,wa,A_,nt,ka,o0,zo,s0,Ug,r0,n0,Bg,a0,i0,c0,pd,$a,H_,at,xa,l0,Wg,d0,p0,Ms,Ma,m0,Dg,h0,Q_,it,Ea,g0,ge,u0,md,f0,_0,qg,b0,v0,Pg,Sg,y0,T0,hd,w0,k0,$0,gd,Fa,Y_,ct,ja,x0,Vg,M0,E0,Es,La,F0,Zg,j0,K_,lt,za,L0,ud,fd,z0,J0,I0,_d,Ja,eb,dt,Ia,U0,bd,vd,B0,W0,D0,yd,Ua,tb,pt,Ba,q0,Fs,Td,P0,S0,Wa,V0,Z0,G0,wd,Da,ob,mt,qa,C0,kd,$d,X0,N0,R0,xd,Pa,sb,ht,Sa,O0,ke,Md,A0,H0,Gg,Q0,Y0,Cg,K0,e4,Xg,t4,o4,s4,Ed,Va,rb,gt,Za,r4,Ga,n4,Ng,a4,i4,c4,Fd,Ca,nb,ut,Xa,l4,jd,Ld,d4,p4,m4,zd,Na,ab,ft,Ra,h4,Jd,Id,g4,u4,f4,Ud,Oa,ib,_t,Aa,_4,Bd,Wd,b4,v4,y4,Dd,Ha,cb,Jo,js,Rg,Qa,T4,Og,w4,lb,bt,Ya,k4,qd,Pd,$4,x4,M4,Sd,Ka,db,vt,ei,E4,Ls,Vd,F4,j4,Ag,L4,z4,J4,Zd,ti,pb,yt,oi,I4,zs,Gd,U4,B4,Hg,W4,D4,q4,Cd,si,mb,Tt,ri,P4,Qg,S4,V4,Js,ni,Z4,Yg,G4,hb,wt,ai,C4,Z,X4,Xd,N4,R4,Nd,O4,A4,Kg,H4,Q4,eu,tu,Y4,K4,Rd,ex,tx,Od,ox,sx,rx,Ad,ii,gb,kt,ci,nx,ou,ax,ix,Is,li,cx,su,lx,ub,$t,di,dx,Hd,Qd,px,mx,hx,Yd,pi,fb,xt,mi,gx,$e,Kd,ux,fx,ru,_x,bx,nu,vx,yx,au,Tx,wx,kx,ep,hi,_b,Mt,gi,$x,Us,tp,xx,Mx,iu,Ex,Fx,jx,op,ui,bb,Et,fi,Lx,sp,rp,zx,Jx,Ix,np,_i,vb,Ft,bi,Ux,ap,ip,Bx,Wx,Dx,cp,vi,yb,jt,yi,qx,lp,dp,Px,Sx,Vx,pp,Ti,Tb,Lt,wi,Zx,ki,Gx,cu,Cx,Xx,Nx,mp,$i,wb,Io,Bs,lu,xi,Rx,du,Ox,kb,Ws,Ax,hp,Hx,Qx,$b,zt,Mi,Yx,pu,Kx,eM,gp,Ei,xb,Uo,Fi,tM,up,ji,Mb,Jt,Li,oM,zi,sM,mu,rM,nM,aM,fp,Ji,Eb,It,Ii,iM,Ui,cM,hu,lM,dM,pM,_p,Bi,Fb,Bo,Ds,gu,Wi,mM,uu,hM,jb,qs,gM,bp,uM,fM,Lb,L,Di,_M,fu,bM,vM,_u,yM,TM,Ps,wM,bu,kM,$M,Ss,qi,xM,vu,MM,EM,Vs,Pi,FM,yu,jM,LM,Zs,Si,zM,Tu,JM,IM,Gs,Vi,UM,Zi,BM,wu,WM,DM,qM,Cs,Gi,PM,ku,SM,VM,Xs,Ci,ZM,$u,GM,CM,Vt,Xi,XM,Ni,NM,xu,RM,OM,AM,Mu,HM,zb,Wo,Ri,QM,vp,yp,YM,KM,Jb,Do,Oi,e3,Ai,t3,Tp,o3,s3,Ib,ue,Hi,r3,Eu,n3,a3,X,Qi,i3,Fu,c3,l3,qo,d3,ju,p3,m3,Lu,h3,g3,u3,zu,Ju,f3,_3,Ut,b3,Iu,v3,y3,Uu,T3,w3,Bu,k3,$3,x3,Wu,M3,E3,Ns,Yi,F3,Du,j3,Ub,Po,Rs,qu,Ki,L3,Pu,z3,Bb,fe,ec,J3,So,I3,wp,U3,B3,kp,W3,D3,q3,$p,tc,P3,xp,oc,Wb,G,sc,S3,Mp,Ep,V3,Z3,G3,rc,C3,nc,X3,N3,R3,Fp,O3,ac,A3,H3,jp,ic,Q3,Lp,cc,Db,_e,lc,Y3,zp,Jp,K3,eE,tE,Ip,dc,oE,Up,pc,qb,Vo,Os,Su,mc,sE,Vu,rE,Pb,Bt,hc,nE,Zu,aE,iE,Bp,cE,gc,lE,Sb,Wt,uc,dE,Gu,pE,mE,Wp,hE,fc,gE,Vb,Zo,As,Cu,_c,uE,Xu,fE,Zb,D,bc,_E,Nu,bE,vE,Hs,yE,Qs,TE,Ys,vc,wE,Ru,kE,$E,Ks,yc,xE,Ou,ME,EE,er,Tc,FE,Au,jE,Gb,Y,wc,LE,Hu,zE,JE,tr,IE,or,UE,sr,kc,BE,Qu,WE,Cb;return v=new ce({}),ur=new ce({}),fr=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`}}),_r=new le({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]'}}),br=new ce({}),vr=new y({props:{name:"class transformers.generation.GreedySearchEncoderDecoderOutput",anchor:"transformers.generation.GreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L181"}}),yr=new y({props:{name:"class transformers.generation.GreedySearchDecoderOnlyOutput",anchor:"transformers.generation.GreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L85"}}),Tr=new y({props:{name:"class transformers.generation.SampleEncoderDecoderOutput",anchor:"transformers.generation.SampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape
<code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L252"}}),wr=new y({props:{name:"class transformers.generation.SampleDecoderOnlyOutput",anchor:"transformers.generation.SampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L223"}}),kr=new y({props:{name:"class transformers.generation.BeamSearchEncoderDecoderOutput",anchor:"transformers.generation.BeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L330"}}),$r=new y({props:{name:"class transformers.generation.BeamSearchDecoderOnlyOutput",anchor:"transformers.generation.BeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L295"}}),xr=new y({props:{name:"class transformers.generation.BeamSampleEncoderDecoderOutput",anchor:"transformers.generation.BeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>).`,name:"scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L415"}}),Mr=new y({props:{name:"class transformers.generation.BeamSampleDecoderOnlyOutput",anchor:"transformers.generation.BeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L380"}}),Er=new y({props:{name:"class transformers.generation.ContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L113"}}),Fr=new y({props:{name:"class transformers.generation.ContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when &#x2014;
<code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.hidden_states",description:"<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is &#x2014;",name:"hidden_states"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.passed",description:`<strong>passed</strong> or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"passed"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L152"}}),jr=new ce({}),Lr=new y({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L86"}}),zr=new y({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L58"}}),Jr=new y({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L156"}}),Ir=new y({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L128"}}),Ur=new y({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L233"}}),Br=new y({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L198"}}),Wr=new y({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L318"}}),Dr=new y({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L283"}}),qr=new y({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L394"}}),Pr=new y({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L367"}}),Sr=new ce({}),Vr=new y({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_utils.py#L69"}}),Zr=new y({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/flax/struct.py#L111"}}),Gr=new y({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_utils.py#L55"}}),Cr=new y({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/flax/struct.py#L111"}}),Xr=new y({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_utils.py#L83"}}),Nr=new y({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/flax/struct.py#L111"}}),Rr=new ce({}),Or=new ce({}),Ar=new y({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1434"}}),Hr=new y({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1455"}}),Qr=new y({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1396"}}),Kr=new y({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1418",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),en=new y({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L772"}}),on=new y({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L795",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),sn=new y({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.hallucination_penalty",description:`<strong>hallucination_penalty</strong> (<code>float</code>) &#x2014;
The parameter for hallucination penalty. 1.0 means no penalty.`,name:"hallucination_penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L332"}}),rn=new y({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L350",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),nn=new y({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L511"}}),cn=new y({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L541",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ln=new y({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L555"}}),as=new Ee({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[vI]},$$scope:{ctx:E}}}),pn=new y({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L632",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mn=new y({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1231"}}),hn=new y({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1258",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),gn=new y({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1163"}}),un=new y({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1175",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fn=new y({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1185"}}),_n=new y({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1203",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bn=new y({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1313"}}),yn=new y({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1321",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Tn=new y({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams used for group beam search. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more
details.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1086"}}),kn=new y({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1117",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$n=new y({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1214"}}),xn=new y({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1220",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mn=new y({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1267"}}),En=new y({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1275",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fn=new y({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L44"}}),jn=new y({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L47",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ln=new y({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L64"}}),zn=new y({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L71",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jn=new y({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L54"}}),In=new y({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L57",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Un=new y({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L101"}}),Bn=new y({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L124",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wn=new y({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L133"}}),ls=new Ee({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[yI]},$$scope:{ctx:E}}}),Dn=new y({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L202",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qn=new y({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L962"}}),ds=new Rm({props:{$$slots:{default:[TI]},$$scope:{ctx:E}}}),ps=new Ee({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[wI]},$$scope:{ctx:E}}}),Pn=new y({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L885",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sn=new y({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L715"}}),ms=new Rm({props:{$$slots:{default:[kI]},$$scope:{ctx:E}}}),hs=new Ee({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[$I]},$$scope:{ctx:E}}}),Zn=new y({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L761",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gn=new y({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1059"}}),Xn=new y({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1076",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Nn=new y({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L279"}}),fs=new Ee({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[xI]},$$scope:{ctx:E}}}),On=new y({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L321",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),An=new y({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.Dict[typing.Tuple[int], float]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L814"}}),_s=new Rm({props:{$$slots:{default:[MI]},$$scope:{ctx:E}}}),bs=new Ee({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[EI]},$$scope:{ctx:E}}}),Hn=new y({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L885",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qn=new y({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1281"}}),Yn=new y({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1292",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kn=new y({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1300"}}),ta=new y({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1307",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),oa=new y({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L212"}}),vs=new Rm({props:{$$slots:{default:[FI]},$$scope:{ctx:E}}}),ys=new Ee({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[jI]},$$scope:{ctx:E}}}),sa=new y({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L273",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ra=new y({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L433"}}),na=new y({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L453",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),aa=new y({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L361"}}),Ts=new Ee({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[LI]},$$scope:{ctx:E}}}),ia=new y({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L417",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ca=new y({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L462"}}),da=new y({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L487",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pa=new y({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <strong>optional</strong>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.smooth_factor",description:`<strong>smooth_factor</strong> (<code>float</code>, <strong>optional</strong>) &#x2014;
The interpolation weight for CFG Rescale. 1 means no rescaling, 0 reduces to the conditional scores without
CFG. Turn it lower if the output degenerates.`,name:"smooth_factor"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1470"}}),ks=new Ee({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[zI]},$$scope:{ctx:E}}}),ga=new y({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1581"}}),ua=new y({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1331"}}),_a=new y({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/logits_process.py#L1358",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ba=new ce({}),va=new y({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L448"}}),ya=new y({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L462"}}),Ta=new y({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L478"}}),wa=new y({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L495"}}),ka=new y({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L551"}}),$a=new y({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L567"}}),xa=new y({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L53"}}),Ma=new y({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ea=new y({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L75"}}),Fa=new y({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ja=new y({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L64"}}),La=new y({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),za=new y({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L202"}}),Ja=new y({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L228"}}),Ia=new y({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L288"}}),Ua=new y({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L367"}}),Ba=new y({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L388"}}),Da=new y({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L427"}}),qa=new y({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L238"}}),Pa=new y({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L280"}}),Sa=new y({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L511"}}),Va=new y({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L522"}}),Za=new y({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L535"}}),Ca=new y({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L542"}}),Xa=new y({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L98"}}),Na=new y({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L113"}}),Ra=new y({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L118"}}),Oa=new y({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L138"}}),Aa=new y({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L146"}}),Ha=new y({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_logits_process.py#L170"}}),Qa=new ce({}),Ya=new y({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L194"}}),Ka=new y({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L206"}}),ei=new y({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L216"}}),ti=new y({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L231"}}),oi=new y({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L315"}}),si=new y({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L337"}}),ri=new y({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L50"}}),ni=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ai=new y({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L72"}}),ii=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ci=new y({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L61"}}),li=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),di=new y({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L241"}}),pi=new y({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L262"}}),mi=new y({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L271"}}),hi=new y({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L288"}}),gi=new y({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L296"}}),ui=new y({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L309"}}),fi=new y({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L95"}}),_i=new y({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L110"}}),bi=new y({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L159"}}),vi=new y({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L179"}}),yi=new y({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L115"}}),Ti=new y({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L139"}}),wi=new y({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L363"}}),$i=new y({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_logits_process.py#L397"}}),xi=new ce({}),Mi=new y({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L36"}}),Ei=new y({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L39",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Fi=new y({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L124"}}),ji=new y({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L125",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Li=new y({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L44"}}),Ji=new y({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L60",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Ii=new y({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L102"}}),Bi=new y({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/stopping_criteria.py#L119",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Wi=new ce({}),Di=new y({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L5"}}),Ps=new Ee({props:{anchor:"transformers.Constraint.example",$$slots:{default:[JI]},$$scope:{ctx:E}}}),qi=new y({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L48",returnDescription:`
<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`
<p>token_ids(<code>torch.tensor</code>)</p>
`}}),Pi=new y({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L113",returnDescription:`
<p>The same constraint as the one being called from.</p>
`,returnType:`
<p>constraint(<code>Constraint</code>)</p>
`}}),Si=new y({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L60"}}),Vi=new y({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L104"}}),Gi=new y({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L94"}}),Ci=new y({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L24"}}),Xi=new y({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L69",returnDescription:`
<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`
<p>stepped(<code>bool</code>)</p>
`}}),Ri=new y({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L129"}}),Oi=new y({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:"<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014; a list of words, where each word is a list of ids. This constraint",name:"nested_token_ids"},{anchor:"transformers.DisjunctiveConstraint.is",description:"<strong>is</strong> fulfilled by generating just one from the list of words. &#x2014;",name:"is"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L261"}}),Hi=new y({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L350"}}),Qi=new y({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L382"}}),Yi=new y({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_constraints.py#L417"}}),Ki=new ce({}),ec=new y({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L91"}}),tc=new y({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L97",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),oc=new y({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L109",returnDescription:`
<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`
<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),sc=new y({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L123"}}),ic=new y({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L215"}}),cc=new y({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L315"}}),lc=new y({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L410"}}),dc=new y({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.32.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L504",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) \u2014 Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),pc=new y({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/beam_search.py#L798"}}),mc=new ce({}),hc=new y({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L4690"}}),uc=new y({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L3059"}}),_c=new ce({}),bc=new y({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L38"}}),Hs=new Rm({props:{warning:!0,$$slots:{default:[II]},$$scope:{ctx:E}}}),Qs=new Ee({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[UI]},$$scope:{ctx:E}}}),vc=new y({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L116"}}),yc=new y({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L130"}}),Tc=new y({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L82"}}),wc=new y({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L159"}}),tr=new Rm({props:{warning:!0,$$slots:{default:[BI]},$$scope:{ctx:E}}}),or=new Ee({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[WI]},$$scope:{ctx:E}}}),kc=new y({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/streamers.py#L213"}}),{c(){T=s("meta"),M=c(),k=s("h1"),w=s("a"),x=s("span"),h(v.$$.fragment),$=c(),S=s("span"),J=a("Utilities for Generation"),I=c(),j=s("p"),q=a("This page lists all the utility functions used by "),K=s("a"),je=a("generate()"),W=a(`,
`),ee=s("a"),Le=a("greedy_search()"),N=a(`,
`),F=s("a"),Yt=a("contrastive_search()"),Kt=a(`,
`),be=s("a"),eo=a("sample()"),to=a(`,
`),jc=s("a"),iy=a("beam_search()"),cy=a(`,
`),Lc=s("a"),ly=a("beam_sample()"),dy=a(`,
`),zc=s("a"),py=a("group_beam_search()"),my=a(`, and
`),Jc=s("a"),hy=a("constrained_beam_search()"),gy=a("."),Mf=c(),Ic=s("p"),uy=a("Most of those are only useful if you are studying the code of the generate methods in the library."),Ef=c(),oo=s("h2"),Ro=s("a"),Om=s("span"),h(ur.$$.fragment),fy=c(),Am=s("span"),_y=a("Generate Outputs"),Ff=c(),ve=s("p"),by=a("The output of "),Uc=s("a"),vy=a("generate()"),yy=a(` is an instance of a subclass of
`),Bc=s("a"),Ty=a("ModelOutput"),wy=a(`. This output is a data structure containing all the information returned
by `),Wc=s("a"),ky=a("generate()"),$y=a(", but that can also be used as tuple or dictionary."),jf=c(),Dc=s("p"),xy=a("Here\u2019s an example:"),Lf=c(),h(fr.$$.fragment),zf=c(),Dt=s("p"),My=a("The "),Hm=s("code"),Ey=a("generation_output"),Fy=a(" object is a "),qc=s("a"),jy=a("GreedySearchDecoderOnlyOutput"),Ly=a(`, as we can
see in the documentation of that class below, it means it has the following attributes:`),Jf=c(),ye=s("ul"),Pc=s("li"),Qm=s("code"),zy=a("sequences"),Jy=a(": the generated sequences of tokens"),Iy=c(),Sc=s("li"),Ym=s("code"),Uy=a("scores"),By=a(" (optional): the prediction scores of the language modelling head, for each generation step"),Wy=c(),Vc=s("li"),Km=s("code"),Dy=a("hidden_states"),qy=a(" (optional): the hidden states of the model, for each generation step"),Py=c(),Zc=s("li"),eh=s("code"),Sy=a("attentions"),Vy=a(" (optional): the attention weights of the model, for each generation step"),If=c(),P=s("p"),Zy=a("Here we have the "),th=s("code"),Gy=a("scores"),Cy=a(" since we passed along "),oh=s("code"),Xy=a("output_scores=True"),Ny=a(", but we don\u2019t have "),sh=s("code"),Ry=a("hidden_states"),Oy=a(` and
`),rh=s("code"),Ay=a("attentions"),Hy=a(" because we didn\u2019t pass "),nh=s("code"),Qy=a("output_hidden_states=True"),Yy=a(" or "),ah=s("code"),Ky=a("output_attentions=True"),eT=a("."),Uf=c(),te=s("p"),tT=a(`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get `),ih=s("code"),oT=a("None"),sT=a(". Here for instance "),ch=s("code"),rT=a("generation_output.scores"),nT=a(` are all the generated prediction scores of the
language modeling head, and `),lh=s("code"),aT=a("generation_output.attentions"),iT=a(" is "),dh=s("code"),cT=a("None"),lT=a("."),Bf=c(),oe=s("p"),dT=a("When using our "),ph=s("code"),pT=a("generation_output"),mT=a(" object as a tuple, it only keeps the attributes that don\u2019t have "),mh=s("code"),hT=a("None"),gT=a(` values.
Here, for instance, it has two elements, `),hh=s("code"),uT=a("loss"),fT=a(" then "),gh=s("code"),_T=a("logits"),bT=a(", so"),Wf=c(),h(_r.$$.fragment),Df=c(),Oo=s("p"),vT=a("will return the tuple "),uh=s("code"),yT=a("(generation_output.sequences, generation_output.scores)"),TT=a(" for instance."),qf=c(),se=s("p"),wT=a("When using our "),fh=s("code"),kT=a("generation_output"),$T=a(" object as a dictionary, it only keeps the attributes that don\u2019t have "),_h=s("code"),xT=a("None"),MT=a(`
values. Here, for instance, it has two keys that are `),bh=s("code"),ET=a("sequences"),FT=a(" and "),vh=s("code"),jT=a("scores"),LT=a("."),Pf=c(),Gc=s("p"),zT=a("We document here all output types."),Sf=c(),so=s("h3"),Ao=s("a"),yh=s("span"),h(br.$$.fragment),JT=c(),Th=s("span"),IT=a("PyTorch"),Vf=c(),ro=s("div"),h(vr.$$.fragment),UT=c(),wh=s("p"),BT=a(`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),Zf=c(),no=s("div"),h(yr.$$.fragment),WT=c(),kh=s("p"),DT=a("Base class for outputs of decoder-only generation models using greedy search."),Gf=c(),ao=s("div"),h(Tr.$$.fragment),qT=c(),$h=s("p"),PT=a(`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),Cf=c(),io=s("div"),h(wr.$$.fragment),ST=c(),xh=s("p"),VT=a("Base class for outputs of decoder-only generation models using sampling."),Xf=c(),co=s("div"),h(kr.$$.fragment),ZT=c(),Mh=s("p"),GT=a(`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),Nf=c(),lo=s("div"),h($r.$$.fragment),CT=c(),Eh=s("p"),XT=a("Base class for outputs of decoder-only generation models using beam search."),Rf=c(),po=s("div"),h(xr.$$.fragment),NT=c(),Fh=s("p"),RT=a(`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),Of=c(),mo=s("div"),h(Mr.$$.fragment),OT=c(),jh=s("p"),AT=a("Base class for outputs of decoder-only generation models using beam sample."),Af=c(),ho=s("div"),h(Er.$$.fragment),HT=c(),Lh=s("p"),QT=a("Base class for outputs of decoder-only generation models using contrastive search."),Hf=c(),go=s("div"),h(Fr.$$.fragment),YT=c(),zh=s("p"),KT=a("Base class for outputs of decoder-only generation models using contrastive search."),Qf=c(),uo=s("h3"),Ho=s("a"),Jh=s("span"),h(jr.$$.fragment),e1=c(),Ih=s("span"),t1=a("TensorFlow"),Yf=c(),fo=s("div"),h(Lr.$$.fragment),o1=c(),Uh=s("p"),s1=a(`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),Kf=c(),_o=s("div"),h(zr.$$.fragment),r1=c(),Bh=s("p"),n1=a("Base class for outputs of decoder-only generation models using greedy search."),e_=c(),bo=s("div"),h(Jr.$$.fragment),a1=c(),Wh=s("p"),i1=a(`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),t_=c(),vo=s("div"),h(Ir.$$.fragment),c1=c(),Dh=s("p"),l1=a("Base class for outputs of decoder-only generation models using sampling."),o_=c(),yo=s("div"),h(Ur.$$.fragment),d1=c(),qh=s("p"),p1=a(`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),s_=c(),To=s("div"),h(Br.$$.fragment),m1=c(),Ph=s("p"),h1=a("Base class for outputs of decoder-only generation models using beam search."),r_=c(),wo=s("div"),h(Wr.$$.fragment),g1=c(),Sh=s("p"),u1=a(`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),n_=c(),ko=s("div"),h(Dr.$$.fragment),f1=c(),Vh=s("p"),_1=a("Base class for outputs of decoder-only generation models using beam sample."),a_=c(),$o=s("div"),h(qr.$$.fragment),b1=c(),Zh=s("p"),v1=a(`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),i_=c(),xo=s("div"),h(Pr.$$.fragment),y1=c(),Gh=s("p"),T1=a("Base class for outputs of decoder-only generation models using contrastive search."),c_=c(),Mo=s("h3"),Qo=s("a"),Ch=s("span"),h(Sr.$$.fragment),w1=c(),Xh=s("span"),k1=a("FLAX"),l_=c(),ze=s("div"),h(Vr.$$.fragment),$1=c(),Nh=s("p"),x1=a("Flax Base class for outputs of decoder-only generation models using sampling."),M1=c(),Yo=s("div"),h(Zr.$$.fragment),E1=c(),Rh=s("p"),F1=a("\u201CReturns a new object replacing the specified fields with new values."),d_=c(),Je=s("div"),h(Gr.$$.fragment),j1=c(),Oh=s("p"),L1=a("Flax Base class for outputs of decoder-only generation models using greedy search."),z1=c(),Ko=s("div"),h(Cr.$$.fragment),J1=c(),Ah=s("p"),I1=a("\u201CReturns a new object replacing the specified fields with new values."),p_=c(),Ie=s("div"),h(Xr.$$.fragment),U1=c(),Hh=s("p"),B1=a("Flax Base class for outputs of decoder-only generation models using greedy search."),W1=c(),es=s("div"),h(Nr.$$.fragment),D1=c(),Qh=s("p"),q1=a("\u201CReturns a new object replacing the specified fields with new values."),m_=c(),Eo=s("h2"),ts=s("a"),Yh=s("span"),h(Rr.$$.fragment),P1=c(),Kh=s("span"),S1=a("LogitsProcessor"),h_=c(),os=s("p"),V1=a("A "),Cc=s("a"),Z1=a("LogitsProcessor"),G1=a(` can be used to modify the prediction scores of a language model head for
generation.`),g_=c(),Fo=s("h3"),ss=s("a"),eg=s("span"),h(Or.$$.fragment),C1=c(),tg=s("span"),X1=a("PyTorch"),u_=c(),Ue=s("div"),h(Ar.$$.fragment),N1=c(),rs=s("p"),Xc=s("a"),R1=a("LogitsProcessor"),O1=a(" enforcing alternated generation between the two codebooks of "),og=s("code"),A1=a("Bark"),H1=a("\u2019s fine submodel."),Q1=c(),Nc=s("div"),h(Hr.$$.fragment),f_=c(),Be=s("div"),h(Qr.$$.fragment),Y1=c(),Yr=s("p"),K1=a(`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or \u2018null\u2019 prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the `),sg=s("code"),e2=a("guidance_scale"),t2=a("."),o2=c(),Rc=s("div"),h(Kr.$$.fragment),__=c(),We=s("div"),h(en.$$.fragment),s2=c(),ns=s("p"),Oc=s("a"),r2=a("LogitsProcessor"),n2=a(` that enforces no repetition of encoder input ids n-grams for the decoder ids. See
`),tn=s("a"),a2=a("ParlAI"),i2=a("."),c2=c(),Ac=s("div"),h(on.$$.fragment),b_=c(),De=s("div"),h(sn.$$.fragment),l2=c(),Hc=s("p"),Qc=s("a"),d2=a("LogitsProcessor"),p2=a(" enforcing an exponential penalty on tokens that are not in the original input."),m2=c(),Yc=s("div"),h(rn.$$.fragment),v_=c(),qe=s("div"),h(nn.$$.fragment),h2=c(),qt=s("p"),Kc=s("a"),g2=a("LogitsWarper"),u2=a(" that performs epsilon-sampling, i.e. restricting to tokens with "),rg=s("code"),f2=a("prob >= epsilon"),_2=a(`. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See `),an=s("a"),b2=a(`Truncation Sampling as Language Model
Desmoothing`),v2=a(" for more information."),y2=c(),el=s("div"),h(cn.$$.fragment),y_=c(),de=s("div"),h(ln.$$.fragment),T2=c(),B=s("p"),tl=s("a"),w2=a("LogitsWarper"),k2=a(` that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, `),ng=s("code"),$2=a("eta"),x2=a(", which is calculated based on a combination of the hyperparameter "),ag=s("code"),M2=a("epsilon"),E2=a(` and the entropy of
the token probabilities, i.e. `),ig=s("code"),F2=a("eta := min(epsilon, sqrt(epsilon, e^-entropy(probabilities)))"),j2=a(`. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See `),dn=s("a"),L2=a(`Truncation
Sampling as Language Model Desmoothing`),z2=a(" for more information. Note: "),cg=s("code"),J2=a("do_sample"),I2=a(`
must be set to `),lg=s("code"),U2=a("True"),B2=a(" for this "),dg=s("code"),W2=a("LogitsWarper"),D2=a(" to work."),q2=c(),h(as.$$.fragment),P2=c(),ol=s("div"),h(pn.$$.fragment),T_=c(),Pe=s("div"),h(mn.$$.fragment),S2=c(),sl=s("p"),rl=s("a"),V2=a("LogitsProcessor"),Z2=a(` that exponentially increases the score of the eos_token_id after regulation_start has been
reached.`),G2=c(),nl=s("div"),h(hn.$$.fragment),w_=c(),Se=s("div"),h(gn.$$.fragment),C2=c(),al=s("p"),il=s("a"),X2=a("LogitsProcessor"),N2=a(" that enforces the specified token as the first generated token."),R2=c(),cl=s("div"),h(un.$$.fragment),k_=c(),Ve=s("div"),h(fn.$$.fragment),O2=c(),is=s("p"),ll=s("a"),A2=a("LogitsProcessor"),H2=a(" that enforces the specified token as the last generated token when "),pg=s("code"),Q2=a("max_length"),Y2=a(" is reached."),K2=c(),dl=s("div"),h(_n.$$.fragment),$_=c(),Ze=s("div"),h(bn.$$.fragment),ew=c(),vn=s("p"),tw=a(`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to `),mg=s("code"),ow=a("inf"),sw=a(` so that they are
sampled at their corresponding index.`),rw=c(),pl=s("div"),h(yn.$$.fragment),x_=c(),Ge=s("div"),h(Tn.$$.fragment),nw=c(),Pt=s("p"),ml=s("a"),aw=a("LogitsProcessor"),iw=a(` that enforces diverse beam search. Note that this logits processor is only effective for
`),hl=s("a"),cw=a("PreTrainedModel.group_beam_search()"),lw=a(". See "),wn=s("a"),dw=a(`Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence
Models`),pw=a(" for more details."),mw=c(),gl=s("div"),h(kn.$$.fragment),M_=c(),Ce=s("div"),h($n.$$.fragment),hw=c(),St=s("p"),ul=s("a"),gw=a("LogitsProcessor"),uw=a(" that removes all "),hg=s("code"),fw=a("nan"),_w=a(" and "),gg=s("code"),bw=a("inf"),vw=a(` values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`),yw=c(),fl=s("div"),h(xn.$$.fragment),E_=c(),Xe=s("div"),h(Mn.$$.fragment),Tw=c(),cs=s("p"),_l=s("a"),ww=a("LogitsWarper"),kw=a(" and "),bl=s("a"),$w=a("LogitsProcessor"),xw=a(` for normalizing the scores using log-softmax. It\u2019s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn\u2019t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`),Mw=c(),vl=s("div"),h(En.$$.fragment),F_=c(),Ne=s("div"),h(Fn.$$.fragment),Ew=c(),ug=s("p"),Fw=a("Abstract base class for all logit processors that can be applied during generation."),jw=c(),yl=s("div"),h(jn.$$.fragment),j_=c(),Re=s("div"),h(Ln.$$.fragment),Lw=c(),V=s("p"),zw=a("This class can be used to create a list of "),Tl=s("a"),Jw=a("LogitsProcessor"),Iw=a(" or "),wl=s("a"),Uw=a("LogitsWarper"),Bw=a(` to subsequently process a
`),fg=s("code"),Ww=a("scores"),Dw=a(" input tensor. This class inherits from list and adds a specific "),_g=s("em"),bg=s("strong"),qw=a("call"),Pw=a(` method to apply each
`),kl=s("a"),Sw=a("LogitsProcessor"),Vw=a(" or "),$l=s("a"),Zw=a("LogitsWarper"),Gw=a(" to the inputs."),Cw=c(),xl=s("div"),h(zn.$$.fragment),L_=c(),Oe=s("div"),h(Jn.$$.fragment),Xw=c(),vg=s("p"),Nw=a("Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),Rw=c(),Ml=s("div"),h(In.$$.fragment),z_=c(),Ae=s("div"),h(Un.$$.fragment),Ow=c(),El=s("p"),Fl=s("a"),Aw=a("LogitsProcessor"),Hw=a(" enforcing a min-length by setting EOS probability to 0."),Qw=c(),jl=s("div"),h(Bn.$$.fragment),J_=c(),pe=s("div"),h(Wn.$$.fragment),Yw=c(),Te=s("p"),Ll=s("a"),Kw=a("LogitsProcessor"),ek=a(` enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, `),yg=s("code"),tk=a("min_length"),ok=a(" will compute the length of "),Tg=s("code"),sk=a("prompt + newly generated tokens"),rk=a(" whereas for other models it will behave as "),wg=s("code"),nk=a("min_new_tokens"),ak=a(`, that is, taking only into account
the newly generated ones.`),ik=c(),h(ls.$$.fragment),ck=c(),zl=s("div"),h(Dn.$$.fragment),I_=c(),R=s("div"),h(qn.$$.fragment),lk=c(),Jl=s("p"),Il=s("a"),dk=a("LogitsProcessor"),pk=a(" that enforces that specified sequences will never be selected."),mk=c(),h(ds.$$.fragment),hk=c(),h(ps.$$.fragment),gk=c(),Ul=s("div"),h(Pn.$$.fragment),U_=c(),O=s("div"),h(Sn.$$.fragment),uk=c(),jo=s("p"),fk=a(`N-grams are groups of \u201Cn\u201D consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: \u201CShe runs fast\u201D, the bi-grams (n=2) would be (\u201Cshe\u201D, \u201Cruns\u201D) and (\u201Cruns\u201D, \u201Cfast\u201D). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This `),Bl=s("a"),_k=a("LogitsProcessor"),bk=a(` enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
`),Vn=s("a"),vk=a("Fairseq"),yk=a("."),Tk=c(),h(ms.$$.fragment),wk=c(),h(hs.$$.fragment),kk=c(),Wl=s("div"),h(Zn.$$.fragment),B_=c(),He=s("div"),h(Gn.$$.fragment),$k=c(),gs=s("p"),Dl=s("a"),xk=a("LogitsProcessor"),Mk=a(` that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See `),Cn=s("a"),Ek=a("Autoregressive Entity Retrieval"),Fk=a(" for more information."),jk=c(),ql=s("div"),h(Xn.$$.fragment),W_=c(),me=s("div"),h(Nn.$$.fragment),Lk=c(),us=s("p"),Pl=s("a"),zk=a("LogitsProcessor"),Jk=a(` that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are less likely to be
selected. The formula can be seen in the original `),Rn=s("a"),Ik=a("paper"),Uk=a(`. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`),Bk=c(),h(fs.$$.fragment),Wk=c(),Sl=s("div"),h(On.$$.fragment),D_=c(),A=s("div"),h(An.$$.fragment),Dk=c(),Vl=s("p"),Zl=s("a"),qk=a("LogitsProcessor"),Pk=a(` that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`),Sk=c(),h(_s.$$.fragment),Vk=c(),h(bs.$$.fragment),Zk=c(),Gl=s("div"),h(Hn.$$.fragment),q_=c(),Qe=s("div"),h(Qn.$$.fragment),Gk=c(),we=s("p"),Cl=s("a"),Ck=a("SuppressTokensAtBeginLogitsProcessor"),Xk=a(" supresses a list of tokens as soon as the "),kg=s("code"),Nk=a("generate"),Rk=a(` function starts
generating using `),$g=s("code"),Ok=a("begin_index"),Ak=a(" tokens. This should ensure that the tokens defined by "),xg=s("code"),Hk=a("begin_suppress_tokens"),Qk=a(` at not
sampled at the begining of the generation.`),Yk=c(),Xl=s("div"),h(Yn.$$.fragment),P_=c(),Ye=s("div"),h(Kn.$$.fragment),Kk=c(),ea=s("p"),e$=a("This processor can be used to suppress a list of tokens. The processor will set their log probs to "),Mg=s("code"),t$=a("-inf"),o$=a(` so that they
are not sampled.`),s$=c(),Nl=s("div"),h(ta.$$.fragment),S_=c(),H=s("div"),h(oa.$$.fragment),r$=c(),Rl=s("p"),Ol=s("a"),n$=a("LogitsWarper"),a$=a(` for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`),i$=c(),h(vs.$$.fragment),c$=c(),h(ys.$$.fragment),l$=c(),Al=s("div"),h(sa.$$.fragment),V_=c(),Ke=s("div"),h(ra.$$.fragment),d$=c(),Hl=s("p"),Ql=s("a"),p$=a("LogitsWarper"),m$=a(" that performs top-k, i.e. restricting to the k highest probability elements."),h$=c(),Yl=s("div"),h(na.$$.fragment),Z_=c(),he=s("div"),h(aa.$$.fragment),g$=c(),Kl=s("p"),ed=s("a"),u$=a("LogitsWarper"),f$=a(" that performs top-p, i.e. restricting to top tokens summing to prob_cut_off <= prob_cut_off."),_$=c(),h(Ts.$$.fragment),b$=c(),td=s("div"),h(ia.$$.fragment),G_=c(),et=s("div"),h(ca.$$.fragment),v$=c(),ws=s("p"),od=s("a"),y$=a("LogitsWarper"),T$=a(" that performs typical decoding. See "),la=s("a"),w$=a(`Typical Decoding for Natural Language
Generation`),k$=a(" for more information."),$$=c(),sd=s("div"),h(da.$$.fragment),C_=c(),Q=s("div"),h(pa.$$.fragment),x$=c(),tt=s("p"),M$=a(`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the `),Eg=s("code"),E$=a("guidance_scale"),F$=a(". The unconditional scores are computed internally by prompting "),Fg=s("code"),j$=a("model"),L$=a(` with
the `),jg=s("code"),z$=a("unconditional_ids"),J$=a(" branch."),I$=c(),ma=s("p"),U$=a("See "),ha=s("a"),B$=a("the paper"),W$=a(" for more information."),D$=c(),h(ks.$$.fragment),q$=c(),rd=s("div"),h(ga.$$.fragment),X_=c(),ot=s("div"),h(ua.$$.fragment),P$=c(),fa=s("p"),S$=a(`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to `),Lg=s("code"),V$=a("inf"),Z$=a(" so that they are sampled at their corresponding index."),G$=c(),nd=s("div"),h(_a.$$.fragment),N_=c(),Lo=s("h3"),$s=s("a"),zg=s("span"),h(ba.$$.fragment),C$=c(),Jg=s("span"),X$=a("TensorFlow"),R_=c(),st=s("div"),h(va.$$.fragment),N$=c(),ad=s("p"),id=s("a"),R$=a("TFLogitsProcessor"),O$=a(" that enforces the specified token as the first generated token."),A$=c(),cd=s("div"),h(ya.$$.fragment),O_=c(),rt=s("div"),h(Ta.$$.fragment),H$=c(),xs=s("p"),ld=s("a"),Q$=a("TFLogitsProcessor"),Y$=a(" that enforces the specified token as the last generated token when "),Ig=s("code"),K$=a("max_length"),e0=a(" is reached."),t0=c(),dd=s("div"),h(wa.$$.fragment),A_=c(),nt=s("div"),h(ka.$$.fragment),o0=c(),zo=s("p"),s0=a(`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to `),Ug=s("code"),r0=a("0"),n0=a(` and all other tokens to
`),Bg=s("code"),a0=a("-inf"),i0=a(" so that they are sampled at their corresponding index."),c0=c(),pd=s("div"),h($a.$$.fragment),H_=c(),at=s("div"),h(xa.$$.fragment),l0=c(),Wg=s("p"),d0=a("Abstract base class for all logit processors that can be applied during generation."),p0=c(),Ms=s("div"),h(Ma.$$.fragment),m0=c(),Dg=s("p"),h0=a("TF method for processing logits."),Q_=c(),it=s("div"),h(Ea.$$.fragment),g0=c(),ge=s("p"),u0=a("This class can be used to create a list of "),md=s("a"),f0=a("TFLogitsProcessor"),_0=a(" to subsequently process a "),qg=s("code"),b0=a("scores"),v0=a(` input tensor.
This class inherits from list and adds a specific `),Pg=s("em"),Sg=s("strong"),y0=a("call"),T0=a(" method to apply each "),hd=s("a"),w0=a("TFLogitsProcessor"),k0=a(` to the
inputs.`),$0=c(),gd=s("div"),h(Fa.$$.fragment),Y_=c(),ct=s("div"),h(ja.$$.fragment),x0=c(),Vg=s("p"),M0=a("Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),E0=c(),Es=s("div"),h(La.$$.fragment),F0=c(),Zg=s("p"),j0=a("TF method for warping logits."),K_=c(),lt=s("div"),h(za.$$.fragment),L0=c(),ud=s("p"),fd=s("a"),z0=a("TFLogitsProcessor"),J0=a(" enforcing a min-length by setting EOS probability to 0."),I0=c(),_d=s("div"),h(Ja.$$.fragment),eb=c(),dt=s("div"),h(Ia.$$.fragment),U0=c(),bd=s("p"),vd=s("a"),B0=a("TFLogitsProcessor"),W0=a(" that enforces that specified sequences will never be sampled."),D0=c(),yd=s("div"),h(Ua.$$.fragment),tb=c(),pt=s("div"),h(Ba.$$.fragment),q0=c(),Fs=s("p"),Td=s("a"),P0=a("TFLogitsProcessor"),S0=a(` that enforces no repetition of n-grams. See
`),Wa=s("a"),V0=a("Fairseq"),Z0=a("."),G0=c(),wd=s("div"),h(Da.$$.fragment),ob=c(),mt=s("div"),h(qa.$$.fragment),C0=c(),kd=s("p"),$d=s("a"),X0=a("TFLogitsProcessor"),N0=a(" enforcing an exponential penalty on repeated sequences."),R0=c(),xd=s("div"),h(Pa.$$.fragment),sb=c(),ht=s("div"),h(Sa.$$.fragment),O0=c(),ke=s("p"),Md=s("a"),A0=a("TFSuppressTokensAtBeginLogitsProcessor"),H0=a(" suppresses a list of tokens as soon as the "),Gg=s("code"),Q0=a("generate"),Y0=a(` function starts
generating using `),Cg=s("code"),K0=a("begin_index"),e4=a(" tokens. This should ensure that the tokens defined by "),Xg=s("code"),t4=a("begin_suppress_tokens"),o4=a(` at not
sampled at the begining of the generation.`),s4=c(),Ed=s("div"),h(Va.$$.fragment),rb=c(),gt=s("div"),h(Za.$$.fragment),r4=c(),Ga=s("p"),n4=a("This processor can be used to suppress a list of tokens. The processor will set their log probs to "),Ng=s("code"),a4=a("-inf"),i4=a(` so that they
are not sampled.`),c4=c(),Fd=s("div"),h(Ca.$$.fragment),nb=c(),ut=s("div"),h(Xa.$$.fragment),l4=c(),jd=s("p"),Ld=s("a"),d4=a("TFLogitsWarper"),p4=a(" for temperature (exponential scaling output probability distribution)."),m4=c(),zd=s("div"),h(Na.$$.fragment),ab=c(),ft=s("div"),h(Ra.$$.fragment),h4=c(),Jd=s("p"),Id=s("a"),g4=a("TFLogitsWarper"),u4=a(" that performs top-k, i.e. restricting to the k highest probability elements."),f4=c(),Ud=s("div"),h(Oa.$$.fragment),ib=c(),_t=s("div"),h(Aa.$$.fragment),_4=c(),Bd=s("p"),Wd=s("a"),b4=a("TFLogitsWarper"),v4=a(" that performs top-p, i.e. restricting to top tokens summing to <= prob_cut_off."),y4=c(),Dd=s("div"),h(Ha.$$.fragment),cb=c(),Jo=s("h3"),js=s("a"),Rg=s("span"),h(Qa.$$.fragment),T4=c(),Og=s("span"),w4=a("FLAX"),lb=c(),bt=s("div"),h(Ya.$$.fragment),k4=c(),qd=s("p"),Pd=s("a"),$4=a("FlaxLogitsProcessor"),x4=a(" that enforces the specified token as the first generated token."),M4=c(),Sd=s("div"),h(Ka.$$.fragment),db=c(),vt=s("div"),h(ei.$$.fragment),E4=c(),Ls=s("p"),Vd=s("a"),F4=a("FlaxLogitsProcessor"),j4=a(" that enforces the specified token as the last generated token when "),Ag=s("code"),L4=a("max_length"),z4=a(" is reached."),J4=c(),Zd=s("div"),h(ti.$$.fragment),pb=c(),yt=s("div"),h(oi.$$.fragment),I4=c(),zs=s("p"),Gd=s("a"),U4=a("FlaxLogitsProcessor"),B4=a(` that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to `),Hg=s("code"),W4=a("-inf"),D4=a(" so that they are sampled at their corresponding index."),q4=c(),Cd=s("div"),h(si.$$.fragment),mb=c(),Tt=s("div"),h(ri.$$.fragment),P4=c(),Qg=s("p"),S4=a("Abstract base class for all logit processors that can be applied during generation."),V4=c(),Js=s("div"),h(ni.$$.fragment),Z4=c(),Yg=s("p"),G4=a("Flax method for processing logits."),hb=c(),wt=s("div"),h(ai.$$.fragment),C4=c(),Z=s("p"),X4=a("This class can be used to create a list of "),Xd=s("a"),N4=a("FlaxLogitsProcessor"),R4=a(" or "),Nd=s("a"),O4=a("FlaxLogitsWarper"),A4=a(` to subsequently process
a `),Kg=s("code"),H4=a("scores"),Q4=a(" input tensor. This class inherits from list and adds a specific "),eu=s("em"),tu=s("strong"),Y4=a("call"),K4=a(` method to apply each
`),Rd=s("a"),ex=a("FlaxLogitsProcessor"),tx=a(" or "),Od=s("a"),ox=a("FlaxLogitsWarper"),sx=a(" to the inputs."),rx=c(),Ad=s("div"),h(ii.$$.fragment),gb=c(),kt=s("div"),h(ci.$$.fragment),nx=c(),ou=s("p"),ax=a("Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),ix=c(),Is=s("div"),h(li.$$.fragment),cx=c(),su=s("p"),lx=a("Flax method for warping logits."),ub=c(),$t=s("div"),h(di.$$.fragment),dx=c(),Hd=s("p"),Qd=s("a"),px=a("FlaxLogitsProcessor"),mx=a(" enforcing a min-length by setting EOS probability to 0."),hx=c(),Yd=s("div"),h(pi.$$.fragment),fb=c(),xt=s("div"),h(mi.$$.fragment),gx=c(),$e=s("p"),Kd=s("a"),ux=a("FlaxLogitsProcessor"),fx=a(" supressing a list of tokens as soon as the "),ru=s("code"),_x=a("generate"),bx=a(` function starts generating using
`),nu=s("code"),vx=a("begin_index"),yx=a(" tokens. This should ensure that the tokens defined by "),au=s("code"),Tx=a("begin_suppress_tokens"),wx=a(` are not sampled at the
begining of the generation.`),kx=c(),ep=s("div"),h(hi.$$.fragment),_b=c(),Mt=s("div"),h(gi.$$.fragment),$x=c(),Us=s("p"),tp=s("a"),xx=a("FlaxLogitsProcessor"),Mx=a(` suppressing a list of tokens at each decoding step. The processor will set their log probs
to be `),iu=s("code"),Ex=a("-inf"),Fx=a(" so they are not sampled."),jx=c(),op=s("div"),h(ui.$$.fragment),bb=c(),Et=s("div"),h(fi.$$.fragment),Lx=c(),sp=s("p"),rp=s("a"),zx=a("FlaxLogitsWarper"),Jx=a(" for temperature (exponential scaling output probability distribution)."),Ix=c(),np=s("div"),h(_i.$$.fragment),vb=c(),Ft=s("div"),h(bi.$$.fragment),Ux=c(),ap=s("p"),ip=s("a"),Bx=a("FlaxLogitsWarper"),Wx=a(" that performs top-k, i.e. restricting to the k highest probability elements."),Dx=c(),cp=s("div"),h(vi.$$.fragment),yb=c(),jt=s("div"),h(yi.$$.fragment),qx=c(),lp=s("p"),dp=s("a"),Px=a("FlaxLogitsWarper"),Sx=a(" that performs top-p, i.e. restricting to top tokens summing to prob_cut_off <= prob_cut_off."),Vx=c(),pp=s("div"),h(Ti.$$.fragment),Tb=c(),Lt=s("div"),h(wi.$$.fragment),Zx=c(),ki=s("p"),Gx=a(`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to `),cu=s("code"),Cx=a("inf"),Xx=a(" so that they are sampled at their corresponding index."),Nx=c(),mp=s("div"),h($i.$$.fragment),wb=c(),Io=s("h2"),Bs=s("a"),lu=s("span"),h(xi.$$.fragment),Rx=c(),du=s("span"),Ox=a("StoppingCriteria"),kb=c(),Ws=s("p"),Ax=a("A "),hp=s("a"),Hx=a("StoppingCriteria"),Qx=a(" can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations."),$b=c(),zt=s("div"),h(Mi.$$.fragment),Yx=c(),pu=s("p"),Kx=a("Abstract base class for all stopping criteria that can be applied during generation."),eM=c(),gp=s("div"),h(Ei.$$.fragment),xb=c(),Uo=s("div"),h(Fi.$$.fragment),tM=c(),up=s("div"),h(ji.$$.fragment),Mb=c(),Jt=s("div"),h(Li.$$.fragment),oM=c(),zi=s("p"),sM=a("This class can be used to stop generation whenever the full generated number of tokens exceeds "),mu=s("code"),rM=a("max_length"),nM=a(`. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`),aM=c(),fp=s("div"),h(Ji.$$.fragment),Eb=c(),It=s("div"),h(Ii.$$.fragment),iM=c(),Ui=s("p"),cM=a(`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
`),hu=s("code"),lM=a("initial_time"),dM=a("."),pM=c(),_p=s("div"),h(Bi.$$.fragment),Fb=c(),Bo=s("h2"),Ds=s("a"),gu=s("span"),h(Wi.$$.fragment),mM=c(),uu=s("span"),hM=a("Constraints"),jb=c(),qs=s("p"),gM=a("A "),bp=s("a"),uM=a("Constraint"),fM=a(" can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations."),Lb=c(),L=s("div"),h(Di.$$.fragment),_M=c(),fu=s("p"),bM=a(`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`),vM=c(),_u=s("p"),yM=a("All classes that inherit Constraint must follow the requirement that"),TM=c(),h(Ps.$$.fragment),wM=c(),bu=s("p"),kM=a("will always terminate (halt)."),$M=c(),Ss=s("div"),h(qi.$$.fragment),xM=c(),vu=s("p"),MM=a("When called, returns the token that would take this constraint one step closer to being fulfilled."),EM=c(),Vs=s("div"),h(Pi.$$.fragment),FM=c(),yu=s("p"),jM=a("Creates a new instance of this constraint."),LM=c(),Zs=s("div"),h(Si.$$.fragment),zM=c(),Tu=s("p"),JM=a("Reads in a token and returns whether it creates progress."),IM=c(),Gs=s("div"),h(Vi.$$.fragment),UM=c(),Zi=s("p"),BM=a("Returns the number of remaining steps of "),wu=s("code"),WM=a("advance()"),DM=a(" in order to complete this constraint."),qM=c(),Cs=s("div"),h(Gi.$$.fragment),PM=c(),ku=s("p"),SM=a(`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`),VM=c(),Xs=s("div"),h(Ci.$$.fragment),ZM=c(),$u=s("p"),GM=a("Tests whether this constraint has been properly defined."),CM=c(),Vt=s("div"),h(Xi.$$.fragment),XM=c(),Ni=s("p"),NM=a(`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes `),xu=s("code"),RM=a("does_advance(self, token_id: int)"),OM=a("."),AM=c(),Mu=s("p"),HM=a(`This isn\u2019t to test whether a certain token will advance the progress; it\u2019s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`),zb=c(),Wo=s("div"),h(Ri.$$.fragment),QM=c(),vp=s("p"),yp=s("a"),YM=a("Constraint"),KM=a(" enforcing that an ordered sequence of tokens is included in the output."),Jb=c(),Do=s("div"),h(Oi.$$.fragment),e3=c(),Ai=s("p"),t3=a("A special "),Tp=s("a"),o3=a("Constraint"),s3=a(" that is fulfilled by fulfilling just one of several constraints."),Ib=c(),ue=s("div"),h(Hi.$$.fragment),r3=c(),Eu=s("p"),n3=a("A class for beam scorers to track its progress through a list of constraints."),a3=c(),X=s("div"),h(Qi.$$.fragment),i3=c(),Fu=s("p"),c3=a(`The list of tokens to generate such that we can make progress.
By \u201Clist\u201D we don\u2019t mean the list of token that will fully fulfill a constraint.`),l3=c(),qo=s("p"),d3=a("Given constraints "),ju=s("code"),p3=a("c_i = {t_ij | j == # of tokens}"),m3=a(`, If we\u2019re not in the middle of progressing through a
specific constraint `),Lu=s("code"),h3=a("c_i"),g3=a(", we return:"),u3=c(),zu=s("p"),Ju=s("code"),f3=a("[t_k1 for k in indices of unfulfilled constraints]"),_3=c(),Ut=s("p"),b3=a(`If we are in the middle of a constraint, then we return:
`),Iu=s("code"),v3=a("[t_ij]"),y3=a(", where "),Uu=s("code"),T3=a("i"),w3=a(" is the index of the inprogress constraint, "),Bu=s("code"),k3=a("j"),$3=a(" is the next step for the constraint."),x3=c(),Wu=s("p"),M3=a(`Though we don\u2019t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that\u2019s the only one we\u2019ll return.`),E3=c(),Ns=s("div"),h(Yi.$$.fragment),F3=c(),Du=s("p"),j3=a("token_ids: the tokens generated thus far to reset the state of the progress through constraints."),Ub=c(),Po=s("h2"),Rs=s("a"),qu=s("span"),h(Ki.$$.fragment),L3=c(),Pu=s("span"),z3=a("BeamSearch"),Bb=c(),fe=s("div"),h(ec.$$.fragment),J3=c(),So=s("p"),I3=a("Abstract base class for all beam scorers that are used for "),wp=s("a"),U3=a("beam_search()"),B3=a(` and
`),kp=s("a"),W3=a("beam_sample()"),D3=a("."),q3=c(),$p=s("div"),h(tc.$$.fragment),P3=c(),xp=s("div"),h(oc.$$.fragment),Wb=c(),G=s("div"),h(sc.$$.fragment),S3=c(),Mp=s("p"),Ep=s("a"),V3=a("BeamScorer"),Z3=a(" implementing standard beam search decoding."),G3=c(),rc=s("p"),C3=a("Adapted in part from "),nc=s("a"),X3=a(`Facebook\u2019s XLM beam search
code`),N3=a("."),R3=c(),Fp=s("p"),O3=a("Reference for the diverse beam search algorithm and implementation "),ac=s("a"),A3=a(`Ashwin Kalyan\u2019s DBS
implementation`),H3=c(),jp=s("div"),h(ic.$$.fragment),Q3=c(),Lp=s("div"),h(cc.$$.fragment),Db=c(),_e=s("div"),h(lc.$$.fragment),Y3=c(),zp=s("p"),Jp=s("a"),K3=a("BeamScorer"),eE=a(" implementing constrained beam search decoding."),tE=c(),Ip=s("div"),h(dc.$$.fragment),oE=c(),Up=s("div"),h(pc.$$.fragment),qb=c(),Vo=s("h2"),Os=s("a"),Su=s("span"),h(mc.$$.fragment),sE=c(),Vu=s("span"),rE=a("Utilities"),Pb=c(),Bt=s("div"),h(hc.$$.fragment),nE=c(),Zu=s("p"),aE=a("Filter a distribution of logits using top-k and/or nucleus (top-p) filtering"),iE=c(),Bp=s("p"),cE=a("From: "),gc=s("a"),lE=a("https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),Sb=c(),Wt=s("div"),h(uc.$$.fragment),dE=c(),Gu=s("p"),pE=a("Filter a distribution of logits using top-k and/or nucleus (top-p) filtering"),mE=c(),Wp=s("p"),hE=a("From: "),fc=s("a"),gE=a("https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),Vb=c(),Zo=s("h2"),As=s("a"),Cu=s("span"),h(_c.$$.fragment),uE=c(),Xu=s("span"),fE=a("Streamers"),Zb=c(),D=s("div"),h(bc.$$.fragment),_E=c(),Nu=s("p"),bE=a("Simple text streamer that prints the token(s) to stdout as soon as entire words are formed."),vE=c(),h(Hs.$$.fragment),yE=c(),h(Qs.$$.fragment),TE=c(),Ys=s("div"),h(vc.$$.fragment),wE=c(),Ru=s("p"),kE=a("Flushes any remaining cache and prints a newline to stdout."),$E=c(),Ks=s("div"),h(yc.$$.fragment),xE=c(),Ou=s("p"),ME=a("Prints the new text to stdout. If the stream is ending, also prints a newline."),EE=c(),er=s("div"),h(Tc.$$.fragment),FE=c(),Au=s("p"),jE=a("Receives tokens, decodes them, and prints them to stdout as soon as they form entire words."),Gb=c(),Y=s("div"),h(wc.$$.fragment),LE=c(),Hu=s("p"),zE=a(`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`),JE=c(),h(tr.$$.fragment),IE=c(),h(or.$$.fragment),UE=c(),sr=s("div"),h(kc.$$.fragment),BE=c(),Qu=s("p"),WE=a("Put the new text in the queue. If the stream is ending, also put a stop signal in the queue."),this.h()},l(e){const p=_I('[data-svelte="svelte-1phssyn"]',document.head);T=r(p,"META",{name:!0,content:!0}),p.forEach(o),M=l(e),k=r(e,"H1",{class:!0});var $c=n(k);w=r($c,"A",{id:!0,class:!0,href:!0});var Yu=n(w);x=r(Yu,"SPAN",{});var Ku=n(x);g(v.$$.fragment,Ku),Ku.forEach(o),Yu.forEach(o),$=l($c),S=r($c,"SPAN",{});var ef=n(S);J=i(ef,"Utilities for Generation"),ef.forEach(o),$c.forEach(o),I=l(e),j=r(e,"P",{});var U=n(j);q=i(U,"This page lists all the utility functions used by "),K=r(U,"A",{href:!0});var tf=n(K);je=i(tf,"generate()"),tf.forEach(o),W=i(U,`,
`),ee=r(U,"A",{href:!0});var of=n(ee);Le=i(of,"greedy_search()"),of.forEach(o),N=i(U,`,
`),F=r(U,"A",{href:!0});var sf=n(F);Yt=i(sf,"contrastive_search()"),sf.forEach(o),Kt=i(U,`,
`),be=r(U,"A",{href:!0});var rf=n(be);eo=i(rf,"sample()"),rf.forEach(o),to=i(U,`,
`),jc=r(U,"A",{href:!0});var nf=n(jc);iy=i(nf,"beam_search()"),nf.forEach(o),cy=i(U,`,
`),Lc=r(U,"A",{href:!0});var af=n(Lc);ly=i(af,"beam_sample()"),af.forEach(o),dy=i(U,`,
`),zc=r(U,"A",{href:!0});var cf=n(zc);py=i(cf,"group_beam_search()"),cf.forEach(o),my=i(U,`, and
`),Jc=r(U,"A",{href:!0});var lf=n(Jc);hy=i(lf,"constrained_beam_search()"),lf.forEach(o),gy=i(U,"."),U.forEach(o),Mf=l(e),Ic=r(e,"P",{});var df=n(Ic);uy=i(df,"Most of those are only useful if you are studying the code of the generate methods in the library."),df.forEach(o),Ef=l(e),oo=r(e,"H2",{class:!0});var xc=n(oo);Ro=r(xc,"A",{id:!0,class:!0,href:!0});var pf=n(Ro);Om=r(pf,"SPAN",{});var mf=n(Om);g(ur.$$.fragment,mf),mf.forEach(o),pf.forEach(o),fy=l(xc),Am=r(xc,"SPAN",{});var hf=n(Am);_y=i(hf,"Generate Outputs"),hf.forEach(o),xc.forEach(o),Ff=l(e),ve=r(e,"P",{});var rr=n(ve);by=i(rr,"The output of "),Uc=r(rr,"A",{href:!0});var gF=n(Uc);vy=i(gF,"generate()"),gF.forEach(o),yy=i(rr,` is an instance of a subclass of
`),Bc=r(rr,"A",{href:!0});var uF=n(Bc);Ty=i(uF,"ModelOutput"),uF.forEach(o),wy=i(rr,`. This output is a data structure containing all the information returned
by `),Wc=r(rr,"A",{href:!0});var fF=n(Wc);ky=i(fF,"generate()"),fF.forEach(o),$y=i(rr,", but that can also be used as tuple or dictionary."),rr.forEach(o),jf=l(e),Dc=r(e,"P",{});var _F=n(Dc);xy=i(_F,"Here\u2019s an example:"),_F.forEach(o),Lf=l(e),g(fr.$$.fragment,e),zf=l(e),Dt=r(e,"P",{});var Dp=n(Dt);My=i(Dp,"The "),Hm=r(Dp,"CODE",{});var bF=n(Hm);Ey=i(bF,"generation_output"),bF.forEach(o),Fy=i(Dp," object is a "),qc=r(Dp,"A",{href:!0});var vF=n(qc);jy=i(vF,"GreedySearchDecoderOnlyOutput"),vF.forEach(o),Ly=i(Dp,`, as we can
see in the documentation of that class below, it means it has the following attributes:`),Dp.forEach(o),Jf=l(e),ye=r(e,"UL",{});var nr=n(ye);Pc=r(nr,"LI",{});var DE=n(Pc);Qm=r(DE,"CODE",{});var yF=n(Qm);zy=i(yF,"sequences"),yF.forEach(o),Jy=i(DE,": the generated sequences of tokens"),DE.forEach(o),Iy=l(nr),Sc=r(nr,"LI",{});var qE=n(Sc);Ym=r(qE,"CODE",{});var TF=n(Ym);Uy=i(TF,"scores"),TF.forEach(o),By=i(qE," (optional): the prediction scores of the language modelling head, for each generation step"),qE.forEach(o),Wy=l(nr),Vc=r(nr,"LI",{});var PE=n(Vc);Km=r(PE,"CODE",{});var wF=n(Km);Dy=i(wF,"hidden_states"),wF.forEach(o),qy=i(PE," (optional): the hidden states of the model, for each generation step"),PE.forEach(o),Py=l(nr),Zc=r(nr,"LI",{});var SE=n(Zc);eh=r(SE,"CODE",{});var kF=n(eh);Sy=i(kF,"attentions"),kF.forEach(o),Vy=i(SE," (optional): the attention weights of the model, for each generation step"),SE.forEach(o),nr.forEach(o),If=l(e),P=r(e,"P",{});var re=n(P);Zy=i(re,"Here we have the "),th=r(re,"CODE",{});var $F=n(th);Gy=i($F,"scores"),$F.forEach(o),Cy=i(re," since we passed along "),oh=r(re,"CODE",{});var xF=n(oh);Xy=i(xF,"output_scores=True"),xF.forEach(o),Ny=i(re,", but we don\u2019t have "),sh=r(re,"CODE",{});var MF=n(sh);Ry=i(MF,"hidden_states"),MF.forEach(o),Oy=i(re,` and
`),rh=r(re,"CODE",{});var EF=n(rh);Ay=i(EF,"attentions"),EF.forEach(o),Hy=i(re," because we didn\u2019t pass "),nh=r(re,"CODE",{});var FF=n(nh);Qy=i(FF,"output_hidden_states=True"),FF.forEach(o),Yy=i(re," or "),ah=r(re,"CODE",{});var jF=n(ah);Ky=i(jF,"output_attentions=True"),jF.forEach(o),eT=i(re,"."),re.forEach(o),Uf=l(e),te=r(e,"P",{});var Zt=n(te);tT=i(Zt,`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get `),ih=r(Zt,"CODE",{});var LF=n(ih);oT=i(LF,"None"),LF.forEach(o),sT=i(Zt,". Here for instance "),ch=r(Zt,"CODE",{});var zF=n(ch);rT=i(zF,"generation_output.scores"),zF.forEach(o),nT=i(Zt,` are all the generated prediction scores of the
language modeling head, and `),lh=r(Zt,"CODE",{});var JF=n(lh);aT=i(JF,"generation_output.attentions"),JF.forEach(o),iT=i(Zt," is "),dh=r(Zt,"CODE",{});var IF=n(dh);cT=i(IF,"None"),IF.forEach(o),lT=i(Zt,"."),Zt.forEach(o),Bf=l(e),oe=r(e,"P",{});var Gt=n(oe);dT=i(Gt,"When using our "),ph=r(Gt,"CODE",{});var UF=n(ph);pT=i(UF,"generation_output"),UF.forEach(o),mT=i(Gt," object as a tuple, it only keeps the attributes that don\u2019t have "),mh=r(Gt,"CODE",{});var BF=n(mh);hT=i(BF,"None"),BF.forEach(o),gT=i(Gt,` values.
Here, for instance, it has two elements, `),hh=r(Gt,"CODE",{});var WF=n(hh);uT=i(WF,"loss"),WF.forEach(o),fT=i(Gt," then "),gh=r(Gt,"CODE",{});var DF=n(gh);_T=i(DF,"logits"),DF.forEach(o),bT=i(Gt,", so"),Gt.forEach(o),Wf=l(e),g(_r.$$.fragment,e),Df=l(e),Oo=r(e,"P",{});var Xb=n(Oo);vT=i(Xb,"will return the tuple "),uh=r(Xb,"CODE",{});var qF=n(uh);yT=i(qF,"(generation_output.sequences, generation_output.scores)"),qF.forEach(o),TT=i(Xb," for instance."),Xb.forEach(o),qf=l(e),se=r(e,"P",{});var Ct=n(se);wT=i(Ct,"When using our "),fh=r(Ct,"CODE",{});var PF=n(fh);kT=i(PF,"generation_output"),PF.forEach(o),$T=i(Ct," object as a dictionary, it only keeps the attributes that don\u2019t have "),_h=r(Ct,"CODE",{});var SF=n(_h);xT=i(SF,"None"),SF.forEach(o),MT=i(Ct,`
values. Here, for instance, it has two keys that are `),bh=r(Ct,"CODE",{});var VF=n(bh);ET=i(VF,"sequences"),VF.forEach(o),FT=i(Ct," and "),vh=r(Ct,"CODE",{});var ZF=n(vh);jT=i(ZF,"scores"),ZF.forEach(o),LT=i(Ct,"."),Ct.forEach(o),Pf=l(e),Gc=r(e,"P",{});var GF=n(Gc);zT=i(GF,"We document here all output types."),GF.forEach(o),Sf=l(e),so=r(e,"H3",{class:!0});var Nb=n(so);Ao=r(Nb,"A",{id:!0,class:!0,href:!0});var CF=n(Ao);yh=r(CF,"SPAN",{});var XF=n(yh);g(br.$$.fragment,XF),XF.forEach(o),CF.forEach(o),JT=l(Nb),Th=r(Nb,"SPAN",{});var NF=n(Th);IT=i(NF,"PyTorch"),NF.forEach(o),Nb.forEach(o),Vf=l(e),ro=r(e,"DIV",{class:!0});var Rb=n(ro);g(vr.$$.fragment,Rb),UT=l(Rb),wh=r(Rb,"P",{});var RF=n(wh);BT=i(RF,`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),RF.forEach(o),Rb.forEach(o),Zf=l(e),no=r(e,"DIV",{class:!0});var Ob=n(no);g(yr.$$.fragment,Ob),WT=l(Ob),kh=r(Ob,"P",{});var OF=n(kh);DT=i(OF,"Base class for outputs of decoder-only generation models using greedy search."),OF.forEach(o),Ob.forEach(o),Gf=l(e),ao=r(e,"DIV",{class:!0});var Ab=n(ao);g(Tr.$$.fragment,Ab),qT=l(Ab),$h=r(Ab,"P",{});var AF=n($h);PT=i(AF,`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),AF.forEach(o),Ab.forEach(o),Cf=l(e),io=r(e,"DIV",{class:!0});var Hb=n(io);g(wr.$$.fragment,Hb),ST=l(Hb),xh=r(Hb,"P",{});var HF=n(xh);VT=i(HF,"Base class for outputs of decoder-only generation models using sampling."),HF.forEach(o),Hb.forEach(o),Xf=l(e),co=r(e,"DIV",{class:!0});var Qb=n(co);g(kr.$$.fragment,Qb),ZT=l(Qb),Mh=r(Qb,"P",{});var QF=n(Mh);GT=i(QF,`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),QF.forEach(o),Qb.forEach(o),Nf=l(e),lo=r(e,"DIV",{class:!0});var Yb=n(lo);g($r.$$.fragment,Yb),CT=l(Yb),Eh=r(Yb,"P",{});var YF=n(Eh);XT=i(YF,"Base class for outputs of decoder-only generation models using beam search."),YF.forEach(o),Yb.forEach(o),Rf=l(e),po=r(e,"DIV",{class:!0});var Kb=n(po);g(xr.$$.fragment,Kb),NT=l(Kb),Fh=r(Kb,"P",{});var KF=n(Fh);RT=i(KF,`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),KF.forEach(o),Kb.forEach(o),Of=l(e),mo=r(e,"DIV",{class:!0});var ev=n(mo);g(Mr.$$.fragment,ev),OT=l(ev),jh=r(ev,"P",{});var e5=n(jh);AT=i(e5,"Base class for outputs of decoder-only generation models using beam sample."),e5.forEach(o),ev.forEach(o),Af=l(e),ho=r(e,"DIV",{class:!0});var tv=n(ho);g(Er.$$.fragment,tv),HT=l(tv),Lh=r(tv,"P",{});var t5=n(Lh);QT=i(t5,"Base class for outputs of decoder-only generation models using contrastive search."),t5.forEach(o),tv.forEach(o),Hf=l(e),go=r(e,"DIV",{class:!0});var ov=n(go);g(Fr.$$.fragment,ov),YT=l(ov),zh=r(ov,"P",{});var o5=n(zh);KT=i(o5,"Base class for outputs of decoder-only generation models using contrastive search."),o5.forEach(o),ov.forEach(o),Qf=l(e),uo=r(e,"H3",{class:!0});var sv=n(uo);Ho=r(sv,"A",{id:!0,class:!0,href:!0});var s5=n(Ho);Jh=r(s5,"SPAN",{});var r5=n(Jh);g(jr.$$.fragment,r5),r5.forEach(o),s5.forEach(o),e1=l(sv),Ih=r(sv,"SPAN",{});var n5=n(Ih);t1=i(n5,"TensorFlow"),n5.forEach(o),sv.forEach(o),Yf=l(e),fo=r(e,"DIV",{class:!0});var rv=n(fo);g(Lr.$$.fragment,rv),o1=l(rv),Uh=r(rv,"P",{});var a5=n(Uh);s1=i(a5,`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),a5.forEach(o),rv.forEach(o),Kf=l(e),_o=r(e,"DIV",{class:!0});var nv=n(_o);g(zr.$$.fragment,nv),r1=l(nv),Bh=r(nv,"P",{});var i5=n(Bh);n1=i(i5,"Base class for outputs of decoder-only generation models using greedy search."),i5.forEach(o),nv.forEach(o),e_=l(e),bo=r(e,"DIV",{class:!0});var av=n(bo);g(Jr.$$.fragment,av),a1=l(av),Wh=r(av,"P",{});var c5=n(Wh);i1=i(c5,`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),c5.forEach(o),av.forEach(o),t_=l(e),vo=r(e,"DIV",{class:!0});var iv=n(vo);g(Ir.$$.fragment,iv),c1=l(iv),Dh=r(iv,"P",{});var l5=n(Dh);l1=i(l5,"Base class for outputs of decoder-only generation models using sampling."),l5.forEach(o),iv.forEach(o),o_=l(e),yo=r(e,"DIV",{class:!0});var cv=n(yo);g(Ur.$$.fragment,cv),d1=l(cv),qh=r(cv,"P",{});var d5=n(qh);p1=i(d5,`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),d5.forEach(o),cv.forEach(o),s_=l(e),To=r(e,"DIV",{class:!0});var lv=n(To);g(Br.$$.fragment,lv),m1=l(lv),Ph=r(lv,"P",{});var p5=n(Ph);h1=i(p5,"Base class for outputs of decoder-only generation models using beam search."),p5.forEach(o),lv.forEach(o),r_=l(e),wo=r(e,"DIV",{class:!0});var dv=n(wo);g(Wr.$$.fragment,dv),g1=l(dv),Sh=r(dv,"P",{});var m5=n(Sh);u1=i(m5,`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),m5.forEach(o),dv.forEach(o),n_=l(e),ko=r(e,"DIV",{class:!0});var pv=n(ko);g(Dr.$$.fragment,pv),f1=l(pv),Vh=r(pv,"P",{});var h5=n(Vh);_1=i(h5,"Base class for outputs of decoder-only generation models using beam sample."),h5.forEach(o),pv.forEach(o),a_=l(e),$o=r(e,"DIV",{class:!0});var mv=n($o);g(qr.$$.fragment,mv),b1=l(mv),Zh=r(mv,"P",{});var g5=n(Zh);v1=i(g5,`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`),g5.forEach(o),mv.forEach(o),i_=l(e),xo=r(e,"DIV",{class:!0});var hv=n(xo);g(Pr.$$.fragment,hv),y1=l(hv),Gh=r(hv,"P",{});var u5=n(Gh);T1=i(u5,"Base class for outputs of decoder-only generation models using contrastive search."),u5.forEach(o),hv.forEach(o),c_=l(e),Mo=r(e,"H3",{class:!0});var gv=n(Mo);Qo=r(gv,"A",{id:!0,class:!0,href:!0});var f5=n(Qo);Ch=r(f5,"SPAN",{});var _5=n(Ch);g(Sr.$$.fragment,_5),_5.forEach(o),f5.forEach(o),w1=l(gv),Xh=r(gv,"SPAN",{});var b5=n(Xh);k1=i(b5,"FLAX"),b5.forEach(o),gv.forEach(o),l_=l(e),ze=r(e,"DIV",{class:!0});var qp=n(ze);g(Vr.$$.fragment,qp),$1=l(qp),Nh=r(qp,"P",{});var v5=n(Nh);x1=i(v5,"Flax Base class for outputs of decoder-only generation models using sampling."),v5.forEach(o),M1=l(qp),Yo=r(qp,"DIV",{class:!0});var uv=n(Yo);g(Zr.$$.fragment,uv),E1=l(uv),Rh=r(uv,"P",{});var y5=n(Rh);F1=i(y5,"\u201CReturns a new object replacing the specified fields with new values."),y5.forEach(o),uv.forEach(o),qp.forEach(o),d_=l(e),Je=r(e,"DIV",{class:!0});var Pp=n(Je);g(Gr.$$.fragment,Pp),j1=l(Pp),Oh=r(Pp,"P",{});var T5=n(Oh);L1=i(T5,"Flax Base class for outputs of decoder-only generation models using greedy search."),T5.forEach(o),z1=l(Pp),Ko=r(Pp,"DIV",{class:!0});var fv=n(Ko);g(Cr.$$.fragment,fv),J1=l(fv),Ah=r(fv,"P",{});var w5=n(Ah);I1=i(w5,"\u201CReturns a new object replacing the specified fields with new values."),w5.forEach(o),fv.forEach(o),Pp.forEach(o),p_=l(e),Ie=r(e,"DIV",{class:!0});var Sp=n(Ie);g(Xr.$$.fragment,Sp),U1=l(Sp),Hh=r(Sp,"P",{});var k5=n(Hh);B1=i(k5,"Flax Base class for outputs of decoder-only generation models using greedy search."),k5.forEach(o),W1=l(Sp),es=r(Sp,"DIV",{class:!0});var _v=n(es);g(Nr.$$.fragment,_v),D1=l(_v),Qh=r(_v,"P",{});var $5=n(Qh);q1=i($5,"\u201CReturns a new object replacing the specified fields with new values."),$5.forEach(o),_v.forEach(o),Sp.forEach(o),m_=l(e),Eo=r(e,"H2",{class:!0});var bv=n(Eo);ts=r(bv,"A",{id:!0,class:!0,href:!0});var x5=n(ts);Yh=r(x5,"SPAN",{});var M5=n(Yh);g(Rr.$$.fragment,M5),M5.forEach(o),x5.forEach(o),P1=l(bv),Kh=r(bv,"SPAN",{});var E5=n(Kh);S1=i(E5,"LogitsProcessor"),E5.forEach(o),bv.forEach(o),h_=l(e),os=r(e,"P",{});var vv=n(os);V1=i(vv,"A "),Cc=r(vv,"A",{href:!0});var F5=n(Cc);Z1=i(F5,"LogitsProcessor"),F5.forEach(o),G1=i(vv,` can be used to modify the prediction scores of a language model head for
generation.`),vv.forEach(o),g_=l(e),Fo=r(e,"H3",{class:!0});var yv=n(Fo);ss=r(yv,"A",{id:!0,class:!0,href:!0});var j5=n(ss);eg=r(j5,"SPAN",{});var L5=n(eg);g(Or.$$.fragment,L5),L5.forEach(o),j5.forEach(o),C1=l(yv),tg=r(yv,"SPAN",{});var z5=n(tg);X1=i(z5,"PyTorch"),z5.forEach(o),yv.forEach(o),u_=l(e),Ue=r(e,"DIV",{class:!0});var Vp=n(Ue);g(Ar.$$.fragment,Vp),N1=l(Vp),rs=r(Vp,"P",{});var gf=n(rs);Xc=r(gf,"A",{href:!0});var J5=n(Xc);R1=i(J5,"LogitsProcessor"),J5.forEach(o),O1=i(gf," enforcing alternated generation between the two codebooks of "),og=r(gf,"CODE",{});var I5=n(og);A1=i(I5,"Bark"),I5.forEach(o),H1=i(gf,"\u2019s fine submodel."),gf.forEach(o),Q1=l(Vp),Nc=r(Vp,"DIV",{class:!0});var U5=n(Nc);g(Hr.$$.fragment,U5),U5.forEach(o),Vp.forEach(o),f_=l(e),Be=r(e,"DIV",{class:!0});var Zp=n(Be);g(Qr.$$.fragment,Zp),Y1=l(Zp),Yr=r(Zp,"P",{});var Tv=n(Yr);K1=i(Tv,`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or \u2018null\u2019 prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the `),sg=r(Tv,"CODE",{});var B5=n(sg);e2=i(B5,"guidance_scale"),B5.forEach(o),t2=i(Tv,"."),Tv.forEach(o),o2=l(Zp),Rc=r(Zp,"DIV",{class:!0});var W5=n(Rc);g(Kr.$$.fragment,W5),W5.forEach(o),Zp.forEach(o),__=l(e),We=r(e,"DIV",{class:!0});var Gp=n(We);g(en.$$.fragment,Gp),s2=l(Gp),ns=r(Gp,"P",{});var uf=n(ns);Oc=r(uf,"A",{href:!0});var D5=n(Oc);r2=i(D5,"LogitsProcessor"),D5.forEach(o),n2=i(uf,` that enforces no repetition of encoder input ids n-grams for the decoder ids. See
`),tn=r(uf,"A",{href:!0,rel:!0});var q5=n(tn);a2=i(q5,"ParlAI"),q5.forEach(o),i2=i(uf,"."),uf.forEach(o),c2=l(Gp),Ac=r(Gp,"DIV",{class:!0});var P5=n(Ac);g(on.$$.fragment,P5),P5.forEach(o),Gp.forEach(o),b_=l(e),De=r(e,"DIV",{class:!0});var Cp=n(De);g(sn.$$.fragment,Cp),l2=l(Cp),Hc=r(Cp,"P",{});var VE=n(Hc);Qc=r(VE,"A",{href:!0});var S5=n(Qc);d2=i(S5,"LogitsProcessor"),S5.forEach(o),p2=i(VE," enforcing an exponential penalty on tokens that are not in the original input."),VE.forEach(o),m2=l(Cp),Yc=r(Cp,"DIV",{class:!0});var V5=n(Yc);g(rn.$$.fragment,V5),V5.forEach(o),Cp.forEach(o),v_=l(e),qe=r(e,"DIV",{class:!0});var Xp=n(qe);g(nn.$$.fragment,Xp),h2=l(Xp),qt=r(Xp,"P",{});var Mc=n(qt);Kc=r(Mc,"A",{href:!0});var Z5=n(Kc);g2=i(Z5,"LogitsWarper"),Z5.forEach(o),u2=i(Mc," that performs epsilon-sampling, i.e. restricting to tokens with "),rg=r(Mc,"CODE",{});var G5=n(rg);f2=i(G5,"prob >= epsilon"),G5.forEach(o),_2=i(Mc,`. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See `),an=r(Mc,"A",{href:!0,rel:!0});var C5=n(an);b2=i(C5,`Truncation Sampling as Language Model
Desmoothing`),C5.forEach(o),v2=i(Mc," for more information."),Mc.forEach(o),y2=l(Xp),el=r(Xp,"DIV",{class:!0});var X5=n(el);g(cn.$$.fragment,X5),X5.forEach(o),Xp.forEach(o),y_=l(e),de=r(e,"DIV",{class:!0});var ar=n(de);g(ln.$$.fragment,ar),T2=l(ar),B=r(ar,"P",{});var C=n(B);tl=r(C,"A",{href:!0});var N5=n(tl);w2=i(N5,"LogitsWarper"),N5.forEach(o),k2=i(C,` that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, `),ng=r(C,"CODE",{});var R5=n(ng);$2=i(R5,"eta"),R5.forEach(o),x2=i(C,", which is calculated based on a combination of the hyperparameter "),ag=r(C,"CODE",{});var O5=n(ag);M2=i(O5,"epsilon"),O5.forEach(o),E2=i(C,` and the entropy of
the token probabilities, i.e. `),ig=r(C,"CODE",{});var A5=n(ig);F2=i(A5,"eta := min(epsilon, sqrt(epsilon, e^-entropy(probabilities)))"),A5.forEach(o),j2=i(C,`. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See `),dn=r(C,"A",{href:!0,rel:!0});var H5=n(dn);L2=i(H5,`Truncation
Sampling as Language Model Desmoothing`),H5.forEach(o),z2=i(C," for more information. Note: "),cg=r(C,"CODE",{});var Q5=n(cg);J2=i(Q5,"do_sample"),Q5.forEach(o),I2=i(C,`
must be set to `),lg=r(C,"CODE",{});var Y5=n(lg);U2=i(Y5,"True"),Y5.forEach(o),B2=i(C," for this "),dg=r(C,"CODE",{});var K5=n(dg);W2=i(K5,"LogitsWarper"),K5.forEach(o),D2=i(C," to work."),C.forEach(o),q2=l(ar),g(as.$$.fragment,ar),P2=l(ar),ol=r(ar,"DIV",{class:!0});var ej=n(ol);g(pn.$$.fragment,ej),ej.forEach(o),ar.forEach(o),T_=l(e),Pe=r(e,"DIV",{class:!0});var Np=n(Pe);g(mn.$$.fragment,Np),S2=l(Np),sl=r(Np,"P",{});var ZE=n(sl);rl=r(ZE,"A",{href:!0});var tj=n(rl);V2=i(tj,"LogitsProcessor"),tj.forEach(o),Z2=i(ZE,` that exponentially increases the score of the eos_token_id after regulation_start has been
reached.`),ZE.forEach(o),G2=l(Np),nl=r(Np,"DIV",{class:!0});var oj=n(nl);g(hn.$$.fragment,oj),oj.forEach(o),Np.forEach(o),w_=l(e),Se=r(e,"DIV",{class:!0});var Rp=n(Se);g(gn.$$.fragment,Rp),C2=l(Rp),al=r(Rp,"P",{});var GE=n(al);il=r(GE,"A",{href:!0});var sj=n(il);X2=i(sj,"LogitsProcessor"),sj.forEach(o),N2=i(GE," that enforces the specified token as the first generated token."),GE.forEach(o),R2=l(Rp),cl=r(Rp,"DIV",{class:!0});var rj=n(cl);g(un.$$.fragment,rj),rj.forEach(o),Rp.forEach(o),k_=l(e),Ve=r(e,"DIV",{class:!0});var Op=n(Ve);g(fn.$$.fragment,Op),O2=l(Op),is=r(Op,"P",{});var ff=n(is);ll=r(ff,"A",{href:!0});var nj=n(ll);A2=i(nj,"LogitsProcessor"),nj.forEach(o),H2=i(ff," that enforces the specified token as the last generated token when "),pg=r(ff,"CODE",{});var aj=n(pg);Q2=i(aj,"max_length"),aj.forEach(o),Y2=i(ff," is reached."),ff.forEach(o),K2=l(Op),dl=r(Op,"DIV",{class:!0});var ij=n(dl);g(_n.$$.fragment,ij),ij.forEach(o),Op.forEach(o),$_=l(e),Ze=r(e,"DIV",{class:!0});var Ap=n(Ze);g(bn.$$.fragment,Ap),ew=l(Ap),vn=r(Ap,"P",{});var wv=n(vn);tw=i(wv,`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to `),mg=r(wv,"CODE",{});var cj=n(mg);ow=i(cj,"inf"),cj.forEach(o),sw=i(wv,` so that they are
sampled at their corresponding index.`),wv.forEach(o),rw=l(Ap),pl=r(Ap,"DIV",{class:!0});var lj=n(pl);g(yn.$$.fragment,lj),lj.forEach(o),Ap.forEach(o),x_=l(e),Ge=r(e,"DIV",{class:!0});var Hp=n(Ge);g(Tn.$$.fragment,Hp),nw=l(Hp),Pt=r(Hp,"P",{});var Ec=n(Pt);ml=r(Ec,"A",{href:!0});var dj=n(ml);aw=i(dj,"LogitsProcessor"),dj.forEach(o),iw=i(Ec,` that enforces diverse beam search. Note that this logits processor is only effective for
`),hl=r(Ec,"A",{href:!0});var pj=n(hl);cw=i(pj,"PreTrainedModel.group_beam_search()"),pj.forEach(o),lw=i(Ec,". See "),wn=r(Ec,"A",{href:!0,rel:!0});var mj=n(wn);dw=i(mj,`Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence
Models`),mj.forEach(o),pw=i(Ec," for more details."),Ec.forEach(o),mw=l(Hp),gl=r(Hp,"DIV",{class:!0});var hj=n(gl);g(kn.$$.fragment,hj),hj.forEach(o),Hp.forEach(o),M_=l(e),Ce=r(e,"DIV",{class:!0});var Qp=n(Ce);g($n.$$.fragment,Qp),hw=l(Qp),St=r(Qp,"P",{});var Fc=n(St);ul=r(Fc,"A",{href:!0});var gj=n(ul);gw=i(gj,"LogitsProcessor"),gj.forEach(o),uw=i(Fc," that removes all "),hg=r(Fc,"CODE",{});var uj=n(hg);fw=i(uj,"nan"),uj.forEach(o),_w=i(Fc," and "),gg=r(Fc,"CODE",{});var fj=n(gg);bw=i(fj,"inf"),fj.forEach(o),vw=i(Fc,` values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`),Fc.forEach(o),yw=l(Qp),fl=r(Qp,"DIV",{class:!0});var _j=n(fl);g(xn.$$.fragment,_j),_j.forEach(o),Qp.forEach(o),E_=l(e),Xe=r(e,"DIV",{class:!0});var Yp=n(Xe);g(Mn.$$.fragment,Yp),Tw=l(Yp),cs=r(Yp,"P",{});var _f=n(cs);_l=r(_f,"A",{href:!0});var bj=n(_l);ww=i(bj,"LogitsWarper"),bj.forEach(o),kw=i(_f," and "),bl=r(_f,"A",{href:!0});var vj=n(bl);$w=i(vj,"LogitsProcessor"),vj.forEach(o),xw=i(_f,` for normalizing the scores using log-softmax. It\u2019s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn\u2019t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`),_f.forEach(o),Mw=l(Yp),vl=r(Yp,"DIV",{class:!0});var yj=n(vl);g(En.$$.fragment,yj),yj.forEach(o),Yp.forEach(o),F_=l(e),Ne=r(e,"DIV",{class:!0});var Kp=n(Ne);g(Fn.$$.fragment,Kp),Ew=l(Kp),ug=r(Kp,"P",{});var Tj=n(ug);Fw=i(Tj,"Abstract base class for all logit processors that can be applied during generation."),Tj.forEach(o),jw=l(Kp),yl=r(Kp,"DIV",{class:!0});var wj=n(yl);g(jn.$$.fragment,wj),wj.forEach(o),Kp.forEach(o),j_=l(e),Re=r(e,"DIV",{class:!0});var em=n(Re);g(Ln.$$.fragment,em),Lw=l(em),V=r(em,"P",{});var ne=n(V);zw=i(ne,"This class can be used to create a list of "),Tl=r(ne,"A",{href:!0});var kj=n(Tl);Jw=i(kj,"LogitsProcessor"),kj.forEach(o),Iw=i(ne," or "),wl=r(ne,"A",{href:!0});var $j=n(wl);Uw=i($j,"LogitsWarper"),$j.forEach(o),Bw=i(ne,` to subsequently process a
`),fg=r(ne,"CODE",{});var xj=n(fg);Ww=i(xj,"scores"),xj.forEach(o),Dw=i(ne," input tensor. This class inherits from list and adds a specific "),_g=r(ne,"EM",{});var Mj=n(_g);bg=r(Mj,"STRONG",{});var Ej=n(bg);qw=i(Ej,"call"),Ej.forEach(o),Mj.forEach(o),Pw=i(ne,` method to apply each
`),kl=r(ne,"A",{href:!0});var Fj=n(kl);Sw=i(Fj,"LogitsProcessor"),Fj.forEach(o),Vw=i(ne," or "),$l=r(ne,"A",{href:!0});var jj=n($l);Zw=i(jj,"LogitsWarper"),jj.forEach(o),Gw=i(ne," to the inputs."),ne.forEach(o),Cw=l(em),xl=r(em,"DIV",{class:!0});var Lj=n(xl);g(zn.$$.fragment,Lj),Lj.forEach(o),em.forEach(o),L_=l(e),Oe=r(e,"DIV",{class:!0});var tm=n(Oe);g(Jn.$$.fragment,tm),Xw=l(tm),vg=r(tm,"P",{});var zj=n(vg);Nw=i(zj,"Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),zj.forEach(o),Rw=l(tm),Ml=r(tm,"DIV",{class:!0});var Jj=n(Ml);g(In.$$.fragment,Jj),Jj.forEach(o),tm.forEach(o),z_=l(e),Ae=r(e,"DIV",{class:!0});var om=n(Ae);g(Un.$$.fragment,om),Ow=l(om),El=r(om,"P",{});var CE=n(El);Fl=r(CE,"A",{href:!0});var Ij=n(Fl);Aw=i(Ij,"LogitsProcessor"),Ij.forEach(o),Hw=i(CE," enforcing a min-length by setting EOS probability to 0."),CE.forEach(o),Qw=l(om),jl=r(om,"DIV",{class:!0});var Uj=n(jl);g(Bn.$$.fragment,Uj),Uj.forEach(o),om.forEach(o),J_=l(e),pe=r(e,"DIV",{class:!0});var ir=n(pe);g(Wn.$$.fragment,ir),Yw=l(ir),Te=r(ir,"P",{});var Go=n(Te);Ll=r(Go,"A",{href:!0});var Bj=n(Ll);Kw=i(Bj,"LogitsProcessor"),Bj.forEach(o),ek=i(Go,` enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, `),yg=r(Go,"CODE",{});var Wj=n(yg);tk=i(Wj,"min_length"),Wj.forEach(o),ok=i(Go," will compute the length of "),Tg=r(Go,"CODE",{});var Dj=n(Tg);sk=i(Dj,"prompt + newly generated tokens"),Dj.forEach(o),rk=i(Go," whereas for other models it will behave as "),wg=r(Go,"CODE",{});var qj=n(wg);nk=i(qj,"min_new_tokens"),qj.forEach(o),ak=i(Go,`, that is, taking only into account
the newly generated ones.`),Go.forEach(o),ik=l(ir),g(ls.$$.fragment,ir),ck=l(ir),zl=r(ir,"DIV",{class:!0});var Pj=n(zl);g(Dn.$$.fragment,Pj),Pj.forEach(o),ir.forEach(o),I_=l(e),R=r(e,"DIV",{class:!0});var Xt=n(R);g(qn.$$.fragment,Xt),lk=l(Xt),Jl=r(Xt,"P",{});var XE=n(Jl);Il=r(XE,"A",{href:!0});var Sj=n(Il);dk=i(Sj,"LogitsProcessor"),Sj.forEach(o),pk=i(XE," that enforces that specified sequences will never be selected."),XE.forEach(o),mk=l(Xt),g(ds.$$.fragment,Xt),hk=l(Xt),g(ps.$$.fragment,Xt),gk=l(Xt),Ul=r(Xt,"DIV",{class:!0});var Vj=n(Ul);g(Pn.$$.fragment,Vj),Vj.forEach(o),Xt.forEach(o),U_=l(e),O=r(e,"DIV",{class:!0});var Nt=n(O);g(Sn.$$.fragment,Nt),uk=l(Nt),jo=r(Nt,"P",{});var sm=n(jo);fk=i(sm,`N-grams are groups of \u201Cn\u201D consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: \u201CShe runs fast\u201D, the bi-grams (n=2) would be (\u201Cshe\u201D, \u201Cruns\u201D) and (\u201Cruns\u201D, \u201Cfast\u201D). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This `),Bl=r(sm,"A",{href:!0});var Zj=n(Bl);_k=i(Zj,"LogitsProcessor"),Zj.forEach(o),bk=i(sm,` enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
`),Vn=r(sm,"A",{href:!0,rel:!0});var Gj=n(Vn);vk=i(Gj,"Fairseq"),Gj.forEach(o),yk=i(sm,"."),sm.forEach(o),Tk=l(Nt),g(ms.$$.fragment,Nt),wk=l(Nt),g(hs.$$.fragment,Nt),kk=l(Nt),Wl=r(Nt,"DIV",{class:!0});var Cj=n(Wl);g(Zn.$$.fragment,Cj),Cj.forEach(o),Nt.forEach(o),B_=l(e),He=r(e,"DIV",{class:!0});var rm=n(He);g(Gn.$$.fragment,rm),$k=l(rm),gs=r(rm,"P",{});var bf=n(gs);Dl=r(bf,"A",{href:!0});var Xj=n(Dl);xk=i(Xj,"LogitsProcessor"),Xj.forEach(o),Mk=i(bf,` that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See `),Cn=r(bf,"A",{href:!0,rel:!0});var Nj=n(Cn);Ek=i(Nj,"Autoregressive Entity Retrieval"),Nj.forEach(o),Fk=i(bf," for more information."),bf.forEach(o),jk=l(rm),ql=r(rm,"DIV",{class:!0});var Rj=n(ql);g(Xn.$$.fragment,Rj),Rj.forEach(o),rm.forEach(o),W_=l(e),me=r(e,"DIV",{class:!0});var cr=n(me);g(Nn.$$.fragment,cr),Lk=l(cr),us=r(cr,"P",{});var vf=n(us);Pl=r(vf,"A",{href:!0});var Oj=n(Pl);zk=i(Oj,"LogitsProcessor"),Oj.forEach(o),Jk=i(vf,` that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are less likely to be
selected. The formula can be seen in the original `),Rn=r(vf,"A",{href:!0,rel:!0});var Aj=n(Rn);Ik=i(Aj,"paper"),Aj.forEach(o),Uk=i(vf,`. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`),vf.forEach(o),Bk=l(cr),g(fs.$$.fragment,cr),Wk=l(cr),Sl=r(cr,"DIV",{class:!0});var Hj=n(Sl);g(On.$$.fragment,Hj),Hj.forEach(o),cr.forEach(o),D_=l(e),A=r(e,"DIV",{class:!0});var Rt=n(A);g(An.$$.fragment,Rt),Dk=l(Rt),Vl=r(Rt,"P",{});var NE=n(Vl);Zl=r(NE,"A",{href:!0});var Qj=n(Zl);qk=i(Qj,"LogitsProcessor"),Qj.forEach(o),Pk=i(NE,` that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`),NE.forEach(o),Sk=l(Rt),g(_s.$$.fragment,Rt),Vk=l(Rt),g(bs.$$.fragment,Rt),Zk=l(Rt),Gl=r(Rt,"DIV",{class:!0});var Yj=n(Gl);g(Hn.$$.fragment,Yj),Yj.forEach(o),Rt.forEach(o),q_=l(e),Qe=r(e,"DIV",{class:!0});var nm=n(Qe);g(Qn.$$.fragment,nm),Gk=l(nm),we=r(nm,"P",{});var Co=n(we);Cl=r(Co,"A",{href:!0});var Kj=n(Cl);Ck=i(Kj,"SuppressTokensAtBeginLogitsProcessor"),Kj.forEach(o),Xk=i(Co," supresses a list of tokens as soon as the "),kg=r(Co,"CODE",{});var eL=n(kg);Nk=i(eL,"generate"),eL.forEach(o),Rk=i(Co,` function starts
generating using `),$g=r(Co,"CODE",{});var tL=n($g);Ok=i(tL,"begin_index"),tL.forEach(o),Ak=i(Co," tokens. This should ensure that the tokens defined by "),xg=r(Co,"CODE",{});var oL=n(xg);Hk=i(oL,"begin_suppress_tokens"),oL.forEach(o),Qk=i(Co,` at not
sampled at the begining of the generation.`),Co.forEach(o),Yk=l(nm),Xl=r(nm,"DIV",{class:!0});var sL=n(Xl);g(Yn.$$.fragment,sL),sL.forEach(o),nm.forEach(o),P_=l(e),Ye=r(e,"DIV",{class:!0});var am=n(Ye);g(Kn.$$.fragment,am),Kk=l(am),ea=r(am,"P",{});var kv=n(ea);e$=i(kv,"This processor can be used to suppress a list of tokens. The processor will set their log probs to "),Mg=r(kv,"CODE",{});var rL=n(Mg);t$=i(rL,"-inf"),rL.forEach(o),o$=i(kv,` so that they
are not sampled.`),kv.forEach(o),s$=l(am),Nl=r(am,"DIV",{class:!0});var nL=n(Nl);g(ta.$$.fragment,nL),nL.forEach(o),am.forEach(o),S_=l(e),H=r(e,"DIV",{class:!0});var Ot=n(H);g(oa.$$.fragment,Ot),r$=l(Ot),Rl=r(Ot,"P",{});var RE=n(Rl);Ol=r(RE,"A",{href:!0});var aL=n(Ol);n$=i(aL,"LogitsWarper"),aL.forEach(o),a$=i(RE,` for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`),RE.forEach(o),i$=l(Ot),g(vs.$$.fragment,Ot),c$=l(Ot),g(ys.$$.fragment,Ot),l$=l(Ot),Al=r(Ot,"DIV",{class:!0});var iL=n(Al);g(sa.$$.fragment,iL),iL.forEach(o),Ot.forEach(o),V_=l(e),Ke=r(e,"DIV",{class:!0});var im=n(Ke);g(ra.$$.fragment,im),d$=l(im),Hl=r(im,"P",{});var OE=n(Hl);Ql=r(OE,"A",{href:!0});var cL=n(Ql);p$=i(cL,"LogitsWarper"),cL.forEach(o),m$=i(OE," that performs top-k, i.e. restricting to the k highest probability elements."),OE.forEach(o),h$=l(im),Yl=r(im,"DIV",{class:!0});var lL=n(Yl);g(na.$$.fragment,lL),lL.forEach(o),im.forEach(o),Z_=l(e),he=r(e,"DIV",{class:!0});var lr=n(he);g(aa.$$.fragment,lr),g$=l(lr),Kl=r(lr,"P",{});var AE=n(Kl);ed=r(AE,"A",{href:!0});var dL=n(ed);u$=i(dL,"LogitsWarper"),dL.forEach(o),f$=i(AE," that performs top-p, i.e. restricting to top tokens summing to prob_cut_off <= prob_cut_off."),AE.forEach(o),_$=l(lr),g(Ts.$$.fragment,lr),b$=l(lr),td=r(lr,"DIV",{class:!0});var pL=n(td);g(ia.$$.fragment,pL),pL.forEach(o),lr.forEach(o),G_=l(e),et=r(e,"DIV",{class:!0});var cm=n(et);g(ca.$$.fragment,cm),v$=l(cm),ws=r(cm,"P",{});var yf=n(ws);od=r(yf,"A",{href:!0});var mL=n(od);y$=i(mL,"LogitsWarper"),mL.forEach(o),T$=i(yf," that performs typical decoding. See "),la=r(yf,"A",{href:!0,rel:!0});var hL=n(la);w$=i(hL,`Typical Decoding for Natural Language
Generation`),hL.forEach(o),k$=i(yf," for more information."),yf.forEach(o),$$=l(cm),sd=r(cm,"DIV",{class:!0});var gL=n(sd);g(da.$$.fragment,gL),gL.forEach(o),cm.forEach(o),C_=l(e),Q=r(e,"DIV",{class:!0});var At=n(Q);g(pa.$$.fragment,At),x$=l(At),tt=r(At,"P",{});var dr=n(tt);M$=i(dr,`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the `),Eg=r(dr,"CODE",{});var uL=n(Eg);E$=i(uL,"guidance_scale"),uL.forEach(o),F$=i(dr,". The unconditional scores are computed internally by prompting "),Fg=r(dr,"CODE",{});var fL=n(Fg);j$=i(fL,"model"),fL.forEach(o),L$=i(dr,` with
the `),jg=r(dr,"CODE",{});var _L=n(jg);z$=i(_L,"unconditional_ids"),_L.forEach(o),J$=i(dr," branch."),dr.forEach(o),I$=l(At),ma=r(At,"P",{});var $v=n(ma);U$=i($v,"See "),ha=r($v,"A",{href:!0,rel:!0});var bL=n(ha);B$=i(bL,"the paper"),bL.forEach(o),W$=i($v," for more information."),$v.forEach(o),D$=l(At),g(ks.$$.fragment,At),q$=l(At),rd=r(At,"DIV",{class:!0});var vL=n(rd);g(ga.$$.fragment,vL),vL.forEach(o),At.forEach(o),X_=l(e),ot=r(e,"DIV",{class:!0});var lm=n(ot);g(ua.$$.fragment,lm),P$=l(lm),fa=r(lm,"P",{});var xv=n(fa);S$=i(xv,`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to `),Lg=r(xv,"CODE",{});var yL=n(Lg);V$=i(yL,"inf"),yL.forEach(o),Z$=i(xv," so that they are sampled at their corresponding index."),xv.forEach(o),G$=l(lm),nd=r(lm,"DIV",{class:!0});var TL=n(nd);g(_a.$$.fragment,TL),TL.forEach(o),lm.forEach(o),N_=l(e),Lo=r(e,"H3",{class:!0});var Mv=n(Lo);$s=r(Mv,"A",{id:!0,class:!0,href:!0});var wL=n($s);zg=r(wL,"SPAN",{});var kL=n(zg);g(ba.$$.fragment,kL),kL.forEach(o),wL.forEach(o),C$=l(Mv),Jg=r(Mv,"SPAN",{});var $L=n(Jg);X$=i($L,"TensorFlow"),$L.forEach(o),Mv.forEach(o),R_=l(e),st=r(e,"DIV",{class:!0});var dm=n(st);g(va.$$.fragment,dm),N$=l(dm),ad=r(dm,"P",{});var HE=n(ad);id=r(HE,"A",{href:!0});var xL=n(id);R$=i(xL,"TFLogitsProcessor"),xL.forEach(o),O$=i(HE," that enforces the specified token as the first generated token."),HE.forEach(o),A$=l(dm),cd=r(dm,"DIV",{class:!0});var ML=n(cd);g(ya.$$.fragment,ML),ML.forEach(o),dm.forEach(o),O_=l(e),rt=r(e,"DIV",{class:!0});var pm=n(rt);g(Ta.$$.fragment,pm),H$=l(pm),xs=r(pm,"P",{});var Tf=n(xs);ld=r(Tf,"A",{href:!0});var EL=n(ld);Q$=i(EL,"TFLogitsProcessor"),EL.forEach(o),Y$=i(Tf," that enforces the specified token as the last generated token when "),Ig=r(Tf,"CODE",{});var FL=n(Ig);K$=i(FL,"max_length"),FL.forEach(o),e0=i(Tf," is reached."),Tf.forEach(o),t0=l(pm),dd=r(pm,"DIV",{class:!0});var jL=n(dd);g(wa.$$.fragment,jL),jL.forEach(o),pm.forEach(o),A_=l(e),nt=r(e,"DIV",{class:!0});var mm=n(nt);g(ka.$$.fragment,mm),o0=l(mm),zo=r(mm,"P",{});var hm=n(zo);s0=i(hm,`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to `),Ug=r(hm,"CODE",{});var LL=n(Ug);r0=i(LL,"0"),LL.forEach(o),n0=i(hm,` and all other tokens to
`),Bg=r(hm,"CODE",{});var zL=n(Bg);a0=i(zL,"-inf"),zL.forEach(o),i0=i(hm," so that they are sampled at their corresponding index."),hm.forEach(o),c0=l(mm),pd=r(mm,"DIV",{class:!0});var JL=n(pd);g($a.$$.fragment,JL),JL.forEach(o),mm.forEach(o),H_=l(e),at=r(e,"DIV",{class:!0});var gm=n(at);g(xa.$$.fragment,gm),l0=l(gm),Wg=r(gm,"P",{});var IL=n(Wg);d0=i(IL,"Abstract base class for all logit processors that can be applied during generation."),IL.forEach(o),p0=l(gm),Ms=r(gm,"DIV",{class:!0});var Ev=n(Ms);g(Ma.$$.fragment,Ev),m0=l(Ev),Dg=r(Ev,"P",{});var UL=n(Dg);h0=i(UL,"TF method for processing logits."),UL.forEach(o),Ev.forEach(o),gm.forEach(o),Q_=l(e),it=r(e,"DIV",{class:!0});var um=n(it);g(Ea.$$.fragment,um),g0=l(um),ge=r(um,"P",{});var Ht=n(ge);u0=i(Ht,"This class can be used to create a list of "),md=r(Ht,"A",{href:!0});var BL=n(md);f0=i(BL,"TFLogitsProcessor"),BL.forEach(o),_0=i(Ht," to subsequently process a "),qg=r(Ht,"CODE",{});var WL=n(qg);b0=i(WL,"scores"),WL.forEach(o),v0=i(Ht,` input tensor.
This class inherits from list and adds a specific `),Pg=r(Ht,"EM",{});var DL=n(Pg);Sg=r(DL,"STRONG",{});var qL=n(Sg);y0=i(qL,"call"),qL.forEach(o),DL.forEach(o),T0=i(Ht," method to apply each "),hd=r(Ht,"A",{href:!0});var PL=n(hd);w0=i(PL,"TFLogitsProcessor"),PL.forEach(o),k0=i(Ht,` to the
inputs.`),Ht.forEach(o),$0=l(um),gd=r(um,"DIV",{class:!0});var SL=n(gd);g(Fa.$$.fragment,SL),SL.forEach(o),um.forEach(o),Y_=l(e),ct=r(e,"DIV",{class:!0});var fm=n(ct);g(ja.$$.fragment,fm),x0=l(fm),Vg=r(fm,"P",{});var VL=n(Vg);M0=i(VL,"Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),VL.forEach(o),E0=l(fm),Es=r(fm,"DIV",{class:!0});var Fv=n(Es);g(La.$$.fragment,Fv),F0=l(Fv),Zg=r(Fv,"P",{});var ZL=n(Zg);j0=i(ZL,"TF method for warping logits."),ZL.forEach(o),Fv.forEach(o),fm.forEach(o),K_=l(e),lt=r(e,"DIV",{class:!0});var _m=n(lt);g(za.$$.fragment,_m),L0=l(_m),ud=r(_m,"P",{});var QE=n(ud);fd=r(QE,"A",{href:!0});var GL=n(fd);z0=i(GL,"TFLogitsProcessor"),GL.forEach(o),J0=i(QE," enforcing a min-length by setting EOS probability to 0."),QE.forEach(o),I0=l(_m),_d=r(_m,"DIV",{class:!0});var CL=n(_d);g(Ja.$$.fragment,CL),CL.forEach(o),_m.forEach(o),eb=l(e),dt=r(e,"DIV",{class:!0});var bm=n(dt);g(Ia.$$.fragment,bm),U0=l(bm),bd=r(bm,"P",{});var YE=n(bd);vd=r(YE,"A",{href:!0});var XL=n(vd);B0=i(XL,"TFLogitsProcessor"),XL.forEach(o),W0=i(YE," that enforces that specified sequences will never be sampled."),YE.forEach(o),D0=l(bm),yd=r(bm,"DIV",{class:!0});var NL=n(yd);g(Ua.$$.fragment,NL),NL.forEach(o),bm.forEach(o),tb=l(e),pt=r(e,"DIV",{class:!0});var vm=n(pt);g(Ba.$$.fragment,vm),q0=l(vm),Fs=r(vm,"P",{});var wf=n(Fs);Td=r(wf,"A",{href:!0});var RL=n(Td);P0=i(RL,"TFLogitsProcessor"),RL.forEach(o),S0=i(wf,` that enforces no repetition of n-grams. See
`),Wa=r(wf,"A",{href:!0,rel:!0});var OL=n(Wa);V0=i(OL,"Fairseq"),OL.forEach(o),Z0=i(wf,"."),wf.forEach(o),G0=l(vm),wd=r(vm,"DIV",{class:!0});var AL=n(wd);g(Da.$$.fragment,AL),AL.forEach(o),vm.forEach(o),ob=l(e),mt=r(e,"DIV",{class:!0});var ym=n(mt);g(qa.$$.fragment,ym),C0=l(ym),kd=r(ym,"P",{});var KE=n(kd);$d=r(KE,"A",{href:!0});var HL=n($d);X0=i(HL,"TFLogitsProcessor"),HL.forEach(o),N0=i(KE," enforcing an exponential penalty on repeated sequences."),KE.forEach(o),R0=l(ym),xd=r(ym,"DIV",{class:!0});var QL=n(xd);g(Pa.$$.fragment,QL),QL.forEach(o),ym.forEach(o),sb=l(e),ht=r(e,"DIV",{class:!0});var Tm=n(ht);g(Sa.$$.fragment,Tm),O0=l(Tm),ke=r(Tm,"P",{});var Xo=n(ke);Md=r(Xo,"A",{href:!0});var YL=n(Md);A0=i(YL,"TFSuppressTokensAtBeginLogitsProcessor"),YL.forEach(o),H0=i(Xo," suppresses a list of tokens as soon as the "),Gg=r(Xo,"CODE",{});var KL=n(Gg);Q0=i(KL,"generate"),KL.forEach(o),Y0=i(Xo,` function starts
generating using `),Cg=r(Xo,"CODE",{});var ez=n(Cg);K0=i(ez,"begin_index"),ez.forEach(o),e4=i(Xo," tokens. This should ensure that the tokens defined by "),Xg=r(Xo,"CODE",{});var tz=n(Xg);t4=i(tz,"begin_suppress_tokens"),tz.forEach(o),o4=i(Xo,` at not
sampled at the begining of the generation.`),Xo.forEach(o),s4=l(Tm),Ed=r(Tm,"DIV",{class:!0});var oz=n(Ed);g(Va.$$.fragment,oz),oz.forEach(o),Tm.forEach(o),rb=l(e),gt=r(e,"DIV",{class:!0});var wm=n(gt);g(Za.$$.fragment,wm),r4=l(wm),Ga=r(wm,"P",{});var jv=n(Ga);n4=i(jv,"This processor can be used to suppress a list of tokens. The processor will set their log probs to "),Ng=r(jv,"CODE",{});var sz=n(Ng);a4=i(sz,"-inf"),sz.forEach(o),i4=i(jv,` so that they
are not sampled.`),jv.forEach(o),c4=l(wm),Fd=r(wm,"DIV",{class:!0});var rz=n(Fd);g(Ca.$$.fragment,rz),rz.forEach(o),wm.forEach(o),nb=l(e),ut=r(e,"DIV",{class:!0});var km=n(ut);g(Xa.$$.fragment,km),l4=l(km),jd=r(km,"P",{});var eF=n(jd);Ld=r(eF,"A",{href:!0});var nz=n(Ld);d4=i(nz,"TFLogitsWarper"),nz.forEach(o),p4=i(eF," for temperature (exponential scaling output probability distribution)."),eF.forEach(o),m4=l(km),zd=r(km,"DIV",{class:!0});var az=n(zd);g(Na.$$.fragment,az),az.forEach(o),km.forEach(o),ab=l(e),ft=r(e,"DIV",{class:!0});var $m=n(ft);g(Ra.$$.fragment,$m),h4=l($m),Jd=r($m,"P",{});var tF=n(Jd);Id=r(tF,"A",{href:!0});var iz=n(Id);g4=i(iz,"TFLogitsWarper"),iz.forEach(o),u4=i(tF," that performs top-k, i.e. restricting to the k highest probability elements."),tF.forEach(o),f4=l($m),Ud=r($m,"DIV",{class:!0});var cz=n(Ud);g(Oa.$$.fragment,cz),cz.forEach(o),$m.forEach(o),ib=l(e),_t=r(e,"DIV",{class:!0});var xm=n(_t);g(Aa.$$.fragment,xm),_4=l(xm),Bd=r(xm,"P",{});var oF=n(Bd);Wd=r(oF,"A",{href:!0});var lz=n(Wd);b4=i(lz,"TFLogitsWarper"),lz.forEach(o),v4=i(oF," that performs top-p, i.e. restricting to top tokens summing to <= prob_cut_off."),oF.forEach(o),y4=l(xm),Dd=r(xm,"DIV",{class:!0});var dz=n(Dd);g(Ha.$$.fragment,dz),dz.forEach(o),xm.forEach(o),cb=l(e),Jo=r(e,"H3",{class:!0});var Lv=n(Jo);js=r(Lv,"A",{id:!0,class:!0,href:!0});var pz=n(js);Rg=r(pz,"SPAN",{});var mz=n(Rg);g(Qa.$$.fragment,mz),mz.forEach(o),pz.forEach(o),T4=l(Lv),Og=r(Lv,"SPAN",{});var hz=n(Og);w4=i(hz,"FLAX"),hz.forEach(o),Lv.forEach(o),lb=l(e),bt=r(e,"DIV",{class:!0});var Mm=n(bt);g(Ya.$$.fragment,Mm),k4=l(Mm),qd=r(Mm,"P",{});var sF=n(qd);Pd=r(sF,"A",{href:!0});var gz=n(Pd);$4=i(gz,"FlaxLogitsProcessor"),gz.forEach(o),x4=i(sF," that enforces the specified token as the first generated token."),sF.forEach(o),M4=l(Mm),Sd=r(Mm,"DIV",{class:!0});var uz=n(Sd);g(Ka.$$.fragment,uz),uz.forEach(o),Mm.forEach(o),db=l(e),vt=r(e,"DIV",{class:!0});var Em=n(vt);g(ei.$$.fragment,Em),E4=l(Em),Ls=r(Em,"P",{});var kf=n(Ls);Vd=r(kf,"A",{href:!0});var fz=n(Vd);F4=i(fz,"FlaxLogitsProcessor"),fz.forEach(o),j4=i(kf," that enforces the specified token as the last generated token when "),Ag=r(kf,"CODE",{});var _z=n(Ag);L4=i(_z,"max_length"),_z.forEach(o),z4=i(kf," is reached."),kf.forEach(o),J4=l(Em),Zd=r(Em,"DIV",{class:!0});var bz=n(Zd);g(ti.$$.fragment,bz),bz.forEach(o),Em.forEach(o),pb=l(e),yt=r(e,"DIV",{class:!0});var Fm=n(yt);g(oi.$$.fragment,Fm),I4=l(Fm),zs=r(Fm,"P",{});var $f=n(zs);Gd=r($f,"A",{href:!0});var vz=n(Gd);U4=i(vz,"FlaxLogitsProcessor"),vz.forEach(o),B4=i($f,` that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to `),Hg=r($f,"CODE",{});var yz=n(Hg);W4=i(yz,"-inf"),yz.forEach(o),D4=i($f," so that they are sampled at their corresponding index."),$f.forEach(o),q4=l(Fm),Cd=r(Fm,"DIV",{class:!0});var Tz=n(Cd);g(si.$$.fragment,Tz),Tz.forEach(o),Fm.forEach(o),mb=l(e),Tt=r(e,"DIV",{class:!0});var jm=n(Tt);g(ri.$$.fragment,jm),P4=l(jm),Qg=r(jm,"P",{});var wz=n(Qg);S4=i(wz,"Abstract base class for all logit processors that can be applied during generation."),wz.forEach(o),V4=l(jm),Js=r(jm,"DIV",{class:!0});var zv=n(Js);g(ni.$$.fragment,zv),Z4=l(zv),Yg=r(zv,"P",{});var kz=n(Yg);G4=i(kz,"Flax method for processing logits."),kz.forEach(o),zv.forEach(o),jm.forEach(o),hb=l(e),wt=r(e,"DIV",{class:!0});var Lm=n(wt);g(ai.$$.fragment,Lm),C4=l(Lm),Z=r(Lm,"P",{});var ae=n(Z);X4=i(ae,"This class can be used to create a list of "),Xd=r(ae,"A",{href:!0});var $z=n(Xd);N4=i($z,"FlaxLogitsProcessor"),$z.forEach(o),R4=i(ae," or "),Nd=r(ae,"A",{href:!0});var xz=n(Nd);O4=i(xz,"FlaxLogitsWarper"),xz.forEach(o),A4=i(ae,` to subsequently process
a `),Kg=r(ae,"CODE",{});var Mz=n(Kg);H4=i(Mz,"scores"),Mz.forEach(o),Q4=i(ae," input tensor. This class inherits from list and adds a specific "),eu=r(ae,"EM",{});var Ez=n(eu);tu=r(Ez,"STRONG",{});var Fz=n(tu);Y4=i(Fz,"call"),Fz.forEach(o),Ez.forEach(o),K4=i(ae,` method to apply each
`),Rd=r(ae,"A",{href:!0});var jz=n(Rd);ex=i(jz,"FlaxLogitsProcessor"),jz.forEach(o),tx=i(ae," or "),Od=r(ae,"A",{href:!0});var Lz=n(Od);ox=i(Lz,"FlaxLogitsWarper"),Lz.forEach(o),sx=i(ae," to the inputs."),ae.forEach(o),rx=l(Lm),Ad=r(Lm,"DIV",{class:!0});var zz=n(Ad);g(ii.$$.fragment,zz),zz.forEach(o),Lm.forEach(o),gb=l(e),kt=r(e,"DIV",{class:!0});var zm=n(kt);g(ci.$$.fragment,zm),nx=l(zm),ou=r(zm,"P",{});var Jz=n(ou);ax=i(Jz,"Abstract base class for all logit warpers that can be applied during generation with multinomial sampling."),Jz.forEach(o),ix=l(zm),Is=r(zm,"DIV",{class:!0});var Jv=n(Is);g(li.$$.fragment,Jv),cx=l(Jv),su=r(Jv,"P",{});var Iz=n(su);lx=i(Iz,"Flax method for warping logits."),Iz.forEach(o),Jv.forEach(o),zm.forEach(o),ub=l(e),$t=r(e,"DIV",{class:!0});var Jm=n($t);g(di.$$.fragment,Jm),dx=l(Jm),Hd=r(Jm,"P",{});var rF=n(Hd);Qd=r(rF,"A",{href:!0});var Uz=n(Qd);px=i(Uz,"FlaxLogitsProcessor"),Uz.forEach(o),mx=i(rF," enforcing a min-length by setting EOS probability to 0."),rF.forEach(o),hx=l(Jm),Yd=r(Jm,"DIV",{class:!0});var Bz=n(Yd);g(pi.$$.fragment,Bz),Bz.forEach(o),Jm.forEach(o),fb=l(e),xt=r(e,"DIV",{class:!0});var Im=n(xt);g(mi.$$.fragment,Im),gx=l(Im),$e=r(Im,"P",{});var No=n($e);Kd=r(No,"A",{href:!0});var Wz=n(Kd);ux=i(Wz,"FlaxLogitsProcessor"),Wz.forEach(o),fx=i(No," supressing a list of tokens as soon as the "),ru=r(No,"CODE",{});var Dz=n(ru);_x=i(Dz,"generate"),Dz.forEach(o),bx=i(No,` function starts generating using
`),nu=r(No,"CODE",{});var qz=n(nu);vx=i(qz,"begin_index"),qz.forEach(o),yx=i(No," tokens. This should ensure that the tokens defined by "),au=r(No,"CODE",{});var Pz=n(au);Tx=i(Pz,"begin_suppress_tokens"),Pz.forEach(o),wx=i(No,` are not sampled at the
begining of the generation.`),No.forEach(o),kx=l(Im),ep=r(Im,"DIV",{class:!0});var Sz=n(ep);g(hi.$$.fragment,Sz),Sz.forEach(o),Im.forEach(o),_b=l(e),Mt=r(e,"DIV",{class:!0});var Um=n(Mt);g(gi.$$.fragment,Um),$x=l(Um),Us=r(Um,"P",{});var xf=n(Us);tp=r(xf,"A",{href:!0});var Vz=n(tp);xx=i(Vz,"FlaxLogitsProcessor"),Vz.forEach(o),Mx=i(xf,` suppressing a list of tokens at each decoding step. The processor will set their log probs
to be `),iu=r(xf,"CODE",{});var Zz=n(iu);Ex=i(Zz,"-inf"),Zz.forEach(o),Fx=i(xf," so they are not sampled."),xf.forEach(o),jx=l(Um),op=r(Um,"DIV",{class:!0});var Gz=n(op);g(ui.$$.fragment,Gz),Gz.forEach(o),Um.forEach(o),bb=l(e),Et=r(e,"DIV",{class:!0});var Bm=n(Et);g(fi.$$.fragment,Bm),Lx=l(Bm),sp=r(Bm,"P",{});var nF=n(sp);rp=r(nF,"A",{href:!0});var Cz=n(rp);zx=i(Cz,"FlaxLogitsWarper"),Cz.forEach(o),Jx=i(nF," for temperature (exponential scaling output probability distribution)."),nF.forEach(o),Ix=l(Bm),np=r(Bm,"DIV",{class:!0});var Xz=n(np);g(_i.$$.fragment,Xz),Xz.forEach(o),Bm.forEach(o),vb=l(e),Ft=r(e,"DIV",{class:!0});var Wm=n(Ft);g(bi.$$.fragment,Wm),Ux=l(Wm),ap=r(Wm,"P",{});var aF=n(ap);ip=r(aF,"A",{href:!0});var Nz=n(ip);Bx=i(Nz,"FlaxLogitsWarper"),Nz.forEach(o),Wx=i(aF," that performs top-k, i.e. restricting to the k highest probability elements."),aF.forEach(o),Dx=l(Wm),cp=r(Wm,"DIV",{class:!0});var Rz=n(cp);g(vi.$$.fragment,Rz),Rz.forEach(o),Wm.forEach(o),yb=l(e),jt=r(e,"DIV",{class:!0});var Dm=n(jt);g(yi.$$.fragment,Dm),qx=l(Dm),lp=r(Dm,"P",{});var iF=n(lp);dp=r(iF,"A",{href:!0});var Oz=n(dp);Px=i(Oz,"FlaxLogitsWarper"),Oz.forEach(o),Sx=i(iF," that performs top-p, i.e. restricting to top tokens summing to prob_cut_off <= prob_cut_off."),iF.forEach(o),Vx=l(Dm),pp=r(Dm,"DIV",{class:!0});var Az=n(pp);g(Ti.$$.fragment,Az),Az.forEach(o),Dm.forEach(o),Tb=l(e),Lt=r(e,"DIV",{class:!0});var qm=n(Lt);g(wi.$$.fragment,qm),Zx=l(qm),ki=r(qm,"P",{});var Iv=n(ki);Gx=i(Iv,`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to `),cu=r(Iv,"CODE",{});var Hz=n(cu);Cx=i(Hz,"inf"),Hz.forEach(o),Xx=i(Iv," so that they are sampled at their corresponding index."),Iv.forEach(o),Nx=l(qm),mp=r(qm,"DIV",{class:!0});var Qz=n(mp);g($i.$$.fragment,Qz),Qz.forEach(o),qm.forEach(o),wb=l(e),Io=r(e,"H2",{class:!0});var Uv=n(Io);Bs=r(Uv,"A",{id:!0,class:!0,href:!0});var Yz=n(Bs);lu=r(Yz,"SPAN",{});var Kz=n(lu);g(xi.$$.fragment,Kz),Kz.forEach(o),Yz.forEach(o),Rx=l(Uv),du=r(Uv,"SPAN",{});var eJ=n(du);Ox=i(eJ,"StoppingCriteria"),eJ.forEach(o),Uv.forEach(o),kb=l(e),Ws=r(e,"P",{});var Bv=n(Ws);Ax=i(Bv,"A "),hp=r(Bv,"A",{href:!0});var tJ=n(hp);Hx=i(tJ,"StoppingCriteria"),tJ.forEach(o),Qx=i(Bv," can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations."),Bv.forEach(o),$b=l(e),zt=r(e,"DIV",{class:!0});var Pm=n(zt);g(Mi.$$.fragment,Pm),Yx=l(Pm),pu=r(Pm,"P",{});var oJ=n(pu);Kx=i(oJ,"Abstract base class for all stopping criteria that can be applied during generation."),oJ.forEach(o),eM=l(Pm),gp=r(Pm,"DIV",{class:!0});var sJ=n(gp);g(Ei.$$.fragment,sJ),sJ.forEach(o),Pm.forEach(o),xb=l(e),Uo=r(e,"DIV",{class:!0});var Wv=n(Uo);g(Fi.$$.fragment,Wv),tM=l(Wv),up=r(Wv,"DIV",{class:!0});var rJ=n(up);g(ji.$$.fragment,rJ),rJ.forEach(o),Wv.forEach(o),Mb=l(e),Jt=r(e,"DIV",{class:!0});var Sm=n(Jt);g(Li.$$.fragment,Sm),oM=l(Sm),zi=r(Sm,"P",{});var Dv=n(zi);sM=i(Dv,"This class can be used to stop generation whenever the full generated number of tokens exceeds "),mu=r(Dv,"CODE",{});var nJ=n(mu);rM=i(nJ,"max_length"),nJ.forEach(o),nM=i(Dv,`. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`),Dv.forEach(o),aM=l(Sm),fp=r(Sm,"DIV",{class:!0});var aJ=n(fp);g(Ji.$$.fragment,aJ),aJ.forEach(o),Sm.forEach(o),Eb=l(e),It=r(e,"DIV",{class:!0});var Vm=n(It);g(Ii.$$.fragment,Vm),iM=l(Vm),Ui=r(Vm,"P",{});var qv=n(Ui);cM=i(qv,`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
`),hu=r(qv,"CODE",{});var iJ=n(hu);lM=i(iJ,"initial_time"),iJ.forEach(o),dM=i(qv,"."),qv.forEach(o),pM=l(Vm),_p=r(Vm,"DIV",{class:!0});var cJ=n(_p);g(Bi.$$.fragment,cJ),cJ.forEach(o),Vm.forEach(o),Fb=l(e),Bo=r(e,"H2",{class:!0});var Pv=n(Bo);Ds=r(Pv,"A",{id:!0,class:!0,href:!0});var lJ=n(Ds);gu=r(lJ,"SPAN",{});var dJ=n(gu);g(Wi.$$.fragment,dJ),dJ.forEach(o),lJ.forEach(o),mM=l(Pv),uu=r(Pv,"SPAN",{});var pJ=n(uu);hM=i(pJ,"Constraints"),pJ.forEach(o),Pv.forEach(o),jb=l(e),qs=r(e,"P",{});var Sv=n(qs);gM=i(Sv,"A "),bp=r(Sv,"A",{href:!0});var mJ=n(bp);uM=i(mJ,"Constraint"),mJ.forEach(o),fM=i(Sv," can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations."),Sv.forEach(o),Lb=l(e),L=r(e,"DIV",{class:!0});var z=n(L);g(Di.$$.fragment,z),_M=l(z),fu=r(z,"P",{});var hJ=n(fu);bM=i(hJ,`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`),hJ.forEach(o),vM=l(z),_u=r(z,"P",{});var gJ=n(_u);yM=i(gJ,"All classes that inherit Constraint must follow the requirement that"),gJ.forEach(o),TM=l(z),g(Ps.$$.fragment,z),wM=l(z),bu=r(z,"P",{});var uJ=n(bu);kM=i(uJ,"will always terminate (halt)."),uJ.forEach(o),$M=l(z),Ss=r(z,"DIV",{class:!0});var Vv=n(Ss);g(qi.$$.fragment,Vv),xM=l(Vv),vu=r(Vv,"P",{});var fJ=n(vu);MM=i(fJ,"When called, returns the token that would take this constraint one step closer to being fulfilled."),fJ.forEach(o),Vv.forEach(o),EM=l(z),Vs=r(z,"DIV",{class:!0});var Zv=n(Vs);g(Pi.$$.fragment,Zv),FM=l(Zv),yu=r(Zv,"P",{});var _J=n(yu);jM=i(_J,"Creates a new instance of this constraint."),_J.forEach(o),Zv.forEach(o),LM=l(z),Zs=r(z,"DIV",{class:!0});var Gv=n(Zs);g(Si.$$.fragment,Gv),zM=l(Gv),Tu=r(Gv,"P",{});var bJ=n(Tu);JM=i(bJ,"Reads in a token and returns whether it creates progress."),bJ.forEach(o),Gv.forEach(o),IM=l(z),Gs=r(z,"DIV",{class:!0});var Cv=n(Gs);g(Vi.$$.fragment,Cv),UM=l(Cv),Zi=r(Cv,"P",{});var Xv=n(Zi);BM=i(Xv,"Returns the number of remaining steps of "),wu=r(Xv,"CODE",{});var vJ=n(wu);WM=i(vJ,"advance()"),vJ.forEach(o),DM=i(Xv," in order to complete this constraint."),Xv.forEach(o),Cv.forEach(o),qM=l(z),Cs=r(z,"DIV",{class:!0});var Nv=n(Cs);g(Gi.$$.fragment,Nv),PM=l(Nv),ku=r(Nv,"P",{});var yJ=n(ku);SM=i(yJ,`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`),yJ.forEach(o),Nv.forEach(o),VM=l(z),Xs=r(z,"DIV",{class:!0});var Rv=n(Xs);g(Ci.$$.fragment,Rv),ZM=l(Rv),$u=r(Rv,"P",{});var TJ=n($u);GM=i(TJ,"Tests whether this constraint has been properly defined."),TJ.forEach(o),Rv.forEach(o),CM=l(z),Vt=r(z,"DIV",{class:!0});var Zm=n(Vt);g(Xi.$$.fragment,Zm),XM=l(Zm),Ni=r(Zm,"P",{});var Ov=n(Ni);NM=i(Ov,`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes `),xu=r(Ov,"CODE",{});var wJ=n(xu);RM=i(wJ,"does_advance(self, token_id: int)"),wJ.forEach(o),OM=i(Ov,"."),Ov.forEach(o),AM=l(Zm),Mu=r(Zm,"P",{});var kJ=n(Mu);HM=i(kJ,`This isn\u2019t to test whether a certain token will advance the progress; it\u2019s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`),kJ.forEach(o),Zm.forEach(o),z.forEach(o),zb=l(e),Wo=r(e,"DIV",{class:!0});var Av=n(Wo);g(Ri.$$.fragment,Av),QM=l(Av),vp=r(Av,"P",{});var cF=n(vp);yp=r(cF,"A",{href:!0});var $J=n(yp);YM=i($J,"Constraint"),$J.forEach(o),KM=i(cF," enforcing that an ordered sequence of tokens is included in the output."),cF.forEach(o),Av.forEach(o),Jb=l(e),Do=r(e,"DIV",{class:!0});var Hv=n(Do);g(Oi.$$.fragment,Hv),e3=l(Hv),Ai=r(Hv,"P",{});var Qv=n(Ai);t3=i(Qv,"A special "),Tp=r(Qv,"A",{href:!0});var xJ=n(Tp);o3=i(xJ,"Constraint"),xJ.forEach(o),s3=i(Qv," that is fulfilled by fulfilling just one of several constraints."),Qv.forEach(o),Hv.forEach(o),Ib=l(e),ue=r(e,"DIV",{class:!0});var pr=n(ue);g(Hi.$$.fragment,pr),r3=l(pr),Eu=r(pr,"P",{});var MJ=n(Eu);n3=i(MJ,"A class for beam scorers to track its progress through a list of constraints."),MJ.forEach(o),a3=l(pr),X=r(pr,"DIV",{class:!0});var xe=n(X);g(Qi.$$.fragment,xe),i3=l(xe),Fu=r(xe,"P",{});var EJ=n(Fu);c3=i(EJ,`The list of tokens to generate such that we can make progress.
By \u201Clist\u201D we don\u2019t mean the list of token that will fully fulfill a constraint.`),EJ.forEach(o),l3=l(xe),qo=r(xe,"P",{});var Gm=n(qo);d3=i(Gm,"Given constraints "),ju=r(Gm,"CODE",{});var FJ=n(ju);p3=i(FJ,"c_i = {t_ij | j == # of tokens}"),FJ.forEach(o),m3=i(Gm,`, If we\u2019re not in the middle of progressing through a
specific constraint `),Lu=r(Gm,"CODE",{});var jJ=n(Lu);h3=i(jJ,"c_i"),jJ.forEach(o),g3=i(Gm,", we return:"),Gm.forEach(o),u3=l(xe),zu=r(xe,"P",{});var LJ=n(zu);Ju=r(LJ,"CODE",{});var zJ=n(Ju);f3=i(zJ,"[t_k1 for k in indices of unfulfilled constraints]"),zJ.forEach(o),LJ.forEach(o),_3=l(xe),Ut=r(xe,"P",{});var mr=n(Ut);b3=i(mr,`If we are in the middle of a constraint, then we return:
`),Iu=r(mr,"CODE",{});var JJ=n(Iu);v3=i(JJ,"[t_ij]"),JJ.forEach(o),y3=i(mr,", where "),Uu=r(mr,"CODE",{});var IJ=n(Uu);T3=i(IJ,"i"),IJ.forEach(o),w3=i(mr," is the index of the inprogress constraint, "),Bu=r(mr,"CODE",{});var UJ=n(Bu);k3=i(UJ,"j"),UJ.forEach(o),$3=i(mr," is the next step for the constraint."),mr.forEach(o),x3=l(xe),Wu=r(xe,"P",{});var BJ=n(Wu);M3=i(BJ,`Though we don\u2019t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that\u2019s the only one we\u2019ll return.`),BJ.forEach(o),xe.forEach(o),E3=l(pr),Ns=r(pr,"DIV",{class:!0});var Yv=n(Ns);g(Yi.$$.fragment,Yv),F3=l(Yv),Du=r(Yv,"P",{});var WJ=n(Du);j3=i(WJ,"token_ids: the tokens generated thus far to reset the state of the progress through constraints."),WJ.forEach(o),Yv.forEach(o),pr.forEach(o),Ub=l(e),Po=r(e,"H2",{class:!0});var Kv=n(Po);Rs=r(Kv,"A",{id:!0,class:!0,href:!0});var DJ=n(Rs);qu=r(DJ,"SPAN",{});var qJ=n(qu);g(Ki.$$.fragment,qJ),qJ.forEach(o),DJ.forEach(o),L3=l(Kv),Pu=r(Kv,"SPAN",{});var PJ=n(Pu);z3=i(PJ,"BeamSearch"),PJ.forEach(o),Kv.forEach(o),Bb=l(e),fe=r(e,"DIV",{class:!0});var hr=n(fe);g(ec.$$.fragment,hr),J3=l(hr),So=r(hr,"P",{});var Cm=n(So);I3=i(Cm,"Abstract base class for all beam scorers that are used for "),wp=r(Cm,"A",{href:!0});var SJ=n(wp);U3=i(SJ,"beam_search()"),SJ.forEach(o),B3=i(Cm,` and
`),kp=r(Cm,"A",{href:!0});var VJ=n(kp);W3=i(VJ,"beam_sample()"),VJ.forEach(o),D3=i(Cm,"."),Cm.forEach(o),q3=l(hr),$p=r(hr,"DIV",{class:!0});var ZJ=n($p);g(tc.$$.fragment,ZJ),ZJ.forEach(o),P3=l(hr),xp=r(hr,"DIV",{class:!0});var GJ=n(xp);g(oc.$$.fragment,GJ),GJ.forEach(o),hr.forEach(o),Wb=l(e),G=r(e,"DIV",{class:!0});var Me=n(G);g(sc.$$.fragment,Me),S3=l(Me),Mp=r(Me,"P",{});var lF=n(Mp);Ep=r(lF,"A",{href:!0});var CJ=n(Ep);V3=i(CJ,"BeamScorer"),CJ.forEach(o),Z3=i(lF," implementing standard beam search decoding."),lF.forEach(o),G3=l(Me),rc=r(Me,"P",{});var ey=n(rc);C3=i(ey,"Adapted in part from "),nc=r(ey,"A",{href:!0,rel:!0});var XJ=n(nc);X3=i(XJ,`Facebook\u2019s XLM beam search
code`),XJ.forEach(o),N3=i(ey,"."),ey.forEach(o),R3=l(Me),Fp=r(Me,"P",{});var dF=n(Fp);O3=i(dF,"Reference for the diverse beam search algorithm and implementation "),ac=r(dF,"A",{href:!0,rel:!0});var NJ=n(ac);A3=i(NJ,`Ashwin Kalyan\u2019s DBS
implementation`),NJ.forEach(o),dF.forEach(o),H3=l(Me),jp=r(Me,"DIV",{class:!0});var RJ=n(jp);g(ic.$$.fragment,RJ),RJ.forEach(o),Q3=l(Me),Lp=r(Me,"DIV",{class:!0});var OJ=n(Lp);g(cc.$$.fragment,OJ),OJ.forEach(o),Me.forEach(o),Db=l(e),_e=r(e,"DIV",{class:!0});var gr=n(_e);g(lc.$$.fragment,gr),Y3=l(gr),zp=r(gr,"P",{});var pF=n(zp);Jp=r(pF,"A",{href:!0});var AJ=n(Jp);K3=i(AJ,"BeamScorer"),AJ.forEach(o),eE=i(pF," implementing constrained beam search decoding."),pF.forEach(o),tE=l(gr),Ip=r(gr,"DIV",{class:!0});var HJ=n(Ip);g(dc.$$.fragment,HJ),HJ.forEach(o),oE=l(gr),Up=r(gr,"DIV",{class:!0});var QJ=n(Up);g(pc.$$.fragment,QJ),QJ.forEach(o),gr.forEach(o),qb=l(e),Vo=r(e,"H2",{class:!0});var ty=n(Vo);Os=r(ty,"A",{id:!0,class:!0,href:!0});var YJ=n(Os);Su=r(YJ,"SPAN",{});var KJ=n(Su);g(mc.$$.fragment,KJ),KJ.forEach(o),YJ.forEach(o),sE=l(ty),Vu=r(ty,"SPAN",{});var eI=n(Vu);rE=i(eI,"Utilities"),eI.forEach(o),ty.forEach(o),Pb=l(e),Bt=r(e,"DIV",{class:!0});var Xm=n(Bt);g(hc.$$.fragment,Xm),nE=l(Xm),Zu=r(Xm,"P",{});var tI=n(Zu);aE=i(tI,"Filter a distribution of logits using top-k and/or nucleus (top-p) filtering"),tI.forEach(o),iE=l(Xm),Bp=r(Xm,"P",{});var mF=n(Bp);cE=i(mF,"From: "),gc=r(mF,"A",{href:!0,rel:!0});var oI=n(gc);lE=i(oI,"https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),oI.forEach(o),mF.forEach(o),Xm.forEach(o),Sb=l(e),Wt=r(e,"DIV",{class:!0});var Nm=n(Wt);g(uc.$$.fragment,Nm),dE=l(Nm),Gu=r(Nm,"P",{});var sI=n(Gu);pE=i(sI,"Filter a distribution of logits using top-k and/or nucleus (top-p) filtering"),sI.forEach(o),mE=l(Nm),Wp=r(Nm,"P",{});var hF=n(Wp);hE=i(hF,"From: "),fc=r(hF,"A",{href:!0,rel:!0});var rI=n(fc);gE=i(rI,"https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),rI.forEach(o),hF.forEach(o),Nm.forEach(o),Vb=l(e),Zo=r(e,"H2",{class:!0});var oy=n(Zo);As=r(oy,"A",{id:!0,class:!0,href:!0});var nI=n(As);Cu=r(nI,"SPAN",{});var aI=n(Cu);g(_c.$$.fragment,aI),aI.forEach(o),nI.forEach(o),uE=l(oy),Xu=r(oy,"SPAN",{});var iI=n(Xu);fE=i(iI,"Streamers"),iI.forEach(o),oy.forEach(o),Zb=l(e),D=r(e,"DIV",{class:!0});var ie=n(D);g(bc.$$.fragment,ie),_E=l(ie),Nu=r(ie,"P",{});var cI=n(Nu);bE=i(cI,"Simple text streamer that prints the token(s) to stdout as soon as entire words are formed."),cI.forEach(o),vE=l(ie),g(Hs.$$.fragment,ie),yE=l(ie),g(Qs.$$.fragment,ie),TE=l(ie),Ys=r(ie,"DIV",{class:!0});var sy=n(Ys);g(vc.$$.fragment,sy),wE=l(sy),Ru=r(sy,"P",{});var lI=n(Ru);kE=i(lI,"Flushes any remaining cache and prints a newline to stdout."),lI.forEach(o),sy.forEach(o),$E=l(ie),Ks=r(ie,"DIV",{class:!0});var ry=n(Ks);g(yc.$$.fragment,ry),xE=l(ry),Ou=r(ry,"P",{});var dI=n(Ou);ME=i(dI,"Prints the new text to stdout. If the stream is ending, also prints a newline."),dI.forEach(o),ry.forEach(o),EE=l(ie),er=r(ie,"DIV",{class:!0});var ny=n(er);g(Tc.$$.fragment,ny),FE=l(ny),Au=r(ny,"P",{});var pI=n(Au);jE=i(pI,"Receives tokens, decodes them, and prints them to stdout as soon as they form entire words."),pI.forEach(o),ny.forEach(o),ie.forEach(o),Gb=l(e),Y=r(e,"DIV",{class:!0});var Qt=n(Y);g(wc.$$.fragment,Qt),LE=l(Qt),Hu=r(Qt,"P",{});var mI=n(Hu);zE=i(mI,`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`),mI.forEach(o),JE=l(Qt),g(tr.$$.fragment,Qt),IE=l(Qt),g(or.$$.fragment,Qt),UE=l(Qt),sr=r(Qt,"DIV",{class:!0});var ay=n(sr);g(kc.$$.fragment,ay),BE=l(ay),Qu=r(ay,"P",{});var hI=n(Qu);WE=i(hI,"Put the new text in the queue. If the stream is ending, also put a stop signal in the queue."),hI.forEach(o),ay.forEach(o),Qt.forEach(o),this.h()},h(){d(T,"name","hf:doc:metadata"),d(T,"content",JSON.stringify(qI)),d(w,"id","utilities-for-generation"),d(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(w,"href","#utilities-for-generation"),d(k,"class","relative group"),d(K,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),d(ee,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),d(F,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),d(be,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),d(jc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),d(Lc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),d(zc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),d(Jc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),d(Ro,"id","generate-outputs"),d(Ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ro,"href","#generate-outputs"),d(oo,"class","relative group"),d(Uc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),d(Bc,"href","/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"),d(Wc,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),d(qc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"),d(Ao,"id","transformers.generation.GreedySearchEncoderDecoderOutput"),d(Ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ao,"href","#transformers.generation.GreedySearchEncoderDecoderOutput"),d(so,"class","relative group"),d(ro,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ao,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(co,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(lo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(po,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(mo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ho,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ho,"id","transformers.generation.TFGreedySearchEncoderDecoderOutput"),d(Ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ho,"href","#transformers.generation.TFGreedySearchEncoderDecoderOutput"),d(uo,"class","relative group"),d(fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(bo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(vo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(To,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(wo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ko,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d($o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Qo,"id","transformers.generation.FlaxSampleOutput"),d(Qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Qo,"href","#transformers.generation.FlaxSampleOutput"),d(Mo,"class","relative group"),d(Yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ko,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ts,"id","logitsprocessor"),d(ts,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ts,"href","#logitsprocessor"),d(Eo,"class","relative group"),d(Cc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(ss,"id","transformers.AlternatingCodebooksLogitsProcessor"),d(ss,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ss,"href","#transformers.AlternatingCodebooksLogitsProcessor"),d(Fo,"class","relative group"),d(Xc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Oc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(tn,"href","https://github.com/facebookresearch/ParlAI/blob/master/parlai/core/torch_generator_agent.py#L1350"),d(tn,"rel","nofollow"),d(Ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Qc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Kc,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(an,"href","https://arxiv.org/abs/2210.15191"),d(an,"rel","nofollow"),d(el,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(tl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(dn,"href","https://arxiv.org/abs/2210.15191"),d(dn,"rel","nofollow"),d(ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(rl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(il,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ll,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(pl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ml,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(hl,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),d(wn,"href","https://arxiv.org/pdf/1610.02424.pdf"),d(wn,"rel","nofollow"),d(gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ul,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(fl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_l,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(bl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(vl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Tl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(wl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(kl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d($l,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ml,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Fl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(jl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ll,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Il,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Ul,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Bl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Vn,"href","https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345"),d(Vn,"rel","nofollow"),d(Wl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Dl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Cn,"href","https://arxiv.org/abs/2010.00904"),d(Cn,"rel","nofollow"),d(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Pl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Rn,"href","https://arxiv.org/pdf/1909.05858.pdf"),d(Rn,"rel","nofollow"),d(Sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Zl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor"),d(Gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Cl,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor"),d(Xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ol,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(Al,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ql,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(Yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ed,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(od,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper"),d(la,"href","https://arxiv.org/abs/2202.00666"),d(la,"rel","nofollow"),d(sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ha,"href","https://arxiv.org/abs/2306.17806"),d(ha,"rel","nofollow"),d(rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d($s,"id","transformers.TFForcedBOSTokenLogitsProcessor"),d($s,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d($s,"href","#transformers.TFForcedBOSTokenLogitsProcessor"),d(Lo,"class","relative group"),d(id,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ld,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(md,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(hd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(_d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(vd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Td,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(Wa,"href","https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345"),d(Wa,"rel","nofollow"),d(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d($d,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsProcessor"),d(xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Md,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor"),d(Ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Fd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ld,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsWarper"),d(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Id,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsWarper"),d(Ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Wd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.TFLogitsWarper"),d(Dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(js,"id","transformers.FlaxForcedBOSTokenLogitsProcessor"),d(js,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(js,"href","#transformers.FlaxForcedBOSTokenLogitsProcessor"),d(Jo,"class","relative group"),d(Pd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Vd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Gd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Xd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Nd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsWarper"),d(Rd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Od,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsWarper"),d(Ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Qd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(Yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Kd,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(tp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsProcessor"),d(op,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(rp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsWarper"),d(np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ip,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsWarper"),d(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(dp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.FlaxLogitsWarper"),d(pp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Bs,"id","transformers.StoppingCriteria"),d(Bs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Bs,"href","#transformers.StoppingCriteria"),d(Io,"class","relative group"),d(hp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria"),d(gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(up,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Uo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ds,"id","transformers.Constraint"),d(Ds,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ds,"href","#transformers.Constraint"),d(Bo,"class","relative group"),d(bp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.Constraint"),d(Ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(yp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.Constraint"),d(Wo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Tp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.Constraint"),d(Do,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Rs,"id","transformers.BeamScorer"),d(Rs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Rs,"href","#transformers.BeamScorer"),d(Po,"class","relative group"),d(wp,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),d(kp,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),d($p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ep,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer"),d(nc,"href","https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529"),d(nc,"rel","nofollow"),d(ac,"href","https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua"),d(ac,"rel","nofollow"),d(jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Jp,"href","/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer"),d(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Up,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Os,"id","transformers.top_k_top_p_filtering"),d(Os,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Os,"href","#transformers.top_k_top_p_filtering"),d(Vo,"class","relative group"),d(gc,"href","https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),d(gc,"rel","nofollow"),d(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fc,"href","https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317"),d(fc,"rel","nofollow"),d(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(As,"id","transformers.TextStreamer"),d(As,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(As,"href","#transformers.TextStreamer"),d(Zo,"class","relative group"),d(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(er,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(sr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,T),m(e,M,p),m(e,k,p),t(k,w),t(w,x),u(v,x,null),t(k,$),t(k,S),t(S,J),m(e,I,p),m(e,j,p),t(j,q),t(j,K),t(K,je),t(j,W),t(j,ee),t(ee,Le),t(j,N),t(j,F),t(F,Yt),t(j,Kt),t(j,be),t(be,eo),t(j,to),t(j,jc),t(jc,iy),t(j,cy),t(j,Lc),t(Lc,ly),t(j,dy),t(j,zc),t(zc,py),t(j,my),t(j,Jc),t(Jc,hy),t(j,gy),m(e,Mf,p),m(e,Ic,p),t(Ic,uy),m(e,Ef,p),m(e,oo,p),t(oo,Ro),t(Ro,Om),u(ur,Om,null),t(oo,fy),t(oo,Am),t(Am,_y),m(e,Ff,p),m(e,ve,p),t(ve,by),t(ve,Uc),t(Uc,vy),t(ve,yy),t(ve,Bc),t(Bc,Ty),t(ve,wy),t(ve,Wc),t(Wc,ky),t(ve,$y),m(e,jf,p),m(e,Dc,p),t(Dc,xy),m(e,Lf,p),u(fr,e,p),m(e,zf,p),m(e,Dt,p),t(Dt,My),t(Dt,Hm),t(Hm,Ey),t(Dt,Fy),t(Dt,qc),t(qc,jy),t(Dt,Ly),m(e,Jf,p),m(e,ye,p),t(ye,Pc),t(Pc,Qm),t(Qm,zy),t(Pc,Jy),t(ye,Iy),t(ye,Sc),t(Sc,Ym),t(Ym,Uy),t(Sc,By),t(ye,Wy),t(ye,Vc),t(Vc,Km),t(Km,Dy),t(Vc,qy),t(ye,Py),t(ye,Zc),t(Zc,eh),t(eh,Sy),t(Zc,Vy),m(e,If,p),m(e,P,p),t(P,Zy),t(P,th),t(th,Gy),t(P,Cy),t(P,oh),t(oh,Xy),t(P,Ny),t(P,sh),t(sh,Ry),t(P,Oy),t(P,rh),t(rh,Ay),t(P,Hy),t(P,nh),t(nh,Qy),t(P,Yy),t(P,ah),t(ah,Ky),t(P,eT),m(e,Uf,p),m(e,te,p),t(te,tT),t(te,ih),t(ih,oT),t(te,sT),t(te,ch),t(ch,rT),t(te,nT),t(te,lh),t(lh,aT),t(te,iT),t(te,dh),t(dh,cT),t(te,lT),m(e,Bf,p),m(e,oe,p),t(oe,dT),t(oe,ph),t(ph,pT),t(oe,mT),t(oe,mh),t(mh,hT),t(oe,gT),t(oe,hh),t(hh,uT),t(oe,fT),t(oe,gh),t(gh,_T),t(oe,bT),m(e,Wf,p),u(_r,e,p),m(e,Df,p),m(e,Oo,p),t(Oo,vT),t(Oo,uh),t(uh,yT),t(Oo,TT),m(e,qf,p),m(e,se,p),t(se,wT),t(se,fh),t(fh,kT),t(se,$T),t(se,_h),t(_h,xT),t(se,MT),t(se,bh),t(bh,ET),t(se,FT),t(se,vh),t(vh,jT),t(se,LT),m(e,Pf,p),m(e,Gc,p),t(Gc,zT),m(e,Sf,p),m(e,so,p),t(so,Ao),t(Ao,yh),u(br,yh,null),t(so,JT),t(so,Th),t(Th,IT),m(e,Vf,p),m(e,ro,p),u(vr,ro,null),t(ro,UT),t(ro,wh),t(wh,BT),m(e,Zf,p),m(e,no,p),u(yr,no,null),t(no,WT),t(no,kh),t(kh,DT),m(e,Gf,p),m(e,ao,p),u(Tr,ao,null),t(ao,qT),t(ao,$h),t($h,PT),m(e,Cf,p),m(e,io,p),u(wr,io,null),t(io,ST),t(io,xh),t(xh,VT),m(e,Xf,p),m(e,co,p),u(kr,co,null),t(co,ZT),t(co,Mh),t(Mh,GT),m(e,Nf,p),m(e,lo,p),u($r,lo,null),t(lo,CT),t(lo,Eh),t(Eh,XT),m(e,Rf,p),m(e,po,p),u(xr,po,null),t(po,NT),t(po,Fh),t(Fh,RT),m(e,Of,p),m(e,mo,p),u(Mr,mo,null),t(mo,OT),t(mo,jh),t(jh,AT),m(e,Af,p),m(e,ho,p),u(Er,ho,null),t(ho,HT),t(ho,Lh),t(Lh,QT),m(e,Hf,p),m(e,go,p),u(Fr,go,null),t(go,YT),t(go,zh),t(zh,KT),m(e,Qf,p),m(e,uo,p),t(uo,Ho),t(Ho,Jh),u(jr,Jh,null),t(uo,e1),t(uo,Ih),t(Ih,t1),m(e,Yf,p),m(e,fo,p),u(Lr,fo,null),t(fo,o1),t(fo,Uh),t(Uh,s1),m(e,Kf,p),m(e,_o,p),u(zr,_o,null),t(_o,r1),t(_o,Bh),t(Bh,n1),m(e,e_,p),m(e,bo,p),u(Jr,bo,null),t(bo,a1),t(bo,Wh),t(Wh,i1),m(e,t_,p),m(e,vo,p),u(Ir,vo,null),t(vo,c1),t(vo,Dh),t(Dh,l1),m(e,o_,p),m(e,yo,p),u(Ur,yo,null),t(yo,d1),t(yo,qh),t(qh,p1),m(e,s_,p),m(e,To,p),u(Br,To,null),t(To,m1),t(To,Ph),t(Ph,h1),m(e,r_,p),m(e,wo,p),u(Wr,wo,null),t(wo,g1),t(wo,Sh),t(Sh,u1),m(e,n_,p),m(e,ko,p),u(Dr,ko,null),t(ko,f1),t(ko,Vh),t(Vh,_1),m(e,a_,p),m(e,$o,p),u(qr,$o,null),t($o,b1),t($o,Zh),t(Zh,v1),m(e,i_,p),m(e,xo,p),u(Pr,xo,null),t(xo,y1),t(xo,Gh),t(Gh,T1),m(e,c_,p),m(e,Mo,p),t(Mo,Qo),t(Qo,Ch),u(Sr,Ch,null),t(Mo,w1),t(Mo,Xh),t(Xh,k1),m(e,l_,p),m(e,ze,p),u(Vr,ze,null),t(ze,$1),t(ze,Nh),t(Nh,x1),t(ze,M1),t(ze,Yo),u(Zr,Yo,null),t(Yo,E1),t(Yo,Rh),t(Rh,F1),m(e,d_,p),m(e,Je,p),u(Gr,Je,null),t(Je,j1),t(Je,Oh),t(Oh,L1),t(Je,z1),t(Je,Ko),u(Cr,Ko,null),t(Ko,J1),t(Ko,Ah),t(Ah,I1),m(e,p_,p),m(e,Ie,p),u(Xr,Ie,null),t(Ie,U1),t(Ie,Hh),t(Hh,B1),t(Ie,W1),t(Ie,es),u(Nr,es,null),t(es,D1),t(es,Qh),t(Qh,q1),m(e,m_,p),m(e,Eo,p),t(Eo,ts),t(ts,Yh),u(Rr,Yh,null),t(Eo,P1),t(Eo,Kh),t(Kh,S1),m(e,h_,p),m(e,os,p),t(os,V1),t(os,Cc),t(Cc,Z1),t(os,G1),m(e,g_,p),m(e,Fo,p),t(Fo,ss),t(ss,eg),u(Or,eg,null),t(Fo,C1),t(Fo,tg),t(tg,X1),m(e,u_,p),m(e,Ue,p),u(Ar,Ue,null),t(Ue,N1),t(Ue,rs),t(rs,Xc),t(Xc,R1),t(rs,O1),t(rs,og),t(og,A1),t(rs,H1),t(Ue,Q1),t(Ue,Nc),u(Hr,Nc,null),m(e,f_,p),m(e,Be,p),u(Qr,Be,null),t(Be,Y1),t(Be,Yr),t(Yr,K1),t(Yr,sg),t(sg,e2),t(Yr,t2),t(Be,o2),t(Be,Rc),u(Kr,Rc,null),m(e,__,p),m(e,We,p),u(en,We,null),t(We,s2),t(We,ns),t(ns,Oc),t(Oc,r2),t(ns,n2),t(ns,tn),t(tn,a2),t(ns,i2),t(We,c2),t(We,Ac),u(on,Ac,null),m(e,b_,p),m(e,De,p),u(sn,De,null),t(De,l2),t(De,Hc),t(Hc,Qc),t(Qc,d2),t(Hc,p2),t(De,m2),t(De,Yc),u(rn,Yc,null),m(e,v_,p),m(e,qe,p),u(nn,qe,null),t(qe,h2),t(qe,qt),t(qt,Kc),t(Kc,g2),t(qt,u2),t(qt,rg),t(rg,f2),t(qt,_2),t(qt,an),t(an,b2),t(qt,v2),t(qe,y2),t(qe,el),u(cn,el,null),m(e,y_,p),m(e,de,p),u(ln,de,null),t(de,T2),t(de,B),t(B,tl),t(tl,w2),t(B,k2),t(B,ng),t(ng,$2),t(B,x2),t(B,ag),t(ag,M2),t(B,E2),t(B,ig),t(ig,F2),t(B,j2),t(B,dn),t(dn,L2),t(B,z2),t(B,cg),t(cg,J2),t(B,I2),t(B,lg),t(lg,U2),t(B,B2),t(B,dg),t(dg,W2),t(B,D2),t(de,q2),u(as,de,null),t(de,P2),t(de,ol),u(pn,ol,null),m(e,T_,p),m(e,Pe,p),u(mn,Pe,null),t(Pe,S2),t(Pe,sl),t(sl,rl),t(rl,V2),t(sl,Z2),t(Pe,G2),t(Pe,nl),u(hn,nl,null),m(e,w_,p),m(e,Se,p),u(gn,Se,null),t(Se,C2),t(Se,al),t(al,il),t(il,X2),t(al,N2),t(Se,R2),t(Se,cl),u(un,cl,null),m(e,k_,p),m(e,Ve,p),u(fn,Ve,null),t(Ve,O2),t(Ve,is),t(is,ll),t(ll,A2),t(is,H2),t(is,pg),t(pg,Q2),t(is,Y2),t(Ve,K2),t(Ve,dl),u(_n,dl,null),m(e,$_,p),m(e,Ze,p),u(bn,Ze,null),t(Ze,ew),t(Ze,vn),t(vn,tw),t(vn,mg),t(mg,ow),t(vn,sw),t(Ze,rw),t(Ze,pl),u(yn,pl,null),m(e,x_,p),m(e,Ge,p),u(Tn,Ge,null),t(Ge,nw),t(Ge,Pt),t(Pt,ml),t(ml,aw),t(Pt,iw),t(Pt,hl),t(hl,cw),t(Pt,lw),t(Pt,wn),t(wn,dw),t(Pt,pw),t(Ge,mw),t(Ge,gl),u(kn,gl,null),m(e,M_,p),m(e,Ce,p),u($n,Ce,null),t(Ce,hw),t(Ce,St),t(St,ul),t(ul,gw),t(St,uw),t(St,hg),t(hg,fw),t(St,_w),t(St,gg),t(gg,bw),t(St,vw),t(Ce,yw),t(Ce,fl),u(xn,fl,null),m(e,E_,p),m(e,Xe,p),u(Mn,Xe,null),t(Xe,Tw),t(Xe,cs),t(cs,_l),t(_l,ww),t(cs,kw),t(cs,bl),t(bl,$w),t(cs,xw),t(Xe,Mw),t(Xe,vl),u(En,vl,null),m(e,F_,p),m(e,Ne,p),u(Fn,Ne,null),t(Ne,Ew),t(Ne,ug),t(ug,Fw),t(Ne,jw),t(Ne,yl),u(jn,yl,null),m(e,j_,p),m(e,Re,p),u(Ln,Re,null),t(Re,Lw),t(Re,V),t(V,zw),t(V,Tl),t(Tl,Jw),t(V,Iw),t(V,wl),t(wl,Uw),t(V,Bw),t(V,fg),t(fg,Ww),t(V,Dw),t(V,_g),t(_g,bg),t(bg,qw),t(V,Pw),t(V,kl),t(kl,Sw),t(V,Vw),t(V,$l),t($l,Zw),t(V,Gw),t(Re,Cw),t(Re,xl),u(zn,xl,null),m(e,L_,p),m(e,Oe,p),u(Jn,Oe,null),t(Oe,Xw),t(Oe,vg),t(vg,Nw),t(Oe,Rw),t(Oe,Ml),u(In,Ml,null),m(e,z_,p),m(e,Ae,p),u(Un,Ae,null),t(Ae,Ow),t(Ae,El),t(El,Fl),t(Fl,Aw),t(El,Hw),t(Ae,Qw),t(Ae,jl),u(Bn,jl,null),m(e,J_,p),m(e,pe,p),u(Wn,pe,null),t(pe,Yw),t(pe,Te),t(Te,Ll),t(Ll,Kw),t(Te,ek),t(Te,yg),t(yg,tk),t(Te,ok),t(Te,Tg),t(Tg,sk),t(Te,rk),t(Te,wg),t(wg,nk),t(Te,ak),t(pe,ik),u(ls,pe,null),t(pe,ck),t(pe,zl),u(Dn,zl,null),m(e,I_,p),m(e,R,p),u(qn,R,null),t(R,lk),t(R,Jl),t(Jl,Il),t(Il,dk),t(Jl,pk),t(R,mk),u(ds,R,null),t(R,hk),u(ps,R,null),t(R,gk),t(R,Ul),u(Pn,Ul,null),m(e,U_,p),m(e,O,p),u(Sn,O,null),t(O,uk),t(O,jo),t(jo,fk),t(jo,Bl),t(Bl,_k),t(jo,bk),t(jo,Vn),t(Vn,vk),t(jo,yk),t(O,Tk),u(ms,O,null),t(O,wk),u(hs,O,null),t(O,kk),t(O,Wl),u(Zn,Wl,null),m(e,B_,p),m(e,He,p),u(Gn,He,null),t(He,$k),t(He,gs),t(gs,Dl),t(Dl,xk),t(gs,Mk),t(gs,Cn),t(Cn,Ek),t(gs,Fk),t(He,jk),t(He,ql),u(Xn,ql,null),m(e,W_,p),m(e,me,p),u(Nn,me,null),t(me,Lk),t(me,us),t(us,Pl),t(Pl,zk),t(us,Jk),t(us,Rn),t(Rn,Ik),t(us,Uk),t(me,Bk),u(fs,me,null),t(me,Wk),t(me,Sl),u(On,Sl,null),m(e,D_,p),m(e,A,p),u(An,A,null),t(A,Dk),t(A,Vl),t(Vl,Zl),t(Zl,qk),t(Vl,Pk),t(A,Sk),u(_s,A,null),t(A,Vk),u(bs,A,null),t(A,Zk),t(A,Gl),u(Hn,Gl,null),m(e,q_,p),m(e,Qe,p),u(Qn,Qe,null),t(Qe,Gk),t(Qe,we),t(we,Cl),t(Cl,Ck),t(we,Xk),t(we,kg),t(kg,Nk),t(we,Rk),t(we,$g),t($g,Ok),t(we,Ak),t(we,xg),t(xg,Hk),t(we,Qk),t(Qe,Yk),t(Qe,Xl),u(Yn,Xl,null),m(e,P_,p),m(e,Ye,p),u(Kn,Ye,null),t(Ye,Kk),t(Ye,ea),t(ea,e$),t(ea,Mg),t(Mg,t$),t(ea,o$),t(Ye,s$),t(Ye,Nl),u(ta,Nl,null),m(e,S_,p),m(e,H,p),u(oa,H,null),t(H,r$),t(H,Rl),t(Rl,Ol),t(Ol,n$),t(Rl,a$),t(H,i$),u(vs,H,null),t(H,c$),u(ys,H,null),t(H,l$),t(H,Al),u(sa,Al,null),m(e,V_,p),m(e,Ke,p),u(ra,Ke,null),t(Ke,d$),t(Ke,Hl),t(Hl,Ql),t(Ql,p$),t(Hl,m$),t(Ke,h$),t(Ke,Yl),u(na,Yl,null),m(e,Z_,p),m(e,he,p),u(aa,he,null),t(he,g$),t(he,Kl),t(Kl,ed),t(ed,u$),t(Kl,f$),t(he,_$),u(Ts,he,null),t(he,b$),t(he,td),u(ia,td,null),m(e,G_,p),m(e,et,p),u(ca,et,null),t(et,v$),t(et,ws),t(ws,od),t(od,y$),t(ws,T$),t(ws,la),t(la,w$),t(ws,k$),t(et,$$),t(et,sd),u(da,sd,null),m(e,C_,p),m(e,Q,p),u(pa,Q,null),t(Q,x$),t(Q,tt),t(tt,M$),t(tt,Eg),t(Eg,E$),t(tt,F$),t(tt,Fg),t(Fg,j$),t(tt,L$),t(tt,jg),t(jg,z$),t(tt,J$),t(Q,I$),t(Q,ma),t(ma,U$),t(ma,ha),t(ha,B$),t(ma,W$),t(Q,D$),u(ks,Q,null),t(Q,q$),t(Q,rd),u(ga,rd,null),m(e,X_,p),m(e,ot,p),u(ua,ot,null),t(ot,P$),t(ot,fa),t(fa,S$),t(fa,Lg),t(Lg,V$),t(fa,Z$),t(ot,G$),t(ot,nd),u(_a,nd,null),m(e,N_,p),m(e,Lo,p),t(Lo,$s),t($s,zg),u(ba,zg,null),t(Lo,C$),t(Lo,Jg),t(Jg,X$),m(e,R_,p),m(e,st,p),u(va,st,null),t(st,N$),t(st,ad),t(ad,id),t(id,R$),t(ad,O$),t(st,A$),t(st,cd),u(ya,cd,null),m(e,O_,p),m(e,rt,p),u(Ta,rt,null),t(rt,H$),t(rt,xs),t(xs,ld),t(ld,Q$),t(xs,Y$),t(xs,Ig),t(Ig,K$),t(xs,e0),t(rt,t0),t(rt,dd),u(wa,dd,null),m(e,A_,p),m(e,nt,p),u(ka,nt,null),t(nt,o0),t(nt,zo),t(zo,s0),t(zo,Ug),t(Ug,r0),t(zo,n0),t(zo,Bg),t(Bg,a0),t(zo,i0),t(nt,c0),t(nt,pd),u($a,pd,null),m(e,H_,p),m(e,at,p),u(xa,at,null),t(at,l0),t(at,Wg),t(Wg,d0),t(at,p0),t(at,Ms),u(Ma,Ms,null),t(Ms,m0),t(Ms,Dg),t(Dg,h0),m(e,Q_,p),m(e,it,p),u(Ea,it,null),t(it,g0),t(it,ge),t(ge,u0),t(ge,md),t(md,f0),t(ge,_0),t(ge,qg),t(qg,b0),t(ge,v0),t(ge,Pg),t(Pg,Sg),t(Sg,y0),t(ge,T0),t(ge,hd),t(hd,w0),t(ge,k0),t(it,$0),t(it,gd),u(Fa,gd,null),m(e,Y_,p),m(e,ct,p),u(ja,ct,null),t(ct,x0),t(ct,Vg),t(Vg,M0),t(ct,E0),t(ct,Es),u(La,Es,null),t(Es,F0),t(Es,Zg),t(Zg,j0),m(e,K_,p),m(e,lt,p),u(za,lt,null),t(lt,L0),t(lt,ud),t(ud,fd),t(fd,z0),t(ud,J0),t(lt,I0),t(lt,_d),u(Ja,_d,null),m(e,eb,p),m(e,dt,p),u(Ia,dt,null),t(dt,U0),t(dt,bd),t(bd,vd),t(vd,B0),t(bd,W0),t(dt,D0),t(dt,yd),u(Ua,yd,null),m(e,tb,p),m(e,pt,p),u(Ba,pt,null),t(pt,q0),t(pt,Fs),t(Fs,Td),t(Td,P0),t(Fs,S0),t(Fs,Wa),t(Wa,V0),t(Fs,Z0),t(pt,G0),t(pt,wd),u(Da,wd,null),m(e,ob,p),m(e,mt,p),u(qa,mt,null),t(mt,C0),t(mt,kd),t(kd,$d),t($d,X0),t(kd,N0),t(mt,R0),t(mt,xd),u(Pa,xd,null),m(e,sb,p),m(e,ht,p),u(Sa,ht,null),t(ht,O0),t(ht,ke),t(ke,Md),t(Md,A0),t(ke,H0),t(ke,Gg),t(Gg,Q0),t(ke,Y0),t(ke,Cg),t(Cg,K0),t(ke,e4),t(ke,Xg),t(Xg,t4),t(ke,o4),t(ht,s4),t(ht,Ed),u(Va,Ed,null),m(e,rb,p),m(e,gt,p),u(Za,gt,null),t(gt,r4),t(gt,Ga),t(Ga,n4),t(Ga,Ng),t(Ng,a4),t(Ga,i4),t(gt,c4),t(gt,Fd),u(Ca,Fd,null),m(e,nb,p),m(e,ut,p),u(Xa,ut,null),t(ut,l4),t(ut,jd),t(jd,Ld),t(Ld,d4),t(jd,p4),t(ut,m4),t(ut,zd),u(Na,zd,null),m(e,ab,p),m(e,ft,p),u(Ra,ft,null),t(ft,h4),t(ft,Jd),t(Jd,Id),t(Id,g4),t(Jd,u4),t(ft,f4),t(ft,Ud),u(Oa,Ud,null),m(e,ib,p),m(e,_t,p),u(Aa,_t,null),t(_t,_4),t(_t,Bd),t(Bd,Wd),t(Wd,b4),t(Bd,v4),t(_t,y4),t(_t,Dd),u(Ha,Dd,null),m(e,cb,p),m(e,Jo,p),t(Jo,js),t(js,Rg),u(Qa,Rg,null),t(Jo,T4),t(Jo,Og),t(Og,w4),m(e,lb,p),m(e,bt,p),u(Ya,bt,null),t(bt,k4),t(bt,qd),t(qd,Pd),t(Pd,$4),t(qd,x4),t(bt,M4),t(bt,Sd),u(Ka,Sd,null),m(e,db,p),m(e,vt,p),u(ei,vt,null),t(vt,E4),t(vt,Ls),t(Ls,Vd),t(Vd,F4),t(Ls,j4),t(Ls,Ag),t(Ag,L4),t(Ls,z4),t(vt,J4),t(vt,Zd),u(ti,Zd,null),m(e,pb,p),m(e,yt,p),u(oi,yt,null),t(yt,I4),t(yt,zs),t(zs,Gd),t(Gd,U4),t(zs,B4),t(zs,Hg),t(Hg,W4),t(zs,D4),t(yt,q4),t(yt,Cd),u(si,Cd,null),m(e,mb,p),m(e,Tt,p),u(ri,Tt,null),t(Tt,P4),t(Tt,Qg),t(Qg,S4),t(Tt,V4),t(Tt,Js),u(ni,Js,null),t(Js,Z4),t(Js,Yg),t(Yg,G4),m(e,hb,p),m(e,wt,p),u(ai,wt,null),t(wt,C4),t(wt,Z),t(Z,X4),t(Z,Xd),t(Xd,N4),t(Z,R4),t(Z,Nd),t(Nd,O4),t(Z,A4),t(Z,Kg),t(Kg,H4),t(Z,Q4),t(Z,eu),t(eu,tu),t(tu,Y4),t(Z,K4),t(Z,Rd),t(Rd,ex),t(Z,tx),t(Z,Od),t(Od,ox),t(Z,sx),t(wt,rx),t(wt,Ad),u(ii,Ad,null),m(e,gb,p),m(e,kt,p),u(ci,kt,null),t(kt,nx),t(kt,ou),t(ou,ax),t(kt,ix),t(kt,Is),u(li,Is,null),t(Is,cx),t(Is,su),t(su,lx),m(e,ub,p),m(e,$t,p),u(di,$t,null),t($t,dx),t($t,Hd),t(Hd,Qd),t(Qd,px),t(Hd,mx),t($t,hx),t($t,Yd),u(pi,Yd,null),m(e,fb,p),m(e,xt,p),u(mi,xt,null),t(xt,gx),t(xt,$e),t($e,Kd),t(Kd,ux),t($e,fx),t($e,ru),t(ru,_x),t($e,bx),t($e,nu),t(nu,vx),t($e,yx),t($e,au),t(au,Tx),t($e,wx),t(xt,kx),t(xt,ep),u(hi,ep,null),m(e,_b,p),m(e,Mt,p),u(gi,Mt,null),t(Mt,$x),t(Mt,Us),t(Us,tp),t(tp,xx),t(Us,Mx),t(Us,iu),t(iu,Ex),t(Us,Fx),t(Mt,jx),t(Mt,op),u(ui,op,null),m(e,bb,p),m(e,Et,p),u(fi,Et,null),t(Et,Lx),t(Et,sp),t(sp,rp),t(rp,zx),t(sp,Jx),t(Et,Ix),t(Et,np),u(_i,np,null),m(e,vb,p),m(e,Ft,p),u(bi,Ft,null),t(Ft,Ux),t(Ft,ap),t(ap,ip),t(ip,Bx),t(ap,Wx),t(Ft,Dx),t(Ft,cp),u(vi,cp,null),m(e,yb,p),m(e,jt,p),u(yi,jt,null),t(jt,qx),t(jt,lp),t(lp,dp),t(dp,Px),t(lp,Sx),t(jt,Vx),t(jt,pp),u(Ti,pp,null),m(e,Tb,p),m(e,Lt,p),u(wi,Lt,null),t(Lt,Zx),t(Lt,ki),t(ki,Gx),t(ki,cu),t(cu,Cx),t(ki,Xx),t(Lt,Nx),t(Lt,mp),u($i,mp,null),m(e,wb,p),m(e,Io,p),t(Io,Bs),t(Bs,lu),u(xi,lu,null),t(Io,Rx),t(Io,du),t(du,Ox),m(e,kb,p),m(e,Ws,p),t(Ws,Ax),t(Ws,hp),t(hp,Hx),t(Ws,Qx),m(e,$b,p),m(e,zt,p),u(Mi,zt,null),t(zt,Yx),t(zt,pu),t(pu,Kx),t(zt,eM),t(zt,gp),u(Ei,gp,null),m(e,xb,p),m(e,Uo,p),u(Fi,Uo,null),t(Uo,tM),t(Uo,up),u(ji,up,null),m(e,Mb,p),m(e,Jt,p),u(Li,Jt,null),t(Jt,oM),t(Jt,zi),t(zi,sM),t(zi,mu),t(mu,rM),t(zi,nM),t(Jt,aM),t(Jt,fp),u(Ji,fp,null),m(e,Eb,p),m(e,It,p),u(Ii,It,null),t(It,iM),t(It,Ui),t(Ui,cM),t(Ui,hu),t(hu,lM),t(Ui,dM),t(It,pM),t(It,_p),u(Bi,_p,null),m(e,Fb,p),m(e,Bo,p),t(Bo,Ds),t(Ds,gu),u(Wi,gu,null),t(Bo,mM),t(Bo,uu),t(uu,hM),m(e,jb,p),m(e,qs,p),t(qs,gM),t(qs,bp),t(bp,uM),t(qs,fM),m(e,Lb,p),m(e,L,p),u(Di,L,null),t(L,_M),t(L,fu),t(fu,bM),t(L,vM),t(L,_u),t(_u,yM),t(L,TM),u(Ps,L,null),t(L,wM),t(L,bu),t(bu,kM),t(L,$M),t(L,Ss),u(qi,Ss,null),t(Ss,xM),t(Ss,vu),t(vu,MM),t(L,EM),t(L,Vs),u(Pi,Vs,null),t(Vs,FM),t(Vs,yu),t(yu,jM),t(L,LM),t(L,Zs),u(Si,Zs,null),t(Zs,zM),t(Zs,Tu),t(Tu,JM),t(L,IM),t(L,Gs),u(Vi,Gs,null),t(Gs,UM),t(Gs,Zi),t(Zi,BM),t(Zi,wu),t(wu,WM),t(Zi,DM),t(L,qM),t(L,Cs),u(Gi,Cs,null),t(Cs,PM),t(Cs,ku),t(ku,SM),t(L,VM),t(L,Xs),u(Ci,Xs,null),t(Xs,ZM),t(Xs,$u),t($u,GM),t(L,CM),t(L,Vt),u(Xi,Vt,null),t(Vt,XM),t(Vt,Ni),t(Ni,NM),t(Ni,xu),t(xu,RM),t(Ni,OM),t(Vt,AM),t(Vt,Mu),t(Mu,HM),m(e,zb,p),m(e,Wo,p),u(Ri,Wo,null),t(Wo,QM),t(Wo,vp),t(vp,yp),t(yp,YM),t(vp,KM),m(e,Jb,p),m(e,Do,p),u(Oi,Do,null),t(Do,e3),t(Do,Ai),t(Ai,t3),t(Ai,Tp),t(Tp,o3),t(Ai,s3),m(e,Ib,p),m(e,ue,p),u(Hi,ue,null),t(ue,r3),t(ue,Eu),t(Eu,n3),t(ue,a3),t(ue,X),u(Qi,X,null),t(X,i3),t(X,Fu),t(Fu,c3),t(X,l3),t(X,qo),t(qo,d3),t(qo,ju),t(ju,p3),t(qo,m3),t(qo,Lu),t(Lu,h3),t(qo,g3),t(X,u3),t(X,zu),t(zu,Ju),t(Ju,f3),t(X,_3),t(X,Ut),t(Ut,b3),t(Ut,Iu),t(Iu,v3),t(Ut,y3),t(Ut,Uu),t(Uu,T3),t(Ut,w3),t(Ut,Bu),t(Bu,k3),t(Ut,$3),t(X,x3),t(X,Wu),t(Wu,M3),t(ue,E3),t(ue,Ns),u(Yi,Ns,null),t(Ns,F3),t(Ns,Du),t(Du,j3),m(e,Ub,p),m(e,Po,p),t(Po,Rs),t(Rs,qu),u(Ki,qu,null),t(Po,L3),t(Po,Pu),t(Pu,z3),m(e,Bb,p),m(e,fe,p),u(ec,fe,null),t(fe,J3),t(fe,So),t(So,I3),t(So,wp),t(wp,U3),t(So,B3),t(So,kp),t(kp,W3),t(So,D3),t(fe,q3),t(fe,$p),u(tc,$p,null),t(fe,P3),t(fe,xp),u(oc,xp,null),m(e,Wb,p),m(e,G,p),u(sc,G,null),t(G,S3),t(G,Mp),t(Mp,Ep),t(Ep,V3),t(Mp,Z3),t(G,G3),t(G,rc),t(rc,C3),t(rc,nc),t(nc,X3),t(rc,N3),t(G,R3),t(G,Fp),t(Fp,O3),t(Fp,ac),t(ac,A3),t(G,H3),t(G,jp),u(ic,jp,null),t(G,Q3),t(G,Lp),u(cc,Lp,null),m(e,Db,p),m(e,_e,p),u(lc,_e,null),t(_e,Y3),t(_e,zp),t(zp,Jp),t(Jp,K3),t(zp,eE),t(_e,tE),t(_e,Ip),u(dc,Ip,null),t(_e,oE),t(_e,Up),u(pc,Up,null),m(e,qb,p),m(e,Vo,p),t(Vo,Os),t(Os,Su),u(mc,Su,null),t(Vo,sE),t(Vo,Vu),t(Vu,rE),m(e,Pb,p),m(e,Bt,p),u(hc,Bt,null),t(Bt,nE),t(Bt,Zu),t(Zu,aE),t(Bt,iE),t(Bt,Bp),t(Bp,cE),t(Bp,gc),t(gc,lE),m(e,Sb,p),m(e,Wt,p),u(uc,Wt,null),t(Wt,dE),t(Wt,Gu),t(Gu,pE),t(Wt,mE),t(Wt,Wp),t(Wp,hE),t(Wp,fc),t(fc,gE),m(e,Vb,p),m(e,Zo,p),t(Zo,As),t(As,Cu),u(_c,Cu,null),t(Zo,uE),t(Zo,Xu),t(Xu,fE),m(e,Zb,p),m(e,D,p),u(bc,D,null),t(D,_E),t(D,Nu),t(Nu,bE),t(D,vE),u(Hs,D,null),t(D,yE),u(Qs,D,null),t(D,TE),t(D,Ys),u(vc,Ys,null),t(Ys,wE),t(Ys,Ru),t(Ru,kE),t(D,$E),t(D,Ks),u(yc,Ks,null),t(Ks,xE),t(Ks,Ou),t(Ou,ME),t(D,EE),t(D,er),u(Tc,er,null),t(er,FE),t(er,Au),t(Au,jE),m(e,Gb,p),m(e,Y,p),u(wc,Y,null),t(Y,LE),t(Y,Hu),t(Hu,zE),t(Y,JE),u(tr,Y,null),t(Y,IE),u(or,Y,null),t(Y,UE),t(Y,sr),u(kc,sr,null),t(sr,BE),t(sr,Qu),t(Qu,WE),Cb=!0},p(e,[p]){const $c={};p&2&&($c.$$scope={dirty:p,ctx:e}),as.$set($c);const Yu={};p&2&&(Yu.$$scope={dirty:p,ctx:e}),ls.$set(Yu);const Ku={};p&2&&(Ku.$$scope={dirty:p,ctx:e}),ds.$set(Ku);const ef={};p&2&&(ef.$$scope={dirty:p,ctx:e}),ps.$set(ef);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),ms.$set(U);const tf={};p&2&&(tf.$$scope={dirty:p,ctx:e}),hs.$set(tf);const of={};p&2&&(of.$$scope={dirty:p,ctx:e}),fs.$set(of);const sf={};p&2&&(sf.$$scope={dirty:p,ctx:e}),_s.$set(sf);const rf={};p&2&&(rf.$$scope={dirty:p,ctx:e}),bs.$set(rf);const nf={};p&2&&(nf.$$scope={dirty:p,ctx:e}),vs.$set(nf);const af={};p&2&&(af.$$scope={dirty:p,ctx:e}),ys.$set(af);const cf={};p&2&&(cf.$$scope={dirty:p,ctx:e}),Ts.$set(cf);const lf={};p&2&&(lf.$$scope={dirty:p,ctx:e}),ks.$set(lf);const df={};p&2&&(df.$$scope={dirty:p,ctx:e}),Ps.$set(df);const xc={};p&2&&(xc.$$scope={dirty:p,ctx:e}),Hs.$set(xc);const pf={};p&2&&(pf.$$scope={dirty:p,ctx:e}),Qs.$set(pf);const mf={};p&2&&(mf.$$scope={dirty:p,ctx:e}),tr.$set(mf);const hf={};p&2&&(hf.$$scope={dirty:p,ctx:e}),or.$set(hf)},i(e){Cb||(f(v.$$.fragment,e),f(ur.$$.fragment,e),f(fr.$$.fragment,e),f(_r.$$.fragment,e),f(br.$$.fragment,e),f(vr.$$.fragment,e),f(yr.$$.fragment,e),f(Tr.$$.fragment,e),f(wr.$$.fragment,e),f(kr.$$.fragment,e),f($r.$$.fragment,e),f(xr.$$.fragment,e),f(Mr.$$.fragment,e),f(Er.$$.fragment,e),f(Fr.$$.fragment,e),f(jr.$$.fragment,e),f(Lr.$$.fragment,e),f(zr.$$.fragment,e),f(Jr.$$.fragment,e),f(Ir.$$.fragment,e),f(Ur.$$.fragment,e),f(Br.$$.fragment,e),f(Wr.$$.fragment,e),f(Dr.$$.fragment,e),f(qr.$$.fragment,e),f(Pr.$$.fragment,e),f(Sr.$$.fragment,e),f(Vr.$$.fragment,e),f(Zr.$$.fragment,e),f(Gr.$$.fragment,e),f(Cr.$$.fragment,e),f(Xr.$$.fragment,e),f(Nr.$$.fragment,e),f(Rr.$$.fragment,e),f(Or.$$.fragment,e),f(Ar.$$.fragment,e),f(Hr.$$.fragment,e),f(Qr.$$.fragment,e),f(Kr.$$.fragment,e),f(en.$$.fragment,e),f(on.$$.fragment,e),f(sn.$$.fragment,e),f(rn.$$.fragment,e),f(nn.$$.fragment,e),f(cn.$$.fragment,e),f(ln.$$.fragment,e),f(as.$$.fragment,e),f(pn.$$.fragment,e),f(mn.$$.fragment,e),f(hn.$$.fragment,e),f(gn.$$.fragment,e),f(un.$$.fragment,e),f(fn.$$.fragment,e),f(_n.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(Tn.$$.fragment,e),f(kn.$$.fragment,e),f($n.$$.fragment,e),f(xn.$$.fragment,e),f(Mn.$$.fragment,e),f(En.$$.fragment,e),f(Fn.$$.fragment,e),f(jn.$$.fragment,e),f(Ln.$$.fragment,e),f(zn.$$.fragment,e),f(Jn.$$.fragment,e),f(In.$$.fragment,e),f(Un.$$.fragment,e),f(Bn.$$.fragment,e),f(Wn.$$.fragment,e),f(ls.$$.fragment,e),f(Dn.$$.fragment,e),f(qn.$$.fragment,e),f(ds.$$.fragment,e),f(ps.$$.fragment,e),f(Pn.$$.fragment,e),f(Sn.$$.fragment,e),f(ms.$$.fragment,e),f(hs.$$.fragment,e),f(Zn.$$.fragment,e),f(Gn.$$.fragment,e),f(Xn.$$.fragment,e),f(Nn.$$.fragment,e),f(fs.$$.fragment,e),f(On.$$.fragment,e),f(An.$$.fragment,e),f(_s.$$.fragment,e),f(bs.$$.fragment,e),f(Hn.$$.fragment,e),f(Qn.$$.fragment,e),f(Yn.$$.fragment,e),f(Kn.$$.fragment,e),f(ta.$$.fragment,e),f(oa.$$.fragment,e),f(vs.$$.fragment,e),f(ys.$$.fragment,e),f(sa.$$.fragment,e),f(ra.$$.fragment,e),f(na.$$.fragment,e),f(aa.$$.fragment,e),f(Ts.$$.fragment,e),f(ia.$$.fragment,e),f(ca.$$.fragment,e),f(da.$$.fragment,e),f(pa.$$.fragment,e),f(ks.$$.fragment,e),f(ga.$$.fragment,e),f(ua.$$.fragment,e),f(_a.$$.fragment,e),f(ba.$$.fragment,e),f(va.$$.fragment,e),f(ya.$$.fragment,e),f(Ta.$$.fragment,e),f(wa.$$.fragment,e),f(ka.$$.fragment,e),f($a.$$.fragment,e),f(xa.$$.fragment,e),f(Ma.$$.fragment,e),f(Ea.$$.fragment,e),f(Fa.$$.fragment,e),f(ja.$$.fragment,e),f(La.$$.fragment,e),f(za.$$.fragment,e),f(Ja.$$.fragment,e),f(Ia.$$.fragment,e),f(Ua.$$.fragment,e),f(Ba.$$.fragment,e),f(Da.$$.fragment,e),f(qa.$$.fragment,e),f(Pa.$$.fragment,e),f(Sa.$$.fragment,e),f(Va.$$.fragment,e),f(Za.$$.fragment,e),f(Ca.$$.fragment,e),f(Xa.$$.fragment,e),f(Na.$$.fragment,e),f(Ra.$$.fragment,e),f(Oa.$$.fragment,e),f(Aa.$$.fragment,e),f(Ha.$$.fragment,e),f(Qa.$$.fragment,e),f(Ya.$$.fragment,e),f(Ka.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(oi.$$.fragment,e),f(si.$$.fragment,e),f(ri.$$.fragment,e),f(ni.$$.fragment,e),f(ai.$$.fragment,e),f(ii.$$.fragment,e),f(ci.$$.fragment,e),f(li.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(hi.$$.fragment,e),f(gi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(_i.$$.fragment,e),f(bi.$$.fragment,e),f(vi.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(wi.$$.fragment,e),f($i.$$.fragment,e),f(xi.$$.fragment,e),f(Mi.$$.fragment,e),f(Ei.$$.fragment,e),f(Fi.$$.fragment,e),f(ji.$$.fragment,e),f(Li.$$.fragment,e),f(Ji.$$.fragment,e),f(Ii.$$.fragment,e),f(Bi.$$.fragment,e),f(Wi.$$.fragment,e),f(Di.$$.fragment,e),f(Ps.$$.fragment,e),f(qi.$$.fragment,e),f(Pi.$$.fragment,e),f(Si.$$.fragment,e),f(Vi.$$.fragment,e),f(Gi.$$.fragment,e),f(Ci.$$.fragment,e),f(Xi.$$.fragment,e),f(Ri.$$.fragment,e),f(Oi.$$.fragment,e),f(Hi.$$.fragment,e),f(Qi.$$.fragment,e),f(Yi.$$.fragment,e),f(Ki.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(oc.$$.fragment,e),f(sc.$$.fragment,e),f(ic.$$.fragment,e),f(cc.$$.fragment,e),f(lc.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(hc.$$.fragment,e),f(uc.$$.fragment,e),f(_c.$$.fragment,e),f(bc.$$.fragment,e),f(Hs.$$.fragment,e),f(Qs.$$.fragment,e),f(vc.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(wc.$$.fragment,e),f(tr.$$.fragment,e),f(or.$$.fragment,e),f(kc.$$.fragment,e),Cb=!0)},o(e){_(v.$$.fragment,e),_(ur.$$.fragment,e),_(fr.$$.fragment,e),_(_r.$$.fragment,e),_(br.$$.fragment,e),_(vr.$$.fragment,e),_(yr.$$.fragment,e),_(Tr.$$.fragment,e),_(wr.$$.fragment,e),_(kr.$$.fragment,e),_($r.$$.fragment,e),_(xr.$$.fragment,e),_(Mr.$$.fragment,e),_(Er.$$.fragment,e),_(Fr.$$.fragment,e),_(jr.$$.fragment,e),_(Lr.$$.fragment,e),_(zr.$$.fragment,e),_(Jr.$$.fragment,e),_(Ir.$$.fragment,e),_(Ur.$$.fragment,e),_(Br.$$.fragment,e),_(Wr.$$.fragment,e),_(Dr.$$.fragment,e),_(qr.$$.fragment,e),_(Pr.$$.fragment,e),_(Sr.$$.fragment,e),_(Vr.$$.fragment,e),_(Zr.$$.fragment,e),_(Gr.$$.fragment,e),_(Cr.$$.fragment,e),_(Xr.$$.fragment,e),_(Nr.$$.fragment,e),_(Rr.$$.fragment,e),_(Or.$$.fragment,e),_(Ar.$$.fragment,e),_(Hr.$$.fragment,e),_(Qr.$$.fragment,e),_(Kr.$$.fragment,e),_(en.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(rn.$$.fragment,e),_(nn.$$.fragment,e),_(cn.$$.fragment,e),_(ln.$$.fragment,e),_(as.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(hn.$$.fragment,e),_(gn.$$.fragment,e),_(un.$$.fragment,e),_(fn.$$.fragment,e),_(_n.$$.fragment,e),_(bn.$$.fragment,e),_(yn.$$.fragment,e),_(Tn.$$.fragment,e),_(kn.$$.fragment,e),_($n.$$.fragment,e),_(xn.$$.fragment,e),_(Mn.$$.fragment,e),_(En.$$.fragment,e),_(Fn.$$.fragment,e),_(jn.$$.fragment,e),_(Ln.$$.fragment,e),_(zn.$$.fragment,e),_(Jn.$$.fragment,e),_(In.$$.fragment,e),_(Un.$$.fragment,e),_(Bn.$$.fragment,e),_(Wn.$$.fragment,e),_(ls.$$.fragment,e),_(Dn.$$.fragment,e),_(qn.$$.fragment,e),_(ds.$$.fragment,e),_(ps.$$.fragment,e),_(Pn.$$.fragment,e),_(Sn.$$.fragment,e),_(ms.$$.fragment,e),_(hs.$$.fragment,e),_(Zn.$$.fragment,e),_(Gn.$$.fragment,e),_(Xn.$$.fragment,e),_(Nn.$$.fragment,e),_(fs.$$.fragment,e),_(On.$$.fragment,e),_(An.$$.fragment,e),_(_s.$$.fragment,e),_(bs.$$.fragment,e),_(Hn.$$.fragment,e),_(Qn.$$.fragment,e),_(Yn.$$.fragment,e),_(Kn.$$.fragment,e),_(ta.$$.fragment,e),_(oa.$$.fragment,e),_(vs.$$.fragment,e),_(ys.$$.fragment,e),_(sa.$$.fragment,e),_(ra.$$.fragment,e),_(na.$$.fragment,e),_(aa.$$.fragment,e),_(Ts.$$.fragment,e),_(ia.$$.fragment,e),_(ca.$$.fragment,e),_(da.$$.fragment,e),_(pa.$$.fragment,e),_(ks.$$.fragment,e),_(ga.$$.fragment,e),_(ua.$$.fragment,e),_(_a.$$.fragment,e),_(ba.$$.fragment,e),_(va.$$.fragment,e),_(ya.$$.fragment,e),_(Ta.$$.fragment,e),_(wa.$$.fragment,e),_(ka.$$.fragment,e),_($a.$$.fragment,e),_(xa.$$.fragment,e),_(Ma.$$.fragment,e),_(Ea.$$.fragment,e),_(Fa.$$.fragment,e),_(ja.$$.fragment,e),_(La.$$.fragment,e),_(za.$$.fragment,e),_(Ja.$$.fragment,e),_(Ia.$$.fragment,e),_(Ua.$$.fragment,e),_(Ba.$$.fragment,e),_(Da.$$.fragment,e),_(qa.$$.fragment,e),_(Pa.$$.fragment,e),_(Sa.$$.fragment,e),_(Va.$$.fragment,e),_(Za.$$.fragment,e),_(Ca.$$.fragment,e),_(Xa.$$.fragment,e),_(Na.$$.fragment,e),_(Ra.$$.fragment,e),_(Oa.$$.fragment,e),_(Aa.$$.fragment,e),_(Ha.$$.fragment,e),_(Qa.$$.fragment,e),_(Ya.$$.fragment,e),_(Ka.$$.fragment,e),_(ei.$$.fragment,e),_(ti.$$.fragment,e),_(oi.$$.fragment,e),_(si.$$.fragment,e),_(ri.$$.fragment,e),_(ni.$$.fragment,e),_(ai.$$.fragment,e),_(ii.$$.fragment,e),_(ci.$$.fragment,e),_(li.$$.fragment,e),_(di.$$.fragment,e),_(pi.$$.fragment,e),_(mi.$$.fragment,e),_(hi.$$.fragment,e),_(gi.$$.fragment,e),_(ui.$$.fragment,e),_(fi.$$.fragment,e),_(_i.$$.fragment,e),_(bi.$$.fragment,e),_(vi.$$.fragment,e),_(yi.$$.fragment,e),_(Ti.$$.fragment,e),_(wi.$$.fragment,e),_($i.$$.fragment,e),_(xi.$$.fragment,e),_(Mi.$$.fragment,e),_(Ei.$$.fragment,e),_(Fi.$$.fragment,e),_(ji.$$.fragment,e),_(Li.$$.fragment,e),_(Ji.$$.fragment,e),_(Ii.$$.fragment,e),_(Bi.$$.fragment,e),_(Wi.$$.fragment,e),_(Di.$$.fragment,e),_(Ps.$$.fragment,e),_(qi.$$.fragment,e),_(Pi.$$.fragment,e),_(Si.$$.fragment,e),_(Vi.$$.fragment,e),_(Gi.$$.fragment,e),_(Ci.$$.fragment,e),_(Xi.$$.fragment,e),_(Ri.$$.fragment,e),_(Oi.$$.fragment,e),_(Hi.$$.fragment,e),_(Qi.$$.fragment,e),_(Yi.$$.fragment,e),_(Ki.$$.fragment,e),_(ec.$$.fragment,e),_(tc.$$.fragment,e),_(oc.$$.fragment,e),_(sc.$$.fragment,e),_(ic.$$.fragment,e),_(cc.$$.fragment,e),_(lc.$$.fragment,e),_(dc.$$.fragment,e),_(pc.$$.fragment,e),_(mc.$$.fragment,e),_(hc.$$.fragment,e),_(uc.$$.fragment,e),_(_c.$$.fragment,e),_(bc.$$.fragment,e),_(Hs.$$.fragment,e),_(Qs.$$.fragment,e),_(vc.$$.fragment,e),_(yc.$$.fragment,e),_(Tc.$$.fragment,e),_(wc.$$.fragment,e),_(tr.$$.fragment,e),_(or.$$.fragment,e),_(kc.$$.fragment,e),Cb=!1},d(e){o(T),e&&o(M),e&&o(k),b(v),e&&o(I),e&&o(j),e&&o(Mf),e&&o(Ic),e&&o(Ef),e&&o(oo),b(ur),e&&o(Ff),e&&o(ve),e&&o(jf),e&&o(Dc),e&&o(Lf),b(fr,e),e&&o(zf),e&&o(Dt),e&&o(Jf),e&&o(ye),e&&o(If),e&&o(P),e&&o(Uf),e&&o(te),e&&o(Bf),e&&o(oe),e&&o(Wf),b(_r,e),e&&o(Df),e&&o(Oo),e&&o(qf),e&&o(se),e&&o(Pf),e&&o(Gc),e&&o(Sf),e&&o(so),b(br),e&&o(Vf),e&&o(ro),b(vr),e&&o(Zf),e&&o(no),b(yr),e&&o(Gf),e&&o(ao),b(Tr),e&&o(Cf),e&&o(io),b(wr),e&&o(Xf),e&&o(co),b(kr),e&&o(Nf),e&&o(lo),b($r),e&&o(Rf),e&&o(po),b(xr),e&&o(Of),e&&o(mo),b(Mr),e&&o(Af),e&&o(ho),b(Er),e&&o(Hf),e&&o(go),b(Fr),e&&o(Qf),e&&o(uo),b(jr),e&&o(Yf),e&&o(fo),b(Lr),e&&o(Kf),e&&o(_o),b(zr),e&&o(e_),e&&o(bo),b(Jr),e&&o(t_),e&&o(vo),b(Ir),e&&o(o_),e&&o(yo),b(Ur),e&&o(s_),e&&o(To),b(Br),e&&o(r_),e&&o(wo),b(Wr),e&&o(n_),e&&o(ko),b(Dr),e&&o(a_),e&&o($o),b(qr),e&&o(i_),e&&o(xo),b(Pr),e&&o(c_),e&&o(Mo),b(Sr),e&&o(l_),e&&o(ze),b(Vr),b(Zr),e&&o(d_),e&&o(Je),b(Gr),b(Cr),e&&o(p_),e&&o(Ie),b(Xr),b(Nr),e&&o(m_),e&&o(Eo),b(Rr),e&&o(h_),e&&o(os),e&&o(g_),e&&o(Fo),b(Or),e&&o(u_),e&&o(Ue),b(Ar),b(Hr),e&&o(f_),e&&o(Be),b(Qr),b(Kr),e&&o(__),e&&o(We),b(en),b(on),e&&o(b_),e&&o(De),b(sn),b(rn),e&&o(v_),e&&o(qe),b(nn),b(cn),e&&o(y_),e&&o(de),b(ln),b(as),b(pn),e&&o(T_),e&&o(Pe),b(mn),b(hn),e&&o(w_),e&&o(Se),b(gn),b(un),e&&o(k_),e&&o(Ve),b(fn),b(_n),e&&o($_),e&&o(Ze),b(bn),b(yn),e&&o(x_),e&&o(Ge),b(Tn),b(kn),e&&o(M_),e&&o(Ce),b($n),b(xn),e&&o(E_),e&&o(Xe),b(Mn),b(En),e&&o(F_),e&&o(Ne),b(Fn),b(jn),e&&o(j_),e&&o(Re),b(Ln),b(zn),e&&o(L_),e&&o(Oe),b(Jn),b(In),e&&o(z_),e&&o(Ae),b(Un),b(Bn),e&&o(J_),e&&o(pe),b(Wn),b(ls),b(Dn),e&&o(I_),e&&o(R),b(qn),b(ds),b(ps),b(Pn),e&&o(U_),e&&o(O),b(Sn),b(ms),b(hs),b(Zn),e&&o(B_),e&&o(He),b(Gn),b(Xn),e&&o(W_),e&&o(me),b(Nn),b(fs),b(On),e&&o(D_),e&&o(A),b(An),b(_s),b(bs),b(Hn),e&&o(q_),e&&o(Qe),b(Qn),b(Yn),e&&o(P_),e&&o(Ye),b(Kn),b(ta),e&&o(S_),e&&o(H),b(oa),b(vs),b(ys),b(sa),e&&o(V_),e&&o(Ke),b(ra),b(na),e&&o(Z_),e&&o(he),b(aa),b(Ts),b(ia),e&&o(G_),e&&o(et),b(ca),b(da),e&&o(C_),e&&o(Q),b(pa),b(ks),b(ga),e&&o(X_),e&&o(ot),b(ua),b(_a),e&&o(N_),e&&o(Lo),b(ba),e&&o(R_),e&&o(st),b(va),b(ya),e&&o(O_),e&&o(rt),b(Ta),b(wa),e&&o(A_),e&&o(nt),b(ka),b($a),e&&o(H_),e&&o(at),b(xa),b(Ma),e&&o(Q_),e&&o(it),b(Ea),b(Fa),e&&o(Y_),e&&o(ct),b(ja),b(La),e&&o(K_),e&&o(lt),b(za),b(Ja),e&&o(eb),e&&o(dt),b(Ia),b(Ua),e&&o(tb),e&&o(pt),b(Ba),b(Da),e&&o(ob),e&&o(mt),b(qa),b(Pa),e&&o(sb),e&&o(ht),b(Sa),b(Va),e&&o(rb),e&&o(gt),b(Za),b(Ca),e&&o(nb),e&&o(ut),b(Xa),b(Na),e&&o(ab),e&&o(ft),b(Ra),b(Oa),e&&o(ib),e&&o(_t),b(Aa),b(Ha),e&&o(cb),e&&o(Jo),b(Qa),e&&o(lb),e&&o(bt),b(Ya),b(Ka),e&&o(db),e&&o(vt),b(ei),b(ti),e&&o(pb),e&&o(yt),b(oi),b(si),e&&o(mb),e&&o(Tt),b(ri),b(ni),e&&o(hb),e&&o(wt),b(ai),b(ii),e&&o(gb),e&&o(kt),b(ci),b(li),e&&o(ub),e&&o($t),b(di),b(pi),e&&o(fb),e&&o(xt),b(mi),b(hi),e&&o(_b),e&&o(Mt),b(gi),b(ui),e&&o(bb),e&&o(Et),b(fi),b(_i),e&&o(vb),e&&o(Ft),b(bi),b(vi),e&&o(yb),e&&o(jt),b(yi),b(Ti),e&&o(Tb),e&&o(Lt),b(wi),b($i),e&&o(wb),e&&o(Io),b(xi),e&&o(kb),e&&o(Ws),e&&o($b),e&&o(zt),b(Mi),b(Ei),e&&o(xb),e&&o(Uo),b(Fi),b(ji),e&&o(Mb),e&&o(Jt),b(Li),b(Ji),e&&o(Eb),e&&o(It),b(Ii),b(Bi),e&&o(Fb),e&&o(Bo),b(Wi),e&&o(jb),e&&o(qs),e&&o(Lb),e&&o(L),b(Di),b(Ps),b(qi),b(Pi),b(Si),b(Vi),b(Gi),b(Ci),b(Xi),e&&o(zb),e&&o(Wo),b(Ri),e&&o(Jb),e&&o(Do),b(Oi),e&&o(Ib),e&&o(ue),b(Hi),b(Qi),b(Yi),e&&o(Ub),e&&o(Po),b(Ki),e&&o(Bb),e&&o(fe),b(ec),b(tc),b(oc),e&&o(Wb),e&&o(G),b(sc),b(ic),b(cc),e&&o(Db),e&&o(_e),b(lc),b(dc),b(pc),e&&o(qb),e&&o(Vo),b(mc),e&&o(Pb),e&&o(Bt),b(hc),e&&o(Sb),e&&o(Wt),b(uc),e&&o(Vb),e&&o(Zo),b(_c),e&&o(Zb),e&&o(D),b(bc),b(Hs),b(Qs),b(vc),b(yc),b(Tc),e&&o(Gb),e&&o(Y),b(wc),b(tr),b(or),b(kc)}}}const qI={local:"utilities-for-generation",sections:[{local:"generate-outputs",sections:[{local:"transformers.generation.GreedySearchEncoderDecoderOutput",title:"PyTorch"},{local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",title:"TensorFlow"},{local:"transformers.generation.FlaxSampleOutput",title:"FLAX"}],title:"Generate Outputs"},{local:"logitsprocessor",sections:[{local:"transformers.AlternatingCodebooksLogitsProcessor",title:"PyTorch"},{local:"transformers.TFForcedBOSTokenLogitsProcessor",title:"TensorFlow"},{local:"transformers.FlaxForcedBOSTokenLogitsProcessor",title:"FLAX"}],title:"LogitsProcessor"},{local:"transformers.StoppingCriteria",title:"StoppingCriteria"},{local:"transformers.Constraint",title:"Constraints"},{local:"transformers.BeamScorer",title:"BeamSearch"},{local:"transformers.top_k_top_p_filtering",title:"Utilities"},{local:"transformers.TextStreamer",title:"Streamers"}],title:"Utilities for Generation"};function PI(E){return bI(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class NI extends gI{constructor(T){super();uI(this,T,PI,DI,fI,{})}}export{NI as default,qI as metadata};
