import{s as gl,o as _l,n as I}from"../chunks/scheduler.9bc65507.js";import{S as Ml,i as yl,g as s,s as l,u as g,A as Tl,h as a,f as t,c as i,j as f,v as _,y as m,k as u,o as n,a as c,w as M,d as y,t as T,x as b}from"../chunks/index.78c82d43.js";import{T as ct}from"../chunks/Tip.87d55b76.js";import{D as F}from"../chunks/Docstring.f3d04bd2.js";import{C as P}from"../chunks/CodeBlock.48618ec2.js";import{I as N}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Te}from"../chunks/ExampleCodeBlock.872b014d.js";function bl(j){let r,w="Examples:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmlhbk1vZGVsJTJDJTIwTWFyaWFuQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1hcmlhbiUyMEhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtZW4tZGUlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFyaWFuQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwSGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1kZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFyaWFuTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarianModel, MarianConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Marian Helsinki-NLP/opus-mt-en-de style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MarianConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Helsinki-NLP/opus-mt-en-de style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function vl(j){let r,w="Examples:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmlhbkZvckNhdXNhbExNJTJDJTIwTWFyaWFuVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBNYXJpYW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1kZSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBNYXJpYW5Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtZW4tZGUlMjIpJTBBc3JjX3RleHRzJTIwJTNEJTIwJTVCJTIySSUyMGFtJTIwYSUyMHNtYWxsJTIwZnJvZy4lMjIlMkMlMjAlMjJUb20lMjBhc2tlZCUyMGhpcyUyMHRlYWNoZXIlMjBmb3IlMjBhZHZpY2UuJTIyJTVEJTBBdGd0X3RleHRzJTIwJTNEJTIwJTVCJTIySWNoJTIwYmluJTIwZWluJTIwa2xlaW5lciUyMEZyb3NjaC4lMjIlMkMlMjAlMjJUb20lMjBiYXQlMjBzZWluZW4lMjBMZWhyZXIlMjB1bSUyMFJhdC4lMjIlNUQlMjAlMjAlMjMlMjBvcHRpb25hbCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihzcmNfdGV4dHMlMkMlMjB0ZXh0X3RhcmdldCUzRHRndF90ZXh0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTIwJTIwJTIzJTIwc2hvdWxkJTIwd29yaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarianForCausalLM, MarianTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianForCausalLM.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = MarianTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>src_texts = [<span class="hljs-string">&quot;I am a small frog.&quot;</span>, <span class="hljs-string">&quot;Tom asked his teacher for advice.&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tgt_texts = [<span class="hljs-string">&quot;Ich bin ein kleiner Frosch.&quot;</span>, <span class="hljs-string">&quot;Tom bat seinen Lehrer um Rat.&quot;</span>]  <span class="hljs-comment"># optional</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(src_texts, text_target=tgt_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)  <span class="hljs-comment"># should work</span>`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function kl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function wl(j){let r,w="Example:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYXJpYW5Nb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtZW4tZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXJpYW5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1kZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZGVjb2Rlcl9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyJTNDcGFkJTNFJTIwU3R1ZGllbiUyMGhhYmVuJTIwZ2V6ZWlndCUyMGRhc3MlMjBlcyUyMGhpbGZyZWljaCUyMGlzdCUyMGVpbmVuJTIwSHVuZCUyMHp1JTIwYmVzaXR6ZW4lMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cy5pbnB1dF9pZHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRzLmlucHV0X2lkcyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MarianModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianModel.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&lt;pad&gt; Studien haben gezeigt dass es hilfreich ist einen Hund zu besitzen&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>    add_special_tokens=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs.input_ids, decoder_input_ids=decoder_inputs.input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">26</span>, <span class="hljs-number">512</span>]`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function xl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function jl(j){let r,w="Examples:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYXJpYW5NVE1vZGVsJTBBJTBBc3JjJTIwJTNEJTIwJTIyZnIlMjIlMjAlMjAlMjMlMjBzb3VyY2UlMjBsYW5ndWFnZSUwQXRyZyUyMCUzRCUyMCUyMmVuJTIyJTIwJTIwJTIzJTIwdGFyZ2V0JTIwbGFuZ3VhZ2UlMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwZiUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtJTdCc3JjJTdELSU3QnRyZyU3RCUyMiUwQW1vZGVsJTIwJTNEJTIwTWFyaWFuTVRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQXNhbXBsZV90ZXh0JTIwJTNEJTIwJTIybyVDMyVCOSUyMGVzdCUyMGwnYXJyJUMzJUFBdCUyMGRlJTIwYnVzJTIwJTNGJTIyJTBBYmF0Y2glMjAlM0QlMjB0b2tlbml6ZXIoJTVCc2FtcGxlX3RleHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmJhdGNoKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MarianMTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>src = <span class="hljs-string">&quot;fr&quot;</span>  <span class="hljs-comment"># source language</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>trg = <span class="hljs-string">&quot;en&quot;</span>  <span class="hljs-comment"># target language</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">f&quot;Helsinki-NLP/opus-mt-<span class="hljs-subst">{src}</span>-<span class="hljs-subst">{trg}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianMTModel.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_text = <span class="hljs-string">&quot;où est l&#x27;arrêt de bus ?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = tokenizer([sample_text], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**batch)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Where&#x27;s the bus stop?&quot;</span>`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function Jl(j){let r,w="Example:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYXJpYW5Gb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtZnItZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXJpYW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1mci1lbiUyMiUyQyUyMGFkZF9jcm9zc19hdHRlbnRpb24lM0RGYWxzZSklMEFhc3NlcnQlMjBtb2RlbC5jb25maWcuaXNfZGVjb2RlciUyQyUyMGYlMjIlN0Jtb2RlbC5fX2NsYXNzX18lN0QlMjBoYXMlMjB0byUyMGJlJTIwY29uZmlndXJlZCUyMGFzJTIwYSUyMGRlY29kZXIuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWV4cGVjdGVkX3NoYXBlJTIwJTNEJTIwJTVCMSUyQyUyMGlucHV0cy5pbnB1dF9pZHMuc2hhcGUlNUItMSU1RCUyQyUyMG1vZGVsLmNvbmZpZy52b2NhYl9zaXplJTVEJTBBbGlzdChsb2dpdHMuc2hhcGUpJTIwJTNEJTNEJTIwZXhwZWN0ZWRfc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MarianForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-fr-en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianForCausalLM.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-fr-en&quot;</span>, add_cross_attention=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> model.config.is_decoder, <span class="hljs-string">f&quot;<span class="hljs-subst">{model.__class__}</span> has to be configured as a decoder.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>expected_shape = [<span class="hljs-number">1</span>, inputs.input_ids.shape[-<span class="hljs-number">1</span>], model.config.vocab_size]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape) == expected_shape
<span class="hljs-literal">True</span>`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function $l(j){let r,w="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",h,p,v="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,k,V=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,A,z,be=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,H,$,ve=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){r=s("p"),r.innerHTML=w,h=l(),p=s("ul"),p.innerHTML=v,o=l(),k=s("p"),k.innerHTML=V,A=l(),z=s("ul"),z.innerHTML=be,H=l(),$=s("p"),$.innerHTML=ve},l(x){r=a(x,"P",{"data-svelte-h":!0}),m(r)!=="svelte-1ajbfxg"&&(r.innerHTML=w),h=i(x),p=a(x,"UL",{"data-svelte-h":!0}),m(p)!=="svelte-qm1t26"&&(p.innerHTML=v),o=i(x),k=a(x,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1v9qsc5"&&(k.innerHTML=V),A=i(x),z=a(x,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-15scerc"&&(z.innerHTML=be),H=i(x),$=a(x,"P",{"data-svelte-h":!0}),m($)!=="svelte-1an3odd"&&($.innerHTML=ve)},m(x,J){c(x,r,J),c(x,h,J),c(x,p,J),c(x,o,J),c(x,k,J),c(x,A,J),c(x,z,J),c(x,H,J),c(x,$,J)},p:I,d(x){x&&(t(r),t(h),t(p),t(o),t(k),t(A),t(z),t(H),t($))}}}function zl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function Ul(j){let r,w="Example:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk1hcmlhbk1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWRlJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZNYXJpYW5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1kZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFMarianModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMarianModel.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function Cl(j){let r,w="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",h,p,v="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,k,V=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,A,z,be=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,H,$,ve=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){r=s("p"),r.innerHTML=w,h=l(),p=s("ul"),p.innerHTML=v,o=l(),k=s("p"),k.innerHTML=V,A=l(),z=s("ul"),z.innerHTML=be,H=l(),$=s("p"),$.innerHTML=ve},l(x){r=a(x,"P",{"data-svelte-h":!0}),m(r)!=="svelte-1ajbfxg"&&(r.innerHTML=w),h=i(x),p=a(x,"UL",{"data-svelte-h":!0}),m(p)!=="svelte-qm1t26"&&(p.innerHTML=v),o=i(x),k=a(x,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1v9qsc5"&&(k.innerHTML=V),A=i(x),z=a(x,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-15scerc"&&(z.innerHTML=be),H=i(x),$=a(x,"P",{"data-svelte-h":!0}),m($)!=="svelte-1an3odd"&&($.innerHTML=ve)},m(x,J){c(x,r,J),c(x,h,J),c(x,p,J),c(x,o,J),c(x,k,J),c(x,A,J),c(x,z,J),c(x,H,J),c(x,$,J)},p:I,d(x){x&&(t(r),t(h),t(p),t(o),t(k),t(A),t(z),t(H),t($))}}}function Fl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function Il(j){let r,w="Examples:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk1hcmlhbk1UTW9kZWwlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQXNyYyUyMCUzRCUyMCUyMmZyJTIyJTIwJTIwJTIzJTIwc291cmNlJTIwbGFuZ3VhZ2UlMEF0cmclMjAlM0QlMjAlMjJlbiUyMiUyMCUyMCUyMyUyMHRhcmdldCUyMGxhbmd1YWdlJTBBc2FtcGxlX3RleHQlMjAlM0QlMjAlMjJvJUMzJUI5JTIwZXN0JTIwbCdhcnIlQzMlQUF0JTIwZGUlMjBidXMlMjAlM0YlMjIlMEFtb2RlbF9uYW1lJTIwJTNEJTIwZiUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtJTdCc3JjJTdELSU3QnRyZyU3RCUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwVEZNYXJpYW5NVE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBYmF0Y2glMjAlM0QlMjB0b2tlbml6ZXIoJTVCc2FtcGxlX3RleHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbiUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqYmF0Y2gpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW4lMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFMarianMTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>src = <span class="hljs-string">&quot;fr&quot;</span>  <span class="hljs-comment"># source language</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>trg = <span class="hljs-string">&quot;en&quot;</span>  <span class="hljs-comment"># target language</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_text = <span class="hljs-string">&quot;où est l&#x27;arrêt de bus ?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">f&quot;Helsinki-NLP/opus-mt-<span class="hljs-subst">{src}</span>-<span class="hljs-subst">{trg}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMarianMTModel.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = tokenizer([sample_text], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = model.generate(**batch)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Where is the bus stop ?&quot;</span>`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function Nl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function ql(j){let r,w="Example:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4TWFyaWFuTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWRlJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheE1hcmlhbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWRlJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJqYXglMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxMarianModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMarianModel.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function Zl(j){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=s("p"),r.innerHTML=w},l(h){r=a(h,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(h,p){c(h,r,p)},p:I,d(h){h&&t(r)}}}function Wl(j){let r,w="Example:",h,p,v;return p=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4TWFyaWFuTVRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwRmxheE1hcmlhbk1UTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkhlbHNpbmtpLU5MUCUyRm9wdXMtbXQtZW4tZGUlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1kZSUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyTXklMjBmcmllbmRzJTIwYXJlJTIwY29vbCUyMGJ1dCUyMHRoZXklMjBlYXQlMjB0b28lMjBtYW55JTIwY2FyYnMuJTIyJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjBtYXhfbGVuZ3RoJTNENjQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMmpheCUyMikuaW5wdXRfaWRzJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDY0JTJDJTIwbnVtX2JlYW1zJTNEMikuc2VxdWVuY2VzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIzJTIwc2hvdWxkJTIwZ2l2ZSUyMCpNZWluZSUyMEZyZXVuZGUlMjBzaW5kJTIwY29vbCUyQyUyMGFiZXIlMjBzaWUlMjBlc3NlbiUyMHp1JTIwdmllbGUlMjBLb2hsZW5oeWRyYXRlLio=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxMarianMTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMarianMTModel.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(text, max_length=<span class="hljs-number">64</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = model.generate(input_ids, max_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">2</span>).sequences

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(sequences, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># should give *Meine Freunde sind cool, aber sie essen zu viele Kohlenhydrate.*</span>`}}),{c(){r=s("p"),r.textContent=w,h=l(),g(p.$$.fragment)},l(o){r=a(o,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=w),h=i(o),_(p.$$.fragment,o)},m(o,k){c(o,r,k),c(o,h,k),M(p,o,k),v=!0},p:I,i(o){v||(y(p.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),v=!1},d(o){o&&(t(r),t(h)),b(p,o)}}}function Hl(j){let r,w,h,p,v,o,k,V,A,z,be="MarianMT",H,$,ve='<a href="https://huggingface.co/models?filter=marian"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-marian-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/opus-mt-zh-en"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',x,J,Pa=`<strong>Bugs:</strong> If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=sshleifer&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>
and assign @patrickvonplaten.`,Uo,pt,Ba="Translations should be similar, but not identical to output in the test set linked to in each model card.",Co,ht,Xa="Tips:",Fo,ut,Qa="<li>A framework for translation models, using the same models as BART.</li>",Io,se,ke,no,mt,Cs,hn,Ya="Implementation Notes",No,ft,Oa=`<li><p>Each model is about 298 MB on disk, there are more than 1,000 models.</p></li> <li><p>The list of supported language pairs can be found <a href="https://huggingface.co/Helsinki-NLP" rel="nofollow">here</a>.</p></li> <li><p>Models were originally trained by <a href="https://researchportal.helsinki.fi/en/persons/j%C3%B6rg-tiedemann" rel="nofollow">Jörg Tiedemann</a> using the <a href="https://marian-nmt.github.io/" rel="nofollow">Marian</a> C++ library, which supports fast training and translation.</p></li> <li><p>All models are transformer encoder-decoders with 6 layers in each component. Each model’s performance is documented
in a model card.</p></li> <li><p>The 80 opus models that require BPE preprocessing are not supported.</p></li> <li><p>The modeling code is the same as <a href="/docs/transformers/v4.33.3/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> with a few minor modifications:</p> <ul><li>static (sinusoid) positional embeddings (<code>MarianConfig.static_position_embeddings=True</code>)</li> <li>no layernorm_embedding (<code>MarianConfig.normalize_embedding=False</code>)</li> <li>the model starts generating with <code>pad_token_id</code> (which has 0 as a token_embedding) as the prefix (Bart uses
<code>&lt;s/&gt;</code>),</li></ul></li> <li><p>Code to bulk convert models can be found in <code>convert_marian_to_pytorch.py</code>.</p></li> <li><p>This model was contributed by <a href="https://huggingface.co/sshleifer" rel="nofollow">sshleifer</a>.</p></li>`,qo,ae,we,oo,gt,Fs,un,Da="Naming",Zo,_t,Ka=`<li>All model names use the following format: <code>Helsinki-NLP/opus-mt-{src}-{tgt}</code></li> <li>The language codes used to name models are inconsistent. Two digit codes can usually be found <a href="https://developers.google.com/admin-sdk/directory/v1/languages" rel="nofollow">here</a>, three digit codes require googling “language
code {code}“.</li> <li>Codes formatted like <code>es_AR</code> are usually <code>code_{region}</code>. That one is Spanish from Argentina.</li> <li>The models were converted in two stages. The first 1000 models use ISO-639-2 codes to identify languages, the second
group use a combination of ISO-639-5 codes and ISO-639-2 codes.</li>`,Wo,re,xe,so,Mt,Is,mn,er="Examples",Ho,yt,tr=`<li>Since Marian models are smaller than many other translation models available in the library, they can be useful for
fine-tuning experiments and integration tests.</li> <li><a href="https://github.com/huggingface/transformers/blob/master/examples/legacy/seq2seq/train_distil_marian_enro.sh" rel="nofollow">Fine-tune on GPU</a></li>`,So,le,je,ao,Tt,Ns,fn,nr="Multilingual Models",Lo,bt,or=`<li>All model names use the following format: <code>Helsinki-NLP/opus-mt-{src}-{tgt}</code>:</li> <li>If a model can output multiple languages, and you should specify a language code by prepending the desired output
language to the <code>src_text</code>.</li> <li>You can see a models’s supported language codes in its model card, under target constituents, like in <a href="https://huggingface.co/Helsinki-NLP/opus-mt-en-roa" rel="nofollow">opus-mt-en-roa</a>.</li> <li>Note that if a model is only multilingual on the source side, like <code>Helsinki-NLP/opus-mt-roa-en</code>, no language
codes are required.</li>`,Vo,vt,sr=`New multi-lingual models from the <a href="https://github.com/Helsinki-NLP/Tatoeba-Challenge" rel="nofollow">Tatoeba-Challenge repo</a>
require 3 character language codes:`,Ao,kt,Ro,wt,ar="Here is the code to see all available pretrained models on the hub:",Go,xt,Eo,ie,Je,ro,jt,qs,gn,rr="Old Style Multi-Lingual Models",Po,Jt,lr=`These are the old style multi-lingual models ported from the OPUS-MT-Train repo: and the members of each language
group:`,Bo,$t,Xo,zt,ir="Example of translating english to many romance languages, using old-style 2 character language codes",Qo,Ut,Yo,de,$e,lo,Ct,Zs,_n,dr="Documentation resources",Oo,Ft,cr='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',Do,ce,ze,io,It,Ws,Mn,pr="MarianConfig",Ko,R,Nt,Hs,yn,hr=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianModel">MarianModel</a>. It is used to instantiate an
Marian model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Marian
<a href="https://huggingface.co/Helsinki-NLP/opus-mt-en-de" rel="nofollow">Helsinki-NLP/opus-mt-en-de</a> architecture.`,Ss,Tn,ur=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ls,Ue,es,pe,Ce,co,qt,Vs,bn,mr="MarianTokenizer",ts,q,Zt,As,vn,fr='Construct a Marian tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',Rs,kn,gr=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Gs,Fe,Es,Ie,Wt,Ps,wn,_r="Build model inputs from a sequence by appending eos_token_id.",ns,he,Ne,po,Ht,Bs,xn,Mr="MarianModel",os,G,St,Xs,jn,yr=`The bare Marian Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qs,Jn,Tr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ys,B,Lt,Os,$n,br='The <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianModel">MarianModel</a> forward method, overrides the <code>__call__</code> special method.',Ds,qe,Ks,Ze,ss,ue,We,ho,Vt,ea,zn,vr="MarianMTModel",as,E,At,ta,Un,kr=`The Marian Model with a language modeling head. Can be used for summarization.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,na,Cn,wr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oa,S,Rt,sa,Fn,xr='The <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianMTModel">MarianMTModel</a> forward method, overrides the <code>__call__</code> special method.',aa,He,ra,In,jr=`Pytorch version of marian-nmt’s transformer.h (c++). Designed for the OPUS-NMT translation checkpoints. Available
models are listed <a href="https://huggingface.co/models?search=Helsinki-NLP" rel="nofollow">here</a>.`,la,Se,rs,me,Le,uo,Gt,ia,Nn,Jr="MarianForCausalLM",ls,fe,Et,da,Ve,Pt,ca,Ae,is,ge,Re,mo,Bt,pa,qn,$r="TFMarianModel",ds,Z,Xt,ha,Zn,zr=`The bare MARIAN Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ua,Wn,Ur=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,ma,Ge,fa,X,Qt,ga,Hn,Cr='The <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> forward method, overrides the <code>__call__</code> special method.',_a,Ee,Ma,Pe,cs,_e,Be,fo,Yt,ya,Sn,Fr="TFMarianMTModel",ps,W,Ot,Ta,Ln,Ir=`The MARIAN Model with a language modeling head. Can be used for summarization.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ba,Vn,Nr=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,va,Xe,ka,L,Dt,wa,An,qr='The <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.TFMarianMTModel">TFMarianMTModel</a> forward method, overrides the <code>__call__</code> special method.',xa,Qe,ja,Rn,Zr=`TF version of marian-nmt’s transformer.h (c++). Designed for the OPUS-NMT translation checkpoints. Available
models are listed <a href="https://huggingface.co/models?search=Helsinki-NLP" rel="nofollow">here</a>.`,Ja,Ye,hs,Me,Oe,go,Kt,$a,Gn,Wr="FlaxMarianModel",us,U,en,za,En,Hr=`The bare Marian Model transformer outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ua,Pn,Sr=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,Ca,Bn,Lr="Finally, this model supports inherent JAX features such as:",Fa,Xn,Vr='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ia,Q,tn,Na,Qn,Ar="The <code>FlaxMarianPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",qa,De,Za,Ke,ms,ye,et,_o,nn,Wa,Yn,Rr="FlaxMarianMTModel",fs,C,on,Ha,On,Gr=`The MARIAN Model with a language modeling head. Can be used for translation.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Sa,Dn,Er=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,La,Kn,Pr="Finally, this model supports inherent JAX features such as:",Va,eo,Br='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Aa,Y,sn,Ra,to,Xr="The <code>FlaxMarianPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Ga,tt,Ea,nt,gs,Mo,_s;return V=new N({}),mt=new N({}),gt=new N({}),Mt=new N({}),Tt=new N({}),kt=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmlhbk1UTW9kZWwlMkMlMjBNYXJpYW5Ub2tlbml6ZXIlMEElMEFzcmNfdGV4dCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMiUzRSUzRWZyYSUzQyUzQyUyMHRoaXMlMjBpcyUyMGElMjBzZW50ZW5jZSUyMGluJTIwZW5nbGlzaCUyMHRoYXQlMjB3ZSUyMHdhbnQlMjB0byUyMHRyYW5zbGF0ZSUyMHRvJTIwZnJlbmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTNFJTNFcG9yJTNDJTNDJTIwVGhpcyUyMHNob3VsZCUyMGdvJTIwdG8lMjBwb3J0dWd1ZXNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTNFJTNFZXNwJTNDJTNDJTIwQW5kJTIwdGhpcyUyMHRvJTIwU3BhbmlzaCUyMiUyQyUwQSU1RCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLXJvYSUyMiUwQXRva2VuaXplciUyMCUzRCUyME1hcmlhblRva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFwcmludCh0b2tlbml6ZXIuc3VwcG9ydGVkX2xhbmd1YWdlX2NvZGVzKSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFyaWFuTVRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEF0cmFuc2xhdGVkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip0b2tlbml6ZXIoc3JjX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpKSUwQSU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMHRyYW5zbGF0ZWQlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarianMTModel, MarianTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>src_text = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;fra&lt;&lt; this is a sentence in english that we want to translate to french&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;por&lt;&lt; This should go to portuguese&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;esp&lt;&lt; And this to Spanish&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-roa&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = MarianTokenizer.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.supported_language_codes)
[<span class="hljs-string">&#x27;&gt;&gt;zlm_Latn&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;mfe&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;hat&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;pap&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;ast&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;cat&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;ind&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;glg&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;wln&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;spa&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;fra&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;ron&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;por&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;ita&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;oci&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;arg&lt;&lt;&#x27;</span>, <span class="hljs-string">&#x27;&gt;&gt;min&lt;&lt;&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianMTModel.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>translated = model.generate(**tokenizer(src_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>[tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> translated]
[<span class="hljs-string">&quot;c&#x27;est une phrase en anglais que nous voulons traduire en français&quot;</span>,
 <span class="hljs-string">&#x27;Isto deve ir para o português.&#x27;</span>,
 <span class="hljs-string">&#x27;Y esto al español&#x27;</span>]`}}),xt=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbW9kZWxzJTBBJTBBbW9kZWxfbGlzdCUyMCUzRCUyMGxpc3RfbW9kZWxzKCklMEFvcmclMjAlM0QlMjAlMjJIZWxzaW5raS1OTFAlMjIlMEFtb2RlbF9pZHMlMjAlM0QlMjAlNUJ4Lm1vZGVsSWQlMjBmb3IlMjB4JTIwaW4lMjBtb2RlbF9saXN0JTIwaWYlMjB4Lm1vZGVsSWQuc3RhcnRzd2l0aChvcmcpJTVEJTBBc3VmZml4JTIwJTNEJTIwJTVCeC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCUyMGZvciUyMHglMjBpbiUyMG1vZGVsX2lkcyU1RCUwQW9sZF9zdHlsZV9tdWx0aV9tb2RlbHMlMjAlM0QlMjAlNUJmJTIyJTdCb3JnJTdEJTJGJTdCcyU3RCUyMiUyMGZvciUyMHMlMjBpbiUyMHN1ZmZpeCUyMGlmJTIwcyUyMCElM0QlMjBzLmxvd2VyKCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

model_list = list_models()
org = <span class="hljs-string">&quot;Helsinki-NLP&quot;</span>
model_ids = [x.modelId <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> model_list <span class="hljs-keyword">if</span> x.modelId.startswith(org)]
suffix = [x.split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> model_ids]
old_style_multi_models = [<span class="hljs-string">f&quot;<span class="hljs-subst">{org}</span>/<span class="hljs-subst">{s}</span>&quot;</span> <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> suffix <span class="hljs-keyword">if</span> s != s.lower()]`}}),jt=new N({}),$t=new P({props:{code:"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",highlighted:`[<span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-NORTH_EU-NORTH_EU&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-ROMANCE-en&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-SCANDINAVIA-SCANDINAVIA&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-de-ZH&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-en-CELTIC&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-en-ROMANCE&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-es-NORWAY&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-fi-NORWAY&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-fi-ZH&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-fi_nb_no_nn_ru_sv_en-SAMI&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-sv-NORWAY&#x27;</span>,
 <span class="hljs-string">&#x27;Helsinki-NLP/opus-mt-sv-ZH&#x27;</span>]
GROUP_MEMBERS = {
 <span class="hljs-string">&#x27;ZH&#x27;</span>: [<span class="hljs-string">&#x27;cmn&#x27;</span>, <span class="hljs-string">&#x27;cn&#x27;</span>, <span class="hljs-string">&#x27;yue&#x27;</span>, <span class="hljs-string">&#x27;ze_zh&#x27;</span>, <span class="hljs-string">&#x27;zh_cn&#x27;</span>, <span class="hljs-string">&#x27;zh_CN&#x27;</span>, <span class="hljs-string">&#x27;zh_HK&#x27;</span>, <span class="hljs-string">&#x27;zh_tw&#x27;</span>, <span class="hljs-string">&#x27;zh_TW&#x27;</span>, <span class="hljs-string">&#x27;zh_yue&#x27;</span>, <span class="hljs-string">&#x27;zhs&#x27;</span>, <span class="hljs-string">&#x27;zht&#x27;</span>, <span class="hljs-string">&#x27;zh&#x27;</span>],
 <span class="hljs-string">&#x27;ROMANCE&#x27;</span>: [<span class="hljs-string">&#x27;fr&#x27;</span>, <span class="hljs-string">&#x27;fr_BE&#x27;</span>, <span class="hljs-string">&#x27;fr_CA&#x27;</span>, <span class="hljs-string">&#x27;fr_FR&#x27;</span>, <span class="hljs-string">&#x27;wa&#x27;</span>, <span class="hljs-string">&#x27;frp&#x27;</span>, <span class="hljs-string">&#x27;oc&#x27;</span>, <span class="hljs-string">&#x27;ca&#x27;</span>, <span class="hljs-string">&#x27;rm&#x27;</span>, <span class="hljs-string">&#x27;lld&#x27;</span>, <span class="hljs-string">&#x27;fur&#x27;</span>, <span class="hljs-string">&#x27;lij&#x27;</span>, <span class="hljs-string">&#x27;lmo&#x27;</span>, <span class="hljs-string">&#x27;es&#x27;</span>, <span class="hljs-string">&#x27;es_AR&#x27;</span>, <span class="hljs-string">&#x27;es_CL&#x27;</span>, <span class="hljs-string">&#x27;es_CO&#x27;</span>, <span class="hljs-string">&#x27;es_CR&#x27;</span>, <span class="hljs-string">&#x27;es_DO&#x27;</span>, <span class="hljs-string">&#x27;es_EC&#x27;</span>, <span class="hljs-string">&#x27;es_ES&#x27;</span>, <span class="hljs-string">&#x27;es_GT&#x27;</span>, <span class="hljs-string">&#x27;es_HN&#x27;</span>, <span class="hljs-string">&#x27;es_MX&#x27;</span>, <span class="hljs-string">&#x27;es_NI&#x27;</span>, <span class="hljs-string">&#x27;es_PA&#x27;</span>, <span class="hljs-string">&#x27;es_PE&#x27;</span>, <span class="hljs-string">&#x27;es_PR&#x27;</span>, <span class="hljs-string">&#x27;es_SV&#x27;</span>, <span class="hljs-string">&#x27;es_UY&#x27;</span>, <span class="hljs-string">&#x27;es_VE&#x27;</span>, <span class="hljs-string">&#x27;pt&#x27;</span>, <span class="hljs-string">&#x27;pt_br&#x27;</span>, <span class="hljs-string">&#x27;pt_BR&#x27;</span>, <span class="hljs-string">&#x27;pt_PT&#x27;</span>, <span class="hljs-string">&#x27;gl&#x27;</span>, <span class="hljs-string">&#x27;lad&#x27;</span>, <span class="hljs-string">&#x27;an&#x27;</span>, <span class="hljs-string">&#x27;mwl&#x27;</span>, <span class="hljs-string">&#x27;it&#x27;</span>, <span class="hljs-string">&#x27;it_IT&#x27;</span>, <span class="hljs-string">&#x27;co&#x27;</span>, <span class="hljs-string">&#x27;nap&#x27;</span>, <span class="hljs-string">&#x27;scn&#x27;</span>, <span class="hljs-string">&#x27;vec&#x27;</span>, <span class="hljs-string">&#x27;sc&#x27;</span>, <span class="hljs-string">&#x27;ro&#x27;</span>, <span class="hljs-string">&#x27;la&#x27;</span>],
 <span class="hljs-string">&#x27;NORTH_EU&#x27;</span>: [<span class="hljs-string">&#x27;de&#x27;</span>, <span class="hljs-string">&#x27;nl&#x27;</span>, <span class="hljs-string">&#x27;fy&#x27;</span>, <span class="hljs-string">&#x27;af&#x27;</span>, <span class="hljs-string">&#x27;da&#x27;</span>, <span class="hljs-string">&#x27;fo&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;no&#x27;</span>, <span class="hljs-string">&#x27;nb&#x27;</span>, <span class="hljs-string">&#x27;nn&#x27;</span>, <span class="hljs-string">&#x27;sv&#x27;</span>],
 <span class="hljs-string">&#x27;SCANDINAVIA&#x27;</span>: [<span class="hljs-string">&#x27;da&#x27;</span>, <span class="hljs-string">&#x27;fo&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;no&#x27;</span>, <span class="hljs-string">&#x27;nb&#x27;</span>, <span class="hljs-string">&#x27;nn&#x27;</span>, <span class="hljs-string">&#x27;sv&#x27;</span>],
 <span class="hljs-string">&#x27;SAMI&#x27;</span>: [<span class="hljs-string">&#x27;se&#x27;</span>, <span class="hljs-string">&#x27;sma&#x27;</span>, <span class="hljs-string">&#x27;smj&#x27;</span>, <span class="hljs-string">&#x27;smn&#x27;</span>, <span class="hljs-string">&#x27;sms&#x27;</span>],
 <span class="hljs-string">&#x27;NORWAY&#x27;</span>: [<span class="hljs-string">&#x27;nb_NO&#x27;</span>, <span class="hljs-string">&#x27;nb&#x27;</span>, <span class="hljs-string">&#x27;nn_NO&#x27;</span>, <span class="hljs-string">&#x27;nn&#x27;</span>, <span class="hljs-string">&#x27;nog&#x27;</span>, <span class="hljs-string">&#x27;no_nb&#x27;</span>, <span class="hljs-string">&#x27;no&#x27;</span>],
 <span class="hljs-string">&#x27;CELTIC&#x27;</span>: [<span class="hljs-string">&#x27;ga&#x27;</span>, <span class="hljs-string">&#x27;cy&#x27;</span>, <span class="hljs-string">&#x27;br&#x27;</span>, <span class="hljs-string">&#x27;gd&#x27;</span>, <span class="hljs-string">&#x27;kw&#x27;</span>, <span class="hljs-string">&#x27;gv&#x27;</span>]
}`}}),Ut=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmlhbk1UTW9kZWwlMkMlMjBNYXJpYW5Ub2tlbml6ZXIlMEElMEFzcmNfdGV4dCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMiUzRSUzRWZyJTNDJTNDJTIwdGhpcyUyMGlzJTIwYSUyMHNlbnRlbmNlJTIwaW4lMjBlbmdsaXNoJTIwdGhhdCUyMHdlJTIwd2FudCUyMHRvJTIwdHJhbnNsYXRlJTIwdG8lMjBmcmVuY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlM0UlM0VwdCUzQyUzQyUyMFRoaXMlMjBzaG91bGQlMjBnbyUyMHRvJTIwcG9ydHVndWVzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiUzRSUzRWVzJTNDJTNDJTIwQW5kJTIwdGhpcyUyMHRvJTIwU3BhbmlzaCUyMiUyQyUwQSU1RCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLVJPTUFOQ0UlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBNYXJpYW5Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBbW9kZWwlMjAlM0QlMjBNYXJpYW5NVE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQXRyYW5zbGF0ZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnRva2VuaXplcihzcmNfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkpJTBBdGd0X3RleHQlMjAlM0QlMjAlNUJ0b2tlbml6ZXIuZGVjb2RlKHQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMjBmb3IlMjB0JTIwaW4lMjB0cmFuc2xhdGVkJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarianMTModel, MarianTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>src_text = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;fr&lt;&lt; this is a sentence in english that we want to translate to french&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;pt&lt;&lt; This should go to portuguese&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&gt;&gt;es&lt;&lt; And this to Spanish&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-ROMANCE&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = MarianTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarianMTModel.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>translated = model.generate(**tokenizer(src_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tgt_text = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> translated]
[<span class="hljs-string">&quot;c&#x27;est une phrase en anglais que nous voulons traduire en français&quot;</span>, 
 <span class="hljs-string">&#x27;Isto deve ir para o português.&#x27;</span>,
 <span class="hljs-string">&#x27;Y esto al español&#x27;</span>]`}}),Ct=new N({}),It=new N({}),Nt=new F({props:{name:"class transformers.MarianConfig",anchor:"transformers.MarianConfig",parameters:[{name:"vocab_size",val:" = 58101"},{name:"decoder_vocab_size",val:" = None"},{name:"max_position_embeddings",val:" = 1024"},{name:"encoder_layers",val:" = 12"},{name:"encoder_ffn_dim",val:" = 4096"},{name:"encoder_attention_heads",val:" = 16"},{name:"decoder_layers",val:" = 12"},{name:"decoder_ffn_dim",val:" = 4096"},{name:"decoder_attention_heads",val:" = 16"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"d_model",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 58100"},{name:"scale_embedding",val:" = False"},{name:"pad_token_id",val:" = 58100"},{name:"eos_token_id",val:" = 0"},{name:"forced_eos_token_id",val:" = 0"},{name:"share_encoder_decoder_embeddings",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarianConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 58101) &#x2014;
Vocabulary size of the Marian model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianModel">MarianModel</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a>.`,name:"vocab_size"},{anchor:"transformers.MarianConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.MarianConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.MarianConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.MarianConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.MarianConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.MarianConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.MarianConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.MarianConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MarianConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MarianConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MarianConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MarianConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MarianConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.MarianConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.MarianConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.MarianConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(d_model).`,name:"scale_embedding"},{anchor:"transformers.MarianConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MarianConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Usually set to
<code>eos_token_id</code>.`,name:"forced_eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/configuration_marian.py#L34"}}),Ue=new Te({props:{anchor:"transformers.MarianConfig.example",$$slots:{default:[bl]},$$scope:{ctx:j}}}),qt=new N({}),Zt=new F({props:{name:"class transformers.MarianTokenizer",anchor:"transformers.MarianTokenizer",parameters:[{name:"source_spm",val:""},{name:"target_spm",val:""},{name:"vocab",val:""},{name:"target_vocab_file",val:" = None"},{name:"source_lang",val:" = None"},{name:"target_lang",val:" = None"},{name:"unk_token",val:" = '<unk>'"},{name:"eos_token",val:" = '</s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"model_max_length",val:" = 512"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"separate_vocabs",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarianTokenizer.source_spm",description:`<strong>source_spm</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .spm extension) that
contains the vocabulary for the source language.`,name:"source_spm"},{anchor:"transformers.MarianTokenizer.target_spm",description:`<strong>target_spm</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .spm extension) that
contains the vocabulary for the target language.`,name:"target_spm"},{anchor:"transformers.MarianTokenizer.source_lang",description:`<strong>source_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string representing the source language.`,name:"source_lang"},{anchor:"transformers.MarianTokenizer.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string representing the target language.`,name:"target_lang"},{anchor:"transformers.MarianTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarianTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.MarianTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarianTokenizer.model_max_length",description:`<strong>model_max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sentence length the model accepts.`,name:"model_max_length"},{anchor:"transformers.MarianTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&quot;&lt;eop&gt;&quot;, &quot;&lt;eod&gt;&quot;]</code>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.MarianTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/tokenization_marian.py#L61"}}),Fe=new Te({props:{anchor:"transformers.MarianTokenizer.example",$$slots:{default:[vl]},$$scope:{ctx:j}}}),Wt=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarianTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/tokenization_marian.py#L283"}}),Ht=new N({}),St=new F({props:{name:"class transformers.MarianModel",anchor:"transformers.MarianModel",parameters:[{name:"config",val:": MarianConfig"}],parametersDescription:[{anchor:"transformers.MarianModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1106"}}),Lt=new F({props:{name:"forward",anchor:"transformers.MarianModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Union[typing.Tuple[torch.Tensor], transformers.modeling_outputs.BaseModelOutput, NoneType] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarianModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarianModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarianModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Marian uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.MarianModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MarianModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MarianModel.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MarianModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MarianModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MarianModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MarianModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarianModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MarianModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MarianModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarianModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarianModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1190",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new ct({props:{$$slots:{default:[kl]},$$scope:{ctx:j}}}),Ze=new Te({props:{anchor:"transformers.MarianModel.forward.example",$$slots:{default:[wl]},$$scope:{ctx:j}}}),Vt=new N({}),At=new F({props:{name:"class transformers.MarianMTModel",anchor:"transformers.MarianMTModel",parameters:[{name:"config",val:": MarianConfig"}],parametersDescription:[{anchor:"transformers.MarianMTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1292"}}),Rt=new F({props:{name:"forward",anchor:"transformers.MarianMTModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Union[typing.Tuple[torch.Tensor], transformers.modeling_outputs.BaseModelOutput, NoneType] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarianMTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarianMTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarianMTModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Marian uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.MarianMTModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MarianMTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MarianMTModel.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MarianMTModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MarianMTModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MarianMTModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MarianMTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarianMTModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MarianMTModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MarianMTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarianMTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarianMTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarianMTModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1416",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),He=new ct({props:{$$slots:{default:[xl]},$$scope:{ctx:j}}}),Se=new Te({props:{anchor:"transformers.MarianMTModel.forward.example",$$slots:{default:[jl]},$$scope:{ctx:j}}}),Gt=new N({}),Et=new F({props:{name:"class transformers.MarianForCausalLM",anchor:"transformers.MarianForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1556"}}),Pt=new F({props:{name:"forward",anchor:"transformers.MarianForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarianForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarianForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarianForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MarianForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.MarianForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MarianForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MarianForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MarianForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MarianForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.MarianForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarianForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarianForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_marian.py#L1589",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ae=new Te({props:{anchor:"transformers.MarianForCausalLM.forward.example",$$slots:{default:[Jl]},$$scope:{ctx:j}}}),Bt=new N({}),Xt=new F({props:{name:"class transformers.TFMarianModel",anchor:"transformers.TFMarianModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFMarianModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_tf_marian.py#L1157"}}),Ge=new ct({props:{$$slots:{default:[$l]},$$scope:{ctx:j}}}),Qt=new F({props:{name:"call",anchor:"transformers.TFMarianModel.call",parameters:[{name:"input_ids",val:": tf.Tensor | None = None"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"decoder_input_ids",val:": tf.Tensor | None = None"},{name:"decoder_attention_mask",val:": tf.Tensor | None = None"},{name:"decoder_position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"decoder_head_mask",val:": tf.Tensor | None = None"},{name:"cross_attn_head_mask",val:": tf.Tensor | None = None"},{name:"encoder_outputs",val:": tf.Tensor | None = None"},{name:"past_key_values",val:": Tuple[Tuple[tf.Tensor]] | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"decoder_inputs_embeds",val:": tf.Tensor | None = None"},{name:"use_cache",val:": bool | None = None"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"training",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFMarianModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFMarianModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFMarianModel.call.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Marian uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.TFMarianModel.call.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
will be made by default and ignore pad tokens. It is not recommended to set this for most use cases.`,name:"decoder_attention_mask"},{anchor:"transformers.TFMarianModel.call.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each decoder input sequence tokens in the position embeddings. Selected in the
range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"decoder_position_ids"},{anchor:"transformers.TFMarianModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFMarianModel.call.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.TFMarianModel.call.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.TFMarianModel.call.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tf.FloatTensor</code>, <em>optional</em>) &#x2014;
hidden states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.
of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of`,name:"encoder_outputs"},{anchor:"transformers.TFMarianModel.call.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[tf.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFMarianModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>). Set to <code>False</code> during training, <code>True</code> during generation`,name:"use_cache"},{anchor:"transformers.TFMarianModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFMarianModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFMarianModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFMarianModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_tf_marian.py#L1169",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Ee=new ct({props:{$$slots:{default:[zl]},$$scope:{ctx:j}}}),Pe=new Te({props:{anchor:"transformers.TFMarianModel.call.example",$$slots:{default:[Ul]},$$scope:{ctx:j}}}),Yt=new N({}),Ot=new F({props:{name:"class transformers.TFMarianMTModel",anchor:"transformers.TFMarianMTModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFMarianMTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_tf_marian.py#L1262"}}),Xe=new ct({props:{$$slots:{default:[Cl]},$$scope:{ctx:j}}}),Dt=new F({props:{name:"call",anchor:"transformers.TFMarianMTModel.call",parameters:[{name:"input_ids",val:": tf.Tensor | None = None"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"decoder_input_ids",val:": tf.Tensor | None = None"},{name:"decoder_attention_mask",val:": tf.Tensor | None = None"},{name:"decoder_position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"decoder_head_mask",val:": tf.Tensor | None = None"},{name:"cross_attn_head_mask",val:": tf.Tensor | None = None"},{name:"encoder_outputs",val:": TFBaseModelOutput | None = None"},{name:"past_key_values",val:": Tuple[Tuple[tf.Tensor]] | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"decoder_inputs_embeds",val:": tf.Tensor | None = None"},{name:"use_cache",val:": bool | None = None"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFMarianMTModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFMarianMTModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFMarianMTModel.call.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Marian uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.TFMarianMTModel.call.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
will be made by default and ignore pad tokens. It is not recommended to set this for most use cases.`,name:"decoder_attention_mask"},{anchor:"transformers.TFMarianMTModel.call.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each decoder input sequence tokens in the position embeddings. Selected in the
range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"decoder_position_ids"},{anchor:"transformers.TFMarianMTModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFMarianMTModel.call.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.TFMarianMTModel.call.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.TFMarianMTModel.call.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tf.FloatTensor</code>, <em>optional</em>) &#x2014;
hidden states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.
of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of`,name:"encoder_outputs"},{anchor:"transformers.TFMarianMTModel.call.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[tf.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFMarianMTModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>). Set to <code>False</code> during training, <code>True</code> during generation`,name:"use_cache"},{anchor:"transformers.TFMarianMTModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFMarianMTModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFMarianMTModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFMarianMTModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFMarianMTModel.call.labels",description:`<strong>labels</strong> (<code>tf.tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_tf_marian.py#L1300",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Qe=new ct({props:{$$slots:{default:[Fl]},$$scope:{ctx:j}}}),Ye=new Te({props:{anchor:"transformers.TFMarianMTModel.call.example",$$slots:{default:[Il]},$$scope:{ctx:j}}}),Kt=new N({}),en=new F({props:{name:"class transformers.FlaxMarianModel",anchor:"transformers.FlaxMarianModel",parameters:[{name:"config",val:": MarianConfig"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxMarianModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxMarianModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_flax_marian.py#L1205"}}),tn=new F({props:{name:"__call__",anchor:"transformers.FlaxMarianModel.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_input_ids",val:": typing.Optional[jax.Array] = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"position_ids",val:": typing.Optional[jax.Array] = None"},{name:"decoder_position_ids",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxMarianModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxMarianModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxMarianModel.__call__.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>For translation and summarization training, <code>decoder_input_ids</code> should be provided. If no
<code>decoder_input_ids</code> is provided, the model will create this tensor by shifting the <code>input_ids</code> to the right
for denoising pre-training following the paper.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxMarianModel.__call__.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the
paper</a> for more information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxMarianModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxMarianModel.__call__.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each decoder input sequence tokens in the position embeddings. Selected in the
range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"decoder_position_ids"},{anchor:"transformers.FlaxMarianModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxMarianModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxMarianModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_flax_marian.py#L1140",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new ct({props:{$$slots:{default:[Nl]},$$scope:{ctx:j}}}),Ke=new Te({props:{anchor:"transformers.FlaxMarianModel.__call__.example",$$slots:{default:[ql]},$$scope:{ctx:j}}}),nn=new N({}),on=new F({props:{name:"class transformers.FlaxMarianMTModel",anchor:"transformers.FlaxMarianMTModel",parameters:[{name:"config",val:": MarianConfig"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxMarianMTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxMarianMTModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_flax_marian.py#L1289"}}),sn=new F({props:{name:"__call__",anchor:"transformers.FlaxMarianMTModel.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_input_ids",val:": typing.Optional[jax.Array] = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"position_ids",val:": typing.Optional[jax.Array] = None"},{name:"decoder_position_ids",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxMarianMTModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxMarianMTModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxMarianMTModel.__call__.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>For translation and summarization training, <code>decoder_input_ids</code> should be provided. If no
<code>decoder_input_ids</code> is provided, the model will create this tensor by shifting the <code>input_ids</code> to the right
for denoising pre-training following the paper.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxMarianMTModel.__call__.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the
paper</a> for more information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxMarianMTModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxMarianMTModel.__call__.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each decoder input sequence tokens in the position embeddings. Selected in the
range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"decoder_position_ids"},{anchor:"transformers.FlaxMarianMTModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxMarianMTModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxMarianMTModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/marian/modeling_flax_marian.py#L1140",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/marian#transformers.MarianConfig"
>MarianConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),tt=new ct({props:{$$slots:{default:[Zl]},$$scope:{ctx:j}}}),nt=new Te({props:{anchor:"transformers.FlaxMarianMTModel.__call__.example",$$slots:{default:[Wl]},$$scope:{ctx:j}}}),{c(){r=s("meta"),w=l(),h=s("p"),p=l(),v=s("h1"),o=s("a"),k=s("span"),g(V.$$.fragment),A=l(),z=s("span"),z.textContent=be,H=l(),$=s("div"),$.innerHTML=ve,x=l(),J=s("p"),J.innerHTML=Pa,Uo=l(),pt=s("p"),pt.textContent=Ba,Co=l(),ht=s("p"),ht.textContent=Xa,Fo=l(),ut=s("ul"),ut.innerHTML=Qa,Io=l(),se=s("h2"),ke=s("a"),no=s("span"),g(mt.$$.fragment),Cs=l(),hn=s("span"),hn.textContent=Ya,No=l(),ft=s("ul"),ft.innerHTML=Oa,qo=l(),ae=s("h2"),we=s("a"),oo=s("span"),g(gt.$$.fragment),Fs=l(),un=s("span"),un.textContent=Da,Zo=l(),_t=s("ul"),_t.innerHTML=Ka,Wo=l(),re=s("h2"),xe=s("a"),so=s("span"),g(Mt.$$.fragment),Is=l(),mn=s("span"),mn.textContent=er,Ho=l(),yt=s("ul"),yt.innerHTML=tr,So=l(),le=s("h2"),je=s("a"),ao=s("span"),g(Tt.$$.fragment),Ns=l(),fn=s("span"),fn.textContent=nr,Lo=l(),bt=s("ul"),bt.innerHTML=or,Vo=l(),vt=s("p"),vt.innerHTML=sr,Ao=l(),g(kt.$$.fragment),Ro=l(),wt=s("p"),wt.textContent=ar,Go=l(),g(xt.$$.fragment),Eo=l(),ie=s("h2"),Je=s("a"),ro=s("span"),g(jt.$$.fragment),qs=l(),gn=s("span"),gn.textContent=rr,Po=l(),Jt=s("p"),Jt.textContent=lr,Bo=l(),g($t.$$.fragment),Xo=l(),zt=s("p"),zt.textContent=ir,Qo=l(),g(Ut.$$.fragment),Yo=l(),de=s("h2"),$e=s("a"),lo=s("span"),g(Ct.$$.fragment),Zs=l(),_n=s("span"),_n.textContent=dr,Oo=l(),Ft=s("ul"),Ft.innerHTML=cr,Do=l(),ce=s("h2"),ze=s("a"),io=s("span"),g(It.$$.fragment),Ws=l(),Mn=s("span"),Mn.textContent=pr,Ko=l(),R=s("div"),g(Nt.$$.fragment),Hs=l(),yn=s("p"),yn.innerHTML=hr,Ss=l(),Tn=s("p"),Tn.innerHTML=ur,Ls=l(),g(Ue.$$.fragment),es=l(),pe=s("h2"),Ce=s("a"),co=s("span"),g(qt.$$.fragment),Vs=l(),bn=s("span"),bn.textContent=mr,ts=l(),q=s("div"),g(Zt.$$.fragment),As=l(),vn=s("p"),vn.innerHTML=fr,Rs=l(),kn=s("p"),kn.innerHTML=gr,Gs=l(),g(Fe.$$.fragment),Es=l(),Ie=s("div"),g(Wt.$$.fragment),Ps=l(),wn=s("p"),wn.textContent=_r,ns=l(),he=s("h2"),Ne=s("a"),po=s("span"),g(Ht.$$.fragment),Bs=l(),xn=s("span"),xn.textContent=Mr,os=l(),G=s("div"),g(St.$$.fragment),Xs=l(),jn=s("p"),jn.innerHTML=yr,Qs=l(),Jn=s("p"),Jn.innerHTML=Tr,Ys=l(),B=s("div"),g(Lt.$$.fragment),Os=l(),$n=s("p"),$n.innerHTML=br,Ds=l(),g(qe.$$.fragment),Ks=l(),g(Ze.$$.fragment),ss=l(),ue=s("h2"),We=s("a"),ho=s("span"),g(Vt.$$.fragment),ea=l(),zn=s("span"),zn.textContent=vr,as=l(),E=s("div"),g(At.$$.fragment),ta=l(),Un=s("p"),Un.innerHTML=kr,na=l(),Cn=s("p"),Cn.innerHTML=wr,oa=l(),S=s("div"),g(Rt.$$.fragment),sa=l(),Fn=s("p"),Fn.innerHTML=xr,aa=l(),g(He.$$.fragment),ra=l(),In=s("p"),In.innerHTML=jr,la=l(),g(Se.$$.fragment),rs=l(),me=s("h2"),Le=s("a"),uo=s("span"),g(Gt.$$.fragment),ia=l(),Nn=s("span"),Nn.textContent=Jr,ls=l(),fe=s("div"),g(Et.$$.fragment),da=l(),Ve=s("div"),g(Pt.$$.fragment),ca=l(),g(Ae.$$.fragment),is=l(),ge=s("h2"),Re=s("a"),mo=s("span"),g(Bt.$$.fragment),pa=l(),qn=s("span"),qn.textContent=$r,ds=l(),Z=s("div"),g(Xt.$$.fragment),ha=l(),Zn=s("p"),Zn.innerHTML=zr,ua=l(),Wn=s("p"),Wn.innerHTML=Ur,ma=l(),g(Ge.$$.fragment),fa=l(),X=s("div"),g(Qt.$$.fragment),ga=l(),Hn=s("p"),Hn.innerHTML=Cr,_a=l(),g(Ee.$$.fragment),Ma=l(),g(Pe.$$.fragment),cs=l(),_e=s("h2"),Be=s("a"),fo=s("span"),g(Yt.$$.fragment),ya=l(),Sn=s("span"),Sn.textContent=Fr,ps=l(),W=s("div"),g(Ot.$$.fragment),Ta=l(),Ln=s("p"),Ln.innerHTML=Ir,ba=l(),Vn=s("p"),Vn.innerHTML=Nr,va=l(),g(Xe.$$.fragment),ka=l(),L=s("div"),g(Dt.$$.fragment),wa=l(),An=s("p"),An.innerHTML=qr,xa=l(),g(Qe.$$.fragment),ja=l(),Rn=s("p"),Rn.innerHTML=Zr,Ja=l(),g(Ye.$$.fragment),hs=l(),Me=s("h2"),Oe=s("a"),go=s("span"),g(Kt.$$.fragment),$a=l(),Gn=s("span"),Gn.textContent=Wr,us=l(),U=s("div"),g(en.$$.fragment),za=l(),En=s("p"),En.innerHTML=Hr,Ua=l(),Pn=s("p"),Pn.innerHTML=Sr,Ca=l(),Bn=s("p"),Bn.textContent=Lr,Fa=l(),Xn=s("ul"),Xn.innerHTML=Vr,Ia=l(),Q=s("div"),g(tn.$$.fragment),Na=l(),Qn=s("p"),Qn.innerHTML=Ar,qa=l(),g(De.$$.fragment),Za=l(),g(Ke.$$.fragment),ms=l(),ye=s("h2"),et=s("a"),_o=s("span"),g(nn.$$.fragment),Wa=l(),Yn=s("span"),Yn.textContent=Rr,fs=l(),C=s("div"),g(on.$$.fragment),Ha=l(),On=s("p"),On.innerHTML=Gr,Sa=l(),Dn=s("p"),Dn.innerHTML=Er,La=l(),Kn=s("p"),Kn.textContent=Pr,Va=l(),eo=s("ul"),eo.innerHTML=Br,Aa=l(),Y=s("div"),g(sn.$$.fragment),Ra=l(),to=s("p"),to.innerHTML=Xr,Ga=l(),g(tt.$$.fragment),Ea=l(),g(nt.$$.fragment),gs=l(),Mo=s("p"),this.h()},l(e){const d=Tl("svelte-1phssyn",document.head);r=a(d,"META",{name:!0,content:!0}),d.forEach(t),w=i(e),h=a(e,"P",{}),f(h).forEach(t),p=i(e),v=a(e,"H1",{class:!0});var an=f(v);o=a(an,"A",{id:!0,class:!0,href:!0});var yo=f(o);k=a(yo,"SPAN",{});var To=f(k);_(V.$$.fragment,To),To.forEach(t),yo.forEach(t),A=i(an),z=a(an,"SPAN",{"data-svelte-h":!0}),m(z)!=="svelte-1enkmra"&&(z.textContent=be),an.forEach(t),H=i(e),$=a(e,"DIV",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-28p0nh"&&($.innerHTML=ve),x=i(e),J=a(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-10ydjdh"&&(J.innerHTML=Pa),Uo=i(e),pt=a(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-15ppnx7"&&(pt.textContent=Ba),Co=i(e),ht=a(e,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-axv494"&&(ht.textContent=Xa),Fo=i(e),ut=a(e,"UL",{"data-svelte-h":!0}),m(ut)!=="svelte-w4zrx0"&&(ut.innerHTML=Qa),Io=i(e),se=a(e,"H2",{class:!0});var rn=f(se);ke=a(rn,"A",{id:!0,class:!0,href:!0});var bo=f(ke);no=a(bo,"SPAN",{});var vo=f(no);_(mt.$$.fragment,vo),vo.forEach(t),bo.forEach(t),Cs=i(rn),hn=a(rn,"SPAN",{"data-svelte-h":!0}),m(hn)!=="svelte-k2bmg4"&&(hn.textContent=Ya),rn.forEach(t),No=i(e),ft=a(e,"UL",{"data-svelte-h":!0}),m(ft)!=="svelte-1g3exm5"&&(ft.innerHTML=Oa),qo=i(e),ae=a(e,"H2",{class:!0});var ln=f(ae);we=a(ln,"A",{id:!0,class:!0,href:!0});var ko=f(we);oo=a(ko,"SPAN",{});var wo=f(oo);_(gt.$$.fragment,wo),wo.forEach(t),ko.forEach(t),Fs=i(ln),un=a(ln,"SPAN",{"data-svelte-h":!0}),m(un)!=="svelte-37h9cp"&&(un.textContent=Da),ln.forEach(t),Zo=i(e),_t=a(e,"UL",{"data-svelte-h":!0}),m(_t)!=="svelte-1teg5jx"&&(_t.innerHTML=Ka),Wo=i(e),re=a(e,"H2",{class:!0});var dn=f(re);xe=a(dn,"A",{id:!0,class:!0,href:!0});var xo=f(xe);so=a(xo,"SPAN",{});var jo=f(so);_(Mt.$$.fragment,jo),jo.forEach(t),xo.forEach(t),Is=i(dn),mn=a(dn,"SPAN",{"data-svelte-h":!0}),m(mn)!=="svelte-byb5hs"&&(mn.textContent=er),dn.forEach(t),Ho=i(e),yt=a(e,"UL",{"data-svelte-h":!0}),m(yt)!=="svelte-ivqdaf"&&(yt.innerHTML=tr),So=i(e),le=a(e,"H2",{class:!0});var cn=f(le);je=a(cn,"A",{id:!0,class:!0,href:!0});var Jo=f(je);ao=a(Jo,"SPAN",{});var $o=f(ao);_(Tt.$$.fragment,$o),$o.forEach(t),Jo.forEach(t),Ns=i(cn),fn=a(cn,"SPAN",{"data-svelte-h":!0}),m(fn)!=="svelte-1wlgm2y"&&(fn.textContent=nr),cn.forEach(t),Lo=i(e),bt=a(e,"UL",{"data-svelte-h":!0}),m(bt)!=="svelte-1yiu6u"&&(bt.innerHTML=or),Vo=i(e),vt=a(e,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-n5hft2"&&(vt.innerHTML=sr),Ao=i(e),_(kt.$$.fragment,e),Ro=i(e),wt=a(e,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-1jqi7uz"&&(wt.textContent=ar),Go=i(e),_(xt.$$.fragment,e),Eo=i(e),ie=a(e,"H2",{class:!0});var pn=f(ie);Je=a(pn,"A",{id:!0,class:!0,href:!0});var zo=f(Je);ro=a(zo,"SPAN",{});var Qr=f(ro);_(jt.$$.fragment,Qr),Qr.forEach(t),zo.forEach(t),qs=i(pn),gn=a(pn,"SPAN",{"data-svelte-h":!0}),m(gn)!=="svelte-19ic8i1"&&(gn.textContent=rr),pn.forEach(t),Po=i(e),Jt=a(e,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-h75jvn"&&(Jt.textContent=lr),Bo=i(e),_($t.$$.fragment,e),Xo=i(e),zt=a(e,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1vkdk78"&&(zt.textContent=ir),Qo=i(e),_(Ut.$$.fragment,e),Yo=i(e),de=a(e,"H2",{class:!0});var Ms=f(de);$e=a(Ms,"A",{id:!0,class:!0,href:!0});var Yr=f($e);lo=a(Yr,"SPAN",{});var Or=f(lo);_(Ct.$$.fragment,Or),Or.forEach(t),Yr.forEach(t),Zs=i(Ms),_n=a(Ms,"SPAN",{"data-svelte-h":!0}),m(_n)!=="svelte-n3f0j0"&&(_n.textContent=dr),Ms.forEach(t),Oo=i(e),Ft=a(e,"UL",{"data-svelte-h":!0}),m(Ft)!=="svelte-1kdght5"&&(Ft.innerHTML=cr),Do=i(e),ce=a(e,"H2",{class:!0});var ys=f(ce);ze=a(ys,"A",{id:!0,class:!0,href:!0});var Dr=f(ze);io=a(Dr,"SPAN",{});var Kr=f(io);_(It.$$.fragment,Kr),Kr.forEach(t),Dr.forEach(t),Ws=i(ys),Mn=a(ys,"SPAN",{"data-svelte-h":!0}),m(Mn)!=="svelte-15c9gzn"&&(Mn.textContent=pr),ys.forEach(t),Ko=i(e),R=a(e,"DIV",{class:!0});var ot=f(R);_(Nt.$$.fragment,ot),Hs=i(ot),yn=a(ot,"P",{"data-svelte-h":!0}),m(yn)!=="svelte-1ormfsz"&&(yn.innerHTML=hr),Ss=i(ot),Tn=a(ot,"P",{"data-svelte-h":!0}),m(Tn)!=="svelte-cfh5wl"&&(Tn.innerHTML=ur),Ls=i(ot),_(Ue.$$.fragment,ot),ot.forEach(t),es=i(e),pe=a(e,"H2",{class:!0});var Ts=f(pe);Ce=a(Ts,"A",{id:!0,class:!0,href:!0});var el=f(Ce);co=a(el,"SPAN",{});var tl=f(co);_(qt.$$.fragment,tl),tl.forEach(t),el.forEach(t),Vs=i(Ts),bn=a(Ts,"SPAN",{"data-svelte-h":!0}),m(bn)!=="svelte-1ujwql2"&&(bn.textContent=mr),Ts.forEach(t),ts=i(e),q=a(e,"DIV",{class:!0});var K=f(q);_(Zt.$$.fragment,K),As=i(K),vn=a(K,"P",{"data-svelte-h":!0}),m(vn)!=="svelte-1giw7lm"&&(vn.innerHTML=fr),Rs=i(K),kn=a(K,"P",{"data-svelte-h":!0}),m(kn)!=="svelte-14xlfoy"&&(kn.innerHTML=gr),Gs=i(K),_(Fe.$$.fragment,K),Es=i(K),Ie=a(K,"DIV",{class:!0});var bs=f(Ie);_(Wt.$$.fragment,bs),Ps=i(bs),wn=a(bs,"P",{"data-svelte-h":!0}),m(wn)!=="svelte-wv4s2m"&&(wn.textContent=_r),bs.forEach(t),K.forEach(t),ns=i(e),he=a(e,"H2",{class:!0});var vs=f(he);Ne=a(vs,"A",{id:!0,class:!0,href:!0});var nl=f(Ne);po=a(nl,"SPAN",{});var ol=f(po);_(Ht.$$.fragment,ol),ol.forEach(t),nl.forEach(t),Bs=i(vs),xn=a(vs,"SPAN",{"data-svelte-h":!0}),m(xn)!=="svelte-1t05l86"&&(xn.textContent=Mr),vs.forEach(t),os=i(e),G=a(e,"DIV",{class:!0});var st=f(G);_(St.$$.fragment,st),Xs=i(st),jn=a(st,"P",{"data-svelte-h":!0}),m(jn)!=="svelte-171zrwa"&&(jn.innerHTML=yr),Qs=i(st),Jn=a(st,"P",{"data-svelte-h":!0}),m(Jn)!=="svelte-hswkmf"&&(Jn.innerHTML=Tr),Ys=i(st),B=a(st,"DIV",{class:!0});var at=f(B);_(Lt.$$.fragment,at),Os=i(at),$n=a(at,"P",{"data-svelte-h":!0}),m($n)!=="svelte-1fh2tw5"&&($n.innerHTML=br),Ds=i(at),_(qe.$$.fragment,at),Ks=i(at),_(Ze.$$.fragment,at),at.forEach(t),st.forEach(t),ss=i(e),ue=a(e,"H2",{class:!0});var ks=f(ue);We=a(ks,"A",{id:!0,class:!0,href:!0});var sl=f(We);ho=a(sl,"SPAN",{});var al=f(ho);_(Vt.$$.fragment,al),al.forEach(t),sl.forEach(t),ea=i(ks),zn=a(ks,"SPAN",{"data-svelte-h":!0}),m(zn)!=="svelte-sz4s85"&&(zn.textContent=vr),ks.forEach(t),as=i(e),E=a(e,"DIV",{class:!0});var rt=f(E);_(At.$$.fragment,rt),ta=i(rt),Un=a(rt,"P",{"data-svelte-h":!0}),m(Un)!=="svelte-163e5u2"&&(Un.innerHTML=kr),na=i(rt),Cn=a(rt,"P",{"data-svelte-h":!0}),m(Cn)!=="svelte-hswkmf"&&(Cn.innerHTML=wr),oa=i(rt),S=a(rt,"DIV",{class:!0});var ee=f(S);_(Rt.$$.fragment,ee),sa=i(ee),Fn=a(ee,"P",{"data-svelte-h":!0}),m(Fn)!=="svelte-agihqt"&&(Fn.innerHTML=xr),aa=i(ee),_(He.$$.fragment,ee),ra=i(ee),In=a(ee,"P",{"data-svelte-h":!0}),m(In)!=="svelte-vjyygk"&&(In.innerHTML=jr),la=i(ee),_(Se.$$.fragment,ee),ee.forEach(t),rt.forEach(t),rs=i(e),me=a(e,"H2",{class:!0});var ws=f(me);Le=a(ws,"A",{id:!0,class:!0,href:!0});var rl=f(Le);uo=a(rl,"SPAN",{});var ll=f(uo);_(Gt.$$.fragment,ll),ll.forEach(t),rl.forEach(t),ia=i(ws),Nn=a(ws,"SPAN",{"data-svelte-h":!0}),m(Nn)!=="svelte-13sj1ye"&&(Nn.textContent=Jr),ws.forEach(t),ls=i(e),fe=a(e,"DIV",{class:!0});var xs=f(fe);_(Et.$$.fragment,xs),da=i(xs),Ve=a(xs,"DIV",{class:!0});var js=f(Ve);_(Pt.$$.fragment,js),ca=i(js),_(Ae.$$.fragment,js),js.forEach(t),xs.forEach(t),is=i(e),ge=a(e,"H2",{class:!0});var Js=f(ge);Re=a(Js,"A",{id:!0,class:!0,href:!0});var il=f(Re);mo=a(il,"SPAN",{});var dl=f(mo);_(Bt.$$.fragment,dl),dl.forEach(t),il.forEach(t),pa=i(Js),qn=a(Js,"SPAN",{"data-svelte-h":!0}),m(qn)!=="svelte-18o2p20"&&(qn.textContent=$r),Js.forEach(t),ds=i(e),Z=a(e,"DIV",{class:!0});var te=f(Z);_(Xt.$$.fragment,te),ha=i(te),Zn=a(te,"P",{"data-svelte-h":!0}),m(Zn)!=="svelte-gz90qi"&&(Zn.innerHTML=zr),ua=i(te),Wn=a(te,"P",{"data-svelte-h":!0}),m(Wn)!=="svelte-1ivrf8m"&&(Wn.innerHTML=Ur),ma=i(te),_(Ge.$$.fragment,te),fa=i(te),X=a(te,"DIV",{class:!0});var lt=f(X);_(Qt.$$.fragment,lt),ga=i(lt),Hn=a(lt,"P",{"data-svelte-h":!0}),m(Hn)!=="svelte-ztkn7t"&&(Hn.innerHTML=Cr),_a=i(lt),_(Ee.$$.fragment,lt),Ma=i(lt),_(Pe.$$.fragment,lt),lt.forEach(t),te.forEach(t),cs=i(e),_e=a(e,"H2",{class:!0});var $s=f(_e);Be=a($s,"A",{id:!0,class:!0,href:!0});var cl=f(Be);fo=a(cl,"SPAN",{});var pl=f(fo);_(Yt.$$.fragment,pl),pl.forEach(t),cl.forEach(t),ya=i($s),Sn=a($s,"SPAN",{"data-svelte-h":!0}),m(Sn)!=="svelte-1i6qdh7"&&(Sn.textContent=Fr),$s.forEach(t),ps=i(e),W=a(e,"DIV",{class:!0});var ne=f(W);_(Ot.$$.fragment,ne),Ta=i(ne),Ln=a(ne,"P",{"data-svelte-h":!0}),m(Ln)!=="svelte-f5zih6"&&(Ln.innerHTML=Ir),ba=i(ne),Vn=a(ne,"P",{"data-svelte-h":!0}),m(Vn)!=="svelte-1ivrf8m"&&(Vn.innerHTML=Nr),va=i(ne),_(Xe.$$.fragment,ne),ka=i(ne),L=a(ne,"DIV",{class:!0});var oe=f(L);_(Dt.$$.fragment,oe),wa=i(oe),An=a(oe,"P",{"data-svelte-h":!0}),m(An)!=="svelte-1qxde5p"&&(An.innerHTML=qr),xa=i(oe),_(Qe.$$.fragment,oe),ja=i(oe),Rn=a(oe,"P",{"data-svelte-h":!0}),m(Rn)!=="svelte-11jr0s7"&&(Rn.innerHTML=Zr),Ja=i(oe),_(Ye.$$.fragment,oe),oe.forEach(t),ne.forEach(t),hs=i(e),Me=a(e,"H2",{class:!0});var zs=f(Me);Oe=a(zs,"A",{id:!0,class:!0,href:!0});var hl=f(Oe);go=a(hl,"SPAN",{});var ul=f(go);_(Kt.$$.fragment,ul),ul.forEach(t),hl.forEach(t),$a=i(zs),Gn=a(zs,"SPAN",{"data-svelte-h":!0}),m(Gn)!=="svelte-uvn4av"&&(Gn.textContent=Wr),zs.forEach(t),us=i(e),U=a(e,"DIV",{class:!0});var O=f(U);_(en.$$.fragment,O),za=i(O),En=a(O,"P",{"data-svelte-h":!0}),m(En)!=="svelte-1el1gt1"&&(En.innerHTML=Hr),Ua=i(O),Pn=a(O,"P",{"data-svelte-h":!0}),m(Pn)!=="svelte-idybz1"&&(Pn.innerHTML=Sr),Ca=i(O),Bn=a(O,"P",{"data-svelte-h":!0}),m(Bn)!=="svelte-1pplc4a"&&(Bn.textContent=Lr),Fa=i(O),Xn=a(O,"UL",{"data-svelte-h":!0}),m(Xn)!=="svelte-1w7z84m"&&(Xn.innerHTML=Vr),Ia=i(O),Q=a(O,"DIV",{class:!0});var it=f(Q);_(tn.$$.fragment,it),Na=i(it),Qn=a(it,"P",{"data-svelte-h":!0}),m(Qn)!=="svelte-1pl959f"&&(Qn.innerHTML=Ar),qa=i(it),_(De.$$.fragment,it),Za=i(it),_(Ke.$$.fragment,it),it.forEach(t),O.forEach(t),ms=i(e),ye=a(e,"H2",{class:!0});var Us=f(ye);et=a(Us,"A",{id:!0,class:!0,href:!0});var ml=f(et);_o=a(ml,"SPAN",{});var fl=f(_o);_(nn.$$.fragment,fl),fl.forEach(t),ml.forEach(t),Wa=i(Us),Yn=a(Us,"SPAN",{"data-svelte-h":!0}),m(Yn)!=="svelte-cnt9ew"&&(Yn.textContent=Rr),Us.forEach(t),fs=i(e),C=a(e,"DIV",{class:!0});var D=f(C);_(on.$$.fragment,D),Ha=i(D),On=a(D,"P",{"data-svelte-h":!0}),m(On)!=="svelte-1uf4wa"&&(On.innerHTML=Gr),Sa=i(D),Dn=a(D,"P",{"data-svelte-h":!0}),m(Dn)!=="svelte-idybz1"&&(Dn.innerHTML=Er),La=i(D),Kn=a(D,"P",{"data-svelte-h":!0}),m(Kn)!=="svelte-1pplc4a"&&(Kn.textContent=Pr),Va=i(D),eo=a(D,"UL",{"data-svelte-h":!0}),m(eo)!=="svelte-1w7z84m"&&(eo.innerHTML=Br),Aa=i(D),Y=a(D,"DIV",{class:!0});var dt=f(Y);_(sn.$$.fragment,dt),Ra=i(dt),to=a(dt,"P",{"data-svelte-h":!0}),m(to)!=="svelte-1pl959f"&&(to.innerHTML=Xr),Ga=i(dt),_(tt.$$.fragment,dt),Ea=i(dt),_(nt.$$.fragment,dt),dt.forEach(t),D.forEach(t),gs=i(e),Mo=a(e,"P",{}),f(Mo).forEach(t),this.h()},h(){u(r,"name","hf:doc:metadata"),u(r,"content",JSON.stringify(Sl)),u(o,"id","marianmt"),u(o,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(o,"href","#marianmt"),u(v,"class","relative group"),u($,"class","flex flex-wrap space-x-1"),u(ke,"id","implementation-notes"),u(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ke,"href","#implementation-notes"),u(se,"class","relative group"),u(we,"id","naming"),u(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(we,"href","#naming"),u(ae,"class","relative group"),u(xe,"id","examples"),u(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(xe,"href","#examples"),u(re,"class","relative group"),u(je,"id","multilingual-models"),u(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(je,"href","#multilingual-models"),u(le,"class","relative group"),u(Je,"id","old-style-multilingual-models"),u(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Je,"href","#old-style-multilingual-models"),u(ie,"class","relative group"),u($e,"id","documentation-resources"),u($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u($e,"href","#documentation-resources"),u(de,"class","relative group"),u(ze,"id","transformers.MarianConfig"),u(ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ze,"href","#transformers.MarianConfig"),u(ce,"class","relative group"),u(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ce,"id","transformers.MarianTokenizer"),u(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Ce,"href","#transformers.MarianTokenizer"),u(pe,"class","relative group"),u(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ne,"id","transformers.MarianModel"),u(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Ne,"href","#transformers.MarianModel"),u(he,"class","relative group"),u(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(We,"id","transformers.MarianMTModel"),u(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(We,"href","#transformers.MarianMTModel"),u(ue,"class","relative group"),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Le,"id","transformers.MarianForCausalLM"),u(Le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Le,"href","#transformers.MarianForCausalLM"),u(me,"class","relative group"),u(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Re,"id","transformers.TFMarianModel"),u(Re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Re,"href","#transformers.TFMarianModel"),u(ge,"class","relative group"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Be,"id","transformers.TFMarianMTModel"),u(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Be,"href","#transformers.TFMarianMTModel"),u(_e,"class","relative group"),u(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Oe,"id","transformers.FlaxMarianModel"),u(Oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Oe,"href","#transformers.FlaxMarianModel"),u(Me,"class","relative group"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(et,"id","transformers.FlaxMarianMTModel"),u(et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(et,"href","#transformers.FlaxMarianMTModel"),u(ye,"class","relative group"),u(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){n(document.head,r),c(e,w,d),c(e,h,d),c(e,p,d),c(e,v,d),n(v,o),n(o,k),M(V,k,null),n(v,A),n(v,z),c(e,H,d),c(e,$,d),c(e,x,d),c(e,J,d),c(e,Uo,d),c(e,pt,d),c(e,Co,d),c(e,ht,d),c(e,Fo,d),c(e,ut,d),c(e,Io,d),c(e,se,d),n(se,ke),n(ke,no),M(mt,no,null),n(se,Cs),n(se,hn),c(e,No,d),c(e,ft,d),c(e,qo,d),c(e,ae,d),n(ae,we),n(we,oo),M(gt,oo,null),n(ae,Fs),n(ae,un),c(e,Zo,d),c(e,_t,d),c(e,Wo,d),c(e,re,d),n(re,xe),n(xe,so),M(Mt,so,null),n(re,Is),n(re,mn),c(e,Ho,d),c(e,yt,d),c(e,So,d),c(e,le,d),n(le,je),n(je,ao),M(Tt,ao,null),n(le,Ns),n(le,fn),c(e,Lo,d),c(e,bt,d),c(e,Vo,d),c(e,vt,d),c(e,Ao,d),M(kt,e,d),c(e,Ro,d),c(e,wt,d),c(e,Go,d),M(xt,e,d),c(e,Eo,d),c(e,ie,d),n(ie,Je),n(Je,ro),M(jt,ro,null),n(ie,qs),n(ie,gn),c(e,Po,d),c(e,Jt,d),c(e,Bo,d),M($t,e,d),c(e,Xo,d),c(e,zt,d),c(e,Qo,d),M(Ut,e,d),c(e,Yo,d),c(e,de,d),n(de,$e),n($e,lo),M(Ct,lo,null),n(de,Zs),n(de,_n),c(e,Oo,d),c(e,Ft,d),c(e,Do,d),c(e,ce,d),n(ce,ze),n(ze,io),M(It,io,null),n(ce,Ws),n(ce,Mn),c(e,Ko,d),c(e,R,d),M(Nt,R,null),n(R,Hs),n(R,yn),n(R,Ss),n(R,Tn),n(R,Ls),M(Ue,R,null),c(e,es,d),c(e,pe,d),n(pe,Ce),n(Ce,co),M(qt,co,null),n(pe,Vs),n(pe,bn),c(e,ts,d),c(e,q,d),M(Zt,q,null),n(q,As),n(q,vn),n(q,Rs),n(q,kn),n(q,Gs),M(Fe,q,null),n(q,Es),n(q,Ie),M(Wt,Ie,null),n(Ie,Ps),n(Ie,wn),c(e,ns,d),c(e,he,d),n(he,Ne),n(Ne,po),M(Ht,po,null),n(he,Bs),n(he,xn),c(e,os,d),c(e,G,d),M(St,G,null),n(G,Xs),n(G,jn),n(G,Qs),n(G,Jn),n(G,Ys),n(G,B),M(Lt,B,null),n(B,Os),n(B,$n),n(B,Ds),M(qe,B,null),n(B,Ks),M(Ze,B,null),c(e,ss,d),c(e,ue,d),n(ue,We),n(We,ho),M(Vt,ho,null),n(ue,ea),n(ue,zn),c(e,as,d),c(e,E,d),M(At,E,null),n(E,ta),n(E,Un),n(E,na),n(E,Cn),n(E,oa),n(E,S),M(Rt,S,null),n(S,sa),n(S,Fn),n(S,aa),M(He,S,null),n(S,ra),n(S,In),n(S,la),M(Se,S,null),c(e,rs,d),c(e,me,d),n(me,Le),n(Le,uo),M(Gt,uo,null),n(me,ia),n(me,Nn),c(e,ls,d),c(e,fe,d),M(Et,fe,null),n(fe,da),n(fe,Ve),M(Pt,Ve,null),n(Ve,ca),M(Ae,Ve,null),c(e,is,d),c(e,ge,d),n(ge,Re),n(Re,mo),M(Bt,mo,null),n(ge,pa),n(ge,qn),c(e,ds,d),c(e,Z,d),M(Xt,Z,null),n(Z,ha),n(Z,Zn),n(Z,ua),n(Z,Wn),n(Z,ma),M(Ge,Z,null),n(Z,fa),n(Z,X),M(Qt,X,null),n(X,ga),n(X,Hn),n(X,_a),M(Ee,X,null),n(X,Ma),M(Pe,X,null),c(e,cs,d),c(e,_e,d),n(_e,Be),n(Be,fo),M(Yt,fo,null),n(_e,ya),n(_e,Sn),c(e,ps,d),c(e,W,d),M(Ot,W,null),n(W,Ta),n(W,Ln),n(W,ba),n(W,Vn),n(W,va),M(Xe,W,null),n(W,ka),n(W,L),M(Dt,L,null),n(L,wa),n(L,An),n(L,xa),M(Qe,L,null),n(L,ja),n(L,Rn),n(L,Ja),M(Ye,L,null),c(e,hs,d),c(e,Me,d),n(Me,Oe),n(Oe,go),M(Kt,go,null),n(Me,$a),n(Me,Gn),c(e,us,d),c(e,U,d),M(en,U,null),n(U,za),n(U,En),n(U,Ua),n(U,Pn),n(U,Ca),n(U,Bn),n(U,Fa),n(U,Xn),n(U,Ia),n(U,Q),M(tn,Q,null),n(Q,Na),n(Q,Qn),n(Q,qa),M(De,Q,null),n(Q,Za),M(Ke,Q,null),c(e,ms,d),c(e,ye,d),n(ye,et),n(et,_o),M(nn,_o,null),n(ye,Wa),n(ye,Yn),c(e,fs,d),c(e,C,d),M(on,C,null),n(C,Ha),n(C,On),n(C,Sa),n(C,Dn),n(C,La),n(C,Kn),n(C,Va),n(C,eo),n(C,Aa),n(C,Y),M(sn,Y,null),n(Y,Ra),n(Y,to),n(Y,Ga),M(tt,Y,null),n(Y,Ea),M(nt,Y,null),c(e,gs,d),c(e,Mo,d),_s=!0},p(e,[d]){const an={};d&2&&(an.$$scope={dirty:d,ctx:e}),Ue.$set(an);const yo={};d&2&&(yo.$$scope={dirty:d,ctx:e}),Fe.$set(yo);const To={};d&2&&(To.$$scope={dirty:d,ctx:e}),qe.$set(To);const rn={};d&2&&(rn.$$scope={dirty:d,ctx:e}),Ze.$set(rn);const bo={};d&2&&(bo.$$scope={dirty:d,ctx:e}),He.$set(bo);const vo={};d&2&&(vo.$$scope={dirty:d,ctx:e}),Se.$set(vo);const ln={};d&2&&(ln.$$scope={dirty:d,ctx:e}),Ae.$set(ln);const ko={};d&2&&(ko.$$scope={dirty:d,ctx:e}),Ge.$set(ko);const wo={};d&2&&(wo.$$scope={dirty:d,ctx:e}),Ee.$set(wo);const dn={};d&2&&(dn.$$scope={dirty:d,ctx:e}),Pe.$set(dn);const xo={};d&2&&(xo.$$scope={dirty:d,ctx:e}),Xe.$set(xo);const jo={};d&2&&(jo.$$scope={dirty:d,ctx:e}),Qe.$set(jo);const cn={};d&2&&(cn.$$scope={dirty:d,ctx:e}),Ye.$set(cn);const Jo={};d&2&&(Jo.$$scope={dirty:d,ctx:e}),De.$set(Jo);const $o={};d&2&&($o.$$scope={dirty:d,ctx:e}),Ke.$set($o);const pn={};d&2&&(pn.$$scope={dirty:d,ctx:e}),tt.$set(pn);const zo={};d&2&&(zo.$$scope={dirty:d,ctx:e}),nt.$set(zo)},i(e){_s||(y(V.$$.fragment,e),y(mt.$$.fragment,e),y(gt.$$.fragment,e),y(Mt.$$.fragment,e),y(Tt.$$.fragment,e),y(kt.$$.fragment,e),y(xt.$$.fragment,e),y(jt.$$.fragment,e),y($t.$$.fragment,e),y(Ut.$$.fragment,e),y(Ct.$$.fragment,e),y(It.$$.fragment,e),y(Nt.$$.fragment,e),y(Ue.$$.fragment,e),y(qt.$$.fragment,e),y(Zt.$$.fragment,e),y(Fe.$$.fragment,e),y(Wt.$$.fragment,e),y(Ht.$$.fragment,e),y(St.$$.fragment,e),y(Lt.$$.fragment,e),y(qe.$$.fragment,e),y(Ze.$$.fragment,e),y(Vt.$$.fragment,e),y(At.$$.fragment,e),y(Rt.$$.fragment,e),y(He.$$.fragment,e),y(Se.$$.fragment,e),y(Gt.$$.fragment,e),y(Et.$$.fragment,e),y(Pt.$$.fragment,e),y(Ae.$$.fragment,e),y(Bt.$$.fragment,e),y(Xt.$$.fragment,e),y(Ge.$$.fragment,e),y(Qt.$$.fragment,e),y(Ee.$$.fragment,e),y(Pe.$$.fragment,e),y(Yt.$$.fragment,e),y(Ot.$$.fragment,e),y(Xe.$$.fragment,e),y(Dt.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Kt.$$.fragment,e),y(en.$$.fragment,e),y(tn.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(nn.$$.fragment,e),y(on.$$.fragment,e),y(sn.$$.fragment,e),y(tt.$$.fragment,e),y(nt.$$.fragment,e),_s=!0)},o(e){T(V.$$.fragment,e),T(mt.$$.fragment,e),T(gt.$$.fragment,e),T(Mt.$$.fragment,e),T(Tt.$$.fragment,e),T(kt.$$.fragment,e),T(xt.$$.fragment,e),T(jt.$$.fragment,e),T($t.$$.fragment,e),T(Ut.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Nt.$$.fragment,e),T(Ue.$$.fragment,e),T(qt.$$.fragment,e),T(Zt.$$.fragment,e),T(Fe.$$.fragment,e),T(Wt.$$.fragment,e),T(Ht.$$.fragment,e),T(St.$$.fragment,e),T(Lt.$$.fragment,e),T(qe.$$.fragment,e),T(Ze.$$.fragment,e),T(Vt.$$.fragment,e),T(At.$$.fragment,e),T(Rt.$$.fragment,e),T(He.$$.fragment,e),T(Se.$$.fragment,e),T(Gt.$$.fragment,e),T(Et.$$.fragment,e),T(Pt.$$.fragment,e),T(Ae.$$.fragment,e),T(Bt.$$.fragment,e),T(Xt.$$.fragment,e),T(Ge.$$.fragment,e),T(Qt.$$.fragment,e),T(Ee.$$.fragment,e),T(Pe.$$.fragment,e),T(Yt.$$.fragment,e),T(Ot.$$.fragment,e),T(Xe.$$.fragment,e),T(Dt.$$.fragment,e),T(Qe.$$.fragment,e),T(Ye.$$.fragment,e),T(Kt.$$.fragment,e),T(en.$$.fragment,e),T(tn.$$.fragment,e),T(De.$$.fragment,e),T(Ke.$$.fragment,e),T(nn.$$.fragment,e),T(on.$$.fragment,e),T(sn.$$.fragment,e),T(tt.$$.fragment,e),T(nt.$$.fragment,e),_s=!1},d(e){e&&(t(w),t(h),t(p),t(v),t(H),t($),t(x),t(J),t(Uo),t(pt),t(Co),t(ht),t(Fo),t(ut),t(Io),t(se),t(No),t(ft),t(qo),t(ae),t(Zo),t(_t),t(Wo),t(re),t(Ho),t(yt),t(So),t(le),t(Lo),t(bt),t(Vo),t(vt),t(Ao),t(Ro),t(wt),t(Go),t(Eo),t(ie),t(Po),t(Jt),t(Bo),t(Xo),t(zt),t(Qo),t(Yo),t(de),t(Oo),t(Ft),t(Do),t(ce),t(Ko),t(R),t(es),t(pe),t(ts),t(q),t(ns),t(he),t(os),t(G),t(ss),t(ue),t(as),t(E),t(rs),t(me),t(ls),t(fe),t(is),t(ge),t(ds),t(Z),t(cs),t(_e),t(ps),t(W),t(hs),t(Me),t(us),t(U),t(ms),t(ye),t(fs),t(C),t(gs),t(Mo)),t(r),b(V),b(mt),b(gt),b(Mt),b(Tt),b(kt,e),b(xt,e),b(jt),b($t,e),b(Ut,e),b(Ct),b(It),b(Nt),b(Ue),b(qt),b(Zt),b(Fe),b(Wt),b(Ht),b(St),b(Lt),b(qe),b(Ze),b(Vt),b(At),b(Rt),b(He),b(Se),b(Gt),b(Et),b(Pt),b(Ae),b(Bt),b(Xt),b(Ge),b(Qt),b(Ee),b(Pe),b(Yt),b(Ot),b(Xe),b(Dt),b(Qe),b(Ye),b(Kt),b(en),b(tn),b(De),b(Ke),b(nn),b(on),b(sn),b(tt),b(nt)}}}const Sl={local:"marianmt",sections:[{local:"implementation-notes",title:"Implementation Notes"},{local:"naming",title:"Naming"},{local:"examples",title:"Examples"},{local:"multilingual-models",title:"Multilingual Models"},{local:"old-style-multilingual-models",title:"Old Style Multi-Lingual Models"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.MarianConfig",title:"MarianConfig"},{local:"transformers.MarianTokenizer",title:"MarianTokenizer"},{local:"transformers.MarianModel",title:"MarianModel"},{local:"transformers.MarianMTModel",title:"MarianMTModel"},{local:"transformers.MarianForCausalLM",title:"MarianForCausalLM"},{local:"transformers.TFMarianModel",title:"TFMarianModel"},{local:"transformers.TFMarianMTModel",title:"TFMarianMTModel"},{local:"transformers.FlaxMarianModel",title:"FlaxMarianModel"},{local:"transformers.FlaxMarianMTModel",title:"FlaxMarianMTModel"}],title:"MarianMT"};function Ll(j){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends Ml{constructor(r){super(),yl(this,r,Ll,Hl,gl,{})}}export{Xl as component};
