import{s as gk,o as uk,n as C}from"../chunks/scheduler.9bc65507.js";import{S as hk,i as fk,g as o,s as r,u as d,A as _k,h as s,f as n,c as a,j as f,v as p,y as b,k as l,o as t,a as c,w as m,d as g,t as u,x as h}from"../chunks/index.78c82d43.js";import{T as no}from"../chunks/Tip.87d55b76.js";import{D as T}from"../chunks/Docstring.f3d04bd2.js";import{C as q}from"../chunks/CodeBlock.48618ec2.js";import{I as Z}from"../chunks/IconCopyLink.bedaa44d.js";import{E as G}from"../chunks/ExampleCodeBlock.872b014d.js";function bk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function vk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Tk(M){let v,k=`Diverse beam search can be particularly useful in scenarios where a variety of different outputs is desired, rather
than multiple similar sequences. It allows the model to explore different generation paths and provides a broader
coverage of possible outputs.`;return{c(){v=o("p"),v.textContent=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-xttj3z"&&(v.textContent=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function yk(M){let v,k="This logits processor can be resource-intensive, especially when using large models or long sequences.";return{c(){v=o("p"),v.textContent=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-6lf7c0"&&(v.textContent=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function $k(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function wk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwSWYlMjB0aGUlMjBtYXhpbXVtJTIwbGVuZ3RoJTIwKGRlZmF1bHQlMjAlM0QlMjAyMCklMjBpcyUyMHNtYWxsZXIlMjB0aGFuJTIwdGhlJTIwbWluaW11bSUyMGxlbmd0aCUyMGNvbnN0cmFpbnQlMkMlMjB0aGUlMjBsYXR0ZXIlMjBpcyUyMGlnbm9yZWQhJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QzMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEZvciUyMHRlc3RpbmclMjBwdXJwb3NlcyUyQyUyMGxldCdzJTIwc2V0JTIwJTYwZW9zX3Rva2VuJTYwJTIwdG8lMjAlNjAlMjJjb21wYW55JTIyJTYwJTJDJTIwdGhlJTIwZmlyc3QlMjBnZW5lcmF0ZWQlMjB0b2tlbi4lMjBUaGlzJTIwd2lsbCUyMG1ha2UlMEElMjMlMjBnZW5lcmF0aW9uJTIwZW5kJTIwdGhlcmUuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEluY3JlYXNpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBtYWtlJTIwZ2VuZXJhdGlvbiUyMGlnbm9yZSUyMG9jY3VyZW5jZXMlMjAlNjAlMjJjb21wYW55JTIyJTYwJTIwKGVvcyUyMHRva2VuKSUyMGJlZm9yZSUyMHRoZSUwQSUyMyUyMG1pbmltdW0lMjBsZW5ndGglMjBjb25kaXRpb24lMjBpcyUyMGhvbm9yZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QyJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If the maximum length (default = 20) is smaller than the minimum length constraint, the latter is ignored!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been working on a new product <span class="hljs-keyword">for</span> the past year.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For testing purposes, let&#x27;s set \`eos_token\` to \`&quot;company&quot;\`, the first generated token. This will make</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generation end there.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Increasing \`min_new_tokens\` will make generation ignore occurences \`&quot;company&quot;\` (eos token) before the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># minimum length condition is honored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new company`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function kk(M){let v,k=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){v=o("p"),v.innerHTML=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-15bvr1j"&&(v.innerHTML=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function xk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Mk(M){let v,k=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){v=o("p"),v.innerHTML=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-5zfsi9"&&(v.innerHTML=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function Lk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function jk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Fk(M){let v,k=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){v=o("p"),v.innerHTML=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-16cusgy"&&(v.innerHTML=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function zk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Ck(M){let v,k=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){v=o("p"),v.innerHTML=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-1byeoum"&&(v.innerHTML=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function Jk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Uk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Ik(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function qk(M){let v,k;return v=new q({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`}}),{c(){d(v.$$.fragment)},l(y){p(v.$$.fragment,y)},m(y,$){m(v,y,$),k=!0},p:C,i(y){k||(g(v.$$.fragment,y),k=!0)},o(y){u(v.$$.fragment,y),k=!1},d(y){h(v,y)}}}function Bk(M){let v,k="The API for the streamer classes is still under development and may change in the future.";return{c(){v=o("p"),v.textContent=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-gv2g1g"&&(v.textContent=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function Sk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Wk(M){let v,k="The API for the streamer classes is still under development and may change in the future.";return{c(){v=o("p"),v.textContent=k},l(y){v=s(y,"P",{"data-svelte-h":!0}),b(v)!=="svelte-gv2g1g"&&(v.textContent=k)},m(y,$){c(y,v,$)},p:C,d(y){y&&n(v)}}}function Pk(M){let v,k="Examples:",y,$,w;return $=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`}}),{c(){v=o("p"),v.textContent=k,y=r(),d($.$$.fragment)},l(_){v=s(_,"P",{"data-svelte-h":!0}),b(v)!=="svelte-kvfsh7"&&(v.textContent=k),y=a(_),p($.$$.fragment,_)},m(_,x){c(_,v,x),c(_,y,x),m($,_,x),w=!0},p:C,i(_){w||(g($.$$.fragment,_),w=!0)},o(_){u($.$$.fragment,_),w=!1},d(_){_&&(n(v),n(y)),h($,_)}}}function Vk(M){let v,k,y,$,w,_,x,oo,Nh,hi,UT="Utilities for Generation",Sm,so,IT=`This page lists all the utility functions used by <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, and
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>.`,Wm,ro,qT="Most of those are only useful if you are studying the code of the generate methods in the library.",Pm,dt,Xt,hm,ao,Xh,fi,BT="Generate Outputs",Vm,io,ST=`The output of <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Dm,co,WT="Here’s an example:",Em,lo,Zm,po,PT=`The <code>generation_output</code> object is a <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput">GreedySearchDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Gm,mo,VT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Nm,go,DT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Xm,uo,ET=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Hm,ho,ZT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Rm,fo,Om,_o,GT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Qm,bo,NT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Am,vo,XT="We document here all output types.",Ym,pt,Ht,fm,To,Hh,_i,HT="PyTorch",Km,mt,yo,Rh,bi,RT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,eg,gt,$o,Oh,vi,OT="Base class for outputs of decoder-only generation models using greedy search.",tg,ut,wo,Qh,Ti,QT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ng,ht,ko,Ah,yi,AT="Base class for outputs of decoder-only generation models using sampling.",og,ft,xo,Yh,$i,YT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,sg,_t,Mo,Kh,wi,KT="Base class for outputs of decoder-only generation models using beam search.",rg,bt,Lo,ef,ki,ey=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ag,vt,jo,tf,xi,ty="Base class for outputs of decoder-only generation models using beam sample.",ig,Tt,Fo,nf,Mi,ny="Base class for outputs of decoder-only generation models using contrastive search.",cg,yt,zo,of,Li,oy="Base class for outputs of decoder-only generation models using contrastive search.",lg,$t,Rt,_m,Co,sf,ji,sy="TensorFlow",dg,wt,Jo,rf,Fi,ry=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,pg,kt,Uo,af,zi,ay="Base class for outputs of decoder-only generation models using greedy search.",mg,xt,Io,cf,Ci,iy=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,gg,Mt,qo,lf,Ji,cy="Base class for outputs of decoder-only generation models using sampling.",ug,Lt,Bo,df,Ui,ly=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,hg,jt,So,pf,Ii,dy="Base class for outputs of decoder-only generation models using beam search.",fg,Ft,Wo,mf,qi,py=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,_g,zt,Po,gf,Bi,my="Base class for outputs of decoder-only generation models using beam sample.",bg,Ct,Vo,uf,Si,gy=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,vg,Jt,Do,hf,Wi,uy="Base class for outputs of decoder-only generation models using contrastive search.",Tg,Ut,Ot,bm,Eo,ff,Pi,hy="FLAX",yg,oe,Zo,_f,Vi,fy="Flax Base class for outputs of decoder-only generation models using sampling.",bf,Qt,Go,vf,Di,_y="“Returns a new object replacing the specified fields with new values.",$g,se,No,Tf,Ei,by="Flax Base class for outputs of decoder-only generation models using greedy search.",yf,At,Xo,$f,Zi,vy="“Returns a new object replacing the specified fields with new values.",wg,re,Ho,wf,Gi,Ty="Flax Base class for outputs of decoder-only generation models using greedy search.",kf,Yt,Ro,xf,Ni,yy="“Returns a new object replacing the specified fields with new values.",kg,It,Kt,vm,Oo,Mf,Xi,$y="LogitsProcessor",xg,Qo,wy=`A <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,Mg,qt,en,Tm,Ao,Lf,Hi,ky="PyTorch",Lg,ae,Yo,jf,Ri,xy='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of <code>Bark</code>’s fine submodel.',Ff,Oi,Ko,jg,N,es,zf,Qi,My=`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Cf,Ai,Ly='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Jf,Yi,ts,Fg,ie,ns,Uf,Ki,jy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces no repetition of encoder input ids n-grams for the decoder ids. See
<a href="https://github.com/facebookresearch/ParlAI/blob/master/parlai/core/torch_generator_agent.py#L1350" rel="nofollow">ParlAI</a>.`,If,ec,os,zg,ce,ss,qf,tc,Fy='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing an exponential penalty on tokens that are not in the original input.',Bf,nc,rs,Cg,X,as,Sf,oc,zy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,Wf,tn,Pf,sc,is,Jg,H,cs,Vf,rc,Cy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,Df,nn,Ef,ac,ls,Ug,le,ds,Zf,ic,Jy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the eos_token_id after regulation_start has been
reached.`,Gf,cc,ps,Ig,de,ms,Nf,lc,Uy='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token.',Xf,dc,gs,qg,pe,us,Hf,pc,Iy='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Rf,mc,hs,Bg,me,fs,Of,gc,qy=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index.`,Qf,uc,_s,Sg,L,bs,Af,hc,By='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',Yf,fc,Sy=`Note that this logits processor is only effective for <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,Kf,on,e_,sn,t_,_c,Wy=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,n_,bc,Py="How It Works:",o_,vc,Vy=`<li><strong>Grouping Beams</strong>: Beams are divided into groups. Each group selects tokens independently of the others.</li> <li><strong>Penalizing Repeated Tokens</strong>: If a beam in a group selects a token already chosen by another group in the
same step, a penalty is applied to that token’s score.</li> <li><strong>Promoting Diversity</strong>: This penalty discourages beams within a group from selecting the same tokens as
beams in other groups.</li>`,s_,Tc,Dy="Benefits:",r_,yc,Ey="<li><strong>Diverse Outputs</strong>: Produces a variety of different sequences.</li> <li><strong>Exploration</strong>: Allows the model to explore different paths.</li>",a_,rn,i_,$c,vs,Wg,ge,Ts,c_,wc,Zy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,l_,kc,ys,Pg,ue,$s,d_,xc,Gy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,p_,Mc,ws,Vg,he,ks,m_,Lc,Ny="Abstract base class for all logit processors that can be applied during generation.",g_,jc,xs,Dg,fe,Ms,u_,Fc,Xy=`This class can be used to create a list of <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,h_,zc,Ls,Eg,_e,js,f_,Cc,Hy="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",__,Jc,Fs,Zg,be,zs,b_,Uc,Ry='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',v_,Ic,Cs,Gg,R,Js,T_,qc,Oy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, <code>min_length</code> will compute the length of <code>prompt + newly generated tokens</code> whereas for other models it will behave as <code>min_new_tokens</code>, that is, taking only into account
the newly generated ones.`,y_,an,$_,Bc,Us,Ng,B,Is,w_,Sc,Qy='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',k_,cn,x_,ln,M_,Wc,qs,Xg,S,Bs,L_,Pc,Ay=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,j_,dn,F_,pn,z_,Vc,Ss,Hg,ve,Ws,C_,Dc,Yy=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,J_,Ec,Ps,Rg,O,Vs,U_,Zc,Ky=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are less likely to be
selected. The formula can be seen in the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`,I_,mn,q_,Gc,Ds,Og,W,Es,B_,Nc,e$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,S_,gn,W_,un,P_,Xc,Zs,Qg,Te,Gs,V_,Hc,t$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,D_,Rc,Ns,Ag,ye,Xs,E_,Oc,n$=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,Z_,Qc,Hs,Yg,P,Rs,G_,Ac,o$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`,N_,hn,X_,fn,H_,Yc,Os,Kg,$e,Qs,R_,Kc,s$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',O_,el,As,eu,Q,Ys,Q_,tl,r$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',A_,_n,Y_,nl,Ks,tu,we,er,K_,ol,a$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language
Generation</a> for more information.`,eb,sl,tr,nu,V,nr,tb,rl,i$=`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the <code>guidance_scale</code>. The unconditional scores are computed internally by prompting <code>model</code> with
the <code>unconditional_ids</code> branch.`,nb,al,c$='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',ob,bn,sb,il,or,ou,A,sr,rb,cl,l$=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,ab,ll,d$='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',ib,dl,rr,su,Bt,vn,ym,ar,cb,pl,p$="TensorFlow",ru,ke,ir,lb,ml,m$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',db,gl,cr,au,xe,lr,pb,ul,g$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',mb,hl,dr,iu,Me,pr,gb,fl,u$=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,ub,_l,mr,cu,Le,gr,hb,bl,h$="Abstract base class for all logit processors that can be applied during generation.",fb,Tn,ur,_b,vl,f$="TF method for processing logits.",lu,je,hr,bb,Tl,_$=`This class can be used to create a list of <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,vb,yl,fr,du,Fe,_r,Tb,$l,b$="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",yb,yn,br,$b,wl,v$="TF method for warping logits.",pu,ze,vr,wb,kl,T$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',kb,xl,Tr,mu,Ce,yr,xb,Ml,y$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Mb,Ll,$r,gu,Je,wr,Lb,jl,$$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,jb,Fl,kr,uu,Ue,xr,Fb,zl,w$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',zb,Cl,Mr,hu,Ie,Lr,Cb,Jl,k$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,Jb,Ul,jr,fu,qe,Fr,Ub,Il,x$=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,Ib,ql,zr,_u,Be,Cr,qb,Bl,M$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Bb,Sl,Jr,bu,Se,Ur,Sb,Wl,L$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Wb,Pl,Ir,vu,We,qr,Pb,Vl,j$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',Vb,Dl,Br,Tu,St,$n,$m,Sr,Db,El,F$="FLAX",yu,Pe,Wr,Eb,Zl,z$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Zb,Gl,Pr,$u,Ve,Vr,Gb,Nl,C$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Nb,Xl,Dr,wu,De,Er,Xb,Hl,J$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Hb,Rl,Zr,ku,Ee,Gr,Rb,Ol,U$="Abstract base class for all logit processors that can be applied during generation.",Ob,wn,Nr,Qb,Ql,I$="Flax method for processing logits.",xu,Ze,Xr,Ab,Al,q$=`This class can be used to create a list of <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Yb,Yl,Hr,Mu,Ge,Rr,Kb,Kl,B$="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",ev,kn,Or,tv,ed,S$="Flax method for warping logits.",Lu,Ne,Qr,nv,td,W$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',ov,nd,Ar,ju,Xe,Yr,sv,od,P$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,rv,sd,Kr,Fu,He,ea,av,rd,V$=`<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,iv,ad,ta,zu,Re,na,cv,id,D$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',lv,cd,oa,Cu,Oe,sa,dv,ld,E$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',pv,dd,ra,Ju,Qe,aa,mv,pd,Z$='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',gv,md,ia,Uu,Ae,ca,uv,gd,G$=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,hv,ud,la,Iu,Wt,xn,wm,da,fv,hd,N$="StoppingCriteria",qu,pa,X$='A <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations.',Bu,Ye,ma,_v,fd,H$="Abstract base class for all stopping criteria that can be applied during generation.",bv,_d,ga,Su,Pt,ua,vv,bd,ha,Wu,Ke,fa,Tv,vd,R$=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,yv,Td,_a,Pu,et,ba,$v,yd,O$=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,wv,$d,va,Vu,Vt,Mn,km,Ta,kv,wd,Q$="Constraints",Du,ya,A$='A <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations.',Eu,j,$a,xv,kd,Y$=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,Mv,xd,K$="All classes that inherit Constraint must follow the requirement that",Lv,Ln,jv,Md,e1="will always terminate (halt).",Fv,jn,wa,zv,Ld,t1="When called, returns the token that would take this constraint one step closer to being fulfilled.",Cv,Fn,ka,Jv,jd,n1="Creates a new instance of this constraint.",Uv,zn,xa,Iv,Fd,o1="Reads in a token and returns whether it creates progress.",qv,Cn,Ma,Bv,zd,s1="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",Sv,Jn,La,Wv,Cd,r1=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,Pv,Un,ja,Vv,Jd,a1="Tests whether this constraint has been properly defined.",Dv,ot,Fa,Ev,Ud,i1=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,Zv,Id,c1=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Zu,Dt,za,Gv,qd,l1='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Gu,Et,Ca,Nv,Bd,d1='A special <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Nu,Y,Ja,Xv,Sd,p1="A class for beam scorers to track its progress through a list of constraints.",Hv,I,Ua,Rv,Wd,m1=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Ov,Pd,g1=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Qv,Vd,u1="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",Av,Dd,h1=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,Yv,Ed,f1=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,Kv,In,Ia,eT,Zd,_1="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Xu,Zt,qn,xm,qa,tT,Gd,b1="BeamSearch",Hu,K,Ba,nT,Nd,v1=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,oT,Xd,Sa,sT,Hd,Wa,Ru,U,Pa,rT,Rd,T1='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',aT,Od,y1=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,iT,Qd,$1=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,cT,Ad,Va,lT,Yd,Da,Ou,ee,Ea,dT,Kd,w1='<a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',pT,ep,Za,mT,tp,Ga,Qu,Gt,Bn,Mm,Na,gT,np,k1="Utilities",Au,tt,Xa,uT,op,x1="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",hT,sp,M1='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Yu,nt,Ha,fT,rp,L1="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",_T,ap,j1='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Ku,Nt,Sn,Lm,Ra,bT,ip,F1="Streamers",eh,J,Oa,vT,cp,z1="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",TT,Wn,yT,Pn,$T,Vn,Qa,wT,lp,C1="Flushes any remaining cache and prints a newline to stdout.",kT,Dn,Aa,xT,dp,J1="Prints the new text to stdout. If the stream is ending, also prints a newline.",MT,En,Ya,LT,pp,U1="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",th,D,Ka,jT,mp,I1=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,FT,Zn,zT,Gn,CT,Nn,ei,JT,gp,q1="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",nh,jm,oh;return oo=new Z({}),ao=new Z({}),lo=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`}}),fo=new q({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]'}}),To=new Z({}),yo=new T({props:{name:"class transformers.generation.GreedySearchEncoderDecoderOutput",anchor:"transformers.generation.GreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L184"}}),$o=new T({props:{name:"class transformers.generation.GreedySearchDecoderOnlyOutput",anchor:"transformers.generation.GreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L88"}}),wo=new T({props:{name:"class transformers.generation.SampleEncoderDecoderOutput",anchor:"transformers.generation.SampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape
<code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L255"}}),ko=new T({props:{name:"class transformers.generation.SampleDecoderOnlyOutput",anchor:"transformers.generation.SampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L226"}}),xo=new T({props:{name:"class transformers.generation.BeamSearchEncoderDecoderOutput",anchor:"transformers.generation.BeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L333"}}),Mo=new T({props:{name:"class transformers.generation.BeamSearchDecoderOnlyOutput",anchor:"transformers.generation.BeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L298"}}),Lo=new T({props:{name:"class transformers.generation.BeamSampleEncoderDecoderOutput",anchor:"transformers.generation.BeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>).`,name:"scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L418"}}),jo=new T({props:{name:"class transformers.generation.BeamSampleDecoderOnlyOutput",anchor:"transformers.generation.BeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L383"}}),Fo=new T({props:{name:"class transformers.generation.ContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L116"}}),zo=new T({props:{name:"class transformers.generation.ContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when &#x2014;
<code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.hidden_states",description:"<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is &#x2014;",name:"hidden_states"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.passed",description:`<strong>passed</strong> or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"passed"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L155"}}),Co=new Z({}),Jo=new T({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L86"}}),Uo=new T({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L58"}}),Io=new T({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L156"}}),qo=new T({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L128"}}),Bo=new T({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L233"}}),So=new T({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L198"}}),Wo=new T({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L318"}}),Po=new T({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L283"}}),Vo=new T({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L394"}}),Do=new T({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L367"}}),Eo=new Z({}),Zo=new T({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_utils.py#L69"}}),Go=new T({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),No=new T({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_utils.py#L55"}}),Xo=new T({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Ho=new T({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_utils.py#L83"}}),Ro=new T({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Oo=new Z({}),Ao=new Z({}),Yo=new T({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1505"}}),Ko=new T({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1526"}}),es=new T({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1465"}}),ts=new T({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1489",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ns=new T({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L763"}}),os=new T({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L786",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ss=new T({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.hallucination_penalty",description:`<strong>hallucination_penalty</strong> (<code>float</code>) &#x2014;
The parameter for hallucination penalty. 1.0 means no penalty.`,name:"hallucination_penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L323"}}),rs=new T({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L341",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),as=new T({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L493"}}),tn=new G({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[bk]},$$scope:{ctx:M}}}),is=new T({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L546",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),cs=new T({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L560"}}),nn=new G({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[vk]},$$scope:{ctx:M}}}),ls=new T({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L623",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ds=new T({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1298"}}),ps=new T({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1325",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ms=new T({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1230"}}),gs=new T({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1242",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),us=new T({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1252"}}),hs=new T({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1270",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fs=new T({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1380"}}),_s=new T({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1388",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bs=new T({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if group beam search is enabled. The
penalty applied to a beam&#x2019;s score when it generates a token that has already been chosen by another beam
within the same group during the same time step. A higher <code>diversity_penalty</code> will enforce greater
diversity among the beams, making it less likely for multiple beams to choose the same token. Conversely, a
lower penalty will allow beams to more freely choose similar tokens. Adjusting this value can help strike a
balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams used for group beam search. Beam search is a method used that maintains beams (or &#x201C;multiple
hypotheses&#x201D;) at each step, expanding each one and keeping the top-scoring sequences. A higher <code>num_beams</code>
will explore more potential sequences. This can increase chances of finding a high-quality output but also
increases computational cost.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
Each group of beams will operate independently, selecting tokens without considering the choices of other
groups. This division promotes diversity by ensuring that beams within different groups explore different
paths. For instance, if <code>num_beams</code> is 6 and <code>num_beam_groups</code> is 2, there will be 2 groups each containing
3 beams. The choice of <code>num_beam_groups</code> should be made considering the desired level of output diversity
and the total number of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1067"}}),on=new no({props:{$$slots:{default:[Tk]},$$scope:{ctx:M}}}),sn=new no({props:{warning:!0,$$slots:{default:[yk]},$$scope:{ctx:M}}}),rn=new G({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[$k]},$$scope:{ctx:M}}}),vs=new T({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1184",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ts=new T({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1281"}}),ys=new T({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1287",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$s=new T({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1334"}}),ws=new T({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1342",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ks=new T({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L44"}}),xs=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L47",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ms=new T({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L64"}}),Ls=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L71",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),js=new T({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L54"}}),Fs=new T({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L57",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zs=new T({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L101"}}),Cs=new T({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L124",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Js=new T({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L133"}}),an=new G({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[wk]},$$scope:{ctx:M}}}),Us=new T({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L195",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Is=new T({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L953"}}),cn=new no({props:{$$slots:{default:[kk]},$$scope:{ctx:M}}}),ln=new G({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[xk]},$$scope:{ctx:M}}}),qs=new T({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L876",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bs=new T({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L706"}}),dn=new no({props:{$$slots:{default:[Mk]},$$scope:{ctx:M}}}),pn=new G({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[Lk]},$$scope:{ctx:M}}}),Ss=new T({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L752",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ws=new T({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1040"}}),Ps=new T({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1057",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vs=new T({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L270"}}),mn=new G({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[jk]},$$scope:{ctx:M}}}),Ds=new T({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L312",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Es=new T({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.Dict[typing.Tuple[int], float]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L805"}}),gn=new no({props:{$$slots:{default:[Fk]},$$scope:{ctx:M}}}),un=new G({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[zk]},$$scope:{ctx:M}}}),Zs=new T({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L876",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gs=new T({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1348"}}),Ns=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1359",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xs=new T({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1367"}}),Hs=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1374",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rs=new T({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L205"}}),hn=new no({props:{$$slots:{default:[Ck]},$$scope:{ctx:M}}}),fn=new G({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[Jk]},$$scope:{ctx:M}}}),Os=new T({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L264",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qs=new T({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L415"}}),As=new T({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L435",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ys=new T({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L352"}}),_n=new G({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[Uk]},$$scope:{ctx:M}}}),Ks=new T({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L399",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),er=new T({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L444"}}),tr=new T({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L469",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),nr=new T({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <strong>optional</strong>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.smooth_factor",description:`<strong>smooth_factor</strong> (<code>float</code>, <strong>optional</strong>) &#x2014;
The interpolation weight for CFG Rescale. 1 means no rescaling, 0 reduces to the conditional scores without
CFG. Turn it lower if the output degenerates.`,name:"smooth_factor"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1541"}}),bn=new G({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Ik]},$$scope:{ctx:M}}}),or=new T({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1650"}}),sr=new T({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1398"}}),rr=new T({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/logits_process.py#L1427",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ar=new Z({}),ir=new T({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L448"}}),cr=new T({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L462"}}),lr=new T({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L478"}}),dr=new T({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L495"}}),pr=new T({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L551"}}),mr=new T({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L567"}}),gr=new T({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L53"}}),ur=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),hr=new T({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L75"}}),fr=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_r=new T({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L64"}}),br=new T({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vr=new T({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L202"}}),Tr=new T({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L228"}}),yr=new T({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L288"}}),$r=new T({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L367"}}),wr=new T({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L388"}}),kr=new T({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L427"}}),xr=new T({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L238"}}),Mr=new T({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L280"}}),Lr=new T({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L511"}}),jr=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L522"}}),Fr=new T({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L535"}}),zr=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L542"}}),Cr=new T({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L98"}}),Jr=new T({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L113"}}),Ur=new T({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L118"}}),Ir=new T({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L138"}}),qr=new T({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L146"}}),Br=new T({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_logits_process.py#L170"}}),Sr=new Z({}),Wr=new T({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L194"}}),Pr=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L206"}}),Vr=new T({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L216"}}),Dr=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L231"}}),Er=new T({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L315"}}),Zr=new T({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L337"}}),Gr=new T({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L50"}}),Nr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xr=new T({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L72"}}),Hr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new T({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L61"}}),Or=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qr=new T({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L241"}}),Ar=new T({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L262"}}),Yr=new T({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L271"}}),Kr=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L288"}}),ea=new T({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L296"}}),ta=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L309"}}),na=new T({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L95"}}),oa=new T({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L110"}}),sa=new T({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L159"}}),ra=new T({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L179"}}),aa=new T({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L115"}}),ia=new T({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L139"}}),ca=new T({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L363"}}),la=new T({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/flax_logits_process.py#L397"}}),da=new Z({}),ma=new T({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L36"}}),ga=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L39",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ua=new T({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L124"}}),ha=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L125",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),fa=new T({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L44"}}),_a=new T({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L60",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ba=new T({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L102"}}),va=new T({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/stopping_criteria.py#L119",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Ta=new Z({}),$a=new T({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L5"}}),Ln=new G({props:{anchor:"transformers.Constraint.example",$$slots:{default:[qk]},$$scope:{ctx:M}}}),wa=new T({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L48",returnDescription:`
<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`
<p>token_ids(<code>torch.tensor</code>)</p>
`}}),ka=new T({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L113",returnDescription:`
<p>The same constraint as the one being called from.</p>
`,returnType:`
<p>constraint(<code>Constraint</code>)</p>
`}}),xa=new T({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L60"}}),Ma=new T({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L104"}}),La=new T({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L94"}}),ja=new T({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L24"}}),Fa=new T({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L69",returnDescription:`
<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`
<p>stepped(<code>bool</code>)</p>
`}}),za=new T({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L129"}}),Ca=new T({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:"<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014; a list of words, where each word is a list of ids. This constraint",name:"nested_token_ids"},{anchor:"transformers.DisjunctiveConstraint.is",description:"<strong>is</strong> fulfilled by generating just one from the list of words. &#x2014;",name:"is"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L261"}}),Ja=new T({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L350"}}),Ua=new T({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L382"}}),Ia=new T({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_constraints.py#L417"}}),qa=new Z({}),Ba=new T({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L91"}}),Sa=new T({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L97",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),Wa=new T({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L109",returnDescription:`
<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`
<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Pa=new T({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L123"}}),Va=new T({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L215"}}),Da=new T({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L315"}}),Ea=new T({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.33.3/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L410"}}),Za=new T({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L504",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),Ga=new T({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/beam_search.py#L798"}}),Na=new Z({}),Xa=new T({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/utils.py#L4696"}}),Ha=new T({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/tf_utils.py#L3059"}}),Ra=new Z({}),Oa=new T({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L38"}}),Wn=new no({props:{warning:!0,$$slots:{default:[Bk]},$$scope:{ctx:M}}}),Pn=new G({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[Sk]},$$scope:{ctx:M}}}),Qa=new T({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L116"}}),Aa=new T({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L130"}}),Ya=new T({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L82"}}),Ka=new T({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L159"}}),Zn=new no({props:{warning:!0,$$slots:{default:[Wk]},$$scope:{ctx:M}}}),Gn=new G({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[Pk]},$$scope:{ctx:M}}}),ei=new T({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/generation/streamers.py#L213"}}),{c(){v=o("meta"),k=r(),y=o("p"),$=r(),w=o("h1"),_=o("a"),x=o("span"),d(oo.$$.fragment),Nh=r(),hi=o("span"),hi.textContent=UT,Sm=r(),so=o("p"),so.innerHTML=IT,Wm=r(),ro=o("p"),ro.textContent=qT,Pm=r(),dt=o("h2"),Xt=o("a"),hm=o("span"),d(ao.$$.fragment),Xh=r(),fi=o("span"),fi.textContent=BT,Vm=r(),io=o("p"),io.innerHTML=ST,Dm=r(),co=o("p"),co.textContent=WT,Em=r(),d(lo.$$.fragment),Zm=r(),po=o("p"),po.innerHTML=PT,Gm=r(),mo=o("ul"),mo.innerHTML=VT,Nm=r(),go=o("p"),go.innerHTML=DT,Xm=r(),uo=o("p"),uo.innerHTML=ET,Hm=r(),ho=o("p"),ho.innerHTML=ZT,Rm=r(),d(fo.$$.fragment),Om=r(),_o=o("p"),_o.innerHTML=GT,Qm=r(),bo=o("p"),bo.innerHTML=NT,Am=r(),vo=o("p"),vo.textContent=XT,Ym=r(),pt=o("h3"),Ht=o("a"),fm=o("span"),d(To.$$.fragment),Hh=r(),_i=o("span"),_i.textContent=HT,Km=r(),mt=o("div"),d(yo.$$.fragment),Rh=r(),bi=o("p"),bi.textContent=RT,eg=r(),gt=o("div"),d($o.$$.fragment),Oh=r(),vi=o("p"),vi.textContent=OT,tg=r(),ut=o("div"),d(wo.$$.fragment),Qh=r(),Ti=o("p"),Ti.textContent=QT,ng=r(),ht=o("div"),d(ko.$$.fragment),Ah=r(),yi=o("p"),yi.textContent=AT,og=r(),ft=o("div"),d(xo.$$.fragment),Yh=r(),$i=o("p"),$i.textContent=YT,sg=r(),_t=o("div"),d(Mo.$$.fragment),Kh=r(),wi=o("p"),wi.textContent=KT,rg=r(),bt=o("div"),d(Lo.$$.fragment),ef=r(),ki=o("p"),ki.textContent=ey,ag=r(),vt=o("div"),d(jo.$$.fragment),tf=r(),xi=o("p"),xi.textContent=ty,ig=r(),Tt=o("div"),d(Fo.$$.fragment),nf=r(),Mi=o("p"),Mi.textContent=ny,cg=r(),yt=o("div"),d(zo.$$.fragment),of=r(),Li=o("p"),Li.textContent=oy,lg=r(),$t=o("h3"),Rt=o("a"),_m=o("span"),d(Co.$$.fragment),sf=r(),ji=o("span"),ji.textContent=sy,dg=r(),wt=o("div"),d(Jo.$$.fragment),rf=r(),Fi=o("p"),Fi.textContent=ry,pg=r(),kt=o("div"),d(Uo.$$.fragment),af=r(),zi=o("p"),zi.textContent=ay,mg=r(),xt=o("div"),d(Io.$$.fragment),cf=r(),Ci=o("p"),Ci.textContent=iy,gg=r(),Mt=o("div"),d(qo.$$.fragment),lf=r(),Ji=o("p"),Ji.textContent=cy,ug=r(),Lt=o("div"),d(Bo.$$.fragment),df=r(),Ui=o("p"),Ui.textContent=ly,hg=r(),jt=o("div"),d(So.$$.fragment),pf=r(),Ii=o("p"),Ii.textContent=dy,fg=r(),Ft=o("div"),d(Wo.$$.fragment),mf=r(),qi=o("p"),qi.textContent=py,_g=r(),zt=o("div"),d(Po.$$.fragment),gf=r(),Bi=o("p"),Bi.textContent=my,bg=r(),Ct=o("div"),d(Vo.$$.fragment),uf=r(),Si=o("p"),Si.textContent=gy,vg=r(),Jt=o("div"),d(Do.$$.fragment),hf=r(),Wi=o("p"),Wi.textContent=uy,Tg=r(),Ut=o("h3"),Ot=o("a"),bm=o("span"),d(Eo.$$.fragment),ff=r(),Pi=o("span"),Pi.textContent=hy,yg=r(),oe=o("div"),d(Zo.$$.fragment),_f=r(),Vi=o("p"),Vi.textContent=fy,bf=r(),Qt=o("div"),d(Go.$$.fragment),vf=r(),Di=o("p"),Di.textContent=_y,$g=r(),se=o("div"),d(No.$$.fragment),Tf=r(),Ei=o("p"),Ei.textContent=by,yf=r(),At=o("div"),d(Xo.$$.fragment),$f=r(),Zi=o("p"),Zi.textContent=vy,wg=r(),re=o("div"),d(Ho.$$.fragment),wf=r(),Gi=o("p"),Gi.textContent=Ty,kf=r(),Yt=o("div"),d(Ro.$$.fragment),xf=r(),Ni=o("p"),Ni.textContent=yy,kg=r(),It=o("h2"),Kt=o("a"),vm=o("span"),d(Oo.$$.fragment),Mf=r(),Xi=o("span"),Xi.textContent=$y,xg=r(),Qo=o("p"),Qo.innerHTML=wy,Mg=r(),qt=o("h3"),en=o("a"),Tm=o("span"),d(Ao.$$.fragment),Lf=r(),Hi=o("span"),Hi.textContent=ky,Lg=r(),ae=o("div"),d(Yo.$$.fragment),jf=r(),Ri=o("p"),Ri.innerHTML=xy,Ff=r(),Oi=o("div"),d(Ko.$$.fragment),jg=r(),N=o("div"),d(es.$$.fragment),zf=r(),Qi=o("p"),Qi.innerHTML=My,Cf=r(),Ai=o("p"),Ai.innerHTML=Ly,Jf=r(),Yi=o("div"),d(ts.$$.fragment),Fg=r(),ie=o("div"),d(ns.$$.fragment),Uf=r(),Ki=o("p"),Ki.innerHTML=jy,If=r(),ec=o("div"),d(os.$$.fragment),zg=r(),ce=o("div"),d(ss.$$.fragment),qf=r(),tc=o("p"),tc.innerHTML=Fy,Bf=r(),nc=o("div"),d(rs.$$.fragment),Cg=r(),X=o("div"),d(as.$$.fragment),Sf=r(),oc=o("p"),oc.innerHTML=zy,Wf=r(),d(tn.$$.fragment),Pf=r(),sc=o("div"),d(is.$$.fragment),Jg=r(),H=o("div"),d(cs.$$.fragment),Vf=r(),rc=o("p"),rc.innerHTML=Cy,Df=r(),d(nn.$$.fragment),Ef=r(),ac=o("div"),d(ls.$$.fragment),Ug=r(),le=o("div"),d(ds.$$.fragment),Zf=r(),ic=o("p"),ic.innerHTML=Jy,Gf=r(),cc=o("div"),d(ps.$$.fragment),Ig=r(),de=o("div"),d(ms.$$.fragment),Nf=r(),lc=o("p"),lc.innerHTML=Uy,Xf=r(),dc=o("div"),d(gs.$$.fragment),qg=r(),pe=o("div"),d(us.$$.fragment),Hf=r(),pc=o("p"),pc.innerHTML=Iy,Rf=r(),mc=o("div"),d(hs.$$.fragment),Bg=r(),me=o("div"),d(fs.$$.fragment),Of=r(),gc=o("p"),gc.innerHTML=qy,Qf=r(),uc=o("div"),d(_s.$$.fragment),Sg=r(),L=o("div"),d(bs.$$.fragment),Af=r(),hc=o("p"),hc.innerHTML=By,Yf=r(),fc=o("p"),fc.innerHTML=Sy,Kf=r(),d(on.$$.fragment),e_=r(),d(sn.$$.fragment),t_=r(),_c=o("p"),_c.innerHTML=Wy,n_=r(),bc=o("p"),bc.textContent=Py,o_=r(),vc=o("ul"),vc.innerHTML=Vy,s_=r(),Tc=o("p"),Tc.textContent=Dy,r_=r(),yc=o("ul"),yc.innerHTML=Ey,a_=r(),d(rn.$$.fragment),i_=r(),$c=o("div"),d(vs.$$.fragment),Wg=r(),ge=o("div"),d(Ts.$$.fragment),c_=r(),wc=o("p"),wc.innerHTML=Zy,l_=r(),kc=o("div"),d(ys.$$.fragment),Pg=r(),ue=o("div"),d($s.$$.fragment),d_=r(),xc=o("p"),xc.innerHTML=Gy,p_=r(),Mc=o("div"),d(ws.$$.fragment),Vg=r(),he=o("div"),d(ks.$$.fragment),m_=r(),Lc=o("p"),Lc.textContent=Ny,g_=r(),jc=o("div"),d(xs.$$.fragment),Dg=r(),fe=o("div"),d(Ms.$$.fragment),u_=r(),Fc=o("p"),Fc.innerHTML=Xy,h_=r(),zc=o("div"),d(Ls.$$.fragment),Eg=r(),_e=o("div"),d(js.$$.fragment),f_=r(),Cc=o("p"),Cc.textContent=Hy,__=r(),Jc=o("div"),d(Fs.$$.fragment),Zg=r(),be=o("div"),d(zs.$$.fragment),b_=r(),Uc=o("p"),Uc.innerHTML=Ry,v_=r(),Ic=o("div"),d(Cs.$$.fragment),Gg=r(),R=o("div"),d(Js.$$.fragment),T_=r(),qc=o("p"),qc.innerHTML=Oy,y_=r(),d(an.$$.fragment),$_=r(),Bc=o("div"),d(Us.$$.fragment),Ng=r(),B=o("div"),d(Is.$$.fragment),w_=r(),Sc=o("p"),Sc.innerHTML=Qy,k_=r(),d(cn.$$.fragment),x_=r(),d(ln.$$.fragment),M_=r(),Wc=o("div"),d(qs.$$.fragment),Xg=r(),S=o("div"),d(Bs.$$.fragment),L_=r(),Pc=o("p"),Pc.innerHTML=Ay,j_=r(),d(dn.$$.fragment),F_=r(),d(pn.$$.fragment),z_=r(),Vc=o("div"),d(Ss.$$.fragment),Hg=r(),ve=o("div"),d(Ws.$$.fragment),C_=r(),Dc=o("p"),Dc.innerHTML=Yy,J_=r(),Ec=o("div"),d(Ps.$$.fragment),Rg=r(),O=o("div"),d(Vs.$$.fragment),U_=r(),Zc=o("p"),Zc.innerHTML=Ky,I_=r(),d(mn.$$.fragment),q_=r(),Gc=o("div"),d(Ds.$$.fragment),Og=r(),W=o("div"),d(Es.$$.fragment),B_=r(),Nc=o("p"),Nc.innerHTML=e$,S_=r(),d(gn.$$.fragment),W_=r(),d(un.$$.fragment),P_=r(),Xc=o("div"),d(Zs.$$.fragment),Qg=r(),Te=o("div"),d(Gs.$$.fragment),V_=r(),Hc=o("p"),Hc.innerHTML=t$,D_=r(),Rc=o("div"),d(Ns.$$.fragment),Ag=r(),ye=o("div"),d(Xs.$$.fragment),E_=r(),Oc=o("p"),Oc.innerHTML=n$,Z_=r(),Qc=o("div"),d(Hs.$$.fragment),Yg=r(),P=o("div"),d(Rs.$$.fragment),G_=r(),Ac=o("p"),Ac.innerHTML=o$,N_=r(),d(hn.$$.fragment),X_=r(),d(fn.$$.fragment),H_=r(),Yc=o("div"),d(Os.$$.fragment),Kg=r(),$e=o("div"),d(Qs.$$.fragment),R_=r(),Kc=o("p"),Kc.innerHTML=s$,O_=r(),el=o("div"),d(As.$$.fragment),eu=r(),Q=o("div"),d(Ys.$$.fragment),Q_=r(),tl=o("p"),tl.innerHTML=r$,A_=r(),d(_n.$$.fragment),Y_=r(),nl=o("div"),d(Ks.$$.fragment),tu=r(),we=o("div"),d(er.$$.fragment),K_=r(),ol=o("p"),ol.innerHTML=a$,eb=r(),sl=o("div"),d(tr.$$.fragment),nu=r(),V=o("div"),d(nr.$$.fragment),tb=r(),rl=o("p"),rl.innerHTML=i$,nb=r(),al=o("p"),al.innerHTML=c$,ob=r(),d(bn.$$.fragment),sb=r(),il=o("div"),d(or.$$.fragment),ou=r(),A=o("div"),d(sr.$$.fragment),rb=r(),cl=o("p"),cl.innerHTML=l$,ab=r(),ll=o("p"),ll.innerHTML=d$,ib=r(),dl=o("div"),d(rr.$$.fragment),su=r(),Bt=o("h3"),vn=o("a"),ym=o("span"),d(ar.$$.fragment),cb=r(),pl=o("span"),pl.textContent=p$,ru=r(),ke=o("div"),d(ir.$$.fragment),lb=r(),ml=o("p"),ml.innerHTML=m$,db=r(),gl=o("div"),d(cr.$$.fragment),au=r(),xe=o("div"),d(lr.$$.fragment),pb=r(),ul=o("p"),ul.innerHTML=g$,mb=r(),hl=o("div"),d(dr.$$.fragment),iu=r(),Me=o("div"),d(pr.$$.fragment),gb=r(),fl=o("p"),fl.innerHTML=u$,ub=r(),_l=o("div"),d(mr.$$.fragment),cu=r(),Le=o("div"),d(gr.$$.fragment),hb=r(),bl=o("p"),bl.textContent=h$,fb=r(),Tn=o("div"),d(ur.$$.fragment),_b=r(),vl=o("p"),vl.textContent=f$,lu=r(),je=o("div"),d(hr.$$.fragment),bb=r(),Tl=o("p"),Tl.innerHTML=_$,vb=r(),yl=o("div"),d(fr.$$.fragment),du=r(),Fe=o("div"),d(_r.$$.fragment),Tb=r(),$l=o("p"),$l.textContent=b$,yb=r(),yn=o("div"),d(br.$$.fragment),$b=r(),wl=o("p"),wl.textContent=v$,pu=r(),ze=o("div"),d(vr.$$.fragment),wb=r(),kl=o("p"),kl.innerHTML=T$,kb=r(),xl=o("div"),d(Tr.$$.fragment),mu=r(),Ce=o("div"),d(yr.$$.fragment),xb=r(),Ml=o("p"),Ml.innerHTML=y$,Mb=r(),Ll=o("div"),d($r.$$.fragment),gu=r(),Je=o("div"),d(wr.$$.fragment),Lb=r(),jl=o("p"),jl.innerHTML=$$,jb=r(),Fl=o("div"),d(kr.$$.fragment),uu=r(),Ue=o("div"),d(xr.$$.fragment),Fb=r(),zl=o("p"),zl.innerHTML=w$,zb=r(),Cl=o("div"),d(Mr.$$.fragment),hu=r(),Ie=o("div"),d(Lr.$$.fragment),Cb=r(),Jl=o("p"),Jl.innerHTML=k$,Jb=r(),Ul=o("div"),d(jr.$$.fragment),fu=r(),qe=o("div"),d(Fr.$$.fragment),Ub=r(),Il=o("p"),Il.innerHTML=x$,Ib=r(),ql=o("div"),d(zr.$$.fragment),_u=r(),Be=o("div"),d(Cr.$$.fragment),qb=r(),Bl=o("p"),Bl.innerHTML=M$,Bb=r(),Sl=o("div"),d(Jr.$$.fragment),bu=r(),Se=o("div"),d(Ur.$$.fragment),Sb=r(),Wl=o("p"),Wl.innerHTML=L$,Wb=r(),Pl=o("div"),d(Ir.$$.fragment),vu=r(),We=o("div"),d(qr.$$.fragment),Pb=r(),Vl=o("p"),Vl.innerHTML=j$,Vb=r(),Dl=o("div"),d(Br.$$.fragment),Tu=r(),St=o("h3"),$n=o("a"),$m=o("span"),d(Sr.$$.fragment),Db=r(),El=o("span"),El.textContent=F$,yu=r(),Pe=o("div"),d(Wr.$$.fragment),Eb=r(),Zl=o("p"),Zl.innerHTML=z$,Zb=r(),Gl=o("div"),d(Pr.$$.fragment),$u=r(),Ve=o("div"),d(Vr.$$.fragment),Gb=r(),Nl=o("p"),Nl.innerHTML=C$,Nb=r(),Xl=o("div"),d(Dr.$$.fragment),wu=r(),De=o("div"),d(Er.$$.fragment),Xb=r(),Hl=o("p"),Hl.innerHTML=J$,Hb=r(),Rl=o("div"),d(Zr.$$.fragment),ku=r(),Ee=o("div"),d(Gr.$$.fragment),Rb=r(),Ol=o("p"),Ol.textContent=U$,Ob=r(),wn=o("div"),d(Nr.$$.fragment),Qb=r(),Ql=o("p"),Ql.textContent=I$,xu=r(),Ze=o("div"),d(Xr.$$.fragment),Ab=r(),Al=o("p"),Al.innerHTML=q$,Yb=r(),Yl=o("div"),d(Hr.$$.fragment),Mu=r(),Ge=o("div"),d(Rr.$$.fragment),Kb=r(),Kl=o("p"),Kl.textContent=B$,ev=r(),kn=o("div"),d(Or.$$.fragment),tv=r(),ed=o("p"),ed.textContent=S$,Lu=r(),Ne=o("div"),d(Qr.$$.fragment),nv=r(),td=o("p"),td.innerHTML=W$,ov=r(),nd=o("div"),d(Ar.$$.fragment),ju=r(),Xe=o("div"),d(Yr.$$.fragment),sv=r(),od=o("p"),od.innerHTML=P$,rv=r(),sd=o("div"),d(Kr.$$.fragment),Fu=r(),He=o("div"),d(ea.$$.fragment),av=r(),rd=o("p"),rd.innerHTML=V$,iv=r(),ad=o("div"),d(ta.$$.fragment),zu=r(),Re=o("div"),d(na.$$.fragment),cv=r(),id=o("p"),id.innerHTML=D$,lv=r(),cd=o("div"),d(oa.$$.fragment),Cu=r(),Oe=o("div"),d(sa.$$.fragment),dv=r(),ld=o("p"),ld.innerHTML=E$,pv=r(),dd=o("div"),d(ra.$$.fragment),Ju=r(),Qe=o("div"),d(aa.$$.fragment),mv=r(),pd=o("p"),pd.innerHTML=Z$,gv=r(),md=o("div"),d(ia.$$.fragment),Uu=r(),Ae=o("div"),d(ca.$$.fragment),uv=r(),gd=o("p"),gd.innerHTML=G$,hv=r(),ud=o("div"),d(la.$$.fragment),Iu=r(),Wt=o("h2"),xn=o("a"),wm=o("span"),d(da.$$.fragment),fv=r(),hd=o("span"),hd.textContent=N$,qu=r(),pa=o("p"),pa.innerHTML=X$,Bu=r(),Ye=o("div"),d(ma.$$.fragment),_v=r(),fd=o("p"),fd.textContent=H$,bv=r(),_d=o("div"),d(ga.$$.fragment),Su=r(),Pt=o("div"),d(ua.$$.fragment),vv=r(),bd=o("div"),d(ha.$$.fragment),Wu=r(),Ke=o("div"),d(fa.$$.fragment),Tv=r(),vd=o("p"),vd.innerHTML=R$,yv=r(),Td=o("div"),d(_a.$$.fragment),Pu=r(),et=o("div"),d(ba.$$.fragment),$v=r(),yd=o("p"),yd.innerHTML=O$,wv=r(),$d=o("div"),d(va.$$.fragment),Vu=r(),Vt=o("h2"),Mn=o("a"),km=o("span"),d(Ta.$$.fragment),kv=r(),wd=o("span"),wd.textContent=Q$,Du=r(),ya=o("p"),ya.innerHTML=A$,Eu=r(),j=o("div"),d($a.$$.fragment),xv=r(),kd=o("p"),kd.textContent=Y$,Mv=r(),xd=o("p"),xd.textContent=K$,Lv=r(),d(Ln.$$.fragment),jv=r(),Md=o("p"),Md.textContent=e1,Fv=r(),jn=o("div"),d(wa.$$.fragment),zv=r(),Ld=o("p"),Ld.textContent=t1,Cv=r(),Fn=o("div"),d(ka.$$.fragment),Jv=r(),jd=o("p"),jd.textContent=n1,Uv=r(),zn=o("div"),d(xa.$$.fragment),Iv=r(),Fd=o("p"),Fd.textContent=o1,qv=r(),Cn=o("div"),d(Ma.$$.fragment),Bv=r(),zd=o("p"),zd.innerHTML=s1,Sv=r(),Jn=o("div"),d(La.$$.fragment),Wv=r(),Cd=o("p"),Cd.textContent=r1,Pv=r(),Un=o("div"),d(ja.$$.fragment),Vv=r(),Jd=o("p"),Jd.textContent=a1,Dv=r(),ot=o("div"),d(Fa.$$.fragment),Ev=r(),Ud=o("p"),Ud.innerHTML=i1,Zv=r(),Id=o("p"),Id.textContent=c1,Zu=r(),Dt=o("div"),d(za.$$.fragment),Gv=r(),qd=o("p"),qd.innerHTML=l1,Gu=r(),Et=o("div"),d(Ca.$$.fragment),Nv=r(),Bd=o("p"),Bd.innerHTML=d1,Nu=r(),Y=o("div"),d(Ja.$$.fragment),Xv=r(),Sd=o("p"),Sd.textContent=p1,Hv=r(),I=o("div"),d(Ua.$$.fragment),Rv=r(),Wd=o("p"),Wd.textContent=m1,Ov=r(),Pd=o("p"),Pd.innerHTML=g1,Qv=r(),Vd=o("p"),Vd.innerHTML=u1,Av=r(),Dd=o("p"),Dd.innerHTML=h1,Yv=r(),Ed=o("p"),Ed.textContent=f1,Kv=r(),In=o("div"),d(Ia.$$.fragment),eT=r(),Zd=o("p"),Zd.textContent=_1,Xu=r(),Zt=o("h2"),qn=o("a"),xm=o("span"),d(qa.$$.fragment),tT=r(),Gd=o("span"),Gd.textContent=b1,Hu=r(),K=o("div"),d(Ba.$$.fragment),nT=r(),Nd=o("p"),Nd.innerHTML=v1,oT=r(),Xd=o("div"),d(Sa.$$.fragment),sT=r(),Hd=o("div"),d(Wa.$$.fragment),Ru=r(),U=o("div"),d(Pa.$$.fragment),rT=r(),Rd=o("p"),Rd.innerHTML=T1,aT=r(),Od=o("p"),Od.innerHTML=y1,iT=r(),Qd=o("p"),Qd.innerHTML=$1,cT=r(),Ad=o("div"),d(Va.$$.fragment),lT=r(),Yd=o("div"),d(Da.$$.fragment),Ou=r(),ee=o("div"),d(Ea.$$.fragment),dT=r(),Kd=o("p"),Kd.innerHTML=w1,pT=r(),ep=o("div"),d(Za.$$.fragment),mT=r(),tp=o("div"),d(Ga.$$.fragment),Qu=r(),Gt=o("h2"),Bn=o("a"),Mm=o("span"),d(Na.$$.fragment),gT=r(),np=o("span"),np.textContent=k1,Au=r(),tt=o("div"),d(Xa.$$.fragment),uT=r(),op=o("p"),op.textContent=x1,hT=r(),sp=o("p"),sp.innerHTML=M1,Yu=r(),nt=o("div"),d(Ha.$$.fragment),fT=r(),rp=o("p"),rp.textContent=L1,_T=r(),ap=o("p"),ap.innerHTML=j1,Ku=r(),Nt=o("h2"),Sn=o("a"),Lm=o("span"),d(Ra.$$.fragment),bT=r(),ip=o("span"),ip.textContent=F1,eh=r(),J=o("div"),d(Oa.$$.fragment),vT=r(),cp=o("p"),cp.textContent=z1,TT=r(),d(Wn.$$.fragment),yT=r(),d(Pn.$$.fragment),$T=r(),Vn=o("div"),d(Qa.$$.fragment),wT=r(),lp=o("p"),lp.textContent=C1,kT=r(),Dn=o("div"),d(Aa.$$.fragment),xT=r(),dp=o("p"),dp.textContent=J1,MT=r(),En=o("div"),d(Ya.$$.fragment),LT=r(),pp=o("p"),pp.textContent=U1,th=r(),D=o("div"),d(Ka.$$.fragment),jT=r(),mp=o("p"),mp.textContent=I1,FT=r(),d(Zn.$$.fragment),zT=r(),d(Gn.$$.fragment),CT=r(),Nn=o("div"),d(ei.$$.fragment),JT=r(),gp=o("p"),gp.textContent=q1,nh=r(),jm=o("p"),this.h()},l(e){const i=_k("svelte-1phssyn",document.head);v=s(i,"META",{name:!0,content:!0}),i.forEach(n),k=a(e),y=s(e,"P",{}),f(y).forEach(n),$=a(e),w=s(e,"H1",{class:!0});var ti=f(w);_=s(ti,"A",{id:!0,class:!0,href:!0});var Fm=f(_);x=s(Fm,"SPAN",{});var zm=f(x);p(oo.$$.fragment,zm),zm.forEach(n),Fm.forEach(n),Nh=a(ti),hi=s(ti,"SPAN",{"data-svelte-h":!0}),b(hi)!=="svelte-143p7rg"&&(hi.textContent=UT),ti.forEach(n),Sm=a(e),so=s(e,"P",{"data-svelte-h":!0}),b(so)!=="svelte-ilwmkg"&&(so.innerHTML=IT),Wm=a(e),ro=s(e,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-1blns9e"&&(ro.textContent=qT),Pm=a(e),dt=s(e,"H2",{class:!0});var ni=f(dt);Xt=s(ni,"A",{id:!0,class:!0,href:!0});var Cm=f(Xt);hm=s(Cm,"SPAN",{});var Jm=f(hm);p(ao.$$.fragment,Jm),Jm.forEach(n),Cm.forEach(n),Xh=a(ni),fi=s(ni,"SPAN",{"data-svelte-h":!0}),b(fi)!=="svelte-1j1svdq"&&(fi.textContent=BT),ni.forEach(n),Vm=a(e),io=s(e,"P",{"data-svelte-h":!0}),b(io)!=="svelte-mzt8aa"&&(io.innerHTML=ST),Dm=a(e),co=s(e,"P",{"data-svelte-h":!0}),b(co)!=="svelte-wwwyth"&&(co.textContent=WT),Em=a(e),p(lo.$$.fragment,e),Zm=a(e),po=s(e,"P",{"data-svelte-h":!0}),b(po)!=="svelte-4nrkff"&&(po.innerHTML=PT),Gm=a(e),mo=s(e,"UL",{"data-svelte-h":!0}),b(mo)!=="svelte-1arpy9m"&&(mo.innerHTML=VT),Nm=a(e),go=s(e,"P",{"data-svelte-h":!0}),b(go)!=="svelte-xh59rv"&&(go.innerHTML=DT),Xm=a(e),uo=s(e,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-rqavqw"&&(uo.innerHTML=ET),Hm=a(e),ho=s(e,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-qr02he"&&(ho.innerHTML=ZT),Rm=a(e),p(fo.$$.fragment,e),Om=a(e),_o=s(e,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-114v74y"&&(_o.innerHTML=GT),Qm=a(e),bo=s(e,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-13knclg"&&(bo.innerHTML=NT),Am=a(e),vo=s(e,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-gz8gow"&&(vo.textContent=XT),Ym=a(e),pt=s(e,"H3",{class:!0});var oi=f(pt);Ht=s(oi,"A",{id:!0,class:!0,href:!0});var Um=f(Ht);fm=s(Um,"SPAN",{});var Im=f(fm);p(To.$$.fragment,Im),Im.forEach(n),Um.forEach(n),Hh=a(oi),_i=s(oi,"SPAN",{"data-svelte-h":!0}),b(_i)!=="svelte-1e6sddw"&&(_i.textContent=HT),oi.forEach(n),Km=a(e),mt=s(e,"DIV",{class:!0});var si=f(mt);p(yo.$$.fragment,si),Rh=a(si),bi=s(si,"P",{"data-svelte-h":!0}),b(bi)!=="svelte-1bnrp61"&&(bi.textContent=RT),si.forEach(n),eg=a(e),gt=s(e,"DIV",{class:!0});var ri=f(gt);p($o.$$.fragment,ri),Oh=a(ri),vi=s(ri,"P",{"data-svelte-h":!0}),b(vi)!=="svelte-fenhkk"&&(vi.textContent=OT),ri.forEach(n),tg=a(e),ut=s(e,"DIV",{class:!0});var ai=f(ut);p(wo.$$.fragment,ai),Qh=a(ai),Ti=s(ai,"P",{"data-svelte-h":!0}),b(Ti)!=="svelte-1dqtgq4"&&(Ti.textContent=QT),ai.forEach(n),ng=a(e),ht=s(e,"DIV",{class:!0});var ii=f(ht);p(ko.$$.fragment,ii),Ah=a(ii),yi=s(ii,"P",{"data-svelte-h":!0}),b(yi)!=="svelte-10orfv5"&&(yi.textContent=AT),ii.forEach(n),og=a(e),ft=s(e,"DIV",{class:!0});var ci=f(ft);p(xo.$$.fragment,ci),Yh=a(ci),$i=s(ci,"P",{"data-svelte-h":!0}),b($i)!=="svelte-jg8udg"&&($i.textContent=YT),ci.forEach(n),sg=a(e),_t=s(e,"DIV",{class:!0});var li=f(_t);p(Mo.$$.fragment,li),Kh=a(li),wi=s(li,"P",{"data-svelte-h":!0}),b(wi)!=="svelte-1i40667"&&(wi.textContent=KT),li.forEach(n),rg=a(e),bt=s(e,"DIV",{class:!0});var di=f(bt);p(Lo.$$.fragment,di),ef=a(di),ki=s(di,"P",{"data-svelte-h":!0}),b(ki)!=="svelte-n5fi8x"&&(ki.textContent=ey),di.forEach(n),ag=a(e),vt=s(e,"DIV",{class:!0});var pi=f(vt);p(jo.$$.fragment,pi),tf=a(pi),xi=s(pi,"P",{"data-svelte-h":!0}),b(xi)!=="svelte-h5pj3l"&&(xi.textContent=ty),pi.forEach(n),ig=a(e),Tt=s(e,"DIV",{class:!0});var mi=f(Tt);p(Fo.$$.fragment,mi),nf=a(mi),Mi=s(mi,"P",{"data-svelte-h":!0}),b(Mi)!=="svelte-pru3ks"&&(Mi.textContent=ny),mi.forEach(n),cg=a(e),yt=s(e,"DIV",{class:!0});var gi=f(yt);p(zo.$$.fragment,gi),of=a(gi),Li=s(gi,"P",{"data-svelte-h":!0}),b(Li)!=="svelte-pru3ks"&&(Li.textContent=oy),gi.forEach(n),lg=a(e),$t=s(e,"H3",{class:!0});var ui=f($t);Rt=s(ui,"A",{id:!0,class:!0,href:!0});var qm=f(Rt);_m=s(qm,"SPAN",{});var Bm=f(_m);p(Co.$$.fragment,Bm),Bm.forEach(n),qm.forEach(n),sf=a(ui),ji=s(ui,"SPAN",{"data-svelte-h":!0}),b(ji)!=="svelte-13st32y"&&(ji.textContent=sy),ui.forEach(n),dg=a(e),wt=s(e,"DIV",{class:!0});var sh=f(wt);p(Jo.$$.fragment,sh),rf=a(sh),Fi=s(sh,"P",{"data-svelte-h":!0}),b(Fi)!=="svelte-1bnrp61"&&(Fi.textContent=ry),sh.forEach(n),pg=a(e),kt=s(e,"DIV",{class:!0});var rh=f(kt);p(Uo.$$.fragment,rh),af=a(rh),zi=s(rh,"P",{"data-svelte-h":!0}),b(zi)!=="svelte-fenhkk"&&(zi.textContent=ay),rh.forEach(n),mg=a(e),xt=s(e,"DIV",{class:!0});var ah=f(xt);p(Io.$$.fragment,ah),cf=a(ah),Ci=s(ah,"P",{"data-svelte-h":!0}),b(Ci)!=="svelte-1dqtgq4"&&(Ci.textContent=iy),ah.forEach(n),gg=a(e),Mt=s(e,"DIV",{class:!0});var ih=f(Mt);p(qo.$$.fragment,ih),lf=a(ih),Ji=s(ih,"P",{"data-svelte-h":!0}),b(Ji)!=="svelte-10orfv5"&&(Ji.textContent=cy),ih.forEach(n),ug=a(e),Lt=s(e,"DIV",{class:!0});var ch=f(Lt);p(Bo.$$.fragment,ch),df=a(ch),Ui=s(ch,"P",{"data-svelte-h":!0}),b(Ui)!=="svelte-jg8udg"&&(Ui.textContent=ly),ch.forEach(n),hg=a(e),jt=s(e,"DIV",{class:!0});var lh=f(jt);p(So.$$.fragment,lh),pf=a(lh),Ii=s(lh,"P",{"data-svelte-h":!0}),b(Ii)!=="svelte-1i40667"&&(Ii.textContent=dy),lh.forEach(n),fg=a(e),Ft=s(e,"DIV",{class:!0});var dh=f(Ft);p(Wo.$$.fragment,dh),mf=a(dh),qi=s(dh,"P",{"data-svelte-h":!0}),b(qi)!=="svelte-n5fi8x"&&(qi.textContent=py),dh.forEach(n),_g=a(e),zt=s(e,"DIV",{class:!0});var ph=f(zt);p(Po.$$.fragment,ph),gf=a(ph),Bi=s(ph,"P",{"data-svelte-h":!0}),b(Bi)!=="svelte-h5pj3l"&&(Bi.textContent=my),ph.forEach(n),bg=a(e),Ct=s(e,"DIV",{class:!0});var mh=f(Ct);p(Vo.$$.fragment,mh),uf=a(mh),Si=s(mh,"P",{"data-svelte-h":!0}),b(Si)!=="svelte-b9zq6n"&&(Si.textContent=gy),mh.forEach(n),vg=a(e),Jt=s(e,"DIV",{class:!0});var gh=f(Jt);p(Do.$$.fragment,gh),hf=a(gh),Wi=s(gh,"P",{"data-svelte-h":!0}),b(Wi)!=="svelte-pru3ks"&&(Wi.textContent=uy),gh.forEach(n),Tg=a(e),Ut=s(e,"H3",{class:!0});var uh=f(Ut);Ot=s(uh,"A",{id:!0,class:!0,href:!0});var B1=f(Ot);bm=s(B1,"SPAN",{});var S1=f(bm);p(Eo.$$.fragment,S1),S1.forEach(n),B1.forEach(n),ff=a(uh),Pi=s(uh,"SPAN",{"data-svelte-h":!0}),b(Pi)!=="svelte-1iv7dlo"&&(Pi.textContent=hy),uh.forEach(n),yg=a(e),oe=s(e,"DIV",{class:!0});var up=f(oe);p(Zo.$$.fragment,up),_f=a(up),Vi=s(up,"P",{"data-svelte-h":!0}),b(Vi)!=="svelte-qoov36"&&(Vi.textContent=fy),bf=a(up),Qt=s(up,"DIV",{class:!0});var hh=f(Qt);p(Go.$$.fragment,hh),vf=a(hh),Di=s(hh,"P",{"data-svelte-h":!0}),b(Di)!=="svelte-5ihtpa"&&(Di.textContent=_y),hh.forEach(n),up.forEach(n),$g=a(e),se=s(e,"DIV",{class:!0});var hp=f(se);p(No.$$.fragment,hp),Tf=a(hp),Ei=s(hp,"P",{"data-svelte-h":!0}),b(Ei)!=="svelte-1tz7qrd"&&(Ei.textContent=by),yf=a(hp),At=s(hp,"DIV",{class:!0});var fh=f(At);p(Xo.$$.fragment,fh),$f=a(fh),Zi=s(fh,"P",{"data-svelte-h":!0}),b(Zi)!=="svelte-5ihtpa"&&(Zi.textContent=vy),fh.forEach(n),hp.forEach(n),wg=a(e),re=s(e,"DIV",{class:!0});var fp=f(re);p(Ho.$$.fragment,fp),wf=a(fp),Gi=s(fp,"P",{"data-svelte-h":!0}),b(Gi)!=="svelte-1tz7qrd"&&(Gi.textContent=Ty),kf=a(fp),Yt=s(fp,"DIV",{class:!0});var _h=f(Yt);p(Ro.$$.fragment,_h),xf=a(_h),Ni=s(_h,"P",{"data-svelte-h":!0}),b(Ni)!=="svelte-5ihtpa"&&(Ni.textContent=yy),_h.forEach(n),fp.forEach(n),kg=a(e),It=s(e,"H2",{class:!0});var bh=f(It);Kt=s(bh,"A",{id:!0,class:!0,href:!0});var W1=f(Kt);vm=s(W1,"SPAN",{});var P1=f(vm);p(Oo.$$.fragment,P1),P1.forEach(n),W1.forEach(n),Mf=a(bh),Xi=s(bh,"SPAN",{"data-svelte-h":!0}),b(Xi)!=="svelte-1u5gntf"&&(Xi.textContent=$y),bh.forEach(n),xg=a(e),Qo=s(e,"P",{"data-svelte-h":!0}),b(Qo)!=="svelte-l94qrz"&&(Qo.innerHTML=wy),Mg=a(e),qt=s(e,"H3",{class:!0});var vh=f(qt);en=s(vh,"A",{id:!0,class:!0,href:!0});var V1=f(en);Tm=s(V1,"SPAN",{});var D1=f(Tm);p(Ao.$$.fragment,D1),D1.forEach(n),V1.forEach(n),Lf=a(vh),Hi=s(vh,"SPAN",{"data-svelte-h":!0}),b(Hi)!=="svelte-1e6sddw"&&(Hi.textContent=ky),vh.forEach(n),Lg=a(e),ae=s(e,"DIV",{class:!0});var _p=f(ae);p(Yo.$$.fragment,_p),jf=a(_p),Ri=s(_p,"P",{"data-svelte-h":!0}),b(Ri)!=="svelte-1ydqxui"&&(Ri.innerHTML=xy),Ff=a(_p),Oi=s(_p,"DIV",{class:!0});var E1=f(Oi);p(Ko.$$.fragment,E1),E1.forEach(n),_p.forEach(n),jg=a(e),N=s(e,"DIV",{class:!0});var Xn=f(N);p(es.$$.fragment,Xn),zf=a(Xn),Qi=s(Xn,"P",{"data-svelte-h":!0}),b(Qi)!=="svelte-151ju3h"&&(Qi.innerHTML=My),Cf=a(Xn),Ai=s(Xn,"P",{"data-svelte-h":!0}),b(Ai)!=="svelte-lu7kru"&&(Ai.innerHTML=Ly),Jf=a(Xn),Yi=s(Xn,"DIV",{class:!0});var Z1=f(Yi);p(ts.$$.fragment,Z1),Z1.forEach(n),Xn.forEach(n),Fg=a(e),ie=s(e,"DIV",{class:!0});var bp=f(ie);p(ns.$$.fragment,bp),Uf=a(bp),Ki=s(bp,"P",{"data-svelte-h":!0}),b(Ki)!=="svelte-773ew9"&&(Ki.innerHTML=jy),If=a(bp),ec=s(bp,"DIV",{class:!0});var G1=f(ec);p(os.$$.fragment,G1),G1.forEach(n),bp.forEach(n),zg=a(e),ce=s(e,"DIV",{class:!0});var vp=f(ce);p(ss.$$.fragment,vp),qf=a(vp),tc=s(vp,"P",{"data-svelte-h":!0}),b(tc)!=="svelte-hh9j4"&&(tc.innerHTML=Fy),Bf=a(vp),nc=s(vp,"DIV",{class:!0});var N1=f(nc);p(rs.$$.fragment,N1),N1.forEach(n),vp.forEach(n),Cg=a(e),X=s(e,"DIV",{class:!0});var Hn=f(X);p(as.$$.fragment,Hn),Sf=a(Hn),oc=s(Hn,"P",{"data-svelte-h":!0}),b(oc)!=="svelte-f3gg4y"&&(oc.innerHTML=zy),Wf=a(Hn),p(tn.$$.fragment,Hn),Pf=a(Hn),sc=s(Hn,"DIV",{class:!0});var X1=f(sc);p(is.$$.fragment,X1),X1.forEach(n),Hn.forEach(n),Jg=a(e),H=s(e,"DIV",{class:!0});var Rn=f(H);p(cs.$$.fragment,Rn),Vf=a(Rn),rc=s(Rn,"P",{"data-svelte-h":!0}),b(rc)!=="svelte-5yclcu"&&(rc.innerHTML=Cy),Df=a(Rn),p(nn.$$.fragment,Rn),Ef=a(Rn),ac=s(Rn,"DIV",{class:!0});var H1=f(ac);p(ls.$$.fragment,H1),H1.forEach(n),Rn.forEach(n),Ug=a(e),le=s(e,"DIV",{class:!0});var Tp=f(le);p(ds.$$.fragment,Tp),Zf=a(Tp),ic=s(Tp,"P",{"data-svelte-h":!0}),b(ic)!=="svelte-hw9389"&&(ic.innerHTML=Jy),Gf=a(Tp),cc=s(Tp,"DIV",{class:!0});var R1=f(cc);p(ps.$$.fragment,R1),R1.forEach(n),Tp.forEach(n),Ig=a(e),de=s(e,"DIV",{class:!0});var yp=f(de);p(ms.$$.fragment,yp),Nf=a(yp),lc=s(yp,"P",{"data-svelte-h":!0}),b(lc)!=="svelte-126ugzn"&&(lc.innerHTML=Uy),Xf=a(yp),dc=s(yp,"DIV",{class:!0});var O1=f(dc);p(gs.$$.fragment,O1),O1.forEach(n),yp.forEach(n),qg=a(e),pe=s(e,"DIV",{class:!0});var $p=f(pe);p(us.$$.fragment,$p),Hf=a($p),pc=s($p,"P",{"data-svelte-h":!0}),b(pc)!=="svelte-972suv"&&(pc.innerHTML=Iy),Rf=a($p),mc=s($p,"DIV",{class:!0});var Q1=f(mc);p(hs.$$.fragment,Q1),Q1.forEach(n),$p.forEach(n),Bg=a(e),me=s(e,"DIV",{class:!0});var wp=f(me);p(fs.$$.fragment,wp),Of=a(wp),gc=s(wp,"P",{"data-svelte-h":!0}),b(gc)!=="svelte-lka4kd"&&(gc.innerHTML=qy),Qf=a(wp),uc=s(wp,"DIV",{class:!0});var A1=f(uc);p(_s.$$.fragment,A1),A1.forEach(n),wp.forEach(n),Sg=a(e),L=s(e,"DIV",{class:!0});var F=f(L);p(bs.$$.fragment,F),Af=a(F),hc=s(F,"P",{"data-svelte-h":!0}),b(hc)!=="svelte-rzaf6h"&&(hc.innerHTML=By),Yf=a(F),fc=s(F,"P",{"data-svelte-h":!0}),b(fc)!=="svelte-1lk6r4c"&&(fc.innerHTML=Sy),Kf=a(F),p(on.$$.fragment,F),e_=a(F),p(sn.$$.fragment,F),t_=a(F),_c=s(F,"P",{"data-svelte-h":!0}),b(_c)!=="svelte-2fpu88"&&(_c.innerHTML=Wy),n_=a(F),bc=s(F,"P",{"data-svelte-h":!0}),b(bc)!=="svelte-1nj4y15"&&(bc.textContent=Py),o_=a(F),vc=s(F,"UL",{"data-svelte-h":!0}),b(vc)!=="svelte-1knkx0p"&&(vc.innerHTML=Vy),s_=a(F),Tc=s(F,"P",{"data-svelte-h":!0}),b(Tc)!=="svelte-5xwkxe"&&(Tc.textContent=Dy),r_=a(F),yc=s(F,"UL",{"data-svelte-h":!0}),b(yc)!=="svelte-7rlln8"&&(yc.innerHTML=Ey),a_=a(F),p(rn.$$.fragment,F),i_=a(F),$c=s(F,"DIV",{class:!0});var Y1=f($c);p(vs.$$.fragment,Y1),Y1.forEach(n),F.forEach(n),Wg=a(e),ge=s(e,"DIV",{class:!0});var kp=f(ge);p(Ts.$$.fragment,kp),c_=a(kp),wc=s(kp,"P",{"data-svelte-h":!0}),b(wc)!=="svelte-ekiqb2"&&(wc.innerHTML=Zy),l_=a(kp),kc=s(kp,"DIV",{class:!0});var K1=f(kc);p(ys.$$.fragment,K1),K1.forEach(n),kp.forEach(n),Pg=a(e),ue=s(e,"DIV",{class:!0});var xp=f(ue);p($s.$$.fragment,xp),d_=a(xp),xc=s(xp,"P",{"data-svelte-h":!0}),b(xc)!=="svelte-1pwpj1b"&&(xc.innerHTML=Gy),p_=a(xp),Mc=s(xp,"DIV",{class:!0});var ew=f(Mc);p(ws.$$.fragment,ew),ew.forEach(n),xp.forEach(n),Vg=a(e),he=s(e,"DIV",{class:!0});var Mp=f(he);p(ks.$$.fragment,Mp),m_=a(Mp),Lc=s(Mp,"P",{"data-svelte-h":!0}),b(Lc)!=="svelte-y1kta5"&&(Lc.textContent=Ny),g_=a(Mp),jc=s(Mp,"DIV",{class:!0});var tw=f(jc);p(xs.$$.fragment,tw),tw.forEach(n),Mp.forEach(n),Dg=a(e),fe=s(e,"DIV",{class:!0});var Lp=f(fe);p(Ms.$$.fragment,Lp),u_=a(Lp),Fc=s(Lp,"P",{"data-svelte-h":!0}),b(Fc)!=="svelte-19brszz"&&(Fc.innerHTML=Xy),h_=a(Lp),zc=s(Lp,"DIV",{class:!0});var nw=f(zc);p(Ls.$$.fragment,nw),nw.forEach(n),Lp.forEach(n),Eg=a(e),_e=s(e,"DIV",{class:!0});var jp=f(_e);p(js.$$.fragment,jp),f_=a(jp),Cc=s(jp,"P",{"data-svelte-h":!0}),b(Cc)!=="svelte-th82mu"&&(Cc.textContent=Hy),__=a(jp),Jc=s(jp,"DIV",{class:!0});var ow=f(Jc);p(Fs.$$.fragment,ow),ow.forEach(n),jp.forEach(n),Zg=a(e),be=s(e,"DIV",{class:!0});var Fp=f(be);p(zs.$$.fragment,Fp),b_=a(Fp),Uc=s(Fp,"P",{"data-svelte-h":!0}),b(Uc)!=="svelte-yzbipn"&&(Uc.innerHTML=Ry),v_=a(Fp),Ic=s(Fp,"DIV",{class:!0});var sw=f(Ic);p(Cs.$$.fragment,sw),sw.forEach(n),Fp.forEach(n),Gg=a(e),R=s(e,"DIV",{class:!0});var On=f(R);p(Js.$$.fragment,On),T_=a(On),qc=s(On,"P",{"data-svelte-h":!0}),b(qc)!=="svelte-18ezl6o"&&(qc.innerHTML=Oy),y_=a(On),p(an.$$.fragment,On),$_=a(On),Bc=s(On,"DIV",{class:!0});var rw=f(Bc);p(Us.$$.fragment,rw),rw.forEach(n),On.forEach(n),Ng=a(e),B=s(e,"DIV",{class:!0});var st=f(B);p(Is.$$.fragment,st),w_=a(st),Sc=s(st,"P",{"data-svelte-h":!0}),b(Sc)!=="svelte-1q6t7p7"&&(Sc.innerHTML=Qy),k_=a(st),p(cn.$$.fragment,st),x_=a(st),p(ln.$$.fragment,st),M_=a(st),Wc=s(st,"DIV",{class:!0});var aw=f(Wc);p(qs.$$.fragment,aw),aw.forEach(n),st.forEach(n),Xg=a(e),S=s(e,"DIV",{class:!0});var rt=f(S);p(Bs.$$.fragment,rt),L_=a(rt),Pc=s(rt,"P",{"data-svelte-h":!0}),b(Pc)!=="svelte-cyendb"&&(Pc.innerHTML=Ay),j_=a(rt),p(dn.$$.fragment,rt),F_=a(rt),p(pn.$$.fragment,rt),z_=a(rt),Vc=s(rt,"DIV",{class:!0});var iw=f(Vc);p(Ss.$$.fragment,iw),iw.forEach(n),rt.forEach(n),Hg=a(e),ve=s(e,"DIV",{class:!0});var zp=f(ve);p(Ws.$$.fragment,zp),C_=a(zp),Dc=s(zp,"P",{"data-svelte-h":!0}),b(Dc)!=="svelte-18a18bn"&&(Dc.innerHTML=Yy),J_=a(zp),Ec=s(zp,"DIV",{class:!0});var cw=f(Ec);p(Ps.$$.fragment,cw),cw.forEach(n),zp.forEach(n),Rg=a(e),O=s(e,"DIV",{class:!0});var Qn=f(O);p(Vs.$$.fragment,Qn),U_=a(Qn),Zc=s(Qn,"P",{"data-svelte-h":!0}),b(Zc)!=="svelte-sxx0tg"&&(Zc.innerHTML=Ky),I_=a(Qn),p(mn.$$.fragment,Qn),q_=a(Qn),Gc=s(Qn,"DIV",{class:!0});var lw=f(Gc);p(Ds.$$.fragment,lw),lw.forEach(n),Qn.forEach(n),Og=a(e),W=s(e,"DIV",{class:!0});var at=f(W);p(Es.$$.fragment,at),B_=a(at),Nc=s(at,"P",{"data-svelte-h":!0}),b(Nc)!=="svelte-4ndvyu"&&(Nc.innerHTML=e$),S_=a(at),p(gn.$$.fragment,at),W_=a(at),p(un.$$.fragment,at),P_=a(at),Xc=s(at,"DIV",{class:!0});var dw=f(Xc);p(Zs.$$.fragment,dw),dw.forEach(n),at.forEach(n),Qg=a(e),Te=s(e,"DIV",{class:!0});var Cp=f(Te);p(Gs.$$.fragment,Cp),V_=a(Cp),Hc=s(Cp,"P",{"data-svelte-h":!0}),b(Hc)!=="svelte-mrvaxm"&&(Hc.innerHTML=t$),D_=a(Cp),Rc=s(Cp,"DIV",{class:!0});var pw=f(Rc);p(Ns.$$.fragment,pw),pw.forEach(n),Cp.forEach(n),Ag=a(e),ye=s(e,"DIV",{class:!0});var Jp=f(ye);p(Xs.$$.fragment,Jp),E_=a(Jp),Oc=s(Jp,"P",{"data-svelte-h":!0}),b(Oc)!=="svelte-a554sd"&&(Oc.innerHTML=n$),Z_=a(Jp),Qc=s(Jp,"DIV",{class:!0});var mw=f(Qc);p(Hs.$$.fragment,mw),mw.forEach(n),Jp.forEach(n),Yg=a(e),P=s(e,"DIV",{class:!0});var it=f(P);p(Rs.$$.fragment,it),G_=a(it),Ac=s(it,"P",{"data-svelte-h":!0}),b(Ac)!=="svelte-yewcel"&&(Ac.innerHTML=o$),N_=a(it),p(hn.$$.fragment,it),X_=a(it),p(fn.$$.fragment,it),H_=a(it),Yc=s(it,"DIV",{class:!0});var gw=f(Yc);p(Os.$$.fragment,gw),gw.forEach(n),it.forEach(n),Kg=a(e),$e=s(e,"DIV",{class:!0});var Up=f($e);p(Qs.$$.fragment,Up),R_=a(Up),Kc=s(Up,"P",{"data-svelte-h":!0}),b(Kc)!=="svelte-joa9hx"&&(Kc.innerHTML=s$),O_=a(Up),el=s(Up,"DIV",{class:!0});var uw=f(el);p(As.$$.fragment,uw),uw.forEach(n),Up.forEach(n),eu=a(e),Q=s(e,"DIV",{class:!0});var An=f(Q);p(Ys.$$.fragment,An),Q_=a(An),tl=s(An,"P",{"data-svelte-h":!0}),b(tl)!=="svelte-mq9erz"&&(tl.innerHTML=r$),A_=a(An),p(_n.$$.fragment,An),Y_=a(An),nl=s(An,"DIV",{class:!0});var hw=f(nl);p(Ks.$$.fragment,hw),hw.forEach(n),An.forEach(n),tu=a(e),we=s(e,"DIV",{class:!0});var Ip=f(we);p(er.$$.fragment,Ip),K_=a(Ip),ol=s(Ip,"P",{"data-svelte-h":!0}),b(ol)!=="svelte-z2xsla"&&(ol.innerHTML=a$),eb=a(Ip),sl=s(Ip,"DIV",{class:!0});var fw=f(sl);p(tr.$$.fragment,fw),fw.forEach(n),Ip.forEach(n),nu=a(e),V=s(e,"DIV",{class:!0});var ct=f(V);p(nr.$$.fragment,ct),tb=a(ct),rl=s(ct,"P",{"data-svelte-h":!0}),b(rl)!=="svelte-pi0cpg"&&(rl.innerHTML=i$),nb=a(ct),al=s(ct,"P",{"data-svelte-h":!0}),b(al)!=="svelte-5qs7tv"&&(al.innerHTML=c$),ob=a(ct),p(bn.$$.fragment,ct),sb=a(ct),il=s(ct,"DIV",{class:!0});var _w=f(il);p(or.$$.fragment,_w),_w.forEach(n),ct.forEach(n),ou=a(e),A=s(e,"DIV",{class:!0});var Yn=f(A);p(sr.$$.fragment,Yn),rb=a(Yn),cl=s(Yn,"P",{"data-svelte-h":!0}),b(cl)!=="svelte-1sygpwz"&&(cl.innerHTML=l$),ab=a(Yn),ll=s(Yn,"P",{"data-svelte-h":!0}),b(ll)!=="svelte-qmmn5t"&&(ll.innerHTML=d$),ib=a(Yn),dl=s(Yn,"DIV",{class:!0});var bw=f(dl);p(rr.$$.fragment,bw),bw.forEach(n),Yn.forEach(n),su=a(e),Bt=s(e,"H3",{class:!0});var Th=f(Bt);vn=s(Th,"A",{id:!0,class:!0,href:!0});var vw=f(vn);ym=s(vw,"SPAN",{});var Tw=f(ym);p(ar.$$.fragment,Tw),Tw.forEach(n),vw.forEach(n),cb=a(Th),pl=s(Th,"SPAN",{"data-svelte-h":!0}),b(pl)!=="svelte-13st32y"&&(pl.textContent=p$),Th.forEach(n),ru=a(e),ke=s(e,"DIV",{class:!0});var qp=f(ke);p(ir.$$.fragment,qp),lb=a(qp),ml=s(qp,"P",{"data-svelte-h":!0}),b(ml)!=="svelte-1x7g4xv"&&(ml.innerHTML=m$),db=a(qp),gl=s(qp,"DIV",{class:!0});var yw=f(gl);p(cr.$$.fragment,yw),yw.forEach(n),qp.forEach(n),au=a(e),xe=s(e,"DIV",{class:!0});var Bp=f(xe);p(lr.$$.fragment,Bp),pb=a(Bp),ul=s(Bp,"P",{"data-svelte-h":!0}),b(ul)!=="svelte-1b68bjr"&&(ul.innerHTML=g$),mb=a(Bp),hl=s(Bp,"DIV",{class:!0});var $w=f(hl);p(dr.$$.fragment,$w),$w.forEach(n),Bp.forEach(n),iu=a(e),Me=s(e,"DIV",{class:!0});var Sp=f(Me);p(pr.$$.fragment,Sp),gb=a(Sp),fl=s(Sp,"P",{"data-svelte-h":!0}),b(fl)!=="svelte-1557waw"&&(fl.innerHTML=u$),ub=a(Sp),_l=s(Sp,"DIV",{class:!0});var ww=f(_l);p(mr.$$.fragment,ww),ww.forEach(n),Sp.forEach(n),cu=a(e),Le=s(e,"DIV",{class:!0});var Wp=f(Le);p(gr.$$.fragment,Wp),hb=a(Wp),bl=s(Wp,"P",{"data-svelte-h":!0}),b(bl)!=="svelte-y1kta5"&&(bl.textContent=h$),fb=a(Wp),Tn=s(Wp,"DIV",{class:!0});var yh=f(Tn);p(ur.$$.fragment,yh),_b=a(yh),vl=s(yh,"P",{"data-svelte-h":!0}),b(vl)!=="svelte-5aspnb"&&(vl.textContent=f$),yh.forEach(n),Wp.forEach(n),lu=a(e),je=s(e,"DIV",{class:!0});var Pp=f(je);p(hr.$$.fragment,Pp),bb=a(Pp),Tl=s(Pp,"P",{"data-svelte-h":!0}),b(Tl)!=="svelte-hgyx93"&&(Tl.innerHTML=_$),vb=a(Pp),yl=s(Pp,"DIV",{class:!0});var kw=f(yl);p(fr.$$.fragment,kw),kw.forEach(n),Pp.forEach(n),du=a(e),Fe=s(e,"DIV",{class:!0});var Vp=f(Fe);p(_r.$$.fragment,Vp),Tb=a(Vp),$l=s(Vp,"P",{"data-svelte-h":!0}),b($l)!=="svelte-th82mu"&&($l.textContent=b$),yb=a(Vp),yn=s(Vp,"DIV",{class:!0});var $h=f(yn);p(br.$$.fragment,$h),$b=a($h),wl=s($h,"P",{"data-svelte-h":!0}),b(wl)!=="svelte-hcoglc"&&(wl.textContent=v$),$h.forEach(n),Vp.forEach(n),pu=a(e),ze=s(e,"DIV",{class:!0});var Dp=f(ze);p(vr.$$.fragment,Dp),wb=a(Dp),kl=s(Dp,"P",{"data-svelte-h":!0}),b(kl)!=="svelte-jvyswr"&&(kl.innerHTML=T$),kb=a(Dp),xl=s(Dp,"DIV",{class:!0});var xw=f(xl);p(Tr.$$.fragment,xw),xw.forEach(n),Dp.forEach(n),mu=a(e),Ce=s(e,"DIV",{class:!0});var Ep=f(Ce);p(yr.$$.fragment,Ep),xb=a(Ep),Ml=s(Ep,"P",{"data-svelte-h":!0}),b(Ml)!=="svelte-6y87sw"&&(Ml.innerHTML=y$),Mb=a(Ep),Ll=s(Ep,"DIV",{class:!0});var Mw=f(Ll);p($r.$$.fragment,Mw),Mw.forEach(n),Ep.forEach(n),gu=a(e),Je=s(e,"DIV",{class:!0});var Zp=f(Je);p(wr.$$.fragment,Zp),Lb=a(Zp),jl=s(Zp,"P",{"data-svelte-h":!0}),b(jl)!=="svelte-15uhqgw"&&(jl.innerHTML=$$),jb=a(Zp),Fl=s(Zp,"DIV",{class:!0});var Lw=f(Fl);p(kr.$$.fragment,Lw),Lw.forEach(n),Zp.forEach(n),uu=a(e),Ue=s(e,"DIV",{class:!0});var Gp=f(Ue);p(xr.$$.fragment,Gp),Fb=a(Gp),zl=s(Gp,"P",{"data-svelte-h":!0}),b(zl)!=="svelte-1ixhgqn"&&(zl.innerHTML=w$),zb=a(Gp),Cl=s(Gp,"DIV",{class:!0});var jw=f(Cl);p(Mr.$$.fragment,jw),jw.forEach(n),Gp.forEach(n),hu=a(e),Ie=s(e,"DIV",{class:!0});var Np=f(Ie);p(Lr.$$.fragment,Np),Cb=a(Np),Jl=s(Np,"P",{"data-svelte-h":!0}),b(Jl)!=="svelte-pr4gqu"&&(Jl.innerHTML=k$),Jb=a(Np),Ul=s(Np,"DIV",{class:!0});var Fw=f(Ul);p(jr.$$.fragment,Fw),Fw.forEach(n),Np.forEach(n),fu=a(e),qe=s(e,"DIV",{class:!0});var Xp=f(qe);p(Fr.$$.fragment,Xp),Ub=a(Xp),Il=s(Xp,"P",{"data-svelte-h":!0}),b(Il)!=="svelte-a554sd"&&(Il.innerHTML=x$),Ib=a(Xp),ql=s(Xp,"DIV",{class:!0});var zw=f(ql);p(zr.$$.fragment,zw),zw.forEach(n),Xp.forEach(n),_u=a(e),Be=s(e,"DIV",{class:!0});var Hp=f(Be);p(Cr.$$.fragment,Hp),qb=a(Hp),Bl=s(Hp,"P",{"data-svelte-h":!0}),b(Bl)!=="svelte-160yymm"&&(Bl.innerHTML=M$),Bb=a(Hp),Sl=s(Hp,"DIV",{class:!0});var Cw=f(Sl);p(Jr.$$.fragment,Cw),Cw.forEach(n),Hp.forEach(n),bu=a(e),Se=s(e,"DIV",{class:!0});var Rp=f(Se);p(Ur.$$.fragment,Rp),Sb=a(Rp),Wl=s(Rp,"P",{"data-svelte-h":!0}),b(Wl)!=="svelte-14j2hvx"&&(Wl.innerHTML=L$),Wb=a(Rp),Pl=s(Rp,"DIV",{class:!0});var Jw=f(Pl);p(Ir.$$.fragment,Jw),Jw.forEach(n),Rp.forEach(n),vu=a(e),We=s(e,"DIV",{class:!0});var Op=f(We);p(qr.$$.fragment,Op),Pb=a(Op),Vl=s(Op,"P",{"data-svelte-h":!0}),b(Vl)!=="svelte-1yoihn7"&&(Vl.innerHTML=j$),Vb=a(Op),Dl=s(Op,"DIV",{class:!0});var Uw=f(Dl);p(Br.$$.fragment,Uw),Uw.forEach(n),Op.forEach(n),Tu=a(e),St=s(e,"H3",{class:!0});var wh=f(St);$n=s(wh,"A",{id:!0,class:!0,href:!0});var Iw=f($n);$m=s(Iw,"SPAN",{});var qw=f($m);p(Sr.$$.fragment,qw),qw.forEach(n),Iw.forEach(n),Db=a(wh),El=s(wh,"SPAN",{"data-svelte-h":!0}),b(El)!=="svelte-1iv7dlo"&&(El.textContent=F$),wh.forEach(n),yu=a(e),Pe=s(e,"DIV",{class:!0});var Qp=f(Pe);p(Wr.$$.fragment,Qp),Eb=a(Qp),Zl=s(Qp,"P",{"data-svelte-h":!0}),b(Zl)!=="svelte-1cc1swr"&&(Zl.innerHTML=z$),Zb=a(Qp),Gl=s(Qp,"DIV",{class:!0});var Bw=f(Gl);p(Pr.$$.fragment,Bw),Bw.forEach(n),Qp.forEach(n),$u=a(e),Ve=s(e,"DIV",{class:!0});var Ap=f(Ve);p(Vr.$$.fragment,Ap),Gb=a(Ap),Nl=s(Ap,"P",{"data-svelte-h":!0}),b(Nl)!=="svelte-5cr5cv"&&(Nl.innerHTML=C$),Nb=a(Ap),Xl=s(Ap,"DIV",{class:!0});var Sw=f(Xl);p(Dr.$$.fragment,Sw),Sw.forEach(n),Ap.forEach(n),wu=a(e),De=s(e,"DIV",{class:!0});var Yp=f(De);p(Er.$$.fragment,Yp),Xb=a(Yp),Hl=s(Yp,"P",{"data-svelte-h":!0}),b(Hl)!=="svelte-16lo884"&&(Hl.innerHTML=J$),Hb=a(Yp),Rl=s(Yp,"DIV",{class:!0});var Ww=f(Rl);p(Zr.$$.fragment,Ww),Ww.forEach(n),Yp.forEach(n),ku=a(e),Ee=s(e,"DIV",{class:!0});var Kp=f(Ee);p(Gr.$$.fragment,Kp),Rb=a(Kp),Ol=s(Kp,"P",{"data-svelte-h":!0}),b(Ol)!=="svelte-y1kta5"&&(Ol.textContent=U$),Ob=a(Kp),wn=s(Kp,"DIV",{class:!0});var kh=f(wn);p(Nr.$$.fragment,kh),Qb=a(kh),Ql=s(kh,"P",{"data-svelte-h":!0}),b(Ql)!=="svelte-1l17mwc"&&(Ql.textContent=I$),kh.forEach(n),Kp.forEach(n),xu=a(e),Ze=s(e,"DIV",{class:!0});var em=f(Ze);p(Xr.$$.fragment,em),Ab=a(em),Al=s(em,"P",{"data-svelte-h":!0}),b(Al)!=="svelte-1dzjt33"&&(Al.innerHTML=q$),Yb=a(em),Yl=s(em,"DIV",{class:!0});var Pw=f(Yl);p(Hr.$$.fragment,Pw),Pw.forEach(n),em.forEach(n),Mu=a(e),Ge=s(e,"DIV",{class:!0});var tm=f(Ge);p(Rr.$$.fragment,tm),Kb=a(tm),Kl=s(tm,"P",{"data-svelte-h":!0}),b(Kl)!=="svelte-th82mu"&&(Kl.textContent=B$),ev=a(tm),kn=s(tm,"DIV",{class:!0});var xh=f(kn);p(Or.$$.fragment,xh),tv=a(xh),ed=s(xh,"P",{"data-svelte-h":!0}),b(ed)!=="svelte-1tcb5cf"&&(ed.textContent=S$),xh.forEach(n),tm.forEach(n),Lu=a(e),Ne=s(e,"DIV",{class:!0});var nm=f(Ne);p(Qr.$$.fragment,nm),nv=a(nm),td=s(nm,"P",{"data-svelte-h":!0}),b(td)!=="svelte-1alf4ur"&&(td.innerHTML=W$),ov=a(nm),nd=s(nm,"DIV",{class:!0});var Vw=f(nd);p(Ar.$$.fragment,Vw),Vw.forEach(n),nm.forEach(n),ju=a(e),Xe=s(e,"DIV",{class:!0});var om=f(Xe);p(Yr.$$.fragment,om),sv=a(om),od=s(om,"P",{"data-svelte-h":!0}),b(od)!=="svelte-16pfka7"&&(od.innerHTML=P$),rv=a(om),sd=s(om,"DIV",{class:!0});var Dw=f(sd);p(Kr.$$.fragment,Dw),Dw.forEach(n),om.forEach(n),Fu=a(e),He=s(e,"DIV",{class:!0});var sm=f(He);p(ea.$$.fragment,sm),av=a(sm),rd=s(sm,"P",{"data-svelte-h":!0}),b(rd)!=="svelte-bs4cah"&&(rd.innerHTML=V$),iv=a(sm),ad=s(sm,"DIV",{class:!0});var Ew=f(ad);p(ta.$$.fragment,Ew),Ew.forEach(n),sm.forEach(n),zu=a(e),Re=s(e,"DIV",{class:!0});var rm=f(Re);p(na.$$.fragment,rm),cv=a(rm),id=s(rm,"P",{"data-svelte-h":!0}),b(id)!=="svelte-55vwbg"&&(id.innerHTML=D$),lv=a(rm),cd=s(rm,"DIV",{class:!0});var Zw=f(cd);p(oa.$$.fragment,Zw),Zw.forEach(n),rm.forEach(n),Cu=a(e),Oe=s(e,"DIV",{class:!0});var am=f(Oe);p(sa.$$.fragment,am),dv=a(am),ld=s(am,"P",{"data-svelte-h":!0}),b(ld)!=="svelte-qx4wmv"&&(ld.innerHTML=E$),pv=a(am),dd=s(am,"DIV",{class:!0});var Gw=f(dd);p(ra.$$.fragment,Gw),Gw.forEach(n),am.forEach(n),Ju=a(e),Qe=s(e,"DIV",{class:!0});var im=f(Qe);p(aa.$$.fragment,im),mv=a(im),pd=s(im,"P",{"data-svelte-h":!0}),b(pd)!=="svelte-ffwf6h"&&(pd.innerHTML=Z$),gv=a(im),md=s(im,"DIV",{class:!0});var Nw=f(md);p(ia.$$.fragment,Nw),Nw.forEach(n),im.forEach(n),Uu=a(e),Ae=s(e,"DIV",{class:!0});var cm=f(Ae);p(ca.$$.fragment,cm),uv=a(cm),gd=s(cm,"P",{"data-svelte-h":!0}),b(gd)!=="svelte-1sygpwz"&&(gd.innerHTML=G$),hv=a(cm),ud=s(cm,"DIV",{class:!0});var Xw=f(ud);p(la.$$.fragment,Xw),Xw.forEach(n),cm.forEach(n),Iu=a(e),Wt=s(e,"H2",{class:!0});var Mh=f(Wt);xn=s(Mh,"A",{id:!0,class:!0,href:!0});var Hw=f(xn);wm=s(Hw,"SPAN",{});var Rw=f(wm);p(da.$$.fragment,Rw),Rw.forEach(n),Hw.forEach(n),fv=a(Mh),hd=s(Mh,"SPAN",{"data-svelte-h":!0}),b(hd)!=="svelte-d9s72"&&(hd.textContent=N$),Mh.forEach(n),qu=a(e),pa=s(e,"P",{"data-svelte-h":!0}),b(pa)!=="svelte-4i1t4j"&&(pa.innerHTML=X$),Bu=a(e),Ye=s(e,"DIV",{class:!0});var lm=f(Ye);p(ma.$$.fragment,lm),_v=a(lm),fd=s(lm,"P",{"data-svelte-h":!0}),b(fd)!=="svelte-rfvu1k"&&(fd.textContent=H$),bv=a(lm),_d=s(lm,"DIV",{class:!0});var Ow=f(_d);p(ga.$$.fragment,Ow),Ow.forEach(n),lm.forEach(n),Su=a(e),Pt=s(e,"DIV",{class:!0});var Lh=f(Pt);p(ua.$$.fragment,Lh),vv=a(Lh),bd=s(Lh,"DIV",{class:!0});var Qw=f(bd);p(ha.$$.fragment,Qw),Qw.forEach(n),Lh.forEach(n),Wu=a(e),Ke=s(e,"DIV",{class:!0});var dm=f(Ke);p(fa.$$.fragment,dm),Tv=a(dm),vd=s(dm,"P",{"data-svelte-h":!0}),b(vd)!=="svelte-4hfu96"&&(vd.innerHTML=R$),yv=a(dm),Td=s(dm,"DIV",{class:!0});var Aw=f(Td);p(_a.$$.fragment,Aw),Aw.forEach(n),dm.forEach(n),Pu=a(e),et=s(e,"DIV",{class:!0});var pm=f(et);p(ba.$$.fragment,pm),$v=a(pm),yd=s(pm,"P",{"data-svelte-h":!0}),b(yd)!=="svelte-q5v59n"&&(yd.innerHTML=O$),wv=a(pm),$d=s(pm,"DIV",{class:!0});var Yw=f($d);p(va.$$.fragment,Yw),Yw.forEach(n),pm.forEach(n),Vu=a(e),Vt=s(e,"H2",{class:!0});var jh=f(Vt);Mn=s(jh,"A",{id:!0,class:!0,href:!0});var Kw=f(Mn);km=s(Kw,"SPAN",{});var ek=f(km);p(Ta.$$.fragment,ek),ek.forEach(n),Kw.forEach(n),kv=a(jh),wd=s(jh,"SPAN",{"data-svelte-h":!0}),b(wd)!=="svelte-1ucxdbr"&&(wd.textContent=Q$),jh.forEach(n),Du=a(e),ya=s(e,"P",{"data-svelte-h":!0}),b(ya)!=="svelte-cxkf79"&&(ya.innerHTML=A$),Eu=a(e),j=s(e,"DIV",{class:!0});var z=f(j);p($a.$$.fragment,z),xv=a(z),kd=s(z,"P",{"data-svelte-h":!0}),b(kd)!=="svelte-1kh5y5v"&&(kd.textContent=Y$),Mv=a(z),xd=s(z,"P",{"data-svelte-h":!0}),b(xd)!=="svelte-1ygkifj"&&(xd.textContent=K$),Lv=a(z),p(Ln.$$.fragment,z),jv=a(z),Md=s(z,"P",{"data-svelte-h":!0}),b(Md)!=="svelte-7kbd1a"&&(Md.textContent=e1),Fv=a(z),jn=s(z,"DIV",{class:!0});var Fh=f(jn);p(wa.$$.fragment,Fh),zv=a(Fh),Ld=s(Fh,"P",{"data-svelte-h":!0}),b(Ld)!=="svelte-691079"&&(Ld.textContent=t1),Fh.forEach(n),Cv=a(z),Fn=s(z,"DIV",{class:!0});var zh=f(Fn);p(ka.$$.fragment,zh),Jv=a(zh),jd=s(zh,"P",{"data-svelte-h":!0}),b(jd)!=="svelte-dtkk01"&&(jd.textContent=n1),zh.forEach(n),Uv=a(z),zn=s(z,"DIV",{class:!0});var Ch=f(zn);p(xa.$$.fragment,Ch),Iv=a(Ch),Fd=s(Ch,"P",{"data-svelte-h":!0}),b(Fd)!=="svelte-11pa7k0"&&(Fd.textContent=o1),Ch.forEach(n),qv=a(z),Cn=s(z,"DIV",{class:!0});var Jh=f(Cn);p(Ma.$$.fragment,Jh),Bv=a(Jh),zd=s(Jh,"P",{"data-svelte-h":!0}),b(zd)!=="svelte-57vcuk"&&(zd.innerHTML=s1),Jh.forEach(n),Sv=a(z),Jn=s(z,"DIV",{class:!0});var Uh=f(Jn);p(La.$$.fragment,Uh),Wv=a(Uh),Cd=s(Uh,"P",{"data-svelte-h":!0}),b(Cd)!=="svelte-e342dt"&&(Cd.textContent=r1),Uh.forEach(n),Pv=a(z),Un=s(z,"DIV",{class:!0});var Ih=f(Un);p(ja.$$.fragment,Ih),Vv=a(Ih),Jd=s(Ih,"P",{"data-svelte-h":!0}),b(Jd)!=="svelte-vbd5xj"&&(Jd.textContent=a1),Ih.forEach(n),Dv=a(z),ot=s(z,"DIV",{class:!0});var mm=f(ot);p(Fa.$$.fragment,mm),Ev=a(mm),Ud=s(mm,"P",{"data-svelte-h":!0}),b(Ud)!=="svelte-1c2dshy"&&(Ud.innerHTML=i1),Zv=a(mm),Id=s(mm,"P",{"data-svelte-h":!0}),b(Id)!=="svelte-1qvu1un"&&(Id.textContent=c1),mm.forEach(n),z.forEach(n),Zu=a(e),Dt=s(e,"DIV",{class:!0});var qh=f(Dt);p(za.$$.fragment,qh),Gv=a(qh),qd=s(qh,"P",{"data-svelte-h":!0}),b(qd)!=="svelte-1cc9he1"&&(qd.innerHTML=l1),qh.forEach(n),Gu=a(e),Et=s(e,"DIV",{class:!0});var Bh=f(Et);p(Ca.$$.fragment,Bh),Nv=a(Bh),Bd=s(Bh,"P",{"data-svelte-h":!0}),b(Bd)!=="svelte-14jt7o"&&(Bd.innerHTML=d1),Bh.forEach(n),Nu=a(e),Y=s(e,"DIV",{class:!0});var Kn=f(Y);p(Ja.$$.fragment,Kn),Xv=a(Kn),Sd=s(Kn,"P",{"data-svelte-h":!0}),b(Sd)!=="svelte-rxlesw"&&(Sd.textContent=p1),Hv=a(Kn),I=s(Kn,"DIV",{class:!0});var te=f(I);p(Ua.$$.fragment,te),Rv=a(te),Wd=s(te,"P",{"data-svelte-h":!0}),b(Wd)!=="svelte-15hhlou"&&(Wd.textContent=m1),Ov=a(te),Pd=s(te,"P",{"data-svelte-h":!0}),b(Pd)!=="svelte-x0d0uq"&&(Pd.innerHTML=g1),Qv=a(te),Vd=s(te,"P",{"data-svelte-h":!0}),b(Vd)!=="svelte-1w36vm3"&&(Vd.innerHTML=u1),Av=a(te),Dd=s(te,"P",{"data-svelte-h":!0}),b(Dd)!=="svelte-1niq0qw"&&(Dd.innerHTML=h1),Yv=a(te),Ed=s(te,"P",{"data-svelte-h":!0}),b(Ed)!=="svelte-af4g6f"&&(Ed.textContent=f1),te.forEach(n),Kv=a(Kn),In=s(Kn,"DIV",{class:!0});var Sh=f(In);p(Ia.$$.fragment,Sh),eT=a(Sh),Zd=s(Sh,"P",{"data-svelte-h":!0}),b(Zd)!=="svelte-eab6jp"&&(Zd.textContent=_1),Sh.forEach(n),Kn.forEach(n),Xu=a(e),Zt=s(e,"H2",{class:!0});var Wh=f(Zt);qn=s(Wh,"A",{id:!0,class:!0,href:!0});var tk=f(qn);xm=s(tk,"SPAN",{});var nk=f(xm);p(qa.$$.fragment,nk),nk.forEach(n),tk.forEach(n),tT=a(Wh),Gd=s(Wh,"SPAN",{"data-svelte-h":!0}),b(Gd)!=="svelte-1wpuqq0"&&(Gd.textContent=b1),Wh.forEach(n),Hu=a(e),K=s(e,"DIV",{class:!0});var eo=f(K);p(Ba.$$.fragment,eo),nT=a(eo),Nd=s(eo,"P",{"data-svelte-h":!0}),b(Nd)!=="svelte-jpkr8b"&&(Nd.innerHTML=v1),oT=a(eo),Xd=s(eo,"DIV",{class:!0});var ok=f(Xd);p(Sa.$$.fragment,ok),ok.forEach(n),sT=a(eo),Hd=s(eo,"DIV",{class:!0});var sk=f(Hd);p(Wa.$$.fragment,sk),sk.forEach(n),eo.forEach(n),Ru=a(e),U=s(e,"DIV",{class:!0});var ne=f(U);p(Pa.$$.fragment,ne),rT=a(ne),Rd=s(ne,"P",{"data-svelte-h":!0}),b(Rd)!=="svelte-1h81qlk"&&(Rd.innerHTML=T1),aT=a(ne),Od=s(ne,"P",{"data-svelte-h":!0}),b(Od)!=="svelte-19qrwo1"&&(Od.innerHTML=y1),iT=a(ne),Qd=s(ne,"P",{"data-svelte-h":!0}),b(Qd)!=="svelte-l79sbt"&&(Qd.innerHTML=$1),cT=a(ne),Ad=s(ne,"DIV",{class:!0});var rk=f(Ad);p(Va.$$.fragment,rk),rk.forEach(n),lT=a(ne),Yd=s(ne,"DIV",{class:!0});var ak=f(Yd);p(Da.$$.fragment,ak),ak.forEach(n),ne.forEach(n),Ou=a(e),ee=s(e,"DIV",{class:!0});var to=f(ee);p(Ea.$$.fragment,to),dT=a(to),Kd=s(to,"P",{"data-svelte-h":!0}),b(Kd)!=="svelte-ktyou1"&&(Kd.innerHTML=w1),pT=a(to),ep=s(to,"DIV",{class:!0});var ik=f(ep);p(Za.$$.fragment,ik),ik.forEach(n),mT=a(to),tp=s(to,"DIV",{class:!0});var ck=f(tp);p(Ga.$$.fragment,ck),ck.forEach(n),to.forEach(n),Qu=a(e),Gt=s(e,"H2",{class:!0});var Ph=f(Gt);Bn=s(Ph,"A",{id:!0,class:!0,href:!0});var lk=f(Bn);Mm=s(lk,"SPAN",{});var dk=f(Mm);p(Na.$$.fragment,dk),dk.forEach(n),lk.forEach(n),gT=a(Ph),np=s(Ph,"SPAN",{"data-svelte-h":!0}),b(np)!=="svelte-z6eyrf"&&(np.textContent=k1),Ph.forEach(n),Au=a(e),tt=s(e,"DIV",{class:!0});var gm=f(tt);p(Xa.$$.fragment,gm),uT=a(gm),op=s(gm,"P",{"data-svelte-h":!0}),b(op)!=="svelte-1aiwpx2"&&(op.textContent=x1),hT=a(gm),sp=s(gm,"P",{"data-svelte-h":!0}),b(sp)!=="svelte-ts4ue3"&&(sp.innerHTML=M1),gm.forEach(n),Yu=a(e),nt=s(e,"DIV",{class:!0});var um=f(nt);p(Ha.$$.fragment,um),fT=a(um),rp=s(um,"P",{"data-svelte-h":!0}),b(rp)!=="svelte-1aiwpx2"&&(rp.textContent=L1),_T=a(um),ap=s(um,"P",{"data-svelte-h":!0}),b(ap)!=="svelte-ts4ue3"&&(ap.innerHTML=j1),um.forEach(n),Ku=a(e),Nt=s(e,"H2",{class:!0});var Vh=f(Nt);Sn=s(Vh,"A",{id:!0,class:!0,href:!0});var pk=f(Sn);Lm=s(pk,"SPAN",{});var mk=f(Lm);p(Ra.$$.fragment,mk),mk.forEach(n),pk.forEach(n),bT=a(Vh),ip=s(Vh,"SPAN",{"data-svelte-h":!0}),b(ip)!=="svelte-hzt923"&&(ip.textContent=F1),Vh.forEach(n),eh=a(e),J=s(e,"DIV",{class:!0});var E=f(J);p(Oa.$$.fragment,E),vT=a(E),cp=s(E,"P",{"data-svelte-h":!0}),b(cp)!=="svelte-5jvlz5"&&(cp.textContent=z1),TT=a(E),p(Wn.$$.fragment,E),yT=a(E),p(Pn.$$.fragment,E),$T=a(E),Vn=s(E,"DIV",{class:!0});var Dh=f(Vn);p(Qa.$$.fragment,Dh),wT=a(Dh),lp=s(Dh,"P",{"data-svelte-h":!0}),b(lp)!=="svelte-10d94rs"&&(lp.textContent=C1),Dh.forEach(n),kT=a(E),Dn=s(E,"DIV",{class:!0});var Eh=f(Dn);p(Aa.$$.fragment,Eh),xT=a(Eh),dp=s(Eh,"P",{"data-svelte-h":!0}),b(dp)!=="svelte-tm945r"&&(dp.textContent=J1),Eh.forEach(n),MT=a(E),En=s(E,"DIV",{class:!0});var Zh=f(En);p(Ya.$$.fragment,Zh),LT=a(Zh),pp=s(Zh,"P",{"data-svelte-h":!0}),b(pp)!=="svelte-1i1356p"&&(pp.textContent=U1),Zh.forEach(n),E.forEach(n),th=a(e),D=s(e,"DIV",{class:!0});var lt=f(D);p(Ka.$$.fragment,lt),jT=a(lt),mp=s(lt,"P",{"data-svelte-h":!0}),b(mp)!=="svelte-190fodr"&&(mp.textContent=I1),FT=a(lt),p(Zn.$$.fragment,lt),zT=a(lt),p(Gn.$$.fragment,lt),CT=a(lt),Nn=s(lt,"DIV",{class:!0});var Gh=f(Nn);p(ei.$$.fragment,Gh),JT=a(Gh),gp=s(Gh,"P",{"data-svelte-h":!0}),b(gp)!=="svelte-16i5iz"&&(gp.textContent=q1),Gh.forEach(n),lt.forEach(n),nh=a(e),jm=s(e,"P",{}),f(jm).forEach(n),this.h()},h(){l(v,"name","hf:doc:metadata"),l(v,"content",JSON.stringify(Dk)),l(_,"id","utilities-for-generation"),l(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(_,"href","#utilities-for-generation"),l(w,"class","relative group"),l(Xt,"id","generate-outputs"),l(Xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Xt,"href","#generate-outputs"),l(dt,"class","relative group"),l(Ht,"id","transformers.generation.GreedySearchEncoderDecoderOutput"),l(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Ht,"href","#transformers.generation.GreedySearchEncoderDecoderOutput"),l(pt,"class","relative group"),l(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Rt,"id","transformers.generation.TFGreedySearchEncoderDecoderOutput"),l(Rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Rt,"href","#transformers.generation.TFGreedySearchEncoderDecoderOutput"),l($t,"class","relative group"),l(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ot,"id","transformers.generation.FlaxSampleOutput"),l(Ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Ot,"href","#transformers.generation.FlaxSampleOutput"),l(Ut,"class","relative group"),l(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Kt,"id","logitsprocessor"),l(Kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Kt,"href","#logitsprocessor"),l(It,"class","relative group"),l(en,"id","transformers.AlternatingCodebooksLogitsProcessor"),l(en,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(en,"href","#transformers.AlternatingCodebooksLogitsProcessor"),l(qt,"class","relative group"),l(Oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(dc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(el,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(il,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(vn,"id","transformers.TFForcedBOSTokenLogitsProcessor"),l(vn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(vn,"href","#transformers.TFForcedBOSTokenLogitsProcessor"),l(Bt,"class","relative group"),l(gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(hl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ll,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Fl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ul,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($n,"id","transformers.FlaxForcedBOSTokenLogitsProcessor"),l($n,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l($n,"href","#transformers.FlaxForcedBOSTokenLogitsProcessor"),l(St,"class","relative group"),l(Gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Rl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xn,"id","transformers.StoppingCriteria"),l(xn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(xn,"href","#transformers.StoppingCriteria"),l(Wt,"class","relative group"),l(_d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mn,"id","transformers.Constraint"),l(Mn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Mn,"href","#transformers.Constraint"),l(Vt,"class","relative group"),l(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(qn,"id","transformers.BeamScorer"),l(qn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(qn,"href","#transformers.BeamScorer"),l(Zt,"class","relative group"),l(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Bn,"id","transformers.top_k_top_p_filtering"),l(Bn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Bn,"href","#transformers.top_k_top_p_filtering"),l(Gt,"class","relative group"),l(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Sn,"id","transformers.TextStreamer"),l(Sn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Sn,"href","#transformers.TextStreamer"),l(Nt,"class","relative group"),l(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,v),c(e,k,i),c(e,y,i),c(e,$,i),c(e,w,i),t(w,_),t(_,x),m(oo,x,null),t(w,Nh),t(w,hi),c(e,Sm,i),c(e,so,i),c(e,Wm,i),c(e,ro,i),c(e,Pm,i),c(e,dt,i),t(dt,Xt),t(Xt,hm),m(ao,hm,null),t(dt,Xh),t(dt,fi),c(e,Vm,i),c(e,io,i),c(e,Dm,i),c(e,co,i),c(e,Em,i),m(lo,e,i),c(e,Zm,i),c(e,po,i),c(e,Gm,i),c(e,mo,i),c(e,Nm,i),c(e,go,i),c(e,Xm,i),c(e,uo,i),c(e,Hm,i),c(e,ho,i),c(e,Rm,i),m(fo,e,i),c(e,Om,i),c(e,_o,i),c(e,Qm,i),c(e,bo,i),c(e,Am,i),c(e,vo,i),c(e,Ym,i),c(e,pt,i),t(pt,Ht),t(Ht,fm),m(To,fm,null),t(pt,Hh),t(pt,_i),c(e,Km,i),c(e,mt,i),m(yo,mt,null),t(mt,Rh),t(mt,bi),c(e,eg,i),c(e,gt,i),m($o,gt,null),t(gt,Oh),t(gt,vi),c(e,tg,i),c(e,ut,i),m(wo,ut,null),t(ut,Qh),t(ut,Ti),c(e,ng,i),c(e,ht,i),m(ko,ht,null),t(ht,Ah),t(ht,yi),c(e,og,i),c(e,ft,i),m(xo,ft,null),t(ft,Yh),t(ft,$i),c(e,sg,i),c(e,_t,i),m(Mo,_t,null),t(_t,Kh),t(_t,wi),c(e,rg,i),c(e,bt,i),m(Lo,bt,null),t(bt,ef),t(bt,ki),c(e,ag,i),c(e,vt,i),m(jo,vt,null),t(vt,tf),t(vt,xi),c(e,ig,i),c(e,Tt,i),m(Fo,Tt,null),t(Tt,nf),t(Tt,Mi),c(e,cg,i),c(e,yt,i),m(zo,yt,null),t(yt,of),t(yt,Li),c(e,lg,i),c(e,$t,i),t($t,Rt),t(Rt,_m),m(Co,_m,null),t($t,sf),t($t,ji),c(e,dg,i),c(e,wt,i),m(Jo,wt,null),t(wt,rf),t(wt,Fi),c(e,pg,i),c(e,kt,i),m(Uo,kt,null),t(kt,af),t(kt,zi),c(e,mg,i),c(e,xt,i),m(Io,xt,null),t(xt,cf),t(xt,Ci),c(e,gg,i),c(e,Mt,i),m(qo,Mt,null),t(Mt,lf),t(Mt,Ji),c(e,ug,i),c(e,Lt,i),m(Bo,Lt,null),t(Lt,df),t(Lt,Ui),c(e,hg,i),c(e,jt,i),m(So,jt,null),t(jt,pf),t(jt,Ii),c(e,fg,i),c(e,Ft,i),m(Wo,Ft,null),t(Ft,mf),t(Ft,qi),c(e,_g,i),c(e,zt,i),m(Po,zt,null),t(zt,gf),t(zt,Bi),c(e,bg,i),c(e,Ct,i),m(Vo,Ct,null),t(Ct,uf),t(Ct,Si),c(e,vg,i),c(e,Jt,i),m(Do,Jt,null),t(Jt,hf),t(Jt,Wi),c(e,Tg,i),c(e,Ut,i),t(Ut,Ot),t(Ot,bm),m(Eo,bm,null),t(Ut,ff),t(Ut,Pi),c(e,yg,i),c(e,oe,i),m(Zo,oe,null),t(oe,_f),t(oe,Vi),t(oe,bf),t(oe,Qt),m(Go,Qt,null),t(Qt,vf),t(Qt,Di),c(e,$g,i),c(e,se,i),m(No,se,null),t(se,Tf),t(se,Ei),t(se,yf),t(se,At),m(Xo,At,null),t(At,$f),t(At,Zi),c(e,wg,i),c(e,re,i),m(Ho,re,null),t(re,wf),t(re,Gi),t(re,kf),t(re,Yt),m(Ro,Yt,null),t(Yt,xf),t(Yt,Ni),c(e,kg,i),c(e,It,i),t(It,Kt),t(Kt,vm),m(Oo,vm,null),t(It,Mf),t(It,Xi),c(e,xg,i),c(e,Qo,i),c(e,Mg,i),c(e,qt,i),t(qt,en),t(en,Tm),m(Ao,Tm,null),t(qt,Lf),t(qt,Hi),c(e,Lg,i),c(e,ae,i),m(Yo,ae,null),t(ae,jf),t(ae,Ri),t(ae,Ff),t(ae,Oi),m(Ko,Oi,null),c(e,jg,i),c(e,N,i),m(es,N,null),t(N,zf),t(N,Qi),t(N,Cf),t(N,Ai),t(N,Jf),t(N,Yi),m(ts,Yi,null),c(e,Fg,i),c(e,ie,i),m(ns,ie,null),t(ie,Uf),t(ie,Ki),t(ie,If),t(ie,ec),m(os,ec,null),c(e,zg,i),c(e,ce,i),m(ss,ce,null),t(ce,qf),t(ce,tc),t(ce,Bf),t(ce,nc),m(rs,nc,null),c(e,Cg,i),c(e,X,i),m(as,X,null),t(X,Sf),t(X,oc),t(X,Wf),m(tn,X,null),t(X,Pf),t(X,sc),m(is,sc,null),c(e,Jg,i),c(e,H,i),m(cs,H,null),t(H,Vf),t(H,rc),t(H,Df),m(nn,H,null),t(H,Ef),t(H,ac),m(ls,ac,null),c(e,Ug,i),c(e,le,i),m(ds,le,null),t(le,Zf),t(le,ic),t(le,Gf),t(le,cc),m(ps,cc,null),c(e,Ig,i),c(e,de,i),m(ms,de,null),t(de,Nf),t(de,lc),t(de,Xf),t(de,dc),m(gs,dc,null),c(e,qg,i),c(e,pe,i),m(us,pe,null),t(pe,Hf),t(pe,pc),t(pe,Rf),t(pe,mc),m(hs,mc,null),c(e,Bg,i),c(e,me,i),m(fs,me,null),t(me,Of),t(me,gc),t(me,Qf),t(me,uc),m(_s,uc,null),c(e,Sg,i),c(e,L,i),m(bs,L,null),t(L,Af),t(L,hc),t(L,Yf),t(L,fc),t(L,Kf),m(on,L,null),t(L,e_),m(sn,L,null),t(L,t_),t(L,_c),t(L,n_),t(L,bc),t(L,o_),t(L,vc),t(L,s_),t(L,Tc),t(L,r_),t(L,yc),t(L,a_),m(rn,L,null),t(L,i_),t(L,$c),m(vs,$c,null),c(e,Wg,i),c(e,ge,i),m(Ts,ge,null),t(ge,c_),t(ge,wc),t(ge,l_),t(ge,kc),m(ys,kc,null),c(e,Pg,i),c(e,ue,i),m($s,ue,null),t(ue,d_),t(ue,xc),t(ue,p_),t(ue,Mc),m(ws,Mc,null),c(e,Vg,i),c(e,he,i),m(ks,he,null),t(he,m_),t(he,Lc),t(he,g_),t(he,jc),m(xs,jc,null),c(e,Dg,i),c(e,fe,i),m(Ms,fe,null),t(fe,u_),t(fe,Fc),t(fe,h_),t(fe,zc),m(Ls,zc,null),c(e,Eg,i),c(e,_e,i),m(js,_e,null),t(_e,f_),t(_e,Cc),t(_e,__),t(_e,Jc),m(Fs,Jc,null),c(e,Zg,i),c(e,be,i),m(zs,be,null),t(be,b_),t(be,Uc),t(be,v_),t(be,Ic),m(Cs,Ic,null),c(e,Gg,i),c(e,R,i),m(Js,R,null),t(R,T_),t(R,qc),t(R,y_),m(an,R,null),t(R,$_),t(R,Bc),m(Us,Bc,null),c(e,Ng,i),c(e,B,i),m(Is,B,null),t(B,w_),t(B,Sc),t(B,k_),m(cn,B,null),t(B,x_),m(ln,B,null),t(B,M_),t(B,Wc),m(qs,Wc,null),c(e,Xg,i),c(e,S,i),m(Bs,S,null),t(S,L_),t(S,Pc),t(S,j_),m(dn,S,null),t(S,F_),m(pn,S,null),t(S,z_),t(S,Vc),m(Ss,Vc,null),c(e,Hg,i),c(e,ve,i),m(Ws,ve,null),t(ve,C_),t(ve,Dc),t(ve,J_),t(ve,Ec),m(Ps,Ec,null),c(e,Rg,i),c(e,O,i),m(Vs,O,null),t(O,U_),t(O,Zc),t(O,I_),m(mn,O,null),t(O,q_),t(O,Gc),m(Ds,Gc,null),c(e,Og,i),c(e,W,i),m(Es,W,null),t(W,B_),t(W,Nc),t(W,S_),m(gn,W,null),t(W,W_),m(un,W,null),t(W,P_),t(W,Xc),m(Zs,Xc,null),c(e,Qg,i),c(e,Te,i),m(Gs,Te,null),t(Te,V_),t(Te,Hc),t(Te,D_),t(Te,Rc),m(Ns,Rc,null),c(e,Ag,i),c(e,ye,i),m(Xs,ye,null),t(ye,E_),t(ye,Oc),t(ye,Z_),t(ye,Qc),m(Hs,Qc,null),c(e,Yg,i),c(e,P,i),m(Rs,P,null),t(P,G_),t(P,Ac),t(P,N_),m(hn,P,null),t(P,X_),m(fn,P,null),t(P,H_),t(P,Yc),m(Os,Yc,null),c(e,Kg,i),c(e,$e,i),m(Qs,$e,null),t($e,R_),t($e,Kc),t($e,O_),t($e,el),m(As,el,null),c(e,eu,i),c(e,Q,i),m(Ys,Q,null),t(Q,Q_),t(Q,tl),t(Q,A_),m(_n,Q,null),t(Q,Y_),t(Q,nl),m(Ks,nl,null),c(e,tu,i),c(e,we,i),m(er,we,null),t(we,K_),t(we,ol),t(we,eb),t(we,sl),m(tr,sl,null),c(e,nu,i),c(e,V,i),m(nr,V,null),t(V,tb),t(V,rl),t(V,nb),t(V,al),t(V,ob),m(bn,V,null),t(V,sb),t(V,il),m(or,il,null),c(e,ou,i),c(e,A,i),m(sr,A,null),t(A,rb),t(A,cl),t(A,ab),t(A,ll),t(A,ib),t(A,dl),m(rr,dl,null),c(e,su,i),c(e,Bt,i),t(Bt,vn),t(vn,ym),m(ar,ym,null),t(Bt,cb),t(Bt,pl),c(e,ru,i),c(e,ke,i),m(ir,ke,null),t(ke,lb),t(ke,ml),t(ke,db),t(ke,gl),m(cr,gl,null),c(e,au,i),c(e,xe,i),m(lr,xe,null),t(xe,pb),t(xe,ul),t(xe,mb),t(xe,hl),m(dr,hl,null),c(e,iu,i),c(e,Me,i),m(pr,Me,null),t(Me,gb),t(Me,fl),t(Me,ub),t(Me,_l),m(mr,_l,null),c(e,cu,i),c(e,Le,i),m(gr,Le,null),t(Le,hb),t(Le,bl),t(Le,fb),t(Le,Tn),m(ur,Tn,null),t(Tn,_b),t(Tn,vl),c(e,lu,i),c(e,je,i),m(hr,je,null),t(je,bb),t(je,Tl),t(je,vb),t(je,yl),m(fr,yl,null),c(e,du,i),c(e,Fe,i),m(_r,Fe,null),t(Fe,Tb),t(Fe,$l),t(Fe,yb),t(Fe,yn),m(br,yn,null),t(yn,$b),t(yn,wl),c(e,pu,i),c(e,ze,i),m(vr,ze,null),t(ze,wb),t(ze,kl),t(ze,kb),t(ze,xl),m(Tr,xl,null),c(e,mu,i),c(e,Ce,i),m(yr,Ce,null),t(Ce,xb),t(Ce,Ml),t(Ce,Mb),t(Ce,Ll),m($r,Ll,null),c(e,gu,i),c(e,Je,i),m(wr,Je,null),t(Je,Lb),t(Je,jl),t(Je,jb),t(Je,Fl),m(kr,Fl,null),c(e,uu,i),c(e,Ue,i),m(xr,Ue,null),t(Ue,Fb),t(Ue,zl),t(Ue,zb),t(Ue,Cl),m(Mr,Cl,null),c(e,hu,i),c(e,Ie,i),m(Lr,Ie,null),t(Ie,Cb),t(Ie,Jl),t(Ie,Jb),t(Ie,Ul),m(jr,Ul,null),c(e,fu,i),c(e,qe,i),m(Fr,qe,null),t(qe,Ub),t(qe,Il),t(qe,Ib),t(qe,ql),m(zr,ql,null),c(e,_u,i),c(e,Be,i),m(Cr,Be,null),t(Be,qb),t(Be,Bl),t(Be,Bb),t(Be,Sl),m(Jr,Sl,null),c(e,bu,i),c(e,Se,i),m(Ur,Se,null),t(Se,Sb),t(Se,Wl),t(Se,Wb),t(Se,Pl),m(Ir,Pl,null),c(e,vu,i),c(e,We,i),m(qr,We,null),t(We,Pb),t(We,Vl),t(We,Vb),t(We,Dl),m(Br,Dl,null),c(e,Tu,i),c(e,St,i),t(St,$n),t($n,$m),m(Sr,$m,null),t(St,Db),t(St,El),c(e,yu,i),c(e,Pe,i),m(Wr,Pe,null),t(Pe,Eb),t(Pe,Zl),t(Pe,Zb),t(Pe,Gl),m(Pr,Gl,null),c(e,$u,i),c(e,Ve,i),m(Vr,Ve,null),t(Ve,Gb),t(Ve,Nl),t(Ve,Nb),t(Ve,Xl),m(Dr,Xl,null),c(e,wu,i),c(e,De,i),m(Er,De,null),t(De,Xb),t(De,Hl),t(De,Hb),t(De,Rl),m(Zr,Rl,null),c(e,ku,i),c(e,Ee,i),m(Gr,Ee,null),t(Ee,Rb),t(Ee,Ol),t(Ee,Ob),t(Ee,wn),m(Nr,wn,null),t(wn,Qb),t(wn,Ql),c(e,xu,i),c(e,Ze,i),m(Xr,Ze,null),t(Ze,Ab),t(Ze,Al),t(Ze,Yb),t(Ze,Yl),m(Hr,Yl,null),c(e,Mu,i),c(e,Ge,i),m(Rr,Ge,null),t(Ge,Kb),t(Ge,Kl),t(Ge,ev),t(Ge,kn),m(Or,kn,null),t(kn,tv),t(kn,ed),c(e,Lu,i),c(e,Ne,i),m(Qr,Ne,null),t(Ne,nv),t(Ne,td),t(Ne,ov),t(Ne,nd),m(Ar,nd,null),c(e,ju,i),c(e,Xe,i),m(Yr,Xe,null),t(Xe,sv),t(Xe,od),t(Xe,rv),t(Xe,sd),m(Kr,sd,null),c(e,Fu,i),c(e,He,i),m(ea,He,null),t(He,av),t(He,rd),t(He,iv),t(He,ad),m(ta,ad,null),c(e,zu,i),c(e,Re,i),m(na,Re,null),t(Re,cv),t(Re,id),t(Re,lv),t(Re,cd),m(oa,cd,null),c(e,Cu,i),c(e,Oe,i),m(sa,Oe,null),t(Oe,dv),t(Oe,ld),t(Oe,pv),t(Oe,dd),m(ra,dd,null),c(e,Ju,i),c(e,Qe,i),m(aa,Qe,null),t(Qe,mv),t(Qe,pd),t(Qe,gv),t(Qe,md),m(ia,md,null),c(e,Uu,i),c(e,Ae,i),m(ca,Ae,null),t(Ae,uv),t(Ae,gd),t(Ae,hv),t(Ae,ud),m(la,ud,null),c(e,Iu,i),c(e,Wt,i),t(Wt,xn),t(xn,wm),m(da,wm,null),t(Wt,fv),t(Wt,hd),c(e,qu,i),c(e,pa,i),c(e,Bu,i),c(e,Ye,i),m(ma,Ye,null),t(Ye,_v),t(Ye,fd),t(Ye,bv),t(Ye,_d),m(ga,_d,null),c(e,Su,i),c(e,Pt,i),m(ua,Pt,null),t(Pt,vv),t(Pt,bd),m(ha,bd,null),c(e,Wu,i),c(e,Ke,i),m(fa,Ke,null),t(Ke,Tv),t(Ke,vd),t(Ke,yv),t(Ke,Td),m(_a,Td,null),c(e,Pu,i),c(e,et,i),m(ba,et,null),t(et,$v),t(et,yd),t(et,wv),t(et,$d),m(va,$d,null),c(e,Vu,i),c(e,Vt,i),t(Vt,Mn),t(Mn,km),m(Ta,km,null),t(Vt,kv),t(Vt,wd),c(e,Du,i),c(e,ya,i),c(e,Eu,i),c(e,j,i),m($a,j,null),t(j,xv),t(j,kd),t(j,Mv),t(j,xd),t(j,Lv),m(Ln,j,null),t(j,jv),t(j,Md),t(j,Fv),t(j,jn),m(wa,jn,null),t(jn,zv),t(jn,Ld),t(j,Cv),t(j,Fn),m(ka,Fn,null),t(Fn,Jv),t(Fn,jd),t(j,Uv),t(j,zn),m(xa,zn,null),t(zn,Iv),t(zn,Fd),t(j,qv),t(j,Cn),m(Ma,Cn,null),t(Cn,Bv),t(Cn,zd),t(j,Sv),t(j,Jn),m(La,Jn,null),t(Jn,Wv),t(Jn,Cd),t(j,Pv),t(j,Un),m(ja,Un,null),t(Un,Vv),t(Un,Jd),t(j,Dv),t(j,ot),m(Fa,ot,null),t(ot,Ev),t(ot,Ud),t(ot,Zv),t(ot,Id),c(e,Zu,i),c(e,Dt,i),m(za,Dt,null),t(Dt,Gv),t(Dt,qd),c(e,Gu,i),c(e,Et,i),m(Ca,Et,null),t(Et,Nv),t(Et,Bd),c(e,Nu,i),c(e,Y,i),m(Ja,Y,null),t(Y,Xv),t(Y,Sd),t(Y,Hv),t(Y,I),m(Ua,I,null),t(I,Rv),t(I,Wd),t(I,Ov),t(I,Pd),t(I,Qv),t(I,Vd),t(I,Av),t(I,Dd),t(I,Yv),t(I,Ed),t(Y,Kv),t(Y,In),m(Ia,In,null),t(In,eT),t(In,Zd),c(e,Xu,i),c(e,Zt,i),t(Zt,qn),t(qn,xm),m(qa,xm,null),t(Zt,tT),t(Zt,Gd),c(e,Hu,i),c(e,K,i),m(Ba,K,null),t(K,nT),t(K,Nd),t(K,oT),t(K,Xd),m(Sa,Xd,null),t(K,sT),t(K,Hd),m(Wa,Hd,null),c(e,Ru,i),c(e,U,i),m(Pa,U,null),t(U,rT),t(U,Rd),t(U,aT),t(U,Od),t(U,iT),t(U,Qd),t(U,cT),t(U,Ad),m(Va,Ad,null),t(U,lT),t(U,Yd),m(Da,Yd,null),c(e,Ou,i),c(e,ee,i),m(Ea,ee,null),t(ee,dT),t(ee,Kd),t(ee,pT),t(ee,ep),m(Za,ep,null),t(ee,mT),t(ee,tp),m(Ga,tp,null),c(e,Qu,i),c(e,Gt,i),t(Gt,Bn),t(Bn,Mm),m(Na,Mm,null),t(Gt,gT),t(Gt,np),c(e,Au,i),c(e,tt,i),m(Xa,tt,null),t(tt,uT),t(tt,op),t(tt,hT),t(tt,sp),c(e,Yu,i),c(e,nt,i),m(Ha,nt,null),t(nt,fT),t(nt,rp),t(nt,_T),t(nt,ap),c(e,Ku,i),c(e,Nt,i),t(Nt,Sn),t(Sn,Lm),m(Ra,Lm,null),t(Nt,bT),t(Nt,ip),c(e,eh,i),c(e,J,i),m(Oa,J,null),t(J,vT),t(J,cp),t(J,TT),m(Wn,J,null),t(J,yT),m(Pn,J,null),t(J,$T),t(J,Vn),m(Qa,Vn,null),t(Vn,wT),t(Vn,lp),t(J,kT),t(J,Dn),m(Aa,Dn,null),t(Dn,xT),t(Dn,dp),t(J,MT),t(J,En),m(Ya,En,null),t(En,LT),t(En,pp),c(e,th,i),c(e,D,i),m(Ka,D,null),t(D,jT),t(D,mp),t(D,FT),m(Zn,D,null),t(D,zT),m(Gn,D,null),t(D,CT),t(D,Nn),m(ei,Nn,null),t(Nn,JT),t(Nn,gp),c(e,nh,i),c(e,jm,i),oh=!0},p(e,[i]){const ti={};i&2&&(ti.$$scope={dirty:i,ctx:e}),tn.$set(ti);const Fm={};i&2&&(Fm.$$scope={dirty:i,ctx:e}),nn.$set(Fm);const zm={};i&2&&(zm.$$scope={dirty:i,ctx:e}),on.$set(zm);const ni={};i&2&&(ni.$$scope={dirty:i,ctx:e}),sn.$set(ni);const Cm={};i&2&&(Cm.$$scope={dirty:i,ctx:e}),rn.$set(Cm);const Jm={};i&2&&(Jm.$$scope={dirty:i,ctx:e}),an.$set(Jm);const oi={};i&2&&(oi.$$scope={dirty:i,ctx:e}),cn.$set(oi);const Um={};i&2&&(Um.$$scope={dirty:i,ctx:e}),ln.$set(Um);const Im={};i&2&&(Im.$$scope={dirty:i,ctx:e}),dn.$set(Im);const si={};i&2&&(si.$$scope={dirty:i,ctx:e}),pn.$set(si);const ri={};i&2&&(ri.$$scope={dirty:i,ctx:e}),mn.$set(ri);const ai={};i&2&&(ai.$$scope={dirty:i,ctx:e}),gn.$set(ai);const ii={};i&2&&(ii.$$scope={dirty:i,ctx:e}),un.$set(ii);const ci={};i&2&&(ci.$$scope={dirty:i,ctx:e}),hn.$set(ci);const li={};i&2&&(li.$$scope={dirty:i,ctx:e}),fn.$set(li);const di={};i&2&&(di.$$scope={dirty:i,ctx:e}),_n.$set(di);const pi={};i&2&&(pi.$$scope={dirty:i,ctx:e}),bn.$set(pi);const mi={};i&2&&(mi.$$scope={dirty:i,ctx:e}),Ln.$set(mi);const gi={};i&2&&(gi.$$scope={dirty:i,ctx:e}),Wn.$set(gi);const ui={};i&2&&(ui.$$scope={dirty:i,ctx:e}),Pn.$set(ui);const qm={};i&2&&(qm.$$scope={dirty:i,ctx:e}),Zn.$set(qm);const Bm={};i&2&&(Bm.$$scope={dirty:i,ctx:e}),Gn.$set(Bm)},i(e){oh||(g(oo.$$.fragment,e),g(ao.$$.fragment,e),g(lo.$$.fragment,e),g(fo.$$.fragment,e),g(To.$$.fragment,e),g(yo.$$.fragment,e),g($o.$$.fragment,e),g(wo.$$.fragment,e),g(ko.$$.fragment,e),g(xo.$$.fragment,e),g(Mo.$$.fragment,e),g(Lo.$$.fragment,e),g(jo.$$.fragment,e),g(Fo.$$.fragment,e),g(zo.$$.fragment,e),g(Co.$$.fragment,e),g(Jo.$$.fragment,e),g(Uo.$$.fragment,e),g(Io.$$.fragment,e),g(qo.$$.fragment,e),g(Bo.$$.fragment,e),g(So.$$.fragment,e),g(Wo.$$.fragment,e),g(Po.$$.fragment,e),g(Vo.$$.fragment,e),g(Do.$$.fragment,e),g(Eo.$$.fragment,e),g(Zo.$$.fragment,e),g(Go.$$.fragment,e),g(No.$$.fragment,e),g(Xo.$$.fragment,e),g(Ho.$$.fragment,e),g(Ro.$$.fragment,e),g(Oo.$$.fragment,e),g(Ao.$$.fragment,e),g(Yo.$$.fragment,e),g(Ko.$$.fragment,e),g(es.$$.fragment,e),g(ts.$$.fragment,e),g(ns.$$.fragment,e),g(os.$$.fragment,e),g(ss.$$.fragment,e),g(rs.$$.fragment,e),g(as.$$.fragment,e),g(tn.$$.fragment,e),g(is.$$.fragment,e),g(cs.$$.fragment,e),g(nn.$$.fragment,e),g(ls.$$.fragment,e),g(ds.$$.fragment,e),g(ps.$$.fragment,e),g(ms.$$.fragment,e),g(gs.$$.fragment,e),g(us.$$.fragment,e),g(hs.$$.fragment,e),g(fs.$$.fragment,e),g(_s.$$.fragment,e),g(bs.$$.fragment,e),g(on.$$.fragment,e),g(sn.$$.fragment,e),g(rn.$$.fragment,e),g(vs.$$.fragment,e),g(Ts.$$.fragment,e),g(ys.$$.fragment,e),g($s.$$.fragment,e),g(ws.$$.fragment,e),g(ks.$$.fragment,e),g(xs.$$.fragment,e),g(Ms.$$.fragment,e),g(Ls.$$.fragment,e),g(js.$$.fragment,e),g(Fs.$$.fragment,e),g(zs.$$.fragment,e),g(Cs.$$.fragment,e),g(Js.$$.fragment,e),g(an.$$.fragment,e),g(Us.$$.fragment,e),g(Is.$$.fragment,e),g(cn.$$.fragment,e),g(ln.$$.fragment,e),g(qs.$$.fragment,e),g(Bs.$$.fragment,e),g(dn.$$.fragment,e),g(pn.$$.fragment,e),g(Ss.$$.fragment,e),g(Ws.$$.fragment,e),g(Ps.$$.fragment,e),g(Vs.$$.fragment,e),g(mn.$$.fragment,e),g(Ds.$$.fragment,e),g(Es.$$.fragment,e),g(gn.$$.fragment,e),g(un.$$.fragment,e),g(Zs.$$.fragment,e),g(Gs.$$.fragment,e),g(Ns.$$.fragment,e),g(Xs.$$.fragment,e),g(Hs.$$.fragment,e),g(Rs.$$.fragment,e),g(hn.$$.fragment,e),g(fn.$$.fragment,e),g(Os.$$.fragment,e),g(Qs.$$.fragment,e),g(As.$$.fragment,e),g(Ys.$$.fragment,e),g(_n.$$.fragment,e),g(Ks.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(nr.$$.fragment,e),g(bn.$$.fragment,e),g(or.$$.fragment,e),g(sr.$$.fragment,e),g(rr.$$.fragment,e),g(ar.$$.fragment,e),g(ir.$$.fragment,e),g(cr.$$.fragment,e),g(lr.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(mr.$$.fragment,e),g(gr.$$.fragment,e),g(ur.$$.fragment,e),g(hr.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(br.$$.fragment,e),g(vr.$$.fragment,e),g(Tr.$$.fragment,e),g(yr.$$.fragment,e),g($r.$$.fragment,e),g(wr.$$.fragment,e),g(kr.$$.fragment,e),g(xr.$$.fragment,e),g(Mr.$$.fragment,e),g(Lr.$$.fragment,e),g(jr.$$.fragment,e),g(Fr.$$.fragment,e),g(zr.$$.fragment,e),g(Cr.$$.fragment,e),g(Jr.$$.fragment,e),g(Ur.$$.fragment,e),g(Ir.$$.fragment,e),g(qr.$$.fragment,e),g(Br.$$.fragment,e),g(Sr.$$.fragment,e),g(Wr.$$.fragment,e),g(Pr.$$.fragment,e),g(Vr.$$.fragment,e),g(Dr.$$.fragment,e),g(Er.$$.fragment,e),g(Zr.$$.fragment,e),g(Gr.$$.fragment,e),g(Nr.$$.fragment,e),g(Xr.$$.fragment,e),g(Hr.$$.fragment,e),g(Rr.$$.fragment,e),g(Or.$$.fragment,e),g(Qr.$$.fragment,e),g(Ar.$$.fragment,e),g(Yr.$$.fragment,e),g(Kr.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(na.$$.fragment,e),g(oa.$$.fragment,e),g(sa.$$.fragment,e),g(ra.$$.fragment,e),g(aa.$$.fragment,e),g(ia.$$.fragment,e),g(ca.$$.fragment,e),g(la.$$.fragment,e),g(da.$$.fragment,e),g(ma.$$.fragment,e),g(ga.$$.fragment,e),g(ua.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(va.$$.fragment,e),g(Ta.$$.fragment,e),g($a.$$.fragment,e),g(Ln.$$.fragment,e),g(wa.$$.fragment,e),g(ka.$$.fragment,e),g(xa.$$.fragment,e),g(Ma.$$.fragment,e),g(La.$$.fragment,e),g(ja.$$.fragment,e),g(Fa.$$.fragment,e),g(za.$$.fragment,e),g(Ca.$$.fragment,e),g(Ja.$$.fragment,e),g(Ua.$$.fragment,e),g(Ia.$$.fragment,e),g(qa.$$.fragment,e),g(Ba.$$.fragment,e),g(Sa.$$.fragment,e),g(Wa.$$.fragment,e),g(Pa.$$.fragment,e),g(Va.$$.fragment,e),g(Da.$$.fragment,e),g(Ea.$$.fragment,e),g(Za.$$.fragment,e),g(Ga.$$.fragment,e),g(Na.$$.fragment,e),g(Xa.$$.fragment,e),g(Ha.$$.fragment,e),g(Ra.$$.fragment,e),g(Oa.$$.fragment,e),g(Wn.$$.fragment,e),g(Pn.$$.fragment,e),g(Qa.$$.fragment,e),g(Aa.$$.fragment,e),g(Ya.$$.fragment,e),g(Ka.$$.fragment,e),g(Zn.$$.fragment,e),g(Gn.$$.fragment,e),g(ei.$$.fragment,e),oh=!0)},o(e){u(oo.$$.fragment,e),u(ao.$$.fragment,e),u(lo.$$.fragment,e),u(fo.$$.fragment,e),u(To.$$.fragment,e),u(yo.$$.fragment,e),u($o.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(xo.$$.fragment,e),u(Mo.$$.fragment,e),u(Lo.$$.fragment,e),u(jo.$$.fragment,e),u(Fo.$$.fragment,e),u(zo.$$.fragment,e),u(Co.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(Io.$$.fragment,e),u(qo.$$.fragment,e),u(Bo.$$.fragment,e),u(So.$$.fragment,e),u(Wo.$$.fragment,e),u(Po.$$.fragment,e),u(Vo.$$.fragment,e),u(Do.$$.fragment,e),u(Eo.$$.fragment,e),u(Zo.$$.fragment,e),u(Go.$$.fragment,e),u(No.$$.fragment,e),u(Xo.$$.fragment,e),u(Ho.$$.fragment,e),u(Ro.$$.fragment,e),u(Oo.$$.fragment,e),u(Ao.$$.fragment,e),u(Yo.$$.fragment,e),u(Ko.$$.fragment,e),u(es.$$.fragment,e),u(ts.$$.fragment,e),u(ns.$$.fragment,e),u(os.$$.fragment,e),u(ss.$$.fragment,e),u(rs.$$.fragment,e),u(as.$$.fragment,e),u(tn.$$.fragment,e),u(is.$$.fragment,e),u(cs.$$.fragment,e),u(nn.$$.fragment,e),u(ls.$$.fragment,e),u(ds.$$.fragment,e),u(ps.$$.fragment,e),u(ms.$$.fragment,e),u(gs.$$.fragment,e),u(us.$$.fragment,e),u(hs.$$.fragment,e),u(fs.$$.fragment,e),u(_s.$$.fragment,e),u(bs.$$.fragment,e),u(on.$$.fragment,e),u(sn.$$.fragment,e),u(rn.$$.fragment,e),u(vs.$$.fragment,e),u(Ts.$$.fragment,e),u(ys.$$.fragment,e),u($s.$$.fragment,e),u(ws.$$.fragment,e),u(ks.$$.fragment,e),u(xs.$$.fragment,e),u(Ms.$$.fragment,e),u(Ls.$$.fragment,e),u(js.$$.fragment,e),u(Fs.$$.fragment,e),u(zs.$$.fragment,e),u(Cs.$$.fragment,e),u(Js.$$.fragment,e),u(an.$$.fragment,e),u(Us.$$.fragment,e),u(Is.$$.fragment,e),u(cn.$$.fragment,e),u(ln.$$.fragment,e),u(qs.$$.fragment,e),u(Bs.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(Ss.$$.fragment,e),u(Ws.$$.fragment,e),u(Ps.$$.fragment,e),u(Vs.$$.fragment,e),u(mn.$$.fragment,e),u(Ds.$$.fragment,e),u(Es.$$.fragment,e),u(gn.$$.fragment,e),u(un.$$.fragment,e),u(Zs.$$.fragment,e),u(Gs.$$.fragment,e),u(Ns.$$.fragment,e),u(Xs.$$.fragment,e),u(Hs.$$.fragment,e),u(Rs.$$.fragment,e),u(hn.$$.fragment,e),u(fn.$$.fragment,e),u(Os.$$.fragment,e),u(Qs.$$.fragment,e),u(As.$$.fragment,e),u(Ys.$$.fragment,e),u(_n.$$.fragment,e),u(Ks.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(nr.$$.fragment,e),u(bn.$$.fragment,e),u(or.$$.fragment,e),u(sr.$$.fragment,e),u(rr.$$.fragment,e),u(ar.$$.fragment,e),u(ir.$$.fragment,e),u(cr.$$.fragment,e),u(lr.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(ur.$$.fragment,e),u(hr.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(vr.$$.fragment,e),u(Tr.$$.fragment,e),u(yr.$$.fragment,e),u($r.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u(xr.$$.fragment,e),u(Mr.$$.fragment,e),u(Lr.$$.fragment,e),u(jr.$$.fragment,e),u(Fr.$$.fragment,e),u(zr.$$.fragment,e),u(Cr.$$.fragment,e),u(Jr.$$.fragment,e),u(Ur.$$.fragment,e),u(Ir.$$.fragment,e),u(qr.$$.fragment,e),u(Br.$$.fragment,e),u(Sr.$$.fragment,e),u(Wr.$$.fragment,e),u(Pr.$$.fragment,e),u(Vr.$$.fragment,e),u(Dr.$$.fragment,e),u(Er.$$.fragment,e),u(Zr.$$.fragment,e),u(Gr.$$.fragment,e),u(Nr.$$.fragment,e),u(Xr.$$.fragment,e),u(Hr.$$.fragment,e),u(Rr.$$.fragment,e),u(Or.$$.fragment,e),u(Qr.$$.fragment,e),u(Ar.$$.fragment,e),u(Yr.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(na.$$.fragment,e),u(oa.$$.fragment,e),u(sa.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(ia.$$.fragment,e),u(ca.$$.fragment,e),u(la.$$.fragment,e),u(da.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ua.$$.fragment,e),u(ha.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(va.$$.fragment,e),u(Ta.$$.fragment,e),u($a.$$.fragment,e),u(Ln.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u(xa.$$.fragment,e),u(Ma.$$.fragment,e),u(La.$$.fragment,e),u(ja.$$.fragment,e),u(Fa.$$.fragment,e),u(za.$$.fragment,e),u(Ca.$$.fragment,e),u(Ja.$$.fragment,e),u(Ua.$$.fragment,e),u(Ia.$$.fragment,e),u(qa.$$.fragment,e),u(Ba.$$.fragment,e),u(Sa.$$.fragment,e),u(Wa.$$.fragment,e),u(Pa.$$.fragment,e),u(Va.$$.fragment,e),u(Da.$$.fragment,e),u(Ea.$$.fragment,e),u(Za.$$.fragment,e),u(Ga.$$.fragment,e),u(Na.$$.fragment,e),u(Xa.$$.fragment,e),u(Ha.$$.fragment,e),u(Ra.$$.fragment,e),u(Oa.$$.fragment,e),u(Wn.$$.fragment,e),u(Pn.$$.fragment,e),u(Qa.$$.fragment,e),u(Aa.$$.fragment,e),u(Ya.$$.fragment,e),u(Ka.$$.fragment,e),u(Zn.$$.fragment,e),u(Gn.$$.fragment,e),u(ei.$$.fragment,e),oh=!1},d(e){e&&(n(k),n(y),n($),n(w),n(Sm),n(so),n(Wm),n(ro),n(Pm),n(dt),n(Vm),n(io),n(Dm),n(co),n(Em),n(Zm),n(po),n(Gm),n(mo),n(Nm),n(go),n(Xm),n(uo),n(Hm),n(ho),n(Rm),n(Om),n(_o),n(Qm),n(bo),n(Am),n(vo),n(Ym),n(pt),n(Km),n(mt),n(eg),n(gt),n(tg),n(ut),n(ng),n(ht),n(og),n(ft),n(sg),n(_t),n(rg),n(bt),n(ag),n(vt),n(ig),n(Tt),n(cg),n(yt),n(lg),n($t),n(dg),n(wt),n(pg),n(kt),n(mg),n(xt),n(gg),n(Mt),n(ug),n(Lt),n(hg),n(jt),n(fg),n(Ft),n(_g),n(zt),n(bg),n(Ct),n(vg),n(Jt),n(Tg),n(Ut),n(yg),n(oe),n($g),n(se),n(wg),n(re),n(kg),n(It),n(xg),n(Qo),n(Mg),n(qt),n(Lg),n(ae),n(jg),n(N),n(Fg),n(ie),n(zg),n(ce),n(Cg),n(X),n(Jg),n(H),n(Ug),n(le),n(Ig),n(de),n(qg),n(pe),n(Bg),n(me),n(Sg),n(L),n(Wg),n(ge),n(Pg),n(ue),n(Vg),n(he),n(Dg),n(fe),n(Eg),n(_e),n(Zg),n(be),n(Gg),n(R),n(Ng),n(B),n(Xg),n(S),n(Hg),n(ve),n(Rg),n(O),n(Og),n(W),n(Qg),n(Te),n(Ag),n(ye),n(Yg),n(P),n(Kg),n($e),n(eu),n(Q),n(tu),n(we),n(nu),n(V),n(ou),n(A),n(su),n(Bt),n(ru),n(ke),n(au),n(xe),n(iu),n(Me),n(cu),n(Le),n(lu),n(je),n(du),n(Fe),n(pu),n(ze),n(mu),n(Ce),n(gu),n(Je),n(uu),n(Ue),n(hu),n(Ie),n(fu),n(qe),n(_u),n(Be),n(bu),n(Se),n(vu),n(We),n(Tu),n(St),n(yu),n(Pe),n($u),n(Ve),n(wu),n(De),n(ku),n(Ee),n(xu),n(Ze),n(Mu),n(Ge),n(Lu),n(Ne),n(ju),n(Xe),n(Fu),n(He),n(zu),n(Re),n(Cu),n(Oe),n(Ju),n(Qe),n(Uu),n(Ae),n(Iu),n(Wt),n(qu),n(pa),n(Bu),n(Ye),n(Su),n(Pt),n(Wu),n(Ke),n(Pu),n(et),n(Vu),n(Vt),n(Du),n(ya),n(Eu),n(j),n(Zu),n(Dt),n(Gu),n(Et),n(Nu),n(Y),n(Xu),n(Zt),n(Hu),n(K),n(Ru),n(U),n(Ou),n(ee),n(Qu),n(Gt),n(Au),n(tt),n(Yu),n(nt),n(Ku),n(Nt),n(eh),n(J),n(th),n(D),n(nh),n(jm)),n(v),h(oo),h(ao),h(lo,e),h(fo,e),h(To),h(yo),h($o),h(wo),h(ko),h(xo),h(Mo),h(Lo),h(jo),h(Fo),h(zo),h(Co),h(Jo),h(Uo),h(Io),h(qo),h(Bo),h(So),h(Wo),h(Po),h(Vo),h(Do),h(Eo),h(Zo),h(Go),h(No),h(Xo),h(Ho),h(Ro),h(Oo),h(Ao),h(Yo),h(Ko),h(es),h(ts),h(ns),h(os),h(ss),h(rs),h(as),h(tn),h(is),h(cs),h(nn),h(ls),h(ds),h(ps),h(ms),h(gs),h(us),h(hs),h(fs),h(_s),h(bs),h(on),h(sn),h(rn),h(vs),h(Ts),h(ys),h($s),h(ws),h(ks),h(xs),h(Ms),h(Ls),h(js),h(Fs),h(zs),h(Cs),h(Js),h(an),h(Us),h(Is),h(cn),h(ln),h(qs),h(Bs),h(dn),h(pn),h(Ss),h(Ws),h(Ps),h(Vs),h(mn),h(Ds),h(Es),h(gn),h(un),h(Zs),h(Gs),h(Ns),h(Xs),h(Hs),h(Rs),h(hn),h(fn),h(Os),h(Qs),h(As),h(Ys),h(_n),h(Ks),h(er),h(tr),h(nr),h(bn),h(or),h(sr),h(rr),h(ar),h(ir),h(cr),h(lr),h(dr),h(pr),h(mr),h(gr),h(ur),h(hr),h(fr),h(_r),h(br),h(vr),h(Tr),h(yr),h($r),h(wr),h(kr),h(xr),h(Mr),h(Lr),h(jr),h(Fr),h(zr),h(Cr),h(Jr),h(Ur),h(Ir),h(qr),h(Br),h(Sr),h(Wr),h(Pr),h(Vr),h(Dr),h(Er),h(Zr),h(Gr),h(Nr),h(Xr),h(Hr),h(Rr),h(Or),h(Qr),h(Ar),h(Yr),h(Kr),h(ea),h(ta),h(na),h(oa),h(sa),h(ra),h(aa),h(ia),h(ca),h(la),h(da),h(ma),h(ga),h(ua),h(ha),h(fa),h(_a),h(ba),h(va),h(Ta),h($a),h(Ln),h(wa),h(ka),h(xa),h(Ma),h(La),h(ja),h(Fa),h(za),h(Ca),h(Ja),h(Ua),h(Ia),h(qa),h(Ba),h(Sa),h(Wa),h(Pa),h(Va),h(Da),h(Ea),h(Za),h(Ga),h(Na),h(Xa),h(Ha),h(Ra),h(Oa),h(Wn),h(Pn),h(Qa),h(Aa),h(Ya),h(Ka),h(Zn),h(Gn),h(ei)}}}const Dk={local:"utilities-for-generation",sections:[{local:"generate-outputs",sections:[{local:"transformers.generation.GreedySearchEncoderDecoderOutput",title:"PyTorch"},{local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",title:"TensorFlow"},{local:"transformers.generation.FlaxSampleOutput",title:"FLAX"}],title:"Generate Outputs"},{local:"logitsprocessor",sections:[{local:"transformers.AlternatingCodebooksLogitsProcessor",title:"PyTorch"},{local:"transformers.TFForcedBOSTokenLogitsProcessor",title:"TensorFlow"},{local:"transformers.FlaxForcedBOSTokenLogitsProcessor",title:"FLAX"}],title:"LogitsProcessor"},{local:"transformers.StoppingCriteria",title:"StoppingCriteria"},{local:"transformers.Constraint",title:"Constraints"},{local:"transformers.BeamScorer",title:"BeamSearch"},{local:"transformers.top_k_top_p_filtering",title:"Utilities"},{local:"transformers.TextStreamer",title:"Streamers"}],title:"Utilities for Generation"};function Ek(M){return uk(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qk extends hk{constructor(v){super(),fk(this,v,Ek,Vk,gk,{})}}export{Qk as component};
