import{s as at,f as Ce,n as st,o as nt}from"../chunks/scheduler.37c15a92.js";import{S as ot,i as it,g as o,s,r as h,A as rt,h as i,f as l,c as n,j as K,u as f,x as p,k as r,y as pt,a,v as w,d as y,t as b,w as g}from"../chunks/index.2bf4358c.js";import{C as N}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as ut}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as lt}from"../chunks/Heading.8ada512a.js";function ct(Ze){let d,D,z,O,M,ee,x,te,j,He="Let’s start by installing Gradio! Since it is a Python package, simply run:",le,T,We="<code>$ pip install gradio</code>",ae,J,_e=`You can run Gradio anywhere, be it from your favourite Python IDE, to Jupyter notebooks or even in Google Colab 🤯!
So install Gradio wherever you run Python!`,se,k,Ve="Let’s get started with a simple “Hello World” example to get familiar with the Gradio syntax:",ne,v,oe,G,Re="Let’s walk through the code above:",ie,I,Se="<li>First, we define a function called <code>greet()</code>. In this case, it is a simple function that adds “Hello” before your name, but it can be <em>any</em> Python function in general. For example, in machine learning applications, this function would <em>call a model to make a prediction</em> on an input and return the output.</li> <li>Then, we create a Gradio <code>Interface</code> with three arguments, <code>fn</code>, <code>inputs</code>, and <code>outputs</code>. These arguments define the prediction function, as well as the <em>type</em> of input and output components we would like. In our case, both components are simple text boxes.</li> <li>We then call the <code>launch()</code> method on the <code>Interface</code> that we created.</li>",re,B,Xe='If you run this code, the interface below will appear automatically within a Jupyter/Colab notebook, or pop in a browser on <strong><a href="http://localhost:7860/" rel="nofollow">http://localhost:7860</a></strong> if running from a script.',pe,u,Ye,ue,$,qe="Try using this GUI right now with your own name or some other input!",ce,U,Pe=`You’ll notice that in this GUI, Gradio automatically inferred the name of the input parameter (<code>name</code>)
and applied it as a label on top of the textbox. What if you’d like to change that?
Or if you’d like to customize the textbox in some other way? In that case, you can
instantiate a class object representing the input component.`,me,C,Qe="Take a look at the example below:",de,Z,he,c,Le,fe,H,Ee=`Here, we’ve created an input textbox with a label, a placeholder, and a set number of lines.
You could do the same for the output textbox, but we’ll leave that for now.`,we,W,Fe=`We’ve seen that with just a few lines of code, Gradio lets you create a simple interface around any function
with any kind of inputs or outputs. In this section, we’ve started with a
simple textbox, but in the next sections, we’ll cover other kinds of inputs and outputs. Let’s now take a look at including some NLP in a Gradio application.`,ye,_,be,V,Ne="Let’s now build a simple interface that allows you to demo a <strong>text-generation</strong> model like GPT-2.",ge,R,ze=`We’ll load our model using the <code>pipeline()</code> function from 🤗 Transformers.
If you need a quick refresher, you can go back to <a href="/course/chapter1/3#text-generation">that section in Chapter 1</a>.`,Me,S,Ae="First, we define a prediction function that takes in a text prompt and returns the text completion:",xe,X,je,Y,Ke="This function completes prompts that you provide, and you can run it with your own input prompts to see how it works. Here is an example (you might get a different completion):",Te,q,Je,P,ke,Q,De="Now that we have a function for generating predictions, we can create and launch an <code>Interface</code> in the same way we did earlier:",ve,L,Ge,E,Oe="That’s it! You can now use this interface to generate text using the GPT-2 model as shown below 🤯.",Ie,m,et,Be,F,tt="Keep reading to see how to build other kinds of demos with Gradio!",$e,A,Ue;return M=new lt({props:{title:"Building your first demo",local:"building-your-first-demo",headingTag:"h1"}}),x=new ut({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"}]}}),v=new N({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdyZWV0KG5hbWUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMjAlMjIlMjAlMkIlMjBuYW1lJTBBJTBBJTBBZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZShmbiUzRGdyZWV0JTJDJTIwaW5wdXRzJTNEJTIydGV4dCUyMiUyQyUyMG91dHB1dHMlM0QlMjJ0ZXh0JTIyKSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello &quot;</span> + name


demo = gr.Interface(fn=greet, inputs=<span class="hljs-string">&quot;text&quot;</span>, outputs=<span class="hljs-string">&quot;text&quot;</span>)

demo.launch()`,wrap:!1}}),Z=new N({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdyZWV0KG5hbWUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMjAlMjIlMjAlMkIlMjBuYW1lJTBBJTBBJTBBJTIzJTIwV2UlMjBpbnN0YW50aWF0ZSUyMHRoZSUyMFRleHRib3glMjBjbGFzcyUwQXRleHRib3glMjAlM0QlMjBnci5UZXh0Ym94KGxhYmVsJTNEJTIyVHlwZSUyMHlvdXIlMjBuYW1lJTIwaGVyZSUzQSUyMiUyQyUyMHBsYWNlaG9sZGVyJTNEJTIySm9obiUyMERvZSUyMiUyQyUyMGxpbmVzJTNEMiklMEElMEFnci5JbnRlcmZhY2UoZm4lM0RncmVldCUyQyUyMGlucHV0cyUzRHRleHRib3glMkMlMjBvdXRwdXRzJTNEJTIydGV4dCUyMikubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello &quot;</span> + name


<span class="hljs-comment"># We instantiate the Textbox class</span>
textbox = gr.Textbox(label=<span class="hljs-string">&quot;Type your name here:&quot;</span>, placeholder=<span class="hljs-string">&quot;John Doe&quot;</span>, lines=<span class="hljs-number">2</span>)

gr.Interface(fn=greet, inputs=textbox, outputs=<span class="hljs-string">&quot;text&quot;</span>).launch()`,wrap:!1}}),_=new lt({props:{title:"🤖 Including model predictions",local:"including-model-predictions",headingTag:"h2"}}),X=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWwlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBJTBBJTBBZGVmJTIwcHJlZGljdChwcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwY29tcGxldGlvbiUyMCUzRCUyMG1vZGVsKHByb21wdCklNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjb21wbGV0aW9u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">prompt</span>):
    completion = model(prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
    <span class="hljs-keyword">return</span> completion`,wrap:!1}}),q=new N({props:{code:"cHJlZGljdCglMjJNeSUyMGZhdm9yaXRlJTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMGlzJTIyKQ==",highlighted:'<span class="hljs-function"><span class="hljs-title">predict</span><span class="hljs-params">(<span class="hljs-string">&quot;My favorite programming language is&quot;</span>)</span></span>',wrap:!1}}),P=new N({props:{code:"JTNFJTNFJTIwTXklMjBmYXZvcml0ZSUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlMjBpcyUyMEhhc2tlbGwuJTIwSSUyMHJlYWxseSUyMGVuam95ZWQlMjB0aGUlMjBIYXNrZWxsJTIwbGFuZ3VhZ2UlMkMlMjBidXQlMjBpdCUyMGRvZXNuJ3QlMjBoYXZlJTIwYWxsJTIwdGhlJTIwZmVhdHVyZXMlMjB0aGF0JTIwY2FuJTIwYmUlMjBhcHBsaWVkJTIwdG8lMjBhbnklMjBvdGhlciUyMGxhbmd1YWdlLiUyMEZvciUyMGV4YW1wbGUlMkMlMjBhbGwlMjBpdCUyMGRvZXMlMjBpcyUyMGNvbXBpbGUlMjB0byUyMGElMjBieXRlJTIwYXJyYXku",highlighted:'&gt;&gt; My favorite programming language <span class="hljs-keyword">is</span> Haskell. I really enjoyed <span class="hljs-keyword">the</span> Haskell language, <span class="hljs-keyword">but</span> <span class="hljs-keyword">it</span> doesn&#x27;t have all <span class="hljs-keyword">the</span> features <span class="hljs-keyword">that</span> can be applied <span class="hljs-keyword">to</span> any other language. For example, all <span class="hljs-keyword">it</span> <span class="hljs-keyword">does</span> <span class="hljs-keyword">is</span> compile <span class="hljs-keyword">to</span> a byte array.',wrap:!1}}),L=new N({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWdyLkludGVyZmFjZShmbiUzRHByZWRpY3QlMkMlMjBpbnB1dHMlM0QlMjJ0ZXh0JTIyJTJDJTIwb3V0cHV0cyUzRCUyMnRleHQlMjIpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

gr.Interface(fn=predict, inputs=<span class="hljs-string">&quot;text&quot;</span>, outputs=<span class="hljs-string">&quot;text&quot;</span>).launch()`,wrap:!1}}),{c(){d=o("meta"),D=s(),z=o("p"),O=s(),h(M.$$.fragment),ee=s(),h(x.$$.fragment),te=s(),j=o("p"),j.textContent=He,le=s(),T=o("p"),T.innerHTML=We,ae=s(),J=o("p"),J.textContent=_e,se=s(),k=o("p"),k.textContent=Ve,ne=s(),h(v.$$.fragment),oe=s(),G=o("p"),G.textContent=Re,ie=s(),I=o("ul"),I.innerHTML=Se,re=s(),B=o("p"),B.innerHTML=Xe,pe=s(),u=o("iframe"),ue=s(),$=o("p"),$.textContent=qe,ce=s(),U=o("p"),U.innerHTML=Pe,me=s(),C=o("p"),C.textContent=Qe,de=s(),h(Z.$$.fragment),he=s(),c=o("iframe"),fe=s(),H=o("p"),H.textContent=Ee,we=s(),W=o("p"),W.textContent=Fe,ye=s(),h(_.$$.fragment),be=s(),V=o("p"),V.innerHTML=Ne,ge=s(),R=o("p"),R.innerHTML=ze,Me=s(),S=o("p"),S.textContent=Ae,xe=s(),h(X.$$.fragment),je=s(),Y=o("p"),Y.textContent=Ke,Te=s(),h(q.$$.fragment),Je=s(),h(P.$$.fragment),ke=s(),Q=o("p"),Q.innerHTML=De,ve=s(),h(L.$$.fragment),Ge=s(),E=o("p"),E.textContent=Oe,Ie=s(),m=o("iframe"),Be=s(),F=o("p"),F.textContent=tt,$e=s(),A=o("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),D=n(e),z=i(e,"P",{}),K(z).forEach(l),O=n(e),f(M.$$.fragment,e),ee=n(e),f(x.$$.fragment,e),te=n(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1majxmb"&&(j.textContent=He),le=n(e),T=i(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-sv8g3f"&&(T.innerHTML=We),ae=n(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-m0sejh"&&(J.textContent=_e),se=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-t8uf68"&&(k.textContent=Ve),ne=n(e),f(v.$$.fragment,e),oe=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-ncdl3e"&&(G.textContent=Re),ie=n(e),I=i(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-hfhpkt"&&(I.innerHTML=Se),re=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-wp0shj"&&(B.innerHTML=Xe),pe=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),K(u).forEach(l),ue=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-4s0wmk"&&($.textContent=qe),ce=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-fjgg8g"&&(U.innerHTML=Pe),me=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-wrn35m"&&(C.textContent=Qe),de=n(e),f(Z.$$.fragment,e),he=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),K(c).forEach(l),fe=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1e1b3uv"&&(H.textContent=Ee),we=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-tl90qv"&&(W.textContent=Fe),ye=n(e),f(_.$$.fragment,e),be=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-b3uqtx"&&(V.innerHTML=Ne),ge=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1kqxpib"&&(R.innerHTML=ze),Me=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-zuidxn"&&(S.textContent=Ae),xe=n(e),f(X.$$.fragment,e),je=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1cnd6y7"&&(Y.textContent=Ke),Te=n(e),f(q.$$.fragment,e),Je=n(e),f(P.$$.fragment,e),ke=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-mg1sf2"&&(Q.innerHTML=De),ve=n(e),f(L.$$.fragment,e),Ge=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ptoolc"&&(E.textContent=Oe),Ie=n(e),m=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),K(m).forEach(l),Be=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-md4bqz"&&(F.textContent=tt),$e=n(e),A=i(e,"P",{}),K(A).forEach(l),this.h()},h(){r(d,"name","hf:doc:metadata"),r(d,"content",mt),Ce(u.src,Ye="https://course-demos-hello-world.hf.space")||r(u,"src",Ye),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Ce(c.src,Le="https://course-demos-hello-world-custom.hf.space")||r(c,"src",Le),r(c,"frameborder","0"),r(c,"height","300"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Ce(m.src,et="https://course-demos-gpt-2.hf.space")||r(m,"src",et),r(m,"frameborder","0"),r(m,"height","300"),r(m,"title","Gradio app"),r(m,"class","container p-0 flex-grow space-iframe"),r(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){pt(document.head,d),a(e,D,t),a(e,z,t),a(e,O,t),w(M,e,t),a(e,ee,t),w(x,e,t),a(e,te,t),a(e,j,t),a(e,le,t),a(e,T,t),a(e,ae,t),a(e,J,t),a(e,se,t),a(e,k,t),a(e,ne,t),w(v,e,t),a(e,oe,t),a(e,G,t),a(e,ie,t),a(e,I,t),a(e,re,t),a(e,B,t),a(e,pe,t),a(e,u,t),a(e,ue,t),a(e,$,t),a(e,ce,t),a(e,U,t),a(e,me,t),a(e,C,t),a(e,de,t),w(Z,e,t),a(e,he,t),a(e,c,t),a(e,fe,t),a(e,H,t),a(e,we,t),a(e,W,t),a(e,ye,t),w(_,e,t),a(e,be,t),a(e,V,t),a(e,ge,t),a(e,R,t),a(e,Me,t),a(e,S,t),a(e,xe,t),w(X,e,t),a(e,je,t),a(e,Y,t),a(e,Te,t),w(q,e,t),a(e,Je,t),w(P,e,t),a(e,ke,t),a(e,Q,t),a(e,ve,t),w(L,e,t),a(e,Ge,t),a(e,E,t),a(e,Ie,t),a(e,m,t),a(e,Be,t),a(e,F,t),a(e,$e,t),a(e,A,t),Ue=!0},p:st,i(e){Ue||(y(M.$$.fragment,e),y(x.$$.fragment,e),y(v.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(L.$$.fragment,e),Ue=!0)},o(e){b(M.$$.fragment,e),b(x.$$.fragment,e),b(v.$$.fragment,e),b(Z.$$.fragment,e),b(_.$$.fragment,e),b(X.$$.fragment,e),b(q.$$.fragment,e),b(P.$$.fragment,e),b(L.$$.fragment,e),Ue=!1},d(e){e&&(l(D),l(z),l(O),l(ee),l(te),l(j),l(le),l(T),l(ae),l(J),l(se),l(k),l(ne),l(oe),l(G),l(ie),l(I),l(re),l(B),l(pe),l(u),l(ue),l($),l(ce),l(U),l(me),l(C),l(de),l(he),l(c),l(fe),l(H),l(we),l(W),l(ye),l(be),l(V),l(ge),l(R),l(Me),l(S),l(xe),l(je),l(Y),l(Te),l(Je),l(ke),l(Q),l(ve),l(Ge),l(E),l(Ie),l(m),l(Be),l(F),l($e),l(A)),l(d),g(M,e),g(x,e),g(v,e),g(Z,e),g(_,e),g(X,e),g(q,e),g(P,e),g(L,e)}}}const mt='{"title":"Building your first demo","local":"building-your-first-demo","sections":[{"title":"🤖 Including model predictions","local":"including-model-predictions","sections":[],"depth":2}],"depth":1}';function dt(Ze){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends ot{constructor(d){super(),it(this,d,dt,ct,at,{})}}export{gt as component};
