import{s as Pe,f as Ke,n as Oe,o as et}from"../chunks/scheduler.37c15a92.js";import{S as tt,i as at,g as o,s,r as h,A as lt,h as i,f as a,c as n,j as Be,u as d,x as r,k as p,y as st,a as l,v as m,d as y,t as M,w}from"../chunks/index.2bf4358c.js";import{Y as nt}from"../chunks/Youtube.1e50a667.js";import{C as Ge}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as ot}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as A}from"../chunks/Heading.8ada512a.js";function it(Re){let J,D,V,K,g,P,U,O,b,xe=`Now that you’ve built a demo, you’ll probably want to share it with others. Gradio demos
can be shared in two ways: using a <strong><em>temporary share link</em></strong> or <strong><em>permanent hosting on Spaces</em></strong>.`,ee,f,Se="We’ll cover both of these approaches shortly. But before you share your demo, you may want to polish it up 💅.",te,j,ae,T,We='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview.png" alt="Overview of a gradio interface"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview-dark.png" alt="Overview of a gradio interface"/>',le,k,$e="To add additional content to your demo, the <code>Interface</code> class supports some optional parameters:",se,v,Ze=`<li><code>title</code>: you can give a title to your demo, which appears <em>above</em> the input and output components.</li> <li><code>description</code>: you can give a description (in text, Markdown, or HTML) for the interface, which appears above the input and output components and below the title.</li> <li><code>article</code>: you can also write an expanded article (in text, Markdown, or HTML) explaining the interface. If provided, it appears <em>below</em> the input and output components.</li> <li><code>theme</code>: don’t like the default colors? Set the theme to use one of <code>default</code>, <code>huggingface</code>, <code>grass</code>, <code>peach</code>. You can also add the <code>dark-</code> prefix, e.g. <code>dark-peach</code> for dark theme (or just <code>dark</code> for the default dark theme).</li> <li><code>examples</code>: to make your demo <em>way easier to use</em>, you can provide some example inputs for the function. These appear below the UI components and can be used to populate the interface. These should be provided as a nested list, in which the outer list consists of samples and each inner list consists of an input corresponding to each input component.</li> <li><code>live</code>: if you want to make your demo “live”, meaning that your model reruns every time the input changes, you can set <code>live=True</code>. This makes sense to use with quick models (we’ll see an example at the end of this section)
Using the options above, we end up with a more complete interface. Run the code below so you can chat with Rick and Morty:</li>`,ne,C,oe,I,Qe="Using the options above, we end up with a more complete interface. Try the interface below:",ie,c,He,re,B,pe,G,Ye=`Now that we have a working demo of our machine learning model, let’s learn how to easily share a link to our interface.
Interfaces can be easily shared publicly by setting <code>share=True</code> in the <code>launch()</code> method:`,ce,R,ue,x,Fe="This generates a public, shareable link that you can send to anybody! When you send this link, the user on the other side can try out the model in their browser for up to 72 hours. Because the processing happens on your device (as long as your device stays on!), you don’t have to worry about packaging any dependencies. If you’re working out of a Google Colab notebook, a share link is always automatically created. It usually looks something like this: <strong>XXXXX.gradio.app</strong>. Although the link is served through a Gradio link, we are only a proxy for your local server, and do not store any data sent through the interfaces.",he,S,Le="Keep in mind, however, that these links are publicly accessible, meaning that anyone can use your model for prediction! Therefore, make sure not to expose any sensitive information through the functions you write, or allow any critical changes to occur on your device. If you set <code>share=False</code> (the default), only a local link is created.",de,W,me,$,Ne="A share link that you can pass around to collegues is cool, but how can you permanently host your demo and have it exist in its own “space” on the internet?",ye,Z,_e=`Hugging Face Spaces provides the infrastructure to permanently host your Gradio model on the internet, <strong>for free</strong>! Spaces allows you to create and push to a (public or private) repo,
where your Gradio
interface code will exist in an <code>app.py</code> file. <a href="https://huggingface.co/blog/gradio-spaces" rel="nofollow">Read a step-by-step tutorial</a> to get started, or watch an example video below.`,Me,Q,we,H,Je,Y,ze='Using what we just learned in the sections so far, let’s create the sketch recognition demo we saw in <a href="/course/chapter9/1">section one of this chapter</a>. Let’s add some customization to our interface and set <code>share=True</code> to create a public link we can pass around.',Te,F,qe='We can load the labels from <a href="https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/class_names.txt" rel="nofollow">class_names.txt</a> and load the pre-trained pytorch model from <a href="https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/pytorch_model.bin" rel="nofollow">pytorch_model.bin</a>. Download these files by following the link and clicking download on the top left corner of the file preview. Let’s take a look at the code below to see how we use these files to load our model and create a <code>predict()</code> function:',ge,L,Ue,N,Ee="Now that we have a <code>predict()</code> function. The next step is to define and launch our gradio interface:",be,_,fe,u,Ve,je,z,Xe=`Notice the <code>live=True</code> parameter in <code>Interface</code>, which means that the sketch demo makes
a prediction every time someone draws on the sketchpad (no submit button!).`,ke,q,Ae=`Furthermore, we also set the <code>share=True</code> argument in the <code>launch()</code> method.
This will create a public link that you can
send to anyone! When you send this link, the user on the other side can try out the
sketch recognition model. To reiterate, you could also host the model on Hugging Face Spaces,
which is how we are able to embed the demo above.`,ve,E,De="Next up, we’ll cover other ways that Gradio can be used with the Hugging Face ecosystem!",Ce,X,Ie;return g=new A({props:{title:"Sharing demos with others",local:"sharing-demos-with-others",headingTag:"h1"}}),U=new ot({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section4.ipynb"}]}}),j=new A({props:{title:"Polishing your Gradio demo:",local:"polishing-your-gradio-demo",headingTag:"h3"}}),C=new Ge({props:{code:"dGl0bGUlMjAlM0QlMjAlMjJBc2slMjBSaWNrJTIwYSUyMFF1ZXN0aW9uJTIyJTBBZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEFUaGUlMjBib3QlMjB3YXMlMjB0cmFpbmVkJTIwdG8lMjBhbnN3ZXIlMjBxdWVzdGlvbnMlMjBiYXNlZCUyMG9uJTIwUmljayUyMGFuZCUyME1vcnR5JTIwZGlhbG9ndWVzLiUyMEFzayUyMFJpY2slMjBhbnl0aGluZyElMEElM0NpbWclMjBzcmMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGY291cnNlLWRlbW9zJTJGUmlja19hbmRfTW9ydHlfUUElMkZyZXNvbHZlJTJGbWFpbiUyRnJpY2sucG5nJTIyJTIwd2lkdGglM0QyMDBweCUzRSUwQSUyMiUyMiUyMiUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjJDaGVjayUyMG91dCUyMCU1QnRoZSUyMG9yaWdpbmFsJTIwUmljayUyMGFuZCUyME1vcnR5JTIwQm90JTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZraW5nYWJ6cHJvJTJGUmlja19hbmRfTW9ydHlfQm90KSUyMHRoYXQlMjB0aGlzJTIwZGVtbyUyMGlzJTIwYmFzZWQlMjBvZmYlMjBvZi4lMjIlMEElMEFnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RwcmVkaWN0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTIydGV4dGJveCUyMiUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0R0aXRsZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEZGVzY3JpcHRpb24lMkMlMEElMjAlMjAlMjAlMjBhcnRpY2xlJTNEYXJ0aWNsZSUyQyUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTVCJTIyV2hhdCUyMGFyZSUyMHlvdSUyMGRvaW5nJTNGJTIyJTVEJTJDJTIwJTVCJTIyV2hlcmUlMjBzaG91bGQlMjB3ZSUyMHRpbWUlMjB0cmF2ZWwlMjB0byUzRiUyMiU1RCU1RCUyQyUwQSkubGF1bmNoKCk=",highlighted:`title = <span class="hljs-string">&quot;Ask Rick a Question&quot;</span>
description = <span class="hljs-string">&quot;&quot;&quot;
The bot was trained to answer questions based on Rick and Morty dialogues. Ask Rick anything!
&lt;img src=&quot;https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png&quot; width=200px&gt;
&quot;&quot;&quot;</span>

article = <span class="hljs-string">&quot;Check out [the original Rick and Morty Bot](https://huggingface.co/spaces/kingabzpro/Rick_and_Morty_Bot) that this demo is based off of.&quot;</span>

gr.Interface(
    fn=predict,
    inputs=<span class="hljs-string">&quot;textbox&quot;</span>,
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
    title=title,
    description=description,
    article=article,
    examples=[[<span class="hljs-string">&quot;What are you doing?&quot;</span>], [<span class="hljs-string">&quot;Where should we time travel to?&quot;</span>]],
).launch()`,wrap:!1}}),B=new A({props:{title:"Sharing your demo with temporary links",local:"sharing-your-demo-with-temporary-links",headingTag:"h3"}}),R=new Ge({props:{code:"Z3IuSW50ZXJmYWNlKGNsYXNzaWZ5X2ltYWdlJTJDJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJsYWJlbCUyMikubGF1bmNoKHNoYXJlJTNEVHJ1ZSk=",highlighted:'gr.Interface(classify_image, <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>).launch(share=<span class="hljs-literal">True</span>)',wrap:!1}}),W=new A({props:{title:"Hosting your demo on Hugging Face Spaces",local:"hosting-your-demo-on-hugging-face-spaces",headingTag:"h3"}}),Q=new nt({props:{id:"LS9Y2wDVI0k"}}),H=new A({props:{title:"✏️ Let’s apply it!",local:"lets-apply-it",headingTag:"h2"}}),L=new Ge({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEFMQUJFTFMlMjAlM0QlMjBQYXRoKCUyMmNsYXNzX25hbWVzLnR4dCUyMikucmVhZF90ZXh0KCkuc3BsaXRsaW5lcygpJTBBJTBBbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMG5uLkNvbnYyZCgxJTJDJTIwMzIlMkMlMjAzJTJDJTIwcGFkZGluZyUzRCUyMnNhbWUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwbm4uTWF4UG9vbDJkKDIpJTJDJTBBJTIwJTIwJTIwJTIwbm4uQ29udjJkKDMyJTJDJTIwNjQlMkMlMjAzJTJDJTIwcGFkZGluZyUzRCUyMnNhbWUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwbm4uTWF4UG9vbDJkKDIpJTJDJTBBJTIwJTIwJTIwJTIwbm4uQ29udjJkKDY0JTJDJTIwMTI4JTJDJTIwMyUyQyUyMHBhZGRpbmclM0QlMjJzYW1lJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMG5uLk1heFBvb2wyZCgyKSUyQyUwQSUyMCUyMCUyMCUyMG5uLkZsYXR0ZW4oKSUyQyUwQSUyMCUyMCUyMCUyMG5uLkxpbmVhcigxMTUyJTJDJTIwMjU2KSUyQyUwQSUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMG5uLkxpbmVhcigyNTYlMkMlMjBsZW4oTEFCRUxTKSklMkMlMEEpJTBBc3RhdGVfZGljdCUyMCUzRCUyMHRvcmNoLmxvYWQoJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBtYXBfbG9jYXRpb24lM0QlMjJjcHUlMjIpJTBBbW9kZWwubG9hZF9zdGF0ZV9kaWN0KHN0YXRlX2RpY3QlMkMlMjBzdHJpY3QlM0RGYWxzZSklMEFtb2RlbC5ldmFsKCklMEElMEElMEFkZWYlMjBwcmVkaWN0KGltKSUzQSUwQSUyMCUyMCUyMCUyMHglMjAlM0QlMjB0b3JjaC50ZW5zb3IoaW0lMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MzIpLnVuc3F1ZWV6ZSgwKS51bnNxdWVlemUoMCklMjAlMkYlMjAyNTUuMCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXQlMjAlM0QlMjBtb2RlbCh4KSUwQSUyMCUyMCUyMCUyMHByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBJTIwJTIwJTIwJTIwdmFsdWVzJTJDJTIwaW5kaWNlcyUyMCUzRCUyMHRvcmNoLnRvcGsocHJvYmFiaWxpdGllcyUyQyUyMDUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCTEFCRUxTJTVCaSU1RCUzQSUyMHYuaXRlbSgpJTIwZm9yJTIwaSUyQyUyMHYlMjBpbiUyMHppcChpbmRpY2VzJTJDJTIwdmFsdWVzKSU3RA==",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

LABELS = Path(<span class="hljs-string">&quot;class_names.txt&quot;</span>).read_text().splitlines()

model = nn.Sequential(
    nn.Conv2d(<span class="hljs-number">1</span>, <span class="hljs-number">32</span>, <span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;same&quot;</span>),
    nn.ReLU(),
    nn.MaxPool2d(<span class="hljs-number">2</span>),
    nn.Conv2d(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;same&quot;</span>),
    nn.ReLU(),
    nn.MaxPool2d(<span class="hljs-number">2</span>),
    nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;same&quot;</span>),
    nn.ReLU(),
    nn.MaxPool2d(<span class="hljs-number">2</span>),
    nn.Flatten(),
    nn.Linear(<span class="hljs-number">1152</span>, <span class="hljs-number">256</span>),
    nn.ReLU(),
    nn.Linear(<span class="hljs-number">256</span>, <span class="hljs-built_in">len</span>(LABELS)),
)
state_dict = torch.load(<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
model.load_state_dict(state_dict, strict=<span class="hljs-literal">False</span>)
model.<span class="hljs-built_in">eval</span>()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">im</span>):
    x = torch.tensor(im, dtype=torch.float32).unsqueeze(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>) / <span class="hljs-number">255.0</span>
    <span class="hljs-keyword">with</span> torch.no_grad():
        out = model(x)
    probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
    values, indices = torch.topk(probabilities, <span class="hljs-number">5</span>)
    <span class="hljs-keyword">return</span> {LABELS[i]: v.item() <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(indices, values)}`,wrap:!1}}),_=new Ge({props:{code:"aW50ZXJmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3QlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlMjJza2V0Y2hwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIybGFiZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJTa2V0Y2glMjBSZWNvZ25pdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyV2hvJTIwd2FudHMlMjB0byUyMHBsYXklMjBQaWN0aW9uYXJ5JTNGJTIwRHJhdyUyMGElMjBjb21tb24lMjBvYmplY3QlMjBsaWtlJTIwYSUyMHNob3ZlbCUyMG9yJTIwYSUyMGxhcHRvcCUyQyUyMGFuZCUyMHRoZSUyMGFsZ29yaXRobSUyMHdpbGwlMjBndWVzcyUyMGluJTIwcmVhbCUyMHRpbWUhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJ0aWNsZSUzRCUyMiUzQ3AlMjBzdHlsZSUzRCd0ZXh0LWFsaWduJTNBJTIwY2VudGVyJyUzRVNrZXRjaCUyMFJlY29nbml0aW9uJTIwJTdDJTIwRGVtbyUyME1vZGVsJTNDJTJGcCUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpdmUlM0RUcnVlJTJDJTBBKSUwQWludGVyZmFjZS5sYXVuY2goc2hhcmUlM0RUcnVlKQ==",highlighted:`interface = gr.Interface(
    predict,
    inputs=<span class="hljs-string">&quot;sketchpad&quot;</span>,
    outputs=<span class="hljs-string">&quot;label&quot;</span>,
    theme=<span class="hljs-string">&quot;huggingface&quot;</span>,
    title=<span class="hljs-string">&quot;Sketch Recognition&quot;</span>,
    description=<span class="hljs-string">&quot;Who wants to play Pictionary? Draw a common object like a shovel or a laptop, and the algorithm will guess in real time!&quot;</span>,
    article=<span class="hljs-string">&quot;&lt;p style=&#x27;text-align: center&#x27;&gt;Sketch Recognition | Demo Model&lt;/p&gt;&quot;</span>,
    live=<span class="hljs-literal">True</span>,
)
interface.launch(share=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){J=o("meta"),D=s(),V=o("p"),K=s(),h(g.$$.fragment),P=s(),h(U.$$.fragment),O=s(),b=o("p"),b.innerHTML=xe,ee=s(),f=o("p"),f.textContent=Se,te=s(),h(j.$$.fragment),ae=s(),T=o("div"),T.innerHTML=We,le=s(),k=o("p"),k.innerHTML=$e,se=s(),v=o("ul"),v.innerHTML=Ze,ne=s(),h(C.$$.fragment),oe=s(),I=o("p"),I.textContent=Qe,ie=s(),c=o("iframe"),re=s(),h(B.$$.fragment),pe=s(),G=o("p"),G.innerHTML=Ye,ce=s(),h(R.$$.fragment),ue=s(),x=o("p"),x.innerHTML=Fe,he=s(),S=o("p"),S.innerHTML=Le,de=s(),h(W.$$.fragment),me=s(),$=o("p"),$.textContent=Ne,ye=s(),Z=o("p"),Z.innerHTML=_e,Me=s(),h(Q.$$.fragment),we=s(),h(H.$$.fragment),Je=s(),Y=o("p"),Y.innerHTML=ze,Te=s(),F=o("p"),F.innerHTML=qe,ge=s(),h(L.$$.fragment),Ue=s(),N=o("p"),N.innerHTML=Ee,be=s(),h(_.$$.fragment),fe=s(),u=o("iframe"),je=s(),z=o("p"),z.innerHTML=Xe,ke=s(),q=o("p"),q.innerHTML=Ae,ve=s(),E=o("p"),E.textContent=De,Ce=s(),X=o("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(a),D=n(e),V=i(e,"P",{}),Be(V).forEach(a),K=n(e),d(g.$$.fragment,e),P=n(e),d(U.$$.fragment,e),O=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1mkrhn0"&&(b.innerHTML=xe),ee=n(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1pmonxq"&&(f.textContent=Se),te=n(e),d(j.$$.fragment,e),ae=n(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-nclpfp"&&(T.innerHTML=We),le=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-2lc6cg"&&(k.innerHTML=$e),se=n(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1aig1l1"&&(v.innerHTML=Ze),ne=n(e),d(C.$$.fragment,e),oe=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ssl3s6"&&(I.textContent=Qe),ie=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Be(c).forEach(a),re=n(e),d(B.$$.fragment,e),pe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1c70l7r"&&(G.innerHTML=Ye),ce=n(e),d(R.$$.fragment,e),ue=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-13vn5xh"&&(x.innerHTML=Fe),he=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-106y49j"&&(S.innerHTML=Le),de=n(e),d(W.$$.fragment,e),me=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-15lxq3n"&&($.textContent=Ne),ye=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1rf27a0"&&(Z.innerHTML=_e),Me=n(e),d(Q.$$.fragment,e),we=n(e),d(H.$$.fragment,e),Je=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1qf1ftl"&&(Y.innerHTML=ze),Te=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-x4hpqm"&&(F.innerHTML=qe),ge=n(e),d(L.$$.fragment,e),Ue=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1fgvly0"&&(N.innerHTML=Ee),be=n(e),d(_.$$.fragment,e),fe=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Be(u).forEach(a),je=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-9yu4kr"&&(z.innerHTML=Xe),ke=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-otwltg"&&(q.innerHTML=Ae),ve=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1n58irn"&&(E.textContent=De),Ce=n(e),X=i(e,"P",{}),Be(X).forEach(a),this.h()},h(){p(J,"name","hf:doc:metadata"),p(J,"content",rt),p(T,"class","flex justify-center"),Ke(c.src,He="https://course-demos-Rick-and-Morty-QA.hf.space")||p(c,"src",He),p(c,"frameborder","0"),p(c,"height","800"),p(c,"title","Gradio app"),p(c,"class","container p-0 flex-grow space-iframe"),p(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Ke(u.src,Ve="https://course-demos-Sketch-Recognition.hf.space")||p(u,"src",Ve),p(u,"frameborder","0"),p(u,"height","650"),p(u,"title","Gradio app"),p(u,"class","container p-0 flex-grow space-iframe"),p(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){st(document.head,J),l(e,D,t),l(e,V,t),l(e,K,t),m(g,e,t),l(e,P,t),m(U,e,t),l(e,O,t),l(e,b,t),l(e,ee,t),l(e,f,t),l(e,te,t),m(j,e,t),l(e,ae,t),l(e,T,t),l(e,le,t),l(e,k,t),l(e,se,t),l(e,v,t),l(e,ne,t),m(C,e,t),l(e,oe,t),l(e,I,t),l(e,ie,t),l(e,c,t),l(e,re,t),m(B,e,t),l(e,pe,t),l(e,G,t),l(e,ce,t),m(R,e,t),l(e,ue,t),l(e,x,t),l(e,he,t),l(e,S,t),l(e,de,t),m(W,e,t),l(e,me,t),l(e,$,t),l(e,ye,t),l(e,Z,t),l(e,Me,t),m(Q,e,t),l(e,we,t),m(H,e,t),l(e,Je,t),l(e,Y,t),l(e,Te,t),l(e,F,t),l(e,ge,t),m(L,e,t),l(e,Ue,t),l(e,N,t),l(e,be,t),m(_,e,t),l(e,fe,t),l(e,u,t),l(e,je,t),l(e,z,t),l(e,ke,t),l(e,q,t),l(e,ve,t),l(e,E,t),l(e,Ce,t),l(e,X,t),Ie=!0},p:Oe,i(e){Ie||(y(g.$$.fragment,e),y(U.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(R.$$.fragment,e),y(W.$$.fragment,e),y(Q.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(_.$$.fragment,e),Ie=!0)},o(e){M(g.$$.fragment,e),M(U.$$.fragment,e),M(j.$$.fragment,e),M(C.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(W.$$.fragment,e),M(Q.$$.fragment,e),M(H.$$.fragment,e),M(L.$$.fragment,e),M(_.$$.fragment,e),Ie=!1},d(e){e&&(a(D),a(V),a(K),a(P),a(O),a(b),a(ee),a(f),a(te),a(ae),a(T),a(le),a(k),a(se),a(v),a(ne),a(oe),a(I),a(ie),a(c),a(re),a(pe),a(G),a(ce),a(ue),a(x),a(he),a(S),a(de),a(me),a($),a(ye),a(Z),a(Me),a(we),a(Je),a(Y),a(Te),a(F),a(ge),a(Ue),a(N),a(be),a(fe),a(u),a(je),a(z),a(ke),a(q),a(ve),a(E),a(Ce),a(X)),a(J),w(g,e),w(U,e),w(j,e),w(C,e),w(B,e),w(R,e),w(W,e),w(Q,e),w(H,e),w(L,e),w(_,e)}}}const rt='{"title":"Sharing demos with others","local":"sharing-demos-with-others","sections":[{"title":"Polishing your Gradio demo:","local":"polishing-your-gradio-demo","sections":[],"depth":3},{"title":"Sharing your demo with temporary links","local":"sharing-your-demo-with-temporary-links","sections":[],"depth":3},{"title":"Hosting your demo on Hugging Face Spaces","local":"hosting-your-demo-on-hugging-face-spaces","sections":[],"depth":3},{"title":"✏️ Let’s apply it!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function pt(Re){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends tt{constructor(J){super(),at(this,J,pt,it,Pe,{})}}export{Mt as component};
