import{s as je,f as Je,n as Ue,o as Te}from"../chunks/scheduler.37c15a92.js";import{S as ge,i as Ie,g as i,s as l,r as Z,A as Ce,h as r,f as s,c as n,j as le,u as B,x as u,k as o,y as ke,a,v,d as x,t as A,w as W}from"../chunks/index.2bf4358c.js";import{C as be}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ge}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as ne}from"../chunks/Heading.8ada512a.js";function Ze(oe){let m,$,S,q,h,E,M,N,d,ie="Now that we can build and share a basic interface, let’s explore some more advanced features such as state, and interpretation.",R,y,_,w,re=`Gradio supports <em>session state</em>, where data persists across multiple submits within a
page load. Session state is useful for building demos of, for example, chatbots where you want to
persist data as the user interacts with the model. Note that session state does not share data between different users of your model.`,Y,f,pe="To store data in a session state, you need to do three things:",z,J,ce="<li>Pass in an <em>extra parameter</em> into your function, which represents the state of the interface.</li> <li>At the end of the function, return the updated value of the state as an <em>extra return value</em>.</li> <li>Add the ‘state’ input and ‘state’ output components when creating your <code>Interface</code>.</li>",X,b,ue="See the chatbot example below:",V,j,F,p,me,H,U,he=`Notice how the state of the output component persists across submits.
Note: you can pass in a default value to the state parameter,
which is used as the initial value of the state.`,L,T,D,g,Me="Most machine learning models are black boxes and the internal logic of the function is hidden from the end user. To encourage transparency, we’ve made it very easy to add interpretation to your model by simply setting the interpretation keyword in the Interface class to default. This allows your users to understand what parts of the input are responsible for the output. Take a look at the simple interface below which shows an image classifier that also includes interpretation:",K,I,P,C,de="Test the interpretation function by submitting an input then clicking Interpret under the output component.",O,c,ye,ee,k,we=`Besides the default interpretation method Gradio provides, you can also specify <code>shap</code> for the <code>interpretation</code> parameter and set the <code>num_shap</code> parameter. This uses Shapley-based interpretation, which you can read more about <a href="https://christophm.github.io/interpretable-ml-book/shap.html" rel="nofollow">here</a>.
Lastly, you can also pass in your own interpretation function into the <code>interpretation</code> parameter. See an example in Gradio’s getting started page <a href="https://gradio.app/getting_started/" rel="nofollow">here</a>.`,te,G,fe="This wraps up our deep dive into the <code>Interface</code> class of Gradio. As we’ve seen, this class makes it simple to create machine learning demos in a few lines of Python code. However, sometimes you’ll want to customise your demo by changing the layout or chaining multiple prediction functions together. Wouldn’t it be nice if we could somehow split the <code>Interface</code> into customizable “blocks”? Fortunately, there is! That’s the topic of the final section.",se,Q,ae;return h=new ne({props:{title:"Advanced Interface features",local:"advanced-interface-features",headingTag:"h1"}}),M=new Ge({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"}]}}),y=new ne({props:{title:"Using state to persist data",local:"using-state-to-persist-data",headingTag:"h3"}}),j=new be({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYXQobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeSUyMCUzRCUyMGhpc3RvcnklMjBvciUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZS5zdGFydHN3aXRoKCUyMkhvdyUyMG1hbnklMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20ucmFuZGludCgxJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJIb3clMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20uY2hvaWNlKCU1QiUyMkdyZWF0JTIyJTJDJTIwJTIyR29vZCUyMiUyQyUyMCUyMk9rYXklMjIlMkMlMjAlMjJCYWQlMjIlNUQpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJXaGVyZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJhbmRvbS5jaG9pY2UoJTVCJTIySGVyZSUyMiUyQyUyMCUyMlRoZXJlJTIyJTJDJTIwJTIyU29tZXdoZXJlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMCUyMkklMjBkb24ndCUyMGtub3clMjIlMEElMjAlMjAlMjAlMjBoaXN0b3J5LmFwcGVuZCgobWVzc2FnZSUyQyUyMHJlc3BvbnNlKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaXN0b3J5JTJDJTIwaGlzdG9yeSUwQSUwQSUwQWlmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGNoYXQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJ0ZXh0JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJjaGF0Ym90JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19zY3JlZW5zaG90JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19mbGFnZ2luZyUzRCUyMm5ldmVyJTIyJTJDJTBBKSUwQWlmYWNlLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history</span>):
    history = history <span class="hljs-keyword">or</span> []
    <span class="hljs-keyword">if</span> message.startswith(<span class="hljs-string">&quot;How many&quot;</span>):
        response = random.randint(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>)
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;How&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Great&quot;</span>, <span class="hljs-string">&quot;Good&quot;</span>, <span class="hljs-string">&quot;Okay&quot;</span>, <span class="hljs-string">&quot;Bad&quot;</span>])
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;Where&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Here&quot;</span>, <span class="hljs-string">&quot;There&quot;</span>, <span class="hljs-string">&quot;Somewhere&quot;</span>])
    <span class="hljs-keyword">else</span>:
        response = <span class="hljs-string">&quot;I don&#x27;t know&quot;</span>
    history.append((message, response))
    <span class="hljs-keyword">return</span> history, history


iface = gr.Interface(
    chat,
    [<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    [<span class="hljs-string">&quot;chatbot&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    allow_screenshot=<span class="hljs-literal">False</span>,
    allow_flagging=<span class="hljs-string">&quot;never&quot;</span>,
)
iface.launch()`,wrap:!1}}),T=new ne({props:{title:"Using interpretation to understand predictions",local:"using-interpretation-to-understand-predictions",headingTag:"h3"}}),I=new be({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGh1bWFuLXJlYWRhYmxlJTIwbGFiZWxzJTIwZm9yJTIwSW1hZ2VOZXQuJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZnaXQuaW8lMkZKSmtZTiUyMiklMEFsYWJlbHMlMjAlM0QlMjByZXNwb25zZS50ZXh0LnNwbGl0KCUyMiU1Q24lMjIpJTBBJTBBJTBBZGVmJTIwY2xhc3NpZnlfaW1hZ2UoaW5wKSUzQSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMGlucC5yZXNoYXBlKCgtMSUyQyUyMDIyNCUyQyUyMDIyNCUyQyUyMDMpKSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMHRmLmtlcmFzLmFwcGxpY2F0aW9ucy5tb2JpbGVuZXRfdjIucHJlcHJvY2Vzc19pbnB1dChpbnApJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbiUyMCUzRCUyMGluY2VwdGlvbl9uZXQucHJlZGljdChpbnApLmZsYXR0ZW4oKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmxhYmVscyU1QmklNUQlM0ElMjBmbG9hdChwcmVkaWN0aW9uJTVCaSU1RCklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDAwKSU3RCUwQSUwQSUwQWltYWdlJTIwJTNEJTIwZ3IuSW1hZ2Uoc2hhcGUlM0QoMjI0JTJDJTIwMjI0KSklMEFsYWJlbCUyMCUzRCUyMGdyLkxhYmVsKG51bV90b3BfY2xhc3NlcyUzRDMpJTBBJTBBdGl0bGUlMjAlM0QlMjAlMjJHcmFkaW8lMjBJbWFnZSUyMENsYXNzaWZpY3Rpb24lMjAlMkIlMjBJbnRlcnByZXRhdGlvbiUyMEV4YW1wbGUlMjIlMEFnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9pbWFnZSUyQyUyMGlucHV0cyUzRGltYWdlJTJDJTIwb3V0cHV0cyUzRGxhYmVsJTJDJTIwaW50ZXJwcmV0YXRpb24lM0QlMjJkZWZhdWx0JTIyJTJDJTIwdGl0bGUlM0R0aXRsZSUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># load the model</span>

<span class="hljs-comment"># Download human-readable labels for ImageNet.</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch()`,wrap:!1}}),{c(){m=i("meta"),$=l(),S=i("p"),q=l(),Z(h.$$.fragment),E=l(),Z(M.$$.fragment),N=l(),d=i("p"),d.textContent=ie,R=l(),Z(y.$$.fragment),_=l(),w=i("p"),w.innerHTML=re,Y=l(),f=i("p"),f.textContent=pe,z=l(),J=i("ol"),J.innerHTML=ce,X=l(),b=i("p"),b.textContent=ue,V=l(),Z(j.$$.fragment),F=l(),p=i("iframe"),H=l(),U=i("p"),U.textContent=he,L=l(),Z(T.$$.fragment),D=l(),g=i("p"),g.textContent=Me,K=l(),Z(I.$$.fragment),P=l(),C=i("p"),C.textContent=de,O=l(),c=i("iframe"),ee=l(),k=i("p"),k.innerHTML=we,te=l(),G=i("p"),G.innerHTML=fe,se=l(),Q=i("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);m=r(t,"META",{name:!0,content:!0}),t.forEach(s),$=n(e),S=r(e,"P",{}),le(S).forEach(s),q=n(e),B(h.$$.fragment,e),E=n(e),B(M.$$.fragment,e),N=n(e),d=r(e,"P",{"data-svelte-h":!0}),u(d)!=="svelte-ot4lbi"&&(d.textContent=ie),R=n(e),B(y.$$.fragment,e),_=n(e),w=r(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-npz0qc"&&(w.innerHTML=re),Y=n(e),f=r(e,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1g0d8ct"&&(f.textContent=pe),z=n(e),J=r(e,"OL",{"data-svelte-h":!0}),u(J)!=="svelte-hwpt2s"&&(J.innerHTML=ce),X=n(e),b=r(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1qrri7m"&&(b.textContent=ue),V=n(e),B(j.$$.fragment,e),F=n(e),p=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),le(p).forEach(s),H=n(e),U=r(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1a0cfxw"&&(U.textContent=he),L=n(e),B(T.$$.fragment,e),D=n(e),g=r(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-vt0h2q"&&(g.textContent=Me),K=n(e),B(I.$$.fragment,e),P=n(e),C=r(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1nf2s8k"&&(C.textContent=de),O=n(e),c=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),le(c).forEach(s),ee=n(e),k=r(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1qf8hkk"&&(k.innerHTML=we),te=n(e),G=r(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1bt3ks"&&(G.innerHTML=fe),se=n(e),Q=r(e,"P",{}),le(Q).forEach(s),this.h()},h(){o(m,"name","hf:doc:metadata"),o(m,"content",Be),Je(p.src,me="https://course-demos-Chatbot-Demo.hf.space")||o(p,"src",me),o(p,"frameborder","0"),o(p,"height","350"),o(p,"title","Gradio app"),o(p,"class","container p-0 flex-grow space-iframe"),o(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Je(c.src,ye="https://course-demos-gradio-image-interpretation.hf.space")||o(c,"src",ye),o(c,"frameborder","0"),o(c,"height","570"),o(c,"title","Gradio app"),o(c,"class","container p-0 flex-grow space-iframe"),o(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ke(document.head,m),a(e,$,t),a(e,S,t),a(e,q,t),v(h,e,t),a(e,E,t),v(M,e,t),a(e,N,t),a(e,d,t),a(e,R,t),v(y,e,t),a(e,_,t),a(e,w,t),a(e,Y,t),a(e,f,t),a(e,z,t),a(e,J,t),a(e,X,t),a(e,b,t),a(e,V,t),v(j,e,t),a(e,F,t),a(e,p,t),a(e,H,t),a(e,U,t),a(e,L,t),v(T,e,t),a(e,D,t),a(e,g,t),a(e,K,t),v(I,e,t),a(e,P,t),a(e,C,t),a(e,O,t),a(e,c,t),a(e,ee,t),a(e,k,t),a(e,te,t),a(e,G,t),a(e,se,t),a(e,Q,t),ae=!0},p:Ue,i(e){ae||(x(h.$$.fragment,e),x(M.$$.fragment,e),x(y.$$.fragment,e),x(j.$$.fragment,e),x(T.$$.fragment,e),x(I.$$.fragment,e),ae=!0)},o(e){A(h.$$.fragment,e),A(M.$$.fragment,e),A(y.$$.fragment,e),A(j.$$.fragment,e),A(T.$$.fragment,e),A(I.$$.fragment,e),ae=!1},d(e){e&&(s($),s(S),s(q),s(E),s(N),s(d),s(R),s(_),s(w),s(Y),s(f),s(z),s(J),s(X),s(b),s(V),s(F),s(p),s(H),s(U),s(L),s(D),s(g),s(K),s(P),s(C),s(O),s(c),s(ee),s(k),s(te),s(G),s(se),s(Q)),s(m),W(h,e),W(M,e),W(y,e),W(j,e),W(T,e),W(I,e)}}}const Be='{"title":"Advanced Interface features","local":"advanced-interface-features","sections":[{"title":"Using state to persist data","local":"using-state-to-persist-data","sections":[],"depth":3},{"title":"Using interpretation to understand predictions","local":"using-interpretation-to-understand-predictions","sections":[],"depth":3}],"depth":1}';function ve(oe){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $e extends ge{constructor(m){super(),Ie(this,m,ve,Ze,je,{})}}export{$e as component};
