import{s as $n,o as zn,n as Vn}from"../chunks/scheduler.37c15a92.js";import{S as _n,i as qn,g as i,s as l,r as u,A as Bn,h as r,f as n,c as a,j as kn,u as o,x as p,k as In,y as An,a as t,v as c,d as m,t as M,w as J}from"../chunks/index.2bf4358c.js";import{T as Zn}from"../chunks/Tip.363c041f.js";import{Y as Xn}from"../chunks/Youtube.1e50a667.js";import{C as d}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Nn}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Ys}from"../chunks/Heading.8ada512a.js";function En(Ve){let y,h="⚠️ Entraîner un <em>tokenizer</em> n’est pas la même chose qu’entraîner un modèle ! L’entraînement du modèle utilise la descente de gradient stochastique pour réduire un peu plus la perte à chaque batch. Il est par nature aléatoire (ce qui signifie que vous devez définir des graines pour obtenir les mêmes résultats lorsque vous effectuez deux fois le même entraînement). Entraîner un <em>tokenizer</em> est un processus statistique qui identifie les meilleurs sous-mots à choisir pour un corpus donné. Les règles exactes utilisées pour les choisir dépendent de l’algorithme de tokénisation. Le processus est déterministe, ce qui signifie que vous obtenez toujours les mêmes résultats lorsque vous vous entraînez avec le même algorithme sur le même corpus.";return{c(){y=i("p"),y.innerHTML=h},l(j){y=r(j,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1nhpa41"&&(y.innerHTML=h)},m(j,$e){t(j,y,$e)},p:Vn,d(j){j&&n(y)}}}function Gn(Ve){let y,h,j,$e,x,_e,f,qe,U,Ss='Si un modèle de langue n’est pas disponible dans la langue qui vous intéresse ou si votre corpus est très différent de celui sur lequel votre modèle de langue a été entraîné, vous voudrez très probablement réentraîner le modèle à partir de zéro en utilisant un <em>tokenizer</em> adapté à vos données. Pour ce faire, vous devrez entraîner un nouveau <em>tokenizer</em> sur votre jeu de données. Mais qu’est-ce que cela signifie exactement ? Lorsque nous avons examiné pour la première fois les <em>tokenizers</em> dans le <a href="/course/fr/chapter2">chapitre 2</a>, nous avons vu que la plupart des <em>transformers</em> utilisent un <em>algorithme de tokenisation en sous-mots</em>. Pour identifier les sous-mots qui sont intéressants et qui apparaissent le plus fréquemment dans un corpus donné, le <em>tokenizer</em> doit examiner attentivement tous les textes du corpus. C’est un processus que nous appelons <em>entraînement</em>. Les règles exactes qui régissent cet apprentissage dépendent du type de <em>tokenizer</em> utilisé. Nous passerons en revue les trois principaux algorithmes plus loin dans ce chapitre.',Be,g,Ae,T,Ze,w,Xe,b,Ls="Il y a une API très simple dans 🤗 <em>Transformers</em> que vous pouvez utiliser pour entraîner un nouveau <em>tokenizer</em> avec les mêmes caractéristiques qu’un déjà existant : <code>AutoTokenizer.train_new_from_iterator()</code>. Pour illustrer cela, disons que nous voulons entraîner GPT-2 à partir de zéro mais dans une langue autre que l’anglais. Notre première tâche est de rassembler des batchs de données dans cette langue dans un corpus d’entraînement. Pour avoir des exemples que tout le monde puisse comprendre, nous n’utiliserons pas ici une langue comme le russe ou le chinois mais plutôt une langue anglaise spécialisée : le langage Python.",Ne,v,Ps='La bibliothèque <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 <em>Datasets</em></a> peut nous aider à assembler un corpus de code source Python. Nous allons utiliser la fonction habituelle <code>load_dataset()</code> pour télécharger et mettre en cache le jeu de données <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a>. Ce jeu de données a été créé pour le <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> et contient des millions de fonctions provenant de bibliothèques open source sur GitHub dans plusieurs langages de programmation. Ici, nous allons charger la partie Python de ce jeu de données :',Ee,C,Ge,Q,Fs="Nous pouvons jeter un coup d’œil au jeu d’entraînement pour voir quelles sont les colonnes auxquelles nous avons accès :",We,k,He,I,De,$,Ks="Nous pouvons voir que le jeu de données sépare les chaînes de documents du code et suggère une tokenization des deux. Ici, nous utiliserons simplement la colonne <code>whole_func_string</code> pour entraîner notre <em>tokenizer</em>. Nous pouvons regarder un exemple de la façon suivante :",Re,z,Ye,V,Os="qui nous affiche ce qui suit :",Se,_,Le,q,en="La première chose à faire est de transformer le jeu de données en un <em>itérateur</em> de listes de textes. Par exemple, une liste de listes de textes. L’utilisation de listes de textes permet à notre <em>tokenizer</em> d’aller plus vite (l’entraînement a alors lieu sur des batchs de textes au lieu de traiter des textes un par un). Et le fait que ce soit un itérateur permet d’éviter d’avoir tout en mémoire en même temps. Si votre corpus est énorme, vous voudrez profiter du fait que 🤗 <em>Datasets</em> ne charge pas tout en RAM mais stocke les éléments du jeu de données sur le disque.",Pe,B,sn="Faire ce qui suit créerait une liste de listes de 1 000 textes chacune mais chargerait tout en mémoire :",Fe,A,Ke,Z,nn="En utilisant un générateur, nous pouvons éviter que Python ne charge quoi que ce soit en mémoire à moins que cela soit réellement nécessaire. Pour créer un tel générateur, il suffit de remplacer les crochets par des parenthèses :",Oe,X,es,N,tn="Cette ligne de code ne récupère aucun élément du jeu de données. Elle crée simplement un objet que vous pouvez utiliser dans une boucle <code>for</code> Python. Les textes ne seront chargés que lorsque vous en aurez besoin (c’est-à-dire lorsque vous serez à l’étape de la boucle <code>for</code> qui les requiert) et seulement 1 000 textes à la fois. De cette façon, vous n’épuiserez pas toute votre mémoire, même si vous traitez un énorme jeu de données.",ss,E,ln="Le problème avec un objet générateur est qu’il ne peut être utilisé qu’une seule fois. Ainsi, au lieu que cet objet nous donne deux fois la liste des 10 premiers chiffres :",ns,G,ts,W,an="on les reçoit une fois et ensuite une liste vide :",ls,H,as,D,rn="C’est pourquoi nous définissons une fonction qui renvoie un générateur à la place :",is,R,rs,Y,pn="Vous pouvez également définir votre générateur à l’intérieur d’une boucle <code>for</code> en utilisant l’instruction <code>yield</code> :",ps,S,us,L,un="qui produit exactement le même générateur que précédemment mais  permet d’utiliser une logique plus complexe que celle que vous pouvez utiliser dans une compréhension de liste.",os,P,cs,F,on="Maintenant que nous avons notre corpus sous la forme d’un itérateur de batchs de textes, nous sommes prêts à entraîner un nouveau <em>tokenizer</em>. Pour ce faire, nous devons d’abord charger le <em>tokenizer</em> que nous voulons coupler avec notre modèle (ici, le GPT-2) :",ms,K,Ms,O,cn="Même si nous allons entraîner un nouveau <em>tokenizer</em>, c’est une bonne idée de faire ça pour éviter de partir entièrement de zéro. De cette façon, nous n’aurons pas à spécifier l’algorithme de tokénisation ou les jetons spéciaux que nous voulons utiliser. Notre nouveau <em>tokenizer</em> sera exactement le même que celui du GPT-2. La seule chose qui changera sera le vocabulaire qui sera déterminé lors de l’entraînement sur notre corpus.",Js,ee,mn="Voyons d’abord comment ce <em>tokenizer</em> traiterait un exemple de fonction :",ds,se,ys,ne,js,te,Mn="Ce <em>tokenizer</em> possède quelques symboles spéciaux, comme <code>Ġ</code> et <code>Ċ</code>, qui désignent respectivement les espaces et les retours à la ligne. Comme on peut le voir, ce n’est pas très efficace. Le <em>tokenizer</em> renvoie des jetons individuels pour chaque espace alors qu’il pourrait regrouper ceux des indentations (puisqu’avoir des ensembles de quatre ou huit espaces est très courant dans du code). Il divise également le nom de la fonction de façon un peu bizarre car pas habitué à voir des mots avec le caractère <code>_</code>.",Ts,le,Jn="Entraînons un nouveau <em>tokenizer</em> et voyons s’il résout ces problèmes. Pour cela, nous allons utiliser la méthode <code>train_new_from_iterator()</code> :",hs,ae,xs,ie,dn="Cette commande peut prendre un peu de temps si votre corpus est très grand. Pour ce jeu de données de 1,6 Go de textes, elle est très rapide (1 minute 16 secondes sur un CPU AMD Ryzen 9 3900X avec 12 cœurs).",fs,re,yn='Notez que <code>AutoTokenizer.train_new_from_iterator()</code> ne fonctionne que si le <em>tokenizer</em> que vous utilisez est un <em>tokenizer</em> « rapide ». Comme vous le verrez dans la section suivante, la bibliothèque 🤗 <em>Transformers</em> contient deux types de <em>tokenizers</em> : certains sont écrits en pur Python et d’autres (les rapides) sont soutenus par la bibliothèque 🤗 <em>Tokenizers</em> qui est écrite dans le langage <a href="https://www.rust-lang.org" rel="nofollow">Rust</a>. Python est le langage le plus souvent utilisé pour les applications de science des données et d’apprentissage profond, mais lorsque quelque chose doit être parallélisé pour être rapide, il faut que cela soit écrit dans un autre langage. Par exemple, les multiplications matricielles qui sont au cœur du calcul du modèle sont écrites en CUDA, une bibliothèque en C optimisée pour les GPUs.',Us,pe,jn='Entraîner un tout nouveau <em>tokenizer</em> en Python pur est atrocement lent, c’est pourquoi nous avons développé la bibliothèque 🤗 <em>Tokenizers</em>. Notez que, tout comme vous n’avez pas eu à apprendre le langage CUDA pour pouvoir exécuter votre modèle sur un batch d’entrées sur un GPU, vous n’aurez pas besoin d’apprendre Rust pour utiliser un <em>tokenizer</em> rapide. La bibliothèque 🤗 <em>Tokenizers</em> fournit des liaisons Python pour de nombreuses méthodes qui appellent en interne un morceau de code en Rust. Par exemple, pour paralléliser l’entraînement de votre nouveau <em>tokenizer</em> ou, comme nous l’avons vu dans le <a href="/course/fr/chapter3">chapitre 3</a>, la tokenisation d’un lot d’entrées.',gs,ue,Tn='La plupart des <em>transformers</em> ont un <em>tokenizer</em> rapide de disponible. Il y a quelques exceptions que vous pouvez vérifier <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">ici</a>. S’il est disponible, l’API <code>AutoTokenizer</code> sélectionne toujours pour vous le <em>tokenizer</em> rapide. Dans la prochaine section, nous allons jeter un coup d’oeil à certaines des autres caractéristiques spéciales des <em>tokenizers</em> rapides, qui seront très utiles pour des tâches comme la classification de <em>tokens</em> et la réponse aux questions. Mais avant cela, essayons notre tout nouveau <em>tokenizer</em> sur l’exemple précédent :',ws,oe,bs,ce,vs,me,hn="Ici, nous voyons à nouveau les symboles spéciaux <code>Ġ</code> et <code>Ċ</code> qui indiquent les espaces et les retours à la ligne. Nous pouvons également voir que notre <em>tokenizer</em> a appris certains <em>tokens</em> qui sont très spécifiques à un corpus de fonctions Python. Par exemple, il y a un token <code>ĊĠĠĠ</code> qui représente une indentation et un <em>token</em> <code>Ġ&quot;&quot;&quot;</code> qui représente les trois guillemets qui commencent une <em>docstring</em>. Le <em>tokenizer</em> divise également correctement le nom de la fonction sur <code>_</code>. Il s’agit d’une représentation assez compacte. En comparaison, l’utilisation du <em>tokenizer</em> en anglais « simple » sur le même exemple nous donnera une phrase plus longue :",Cs,Me,Qs,Je,ks,de,xn="Prenons un autre exemple :",Is,ye,$s,je,zs,Te,fn="En plus du <em>token</em> correspondant à une indentation, on peut également voir ici un <em>token</em> pour une double indentation : <code>ĊĠĠĠĠĠĠĠĠĠ</code>. Les mots spéciaux de Python comme <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, et <code>return</code> sont tous tokenizés comme un seul <em>token</em>. Nous pouvons voir qu’en plus de séparer sur <code>_</code> et <code>.</code> le tokenizer sépare correctement même les noms en minuscules. Par exemple <code>LinearLayer</code> est tokenisé comme <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",Vs,he,_s,xe,Un="Pour être sûr de pouvoir l’utiliser plus tard, nous devons sauvegarder notre nouveau <em>tokenizer</em>. Comme pour les modèles, ceci est fait avec la méthode <code>save_pretrained()</code> :",qs,fe,Bs,Ue,gn="Cela créera un nouveau dossier nommé <em>code-search-net-tokenizer</em> contenant tous les fichiers dont le <em>tokenizer</em> a besoin pour être rechargé. Si vous souhaitez partager ce <em>tokenizer</em> avec vos collègues et amis, vous pouvez le télécharger sur le <em>Hub</em> en vous connectant à votre compte. Si vous travaillez dans un <em>notebook</em>, il existe une fonction pratique pour vous aider à le faire :",As,ge,Zs,we,wn="Cela affichera un <em>widget</em> où vous pourrez entrer vos identifiants de connexion à Hugging Face. Si vous ne travaillez pas sur un ordinateur portable, tapez simplement la ligne suivante dans votre terminal :",Xs,be,Ns,ve,bn="Une fois connecté, vous pouvez pousser votre <em>tokenizer</em> en exécutant la commande suivante :",Es,Ce,Gs,Qe,vn="Cela créera un nouveau dépôt dans votre espace avec le nom <code>code-search-net-tokenizer</code> contenant le fichier <em>tokenizer</em>. Vous pouvez ensuite charger le <em>tokenizer</em> de n’importe où avec la méthode <code>from_pretrained()</code> :",Ws,ke,Hs,Ie,Cn='Vous êtes maintenant prêt à entraîner un modèle de langue à partir de zéro et à le <em>finetuner</em> sur votre tâche ! Nous verrons cela dans le <a href="/course/fr/chapter7">chapitre 7</a>, mais d’abord, dans le reste de ce chapitre, nous allons examiner de plus près les <em>tokenizers</em> rapides et explorer en détail ce qui se passe lorsque nous appelons la méthode <code>train_new_from_iterator()</code>.',Ds,ze,Rs;return x=new Ys({props:{title:"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien",local:"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien",headingTag:"h1"}}),f=new Nn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"}]}}),g=new Xn({props:{id:"DJimQynXZsQ"}}),T=new Zn({props:{warning:!0,$$slots:{default:[En]},$$scope:{ctx:Ve}}}),w=new Ys({props:{title:"Assemblage d’un corpus",local:"assemblage-dun-corpus",headingTag:"h2"}}),C=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwQ2VsYSUyMHBldXQlMjBwcmVuZHJlJTIwcXVlbHF1ZXMlMjBtaW51dGVzJTIwYWxvcnMlMjBwcmVuZXolMjB1biUyMHRoJUMzJUE5JTIwb3UlMjB1biUyMGNhZiVDMyVBOSUyMHBlbmRhbnQlMjBxdWUlMjB2b3VzJTIwcGF0aWVudGV6JTIwISUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb2RlX3NlYXJjaF9uZXQlMjIlMkMlMjAlMjJweXRob24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Cela peut prendre quelques minutes alors prenez un thé ou un café pendant que vous patientez !</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),k=new d({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),I=new d({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),z=new d({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),_=new d({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),A=new d({props:{code:"JTIzJTIwTmUlMjBkJUMzJUE5Y29tbWVudGV6JTIwcGFzJTIwbGElMjBsaWduZSUyMHN1aXZhbnRlJTIwJUMzJUEwJTIwbW9pbnMlMjBxdWUlMjB2b3RyZSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwc29pdCUyMHBldGl0JTIwISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Ne décommentez pas la ligne suivante à moins que votre jeu de données soit petit !</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),X=new d({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),G=new d({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),H=new d({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),R=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),S=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),P=new Ys({props:{title:"Entraînement d’un nouveau <i> tokenizer </i>",local:"entraînement-dun-nouveau-i-tokenizer-i",headingTag:"h2"}}),K=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),se=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),ne=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),ae=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),oe=new d({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),ce=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Me=new d({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),Je=new d({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ye=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),je=new d({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),he=new Ys({props:{title:"Sauvegarde du <i> tokenizer </i>",local:"sauvegarde-du-i-tokenizer-i",headingTag:"h2"}}),fe=new d({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),ge=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),be=new d({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Ce=new d({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),ke=new d({props:{code:"JTIzJTIwUmVtcGxhY2V6JTIwJTIyaHVnZ2luZ2ZhY2UtY291cnNlJTIyJTIwY2ktZGVzc291cyUyMHBhciUyMHZvdHJlJTIwZXNwYWNlJTIwciVDMyVBOWVsJTIwcG91ciUyMHV0aWxpc2VyJTIwdm90cmUlMjBwcm9wcmUlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Remplacez &quot;huggingface-course&quot; ci-dessous par votre espace réel pour utiliser votre propre tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),{c(){y=i("meta"),h=l(),j=i("p"),$e=l(),u(x.$$.fragment),_e=l(),u(f.$$.fragment),qe=l(),U=i("p"),U.innerHTML=Ss,Be=l(),u(g.$$.fragment),Ae=l(),u(T.$$.fragment),Ze=l(),u(w.$$.fragment),Xe=l(),b=i("p"),b.innerHTML=Ls,Ne=l(),v=i("p"),v.innerHTML=Ps,Ee=l(),u(C.$$.fragment),Ge=l(),Q=i("p"),Q.textContent=Fs,We=l(),u(k.$$.fragment),He=l(),u(I.$$.fragment),De=l(),$=i("p"),$.innerHTML=Ks,Re=l(),u(z.$$.fragment),Ye=l(),V=i("p"),V.textContent=Os,Se=l(),u(_.$$.fragment),Le=l(),q=i("p"),q.innerHTML=en,Pe=l(),B=i("p"),B.textContent=sn,Fe=l(),u(A.$$.fragment),Ke=l(),Z=i("p"),Z.textContent=nn,Oe=l(),u(X.$$.fragment),es=l(),N=i("p"),N.innerHTML=tn,ss=l(),E=i("p"),E.textContent=ln,ns=l(),u(G.$$.fragment),ts=l(),W=i("p"),W.textContent=an,ls=l(),u(H.$$.fragment),as=l(),D=i("p"),D.textContent=rn,is=l(),u(R.$$.fragment),rs=l(),Y=i("p"),Y.innerHTML=pn,ps=l(),u(S.$$.fragment),us=l(),L=i("p"),L.textContent=un,os=l(),u(P.$$.fragment),cs=l(),F=i("p"),F.innerHTML=on,ms=l(),u(K.$$.fragment),Ms=l(),O=i("p"),O.innerHTML=cn,Js=l(),ee=i("p"),ee.innerHTML=mn,ds=l(),u(se.$$.fragment),ys=l(),u(ne.$$.fragment),js=l(),te=i("p"),te.innerHTML=Mn,Ts=l(),le=i("p"),le.innerHTML=Jn,hs=l(),u(ae.$$.fragment),xs=l(),ie=i("p"),ie.textContent=dn,fs=l(),re=i("p"),re.innerHTML=yn,Us=l(),pe=i("p"),pe.innerHTML=jn,gs=l(),ue=i("p"),ue.innerHTML=Tn,ws=l(),u(oe.$$.fragment),bs=l(),u(ce.$$.fragment),vs=l(),me=i("p"),me.innerHTML=hn,Cs=l(),u(Me.$$.fragment),Qs=l(),u(Je.$$.fragment),ks=l(),de=i("p"),de.textContent=xn,Is=l(),u(ye.$$.fragment),$s=l(),u(je.$$.fragment),zs=l(),Te=i("p"),Te.innerHTML=fn,Vs=l(),u(he.$$.fragment),_s=l(),xe=i("p"),xe.innerHTML=Un,qs=l(),u(fe.$$.fragment),Bs=l(),Ue=i("p"),Ue.innerHTML=gn,As=l(),u(ge.$$.fragment),Zs=l(),we=i("p"),we.innerHTML=wn,Xs=l(),u(be.$$.fragment),Ns=l(),ve=i("p"),ve.innerHTML=bn,Es=l(),u(Ce.$$.fragment),Gs=l(),Qe=i("p"),Qe.innerHTML=vn,Ws=l(),u(ke.$$.fragment),Hs=l(),Ie=i("p"),Ie.innerHTML=Cn,Ds=l(),ze=i("p"),this.h()},l(e){const s=Bn("svelte-u9bgzb",document.head);y=r(s,"META",{name:!0,content:!0}),s.forEach(n),h=a(e),j=r(e,"P",{}),kn(j).forEach(n),$e=a(e),o(x.$$.fragment,e),_e=a(e),o(f.$$.fragment,e),qe=a(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-h6p3z9"&&(U.innerHTML=Ss),Be=a(e),o(g.$$.fragment,e),Ae=a(e),o(T.$$.fragment,e),Ze=a(e),o(w.$$.fragment,e),Xe=a(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-3a8ahh"&&(b.innerHTML=Ls),Ne=a(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bb56lo"&&(v.innerHTML=Ps),Ee=a(e),o(C.$$.fragment,e),Ge=a(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1fp73ub"&&(Q.textContent=Fs),We=a(e),o(k.$$.fragment,e),He=a(e),o(I.$$.fragment,e),De=a(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-qlite4"&&($.innerHTML=Ks),Re=a(e),o(z.$$.fragment,e),Ye=a(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-5ljnps"&&(V.textContent=Os),Se=a(e),o(_.$$.fragment,e),Le=a(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1vx3fum"&&(q.innerHTML=en),Pe=a(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-zpov33"&&(B.textContent=sn),Fe=a(e),o(A.$$.fragment,e),Ke=a(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-128wl1g"&&(Z.textContent=nn),Oe=a(e),o(X.$$.fragment,e),es=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-akpd54"&&(N.innerHTML=tn),ss=a(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-128xrzf"&&(E.textContent=ln),ns=a(e),o(G.$$.fragment,e),ts=a(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-17tsik7"&&(W.textContent=an),ls=a(e),o(H.$$.fragment,e),as=a(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-vat3n0"&&(D.textContent=rn),is=a(e),o(R.$$.fragment,e),rs=a(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1yy0u8j"&&(Y.innerHTML=pn),ps=a(e),o(S.$$.fragment,e),us=a(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-k8aiy2"&&(L.textContent=un),os=a(e),o(P.$$.fragment,e),cs=a(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1qktmfg"&&(F.innerHTML=on),ms=a(e),o(K.$$.fragment,e),Ms=a(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-ck2ga4"&&(O.innerHTML=cn),Js=a(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-4abjsh"&&(ee.innerHTML=mn),ds=a(e),o(se.$$.fragment,e),ys=a(e),o(ne.$$.fragment,e),js=a(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-88e5us"&&(te.innerHTML=Mn),Ts=a(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1179w4l"&&(le.innerHTML=Jn),hs=a(e),o(ae.$$.fragment,e),xs=a(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-kor19t"&&(ie.textContent=dn),fs=a(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-139x0nq"&&(re.innerHTML=yn),Us=a(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1hv5grb"&&(pe.innerHTML=jn),gs=a(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1qq2t5z"&&(ue.innerHTML=Tn),ws=a(e),o(oe.$$.fragment,e),bs=a(e),o(ce.$$.fragment,e),vs=a(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1stp3zo"&&(me.innerHTML=hn),Cs=a(e),o(Me.$$.fragment,e),Qs=a(e),o(Je.$$.fragment,e),ks=a(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-wslgg9"&&(de.textContent=xn),Is=a(e),o(ye.$$.fragment,e),$s=a(e),o(je.$$.fragment,e),zs=a(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-eqlvs6"&&(Te.innerHTML=fn),Vs=a(e),o(he.$$.fragment,e),_s=a(e),xe=r(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1hhex8"&&(xe.innerHTML=Un),qs=a(e),o(fe.$$.fragment,e),Bs=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1pu5z8g"&&(Ue.innerHTML=gn),As=a(e),o(ge.$$.fragment,e),Zs=a(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-brnmsg"&&(we.innerHTML=wn),Xs=a(e),o(be.$$.fragment,e),Ns=a(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-vzsbv1"&&(ve.innerHTML=bn),Es=a(e),o(Ce.$$.fragment,e),Gs=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-14y6ub0"&&(Qe.innerHTML=vn),Ws=a(e),o(ke.$$.fragment,e),Hs=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-oen3da"&&(Ie.innerHTML=Cn),Ds=a(e),ze=r(e,"P",{}),kn(ze).forEach(n),this.h()},h(){In(y,"name","hf:doc:metadata"),In(y,"content",Wn)},m(e,s){An(document.head,y),t(e,h,s),t(e,j,s),t(e,$e,s),c(x,e,s),t(e,_e,s),c(f,e,s),t(e,qe,s),t(e,U,s),t(e,Be,s),c(g,e,s),t(e,Ae,s),c(T,e,s),t(e,Ze,s),c(w,e,s),t(e,Xe,s),t(e,b,s),t(e,Ne,s),t(e,v,s),t(e,Ee,s),c(C,e,s),t(e,Ge,s),t(e,Q,s),t(e,We,s),c(k,e,s),t(e,He,s),c(I,e,s),t(e,De,s),t(e,$,s),t(e,Re,s),c(z,e,s),t(e,Ye,s),t(e,V,s),t(e,Se,s),c(_,e,s),t(e,Le,s),t(e,q,s),t(e,Pe,s),t(e,B,s),t(e,Fe,s),c(A,e,s),t(e,Ke,s),t(e,Z,s),t(e,Oe,s),c(X,e,s),t(e,es,s),t(e,N,s),t(e,ss,s),t(e,E,s),t(e,ns,s),c(G,e,s),t(e,ts,s),t(e,W,s),t(e,ls,s),c(H,e,s),t(e,as,s),t(e,D,s),t(e,is,s),c(R,e,s),t(e,rs,s),t(e,Y,s),t(e,ps,s),c(S,e,s),t(e,us,s),t(e,L,s),t(e,os,s),c(P,e,s),t(e,cs,s),t(e,F,s),t(e,ms,s),c(K,e,s),t(e,Ms,s),t(e,O,s),t(e,Js,s),t(e,ee,s),t(e,ds,s),c(se,e,s),t(e,ys,s),c(ne,e,s),t(e,js,s),t(e,te,s),t(e,Ts,s),t(e,le,s),t(e,hs,s),c(ae,e,s),t(e,xs,s),t(e,ie,s),t(e,fs,s),t(e,re,s),t(e,Us,s),t(e,pe,s),t(e,gs,s),t(e,ue,s),t(e,ws,s),c(oe,e,s),t(e,bs,s),c(ce,e,s),t(e,vs,s),t(e,me,s),t(e,Cs,s),c(Me,e,s),t(e,Qs,s),c(Je,e,s),t(e,ks,s),t(e,de,s),t(e,Is,s),c(ye,e,s),t(e,$s,s),c(je,e,s),t(e,zs,s),t(e,Te,s),t(e,Vs,s),c(he,e,s),t(e,_s,s),t(e,xe,s),t(e,qs,s),c(fe,e,s),t(e,Bs,s),t(e,Ue,s),t(e,As,s),c(ge,e,s),t(e,Zs,s),t(e,we,s),t(e,Xs,s),c(be,e,s),t(e,Ns,s),t(e,ve,s),t(e,Es,s),c(Ce,e,s),t(e,Gs,s),t(e,Qe,s),t(e,Ws,s),c(ke,e,s),t(e,Hs,s),t(e,Ie,s),t(e,Ds,s),t(e,ze,s),Rs=!0},p(e,[s]){const Qn={};s&2&&(Qn.$$scope={dirty:s,ctx:e}),T.$set(Qn)},i(e){Rs||(m(x.$$.fragment,e),m(f.$$.fragment,e),m(g.$$.fragment,e),m(T.$$.fragment,e),m(w.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(I.$$.fragment,e),m(z.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),Rs=!0)},o(e){M(x.$$.fragment,e),M(f.$$.fragment,e),M(g.$$.fragment,e),M(T.$$.fragment,e),M(w.$$.fragment,e),M(C.$$.fragment,e),M(k.$$.fragment,e),M(I.$$.fragment,e),M(z.$$.fragment,e),M(_.$$.fragment,e),M(A.$$.fragment,e),M(X.$$.fragment,e),M(G.$$.fragment,e),M(H.$$.fragment,e),M(R.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(Je.$$.fragment,e),M(ye.$$.fragment,e),M(je.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(be.$$.fragment,e),M(Ce.$$.fragment,e),M(ke.$$.fragment,e),Rs=!1},d(e){e&&(n(h),n(j),n($e),n(_e),n(qe),n(U),n(Be),n(Ae),n(Ze),n(Xe),n(b),n(Ne),n(v),n(Ee),n(Ge),n(Q),n(We),n(He),n(De),n($),n(Re),n(Ye),n(V),n(Se),n(Le),n(q),n(Pe),n(B),n(Fe),n(Ke),n(Z),n(Oe),n(es),n(N),n(ss),n(E),n(ns),n(ts),n(W),n(ls),n(as),n(D),n(is),n(rs),n(Y),n(ps),n(us),n(L),n(os),n(cs),n(F),n(ms),n(Ms),n(O),n(Js),n(ee),n(ds),n(ys),n(js),n(te),n(Ts),n(le),n(hs),n(xs),n(ie),n(fs),n(re),n(Us),n(pe),n(gs),n(ue),n(ws),n(bs),n(vs),n(me),n(Cs),n(Qs),n(ks),n(de),n(Is),n($s),n(zs),n(Te),n(Vs),n(_s),n(xe),n(qs),n(Bs),n(Ue),n(As),n(Zs),n(we),n(Xs),n(Ns),n(ve),n(Es),n(Gs),n(Qe),n(Ws),n(Hs),n(Ie),n(Ds),n(ze)),n(y),J(x,e),J(f,e),J(g,e),J(T,e),J(w,e),J(C,e),J(k,e),J(I,e),J(z,e),J(_,e),J(A,e),J(X,e),J(G,e),J(H,e),J(R,e),J(S,e),J(P,e),J(K,e),J(se,e),J(ne,e),J(ae,e),J(oe,e),J(ce,e),J(Me,e),J(Je,e),J(ye,e),J(je,e),J(he,e),J(fe,e),J(ge,e),J(be,e),J(Ce,e),J(ke,e)}}}const Wn='{"title":"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien","local":"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien","sections":[{"title":"Assemblage d’un corpus","local":"assemblage-dun-corpus","sections":[],"depth":2},{"title":"Entraînement d’un nouveau <i> tokenizer </i>","local":"entraînement-dun-nouveau-i-tokenizer-i","sections":[],"depth":2},{"title":"Sauvegarde du <i> tokenizer </i>","local":"sauvegarde-du-i-tokenizer-i","sections":[],"depth":2}],"depth":1}';function Hn(Ve){return zn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kn extends _n{constructor(y){super(),qn(this,y,Hn,Gn,$n,{})}}export{Kn as component};
