import{s as Ci,o as Zi,n as Vi}from"../chunks/scheduler.37c15a92.js";import{S as qi,i as Bi,g as i,s as n,r as o,A as _i,h as p,f as t,c as a,j as Ii,u,x as r,k as aa,y as Wi,a as l,v as c,d as m,t as M,w as d}from"../chunks/index.2bf4358c.js";import{T as Qi}from"../chunks/Tip.363c041f.js";import{Y as Ni}from"../chunks/Youtube.1e50a667.js";import{C as J}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Xi}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as ct}from"../chunks/Heading.8ada512a.js";function Ri(mt){let y,k=`<strong>Pour aller plus loin</strong> Si vous testez les deux versions des normaliseurs précédents sur une chaîne contenant le caractère unicode <code>u&quot;\\u0085&quot;</code> vous remarquerez sûrement qu’ils ne sont pas exactement équivalents.
Pour ne pas trop compliquer la version avec <code>normalizers.Sequence</code>, nous n’avons pas inclus les Regex que le <code>BertNormalizer</code> requiert quand l’argument <code>clean_text</code> est mis à <code>True</code> ce qui est le comportement par défaut. Mais ne vous inquiétez pas : il est possible d’obtenir exactement la même normalisation sans utiliser le très pratique <code>BertNormalizer</code> en ajoutant deux <code>normalizers.Replace</code> à la séquence de normalisation.`;return{c(){y=i("p"),y.innerHTML=k},l(j){y=p(j,"P",{"data-svelte-h":!0}),r(y)!=="svelte-5i2npl"&&(y.innerHTML=k)},m(j,ot){l(j,y,ot)},p:Vi,d(j){j&&t(y)}}}function Ai(mt){let y,k,j,ot,b,Mt,U,dt,$,ia="Comme nous l’avons vu dans les sections précédentes, la tokenisation comprend plusieurs étapes :",Jt,w,pa="<li>normalisation (tout nettoyage du texte jugé nécessaire, comme la suppression des espaces ou des accents, la normalisation Unicode, etc.),</li> <li>prétokénisation (division de l’entrée en mots),</li> <li>passage de l’entrée dans le modèle (utilisation des mots prétokénisés pour produire une séquence de <em>tokens</em>),</li> <li>post-traitement (ajout des <em>tokens</em> spéciaux du <em>tokenizer</em>, génération du masque d’attention et des identifiants du type de <em>token</em>).</li>",yt,h,ra="Pour mémoire, voici un autre aperçu du processus global :",jt,T,oa='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',Tt,g,ua='La bibliothèque 🤗 <em>Tokenizers</em> a été construite pour fournir plusieurs options pour chacune de ces étapes. Vous pouvez les mélanger et assortir ensemble. Dans cette section, nous verrons comment nous pouvons construire un <em>tokenizer</em> à partir de zéro, par opposition à entraîner un nouveau <em>tokenizer</em> à partir d’un ancien, comme nous l’avons fait dans <a href="/course/fr/chapter6/2">section 2</a>. Vous serez alors en mesure de construire n’importe quel type de <em>tokenizer</em> auquel vous pouvez penser !',ft,x,kt,z,ca="Plus précisément, la bibliothèque est construite autour d’une classe centrale <code>Tokenizer</code> avec les blocs de construction regroupés en sous-modules :",bt,v,ma='<li><code>normalizers</code> contient tous les types de <code>Normalizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">ici</a>),</li> <li><code>pre_tokenizers</code> contient tous les types de <code>PreTokenizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">ici</a>),</li> <li><code>models</code> contient les différents types de <code>Model</code> que vous pouvez utiliser, comme <code>BPE</code>, <code>WordPiece</code>, et <code>Unigram</code> (liste complète <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">ici</a>),</li> <li><code>trainers</code> contient tous les différents types de <code>Trainer</code> que vous pouvez utiliser pour entraîner votre modèle sur un corpus (un par type de modèle ; liste complète <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">ici</a>),</li> <li><code>post_processors</code> contient les différents types de <code>PostProcessor</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">ici</a>),</li> <li><code>decoders</code> contient les différents types de <code>Decoder</code> que vous pouvez utiliser pour décoder les sorties de tokenization (liste complète <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">ici</a>).</li>',Ut,I,Ma='Vous pouvez trouver la liste complète des blocs de construction <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">ici</a>.',$t,C,wt,Z,da='Pour entraîner notre nouveau <em>tokenizer</em>, nous utiliserons un petit corpus de texte (pour que les exemples soient rapides). Les étapes pour acquérir ce corpus sont similaires à celles que nous avons suivies au <a href="/course/fr/chapter6/2">début du chapitre</a>, mais cette fois nous utiliserons le jeu de données <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> :',ht,V,gt,q,Ja="La fonction <code>get_training_corpus()</code> est un générateur qui donne des batchs de 1 000 textes, que nous utiliserons pour entraîner le <em>tokenizer</em>.",xt,B,ya="🤗 <em>Tokenizers</em> peut aussi être entraîné directement sur des fichiers texte. Voici comment nous pouvons générer un fichier texte contenant tous les textes de WikiText-2 que nous pourrons ensuite utilisé en local :",zt,_,vt,W,ja="Ensuite, nous vous montrerons comment construire vos propres <em>tokenizers</em> pour BERT, GPT-2 et XLNet, bloc par bloc. Cela vous donnera un exemple de chacun des trois principaux algorithmes de tokenisation : <em>WordPiece</em>, BPE et <em>Unigram</em>. Commençons par BERT !",It,Q,Ct,N,Ta="Pour construire un <em>tokenizer</em> avec la bibliothèque 🤗 <em>Tokenizers</em>, nous commençons par instancier un objet <code>Tokenizer</code> avec un <code>model</code>. Puis nous définissons ses attributs <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> et <code>decoder</code> aux valeurs que nous voulons.",Zt,X,fa="Pour cet exemple, nous allons créer un <code>Tokenizer</code> avec un modèle <em>WordPiece</em> :",Vt,R,qt,A,ka="Nous devons spécifier le <code>unk_token</code> pour que le modèle sache quoi retourner lorsqu’il rencontre des caractères qu’il n’a pas vu auparavant. D’autres arguments que nous pouvons définir ici incluent le <code>vocab</code> de notre modèle (nous allons entraîner le modèle, donc nous n’avons pas besoin de le définir) et <code>max_input_chars_per_word</code>, qui spécifie une longueur maximale pour chaque mot (les mots plus longs que la valeur passée seront séparés).",Bt,L,ba="La première étape de la tokénisation est la normalisation. Puisque BERT est largement utilisé, une fonction <code>BertNormalizer</code> a été créée avec les options classiques que nous pouvons définir pour BERT : <code>lowercase</code> pour mettre le texte en minuscule, <code>strip_accents</code> qui enlève les accents, <code>clean_text</code> pour enlever tous les caractères de contrôle et fusionner des espaces répétés par un seul, et <code>handle_chinese_chars</code> qui place des espaces autour des caractères chinois. Pour reproduire le <em>tokenizer</em> <code>bert-base-uncased</code>, nous pouvons simplement définir ce <em>normalizer</em> :",_t,H,Wt,G,Ua="Cependant, généralement, lorsque vous construisez un nouveau <em>tokenizer</em>, vous n’avez pas accès à un normaliseur aussi pratique déjà implémenté dans la bibliothèque 🤗 <em>Tokenizers</em>. Donc voyons comment créer le normaliseur de BERT manuellement. La bibliothèque fournit un normaliseur <code>Lowercase</code> et un normaliseur <code>StripAccents</code>. Il est possible de composer plusieurs normaliseurs en utilisant une <code>Sequence</code> :",Qt,E,Nt,D,$a="Nous utilisons également un normaliseur Unicode <code>NFD</code>, car sinon <code>StripAccents</code> ne reconnaîtra pas correctement les caractères accentués et ne les supprimera donc pas.",Xt,S,wa="Comme nous l’avons vu précédemment, nous pouvons utiliser la méthode <code>normalize_str()</code> du <code>normalizer</code> pour vérifier les effets qu’il a sur un texte donné :",Rt,P,At,F,Lt,f,Ht,Y,ha="L’étape suivante est la prétokenisation. Encore une fois, il y a un <code>BertPreTokenizer</code> préconstruit que nous pouvons utiliser :",Gt,K,Et,O,ga="Ou nous pouvons le construire à partir de zéro :",Dt,ee,St,se,xa="Notez que le <code>Whitespace</code> divise sur les espaces et tous les caractères qui ne sont pas des lettres, des chiffres ou le caractère de soulignement. Donc techniquement il divise sur les espaces et la ponctuation :",Pt,te,Ft,le,Yt,ne,za="Si vous voulez seulement séparer sur les espaces, vous devez utiliser <code>WhitespaceSplit</code> à la place :",Kt,ae,Ot,ie,el,pe,va="Comme pour les normaliseurs, vous pouvez utiliser une <code>Sequence</code> pour composer plusieurs prétokenizers :",sl,re,tl,oe,ll,ue,Ia="L’étape suivante dans le pipeline de tokénisation est de faire passer les entrées par le modèle. Nous avons déjà spécifié notre modèle dans l’initialisation, mais nous devons encore l’entraîner, ce qui nécessitera un <code>WordPieceTrainer</code>. La principale chose à retenir lors de l’instanciation d’un entraîneur dans 🤗 <em>Tokenizers</em> est que vous devez lui passer tous les <em>tokens</em> spéciaux que vous avez l’intention d’utiliser. Sinon il ne les ajoutera pas au vocabulaire puisqu’ils ne sont pas dans le corpus d’entraînement :",nl,ce,al,me,Ca="En plus de spécifier la <code>vocab_size</code> et les <code>special_tokens</code>, nous pouvons définir la <code>min_frequency</code> (le nombre de fois qu’un <em>token</em> doit apparaître pour être inclus dans le vocabulaire) ou changer le <code>continuing_subword_prefix</code> (si nous voulons utiliser quelque chose de différent de <code>##</code>).",il,Me,Za="Pour entraîner notre modèle en utilisant l’itérateur que nous avons défini plus tôt, il suffit d’exécuter cette commande :",pl,de,rl,Je,Va="Nous pouvons également utiliser des fichiers texte pour entraîner notre <em>tokenizer</em> qui ressemblerait alors à ceci (nous réinitialisons le modèle avec un <code>WordPiece</code> vide au préalable) :",ol,ye,ul,je,qa="Dans les deux cas, nous pouvons ensuite tester le <em>tokenizer</em> sur un texte en appelant la méthode <code>encode()</code> :",cl,Te,ml,fe,Ml,ke,Ba="L’encodage obtenu est un <code>Encoding</code> contenant toutes les sorties nécessaires du <em>tokenizer</em> dans ses différents attributs : <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> et <code>overflowing</code>.",dl,be,_a="La dernière étape du pipeline de tokénisation est le post-traitement. Nous devons ajouter le <em>token</em> <code>[CLS]</code> au début et le <em>token</em> <code>[SEP]</code> à la fin (ou après chaque phrase si nous avons une paire de phrases). Nous utiliserons <code>TemplateProcessor</code> pour cela, mais d’abord nous devons connaître les identifiants des <em>tokens</em> <code>[CLS]</code> et <code>[SEP]</code> dans le vocabulaire :",Jl,Ue,yl,$e,jl,we,Wa="Pour écrire le gabarit pour <code>TemplateProcessor</code>, nous devons spécifier comment traiter une seule phrase et une paire de phrases. Pour les deux, nous écrivons les <em>tokens</em> spéciaux que nous voulons utiliser. La première (ou unique) phrase est représentée par <code>$A</code>, alors que la deuxième phrase (si on code une paire) est représentée par <code>$B</code>. Pour chacun de ces éléments (<em>tokens</em> spéciaux et phrases), nous spécifions également l’identifiant du <em>token</em> correspondant après un deux-points.",Tl,he,Qa="Le gabarit classique de BERT est donc défini comme suit :",fl,ge,kl,xe,Na="Notez que nous devons transmettre les identifiants des <em>tokens</em> spéciaux afin que le <em>tokenizer</em> puisse les convertir correctement.",bl,ze,Xa="Une fois cela ajouté, revenons à notre exemple précédent donnera :",Ul,ve,$l,Ie,wl,Ce,Ra="Et sur une paire de phrases, on obtient le bon résultat :",hl,Ze,gl,Ve,xl,qe,Aa="Nous avons presque fini de construire ce <em>tokenizer</em> à partir de zéro. La dernière étape consiste à inclure un décodeur :",zl,Be,vl,_e,La="Testons-le sur notre précédent <code>encoding</code> :",Il,We,Cl,Qe,Zl,Ne,Ha="Génial ! Nous pouvons enregistrer notre <em>tokenizer</em> dans un seul fichier JSON comme ceci :",Vl,Xe,ql,Re,Ga="Nous pouvons alors recharger ce fichier dans un objet <code>Tokenizer</code> avec la méthode <code>from_file()</code> :",Bl,Ae,_l,Le,Ea="Pour utiliser ce <em>tokenizer</em> dans 🤗 <em>Transformers</em>, nous devons l’envelopper dans un <code>PreTrainedTokenizerFast</code>. Nous pouvons soit utiliser la classe générique, soit, si notre <em>tokenizer</em> correspond à un modèle existant, utiliser cette classe (ici, <code>BertTokenizerFast</code>). Si vous appliquez cette logique pour construire un tout nouveau <em>tokenizer</em>, vous devrez utiliser la première option.",Wl,He,Da="Pour envelopper le <em>tokenizer</em> dans un <code>PreTrainedTokenizerFast</code>, nous pouvons soit passer le <em>tokenizer</em> que nous avons construit comme un <code>tokenizer_object</code>, soit passer le fichier de <em>tokenizer</em> que nous avons sauvegardé comme <code>tokenizer_file</code>. Ce qu’il faut retenir, c’est que nous devons définir manuellement tous les <em>tokens</em> spéciaux car cette classe ne peut pas déduire de l’objet <code>tokenizer</code> quel <em>token</em> est le <em>token</em> de masque, quel est le <em>token</em><code>[CLS]</code>, etc :",Ql,Ge,Nl,Ee,Sa="Si vous utilisez une classe de <em>tokenizer</em> spécifique (comme <code>BertTokenizerFast</code>), vous aurez seulement besoin de spécifier les <em>tokens</em> spéciaux qui sont différents de ceux par défaut (ici, aucun) :",Xl,De,Rl,Se,Pa="Vous pouvez ensuite utiliser ce <em>tokenizer</em> comme n’importe quel autre <em>tokenizer</em> de 🤗 <em>Transformers</em>. Vous pouvez le sauvegarder avec la méthode <code>save_pretrained()</code> ou le télécharger sur le <em>Hub</em> avec la méthode <code>push_to_hub()</code>.",Al,Pe,Fa="Maintenant que nous avons vu comment construire un <em>tokenizer WordPiece</em>, faisons de même pour un <em>tokenizer</em> BPE. Nous irons un peu plus vite puisque vous connaissez toutes les étapes. Nous ne soulignerons que les différences.",Ll,Fe,Hl,Ye,Ya="Construisons maintenant un <em>tokenizer</em> BPE. Comme pour le <em>tokenizer</em> BERT, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle BPE :",Gl,Ke,El,Oe,Ka="Comme pour BERT, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un (nous aurions besoin de passer le <code>vocab</code> et le <code>merges</code> dans ce cas), mais puisque nous allons nous entraîner à partir de zéro, nous n’avons pas besoin de le faire. Nous n’avons pas non plus besoin de spécifier un <code>unk_token</code> parce que le GPT-2 utilise un BPE au niveau de l’octet.",Dl,es,Oa="GPT-2 n’utilise pas de normaliseur, donc nous sautons cette étape et allons directement à la prétokénisation :",Sl,ss,Pl,ts,ei="L’option que nous avons ajoutée à <code>ByteLevel</code> ici est de ne pas ajouter d’espace en début de phrase (ce qui est le cas par défaut). Nous pouvons jeter un coup d’oeil à la prétokénisation d’un texte d’exemple comme avant :",Fl,ls,Yl,ns,Kl,as,si="Vient ensuite le modèle, qui doit être entraîné. Pour le GPT-2, le seul <em>token</em> spécial est le <em>token</em> de fin de texte :",Ol,is,en,ps,ti="Comme avec le <code>WordPieceTrainer</code>, ainsi que le <code>vocab_size</code> et le <code>special_tokens</code>, nous pouvons spécifier la <code>min_frequency</code> si nous le voulons, ou si nous avons un suffixe de fin de mot (comme <code>&lt;/w&gt;</code>), nous pouvons le définir avec <code>end_of_word_suffix</code>.",sn,rs,li="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",tn,os,ln,us,ni="Regardons la tokenisation d’un exemple de texte :",nn,cs,an,ms,pn,Ms,ai="Nous appliquons le post-traitement au niveau de l’octet pour le <em>tokenizer</em> du GPT-2 comme suit :",rn,ds,on,Js,ii="L’option <code>trim_offsets = False</code> indique au post-processeur que nous devons laisser les <em>offsets</em> des <em>tokens</em> qui commencent par ‘Ġ’ tels quels : de cette façon, le début des <em>offsets</em> pointera sur l’espace avant le mot, et non sur le premier caractère du mot (puisque l’espace fait techniquement partie du <em>token</em>). Regardons le résultat avec le texte que nous venons de coder, où <code>&#39;Ġtest&#39;</code> est le <em>token</em> à l’index 4 :",un,ys,cn,js,mn,Ts,pi="Enfin, nous ajoutons un décodeur au niveau de l’octet :",Mn,fs,dn,ks,ri="et nous pouvons vérifier qu’il fonctionne correctement :",Jn,bs,yn,Us,jn,$s,oi="Super ! Maintenant que nous avons terminé, nous pouvons sauvegarder le tokenizer comme avant, et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou un <code>GPT2TokenizerFast</code> si nous voulons l’utiliser dans 🤗 <em>Transformers</em> :",Tn,ws,fn,hs,ui="ou :",kn,gs,bn,xs,ci="Comme dernier exemple, nous allons vous montrer comment construire un <em>tokenizer</em> <em>Unigram</em> à partir de zéro.",Un,zs,$n,vs,mi="Construisons maintenant un <em>tokenizer</em> XLNet. Comme pour les <em>tokenizers</em> précédents, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle <em>Unigram</em> :",wn,Is,hn,Cs,Mi="Encore une fois, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un.",gn,Zs,di="Pour la normalisation, XLNet utilise quelques remplacements (qui proviennent de <em>SentencePiece</em>) :",xn,Vs,zn,qs,Ji="Il remplace <code>“</code> et <code>”</code> par <code>”</code> et toute séquence de deux espaces ou plus par un seul espace, de plus il supprime les accents.",vn,Bs,yi="Le prétokenizer à utiliser pour tout <em>tokenizer SentencePiece</em> est <code>Metaspace</code> :",In,_s,Cn,Ws,ji="Nous pouvons jeter un coup d’oeil à la prétokénisation sur le même exemple de texte que précédemment :",Zn,Qs,Vn,Ns,qn,Xs,Ti="Vient ensuite le modèle, qui doit être entraîné. XLNet possède un certain nombre de <em>tokens</em> spéciaux :",Bn,Rs,_n,As,fi="Un argument très important à ne pas oublier pour le <code>UnigramTrainer</code> est le <code>unk_token</code>. Nous pouvons aussi passer d’autres arguments spécifiques à l’algorithme <em>Unigram</em>, comme le <code>shrinking_factor</code> pour chaque étape où nous enlevons des <em>tokens</em> (par défaut 0.75) ou le <code>max_piece_length</code> pour spécifier la longueur maximale d’un <em>token</em> donné (par défaut 16).",Wn,Ls,ki="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",Qn,Hs,Nn,Gs,bi="Regardons la tokenisation de notre exemple :",Xn,Es,Rn,Ds,An,Ss,Ui="Une particularité de XLNet est qu’il place le <em>token</em> <code>&lt;cls&gt;</code> à la fin de la phrase, avec un identifiant de 2 (pour le distinguer des autres <em>tokens</em>). Le résultat est un remplissage à gauche. Nous pouvons traiter tous les <em>tokens</em> spéciaux et les types d’identifiant de <em>token</em> avec un modèle, comme pour BERT. Mais d’abord nous devons obtenir les identifiants des <em>tokens</em> <code>&lt;cls&gt;</code> et <code>&lt;sep&gt;</code> :",Ln,Ps,Hn,Fs,Gn,Ys,$i="Le modèle ressemble à ceci :",En,Ks,Dn,Os,wi="Et nous pouvons tester son fonctionnement en codant une paire de phrases :",Sn,et,Pn,st,Fn,tt,hi="Enfin, nous ajoutons un décodeur <code>Metaspace</code> :",Yn,lt,Kn,nt,gi="et on en a fini avec ce <em>tokenizer</em> ! On peut le sauvegarder et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou <code>XLNetTokenizerFast</code> si on veut l’utiliser dans 🤗 <em>Transformers</em>. Une chose à noter lors de l’utilisation de <code>PreTrainedTokenizerFast</code> est qu’en plus des <em>tokens</em> spéciaux, nous devons dire à la bibliothèque 🤗 <em>Transformers</em> de rembourrer à gauche :",On,at,ea,it,xi="Ou alternativement :",sa,pt,ta,rt,zi="Maintenant que vous avez vu comment les différentes briques sont utilisées pour construire des <em>tokenizers</em> existants, vous devriez être capable d’écrire n’importe quel <em>tokenizer</em> que vous voulez avec la bibliothèque 🤗 <em>Tokenizers</em> et pouvoir l’utiliser dans 🤗 <em>Transformers</em>.",la,ut,na;return b=new ct({props:{title:"Construction d’un <i> tokenizer </i> , bloc par bloc",local:"construction-dun-i-tokenizer-i--bloc-par-bloc",headingTag:"h1"}}),U=new Xi({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"}]}}),x=new Ni({props:{id:"MR8tZm5ViWU"}}),C=new ct({props:{title:"Acquisition d’un corpus",local:"acquisition-dun-corpus",headingTag:"h2"}}),V=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),_=new J({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),Q=new ct({props:{title:"Construire un <i> tokenizer WordPiece </i> à partir de zéro",local:"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro",headingTag:"h2"}}),R=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),H=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new J({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),F=new J({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),f=new Qi({props:{$$slots:{default:[Ri]},$$scope:{ctx:mt}}}),K=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),te=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),le=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ae=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ie=new J({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),re=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),oe=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ce=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),de=new J({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),ye=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Te=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),fe=new J({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ue=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),$e=new J({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ge=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),ve=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ie=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),Ve=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Be=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),We=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Qe=new J({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXIuLi4lMjBzdXIlMjB1bmUlMjBwYWlyZSUyMGRlJTIwcGhyYXNlcy4=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer... sur une paire de phrases.</span>',wrap:!1}}),Xe=new J({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ae=new J({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFZvdXMlMjBwb3V2ZXolMjBjaGFyZ2VyJTIwJUMzJUEwJTIwcGFydGlyJTIwZHUlMjBmaWNoaWVyJTIwZHUlMjB0b2tlbml6ZXIlMkMlMjBhbHRlcm5hdGl2ZW1lbnQlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # Vous pouvez charger à partir du fichier du tokenizer, alternativement</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),De=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new ct({props:{title:"Construire un <i> tokenizer </i> BPE à partir de zéro",local:"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro",headingTag:"h2"}}),Ke=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ls=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),is=new J({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),os=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),cs=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ms=new J({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ds=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),ys=new J({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),js=new J({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),fs=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),bs=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Us=new J({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer</span>',wrap:!1}}),ws=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),gs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),zs=new ct({props:{title:"Construire un <i> tokenizer Unigram </i> à partir de zéro",local:"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro",headingTag:"h2"}}),Is=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Vs=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),_s=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Qs=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Ns=new J({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Rs=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Hs=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Es=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ds=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Fs=new J({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),et=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),st=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),lt=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),at=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),pt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),{c(){y=i("meta"),k=n(),j=i("p"),ot=n(),o(b.$$.fragment),Mt=n(),o(U.$$.fragment),dt=n(),$=i("p"),$.textContent=ia,Jt=n(),w=i("ul"),w.innerHTML=pa,yt=n(),h=i("p"),h.textContent=ra,jt=n(),T=i("div"),T.innerHTML=oa,Tt=n(),g=i("p"),g.innerHTML=ua,ft=n(),o(x.$$.fragment),kt=n(),z=i("p"),z.innerHTML=ca,bt=n(),v=i("ul"),v.innerHTML=ma,Ut=n(),I=i("p"),I.innerHTML=Ma,$t=n(),o(C.$$.fragment),wt=n(),Z=i("p"),Z.innerHTML=da,ht=n(),o(V.$$.fragment),gt=n(),q=i("p"),q.innerHTML=Ja,xt=n(),B=i("p"),B.innerHTML=ya,zt=n(),o(_.$$.fragment),vt=n(),W=i("p"),W.innerHTML=ja,It=n(),o(Q.$$.fragment),Ct=n(),N=i("p"),N.innerHTML=Ta,Zt=n(),X=i("p"),X.innerHTML=fa,Vt=n(),o(R.$$.fragment),qt=n(),A=i("p"),A.innerHTML=ka,Bt=n(),L=i("p"),L.innerHTML=ba,_t=n(),o(H.$$.fragment),Wt=n(),G=i("p"),G.innerHTML=Ua,Qt=n(),o(E.$$.fragment),Nt=n(),D=i("p"),D.innerHTML=$a,Xt=n(),S=i("p"),S.innerHTML=wa,Rt=n(),o(P.$$.fragment),At=n(),o(F.$$.fragment),Lt=n(),o(f.$$.fragment),Ht=n(),Y=i("p"),Y.innerHTML=ha,Gt=n(),o(K.$$.fragment),Et=n(),O=i("p"),O.textContent=ga,Dt=n(),o(ee.$$.fragment),St=n(),se=i("p"),se.innerHTML=xa,Pt=n(),o(te.$$.fragment),Ft=n(),o(le.$$.fragment),Yt=n(),ne=i("p"),ne.innerHTML=za,Kt=n(),o(ae.$$.fragment),Ot=n(),o(ie.$$.fragment),el=n(),pe=i("p"),pe.innerHTML=va,sl=n(),o(re.$$.fragment),tl=n(),o(oe.$$.fragment),ll=n(),ue=i("p"),ue.innerHTML=Ia,nl=n(),o(ce.$$.fragment),al=n(),me=i("p"),me.innerHTML=Ca,il=n(),Me=i("p"),Me.textContent=Za,pl=n(),o(de.$$.fragment),rl=n(),Je=i("p"),Je.innerHTML=Va,ol=n(),o(ye.$$.fragment),ul=n(),je=i("p"),je.innerHTML=qa,cl=n(),o(Te.$$.fragment),ml=n(),o(fe.$$.fragment),Ml=n(),ke=i("p"),ke.innerHTML=Ba,dl=n(),be=i("p"),be.innerHTML=_a,Jl=n(),o(Ue.$$.fragment),yl=n(),o($e.$$.fragment),jl=n(),we=i("p"),we.innerHTML=Wa,Tl=n(),he=i("p"),he.textContent=Qa,fl=n(),o(ge.$$.fragment),kl=n(),xe=i("p"),xe.innerHTML=Na,bl=n(),ze=i("p"),ze.textContent=Xa,Ul=n(),o(ve.$$.fragment),$l=n(),o(Ie.$$.fragment),wl=n(),Ce=i("p"),Ce.textContent=Ra,hl=n(),o(Ze.$$.fragment),gl=n(),o(Ve.$$.fragment),xl=n(),qe=i("p"),qe.innerHTML=Aa,zl=n(),o(Be.$$.fragment),vl=n(),_e=i("p"),_e.innerHTML=La,Il=n(),o(We.$$.fragment),Cl=n(),o(Qe.$$.fragment),Zl=n(),Ne=i("p"),Ne.innerHTML=Ha,Vl=n(),o(Xe.$$.fragment),ql=n(),Re=i("p"),Re.innerHTML=Ga,Bl=n(),o(Ae.$$.fragment),_l=n(),Le=i("p"),Le.innerHTML=Ea,Wl=n(),He=i("p"),He.innerHTML=Da,Ql=n(),o(Ge.$$.fragment),Nl=n(),Ee=i("p"),Ee.innerHTML=Sa,Xl=n(),o(De.$$.fragment),Rl=n(),Se=i("p"),Se.innerHTML=Pa,Al=n(),Pe=i("p"),Pe.innerHTML=Fa,Ll=n(),o(Fe.$$.fragment),Hl=n(),Ye=i("p"),Ye.innerHTML=Ya,Gl=n(),o(Ke.$$.fragment),El=n(),Oe=i("p"),Oe.innerHTML=Ka,Dl=n(),es=i("p"),es.textContent=Oa,Sl=n(),o(ss.$$.fragment),Pl=n(),ts=i("p"),ts.innerHTML=ei,Fl=n(),o(ls.$$.fragment),Yl=n(),o(ns.$$.fragment),Kl=n(),as=i("p"),as.innerHTML=si,Ol=n(),o(is.$$.fragment),en=n(),ps=i("p"),ps.innerHTML=ti,sn=n(),rs=i("p"),rs.innerHTML=li,tn=n(),o(os.$$.fragment),ln=n(),us=i("p"),us.textContent=ni,nn=n(),o(cs.$$.fragment),an=n(),o(ms.$$.fragment),pn=n(),Ms=i("p"),Ms.innerHTML=ai,rn=n(),o(ds.$$.fragment),on=n(),Js=i("p"),Js.innerHTML=ii,un=n(),o(ys.$$.fragment),cn=n(),o(js.$$.fragment),mn=n(),Ts=i("p"),Ts.textContent=pi,Mn=n(),o(fs.$$.fragment),dn=n(),ks=i("p"),ks.textContent=ri,Jn=n(),o(bs.$$.fragment),yn=n(),o(Us.$$.fragment),jn=n(),$s=i("p"),$s.innerHTML=oi,Tn=n(),o(ws.$$.fragment),fn=n(),hs=i("p"),hs.textContent=ui,kn=n(),o(gs.$$.fragment),bn=n(),xs=i("p"),xs.innerHTML=ci,Un=n(),o(zs.$$.fragment),$n=n(),vs=i("p"),vs.innerHTML=mi,wn=n(),o(Is.$$.fragment),hn=n(),Cs=i("p"),Cs.textContent=Mi,gn=n(),Zs=i("p"),Zs.innerHTML=di,xn=n(),o(Vs.$$.fragment),zn=n(),qs=i("p"),qs.innerHTML=Ji,vn=n(),Bs=i("p"),Bs.innerHTML=yi,In=n(),o(_s.$$.fragment),Cn=n(),Ws=i("p"),Ws.textContent=ji,Zn=n(),o(Qs.$$.fragment),Vn=n(),o(Ns.$$.fragment),qn=n(),Xs=i("p"),Xs.innerHTML=Ti,Bn=n(),o(Rs.$$.fragment),_n=n(),As=i("p"),As.innerHTML=fi,Wn=n(),Ls=i("p"),Ls.innerHTML=ki,Qn=n(),o(Hs.$$.fragment),Nn=n(),Gs=i("p"),Gs.textContent=bi,Xn=n(),o(Es.$$.fragment),Rn=n(),o(Ds.$$.fragment),An=n(),Ss=i("p"),Ss.innerHTML=Ui,Ln=n(),o(Ps.$$.fragment),Hn=n(),o(Fs.$$.fragment),Gn=n(),Ys=i("p"),Ys.textContent=$i,En=n(),o(Ks.$$.fragment),Dn=n(),Os=i("p"),Os.textContent=wi,Sn=n(),o(et.$$.fragment),Pn=n(),o(st.$$.fragment),Fn=n(),tt=i("p"),tt.innerHTML=hi,Yn=n(),o(lt.$$.fragment),Kn=n(),nt=i("p"),nt.innerHTML=gi,On=n(),o(at.$$.fragment),ea=n(),it=i("p"),it.textContent=xi,sa=n(),o(pt.$$.fragment),ta=n(),rt=i("p"),rt.innerHTML=zi,la=n(),ut=i("p"),this.h()},l(e){const s=_i("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(t),k=a(e),j=p(e,"P",{}),Ii(j).forEach(t),ot=a(e),u(b.$$.fragment,e),Mt=a(e),u(U.$$.fragment,e),dt=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-oyei3k"&&($.textContent=ia),Jt=a(e),w=p(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-5anut5"&&(w.innerHTML=pa),yt=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1f3bknh"&&(h.textContent=ra),jt=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-oxfng3"&&(T.innerHTML=oa),Tt=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1kynzbk"&&(g.innerHTML=ua),ft=a(e),u(x.$$.fragment,e),kt=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-5p1dxj"&&(z.innerHTML=ca),bt=a(e),v=p(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1j4jxyk"&&(v.innerHTML=ma),Ut=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1pt23pv"&&(I.innerHTML=Ma),$t=a(e),u(C.$$.fragment,e),wt=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-17c1e08"&&(Z.innerHTML=da),ht=a(e),u(V.$$.fragment,e),gt=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1b2mrqy"&&(q.innerHTML=Ja),xt=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1iw8f3y"&&(B.innerHTML=ya),zt=a(e),u(_.$$.fragment,e),vt=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nye8ho"&&(W.innerHTML=ja),It=a(e),u(Q.$$.fragment,e),Ct=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1qlbya"&&(N.innerHTML=Ta),Zt=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1bcasjg"&&(X.innerHTML=fa),Vt=a(e),u(R.$$.fragment,e),qt=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1i725qn"&&(A.innerHTML=ka),Bt=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-17fukp3"&&(L.innerHTML=ba),_t=a(e),u(H.$$.fragment,e),Wt=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1fejf0b"&&(G.innerHTML=Ua),Qt=a(e),u(E.$$.fragment,e),Nt=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-okx1fu"&&(D.innerHTML=$a),Xt=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1gwij1w"&&(S.innerHTML=wa),Rt=a(e),u(P.$$.fragment,e),At=a(e),u(F.$$.fragment,e),Lt=a(e),u(f.$$.fragment,e),Ht=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19f16tj"&&(Y.innerHTML=ha),Gt=a(e),u(K.$$.fragment,e),Et=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-159e3ir"&&(O.textContent=ga),Dt=a(e),u(ee.$$.fragment,e),St=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-y4t8zr"&&(se.innerHTML=xa),Pt=a(e),u(te.$$.fragment,e),Ft=a(e),u(le.$$.fragment,e),Yt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-fvtgu0"&&(ne.innerHTML=za),Kt=a(e),u(ae.$$.fragment,e),Ot=a(e),u(ie.$$.fragment,e),el=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-cs3b0n"&&(pe.innerHTML=va),sl=a(e),u(re.$$.fragment,e),tl=a(e),u(oe.$$.fragment,e),ll=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-zfspxd"&&(ue.innerHTML=Ia),nl=a(e),u(ce.$$.fragment,e),al=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1arwrfz"&&(me.innerHTML=Ca),il=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-5lxhpv"&&(Me.textContent=Za),pl=a(e),u(de.$$.fragment,e),rl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-xg4lg6"&&(Je.innerHTML=Va),ol=a(e),u(ye.$$.fragment,e),ul=a(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1i0wlz3"&&(je.innerHTML=qa),cl=a(e),u(Te.$$.fragment,e),ml=a(e),u(fe.$$.fragment,e),Ml=a(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1s495vi"&&(ke.innerHTML=Ba),dl=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-eg12gz"&&(be.innerHTML=_a),Jl=a(e),u(Ue.$$.fragment,e),yl=a(e),u($e.$$.fragment,e),jl=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1kio2jq"&&(we.innerHTML=Wa),Tl=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-zo512q"&&(he.textContent=Qa),fl=a(e),u(ge.$$.fragment,e),kl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1sagyrz"&&(xe.innerHTML=Na),bl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-e0zi7j"&&(ze.textContent=Xa),Ul=a(e),u(ve.$$.fragment,e),$l=a(e),u(Ie.$$.fragment,e),wl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-4c2egr"&&(Ce.textContent=Ra),hl=a(e),u(Ze.$$.fragment,e),gl=a(e),u(Ve.$$.fragment,e),xl=a(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-qsb42a"&&(qe.innerHTML=Aa),zl=a(e),u(Be.$$.fragment,e),vl=a(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-116zp44"&&(_e.innerHTML=La),Il=a(e),u(We.$$.fragment,e),Cl=a(e),u(Qe.$$.fragment,e),Zl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-67o763"&&(Ne.innerHTML=Ha),Vl=a(e),u(Xe.$$.fragment,e),ql=a(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-kfjmjn"&&(Re.innerHTML=Ga),Bl=a(e),u(Ae.$$.fragment,e),_l=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-ychh5o"&&(Le.innerHTML=Ea),Wl=a(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-vdya8f"&&(He.innerHTML=Da),Ql=a(e),u(Ge.$$.fragment,e),Nl=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-awkqmq"&&(Ee.innerHTML=Sa),Xl=a(e),u(De.$$.fragment,e),Rl=a(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1ndzyah"&&(Se.innerHTML=Pa),Al=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1rarvjc"&&(Pe.innerHTML=Fa),Ll=a(e),u(Fe.$$.fragment,e),Hl=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-ix9zak"&&(Ye.innerHTML=Ya),Gl=a(e),u(Ke.$$.fragment,e),El=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-d2bplb"&&(Oe.innerHTML=Ka),Dl=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-lcqq2e"&&(es.textContent=Oa),Sl=a(e),u(ss.$$.fragment,e),Pl=a(e),ts=p(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-pjtgp6"&&(ts.innerHTML=ei),Fl=a(e),u(ls.$$.fragment,e),Yl=a(e),u(ns.$$.fragment,e),Kl=a(e),as=p(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-thl8v2"&&(as.innerHTML=si),Ol=a(e),u(is.$$.fragment,e),en=a(e),ps=p(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-zu5iz"&&(ps.innerHTML=ti),sn=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-z3sga0"&&(rs.innerHTML=li),tn=a(e),u(os.$$.fragment,e),ln=a(e),us=p(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-18twlvh"&&(us.textContent=ni),nn=a(e),u(cs.$$.fragment,e),an=a(e),u(ms.$$.fragment,e),pn=a(e),Ms=p(e,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-16mr1f9"&&(Ms.innerHTML=ai),rn=a(e),u(ds.$$.fragment,e),on=a(e),Js=p(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-m9lq9f"&&(Js.innerHTML=ii),un=a(e),u(ys.$$.fragment,e),cn=a(e),u(js.$$.fragment,e),mn=a(e),Ts=p(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1lij06j"&&(Ts.textContent=pi),Mn=a(e),u(fs.$$.fragment,e),dn=a(e),ks=p(e,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-4071k0"&&(ks.textContent=ri),Jn=a(e),u(bs.$$.fragment,e),yn=a(e),u(Us.$$.fragment,e),jn=a(e),$s=p(e,"P",{"data-svelte-h":!0}),r($s)!=="svelte-y86eft"&&($s.innerHTML=oi),Tn=a(e),u(ws.$$.fragment,e),fn=a(e),hs=p(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-13b090a"&&(hs.textContent=ui),kn=a(e),u(gs.$$.fragment,e),bn=a(e),xs=p(e,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-1w4hpgt"&&(xs.innerHTML=ci),Un=a(e),u(zs.$$.fragment,e),$n=a(e),vs=p(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-58ts27"&&(vs.innerHTML=mi),wn=a(e),u(Is.$$.fragment,e),hn=a(e),Cs=p(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-14pp70f"&&(Cs.textContent=Mi),gn=a(e),Zs=p(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-st1rcn"&&(Zs.innerHTML=di),xn=a(e),u(Vs.$$.fragment,e),zn=a(e),qs=p(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-13xok8v"&&(qs.innerHTML=Ji),vn=a(e),Bs=p(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-167wifx"&&(Bs.innerHTML=yi),In=a(e),u(_s.$$.fragment,e),Cn=a(e),Ws=p(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1o14whc"&&(Ws.textContent=ji),Zn=a(e),u(Qs.$$.fragment,e),Vn=a(e),u(Ns.$$.fragment,e),qn=a(e),Xs=p(e,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-13jka1z"&&(Xs.innerHTML=Ti),Bn=a(e),u(Rs.$$.fragment,e),_n=a(e),As=p(e,"P",{"data-svelte-h":!0}),r(As)!=="svelte-3xrd6e"&&(As.innerHTML=fi),Wn=a(e),Ls=p(e,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-z3sga0"&&(Ls.innerHTML=ki),Qn=a(e),u(Hs.$$.fragment,e),Nn=a(e),Gs=p(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-1y9tqut"&&(Gs.textContent=bi),Xn=a(e),u(Es.$$.fragment,e),Rn=a(e),u(Ds.$$.fragment,e),An=a(e),Ss=p(e,"P",{"data-svelte-h":!0}),r(Ss)!=="svelte-1fjzee2"&&(Ss.innerHTML=Ui),Ln=a(e),u(Ps.$$.fragment,e),Hn=a(e),u(Fs.$$.fragment,e),Gn=a(e),Ys=p(e,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-1g309vi"&&(Ys.textContent=$i),En=a(e),u(Ks.$$.fragment,e),Dn=a(e),Os=p(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-w6fgfg"&&(Os.textContent=wi),Sn=a(e),u(et.$$.fragment,e),Pn=a(e),u(st.$$.fragment,e),Fn=a(e),tt=p(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-ztu276"&&(tt.innerHTML=hi),Yn=a(e),u(lt.$$.fragment,e),Kn=a(e),nt=p(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1wp6ni3"&&(nt.innerHTML=gi),On=a(e),u(at.$$.fragment,e),ea=a(e),it=p(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-rruroj"&&(it.textContent=xi),sa=a(e),u(pt.$$.fragment,e),ta=a(e),rt=p(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-j719xk"&&(rt.innerHTML=zi),la=a(e),ut=p(e,"P",{}),Ii(ut).forEach(t),this.h()},h(){aa(y,"name","hf:doc:metadata"),aa(y,"content",Li),aa(T,"class","flex justify-center")},m(e,s){Wi(document.head,y),l(e,k,s),l(e,j,s),l(e,ot,s),c(b,e,s),l(e,Mt,s),c(U,e,s),l(e,dt,s),l(e,$,s),l(e,Jt,s),l(e,w,s),l(e,yt,s),l(e,h,s),l(e,jt,s),l(e,T,s),l(e,Tt,s),l(e,g,s),l(e,ft,s),c(x,e,s),l(e,kt,s),l(e,z,s),l(e,bt,s),l(e,v,s),l(e,Ut,s),l(e,I,s),l(e,$t,s),c(C,e,s),l(e,wt,s),l(e,Z,s),l(e,ht,s),c(V,e,s),l(e,gt,s),l(e,q,s),l(e,xt,s),l(e,B,s),l(e,zt,s),c(_,e,s),l(e,vt,s),l(e,W,s),l(e,It,s),c(Q,e,s),l(e,Ct,s),l(e,N,s),l(e,Zt,s),l(e,X,s),l(e,Vt,s),c(R,e,s),l(e,qt,s),l(e,A,s),l(e,Bt,s),l(e,L,s),l(e,_t,s),c(H,e,s),l(e,Wt,s),l(e,G,s),l(e,Qt,s),c(E,e,s),l(e,Nt,s),l(e,D,s),l(e,Xt,s),l(e,S,s),l(e,Rt,s),c(P,e,s),l(e,At,s),c(F,e,s),l(e,Lt,s),c(f,e,s),l(e,Ht,s),l(e,Y,s),l(e,Gt,s),c(K,e,s),l(e,Et,s),l(e,O,s),l(e,Dt,s),c(ee,e,s),l(e,St,s),l(e,se,s),l(e,Pt,s),c(te,e,s),l(e,Ft,s),c(le,e,s),l(e,Yt,s),l(e,ne,s),l(e,Kt,s),c(ae,e,s),l(e,Ot,s),c(ie,e,s),l(e,el,s),l(e,pe,s),l(e,sl,s),c(re,e,s),l(e,tl,s),c(oe,e,s),l(e,ll,s),l(e,ue,s),l(e,nl,s),c(ce,e,s),l(e,al,s),l(e,me,s),l(e,il,s),l(e,Me,s),l(e,pl,s),c(de,e,s),l(e,rl,s),l(e,Je,s),l(e,ol,s),c(ye,e,s),l(e,ul,s),l(e,je,s),l(e,cl,s),c(Te,e,s),l(e,ml,s),c(fe,e,s),l(e,Ml,s),l(e,ke,s),l(e,dl,s),l(e,be,s),l(e,Jl,s),c(Ue,e,s),l(e,yl,s),c($e,e,s),l(e,jl,s),l(e,we,s),l(e,Tl,s),l(e,he,s),l(e,fl,s),c(ge,e,s),l(e,kl,s),l(e,xe,s),l(e,bl,s),l(e,ze,s),l(e,Ul,s),c(ve,e,s),l(e,$l,s),c(Ie,e,s),l(e,wl,s),l(e,Ce,s),l(e,hl,s),c(Ze,e,s),l(e,gl,s),c(Ve,e,s),l(e,xl,s),l(e,qe,s),l(e,zl,s),c(Be,e,s),l(e,vl,s),l(e,_e,s),l(e,Il,s),c(We,e,s),l(e,Cl,s),c(Qe,e,s),l(e,Zl,s),l(e,Ne,s),l(e,Vl,s),c(Xe,e,s),l(e,ql,s),l(e,Re,s),l(e,Bl,s),c(Ae,e,s),l(e,_l,s),l(e,Le,s),l(e,Wl,s),l(e,He,s),l(e,Ql,s),c(Ge,e,s),l(e,Nl,s),l(e,Ee,s),l(e,Xl,s),c(De,e,s),l(e,Rl,s),l(e,Se,s),l(e,Al,s),l(e,Pe,s),l(e,Ll,s),c(Fe,e,s),l(e,Hl,s),l(e,Ye,s),l(e,Gl,s),c(Ke,e,s),l(e,El,s),l(e,Oe,s),l(e,Dl,s),l(e,es,s),l(e,Sl,s),c(ss,e,s),l(e,Pl,s),l(e,ts,s),l(e,Fl,s),c(ls,e,s),l(e,Yl,s),c(ns,e,s),l(e,Kl,s),l(e,as,s),l(e,Ol,s),c(is,e,s),l(e,en,s),l(e,ps,s),l(e,sn,s),l(e,rs,s),l(e,tn,s),c(os,e,s),l(e,ln,s),l(e,us,s),l(e,nn,s),c(cs,e,s),l(e,an,s),c(ms,e,s),l(e,pn,s),l(e,Ms,s),l(e,rn,s),c(ds,e,s),l(e,on,s),l(e,Js,s),l(e,un,s),c(ys,e,s),l(e,cn,s),c(js,e,s),l(e,mn,s),l(e,Ts,s),l(e,Mn,s),c(fs,e,s),l(e,dn,s),l(e,ks,s),l(e,Jn,s),c(bs,e,s),l(e,yn,s),c(Us,e,s),l(e,jn,s),l(e,$s,s),l(e,Tn,s),c(ws,e,s),l(e,fn,s),l(e,hs,s),l(e,kn,s),c(gs,e,s),l(e,bn,s),l(e,xs,s),l(e,Un,s),c(zs,e,s),l(e,$n,s),l(e,vs,s),l(e,wn,s),c(Is,e,s),l(e,hn,s),l(e,Cs,s),l(e,gn,s),l(e,Zs,s),l(e,xn,s),c(Vs,e,s),l(e,zn,s),l(e,qs,s),l(e,vn,s),l(e,Bs,s),l(e,In,s),c(_s,e,s),l(e,Cn,s),l(e,Ws,s),l(e,Zn,s),c(Qs,e,s),l(e,Vn,s),c(Ns,e,s),l(e,qn,s),l(e,Xs,s),l(e,Bn,s),c(Rs,e,s),l(e,_n,s),l(e,As,s),l(e,Wn,s),l(e,Ls,s),l(e,Qn,s),c(Hs,e,s),l(e,Nn,s),l(e,Gs,s),l(e,Xn,s),c(Es,e,s),l(e,Rn,s),c(Ds,e,s),l(e,An,s),l(e,Ss,s),l(e,Ln,s),c(Ps,e,s),l(e,Hn,s),c(Fs,e,s),l(e,Gn,s),l(e,Ys,s),l(e,En,s),c(Ks,e,s),l(e,Dn,s),l(e,Os,s),l(e,Sn,s),c(et,e,s),l(e,Pn,s),c(st,e,s),l(e,Fn,s),l(e,tt,s),l(e,Yn,s),c(lt,e,s),l(e,Kn,s),l(e,nt,s),l(e,On,s),c(at,e,s),l(e,ea,s),l(e,it,s),l(e,sa,s),c(pt,e,s),l(e,ta,s),l(e,rt,s),l(e,la,s),l(e,ut,s),na=!0},p(e,[s]){const vi={};s&2&&(vi.$$scope={dirty:s,ctx:e}),f.$set(vi)},i(e){na||(m(b.$$.fragment,e),m(U.$$.fragment,e),m(x.$$.fragment,e),m(C.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(E.$$.fragment,e),m(P.$$.fragment,e),m(F.$$.fragment,e),m(f.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Ve.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Qe.$$.fragment,e),m(Xe.$$.fragment,e),m(Ae.$$.fragment,e),m(Ge.$$.fragment,e),m(De.$$.fragment,e),m(Fe.$$.fragment,e),m(Ke.$$.fragment,e),m(ss.$$.fragment,e),m(ls.$$.fragment,e),m(ns.$$.fragment,e),m(is.$$.fragment,e),m(os.$$.fragment,e),m(cs.$$.fragment,e),m(ms.$$.fragment,e),m(ds.$$.fragment,e),m(ys.$$.fragment,e),m(js.$$.fragment,e),m(fs.$$.fragment,e),m(bs.$$.fragment,e),m(Us.$$.fragment,e),m(ws.$$.fragment,e),m(gs.$$.fragment,e),m(zs.$$.fragment,e),m(Is.$$.fragment,e),m(Vs.$$.fragment,e),m(_s.$$.fragment,e),m(Qs.$$.fragment,e),m(Ns.$$.fragment,e),m(Rs.$$.fragment,e),m(Hs.$$.fragment,e),m(Es.$$.fragment,e),m(Ds.$$.fragment,e),m(Ps.$$.fragment,e),m(Fs.$$.fragment,e),m(Ks.$$.fragment,e),m(et.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),na=!0)},o(e){M(b.$$.fragment,e),M(U.$$.fragment,e),M(x.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(_.$$.fragment,e),M(Q.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(F.$$.fragment,e),M(f.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(fe.$$.fragment,e),M(Ue.$$.fragment,e),M($e.$$.fragment,e),M(ge.$$.fragment,e),M(ve.$$.fragment,e),M(Ie.$$.fragment,e),M(Ze.$$.fragment,e),M(Ve.$$.fragment,e),M(Be.$$.fragment,e),M(We.$$.fragment,e),M(Qe.$$.fragment,e),M(Xe.$$.fragment,e),M(Ae.$$.fragment,e),M(Ge.$$.fragment,e),M(De.$$.fragment,e),M(Fe.$$.fragment,e),M(Ke.$$.fragment,e),M(ss.$$.fragment,e),M(ls.$$.fragment,e),M(ns.$$.fragment,e),M(is.$$.fragment,e),M(os.$$.fragment,e),M(cs.$$.fragment,e),M(ms.$$.fragment,e),M(ds.$$.fragment,e),M(ys.$$.fragment,e),M(js.$$.fragment,e),M(fs.$$.fragment,e),M(bs.$$.fragment,e),M(Us.$$.fragment,e),M(ws.$$.fragment,e),M(gs.$$.fragment,e),M(zs.$$.fragment,e),M(Is.$$.fragment,e),M(Vs.$$.fragment,e),M(_s.$$.fragment,e),M(Qs.$$.fragment,e),M(Ns.$$.fragment,e),M(Rs.$$.fragment,e),M(Hs.$$.fragment,e),M(Es.$$.fragment,e),M(Ds.$$.fragment,e),M(Ps.$$.fragment,e),M(Fs.$$.fragment,e),M(Ks.$$.fragment,e),M(et.$$.fragment,e),M(st.$$.fragment,e),M(lt.$$.fragment,e),M(at.$$.fragment,e),M(pt.$$.fragment,e),na=!1},d(e){e&&(t(k),t(j),t(ot),t(Mt),t(dt),t($),t(Jt),t(w),t(yt),t(h),t(jt),t(T),t(Tt),t(g),t(ft),t(kt),t(z),t(bt),t(v),t(Ut),t(I),t($t),t(wt),t(Z),t(ht),t(gt),t(q),t(xt),t(B),t(zt),t(vt),t(W),t(It),t(Ct),t(N),t(Zt),t(X),t(Vt),t(qt),t(A),t(Bt),t(L),t(_t),t(Wt),t(G),t(Qt),t(Nt),t(D),t(Xt),t(S),t(Rt),t(At),t(Lt),t(Ht),t(Y),t(Gt),t(Et),t(O),t(Dt),t(St),t(se),t(Pt),t(Ft),t(Yt),t(ne),t(Kt),t(Ot),t(el),t(pe),t(sl),t(tl),t(ll),t(ue),t(nl),t(al),t(me),t(il),t(Me),t(pl),t(rl),t(Je),t(ol),t(ul),t(je),t(cl),t(ml),t(Ml),t(ke),t(dl),t(be),t(Jl),t(yl),t(jl),t(we),t(Tl),t(he),t(fl),t(kl),t(xe),t(bl),t(ze),t(Ul),t($l),t(wl),t(Ce),t(hl),t(gl),t(xl),t(qe),t(zl),t(vl),t(_e),t(Il),t(Cl),t(Zl),t(Ne),t(Vl),t(ql),t(Re),t(Bl),t(_l),t(Le),t(Wl),t(He),t(Ql),t(Nl),t(Ee),t(Xl),t(Rl),t(Se),t(Al),t(Pe),t(Ll),t(Hl),t(Ye),t(Gl),t(El),t(Oe),t(Dl),t(es),t(Sl),t(Pl),t(ts),t(Fl),t(Yl),t(Kl),t(as),t(Ol),t(en),t(ps),t(sn),t(rs),t(tn),t(ln),t(us),t(nn),t(an),t(pn),t(Ms),t(rn),t(on),t(Js),t(un),t(cn),t(mn),t(Ts),t(Mn),t(dn),t(ks),t(Jn),t(yn),t(jn),t($s),t(Tn),t(fn),t(hs),t(kn),t(bn),t(xs),t(Un),t($n),t(vs),t(wn),t(hn),t(Cs),t(gn),t(Zs),t(xn),t(zn),t(qs),t(vn),t(Bs),t(In),t(Cn),t(Ws),t(Zn),t(Vn),t(qn),t(Xs),t(Bn),t(_n),t(As),t(Wn),t(Ls),t(Qn),t(Nn),t(Gs),t(Xn),t(Rn),t(An),t(Ss),t(Ln),t(Hn),t(Gn),t(Ys),t(En),t(Dn),t(Os),t(Sn),t(Pn),t(Fn),t(tt),t(Yn),t(Kn),t(nt),t(On),t(ea),t(it),t(sa),t(ta),t(rt),t(la),t(ut)),t(y),d(b,e),d(U,e),d(x,e),d(C,e),d(V,e),d(_,e),d(Q,e),d(R,e),d(H,e),d(E,e),d(P,e),d(F,e),d(f,e),d(K,e),d(ee,e),d(te,e),d(le,e),d(ae,e),d(ie,e),d(re,e),d(oe,e),d(ce,e),d(de,e),d(ye,e),d(Te,e),d(fe,e),d(Ue,e),d($e,e),d(ge,e),d(ve,e),d(Ie,e),d(Ze,e),d(Ve,e),d(Be,e),d(We,e),d(Qe,e),d(Xe,e),d(Ae,e),d(Ge,e),d(De,e),d(Fe,e),d(Ke,e),d(ss,e),d(ls,e),d(ns,e),d(is,e),d(os,e),d(cs,e),d(ms,e),d(ds,e),d(ys,e),d(js,e),d(fs,e),d(bs,e),d(Us,e),d(ws,e),d(gs,e),d(zs,e),d(Is,e),d(Vs,e),d(_s,e),d(Qs,e),d(Ns,e),d(Rs,e),d(Hs,e),d(Es,e),d(Ds,e),d(Ps,e),d(Fs,e),d(Ks,e),d(et,e),d(st,e),d(lt,e),d(at,e),d(pt,e)}}}const Li='{"title":"Construction d’un <i> tokenizer </i> , bloc par bloc","local":"construction-dun-i-tokenizer-i--bloc-par-bloc","sections":[{"title":"Acquisition d’un corpus","local":"acquisition-dun-corpus","sections":[],"depth":2},{"title":"Construire un <i> tokenizer WordPiece </i> à partir de zéro","local":"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer </i> BPE à partir de zéro","local":"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer Unigram </i> à partir de zéro","local":"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro","sections":[],"depth":2}],"depth":1}';function Hi(mt){return Zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ki extends qi{constructor(y){super(),Bi(this,y,Hi,Ai,Ci,{})}}export{Ki as component};
