import{s as jt,o as vt,n as et}from"../chunks/scheduler.37c15a92.js";import{S as zt,i as gt,g as f,s,r,A as Gt,h as M,f as a,c as i,j as Tt,u as p,x as b,k as Ut,y as Zt,a as l,v as m,d,t as c,w as u}from"../chunks/index.2bf4358c.js";import{T as De}from"../chunks/Tip.363c041f.js";import{Y as Ke}from"../chunks/Youtube.1e50a667.js";import{C as w}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as _t}from"../chunks/DocNotebookDropdown.46ab6a61.js";import{F as Ct}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Oe}from"../chunks/Heading.8ada512a.js";function kt($){let n,h="I modelli 🤗 Transformers hanno un’abilità speciale che manca alla maggior parte dei modelli Keras – possono usare in maniera automatica una funzione obiettivo appropriata, calcolata internamente. Questa funzione obiettivo verrà usata di default a meno che non venga definito l’argomento di funzione obiettivo nel metodo <code>compile()</code>. Per usare la funzione obiettivo interna è necessario passare le etichette come parte dell’input, non separatamente, che è l’approccio normale con i modelli Keras. Verranno mostrati esempi di ciò nella Parte 2 del corso, dove definire la funzione obiettivo correttamente può essere difficile. Per la classificazione di sequenze, invece, la funzione obiettivo standard di Keras funziona bene, quindi verrà utilizzata quella.";return{c(){n=f("p"),n.innerHTML=h},l(o){n=M(o,"P",{"data-svelte-h":!0}),b(n)!=="svelte-ez7phw"&&(n.innerHTML=h)},m(o,y){l(o,n,y)},p:et,d(o){o&&a(n)}}}function It($){let n,h="Attenzione ad un errore comune — si <em>può</em> passare solo il nome della funzione obiettivo a Keras come una stringa, ma di default Keras si aspetta che softmax sia già stato applicato ai risultati. Molti modelli invece forniscono come risultato i valori prima dell’applicazione del softmax, chiamati <em>logits</em>. Bisogna informare la funzione obiettivo che il nostro modello fa esattamente questo, e il solo modo di farlo è invocandola direttamente, non tramite la stringa che rappresenta il suo nome.";return{c(){n=f("p"),n.innerHTML=h},l(o){n=M(o,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1knd3lr"&&(n.innerHTML=h)},m(o,y){l(o,n,y)},p:et,d(o){o&&a(n)}}}function Xt($){let n,h="La libreria 🤗 Transformers fornisce anche una funzione <code>create_optimizer()</code> che crea un ottimizzatore <code>AdamW</code> con decadimento della learning rate. Questa può essere una scorciatoia utile che verrà presentata nel dettaglio nelle sezioni future del corso.";return{c(){n=f("p"),n.innerHTML=h},l(o){n=M(o,"P",{"data-svelte-h":!0}),b(n)!=="svelte-12088bb"&&(n.innerHTML=h)},m(o,y){l(o,n,y)},p:et,d(o){o&&a(n)}}}function Rt($){let n,h='💡 Se vuoi caricare il modello in maniera automatica all’Hub durante l’addestramento, puoi passare <code>PushToHubCallback</code> al metodo <code>model.fit()</code>. Maggiori dettagli verranno forniti nel <a href="/course/chapter4/3">Capitolo 4</a>';return{c(){n=f("p"),n.innerHTML=h},l(o){n=M(o,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1b5s7xj"&&(n.innerHTML=h)},m(o,y){l(o,n,y)},p:et,d(o){o&&a(n)}}}function Wt($){let n,h,o,y,J,pe,z,me,g,de,G,tt='Dopo tutto il lavoro di preprocessing nella sezione precedente, rimangono giusto gli ultimi passi per addestrare il modello. Attenzione tuttavia che il comando <code>model.fit()</code> sarà molto lento su una CPU. Se non avete una GPU a disposizione, potete avere accesso gratuitamente a GPU o TPU su <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',ce,Z,at="Gli esempi di codice qui sotto partono dal presupposto che gli esempi nella sezione precedente siano già stati eseguiti. Ecco un breve riassunto di cosa serve:",ue,_,fe,C,Me,k,lt="I modelli di TensorFlow importati da 🤗 Transformers sono già dei modelli Keras. Ecco una breve introduzione a Keras.",be,I,he,X,st="Ciò significa che una volta che si hanno i dati, è richiesto poco lavoro aggiuntivo per cominciare l’addestramento.",ye,R,$e,W,it='Come nel <a href="/course/chapter2">capitolo precedente</a>, verrà utilizzata la classe <code>TFAutoModelForSequenceClassification</code> con due etichette:',we,F,Je,Q,nt='Diversamente dal <a href="/course/chapter2">Capitolo 2</a>, un avviso di avvertimento verrà visualizzato dopo aver istanziato questo modello pre-addestrato. Ciò avviene perché BERT non è stato pre-addestrato per classificare coppie di frasi, quindi la testa del modello pre-addestrato viene scartata e una nuova testa adeguata per il compito di classificazione di sequenze è stata inserita. Gli avvertimenti indicano che alcuni pesi non verranno usati (quelli corrispondenti alla testa scartata del modello pre-addestrato) e che altri pesi sono stati inizializzati con valori casuali (quelli per la nuova testa). L’avvertimento viene concluso con un’esortazione ad addestrare il modello, che è esattamente ciò che stiamo per fare.',Te,V,ot="Per affinare il modello sul dataset, bisogna solo chiamare <code>compile()</code> (compila) sul modello e passare i dati al metodo <code>fit()</code>. Ciò farà partire il processo di affinamento (che dovrebbe richiedere un paio di minuti su una GPU) e fare il report della funzione obiettivo di addestramento, in aggiunta alla funzione obiettivo di validazione alla fine di ogni epoca.",Ue,T,je,Y,ve,U,ze,H,ge,B,Ge,x,rt="Il codice presentato qui sopra sicuramente funziona, ma la funzione obiettivo scende in maniera molto lenta e sporadica. La causa principale di ciò è la <em>learning rate</em> (tasso di apprendimento). Come con la funzione obiettivo, quando si passa il nome di un ottimizzatore a Keras tramite una stringa, Keras inizializza quell’ottimizzatore con i valori di default per tutti i parametri, inclusa la learning rate. Grazie alla nostra esperienza, però, sappiamo che i modelli transformer beneficiano da una learning rate molto più bassa del valore di default per Adam, che è 1e-3, scritto anche come 10 alla -3, o 0.001. Il valore 5e-5 (0.00005), circa venti volte più basso, è un punto di partenza migliore.",Ze,N,pt="In aggiunta a diminuire la learning rate, abbiamo un secondo asso nella manica: possiamo ridurre lentamente la learning rate durante l’addestramento. Nella letteratura, questo approccio viene spesso indicato come <em>decaying</em> (decadimento) o <em>annealing</em> (ricottura) della learning rate. In Keras, il modo migliore per ottenere ciò è attraverso un <em>learning rate scheduler</em> (pianificatore del tasso di addestramento). Un buon esempio è <code>PolynomialDecay</code> (decadimento polinomiale) — nonostante il nome, con le impostazioni di default ha un semplice decadimento lineare dal valore iniziale a quello finale durante l’addestramento, che è esattamente ciò che cerchiamo. Per utilizzare lo scheduler in maniera corretta, però, bisogna dirgli quanto lungo sarà l’addestramento. Lo calcoliamo tramite la variabile <code>num_train_steps</code> nell’esempio qui sotto.",_e,q,Ce,j,ke,E,mt="Adesso che abbiamo il nostro ottimizzatore nuovo di zecca, possiamo provare con un addestramento. Per prima cosa, ricarichiamo il modello, per resettare i cambiamenti ai pesi dall’addestramento precedente, dopodiché lo possiamo compilare con nuovo ottimizzatore.",Ie,S,Xe,A,dt="Ora chiamiamo di nuovo fit",Re,P,We,v,Fe,L,Qe,D,Ve,K,ct="Vedere la funzione obiettivo che diminuisce durante l’addestramento è bello, ma se volessimo ottenere dei risultati dal modello addestrato, ad esempio per calcolare delle metriche o per usare il modello in produzione? Per questo, si può usare il metodo <code>predict()</code>. Questo metodo restituisce i `<em>logits</em> dalla testa del modello, uno per classe.",Ye,O,He,ee,ut="I logits possono essere convertiti nelle predizioni delle classi del modello usando <code>argmax</code> per trovare il logit più grande, che corrisponde alla classe più probabile.",Be,te,xe,ae,Ne,le,ft="Ora usiamo le <code>preds</code> per calcolare delle metriche! Si possono caricare le metriche associate al dataset MRPC in maniera facile tanto quanto caricare il dataset in sé, usando la funzione <code>load_metric()</code>. L’oggetto restituito ha un metodo <code>compute()</code> che può essere usato per calcolare le metriche.",qe,se,Ee,ie,Se,ne,Mt='L’esatto valore dei risultati ottenuti può variare, poiché l’inizializzazione casuale della testa del modello può cambiare le metriche ottenute. Qui vediamo che il nostro modello ha una accuratezza del 87.78% sul validation set e valore F1 di 89.97. Queste sono le due metriche utilizzare per valutare risultati sul dataset MRPC per il benchmark GLUE. La tabella nell’<a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">articolo du BERT</a> riportava un valore F1 di 88.9 per il modello di base. Quello era il modello <code>uncased</code>, mentre qui stiamo usando il modello <code>cased</code>, il che spiega i migliori risultati.',Ae,oe,bt="Questo conclude l’introduzione all’affinamento usando l’API Keras. Un esempio per i compiti di NLP più comuni verrà fornito nel Capitolo 7. Per migliorare le vostre abilità con l’API Keras, provate ad affinare un modello sul dataset GLUE SST-2, usando il processing dei dati spiegato nella sezione 2.",Pe,re,Le;return J=new Ct({props:{fw:$[0]}}),z=new Oe({props:{title:"Affinare un modell usando Keras",local:"affinare-un-modell-usando-keras",headingTag:"h1"}}),g=new _t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter3/section3_tf.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter3/section3_tf.ipynb"}]}}),_=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQXRmX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC50b190Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJhdHRlbnRpb25fbWFzayUyMiUyQyUyMCUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfY29scyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSklMEElMEF0Zl92YWxpZGF0aW9uX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVELnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)

data_collator = DataCollatorWithPadding(tokenizer=tokenizer, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

tf_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].to_tf_dataset(
    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
    shuffle=<span class="hljs-literal">True</span>,
    collate_fn=data_collator,
    batch_size=<span class="hljs-number">8</span>,
)

tf_validation_dataset = tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>].to_tf_dataset(
    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
    shuffle=<span class="hljs-literal">False</span>,
    collate_fn=data_collator,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),C=new Oe({props:{title:"Addestramento",local:"addestramento",headingTag:"h3"}}),I=new Ke({props:{id:"rnTGBy2ax1c"}}),R=new Ke({props:{id:"AUozVp78dhk"}}),F=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),T=new De({props:{$$slots:{default:[kt]},$$scope:{ctx:$}}}),Y=new w({props:{code:"ZnJvbSUyMHRlbnNvcmZsb3cua2VyYXMubG9zc2VzJTIwaW1wb3J0JTIwU3BhcnNlQ2F0ZWdvcmljYWxDcm9zc2VudHJvcHklMEElMEFtb2RlbC5jb21waWxlKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRCUyMmFkYW0lMjIlMkMlMEElMjAlMjAlMjAlMjBsb3NzJTNEU3BhcnNlQ2F0ZWdvcmljYWxDcm9zc2VudHJvcHkoZnJvbV9sb2dpdHMlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY3MlM0QlNUIlMjJhY2N1cmFjeSUyMiU1RCUyQyUwQSklMEFtb2RlbC5maXQoJTBBJTIwJTIwJTIwJTIwdGZfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHZhbGlkYXRpb25fZGF0YSUzRHRmX3ZhbGlkYXRpb25fZGF0YXNldCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tensorflow.keras.losses <span class="hljs-keyword">import</span> SparseCategoricalCrossentropy

model.<span class="hljs-built_in">compile</span>(
    optimizer=<span class="hljs-string">&quot;adam&quot;</span>,
    loss=SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
    metrics=[<span class="hljs-string">&quot;accuracy&quot;</span>],
)
model.fit(
    tf_train_dataset,
    validation_data=tf_validation_dataset,
)`,wrap:!1}}),U=new De({props:{warning:!0,$$slots:{default:[It]},$$scope:{ctx:$}}}),H=new Oe({props:{title:"Migliorare la performance di addestramento",local:"migliorare-la-performance-di-addestramento",headingTag:"h3"}}),B=new Ke({props:{id:"cpzq6ESSM5c"}}),q=new w({props:{code:"ZnJvbSUyMHRlbnNvcmZsb3cua2VyYXMub3B0aW1pemVycy5zY2hlZHVsZXMlMjBpbXBvcnQlMjBQb2x5bm9taWFsRGVjYXklMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwOCUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBJTIzJTIwVGhlJTIwbnVtYmVyJTIwb2YlMjB0cmFpbmluZyUyMHN0ZXBzJTIwaXMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHNhbXBsZXMlMjBpbiUyMHRoZSUyMGRhdGFzZXQlMkMlMjBkaXZpZGVkJTIwYnklMjB0aGUlMjBiYXRjaCUyMHNpemUlMjB0aGVuJTIwbXVsdGlwbGllZCUwQSUyMyUyMGJ5JTIwdGhlJTIwdG90YWwlMjBudW1iZXIlMjBvZiUyMGVwb2Nocy4lMjBOb3RlJTIwdGhhdCUyMHRoZSUyMHRmX3RyYWluX2RhdGFzZXQlMjBoZXJlJTIwaXMlMjBhJTIwYmF0Y2hlZCUyMHRmLmRhdGEuRGF0YXNldCUyQyUwQSUyMyUyMG5vdCUyMHRoZSUyMG9yaWdpbmFsJTIwSHVnZ2luZyUyMEZhY2UlMjBEYXRhc2V0JTJDJTIwc28lMjBpdHMlMjBsZW4oKSUyMGlzJTIwYWxyZWFkeSUyMG51bV9zYW1wbGVzJTIwJTJGJTJGJTIwYmF0Y2hfc2l6ZS4lMEFudW1fdHJhaW5fc3RlcHMlMjAlM0QlMjBsZW4odGZfdHJhaW5fZGF0YXNldCklMjAqJTIwbnVtX2Vwb2NocyUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMFBvbHlub21pYWxEZWNheSglMEElMjAlMjAlMjAlMjBpbml0aWFsX2xlYXJuaW5nX3JhdGUlM0Q1ZS01JTJDJTIwZW5kX2xlYXJuaW5nX3JhdGUlM0QwLjAlMkMlMjBkZWNheV9zdGVwcyUzRG51bV90cmFpbl9zdGVwcyUwQSklMEFmcm9tJTIwdGVuc29yZmxvdy5rZXJhcy5vcHRpbWl6ZXJzJTIwaW1wb3J0JTIwQWRhbSUwQSUwQW9wdCUyMCUzRCUyMEFkYW0obGVhcm5pbmdfcmF0ZSUzRGxyX3NjaGVkdWxlcik=",highlighted:`<span class="hljs-keyword">from</span> tensorflow.keras.optimizers.schedules <span class="hljs-keyword">import</span> PolynomialDecay

batch_size = <span class="hljs-number">8</span>
num_epochs = <span class="hljs-number">3</span>
<span class="hljs-comment"># The number of training steps is the number of samples in the dataset, divided by the batch size then multiplied</span>
<span class="hljs-comment"># by the total number of epochs. Note that the tf_train_dataset here is a batched tf.data.Dataset,</span>
<span class="hljs-comment"># not the original Hugging Face Dataset, so its len() is already num_samples // batch_size.</span>
num_train_steps = <span class="hljs-built_in">len</span>(tf_train_dataset) * num_epochs
lr_scheduler = PolynomialDecay(
    initial_learning_rate=<span class="hljs-number">5e-5</span>, end_learning_rate=<span class="hljs-number">0.0</span>, decay_steps=num_train_steps
)
<span class="hljs-keyword">from</span> tensorflow.keras.optimizers <span class="hljs-keyword">import</span> Adam

opt = Adam(learning_rate=lr_scheduler)`,wrap:!1}}),j=new De({props:{$$slots:{default:[Xt]},$$scope:{ctx:$}}}),S=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMG51bV9sYWJlbHMlM0QyKSUwQWxvc3MlMjAlM0QlMjB0Zi5rZXJhcy5sb3NzZXMuU3BhcnNlQ2F0ZWdvcmljYWxDcm9zc2VudHJvcHkoZnJvbV9sb2dpdHMlM0RUcnVlKSUwQW1vZGVsLmNvbXBpbGUob3B0aW1pemVyJTNEb3B0JTJDJTIwbG9zcyUzRGxvc3MlMkMlMjBtZXRyaWNzJTNEJTVCJTIyYWNjdXJhY3klMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
loss = tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>)
model.<span class="hljs-built_in">compile</span>(optimizer=opt, loss=loss, metrics=[<span class="hljs-string">&quot;accuracy&quot;</span>])`,wrap:!1}}),P=new w({props:{code:"bW9kZWwuZml0KHRmX3RyYWluX2RhdGFzZXQlMkMlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl92YWxpZGF0aW9uX2RhdGFzZXQlMkMlMjBlcG9jaHMlM0QzKQ==",highlighted:'model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)',wrap:!1}}),v=new De({props:{$$slots:{default:[Rt]},$$scope:{ctx:$}}}),L=new Oe({props:{title:"Predizioni del modello",local:"predizioni-del-modello",headingTag:"h3"}}),D=new Ke({props:{id:"nx10eh4CoOs"}}),O=new w({props:{code:"cHJlZHMlMjAlM0QlMjBtb2RlbC5wcmVkaWN0KHRmX3ZhbGlkYXRpb25fZGF0YXNldCklNUIlMjJsb2dpdHMlMjIlNUQ=",highlighted:'preds = model.predict(tf_validation_dataset)[<span class="hljs-string">&quot;logits&quot;</span>]',wrap:!1}}),te=new w({props:{code:"Y2xhc3NfcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZHMlMkMlMjBheGlzJTNEMSklMEFwcmludChwcmVkcy5zaGFwZSUyQyUyMGNsYXNzX3ByZWRzLnNoYXBlKQ==",highlighted:`class_preds = np.argmax(preds, axis=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(preds.shape, class_preds.shape)`,wrap:!1}}),ae=new w({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),se=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRGNsYXNzX3ByZWRzJTJDJTIwcmVmZXJlbmNlcyUzRHJhd19kYXRhc2V0cyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlNUIlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=class_preds, references=raw_datasets[<span class="hljs-string">&quot;validation&quot;</span>][<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),ie=new w({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),{c(){n=f("meta"),h=s(),o=f("p"),y=s(),r(J.$$.fragment),pe=s(),r(z.$$.fragment),me=s(),r(g.$$.fragment),de=s(),G=f("p"),G.innerHTML=tt,ce=s(),Z=f("p"),Z.textContent=at,ue=s(),r(_.$$.fragment),fe=s(),r(C.$$.fragment),Me=s(),k=f("p"),k.textContent=lt,be=s(),r(I.$$.fragment),he=s(),X=f("p"),X.textContent=st,ye=s(),r(R.$$.fragment),$e=s(),W=f("p"),W.innerHTML=it,we=s(),r(F.$$.fragment),Je=s(),Q=f("p"),Q.innerHTML=nt,Te=s(),V=f("p"),V.innerHTML=ot,Ue=s(),r(T.$$.fragment),je=s(),r(Y.$$.fragment),ve=s(),r(U.$$.fragment),ze=s(),r(H.$$.fragment),ge=s(),r(B.$$.fragment),Ge=s(),x=f("p"),x.innerHTML=rt,Ze=s(),N=f("p"),N.innerHTML=pt,_e=s(),r(q.$$.fragment),Ce=s(),r(j.$$.fragment),ke=s(),E=f("p"),E.textContent=mt,Ie=s(),r(S.$$.fragment),Xe=s(),A=f("p"),A.textContent=dt,Re=s(),r(P.$$.fragment),We=s(),r(v.$$.fragment),Fe=s(),r(L.$$.fragment),Qe=s(),r(D.$$.fragment),Ve=s(),K=f("p"),K.innerHTML=ct,Ye=s(),r(O.$$.fragment),He=s(),ee=f("p"),ee.innerHTML=ut,Be=s(),r(te.$$.fragment),xe=s(),r(ae.$$.fragment),Ne=s(),le=f("p"),le.innerHTML=ft,qe=s(),r(se.$$.fragment),Ee=s(),r(ie.$$.fragment),Se=s(),ne=f("p"),ne.innerHTML=Mt,Ae=s(),oe=f("p"),oe.textContent=bt,Pe=s(),re=f("p"),this.h()},l(e){const t=Gt("svelte-u9bgzb",document.head);n=M(t,"META",{name:!0,content:!0}),t.forEach(a),h=i(e),o=M(e,"P",{}),Tt(o).forEach(a),y=i(e),p(J.$$.fragment,e),pe=i(e),p(z.$$.fragment,e),me=i(e),p(g.$$.fragment,e),de=i(e),G=M(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-mazm0f"&&(G.innerHTML=tt),ce=i(e),Z=M(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-11al6ht"&&(Z.textContent=at),ue=i(e),p(_.$$.fragment,e),fe=i(e),p(C.$$.fragment,e),Me=i(e),k=M(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-29hd6y"&&(k.textContent=lt),be=i(e),p(I.$$.fragment,e),he=i(e),X=M(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-t32qum"&&(X.textContent=st),ye=i(e),p(R.$$.fragment,e),$e=i(e),W=M(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-rpqwya"&&(W.innerHTML=it),we=i(e),p(F.$$.fragment,e),Je=i(e),Q=M(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-12uqbjy"&&(Q.innerHTML=nt),Te=i(e),V=M(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-elvb6f"&&(V.innerHTML=ot),Ue=i(e),p(T.$$.fragment,e),je=i(e),p(Y.$$.fragment,e),ve=i(e),p(U.$$.fragment,e),ze=i(e),p(H.$$.fragment,e),ge=i(e),p(B.$$.fragment,e),Ge=i(e),x=M(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-14aoo6j"&&(x.innerHTML=rt),Ze=i(e),N=M(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1jd05ug"&&(N.innerHTML=pt),_e=i(e),p(q.$$.fragment,e),Ce=i(e),p(j.$$.fragment,e),ke=i(e),E=M(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-oxsztq"&&(E.textContent=mt),Ie=i(e),p(S.$$.fragment,e),Xe=i(e),A=M(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-8qduz1"&&(A.textContent=dt),Re=i(e),p(P.$$.fragment,e),We=i(e),p(v.$$.fragment,e),Fe=i(e),p(L.$$.fragment,e),Qe=i(e),p(D.$$.fragment,e),Ve=i(e),K=M(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1xxp91"&&(K.innerHTML=ct),Ye=i(e),p(O.$$.fragment,e),He=i(e),ee=M(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-1ylry8s"&&(ee.innerHTML=ut),Be=i(e),p(te.$$.fragment,e),xe=i(e),p(ae.$$.fragment,e),Ne=i(e),le=M(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-oorxl5"&&(le.innerHTML=ft),qe=i(e),p(se.$$.fragment,e),Ee=i(e),p(ie.$$.fragment,e),Se=i(e),ne=M(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-nmfkbr"&&(ne.innerHTML=Mt),Ae=i(e),oe=M(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1xhes2n"&&(oe.textContent=bt),Pe=i(e),re=M(e,"P",{}),Tt(re).forEach(a),this.h()},h(){Ut(n,"name","hf:doc:metadata"),Ut(n,"content",Ft)},m(e,t){Zt(document.head,n),l(e,h,t),l(e,o,t),l(e,y,t),m(J,e,t),l(e,pe,t),m(z,e,t),l(e,me,t),m(g,e,t),l(e,de,t),l(e,G,t),l(e,ce,t),l(e,Z,t),l(e,ue,t),m(_,e,t),l(e,fe,t),m(C,e,t),l(e,Me,t),l(e,k,t),l(e,be,t),m(I,e,t),l(e,he,t),l(e,X,t),l(e,ye,t),m(R,e,t),l(e,$e,t),l(e,W,t),l(e,we,t),m(F,e,t),l(e,Je,t),l(e,Q,t),l(e,Te,t),l(e,V,t),l(e,Ue,t),m(T,e,t),l(e,je,t),m(Y,e,t),l(e,ve,t),m(U,e,t),l(e,ze,t),m(H,e,t),l(e,ge,t),m(B,e,t),l(e,Ge,t),l(e,x,t),l(e,Ze,t),l(e,N,t),l(e,_e,t),m(q,e,t),l(e,Ce,t),m(j,e,t),l(e,ke,t),l(e,E,t),l(e,Ie,t),m(S,e,t),l(e,Xe,t),l(e,A,t),l(e,Re,t),m(P,e,t),l(e,We,t),m(v,e,t),l(e,Fe,t),m(L,e,t),l(e,Qe,t),m(D,e,t),l(e,Ve,t),l(e,K,t),l(e,Ye,t),m(O,e,t),l(e,He,t),l(e,ee,t),l(e,Be,t),m(te,e,t),l(e,xe,t),m(ae,e,t),l(e,Ne,t),l(e,le,t),l(e,qe,t),m(se,e,t),l(e,Ee,t),m(ie,e,t),l(e,Se,t),l(e,ne,t),l(e,Ae,t),l(e,oe,t),l(e,Pe,t),l(e,re,t),Le=!0},p(e,[t]){const ht={};t&1&&(ht.fw=e[0]),J.$set(ht);const yt={};t&2&&(yt.$$scope={dirty:t,ctx:e}),T.$set(yt);const $t={};t&2&&($t.$$scope={dirty:t,ctx:e}),U.$set($t);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),j.$set(wt);const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),v.$set(Jt)},i(e){Le||(d(J.$$.fragment,e),d(z.$$.fragment,e),d(g.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(T.$$.fragment,e),d(Y.$$.fragment,e),d(U.$$.fragment,e),d(H.$$.fragment,e),d(B.$$.fragment,e),d(q.$$.fragment,e),d(j.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(v.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),Le=!0)},o(e){c(J.$$.fragment,e),c(z.$$.fragment,e),c(g.$$.fragment,e),c(_.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(T.$$.fragment,e),c(Y.$$.fragment,e),c(U.$$.fragment,e),c(H.$$.fragment,e),c(B.$$.fragment,e),c(q.$$.fragment,e),c(j.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(v.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),Le=!1},d(e){e&&(a(h),a(o),a(y),a(pe),a(me),a(de),a(G),a(ce),a(Z),a(ue),a(fe),a(Me),a(k),a(be),a(he),a(X),a(ye),a($e),a(W),a(we),a(Je),a(Q),a(Te),a(V),a(Ue),a(je),a(ve),a(ze),a(ge),a(Ge),a(x),a(Ze),a(N),a(_e),a(Ce),a(ke),a(E),a(Ie),a(Xe),a(A),a(Re),a(We),a(Fe),a(Qe),a(Ve),a(K),a(Ye),a(He),a(ee),a(Be),a(xe),a(Ne),a(le),a(qe),a(Ee),a(Se),a(ne),a(Ae),a(oe),a(Pe),a(re)),a(n),u(J,e),u(z,e),u(g,e),u(_,e),u(C,e),u(I,e),u(R,e),u(F,e),u(T,e),u(Y,e),u(U,e),u(H,e),u(B,e),u(q,e),u(j,e),u(S,e),u(P,e),u(v,e),u(L,e),u(D,e),u(O,e),u(te,e),u(ae,e),u(se,e),u(ie,e)}}}const Ft='{"title":"Affinare un modell usando Keras","local":"affinare-un-modell-usando-keras","sections":[{"title":"Addestramento","local":"addestramento","sections":[],"depth":3},{"title":"Migliorare la performance di addestramento","local":"migliorare-la-performance-di-addestramento","sections":[],"depth":3},{"title":"Predizioni del modello","local":"predizioni-del-modello","sections":[],"depth":3}],"depth":1}';function Qt($,n,h){let o="pt";return vt(()=>{const y=new URLSearchParams(window.location.search);h(0,o=y.get("fw")||"pt")}),[o]}class St extends zt{constructor(n){super(),gt(this,n,Qt,Wt,jt,{})}}export{St as component};
