import{s as pe,n as me,o as ge}from"../chunks/scheduler.9bc65507.js";import{S as ye,i as be,g as l,s as o,r as le,A as we,h as n,f as s,c as i,j as ne,u as re,x as r,k as Y,y as ve,a,v as de,d as ce,t as he,w as fe}from"../chunks/index.707bf1b6.js";import{H as ue,g as _e}from"../chunks/Heading.98cce615.js";function xe(B){let d,C,L,P,h,H,f,D="🤗 Transformers is an opinionated library built for:",$,u,G="<li>machine learning researchers and educators seeking to use, study or extend large-scale Transformers models.</li> <li>hands-on practitioners who want to fine-tune those models or serve them in production, or both.</li> <li>engineers who just want to download a pretrained model and use it to solve a given machine learning task.</li>",A,p,J="The library was designed with two strong goals in mind:",j,m,X="<li>Be as easy and fast to use as possible:</li>",z,g,Q=`<li>We strongly limited the number of user-facing abstractions to learn, in fact, there are almost no abstractions,
just three standard classes required to use each model: <a href="main_classes/configuration">configuration</a>,
<a href="main_classes/model">models</a>, and a preprocessing class (<a href="main_classes/tokenizer">tokenizer</a> for NLP, <a href="main_classes/image_processor">image processor</a> for vision, <a href="main_classes/feature_extractor">feature extractor</a> for audio, and <a href="main_classes/processors">processor</a> for multimodal inputs).</li> <li>All of these classes can be initialized in a simple and unified way from pretrained instances by using a common
<code>from_pretrained()</code> method which downloads (if needed), caches and
loads the related class instance and associated data (configurations’ hyperparameters, tokenizers’ vocabulary,
and models’ weights) from a pretrained checkpoint provided on <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> or your own saved checkpoint.</li> <li>On top of those three base classes, the library provides two APIs: <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for quickly
using a model for inference on a given task and <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> to quickly train or fine-tune a PyTorch model (all TensorFlow models are compatible with <code>Keras.fit</code>).</li> <li>As a consequence, this library is NOT a modular toolbox of building blocks for neural nets. If you want to
extend or build upon the library, just use regular Python, PyTorch, TensorFlow, Keras modules and inherit from the base
classes of the library to reuse functionalities like model loading and saving. If you’d like to learn more about our coding philosophy for models, check out our <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">Repeat Yourself</a> blog post.</li>`,I,c,V="<li>Provide state-of-the-art models with performances as close as possible to the original models:</li>",q,y,Z=`<li>We provide at least one example for each architecture which reproduces a result provided by the official authors
of said architecture.</li> <li>The code is usually as close to the original code base as possible which means some PyTorch code may be not as
<em>pytorchic</em> as it could be as a result of being converted TensorFlow code and vice versa.</li>`,F,b,ee="A few other goals:",U,w,te="<li><p>Expose the models’ internals as consistently as possible:</p> <ul><li>We give access, using a single API, to the full hidden-states and attention weights.</li> <li>The preprocessing classes and base model APIs are standardized to easily switch between models.</li></ul></li> <li><p>Incorporate a subjective selection of promising tools for fine-tuning and investigating these models:</p> <ul><li>A simple and consistent way to add new tokens to the vocabulary and embeddings for fine-tuning.</li> <li>Simple ways to mask and prune Transformer heads.</li></ul></li> <li><p>Easily switch between PyTorch, TensorFlow 2.0 and Flax, allowing training with one framework and inference with another.</p></li>",E,v,O,_,se="The library is built around three types of classes for each model:",S,x,ae='<li><strong>Model classes</strong> can be PyTorch models (<a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a>), Keras models (<a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a>) or JAX/Flax models (<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen.html" rel="nofollow">flax.linen.Module</a>) that work with the pretrained weights provided in the library.</li> <li><strong>Configuration classes</strong> store the hyperparameters required to build a model (such as the number of layers and hidden size). You don’t always need to instantiate these yourself. In particular, if you are using a pretrained model without any modification, creating the model will automatically take care of instantiating the configuration (which is part of the model).</li> <li><strong>Preprocessing classes</strong> convert the raw data into a format accepted by the model. A <a href="main_classes/tokenizer">tokenizer</a> stores the vocabulary for each model and provide methods for encoding and decoding strings in a list of token embedding indices to be fed to a model. <a href="main_classes/image_processor">Image processors</a> preprocess vision inputs, <a href="main_classes/feature_extractor">feature extractors</a> preprocess audio inputs, and a <a href="main_classes/processors">processor</a> handles multimodal inputs.</li>',K,T,oe="All these classes can be instantiated from pretrained instances, saved locally, and shared on the Hub with three methods:",W,M,ie=`<li><code>from_pretrained()</code> lets you instantiate a model, configuration, and preprocessing class from a pretrained version either
provided by the library itself (the supported models can be found on the <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>) or
stored locally (or on a server) by the user.</li> <li><code>save_pretrained()</code> lets you save a model, configuration, and preprocessing class locally so that it can be reloaded using
<code>from_pretrained()</code>.</li> <li><code>push_to_hub()</code> lets you share a model, configuration, and a preprocessing class to the Hub, so it is easily accessible to everyone.</li>`,N,k,R;return h=new ue({props:{title:"Philosophy",local:"philosophy",headingTag:"h1"}}),v=new ue({props:{title:"Main concepts",local:"main-concepts",headingTag:"h2"}}),{c(){d=l("meta"),C=o(),L=l("p"),P=o(),le(h.$$.fragment),H=o(),f=l("p"),f.textContent=D,$=o(),u=l("ul"),u.innerHTML=G,A=o(),p=l("p"),p.textContent=J,j=o(),m=l("ol"),m.innerHTML=X,z=o(),g=l("ul"),g.innerHTML=Q,I=o(),c=l("ol"),c.innerHTML=V,q=o(),y=l("ul"),y.innerHTML=Z,F=o(),b=l("p"),b.textContent=ee,U=o(),w=l("ul"),w.innerHTML=te,E=o(),le(v.$$.fragment),O=o(),_=l("p"),_.textContent=se,S=o(),x=l("ul"),x.innerHTML=ae,K=o(),T=l("p"),T.textContent=oe,W=o(),M=l("ul"),M.innerHTML=ie,N=o(),k=l("p"),this.h()},l(e){const t=we("svelte-u9bgzb",document.head);d=n(t,"META",{name:!0,content:!0}),t.forEach(s),C=i(e),L=n(e,"P",{}),ne(L).forEach(s),P=i(e),re(h.$$.fragment,e),H=i(e),f=n(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1p1j4j2"&&(f.textContent=D),$=i(e),u=n(e,"UL",{"data-svelte-h":!0}),r(u)!=="svelte-15p34re"&&(u.innerHTML=G),A=i(e),p=n(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-l3cofq"&&(p.textContent=J),j=i(e),m=n(e,"OL",{"data-svelte-h":!0}),r(m)!=="svelte-a039tw"&&(m.innerHTML=X),z=i(e),g=n(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1g7s4j4"&&(g.innerHTML=Q),I=i(e),c=n(e,"OL",{start:!0,"data-svelte-h":!0}),r(c)!=="svelte-1j3ty0h"&&(c.innerHTML=V),q=i(e),y=n(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-eaof5h"&&(y.innerHTML=Z),F=i(e),b=n(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-16fl7yl"&&(b.textContent=ee),U=i(e),w=n(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-r5ixu4"&&(w.innerHTML=te),E=i(e),re(v.$$.fragment,e),O=i(e),_=n(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-60ebt4"&&(_.textContent=se),S=i(e),x=n(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-jd06a0"&&(x.innerHTML=ae),K=i(e),T=n(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ff8m9n"&&(T.textContent=oe),W=i(e),M=n(e,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-1p0er3n"&&(M.innerHTML=ie),N=i(e),k=n(e,"P",{}),ne(k).forEach(s),this.h()},h(){Y(d,"name","hf:doc:metadata"),Y(d,"content",Te),Y(c,"start","2")},m(e,t){ve(document.head,d),a(e,C,t),a(e,L,t),a(e,P,t),de(h,e,t),a(e,H,t),a(e,f,t),a(e,$,t),a(e,u,t),a(e,A,t),a(e,p,t),a(e,j,t),a(e,m,t),a(e,z,t),a(e,g,t),a(e,I,t),a(e,c,t),a(e,q,t),a(e,y,t),a(e,F,t),a(e,b,t),a(e,U,t),a(e,w,t),a(e,E,t),de(v,e,t),a(e,O,t),a(e,_,t),a(e,S,t),a(e,x,t),a(e,K,t),a(e,T,t),a(e,W,t),a(e,M,t),a(e,N,t),a(e,k,t),R=!0},p:me,i(e){R||(ce(h.$$.fragment,e),ce(v.$$.fragment,e),R=!0)},o(e){he(h.$$.fragment,e),he(v.$$.fragment,e),R=!1},d(e){e&&(s(C),s(L),s(P),s(H),s(f),s($),s(u),s(A),s(p),s(j),s(m),s(z),s(g),s(I),s(c),s(q),s(y),s(F),s(b),s(U),s(w),s(E),s(O),s(_),s(S),s(x),s(K),s(T),s(W),s(M),s(N),s(k)),s(d),fe(h,e),fe(v,e)}}}const Te='{"title":"Philosophy","local":"philosophy","sections":[{"title":"Main concepts","local":"main-concepts","sections":[],"depth":2}],"depth":1}';function Me(B){return ge(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=_e}),[]}class Pe extends ye{constructor(d){super(),be(this,d,Me,xe,pe,{})}}export{Pe as component};
