import{s as Ot,n as Vt,o as Nt}from"../chunks/scheduler.9039eef2.js";import{S as Ut,i as Ft,g as n,s as l,r as m,A as St,h as o,f as r,c as a,j as f,u,x as p,k as z,y as t,a as s,v as c,d as _,t as h,w as g}from"../chunks/index.cdcc3d35.js";import{D as x}from"../chunks/Docstring.fff63cfc.js";import{H as ve}from"../chunks/Heading.96ce3702.js";function Wt(_t){let T,xe,$e,Pe,I,Te,q,ht="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",we,O,ke,V,gt="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Ce,N,Me,U,bt="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",Le,d,F,Be,le,ft="Base abstract class that handles model parallelism.",Re,k,S,Xe,ae,zt=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Ge,P,W,Je,ie,vt=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Qe,ne,$t=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Ye,y,A,Ze,oe,yt="Creates an optimizer ready for a parallelized model from an existing optimizer.",et,se,xt="There are two cases:",tt,de,Pt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,rt,pe,K,lt,me,j,De,B,Ee,R,Tt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",He,v,X,at,C,G,it,ue,wt="Provides the list of supported model types for parallelization.",nt,M,J,ot,ce,kt="Returns <code>True</code> if the model can be parallelized, <code>False</code> otherwise.",st,L,Q,dt,_e,Ct="Returns the parallelizer class associated to the model.",Ie,Y,qe,Z,Oe,ee,Mt="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Ve,$,te,pt,he,Lt="Context manager that makes the loading of a model lazy for model parallelism:",mt,ge,Dt=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,ut,be,Et="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",Ne,w,re,ct,fe,Ht=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Ue,ye,Fe;return I=new ve({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),O=new ve({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),N=new ve({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),F=new x({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L148"}}),S=new x({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"should_parallelize_layer_predicate_func",val:": Optional = None"},{name:"**parallel_layer_specific_kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.should_parallelize_layer_predicate_func",description:`<strong>should_parallelize_layer_predicate_func</strong> (Optional[Callable[[torch.nn.Module], bool]], defaults to <code>None</code>) &#x2014;
A function that takes a layer as input and returns a boolean specifying if the input layer should be
parallelized. This is useful to skip unnecessary parallelization, for pipeline parallelism for instance.`,name:"should_parallelize_layer_predicate_func"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.*parallel_layer_specific_kwargs",description:`*<strong>*parallel_layer_specific_kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Keyword arguments specific to some parallel layers, they will be ignored by the other parallel layers.`,name:"*parallel_layer_specific_kwargs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new x({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"kv_size_multiplier",val:": Optional = None"},{name:"pipeline_parallel_input_names",val:": Union = None"},{name:"pipeline_parallel_num_microbatches",val:": int = 1"},{name:"pipeline_parallel_use_zero1_optimizer",val:": bool = False"},{name:"pipeline_parallel_gradient_checkpointing_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"},{name:"num_ranks_per_loading_step",val:": int = -1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.kv_size_multiplier",description:`<strong>kv_size_multiplier</strong> (<code>Optional[int], defaults to </code>None\`) &#x2014;
The number of times to replicate the KV heads when the TP size is bigger than the number of KV heads.
If left unspecified, the smallest multiplier that makes the number of KV heads divisible by the TP size
will be used.`,name:"kv_size_multiplier"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_num_microbatches",description:`<strong>pipeline_parallel_num_microbatches</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of microbatches used for pipeline execution.`,name:"pipeline_parallel_num_microbatches"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_use_zero1_optimizer",description:`<strong>pipeline_parallel_use_zero1_optimizer</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When zero-1 optimizer is used, set this to True, so the PP model will understand that zero-1 optimizer
will handle data parallel gradient averaging.`,name:"pipeline_parallel_use_zero1_optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_gradient_checkpointing_enabled",description:`<strong>pipeline_parallel_gradient_checkpointing_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not gradient checkpointing should be enabled when doing pipeline parallelism.`,name:"pipeline_parallel_gradient_checkpointing_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.num_ranks_per_loading_step",description:`<strong>num_ranks_per_loading_step</strong> (<code>int</code>, defaults to <code>-1</code>) &#x2014;
Corresponds to the number of ranks that can initialize and load the model weights at the same time.
If the value is inferior to 0, the maximum number of ranks will be used.`,name:"num_ranks_per_loading_step"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L537",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),A=new x({props:{name:"optimizer_for_mp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),K=new x({props:{name:"save_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"output_dir",val:": Union"},{name:"as_regular",val:": bool = False"},{name:"as_sharded",val:": bool = True"},{name:"optimizer",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L1014"}}),j=new x({props:{name:"load_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/base.py#L1046"}}),B=new ve({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),X=new x({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/parallelizers_manager.py#L52"}}),G=new x({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/parallelizers_manager.py#L65"}}),J=new x({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/parallelizers_manager.py#L85"}}),Q=new x({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/parallelizers_manager.py#L97"}}),Y=new ve({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Z=new ve({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),te=new x({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/utils.py#L1401"}}),re=new x({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.21/optimum/neuron/distributed/utils.py#L1447"}}),{c(){T=n("meta"),xe=l(),$e=n("p"),Pe=l(),m(I.$$.fragment),Te=l(),q=n("p"),q.innerHTML=ht,we=l(),m(O.$$.fragment),ke=l(),V=n("p"),V.innerHTML=gt,Ce=l(),m(N.$$.fragment),Me=l(),U=n("p"),U.innerHTML=bt,Le=l(),d=n("div"),m(F.$$.fragment),Be=l(),le=n("p"),le.textContent=ft,Re=l(),k=n("div"),m(S.$$.fragment),Xe=l(),ae=n("p"),ae.textContent=zt,Ge=l(),P=n("div"),m(W.$$.fragment),Je=l(),ie=n("p"),ie.innerHTML=vt,Qe=l(),ne=n("p"),ne.textContent=$t,Ye=l(),y=n("div"),m(A.$$.fragment),Ze=l(),oe=n("p"),oe.textContent=yt,et=l(),se=n("p"),se.textContent=xt,tt=l(),de=n("ol"),de.innerHTML=Pt,rt=l(),pe=n("div"),m(K.$$.fragment),lt=l(),me=n("div"),m(j.$$.fragment),De=l(),m(B.$$.fragment),Ee=l(),R=n("p"),R.innerHTML=Tt,He=l(),v=n("div"),m(X.$$.fragment),at=l(),C=n("div"),m(G.$$.fragment),it=l(),ue=n("p"),ue.textContent=wt,nt=l(),M=n("div"),m(J.$$.fragment),ot=l(),ce=n("p"),ce.innerHTML=kt,st=l(),L=n("div"),m(Q.$$.fragment),dt=l(),_e=n("p"),_e.textContent=Ct,Ie=l(),m(Y.$$.fragment),qe=l(),m(Z.$$.fragment),Oe=l(),ee=n("p"),ee.textContent=Mt,Ve=l(),$=n("div"),m(te.$$.fragment),pt=l(),he=n("p"),he.textContent=Lt,mt=l(),ge=n("ul"),ge.innerHTML=Dt,ut=l(),be=n("p"),be.innerHTML=Et,Ne=l(),w=n("div"),m(re.$$.fragment),ct=l(),fe=n("p"),fe.textContent=Ht,Ue=l(),ye=n("p"),this.h()},l(e){const i=St("svelte-u9bgzb",document.head);T=o(i,"META",{name:!0,content:!0}),i.forEach(r),xe=a(e),$e=o(e,"P",{}),f($e).forEach(r),Pe=a(e),u(I.$$.fragment,e),Te=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-it0u39"&&(q.innerHTML=ht),we=a(e),u(O.$$.fragment,e),ke=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-5ss4zj"&&(V.innerHTML=gt),Ce=a(e),u(N.$$.fragment,e),Me=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1bsvcro"&&(U.innerHTML=bt),Le=a(e),d=o(e,"DIV",{class:!0});var b=f(d);u(F.$$.fragment,b),Be=a(b),le=o(b,"P",{"data-svelte-h":!0}),p(le)!=="svelte-h4ipsc"&&(le.textContent=ft),Re=a(b),k=o(b,"DIV",{class:!0});var Se=f(k);u(S.$$.fragment,Se),Xe=a(Se),ae=o(Se,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1e0iews"&&(ae.textContent=zt),Se.forEach(r),Ge=a(b),P=o(b,"DIV",{class:!0});var ze=f(P);u(W.$$.fragment,ze),Je=a(ze),ie=o(ze,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1ytdrar"&&(ie.innerHTML=vt),Qe=a(ze),ne=o(ze,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-3oskg6"&&(ne.textContent=$t),ze.forEach(r),Ye=a(b),y=o(b,"DIV",{class:!0});var D=f(y);u(A.$$.fragment,D),Ze=a(D),oe=o(D,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-gytsrb"&&(oe.textContent=yt),et=a(D),se=o(D,"P",{"data-svelte-h":!0}),p(se)!=="svelte-k6ubrx"&&(se.textContent=xt),tt=a(D),de=o(D,"OL",{"data-svelte-h":!0}),p(de)!=="svelte-ogaf4b"&&(de.innerHTML=Pt),D.forEach(r),rt=a(b),pe=o(b,"DIV",{class:!0});var It=f(pe);u(K.$$.fragment,It),It.forEach(r),lt=a(b),me=o(b,"DIV",{class:!0});var qt=f(me);u(j.$$.fragment,qt),qt.forEach(r),b.forEach(r),De=a(e),u(B.$$.fragment,e),Ee=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1x1mrd0"&&(R.innerHTML=Tt),He=a(e),v=o(e,"DIV",{class:!0});var E=f(v);u(X.$$.fragment,E),at=a(E),C=o(E,"DIV",{class:!0});var We=f(C);u(G.$$.fragment,We),it=a(We),ue=o(We,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-esrxt2"&&(ue.textContent=wt),We.forEach(r),nt=a(E),M=o(E,"DIV",{class:!0});var Ae=f(M);u(J.$$.fragment,Ae),ot=a(Ae),ce=o(Ae,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1bapgxn"&&(ce.innerHTML=kt),Ae.forEach(r),st=a(E),L=o(E,"DIV",{class:!0});var Ke=f(L);u(Q.$$.fragment,Ke),dt=a(Ke),_e=o(Ke,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-3qe9b8"&&(_e.textContent=Ct),Ke.forEach(r),E.forEach(r),Ie=a(e),u(Y.$$.fragment,e),qe=a(e),u(Z.$$.fragment,e),Oe=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-4ddlue"&&(ee.textContent=Mt),Ve=a(e),$=o(e,"DIV",{class:!0});var H=f($);u(te.$$.fragment,H),pt=a(H),he=o(H,"P",{"data-svelte-h":!0}),p(he)!=="svelte-bh7x4"&&(he.textContent=Lt),mt=a(H),ge=o(H,"UL",{"data-svelte-h":!0}),p(ge)!=="svelte-1j7gypf"&&(ge.innerHTML=Dt),ut=a(H),be=o(H,"P",{"data-svelte-h":!0}),p(be)!=="svelte-oha5tr"&&(be.innerHTML=Et),H.forEach(r),Ne=a(e),w=o(e,"DIV",{class:!0});var je=f(w);u(re.$$.fragment,je),ct=a(je),fe=o(je,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1agud9l"&&(fe.textContent=Ht),je.forEach(r),Ue=a(e),ye=o(e,"P",{}),f(ye).forEach(r),this.h()},h(){z(T,"name","hf:doc:metadata"),z(T,"content",At),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,T),s(e,xe,i),s(e,$e,i),s(e,Pe,i),c(I,e,i),s(e,Te,i),s(e,q,i),s(e,we,i),c(O,e,i),s(e,ke,i),s(e,V,i),s(e,Ce,i),c(N,e,i),s(e,Me,i),s(e,U,i),s(e,Le,i),s(e,d,i),c(F,d,null),t(d,Be),t(d,le),t(d,Re),t(d,k),c(S,k,null),t(k,Xe),t(k,ae),t(d,Ge),t(d,P),c(W,P,null),t(P,Je),t(P,ie),t(P,Qe),t(P,ne),t(d,Ye),t(d,y),c(A,y,null),t(y,Ze),t(y,oe),t(y,et),t(y,se),t(y,tt),t(y,de),t(d,rt),t(d,pe),c(K,pe,null),t(d,lt),t(d,me),c(j,me,null),s(e,De,i),c(B,e,i),s(e,Ee,i),s(e,R,i),s(e,He,i),s(e,v,i),c(X,v,null),t(v,at),t(v,C),c(G,C,null),t(C,it),t(C,ue),t(v,nt),t(v,M),c(J,M,null),t(M,ot),t(M,ce),t(v,st),t(v,L),c(Q,L,null),t(L,dt),t(L,_e),s(e,Ie,i),c(Y,e,i),s(e,qe,i),c(Z,e,i),s(e,Oe,i),s(e,ee,i),s(e,Ve,i),s(e,$,i),c(te,$,null),t($,pt),t($,he),t($,mt),t($,ge),t($,ut),t($,be),s(e,Ne,i),s(e,w,i),c(re,w,null),t(w,ct),t(w,fe),s(e,Ue,i),s(e,ye,i),Fe=!0},p:Vt,i(e){Fe||(_(I.$$.fragment,e),_(O.$$.fragment,e),_(N.$$.fragment,e),_(F.$$.fragment,e),_(S.$$.fragment,e),_(W.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(j.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(G.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(Z.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),Fe=!0)},o(e){h(I.$$.fragment,e),h(O.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),Fe=!1},d(e){e&&(r(xe),r($e),r(Pe),r(Te),r(q),r(we),r(ke),r(V),r(Ce),r(Me),r(U),r(Le),r(d),r(De),r(Ee),r(R),r(He),r(v),r(Ie),r(qe),r(Oe),r(ee),r(Ve),r($),r(Ne),r(w),r(Ue),r(ye)),r(T),g(I,e),g(O,e),g(N,e),g(F),g(S),g(W),g(A),g(K),g(j),g(B,e),g(X),g(G),g(J),g(Q),g(Y,e),g(Z,e),g(te),g(re)}}}const At='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function Kt(_t){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends Ut{constructor(T){super(),Ft(this,T,Kt,Wt,Ot,{})}}export{Gt as component};
