import{s as Vt,o as Yt,n as Pt}from"../chunks/scheduler.924d507e.js";import{S as St,i as Dt,g as s,s as a,r as f,A as Kt,h as o,f as n,c as i,j as Nt,u as m,x as p,k as Ft,y as Ot,a as l,v as u,d,t as h,w as c}from"../chunks/index.0ece89e8.js";import{T as te}from"../chunks/Tip.a5ce8f1d.js";import{C as V}from"../chunks/CodeBlock.d01ac312.js";import{H as S}from"../chunks/Heading.c9bff43c.js";function ee(D){let r,J='LoftQ initialization does not require quantizing the base model with the <code>load_in_4bits</code> parameter in the <a href="https://huggingface.co/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method! Learn more about LoftQ initialization in the <a href="../conceptual_guides/lora#initialization-options">Initialization options</a> section.';return{c(){r=s("p"),r.innerHTML=J},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-w27f76"&&(r.innerHTML=J)},m(M,Y){l(M,r,Y)},p:Pt,d(M){M&&n(r)}}}function ne(D){let r,J,M,Y,b,K,w,qt="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",O,y,Bt='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li>',tt,g,zt='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',et,_,It="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",nt,$,lt,j,Zt='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.36.0/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',at,v,Lt="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",it,C,st,q,Ut='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',ot,B,rt,z,kt='Next, you should call the <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for traininng.',pt,I,ft,Z,Qt="Now that the quantized model is ready, let’s set up a configuration.",mt,L,ut,U,xt='Create a <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',dt,k,ht,Q,Wt='Then use the <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',ct,x,Mt,W,Et="You’re all set for training with whichever training method you prefer!",Tt,E,Jt,X,Xt='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, create a <code>LoftQConfig</code> and set <code>loftq_bits=4</code> for 4-bit quantization.',bt,T,wt,G,yt,A,Gt='Now pass the <code>loftq_config</code> to the <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> to enable LoftQ initialization, and create a <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> for training.',gt,R,_t,H,$t,N,At="If you’re interested in learning more about quantization, the following may be helpful:",jt,F,Rt='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',vt,P,Ct;return b=new S({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),$=new S({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),B=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),I=new V({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),L=new S({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),k=new V({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),x=new V({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),E=new S({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),T=new te({props:{warning:!0,$$slots:{default:[ee]},$$scope:{ctx:D}}}),G=new V({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMExvZnRRQ29uZmlnJTJDJTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQWxvZnRxX2NvbmZpZyUyMCUzRCUyMExvZnRRQ29uZmlnKGxvZnRxX2JpdHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoModelForCausalLM, LoftQConfig, LoraConfig, get_peft_model

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>)`,wrap:!1}}),R=new V({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIybG9mdHElMjIlMkMlMEElMjAlMjAlMjAlMjBsb2Z0cV9jb25maWclM0Rsb2Z0cV9jb25maWclMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyk=",highlighted:`lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>,
    loftq_config=loftq_config,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, lora_config)`,wrap:!1}}),H=new S({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){r=s("meta"),J=a(),M=s("p"),Y=a(),f(b.$$.fragment),K=a(),w=s("p"),w.textContent=qt,O=a(),y=s("ul"),y.innerHTML=Bt,tt=a(),g=s("p"),g.innerHTML=zt,et=a(),_=s("p"),_.textContent=It,nt=a(),f($.$$.fragment),lt=a(),j=s("p"),j.innerHTML=Zt,at=a(),v=s("ul"),v.innerHTML=Lt,it=a(),f(C.$$.fragment),st=a(),q=s("p"),q.innerHTML=Ut,ot=a(),f(B.$$.fragment),rt=a(),z=s("p"),z.innerHTML=kt,pt=a(),f(I.$$.fragment),ft=a(),Z=s("p"),Z.textContent=Qt,mt=a(),f(L.$$.fragment),ut=a(),U=s("p"),U.innerHTML=xt,dt=a(),f(k.$$.fragment),ht=a(),Q=s("p"),Q.innerHTML=Wt,ct=a(),f(x.$$.fragment),Mt=a(),W=s("p"),W.textContent=Et,Tt=a(),f(E.$$.fragment),Jt=a(),X=s("p"),X.innerHTML=Xt,bt=a(),f(T.$$.fragment),wt=a(),f(G.$$.fragment),yt=a(),A=s("p"),A.innerHTML=Gt,gt=a(),f(R.$$.fragment),_t=a(),f(H.$$.fragment),$t=a(),N=s("p"),N.textContent=At,jt=a(),F=s("ul"),F.innerHTML=Rt,vt=a(),P=s("p"),this.h()},l(t){const e=Kt("svelte-u9bgzb",document.head);r=o(e,"META",{name:!0,content:!0}),e.forEach(n),J=i(t),M=o(t,"P",{}),Nt(M).forEach(n),Y=i(t),m(b.$$.fragment,t),K=i(t),w=o(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-famg4s"&&(w.textContent=qt),O=i(t),y=o(t,"UL",{"data-svelte-h":!0}),p(y)!=="svelte-10cnhiv"&&(y.innerHTML=Bt),tt=i(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-142xot4"&&(g.innerHTML=zt),et=i(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1demhiu"&&(_.textContent=It),nt=i(t),m($.$$.fragment,t),lt=i(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-lhtroc"&&(j.innerHTML=Zt),at=i(t),v=o(t,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-hfynw8"&&(v.innerHTML=Lt),it=i(t),m(C.$$.fragment,t),st=i(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-a8rnja"&&(q.innerHTML=Ut),ot=i(t),m(B.$$.fragment,t),rt=i(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1frbcix"&&(z.innerHTML=kt),pt=i(t),m(I.$$.fragment,t),ft=i(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-11mx7fc"&&(Z.textContent=Qt),mt=i(t),m(L.$$.fragment,t),ut=i(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-h80zxx"&&(U.innerHTML=xt),dt=i(t),m(k.$$.fragment,t),ht=i(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-2kihwc"&&(Q.innerHTML=Wt),ct=i(t),m(x.$$.fragment,t),Mt=i(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-xd402n"&&(W.textContent=Et),Tt=i(t),m(E.$$.fragment,t),Jt=i(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-g845ls"&&(X.innerHTML=Xt),bt=i(t),m(T.$$.fragment,t),wt=i(t),m(G.$$.fragment,t),yt=i(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1i0tjkm"&&(A.innerHTML=Gt),gt=i(t),m(R.$$.fragment,t),_t=i(t),m(H.$$.fragment,t),$t=i(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-agdyn7"&&(N.textContent=At),jt=i(t),F=o(t,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-83nivc"&&(F.innerHTML=Rt),vt=i(t),P=o(t,"P",{}),Nt(P).forEach(n),this.h()},h(){Ft(r,"name","hf:doc:metadata"),Ft(r,"content",le)},m(t,e){Ot(document.head,r),l(t,J,e),l(t,M,e),l(t,Y,e),u(b,t,e),l(t,K,e),l(t,w,e),l(t,O,e),l(t,y,e),l(t,tt,e),l(t,g,e),l(t,et,e),l(t,_,e),l(t,nt,e),u($,t,e),l(t,lt,e),l(t,j,e),l(t,at,e),l(t,v,e),l(t,it,e),u(C,t,e),l(t,st,e),l(t,q,e),l(t,ot,e),u(B,t,e),l(t,rt,e),l(t,z,e),l(t,pt,e),u(I,t,e),l(t,ft,e),l(t,Z,e),l(t,mt,e),u(L,t,e),l(t,ut,e),l(t,U,e),l(t,dt,e),u(k,t,e),l(t,ht,e),l(t,Q,e),l(t,ct,e),u(x,t,e),l(t,Mt,e),l(t,W,e),l(t,Tt,e),u(E,t,e),l(t,Jt,e),l(t,X,e),l(t,bt,e),u(T,t,e),l(t,wt,e),u(G,t,e),l(t,yt,e),l(t,A,e),l(t,gt,e),u(R,t,e),l(t,_t,e),u(H,t,e),l(t,$t,e),l(t,N,e),l(t,jt,e),l(t,F,e),l(t,vt,e),l(t,P,e),Ct=!0},p(t,[e]){const Ht={};e&2&&(Ht.$$scope={dirty:e,ctx:t}),T.$set(Ht)},i(t){Ct||(d(b.$$.fragment,t),d($.$$.fragment,t),d(C.$$.fragment,t),d(B.$$.fragment,t),d(I.$$.fragment,t),d(L.$$.fragment,t),d(k.$$.fragment,t),d(x.$$.fragment,t),d(E.$$.fragment,t),d(T.$$.fragment,t),d(G.$$.fragment,t),d(R.$$.fragment,t),d(H.$$.fragment,t),Ct=!0)},o(t){h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(B.$$.fragment,t),h(I.$$.fragment,t),h(L.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(E.$$.fragment,t),h(T.$$.fragment,t),h(G.$$.fragment,t),h(R.$$.fragment,t),h(H.$$.fragment,t),Ct=!1},d(t){t&&(n(J),n(M),n(Y),n(K),n(w),n(O),n(y),n(tt),n(g),n(et),n(_),n(nt),n(lt),n(j),n(at),n(v),n(it),n(st),n(q),n(ot),n(rt),n(z),n(pt),n(ft),n(Z),n(mt),n(ut),n(U),n(dt),n(ht),n(Q),n(ct),n(Mt),n(W),n(Tt),n(Jt),n(X),n(bt),n(wt),n(yt),n(A),n(gt),n(_t),n($t),n(N),n(jt),n(F),n(vt),n(P)),n(r),c(b,t),c($,t),c(C,t),c(B,t),c(I,t),c(L,t),c(k,t),c(x,t),c(E,t),c(T,t),c(G,t),c(R,t),c(H,t)}}}const le='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ae(D){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends St{constructor(r){super(),Dt(this,r,ae,ne,Vt,{})}}export{fe as component};
