import{s as au,o as lu,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as ru,i as iu,g as m,s as a,r as u,A as pu,h as d,f as i,c as l,j as x,u as g,x as T,k as $,y as o,a as c,v as f,d as h,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Z}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as U}from"../chunks/CodeBlock.fa01571c.js";import{E as R}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as j}from"../chunks/Heading.723dceba.js";function mu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function du(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function cu(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function uu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function gu(w){let n,M="Example of feature extraction:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function fu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function hu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function _u(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function bu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function yu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Tu(w){let n,M="Example of single-label classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ykxpe4"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Mu(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function vu(w){let n,M="Example using zero-shot-classification <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vtj8d2"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function wu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function xu(w){let n,M="Example of token classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-rtgw80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function $u(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ku(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Ju(w){let n,M="Example of mutliple choice:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lfckvi"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ju(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Ru(w){let n,M="Example of question answering:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ml1brl"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Uu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Iu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Cu(w){let n,M="Example of image classification:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1nh3zco"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Zu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Wu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Nu(w){let n,M="Example of semantic segmentation:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wzzaup"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Su(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Fu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Ou(w){let n,M="Example of audio classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mp8f15"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Gu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Xu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Vu(w){let n,M="Example of audio frame classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12boqdm"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function zu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function qu(w){let n,M="Example of CTC:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mdyxnj"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Lu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Bu(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Hu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Pu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Eu(w){let n,M="Example of Audio XVector:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1kzdm5c"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Qu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Du(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Yu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Au(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function Ku(w){let n,M="Example of pix2struct:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11ikyn3"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function eg(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function tg(w){let n,M="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6kynse"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ng(w){let n,M="Example using <code>transformers.pipelines</code>(only if the task is supported):",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-xxeb0k"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function og(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:J,d(r){r&&i(n)}}}function sg(w){let n,M="Example of feature extraction:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ag(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:J,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function lg(w){let n,M,r,s,y,t,v,gl,yn,Km="The following ORT classes are available for instantiating a base model class without a specific head.",fl,Tn,hl,I,Mn,Jr,us,ed="Base class for implementing models using ONNX Runtime.",jr,gs,td=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,Rr,fs,nd="Class attributes:",Ur,hs,od=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,Ir,_s,sd="Common attributes:",Cr,bs,ad=`<li>model (<code>ort.InferenceSession</code>) — The ONNX Runtime InferenceSession that is running the model.</li> <li>config (<a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> — The configuration of the model.</li> <li>use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) — Whether to use I/O bindings with <strong>ONNX Runtime
with the CUDAExecutionProvider</strong>, this can significantly speedup inference depending on the task.</li> <li>model_save_dir (<code>Path</code>) — The directory where the model exported to ONNX is saved.
By defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory is used.</li> <li>providers (\`List[str]) — The list of execution providers available to ONNX Runtime.</li>`,Zr,mt,vn,Wr,ys,ld="Returns whether this model can generate sequences with <code>.generate()</code>.",Nr,dt,wn,Sr,Ts,rd="Instantiate a pretrained model from a pre-trained model configuration.",Fr,ct,xn,Or,Ms,id=`Loads an ONNX Inference session with a given provider. Default provider is <code>CPUExecutionProvider</code> to match the
default behaviour in PyTorch/TensorFlow/JAX.`,Gr,ut,$n,Xr,vs,pd="Raises an error if IO Binding is requested although the tensor used are numpy arrays.",Vr,gt,kn,zr,ws,md="Initializes attributes that may be shared among several ONNX Runtime inference sesssions.",qr,ft,Jn,Lr,xs,dd="Changes the ONNX Runtime provider according to the device.",_l,jn,bl,Rn,cd="The following ORT classes are available for the following natural language processing tasks.",yl,Un,Tl,N,In,Br,$s,ud="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt_bigcode, gpt_neo, gpt_neox, gptj, llama.",Hr,ks,gd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pr,Js,fd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Er,le,Cn,Qr,js,hd="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",Dr,ht,Yr,_t,Ar,bt,Ml,Zn,vl,S,Wn,Kr,Rs,_d="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",ei,Us,bd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ti,Is,yd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ni,re,Nn,oi,Cs,Td="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",si,yt,ai,Tt,li,Mt,wl,Sn,xl,F,Fn,ri,Zs,Md="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot_small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",ii,Ws,vd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,pi,Ns,wd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',mi,ie,On,di,Ss,xd="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",ci,vt,ui,wt,gi,xt,$l,Gn,kl,O,Xn,fi,Fs,$d=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,hi,Os,kd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,_i,Gs,Jd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',bi,W,Vn,yi,Xs,jd="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",Ti,$t,Mi,kt,vi,Jt,wi,jt,Jl,zn,jl,G,qn,xi,Vs,Rd=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,$i,zs,Ud=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ki,qs,Id='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ji,pe,Ln,ji,Ls,Cd="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Ri,Rt,Ui,Ut,Ii,It,Rl,Bn,Ul,X,Hn,Ci,Bs,Zd=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Zi,Hs,Wd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Wi,Ps,Nd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ni,Ae,Pn,Si,Es,Sd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Fi,Ct,Oi,Zt,Il,En,Cl,V,Qn,Gi,Qs,Fd="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",Xi,Ds,Od=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vi,Ys,Gd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',zi,me,Dn,qi,As,Xd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",Li,Wt,Bi,Nt,Hi,St,Zl,Yn,Wl,An,Vd="The following ORT classes are available for the following computer vision tasks.",Nl,Kn,Sl,z,eo,Pi,Ks,zd="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec_vision, deit, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, vit.",Ei,ea,qd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Qi,ta,Ld='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Di,de,to,Yi,na,Bd="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Ai,Ft,Ki,Ot,ep,Gt,Fl,no,Ol,q,oo,tp,oa,Hd="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports segformer.",np,sa,Pd=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,op,aa,Ed='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',sp,ce,so,ap,la,Qd="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",lp,Xt,rp,Vt,ip,zt,Gl,ao,Xl,lo,Dd="The following ORT classes are available for the following audio tasks.",Vl,ro,zl,L,io,pp,ra,Yd=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,mp,ia,Ad=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dp,pa,Kd='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cp,ue,po,up,ma,ec="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",gp,qt,fp,Lt,hp,Bt,ql,mo,Ll,B,co,_p,da,tc="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",bp,ca,nc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,yp,ua,oc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Tp,Ke,uo,Mp,ga,sc="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",vp,Ht,wp,Pt,Bl,go,Hl,H,fo,xp,fa,ac="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",$p,ha,lc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,kp,_a,rc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Jp,et,ho,jp,ba,ic="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Rp,Et,Up,Qt,Pl,_o,El,P,bo,Ip,ya,pc="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",Cp,Ta,mc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Zp,Ma,dc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Wp,ge,yo,Np,va,cc="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",Sp,Dt,Fp,Yt,Op,At,Ql,To,Dl,E,Mo,Gp,wa,uc="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Xp,xa,gc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vp,$a,fc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',zp,tt,vo,qp,ka,hc="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Lp,Kt,Bp,en,Yl,wo,Al,xo,_c="The following ORT classes are available for the following multimodal tasks.",Kl,$o,er,Q,ko,Hp,Ja,bc="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",Pp,ja,yc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ep,Ra,Tc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Qp,fe,Jo,Dp,Ua,Mc="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Yp,tn,Ap,nn,Kp,on,tr,jo,nr,D,Ro,em,Ia,vc="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",tm,Ca,wc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,nm,Za,xc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',om,nt,Uo,sm,Wa,$c="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",am,sn,lm,an,or,Io,sr,Co,kc="The following ORT classes are available for the following custom tasks.",ar,Zo,lr,Y,Wo,rm,Na,Jc="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",im,Sa,jc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,pm,Fa,Rc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',mm,he,No,dm,Oa,Uc="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",cm,ln,um,rn,gm,pn,rr,So,ir,A,Fo,fm,Ga,Ic="ONNX Model for feature-extraction task.",hm,Xa,Cc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,_m,Va,Zc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',bm,_e,Oo,ym,za,Wc="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",Tm,mn,Mm,dn,vm,cn,pr,Go,mr,Xo,dr,K,Vo,wm,qa,Nc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">diffusers.StableDiffusionPipeline</a>.',xm,La,Sc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,$m,Ba,Fc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',km,un,zo,Jm,Ha,Oc="Function invoked when calling the pipeline for generation.",cr,qo,ur,ee,Lo,jm,Pa,Gc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionImg2ImgPipeline</a>.',Rm,Ea,Xc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Um,Qa,Vc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Im,gn,Bo,Cm,Da,zc="Function invoked when calling the pipeline for generation.",gr,Ho,fr,te,Po,Zm,Ya,qc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">diffusers.StableDiffusionInpaintPipeline</a>.',Wm,Aa,Lc=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Nm,Ka,Bc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Sm,fn,Eo,Fm,el,Hc="Function invoked when calling the pipeline for generation.",hr,Qo,_r,ne,Do,Om,tl,Pc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">diffusers.StableDiffusionXLPipeline</a>.',Gm,nl,Ec=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Xm,ol,Qc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Vm,hn,Yo,zm,sl,Dc="Function invoked when calling the pipeline for generation.",br,Ao,yr,oe,Ko,qm,al,Yc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.',Lm,ll,Ac=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Bm,rl,Kc='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Hm,_n,es,Pm,il,eu="Function invoked when calling the pipeline for generation.",Tr,ts,Mr,se,ns,Em,pl,tu='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/latent_consistency#diffusers.LatentConsistencyModelPipeline" rel="nofollow">diffusers.LatentConsistencyModelPipeline</a>.',Qm,ml,nu=`This model inherits from <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dm,dl,ou='This class should be initialized using the <a href="/docs/optimum/v1.18.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ym,bn,os,Am,cl,su="Function invoked when calling the pipeline for generation.",vr,ul,wr;return y=new j({props:{title:"Models",local:"models",headingTag:"h1"}}),v=new j({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Tn=new j({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),Mn=new k({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L139"}}),vn=new k({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L898"}}),wn=new k({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"export",val:": bool = False"},{name:"force_download",val:": bool = False"},{name:"use_auth_token",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"subfolder",val:": str = ''"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"local_files_only",val:": bool = False"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.from_transformers",description:`<strong>from_transformers</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> contains a vanilla Transformers checkpoint.`,name:"from_transformers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for
possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L614",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),xn=new k({props:{name:"load_model",anchor:"optimum.onnxruntime.ORTModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the ONNX model.`,name:"path"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a>
for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.load_model.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>) &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionary corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L335"}}),$n=new k({props:{name:"raise_on_numpy_input_io_binding",anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding",parameters:[{name:"use_torch",val:": bool"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding.use_torch",description:`<strong>use_torch</strong> (<code>bool</code>) &#x2014;
Whether the tensor used during inference are of type torch.Tensor or not.`,name:"use_torch"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L835"}}),kn=new k({props:{name:"shared_attributes_init",anchor:"optimum.onnxruntime.ORTModel.shared_attributes_init",parameters:[{name:"model",val:": InferenceSession"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L182"}}),Jn=new k({props:{name:"to",anchor:"optimum.onnxruntime.ORTModel.to",parameters:[{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.to.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code> or <code>int</code>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run
the model on the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too.`,name:"device"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L295",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the model placed on the requested device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),jn=new j({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Un=new j({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),In=new k({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_decoder.py#L115"}}),Cn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache_branch",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_decoder.py#L182"}}),ht=new Z({props:{$$slots:{default:[mu]},$$scope:{ctx:w}}}),_t=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[du]},$$scope:{ctx:w}}}),bt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[cu]},$$scope:{ctx:w}}}),Zn=new j({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),Wn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1103"}}),Nn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1110"}}),yt=new Z({props:{$$slots:{default:[uu]},$$scope:{ctx:w}}}),Tt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[gu]},$$scope:{ctx:w}}}),Mt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[fu]},$$scope:{ctx:w}}}),Sn=new j({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Fn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1116"}}),On=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1170"}}),vt=new Z({props:{$$slots:{default:[hu]},$$scope:{ctx:w}}}),wt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[_u]},$$scope:{ctx:w}}}),xt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[bu]},$$scope:{ctx:w}}}),Gn=new j({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Xn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1328"}}),Vn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1336"}}),$t=new Z({props:{$$slots:{default:[yu]},$$scope:{ctx:w}}}),kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Tu]},$$scope:{ctx:w}}}),Jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[Mu]},$$scope:{ctx:w}}}),jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[vu]},$$scope:{ctx:w}}}),zn=new j({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),qn=new k({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1429"}}),Ln=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1438"}}),Rt=new Z({props:{$$slots:{default:[wu]},$$scope:{ctx:w}}}),Ut=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[xu]},$$scope:{ctx:w}}}),It=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[$u]},$$scope:{ctx:w}}}),Bn=new j({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Hn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1528"}}),Pn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1536"}}),Ct=new Z({props:{$$slots:{default:[ku]},$$scope:{ctx:w}}}),Zt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Ju]},$$scope:{ctx:w}}}),En=new j({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Qn=new k({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1206"}}),Dn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1213"}}),Wt=new Z({props:{$$slots:{default:[ju]},$$scope:{ctx:w}}}),Nt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[Ru]},$$scope:{ctx:w}}}),St=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Uu]},$$scope:{ctx:w}}}),Yn=new j({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Kn=new j({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),eo=new k({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1634"}}),to=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1641"}}),Ft=new Z({props:{$$slots:{default:[Iu]},$$scope:{ctx:w}}}),Ot=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Cu]},$$scope:{ctx:w}}}),Gt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Zu]},$$scope:{ctx:w}}}),no=new j({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),oo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1728"}}),so=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1735"}}),Xt=new Z({props:{$$slots:{default:[Wu]},$$scope:{ctx:w}}}),Vt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Nu]},$$scope:{ctx:w}}}),zt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Su]},$$scope:{ctx:w}}}),ao=new j({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ro=new j({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),io=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1834"}}),po=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"attenton_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1865"}}),qt=new Z({props:{$$slots:{default:[Fu]},$$scope:{ctx:w}}}),Lt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Ou]},$$scope:{ctx:w}}}),Bt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Gu]},$$scope:{ctx:w}}}),mo=new j({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),co=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2141"}}),uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2148"}}),Ht=new Z({props:{$$slots:{default:[Xu]},$$scope:{ctx:w}}}),Pt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Vu]},$$scope:{ctx:w}}}),go=new j({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),fo=new k({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1946"}}),ho=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L1953"}}),Et=new Z({props:{$$slots:{default:[zu]},$$scope:{ctx:w}}}),Qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[qu]},$$scope:{ctx:w}}}),_o=new j({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),bo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1261"}}),yo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1303"}}),Dt=new Z({props:{$$slots:{default:[Lu]},$$scope:{ctx:w}}}),Yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Bu]},$$scope:{ctx:w}}}),At=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Hu]},$$scope:{ctx:w}}}),To=new j({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),Mo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2052"}}),vo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2059"}}),Kt=new Z({props:{$$slots:{default:[Pu]},$$scope:{ctx:w}}}),en=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[Eu]},$$scope:{ctx:w}}}),wo=new j({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),$o=new j({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),ko=new k({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1832"}}),Jo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1890"}}),tn=new Z({props:{$$slots:{default:[Qu]},$$scope:{ctx:w}}}),nn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Du]},$$scope:{ctx:w}}}),on=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[Yu]},$$scope:{ctx:w}}}),jo=new j({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),Ro=new k({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1977"}}),Uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_seq2seq.py#L1989"}}),sn=new Z({props:{$$slots:{default:[Au]},$$scope:{ctx:w}}}),an=new R({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[Ku]},$$scope:{ctx:w}}}),Io=new j({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Zo=new j({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),Wo=new k({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2221"}}),No=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L2226"}}),ln=new Z({props:{$$slots:{default:[eg]},$$scope:{ctx:w}}}),rn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[tg]},$$scope:{ctx:w}}}),pn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[ng]},$$scope:{ctx:w}}}),So=new j({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),Fo=new k({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L941"}}),Oo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_ort.py#L948"}}),mn=new Z({props:{$$slots:{default:[og]},$$scope:{ctx:w}}}),dn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[sg]},$$scope:{ctx:w}}}),cn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[ag]},$$scope:{ctx:w}}}),Go=new j({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),Xo=new j({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h4"}}),Vo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L542"}}),zo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_stable_diffusion.py#L202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),qo=new j({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Lo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L551"}}),Bo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_stable_diffusion_img2img.py#L76",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Ho=new j({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Po=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L560"}}),Eo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": Image"},{name:"mask_image",val:": Image"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing a masked image batch which will be upscaled.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_stable_diffusion_inpaint.py#L98",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Qo=new j({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Do=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L627"}}),Yo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl.py#L263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ao=new j({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Ko=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L636"}}),es=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl_img2img.py#L267",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),ts=new j({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),ns=new k({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/onnxruntime/modeling_diffusion.py#L569"}}),os=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"original_inference_steps",val:": int = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/v1.18.0/optimum/pipelines/diffusers/pipeline_latent_consistency.py#L30",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){n=m("meta"),M=a(),r=m("p"),s=a(),u(y.$$.fragment),t=a(),u(v.$$.fragment),gl=a(),yn=m("p"),yn.textContent=Km,fl=a(),u(Tn.$$.fragment),hl=a(),I=m("div"),u(Mn.$$.fragment),Jr=a(),us=m("p"),us.textContent=ed,jr=a(),gs=m("p"),gs.innerHTML=td,Rr=a(),fs=m("p"),fs.textContent=nd,Ur=a(),hs=m("ul"),hs.innerHTML=od,Ir=a(),_s=m("p"),_s.textContent=sd,Cr=a(),bs=m("ul"),bs.innerHTML=ad,Zr=a(),mt=m("div"),u(vn.$$.fragment),Wr=a(),ys=m("p"),ys.innerHTML=ld,Nr=a(),dt=m("div"),u(wn.$$.fragment),Sr=a(),Ts=m("p"),Ts.textContent=rd,Fr=a(),ct=m("div"),u(xn.$$.fragment),Or=a(),Ms=m("p"),Ms.innerHTML=id,Gr=a(),ut=m("div"),u($n.$$.fragment),Xr=a(),vs=m("p"),vs.textContent=pd,Vr=a(),gt=m("div"),u(kn.$$.fragment),zr=a(),ws=m("p"),ws.textContent=md,qr=a(),ft=m("div"),u(Jn.$$.fragment),Lr=a(),xs=m("p"),xs.textContent=dd,_l=a(),u(jn.$$.fragment),bl=a(),Rn=m("p"),Rn.textContent=cd,yl=a(),u(Un.$$.fragment),Tl=a(),N=m("div"),u(In.$$.fragment),Br=a(),$s=m("p"),$s.textContent=ud,Hr=a(),ks=m("p"),ks.innerHTML=gd,Pr=a(),Js=m("p"),Js.innerHTML=fd,Er=a(),le=m("div"),u(Cn.$$.fragment),Qr=a(),js=m("p"),js.innerHTML=hd,Dr=a(),u(ht.$$.fragment),Yr=a(),u(_t.$$.fragment),Ar=a(),u(bt.$$.fragment),Ml=a(),u(Zn.$$.fragment),vl=a(),S=m("div"),u(Wn.$$.fragment),Kr=a(),Rs=m("p"),Rs.textContent=_d,ei=a(),Us=m("p"),Us.innerHTML=bd,ti=a(),Is=m("p"),Is.innerHTML=yd,ni=a(),re=m("div"),u(Nn.$$.fragment),oi=a(),Cs=m("p"),Cs.innerHTML=Td,si=a(),u(yt.$$.fragment),ai=a(),u(Tt.$$.fragment),li=a(),u(Mt.$$.fragment),wl=a(),u(Sn.$$.fragment),xl=a(),F=m("div"),u(Fn.$$.fragment),ri=a(),Zs=m("p"),Zs.textContent=Md,ii=a(),Ws=m("p"),Ws.innerHTML=vd,pi=a(),Ns=m("p"),Ns.innerHTML=wd,mi=a(),ie=m("div"),u(On.$$.fragment),di=a(),Ss=m("p"),Ss.innerHTML=xd,ci=a(),u(vt.$$.fragment),ui=a(),u(wt.$$.fragment),gi=a(),u(xt.$$.fragment),$l=a(),u(Gn.$$.fragment),kl=a(),O=m("div"),u(Xn.$$.fragment),fi=a(),Fs=m("p"),Fs.textContent=$d,hi=a(),Os=m("p"),Os.innerHTML=kd,_i=a(),Gs=m("p"),Gs.innerHTML=Jd,bi=a(),W=m("div"),u(Vn.$$.fragment),yi=a(),Xs=m("p"),Xs.innerHTML=jd,Ti=a(),u($t.$$.fragment),Mi=a(),u(kt.$$.fragment),vi=a(),u(Jt.$$.fragment),wi=a(),u(jt.$$.fragment),Jl=a(),u(zn.$$.fragment),jl=a(),G=m("div"),u(qn.$$.fragment),xi=a(),Vs=m("p"),Vs.textContent=Rd,$i=a(),zs=m("p"),zs.innerHTML=Ud,ki=a(),qs=m("p"),qs.innerHTML=Id,Ji=a(),pe=m("div"),u(Ln.$$.fragment),ji=a(),Ls=m("p"),Ls.innerHTML=Cd,Ri=a(),u(Rt.$$.fragment),Ui=a(),u(Ut.$$.fragment),Ii=a(),u(It.$$.fragment),Rl=a(),u(Bn.$$.fragment),Ul=a(),X=m("div"),u(Hn.$$.fragment),Ci=a(),Bs=m("p"),Bs.textContent=Zd,Zi=a(),Hs=m("p"),Hs.innerHTML=Wd,Wi=a(),Ps=m("p"),Ps.innerHTML=Nd,Ni=a(),Ae=m("div"),u(Pn.$$.fragment),Si=a(),Es=m("p"),Es.innerHTML=Sd,Fi=a(),u(Ct.$$.fragment),Oi=a(),u(Zt.$$.fragment),Il=a(),u(En.$$.fragment),Cl=a(),V=m("div"),u(Qn.$$.fragment),Gi=a(),Qs=m("p"),Qs.textContent=Fd,Xi=a(),Ds=m("p"),Ds.innerHTML=Od,Vi=a(),Ys=m("p"),Ys.innerHTML=Gd,zi=a(),me=m("div"),u(Dn.$$.fragment),qi=a(),As=m("p"),As.innerHTML=Xd,Li=a(),u(Wt.$$.fragment),Bi=a(),u(Nt.$$.fragment),Hi=a(),u(St.$$.fragment),Zl=a(),u(Yn.$$.fragment),Wl=a(),An=m("p"),An.textContent=Vd,Nl=a(),u(Kn.$$.fragment),Sl=a(),z=m("div"),u(eo.$$.fragment),Pi=a(),Ks=m("p"),Ks.textContent=zd,Ei=a(),ea=m("p"),ea.innerHTML=qd,Qi=a(),ta=m("p"),ta.innerHTML=Ld,Di=a(),de=m("div"),u(to.$$.fragment),Yi=a(),na=m("p"),na.innerHTML=Bd,Ai=a(),u(Ft.$$.fragment),Ki=a(),u(Ot.$$.fragment),ep=a(),u(Gt.$$.fragment),Fl=a(),u(no.$$.fragment),Ol=a(),q=m("div"),u(oo.$$.fragment),tp=a(),oa=m("p"),oa.textContent=Hd,np=a(),sa=m("p"),sa.innerHTML=Pd,op=a(),aa=m("p"),aa.innerHTML=Ed,sp=a(),ce=m("div"),u(so.$$.fragment),ap=a(),la=m("p"),la.innerHTML=Qd,lp=a(),u(Xt.$$.fragment),rp=a(),u(Vt.$$.fragment),ip=a(),u(zt.$$.fragment),Gl=a(),u(ao.$$.fragment),Xl=a(),lo=m("p"),lo.textContent=Dd,Vl=a(),u(ro.$$.fragment),zl=a(),L=m("div"),u(io.$$.fragment),pp=a(),ra=m("p"),ra.textContent=Yd,mp=a(),ia=m("p"),ia.innerHTML=Ad,dp=a(),pa=m("p"),pa.innerHTML=Kd,cp=a(),ue=m("div"),u(po.$$.fragment),up=a(),ma=m("p"),ma.innerHTML=ec,gp=a(),u(qt.$$.fragment),fp=a(),u(Lt.$$.fragment),hp=a(),u(Bt.$$.fragment),ql=a(),u(mo.$$.fragment),Ll=a(),B=m("div"),u(co.$$.fragment),_p=a(),da=m("p"),da.textContent=tc,bp=a(),ca=m("p"),ca.innerHTML=nc,yp=a(),ua=m("p"),ua.innerHTML=oc,Tp=a(),Ke=m("div"),u(uo.$$.fragment),Mp=a(),ga=m("p"),ga.innerHTML=sc,vp=a(),u(Ht.$$.fragment),wp=a(),u(Pt.$$.fragment),Bl=a(),u(go.$$.fragment),Hl=a(),H=m("div"),u(fo.$$.fragment),xp=a(),fa=m("p"),fa.textContent=ac,$p=a(),ha=m("p"),ha.innerHTML=lc,kp=a(),_a=m("p"),_a.innerHTML=rc,Jp=a(),et=m("div"),u(ho.$$.fragment),jp=a(),ba=m("p"),ba.innerHTML=ic,Rp=a(),u(Et.$$.fragment),Up=a(),u(Qt.$$.fragment),Pl=a(),u(_o.$$.fragment),El=a(),P=m("div"),u(bo.$$.fragment),Ip=a(),ya=m("p"),ya.textContent=pc,Cp=a(),Ta=m("p"),Ta.innerHTML=mc,Zp=a(),Ma=m("p"),Ma.innerHTML=dc,Wp=a(),ge=m("div"),u(yo.$$.fragment),Np=a(),va=m("p"),va.innerHTML=cc,Sp=a(),u(Dt.$$.fragment),Fp=a(),u(Yt.$$.fragment),Op=a(),u(At.$$.fragment),Ql=a(),u(To.$$.fragment),Dl=a(),E=m("div"),u(Mo.$$.fragment),Gp=a(),wa=m("p"),wa.textContent=uc,Xp=a(),xa=m("p"),xa.innerHTML=gc,Vp=a(),$a=m("p"),$a.innerHTML=fc,zp=a(),tt=m("div"),u(vo.$$.fragment),qp=a(),ka=m("p"),ka.innerHTML=hc,Lp=a(),u(Kt.$$.fragment),Bp=a(),u(en.$$.fragment),Yl=a(),u(wo.$$.fragment),Al=a(),xo=m("p"),xo.textContent=_c,Kl=a(),u($o.$$.fragment),er=a(),Q=m("div"),u(ko.$$.fragment),Hp=a(),Ja=m("p"),Ja.textContent=bc,Pp=a(),ja=m("p"),ja.innerHTML=yc,Ep=a(),Ra=m("p"),Ra.innerHTML=Tc,Qp=a(),fe=m("div"),u(Jo.$$.fragment),Dp=a(),Ua=m("p"),Ua.innerHTML=Mc,Yp=a(),u(tn.$$.fragment),Ap=a(),u(nn.$$.fragment),Kp=a(),u(on.$$.fragment),tr=a(),u(jo.$$.fragment),nr=a(),D=m("div"),u(Ro.$$.fragment),em=a(),Ia=m("p"),Ia.textContent=vc,tm=a(),Ca=m("p"),Ca.innerHTML=wc,nm=a(),Za=m("p"),Za.innerHTML=xc,om=a(),nt=m("div"),u(Uo.$$.fragment),sm=a(),Wa=m("p"),Wa.innerHTML=$c,am=a(),u(sn.$$.fragment),lm=a(),u(an.$$.fragment),or=a(),u(Io.$$.fragment),sr=a(),Co=m("p"),Co.textContent=kc,ar=a(),u(Zo.$$.fragment),lr=a(),Y=m("div"),u(Wo.$$.fragment),rm=a(),Na=m("p"),Na.textContent=Jc,im=a(),Sa=m("p"),Sa.innerHTML=jc,pm=a(),Fa=m("p"),Fa.innerHTML=Rc,mm=a(),he=m("div"),u(No.$$.fragment),dm=a(),Oa=m("p"),Oa.innerHTML=Uc,cm=a(),u(ln.$$.fragment),um=a(),u(rn.$$.fragment),gm=a(),u(pn.$$.fragment),rr=a(),u(So.$$.fragment),ir=a(),A=m("div"),u(Fo.$$.fragment),fm=a(),Ga=m("p"),Ga.textContent=Ic,hm=a(),Xa=m("p"),Xa.innerHTML=Cc,_m=a(),Va=m("p"),Va.innerHTML=Zc,bm=a(),_e=m("div"),u(Oo.$$.fragment),ym=a(),za=m("p"),za.innerHTML=Wc,Tm=a(),u(mn.$$.fragment),Mm=a(),u(dn.$$.fragment),vm=a(),u(cn.$$.fragment),pr=a(),u(Go.$$.fragment),mr=a(),u(Xo.$$.fragment),dr=a(),K=m("div"),u(Vo.$$.fragment),wm=a(),qa=m("p"),qa.innerHTML=Nc,xm=a(),La=m("p"),La.innerHTML=Sc,$m=a(),Ba=m("p"),Ba.innerHTML=Fc,km=a(),un=m("div"),u(zo.$$.fragment),Jm=a(),Ha=m("p"),Ha.textContent=Oc,cr=a(),u(qo.$$.fragment),ur=a(),ee=m("div"),u(Lo.$$.fragment),jm=a(),Pa=m("p"),Pa.innerHTML=Gc,Rm=a(),Ea=m("p"),Ea.innerHTML=Xc,Um=a(),Qa=m("p"),Qa.innerHTML=Vc,Im=a(),gn=m("div"),u(Bo.$$.fragment),Cm=a(),Da=m("p"),Da.textContent=zc,gr=a(),u(Ho.$$.fragment),fr=a(),te=m("div"),u(Po.$$.fragment),Zm=a(),Ya=m("p"),Ya.innerHTML=qc,Wm=a(),Aa=m("p"),Aa.innerHTML=Lc,Nm=a(),Ka=m("p"),Ka.innerHTML=Bc,Sm=a(),fn=m("div"),u(Eo.$$.fragment),Fm=a(),el=m("p"),el.textContent=Hc,hr=a(),u(Qo.$$.fragment),_r=a(),ne=m("div"),u(Do.$$.fragment),Om=a(),tl=m("p"),tl.innerHTML=Pc,Gm=a(),nl=m("p"),nl.innerHTML=Ec,Xm=a(),ol=m("p"),ol.innerHTML=Qc,Vm=a(),hn=m("div"),u(Yo.$$.fragment),zm=a(),sl=m("p"),sl.textContent=Dc,br=a(),u(Ao.$$.fragment),yr=a(),oe=m("div"),u(Ko.$$.fragment),qm=a(),al=m("p"),al.innerHTML=Yc,Lm=a(),ll=m("p"),ll.innerHTML=Ac,Bm=a(),rl=m("p"),rl.innerHTML=Kc,Hm=a(),_n=m("div"),u(es.$$.fragment),Pm=a(),il=m("p"),il.textContent=eu,Tr=a(),u(ts.$$.fragment),Mr=a(),se=m("div"),u(ns.$$.fragment),Em=a(),pl=m("p"),pl.innerHTML=tu,Qm=a(),ml=m("p"),ml.innerHTML=nu,Dm=a(),dl=m("p"),dl.innerHTML=ou,Ym=a(),bn=m("div"),u(os.$$.fragment),Am=a(),cl=m("p"),cl.textContent=su,vr=a(),ul=m("p"),this.h()},l(e){const p=pu("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),M=l(e),r=d(e,"P",{}),x(r).forEach(i),s=l(e),g(y.$$.fragment,e),t=l(e),g(v.$$.fragment,e),gl=l(e),yn=d(e,"P",{"data-svelte-h":!0}),T(yn)!=="svelte-uyecg"&&(yn.textContent=Km),fl=l(e),g(Tn.$$.fragment,e),hl=l(e),I=d(e,"DIV",{class:!0});var C=x(I);g(Mn.$$.fragment,C),Jr=l(C),us=d(C,"P",{"data-svelte-h":!0}),T(us)!=="svelte-12yueui"&&(us.textContent=ed),jr=l(C),gs=d(C,"P",{"data-svelte-h":!0}),T(gs)!=="svelte-zarm0s"&&(gs.innerHTML=td),Rr=l(C),fs=d(C,"P",{"data-svelte-h":!0}),T(fs)!=="svelte-wz8va1"&&(fs.textContent=nd),Ur=l(C),hs=d(C,"UL",{"data-svelte-h":!0}),T(hs)!=="svelte-qpxha0"&&(hs.innerHTML=od),Ir=l(C),_s=d(C,"P",{"data-svelte-h":!0}),T(_s)!=="svelte-86gko0"&&(_s.textContent=sd),Cr=l(C),bs=d(C,"UL",{"data-svelte-h":!0}),T(bs)!=="svelte-13shzai"&&(bs.innerHTML=ad),Zr=l(C),mt=d(C,"DIV",{class:!0});var ss=x(mt);g(vn.$$.fragment,ss),Wr=l(ss),ys=d(ss,"P",{"data-svelte-h":!0}),T(ys)!=="svelte-1r2xt0l"&&(ys.innerHTML=ld),ss.forEach(i),Nr=l(C),dt=d(C,"DIV",{class:!0});var as=x(dt);g(wn.$$.fragment,as),Sr=l(as),Ts=d(as,"P",{"data-svelte-h":!0}),T(Ts)!=="svelte-18vxhwp"&&(Ts.textContent=rd),as.forEach(i),Fr=l(C),ct=d(C,"DIV",{class:!0});var ls=x(ct);g(xn.$$.fragment,ls),Or=l(ls),Ms=d(ls,"P",{"data-svelte-h":!0}),T(Ms)!=="svelte-1sb2z5w"&&(Ms.innerHTML=id),ls.forEach(i),Gr=l(C),ut=d(C,"DIV",{class:!0});var rs=x(ut);g($n.$$.fragment,rs),Xr=l(rs),vs=d(rs,"P",{"data-svelte-h":!0}),T(vs)!=="svelte-h8ck7o"&&(vs.textContent=pd),rs.forEach(i),Vr=l(C),gt=d(C,"DIV",{class:!0});var is=x(gt);g(kn.$$.fragment,is),zr=l(is),ws=d(is,"P",{"data-svelte-h":!0}),T(ws)!=="svelte-1b4tey4"&&(ws.textContent=md),is.forEach(i),qr=l(C),ft=d(C,"DIV",{class:!0});var ps=x(ft);g(Jn.$$.fragment,ps),Lr=l(ps),xs=d(ps,"P",{"data-svelte-h":!0}),T(xs)!=="svelte-1tdm1u4"&&(xs.textContent=dd),ps.forEach(i),C.forEach(i),_l=l(e),g(jn.$$.fragment,e),bl=l(e),Rn=d(e,"P",{"data-svelte-h":!0}),T(Rn)!=="svelte-1tlroh"&&(Rn.textContent=cd),yl=l(e),g(Un.$$.fragment,e),Tl=l(e),N=d(e,"DIV",{class:!0});var be=x(N);g(In.$$.fragment,be),Br=l(be),$s=d(be,"P",{"data-svelte-h":!0}),T($s)!=="svelte-pig4vj"&&($s.textContent=ud),Hr=l(be),ks=d(be,"P",{"data-svelte-h":!0}),T(ks)!=="svelte-au2uqo"&&(ks.innerHTML=gd),Pr=l(be),Js=d(be,"P",{"data-svelte-h":!0}),T(Js)!=="svelte-6mxlp1"&&(Js.innerHTML=fd),Er=l(be),le=d(be,"DIV",{class:!0});var ye=x(le);g(Cn.$$.fragment,ye),Qr=l(ye),js=d(ye,"P",{"data-svelte-h":!0}),T(js)!=="svelte-1ox9av6"&&(js.innerHTML=hd),Dr=l(ye),g(ht.$$.fragment,ye),Yr=l(ye),g(_t.$$.fragment,ye),Ar=l(ye),g(bt.$$.fragment,ye),ye.forEach(i),be.forEach(i),Ml=l(e),g(Zn.$$.fragment,e),vl=l(e),S=d(e,"DIV",{class:!0});var Te=x(S);g(Wn.$$.fragment,Te),Kr=l(Te),Rs=d(Te,"P",{"data-svelte-h":!0}),T(Rs)!=="svelte-lnzl0e"&&(Rs.textContent=_d),ei=l(Te),Us=d(Te,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-au2uqo"&&(Us.innerHTML=bd),ti=l(Te),Is=d(Te,"P",{"data-svelte-h":!0}),T(Is)!=="svelte-6mxlp1"&&(Is.innerHTML=yd),ni=l(Te),re=d(Te,"DIV",{class:!0});var Me=x(re);g(Nn.$$.fragment,Me),oi=l(Me),Cs=d(Me,"P",{"data-svelte-h":!0}),T(Cs)!=="svelte-1xqof9m"&&(Cs.innerHTML=Td),si=l(Me),g(yt.$$.fragment,Me),ai=l(Me),g(Tt.$$.fragment,Me),li=l(Me),g(Mt.$$.fragment,Me),Me.forEach(i),Te.forEach(i),wl=l(e),g(Sn.$$.fragment,e),xl=l(e),F=d(e,"DIV",{class:!0});var ve=x(F);g(Fn.$$.fragment,ve),ri=l(ve),Zs=d(ve,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-t6z30i"&&(Zs.textContent=Md),ii=l(ve),Ws=d(ve,"P",{"data-svelte-h":!0}),T(Ws)!=="svelte-au2uqo"&&(Ws.innerHTML=vd),pi=l(ve),Ns=d(ve,"P",{"data-svelte-h":!0}),T(Ns)!=="svelte-6mxlp1"&&(Ns.innerHTML=wd),mi=l(ve),ie=d(ve,"DIV",{class:!0});var we=x(ie);g(On.$$.fragment,we),di=l(we),Ss=d(we,"P",{"data-svelte-h":!0}),T(Ss)!=="svelte-n65k7h"&&(Ss.innerHTML=xd),ci=l(we),g(vt.$$.fragment,we),ui=l(we),g(wt.$$.fragment,we),gi=l(we),g(xt.$$.fragment,we),we.forEach(i),ve.forEach(i),$l=l(e),g(Gn.$$.fragment,e),kl=l(e),O=d(e,"DIV",{class:!0});var xe=x(O);g(Xn.$$.fragment,xe),fi=l(xe),Fs=d(xe,"P",{"data-svelte-h":!0}),T(Fs)!=="svelte-ixbo5n"&&(Fs.textContent=$d),hi=l(xe),Os=d(xe,"P",{"data-svelte-h":!0}),T(Os)!=="svelte-au2uqo"&&(Os.innerHTML=kd),_i=l(xe),Gs=d(xe,"P",{"data-svelte-h":!0}),T(Gs)!=="svelte-6mxlp1"&&(Gs.innerHTML=Jd),bi=l(xe),W=d(xe,"DIV",{class:!0});var ae=x(W);g(Vn.$$.fragment,ae),yi=l(ae),Xs=d(ae,"P",{"data-svelte-h":!0}),T(Xs)!=="svelte-1plx9t"&&(Xs.innerHTML=jd),Ti=l(ae),g($t.$$.fragment,ae),Mi=l(ae),g(kt.$$.fragment,ae),vi=l(ae),g(Jt.$$.fragment,ae),wi=l(ae),g(jt.$$.fragment,ae),ae.forEach(i),xe.forEach(i),Jl=l(e),g(zn.$$.fragment,e),jl=l(e),G=d(e,"DIV",{class:!0});var $e=x(G);g(qn.$$.fragment,$e),xi=l($e),Vs=d($e,"P",{"data-svelte-h":!0}),T(Vs)!=="svelte-1l2d2mz"&&(Vs.textContent=Rd),$i=l($e),zs=d($e,"P",{"data-svelte-h":!0}),T(zs)!=="svelte-au2uqo"&&(zs.innerHTML=Ud),ki=l($e),qs=d($e,"P",{"data-svelte-h":!0}),T(qs)!=="svelte-6mxlp1"&&(qs.innerHTML=Id),Ji=l($e),pe=d($e,"DIV",{class:!0});var ke=x(pe);g(Ln.$$.fragment,ke),ji=l(ke),Ls=d(ke,"P",{"data-svelte-h":!0}),T(Ls)!=="svelte-xk2xch"&&(Ls.innerHTML=Cd),Ri=l(ke),g(Rt.$$.fragment,ke),Ui=l(ke),g(Ut.$$.fragment,ke),Ii=l(ke),g(It.$$.fragment,ke),ke.forEach(i),$e.forEach(i),Rl=l(e),g(Bn.$$.fragment,e),Ul=l(e),X=d(e,"DIV",{class:!0});var Je=x(X);g(Hn.$$.fragment,Je),Ci=l(Je),Bs=d(Je,"P",{"data-svelte-h":!0}),T(Bs)!=="svelte-1oobrgk"&&(Bs.textContent=Zd),Zi=l(Je),Hs=d(Je,"P",{"data-svelte-h":!0}),T(Hs)!=="svelte-au2uqo"&&(Hs.innerHTML=Wd),Wi=l(Je),Ps=d(Je,"P",{"data-svelte-h":!0}),T(Ps)!=="svelte-6mxlp1"&&(Ps.innerHTML=Nd),Ni=l(Je),Ae=d(Je,"DIV",{class:!0});var ot=x(Ae);g(Pn.$$.fragment,ot),Si=l(ot),Es=d(ot,"P",{"data-svelte-h":!0}),T(Es)!=="svelte-qesv8n"&&(Es.innerHTML=Sd),Fi=l(ot),g(Ct.$$.fragment,ot),Oi=l(ot),g(Zt.$$.fragment,ot),ot.forEach(i),Je.forEach(i),Il=l(e),g(En.$$.fragment,e),Cl=l(e),V=d(e,"DIV",{class:!0});var je=x(V);g(Qn.$$.fragment,je),Gi=l(je),Qs=d(je,"P",{"data-svelte-h":!0}),T(Qs)!=="svelte-1hsozsl"&&(Qs.textContent=Fd),Xi=l(je),Ds=d(je,"P",{"data-svelte-h":!0}),T(Ds)!=="svelte-au2uqo"&&(Ds.innerHTML=Od),Vi=l(je),Ys=d(je,"P",{"data-svelte-h":!0}),T(Ys)!=="svelte-6mxlp1"&&(Ys.innerHTML=Gd),zi=l(je),me=d(je,"DIV",{class:!0});var Re=x(me);g(Dn.$$.fragment,Re),qi=l(Re),As=d(Re,"P",{"data-svelte-h":!0}),T(As)!=="svelte-1dng7rw"&&(As.innerHTML=Xd),Li=l(Re),g(Wt.$$.fragment,Re),Bi=l(Re),g(Nt.$$.fragment,Re),Hi=l(Re),g(St.$$.fragment,Re),Re.forEach(i),je.forEach(i),Zl=l(e),g(Yn.$$.fragment,e),Wl=l(e),An=d(e,"P",{"data-svelte-h":!0}),T(An)!=="svelte-1h2y3wu"&&(An.textContent=Vd),Nl=l(e),g(Kn.$$.fragment,e),Sl=l(e),z=d(e,"DIV",{class:!0});var Ue=x(z);g(eo.$$.fragment,Ue),Pi=l(Ue),Ks=d(Ue,"P",{"data-svelte-h":!0}),T(Ks)!=="svelte-lp0at6"&&(Ks.textContent=zd),Ei=l(Ue),ea=d(Ue,"P",{"data-svelte-h":!0}),T(ea)!=="svelte-au2uqo"&&(ea.innerHTML=qd),Qi=l(Ue),ta=d(Ue,"P",{"data-svelte-h":!0}),T(ta)!=="svelte-6mxlp1"&&(ta.innerHTML=Ld),Di=l(Ue),de=d(Ue,"DIV",{class:!0});var Ie=x(de);g(to.$$.fragment,Ie),Yi=l(Ie),na=d(Ie,"P",{"data-svelte-h":!0}),T(na)!=="svelte-1azuqx"&&(na.innerHTML=Bd),Ai=l(Ie),g(Ft.$$.fragment,Ie),Ki=l(Ie),g(Ot.$$.fragment,Ie),ep=l(Ie),g(Gt.$$.fragment,Ie),Ie.forEach(i),Ue.forEach(i),Fl=l(e),g(no.$$.fragment,e),Ol=l(e),q=d(e,"DIV",{class:!0});var Ce=x(q);g(oo.$$.fragment,Ce),tp=l(Ce),oa=d(Ce,"P",{"data-svelte-h":!0}),T(oa)!=="svelte-mw2y5y"&&(oa.textContent=Hd),np=l(Ce),sa=d(Ce,"P",{"data-svelte-h":!0}),T(sa)!=="svelte-au2uqo"&&(sa.innerHTML=Pd),op=l(Ce),aa=d(Ce,"P",{"data-svelte-h":!0}),T(aa)!=="svelte-6mxlp1"&&(aa.innerHTML=Ed),sp=l(Ce),ce=d(Ce,"DIV",{class:!0});var Ze=x(ce);g(so.$$.fragment,Ze),ap=l(Ze),la=d(Ze,"P",{"data-svelte-h":!0}),T(la)!=="svelte-1s27jle"&&(la.innerHTML=Qd),lp=l(Ze),g(Xt.$$.fragment,Ze),rp=l(Ze),g(Vt.$$.fragment,Ze),ip=l(Ze),g(zt.$$.fragment,Ze),Ze.forEach(i),Ce.forEach(i),Gl=l(e),g(ao.$$.fragment,e),Xl=l(e),lo=d(e,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-liyjdz"&&(lo.textContent=Dd),Vl=l(e),g(ro.$$.fragment,e),zl=l(e),L=d(e,"DIV",{class:!0});var We=x(L);g(io.$$.fragment,We),pp=l(We),ra=d(We,"P",{"data-svelte-h":!0}),T(ra)!=="svelte-yleggj"&&(ra.textContent=Yd),mp=l(We),ia=d(We,"P",{"data-svelte-h":!0}),T(ia)!=="svelte-au2uqo"&&(ia.innerHTML=Ad),dp=l(We),pa=d(We,"P",{"data-svelte-h":!0}),T(pa)!=="svelte-6mxlp1"&&(pa.innerHTML=Kd),cp=l(We),ue=d(We,"DIV",{class:!0});var Ne=x(ue);g(po.$$.fragment,Ne),up=l(Ne),ma=d(Ne,"P",{"data-svelte-h":!0}),T(ma)!=="svelte-p67kxo"&&(ma.innerHTML=ec),gp=l(Ne),g(qt.$$.fragment,Ne),fp=l(Ne),g(Lt.$$.fragment,Ne),hp=l(Ne),g(Bt.$$.fragment,Ne),Ne.forEach(i),We.forEach(i),ql=l(e),g(mo.$$.fragment,e),Ll=l(e),B=d(e,"DIV",{class:!0});var Se=x(B);g(co.$$.fragment,Se),_p=l(Se),da=d(Se,"P",{"data-svelte-h":!0}),T(da)!=="svelte-lyybxc"&&(da.textContent=tc),bp=l(Se),ca=d(Se,"P",{"data-svelte-h":!0}),T(ca)!=="svelte-au2uqo"&&(ca.innerHTML=nc),yp=l(Se),ua=d(Se,"P",{"data-svelte-h":!0}),T(ua)!=="svelte-6mxlp1"&&(ua.innerHTML=oc),Tp=l(Se),Ke=d(Se,"DIV",{class:!0});var st=x(Ke);g(uo.$$.fragment,st),Mp=l(st),ga=d(st,"P",{"data-svelte-h":!0}),T(ga)!=="svelte-18aced7"&&(ga.innerHTML=sc),vp=l(st),g(Ht.$$.fragment,st),wp=l(st),g(Pt.$$.fragment,st),st.forEach(i),Se.forEach(i),Bl=l(e),g(go.$$.fragment,e),Hl=l(e),H=d(e,"DIV",{class:!0});var Fe=x(H);g(fo.$$.fragment,Fe),xp=l(Fe),fa=d(Fe,"P",{"data-svelte-h":!0}),T(fa)!=="svelte-xbkga4"&&(fa.textContent=ac),$p=l(Fe),ha=d(Fe,"P",{"data-svelte-h":!0}),T(ha)!=="svelte-au2uqo"&&(ha.innerHTML=lc),kp=l(Fe),_a=d(Fe,"P",{"data-svelte-h":!0}),T(_a)!=="svelte-6mxlp1"&&(_a.innerHTML=rc),Jp=l(Fe),et=d(Fe,"DIV",{class:!0});var at=x(et);g(ho.$$.fragment,at),jp=l(at),ba=d(at,"P",{"data-svelte-h":!0}),T(ba)!=="svelte-1szjv6u"&&(ba.innerHTML=ic),Rp=l(at),g(Et.$$.fragment,at),Up=l(at),g(Qt.$$.fragment,at),at.forEach(i),Fe.forEach(i),Pl=l(e),g(_o.$$.fragment,e),El=l(e),P=d(e,"DIV",{class:!0});var Oe=x(P);g(bo.$$.fragment,Oe),Ip=l(Oe),ya=d(Oe,"P",{"data-svelte-h":!0}),T(ya)!=="svelte-135bhh9"&&(ya.textContent=pc),Cp=l(Oe),Ta=d(Oe,"P",{"data-svelte-h":!0}),T(Ta)!=="svelte-au2uqo"&&(Ta.innerHTML=mc),Zp=l(Oe),Ma=d(Oe,"P",{"data-svelte-h":!0}),T(Ma)!=="svelte-6mxlp1"&&(Ma.innerHTML=dc),Wp=l(Oe),ge=d(Oe,"DIV",{class:!0});var Ge=x(ge);g(yo.$$.fragment,Ge),Np=l(Ge),va=d(Ge,"P",{"data-svelte-h":!0}),T(va)!=="svelte-1e3zkhy"&&(va.innerHTML=cc),Sp=l(Ge),g(Dt.$$.fragment,Ge),Fp=l(Ge),g(Yt.$$.fragment,Ge),Op=l(Ge),g(At.$$.fragment,Ge),Ge.forEach(i),Oe.forEach(i),Ql=l(e),g(To.$$.fragment,e),Dl=l(e),E=d(e,"DIV",{class:!0});var Xe=x(E);g(Mo.$$.fragment,Xe),Gp=l(Xe),wa=d(Xe,"P",{"data-svelte-h":!0}),T(wa)!=="svelte-1bhc8y0"&&(wa.textContent=uc),Xp=l(Xe),xa=d(Xe,"P",{"data-svelte-h":!0}),T(xa)!=="svelte-au2uqo"&&(xa.innerHTML=gc),Vp=l(Xe),$a=d(Xe,"P",{"data-svelte-h":!0}),T($a)!=="svelte-6mxlp1"&&($a.innerHTML=fc),zp=l(Xe),tt=d(Xe,"DIV",{class:!0});var lt=x(tt);g(vo.$$.fragment,lt),qp=l(lt),ka=d(lt,"P",{"data-svelte-h":!0}),T(ka)!=="svelte-1fuxgrl"&&(ka.innerHTML=hc),Lp=l(lt),g(Kt.$$.fragment,lt),Bp=l(lt),g(en.$$.fragment,lt),lt.forEach(i),Xe.forEach(i),Yl=l(e),g(wo.$$.fragment,e),Al=l(e),xo=d(e,"P",{"data-svelte-h":!0}),T(xo)!=="svelte-1gk58z"&&(xo.textContent=_c),Kl=l(e),g($o.$$.fragment,e),er=l(e),Q=d(e,"DIV",{class:!0});var Ve=x(Q);g(ko.$$.fragment,Ve),Hp=l(Ve),Ja=d(Ve,"P",{"data-svelte-h":!0}),T(Ja)!=="svelte-1yhfevg"&&(Ja.textContent=bc),Pp=l(Ve),ja=d(Ve,"P",{"data-svelte-h":!0}),T(ja)!=="svelte-au2uqo"&&(ja.innerHTML=yc),Ep=l(Ve),Ra=d(Ve,"P",{"data-svelte-h":!0}),T(Ra)!=="svelte-6mxlp1"&&(Ra.innerHTML=Tc),Qp=l(Ve),fe=d(Ve,"DIV",{class:!0});var ze=x(fe);g(Jo.$$.fragment,ze),Dp=l(ze),Ua=d(ze,"P",{"data-svelte-h":!0}),T(Ua)!=="svelte-11xalzp"&&(Ua.innerHTML=Mc),Yp=l(ze),g(tn.$$.fragment,ze),Ap=l(ze),g(nn.$$.fragment,ze),Kp=l(ze),g(on.$$.fragment,ze),ze.forEach(i),Ve.forEach(i),tr=l(e),g(jo.$$.fragment,e),nr=l(e),D=d(e,"DIV",{class:!0});var qe=x(D);g(Ro.$$.fragment,qe),em=l(qe),Ia=d(qe,"P",{"data-svelte-h":!0}),T(Ia)!=="svelte-80a148"&&(Ia.textContent=vc),tm=l(qe),Ca=d(qe,"P",{"data-svelte-h":!0}),T(Ca)!=="svelte-au2uqo"&&(Ca.innerHTML=wc),nm=l(qe),Za=d(qe,"P",{"data-svelte-h":!0}),T(Za)!=="svelte-6mxlp1"&&(Za.innerHTML=xc),om=l(qe),nt=d(qe,"DIV",{class:!0});var rt=x(nt);g(Uo.$$.fragment,rt),sm=l(rt),Wa=d(rt,"P",{"data-svelte-h":!0}),T(Wa)!=="svelte-eywb10"&&(Wa.innerHTML=$c),am=l(rt),g(sn.$$.fragment,rt),lm=l(rt),g(an.$$.fragment,rt),rt.forEach(i),qe.forEach(i),or=l(e),g(Io.$$.fragment,e),sr=l(e),Co=d(e,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-1n8n3ms"&&(Co.textContent=kc),ar=l(e),g(Zo.$$.fragment,e),lr=l(e),Y=d(e,"DIV",{class:!0});var Le=x(Y);g(Wo.$$.fragment,Le),rm=l(Le),Na=d(Le,"P",{"data-svelte-h":!0}),T(Na)!=="svelte-5pmyjn"&&(Na.textContent=Jc),im=l(Le),Sa=d(Le,"P",{"data-svelte-h":!0}),T(Sa)!=="svelte-au2uqo"&&(Sa.innerHTML=jc),pm=l(Le),Fa=d(Le,"P",{"data-svelte-h":!0}),T(Fa)!=="svelte-6mxlp1"&&(Fa.innerHTML=Rc),mm=l(Le),he=d(Le,"DIV",{class:!0});var Be=x(he);g(No.$$.fragment,Be),dm=l(Be),Oa=d(Be,"P",{"data-svelte-h":!0}),T(Oa)!=="svelte-1usnw5b"&&(Oa.innerHTML=Uc),cm=l(Be),g(ln.$$.fragment,Be),um=l(Be),g(rn.$$.fragment,Be),gm=l(Be),g(pn.$$.fragment,Be),Be.forEach(i),Le.forEach(i),rr=l(e),g(So.$$.fragment,e),ir=l(e),A=d(e,"DIV",{class:!0});var He=x(A);g(Fo.$$.fragment,He),fm=l(He),Ga=d(He,"P",{"data-svelte-h":!0}),T(Ga)!=="svelte-1rhquq6"&&(Ga.textContent=Ic),hm=l(He),Xa=d(He,"P",{"data-svelte-h":!0}),T(Xa)!=="svelte-au2uqo"&&(Xa.innerHTML=Cc),_m=l(He),Va=d(He,"P",{"data-svelte-h":!0}),T(Va)!=="svelte-6mxlp1"&&(Va.innerHTML=Zc),bm=l(He),_e=d(He,"DIV",{class:!0});var Pe=x(_e);g(Oo.$$.fragment,Pe),ym=l(Pe),za=d(Pe,"P",{"data-svelte-h":!0}),T(za)!=="svelte-iqwqsz"&&(za.innerHTML=Wc),Tm=l(Pe),g(mn.$$.fragment,Pe),Mm=l(Pe),g(dn.$$.fragment,Pe),vm=l(Pe),g(cn.$$.fragment,Pe),Pe.forEach(i),He.forEach(i),pr=l(e),g(Go.$$.fragment,e),mr=l(e),g(Xo.$$.fragment,e),dr=l(e),K=d(e,"DIV",{class:!0});var Ee=x(K);g(Vo.$$.fragment,Ee),wm=l(Ee),qa=d(Ee,"P",{"data-svelte-h":!0}),T(qa)!=="svelte-o3cjct"&&(qa.innerHTML=Nc),xm=l(Ee),La=d(Ee,"P",{"data-svelte-h":!0}),T(La)!=="svelte-au2uqo"&&(La.innerHTML=Sc),$m=l(Ee),Ba=d(Ee,"P",{"data-svelte-h":!0}),T(Ba)!=="svelte-6mxlp1"&&(Ba.innerHTML=Fc),km=l(Ee),un=d(Ee,"DIV",{class:!0});var ms=x(un);g(zo.$$.fragment,ms),Jm=l(ms),Ha=d(ms,"P",{"data-svelte-h":!0}),T(Ha)!=="svelte-v78lg8"&&(Ha.textContent=Oc),ms.forEach(i),Ee.forEach(i),cr=l(e),g(qo.$$.fragment,e),ur=l(e),ee=d(e,"DIV",{class:!0});var Qe=x(ee);g(Lo.$$.fragment,Qe),jm=l(Qe),Pa=d(Qe,"P",{"data-svelte-h":!0}),T(Pa)!=="svelte-1ds9yih"&&(Pa.innerHTML=Gc),Rm=l(Qe),Ea=d(Qe,"P",{"data-svelte-h":!0}),T(Ea)!=="svelte-au2uqo"&&(Ea.innerHTML=Xc),Um=l(Qe),Qa=d(Qe,"P",{"data-svelte-h":!0}),T(Qa)!=="svelte-6mxlp1"&&(Qa.innerHTML=Vc),Im=l(Qe),gn=d(Qe,"DIV",{class:!0});var ds=x(gn);g(Bo.$$.fragment,ds),Cm=l(ds),Da=d(ds,"P",{"data-svelte-h":!0}),T(Da)!=="svelte-v78lg8"&&(Da.textContent=zc),ds.forEach(i),Qe.forEach(i),gr=l(e),g(Ho.$$.fragment,e),fr=l(e),te=d(e,"DIV",{class:!0});var De=x(te);g(Po.$$.fragment,De),Zm=l(De),Ya=d(De,"P",{"data-svelte-h":!0}),T(Ya)!=="svelte-1jlenwy"&&(Ya.innerHTML=qc),Wm=l(De),Aa=d(De,"P",{"data-svelte-h":!0}),T(Aa)!=="svelte-au2uqo"&&(Aa.innerHTML=Lc),Nm=l(De),Ka=d(De,"P",{"data-svelte-h":!0}),T(Ka)!=="svelte-6mxlp1"&&(Ka.innerHTML=Bc),Sm=l(De),fn=d(De,"DIV",{class:!0});var cs=x(fn);g(Eo.$$.fragment,cs),Fm=l(cs),el=d(cs,"P",{"data-svelte-h":!0}),T(el)!=="svelte-v78lg8"&&(el.textContent=Hc),cs.forEach(i),De.forEach(i),hr=l(e),g(Qo.$$.fragment,e),_r=l(e),ne=d(e,"DIV",{class:!0});var Ye=x(ne);g(Do.$$.fragment,Ye),Om=l(Ye),tl=d(Ye,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-tg08kp"&&(tl.innerHTML=Pc),Gm=l(Ye),nl=d(Ye,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-au2uqo"&&(nl.innerHTML=Ec),Xm=l(Ye),ol=d(Ye,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-6mxlp1"&&(ol.innerHTML=Qc),Vm=l(Ye),hn=d(Ye,"DIV",{class:!0});var xr=x(hn);g(Yo.$$.fragment,xr),zm=l(xr),sl=d(xr,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-v78lg8"&&(sl.textContent=Dc),xr.forEach(i),Ye.forEach(i),br=l(e),g(Ao.$$.fragment,e),yr=l(e),oe=d(e,"DIV",{class:!0});var it=x(oe);g(Ko.$$.fragment,it),qm=l(it),al=d(it,"P",{"data-svelte-h":!0}),T(al)!=="svelte-zcp8nz"&&(al.innerHTML=Yc),Lm=l(it),ll=d(it,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-au2uqo"&&(ll.innerHTML=Ac),Bm=l(it),rl=d(it,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-6mxlp1"&&(rl.innerHTML=Kc),Hm=l(it),_n=d(it,"DIV",{class:!0});var $r=x(_n);g(es.$$.fragment,$r),Pm=l($r),il=d($r,"P",{"data-svelte-h":!0}),T(il)!=="svelte-v78lg8"&&(il.textContent=eu),$r.forEach(i),it.forEach(i),Tr=l(e),g(ts.$$.fragment,e),Mr=l(e),se=d(e,"DIV",{class:!0});var pt=x(se);g(ns.$$.fragment,pt),Em=l(pt),pl=d(pt,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-1d0xpim"&&(pl.innerHTML=tu),Qm=l(pt),ml=d(pt,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-au2uqo"&&(ml.innerHTML=nu),Dm=l(pt),dl=d(pt,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-6mxlp1"&&(dl.innerHTML=ou),Ym=l(pt),bn=d(pt,"DIV",{class:!0});var kr=x(bn);g(os.$$.fragment,kr),Am=l(kr),cl=d(kr,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-v78lg8"&&(cl.textContent=su),kr.forEach(i),pt.forEach(i),vr=l(e),ul=d(e,"P",{}),x(ul).forEach(i),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",rg),$(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,M,p),c(e,r,p),c(e,s,p),f(y,e,p),c(e,t,p),f(v,e,p),c(e,gl,p),c(e,yn,p),c(e,fl,p),f(Tn,e,p),c(e,hl,p),c(e,I,p),f(Mn,I,null),o(I,Jr),o(I,us),o(I,jr),o(I,gs),o(I,Rr),o(I,fs),o(I,Ur),o(I,hs),o(I,Ir),o(I,_s),o(I,Cr),o(I,bs),o(I,Zr),o(I,mt),f(vn,mt,null),o(mt,Wr),o(mt,ys),o(I,Nr),o(I,dt),f(wn,dt,null),o(dt,Sr),o(dt,Ts),o(I,Fr),o(I,ct),f(xn,ct,null),o(ct,Or),o(ct,Ms),o(I,Gr),o(I,ut),f($n,ut,null),o(ut,Xr),o(ut,vs),o(I,Vr),o(I,gt),f(kn,gt,null),o(gt,zr),o(gt,ws),o(I,qr),o(I,ft),f(Jn,ft,null),o(ft,Lr),o(ft,xs),c(e,_l,p),f(jn,e,p),c(e,bl,p),c(e,Rn,p),c(e,yl,p),f(Un,e,p),c(e,Tl,p),c(e,N,p),f(In,N,null),o(N,Br),o(N,$s),o(N,Hr),o(N,ks),o(N,Pr),o(N,Js),o(N,Er),o(N,le),f(Cn,le,null),o(le,Qr),o(le,js),o(le,Dr),f(ht,le,null),o(le,Yr),f(_t,le,null),o(le,Ar),f(bt,le,null),c(e,Ml,p),f(Zn,e,p),c(e,vl,p),c(e,S,p),f(Wn,S,null),o(S,Kr),o(S,Rs),o(S,ei),o(S,Us),o(S,ti),o(S,Is),o(S,ni),o(S,re),f(Nn,re,null),o(re,oi),o(re,Cs),o(re,si),f(yt,re,null),o(re,ai),f(Tt,re,null),o(re,li),f(Mt,re,null),c(e,wl,p),f(Sn,e,p),c(e,xl,p),c(e,F,p),f(Fn,F,null),o(F,ri),o(F,Zs),o(F,ii),o(F,Ws),o(F,pi),o(F,Ns),o(F,mi),o(F,ie),f(On,ie,null),o(ie,di),o(ie,Ss),o(ie,ci),f(vt,ie,null),o(ie,ui),f(wt,ie,null),o(ie,gi),f(xt,ie,null),c(e,$l,p),f(Gn,e,p),c(e,kl,p),c(e,O,p),f(Xn,O,null),o(O,fi),o(O,Fs),o(O,hi),o(O,Os),o(O,_i),o(O,Gs),o(O,bi),o(O,W),f(Vn,W,null),o(W,yi),o(W,Xs),o(W,Ti),f($t,W,null),o(W,Mi),f(kt,W,null),o(W,vi),f(Jt,W,null),o(W,wi),f(jt,W,null),c(e,Jl,p),f(zn,e,p),c(e,jl,p),c(e,G,p),f(qn,G,null),o(G,xi),o(G,Vs),o(G,$i),o(G,zs),o(G,ki),o(G,qs),o(G,Ji),o(G,pe),f(Ln,pe,null),o(pe,ji),o(pe,Ls),o(pe,Ri),f(Rt,pe,null),o(pe,Ui),f(Ut,pe,null),o(pe,Ii),f(It,pe,null),c(e,Rl,p),f(Bn,e,p),c(e,Ul,p),c(e,X,p),f(Hn,X,null),o(X,Ci),o(X,Bs),o(X,Zi),o(X,Hs),o(X,Wi),o(X,Ps),o(X,Ni),o(X,Ae),f(Pn,Ae,null),o(Ae,Si),o(Ae,Es),o(Ae,Fi),f(Ct,Ae,null),o(Ae,Oi),f(Zt,Ae,null),c(e,Il,p),f(En,e,p),c(e,Cl,p),c(e,V,p),f(Qn,V,null),o(V,Gi),o(V,Qs),o(V,Xi),o(V,Ds),o(V,Vi),o(V,Ys),o(V,zi),o(V,me),f(Dn,me,null),o(me,qi),o(me,As),o(me,Li),f(Wt,me,null),o(me,Bi),f(Nt,me,null),o(me,Hi),f(St,me,null),c(e,Zl,p),f(Yn,e,p),c(e,Wl,p),c(e,An,p),c(e,Nl,p),f(Kn,e,p),c(e,Sl,p),c(e,z,p),f(eo,z,null),o(z,Pi),o(z,Ks),o(z,Ei),o(z,ea),o(z,Qi),o(z,ta),o(z,Di),o(z,de),f(to,de,null),o(de,Yi),o(de,na),o(de,Ai),f(Ft,de,null),o(de,Ki),f(Ot,de,null),o(de,ep),f(Gt,de,null),c(e,Fl,p),f(no,e,p),c(e,Ol,p),c(e,q,p),f(oo,q,null),o(q,tp),o(q,oa),o(q,np),o(q,sa),o(q,op),o(q,aa),o(q,sp),o(q,ce),f(so,ce,null),o(ce,ap),o(ce,la),o(ce,lp),f(Xt,ce,null),o(ce,rp),f(Vt,ce,null),o(ce,ip),f(zt,ce,null),c(e,Gl,p),f(ao,e,p),c(e,Xl,p),c(e,lo,p),c(e,Vl,p),f(ro,e,p),c(e,zl,p),c(e,L,p),f(io,L,null),o(L,pp),o(L,ra),o(L,mp),o(L,ia),o(L,dp),o(L,pa),o(L,cp),o(L,ue),f(po,ue,null),o(ue,up),o(ue,ma),o(ue,gp),f(qt,ue,null),o(ue,fp),f(Lt,ue,null),o(ue,hp),f(Bt,ue,null),c(e,ql,p),f(mo,e,p),c(e,Ll,p),c(e,B,p),f(co,B,null),o(B,_p),o(B,da),o(B,bp),o(B,ca),o(B,yp),o(B,ua),o(B,Tp),o(B,Ke),f(uo,Ke,null),o(Ke,Mp),o(Ke,ga),o(Ke,vp),f(Ht,Ke,null),o(Ke,wp),f(Pt,Ke,null),c(e,Bl,p),f(go,e,p),c(e,Hl,p),c(e,H,p),f(fo,H,null),o(H,xp),o(H,fa),o(H,$p),o(H,ha),o(H,kp),o(H,_a),o(H,Jp),o(H,et),f(ho,et,null),o(et,jp),o(et,ba),o(et,Rp),f(Et,et,null),o(et,Up),f(Qt,et,null),c(e,Pl,p),f(_o,e,p),c(e,El,p),c(e,P,p),f(bo,P,null),o(P,Ip),o(P,ya),o(P,Cp),o(P,Ta),o(P,Zp),o(P,Ma),o(P,Wp),o(P,ge),f(yo,ge,null),o(ge,Np),o(ge,va),o(ge,Sp),f(Dt,ge,null),o(ge,Fp),f(Yt,ge,null),o(ge,Op),f(At,ge,null),c(e,Ql,p),f(To,e,p),c(e,Dl,p),c(e,E,p),f(Mo,E,null),o(E,Gp),o(E,wa),o(E,Xp),o(E,xa),o(E,Vp),o(E,$a),o(E,zp),o(E,tt),f(vo,tt,null),o(tt,qp),o(tt,ka),o(tt,Lp),f(Kt,tt,null),o(tt,Bp),f(en,tt,null),c(e,Yl,p),f(wo,e,p),c(e,Al,p),c(e,xo,p),c(e,Kl,p),f($o,e,p),c(e,er,p),c(e,Q,p),f(ko,Q,null),o(Q,Hp),o(Q,Ja),o(Q,Pp),o(Q,ja),o(Q,Ep),o(Q,Ra),o(Q,Qp),o(Q,fe),f(Jo,fe,null),o(fe,Dp),o(fe,Ua),o(fe,Yp),f(tn,fe,null),o(fe,Ap),f(nn,fe,null),o(fe,Kp),f(on,fe,null),c(e,tr,p),f(jo,e,p),c(e,nr,p),c(e,D,p),f(Ro,D,null),o(D,em),o(D,Ia),o(D,tm),o(D,Ca),o(D,nm),o(D,Za),o(D,om),o(D,nt),f(Uo,nt,null),o(nt,sm),o(nt,Wa),o(nt,am),f(sn,nt,null),o(nt,lm),f(an,nt,null),c(e,or,p),f(Io,e,p),c(e,sr,p),c(e,Co,p),c(e,ar,p),f(Zo,e,p),c(e,lr,p),c(e,Y,p),f(Wo,Y,null),o(Y,rm),o(Y,Na),o(Y,im),o(Y,Sa),o(Y,pm),o(Y,Fa),o(Y,mm),o(Y,he),f(No,he,null),o(he,dm),o(he,Oa),o(he,cm),f(ln,he,null),o(he,um),f(rn,he,null),o(he,gm),f(pn,he,null),c(e,rr,p),f(So,e,p),c(e,ir,p),c(e,A,p),f(Fo,A,null),o(A,fm),o(A,Ga),o(A,hm),o(A,Xa),o(A,_m),o(A,Va),o(A,bm),o(A,_e),f(Oo,_e,null),o(_e,ym),o(_e,za),o(_e,Tm),f(mn,_e,null),o(_e,Mm),f(dn,_e,null),o(_e,vm),f(cn,_e,null),c(e,pr,p),f(Go,e,p),c(e,mr,p),f(Xo,e,p),c(e,dr,p),c(e,K,p),f(Vo,K,null),o(K,wm),o(K,qa),o(K,xm),o(K,La),o(K,$m),o(K,Ba),o(K,km),o(K,un),f(zo,un,null),o(un,Jm),o(un,Ha),c(e,cr,p),f(qo,e,p),c(e,ur,p),c(e,ee,p),f(Lo,ee,null),o(ee,jm),o(ee,Pa),o(ee,Rm),o(ee,Ea),o(ee,Um),o(ee,Qa),o(ee,Im),o(ee,gn),f(Bo,gn,null),o(gn,Cm),o(gn,Da),c(e,gr,p),f(Ho,e,p),c(e,fr,p),c(e,te,p),f(Po,te,null),o(te,Zm),o(te,Ya),o(te,Wm),o(te,Aa),o(te,Nm),o(te,Ka),o(te,Sm),o(te,fn),f(Eo,fn,null),o(fn,Fm),o(fn,el),c(e,hr,p),f(Qo,e,p),c(e,_r,p),c(e,ne,p),f(Do,ne,null),o(ne,Om),o(ne,tl),o(ne,Gm),o(ne,nl),o(ne,Xm),o(ne,ol),o(ne,Vm),o(ne,hn),f(Yo,hn,null),o(hn,zm),o(hn,sl),c(e,br,p),f(Ao,e,p),c(e,yr,p),c(e,oe,p),f(Ko,oe,null),o(oe,qm),o(oe,al),o(oe,Lm),o(oe,ll),o(oe,Bm),o(oe,rl),o(oe,Hm),o(oe,_n),f(es,_n,null),o(_n,Pm),o(_n,il),c(e,Tr,p),f(ts,e,p),c(e,Mr,p),c(e,se,p),f(ns,se,null),o(se,Em),o(se,pl),o(se,Qm),o(se,ml),o(se,Dm),o(se,dl),o(se,Ym),o(se,bn),f(os,bn,null),o(bn,Am),o(bn,cl),c(e,vr,p),c(e,ul,p),wr=!0},p(e,[p]){const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),ht.$set(C);const ss={};p&2&&(ss.$$scope={dirty:p,ctx:e}),_t.$set(ss);const as={};p&2&&(as.$$scope={dirty:p,ctx:e}),bt.$set(as);const ls={};p&2&&(ls.$$scope={dirty:p,ctx:e}),yt.$set(ls);const rs={};p&2&&(rs.$$scope={dirty:p,ctx:e}),Tt.$set(rs);const is={};p&2&&(is.$$scope={dirty:p,ctx:e}),Mt.$set(is);const ps={};p&2&&(ps.$$scope={dirty:p,ctx:e}),vt.$set(ps);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),wt.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),xt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),$t.$set(Te);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),kt.$set(Me);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),Jt.$set(ve);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),jt.$set(we);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),Rt.$set(xe);const ae={};p&2&&(ae.$$scope={dirty:p,ctx:e}),Ut.$set(ae);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),It.$set($e);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),Ct.$set(ke);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Zt.$set(Je);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:e}),Wt.$set(ot);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),Nt.$set(je);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),St.$set(Re);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Ft.$set(Ue);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),Ot.$set(Ie);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),Gt.$set(Ce);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),Xt.$set(Ze);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Vt.$set(We);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),zt.$set(Ne);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),qt.$set(Se);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),Lt.$set(st);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),Bt.$set(Fe);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),Ht.$set(at);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),Pt.$set(Oe);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Et.$set(Ge);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Qt.$set(Xe);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),Dt.$set(lt);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),Yt.$set(Ve);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),At.$set(ze);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),Kt.$set(qe);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:e}),en.$set(rt);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),tn.$set(Le);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),nn.$set(Be);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),on.$set(He);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),sn.$set(Pe);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),an.$set(Ee);const ms={};p&2&&(ms.$$scope={dirty:p,ctx:e}),ln.$set(ms);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),rn.$set(Qe);const ds={};p&2&&(ds.$$scope={dirty:p,ctx:e}),pn.$set(ds);const De={};p&2&&(De.$$scope={dirty:p,ctx:e}),mn.$set(De);const cs={};p&2&&(cs.$$scope={dirty:p,ctx:e}),dn.$set(cs);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),cn.$set(Ye)},i(e){wr||(h(y.$$.fragment,e),h(v.$$.fragment,e),h(Tn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(wn.$$.fragment,e),h(xn.$$.fragment,e),h($n.$$.fragment,e),h(kn.$$.fragment,e),h(Jn.$$.fragment,e),h(jn.$$.fragment,e),h(Un.$$.fragment,e),h(In.$$.fragment,e),h(Cn.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(bt.$$.fragment,e),h(Zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Nn.$$.fragment,e),h(yt.$$.fragment,e),h(Tt.$$.fragment,e),h(Mt.$$.fragment,e),h(Sn.$$.fragment,e),h(Fn.$$.fragment,e),h(On.$$.fragment,e),h(vt.$$.fragment,e),h(wt.$$.fragment,e),h(xt.$$.fragment,e),h(Gn.$$.fragment,e),h(Xn.$$.fragment,e),h(Vn.$$.fragment,e),h($t.$$.fragment,e),h(kt.$$.fragment,e),h(Jt.$$.fragment,e),h(jt.$$.fragment,e),h(zn.$$.fragment,e),h(qn.$$.fragment,e),h(Ln.$$.fragment,e),h(Rt.$$.fragment,e),h(Ut.$$.fragment,e),h(It.$$.fragment,e),h(Bn.$$.fragment,e),h(Hn.$$.fragment,e),h(Pn.$$.fragment,e),h(Ct.$$.fragment,e),h(Zt.$$.fragment,e),h(En.$$.fragment,e),h(Qn.$$.fragment,e),h(Dn.$$.fragment,e),h(Wt.$$.fragment,e),h(Nt.$$.fragment,e),h(St.$$.fragment,e),h(Yn.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(Ft.$$.fragment,e),h(Ot.$$.fragment,e),h(Gt.$$.fragment,e),h(no.$$.fragment,e),h(oo.$$.fragment,e),h(so.$$.fragment,e),h(Xt.$$.fragment,e),h(Vt.$$.fragment,e),h(zt.$$.fragment,e),h(ao.$$.fragment,e),h(ro.$$.fragment,e),h(io.$$.fragment,e),h(po.$$.fragment,e),h(qt.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(mo.$$.fragment,e),h(co.$$.fragment,e),h(uo.$$.fragment,e),h(Ht.$$.fragment,e),h(Pt.$$.fragment,e),h(go.$$.fragment,e),h(fo.$$.fragment,e),h(ho.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(Dt.$$.fragment,e),h(Yt.$$.fragment,e),h(At.$$.fragment,e),h(To.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(Kt.$$.fragment,e),h(en.$$.fragment,e),h(wo.$$.fragment,e),h($o.$$.fragment,e),h(ko.$$.fragment,e),h(Jo.$$.fragment,e),h(tn.$$.fragment,e),h(nn.$$.fragment,e),h(on.$$.fragment,e),h(jo.$$.fragment,e),h(Ro.$$.fragment,e),h(Uo.$$.fragment,e),h(sn.$$.fragment,e),h(an.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(Wo.$$.fragment,e),h(No.$$.fragment,e),h(ln.$$.fragment,e),h(rn.$$.fragment,e),h(pn.$$.fragment,e),h(So.$$.fragment,e),h(Fo.$$.fragment,e),h(Oo.$$.fragment,e),h(mn.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(Go.$$.fragment,e),h(Xo.$$.fragment,e),h(Vo.$$.fragment,e),h(zo.$$.fragment,e),h(qo.$$.fragment,e),h(Lo.$$.fragment,e),h(Bo.$$.fragment,e),h(Ho.$$.fragment,e),h(Po.$$.fragment,e),h(Eo.$$.fragment,e),h(Qo.$$.fragment,e),h(Do.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(Ko.$$.fragment,e),h(es.$$.fragment,e),h(ts.$$.fragment,e),h(ns.$$.fragment,e),h(os.$$.fragment,e),wr=!0)},o(e){_(y.$$.fragment,e),_(v.$$.fragment,e),_(Tn.$$.fragment,e),_(Mn.$$.fragment,e),_(vn.$$.fragment,e),_(wn.$$.fragment,e),_(xn.$$.fragment,e),_($n.$$.fragment,e),_(kn.$$.fragment,e),_(Jn.$$.fragment,e),_(jn.$$.fragment,e),_(Un.$$.fragment,e),_(In.$$.fragment,e),_(Cn.$$.fragment,e),_(ht.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(Zn.$$.fragment,e),_(Wn.$$.fragment,e),_(Nn.$$.fragment,e),_(yt.$$.fragment,e),_(Tt.$$.fragment,e),_(Mt.$$.fragment,e),_(Sn.$$.fragment,e),_(Fn.$$.fragment,e),_(On.$$.fragment,e),_(vt.$$.fragment,e),_(wt.$$.fragment,e),_(xt.$$.fragment,e),_(Gn.$$.fragment,e),_(Xn.$$.fragment,e),_(Vn.$$.fragment,e),_($t.$$.fragment,e),_(kt.$$.fragment,e),_(Jt.$$.fragment,e),_(jt.$$.fragment,e),_(zn.$$.fragment,e),_(qn.$$.fragment,e),_(Ln.$$.fragment,e),_(Rt.$$.fragment,e),_(Ut.$$.fragment,e),_(It.$$.fragment,e),_(Bn.$$.fragment,e),_(Hn.$$.fragment,e),_(Pn.$$.fragment,e),_(Ct.$$.fragment,e),_(Zt.$$.fragment,e),_(En.$$.fragment,e),_(Qn.$$.fragment,e),_(Dn.$$.fragment,e),_(Wt.$$.fragment,e),_(Nt.$$.fragment,e),_(St.$$.fragment,e),_(Yn.$$.fragment,e),_(Kn.$$.fragment,e),_(eo.$$.fragment,e),_(to.$$.fragment,e),_(Ft.$$.fragment,e),_(Ot.$$.fragment,e),_(Gt.$$.fragment,e),_(no.$$.fragment,e),_(oo.$$.fragment,e),_(so.$$.fragment,e),_(Xt.$$.fragment,e),_(Vt.$$.fragment,e),_(zt.$$.fragment,e),_(ao.$$.fragment,e),_(ro.$$.fragment,e),_(io.$$.fragment,e),_(po.$$.fragment,e),_(qt.$$.fragment,e),_(Lt.$$.fragment,e),_(Bt.$$.fragment,e),_(mo.$$.fragment,e),_(co.$$.fragment,e),_(uo.$$.fragment,e),_(Ht.$$.fragment,e),_(Pt.$$.fragment,e),_(go.$$.fragment,e),_(fo.$$.fragment,e),_(ho.$$.fragment,e),_(Et.$$.fragment,e),_(Qt.$$.fragment,e),_(_o.$$.fragment,e),_(bo.$$.fragment,e),_(yo.$$.fragment,e),_(Dt.$$.fragment,e),_(Yt.$$.fragment,e),_(At.$$.fragment,e),_(To.$$.fragment,e),_(Mo.$$.fragment,e),_(vo.$$.fragment,e),_(Kt.$$.fragment,e),_(en.$$.fragment,e),_(wo.$$.fragment,e),_($o.$$.fragment,e),_(ko.$$.fragment,e),_(Jo.$$.fragment,e),_(tn.$$.fragment,e),_(nn.$$.fragment,e),_(on.$$.fragment,e),_(jo.$$.fragment,e),_(Ro.$$.fragment,e),_(Uo.$$.fragment,e),_(sn.$$.fragment,e),_(an.$$.fragment,e),_(Io.$$.fragment,e),_(Zo.$$.fragment,e),_(Wo.$$.fragment,e),_(No.$$.fragment,e),_(ln.$$.fragment,e),_(rn.$$.fragment,e),_(pn.$$.fragment,e),_(So.$$.fragment,e),_(Fo.$$.fragment,e),_(Oo.$$.fragment,e),_(mn.$$.fragment,e),_(dn.$$.fragment,e),_(cn.$$.fragment,e),_(Go.$$.fragment,e),_(Xo.$$.fragment,e),_(Vo.$$.fragment,e),_(zo.$$.fragment,e),_(qo.$$.fragment,e),_(Lo.$$.fragment,e),_(Bo.$$.fragment,e),_(Ho.$$.fragment,e),_(Po.$$.fragment,e),_(Eo.$$.fragment,e),_(Qo.$$.fragment,e),_(Do.$$.fragment,e),_(Yo.$$.fragment,e),_(Ao.$$.fragment,e),_(Ko.$$.fragment,e),_(es.$$.fragment,e),_(ts.$$.fragment,e),_(ns.$$.fragment,e),_(os.$$.fragment,e),wr=!1},d(e){e&&(i(M),i(r),i(s),i(t),i(gl),i(yn),i(fl),i(hl),i(I),i(_l),i(bl),i(Rn),i(yl),i(Tl),i(N),i(Ml),i(vl),i(S),i(wl),i(xl),i(F),i($l),i(kl),i(O),i(Jl),i(jl),i(G),i(Rl),i(Ul),i(X),i(Il),i(Cl),i(V),i(Zl),i(Wl),i(An),i(Nl),i(Sl),i(z),i(Fl),i(Ol),i(q),i(Gl),i(Xl),i(lo),i(Vl),i(zl),i(L),i(ql),i(Ll),i(B),i(Bl),i(Hl),i(H),i(Pl),i(El),i(P),i(Ql),i(Dl),i(E),i(Yl),i(Al),i(xo),i(Kl),i(er),i(Q),i(tr),i(nr),i(D),i(or),i(sr),i(Co),i(ar),i(lr),i(Y),i(rr),i(ir),i(A),i(pr),i(mr),i(dr),i(K),i(cr),i(ur),i(ee),i(gr),i(fr),i(te),i(hr),i(_r),i(ne),i(br),i(yr),i(oe),i(Tr),i(Mr),i(se),i(vr),i(ul)),i(n),b(y,e),b(v,e),b(Tn,e),b(Mn),b(vn),b(wn),b(xn),b($n),b(kn),b(Jn),b(jn,e),b(Un,e),b(In),b(Cn),b(ht),b(_t),b(bt),b(Zn,e),b(Wn),b(Nn),b(yt),b(Tt),b(Mt),b(Sn,e),b(Fn),b(On),b(vt),b(wt),b(xt),b(Gn,e),b(Xn),b(Vn),b($t),b(kt),b(Jt),b(jt),b(zn,e),b(qn),b(Ln),b(Rt),b(Ut),b(It),b(Bn,e),b(Hn),b(Pn),b(Ct),b(Zt),b(En,e),b(Qn),b(Dn),b(Wt),b(Nt),b(St),b(Yn,e),b(Kn,e),b(eo),b(to),b(Ft),b(Ot),b(Gt),b(no,e),b(oo),b(so),b(Xt),b(Vt),b(zt),b(ao,e),b(ro,e),b(io),b(po),b(qt),b(Lt),b(Bt),b(mo,e),b(co),b(uo),b(Ht),b(Pt),b(go,e),b(fo),b(ho),b(Et),b(Qt),b(_o,e),b(bo),b(yo),b(Dt),b(Yt),b(At),b(To,e),b(Mo),b(vo),b(Kt),b(en),b(wo,e),b($o,e),b(ko),b(Jo),b(tn),b(nn),b(on),b(jo,e),b(Ro),b(Uo),b(sn),b(an),b(Io,e),b(Zo,e),b(Wo),b(No),b(ln),b(rn),b(pn),b(So,e),b(Fo),b(Oo),b(mn),b(dn),b(cn),b(Go,e),b(Xo,e),b(Vo),b(zo),b(qo,e),b(Lo),b(Bo),b(Ho,e),b(Po),b(Eo),b(Qo,e),b(Do),b(Yo),b(Ao,e),b(Ko),b(es),b(ts,e),b(ns),b(os)}}}const rg='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function ig(w){return lu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hg extends ru{constructor(n){super(),iu(this,n,ig,lg,au,{})}}export{hg as component};
